// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Textract
///
/// Client for invoking operations on Amazon Textract. Each operation on Amazon Textract is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_textract::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_textract::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_textract::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AnalyzeDocument` operation.
    ///
    /// See [`AnalyzeDocument`](crate::client::fluent_builders::AnalyzeDocument) for more information about the
    /// operation and its arguments.
    pub fn analyze_document(&self) -> fluent_builders::AnalyzeDocument<C, M, R> {
        fluent_builders::AnalyzeDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AnalyzeExpense` operation.
    ///
    /// See [`AnalyzeExpense`](crate::client::fluent_builders::AnalyzeExpense) for more information about the
    /// operation and its arguments.
    pub fn analyze_expense(&self) -> fluent_builders::AnalyzeExpense<C, M, R> {
        fluent_builders::AnalyzeExpense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectDocumentText` operation.
    ///
    /// See [`DetectDocumentText`](crate::client::fluent_builders::DetectDocumentText) for more information about the
    /// operation and its arguments.
    pub fn detect_document_text(&self) -> fluent_builders::DetectDocumentText<C, M, R> {
        fluent_builders::DetectDocumentText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDocumentAnalysis` operation.
    ///
    /// See [`GetDocumentAnalysis`](crate::client::fluent_builders::GetDocumentAnalysis) for more information about the
    /// operation and its arguments.
    pub fn get_document_analysis(&self) -> fluent_builders::GetDocumentAnalysis<C, M, R> {
        fluent_builders::GetDocumentAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDocumentTextDetection` operation.
    ///
    /// See [`GetDocumentTextDetection`](crate::client::fluent_builders::GetDocumentTextDetection) for more information about the
    /// operation and its arguments.
    pub fn get_document_text_detection(
        &self,
    ) -> fluent_builders::GetDocumentTextDetection<C, M, R> {
        fluent_builders::GetDocumentTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExpenseAnalysis` operation.
    ///
    /// See [`GetExpenseAnalysis`](crate::client::fluent_builders::GetExpenseAnalysis) for more information about the
    /// operation and its arguments.
    pub fn get_expense_analysis(&self) -> fluent_builders::GetExpenseAnalysis<C, M, R> {
        fluent_builders::GetExpenseAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDocumentAnalysis` operation.
    ///
    /// See [`StartDocumentAnalysis`](crate::client::fluent_builders::StartDocumentAnalysis) for more information about the
    /// operation and its arguments.
    pub fn start_document_analysis(&self) -> fluent_builders::StartDocumentAnalysis<C, M, R> {
        fluent_builders::StartDocumentAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDocumentTextDetection` operation.
    ///
    /// See [`StartDocumentTextDetection`](crate::client::fluent_builders::StartDocumentTextDetection) for more information about the
    /// operation and its arguments.
    pub fn start_document_text_detection(
        &self,
    ) -> fluent_builders::StartDocumentTextDetection<C, M, R> {
        fluent_builders::StartDocumentTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartExpenseAnalysis` operation.
    ///
    /// See [`StartExpenseAnalysis`](crate::client::fluent_builders::StartExpenseAnalysis) for more information about the
    /// operation and its arguments.
    pub fn start_expense_analysis(&self) -> fluent_builders::StartExpenseAnalysis<C, M, R> {
        fluent_builders::StartExpenseAnalysis::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AnalyzeDocument`.
    ///
    /// <p>Analyzes an input document for relationships between detected items.  </p>
    /// <p>The types of information returned are as follows: </p>
    /// <ul>
    /// <li>
    /// <p>Form data (key-value pairs). The related information is returned in two <a>Block</a> objects, each of type <code>KEY_VALUE_SET</code>: a KEY
    /// <code>Block</code> object and a VALUE <code>Block</code> object. For example,
    /// <i>Name: Ana Silva Carolina</i> contains a key and value.
    /// <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is
    /// the value.</p>
    /// </li>
    /// <li>
    /// <p>Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL
    /// <code>Block</code> object is returned for each cell in a table.</p>
    /// </li>
    /// <li>
    /// <p>Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects.
    /// All lines and words that are detected in the document are returned (including text that doesn't have a
    /// relationship with the value of <code>FeatureTypes</code>). </p>
    /// </li>
    /// </ul>
    ///
    /// <p>Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables.
    /// A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element,
    /// including the selection status.</p>
    /// <p>You can choose which type of analysis to perform by specifying the <code>FeatureTypes</code> list.
    /// </p>
    /// <p>The output is returned in a list of <code>Block</code> objects.</p>
    /// <p>
    /// <code>AnalyzeDocument</code> is a synchronous operation. To analyze documents
    /// asynchronously, use <a>StartDocumentAnalysis</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AnalyzeDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::analyze_document_input::Builder,
    }
    impl<C, M, R> AnalyzeDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AnalyzeDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AnalyzeDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::AnalyzeDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AnalyzeDocumentInputOperationOutputAlias,
                crate::output::AnalyzeDocumentOutput,
                crate::error::AnalyzeDocumentError,
                crate::input::AnalyzeDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn document(mut self, inp: crate::model::Document) -> Self {
            self.inner = self.inner.document(inp);
            self
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// Appends an item to `FeatureTypes`.
        ///
        /// To override the contents of this collection use [`set_feature_types`](Self::set_feature_types).
        ///
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected form data.
        /// To perform both types of analysis, add TABLES and FORMS to
        /// <code>FeatureTypes</code>. All lines and words detected in the document are included in
        /// the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn feature_types(mut self, inp: impl Into<crate::model::FeatureType>) -> Self {
            self.inner = self.inner.feature_types(inp);
            self
        }
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected form data.
        /// To perform both types of analysis, add TABLES and FORMS to
        /// <code>FeatureTypes</code>. All lines and words detected in the document are included in
        /// the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn set_feature_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        ) -> Self {
            self.inner = self.inner.set_feature_types(input);
            self
        }
        /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
        pub fn human_loop_config(mut self, inp: crate::model::HumanLoopConfig) -> Self {
            self.inner = self.inner.human_loop_config(inp);
            self
        }
        /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.inner = self.inner.set_human_loop_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AnalyzeExpense`.
    ///
    /// <p>Analyzes an input document for financially related relationships between text.</p>
    /// <p>Information is returned as <code>ExpenseDocuments</code> and seperated as follows.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LineItemGroups</code>- A data set containing <code>LineItems</code> which
    /// store information about the lines of text, such as an item purchased and its price on a receipt.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SummaryFields</code>- Contains all other information a receipt, such as header information
    /// or the vendors name.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct AnalyzeExpense<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::analyze_expense_input::Builder,
    }
    impl<C, M, R> AnalyzeExpense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AnalyzeExpense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AnalyzeExpenseOutput,
            aws_smithy_http::result::SdkError<crate::error::AnalyzeExpenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AnalyzeExpenseInputOperationOutputAlias,
                crate::output::AnalyzeExpenseOutput,
                crate::error::AnalyzeExpenseError,
                crate::input::AnalyzeExpenseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input document, either as bytes or as an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code>
        /// property. For example, you would use the <code>Bytes</code> property to pass a document
        /// loaded from a local file system. Image bytes passed by using the <code>Bytes</code>
        /// property must be base64 encoded. Your code might not need to encode document file bytes if
        /// you're using an AWS SDK to call Amazon Textract API operations. </p>
        /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the
        /// <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64
        /// encoded.</p>
        /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS
        /// Region that you use for Amazon Textract operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using
        /// the Bytes property isn't supported. You must first upload the document to an Amazon S3
        /// bucket, and then call the operation using the S3Object property.</p>
        ///
        /// <p>For Amazon Textract to process an S3 object, the user must have permission
        /// to access the S3 object. </p>
        pub fn document(mut self, inp: crate::model::Document) -> Self {
            self.inner = self.inner.document(inp);
            self
        }
        /// <p>The input document, either as bytes or as an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code>
        /// property. For example, you would use the <code>Bytes</code> property to pass a document
        /// loaded from a local file system. Image bytes passed by using the <code>Bytes</code>
        /// property must be base64 encoded. Your code might not need to encode document file bytes if
        /// you're using an AWS SDK to call Amazon Textract API operations. </p>
        /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the
        /// <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64
        /// encoded.</p>
        /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS
        /// Region that you use for Amazon Textract operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using
        /// the Bytes property isn't supported. You must first upload the document to an Amazon S3
        /// bucket, and then call the operation using the S3Object property.</p>
        ///
        /// <p>For Amazon Textract to process an S3 object, the user must have permission
        /// to access the S3 object. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectDocumentText`.
    ///
    /// <p>Detects text in the input document. Amazon Textract can detect lines of text and the
    /// words that make up a line of text. The input document must be an image in JPEG or PNG
    /// format. <code>DetectDocumentText</code> returns the detected text in an array of <a>Block</a> objects. </p>
    /// <p>Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object
    /// is the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE <code>Block</code> object is
    /// a parent for each word that makes up the line. Words are represented by <code>Block</code> objects of type WORD.</p>
    ///
    /// <p>
    /// <code>DetectDocumentText</code> is a synchronous operation. To analyze documents
    /// asynchronously, use <a>StartDocumentTextDetection</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectDocumentText<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_document_text_input::Builder,
    }
    impl<C, M, R> DetectDocumentText<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectDocumentText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectDocumentTextOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectDocumentTextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectDocumentTextInputOperationOutputAlias,
                crate::output::DetectDocumentTextOutput,
                crate::error::DetectDocumentTextError,
                crate::input::DetectDocumentTextInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn document(mut self, inp: crate::model::Document) -> Self {
            self.inner = self.inner.document(inp);
            self
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentAnalysis`.
    ///
    /// <p>Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.</p>
    /// <p>You start asynchronous text analysis by calling <a>StartDocumentAnalysis</a>, which returns a job identifier
    /// (<code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a
    /// completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
    /// <code>StartDocumentAnalysis</code>. To get the results of the text-detection operation,
    /// first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>.
    /// If so, call <code>GetDocumentAnalysis</code>, and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartDocumentAnalysis</code>.</p>
    /// <p>
    /// <code>GetDocumentAnalysis</code> returns an array of <a>Block</a> objects. The following
    /// types of information are returned: </p>
    /// <ul>
    /// <li>
    /// <p>Form data (key-value pairs). The related information is returned in two <a>Block</a> objects, each of type <code>KEY_VALUE_SET</code>: a KEY
    /// <code>Block</code> object and a VALUE <code>Block</code> object. For example,
    /// <i>Name: Ana Silva Carolina</i> contains a key and value.
    /// <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is
    /// the value.</p>
    /// </li>
    /// <li>
    /// <p>Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL
    /// <code>Block</code> object is returned for each cell in a table.</p>
    /// </li>
    /// <li>
    /// <p>Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects.
    /// All lines and words that are detected in the document are returned (including text that doesn't have a
    /// relationship with the value of the <code>StartDocumentAnalysis</code>
    /// <code>FeatureTypes</code> input parameter). </p>
    /// </li>
    /// </ul>
    ///
    /// <p>Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables.
    /// A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element,
    /// including the selection status.</p>
    ///
    ///
    ///
    /// <p>Use the <code>MaxResults</code> parameter to limit the number of blocks that are
    /// returned. If there are more results than specified in <code>MaxResults</code>, the value of
    /// <code>NextToken</code> in the operation response contains a pagination token for getting
    /// the next set of results. To get the next page of results, call
    /// <code>GetDocumentAnalysis</code>, and populate the <code>NextToken</code> request
    /// parameter with the token value that's returned from the previous call to
    /// <code>GetDocumentAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDocumentAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_document_analysis_input::Builder,
    }
    impl<C, M, R> GetDocumentAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentAnalysisInputOperationOutputAlias,
                crate::output::GetDocumentAnalysisOutput,
                crate::error::GetDocumentAnalysisError,
                crate::input::GetDocumentAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value that you
        /// can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results
        /// is returned. The default value is 1,000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value that you
        /// can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results
        /// is returned. The default value is 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentTextDetection`.
    ///
    /// <p>Gets the results for an Amazon Textract asynchronous operation that detects text in a document.
    /// Amazon Textract can detect lines of text and the words that make up a line of text.</p>
    /// <p>You start asynchronous text detection by calling <a>StartDocumentTextDetection</a>, which returns a job identifier
    /// (<code>JobId</code>). When the text detection operation finishes, Amazon Textract publishes a
    /// completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
    /// <code>StartDocumentTextDetection</code>. To get the results of the text-detection
    /// operation, first check that the status value published to the Amazon SNS topic is
    /// <code>SUCCEEDED</code>. If so, call <code>GetDocumentTextDetection</code>, and pass the
    /// job identifier (<code>JobId</code>) from the initial call to
    /// <code>StartDocumentTextDetection</code>.</p>
    /// <p>
    /// <code>GetDocumentTextDetection</code> returns an array of <a>Block</a>
    /// objects. </p>
    /// <p>Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object
    /// is the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE <code>Block</code> object is
    /// a parent for each word that makes up the line. Words are represented by <code>Block</code> objects of type WORD.</p>
    ///
    /// <p>Use the MaxResults parameter to limit the number of blocks that are returned. If there
    /// are more results than specified in <code>MaxResults</code>, the value of
    /// <code>NextToken</code> in the operation response contains a pagination token for getting
    /// the next set of results. To get the next page of results, call
    /// <code>GetDocumentTextDetection</code>, and populate the <code>NextToken</code> request
    /// parameter with the token value that's returned from the previous call to
    /// <code>GetDocumentTextDetection</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDocumentTextDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_document_text_detection_input::Builder,
    }
    impl<C, M, R> GetDocumentTextDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentTextDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentTextDetectionInputOperationOutputAlias,
                crate::output::GetDocumentTextDetectionOutput,
                crate::error::GetDocumentTextDetectionError,
                crate::input::GetDocumentTextDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is
        /// returned. The default value is 1,000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is
        /// returned. The default value is 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExpenseAnalysis`.
    ///
    /// <p>Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and
    /// receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input
    /// invoices and receipts.</p>
    /// <p>You start asynchronous invoice/receipt analysis by calling <a>StartExpenseAnalysis</a>, which returns a job identifier (<code>JobId</code>). Upon
    /// completion of the invoice/receipt analysis, Amazon Textract publishes the completion status to the
    /// Amazon Simple Notification Service (Amazon SNS) topic. This topic must be registered in the initial call to
    /// <code>StartExpenseAnalysis</code>. To get the results of the invoice/receipt analysis operation,
    /// first ensure that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so,
    /// call <code>GetExpenseAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the
    /// initial call to <code>StartExpenseAnalysis</code>.</p>
    /// <p>Use the MaxResults parameter to limit the number of blocks that are returned. If there are
    /// more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in
    /// the operation response contains a pagination token for getting the next set of results. To get
    /// the next page of results, call <code>GetExpenseAnalysis</code>, and populate the
    /// <code>NextToken</code> request parameter with the token value that's returned from the previous
    /// call to <code>GetExpenseAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html">Analyzing Invoices and Receipts</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetExpenseAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_expense_analysis_input::Builder,
    }
    impl<C, M, R> GetExpenseAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExpenseAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExpenseAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExpenseAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExpenseAnalysisInputOperationOutputAlias,
                crate::output::GetExpenseAnalysisOutput,
                crate::error::GetExpenseAnalysisError,
                crate::input::GetExpenseAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 20. If you specify a value greater than 20, a maximum of 20 results is
        /// returned. The default value is 20.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 20. If you specify a value greater than 20, a maximum of 20 results is
        /// returned. The default value is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDocumentAnalysis`.
    ///
    /// <p>Starts the asynchronous analysis of an input document for relationships between detected
    /// items such as key-value pairs, tables, and selection elements.</p>
    ///
    /// <p>
    /// <code>StartDocumentAnalysis</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The
    /// documents are stored in an Amazon S3 bucket. Use <a>DocumentLocation</a> to specify the bucket name and file name
    /// of the document.
    /// </p>
    /// <p>
    /// <code>StartDocumentAnalysis</code> returns a job identifier
    /// (<code>JobId</code>) that you use to get the results of the operation. When text
    /// analysis is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS)
    /// topic that you specify in <code>NotificationChannel</code>. To get the results of the text
    /// analysis operation, first check that the status value published to the Amazon SNS topic is
    /// <code>SUCCEEDED</code>. If so, call <a>GetDocumentAnalysis</a>, and pass
    /// the job identifier (<code>JobId</code>) from the initial call to
    /// <code>StartDocumentAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDocumentAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_document_analysis_input::Builder,
    }
    impl<C, M, R> StartDocumentAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDocumentAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDocumentAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDocumentAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDocumentAnalysisInputOperationOutputAlias,
                crate::output::StartDocumentAnalysisOutput,
                crate::error::StartDocumentAnalysisError,
                crate::input::StartDocumentAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, inp: crate::model::DocumentLocation) -> Self {
            self.inner = self.inner.document_location(inp);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.inner = self.inner.set_document_location(input);
            self
        }
        /// Appends an item to `FeatureTypes`.
        ///
        /// To override the contents of this collection use [`set_feature_types`](Self::set_feature_types).
        ///
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected
        /// form data. To perform both types of analysis, add TABLES
        /// and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
        /// included in the response (including text that isn't related to the value of
        /// <code>FeatureTypes</code>). </p>
        pub fn feature_types(mut self, inp: impl Into<crate::model::FeatureType>) -> Self {
            self.inner = self.inner.feature_types(inp);
            self
        }
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected
        /// form data. To perform both types of analysis, add TABLES
        /// and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
        /// included in the response (including text that isn't related to the value of
        /// <code>FeatureTypes</code>). </p>
        pub fn set_feature_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        ) -> Self {
            self.inner = self.inner.set_feature_types(input);
            self
        }
        /// <p>The idempotent token that you use to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentAnalysis</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The idempotent token that you use to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentAnalysis</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save
        /// the results internally to be accessed by the GetDocumentAnalysis operation.</p>
        pub fn output_config(mut self, inp: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(inp);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save
        /// the results internally to be accessed by the GetDocumentAnalysis operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDocumentTextDetection`.
    ///
    /// <p>Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of
    /// text and the words that make up a line of text.</p>
    /// <p>
    /// <code>StartDocumentTextDetection</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The
    /// documents are stored in an Amazon S3 bucket. Use <a>DocumentLocation</a> to specify the bucket name and file name
    /// of the document.
    /// </p>
    /// <p>
    /// <code>StartTextDetection</code> returns a job identifier
    /// (<code>JobId</code>) that you use to get the results of the operation. When text
    /// detection is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS)
    /// topic that you specify in <code>NotificationChannel</code>. To get the results of the text
    /// detection operation, first check that the status value published to the Amazon SNS topic is
    /// <code>SUCCEEDED</code>. If so, call <a>GetDocumentTextDetection</a>, and
    /// pass the job identifier (<code>JobId</code>) from the initial call to
    /// <code>StartDocumentTextDetection</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDocumentTextDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_document_text_detection_input::Builder,
    }
    impl<C, M, R> StartDocumentTextDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDocumentTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDocumentTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDocumentTextDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDocumentTextDetectionInputOperationOutputAlias,
                crate::output::StartDocumentTextDetectionOutput,
                crate::error::StartDocumentTextDetectionError,
                crate::input::StartDocumentTextDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, inp: crate::model::DocumentLocation) -> Self {
            self.inner = self.inner.document_location(inp);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.inner = self.inner.set_document_location(input);
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentTextDetection</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentTextDetection</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will
        /// save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
        pub fn output_config(mut self, inp: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(inp);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will
        /// save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExpenseAnalysis`.
    ///
    /// <p>Starts the asynchronous analysis of invoices or receipts for data like contact information,
    /// items purchased, and vendor names.</p>
    ///
    /// <p>
    /// <code>StartExpenseAnalysis</code> can analyze text in documents that are in JPEG, PNG, and
    /// PDF format. The documents must be stored in an Amazon S3 bucket. Use the <a>DocumentLocation</a> parameter to specify the name of your S3 bucket and the name of the
    /// document in that bucket. </p>
    /// <p>
    /// <code>StartExpenseAnalysis</code> returns a job identifier (<code>JobId</code>) that you
    /// will provide to <code>GetExpenseAnalysis</code> to retrieve the results of the operation. When
    /// the analysis of the input invoices/receipts is finished, Amazon Textract publishes a completion
    /// status to the Amazon Simple Notification Service (Amazon SNS) topic that you provide to the <code>NotificationChannel</code>.
    /// To obtain the results of the invoice and receipt analysis operation, ensure that the status value
    /// published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetExpenseAnalysis</a>, and pass the job identifier (<code>JobId</code>) that was
    /// returned by your call to <code>StartExpenseAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html">Analyzing Invoices and Receipts</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartExpenseAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_expense_analysis_input::Builder,
    }
    impl<C, M, R> StartExpenseAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartExpenseAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExpenseAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExpenseAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartExpenseAnalysisInputOperationOutputAlias,
                crate::output::StartExpenseAnalysisOutput,
                crate::error::StartExpenseAnalysisError,
                crate::input::StartExpenseAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, inp: crate::model::DocumentLocation) -> Self {
            self.inner = self.inner.document_location(inp);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.inner = self.inner.set_document_location(input);
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned.
        /// Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
        /// For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned.
        /// Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
        /// For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>An identifier you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will
        /// save the results internally to be accessed by the <code>GetExpenseAnalysis</code>
        /// operation.</p>
        pub fn output_config(mut self, inp: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(inp);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will
        /// save the results internally to be accessed by the <code>GetExpenseAnalysis</code>
        /// operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
