// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AnalyzeDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AnalyzeDocumentError {
    /// Kind of error that occurred.
    pub kind: AnalyzeDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AnalyzeDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AnalyzeDocumentErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
    BadDocumentException(crate::error::BadDocumentException),
    /// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
    DocumentTooLargeException(crate::error::DocumentTooLargeException),
    /// <p>Indicates you have exceeded the maximum number of active human in the loop workflows available</p>
    HumanLoopQuotaExceededException(crate::error::HumanLoopQuotaExceededException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
    UnsupportedDocumentException(crate::error::UnsupportedDocumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AnalyzeDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AnalyzeDocumentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::BadDocumentException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::DocumentTooLargeException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::HumanLoopQuotaExceededException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            AnalyzeDocumentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::UnsupportedDocumentException(_inner) => _inner.fmt(f),
            AnalyzeDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AnalyzeDocumentError {
    fn code(&self) -> Option<&str> {
        AnalyzeDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AnalyzeDocumentError {
    /// Creates a new `AnalyzeDocumentError`.
    pub fn new(kind: AnalyzeDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AnalyzeDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AnalyzeDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AnalyzeDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AnalyzeDocumentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::BadDocumentException`.
    pub fn is_bad_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::BadDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::DocumentTooLargeException`.
    pub fn is_document_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::DocumentTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::HumanLoopQuotaExceededException`.
    pub fn is_human_loop_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::HumanLoopQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AnalyzeDocumentErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeDocumentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeDocumentErrorKind::UnsupportedDocumentException`.
    pub fn is_unsupported_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeDocumentErrorKind::UnsupportedDocumentException(_)
        )
    }
}
impl std::error::Error for AnalyzeDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AnalyzeDocumentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::BadDocumentException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::DocumentTooLargeException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::HumanLoopQuotaExceededException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::InternalServerError(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            AnalyzeDocumentErrorKind::ThrottlingException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::UnsupportedDocumentException(_inner) => Some(_inner),
            AnalyzeDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AnalyzeExpense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AnalyzeExpenseError {
    /// Kind of error that occurred.
    pub kind: AnalyzeExpenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AnalyzeExpense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AnalyzeExpenseErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
    BadDocumentException(crate::error::BadDocumentException),
    /// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
    DocumentTooLargeException(crate::error::DocumentTooLargeException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
    UnsupportedDocumentException(crate::error::UnsupportedDocumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AnalyzeExpenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AnalyzeExpenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::BadDocumentException(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::DocumentTooLargeException(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            AnalyzeExpenseErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::UnsupportedDocumentException(_inner) => _inner.fmt(f),
            AnalyzeExpenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AnalyzeExpenseError {
    fn code(&self) -> Option<&str> {
        AnalyzeExpenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AnalyzeExpenseError {
    /// Creates a new `AnalyzeExpenseError`.
    pub fn new(kind: AnalyzeExpenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AnalyzeExpenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AnalyzeExpenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AnalyzeExpenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AnalyzeExpenseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeExpenseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::BadDocumentException`.
    pub fn is_bad_document_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeExpenseErrorKind::BadDocumentException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::DocumentTooLargeException`.
    pub fn is_document_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeExpenseErrorKind::DocumentTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AnalyzeExpenseErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeExpenseErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeExpenseErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeExpenseErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeExpenseErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeExpenseErrorKind::UnsupportedDocumentException`.
    pub fn is_unsupported_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeExpenseErrorKind::UnsupportedDocumentException(_)
        )
    }
}
impl std::error::Error for AnalyzeExpenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AnalyzeExpenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::BadDocumentException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::DocumentTooLargeException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::InternalServerError(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::ThrottlingException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::UnsupportedDocumentException(_inner) => Some(_inner),
            AnalyzeExpenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AnalyzeID` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AnalyzeIDError {
    /// Kind of error that occurred.
    pub kind: AnalyzeIDErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AnalyzeID` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AnalyzeIDErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
    BadDocumentException(crate::error::BadDocumentException),
    /// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
    DocumentTooLargeException(crate::error::DocumentTooLargeException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
    UnsupportedDocumentException(crate::error::UnsupportedDocumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AnalyzeIDError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AnalyzeIDErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::BadDocumentException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::DocumentTooLargeException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::UnsupportedDocumentException(_inner) => _inner.fmt(f),
            AnalyzeIDErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AnalyzeIDError {
    fn code(&self) -> Option<&str> {
        AnalyzeIDError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AnalyzeIDError {
    /// Creates a new `AnalyzeIDError`.
    pub fn new(kind: AnalyzeIDErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AnalyzeIDError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AnalyzeIDErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AnalyzeIDError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AnalyzeIDErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeIDErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::BadDocumentException`.
    pub fn is_bad_document_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeIDErrorKind::BadDocumentException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::DocumentTooLargeException`.
    pub fn is_document_too_large_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeIDErrorKind::DocumentTooLargeException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AnalyzeIDErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeIDErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeIDErrorKind::InvalidS3ObjectException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeIDErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AnalyzeIDErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `AnalyzeIDErrorKind::UnsupportedDocumentException`.
    pub fn is_unsupported_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            AnalyzeIDErrorKind::UnsupportedDocumentException(_)
        )
    }
}
impl std::error::Error for AnalyzeIDError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AnalyzeIDErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::BadDocumentException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::DocumentTooLargeException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::InternalServerError(_inner) => Some(_inner),
            AnalyzeIDErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::ThrottlingException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::UnsupportedDocumentException(_inner) => Some(_inner),
            AnalyzeIDErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectDocumentText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectDocumentTextError {
    /// Kind of error that occurred.
    pub kind: DetectDocumentTextErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectDocumentText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectDocumentTextErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
    BadDocumentException(crate::error::BadDocumentException),
    /// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
    DocumentTooLargeException(crate::error::DocumentTooLargeException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
    UnsupportedDocumentException(crate::error::UnsupportedDocumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectDocumentTextError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectDocumentTextErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::BadDocumentException(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::DocumentTooLargeException(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            DetectDocumentTextErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::UnsupportedDocumentException(_inner) => _inner.fmt(f),
            DetectDocumentTextErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectDocumentTextError {
    fn code(&self) -> Option<&str> {
        DetectDocumentTextError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectDocumentTextError {
    /// Creates a new `DetectDocumentTextError`.
    pub fn new(kind: DetectDocumentTextErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectDocumentTextError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectDocumentTextErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectDocumentTextError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectDocumentTextErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::BadDocumentException`.
    pub fn is_bad_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::BadDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::DocumentTooLargeException`.
    pub fn is_document_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::DocumentTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDocumentTextErrorKind::UnsupportedDocumentException`.
    pub fn is_unsupported_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDocumentTextErrorKind::UnsupportedDocumentException(_)
        )
    }
}
impl std::error::Error for DetectDocumentTextError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectDocumentTextErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::BadDocumentException(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::DocumentTooLargeException(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::InternalServerError(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            DetectDocumentTextErrorKind::ThrottlingException(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::UnsupportedDocumentException(_inner) => Some(_inner),
            DetectDocumentTextErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDocumentAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDocumentAnalysisError {
    /// Kind of error that occurred.
    pub kind: GetDocumentAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDocumentAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDocumentAnalysisErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An invalid job identifier was passed to <code>GetDocumentAnalysis</code> or to <code>GetDocumentAnalysis</code>.</p>
    InvalidJobIdException(crate::error::InvalidJobIdException),
    /// <p> Indicates you do not have decrypt permissions with the KMS key entered, or the KMS key was entered incorrectly. </p>
    InvalidKmsKeyException(crate::error::InvalidKmsKeyException),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDocumentAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDocumentAnalysisErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDocumentAnalysisErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetDocumentAnalysisErrorKind::InvalidJobIdException(_inner) => _inner.fmt(f),
            GetDocumentAnalysisErrorKind::InvalidKmsKeyException(_inner) => _inner.fmt(f),
            GetDocumentAnalysisErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetDocumentAnalysisErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            GetDocumentAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetDocumentAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDocumentAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDocumentAnalysisError {
    fn code(&self) -> Option<&str> {
        GetDocumentAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDocumentAnalysisError {
    /// Creates a new `GetDocumentAnalysisError`.
    pub fn new(kind: GetDocumentAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDocumentAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDocumentAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDocumentAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDocumentAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::InvalidJobIdException`.
    pub fn is_invalid_job_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::InvalidJobIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::InvalidKmsKeyException`.
    pub fn is_invalid_kms_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::InvalidKmsKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentAnalysisErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetDocumentAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDocumentAnalysisErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDocumentAnalysisErrorKind::InternalServerError(_inner) => Some(_inner),
            GetDocumentAnalysisErrorKind::InvalidJobIdException(_inner) => Some(_inner),
            GetDocumentAnalysisErrorKind::InvalidKmsKeyException(_inner) => Some(_inner),
            GetDocumentAnalysisErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetDocumentAnalysisErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            GetDocumentAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            GetDocumentAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDocumentAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDocumentTextDetection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDocumentTextDetectionError {
    /// Kind of error that occurred.
    pub kind: GetDocumentTextDetectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDocumentTextDetection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDocumentTextDetectionErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An invalid job identifier was passed to <code>GetDocumentAnalysis</code> or to <code>GetDocumentAnalysis</code>.</p>
    InvalidJobIdException(crate::error::InvalidJobIdException),
    /// <p> Indicates you do not have decrypt permissions with the KMS key entered, or the KMS key was entered incorrectly. </p>
    InvalidKmsKeyException(crate::error::InvalidKmsKeyException),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDocumentTextDetectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDocumentTextDetectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDocumentTextDetectionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetDocumentTextDetectionErrorKind::InvalidJobIdException(_inner) => _inner.fmt(f),
            GetDocumentTextDetectionErrorKind::InvalidKmsKeyException(_inner) => _inner.fmt(f),
            GetDocumentTextDetectionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetDocumentTextDetectionErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            GetDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetDocumentTextDetectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDocumentTextDetectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDocumentTextDetectionError {
    fn code(&self) -> Option<&str> {
        GetDocumentTextDetectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDocumentTextDetectionError {
    /// Creates a new `GetDocumentTextDetectionError`.
    pub fn new(kind: GetDocumentTextDetectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDocumentTextDetectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDocumentTextDetectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDocumentTextDetectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDocumentTextDetectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::InvalidJobIdException`.
    pub fn is_invalid_job_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::InvalidJobIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::InvalidKmsKeyException`.
    pub fn is_invalid_kms_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::InvalidKmsKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDocumentTextDetectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentTextDetectionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetDocumentTextDetectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDocumentTextDetectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDocumentTextDetectionErrorKind::InternalServerError(_inner) => Some(_inner),
            GetDocumentTextDetectionErrorKind::InvalidJobIdException(_inner) => Some(_inner),
            GetDocumentTextDetectionErrorKind::InvalidKmsKeyException(_inner) => Some(_inner),
            GetDocumentTextDetectionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetDocumentTextDetectionErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            GetDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            GetDocumentTextDetectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDocumentTextDetectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExpenseAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExpenseAnalysisError {
    /// Kind of error that occurred.
    pub kind: GetExpenseAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExpenseAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExpenseAnalysisErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An invalid job identifier was passed to <code>GetDocumentAnalysis</code> or to <code>GetDocumentAnalysis</code>.</p>
    InvalidJobIdException(crate::error::InvalidJobIdException),
    /// <p> Indicates you do not have decrypt permissions with the KMS key entered, or the KMS key was entered incorrectly. </p>
    InvalidKmsKeyException(crate::error::InvalidKmsKeyException),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExpenseAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExpenseAnalysisErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExpenseAnalysisErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetExpenseAnalysisErrorKind::InvalidJobIdException(_inner) => _inner.fmt(f),
            GetExpenseAnalysisErrorKind::InvalidKmsKeyException(_inner) => _inner.fmt(f),
            GetExpenseAnalysisErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetExpenseAnalysisErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            GetExpenseAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetExpenseAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetExpenseAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExpenseAnalysisError {
    fn code(&self) -> Option<&str> {
        GetExpenseAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExpenseAnalysisError {
    /// Creates a new `GetExpenseAnalysisError`.
    pub fn new(kind: GetExpenseAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExpenseAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExpenseAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExpenseAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExpenseAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::InvalidJobIdException`.
    pub fn is_invalid_job_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::InvalidJobIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::InvalidKmsKeyException`.
    pub fn is_invalid_kms_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::InvalidKmsKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExpenseAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExpenseAnalysisErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetExpenseAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExpenseAnalysisErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExpenseAnalysisErrorKind::InternalServerError(_inner) => Some(_inner),
            GetExpenseAnalysisErrorKind::InvalidJobIdException(_inner) => Some(_inner),
            GetExpenseAnalysisErrorKind::InvalidKmsKeyException(_inner) => Some(_inner),
            GetExpenseAnalysisErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetExpenseAnalysisErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            GetExpenseAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            GetExpenseAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetExpenseAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDocumentAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDocumentAnalysisError {
    /// Kind of error that occurred.
    pub kind: StartDocumentAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDocumentAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDocumentAnalysisErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
    BadDocumentException(crate::error::BadDocumentException),
    /// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
    DocumentTooLargeException(crate::error::DocumentTooLargeException),
    /// <p>A <code>ClientRequestToken</code> input parameter was reused with an operation, but at least one of the other input parameters is different from the previous call to the operation. </p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p> Indicates you do not have decrypt permissions with the KMS key entered, or the KMS key was entered incorrectly. </p>
    InvalidKmsKeyException(crate::error::InvalidKmsKeyException),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>An Amazon Textract service limit was exceeded. For example, if you start too many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>, for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Textract service limit. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
    UnsupportedDocumentException(crate::error::UnsupportedDocumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDocumentAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDocumentAnalysisErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::BadDocumentException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::DocumentTooLargeException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentAnalysisErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::InvalidKmsKeyException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::UnsupportedDocumentException(_inner) => _inner.fmt(f),
            StartDocumentAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDocumentAnalysisError {
    fn code(&self) -> Option<&str> {
        StartDocumentAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDocumentAnalysisError {
    /// Creates a new `StartDocumentAnalysisError`.
    pub fn new(kind: StartDocumentAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDocumentAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDocumentAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDocumentAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDocumentAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::BadDocumentException`.
    pub fn is_bad_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::BadDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::DocumentTooLargeException`.
    pub fn is_document_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::DocumentTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::InvalidKmsKeyException`.
    pub fn is_invalid_kms_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::InvalidKmsKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentAnalysisErrorKind::UnsupportedDocumentException`.
    pub fn is_unsupported_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentAnalysisErrorKind::UnsupportedDocumentException(_)
        )
    }
}
impl std::error::Error for StartDocumentAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDocumentAnalysisErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::BadDocumentException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::DocumentTooLargeException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            StartDocumentAnalysisErrorKind::InternalServerError(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::InvalidKmsKeyException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            StartDocumentAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::UnsupportedDocumentException(_inner) => Some(_inner),
            StartDocumentAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDocumentTextDetection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDocumentTextDetectionError {
    /// Kind of error that occurred.
    pub kind: StartDocumentTextDetectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDocumentTextDetection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDocumentTextDetectionErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
    BadDocumentException(crate::error::BadDocumentException),
    /// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
    DocumentTooLargeException(crate::error::DocumentTooLargeException),
    /// <p>A <code>ClientRequestToken</code> input parameter was reused with an operation, but at least one of the other input parameters is different from the previous call to the operation. </p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p> Indicates you do not have decrypt permissions with the KMS key entered, or the KMS key was entered incorrectly. </p>
    InvalidKmsKeyException(crate::error::InvalidKmsKeyException),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>An Amazon Textract service limit was exceeded. For example, if you start too many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>, for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Textract service limit. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
    UnsupportedDocumentException(crate::error::UnsupportedDocumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDocumentTextDetectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDocumentTextDetectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::BadDocumentException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::DocumentTooLargeException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentTextDetectionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::InvalidKmsKeyException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentTextDetectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartDocumentTextDetectionErrorKind::UnsupportedDocumentException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentTextDetectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDocumentTextDetectionError {
    fn code(&self) -> Option<&str> {
        StartDocumentTextDetectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDocumentTextDetectionError {
    /// Creates a new `StartDocumentTextDetectionError`.
    pub fn new(kind: StartDocumentTextDetectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDocumentTextDetectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDocumentTextDetectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDocumentTextDetectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDocumentTextDetectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::BadDocumentException`.
    pub fn is_bad_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::BadDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::DocumentTooLargeException`.
    pub fn is_document_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::DocumentTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::InvalidKmsKeyException`.
    pub fn is_invalid_kms_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::InvalidKmsKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentTextDetectionErrorKind::UnsupportedDocumentException`.
    pub fn is_unsupported_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentTextDetectionErrorKind::UnsupportedDocumentException(_)
        )
    }
}
impl std::error::Error for StartDocumentTextDetectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDocumentTextDetectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::BadDocumentException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::DocumentTooLargeException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            StartDocumentTextDetectionErrorKind::InternalServerError(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::InvalidKmsKeyException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            StartDocumentTextDetectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartDocumentTextDetectionErrorKind::UnsupportedDocumentException(_inner) => {
                Some(_inner)
            }
            StartDocumentTextDetectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartExpenseAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartExpenseAnalysisError {
    /// Kind of error that occurred.
    pub kind: StartExpenseAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartExpenseAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartExpenseAnalysisErrorKind {
    /// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
    BadDocumentException(crate::error::BadDocumentException),
    /// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
    DocumentTooLargeException(crate::error::DocumentTooLargeException),
    /// <p>A <code>ClientRequestToken</code> input parameter was reused with an operation, but at least one of the other input parameters is different from the previous call to the operation. </p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>Amazon Textract experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p> Indicates you do not have decrypt permissions with the KMS key entered, or the KMS key was entered incorrectly. </p>
    InvalidKmsKeyException(crate::error::InvalidKmsKeyException),
    /// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>An Amazon Textract service limit was exceeded. For example, if you start too many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>, for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Textract service limit. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
    UnsupportedDocumentException(crate::error::UnsupportedDocumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartExpenseAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartExpenseAnalysisErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::BadDocumentException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::DocumentTooLargeException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            StartExpenseAnalysisErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::InvalidKmsKeyException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::InvalidS3ObjectException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartExpenseAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::UnsupportedDocumentException(_inner) => _inner.fmt(f),
            StartExpenseAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartExpenseAnalysisError {
    fn code(&self) -> Option<&str> {
        StartExpenseAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartExpenseAnalysisError {
    /// Creates a new `StartExpenseAnalysisError`.
    pub fn new(kind: StartExpenseAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartExpenseAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartExpenseAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartExpenseAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartExpenseAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::BadDocumentException`.
    pub fn is_bad_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::BadDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::DocumentTooLargeException`.
    pub fn is_document_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::DocumentTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::InvalidKmsKeyException`.
    pub fn is_invalid_kms_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::InvalidKmsKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::InvalidS3ObjectException`.
    pub fn is_invalid_s3_object_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::InvalidS3ObjectException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExpenseAnalysisErrorKind::UnsupportedDocumentException`.
    pub fn is_unsupported_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExpenseAnalysisErrorKind::UnsupportedDocumentException(_)
        )
    }
}
impl std::error::Error for StartExpenseAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartExpenseAnalysisErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::BadDocumentException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::DocumentTooLargeException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            StartExpenseAnalysisErrorKind::InternalServerError(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::InvalidKmsKeyException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::InvalidS3ObjectException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            StartExpenseAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::UnsupportedDocumentException(_inner) => Some(_inner),
            StartExpenseAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The format of the input document isn't supported. Documents for operations can be in PNG, JPEG, PDF, or TIFF format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl UnsupportedDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedDocumentException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl UnsupportedDocumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedDocumentException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedDocumentException {}
/// See [`UnsupportedDocumentException`](crate::error::UnsupportedDocumentException)
pub mod unsupported_document_exception {
    /// A builder for [`UnsupportedDocumentException`](crate::error::UnsupportedDocumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedDocumentException`](crate::error::UnsupportedDocumentException)
        pub fn build(self) -> crate::error::UnsupportedDocumentException {
            crate::error::UnsupportedDocumentException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl UnsupportedDocumentException {
    /// Creates a new builder-style object to manufacture [`UnsupportedDocumentException`](crate::error::UnsupportedDocumentException)
    pub fn builder() -> crate::error::unsupported_document_exception::Builder {
        crate::error::unsupported_document_exception::Builder::default()
    }
}

/// <p>Amazon Textract is temporarily unable to process the request. Try your call again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Textract.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedThroughputExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl ProvisionedThroughputExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for ProvisionedThroughputExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedThroughputExceededException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl ProvisionedThroughputExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProvisionedThroughputExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProvisionedThroughputExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProvisionedThroughputExceededException {}
/// See [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
pub mod provisioned_throughput_exceeded_exception {
    /// A builder for [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
        pub fn build(self) -> crate::error::ProvisionedThroughputExceededException {
            crate::error::ProvisionedThroughputExceededException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl ProvisionedThroughputExceededException {
    /// Creates a new builder-style object to manufacture [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
    pub fn builder() -> crate::error::provisioned_throughput_exceeded_exception::Builder {
        crate::error::provisioned_throughput_exceeded_exception::Builder::default()
    }
}

/// <p>An Amazon Textract service limit was exceeded. For example, if you start too many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>, for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Textract service limit. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For troubleshooting information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3ObjectException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl InvalidS3ObjectException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for InvalidS3ObjectException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3ObjectException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InvalidS3ObjectException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3ObjectException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3ObjectException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3ObjectException {}
/// See [`InvalidS3ObjectException`](crate::error::InvalidS3ObjectException)
pub mod invalid_s3_object_exception {
    /// A builder for [`InvalidS3ObjectException`](crate::error::InvalidS3ObjectException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3ObjectException`](crate::error::InvalidS3ObjectException)
        pub fn build(self) -> crate::error::InvalidS3ObjectException {
            crate::error::InvalidS3ObjectException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl InvalidS3ObjectException {
    /// Creates a new builder-style object to manufacture [`InvalidS3ObjectException`](crate::error::InvalidS3ObjectException)
    pub fn builder() -> crate::error::invalid_s3_object_exception::Builder {
        crate::error::invalid_s3_object_exception::Builder::default()
    }
}

/// <p>An input parameter violated a constraint. For example, in synchronous operations, an <code>InvalidParameterException</code> exception occurs when neither of the <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request parameter. Validate your parameter before calling the API operation again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p> Indicates you do not have decrypt permissions with the KMS key entered, or the KMS key was entered incorrectly. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKmsKeyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl InvalidKmsKeyException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for InvalidKmsKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKmsKeyException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InvalidKmsKeyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKmsKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKmsKeyException [InvalidKMSKeyException]")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKmsKeyException {}
/// See [`InvalidKmsKeyException`](crate::error::InvalidKmsKeyException)
pub mod invalid_kms_key_exception {
    /// A builder for [`InvalidKmsKeyException`](crate::error::InvalidKmsKeyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKmsKeyException`](crate::error::InvalidKmsKeyException)
        pub fn build(self) -> crate::error::InvalidKmsKeyException {
            crate::error::InvalidKmsKeyException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl InvalidKmsKeyException {
    /// Creates a new builder-style object to manufacture [`InvalidKmsKeyException`](crate::error::InvalidKmsKeyException)
    pub fn builder() -> crate::error::invalid_kms_key_exception::Builder {
        crate::error::invalid_kms_key_exception::Builder::default()
    }
}

/// <p>Amazon Textract experienced a service issue. Try your call again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl InternalServerError {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>A <code>ClientRequestToken</code> input parameter was reused with an operation, but at least one of the other input parameters is different from the previous call to the operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotentParameterMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl IdempotentParameterMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotentParameterMismatchException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl IdempotentParameterMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotentParameterMismatchException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotentParameterMismatchException {}
/// See [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
pub mod idempotent_parameter_mismatch_exception {
    /// A builder for [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
        pub fn build(self) -> crate::error::IdempotentParameterMismatchException {
            crate::error::IdempotentParameterMismatchException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl IdempotentParameterMismatchException {
    /// Creates a new builder-style object to manufacture [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    pub fn builder() -> crate::error::idempotent_parameter_mismatch_exception::Builder {
        crate::error::idempotent_parameter_mismatch_exception::Builder::default()
    }
}

/// <p>The document can't be processed because it's too large. The maximum document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is 500 MB for PDF files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentTooLargeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl DocumentTooLargeException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for DocumentTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentTooLargeException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl DocumentTooLargeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DocumentTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DocumentTooLargeException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for DocumentTooLargeException {}
/// See [`DocumentTooLargeException`](crate::error::DocumentTooLargeException)
pub mod document_too_large_exception {
    /// A builder for [`DocumentTooLargeException`](crate::error::DocumentTooLargeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentTooLargeException`](crate::error::DocumentTooLargeException)
        pub fn build(self) -> crate::error::DocumentTooLargeException {
            crate::error::DocumentTooLargeException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl DocumentTooLargeException {
    /// Creates a new builder-style object to manufacture [`DocumentTooLargeException`](crate::error::DocumentTooLargeException)
    pub fn builder() -> crate::error::document_too_large_exception::Builder {
        crate::error::document_too_large_exception::Builder::default()
    }
}

/// <p>Amazon Textract isn't able to read the document. For more information on the document limits in Amazon Textract, see <code>limits</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl BadDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for BadDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadDocumentException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl BadDocumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadDocumentException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadDocumentException {}
/// See [`BadDocumentException`](crate::error::BadDocumentException)
pub mod bad_document_exception {
    /// A builder for [`BadDocumentException`](crate::error::BadDocumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`BadDocumentException`](crate::error::BadDocumentException)
        pub fn build(self) -> crate::error::BadDocumentException {
            crate::error::BadDocumentException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl BadDocumentException {
    /// Creates a new builder-style object to manufacture [`BadDocumentException`](crate::error::BadDocumentException)
    pub fn builder() -> crate::error::bad_document_exception::Builder {
        crate::error::bad_document_exception::Builder::default()
    }
}

/// <p>You aren't authorized to perform the action. Use the Amazon Resource Name (ARN) of an authorized user or IAM role to perform the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>An invalid job identifier was passed to <code>GetDocumentAnalysis</code> or to <code>GetDocumentAnalysis</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidJobIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl InvalidJobIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for InvalidJobIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidJobIdException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InvalidJobIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidJobIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidJobIdException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidJobIdException {}
/// See [`InvalidJobIdException`](crate::error::InvalidJobIdException)
pub mod invalid_job_id_exception {
    /// A builder for [`InvalidJobIdException`](crate::error::InvalidJobIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidJobIdException`](crate::error::InvalidJobIdException)
        pub fn build(self) -> crate::error::InvalidJobIdException {
            crate::error::InvalidJobIdException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl InvalidJobIdException {
    /// Creates a new builder-style object to manufacture [`InvalidJobIdException`](crate::error::InvalidJobIdException)
    pub fn builder() -> crate::error::invalid_job_id_exception::Builder {
        crate::error::invalid_job_id_exception::Builder::default()
    }
}

/// <p>Indicates you have exceeded the maximum number of active human in the loop workflows available</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HumanLoopQuotaExceededException {
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The quota code.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The service code.</p>
    pub service_code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl HumanLoopQuotaExceededException {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The quota code.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The service code.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for HumanLoopQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HumanLoopQuotaExceededException");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl HumanLoopQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HumanLoopQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HumanLoopQuotaExceededException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for HumanLoopQuotaExceededException {}
/// See [`HumanLoopQuotaExceededException`](crate::error::HumanLoopQuotaExceededException)
pub mod human_loop_quota_exceeded_exception {
    /// A builder for [`HumanLoopQuotaExceededException`](crate::error::HumanLoopQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The quota code.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The quota code.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The service code.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service code.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`HumanLoopQuotaExceededException`](crate::error::HumanLoopQuotaExceededException)
        pub fn build(self) -> crate::error::HumanLoopQuotaExceededException {
            crate::error::HumanLoopQuotaExceededException {
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl HumanLoopQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`HumanLoopQuotaExceededException`](crate::error::HumanLoopQuotaExceededException)
    pub fn builder() -> crate::error::human_loop_quota_exceeded_exception::Builder {
        crate::error::human_loop_quota_exceeded_exception::Builder::default()
    }
}
