// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AnalyzeDocumentInput`](crate::input::AnalyzeDocumentInput)
pub mod analyze_document_input {
    /// A builder for [`AnalyzeDocumentInput`](crate::input::AnalyzeDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<crate::model::Document>,
        pub(crate) feature_types: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        pub(crate) human_loop_config: std::option::Option<crate::model::HumanLoopConfig>,
    }
    impl Builder {
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.document = Some(input);
            self
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.document = input;
            self
        }
        /// Appends an item to `feature_types`.
        ///
        /// To override the contents of this collection use [`set_feature_types`](Self::set_feature_types).
        ///
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected form data.
        /// To perform both types of analysis, add TABLES and FORMS to
        /// <code>FeatureTypes</code>. All lines and words detected in the document are included in
        /// the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn feature_types(mut self, input: impl Into<crate::model::FeatureType>) -> Self {
            let mut v = self.feature_types.unwrap_or_default();
            v.push(input.into());
            self.feature_types = Some(v);
            self
        }
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected form data.
        /// To perform both types of analysis, add TABLES and FORMS to
        /// <code>FeatureTypes</code>. All lines and words detected in the document are included in
        /// the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn set_feature_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        ) -> Self {
            self.feature_types = input;
            self
        }
        /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
        pub fn human_loop_config(mut self, input: crate::model::HumanLoopConfig) -> Self {
            self.human_loop_config = Some(input);
            self
        }
        /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.human_loop_config = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyzeDocumentInput`](crate::input::AnalyzeDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AnalyzeDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AnalyzeDocumentInput {
                document: self.document,
                feature_types: self.feature_types,
                human_loop_config: self.human_loop_config,
            })
        }
    }
}
#[doc(hidden)]
pub type AnalyzeDocumentInputOperationOutputAlias = crate::operation::AnalyzeDocument;
#[doc(hidden)]
pub type AnalyzeDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AnalyzeDocumentInput {
    /// Consumes the builder and constructs an Operation<[`AnalyzeDocument`](crate::operation::AnalyzeDocument)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AnalyzeDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AnalyzeDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AnalyzeDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AnalyzeDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.AnalyzeDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_analyze_document(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AnalyzeDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AnalyzeDocument",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AnalyzeDocumentInput`](crate::input::AnalyzeDocumentInput)
    pub fn builder() -> crate::input::analyze_document_input::Builder {
        crate::input::analyze_document_input::Builder::default()
    }
}

/// See [`AnalyzeExpenseInput`](crate::input::AnalyzeExpenseInput)
pub mod analyze_expense_input {
    /// A builder for [`AnalyzeExpenseInput`](crate::input::AnalyzeExpenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<crate::model::Document>,
    }
    impl Builder {
        /// <p>The input document, either as bytes or as an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code>
        /// property. For example, you would use the <code>Bytes</code> property to pass a document
        /// loaded from a local file system. Image bytes passed by using the <code>Bytes</code>
        /// property must be base64 encoded. Your code might not need to encode document file bytes if
        /// you're using an AWS SDK to call Amazon Textract API operations. </p>
        /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the
        /// <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64
        /// encoded.</p>
        /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS
        /// Region that you use for Amazon Textract operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using
        /// the Bytes property isn't supported. You must first upload the document to an Amazon S3
        /// bucket, and then call the operation using the S3Object property.</p>
        ///
        /// <p>For Amazon Textract to process an S3 object, the user must have permission
        /// to access the S3 object. </p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.document = Some(input);
            self
        }
        /// <p>The input document, either as bytes or as an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code>
        /// property. For example, you would use the <code>Bytes</code> property to pass a document
        /// loaded from a local file system. Image bytes passed by using the <code>Bytes</code>
        /// property must be base64 encoded. Your code might not need to encode document file bytes if
        /// you're using an AWS SDK to call Amazon Textract API operations. </p>
        /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the
        /// <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64
        /// encoded.</p>
        /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS
        /// Region that you use for Amazon Textract operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using
        /// the Bytes property isn't supported. You must first upload the document to an Amazon S3
        /// bucket, and then call the operation using the S3Object property.</p>
        ///
        /// <p>For Amazon Textract to process an S3 object, the user must have permission
        /// to access the S3 object. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyzeExpenseInput`](crate::input::AnalyzeExpenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AnalyzeExpenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AnalyzeExpenseInput {
                document: self.document,
            })
        }
    }
}
#[doc(hidden)]
pub type AnalyzeExpenseInputOperationOutputAlias = crate::operation::AnalyzeExpense;
#[doc(hidden)]
pub type AnalyzeExpenseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AnalyzeExpenseInput {
    /// Consumes the builder and constructs an Operation<[`AnalyzeExpense`](crate::operation::AnalyzeExpense)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AnalyzeExpense,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AnalyzeExpenseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AnalyzeExpenseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AnalyzeExpenseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.AnalyzeExpense",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_analyze_expense(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AnalyzeExpense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AnalyzeExpense",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AnalyzeExpenseInput`](crate::input::AnalyzeExpenseInput)
    pub fn builder() -> crate::input::analyze_expense_input::Builder {
        crate::input::analyze_expense_input::Builder::default()
    }
}

/// See [`DetectDocumentTextInput`](crate::input::DetectDocumentTextInput)
pub mod detect_document_text_input {
    /// A builder for [`DetectDocumentTextInput`](crate::input::DetectDocumentTextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<crate::model::Document>,
    }
    impl Builder {
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.document = Some(input);
            self
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
        /// in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectDocumentTextInput`](crate::input::DetectDocumentTextInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectDocumentTextInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectDocumentTextInput {
                document: self.document,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectDocumentTextInputOperationOutputAlias = crate::operation::DetectDocumentText;
#[doc(hidden)]
pub type DetectDocumentTextInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectDocumentTextInput {
    /// Consumes the builder and constructs an Operation<[`DetectDocumentText`](crate::operation::DetectDocumentText)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectDocumentText,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectDocumentTextInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectDocumentTextInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectDocumentTextInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.DetectDocumentText",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_document_text(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectDocumentText::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectDocumentText",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectDocumentTextInput`](crate::input::DetectDocumentTextInput)
    pub fn builder() -> crate::input::detect_document_text_input::Builder {
        crate::input::detect_document_text_input::Builder::default()
    }
}

/// See [`GetDocumentAnalysisInput`](crate::input::GetDocumentAnalysisInput)
pub mod get_document_analysis_input {
    /// A builder for [`GetDocumentAnalysisInput`](crate::input::GetDocumentAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value that you
        /// can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results
        /// is returned. The default value is 1,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value that you
        /// can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results
        /// is returned. The default value is 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentAnalysisInput`](crate::input::GetDocumentAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentAnalysisInput {
                job_id: self.job_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentAnalysisInputOperationOutputAlias = crate::operation::GetDocumentAnalysis;
#[doc(hidden)]
pub type GetDocumentAnalysisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentAnalysis`](crate::operation::GetDocumentAnalysis)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentAnalysis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.GetDocumentAnalysis",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_document_analysis(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentAnalysis",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentAnalysisInput`](crate::input::GetDocumentAnalysisInput)
    pub fn builder() -> crate::input::get_document_analysis_input::Builder {
        crate::input::get_document_analysis_input::Builder::default()
    }
}

/// See [`GetDocumentTextDetectionInput`](crate::input::GetDocumentTextDetectionInput)
pub mod get_document_text_detection_input {
    /// A builder for [`GetDocumentTextDetectionInput`](crate::input::GetDocumentTextDetectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is
        /// returned. The default value is 1,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is
        /// returned. The default value is 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentTextDetectionInput`](crate::input::GetDocumentTextDetectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentTextDetectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentTextDetectionInput {
                job_id: self.job_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentTextDetectionInputOperationOutputAlias =
    crate::operation::GetDocumentTextDetection;
#[doc(hidden)]
pub type GetDocumentTextDetectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentTextDetectionInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentTextDetection`](crate::operation::GetDocumentTextDetection)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentTextDetection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentTextDetectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentTextDetectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentTextDetectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.GetDocumentTextDetection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_document_text_detection(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentTextDetection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentTextDetection",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentTextDetectionInput`](crate::input::GetDocumentTextDetectionInput)
    pub fn builder() -> crate::input::get_document_text_detection_input::Builder {
        crate::input::get_document_text_detection_input::Builder::default()
    }
}

/// See [`GetExpenseAnalysisInput`](crate::input::GetExpenseAnalysisInput)
pub mod get_expense_analysis_input {
    /// A builder for [`GetExpenseAnalysisInput`](crate::input::GetExpenseAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 20. If you specify a value greater than 20, a maximum of 20 results is
        /// returned. The default value is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can
        /// specify is 20. If you specify a value greater than 20, a maximum of 20 results is
        /// returned. The default value is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExpenseAnalysisInput`](crate::input::GetExpenseAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExpenseAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExpenseAnalysisInput {
                job_id: self.job_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExpenseAnalysisInputOperationOutputAlias = crate::operation::GetExpenseAnalysis;
#[doc(hidden)]
pub type GetExpenseAnalysisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetExpenseAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`GetExpenseAnalysis`](crate::operation::GetExpenseAnalysis)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExpenseAnalysis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetExpenseAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetExpenseAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetExpenseAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.GetExpenseAnalysis",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_expense_analysis(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExpenseAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExpenseAnalysis",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetExpenseAnalysisInput`](crate::input::GetExpenseAnalysisInput)
    pub fn builder() -> crate::input::get_expense_analysis_input::Builder {
        crate::input::get_expense_analysis_input::Builder::default()
    }
}

/// See [`StartDocumentAnalysisInput`](crate::input::StartDocumentAnalysisInput)
pub mod start_document_analysis_input {
    /// A builder for [`StartDocumentAnalysisInput`](crate::input::StartDocumentAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_location: std::option::Option<crate::model::DocumentLocation>,
        pub(crate) feature_types: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) job_tag: std::option::Option<std::string::String>,
        pub(crate) notification_channel: std::option::Option<crate::model::NotificationChannel>,
        pub(crate) output_config: std::option::Option<crate::model::OutputConfig>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, input: crate::model::DocumentLocation) -> Self {
            self.document_location = Some(input);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.document_location = input;
            self
        }
        /// Appends an item to `feature_types`.
        ///
        /// To override the contents of this collection use [`set_feature_types`](Self::set_feature_types).
        ///
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected
        /// form data. To perform both types of analysis, add TABLES
        /// and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
        /// included in the response (including text that isn't related to the value of
        /// <code>FeatureTypes</code>). </p>
        pub fn feature_types(mut self, input: impl Into<crate::model::FeatureType>) -> Self {
            let mut v = self.feature_types.unwrap_or_default();
            v.push(input.into());
            self.feature_types = Some(v);
            self
        }
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
        /// about the tables that are detected in the input document. Add FORMS to return detected
        /// form data. To perform both types of analysis, add TABLES
        /// and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
        /// included in the response (including text that isn't related to the value of
        /// <code>FeatureTypes</code>). </p>
        pub fn set_feature_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        ) -> Self {
            self.feature_types = input;
            self
        }
        /// <p>The idempotent token that you use to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentAnalysis</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The idempotent token that you use to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentAnalysis</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_tag = Some(input.into());
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_tag = input;
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.notification_channel = Some(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.notification_channel = input;
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save
        /// the results internally to be accessed by the GetDocumentAnalysis operation.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save
        /// the results internally to be accessed by the GetDocumentAnalysis operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDocumentAnalysisInput`](crate::input::StartDocumentAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDocumentAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDocumentAnalysisInput {
                document_location: self.document_location,
                feature_types: self.feature_types,
                client_request_token: self.client_request_token,
                job_tag: self.job_tag,
                notification_channel: self.notification_channel,
                output_config: self.output_config,
                kms_key_id: self.kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDocumentAnalysisInputOperationOutputAlias = crate::operation::StartDocumentAnalysis;
#[doc(hidden)]
pub type StartDocumentAnalysisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDocumentAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`StartDocumentAnalysis`](crate::operation::StartDocumentAnalysis)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDocumentAnalysis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDocumentAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDocumentAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDocumentAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.StartDocumentAnalysis",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_document_analysis(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDocumentAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDocumentAnalysis",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDocumentAnalysisInput`](crate::input::StartDocumentAnalysisInput)
    pub fn builder() -> crate::input::start_document_analysis_input::Builder {
        crate::input::start_document_analysis_input::Builder::default()
    }
}

/// See [`StartDocumentTextDetectionInput`](crate::input::StartDocumentTextDetectionInput)
pub mod start_document_text_detection_input {
    /// A builder for [`StartDocumentTextDetectionInput`](crate::input::StartDocumentTextDetectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_location: std::option::Option<crate::model::DocumentLocation>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) job_tag: std::option::Option<std::string::String>,
        pub(crate) notification_channel: std::option::Option<crate::model::NotificationChannel>,
        pub(crate) output_config: std::option::Option<crate::model::OutputConfig>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, input: crate::model::DocumentLocation) -> Self {
            self.document_location = Some(input);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.document_location = input;
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentTextDetection</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same
        /// token with multiple <code>StartDocumentTextDetection</code> requests, the same
        /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
        /// job from being accidentally started more than once. For more information, see
        /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_tag = Some(input.into());
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_tag = input;
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.notification_channel = Some(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.notification_channel = input;
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will
        /// save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will
        /// save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDocumentTextDetectionInput`](crate::input::StartDocumentTextDetectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDocumentTextDetectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDocumentTextDetectionInput {
                document_location: self.document_location,
                client_request_token: self.client_request_token,
                job_tag: self.job_tag,
                notification_channel: self.notification_channel,
                output_config: self.output_config,
                kms_key_id: self.kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDocumentTextDetectionInputOperationOutputAlias =
    crate::operation::StartDocumentTextDetection;
#[doc(hidden)]
pub type StartDocumentTextDetectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDocumentTextDetectionInput {
    /// Consumes the builder and constructs an Operation<[`StartDocumentTextDetection`](crate::operation::StartDocumentTextDetection)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDocumentTextDetection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDocumentTextDetectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDocumentTextDetectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDocumentTextDetectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.StartDocumentTextDetection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_document_text_detection(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDocumentTextDetection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDocumentTextDetection",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDocumentTextDetectionInput`](crate::input::StartDocumentTextDetectionInput)
    pub fn builder() -> crate::input::start_document_text_detection_input::Builder {
        crate::input::start_document_text_detection_input::Builder::default()
    }
}

/// See [`StartExpenseAnalysisInput`](crate::input::StartExpenseAnalysisInput)
pub mod start_expense_analysis_input {
    /// A builder for [`StartExpenseAnalysisInput`](crate::input::StartExpenseAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_location: std::option::Option<crate::model::DocumentLocation>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) job_tag: std::option::Option<std::string::String>,
        pub(crate) notification_channel: std::option::Option<crate::model::NotificationChannel>,
        pub(crate) output_config: std::option::Option<crate::model::OutputConfig>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, input: crate::model::DocumentLocation) -> Self {
            self.document_location = Some(input);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.document_location = input;
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned.
        /// Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
        /// For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>
        /// </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned.
        /// Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
        /// For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>An identifier you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_tag = Some(input.into());
            self
        }
        /// <p>An identifier you specify that's included in the completion notification published
        /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
        /// document that the completion notification corresponds to (such as a tax form or a
        /// receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_tag = input;
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.notification_channel = Some(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
        /// operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.notification_channel = input;
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will
        /// save the results internally to be accessed by the <code>GetExpenseAnalysis</code>
        /// operation.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will
        /// save the results internally to be accessed by the <code>GetExpenseAnalysis</code>
        /// operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be
        /// in either Key ID or Key Alias format. When a KMS key is provided, the
        /// KMS key will be used for server-side encryption of the objects in the
        /// customer bucket. When this parameter is not enabled, the result will
        /// be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExpenseAnalysisInput`](crate::input::StartExpenseAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartExpenseAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartExpenseAnalysisInput {
                document_location: self.document_location,
                client_request_token: self.client_request_token,
                job_tag: self.job_tag,
                notification_channel: self.notification_channel,
                output_config: self.output_config,
                kms_key_id: self.kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartExpenseAnalysisInputOperationOutputAlias = crate::operation::StartExpenseAnalysis;
#[doc(hidden)]
pub type StartExpenseAnalysisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartExpenseAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`StartExpenseAnalysis`](crate::operation::StartExpenseAnalysis)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartExpenseAnalysis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartExpenseAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartExpenseAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartExpenseAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Textract.StartExpenseAnalysis",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_expense_analysis(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartExpenseAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartExpenseAnalysis",
            "textract",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartExpenseAnalysisInput`](crate::input::StartExpenseAnalysisInput)
    pub fn builder() -> crate::input::start_expense_analysis_input::Builder {
        crate::input::start_expense_analysis_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExpenseAnalysisInput {
    /// <p>The location of the document to be processed.</p>
    pub document_location: std::option::Option<crate::model::DocumentLocation>,
    /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned.
    /// Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
    /// For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>
    /// </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>An identifier you specify that's included in the completion notification published
    /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
    /// document that the completion notification corresponds to (such as a tax form or a
    /// receipt).</p>
    pub job_tag: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
    /// operation to. </p>
    pub notification_channel: std::option::Option<crate::model::NotificationChannel>,
    /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will
    /// save the results internally to be accessed by the <code>GetExpenseAnalysis</code>
    /// operation.</p>
    pub output_config: std::option::Option<crate::model::OutputConfig>,
    /// <p>The KMS key used to encrypt the inference results. This can be
    /// in either Key ID or Key Alias format. When a KMS key is provided, the
    /// KMS key will be used for server-side encryption of the objects in the
    /// customer bucket. When this parameter is not enabled, the result will
    /// be encrypted server side,using SSE-S3.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl StartExpenseAnalysisInput {
    /// <p>The location of the document to be processed.</p>
    pub fn document_location(&self) -> std::option::Option<&crate::model::DocumentLocation> {
        self.document_location.as_ref()
    }
    /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned.
    /// Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
    /// For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>
    /// </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>An identifier you specify that's included in the completion notification published
    /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
    /// document that the completion notification corresponds to (such as a tax form or a
    /// receipt).</p>
    pub fn job_tag(&self) -> std::option::Option<&str> {
        self.job_tag.as_deref()
    }
    /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
    /// operation to. </p>
    pub fn notification_channel(&self) -> std::option::Option<&crate::model::NotificationChannel> {
        self.notification_channel.as_ref()
    }
    /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will
    /// save the results internally to be accessed by the <code>GetExpenseAnalysis</code>
    /// operation.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::OutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The KMS key used to encrypt the inference results. This can be
    /// in either Key ID or Key Alias format. When a KMS key is provided, the
    /// KMS key will be used for server-side encryption of the objects in the
    /// customer bucket. When this parameter is not enabled, the result will
    /// be encrypted server side,using SSE-S3.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for StartExpenseAnalysisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExpenseAnalysisInput");
        formatter.field("document_location", &self.document_location);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("job_tag", &self.job_tag);
        formatter.field("notification_channel", &self.notification_channel);
        formatter.field("output_config", &self.output_config);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDocumentTextDetectionInput {
    /// <p>The location of the document to be processed.</p>
    pub document_location: std::option::Option<crate::model::DocumentLocation>,
    /// <p>The idempotent token that's used to identify the start request. If you use the same
    /// token with multiple <code>StartDocumentTextDetection</code> requests, the same
    /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
    /// job from being accidentally started more than once. For more information, see
    /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>An identifier that you specify that's included in the completion notification published
    /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
    /// document that the completion notification corresponds to (such as a tax form or a
    /// receipt).</p>
    pub job_tag: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
    /// operation to. </p>
    pub notification_channel: std::option::Option<crate::model::NotificationChannel>,
    /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will
    /// save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
    pub output_config: std::option::Option<crate::model::OutputConfig>,
    /// <p>The KMS key used to encrypt the inference results. This can be
    /// in either Key ID or Key Alias format. When a KMS key is provided, the
    /// KMS key will be used for server-side encryption of the objects in the
    /// customer bucket. When this parameter is not enabled, the result will
    /// be encrypted server side,using SSE-S3.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl StartDocumentTextDetectionInput {
    /// <p>The location of the document to be processed.</p>
    pub fn document_location(&self) -> std::option::Option<&crate::model::DocumentLocation> {
        self.document_location.as_ref()
    }
    /// <p>The idempotent token that's used to identify the start request. If you use the same
    /// token with multiple <code>StartDocumentTextDetection</code> requests, the same
    /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
    /// job from being accidentally started more than once. For more information, see
    /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>An identifier that you specify that's included in the completion notification published
    /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
    /// document that the completion notification corresponds to (such as a tax form or a
    /// receipt).</p>
    pub fn job_tag(&self) -> std::option::Option<&str> {
        self.job_tag.as_deref()
    }
    /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
    /// operation to. </p>
    pub fn notification_channel(&self) -> std::option::Option<&crate::model::NotificationChannel> {
        self.notification_channel.as_ref()
    }
    /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will
    /// save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::OutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The KMS key used to encrypt the inference results. This can be
    /// in either Key ID or Key Alias format. When a KMS key is provided, the
    /// KMS key will be used for server-side encryption of the objects in the
    /// customer bucket. When this parameter is not enabled, the result will
    /// be encrypted server side,using SSE-S3.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for StartDocumentTextDetectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDocumentTextDetectionInput");
        formatter.field("document_location", &self.document_location);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("job_tag", &self.job_tag);
        formatter.field("notification_channel", &self.notification_channel);
        formatter.field("output_config", &self.output_config);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDocumentAnalysisInput {
    /// <p>The location of the document to be processed.</p>
    pub document_location: std::option::Option<crate::model::DocumentLocation>,
    /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
    /// about the tables that are detected in the input document. Add FORMS to return detected
    /// form data. To perform both types of analysis, add TABLES
    /// and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
    /// included in the response (including text that isn't related to the value of
    /// <code>FeatureTypes</code>). </p>
    pub feature_types: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
    /// <p>The idempotent token that you use to identify the start request. If you use the same
    /// token with multiple <code>StartDocumentAnalysis</code> requests, the same
    /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
    /// job from being accidentally started more than once. For more information, see
    /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>An identifier that you specify that's included in the completion notification published
    /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
    /// document that the completion notification corresponds to (such as a tax form or a
    /// receipt).</p>
    pub job_tag: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
    /// operation to. </p>
    pub notification_channel: std::option::Option<crate::model::NotificationChannel>,
    /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save
    /// the results internally to be accessed by the GetDocumentAnalysis operation.</p>
    pub output_config: std::option::Option<crate::model::OutputConfig>,
    /// <p>The KMS key used to encrypt the inference results. This can be
    /// in either Key ID or Key Alias format. When a KMS key is provided, the
    /// KMS key will be used for server-side encryption of the objects in the
    /// customer bucket. When this parameter is not enabled, the result will
    /// be encrypted server side,using SSE-S3.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl StartDocumentAnalysisInput {
    /// <p>The location of the document to be processed.</p>
    pub fn document_location(&self) -> std::option::Option<&crate::model::DocumentLocation> {
        self.document_location.as_ref()
    }
    /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
    /// about the tables that are detected in the input document. Add FORMS to return detected
    /// form data. To perform both types of analysis, add TABLES
    /// and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
    /// included in the response (including text that isn't related to the value of
    /// <code>FeatureTypes</code>). </p>
    pub fn feature_types(&self) -> std::option::Option<&[crate::model::FeatureType]> {
        self.feature_types.as_deref()
    }
    /// <p>The idempotent token that you use to identify the start request. If you use the same
    /// token with multiple <code>StartDocumentAnalysis</code> requests, the same
    /// <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same
    /// job from being accidentally started more than once. For more information, see
    /// <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>An identifier that you specify that's included in the completion notification published
    /// to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of
    /// document that the completion notification corresponds to (such as a tax form or a
    /// receipt).</p>
    pub fn job_tag(&self) -> std::option::Option<&str> {
        self.job_tag.as_deref()
    }
    /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
    /// operation to. </p>
    pub fn notification_channel(&self) -> std::option::Option<&crate::model::NotificationChannel> {
        self.notification_channel.as_ref()
    }
    /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save
    /// the results internally to be accessed by the GetDocumentAnalysis operation.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::OutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The KMS key used to encrypt the inference results. This can be
    /// in either Key ID or Key Alias format. When a KMS key is provided, the
    /// KMS key will be used for server-side encryption of the objects in the
    /// customer bucket. When this parameter is not enabled, the result will
    /// be encrypted server side,using SSE-S3.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for StartDocumentAnalysisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDocumentAnalysisInput");
        formatter.field("document_location", &self.document_location);
        formatter.field("feature_types", &self.feature_types);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("job_tag", &self.job_tag);
        formatter.field("notification_channel", &self.notification_channel);
        formatter.field("output_config", &self.output_config);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExpenseAnalysisInput {
    /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
    /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per paginated call. The largest value you can
    /// specify is 20. If you specify a value greater than 20, a maximum of 20 results is
    /// returned. The default value is 20.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
    /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetExpenseAnalysisInput {
    /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
    /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The maximum number of results to return per paginated call. The largest value you can
    /// specify is 20. If you specify a value greater than 20, a maximum of 20 results is
    /// returned. The default value is 20.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
    /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetExpenseAnalysisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExpenseAnalysisInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentTextDetectionInput {
    /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
    /// <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per paginated call. The largest value you can
    /// specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is
    /// returned. The default value is 1,000.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
    /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDocumentTextDetectionInput {
    /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
    /// <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The maximum number of results to return per paginated call. The largest value you can
    /// specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is
    /// returned. The default value is 1,000.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
    /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDocumentTextDetectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentTextDetectionInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentAnalysisInput {
    /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from
    /// <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per paginated call. The largest value that you
    /// can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results
    /// is returned. The default value is 1,000.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
    /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDocumentAnalysisInput {
    /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from
    /// <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The maximum number of results to return per paginated call. The largest value that you
    /// can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results
    /// is returned. The default value is 1,000.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination
    /// token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDocumentAnalysisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentAnalysisInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectDocumentTextInput {
    /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
    /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
    /// in JPEG or PNG format.</p>
    /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
    /// image bytes that are passed using the <code>Bytes</code> field. </p>
    pub document: std::option::Option<crate::model::Document>,
}
impl DetectDocumentTextInput {
    /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
    /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
    /// in JPEG or PNG format.</p>
    /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
    /// image bytes that are passed using the <code>Bytes</code> field. </p>
    pub fn document(&self) -> std::option::Option<&crate::model::Document> {
        self.document.as_ref()
    }
}
impl std::fmt::Debug for DetectDocumentTextInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectDocumentTextInput");
        formatter.field("document", &self.document);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyzeExpenseInput {
    /// <p>The input document, either as bytes or as an S3 object.</p>
    /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code>
    /// property. For example, you would use the <code>Bytes</code> property to pass a document
    /// loaded from a local file system. Image bytes passed by using the <code>Bytes</code>
    /// property must be base64 encoded. Your code might not need to encode document file bytes if
    /// you're using an AWS SDK to call Amazon Textract API operations. </p>
    /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the
    /// <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64
    /// encoded.</p>
    /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS
    /// Region that you use for Amazon Textract operations.</p>
    /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using
    /// the Bytes property isn't supported. You must first upload the document to an Amazon S3
    /// bucket, and then call the operation using the S3Object property.</p>
    ///
    /// <p>For Amazon Textract to process an S3 object, the user must have permission
    /// to access the S3 object. </p>
    pub document: std::option::Option<crate::model::Document>,
}
impl AnalyzeExpenseInput {
    /// <p>The input document, either as bytes or as an S3 object.</p>
    /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code>
    /// property. For example, you would use the <code>Bytes</code> property to pass a document
    /// loaded from a local file system. Image bytes passed by using the <code>Bytes</code>
    /// property must be base64 encoded. Your code might not need to encode document file bytes if
    /// you're using an AWS SDK to call Amazon Textract API operations. </p>
    /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the
    /// <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64
    /// encoded.</p>
    /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS
    /// Region that you use for Amazon Textract operations.</p>
    /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using
    /// the Bytes property isn't supported. You must first upload the document to an Amazon S3
    /// bucket, and then call the operation using the S3Object property.</p>
    ///
    /// <p>For Amazon Textract to process an S3 object, the user must have permission
    /// to access the S3 object. </p>
    pub fn document(&self) -> std::option::Option<&crate::model::Document> {
        self.document.as_ref()
    }
}
impl std::fmt::Debug for AnalyzeExpenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyzeExpenseInput");
        formatter.field("document", &self.document);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyzeDocumentInput {
    /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
    /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
    /// in JPEG or PNG format.</p>
    /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
    /// image bytes that are passed using the <code>Bytes</code> field. </p>
    pub document: std::option::Option<crate::model::Document>,
    /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
    /// about the tables that are detected in the input document. Add FORMS to return detected form data.
    /// To perform both types of analysis, add TABLES and FORMS to
    /// <code>FeatureTypes</code>. All lines and words detected in the document are included in
    /// the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
    pub feature_types: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
    /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
    pub human_loop_config: std::option::Option<crate::model::HumanLoopConfig>,
}
impl AnalyzeDocumentInput {
    /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
    /// to call Amazon Textract operations, you can't pass image bytes. The document must be an image
    /// in JPEG or PNG format.</p>
    /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
    /// image bytes that are passed using the <code>Bytes</code> field. </p>
    pub fn document(&self) -> std::option::Option<&crate::model::Document> {
        self.document.as_ref()
    }
    /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information
    /// about the tables that are detected in the input document. Add FORMS to return detected form data.
    /// To perform both types of analysis, add TABLES and FORMS to
    /// <code>FeatureTypes</code>. All lines and words detected in the document are included in
    /// the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
    pub fn feature_types(&self) -> std::option::Option<&[crate::model::FeatureType]> {
        self.feature_types.as_deref()
    }
    /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
    pub fn human_loop_config(&self) -> std::option::Option<&crate::model::HumanLoopConfig> {
        self.human_loop_config.as_ref()
    }
}
impl std::fmt::Debug for AnalyzeDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyzeDocumentInput");
        formatter.field("document", &self.document);
        formatter.field("feature_types", &self.feature_types);
        formatter.field("human_loop_config", &self.human_loop_config);
        formatter.finish()
    }
}
