// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExpenseAnalysisOutput {
    /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
    /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartExpenseAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExpenseAnalysisOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`StartExpenseAnalysisOutput`](crate::output::StartExpenseAnalysisOutput)
pub mod start_expense_analysis_output {
    /// A builder for [`StartExpenseAnalysisOutput`](crate::output::StartExpenseAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from
        /// <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExpenseAnalysisOutput`](crate::output::StartExpenseAnalysisOutput)
        pub fn build(self) -> crate::output::StartExpenseAnalysisOutput {
            crate::output::StartExpenseAnalysisOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl StartExpenseAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`StartExpenseAnalysisOutput`](crate::output::StartExpenseAnalysisOutput)
    pub fn builder() -> crate::output::start_expense_analysis_output::Builder {
        crate::output::start_expense_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDocumentTextDetectionOutput {
    /// <p>The identifier of the text detection job for the document. Use <code>JobId</code> to
    /// identify the job in a subsequent call to <code>GetDocumentTextDetection</code>.
    /// A <code>JobId</code> value is only valid for 7 days.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartDocumentTextDetectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDocumentTextDetectionOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`StartDocumentTextDetectionOutput`](crate::output::StartDocumentTextDetectionOutput)
pub mod start_document_text_detection_output {
    /// A builder for [`StartDocumentTextDetectionOutput`](crate::output::StartDocumentTextDetectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the text detection job for the document. Use <code>JobId</code> to
        /// identify the job in a subsequent call to <code>GetDocumentTextDetection</code>.
        /// A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the text detection job for the document. Use <code>JobId</code> to
        /// identify the job in a subsequent call to <code>GetDocumentTextDetection</code>.
        /// A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDocumentTextDetectionOutput`](crate::output::StartDocumentTextDetectionOutput)
        pub fn build(self) -> crate::output::StartDocumentTextDetectionOutput {
            crate::output::StartDocumentTextDetectionOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl StartDocumentTextDetectionOutput {
    /// Creates a new builder-style object to manufacture [`StartDocumentTextDetectionOutput`](crate::output::StartDocumentTextDetectionOutput)
    pub fn builder() -> crate::output::start_document_text_detection_output::Builder {
        crate::output::start_document_text_detection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDocumentAnalysisOutput {
    /// <p>The identifier for the document text detection job. Use <code>JobId</code> to identify
    /// the job in a subsequent call to <code>GetDocumentAnalysis</code>. A <code>JobId</code> value
    /// is only valid for 7 days.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartDocumentAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDocumentAnalysisOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`StartDocumentAnalysisOutput`](crate::output::StartDocumentAnalysisOutput)
pub mod start_document_analysis_output {
    /// A builder for [`StartDocumentAnalysisOutput`](crate::output::StartDocumentAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the document text detection job. Use <code>JobId</code> to identify
        /// the job in a subsequent call to <code>GetDocumentAnalysis</code>. A <code>JobId</code> value
        /// is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier for the document text detection job. Use <code>JobId</code> to identify
        /// the job in a subsequent call to <code>GetDocumentAnalysis</code>. A <code>JobId</code> value
        /// is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDocumentAnalysisOutput`](crate::output::StartDocumentAnalysisOutput)
        pub fn build(self) -> crate::output::StartDocumentAnalysisOutput {
            crate::output::StartDocumentAnalysisOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl StartDocumentAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`StartDocumentAnalysisOutput`](crate::output::StartDocumentAnalysisOutput)
    pub fn builder() -> crate::output::start_document_analysis_output::Builder {
        crate::output::start_document_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExpenseAnalysisOutput {
    /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
    /// returned in every page of paginated responses from an Amazon Textract operation.</p>
    pub document_metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>The current status of the text detection job.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
    /// the subsequent request to retrieve the next set of text-detection results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The expenses detected by Amazon Textract.</p>
    pub expense_documents: std::option::Option<std::vec::Vec<crate::model::ExpenseDocument>>,
    /// <p>A list of warnings that occurred during the text-detection operation for the
    /// document.</p>
    pub warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
    /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The current model version of AnalyzeExpense.</p>
    pub analyze_expense_model_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetExpenseAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExpenseAnalysisOutput");
        formatter.field("document_metadata", &self.document_metadata);
        formatter.field("job_status", &self.job_status);
        formatter.field("next_token", &self.next_token);
        formatter.field("expense_documents", &self.expense_documents);
        formatter.field("warnings", &self.warnings);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "analyze_expense_model_version",
            &self.analyze_expense_model_version,
        );
        formatter.finish()
    }
}
/// See [`GetExpenseAnalysisOutput`](crate::output::GetExpenseAnalysisOutput)
pub mod get_expense_analysis_output {
    /// A builder for [`GetExpenseAnalysisOutput`](crate::output::GetExpenseAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) expense_documents:
            std::option::Option<std::vec::Vec<crate::model::ExpenseDocument>>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) analyze_expense_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
        /// returned in every page of paginated responses from an Amazon Textract operation.</p>
        pub fn document_metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.document_metadata = Some(input);
            self
        }
        /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
        /// returned in every page of paginated responses from an Amazon Textract operation.</p>
        pub fn set_document_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.document_metadata = input;
            self
        }
        /// <p>The current status of the text detection job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the text detection job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
        /// the subsequent request to retrieve the next set of text-detection results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
        /// the subsequent request to retrieve the next set of text-detection results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `expense_documents`.
        ///
        /// To override the contents of this collection use [`set_expense_documents`](Self::set_expense_documents).
        ///
        /// <p>The expenses detected by Amazon Textract.</p>
        pub fn expense_documents(
            mut self,
            input: impl Into<crate::model::ExpenseDocument>,
        ) -> Self {
            let mut v = self.expense_documents.unwrap_or_default();
            v.push(input.into());
            self.expense_documents = Some(v);
            self
        }
        /// <p>The expenses detected by Amazon Textract.</p>
        pub fn set_expense_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpenseDocument>>,
        ) -> Self {
            self.expense_documents = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>A list of warnings that occurred during the text-detection operation for the
        /// document.</p>
        pub fn warnings(mut self, input: impl Into<crate::model::Warning>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>A list of warnings that occurred during the text-detection operation for the
        /// document.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The current model version of AnalyzeExpense.</p>
        pub fn analyze_expense_model_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.analyze_expense_model_version = Some(input.into());
            self
        }
        /// <p>The current model version of AnalyzeExpense.</p>
        pub fn set_analyze_expense_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyze_expense_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExpenseAnalysisOutput`](crate::output::GetExpenseAnalysisOutput)
        pub fn build(self) -> crate::output::GetExpenseAnalysisOutput {
            crate::output::GetExpenseAnalysisOutput {
                document_metadata: self.document_metadata,
                job_status: self.job_status,
                next_token: self.next_token,
                expense_documents: self.expense_documents,
                warnings: self.warnings,
                status_message: self.status_message,
                analyze_expense_model_version: self.analyze_expense_model_version,
            }
        }
    }
}
impl GetExpenseAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`GetExpenseAnalysisOutput`](crate::output::GetExpenseAnalysisOutput)
    pub fn builder() -> crate::output::get_expense_analysis_output::Builder {
        crate::output::get_expense_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentTextDetectionOutput {
    /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
    /// returned in every page of paginated responses from an Amazon Textract video operation.</p>
    pub document_metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>The current status of the text detection job.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
    /// the subsequent request to retrieve the next set of text-detection results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The results of the text-detection operation.</p>
    pub blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
    /// <p>A list of warnings that occurred during the text-detection operation for the
    /// document.</p>
    pub warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
    /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p></p>
    pub detect_document_text_model_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDocumentTextDetectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentTextDetectionOutput");
        formatter.field("document_metadata", &self.document_metadata);
        formatter.field("job_status", &self.job_status);
        formatter.field("next_token", &self.next_token);
        formatter.field("blocks", &self.blocks);
        formatter.field("warnings", &self.warnings);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "detect_document_text_model_version",
            &self.detect_document_text_model_version,
        );
        formatter.finish()
    }
}
/// See [`GetDocumentTextDetectionOutput`](crate::output::GetDocumentTextDetectionOutput)
pub mod get_document_text_detection_output {
    /// A builder for [`GetDocumentTextDetectionOutput`](crate::output::GetDocumentTextDetectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) detect_document_text_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
        /// returned in every page of paginated responses from an Amazon Textract video operation.</p>
        pub fn document_metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.document_metadata = Some(input);
            self
        }
        /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
        /// returned in every page of paginated responses from an Amazon Textract video operation.</p>
        pub fn set_document_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.document_metadata = input;
            self
        }
        /// <p>The current status of the text detection job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the text detection job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
        /// the subsequent request to retrieve the next set of text-detection results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
        /// the subsequent request to retrieve the next set of text-detection results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `blocks`.
        ///
        /// To override the contents of this collection use [`set_blocks`](Self::set_blocks).
        ///
        /// <p>The results of the text-detection operation.</p>
        pub fn blocks(mut self, input: impl Into<crate::model::Block>) -> Self {
            let mut v = self.blocks.unwrap_or_default();
            v.push(input.into());
            self.blocks = Some(v);
            self
        }
        /// <p>The results of the text-detection operation.</p>
        pub fn set_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Block>>,
        ) -> Self {
            self.blocks = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>A list of warnings that occurred during the text-detection operation for the
        /// document.</p>
        pub fn warnings(mut self, input: impl Into<crate::model::Warning>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>A list of warnings that occurred during the text-detection operation for the
        /// document.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p></p>
        pub fn detect_document_text_model_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.detect_document_text_model_version = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_detect_document_text_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detect_document_text_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentTextDetectionOutput`](crate::output::GetDocumentTextDetectionOutput)
        pub fn build(self) -> crate::output::GetDocumentTextDetectionOutput {
            crate::output::GetDocumentTextDetectionOutput {
                document_metadata: self.document_metadata,
                job_status: self.job_status,
                next_token: self.next_token,
                blocks: self.blocks,
                warnings: self.warnings,
                status_message: self.status_message,
                detect_document_text_model_version: self.detect_document_text_model_version,
            }
        }
    }
}
impl GetDocumentTextDetectionOutput {
    /// Creates a new builder-style object to manufacture [`GetDocumentTextDetectionOutput`](crate::output::GetDocumentTextDetectionOutput)
    pub fn builder() -> crate::output::get_document_text_detection_output::Builder {
        crate::output::get_document_text_detection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentAnalysisOutput {
    /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
    /// returned in every page of paginated responses from an Amazon Textract video operation.</p>
    pub document_metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>The current status of the text detection job.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
    /// the subsequent request to retrieve the next set of text detection results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The results of the text-analysis operation.</p>
    pub blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
    /// <p>A list of warnings that occurred during the document-analysis operation.</p>
    pub warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
    /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p></p>
    pub analyze_document_model_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDocumentAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentAnalysisOutput");
        formatter.field("document_metadata", &self.document_metadata);
        formatter.field("job_status", &self.job_status);
        formatter.field("next_token", &self.next_token);
        formatter.field("blocks", &self.blocks);
        formatter.field("warnings", &self.warnings);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "analyze_document_model_version",
            &self.analyze_document_model_version,
        );
        formatter.finish()
    }
}
/// See [`GetDocumentAnalysisOutput`](crate::output::GetDocumentAnalysisOutput)
pub mod get_document_analysis_output {
    /// A builder for [`GetDocumentAnalysisOutput`](crate::output::GetDocumentAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) analyze_document_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
        /// returned in every page of paginated responses from an Amazon Textract video operation.</p>
        pub fn document_metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.document_metadata = Some(input);
            self
        }
        /// <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is
        /// returned in every page of paginated responses from an Amazon Textract video operation.</p>
        pub fn set_document_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.document_metadata = input;
            self
        }
        /// <p>The current status of the text detection job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the text detection job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
        /// the subsequent request to retrieve the next set of text detection results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Textract returns this token. You can use this token in
        /// the subsequent request to retrieve the next set of text detection results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `blocks`.
        ///
        /// To override the contents of this collection use [`set_blocks`](Self::set_blocks).
        ///
        /// <p>The results of the text-analysis operation.</p>
        pub fn blocks(mut self, input: impl Into<crate::model::Block>) -> Self {
            let mut v = self.blocks.unwrap_or_default();
            v.push(input.into());
            self.blocks = Some(v);
            self
        }
        /// <p>The results of the text-analysis operation.</p>
        pub fn set_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Block>>,
        ) -> Self {
            self.blocks = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>A list of warnings that occurred during the document-analysis operation.</p>
        pub fn warnings(mut self, input: impl Into<crate::model::Warning>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>A list of warnings that occurred during the document-analysis operation.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Returns if the detection job could not be completed. Contains explanation for what error occured.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p></p>
        pub fn analyze_document_model_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.analyze_document_model_version = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_analyze_document_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyze_document_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentAnalysisOutput`](crate::output::GetDocumentAnalysisOutput)
        pub fn build(self) -> crate::output::GetDocumentAnalysisOutput {
            crate::output::GetDocumentAnalysisOutput {
                document_metadata: self.document_metadata,
                job_status: self.job_status,
                next_token: self.next_token,
                blocks: self.blocks,
                warnings: self.warnings,
                status_message: self.status_message,
                analyze_document_model_version: self.analyze_document_model_version,
            }
        }
    }
}
impl GetDocumentAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`GetDocumentAnalysisOutput`](crate::output::GetDocumentAnalysisOutput)
    pub fn builder() -> crate::output::get_document_analysis_output::Builder {
        crate::output::get_document_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectDocumentTextOutput {
    /// <p>Metadata about the document. It contains the number of pages that are detected in the
    /// document.</p>
    pub document_metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>An array of <code>Block</code> objects that contain the text that's detected in the
    /// document.</p>
    pub blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
    /// <p></p>
    pub detect_document_text_model_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DetectDocumentTextOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectDocumentTextOutput");
        formatter.field("document_metadata", &self.document_metadata);
        formatter.field("blocks", &self.blocks);
        formatter.field(
            "detect_document_text_model_version",
            &self.detect_document_text_model_version,
        );
        formatter.finish()
    }
}
/// See [`DetectDocumentTextOutput`](crate::output::DetectDocumentTextOutput)
pub mod detect_document_text_output {
    /// A builder for [`DetectDocumentTextOutput`](crate::output::DetectDocumentTextOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
        pub(crate) detect_document_text_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Metadata about the document. It contains the number of pages that are detected in the
        /// document.</p>
        pub fn document_metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.document_metadata = Some(input);
            self
        }
        /// <p>Metadata about the document. It contains the number of pages that are detected in the
        /// document.</p>
        pub fn set_document_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.document_metadata = input;
            self
        }
        /// Appends an item to `blocks`.
        ///
        /// To override the contents of this collection use [`set_blocks`](Self::set_blocks).
        ///
        /// <p>An array of <code>Block</code> objects that contain the text that's detected in the
        /// document.</p>
        pub fn blocks(mut self, input: impl Into<crate::model::Block>) -> Self {
            let mut v = self.blocks.unwrap_or_default();
            v.push(input.into());
            self.blocks = Some(v);
            self
        }
        /// <p>An array of <code>Block</code> objects that contain the text that's detected in the
        /// document.</p>
        pub fn set_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Block>>,
        ) -> Self {
            self.blocks = input;
            self
        }
        /// <p></p>
        pub fn detect_document_text_model_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.detect_document_text_model_version = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_detect_document_text_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detect_document_text_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectDocumentTextOutput`](crate::output::DetectDocumentTextOutput)
        pub fn build(self) -> crate::output::DetectDocumentTextOutput {
            crate::output::DetectDocumentTextOutput {
                document_metadata: self.document_metadata,
                blocks: self.blocks,
                detect_document_text_model_version: self.detect_document_text_model_version,
            }
        }
    }
}
impl DetectDocumentTextOutput {
    /// Creates a new builder-style object to manufacture [`DetectDocumentTextOutput`](crate::output::DetectDocumentTextOutput)
    pub fn builder() -> crate::output::detect_document_text_output::Builder {
        crate::output::detect_document_text_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyzeExpenseOutput {
    /// <p>Information about the input document.</p>
    pub document_metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>The expenses detected by Amazon Textract.</p>
    pub expense_documents: std::option::Option<std::vec::Vec<crate::model::ExpenseDocument>>,
}
impl std::fmt::Debug for AnalyzeExpenseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyzeExpenseOutput");
        formatter.field("document_metadata", &self.document_metadata);
        formatter.field("expense_documents", &self.expense_documents);
        formatter.finish()
    }
}
/// See [`AnalyzeExpenseOutput`](crate::output::AnalyzeExpenseOutput)
pub mod analyze_expense_output {
    /// A builder for [`AnalyzeExpenseOutput`](crate::output::AnalyzeExpenseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) expense_documents:
            std::option::Option<std::vec::Vec<crate::model::ExpenseDocument>>,
    }
    impl Builder {
        /// <p>Information about the input document.</p>
        pub fn document_metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.document_metadata = Some(input);
            self
        }
        /// <p>Information about the input document.</p>
        pub fn set_document_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.document_metadata = input;
            self
        }
        /// Appends an item to `expense_documents`.
        ///
        /// To override the contents of this collection use [`set_expense_documents`](Self::set_expense_documents).
        ///
        /// <p>The expenses detected by Amazon Textract.</p>
        pub fn expense_documents(
            mut self,
            input: impl Into<crate::model::ExpenseDocument>,
        ) -> Self {
            let mut v = self.expense_documents.unwrap_or_default();
            v.push(input.into());
            self.expense_documents = Some(v);
            self
        }
        /// <p>The expenses detected by Amazon Textract.</p>
        pub fn set_expense_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpenseDocument>>,
        ) -> Self {
            self.expense_documents = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyzeExpenseOutput`](crate::output::AnalyzeExpenseOutput)
        pub fn build(self) -> crate::output::AnalyzeExpenseOutput {
            crate::output::AnalyzeExpenseOutput {
                document_metadata: self.document_metadata,
                expense_documents: self.expense_documents,
            }
        }
    }
}
impl AnalyzeExpenseOutput {
    /// Creates a new builder-style object to manufacture [`AnalyzeExpenseOutput`](crate::output::AnalyzeExpenseOutput)
    pub fn builder() -> crate::output::analyze_expense_output::Builder {
        crate::output::analyze_expense_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyzeDocumentOutput {
    /// <p>Metadata about the analyzed document. An example is the number of pages.</p>
    pub document_metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>The items that are detected and analyzed by <code>AnalyzeDocument</code>.</p>
    pub blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
    /// <p>Shows the results of the human in the loop evaluation.</p>
    pub human_loop_activation_output: std::option::Option<crate::model::HumanLoopActivationOutput>,
    /// <p>The version of the model used to analyze the document.</p>
    pub analyze_document_model_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AnalyzeDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyzeDocumentOutput");
        formatter.field("document_metadata", &self.document_metadata);
        formatter.field("blocks", &self.blocks);
        formatter.field(
            "human_loop_activation_output",
            &self.human_loop_activation_output,
        );
        formatter.field(
            "analyze_document_model_version",
            &self.analyze_document_model_version,
        );
        formatter.finish()
    }
}
/// See [`AnalyzeDocumentOutput`](crate::output::AnalyzeDocumentOutput)
pub mod analyze_document_output {
    /// A builder for [`AnalyzeDocumentOutput`](crate::output::AnalyzeDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) blocks: std::option::Option<std::vec::Vec<crate::model::Block>>,
        pub(crate) human_loop_activation_output:
            std::option::Option<crate::model::HumanLoopActivationOutput>,
        pub(crate) analyze_document_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Metadata about the analyzed document. An example is the number of pages.</p>
        pub fn document_metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.document_metadata = Some(input);
            self
        }
        /// <p>Metadata about the analyzed document. An example is the number of pages.</p>
        pub fn set_document_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.document_metadata = input;
            self
        }
        /// Appends an item to `blocks`.
        ///
        /// To override the contents of this collection use [`set_blocks`](Self::set_blocks).
        ///
        /// <p>The items that are detected and analyzed by <code>AnalyzeDocument</code>.</p>
        pub fn blocks(mut self, input: impl Into<crate::model::Block>) -> Self {
            let mut v = self.blocks.unwrap_or_default();
            v.push(input.into());
            self.blocks = Some(v);
            self
        }
        /// <p>The items that are detected and analyzed by <code>AnalyzeDocument</code>.</p>
        pub fn set_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Block>>,
        ) -> Self {
            self.blocks = input;
            self
        }
        /// <p>Shows the results of the human in the loop evaluation.</p>
        pub fn human_loop_activation_output(
            mut self,
            input: crate::model::HumanLoopActivationOutput,
        ) -> Self {
            self.human_loop_activation_output = Some(input);
            self
        }
        /// <p>Shows the results of the human in the loop evaluation.</p>
        pub fn set_human_loop_activation_output(
            mut self,
            input: std::option::Option<crate::model::HumanLoopActivationOutput>,
        ) -> Self {
            self.human_loop_activation_output = input;
            self
        }
        /// <p>The version of the model used to analyze the document.</p>
        pub fn analyze_document_model_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.analyze_document_model_version = Some(input.into());
            self
        }
        /// <p>The version of the model used to analyze the document.</p>
        pub fn set_analyze_document_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyze_document_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyzeDocumentOutput`](crate::output::AnalyzeDocumentOutput)
        pub fn build(self) -> crate::output::AnalyzeDocumentOutput {
            crate::output::AnalyzeDocumentOutput {
                document_metadata: self.document_metadata,
                blocks: self.blocks,
                human_loop_activation_output: self.human_loop_activation_output,
                analyze_document_model_version: self.analyze_document_model_version,
            }
        }
    }
}
impl AnalyzeDocumentOutput {
    /// Creates a new builder-style object to manufacture [`AnalyzeDocumentOutput`](crate::output::AnalyzeDocumentOutput)
    pub fn builder() -> crate::output::analyze_document_output::Builder {
        crate::output::analyze_document_output::Builder::default()
    }
}
