// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateCanaryInput`](crate::input::CreateCanaryInput)
pub mod create_canary_input {
    /// A builder for [`CreateCanaryInput`](crate::input::CreateCanaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<crate::model::CanaryCodeInput>,
        pub(crate) artifact_s3_location: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::CanaryScheduleInput>,
        pub(crate) run_config: std::option::Option<crate::model::CanaryRunConfigInput>,
        pub(crate) success_retention_period_in_days: std::option::Option<i32>,
        pub(crate) failure_retention_period_in_days: std::option::Option<i32>,
        pub(crate) runtime_version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigInput>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) artifact_config: std::option::Option<crate::model::ArtifactConfigInput>,
    }
    impl Builder {
        /// <p>The name for this canary. Be sure to give it a descriptive name
        /// that distinguishes it from other canaries in your account.</p>
        /// <p>Do not include secrets or proprietary information in your canary names. The canary name
        /// makes up part of the canary ARN, and the ARN is included in outbound calls over the
        /// internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
        /// Considerations for Synthetics Canaries</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for this canary. Be sure to give it a descriptive name
        /// that distinguishes it from other canaries in your account.</p>
        /// <p>Do not include secrets or proprietary information in your canary names. The canary name
        /// makes up part of the canary ARN, and the ARN is included in outbound calls over the
        /// internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
        /// Considerations for Synthetics Canaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn code(mut self, input: crate::model::CanaryCodeInput) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::CanaryCodeInput>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this
        /// canary. Artifacts include the log file, screenshots, and HAR files.  The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn artifact_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_s3_location = Some(input.into());
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this
        /// canary. Artifacts include the log file, screenshots, and HAR files.  The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn set_artifact_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_s3_location = input;
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:PutLogEvents</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:PutLogEvents</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>A structure that contains information about how often the canary is to run and when
        /// these test runs are to stop.</p>
        pub fn schedule(mut self, input: crate::model::CanaryScheduleInput) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>A structure that contains information about how often the canary is to run and when
        /// these test runs are to stop.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::CanaryScheduleInput>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>A structure that contains the configuration for individual canary runs,
        /// such as timeout value.</p>
        pub fn run_config(mut self, input: crate::model::CanaryRunConfigInput) -> Self {
            self.run_config = Some(input);
            self
        }
        /// <p>A structure that contains the configuration for individual canary runs,
        /// such as timeout value.</p>
        pub fn set_run_config(
            mut self,
            input: std::option::Option<crate::model::CanaryRunConfigInput>,
        ) -> Self {
            self.run_config = input;
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn success_retention_period_in_days(mut self, input: i32) -> Self {
            self.success_retention_period_in_days = Some(input);
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn set_success_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.success_retention_period_in_days = input;
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn failure_retention_period_in_days(mut self, input: i32) -> Self {
            self.failure_retention_period_in_days = Some(input);
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn set_failure_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.failure_retention_period_in_days = input;
            self
        }
        /// <p>Specifies the runtime version to use for the canary. For a list of valid
        /// runtime versions and more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn runtime_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_version = Some(input.into());
            self
        }
        /// <p>Specifies the runtime version to use for the canary. For a list of valid
        /// runtime versions and more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn set_runtime_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.runtime_version = input;
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigInput) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigInput>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs to associate with the canary.
        /// You can associate as many as 50 tags with a canary.</p>
        /// <p>Tags can help you organize and categorize your
        /// resources. You can also use them to scope user permissions, by
        /// granting a user permission to access or change only the resources that have
        /// certain tag values.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs to associate with the canary.
        /// You can associate as many as 50 tags with a canary.</p>
        /// <p>Tags can help you organize and categorize your
        /// resources. You can also use them to scope user permissions, by
        /// granting a user permission to access or change only the resources that have
        /// certain tag values.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts, including
        /// the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
        pub fn artifact_config(mut self, input: crate::model::ArtifactConfigInput) -> Self {
            self.artifact_config = Some(input);
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts, including
        /// the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
        pub fn set_artifact_config(
            mut self,
            input: std::option::Option<crate::model::ArtifactConfigInput>,
        ) -> Self {
            self.artifact_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCanaryInput`](crate::input::CreateCanaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCanaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCanaryInput {
                name: self.name,
                code: self.code,
                artifact_s3_location: self.artifact_s3_location,
                execution_role_arn: self.execution_role_arn,
                schedule: self.schedule,
                run_config: self.run_config,
                success_retention_period_in_days: self.success_retention_period_in_days,
                failure_retention_period_in_days: self.failure_retention_period_in_days,
                runtime_version: self.runtime_version,
                vpc_config: self.vpc_config,
                tags: self.tags,
                artifact_config: self.artifact_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCanaryInputOperationOutputAlias = crate::operation::CreateCanary;
#[doc(hidden)]
pub type CreateCanaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCanaryInput {
    /// Consumes the builder and constructs an Operation<[`CreateCanary`](crate::operation::CreateCanary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCanary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCanaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/canary").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCanaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCanaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_canary(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCanary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCanary",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCanaryInput`](crate::input::CreateCanaryInput)
    pub fn builder() -> crate::input::create_canary_input::Builder {
        crate::input::create_canary_input::Builder::default()
    }
}

/// See [`DeleteCanaryInput`](crate::input::DeleteCanaryInput)
pub mod delete_canary_input {
    /// A builder for [`DeleteCanaryInput`](crate::input::DeleteCanaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the canary that you want to delete. To find the names of your canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary that you want to delete. To find the names of your canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCanaryInput`](crate::input::DeleteCanaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCanaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCanaryInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteCanaryInputOperationOutputAlias = crate::operation::DeleteCanary;
#[doc(hidden)]
pub type DeleteCanaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCanaryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCanary`](crate::operation::DeleteCanary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCanary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCanaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_1, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/canary/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCanaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCanaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCanary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCanary",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCanaryInput`](crate::input::DeleteCanaryInput)
    pub fn builder() -> crate::input::delete_canary_input::Builder {
        crate::input::delete_canary_input::Builder::default()
    }
}

/// See [`DescribeCanariesInput`](crate::input::DescribeCanariesInput)
pub mod describe_canaries_input {
    /// A builder for [`DescribeCanariesInput`](crate::input::DescribeCanariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specify this parameter to limit how many canaries are returned each time you use
        /// the <code>DescribeCanaries</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specify this parameter to limit how many canaries are returned each time you use
        /// the <code>DescribeCanaries</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCanariesInput`](crate::input::DescribeCanariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCanariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCanariesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCanariesInputOperationOutputAlias = crate::operation::DescribeCanaries;
#[doc(hidden)]
pub type DescribeCanariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCanariesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCanaries`](crate::operation::DescribeCanaries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCanaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCanariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/canaries").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCanariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCanariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_canaries(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCanaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCanaries",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCanariesInput`](crate::input::DescribeCanariesInput)
    pub fn builder() -> crate::input::describe_canaries_input::Builder {
        crate::input::describe_canaries_input::Builder::default()
    }
}

/// See [`DescribeCanariesLastRunInput`](crate::input::DescribeCanariesLastRunInput)
pub mod describe_canaries_last_run_input {
    /// A builder for [`DescribeCanariesLastRunInput`](crate::input::DescribeCanariesLastRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeCanaries</code> operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeCanaries</code> operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCanariesLastRunInput`](crate::input::DescribeCanariesLastRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCanariesLastRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCanariesLastRunInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCanariesLastRunInputOperationOutputAlias =
    crate::operation::DescribeCanariesLastRun;
#[doc(hidden)]
pub type DescribeCanariesLastRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCanariesLastRunInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCanariesLastRun`](crate::operation::DescribeCanariesLastRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCanariesLastRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCanariesLastRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/canaries/last-run").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCanariesLastRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCanariesLastRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_canaries_last_run(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCanariesLastRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCanariesLastRun",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCanariesLastRunInput`](crate::input::DescribeCanariesLastRunInput)
    pub fn builder() -> crate::input::describe_canaries_last_run_input::Builder {
        crate::input::describe_canaries_last_run_input::Builder::default()
    }
}

/// See [`DescribeRuntimeVersionsInput`](crate::input::DescribeRuntimeVersionsInput)
pub mod describe_runtime_versions_input {
    /// A builder for [`DescribeRuntimeVersionsInput`](crate::input::DescribeRuntimeVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeRuntimeVersions</code> operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeRuntimeVersions</code> operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeRuntimeVersions</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeRuntimeVersions</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRuntimeVersionsInput`](crate::input::DescribeRuntimeVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRuntimeVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRuntimeVersionsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRuntimeVersionsInputOperationOutputAlias =
    crate::operation::DescribeRuntimeVersions;
#[doc(hidden)]
pub type DescribeRuntimeVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRuntimeVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRuntimeVersions`](crate::operation::DescribeRuntimeVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRuntimeVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRuntimeVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/runtime-versions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRuntimeVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRuntimeVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_runtime_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRuntimeVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRuntimeVersions",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRuntimeVersionsInput`](crate::input::DescribeRuntimeVersionsInput)
    pub fn builder() -> crate::input::describe_runtime_versions_input::Builder {
        crate::input::describe_runtime_versions_input::Builder::default()
    }
}

/// See [`GetCanaryInput`](crate::input::GetCanaryInput)
pub mod get_canary_input {
    /// A builder for [`GetCanaryInput`](crate::input::GetCanaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the canary that you want details for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary that you want details for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCanaryInput`](crate::input::GetCanaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetCanaryInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetCanaryInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetCanaryInputOperationOutputAlias = crate::operation::GetCanary;
#[doc(hidden)]
pub type GetCanaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCanaryInput {
    /// Consumes the builder and constructs an Operation<[`GetCanary`](crate::operation::GetCanary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCanary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCanaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_2, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/canary/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCanaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCanaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetCanary::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetCanary",
                    "synthetics",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCanaryInput`](crate::input::GetCanaryInput)
    pub fn builder() -> crate::input::get_canary_input::Builder {
        crate::input::get_canary_input::Builder::default()
    }
}

/// See [`GetCanaryRunsInput`](crate::input::GetCanaryRunsInput)
pub mod get_canary_runs_input {
    /// A builder for [`GetCanaryRunsInput`](crate::input::GetCanaryRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the canary that you want to see runs for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary that you want to see runs for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>GetCanaryRuns</code> operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>GetCanaryRuns</code> operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCanaryRunsInput`](crate::input::GetCanaryRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCanaryRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCanaryRunsInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCanaryRunsInputOperationOutputAlias = crate::operation::GetCanaryRuns;
#[doc(hidden)]
pub type GetCanaryRunsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCanaryRunsInput {
    /// Consumes the builder and constructs an Operation<[`GetCanaryRuns`](crate::operation::GetCanaryRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCanaryRuns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCanaryRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_3, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/canary/{Name}/runs", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCanaryRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCanaryRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_canary_runs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCanaryRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCanaryRuns",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCanaryRunsInput`](crate::input::GetCanaryRunsInput)
    pub fn builder() -> crate::input::get_canary_runs_input::Builder {
        crate::input::get_canary_runs_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the canary that you want to view tags for.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the canary that you want to view tags for.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.resource_arn;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_4, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartCanaryInput`](crate::input::StartCanaryInput)
pub mod start_canary_input {
    /// A builder for [`StartCanaryInput`](crate::input::StartCanaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the canary that you want to run. To find
        /// canary names, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary that you want to run. To find
        /// canary names, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartCanaryInput`](crate::input::StartCanaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartCanaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartCanaryInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StartCanaryInputOperationOutputAlias = crate::operation::StartCanary;
#[doc(hidden)]
pub type StartCanaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartCanaryInput {
    /// Consumes the builder and constructs an Operation<[`StartCanary`](crate::operation::StartCanary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartCanary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartCanaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_5, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/canary/{Name}/start", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartCanaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartCanaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartCanary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartCanary",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartCanaryInput`](crate::input::StartCanaryInput)
    pub fn builder() -> crate::input::start_canary_input::Builder {
        crate::input::start_canary_input::Builder::default()
    }
}

/// See [`StopCanaryInput`](crate::input::StopCanaryInput)
pub mod stop_canary_input {
    /// A builder for [`StopCanaryInput`](crate::input::StopCanaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the canary that you want to stop. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary that you want to stop. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopCanaryInput`](crate::input::StopCanaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopCanaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopCanaryInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StopCanaryInputOperationOutputAlias = crate::operation::StopCanary;
#[doc(hidden)]
pub type StopCanaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopCanaryInput {
    /// Consumes the builder and constructs an Operation<[`StopCanary`](crate::operation::StopCanary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopCanary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopCanaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_6, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/canary/{Name}/stop", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopCanaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopCanaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopCanary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopCanary",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopCanaryInput`](crate::input::StopCanaryInput)
    pub fn builder() -> crate::input::stop_canary_input::Builder {
        crate::input::stop_canary_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the canary that you're adding tags to.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the canary that you're adding tags to.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the canary.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of key-value pairs to associate with the canary.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.resource_arn;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_7, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the canary that you're removing tags from.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the canary that you're removing tags from.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.resource_arn;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_8, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_9) = &_input.tag_keys {
                for inner_10 in inner_9 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_10));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateCanaryInput`](crate::input::UpdateCanaryInput)
pub mod update_canary_input {
    /// A builder for [`UpdateCanaryInput`](crate::input::UpdateCanaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<crate::model::CanaryCodeInput>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) runtime_version: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::CanaryScheduleInput>,
        pub(crate) run_config: std::option::Option<crate::model::CanaryRunConfigInput>,
        pub(crate) success_retention_period_in_days: std::option::Option<i32>,
        pub(crate) failure_retention_period_in_days: std::option::Option<i32>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigInput>,
        pub(crate) visual_reference: std::option::Option<crate::model::VisualReferenceInput>,
        pub(crate) artifact_s3_location: std::option::Option<std::string::String>,
        pub(crate) artifact_config: std::option::Option<crate::model::ArtifactConfigInput>,
    }
    impl Builder {
        /// <p>The name of the canary that you want to update. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        /// <p>You cannot change the name of a canary that has already been created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary that you want to update. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        /// <p>You cannot change the name of a canary that has already been created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn code(mut self, input: crate::model::CanaryCodeInput) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::CanaryCodeInput>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>Specifies the runtime version to use for the canary.  
        /// For a list of valid runtime versions and for more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn runtime_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_version = Some(input.into());
            self
        }
        /// <p>Specifies the runtime version to use for the canary.  
        /// For a list of valid runtime versions and for more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn set_runtime_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.runtime_version = input;
            self
        }
        /// <p>A structure that contains information about how often the canary is to run, and when
        /// these runs are to stop.</p>
        pub fn schedule(mut self, input: crate::model::CanaryScheduleInput) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>A structure that contains information about how often the canary is to run, and when
        /// these runs are to stop.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::CanaryScheduleInput>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>A structure that contains the timeout value that is used for each individual run of the
        /// canary.</p>
        pub fn run_config(mut self, input: crate::model::CanaryRunConfigInput) -> Self {
            self.run_config = Some(input);
            self
        }
        /// <p>A structure that contains the timeout value that is used for each individual run of the
        /// canary.</p>
        pub fn set_run_config(
            mut self,
            input: std::option::Option<crate::model::CanaryRunConfigInput>,
        ) -> Self {
            self.run_config = input;
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary.</p>
        pub fn success_retention_period_in_days(mut self, input: i32) -> Self {
            self.success_retention_period_in_days = Some(input);
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary.</p>
        pub fn set_success_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.success_retention_period_in_days = input;
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary.</p>
        pub fn failure_retention_period_in_days(mut self, input: i32) -> Self {
            self.failure_retention_period_in_days = Some(input);
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary.</p>
        pub fn set_failure_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.failure_retention_period_in_days = input;
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigInput) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigInput>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary. If you omit this
        /// parameter, no changes are made to any baseline screenshots that the canary might be using already.</p>
        /// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b>
        /// runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">
        /// Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">
        /// Visual monitoring blueprint</a>
        /// </p>
        pub fn visual_reference(mut self, input: crate::model::VisualReferenceInput) -> Self {
            self.visual_reference = Some(input);
            self
        }
        /// <p>Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary. If you omit this
        /// parameter, no changes are made to any baseline screenshots that the canary might be using already.</p>
        /// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b>
        /// runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">
        /// Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">
        /// Visual monitoring blueprint</a>
        /// </p>
        pub fn set_visual_reference(
            mut self,
            input: std::option::Option<crate::model::VisualReferenceInput>,
        ) -> Self {
            self.visual_reference = input;
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        /// Artifacts include the log file, screenshots, and HAR files. The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn artifact_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_s3_location = Some(input.into());
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        /// Artifacts include the log file, screenshots, and HAR files. The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn set_artifact_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_s3_location = input;
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts,
        /// including the encryption-at-rest settings for artifacts that
        /// the canary uploads to Amazon S3.</p>
        pub fn artifact_config(mut self, input: crate::model::ArtifactConfigInput) -> Self {
            self.artifact_config = Some(input);
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts,
        /// including the encryption-at-rest settings for artifacts that
        /// the canary uploads to Amazon S3.</p>
        pub fn set_artifact_config(
            mut self,
            input: std::option::Option<crate::model::ArtifactConfigInput>,
        ) -> Self {
            self.artifact_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCanaryInput`](crate::input::UpdateCanaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCanaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCanaryInput {
                name: self.name,
                code: self.code,
                execution_role_arn: self.execution_role_arn,
                runtime_version: self.runtime_version,
                schedule: self.schedule,
                run_config: self.run_config,
                success_retention_period_in_days: self.success_retention_period_in_days,
                failure_retention_period_in_days: self.failure_retention_period_in_days,
                vpc_config: self.vpc_config,
                visual_reference: self.visual_reference,
                artifact_s3_location: self.artifact_s3_location,
                artifact_config: self.artifact_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCanaryInputOperationOutputAlias = crate::operation::UpdateCanary;
#[doc(hidden)]
pub type UpdateCanaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCanaryInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCanary`](crate::operation::UpdateCanary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCanary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCanaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_11, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/canary/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCanaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCanaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_canary(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCanary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCanary",
            "synthetics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCanaryInput`](crate::input::UpdateCanaryInput)
    pub fn builder() -> crate::input::update_canary_input::Builder {
        crate::input::update_canary_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCanaryInput {
    /// <p>The name of the canary that you want to update. To find the names of your
    /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    /// <p>You cannot change the name of a canary that has already been created.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A structure that includes the entry point from which the canary should start
    /// running your script. If the script is stored in
    /// an S3 bucket, the bucket name, key, and version are also included.
    /// </p>
    pub code: std::option::Option<crate::model::CanaryCodeInput>,
    /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
    /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
    /// policy. The role must also have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>s3:PutObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketLocation</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:ListAllMyBuckets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudwatch:PutMetricData</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogStream</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogStream</code>
    /// </p>
    /// </li>
    /// </ul>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the runtime version to use for the canary.  
    /// For a list of valid runtime versions and for more information about
    /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
    /// Canary Runtime Versions</a>.</p>
    pub runtime_version: std::option::Option<std::string::String>,
    /// <p>A structure that contains information about how often the canary is to run, and when
    /// these runs are to stop.</p>
    pub schedule: std::option::Option<crate::model::CanaryScheduleInput>,
    /// <p>A structure that contains the timeout value that is used for each individual run of the
    /// canary.</p>
    pub run_config: std::option::Option<crate::model::CanaryRunConfigInput>,
    /// <p>The number of days to retain data about successful runs of this canary.</p>
    pub success_retention_period_in_days: std::option::Option<i32>,
    /// <p>The number of days to retain data about failed runs of this canary.</p>
    pub failure_retention_period_in_days: std::option::Option<i32>,
    /// <p>If this canary is to test an endpoint in a VPC, this structure contains
    /// information about the subnet and security groups of the VPC endpoint.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
    /// Running a Canary in a VPC</a>.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigInput>,
    /// <p>Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary. If you omit this
    /// parameter, no changes are made to any baseline screenshots that the canary might be using already.</p>
    /// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b>
    /// runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">
    /// Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">
    /// Visual monitoring blueprint</a>
    /// </p>
    pub visual_reference: std::option::Option<crate::model::VisualReferenceInput>,
    /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
    /// Artifacts include the log file, screenshots, and HAR files. The name of the
    /// S3 bucket can't include a period (.).</p>
    pub artifact_s3_location: std::option::Option<std::string::String>,
    /// <p>A structure that contains the configuration for canary artifacts,
    /// including the encryption-at-rest settings for artifacts that
    /// the canary uploads to Amazon S3.</p>
    pub artifact_config: std::option::Option<crate::model::ArtifactConfigInput>,
}
impl UpdateCanaryInput {
    /// <p>The name of the canary that you want to update. To find the names of your
    /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    /// <p>You cannot change the name of a canary that has already been created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A structure that includes the entry point from which the canary should start
    /// running your script. If the script is stored in
    /// an S3 bucket, the bucket name, key, and version are also included.
    /// </p>
    pub fn code(&self) -> std::option::Option<&crate::model::CanaryCodeInput> {
        self.code.as_ref()
    }
    /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
    /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
    /// policy. The role must also have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>s3:PutObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketLocation</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:ListAllMyBuckets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudwatch:PutMetricData</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogStream</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogStream</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>Specifies the runtime version to use for the canary.  
    /// For a list of valid runtime versions and for more information about
    /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
    /// Canary Runtime Versions</a>.</p>
    pub fn runtime_version(&self) -> std::option::Option<&str> {
        self.runtime_version.as_deref()
    }
    /// <p>A structure that contains information about how often the canary is to run, and when
    /// these runs are to stop.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::CanaryScheduleInput> {
        self.schedule.as_ref()
    }
    /// <p>A structure that contains the timeout value that is used for each individual run of the
    /// canary.</p>
    pub fn run_config(&self) -> std::option::Option<&crate::model::CanaryRunConfigInput> {
        self.run_config.as_ref()
    }
    /// <p>The number of days to retain data about successful runs of this canary.</p>
    pub fn success_retention_period_in_days(&self) -> std::option::Option<i32> {
        self.success_retention_period_in_days
    }
    /// <p>The number of days to retain data about failed runs of this canary.</p>
    pub fn failure_retention_period_in_days(&self) -> std::option::Option<i32> {
        self.failure_retention_period_in_days
    }
    /// <p>If this canary is to test an endpoint in a VPC, this structure contains
    /// information about the subnet and security groups of the VPC endpoint.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
    /// Running a Canary in a VPC</a>.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigInput> {
        self.vpc_config.as_ref()
    }
    /// <p>Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary. If you omit this
    /// parameter, no changes are made to any baseline screenshots that the canary might be using already.</p>
    /// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b>
    /// runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">
    /// Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">
    /// Visual monitoring blueprint</a>
    /// </p>
    pub fn visual_reference(&self) -> std::option::Option<&crate::model::VisualReferenceInput> {
        self.visual_reference.as_ref()
    }
    /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
    /// Artifacts include the log file, screenshots, and HAR files. The name of the
    /// S3 bucket can't include a period (.).</p>
    pub fn artifact_s3_location(&self) -> std::option::Option<&str> {
        self.artifact_s3_location.as_deref()
    }
    /// <p>A structure that contains the configuration for canary artifacts,
    /// including the encryption-at-rest settings for artifacts that
    /// the canary uploads to Amazon S3.</p>
    pub fn artifact_config(&self) -> std::option::Option<&crate::model::ArtifactConfigInput> {
        self.artifact_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateCanaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCanaryInput");
        formatter.field("name", &self.name);
        formatter.field("code", &self.code);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("runtime_version", &self.runtime_version);
        formatter.field("schedule", &self.schedule);
        formatter.field("run_config", &self.run_config);
        formatter.field(
            "success_retention_period_in_days",
            &self.success_retention_period_in_days,
        );
        formatter.field(
            "failure_retention_period_in_days",
            &self.failure_retention_period_in_days,
        );
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("visual_reference", &self.visual_reference);
        formatter.field("artifact_s3_location", &self.artifact_s3_location);
        formatter.field("artifact_config", &self.artifact_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the canary that you're removing tags from.</p>
    /// <p>The ARN format of a canary is
    /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
    /// </code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the canary that you're removing tags from.</p>
    /// <p>The ARN format of a canary is
    /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
    /// </code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the canary that you're adding tags to.</p>
    /// <p>The ARN format of a canary is
    /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
    /// </code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of key-value pairs to associate with the canary.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the canary that you're adding tags to.</p>
    /// <p>The ARN format of a canary is
    /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
    /// </code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of key-value pairs to associate with the canary.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopCanaryInput {
    /// <p>The name of the canary that you want to stop. To find the names of your
    /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StopCanaryInput {
    /// <p>The name of the canary that you want to stop. To find the names of your
    /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StopCanaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopCanaryInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCanaryInput {
    /// <p>The name of the canary that you want to run. To find
    /// canary names, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StartCanaryInput {
    /// <p>The name of the canary that you want to run. To find
    /// canary names, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StartCanaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCanaryInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the canary that you want to view tags for.</p>
    /// <p>The ARN format of a canary is
    /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
    /// </code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the canary that you want to view tags for.</p>
    /// <p>The ARN format of a canary is
    /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
    /// </code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCanaryRunsInput {
    /// <p>The name of the canary that you want to see runs for.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent <code>GetCanaryRuns</code> operation to retrieve the next
    /// set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specify this parameter to limit how many runs are returned each time you use
    /// the <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetCanaryRunsInput {
    /// <p>The name of the canary that you want to see runs for.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent <code>GetCanaryRuns</code> operation to retrieve the next
    /// set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specify this parameter to limit how many runs are returned each time you use
    /// the <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetCanaryRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCanaryRunsInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCanaryInput {
    /// <p>The name of the canary that you want details for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetCanaryInput {
    /// <p>The name of the canary that you want details for.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetCanaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCanaryInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRuntimeVersionsInput {
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent <code>DescribeRuntimeVersions</code> operation to retrieve the next
    /// set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specify this parameter to limit how many runs are returned each time you use
    /// the <code>DescribeRuntimeVersions</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeRuntimeVersionsInput {
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent <code>DescribeRuntimeVersions</code> operation to retrieve the next
    /// set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specify this parameter to limit how many runs are returned each time you use
    /// the <code>DescribeRuntimeVersions</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeRuntimeVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRuntimeVersionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCanariesLastRunInput {
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent <code>DescribeCanaries</code> operation to retrieve the next
    /// set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specify this parameter to limit how many runs are returned each time you use
    /// the <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeCanariesLastRunInput {
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent <code>DescribeCanaries</code> operation to retrieve the next
    /// set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specify this parameter to limit how many runs are returned each time you use
    /// the <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeCanariesLastRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCanariesLastRunInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCanariesInput {
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent operation to retrieve the next
    /// set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specify this parameter to limit how many canaries are returned each time you use
    /// the <code>DescribeCanaries</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeCanariesInput {
    /// <p>A token that indicates that there is more data
    /// available. You can use this token in a subsequent operation to retrieve the next
    /// set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specify this parameter to limit how many canaries are returned each time you use
    /// the <code>DescribeCanaries</code> operation. If you omit this parameter, the default of 100 is used.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeCanariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCanariesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCanaryInput {
    /// <p>The name of the canary that you want to delete. To find the names of your canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteCanaryInput {
    /// <p>The name of the canary that you want to delete. To find the names of your canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteCanaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCanaryInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCanaryInput {
    /// <p>The name for this canary. Be sure to give it a descriptive name
    /// that distinguishes it from other canaries in your account.</p>
    /// <p>Do not include secrets or proprietary information in your canary names. The canary name
    /// makes up part of the canary ARN, and the ARN is included in outbound calls over the
    /// internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
    /// Considerations for Synthetics Canaries</a>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A structure that includes the entry point from which the canary should start
    /// running your script. If the script is stored in
    /// an S3 bucket, the bucket name, key, and version are also included.
    /// </p>
    pub code: std::option::Option<crate::model::CanaryCodeInput>,
    /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this
    /// canary. Artifacts include the log file, screenshots, and HAR files.  The name of the
    /// S3 bucket can't include a period (.).</p>
    pub artifact_s3_location: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
    /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
    /// policy. The role must also have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>s3:PutObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketLocation</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:ListAllMyBuckets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudwatch:PutMetricData</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogStream</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:PutLogEvents</code>
    /// </p>
    /// </li>
    /// </ul>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>A structure that contains information about how often the canary is to run and when
    /// these test runs are to stop.</p>
    pub schedule: std::option::Option<crate::model::CanaryScheduleInput>,
    /// <p>A structure that contains the configuration for individual canary runs,
    /// such as timeout value.</p>
    pub run_config: std::option::Option<crate::model::CanaryRunConfigInput>,
    /// <p>The number of days to retain data about successful runs of this canary. If you omit
    /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
    pub success_retention_period_in_days: std::option::Option<i32>,
    /// <p>The number of days to retain data about failed runs of this canary. If you omit
    /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
    pub failure_retention_period_in_days: std::option::Option<i32>,
    /// <p>Specifies the runtime version to use for the canary. For a list of valid
    /// runtime versions and more information about
    /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
    /// Canary Runtime Versions</a>.</p>
    pub runtime_version: std::option::Option<std::string::String>,
    /// <p>If this canary is to test an endpoint in a VPC, this structure contains
    /// information about the subnet and security groups of the VPC endpoint.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
    /// Running a Canary in a VPC</a>.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigInput>,
    /// <p>A list of key-value pairs to associate with the canary.
    /// You can associate as many as 50 tags with a canary.</p>
    /// <p>Tags can help you organize and categorize your
    /// resources. You can also use them to scope user permissions, by
    /// granting a user permission to access or change only the resources that have
    /// certain tag values.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A structure that contains the configuration for canary artifacts, including
    /// the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
    pub artifact_config: std::option::Option<crate::model::ArtifactConfigInput>,
}
impl CreateCanaryInput {
    /// <p>The name for this canary. Be sure to give it a descriptive name
    /// that distinguishes it from other canaries in your account.</p>
    /// <p>Do not include secrets or proprietary information in your canary names. The canary name
    /// makes up part of the canary ARN, and the ARN is included in outbound calls over the
    /// internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
    /// Considerations for Synthetics Canaries</a>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A structure that includes the entry point from which the canary should start
    /// running your script. If the script is stored in
    /// an S3 bucket, the bucket name, key, and version are also included.
    /// </p>
    pub fn code(&self) -> std::option::Option<&crate::model::CanaryCodeInput> {
        self.code.as_ref()
    }
    /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this
    /// canary. Artifacts include the log file, screenshots, and HAR files.  The name of the
    /// S3 bucket can't include a period (.).</p>
    pub fn artifact_s3_location(&self) -> std::option::Option<&str> {
        self.artifact_s3_location.as_deref()
    }
    /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
    /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
    /// policy. The role must also have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>s3:PutObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketLocation</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:ListAllMyBuckets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudwatch:PutMetricData</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:CreateLogStream</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>logs:PutLogEvents</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>A structure that contains information about how often the canary is to run and when
    /// these test runs are to stop.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::CanaryScheduleInput> {
        self.schedule.as_ref()
    }
    /// <p>A structure that contains the configuration for individual canary runs,
    /// such as timeout value.</p>
    pub fn run_config(&self) -> std::option::Option<&crate::model::CanaryRunConfigInput> {
        self.run_config.as_ref()
    }
    /// <p>The number of days to retain data about successful runs of this canary. If you omit
    /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
    pub fn success_retention_period_in_days(&self) -> std::option::Option<i32> {
        self.success_retention_period_in_days
    }
    /// <p>The number of days to retain data about failed runs of this canary. If you omit
    /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
    pub fn failure_retention_period_in_days(&self) -> std::option::Option<i32> {
        self.failure_retention_period_in_days
    }
    /// <p>Specifies the runtime version to use for the canary. For a list of valid
    /// runtime versions and more information about
    /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
    /// Canary Runtime Versions</a>.</p>
    pub fn runtime_version(&self) -> std::option::Option<&str> {
        self.runtime_version.as_deref()
    }
    /// <p>If this canary is to test an endpoint in a VPC, this structure contains
    /// information about the subnet and security groups of the VPC endpoint.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
    /// Running a Canary in a VPC</a>.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigInput> {
        self.vpc_config.as_ref()
    }
    /// <p>A list of key-value pairs to associate with the canary.
    /// You can associate as many as 50 tags with a canary.</p>
    /// <p>Tags can help you organize and categorize your
    /// resources. You can also use them to scope user permissions, by
    /// granting a user permission to access or change only the resources that have
    /// certain tag values.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A structure that contains the configuration for canary artifacts, including
    /// the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
    pub fn artifact_config(&self) -> std::option::Option<&crate::model::ArtifactConfigInput> {
        self.artifact_config.as_ref()
    }
}
impl std::fmt::Debug for CreateCanaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCanaryInput");
        formatter.field("name", &self.name);
        formatter.field("code", &self.code);
        formatter.field("artifact_s3_location", &self.artifact_s3_location);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("schedule", &self.schedule);
        formatter.field("run_config", &self.run_config);
        formatter.field(
            "success_retention_period_in_days",
            &self.success_retention_period_in_days,
        );
        formatter.field(
            "failure_retention_period_in_days",
            &self.failure_retention_period_in_days,
        );
        formatter.field("runtime_version", &self.runtime_version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("tags", &self.tags);
        formatter.field("artifact_config", &self.artifact_config);
        formatter.finish()
    }
}
