// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Synthetics
///
/// Client for invoking operations on Synthetics. Each operation on Synthetics is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_synthetics::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_synthetics::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_synthetics::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateCanary` operation.
    ///
    /// See [`CreateCanary`](crate::client::fluent_builders::CreateCanary) for more information about the
    /// operation and its arguments.
    pub fn create_canary(&self) -> fluent_builders::CreateCanary<C, M, R> {
        fluent_builders::CreateCanary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCanary` operation.
    ///
    /// See [`DeleteCanary`](crate::client::fluent_builders::DeleteCanary) for more information about the
    /// operation and its arguments.
    pub fn delete_canary(&self) -> fluent_builders::DeleteCanary<C, M, R> {
        fluent_builders::DeleteCanary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCanaries` operation.
    ///
    /// See [`DescribeCanaries`](crate::client::fluent_builders::DescribeCanaries) for more information about the
    /// operation and its arguments.
    pub fn describe_canaries(&self) -> fluent_builders::DescribeCanaries<C, M, R> {
        fluent_builders::DescribeCanaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCanariesLastRun` operation.
    ///
    /// See [`DescribeCanariesLastRun`](crate::client::fluent_builders::DescribeCanariesLastRun) for more information about the
    /// operation and its arguments.
    pub fn describe_canaries_last_run(&self) -> fluent_builders::DescribeCanariesLastRun<C, M, R> {
        fluent_builders::DescribeCanariesLastRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRuntimeVersions` operation.
    ///
    /// See [`DescribeRuntimeVersions`](crate::client::fluent_builders::DescribeRuntimeVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_runtime_versions(&self) -> fluent_builders::DescribeRuntimeVersions<C, M, R> {
        fluent_builders::DescribeRuntimeVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCanary` operation.
    ///
    /// See [`GetCanary`](crate::client::fluent_builders::GetCanary) for more information about the
    /// operation and its arguments.
    pub fn get_canary(&self) -> fluent_builders::GetCanary<C, M, R> {
        fluent_builders::GetCanary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCanaryRuns` operation.
    ///
    /// See [`GetCanaryRuns`](crate::client::fluent_builders::GetCanaryRuns) for more information about the
    /// operation and its arguments.
    pub fn get_canary_runs(&self) -> fluent_builders::GetCanaryRuns<C, M, R> {
        fluent_builders::GetCanaryRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartCanary` operation.
    ///
    /// See [`StartCanary`](crate::client::fluent_builders::StartCanary) for more information about the
    /// operation and its arguments.
    pub fn start_canary(&self) -> fluent_builders::StartCanary<C, M, R> {
        fluent_builders::StartCanary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopCanary` operation.
    ///
    /// See [`StopCanary`](crate::client::fluent_builders::StopCanary) for more information about the
    /// operation and its arguments.
    pub fn stop_canary(&self) -> fluent_builders::StopCanary<C, M, R> {
        fluent_builders::StopCanary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCanary` operation.
    ///
    /// See [`UpdateCanary`](crate::client::fluent_builders::UpdateCanary) for more information about the
    /// operation and its arguments.
    pub fn update_canary(&self) -> fluent_builders::UpdateCanary<C, M, R> {
        fluent_builders::UpdateCanary::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCanary`.
    ///
    /// <p>Creates a canary. Canaries are scripts that monitor your endpoints and APIs from the
    /// outside-in. Canaries help you check the availability and latency of your web services and
    /// troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and
    /// metrics. You can set up a canary to run continuously or just once. </p>
    /// <p>Do not use <code>CreateCanary</code> to modify an existing canary. Use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_UpdateCanary.html">UpdateCanary</a> instead.</p>
    /// <p>To create canaries, you must have the <code>CloudWatchSyntheticsFullAccess</code> policy.
    /// If you are creating a new IAM role for the canary, you also need the
    /// the <code>iam:CreateRole</code>, <code>iam:CreatePolicy</code> and
    /// <code>iam:AttachRolePolicy</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Roles">Necessary
    /// Roles and Permissions</a>.</p>
    /// <p>Do not include secrets or proprietary information in your canary names. The canary name
    /// makes up part of the Amazon Resource Name (ARN) for the canary, and the ARN is included in
    /// outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
    /// Considerations for Synthetics Canaries</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCanary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_canary_input::Builder,
    }
    impl<C, M, R> CreateCanary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCanary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCanaryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCanaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCanaryInputOperationOutputAlias,
                crate::output::CreateCanaryOutput,
                crate::error::CreateCanaryError,
                crate::input::CreateCanaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for this canary. Be sure to give it a descriptive name
        /// that distinguishes it from other canaries in your account.</p>
        /// <p>Do not include secrets or proprietary information in your canary names. The canary name
        /// makes up part of the canary ARN, and the ARN is included in outbound calls over the
        /// internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
        /// Considerations for Synthetics Canaries</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for this canary. Be sure to give it a descriptive name
        /// that distinguishes it from other canaries in your account.</p>
        /// <p>Do not include secrets or proprietary information in your canary names. The canary name
        /// makes up part of the canary ARN, and the ARN is included in outbound calls over the
        /// internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
        /// Considerations for Synthetics Canaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn code(mut self, inp: crate::model::CanaryCodeInput) -> Self {
            self.inner = self.inner.code(inp);
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::CanaryCodeInput>,
        ) -> Self {
            self.inner = self.inner.set_code(input);
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this
        /// canary. Artifacts include the log file, screenshots, and HAR files.  The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn artifact_s3_location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_s3_location(inp);
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this
        /// canary. Artifacts include the log file, screenshots, and HAR files.  The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn set_artifact_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_artifact_s3_location(input);
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:PutLogEvents</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn execution_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:PutLogEvents</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>A structure that contains information about how often the canary is to run and when
        /// these test runs are to stop.</p>
        pub fn schedule(mut self, inp: crate::model::CanaryScheduleInput) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>A structure that contains information about how often the canary is to run and when
        /// these test runs are to stop.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::CanaryScheduleInput>,
        ) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>A structure that contains the configuration for individual canary runs,
        /// such as timeout value.</p>
        pub fn run_config(mut self, inp: crate::model::CanaryRunConfigInput) -> Self {
            self.inner = self.inner.run_config(inp);
            self
        }
        /// <p>A structure that contains the configuration for individual canary runs,
        /// such as timeout value.</p>
        pub fn set_run_config(
            mut self,
            input: std::option::Option<crate::model::CanaryRunConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_run_config(input);
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn success_retention_period_in_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.success_retention_period_in_days(inp);
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn set_success_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_success_retention_period_in_days(input);
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn failure_retention_period_in_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.failure_retention_period_in_days(inp);
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary. If you omit
        /// this field, the default of 31 days is used. The valid range is 1 to 455 days.</p>
        pub fn set_failure_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_failure_retention_period_in_days(input);
            self
        }
        /// <p>Specifies the runtime version to use for the canary. For a list of valid
        /// runtime versions and more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn runtime_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.runtime_version(inp);
            self
        }
        /// <p>Specifies the runtime version to use for the canary. For a list of valid
        /// runtime versions and more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn set_runtime_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_runtime_version(input);
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfigInput) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs to associate with the canary.
        /// You can associate as many as 50 tags with a canary.</p>
        /// <p>Tags can help you organize and categorize your
        /// resources. You can also use them to scope user permissions, by
        /// granting a user permission to access or change only the resources that have
        /// certain tag values.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs to associate with the canary.
        /// You can associate as many as 50 tags with a canary.</p>
        /// <p>Tags can help you organize and categorize your
        /// resources. You can also use them to scope user permissions, by
        /// granting a user permission to access or change only the resources that have
        /// certain tag values.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts, including
        /// the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
        pub fn artifact_config(mut self, inp: crate::model::ArtifactConfigInput) -> Self {
            self.inner = self.inner.artifact_config(inp);
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts, including
        /// the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
        pub fn set_artifact_config(
            mut self,
            input: std::option::Option<crate::model::ArtifactConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_artifact_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCanary`.
    ///
    /// <p>Permanently deletes the specified canary.</p>
    /// <p>When you delete a canary, resources used and created by the canary are not automatically deleted. After you delete a canary that you do not intend to
    /// use again, you
    /// should also delete the following:</p>
    /// <ul>
    /// <li>
    /// <p>The Lambda functions and layers used by this canary. These have the prefix
    /// <code>cwsyn-<i>MyCanaryName</i>
    /// </code>.</p>
    /// </li>
    /// <li>
    /// <p>The CloudWatch alarms created for this canary. These alarms have a name of
    /// <code>Synthetics-SharpDrop-Alarm-<i>MyCanaryName</i>
    /// </code>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon S3 objects and buckets, such as the canary's artifact location.</p>
    /// </li>
    /// <li>
    /// <p>IAM roles created for the canary. If they were created in the console, these roles
    /// have the name <code>
    /// role/service-role/CloudWatchSyntheticsRole-<i>MyCanaryName</i>
    /// </code>.</p>
    /// </li>
    /// <li>
    /// <p>CloudWatch Logs log groups created for the canary. These logs groups have the name
    /// <code>/aws/lambda/cwsyn-<i>MyCanaryName</i>
    /// </code>. </p>
    /// </li>
    /// </ul>
    ///
    /// <p>Before you delete a canary, you might want to use <code>GetCanary</code> to display
    /// the information about this canary. Make
    /// note of the information returned by this operation so that you can delete these resources
    /// after you delete the canary.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCanary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_canary_input::Builder,
    }
    impl<C, M, R> DeleteCanary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCanary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCanaryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCanaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCanaryInputOperationOutputAlias,
                crate::output::DeleteCanaryOutput,
                crate::error::DeleteCanaryError,
                crate::input::DeleteCanaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the canary that you want to delete. To find the names of your canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the canary that you want to delete. To find the names of your canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCanaries`.
    ///
    /// <p>This operation returns a list of the canaries in your account, along with full details
    /// about each canary.</p>
    /// <p>This operation does not have resource-level authorization, so if a user is able to use
    /// <code>DescribeCanaries</code>, the user can see all of the canaries in the account. A
    /// deny policy can only be used to restrict access to all canaries. It cannot be used on
    /// specific resources. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCanaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_canaries_input::Builder,
    }
    impl<C, M, R> DescribeCanaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCanaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCanariesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCanariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCanariesInputOperationOutputAlias,
                crate::output::DescribeCanariesOutput,
                crate::error::DescribeCanariesError,
                crate::input::DescribeCanariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specify this parameter to limit how many canaries are returned each time you use
        /// the <code>DescribeCanaries</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specify this parameter to limit how many canaries are returned each time you use
        /// the <code>DescribeCanaries</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCanariesLastRun`.
    ///
    /// <p>Use this operation to see information from the most recent run of each canary that you have created.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCanariesLastRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_canaries_last_run_input::Builder,
    }
    impl<C, M, R> DescribeCanariesLastRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCanariesLastRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCanariesLastRunOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCanariesLastRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCanariesLastRunInputOperationOutputAlias,
                crate::output::DescribeCanariesLastRunOutput,
                crate::error::DescribeCanariesLastRunError,
                crate::input::DescribeCanariesLastRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeCanaries</code> operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeCanaries</code> operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuntimeVersions`.
    ///
    /// <p>Returns a list of Synthetics canary runtime versions. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
    /// Canary Runtime Versions</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRuntimeVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_runtime_versions_input::Builder,
    }
    impl<C, M, R> DescribeRuntimeVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRuntimeVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuntimeVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuntimeVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRuntimeVersionsInputOperationOutputAlias,
                crate::output::DescribeRuntimeVersionsOutput,
                crate::error::DescribeRuntimeVersionsError,
                crate::input::DescribeRuntimeVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeRuntimeVersions</code> operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>DescribeRuntimeVersions</code> operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeRuntimeVersions</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>DescribeRuntimeVersions</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCanary`.
    ///
    /// <p>Retrieves complete information about one canary. You must specify
    /// the name of the canary that you want. To get a list of canaries
    /// and their names, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCanary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_canary_input::Builder,
    }
    impl<C, M, R> GetCanary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCanary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCanaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCanaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCanaryInputOperationOutputAlias,
                crate::output::GetCanaryOutput,
                crate::error::GetCanaryError,
                crate::input::GetCanaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the canary that you want details for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the canary that you want details for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCanaryRuns`.
    ///
    /// <p>Retrieves a list of runs for a specified canary.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCanaryRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_canary_runs_input::Builder,
    }
    impl<C, M, R> GetCanaryRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCanaryRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCanaryRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCanaryRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCanaryRunsInputOperationOutputAlias,
                crate::output::GetCanaryRunsOutput,
                crate::error::GetCanaryRunsError,
                crate::input::GetCanaryRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the canary that you want to see runs for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the canary that you want to see runs for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>GetCanaryRuns</code> operation to retrieve the next
        /// set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token that indicates that there is more data
        /// available. You can use this token in a subsequent <code>GetCanaryRuns</code> operation to retrieve the next
        /// set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specify this parameter to limit how many runs are returned each time you use
        /// the <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with a canary.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the canary that you want to view tags for.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the canary that you want to view tags for.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCanary`.
    ///
    /// <p>Use this operation to run a canary that has already been created.  
    /// The frequency of the canary runs is determined by the value of the canary's <code>Schedule</code>. To see a canary's schedule,
    /// use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanary.html">GetCanary</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartCanary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_canary_input::Builder,
    }
    impl<C, M, R> StartCanary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartCanary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCanaryOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCanaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartCanaryInputOperationOutputAlias,
                crate::output::StartCanaryOutput,
                crate::error::StartCanaryError,
                crate::input::StartCanaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the canary that you want to run. To find
        /// canary names, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the canary that you want to run. To find
        /// canary names, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopCanary`.
    ///
    /// <p>Stops the canary to prevent all future runs. If the canary is currently running,
    /// Synthetics stops waiting for the current run of the specified canary to complete. The
    /// run that is in progress completes on its own, publishes metrics, and uploads artifacts, but
    /// it is not recorded in Synthetics as a completed run.</p>
    /// <p>You can use <code>StartCanary</code> to start it running again
    /// with the canary’s current schedule at any point in the future.  </p>
    #[derive(std::fmt::Debug)]
    pub struct StopCanary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_canary_input::Builder,
    }
    impl<C, M, R> StopCanary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopCanary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopCanaryOutput,
            aws_smithy_http::result::SdkError<crate::error::StopCanaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopCanaryInputOperationOutputAlias,
                crate::output::StopCanaryOutput,
                crate::error::StopCanaryError,
                crate::input::StopCanaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the canary that you want to stop. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the canary that you want to stop. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified canary. </p>
    /// <p>Tags can help you organize and categorize your
    /// resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with
    /// certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can use the <code>TagResource</code> action with a canary that already has tags. If you specify a new tag key for the alarm,
    /// this tag is appended to the list of tags associated
    /// with the alarm. If you specify a tag key that is already associated with the alarm, the new tag value that you specify replaces
    /// the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a canary.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the canary that you're adding tags to.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the canary that you're adding tags to.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the canary.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The list of key-value pairs to associate with the canary.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified canary.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the canary that you're removing tags from.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the canary that you're removing tags from.</p>
        /// <p>The ARN format of a canary is
        /// <code>arn:aws:synthetics:<i>Region</i>:<i>account-id</i>:canary:<i>canary-name</i>
        /// </code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCanary`.
    ///
    /// <p>Use this operation to change the settings of a canary that has
    /// already been created.</p>
    /// <p>You can't use this operation to update the tags of an existing canary. To
    /// change the tags of an existing canary, use
    /// <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_TagResource.html">TagResource</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCanary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_canary_input::Builder,
    }
    impl<C, M, R> UpdateCanary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCanary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCanaryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCanaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCanaryInputOperationOutputAlias,
                crate::output::UpdateCanaryOutput,
                crate::error::UpdateCanaryError,
                crate::input::UpdateCanaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the canary that you want to update. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        /// <p>You cannot change the name of a canary that has already been created.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the canary that you want to update. To find the names of your
        /// canaries, use <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html">DescribeCanaries</a>.</p>
        /// <p>You cannot change the name of a canary that has already been created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn code(mut self, inp: crate::model::CanaryCodeInput) -> Self {
            self.inner = self.inner.code(inp);
            self
        }
        /// <p>A structure that includes the entry point from which the canary should start
        /// running your script. If the script is stored in
        /// an S3 bucket, the bucket name, key, and version are also included.
        /// </p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::CanaryCodeInput>,
        ) -> Self {
            self.inner = self.inner.set_code(input);
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn execution_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role to be used to run the canary. This role must already exist,
        /// and must include <code>lambda.amazonaws.com</code> as a principal in the trust
        /// policy. The role must also have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListAllMyBuckets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>cloudwatch:PutMetricData</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>logs:CreateLogStream</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>Specifies the runtime version to use for the canary.  
        /// For a list of valid runtime versions and for more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn runtime_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.runtime_version(inp);
            self
        }
        /// <p>Specifies the runtime version to use for the canary.  
        /// For a list of valid runtime versions and for more information about
        /// runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
        /// Canary Runtime Versions</a>.</p>
        pub fn set_runtime_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_runtime_version(input);
            self
        }
        /// <p>A structure that contains information about how often the canary is to run, and when
        /// these runs are to stop.</p>
        pub fn schedule(mut self, inp: crate::model::CanaryScheduleInput) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>A structure that contains information about how often the canary is to run, and when
        /// these runs are to stop.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::CanaryScheduleInput>,
        ) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>A structure that contains the timeout value that is used for each individual run of the
        /// canary.</p>
        pub fn run_config(mut self, inp: crate::model::CanaryRunConfigInput) -> Self {
            self.inner = self.inner.run_config(inp);
            self
        }
        /// <p>A structure that contains the timeout value that is used for each individual run of the
        /// canary.</p>
        pub fn set_run_config(
            mut self,
            input: std::option::Option<crate::model::CanaryRunConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_run_config(input);
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary.</p>
        pub fn success_retention_period_in_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.success_retention_period_in_days(inp);
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary.</p>
        pub fn set_success_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_success_retention_period_in_days(input);
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary.</p>
        pub fn failure_retention_period_in_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.failure_retention_period_in_days(inp);
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary.</p>
        pub fn set_failure_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_failure_retention_period_in_days(input);
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfigInput) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains
        /// information about the subnet and security groups of the VPC endpoint.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
        /// Running a Canary in a VPC</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary. If you omit this
        /// parameter, no changes are made to any baseline screenshots that the canary might be using already.</p>
        /// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b>
        /// runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">
        /// Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">
        /// Visual monitoring blueprint</a>
        /// </p>
        pub fn visual_reference(mut self, inp: crate::model::VisualReferenceInput) -> Self {
            self.inner = self.inner.visual_reference(inp);
            self
        }
        /// <p>Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary. If you omit this
        /// parameter, no changes are made to any baseline screenshots that the canary might be using already.</p>
        /// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b>
        /// runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">
        /// Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">
        /// Visual monitoring blueprint</a>
        /// </p>
        pub fn set_visual_reference(
            mut self,
            input: std::option::Option<crate::model::VisualReferenceInput>,
        ) -> Self {
            self.inner = self.inner.set_visual_reference(input);
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        /// Artifacts include the log file, screenshots, and HAR files. The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn artifact_s3_location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_s3_location(inp);
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        /// Artifacts include the log file, screenshots, and HAR files. The name of the
        /// S3 bucket can't include a period (.).</p>
        pub fn set_artifact_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_artifact_s3_location(input);
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts,
        /// including the encryption-at-rest settings for artifacts that
        /// the canary uploads to Amazon S3.</p>
        pub fn artifact_config(mut self, inp: crate::model::ArtifactConfigInput) -> Self {
            self.inner = self.inner.artifact_config(inp);
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts,
        /// including the encryption-at-rest settings for artifacts that
        /// the canary uploads to Amazon S3.</p>
        pub fn set_artifact_config(
            mut self,
            input: std::option::Option<crate::model::ArtifactConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_artifact_config(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
