// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactConfigInput {
    /// <p>A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> </p>
    pub s3_encryption: std::option::Option<crate::model::S3EncryptionConfig>,
}
impl ArtifactConfigInput {
    /// <p>A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> </p>
    pub fn s3_encryption(&self) -> std::option::Option<&crate::model::S3EncryptionConfig> {
        self.s3_encryption.as_ref()
    }
}
impl std::fmt::Debug for ArtifactConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactConfigInput");
        formatter.field("s3_encryption", &self.s3_encryption);
        formatter.finish()
    }
}
/// See [`ArtifactConfigInput`](crate::model::ArtifactConfigInput)
pub mod artifact_config_input {
    /// A builder for [`ArtifactConfigInput`](crate::model::ArtifactConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_encryption: std::option::Option<crate::model::S3EncryptionConfig>,
    }
    impl Builder {
        /// <p>A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> </p>
        pub fn s3_encryption(mut self, input: crate::model::S3EncryptionConfig) -> Self {
            self.s3_encryption = Some(input);
            self
        }
        /// <p>A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> </p>
        pub fn set_s3_encryption(
            mut self,
            input: std::option::Option<crate::model::S3EncryptionConfig>,
        ) -> Self {
            self.s3_encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactConfigInput`](crate::model::ArtifactConfigInput)
        pub fn build(self) -> crate::model::ArtifactConfigInput {
            crate::model::ArtifactConfigInput {
                s3_encryption: self.s3_encryption,
            }
        }
    }
}
impl ArtifactConfigInput {
    /// Creates a new builder-style object to manufacture [`ArtifactConfigInput`](crate::model::ArtifactConfigInput)
    pub fn builder() -> crate::model::artifact_config_input::Builder {
        crate::model::artifact_config_input::Builder::default()
    }
}

/// <p>A structure that contains the configuration of encryption-at-rest settings for canary artifacts that the canary uploads to Amazon S3. </p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3EncryptionConfig {
    /// <p> The encryption method to use for artifacts created by this canary. Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed KMS key.</p>
    /// <p>If you omit this parameter, an Amazon Web Services-managed KMS key is used. </p>
    pub encryption_mode: std::option::Option<crate::model::EncryptionMode>,
    /// <p>The ARN of the customer-managed KMS key to use, if you specify <code>SSE-KMS</code> for <code>EncryptionMode</code> </p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl S3EncryptionConfig {
    /// <p> The encryption method to use for artifacts created by this canary. Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed KMS key.</p>
    /// <p>If you omit this parameter, an Amazon Web Services-managed KMS key is used. </p>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionMode> {
        self.encryption_mode.as_ref()
    }
    /// <p>The ARN of the customer-managed KMS key to use, if you specify <code>SSE-KMS</code> for <code>EncryptionMode</code> </p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for S3EncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3EncryptionConfig");
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`S3EncryptionConfig`](crate::model::S3EncryptionConfig)
pub mod s3_encryption_config {
    /// A builder for [`S3EncryptionConfig`](crate::model::S3EncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionMode>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The encryption method to use for artifacts created by this canary. Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed KMS key.</p>
        /// <p>If you omit this parameter, an Amazon Web Services-managed KMS key is used. </p>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p> The encryption method to use for artifacts created by this canary. Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed KMS key.</p>
        /// <p>If you omit this parameter, an Amazon Web Services-managed KMS key is used. </p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>The ARN of the customer-managed KMS key to use, if you specify <code>SSE-KMS</code> for <code>EncryptionMode</code> </p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the customer-managed KMS key to use, if you specify <code>SSE-KMS</code> for <code>EncryptionMode</code> </p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3EncryptionConfig`](crate::model::S3EncryptionConfig)
        pub fn build(self) -> crate::model::S3EncryptionConfig {
            crate::model::S3EncryptionConfig {
                encryption_mode: self.encryption_mode,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl S3EncryptionConfig {
    /// Creates a new builder-style object to manufacture [`S3EncryptionConfig`](crate::model::S3EncryptionConfig)
    pub fn builder() -> crate::model::s3_encryption_config::Builder {
        crate::model::s3_encryption_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionMode {
    #[allow(missing_docs)] // documentation missing in model
    SseKms,
    #[allow(missing_docs)] // documentation missing in model
    SseS3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionMode {
    fn from(s: &str) -> Self {
        match s {
            "SSE_KMS" => EncryptionMode::SseKms,
            "SSE_S3" => EncryptionMode::SseS3,
            other => EncryptionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionMode::from(s))
    }
}
impl EncryptionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionMode::SseKms => "SSE_KMS",
            EncryptionMode::SseS3 => "SSE_S3",
            EncryptionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSE_KMS", "SSE_S3"]
    }
}
impl AsRef<str> for EncryptionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that specifies what screenshots to use as a baseline for visual monitoring by this canary, and optionally the parts of the screenshots to ignore during the visual monitoring comparison.</p>
/// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b> runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html"> Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html"> Visual monitoring blueprint</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VisualReferenceInput {
    /// <p>An array of screenshots that will be used as the baseline for visual monitoring in future runs of this canary. If there is a screenshot that you don't want to be used for visual monitoring, remove it from this array.</p>
    pub base_screenshots: std::option::Option<std::vec::Vec<crate::model::BaseScreenshot>>,
    /// <p>Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html"> CanaryRun</a> from any past run of this canary.</p>
    pub base_canary_run_id: std::option::Option<std::string::String>,
}
impl VisualReferenceInput {
    /// <p>An array of screenshots that will be used as the baseline for visual monitoring in future runs of this canary. If there is a screenshot that you don't want to be used for visual monitoring, remove it from this array.</p>
    pub fn base_screenshots(&self) -> std::option::Option<&[crate::model::BaseScreenshot]> {
        self.base_screenshots.as_deref()
    }
    /// <p>Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html"> CanaryRun</a> from any past run of this canary.</p>
    pub fn base_canary_run_id(&self) -> std::option::Option<&str> {
        self.base_canary_run_id.as_deref()
    }
}
impl std::fmt::Debug for VisualReferenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VisualReferenceInput");
        formatter.field("base_screenshots", &self.base_screenshots);
        formatter.field("base_canary_run_id", &self.base_canary_run_id);
        formatter.finish()
    }
}
/// See [`VisualReferenceInput`](crate::model::VisualReferenceInput)
pub mod visual_reference_input {
    /// A builder for [`VisualReferenceInput`](crate::model::VisualReferenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_screenshots:
            std::option::Option<std::vec::Vec<crate::model::BaseScreenshot>>,
        pub(crate) base_canary_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `base_screenshots`.
        ///
        /// To override the contents of this collection use [`set_base_screenshots`](Self::set_base_screenshots).
        ///
        /// <p>An array of screenshots that will be used as the baseline for visual monitoring in future runs of this canary. If there is a screenshot that you don't want to be used for visual monitoring, remove it from this array.</p>
        pub fn base_screenshots(mut self, input: crate::model::BaseScreenshot) -> Self {
            let mut v = self.base_screenshots.unwrap_or_default();
            v.push(input);
            self.base_screenshots = Some(v);
            self
        }
        /// <p>An array of screenshots that will be used as the baseline for visual monitoring in future runs of this canary. If there is a screenshot that you don't want to be used for visual monitoring, remove it from this array.</p>
        pub fn set_base_screenshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BaseScreenshot>>,
        ) -> Self {
            self.base_screenshots = input;
            self
        }
        /// <p>Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html"> CanaryRun</a> from any past run of this canary.</p>
        pub fn base_canary_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_canary_run_id = Some(input.into());
            self
        }
        /// <p>Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html"> CanaryRun</a> from any past run of this canary.</p>
        pub fn set_base_canary_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_canary_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VisualReferenceInput`](crate::model::VisualReferenceInput)
        pub fn build(self) -> crate::model::VisualReferenceInput {
            crate::model::VisualReferenceInput {
                base_screenshots: self.base_screenshots,
                base_canary_run_id: self.base_canary_run_id,
            }
        }
    }
}
impl VisualReferenceInput {
    /// Creates a new builder-style object to manufacture [`VisualReferenceInput`](crate::model::VisualReferenceInput)
    pub fn builder() -> crate::model::visual_reference_input::Builder {
        crate::model::visual_reference_input::Builder::default()
    }
}

/// <p>A structure representing a screenshot that is used as a baseline during visual monitoring comparisons made by the canary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaseScreenshot {
    /// <p>The name of the screenshot. This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.</p>
    pub screenshot_name: std::option::Option<std::string::String>,
    /// <p>Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the coordinates to use here, use the CloudWatch Logs console to draw the boundaries on the screen. For more information, see {LINK}</p>
    pub ignore_coordinates: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BaseScreenshot {
    /// <p>The name of the screenshot. This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.</p>
    pub fn screenshot_name(&self) -> std::option::Option<&str> {
        self.screenshot_name.as_deref()
    }
    /// <p>Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the coordinates to use here, use the CloudWatch Logs console to draw the boundaries on the screen. For more information, see {LINK}</p>
    pub fn ignore_coordinates(&self) -> std::option::Option<&[std::string::String]> {
        self.ignore_coordinates.as_deref()
    }
}
impl std::fmt::Debug for BaseScreenshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaseScreenshot");
        formatter.field("screenshot_name", &self.screenshot_name);
        formatter.field("ignore_coordinates", &self.ignore_coordinates);
        formatter.finish()
    }
}
/// See [`BaseScreenshot`](crate::model::BaseScreenshot)
pub mod base_screenshot {
    /// A builder for [`BaseScreenshot`](crate::model::BaseScreenshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) screenshot_name: std::option::Option<std::string::String>,
        pub(crate) ignore_coordinates: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the screenshot. This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.</p>
        pub fn screenshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.screenshot_name = Some(input.into());
            self
        }
        /// <p>The name of the screenshot. This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.</p>
        pub fn set_screenshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screenshot_name = input;
            self
        }
        /// Appends an item to `ignore_coordinates`.
        ///
        /// To override the contents of this collection use [`set_ignore_coordinates`](Self::set_ignore_coordinates).
        ///
        /// <p>Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the coordinates to use here, use the CloudWatch Logs console to draw the boundaries on the screen. For more information, see {LINK}</p>
        pub fn ignore_coordinates(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ignore_coordinates.unwrap_or_default();
            v.push(input.into());
            self.ignore_coordinates = Some(v);
            self
        }
        /// <p>Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the coordinates to use here, use the CloudWatch Logs console to draw the boundaries on the screen. For more information, see {LINK}</p>
        pub fn set_ignore_coordinates(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ignore_coordinates = input;
            self
        }
        /// Consumes the builder and constructs a [`BaseScreenshot`](crate::model::BaseScreenshot)
        pub fn build(self) -> crate::model::BaseScreenshot {
            crate::model::BaseScreenshot {
                screenshot_name: self.screenshot_name,
                ignore_coordinates: self.ignore_coordinates,
            }
        }
    }
}
impl BaseScreenshot {
    /// Creates a new builder-style object to manufacture [`BaseScreenshot`](crate::model::BaseScreenshot)
    pub fn builder() -> crate::model::base_screenshot::Builder {
        crate::model::base_screenshot::Builder::default()
    }
}

/// <p>If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"> Running a Canary in a VPC</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfigInput {
    /// <p>The IDs of the subnets where this canary is to run.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the security groups for this canary.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfigInput {
    /// <p>The IDs of the subnets where this canary is to run.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The IDs of the security groups for this canary.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfigInput");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcConfigInput`](crate::model::VpcConfigInput)
pub mod vpc_config_input {
    /// A builder for [`VpcConfigInput`](crate::model::VpcConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets where this canary is to run.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The IDs of the subnets where this canary is to run.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups for this canary.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of the security groups for this canary.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfigInput`](crate::model::VpcConfigInput)
        pub fn build(self) -> crate::model::VpcConfigInput {
            crate::model::VpcConfigInput {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcConfigInput {
    /// Creates a new builder-style object to manufacture [`VpcConfigInput`](crate::model::VpcConfigInput)
    pub fn builder() -> crate::model::vpc_config_input::Builder {
        crate::model::vpc_config_input::Builder::default()
    }
}

/// <p>A structure that contains input information for a canary run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryRunConfigInput {
    /// <p>How long the canary is allowed to run before it must stop. You can't set this time to be longer than the frequency of the runs of this canary.</p>
    /// <p>If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
    pub memory_in_mb: std::option::Option<i32>,
    /// <p>Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html"> Canaries and X-Ray tracing</a>.</p>
    /// <p>You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.</p>
    pub active_tracing: std::option::Option<bool>,
    /// <p>Specifies the keys and values to use for any environment variables used in the canary script. Use the following format:</p>
    /// <p>{ "key1" : "value1", "key2" : "value2", ...}</p>
    /// <p>Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime"> Runtime environment variables</a>.</p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CanaryRunConfigInput {
    /// <p>How long the canary is allowed to run before it must stop. You can't set this time to be longer than the frequency of the runs of this canary.</p>
    /// <p>If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.timeout_in_seconds
    }
    /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
    pub fn memory_in_mb(&self) -> std::option::Option<i32> {
        self.memory_in_mb
    }
    /// <p>Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html"> Canaries and X-Ray tracing</a>.</p>
    /// <p>You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.</p>
    pub fn active_tracing(&self) -> std::option::Option<bool> {
        self.active_tracing
    }
    /// <p>Specifies the keys and values to use for any environment variables used in the canary script. Use the following format:</p>
    /// <p>{ "key1" : "value1", "key2" : "value2", ...}</p>
    /// <p>Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime"> Runtime environment variables</a>.</p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
}
impl std::fmt::Debug for CanaryRunConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryRunConfigInput");
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("memory_in_mb", &self.memory_in_mb);
        formatter.field("active_tracing", &self.active_tracing);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.finish()
    }
}
/// See [`CanaryRunConfigInput`](crate::model::CanaryRunConfigInput)
pub mod canary_run_config_input {
    /// A builder for [`CanaryRunConfigInput`](crate::model::CanaryRunConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) memory_in_mb: std::option::Option<i32>,
        pub(crate) active_tracing: std::option::Option<bool>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>How long the canary is allowed to run before it must stop. You can't set this time to be longer than the frequency of the runs of this canary.</p>
        /// <p>If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>How long the canary is allowed to run before it must stop. You can't set this time to be longer than the frequency of the runs of this canary.</p>
        /// <p>If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
        pub fn memory_in_mb(mut self, input: i32) -> Self {
            self.memory_in_mb = Some(input);
            self
        }
        /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
        pub fn set_memory_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_in_mb = input;
            self
        }
        /// <p>Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html"> Canaries and X-Ray tracing</a>.</p>
        /// <p>You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.</p>
        pub fn active_tracing(mut self, input: bool) -> Self {
            self.active_tracing = Some(input);
            self
        }
        /// <p>Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html"> Canaries and X-Ray tracing</a>.</p>
        /// <p>You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.</p>
        pub fn set_active_tracing(mut self, input: std::option::Option<bool>) -> Self {
            self.active_tracing = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p>Specifies the keys and values to use for any environment variables used in the canary script. Use the following format:</p>
        /// <p>{ "key1" : "value1", "key2" : "value2", ...}</p>
        /// <p>Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime"> Runtime environment variables</a>.</p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p>Specifies the keys and values to use for any environment variables used in the canary script. Use the following format:</p>
        /// <p>{ "key1" : "value1", "key2" : "value2", ...}</p>
        /// <p>Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime"> Runtime environment variables</a>.</p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryRunConfigInput`](crate::model::CanaryRunConfigInput)
        pub fn build(self) -> crate::model::CanaryRunConfigInput {
            crate::model::CanaryRunConfigInput {
                timeout_in_seconds: self.timeout_in_seconds,
                memory_in_mb: self.memory_in_mb,
                active_tracing: self.active_tracing,
                environment_variables: self.environment_variables,
            }
        }
    }
}
impl CanaryRunConfigInput {
    /// Creates a new builder-style object to manufacture [`CanaryRunConfigInput`](crate::model::CanaryRunConfigInput)
    pub fn builder() -> crate::model::canary_run_config_input::Builder {
        crate::model::canary_run_config_input::Builder::default()
    }
}

/// <p>This structure specifies how often a canary is to make runs and the date and time when it should stop making runs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryScheduleInput {
    /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
    /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
    /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
    /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
    /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>How long, in seconds, for the canary to continue making regular runs according to the schedule in the <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.</p>
    pub duration_in_seconds: std::option::Option<i64>,
}
impl CanaryScheduleInput {
    /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
    /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
    /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
    /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
    /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>How long, in seconds, for the canary to continue making regular runs according to the schedule in the <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i64> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for CanaryScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryScheduleInput");
        formatter.field("expression", &self.expression);
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`CanaryScheduleInput`](crate::model::CanaryScheduleInput)
pub mod canary_schedule_input {
    /// A builder for [`CanaryScheduleInput`](crate::model::CanaryScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) duration_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
        /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
        /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
        /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
        /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
        /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
        /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
        /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
        /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>How long, in seconds, for the canary to continue making regular runs according to the schedule in the <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.</p>
        pub fn duration_in_seconds(mut self, input: i64) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>How long, in seconds, for the canary to continue making regular runs according to the schedule in the <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryScheduleInput`](crate::model::CanaryScheduleInput)
        pub fn build(self) -> crate::model::CanaryScheduleInput {
            crate::model::CanaryScheduleInput {
                expression: self.expression,
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl CanaryScheduleInput {
    /// Creates a new builder-style object to manufacture [`CanaryScheduleInput`](crate::model::CanaryScheduleInput)
    pub fn builder() -> crate::model::canary_schedule_input::Builder {
        crate::model::canary_schedule_input::Builder::default()
    }
}

/// <p>Use this structure to input your script code for the canary. This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script was passed into the canary directly, the script code is contained in the value of <code>Zipfile</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryCodeInput {
    /// <p>If your canary script is located in S3, specify the bucket name here. Do not include <code>s3://</code> as the start of the bucket name.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The S3 key of your script. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a>.</p>
    pub s3_key: std::option::Option<std::string::String>,
    /// <p>The S3 version ID of your script.</p>
    pub s3_version: std::option::Option<std::string::String>,
    /// <p>If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the base64-encoded contents of the .zip file that contains the script. It must be smaller than 225 Kb.</p>
    /// <p>For large canary scripts, we recommend that you use an S3 location instead of inputting it directly with this parameter.</p>
    pub zip_file: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The entry point to use for the source code when running the canary. For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code>, the handler must be specified as <code> <i>fileName</i>.handler</code>. For <code>syn-python-selenium-1.1</code>, <code>syn-nodejs.puppeteer-3.4</code>, and later runtimes, the handler can be specified as <code> <i>fileName</i>.<i>functionName</i> </code>, or you can specify a folder where canary scripts reside as <code> <i>folder</i>/<i>fileName</i>.<i>functionName</i> </code>.</p>
    pub handler: std::option::Option<std::string::String>,
}
impl CanaryCodeInput {
    /// <p>If your canary script is located in S3, specify the bucket name here. Do not include <code>s3://</code> as the start of the bucket name.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The S3 key of your script. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a>.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
    /// <p>The S3 version ID of your script.</p>
    pub fn s3_version(&self) -> std::option::Option<&str> {
        self.s3_version.as_deref()
    }
    /// <p>If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the base64-encoded contents of the .zip file that contains the script. It must be smaller than 225 Kb.</p>
    /// <p>For large canary scripts, we recommend that you use an S3 location instead of inputting it directly with this parameter.</p>
    pub fn zip_file(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.zip_file.as_ref()
    }
    /// <p>The entry point to use for the source code when running the canary. For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code>, the handler must be specified as <code> <i>fileName</i>.handler</code>. For <code>syn-python-selenium-1.1</code>, <code>syn-nodejs.puppeteer-3.4</code>, and later runtimes, the handler can be specified as <code> <i>fileName</i>.<i>functionName</i> </code>, or you can specify a folder where canary scripts reside as <code> <i>folder</i>/<i>fileName</i>.<i>functionName</i> </code>.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
}
impl std::fmt::Debug for CanaryCodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryCodeInput");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.field("s3_version", &self.s3_version);
        formatter.field("zip_file", &self.zip_file);
        formatter.field("handler", &self.handler);
        formatter.finish()
    }
}
/// See [`CanaryCodeInput`](crate::model::CanaryCodeInput)
pub mod canary_code_input {
    /// A builder for [`CanaryCodeInput`](crate::model::CanaryCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
        pub(crate) s3_version: std::option::Option<std::string::String>,
        pub(crate) zip_file: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) handler: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If your canary script is located in S3, specify the bucket name here. Do not include <code>s3://</code> as the start of the bucket name.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>If your canary script is located in S3, specify the bucket name here. Do not include <code>s3://</code> as the start of the bucket name.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The S3 key of your script. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a>.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The S3 key of your script. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a>.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// <p>The S3 version ID of your script.</p>
        pub fn s3_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_version = Some(input.into());
            self
        }
        /// <p>The S3 version ID of your script.</p>
        pub fn set_s3_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_version = input;
            self
        }
        /// <p>If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the base64-encoded contents of the .zip file that contains the script. It must be smaller than 225 Kb.</p>
        /// <p>For large canary scripts, we recommend that you use an S3 location instead of inputting it directly with this parameter.</p>
        pub fn zip_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.zip_file = Some(input);
            self
        }
        /// <p>If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the base64-encoded contents of the .zip file that contains the script. It must be smaller than 225 Kb.</p>
        /// <p>For large canary scripts, we recommend that you use an S3 location instead of inputting it directly with this parameter.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.zip_file = input;
            self
        }
        /// <p>The entry point to use for the source code when running the canary. For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code>, the handler must be specified as <code> <i>fileName</i>.handler</code>. For <code>syn-python-selenium-1.1</code>, <code>syn-nodejs.puppeteer-3.4</code>, and later runtimes, the handler can be specified as <code> <i>fileName</i>.<i>functionName</i> </code>, or you can specify a folder where canary scripts reside as <code> <i>folder</i>/<i>fileName</i>.<i>functionName</i> </code>.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The entry point to use for the source code when running the canary. For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code>, the handler must be specified as <code> <i>fileName</i>.handler</code>. For <code>syn-python-selenium-1.1</code>, <code>syn-nodejs.puppeteer-3.4</code>, and later runtimes, the handler can be specified as <code> <i>fileName</i>.<i>functionName</i> </code>, or you can specify a folder where canary scripts reside as <code> <i>folder</i>/<i>fileName</i>.<i>functionName</i> </code>.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryCodeInput`](crate::model::CanaryCodeInput)
        pub fn build(self) -> crate::model::CanaryCodeInput {
            crate::model::CanaryCodeInput {
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
                s3_version: self.s3_version,
                zip_file: self.zip_file,
                handler: self.handler,
            }
        }
    }
}
impl CanaryCodeInput {
    /// Creates a new builder-style object to manufacture [`CanaryCodeInput`](crate::model::CanaryCodeInput)
    pub fn builder() -> crate::model::canary_code_input::Builder {
        crate::model::canary_code_input::Builder::default()
    }
}

/// <p>This structure contains the details about one run of one canary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryRun {
    /// <p>A unique ID that identifies this canary run.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the canary.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of this run.</p>
    pub status: std::option::Option<crate::model::CanaryRunStatus>,
    /// <p>A structure that contains the start and end times of this run.</p>
    pub timeline: std::option::Option<crate::model::CanaryRunTimeline>,
    /// <p>The location where the canary stored artifacts from the run. Artifacts include the log file, screenshots, and HAR files.</p>
    pub artifact_s3_location: std::option::Option<std::string::String>,
}
impl CanaryRun {
    /// <p>A unique ID that identifies this canary run.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the canary.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of this run.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CanaryRunStatus> {
        self.status.as_ref()
    }
    /// <p>A structure that contains the start and end times of this run.</p>
    pub fn timeline(&self) -> std::option::Option<&crate::model::CanaryRunTimeline> {
        self.timeline.as_ref()
    }
    /// <p>The location where the canary stored artifacts from the run. Artifacts include the log file, screenshots, and HAR files.</p>
    pub fn artifact_s3_location(&self) -> std::option::Option<&str> {
        self.artifact_s3_location.as_deref()
    }
}
impl std::fmt::Debug for CanaryRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryRun");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("timeline", &self.timeline);
        formatter.field("artifact_s3_location", &self.artifact_s3_location);
        formatter.finish()
    }
}
/// See [`CanaryRun`](crate::model::CanaryRun)
pub mod canary_run {
    /// A builder for [`CanaryRun`](crate::model::CanaryRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CanaryRunStatus>,
        pub(crate) timeline: std::option::Option<crate::model::CanaryRunTimeline>,
        pub(crate) artifact_s3_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique ID that identifies this canary run.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique ID that identifies this canary run.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the canary.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of this run.</p>
        pub fn status(mut self, input: crate::model::CanaryRunStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of this run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CanaryRunStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A structure that contains the start and end times of this run.</p>
        pub fn timeline(mut self, input: crate::model::CanaryRunTimeline) -> Self {
            self.timeline = Some(input);
            self
        }
        /// <p>A structure that contains the start and end times of this run.</p>
        pub fn set_timeline(
            mut self,
            input: std::option::Option<crate::model::CanaryRunTimeline>,
        ) -> Self {
            self.timeline = input;
            self
        }
        /// <p>The location where the canary stored artifacts from the run. Artifacts include the log file, screenshots, and HAR files.</p>
        pub fn artifact_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_s3_location = Some(input.into());
            self
        }
        /// <p>The location where the canary stored artifacts from the run. Artifacts include the log file, screenshots, and HAR files.</p>
        pub fn set_artifact_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryRun`](crate::model::CanaryRun)
        pub fn build(self) -> crate::model::CanaryRun {
            crate::model::CanaryRun {
                id: self.id,
                name: self.name,
                status: self.status,
                timeline: self.timeline,
                artifact_s3_location: self.artifact_s3_location,
            }
        }
    }
}
impl CanaryRun {
    /// Creates a new builder-style object to manufacture [`CanaryRun`](crate::model::CanaryRun)
    pub fn builder() -> crate::model::canary_run::Builder {
        crate::model::canary_run::Builder::default()
    }
}

/// <p>This structure contains the start and end times of a single canary run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryRunTimeline {
    /// <p>The start time of the run.</p>
    pub started: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time of the run.</p>
    pub completed: std::option::Option<aws_smithy_types::DateTime>,
}
impl CanaryRunTimeline {
    /// <p>The start time of the run.</p>
    pub fn started(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started.as_ref()
    }
    /// <p>The end time of the run.</p>
    pub fn completed(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completed.as_ref()
    }
}
impl std::fmt::Debug for CanaryRunTimeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryRunTimeline");
        formatter.field("started", &self.started);
        formatter.field("completed", &self.completed);
        formatter.finish()
    }
}
/// See [`CanaryRunTimeline`](crate::model::CanaryRunTimeline)
pub mod canary_run_timeline {
    /// A builder for [`CanaryRunTimeline`](crate::model::CanaryRunTimeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) started: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completed: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start time of the run.</p>
        pub fn started(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started = Some(input);
            self
        }
        /// <p>The start time of the run.</p>
        pub fn set_started(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started = input;
            self
        }
        /// <p>The end time of the run.</p>
        pub fn completed(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completed = Some(input);
            self
        }
        /// <p>The end time of the run.</p>
        pub fn set_completed(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completed = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryRunTimeline`](crate::model::CanaryRunTimeline)
        pub fn build(self) -> crate::model::CanaryRunTimeline {
            crate::model::CanaryRunTimeline {
                started: self.started,
                completed: self.completed,
            }
        }
    }
}
impl CanaryRunTimeline {
    /// Creates a new builder-style object to manufacture [`CanaryRunTimeline`](crate::model::CanaryRunTimeline)
    pub fn builder() -> crate::model::canary_run_timeline::Builder {
        crate::model::canary_run_timeline::Builder::default()
    }
}

/// <p>This structure contains the status information about a canary run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryRunStatus {
    /// <p>The current state of the run.</p>
    pub state: std::option::Option<crate::model::CanaryRunState>,
    /// <p>If run of the canary failed, this field contains the reason for the error.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.</p>
    pub state_reason_code: std::option::Option<crate::model::CanaryRunStateReasonCode>,
}
impl CanaryRunStatus {
    /// <p>The current state of the run.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CanaryRunState> {
        self.state.as_ref()
    }
    /// <p>If run of the canary failed, this field contains the reason for the error.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.</p>
    pub fn state_reason_code(
        &self,
    ) -> std::option::Option<&crate::model::CanaryRunStateReasonCode> {
        self.state_reason_code.as_ref()
    }
}
impl std::fmt::Debug for CanaryRunStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryRunStatus");
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.finish()
    }
}
/// See [`CanaryRunStatus`](crate::model::CanaryRunStatus)
pub mod canary_run_status {
    /// A builder for [`CanaryRunStatus`](crate::model::CanaryRunStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::CanaryRunState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::CanaryRunStateReasonCode>,
    }
    impl Builder {
        /// <p>The current state of the run.</p>
        pub fn state(mut self, input: crate::model::CanaryRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the run.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CanaryRunState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>If run of the canary failed, this field contains the reason for the error.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>If run of the canary failed, this field contains the reason for the error.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.</p>
        pub fn state_reason_code(mut self, input: crate::model::CanaryRunStateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::CanaryRunStateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryRunStatus`](crate::model::CanaryRunStatus)
        pub fn build(self) -> crate::model::CanaryRunStatus {
            crate::model::CanaryRunStatus {
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
            }
        }
    }
}
impl CanaryRunStatus {
    /// Creates a new builder-style object to manufacture [`CanaryRunStatus`](crate::model::CanaryRunStatus)
    pub fn builder() -> crate::model::canary_run_status::Builder {
        crate::model::canary_run_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CanaryRunStateReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    CanaryFailure,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CanaryRunStateReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "CANARY_FAILURE" => CanaryRunStateReasonCode::CanaryFailure,
            "EXECUTION_FAILURE" => CanaryRunStateReasonCode::ExecutionFailure,
            other => CanaryRunStateReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CanaryRunStateReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CanaryRunStateReasonCode::from(s))
    }
}
impl CanaryRunStateReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CanaryRunStateReasonCode::CanaryFailure => "CANARY_FAILURE",
            CanaryRunStateReasonCode::ExecutionFailure => "EXECUTION_FAILURE",
            CanaryRunStateReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANARY_FAILURE", "EXECUTION_FAILURE"]
    }
}
impl AsRef<str> for CanaryRunStateReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CanaryRunState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Passed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CanaryRunState {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => CanaryRunState::Failed,
            "PASSED" => CanaryRunState::Passed,
            "RUNNING" => CanaryRunState::Running,
            other => CanaryRunState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CanaryRunState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CanaryRunState::from(s))
    }
}
impl CanaryRunState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CanaryRunState::Failed => "FAILED",
            CanaryRunState::Passed => "PASSED",
            CanaryRunState::Running => "RUNNING",
            CanaryRunState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PASSED", "RUNNING"]
    }
}
impl AsRef<str> for CanaryRunState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure contains all information about one canary in your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Canary {
    /// <p>The unique ID of this canary.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the canary.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch Synthetics.</p>
    pub code: std::option::Option<crate::model::CanaryCodeOutput>,
    /// <p>The ARN of the IAM role used to run the canary. This role must include <code>lambda.amazonaws.com</code> as a principal in the trust policy.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>A structure that contains information about how often the canary is to run, and when these runs are to stop.</p>
    pub schedule: std::option::Option<crate::model::CanaryScheduleOutput>,
    /// <p>A structure that contains information about a canary run.</p>
    pub run_config: std::option::Option<crate::model::CanaryRunConfigOutput>,
    /// <p>The number of days to retain data about successful runs of this canary.</p>
    pub success_retention_period_in_days: std::option::Option<i32>,
    /// <p>The number of days to retain data about failed runs of this canary.</p>
    pub failure_retention_period_in_days: std::option::Option<i32>,
    /// <p>A structure that contains information about the canary's status.</p>
    pub status: std::option::Option<crate::model::CanaryStatus>,
    /// <p>A structure that contains information about when the canary was created, modified, and most recently run.</p>
    pub timeline: std::option::Option<crate::model::CanaryTimeline>,
    /// <p>The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include the log file, screenshots, and HAR files.</p>
    pub artifact_s3_location: std::option::Option<std::string::String>,
    /// <p>The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources and Conditions for Lambda Actions</a>.</p>
    pub engine_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the runtime version to use for the canary. For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
    pub runtime_version: std::option::Option<std::string::String>,
    /// <p>If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"> Running a Canary in a VPC</a>.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigOutput>,
    /// <p>If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.</p>
    pub visual_reference: std::option::Option<crate::model::VisualReferenceOutput>,
    /// <p>The list of key-value pairs that are associated with the canary.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
    pub artifact_config: std::option::Option<crate::model::ArtifactConfigOutput>,
}
impl Canary {
    /// <p>The unique ID of this canary.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the canary.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch Synthetics.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::CanaryCodeOutput> {
        self.code.as_ref()
    }
    /// <p>The ARN of the IAM role used to run the canary. This role must include <code>lambda.amazonaws.com</code> as a principal in the trust policy.</p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>A structure that contains information about how often the canary is to run, and when these runs are to stop.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::CanaryScheduleOutput> {
        self.schedule.as_ref()
    }
    /// <p>A structure that contains information about a canary run.</p>
    pub fn run_config(&self) -> std::option::Option<&crate::model::CanaryRunConfigOutput> {
        self.run_config.as_ref()
    }
    /// <p>The number of days to retain data about successful runs of this canary.</p>
    pub fn success_retention_period_in_days(&self) -> std::option::Option<i32> {
        self.success_retention_period_in_days
    }
    /// <p>The number of days to retain data about failed runs of this canary.</p>
    pub fn failure_retention_period_in_days(&self) -> std::option::Option<i32> {
        self.failure_retention_period_in_days
    }
    /// <p>A structure that contains information about the canary's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CanaryStatus> {
        self.status.as_ref()
    }
    /// <p>A structure that contains information about when the canary was created, modified, and most recently run.</p>
    pub fn timeline(&self) -> std::option::Option<&crate::model::CanaryTimeline> {
        self.timeline.as_ref()
    }
    /// <p>The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include the log file, screenshots, and HAR files.</p>
    pub fn artifact_s3_location(&self) -> std::option::Option<&str> {
        self.artifact_s3_location.as_deref()
    }
    /// <p>The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources and Conditions for Lambda Actions</a>.</p>
    pub fn engine_arn(&self) -> std::option::Option<&str> {
        self.engine_arn.as_deref()
    }
    /// <p>Specifies the runtime version to use for the canary. For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
    pub fn runtime_version(&self) -> std::option::Option<&str> {
        self.runtime_version.as_deref()
    }
    /// <p>If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"> Running a Canary in a VPC</a>.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigOutput> {
        self.vpc_config.as_ref()
    }
    /// <p>If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.</p>
    pub fn visual_reference(&self) -> std::option::Option<&crate::model::VisualReferenceOutput> {
        self.visual_reference.as_ref()
    }
    /// <p>The list of key-value pairs that are associated with the canary.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
    pub fn artifact_config(&self) -> std::option::Option<&crate::model::ArtifactConfigOutput> {
        self.artifact_config.as_ref()
    }
}
impl std::fmt::Debug for Canary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Canary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("code", &self.code);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("schedule", &self.schedule);
        formatter.field("run_config", &self.run_config);
        formatter.field(
            "success_retention_period_in_days",
            &self.success_retention_period_in_days,
        );
        formatter.field(
            "failure_retention_period_in_days",
            &self.failure_retention_period_in_days,
        );
        formatter.field("status", &self.status);
        formatter.field("timeline", &self.timeline);
        formatter.field("artifact_s3_location", &self.artifact_s3_location);
        formatter.field("engine_arn", &self.engine_arn);
        formatter.field("runtime_version", &self.runtime_version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("visual_reference", &self.visual_reference);
        formatter.field("tags", &self.tags);
        formatter.field("artifact_config", &self.artifact_config);
        formatter.finish()
    }
}
/// See [`Canary`](crate::model::Canary)
pub mod canary {
    /// A builder for [`Canary`](crate::model::Canary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<crate::model::CanaryCodeOutput>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::CanaryScheduleOutput>,
        pub(crate) run_config: std::option::Option<crate::model::CanaryRunConfigOutput>,
        pub(crate) success_retention_period_in_days: std::option::Option<i32>,
        pub(crate) failure_retention_period_in_days: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::CanaryStatus>,
        pub(crate) timeline: std::option::Option<crate::model::CanaryTimeline>,
        pub(crate) artifact_s3_location: std::option::Option<std::string::String>,
        pub(crate) engine_arn: std::option::Option<std::string::String>,
        pub(crate) runtime_version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigOutput>,
        pub(crate) visual_reference: std::option::Option<crate::model::VisualReferenceOutput>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) artifact_config: std::option::Option<crate::model::ArtifactConfigOutput>,
    }
    impl Builder {
        /// <p>The unique ID of this canary.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of this canary.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the canary.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the canary.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch Synthetics.</p>
        pub fn code(mut self, input: crate::model::CanaryCodeOutput) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch Synthetics.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::CanaryCodeOutput>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The ARN of the IAM role used to run the canary. This role must include <code>lambda.amazonaws.com</code> as a principal in the trust policy.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role used to run the canary. This role must include <code>lambda.amazonaws.com</code> as a principal in the trust policy.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>A structure that contains information about how often the canary is to run, and when these runs are to stop.</p>
        pub fn schedule(mut self, input: crate::model::CanaryScheduleOutput) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>A structure that contains information about how often the canary is to run, and when these runs are to stop.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::CanaryScheduleOutput>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>A structure that contains information about a canary run.</p>
        pub fn run_config(mut self, input: crate::model::CanaryRunConfigOutput) -> Self {
            self.run_config = Some(input);
            self
        }
        /// <p>A structure that contains information about a canary run.</p>
        pub fn set_run_config(
            mut self,
            input: std::option::Option<crate::model::CanaryRunConfigOutput>,
        ) -> Self {
            self.run_config = input;
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary.</p>
        pub fn success_retention_period_in_days(mut self, input: i32) -> Self {
            self.success_retention_period_in_days = Some(input);
            self
        }
        /// <p>The number of days to retain data about successful runs of this canary.</p>
        pub fn set_success_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.success_retention_period_in_days = input;
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary.</p>
        pub fn failure_retention_period_in_days(mut self, input: i32) -> Self {
            self.failure_retention_period_in_days = Some(input);
            self
        }
        /// <p>The number of days to retain data about failed runs of this canary.</p>
        pub fn set_failure_retention_period_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.failure_retention_period_in_days = input;
            self
        }
        /// <p>A structure that contains information about the canary's status.</p>
        pub fn status(mut self, input: crate::model::CanaryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A structure that contains information about the canary's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CanaryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A structure that contains information about when the canary was created, modified, and most recently run.</p>
        pub fn timeline(mut self, input: crate::model::CanaryTimeline) -> Self {
            self.timeline = Some(input);
            self
        }
        /// <p>A structure that contains information about when the canary was created, modified, and most recently run.</p>
        pub fn set_timeline(
            mut self,
            input: std::option::Option<crate::model::CanaryTimeline>,
        ) -> Self {
            self.timeline = input;
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include the log file, screenshots, and HAR files.</p>
        pub fn artifact_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_s3_location = Some(input.into());
            self
        }
        /// <p>The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include the log file, screenshots, and HAR files.</p>
        pub fn set_artifact_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_s3_location = input;
            self
        }
        /// <p>The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources and Conditions for Lambda Actions</a>.</p>
        pub fn engine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources and Conditions for Lambda Actions</a>.</p>
        pub fn set_engine_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_arn = input;
            self
        }
        /// <p>Specifies the runtime version to use for the canary. For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
        pub fn runtime_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_version = Some(input.into());
            self
        }
        /// <p>Specifies the runtime version to use for the canary. For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
        pub fn set_runtime_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.runtime_version = input;
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"> Running a Canary in a VPC</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigOutput) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"> Running a Canary in a VPC</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigOutput>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.</p>
        pub fn visual_reference(mut self, input: crate::model::VisualReferenceOutput) -> Self {
            self.visual_reference = Some(input);
            self
        }
        /// <p>If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.</p>
        pub fn set_visual_reference(
            mut self,
            input: std::option::Option<crate::model::VisualReferenceOutput>,
        ) -> Self {
            self.visual_reference = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs that are associated with the canary.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of key-value pairs that are associated with the canary.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
        pub fn artifact_config(mut self, input: crate::model::ArtifactConfigOutput) -> Self {
            self.artifact_config = Some(input);
            self
        }
        /// <p>A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
        pub fn set_artifact_config(
            mut self,
            input: std::option::Option<crate::model::ArtifactConfigOutput>,
        ) -> Self {
            self.artifact_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Canary`](crate::model::Canary)
        pub fn build(self) -> crate::model::Canary {
            crate::model::Canary {
                id: self.id,
                name: self.name,
                code: self.code,
                execution_role_arn: self.execution_role_arn,
                schedule: self.schedule,
                run_config: self.run_config,
                success_retention_period_in_days: self.success_retention_period_in_days,
                failure_retention_period_in_days: self.failure_retention_period_in_days,
                status: self.status,
                timeline: self.timeline,
                artifact_s3_location: self.artifact_s3_location,
                engine_arn: self.engine_arn,
                runtime_version: self.runtime_version,
                vpc_config: self.vpc_config,
                visual_reference: self.visual_reference,
                tags: self.tags,
                artifact_config: self.artifact_config,
            }
        }
    }
}
impl Canary {
    /// Creates a new builder-style object to manufacture [`Canary`](crate::model::Canary)
    pub fn builder() -> crate::model::canary::Builder {
        crate::model::canary::Builder::default()
    }
}

/// <p>A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactConfigOutput {
    /// <p>A structure that contains the configuration of encryption settings for canary artifacts that are stored in Amazon S3. </p>
    pub s3_encryption: std::option::Option<crate::model::S3EncryptionConfig>,
}
impl ArtifactConfigOutput {
    /// <p>A structure that contains the configuration of encryption settings for canary artifacts that are stored in Amazon S3. </p>
    pub fn s3_encryption(&self) -> std::option::Option<&crate::model::S3EncryptionConfig> {
        self.s3_encryption.as_ref()
    }
}
impl std::fmt::Debug for ArtifactConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactConfigOutput");
        formatter.field("s3_encryption", &self.s3_encryption);
        formatter.finish()
    }
}
/// See [`ArtifactConfigOutput`](crate::model::ArtifactConfigOutput)
pub mod artifact_config_output {
    /// A builder for [`ArtifactConfigOutput`](crate::model::ArtifactConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_encryption: std::option::Option<crate::model::S3EncryptionConfig>,
    }
    impl Builder {
        /// <p>A structure that contains the configuration of encryption settings for canary artifacts that are stored in Amazon S3. </p>
        pub fn s3_encryption(mut self, input: crate::model::S3EncryptionConfig) -> Self {
            self.s3_encryption = Some(input);
            self
        }
        /// <p>A structure that contains the configuration of encryption settings for canary artifacts that are stored in Amazon S3. </p>
        pub fn set_s3_encryption(
            mut self,
            input: std::option::Option<crate::model::S3EncryptionConfig>,
        ) -> Self {
            self.s3_encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactConfigOutput`](crate::model::ArtifactConfigOutput)
        pub fn build(self) -> crate::model::ArtifactConfigOutput {
            crate::model::ArtifactConfigOutput {
                s3_encryption: self.s3_encryption,
            }
        }
    }
}
impl ArtifactConfigOutput {
    /// Creates a new builder-style object to manufacture [`ArtifactConfigOutput`](crate::model::ArtifactConfigOutput)
    pub fn builder() -> crate::model::artifact_config_output::Builder {
        crate::model::artifact_config_output::Builder::default()
    }
}

/// <p>If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run that is used as the baseline for screenshots, and the coordinates of any parts of those screenshots that are ignored during visual monitoring comparison.</p>
/// <p>Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b> runtime or later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VisualReferenceOutput {
    /// <p>An array of screenshots that are used as the baseline for comparisons during visual monitoring.</p>
    pub base_screenshots: std::option::Option<std::vec::Vec<crate::model::BaseScreenshot>>,
    /// <p>The ID of the canary run that produced the screenshots that are used as the baseline for visual monitoring comparisons during future runs of this canary.</p>
    pub base_canary_run_id: std::option::Option<std::string::String>,
}
impl VisualReferenceOutput {
    /// <p>An array of screenshots that are used as the baseline for comparisons during visual monitoring.</p>
    pub fn base_screenshots(&self) -> std::option::Option<&[crate::model::BaseScreenshot]> {
        self.base_screenshots.as_deref()
    }
    /// <p>The ID of the canary run that produced the screenshots that are used as the baseline for visual monitoring comparisons during future runs of this canary.</p>
    pub fn base_canary_run_id(&self) -> std::option::Option<&str> {
        self.base_canary_run_id.as_deref()
    }
}
impl std::fmt::Debug for VisualReferenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VisualReferenceOutput");
        formatter.field("base_screenshots", &self.base_screenshots);
        formatter.field("base_canary_run_id", &self.base_canary_run_id);
        formatter.finish()
    }
}
/// See [`VisualReferenceOutput`](crate::model::VisualReferenceOutput)
pub mod visual_reference_output {
    /// A builder for [`VisualReferenceOutput`](crate::model::VisualReferenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_screenshots:
            std::option::Option<std::vec::Vec<crate::model::BaseScreenshot>>,
        pub(crate) base_canary_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `base_screenshots`.
        ///
        /// To override the contents of this collection use [`set_base_screenshots`](Self::set_base_screenshots).
        ///
        /// <p>An array of screenshots that are used as the baseline for comparisons during visual monitoring.</p>
        pub fn base_screenshots(mut self, input: crate::model::BaseScreenshot) -> Self {
            let mut v = self.base_screenshots.unwrap_or_default();
            v.push(input);
            self.base_screenshots = Some(v);
            self
        }
        /// <p>An array of screenshots that are used as the baseline for comparisons during visual monitoring.</p>
        pub fn set_base_screenshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BaseScreenshot>>,
        ) -> Self {
            self.base_screenshots = input;
            self
        }
        /// <p>The ID of the canary run that produced the screenshots that are used as the baseline for visual monitoring comparisons during future runs of this canary.</p>
        pub fn base_canary_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_canary_run_id = Some(input.into());
            self
        }
        /// <p>The ID of the canary run that produced the screenshots that are used as the baseline for visual monitoring comparisons during future runs of this canary.</p>
        pub fn set_base_canary_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_canary_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VisualReferenceOutput`](crate::model::VisualReferenceOutput)
        pub fn build(self) -> crate::model::VisualReferenceOutput {
            crate::model::VisualReferenceOutput {
                base_screenshots: self.base_screenshots,
                base_canary_run_id: self.base_canary_run_id,
            }
        }
    }
}
impl VisualReferenceOutput {
    /// Creates a new builder-style object to manufacture [`VisualReferenceOutput`](crate::model::VisualReferenceOutput)
    pub fn builder() -> crate::model::visual_reference_output::Builder {
        crate::model::visual_reference_output::Builder::default()
    }
}

/// <p>If this canary is to test an endpoint in a VPC, this structure contains information about the subnets and security groups of the VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"> Running a Canary in a VPC</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfigOutput {
    /// <p>The IDs of the VPC where this canary is to run.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the subnets where this canary is to run.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the security groups for this canary.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfigOutput {
    /// <p>The IDs of the VPC where this canary is to run.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The IDs of the subnets where this canary is to run.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The IDs of the security groups for this canary.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfigOutput");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcConfigOutput`](crate::model::VpcConfigOutput)
pub mod vpc_config_output {
    /// A builder for [`VpcConfigOutput`](crate::model::VpcConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The IDs of the VPC where this canary is to run.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The IDs of the VPC where this canary is to run.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets where this canary is to run.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The IDs of the subnets where this canary is to run.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups for this canary.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of the security groups for this canary.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfigOutput`](crate::model::VpcConfigOutput)
        pub fn build(self) -> crate::model::VpcConfigOutput {
            crate::model::VpcConfigOutput {
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcConfigOutput {
    /// Creates a new builder-style object to manufacture [`VpcConfigOutput`](crate::model::VpcConfigOutput)
    pub fn builder() -> crate::model::vpc_config_output::Builder {
        crate::model::vpc_config_output::Builder::default()
    }
}

/// <p>This structure contains information about when the canary was created and modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryTimeline {
    /// <p>The date and time the canary was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the canary was most recently modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the canary's most recent run started.</p>
    pub last_started: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the canary's most recent run ended.</p>
    pub last_stopped: std::option::Option<aws_smithy_types::DateTime>,
}
impl CanaryTimeline {
    /// <p>The date and time the canary was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The date and time the canary was most recently modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The date and time that the canary's most recent run started.</p>
    pub fn last_started(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_started.as_ref()
    }
    /// <p>The date and time that the canary's most recent run ended.</p>
    pub fn last_stopped(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_stopped.as_ref()
    }
}
impl std::fmt::Debug for CanaryTimeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryTimeline");
        formatter.field("created", &self.created);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("last_started", &self.last_started);
        formatter.field("last_stopped", &self.last_stopped);
        formatter.finish()
    }
}
/// See [`CanaryTimeline`](crate::model::CanaryTimeline)
pub mod canary_timeline {
    /// A builder for [`CanaryTimeline`](crate::model::CanaryTimeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_started: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_stopped: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time the canary was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time the canary was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time the canary was most recently modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time the canary was most recently modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The date and time that the canary's most recent run started.</p>
        pub fn last_started(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_started = Some(input);
            self
        }
        /// <p>The date and time that the canary's most recent run started.</p>
        pub fn set_last_started(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_started = input;
            self
        }
        /// <p>The date and time that the canary's most recent run ended.</p>
        pub fn last_stopped(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_stopped = Some(input);
            self
        }
        /// <p>The date and time that the canary's most recent run ended.</p>
        pub fn set_last_stopped(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_stopped = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryTimeline`](crate::model::CanaryTimeline)
        pub fn build(self) -> crate::model::CanaryTimeline {
            crate::model::CanaryTimeline {
                created: self.created,
                last_modified: self.last_modified,
                last_started: self.last_started,
                last_stopped: self.last_stopped,
            }
        }
    }
}
impl CanaryTimeline {
    /// Creates a new builder-style object to manufacture [`CanaryTimeline`](crate::model::CanaryTimeline)
    pub fn builder() -> crate::model::canary_timeline::Builder {
        crate::model::canary_timeline::Builder::default()
    }
}

/// <p>A structure that contains the current state of the canary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryStatus {
    /// <p>The current state of the canary.</p>
    pub state: std::option::Option<crate::model::CanaryState>,
    /// <p>If the canary has insufficient permissions to run, this field provides more details.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>If the canary cannot run or has failed, this field displays the reason.</p>
    pub state_reason_code: std::option::Option<crate::model::CanaryStateReasonCode>,
}
impl CanaryStatus {
    /// <p>The current state of the canary.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CanaryState> {
        self.state.as_ref()
    }
    /// <p>If the canary has insufficient permissions to run, this field provides more details.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>If the canary cannot run or has failed, this field displays the reason.</p>
    pub fn state_reason_code(&self) -> std::option::Option<&crate::model::CanaryStateReasonCode> {
        self.state_reason_code.as_ref()
    }
}
impl std::fmt::Debug for CanaryStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryStatus");
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.finish()
    }
}
/// See [`CanaryStatus`](crate::model::CanaryStatus)
pub mod canary_status {
    /// A builder for [`CanaryStatus`](crate::model::CanaryStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::CanaryState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::CanaryStateReasonCode>,
    }
    impl Builder {
        /// <p>The current state of the canary.</p>
        pub fn state(mut self, input: crate::model::CanaryState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the canary.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::CanaryState>) -> Self {
            self.state = input;
            self
        }
        /// <p>If the canary has insufficient permissions to run, this field provides more details.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>If the canary has insufficient permissions to run, this field provides more details.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>If the canary cannot run or has failed, this field displays the reason.</p>
        pub fn state_reason_code(mut self, input: crate::model::CanaryStateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>If the canary cannot run or has failed, this field displays the reason.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::CanaryStateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryStatus`](crate::model::CanaryStatus)
        pub fn build(self) -> crate::model::CanaryStatus {
            crate::model::CanaryStatus {
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
            }
        }
    }
}
impl CanaryStatus {
    /// Creates a new builder-style object to manufacture [`CanaryStatus`](crate::model::CanaryStatus)
    pub fn builder() -> crate::model::canary_status::Builder {
        crate::model::canary_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CanaryStateReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    InvalidPermissions,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CanaryStateReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "INVALID_PERMISSIONS" => CanaryStateReasonCode::InvalidPermissions,
            other => CanaryStateReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CanaryStateReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CanaryStateReasonCode::from(s))
    }
}
impl CanaryStateReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CanaryStateReasonCode::InvalidPermissions => "INVALID_PERMISSIONS",
            CanaryStateReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INVALID_PERMISSIONS"]
    }
}
impl AsRef<str> for CanaryStateReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CanaryState {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CanaryState {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => CanaryState::Creating,
            "DELETING" => CanaryState::Deleting,
            "ERROR" => CanaryState::Error,
            "READY" => CanaryState::Ready,
            "RUNNING" => CanaryState::Running,
            "STARTING" => CanaryState::Starting,
            "STOPPED" => CanaryState::Stopped,
            "STOPPING" => CanaryState::Stopping,
            "UPDATING" => CanaryState::Updating,
            other => CanaryState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CanaryState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CanaryState::from(s))
    }
}
impl CanaryState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CanaryState::Creating => "CREATING",
            CanaryState::Deleting => "DELETING",
            CanaryState::Error => "ERROR",
            CanaryState::Ready => "READY",
            CanaryState::Running => "RUNNING",
            CanaryState::Starting => "STARTING",
            CanaryState::Stopped => "STOPPED",
            CanaryState::Stopping => "STOPPING",
            CanaryState::Updating => "UPDATING",
            CanaryState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATING", "DELETING", "ERROR", "READY", "RUNNING", "STARTING", "STOPPED", "STOPPING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for CanaryState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains information about a canary run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryRunConfigOutput {
    /// <p>How long the canary is allowed to run before it must stop.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
    pub memory_in_mb: std::option::Option<i32>,
    /// <p>Displays whether this canary run used active X-Ray tracing. </p>
    pub active_tracing: std::option::Option<bool>,
}
impl CanaryRunConfigOutput {
    /// <p>How long the canary is allowed to run before it must stop.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.timeout_in_seconds
    }
    /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
    pub fn memory_in_mb(&self) -> std::option::Option<i32> {
        self.memory_in_mb
    }
    /// <p>Displays whether this canary run used active X-Ray tracing. </p>
    pub fn active_tracing(&self) -> std::option::Option<bool> {
        self.active_tracing
    }
}
impl std::fmt::Debug for CanaryRunConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryRunConfigOutput");
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("memory_in_mb", &self.memory_in_mb);
        formatter.field("active_tracing", &self.active_tracing);
        formatter.finish()
    }
}
/// See [`CanaryRunConfigOutput`](crate::model::CanaryRunConfigOutput)
pub mod canary_run_config_output {
    /// A builder for [`CanaryRunConfigOutput`](crate::model::CanaryRunConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) memory_in_mb: std::option::Option<i32>,
        pub(crate) active_tracing: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>How long the canary is allowed to run before it must stop.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>How long the canary is allowed to run before it must stop.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
        pub fn memory_in_mb(mut self, input: i32) -> Self {
            self.memory_in_mb = Some(input);
            self
        }
        /// <p>The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of 64.</p>
        pub fn set_memory_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_in_mb = input;
            self
        }
        /// <p>Displays whether this canary run used active X-Ray tracing. </p>
        pub fn active_tracing(mut self, input: bool) -> Self {
            self.active_tracing = Some(input);
            self
        }
        /// <p>Displays whether this canary run used active X-Ray tracing. </p>
        pub fn set_active_tracing(mut self, input: std::option::Option<bool>) -> Self {
            self.active_tracing = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryRunConfigOutput`](crate::model::CanaryRunConfigOutput)
        pub fn build(self) -> crate::model::CanaryRunConfigOutput {
            crate::model::CanaryRunConfigOutput {
                timeout_in_seconds: self.timeout_in_seconds,
                memory_in_mb: self.memory_in_mb,
                active_tracing: self.active_tracing,
            }
        }
    }
}
impl CanaryRunConfigOutput {
    /// Creates a new builder-style object to manufacture [`CanaryRunConfigOutput`](crate::model::CanaryRunConfigOutput)
    pub fn builder() -> crate::model::canary_run_config_output::Builder {
        crate::model::canary_run_config_output::Builder::default()
    }
}

/// <p>How long, in seconds, for the canary to continue making regular runs according to the schedule in the <code>Expression</code> value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryScheduleOutput {
    /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
    /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
    /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
    /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
    /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>How long, in seconds, for the canary to continue making regular runs after it was created. The runs are performed according to the schedule in the <code>Expression</code> value.</p>
    pub duration_in_seconds: std::option::Option<i64>,
}
impl CanaryScheduleOutput {
    /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
    /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
    /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
    /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
    /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>How long, in seconds, for the canary to continue making regular runs after it was created. The runs are performed according to the schedule in the <code>Expression</code> value.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i64> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for CanaryScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryScheduleOutput");
        formatter.field("expression", &self.expression);
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`CanaryScheduleOutput`](crate::model::CanaryScheduleOutput)
pub mod canary_schedule_output {
    /// A builder for [`CanaryScheduleOutput`](crate::model::CanaryScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) duration_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
        /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
        /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
        /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
        /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.</p>
        /// <p>For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or <code>hour</code>. </p>
        /// <p>For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.</p>
        /// <p>Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.</p>
        /// <p>Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"> Scheduling canary runs using cron</a>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>How long, in seconds, for the canary to continue making regular runs after it was created. The runs are performed according to the schedule in the <code>Expression</code> value.</p>
        pub fn duration_in_seconds(mut self, input: i64) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>How long, in seconds, for the canary to continue making regular runs after it was created. The runs are performed according to the schedule in the <code>Expression</code> value.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryScheduleOutput`](crate::model::CanaryScheduleOutput)
        pub fn build(self) -> crate::model::CanaryScheduleOutput {
            crate::model::CanaryScheduleOutput {
                expression: self.expression,
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl CanaryScheduleOutput {
    /// Creates a new builder-style object to manufacture [`CanaryScheduleOutput`](crate::model::CanaryScheduleOutput)
    pub fn builder() -> crate::model::canary_schedule_output::Builder {
        crate::model::canary_schedule_output::Builder::default()
    }
}

/// <p>This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch Synthetics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryCodeOutput {
    /// <p>The ARN of the Lambda layer where Synthetics stores the canary script code.</p>
    pub source_location_arn: std::option::Option<std::string::String>,
    /// <p>The entry point to use for the source code when running the canary.</p>
    pub handler: std::option::Option<std::string::String>,
}
impl CanaryCodeOutput {
    /// <p>The ARN of the Lambda layer where Synthetics stores the canary script code.</p>
    pub fn source_location_arn(&self) -> std::option::Option<&str> {
        self.source_location_arn.as_deref()
    }
    /// <p>The entry point to use for the source code when running the canary.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
}
impl std::fmt::Debug for CanaryCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryCodeOutput");
        formatter.field("source_location_arn", &self.source_location_arn);
        formatter.field("handler", &self.handler);
        formatter.finish()
    }
}
/// See [`CanaryCodeOutput`](crate::model::CanaryCodeOutput)
pub mod canary_code_output {
    /// A builder for [`CanaryCodeOutput`](crate::model::CanaryCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_location_arn: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Lambda layer where Synthetics stores the canary script code.</p>
        pub fn source_location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_location_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda layer where Synthetics stores the canary script code.</p>
        pub fn set_source_location_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_location_arn = input;
            self
        }
        /// <p>The entry point to use for the source code when running the canary.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The entry point to use for the source code when running the canary.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryCodeOutput`](crate::model::CanaryCodeOutput)
        pub fn build(self) -> crate::model::CanaryCodeOutput {
            crate::model::CanaryCodeOutput {
                source_location_arn: self.source_location_arn,
                handler: self.handler,
            }
        }
    }
}
impl CanaryCodeOutput {
    /// Creates a new builder-style object to manufacture [`CanaryCodeOutput`](crate::model::CanaryCodeOutput)
    pub fn builder() -> crate::model::canary_code_output::Builder {
        crate::model::canary_code_output::Builder::default()
    }
}

/// <p>This structure contains information about one canary runtime version. For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuntimeVersion {
    /// <p>The name of the runtime version. For a list of valid runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
    pub version_name: std::option::Option<std::string::String>,
    /// <p>A description of the runtime version, created by Amazon.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the runtime version was released.</p>
    pub release_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If this runtime version is deprecated, this value is the date of deprecation.</p>
    pub deprecation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl RuntimeVersion {
    /// <p>The name of the runtime version. For a list of valid runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
    pub fn version_name(&self) -> std::option::Option<&str> {
        self.version_name.as_deref()
    }
    /// <p>A description of the runtime version, created by Amazon.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the runtime version was released.</p>
    pub fn release_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.release_date.as_ref()
    }
    /// <p>If this runtime version is deprecated, this value is the date of deprecation.</p>
    pub fn deprecation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deprecation_date.as_ref()
    }
}
impl std::fmt::Debug for RuntimeVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuntimeVersion");
        formatter.field("version_name", &self.version_name);
        formatter.field("description", &self.description);
        formatter.field("release_date", &self.release_date);
        formatter.field("deprecation_date", &self.deprecation_date);
        formatter.finish()
    }
}
/// See [`RuntimeVersion`](crate::model::RuntimeVersion)
pub mod runtime_version {
    /// A builder for [`RuntimeVersion`](crate::model::RuntimeVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) release_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deprecation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the runtime version. For a list of valid runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The name of the runtime version. For a list of valid runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"> Canary Runtime Versions</a>.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>A description of the runtime version, created by Amazon.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the runtime version, created by Amazon.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the runtime version was released.</p>
        pub fn release_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.release_date = Some(input);
            self
        }
        /// <p>The date that the runtime version was released.</p>
        pub fn set_release_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.release_date = input;
            self
        }
        /// <p>If this runtime version is deprecated, this value is the date of deprecation.</p>
        pub fn deprecation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deprecation_date = Some(input);
            self
        }
        /// <p>If this runtime version is deprecated, this value is the date of deprecation.</p>
        pub fn set_deprecation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deprecation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`RuntimeVersion`](crate::model::RuntimeVersion)
        pub fn build(self) -> crate::model::RuntimeVersion {
            crate::model::RuntimeVersion {
                version_name: self.version_name,
                description: self.description,
                release_date: self.release_date,
                deprecation_date: self.deprecation_date,
            }
        }
    }
}
impl RuntimeVersion {
    /// Creates a new builder-style object to manufacture [`RuntimeVersion`](crate::model::RuntimeVersion)
    pub fn builder() -> crate::model::runtime_version::Builder {
        crate::model::runtime_version::Builder::default()
    }
}

/// <p>This structure contains information about the most recent run of a single canary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanaryLastRun {
    /// <p>The name of the canary.</p>
    pub canary_name: std::option::Option<std::string::String>,
    /// <p>The results from this canary's most recent run.</p>
    pub last_run: std::option::Option<crate::model::CanaryRun>,
}
impl CanaryLastRun {
    /// <p>The name of the canary.</p>
    pub fn canary_name(&self) -> std::option::Option<&str> {
        self.canary_name.as_deref()
    }
    /// <p>The results from this canary's most recent run.</p>
    pub fn last_run(&self) -> std::option::Option<&crate::model::CanaryRun> {
        self.last_run.as_ref()
    }
}
impl std::fmt::Debug for CanaryLastRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanaryLastRun");
        formatter.field("canary_name", &self.canary_name);
        formatter.field("last_run", &self.last_run);
        formatter.finish()
    }
}
/// See [`CanaryLastRun`](crate::model::CanaryLastRun)
pub mod canary_last_run {
    /// A builder for [`CanaryLastRun`](crate::model::CanaryLastRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) canary_name: std::option::Option<std::string::String>,
        pub(crate) last_run: std::option::Option<crate::model::CanaryRun>,
    }
    impl Builder {
        /// <p>The name of the canary.</p>
        pub fn canary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.canary_name = Some(input.into());
            self
        }
        /// <p>The name of the canary.</p>
        pub fn set_canary_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.canary_name = input;
            self
        }
        /// <p>The results from this canary's most recent run.</p>
        pub fn last_run(mut self, input: crate::model::CanaryRun) -> Self {
            self.last_run = Some(input);
            self
        }
        /// <p>The results from this canary's most recent run.</p>
        pub fn set_last_run(mut self, input: std::option::Option<crate::model::CanaryRun>) -> Self {
            self.last_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CanaryLastRun`](crate::model::CanaryLastRun)
        pub fn build(self) -> crate::model::CanaryLastRun {
            crate::model::CanaryLastRun {
                canary_name: self.canary_name,
                last_run: self.last_run,
            }
        }
    }
}
impl CanaryLastRun {
    /// Creates a new builder-style object to manufacture [`CanaryLastRun`](crate::model::CanaryLastRun)
    pub fn builder() -> crate::model::canary_last_run::Builder {
        crate::model::canary_last_run::Builder::default()
    }
}
