// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Simple Workflow Service
///
/// Client for invoking operations on Amazon Simple Workflow Service. Each operation on Amazon Simple Workflow Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_swf::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_swf::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_swf::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CountClosedWorkflowExecutions`](crate::client::fluent_builders::CountClosedWorkflowExecutions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::set_domain): <p>The name of the domain containing the workflow executions to count.</p>
    ///   - [`start_time_filter(ExecutionTimeFilter)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::start_time_filter) / [`set_start_time_filter(Option<ExecutionTimeFilter>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::set_start_time_filter): <p>If specified, only workflow executions that meet the start time criteria of the filter are counted.</p> <note>   <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>  </note>
    ///   - [`close_time_filter(ExecutionTimeFilter)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::close_time_filter) / [`set_close_time_filter(Option<ExecutionTimeFilter>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::set_close_time_filter): <p>If specified, only workflow executions that meet the close time criteria of the filter are counted.</p> <note>   <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>  </note>
    ///   - [`execution_filter(WorkflowExecutionFilter)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::execution_filter) / [`set_execution_filter(Option<WorkflowExecutionFilter>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::set_execution_filter): <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`type_filter(WorkflowTypeFilter)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::type_filter) / [`set_type_filter(Option<WorkflowTypeFilter>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::set_type_filter): <p>If specified, indicates the type of the workflow executions to be counted.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`tag_filter(TagFilter)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::tag_filter) / [`set_tag_filter(Option<TagFilter>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::set_tag_filter): <p>If specified, only executions that have a tag that matches the filter are counted.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`close_status_filter(CloseStatusFilter)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::close_status_filter) / [`set_close_status_filter(Option<CloseStatusFilter>)`](crate::client::fluent_builders::CountClosedWorkflowExecutions::set_close_status_filter): <p>If specified, only workflow executions that match this close status are counted. This filter has an affect only if <code>executionStatus</code> is specified as <code>CLOSED</code>.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    /// - On success, responds with [`CountClosedWorkflowExecutionsOutput`](crate::output::CountClosedWorkflowExecutionsOutput) with field(s):
    ///   - [`count(i32)`](crate::output::CountClosedWorkflowExecutionsOutput::count): <p>The number of workflow executions.</p>
    ///   - [`truncated(bool)`](crate::output::CountClosedWorkflowExecutionsOutput::truncated): <p>If set to true, indicates that the actual count was more than the maximum supported by this API and the count returned is the truncated value.</p>
    /// - On failure, responds with [`SdkError<CountClosedWorkflowExecutionsError>`](crate::error::CountClosedWorkflowExecutionsError)
    pub fn count_closed_workflow_executions(
        &self,
    ) -> fluent_builders::CountClosedWorkflowExecutions {
        fluent_builders::CountClosedWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CountOpenWorkflowExecutions`](crate::client::fluent_builders::CountOpenWorkflowExecutions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::set_domain): <p>The name of the domain containing the workflow executions to count.</p>
    ///   - [`start_time_filter(ExecutionTimeFilter)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::start_time_filter) / [`set_start_time_filter(Option<ExecutionTimeFilter>)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::set_start_time_filter): <p>Specifies the start time criteria that workflow executions must meet in order to be counted.</p>
    ///   - [`type_filter(WorkflowTypeFilter)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::type_filter) / [`set_type_filter(Option<WorkflowTypeFilter>)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::set_type_filter): <p>Specifies the type of the workflow executions to be counted.</p> <note>   <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`tag_filter(TagFilter)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::tag_filter) / [`set_tag_filter(Option<TagFilter>)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::set_tag_filter): <p>If specified, only executions that have a tag that matches the filter are counted.</p> <note>   <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`execution_filter(WorkflowExecutionFilter)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::execution_filter) / [`set_execution_filter(Option<WorkflowExecutionFilter>)`](crate::client::fluent_builders::CountOpenWorkflowExecutions::set_execution_filter): <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.</p> <note>   <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    /// - On success, responds with [`CountOpenWorkflowExecutionsOutput`](crate::output::CountOpenWorkflowExecutionsOutput) with field(s):
    ///   - [`count(i32)`](crate::output::CountOpenWorkflowExecutionsOutput::count): <p>The number of workflow executions.</p>
    ///   - [`truncated(bool)`](crate::output::CountOpenWorkflowExecutionsOutput::truncated): <p>If set to true, indicates that the actual count was more than the maximum supported by this API and the count returned is the truncated value.</p>
    /// - On failure, responds with [`SdkError<CountOpenWorkflowExecutionsError>`](crate::error::CountOpenWorkflowExecutionsError)
    pub fn count_open_workflow_executions(&self) -> fluent_builders::CountOpenWorkflowExecutions {
        fluent_builders::CountOpenWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CountPendingActivityTasks`](crate::client::fluent_builders::CountPendingActivityTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CountPendingActivityTasks::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CountPendingActivityTasks::set_domain): <p>The name of the domain that contains the task list.</p>
    ///   - [`task_list(TaskList)`](crate::client::fluent_builders::CountPendingActivityTasks::task_list) / [`set_task_list(Option<TaskList>)`](crate::client::fluent_builders::CountPendingActivityTasks::set_task_list): <p>The name of the task list.</p>
    /// - On success, responds with [`CountPendingActivityTasksOutput`](crate::output::CountPendingActivityTasksOutput) with field(s):
    ///   - [`count(i32)`](crate::output::CountPendingActivityTasksOutput::count): <p>The number of tasks in the task list.</p>
    ///   - [`truncated(bool)`](crate::output::CountPendingActivityTasksOutput::truncated): <p>If set to true, indicates that the actual count was more than the maximum supported by this API and the count returned is the truncated value.</p>
    /// - On failure, responds with [`SdkError<CountPendingActivityTasksError>`](crate::error::CountPendingActivityTasksError)
    pub fn count_pending_activity_tasks(&self) -> fluent_builders::CountPendingActivityTasks {
        fluent_builders::CountPendingActivityTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CountPendingDecisionTasks`](crate::client::fluent_builders::CountPendingDecisionTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CountPendingDecisionTasks::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CountPendingDecisionTasks::set_domain): <p>The name of the domain that contains the task list.</p>
    ///   - [`task_list(TaskList)`](crate::client::fluent_builders::CountPendingDecisionTasks::task_list) / [`set_task_list(Option<TaskList>)`](crate::client::fluent_builders::CountPendingDecisionTasks::set_task_list): <p>The name of the task list.</p>
    /// - On success, responds with [`CountPendingDecisionTasksOutput`](crate::output::CountPendingDecisionTasksOutput) with field(s):
    ///   - [`count(i32)`](crate::output::CountPendingDecisionTasksOutput::count): <p>The number of tasks in the task list.</p>
    ///   - [`truncated(bool)`](crate::output::CountPendingDecisionTasksOutput::truncated): <p>If set to true, indicates that the actual count was more than the maximum supported by this API and the count returned is the truncated value.</p>
    /// - On failure, responds with [`SdkError<CountPendingDecisionTasksError>`](crate::error::CountPendingDecisionTasksError)
    pub fn count_pending_decision_tasks(&self) -> fluent_builders::CountPendingDecisionTasks {
        fluent_builders::CountPendingDecisionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprecateActivityType`](crate::client::fluent_builders::DeprecateActivityType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeprecateActivityType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeprecateActivityType::set_domain): <p>The name of the domain in which the activity type is registered.</p>
    ///   - [`activity_type(ActivityType)`](crate::client::fluent_builders::DeprecateActivityType::activity_type) / [`set_activity_type(Option<ActivityType>)`](crate::client::fluent_builders::DeprecateActivityType::set_activity_type): <p>The activity type to deprecate.</p>
    /// - On success, responds with [`DeprecateActivityTypeOutput`](crate::output::DeprecateActivityTypeOutput)

    /// - On failure, responds with [`SdkError<DeprecateActivityTypeError>`](crate::error::DeprecateActivityTypeError)
    pub fn deprecate_activity_type(&self) -> fluent_builders::DeprecateActivityType {
        fluent_builders::DeprecateActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprecateDomain`](crate::client::fluent_builders::DeprecateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeprecateDomain::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeprecateDomain::set_name): <p>The name of the domain to deprecate.</p>
    /// - On success, responds with [`DeprecateDomainOutput`](crate::output::DeprecateDomainOutput)

    /// - On failure, responds with [`SdkError<DeprecateDomainError>`](crate::error::DeprecateDomainError)
    pub fn deprecate_domain(&self) -> fluent_builders::DeprecateDomain {
        fluent_builders::DeprecateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprecateWorkflowType`](crate::client::fluent_builders::DeprecateWorkflowType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeprecateWorkflowType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeprecateWorkflowType::set_domain): <p>The name of the domain in which the workflow type is registered.</p>
    ///   - [`workflow_type(WorkflowType)`](crate::client::fluent_builders::DeprecateWorkflowType::workflow_type) / [`set_workflow_type(Option<WorkflowType>)`](crate::client::fluent_builders::DeprecateWorkflowType::set_workflow_type): <p>The workflow type to deprecate.</p>
    /// - On success, responds with [`DeprecateWorkflowTypeOutput`](crate::output::DeprecateWorkflowTypeOutput)

    /// - On failure, responds with [`SdkError<DeprecateWorkflowTypeError>`](crate::error::DeprecateWorkflowTypeError)
    pub fn deprecate_workflow_type(&self) -> fluent_builders::DeprecateWorkflowType {
        fluent_builders::DeprecateWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeActivityType`](crate::client::fluent_builders::DescribeActivityType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DescribeActivityType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DescribeActivityType::set_domain): <p>The name of the domain in which the activity type is registered.</p>
    ///   - [`activity_type(ActivityType)`](crate::client::fluent_builders::DescribeActivityType::activity_type) / [`set_activity_type(Option<ActivityType>)`](crate::client::fluent_builders::DescribeActivityType::set_activity_type): <p>The activity type to get information about. Activity types are identified by the <code>name</code> and <code>version</code> that were supplied when the activity was registered.</p>
    /// - On success, responds with [`DescribeActivityTypeOutput`](crate::output::DescribeActivityTypeOutput) with field(s):
    ///   - [`type_info(Option<ActivityTypeInfo>)`](crate::output::DescribeActivityTypeOutput::type_info): <p>General information about the activity type.</p>  <p>The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.</p>  <ul>   <li> <p> <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be running. </p> </li>   <li> <p> <code>DEPRECATED</code> – The type was deprecated using <code>DeprecateActivityType</code>, but is still in use. You should keep workers supporting this type running. You cannot create new tasks of this type. </p> </li>  </ul>
    ///   - [`configuration(Option<ActivityTypeConfiguration>)`](crate::output::DescribeActivityTypeOutput::configuration): <p>The configuration settings registered with the activity type.</p>
    /// - On failure, responds with [`SdkError<DescribeActivityTypeError>`](crate::error::DescribeActivityTypeError)
    pub fn describe_activity_type(&self) -> fluent_builders::DescribeActivityType {
        fluent_builders::DescribeActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomain::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeDomain::set_name): <p>The name of the domain to describe.</p>
    /// - On success, responds with [`DescribeDomainOutput`](crate::output::DescribeDomainOutput) with field(s):
    ///   - [`domain_info(Option<DomainInfo>)`](crate::output::DescribeDomainOutput::domain_info): <p>The basic information about a domain, such as its name, status, and description.</p>
    ///   - [`configuration(Option<DomainConfiguration>)`](crate::output::DescribeDomainOutput::configuration): <p>The domain configuration. Currently, this includes only the domain's retention period.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainError>`](crate::error::DescribeDomainError)
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkflowExecution`](crate::client::fluent_builders::DescribeWorkflowExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkflowExecution::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DescribeWorkflowExecution::set_domain): <p>The name of the domain containing the workflow execution.</p>
    ///   - [`execution(WorkflowExecution)`](crate::client::fluent_builders::DescribeWorkflowExecution::execution) / [`set_execution(Option<WorkflowExecution>)`](crate::client::fluent_builders::DescribeWorkflowExecution::set_execution): <p>The workflow execution to describe.</p>
    /// - On success, responds with [`DescribeWorkflowExecutionOutput`](crate::output::DescribeWorkflowExecutionOutput) with field(s):
    ///   - [`execution_info(Option<WorkflowExecutionInfo>)`](crate::output::DescribeWorkflowExecutionOutput::execution_info): <p>Information about the workflow execution.</p>
    ///   - [`execution_configuration(Option<WorkflowExecutionConfiguration>)`](crate::output::DescribeWorkflowExecutionOutput::execution_configuration): <p>The configuration settings for this workflow execution including timeout values, tasklist etc.</p>
    ///   - [`open_counts(Option<WorkflowExecutionOpenCounts>)`](crate::output::DescribeWorkflowExecutionOutput::open_counts): <p>The number of tasks for this workflow execution. This includes open and closed tasks of all types.</p>
    ///   - [`latest_activity_task_timestamp(Option<DateTime>)`](crate::output::DescribeWorkflowExecutionOutput::latest_activity_task_timestamp): <p>The time when the last activity task was scheduled for this workflow execution. You can use this information to determine if the workflow has not made progress for an unusually long period of time and might require a corrective action.</p>
    ///   - [`latest_execution_context(Option<String>)`](crate::output::DescribeWorkflowExecutionOutput::latest_execution_context): <p>The latest executionContext provided by the decider for this workflow execution. A decider can provide an executionContext (a free-form string) when closing a decision task using <code>RespondDecisionTaskCompleted</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeWorkflowExecutionError>`](crate::error::DescribeWorkflowExecutionError)
    pub fn describe_workflow_execution(&self) -> fluent_builders::DescribeWorkflowExecution {
        fluent_builders::DescribeWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkflowType`](crate::client::fluent_builders::DescribeWorkflowType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkflowType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DescribeWorkflowType::set_domain): <p>The name of the domain in which this workflow type is registered.</p>
    ///   - [`workflow_type(WorkflowType)`](crate::client::fluent_builders::DescribeWorkflowType::workflow_type) / [`set_workflow_type(Option<WorkflowType>)`](crate::client::fluent_builders::DescribeWorkflowType::set_workflow_type): <p>The workflow type to describe.</p>
    /// - On success, responds with [`DescribeWorkflowTypeOutput`](crate::output::DescribeWorkflowTypeOutput) with field(s):
    ///   - [`type_info(Option<WorkflowTypeInfo>)`](crate::output::DescribeWorkflowTypeOutput::type_info): <p>General information about the workflow type.</p>  <p>The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.</p>  <ul>   <li> <p> <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be running.</p> </li>   <li> <p> <code>DEPRECATED</code> – The type was deprecated using <code>DeprecateWorkflowType</code>, but is still in use. You should keep workers supporting this type running. You cannot create new workflow executions of this type.</p> </li>  </ul>
    ///   - [`configuration(Option<WorkflowTypeConfiguration>)`](crate::output::DescribeWorkflowTypeOutput::configuration): <p>Configuration settings of the workflow type registered through <code>RegisterWorkflowType</code> </p>
    /// - On failure, responds with [`SdkError<DescribeWorkflowTypeError>`](crate::error::DescribeWorkflowTypeError)
    pub fn describe_workflow_type(&self) -> fluent_builders::DescribeWorkflowType {
        fluent_builders::DescribeWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWorkflowExecutionHistory`](crate::client::fluent_builders::GetWorkflowExecutionHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetWorkflowExecutionHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::set_domain): <p>The name of the domain containing the workflow execution.</p>
    ///   - [`execution(WorkflowExecution)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::execution) / [`set_execution(Option<WorkflowExecution>)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::set_execution): <p>Specifies the workflow execution for which to return the history.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::set_next_page_token): <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
    ///   - [`maximum_page_size(i32)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::maximum_page_size) / [`set_maximum_page_size(i32)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::set_maximum_page_size): <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::GetWorkflowExecutionHistory::set_reverse_order): <p>When set to <code>true</code>, returns the events in reverse order. By default the results are returned in ascending order of the <code>eventTimeStamp</code> of the events.</p>
    /// - On success, responds with [`GetWorkflowExecutionHistoryOutput`](crate::output::GetWorkflowExecutionHistoryOutput) with field(s):
    ///   - [`events(Option<Vec<HistoryEvent>>)`](crate::output::GetWorkflowExecutionHistoryOutput::events): <p>The list of history events.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetWorkflowExecutionHistoryOutput::next_page_token): <p>If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all other arguments unchanged.</p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.</p>
    /// - On failure, responds with [`SdkError<GetWorkflowExecutionHistoryError>`](crate::error::GetWorkflowExecutionHistoryError)
    pub fn get_workflow_execution_history(&self) -> fluent_builders::GetWorkflowExecutionHistory {
        fluent_builders::GetWorkflowExecutionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListActivityTypes`](crate::client::fluent_builders::ListActivityTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListActivityTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListActivityTypes::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListActivityTypes::set_domain): <p>The name of the domain in which the activity types have been registered.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListActivityTypes::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListActivityTypes::set_name): <p>If specified, only lists the activity types that have this name.</p>
    ///   - [`registration_status(RegistrationStatus)`](crate::client::fluent_builders::ListActivityTypes::registration_status) / [`set_registration_status(Option<RegistrationStatus>)`](crate::client::fluent_builders::ListActivityTypes::set_registration_status): <p>Specifies the registration status of the activity types to list.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::ListActivityTypes::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::ListActivityTypes::set_next_page_token): <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
    ///   - [`maximum_page_size(i32)`](crate::client::fluent_builders::ListActivityTypes::maximum_page_size) / [`set_maximum_page_size(i32)`](crate::client::fluent_builders::ListActivityTypes::set_maximum_page_size): <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::ListActivityTypes::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::ListActivityTypes::set_reverse_order): <p>When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by <code>name</code> of the activity types.</p>
    /// - On success, responds with [`ListActivityTypesOutput`](crate::output::ListActivityTypesOutput) with field(s):
    ///   - [`type_infos(Option<Vec<ActivityTypeInfo>>)`](crate::output::ListActivityTypesOutput::type_infos): <p>List of activity type information.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListActivityTypesOutput::next_page_token): <p>If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all other arguments unchanged.</p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.</p>
    /// - On failure, responds with [`SdkError<ListActivityTypesError>`](crate::error::ListActivityTypesError)
    pub fn list_activity_types(&self) -> fluent_builders::ListActivityTypes {
        fluent_builders::ListActivityTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClosedWorkflowExecutions`](crate::client::fluent_builders::ListClosedWorkflowExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListClosedWorkflowExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_domain): <p>The name of the domain that contains the workflow executions to list.</p>
    ///   - [`start_time_filter(ExecutionTimeFilter)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::start_time_filter) / [`set_start_time_filter(Option<ExecutionTimeFilter>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_start_time_filter): <p>If specified, the workflow executions are included in the returned results based on whether their start times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their start times.</p> <note>   <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>  </note>
    ///   - [`close_time_filter(ExecutionTimeFilter)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::close_time_filter) / [`set_close_time_filter(Option<ExecutionTimeFilter>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_close_time_filter): <p>If specified, the workflow executions are included in the returned results based on whether their close times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their close times.</p> <note>   <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>  </note>
    ///   - [`execution_filter(WorkflowExecutionFilter)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::execution_filter) / [`set_execution_filter(Option<WorkflowExecutionFilter>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_execution_filter): <p>If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`close_status_filter(CloseStatusFilter)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::close_status_filter) / [`set_close_status_filter(Option<CloseStatusFilter>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_close_status_filter): <p>If specified, only workflow executions that match this <i>close status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED workflow executions are listed.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`type_filter(WorkflowTypeFilter)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::type_filter) / [`set_type_filter(Option<WorkflowTypeFilter>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_type_filter): <p>If specified, only executions of the type specified in the filter are returned.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`tag_filter(TagFilter)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::tag_filter) / [`set_tag_filter(Option<TagFilter>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_tag_filter): <p>If specified, only executions that have the matching tag are listed.</p> <note>   <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_next_page_token): <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
    ///   - [`maximum_page_size(i32)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::maximum_page_size) / [`set_maximum_page_size(i32)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_maximum_page_size): <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::ListClosedWorkflowExecutions::set_reverse_order): <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in descending order of the start or the close time of the executions.</p>
    /// - On success, responds with [`ListClosedWorkflowExecutionsOutput`](crate::output::ListClosedWorkflowExecutionsOutput) with field(s):
    ///   - [`execution_infos(Option<Vec<WorkflowExecutionInfo>>)`](crate::output::ListClosedWorkflowExecutionsOutput::execution_infos): <p>The list of workflow information structures.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListClosedWorkflowExecutionsOutput::next_page_token): <p>If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all other arguments unchanged.</p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.</p>
    /// - On failure, responds with [`SdkError<ListClosedWorkflowExecutionsError>`](crate::error::ListClosedWorkflowExecutionsError)
    pub fn list_closed_workflow_executions(&self) -> fluent_builders::ListClosedWorkflowExecutions {
        fluent_builders::ListClosedWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomains`](crate::client::fluent_builders::ListDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::ListDomains::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::ListDomains::set_next_page_token): <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
    ///   - [`registration_status(RegistrationStatus)`](crate::client::fluent_builders::ListDomains::registration_status) / [`set_registration_status(Option<RegistrationStatus>)`](crate::client::fluent_builders::ListDomains::set_registration_status): <p>Specifies the registration status of the domains to list.</p>
    ///   - [`maximum_page_size(i32)`](crate::client::fluent_builders::ListDomains::maximum_page_size) / [`set_maximum_page_size(i32)`](crate::client::fluent_builders::ListDomains::set_maximum_page_size): <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::ListDomains::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::ListDomains::set_reverse_order): <p>When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by <code>name</code> of the domains.</p>
    /// - On success, responds with [`ListDomainsOutput`](crate::output::ListDomainsOutput) with field(s):
    ///   - [`domain_infos(Option<Vec<DomainInfo>>)`](crate::output::ListDomainsOutput::domain_infos): <p>A list of DomainInfo structures.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListDomainsOutput::next_page_token): <p>If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all other arguments unchanged.</p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.</p>
    /// - On failure, responds with [`SdkError<ListDomainsError>`](crate::error::ListDomainsError)
    pub fn list_domains(&self) -> fluent_builders::ListDomains {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOpenWorkflowExecutions`](crate::client::fluent_builders::ListOpenWorkflowExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOpenWorkflowExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_domain): <p>The name of the domain that contains the workflow executions to list.</p>
    ///   - [`start_time_filter(ExecutionTimeFilter)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::start_time_filter) / [`set_start_time_filter(Option<ExecutionTimeFilter>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_start_time_filter): <p>Workflow executions are included in the returned results based on whether their start times are within the range specified by this filter.</p>
    ///   - [`type_filter(WorkflowTypeFilter)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::type_filter) / [`set_type_filter(Option<WorkflowTypeFilter>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_type_filter): <p>If specified, only executions of the type specified in the filter are returned.</p> <note>   <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`tag_filter(TagFilter)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::tag_filter) / [`set_tag_filter(Option<TagFilter>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_tag_filter): <p>If specified, only executions that have the matching tag are listed.</p> <note>   <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_next_page_token): <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
    ///   - [`maximum_page_size(i32)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::maximum_page_size) / [`set_maximum_page_size(i32)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_maximum_page_size): <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_reverse_order): <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in descending order of the start time of the executions.</p>
    ///   - [`execution_filter(WorkflowExecutionFilter)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::execution_filter) / [`set_execution_filter(Option<WorkflowExecutionFilter>)`](crate::client::fluent_builders::ListOpenWorkflowExecutions::set_execution_filter): <p>If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p> <note>   <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>  </note>
    /// - On success, responds with [`ListOpenWorkflowExecutionsOutput`](crate::output::ListOpenWorkflowExecutionsOutput) with field(s):
    ///   - [`execution_infos(Option<Vec<WorkflowExecutionInfo>>)`](crate::output::ListOpenWorkflowExecutionsOutput::execution_infos): <p>The list of workflow information structures.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListOpenWorkflowExecutionsOutput::next_page_token): <p>If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all other arguments unchanged.</p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.</p>
    /// - On failure, responds with [`SdkError<ListOpenWorkflowExecutionsError>`](crate::error::ListOpenWorkflowExecutionsError)
    pub fn list_open_workflow_executions(&self) -> fluent_builders::ListOpenWorkflowExecutions {
        fluent_builders::ListOpenWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<ResourceTag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array of tags associated with the domain.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkflowTypes`](crate::client::fluent_builders::ListWorkflowTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkflowTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListWorkflowTypes::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListWorkflowTypes::set_domain): <p>The name of the domain in which the workflow types have been registered.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListWorkflowTypes::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListWorkflowTypes::set_name): <p>If specified, lists the workflow type with this name.</p>
    ///   - [`registration_status(RegistrationStatus)`](crate::client::fluent_builders::ListWorkflowTypes::registration_status) / [`set_registration_status(Option<RegistrationStatus>)`](crate::client::fluent_builders::ListWorkflowTypes::set_registration_status): <p>Specifies the registration status of the workflow types to list.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkflowTypes::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::ListWorkflowTypes::set_next_page_token): <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
    ///   - [`maximum_page_size(i32)`](crate::client::fluent_builders::ListWorkflowTypes::maximum_page_size) / [`set_maximum_page_size(i32)`](crate::client::fluent_builders::ListWorkflowTypes::set_maximum_page_size): <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::ListWorkflowTypes::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::ListWorkflowTypes::set_reverse_order): <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in ascending alphabetical order of the <code>name</code> of the workflow types.</p>
    /// - On success, responds with [`ListWorkflowTypesOutput`](crate::output::ListWorkflowTypesOutput) with field(s):
    ///   - [`type_infos(Option<Vec<WorkflowTypeInfo>>)`](crate::output::ListWorkflowTypesOutput::type_infos): <p>The list of workflow type information.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListWorkflowTypesOutput::next_page_token): <p>If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all other arguments unchanged.</p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.</p>
    /// - On failure, responds with [`SdkError<ListWorkflowTypesError>`](crate::error::ListWorkflowTypesError)
    pub fn list_workflow_types(&self) -> fluent_builders::ListWorkflowTypes {
        fluent_builders::ListWorkflowTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PollForActivityTask`](crate::client::fluent_builders::PollForActivityTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::PollForActivityTask::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::PollForActivityTask::set_domain): <p>The name of the domain that contains the task lists being polled.</p>
    ///   - [`task_list(TaskList)`](crate::client::fluent_builders::PollForActivityTask::task_list) / [`set_task_list(Option<TaskList>)`](crate::client::fluent_builders::PollForActivityTask::set_task_list): <p>Specifies the task list to poll for activity tasks.</p>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::PollForActivityTask::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::PollForActivityTask::set_identity): <p>Identity of the worker making the request, recorded in the <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
    /// - On success, responds with [`PollForActivityTaskOutput`](crate::output::PollForActivityTaskOutput) with field(s):
    ///   - [`task_token(Option<String>)`](crate::output::PollForActivityTaskOutput::task_token): <p>The opaque string used as a handle on the task. This token is used by workers to communicate progress and response information back to the system about the task.</p>
    ///   - [`activity_id(Option<String>)`](crate::output::PollForActivityTaskOutput::activity_id): <p>The unique ID of the task.</p>
    ///   - [`started_event_id(i64)`](crate::output::PollForActivityTaskOutput::started_event_id): <p>The ID of the <code>ActivityTaskStarted</code> event recorded in the history.</p>
    ///   - [`workflow_execution(Option<WorkflowExecution>)`](crate::output::PollForActivityTaskOutput::workflow_execution): <p>The workflow execution that started this activity task.</p>
    ///   - [`activity_type(Option<ActivityType>)`](crate::output::PollForActivityTaskOutput::activity_type): <p>The type of this activity task.</p>
    ///   - [`input(Option<String>)`](crate::output::PollForActivityTaskOutput::input): <p>The inputs provided when the activity task was scheduled. The form of the input is user defined and should be meaningful to the activity implementation.</p>
    /// - On failure, responds with [`SdkError<PollForActivityTaskError>`](crate::error::PollForActivityTaskError)
    pub fn poll_for_activity_task(&self) -> fluent_builders::PollForActivityTask {
        fluent_builders::PollForActivityTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PollForDecisionTask`](crate::client::fluent_builders::PollForDecisionTask) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::PollForDecisionTask::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::PollForDecisionTask::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::PollForDecisionTask::set_domain): <p>The name of the domain containing the task lists to poll.</p>
    ///   - [`task_list(TaskList)`](crate::client::fluent_builders::PollForDecisionTask::task_list) / [`set_task_list(Option<TaskList>)`](crate::client::fluent_builders::PollForDecisionTask::set_task_list): <p>Specifies the task list to poll for decision tasks.</p>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::PollForDecisionTask::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::PollForDecisionTask::set_identity): <p>Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::PollForDecisionTask::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::PollForDecisionTask::set_next_page_token): <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p> <note>   <p>The <code>nextPageToken</code> returned by this action cannot be used with <code>GetWorkflowExecutionHistory</code> to get the next page. You must call <code>PollForDecisionTask</code> again (with the <code>nextPageToken</code>) to retrieve the next page of history records. Calling <code>PollForDecisionTask</code> with a <code>nextPageToken</code> doesn't return a new decision task.</p>  </note>
    ///   - [`maximum_page_size(i32)`](crate::client::fluent_builders::PollForDecisionTask::maximum_page_size) / [`set_maximum_page_size(i32)`](crate::client::fluent_builders::PollForDecisionTask::set_maximum_page_size): <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>  <p>This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.</p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::PollForDecisionTask::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::PollForDecisionTask::set_reverse_order): <p>When set to <code>true</code>, returns the events in reverse order. By default the results are returned in ascending order of the <code>eventTimestamp</code> of the events.</p>
    /// - On success, responds with [`PollForDecisionTaskOutput`](crate::output::PollForDecisionTaskOutput) with field(s):
    ///   - [`task_token(Option<String>)`](crate::output::PollForDecisionTaskOutput::task_token): <p>The opaque string used as a handle on the task. This token is used by workers to communicate progress and response information back to the system about the task.</p>
    ///   - [`started_event_id(i64)`](crate::output::PollForDecisionTaskOutput::started_event_id): <p>The ID of the <code>DecisionTaskStarted</code> event recorded in the history.</p>
    ///   - [`workflow_execution(Option<WorkflowExecution>)`](crate::output::PollForDecisionTaskOutput::workflow_execution): <p>The workflow execution for which this decision task was created.</p>
    ///   - [`workflow_type(Option<WorkflowType>)`](crate::output::PollForDecisionTaskOutput::workflow_type): <p>The type of the workflow execution for which this decision task was created.</p>
    ///   - [`events(Option<Vec<HistoryEvent>>)`](crate::output::PollForDecisionTaskOutput::events): <p>A paginated list of history events of the workflow execution. The decider uses this during the processing of the decision task.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::PollForDecisionTaskOutput::next_page_token): <p>If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all other arguments unchanged.</p>  <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.</p>
    ///   - [`previous_started_event_id(i64)`](crate::output::PollForDecisionTaskOutput::previous_started_event_id): <p>The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was processed by the decider. This can be used to determine the events in the history new since the last decision task received by the decider.</p>
    /// - On failure, responds with [`SdkError<PollForDecisionTaskError>`](crate::error::PollForDecisionTaskError)
    pub fn poll_for_decision_task(&self) -> fluent_builders::PollForDecisionTask {
        fluent_builders::PollForDecisionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RecordActivityTaskHeartbeat`](crate::client::fluent_builders::RecordActivityTaskHeartbeat) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::RecordActivityTaskHeartbeat::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::RecordActivityTaskHeartbeat::set_task_token): <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>   <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results. </p>  </important>
    ///   - [`details(impl Into<String>)`](crate::client::fluent_builders::RecordActivityTaskHeartbeat::details) / [`set_details(Option<String>)`](crate::client::fluent_builders::RecordActivityTaskHeartbeat::set_details): <p>If specified, contains details about the progress of the task.</p>
    /// - On success, responds with [`RecordActivityTaskHeartbeatOutput`](crate::output::RecordActivityTaskHeartbeatOutput) with field(s):
    ///   - [`cancel_requested(bool)`](crate::output::RecordActivityTaskHeartbeatOutput::cancel_requested): <p>Set to <code>true</code> if cancellation of the task is requested.</p>
    /// - On failure, responds with [`SdkError<RecordActivityTaskHeartbeatError>`](crate::error::RecordActivityTaskHeartbeatError)
    pub fn record_activity_task_heartbeat(&self) -> fluent_builders::RecordActivityTaskHeartbeat {
        fluent_builders::RecordActivityTaskHeartbeat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterActivityType`](crate::client::fluent_builders::RegisterActivityType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_domain): <p>The name of the domain in which this activity is to be registered.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_name): <p>The name of the activity type within the domain.</p>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_version): <p>The version of the activity type.</p> <note>   <p>The activity type consists of the name and version, the combination of which must be unique within the domain.</p>  </note>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_description): <p>A textual description of the activity type.</p>
    ///   - [`default_task_start_to_close_timeout(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::default_task_start_to_close_timeout) / [`set_default_task_start_to_close_timeout(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_default_task_start_to_close_timeout): <p>If set, specifies the default maximum duration that a worker can take to process tasks of this activity type. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>  <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    ///   - [`default_task_heartbeat_timeout(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::default_task_heartbeat_timeout) / [`set_default_task_heartbeat_timeout(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_default_task_heartbeat_timeout): <p>If set, specifies the default maximum time before which a worker processing a task of this type must report progress by calling <code>RecordActivityTaskHeartbeat</code>. If the timeout is exceeded, the activity task is automatically timed out. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task.</p>  <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    ///   - [`default_task_list(TaskList)`](crate::client::fluent_builders::RegisterActivityType::default_task_list) / [`set_default_task_list(Option<TaskList>)`](crate::client::fluent_builders::RegisterActivityType::set_default_task_list): <p>If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list is used if a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
    ///   - [`default_task_priority(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::default_task_priority) / [`set_default_task_priority(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_default_task_priority): <p>The default task priority to assign to the activity type. If not assigned, then <code>0</code> is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>  <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>in the <i>Amazon SWF Developer Guide</i>.</i>.</p>
    ///   - [`default_task_schedule_to_start_timeout(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::default_task_schedule_to_start_timeout) / [`set_default_task_schedule_to_start_timeout(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_default_task_schedule_to_start_timeout): <p>If set, specifies the default maximum duration that a task of this activity type can wait before being assigned to a worker. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>  <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    ///   - [`default_task_schedule_to_close_timeout(impl Into<String>)`](crate::client::fluent_builders::RegisterActivityType::default_task_schedule_to_close_timeout) / [`set_default_task_schedule_to_close_timeout(Option<String>)`](crate::client::fluent_builders::RegisterActivityType::set_default_task_schedule_to_close_timeout): <p>If set, specifies the default maximum duration for a task of this activity type. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>  <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// - On success, responds with [`RegisterActivityTypeOutput`](crate::output::RegisterActivityTypeOutput)

    /// - On failure, responds with [`SdkError<RegisterActivityTypeError>`](crate::error::RegisterActivityTypeError)
    pub fn register_activity_type(&self) -> fluent_builders::RegisterActivityType {
        fluent_builders::RegisterActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterDomain`](crate::client::fluent_builders::RegisterDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RegisterDomain::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RegisterDomain::set_name): <p>Name of the domain to register. The name must be unique in the region that the domain is registered in.</p>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::RegisterDomain::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::RegisterDomain::set_description): <p>A text description of the domain.</p>
    ///   - [`workflow_execution_retention_period_in_days(impl Into<String>)`](crate::client::fluent_builders::RegisterDomain::workflow_execution_retention_period_in_days) / [`set_workflow_execution_retention_period_in_days(Option<String>)`](crate::client::fluent_builders::RegisterDomain::set_workflow_execution_retention_period_in_days): <p>The duration (in days) that records and histories of workflow executions on the domain should be kept by the service. After the retention period, the workflow execution isn't available in the results of visibility calls.</p>  <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history isn't retained. As soon as the workflow execution completes, the execution record and its history are deleted.</p>  <p>The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    ///   - [`tags(Vec<ResourceTag>)`](crate::client::fluent_builders::RegisterDomain::tags) / [`set_tags(Option<Vec<ResourceTag>>)`](crate::client::fluent_builders::RegisterDomain::set_tags): <p>Tags to be added when registering a domain.</p>  <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    /// - On success, responds with [`RegisterDomainOutput`](crate::output::RegisterDomainOutput)

    /// - On failure, responds with [`SdkError<RegisterDomainError>`](crate::error::RegisterDomainError)
    pub fn register_domain(&self) -> fluent_builders::RegisterDomain {
        fluent_builders::RegisterDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterWorkflowType`](crate::client::fluent_builders::RegisterWorkflowType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_domain): <p>The name of the domain in which to register the workflow type.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_name): <p>The name of the workflow type.</p>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_version): <p>The version of the workflow type.</p> <note>   <p>The workflow type consists of the name and version, the combination of which must be unique within the domain. To get a list of all currently registered workflow types, use the <code>ListWorkflowTypes</code> action.</p>  </note>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_description): <p>Textual description of the workflow type.</p>
    ///   - [`default_task_start_to_close_timeout(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::default_task_start_to_close_timeout) / [`set_default_task_start_to_close_timeout(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_default_task_start_to_close_timeout): <p>If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be overridden when starting a workflow execution using the <code>StartWorkflowExecution</code> action or the <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>  <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    ///   - [`default_execution_start_to_close_timeout(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::default_execution_start_to_close_timeout) / [`set_default_execution_start_to_close_timeout(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_default_execution_start_to_close_timeout): <p>If set, specifies the default maximum duration for executions of this workflow type. You can override this default when starting an execution through the <code>StartWorkflowExecution</code> Action or <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>  <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a workflow execution can run. Exceeding this limit always causes the workflow execution to time out.</p>
    ///   - [`default_task_list(TaskList)`](crate::client::fluent_builders::RegisterWorkflowType::default_task_list) / [`set_default_task_list(Option<TaskList>)`](crate::client::fluent_builders::RegisterWorkflowType::set_default_task_list): <p>If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow type. This default is used only if a task list isn't provided when starting the execution through the <code>StartWorkflowExecution</code> Action or <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
    ///   - [`default_task_priority(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::default_task_priority) / [`set_default_task_priority(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_default_task_priority): <p>The default task priority to assign to the workflow type. If not assigned, then <code>0</code> is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>  <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    ///   - [`default_child_policy(ChildPolicy)`](crate::client::fluent_builders::RegisterWorkflowType::default_child_policy) / [`set_default_child_policy(Option<ChildPolicy>)`](crate::client::fluent_builders::RegisterWorkflowType::set_default_child_policy): <p>If set, specifies the default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the <code>TerminateWorkflowExecution</code> action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the <code>StartWorkflowExecution</code> action or the <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>  <p>The supported child policies are:</p>  <ul>   <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>   <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>   <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>  </ul>
    ///   - [`default_lambda_role(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkflowType::default_lambda_role) / [`set_default_lambda_role(Option<String>)`](crate::client::fluent_builders::RegisterWorkflowType::set_default_lambda_role): <p>The default IAM role attached to this workflow type.</p> <note>   <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when you start this workflow type, the default Lambda role is attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.</p>  </note>
    /// - On success, responds with [`RegisterWorkflowTypeOutput`](crate::output::RegisterWorkflowTypeOutput)

    /// - On failure, responds with [`SdkError<RegisterWorkflowTypeError>`](crate::error::RegisterWorkflowTypeError)
    pub fn register_workflow_type(&self) -> fluent_builders::RegisterWorkflowType {
        fluent_builders::RegisterWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RequestCancelWorkflowExecution`](crate::client::fluent_builders::RequestCancelWorkflowExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RequestCancelWorkflowExecution::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RequestCancelWorkflowExecution::set_domain): <p>The name of the domain containing the workflow execution to cancel.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::RequestCancelWorkflowExecution::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::RequestCancelWorkflowExecution::set_workflow_id): <p>The workflowId of the workflow execution to cancel.</p>
    ///   - [`run_id(impl Into<String>)`](crate::client::fluent_builders::RequestCancelWorkflowExecution::run_id) / [`set_run_id(Option<String>)`](crate::client::fluent_builders::RequestCancelWorkflowExecution::set_run_id): <p>The runId of the workflow execution to cancel.</p>
    /// - On success, responds with [`RequestCancelWorkflowExecutionOutput`](crate::output::RequestCancelWorkflowExecutionOutput)

    /// - On failure, responds with [`SdkError<RequestCancelWorkflowExecutionError>`](crate::error::RequestCancelWorkflowExecutionError)
    pub fn request_cancel_workflow_execution(
        &self,
    ) -> fluent_builders::RequestCancelWorkflowExecution {
        fluent_builders::RequestCancelWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RespondActivityTaskCanceled`](crate::client::fluent_builders::RespondActivityTaskCanceled) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::RespondActivityTaskCanceled::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::RespondActivityTaskCanceled::set_task_token): <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>   <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>  </important>
    ///   - [`details(impl Into<String>)`](crate::client::fluent_builders::RespondActivityTaskCanceled::details) / [`set_details(Option<String>)`](crate::client::fluent_builders::RespondActivityTaskCanceled::set_details): <p> Information about the cancellation.</p>
    /// - On success, responds with [`RespondActivityTaskCanceledOutput`](crate::output::RespondActivityTaskCanceledOutput)

    /// - On failure, responds with [`SdkError<RespondActivityTaskCanceledError>`](crate::error::RespondActivityTaskCanceledError)
    pub fn respond_activity_task_canceled(&self) -> fluent_builders::RespondActivityTaskCanceled {
        fluent_builders::RespondActivityTaskCanceled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RespondActivityTaskCompleted`](crate::client::fluent_builders::RespondActivityTaskCompleted) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::RespondActivityTaskCompleted::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::RespondActivityTaskCompleted::set_task_token): <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>   <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>  </important>
    ///   - [`result(impl Into<String>)`](crate::client::fluent_builders::RespondActivityTaskCompleted::result) / [`set_result(Option<String>)`](crate::client::fluent_builders::RespondActivityTaskCompleted::set_result): <p>The result of the activity task. It is a free form string that is implementation specific.</p>
    /// - On success, responds with [`RespondActivityTaskCompletedOutput`](crate::output::RespondActivityTaskCompletedOutput)

    /// - On failure, responds with [`SdkError<RespondActivityTaskCompletedError>`](crate::error::RespondActivityTaskCompletedError)
    pub fn respond_activity_task_completed(&self) -> fluent_builders::RespondActivityTaskCompleted {
        fluent_builders::RespondActivityTaskCompleted::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RespondActivityTaskFailed`](crate::client::fluent_builders::RespondActivityTaskFailed) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::RespondActivityTaskFailed::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::RespondActivityTaskFailed::set_task_token): <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>   <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>  </important>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::RespondActivityTaskFailed::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::RespondActivityTaskFailed::set_reason): <p>Description of the error that may assist in diagnostics.</p>
    ///   - [`details(impl Into<String>)`](crate::client::fluent_builders::RespondActivityTaskFailed::details) / [`set_details(Option<String>)`](crate::client::fluent_builders::RespondActivityTaskFailed::set_details): <p> Detailed information about the failure.</p>
    /// - On success, responds with [`RespondActivityTaskFailedOutput`](crate::output::RespondActivityTaskFailedOutput)

    /// - On failure, responds with [`SdkError<RespondActivityTaskFailedError>`](crate::error::RespondActivityTaskFailedError)
    pub fn respond_activity_task_failed(&self) -> fluent_builders::RespondActivityTaskFailed {
        fluent_builders::RespondActivityTaskFailed::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RespondDecisionTaskCompleted`](crate::client::fluent_builders::RespondDecisionTaskCompleted) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::RespondDecisionTaskCompleted::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::RespondDecisionTaskCompleted::set_task_token): <p>The <code>taskToken</code> from the <code>DecisionTask</code>.</p> <important>   <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>  </important>
    ///   - [`decisions(Vec<Decision>)`](crate::client::fluent_builders::RespondDecisionTaskCompleted::decisions) / [`set_decisions(Option<Vec<Decision>>)`](crate::client::fluent_builders::RespondDecisionTaskCompleted::set_decisions): <p>The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for the <code>Decision</code> structure for details.</p>
    ///   - [`execution_context(impl Into<String>)`](crate::client::fluent_builders::RespondDecisionTaskCompleted::execution_context) / [`set_execution_context(Option<String>)`](crate::client::fluent_builders::RespondDecisionTaskCompleted::set_execution_context): <p>User defined context to add to workflow execution.</p>
    /// - On success, responds with [`RespondDecisionTaskCompletedOutput`](crate::output::RespondDecisionTaskCompletedOutput)

    /// - On failure, responds with [`SdkError<RespondDecisionTaskCompletedError>`](crate::error::RespondDecisionTaskCompletedError)
    pub fn respond_decision_task_completed(&self) -> fluent_builders::RespondDecisionTaskCompleted {
        fluent_builders::RespondDecisionTaskCompleted::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SignalWorkflowExecution`](crate::client::fluent_builders::SignalWorkflowExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::set_domain): <p>The name of the domain containing the workflow execution to signal.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::set_workflow_id): <p>The workflowId of the workflow execution to signal.</p>
    ///   - [`run_id(impl Into<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::run_id) / [`set_run_id(Option<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::set_run_id): <p>The runId of the workflow execution to signal.</p>
    ///   - [`signal_name(impl Into<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::signal_name) / [`set_signal_name(Option<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::set_signal_name): <p>The name of the signal. This name must be meaningful to the target workflow.</p>
    ///   - [`input(impl Into<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::input) / [`set_input(Option<String>)`](crate::client::fluent_builders::SignalWorkflowExecution::set_input): <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target workflow execution's history.</p>
    /// - On success, responds with [`SignalWorkflowExecutionOutput`](crate::output::SignalWorkflowExecutionOutput)

    /// - On failure, responds with [`SdkError<SignalWorkflowExecutionError>`](crate::error::SignalWorkflowExecutionError)
    pub fn signal_workflow_execution(&self) -> fluent_builders::SignalWorkflowExecution {
        fluent_builders::SignalWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartWorkflowExecution`](crate::client::fluent_builders::StartWorkflowExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::StartWorkflowExecution::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::StartWorkflowExecution::set_domain): <p>The name of the domain in which the workflow execution is created.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::StartWorkflowExecution::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::StartWorkflowExecution::set_workflow_id): <p>The user defined identifier associated with the workflow execution. You can use this to associate a custom identifier with the workflow execution. You may specify the same identifier if a workflow execution is logically a <i>restart</i> of a previous execution. You cannot have two open workflow executions with the same <code>workflowId</code> at the same time within the same domain.</p>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`workflow_type(WorkflowType)`](crate::client::fluent_builders::StartWorkflowExecution::workflow_type) / [`set_workflow_type(Option<WorkflowType>)`](crate::client::fluent_builders::StartWorkflowExecution::set_workflow_type): <p>The type of the workflow to start.</p>
    ///   - [`task_list(TaskList)`](crate::client::fluent_builders::StartWorkflowExecution::task_list) / [`set_task_list(Option<TaskList>)`](crate::client::fluent_builders::StartWorkflowExecution::set_task_list): <p>The task list to use for the decision tasks generated for this workflow execution. This overrides the <code>defaultTaskList</code> specified when registering the workflow type.</p> <note>   <p>A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.</p>  </note>  <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
    ///   - [`task_priority(impl Into<String>)`](crate::client::fluent_builders::StartWorkflowExecution::task_priority) / [`set_task_priority(Option<String>)`](crate::client::fluent_builders::StartWorkflowExecution::set_task_priority): <p>The task priority to use for this workflow execution. This overrides any default priority that was assigned when the workflow type was registered. If not set, then the default task priority for the workflow type is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>  <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    ///   - [`input(impl Into<String>)`](crate::client::fluent_builders::StartWorkflowExecution::input) / [`set_input(Option<String>)`](crate::client::fluent_builders::StartWorkflowExecution::set_input): <p>The input for the workflow execution. This is a free form string which should be meaningful to the workflow you are starting. This <code>input</code> is made available to the new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
    ///   - [`execution_start_to_close_timeout(impl Into<String>)`](crate::client::fluent_builders::StartWorkflowExecution::execution_start_to_close_timeout) / [`set_execution_start_to_close_timeout(Option<String>)`](crate::client::fluent_builders::StartWorkflowExecution::set_execution_start_to_close_timeout): <p>The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>  <p>The duration is specified in seconds; an integer greater than or equal to <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow execution can run.</p> <note>   <p>An execution start-to-close timeout must be specified either through this parameter or as a default when the workflow type is registered. If neither this parameter nor a default execution start-to-close timeout is specified, a fault is returned.</p>  </note>
    ///   - [`tag_list(Vec<String>)`](crate::client::fluent_builders::StartWorkflowExecution::tag_list) / [`set_tag_list(Option<Vec<String>>)`](crate::client::fluent_builders::StartWorkflowExecution::set_tag_list): <p>The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list workflow executions with a specific tag by calling <code>ListOpenWorkflowExecutions</code> or <code>ListClosedWorkflowExecutions</code> and specifying a <code>TagFilter</code>.</p>
    ///   - [`task_start_to_close_timeout(impl Into<String>)`](crate::client::fluent_builders::StartWorkflowExecution::task_start_to_close_timeout) / [`set_task_start_to_close_timeout(Option<String>)`](crate::client::fluent_builders::StartWorkflowExecution::set_task_start_to_close_timeout): <p>Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using <code>RegisterWorkflowType</code>.</p>  <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p> <note>   <p>A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>  </note>
    ///   - [`child_policy(ChildPolicy)`](crate::client::fluent_builders::StartWorkflowExecution::child_policy) / [`set_child_policy(Option<ChildPolicy>)`](crate::client::fluent_builders::StartWorkflowExecution::set_child_policy): <p>If set, specifies the policy to use for the child workflow executions of this workflow execution if it is terminated, by calling the <code>TerminateWorkflowExecution</code> action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using <code>RegisterWorkflowType</code>.</p>  <p>The supported child policies are:</p>  <ul>   <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>   <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>   <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>  </ul> <note>   <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>  </note>
    ///   - [`lambda_role(impl Into<String>)`](crate::client::fluent_builders::StartWorkflowExecution::lambda_role) / [`set_lambda_role(Option<String>)`](crate::client::fluent_builders::StartWorkflowExecution::set_lambda_role): <p>The IAM role to attach to this workflow execution.</p> <note>   <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.</p>  </note>
    /// - On success, responds with [`StartWorkflowExecutionOutput`](crate::output::StartWorkflowExecutionOutput) with field(s):
    ///   - [`run_id(Option<String>)`](crate::output::StartWorkflowExecutionOutput::run_id): <p>The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to uniquely identify the workflow execution within a domain.</p>
    /// - On failure, responds with [`SdkError<StartWorkflowExecutionError>`](crate::error::StartWorkflowExecutionError)
    pub fn start_workflow_execution(&self) -> fluent_builders::StartWorkflowExecution {
        fluent_builders::StartWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    ///   - [`tags(Vec<ResourceTag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<ResourceTag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of tags to add to a domain. </p>  <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateWorkflowExecution`](crate::client::fluent_builders::TerminateWorkflowExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::set_domain): <p>The domain of the workflow execution to terminate.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::set_workflow_id): <p>The workflowId of the workflow execution to terminate.</p>
    ///   - [`run_id(impl Into<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::run_id) / [`set_run_id(Option<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::set_run_id): <p>The runId of the workflow execution to terminate.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::set_reason): <p> A descriptive reason for terminating the workflow execution.</p>
    ///   - [`details(impl Into<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::details) / [`set_details(Option<String>)`](crate::client::fluent_builders::TerminateWorkflowExecution::set_details): <p> Details for terminating the workflow execution.</p>
    ///   - [`child_policy(ChildPolicy)`](crate::client::fluent_builders::TerminateWorkflowExecution::child_policy) / [`set_child_policy(Option<ChildPolicy>)`](crate::client::fluent_builders::TerminateWorkflowExecution::set_child_policy): <p>If set, specifies the policy to use for the child workflow executions of the workflow execution being terminated. This policy overrides the child policy specified for the workflow execution at registration time or when starting the execution.</p>  <p>The supported child policies are:</p>  <ul>   <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>   <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>   <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>  </ul> <note>   <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>  </note>
    /// - On success, responds with [`TerminateWorkflowExecutionOutput`](crate::output::TerminateWorkflowExecutionOutput)

    /// - On failure, responds with [`SdkError<TerminateWorkflowExecutionError>`](crate::error::TerminateWorkflowExecutionError)
    pub fn terminate_workflow_execution(&self) -> fluent_builders::TerminateWorkflowExecution {
        fluent_builders::TerminateWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UndeprecateActivityType`](crate::client::fluent_builders::UndeprecateActivityType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::UndeprecateActivityType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::UndeprecateActivityType::set_domain): <p>The name of the domain of the deprecated activity type.</p>
    ///   - [`activity_type(ActivityType)`](crate::client::fluent_builders::UndeprecateActivityType::activity_type) / [`set_activity_type(Option<ActivityType>)`](crate::client::fluent_builders::UndeprecateActivityType::set_activity_type): <p>The activity type to undeprecate.</p>
    /// - On success, responds with [`UndeprecateActivityTypeOutput`](crate::output::UndeprecateActivityTypeOutput)

    /// - On failure, responds with [`SdkError<UndeprecateActivityTypeError>`](crate::error::UndeprecateActivityTypeError)
    pub fn undeprecate_activity_type(&self) -> fluent_builders::UndeprecateActivityType {
        fluent_builders::UndeprecateActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UndeprecateDomain`](crate::client::fluent_builders::UndeprecateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UndeprecateDomain::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UndeprecateDomain::set_name): <p>The name of the domain of the deprecated workflow type.</p>
    /// - On success, responds with [`UndeprecateDomainOutput`](crate::output::UndeprecateDomainOutput)

    /// - On failure, responds with [`SdkError<UndeprecateDomainError>`](crate::error::UndeprecateDomainError)
    pub fn undeprecate_domain(&self) -> fluent_builders::UndeprecateDomain {
        fluent_builders::UndeprecateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UndeprecateWorkflowType`](crate::client::fluent_builders::UndeprecateWorkflowType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::UndeprecateWorkflowType::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::UndeprecateWorkflowType::set_domain): <p>The name of the domain of the deprecated workflow type.</p>
    ///   - [`workflow_type(WorkflowType)`](crate::client::fluent_builders::UndeprecateWorkflowType::workflow_type) / [`set_workflow_type(Option<WorkflowType>)`](crate::client::fluent_builders::UndeprecateWorkflowType::set_workflow_type): <p>The name of the domain of the deprecated workflow type.</p>
    /// - On success, responds with [`UndeprecateWorkflowTypeOutput`](crate::output::UndeprecateWorkflowTypeOutput)

    /// - On failure, responds with [`SdkError<UndeprecateWorkflowTypeError>`](crate::error::UndeprecateWorkflowTypeError)
    pub fn undeprecate_workflow_type(&self) -> fluent_builders::UndeprecateWorkflowType {
        fluent_builders::UndeprecateWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tags to remove from the Amazon SWF domain.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CountClosedWorkflowExecutions`.
    ///
    /// <p>Returns the number of closed workflow executions within the given domain that meet the specified filtering criteria.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</p> </li>
    /// <li> <p> <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</p> </li>
    /// <li> <p> <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CountClosedWorkflowExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::count_closed_workflow_executions_input::Builder,
    }
    impl CountClosedWorkflowExecutions {
        /// Creates a new `CountClosedWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountClosedWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::CountClosedWorkflowExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the start time criteria of the filter are counted.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the start time criteria of the filter are counted.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the close time criteria of the filter are counted.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn close_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.close_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the close time criteria of the filter are counted.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_close_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
        /// <p>If specified, indicates the type of the workflow executions to be counted.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(input);
            self
        }
        /// <p>If specified, indicates the type of the workflow executions to be counted.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are counted.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are counted.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that match this close status are counted. This filter has an affect only if <code>executionStatus</code> is specified as <code>CLOSED</code>.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn close_status_filter(mut self, input: crate::model::CloseStatusFilter) -> Self {
            self.inner = self.inner.close_status_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that match this close status are counted. This filter has an affect only if <code>executionStatus</code> is specified as <code>CLOSED</code>.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_close_status_filter(
            mut self,
            input: std::option::Option<crate::model::CloseStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_status_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CountOpenWorkflowExecutions`.
    ///
    /// <p>Returns the number of open workflow executions within the given domain that meet the specified filtering criteria.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</p> </li>
    /// <li> <p> <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</p> </li>
    /// <li> <p> <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CountOpenWorkflowExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::count_open_workflow_executions_input::Builder,
    }
    impl CountOpenWorkflowExecutions {
        /// Creates a new `CountOpenWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountOpenWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::CountOpenWorkflowExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the start time criteria that workflow executions must meet in order to be counted.</p>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(input);
            self
        }
        /// <p>Specifies the start time criteria that workflow executions must meet in order to be counted.</p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>Specifies the type of the workflow executions to be counted.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(input);
            self
        }
        /// <p>Specifies the type of the workflow executions to be counted.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are counted.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are counted.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CountPendingActivityTasks`.
    ///
    /// <p>Returns the estimated number of activity tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no activity task was ever scheduled in then <code>0</code> is returned.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CountPendingActivityTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::count_pending_activity_tasks_input::Builder,
    }
    impl CountPendingActivityTasks {
        /// Creates a new `CountPendingActivityTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountPendingActivityTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::CountPendingActivityTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CountPendingDecisionTasks`.
    ///
    /// <p>Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then <code>0</code> is returned.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CountPendingDecisionTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::count_pending_decision_tasks_input::Builder,
    }
    impl CountPendingDecisionTasks {
        /// Creates a new `CountPendingDecisionTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountPendingDecisionTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::CountPendingDecisionTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateActivityType`.
    ///
    /// <p>Deprecates the specified <i>activity type</i>. After an activity type has been deprecated, you cannot create new tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated continue to run.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.</p> </li>
    /// <li> <p> <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateActivityType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deprecate_activity_type_input::Builder,
    }
    impl DeprecateActivityType {
        /// Creates a new `DeprecateActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateActivityTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The activity type to deprecate.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.inner = self.inner.activity_type(input);
            self
        }
        /// <p>The activity type to deprecate.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.inner = self.inner.set_activity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateDomain`.
    ///
    /// <p>Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow executions or register new types. However, you can still use visibility actions on this domain. Deprecating a domain also deprecates all activity and workflow types registered in the domain. Executions that were started before the domain was deprecated continues to run.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deprecate_domain_input::Builder,
    }
    impl DeprecateDomain {
        /// Creates a new `DeprecateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain to deprecate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the domain to deprecate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateWorkflowType`.
    ///
    /// <p>Deprecates the specified <i>workflow type</i>. After a workflow type has been deprecated, you cannot create new executions of that type. Executions that were started before the type was deprecated continues to run. A deprecated workflow type may still be used when calling visibility actions.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</p> </li>
    /// <li> <p> <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateWorkflowType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deprecate_workflow_type_input::Builder,
    }
    impl DeprecateWorkflowType {
        /// Creates a new `DeprecateWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateWorkflowTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the workflow type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which the workflow type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflow type to deprecate.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(input);
            self
        }
        /// <p>The workflow type to deprecate.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActivityType`.
    ///
    /// <p>Returns information about the specified activity type. This includes configuration settings provided when the type was registered and other general information about the type.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.</p> </li>
    /// <li> <p> <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeActivityType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_activity_type_input::Builder,
    }
    impl DescribeActivityType {
        /// Creates a new `DescribeActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActivityTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The activity type to get information about. Activity types are identified by the <code>name</code> and <code>version</code> that were supplied when the activity was registered.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.inner = self.inner.activity_type(input);
            self
        }
        /// <p>The activity type to get information about. Activity types are identified by the <code>name</code> and <code>version</code> that were supplied when the activity was registered.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.inner = self.inner.set_activity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Returns information about the specified domain, including description and status.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl DescribeDomain {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain to describe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the domain to describe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkflowExecution`.
    ///
    /// <p>Returns information about the specified workflow execution including its type and some statistics.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkflowExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workflow_execution_input::Builder,
    }
    impl DescribeWorkflowExecution {
        /// Creates a new `DescribeWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflow execution to describe.</p>
        pub fn execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.inner = self.inner.execution(input);
            self
        }
        /// <p>The workflow execution to describe.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.inner = self.inner.set_execution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkflowType`.
    ///
    /// <p>Returns information about the specified <i>workflow type</i>. This includes configuration settings specified when the type was registered and other information such as creation date, current status, etc.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</p> </li>
    /// <li> <p> <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkflowType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workflow_type_input::Builder,
    }
    impl DescribeWorkflowType {
        /// Creates a new `DescribeWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which this workflow type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which this workflow type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflow type to describe.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(input);
            self
        }
        /// <p>The workflow type to describe.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflowExecutionHistory`.
    ///
    /// <p>Returns the history of the specified workflow execution. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned by the initial call.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkflowExecutionHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_workflow_execution_history_input::Builder,
    }
    impl GetWorkflowExecutionHistory {
        /// Creates a new `GetWorkflowExecutionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowExecutionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowExecutionHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetWorkflowExecutionHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetWorkflowExecutionHistoryPaginator {
            crate::paginator::GetWorkflowExecutionHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the workflow execution for which to return the history.</p>
        pub fn execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.inner = self.inner.execution(input);
            self
        }
        /// <p>Specifies the workflow execution for which to return the history.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.inner = self.inner.set_execution(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_page_size(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the results are returned in ascending order of the <code>eventTimeStamp</code> of the events.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the results are returned in ascending order of the <code>eventTimeStamp</code> of the events.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActivityTypes`.
    ///
    /// <p>Returns information about all activities registered in the specified domain that match the specified name and registration status. The result includes information like creation date, current status of the activity, etc. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned by the initial call.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListActivityTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_activity_types_input::Builder,
    }
    impl ListActivityTypes {
        /// Creates a new `ListActivityTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActivityTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActivityTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListActivityTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListActivityTypesPaginator {
            crate::paginator::ListActivityTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain in which the activity types have been registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which the activity types have been registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, only lists the activity types that have this name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>If specified, only lists the activity types that have this name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the registration status of the activity types to list.</p>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(input);
            self
        }
        /// <p>Specifies the registration status of the activity types to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_page_size(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by <code>name</code> of the activity types.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by <code>name</code> of the activity types.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClosedWorkflowExecutions`.
    ///
    /// <p>Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</p> </li>
    /// <li> <p> <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</p> </li>
    /// <li> <p> <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClosedWorkflowExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_closed_workflow_executions_input::Builder,
    }
    impl ListClosedWorkflowExecutions {
        /// Creates a new `ListClosedWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClosedWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClosedWorkflowExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListClosedWorkflowExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListClosedWorkflowExecutionsPaginator {
            crate::paginator::ListClosedWorkflowExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on whether their start times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their start times.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on whether their start times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their start times.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on whether their close times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their close times.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn close_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.close_time_filter(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on whether their close times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their close times.</p> <note>
        /// <p> <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_close_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that match this <i>close status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED workflow executions are listed.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn close_status_filter(mut self, input: crate::model::CloseStatusFilter) -> Self {
            self.inner = self.inner.close_status_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that match this <i>close status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED workflow executions are listed.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_close_status_filter(
            mut self,
            input: std::option::Option<crate::model::CloseStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_status_filter(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are returned.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are returned.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p> <note>
        /// <p> <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_page_size(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in descending order of the start or the close time of the executions.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in descending order of the start or the close time of the executions.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains. The element must be set to <code>arn:aws:swf::AccountID:domain/*</code>, where <i>AccountID</i> is the account ID, with no dashes.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl ListDomains {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsPaginator {
            crate::paginator::ListDomainsPaginator::new(self.handle, self.inner)
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>Specifies the registration status of the domains to list.</p>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(input);
            self
        }
        /// <p>Specifies the registration status of the domains to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_page_size(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by <code>name</code> of the domains.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by <code>name</code> of the domains.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpenWorkflowExecutions`.
    ///
    /// <p>Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</p> </li>
    /// <li> <p> <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</p> </li>
    /// <li> <p> <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOpenWorkflowExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_open_workflow_executions_input::Builder,
    }
    impl ListOpenWorkflowExecutions {
        /// Creates a new `ListOpenWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpenWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpenWorkflowExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOpenWorkflowExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOpenWorkflowExecutionsPaginator {
            crate::paginator::ListOpenWorkflowExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Workflow executions are included in the returned results based on whether their start times are within the range specified by this filter.</p>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(input);
            self
        }
        /// <p>Workflow executions are included in the returned results based on whether their start times are within the range specified by this filter.</p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are returned.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are returned.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_page_size(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in descending order of the start time of the executions.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in descending order of the start time of the executions.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p> <note>
        /// <p> <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags for a given domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkflowTypes`.
    ///
    /// <p>Returns information about workflow types in the specified domain. The results may be split into multiple pages that can be retrieved by making the call repeatedly.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkflowTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_workflow_types_input::Builder,
    }
    impl ListWorkflowTypes {
        /// Creates a new `ListWorkflowTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkflowTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkflowTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkflowTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkflowTypesPaginator {
            crate::paginator::ListWorkflowTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain in which the workflow types have been registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which the workflow types have been registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, lists the workflow type with this name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>If specified, lists the workflow type with this name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the registration status of the workflow types to list.</p>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(input);
            self
        }
        /// <p>Specifies the registration status of the workflow types to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_page_size(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in ascending alphabetical order of the <code>name</code> of the workflow types.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the results are returned in ascending alphabetical order of the <code>name</code> of the workflow types.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PollForActivityTask`.
    ///
    /// <p>Used by workers to get an <code>ActivityTask</code> from the specified activity <code>taskList</code>. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns an empty result. An empty result, in this context, means that an ActivityTask is returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its type to identify and process it correctly.</p> <important>
    /// <p>Workers should set their client side socket timeout to at least 70 seconds (10 seconds higher than the maximum time service may hold the poll request).</p>
    /// </important>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PollForActivityTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::poll_for_activity_task_input::Builder,
    }
    impl PollForActivityTask {
        /// Creates a new `PollForActivityTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PollForActivityTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::PollForActivityTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the task lists being polled.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain that contains the task lists being polled.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the task list to poll for activity tasks.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(input);
            self
        }
        /// <p>Specifies the task list to poll for activity tasks.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
        /// <p>Identity of the worker making the request, recorded in the <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>Identity of the worker making the request, recorded in the <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PollForDecisionTask`.
    ///
    /// <p>Used by deciders to get a <code>DecisionTask</code> from the specified decision <code>taskList</code>. A decision task may be returned for any open workflow execution that is using the specified task list. The task includes a paginated view of the history of the workflow execution. The decider should use the workflow type and the history to determine how to properly handle the task.</p>
    /// <p>This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned, but that the value of taskToken is an empty string.</p> <important>
    /// <p>Deciders should set their client side socket timeout to at least 70 seconds (10 seconds higher than the timeout).</p>
    /// </important> <important>
    /// <p>Because the number of workflow history events for a single workflow execution might be very large, the result returned might be split up across a number of pages. To retrieve subsequent pages, make additional calls to <code>PollForDecisionTask</code> using the <code>nextPageToken</code> returned by the initial call. Note that you do <i>not</i> call <code>GetWorkflowExecutionHistory</code> with this <code>nextPageToken</code>. Instead, call <code>PollForDecisionTask</code> again.</p>
    /// </important>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PollForDecisionTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::poll_for_decision_task_input::Builder,
    }
    impl PollForDecisionTask {
        /// Creates a new `PollForDecisionTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PollForDecisionTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::PollForDecisionTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::PollForDecisionTaskPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::PollForDecisionTaskPaginator {
            crate::paginator::PollForDecisionTaskPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain containing the task lists to poll.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain containing the task lists to poll.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the task list to poll for decision tasks.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(input);
            self
        }
        /// <p>Specifies the task list to poll for decision tasks.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
        /// <p>Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p> <note>
        /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <code>GetWorkflowExecutionHistory</code> to get the next page. You must call <code>PollForDecisionTask</code> again (with the <code>nextPageToken</code>) to retrieve the next page of history records. Calling <code>PollForDecisionTask</code> with a <code>nextPageToken</code> doesn't return a new decision task.</p>
        /// </note>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results available. The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has exceeded its maximum lifetime</code>". </p>
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned in a single call. </p> <note>
        /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <code>GetWorkflowExecutionHistory</code> to get the next page. You must call <code>PollForDecisionTask</code> again (with the <code>nextPageToken</code>) to retrieve the next page of history records. Calling <code>PollForDecisionTask</code> with a <code>nextPageToken</code> doesn't return a new decision task.</p>
        /// </note>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        /// <p>This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.</p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_page_size(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages of results. </p>
        /// <p>This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.</p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the results are returned in ascending order of the <code>eventTimestamp</code> of the events.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the results are returned in ascending order of the <code>eventTimestamp</code> of the events.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RecordActivityTaskHeartbeat`.
    ///
    /// <p>Used by activity workers to report to the service that the <code>ActivityTask</code> represented by the specified <code>taskToken</code> is still making progress. The worker can also specify details of the progress, for example percent complete, using the <code>details</code> parameter. This action can also be used by the worker as a mechanism to check if cancellation is being requested for the activity task. If a cancellation is being attempted for the specified task, then the boolean <code>cancelRequested</code> flag returned by the service is set to <code>true</code>.</p>
    /// <p>This action resets the <code>taskHeartbeatTimeout</code> clock. The <code>taskHeartbeatTimeout</code> is specified in <code>RegisterActivityType</code>.</p>
    /// <p>This action doesn't in itself create an event in the workflow execution history. However, if the task times out, the workflow execution history contains a <code>ActivityTaskTimedOut</code> event that contains the information from the last heartbeat generated by the activity worker.</p> <note>
    /// <p>The <code>taskStartToCloseTimeout</code> of an activity type is the maximum duration of an activity task, regardless of the number of <code>RecordActivityTaskHeartbeat</code> requests received. The <code>taskStartToCloseTimeout</code> is also specified in <code>RegisterActivityType</code>.</p>
    /// </note> <note>
    /// <p>This operation is only useful for long-lived activities to report liveliness of the task and to determine if a cancellation is being attempted.</p>
    /// </note> <important>
    /// <p>If the <code>cancelRequested</code> flag returns <code>true</code>, a cancellation is being attempted. If the worker can cancel the activity, it should respond with <code>RespondActivityTaskCanceled</code>. Otherwise, it should ignore the cancellation request.</p>
    /// </important>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RecordActivityTaskHeartbeat {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::record_activity_task_heartbeat_input::Builder,
    }
    impl RecordActivityTaskHeartbeat {
        /// Creates a new `RecordActivityTaskHeartbeat`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RecordActivityTaskHeartbeatOutput,
            aws_smithy_http::result::SdkError<crate::error::RecordActivityTaskHeartbeatError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results. </p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results. </p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>If specified, contains details about the progress of the task.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(input.into());
            self
        }
        /// <p>If specified, contains details about the progress of the task.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterActivityType`.
    ///
    /// <p>Registers a new <i>activity type</i> along with its configuration settings in the specified domain.</p> <important>
    /// <p>A <code>TypeAlreadyExists</code> fault is returned if the type already exists in the domain. You cannot change any configuration settings of the type after its registration, and it must be registered as a new version.</p>
    /// </important>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.</p> </li>
    /// <li> <p> <code>name</code>: String constraint. The key is <code>swf:name</code>.</p> </li>
    /// <li> <p> <code>version</code>: String constraint. The key is <code>swf:version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterActivityType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_activity_type_input::Builder,
    }
    impl RegisterActivityType {
        /// Creates a new `RegisterActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterActivityTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which this activity is to be registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which this activity is to be registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the activity type within the domain.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the activity type within the domain.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the activity type.</p> <note>
        /// <p>The activity type consists of the name and version, the combination of which must be unique within the domain.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the activity type.</p> <note>
        /// <p>The activity type consists of the name and version, the combination of which must be unique within the domain.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>A textual description of the activity type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A textual description of the activity type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If set, specifies the default maximum duration that a worker can take to process tasks of this activity type. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_start_to_close_timeout(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration that a worker can take to process tasks of this activity type. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the default maximum time before which a worker processing a task of this type must report progress by calling <code>RecordActivityTaskHeartbeat</code>. If the timeout is exceeded, the activity task is automatically timed out. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_heartbeat_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_heartbeat_timeout(input.into());
            self
        }
        /// <p>If set, specifies the default maximum time before which a worker processing a task of this type must report progress by calling <code>RecordActivityTaskHeartbeat</code>. If the timeout is exceeded, the activity task is automatically timed out. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_heartbeat_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_heartbeat_timeout(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list is used if a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        pub fn default_task_list(mut self, input: crate::model::TaskList) -> Self {
            self.inner = self.inner.default_task_list(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list is used if a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.inner = self.inner.set_default_task_list(input);
            self
        }
        /// <p>The default task priority to assign to the activity type. If not assigned, then <code>0</code> is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>in the <i>Amazon SWF Developer Guide</i>.</i>.</p>
        pub fn default_task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_task_priority(input.into());
            self
        }
        /// <p>The default task priority to assign to the activity type. If not assigned, then <code>0</code> is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>in the <i>Amazon SWF Developer Guide</i>.</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_priority(input);
            self
        }
        /// <p>If set, specifies the default maximum duration that a task of this activity type can wait before being assigned to a worker. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_start_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .default_task_schedule_to_start_timeout(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration that a task of this activity type can wait before being assigned to a worker. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_start_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_schedule_to_start_timeout(input);
            self
        }
        /// <p>If set, specifies the default maximum duration for a task of this activity type. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .default_task_schedule_to_close_timeout(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration for a task of this activity type. This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_schedule_to_close_timeout(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDomain`.
    ///
    /// <p>Registers a new domain.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>You cannot use an IAM policy to control domain access for this action. The name of the domain being registered is available as the resource of this action.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_domain_input::Builder,
    }
    impl RegisterDomain {
        /// Creates a new `RegisterDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the domain to register. The name must be unique in the region that the domain is registered in.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of the domain to register. The name must be unique in the region that the domain is registered in.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A text description of the domain.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A text description of the domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The duration (in days) that records and histories of workflow executions on the domain should be kept by the service. After the retention period, the workflow execution isn't available in the results of visibility calls.</p>
        /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history isn't retained. As soon as the workflow execution completes, the execution record and its history are deleted.</p>
        /// <p>The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn workflow_execution_retention_period_in_days(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .workflow_execution_retention_period_in_days(input.into());
            self
        }
        /// <p>The duration (in days) that records and histories of workflow executions on the domain should be kept by the service. After the retention period, the workflow execution isn't available in the results of visibility calls.</p>
        /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history isn't retained. As soon as the workflow execution completes, the execution record and its history are deleted.</p>
        /// <p>The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_workflow_execution_retention_period_in_days(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_workflow_execution_retention_period_in_days(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be added when registering a domain.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: crate::model::ResourceTag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be added when registering a domain.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterWorkflowType`.
    ///
    /// <p>Registers a new <i>workflow type</i> and its configuration settings in the specified domain.</p>
    /// <p>The retention period for the workflow history is set by the <code>RegisterDomain</code> action.</p> <important>
    /// <p>If the type already exists, then a <code>TypeAlreadyExists</code> fault is returned. You cannot change the configuration settings of a workflow type once it is registered and it must be registered as a new version.</p>
    /// </important>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.</p> </li>
    /// <li> <p> <code>name</code>: String constraint. The key is <code>swf:name</code>.</p> </li>
    /// <li> <p> <code>version</code>: String constraint. The key is <code>swf:version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterWorkflowType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_workflow_type_input::Builder,
    }
    impl RegisterWorkflowType {
        /// Creates a new `RegisterWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterWorkflowTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which to register the workflow type.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which to register the workflow type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the workflow type.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the workflow type.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the workflow type.</p> <note>
        /// <p>The workflow type consists of the name and version, the combination of which must be unique within the domain. To get a list of all currently registered workflow types, use the <code>ListWorkflowTypes</code> action.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the workflow type.</p> <note>
        /// <p>The workflow type consists of the name and version, the combination of which must be unique within the domain. To get a list of all currently registered workflow types, use the <code>ListWorkflowTypes</code> action.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>Textual description of the workflow type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Textual description of the workflow type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be overridden when starting a workflow execution using the <code>StartWorkflowExecution</code> action or the <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_start_to_close_timeout(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be overridden when starting a workflow execution using the <code>StartWorkflowExecution</code> action or the <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the default maximum duration for executions of this workflow type. You can override this default when starting an execution through the <code>StartWorkflowExecution</code> Action or <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a workflow execution can run. Exceeding this limit always causes the workflow execution to time out.</p>
        pub fn default_execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .default_execution_start_to_close_timeout(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration for executions of this workflow type. You can override this default when starting an execution through the <code>StartWorkflowExecution</code> Action or <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a workflow execution can run. Exceeding this limit always causes the workflow execution to time out.</p>
        pub fn set_default_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_default_execution_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow type. This default is used only if a task list isn't provided when starting the execution through the <code>StartWorkflowExecution</code> Action or <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        pub fn default_task_list(mut self, input: crate::model::TaskList) -> Self {
            self.inner = self.inner.default_task_list(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow type. This default is used only if a task list isn't provided when starting the execution through the <code>StartWorkflowExecution</code> Action or <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.inner = self.inner.set_default_task_list(input);
            self
        }
        /// <p>The default task priority to assign to the workflow type. If not assigned, then <code>0</code> is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn default_task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_task_priority(input.into());
            self
        }
        /// <p>The default task priority to assign to the workflow type. If not assigned, then <code>0</code> is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_priority(input);
            self
        }
        /// <p>If set, specifies the default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the <code>TerminateWorkflowExecution</code> action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the <code>StartWorkflowExecution</code> action or the <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>
        /// <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>
        /// <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>
        /// </ul>
        pub fn default_child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.inner = self.inner.default_child_policy(input);
            self
        }
        /// <p>If set, specifies the default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the <code>TerminateWorkflowExecution</code> action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the <code>StartWorkflowExecution</code> action or the <code>StartChildWorkflowExecution</code> <code>Decision</code>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>
        /// <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>
        /// <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>
        /// </ul>
        pub fn set_default_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.inner = self.inner.set_default_child_policy(input);
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p> <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when you start this workflow type, the default Lambda role is attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn default_lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_lambda_role(input.into());
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p> <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when you start this workflow type, the default Lambda role is attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_default_lambda_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_lambda_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RequestCancelWorkflowExecution`.
    ///
    /// <p>Records a <code>WorkflowExecutionCancelRequested</code> event in the currently running workflow execution identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> <note>
    /// <p>If the runId isn't specified, the <code>WorkflowExecutionCancelRequested</code> event is recorded in the history of the current open workflow execution with the specified workflowId in the domain.</p>
    /// </note> <note>
    /// <p>Because this action allows the workflow to properly clean up and gracefully close, it should be used instead of <code>TerminateWorkflowExecution</code> when possible.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RequestCancelWorkflowExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::request_cancel_workflow_execution_input::Builder,
    }
    impl RequestCancelWorkflowExecution {
        /// Creates a new `RequestCancelWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RequestCancelWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::RequestCancelWorkflowExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow execution to cancel.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution to cancel.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflowId of the workflow execution to cancel.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>The workflowId of the workflow execution to cancel.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The runId of the workflow execution to cancel.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(input.into());
            self
        }
        /// <p>The runId of the workflow execution to cancel.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondActivityTaskCanceled`.
    ///
    /// <p>Used by workers to tell the service that the <code>ActivityTask</code> identified by the <code>taskToken</code> was successfully canceled. Additional <code>details</code> can be provided using the <code>details</code> argument.</p>
    /// <p>These <code>details</code> (if provided) appear in the <code>ActivityTaskCanceled</code> event added to the workflow history.</p> <important>
    /// <p>Only use this operation if the <code>canceled</code> flag of a <code>RecordActivityTaskHeartbeat</code> request returns <code>true</code> and if the activity can be safely undone or abandoned.</p>
    /// </important>
    /// <p>A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to <code>RespondActivityTaskCompleted</code>, RespondActivityTaskCanceled, <code>RespondActivityTaskFailed</code>, or the task has <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed out</a>.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RespondActivityTaskCanceled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::respond_activity_task_canceled_input::Builder,
    }
    impl RespondActivityTaskCanceled {
        /// Creates a new `RespondActivityTaskCanceled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondActivityTaskCanceledOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCanceledError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p> Information about the cancellation.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(input.into());
            self
        }
        /// <p> Information about the cancellation.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondActivityTaskCompleted`.
    ///
    /// <p>Used by workers to tell the service that the <code>ActivityTask</code> identified by the <code>taskToken</code> completed successfully with a <code>result</code> (if provided). The <code>result</code> appears in the <code>ActivityTaskCompleted</code> event in the workflow history.</p> <important>
    /// <p>If the requested task doesn't complete successfully, use <code>RespondActivityTaskFailed</code> instead. If the worker finds that the task is canceled through the <code>canceled</code> flag returned by <code>RecordActivityTaskHeartbeat</code>, it should cancel the task, clean up and then call <code>RespondActivityTaskCanceled</code>.</p>
    /// </important>
    /// <p>A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted, <code>RespondActivityTaskCanceled</code>, <code>RespondActivityTaskFailed</code>, or the task has <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed out</a>.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RespondActivityTaskCompleted {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::respond_activity_task_completed_input::Builder,
    }
    impl RespondActivityTaskCompleted {
        /// Creates a new `RespondActivityTaskCompleted`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondActivityTaskCompletedOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCompletedError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>The result of the activity task. It is a free form string that is implementation specific.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result(input.into());
            self
        }
        /// <p>The result of the activity task. It is a free form string that is implementation specific.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_result(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondActivityTaskFailed`.
    ///
    /// <p>Used by workers to tell the service that the <code>ActivityTask</code> identified by the <code>taskToken</code> has failed with <code>reason</code> (if specified). The <code>reason</code> and <code>details</code> appear in the <code>ActivityTaskFailed</code> event added to the workflow history.</p>
    /// <p>A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as open while a worker is processing it. A task is closed after it has been specified in a call to <code>RespondActivityTaskCompleted</code>, <code>RespondActivityTaskCanceled</code>, RespondActivityTaskFailed, or the task has <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed out</a>.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RespondActivityTaskFailed {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::respond_activity_task_failed_input::Builder,
    }
    impl RespondActivityTaskFailed {
        /// Creates a new `RespondActivityTaskFailed`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondActivityTaskFailedOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskFailedError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <code>ActivityTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>Description of the error that may assist in diagnostics.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>Description of the error that may assist in diagnostics.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p> Detailed information about the failure.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(input.into());
            self
        }
        /// <p> Detailed information about the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondDecisionTaskCompleted`.
    ///
    /// <p>Used by deciders to tell the service that the <code>DecisionTask</code> identified by the <code>taskToken</code> has successfully completed. The <code>decisions</code> argument specifies the list of decisions made while processing the task.</p>
    /// <p>A <code>DecisionTaskCompleted</code> event is added to the workflow history. The <code>executionContext</code> specified is attached to the event in the workflow execution history.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>If an IAM policy grants permission to use <code>RespondDecisionTaskCompleted</code>, it can express permissions for the list of decisions in the <code>decisions</code> parameter. Each of the decisions has one or more parameters, much like a regular API call. To allow for policies to be as readable as possible, you can express permissions on decisions as if they were actual API calls, including applying conditions to some parameters. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RespondDecisionTaskCompleted {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::respond_decision_task_completed_input::Builder,
    }
    impl RespondDecisionTaskCompleted {
        /// Creates a new `RespondDecisionTaskCompleted`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondDecisionTaskCompletedOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondDecisionTaskCompletedError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> from the <code>DecisionTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The <code>taskToken</code> from the <code>DecisionTask</code>.</p> <important>
        /// <p> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// Appends an item to `decisions`.
        ///
        /// To override the contents of this collection use [`set_decisions`](Self::set_decisions).
        ///
        /// <p>The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for the <code>Decision</code> structure for details.</p>
        pub fn decisions(mut self, input: crate::model::Decision) -> Self {
            self.inner = self.inner.decisions(input);
            self
        }
        /// <p>The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for the <code>Decision</code> structure for details.</p>
        pub fn set_decisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Decision>>,
        ) -> Self {
            self.inner = self.inner.set_decisions(input);
            self
        }
        /// <p>User defined context to add to workflow execution.</p>
        pub fn execution_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_context(input.into());
            self
        }
        /// <p>User defined context to add to workflow execution.</p>
        pub fn set_execution_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SignalWorkflowExecution`.
    ///
    /// <p>Records a <code>WorkflowExecutionSignaled</code> event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with the specified user defined signalName and input (if provided).</p> <note>
    /// <p>If a runId isn't specified, then the <code>WorkflowExecutionSignaled</code> event is recorded in the history of the current open workflow with the matching workflowId in the domain.</p>
    /// </note> <note>
    /// <p>If the specified workflow execution isn't open, this method fails with <code>UnknownResource</code>.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SignalWorkflowExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::signal_workflow_execution_input::Builder,
    }
    impl SignalWorkflowExecution {
        /// Creates a new `SignalWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SignalWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::SignalWorkflowExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow execution to signal.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution to signal.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflowId of the workflow execution to signal.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>The workflowId of the workflow execution to signal.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The runId of the workflow execution to signal.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(input.into());
            self
        }
        /// <p>The runId of the workflow execution to signal.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
        pub fn signal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.signal_name(input.into());
            self
        }
        /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
        pub fn set_signal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_signal_name(input);
            self
        }
        /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target workflow execution's history.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(input.into());
            self
        }
        /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target workflow execution's history.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartWorkflowExecution`.
    ///
    /// <p>Starts an execution of the workflow type in the specified domain using the provided <code>workflowId</code> and input data.</p>
    /// <p>This action returns the newly started workflow execution.</p>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>tagList.member.0</code>: The key is <code>swf:tagList.member.0</code>.</p> </li>
    /// <li> <p> <code>tagList.member.1</code>: The key is <code>swf:tagList.member.1</code>.</p> </li>
    /// <li> <p> <code>tagList.member.2</code>: The key is <code>swf:tagList.member.2</code>.</p> </li>
    /// <li> <p> <code>tagList.member.3</code>: The key is <code>swf:tagList.member.3</code>.</p> </li>
    /// <li> <p> <code>tagList.member.4</code>: The key is <code>swf:tagList.member.4</code>.</p> </li>
    /// <li> <p> <code>taskList</code>: String constraint. The key is <code>swf:taskList.name</code>.</p> </li>
    /// <li> <p> <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</p> </li>
    /// <li> <p> <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartWorkflowExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_workflow_execution_input::Builder,
    }
    impl StartWorkflowExecution {
        /// Creates a new `StartWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartWorkflowExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the workflow execution is created.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain in which the workflow execution is created.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The user defined identifier associated with the workflow execution. You can use this to associate a custom identifier with the workflow execution. You may specify the same identifier if a workflow execution is logically a <i>restart</i> of a previous execution. You cannot have two open workflow executions with the same <code>workflowId</code> at the same time within the same domain.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>The user defined identifier associated with the workflow execution. You can use this to associate a custom identifier with the workflow execution. You may specify the same identifier if a workflow execution is logically a <i>restart</i> of a previous execution. You cannot have two open workflow executions with the same <code>workflowId</code> at the same time within the same domain.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The type of the workflow to start.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(input);
            self
        }
        /// <p>The type of the workflow to start.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
        /// <p>The task list to use for the decision tasks generated for this workflow execution. This overrides the <code>defaultTaskList</code> specified when registering the workflow type.</p> <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(input);
            self
        }
        /// <p>The task list to use for the decision tasks generated for this workflow execution. This overrides the <code>defaultTaskList</code> specified when registering the workflow type.</p> <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
        /// <p>The task priority to use for this workflow execution. This overrides any default priority that was assigned when the workflow type was registered. If not set, then the default task priority for the workflow type is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_priority(input.into());
            self
        }
        /// <p>The task priority to use for this workflow execution. This overrides any default priority that was assigned when the workflow type was registered. If not set, then the default task priority for the workflow type is used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_priority(input);
            self
        }
        /// <p>The input for the workflow execution. This is a free form string which should be meaningful to the workflow you are starting. This <code>input</code> is made available to the new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(input.into());
            self
        }
        /// <p>The input for the workflow execution. This is a free form string which should be meaningful to the workflow you are starting. This <code>input</code> is made available to the new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        /// <p>The duration is specified in seconds; an integer greater than or equal to <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow execution can run.</p> <note>
        /// <p>An execution start-to-close timeout must be specified either through this parameter or as a default when the workflow type is registered. If neither this parameter nor a default execution start-to-close timeout is specified, a fault is returned.</p>
        /// </note>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.execution_start_to_close_timeout(input.into());
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        /// <p>The duration is specified in seconds; an integer greater than or equal to <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow execution can run.</p> <note>
        /// <p>An execution start-to-close timeout must be specified either through this parameter or as a default when the workflow type is registered. If neither this parameter nor a default execution start-to-close timeout is specified, a fault is returned.</p>
        /// </note>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_start_to_close_timeout(input);
            self
        }
        /// Appends an item to `tagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list workflow executions with a specific tag by calling <code>ListOpenWorkflowExecutions</code> or <code>ListClosedWorkflowExecutions</code> and specifying a <code>TagFilter</code>.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_list(input.into());
            self
        }
        /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list workflow executions with a specific tag by calling <code>ListOpenWorkflowExecutions</code> or <code>ListClosedWorkflowExecutions</code> and specifying a <code>TagFilter</code>.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using <code>RegisterWorkflowType</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p> <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.task_start_to_close_timeout(input.into());
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using <code>RegisterWorkflowType</code>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p> <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of this workflow execution if it is terminated, by calling the <code>TerminateWorkflowExecution</code> action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using <code>RegisterWorkflowType</code>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>
        /// <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>
        /// <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>
        /// </ul> <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.inner = self.inner.child_policy(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of this workflow execution if it is terminated, by calling the <code>TerminateWorkflowExecution</code> action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using <code>RegisterWorkflowType</code>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>
        /// <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>
        /// <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>
        /// </ul> <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.inner = self.inner.set_child_policy(input);
            self
        }
        /// <p>The IAM role to attach to this workflow execution.</p> <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lambda_role(input.into());
            self
        }
        /// <p>The IAM role to attach to this workflow execution.</p> <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lambda_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add a tag to a Amazon SWF domain.</p> <note>
    /// <p>Amazon SWF supports a maximum of 50 tags per resource.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a domain. </p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: crate::model::ResourceTag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of tags to add to a domain. </p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateWorkflowExecution`.
    ///
    /// <p>Records a <code>WorkflowExecutionTerminated</code> event and forces closure of the workflow execution identified by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when starting this execution, is applied to any open child workflow executions of this workflow execution.</p> <important>
    /// <p>If the identified workflow execution was in progress, it is terminated immediately.</p>
    /// </important> <note>
    /// <p>If a runId isn't specified, then the <code>WorkflowExecutionTerminated</code> event is recorded in the history of the current open workflow with the matching workflowId in the domain.</p>
    /// </note> <note>
    /// <p>You should consider using <code>RequestCancelWorkflowExecution</code> action instead because it allows the workflow to gracefully close while <code>TerminateWorkflowExecution</code> doesn't.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateWorkflowExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::terminate_workflow_execution_input::Builder,
    }
    impl TerminateWorkflowExecution {
        /// Creates a new `TerminateWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateWorkflowExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain of the workflow execution to terminate.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain of the workflow execution to terminate.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflowId of the workflow execution to terminate.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>The workflowId of the workflow execution to terminate.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The runId of the workflow execution to terminate.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(input.into());
            self
        }
        /// <p>The runId of the workflow execution to terminate.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// <p> A descriptive reason for terminating the workflow execution.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p> A descriptive reason for terminating the workflow execution.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p> Details for terminating the workflow execution.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(input.into());
            self
        }
        /// <p> Details for terminating the workflow execution.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the workflow execution being terminated. This policy overrides the child policy specified for the workflow execution at registration time or when starting the execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>
        /// <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>
        /// <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>
        /// </ul> <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.inner = self.inner.child_policy(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the workflow execution being terminated. This policy overrides the child policy specified for the workflow execution at registration time or when starting the execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code> – The child executions are terminated.</p> </li>
        /// <li> <p> <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.</p> </li>
        /// <li> <p> <code>ABANDON</code> – No action is taken. The child executions continue to run.</p> </li>
        /// </ul> <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.inner = self.inner.set_child_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeprecateActivityType`.
    ///
    /// <p>Undeprecates a previously deprecated <i>activity type</i>. After an activity type has been undeprecated, you can create new tasks of that activity type.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.</p> </li>
    /// <li> <p> <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UndeprecateActivityType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::undeprecate_activity_type_input::Builder,
    }
    impl UndeprecateActivityType {
        /// Creates a new `UndeprecateActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeprecateActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeprecateActivityTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain of the deprecated activity type.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain of the deprecated activity type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The activity type to undeprecate.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.inner = self.inner.activity_type(input);
            self
        }
        /// <p>The activity type to undeprecate.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.inner = self.inner.set_activity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeprecateDomain`.
    ///
    /// <p>Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used to create new workflow executions or register new types.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>You cannot use an IAM policy to constrain this action's parameters.</p> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UndeprecateDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::undeprecate_domain_input::Builder,
    }
    impl UndeprecateDomain {
        /// Creates a new `UndeprecateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeprecateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeprecateDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeprecateWorkflowType`.
    ///
    /// <p>Undeprecates a previously deprecated <i>workflow type</i>. After a workflow type has been undeprecated, you can create new executions of that type. </p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p> <b>Access Control</b> </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as follows:</p>
    /// <ul>
    /// <li> <p>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</p> </li>
    /// <li> <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p> </li>
    /// <li> <p>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.</p>
    /// <ul>
    /// <li> <p> <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</p> </li>
    /// <li> <p> <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UndeprecateWorkflowType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::undeprecate_workflow_type_input::Builder,
    }
    impl UndeprecateWorkflowType {
        /// Creates a new `UndeprecateWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeprecateWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeprecateWorkflowTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(input);
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove a tag from a Amazon SWF domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tags to remove from the Amazon SWF domain.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tags to remove from the Amazon SWF domain.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
