// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CountClosedWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CountClosedWorkflowExecutionsError {
    /// Kind of error that occurred.
    pub kind: CountClosedWorkflowExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CountClosedWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CountClosedWorkflowExecutionsErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CountClosedWorkflowExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CountClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            CountClosedWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            CountClosedWorkflowExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CountClosedWorkflowExecutionsError {
    fn code(&self) -> Option<&str> {
        CountClosedWorkflowExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CountClosedWorkflowExecutionsError {
    /// Creates a new `CountClosedWorkflowExecutionsError`.
    pub fn new(
        kind: CountClosedWorkflowExecutionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CountClosedWorkflowExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CountClosedWorkflowExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CountClosedWorkflowExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CountClosedWorkflowExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CountClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CountClosedWorkflowExecutionsErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountClosedWorkflowExecutionsErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for CountClosedWorkflowExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CountClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            CountClosedWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            CountClosedWorkflowExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CountOpenWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CountOpenWorkflowExecutionsError {
    /// Kind of error that occurred.
    pub kind: CountOpenWorkflowExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CountOpenWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CountOpenWorkflowExecutionsErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CountOpenWorkflowExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CountOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            CountOpenWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            CountOpenWorkflowExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CountOpenWorkflowExecutionsError {
    fn code(&self) -> Option<&str> {
        CountOpenWorkflowExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CountOpenWorkflowExecutionsError {
    /// Creates a new `CountOpenWorkflowExecutionsError`.
    pub fn new(kind: CountOpenWorkflowExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CountOpenWorkflowExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CountOpenWorkflowExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CountOpenWorkflowExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CountOpenWorkflowExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CountOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CountOpenWorkflowExecutionsErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountOpenWorkflowExecutionsErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for CountOpenWorkflowExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CountOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            CountOpenWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            CountOpenWorkflowExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CountPendingActivityTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CountPendingActivityTasksError {
    /// Kind of error that occurred.
    pub kind: CountPendingActivityTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CountPendingActivityTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CountPendingActivityTasksErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CountPendingActivityTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CountPendingActivityTasksErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            CountPendingActivityTasksErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            CountPendingActivityTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CountPendingActivityTasksError {
    fn code(&self) -> Option<&str> {
        CountPendingActivityTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CountPendingActivityTasksError {
    /// Creates a new `CountPendingActivityTasksError`.
    pub fn new(kind: CountPendingActivityTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CountPendingActivityTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CountPendingActivityTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CountPendingActivityTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CountPendingActivityTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CountPendingActivityTasksErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountPendingActivityTasksErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CountPendingActivityTasksErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountPendingActivityTasksErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for CountPendingActivityTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CountPendingActivityTasksErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            CountPendingActivityTasksErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            CountPendingActivityTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CountPendingDecisionTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CountPendingDecisionTasksError {
    /// Kind of error that occurred.
    pub kind: CountPendingDecisionTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CountPendingDecisionTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CountPendingDecisionTasksErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CountPendingDecisionTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CountPendingDecisionTasksErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            CountPendingDecisionTasksErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            CountPendingDecisionTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CountPendingDecisionTasksError {
    fn code(&self) -> Option<&str> {
        CountPendingDecisionTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CountPendingDecisionTasksError {
    /// Creates a new `CountPendingDecisionTasksError`.
    pub fn new(kind: CountPendingDecisionTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CountPendingDecisionTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CountPendingDecisionTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CountPendingDecisionTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CountPendingDecisionTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CountPendingDecisionTasksErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountPendingDecisionTasksErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CountPendingDecisionTasksErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            CountPendingDecisionTasksErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for CountPendingDecisionTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CountPendingDecisionTasksErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            CountPendingDecisionTasksErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            CountPendingDecisionTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeprecateActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeprecateActivityTypeError {
    /// Kind of error that occurred.
    pub kind: DeprecateActivityTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeprecateActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeprecateActivityTypeErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the specified activity or workflow type was already deprecated.</p>
    TypeDeprecatedFault(crate::error::TypeDeprecatedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeprecateActivityTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeprecateActivityTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            DeprecateActivityTypeErrorKind::TypeDeprecatedFault(_inner) => _inner.fmt(f),
            DeprecateActivityTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            DeprecateActivityTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeprecateActivityTypeError {
    fn code(&self) -> Option<&str> {
        DeprecateActivityTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeprecateActivityTypeError {
    /// Creates a new `DeprecateActivityTypeError`.
    pub fn new(kind: DeprecateActivityTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeprecateActivityTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeprecateActivityTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeprecateActivityTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeprecateActivityTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeprecateActivityTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateActivityTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateActivityTypeErrorKind::TypeDeprecatedFault`.
    pub fn is_type_deprecated_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateActivityTypeErrorKind::TypeDeprecatedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateActivityTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateActivityTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for DeprecateActivityTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeprecateActivityTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            DeprecateActivityTypeErrorKind::TypeDeprecatedFault(_inner) => Some(_inner),
            DeprecateActivityTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            DeprecateActivityTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeprecateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeprecateDomainError {
    /// Kind of error that occurred.
    pub kind: DeprecateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeprecateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeprecateDomainErrorKind {
    /// <p>Returned when the specified domain has been deprecated.</p>
    DomainDeprecatedFault(crate::error::DomainDeprecatedFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeprecateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeprecateDomainErrorKind::DomainDeprecatedFault(_inner) => _inner.fmt(f),
            DeprecateDomainErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            DeprecateDomainErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            DeprecateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeprecateDomainError {
    fn code(&self) -> Option<&str> {
        DeprecateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeprecateDomainError {
    /// Creates a new `DeprecateDomainError`.
    pub fn new(kind: DeprecateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeprecateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeprecateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeprecateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeprecateDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeprecateDomainErrorKind::DomainDeprecatedFault`.
    pub fn is_domain_deprecated_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateDomainErrorKind::DomainDeprecatedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateDomainErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateDomainErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateDomainErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateDomainErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for DeprecateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeprecateDomainErrorKind::DomainDeprecatedFault(_inner) => Some(_inner),
            DeprecateDomainErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            DeprecateDomainErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            DeprecateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeprecateWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeprecateWorkflowTypeError {
    /// Kind of error that occurred.
    pub kind: DeprecateWorkflowTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeprecateWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeprecateWorkflowTypeErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the specified activity or workflow type was already deprecated.</p>
    TypeDeprecatedFault(crate::error::TypeDeprecatedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeprecateWorkflowTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            DeprecateWorkflowTypeErrorKind::TypeDeprecatedFault(_inner) => _inner.fmt(f),
            DeprecateWorkflowTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            DeprecateWorkflowTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeprecateWorkflowTypeError {
    fn code(&self) -> Option<&str> {
        DeprecateWorkflowTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeprecateWorkflowTypeError {
    /// Creates a new `DeprecateWorkflowTypeError`.
    pub fn new(kind: DeprecateWorkflowTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeprecateWorkflowTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeprecateWorkflowTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeprecateWorkflowTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeprecateWorkflowTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeprecateWorkflowTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateWorkflowTypeErrorKind::TypeDeprecatedFault`.
    pub fn is_type_deprecated_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateWorkflowTypeErrorKind::TypeDeprecatedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateWorkflowTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateWorkflowTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for DeprecateWorkflowTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            DeprecateWorkflowTypeErrorKind::TypeDeprecatedFault(_inner) => Some(_inner),
            DeprecateWorkflowTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            DeprecateWorkflowTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeActivityTypeError {
    /// Kind of error that occurred.
    pub kind: DescribeActivityTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeActivityTypeErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeActivityTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeActivityTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            DescribeActivityTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            DescribeActivityTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeActivityTypeError {
    fn code(&self) -> Option<&str> {
        DescribeActivityTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeActivityTypeError {
    /// Creates a new `DescribeActivityTypeError`.
    pub fn new(kind: DescribeActivityTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeActivityTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeActivityTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeActivityTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeActivityTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeActivityTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeActivityTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeActivityTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeActivityTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for DescribeActivityTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeActivityTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            DescribeActivityTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            DescribeActivityTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainError {
    fn code(&self) -> Option<&str> {
        DescribeDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainError {
    /// Creates a new `DescribeDomainError`.
    pub fn new(kind: DescribeDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::UnknownResourceFault(_))
    }
}
impl std::error::Error for DescribeDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            DescribeDomainErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            DescribeDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkflowExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkflowExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkflowExecutionErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkflowExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            DescribeWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            DescribeWorkflowExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkflowExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeWorkflowExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkflowExecutionError {
    /// Creates a new `DescribeWorkflowExecutionError`.
    pub fn new(kind: DescribeWorkflowExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkflowExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkflowExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkflowExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkflowExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkflowExecutionErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowExecutionErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkflowExecutionErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowExecutionErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for DescribeWorkflowExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            DescribeWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            DescribeWorkflowExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkflowTypeError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkflowTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkflowTypeErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkflowTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            DescribeWorkflowTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            DescribeWorkflowTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkflowTypeError {
    fn code(&self) -> Option<&str> {
        DescribeWorkflowTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkflowTypeError {
    /// Creates a new `DescribeWorkflowTypeError`.
    pub fn new(kind: DescribeWorkflowTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkflowTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkflowTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkflowTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkflowTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkflowTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkflowTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for DescribeWorkflowTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            DescribeWorkflowTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            DescribeWorkflowTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkflowExecutionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkflowExecutionHistoryError {
    /// Kind of error that occurred.
    pub kind: GetWorkflowExecutionHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkflowExecutionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkflowExecutionHistoryErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkflowExecutionHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkflowExecutionHistoryErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            GetWorkflowExecutionHistoryErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            GetWorkflowExecutionHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkflowExecutionHistoryError {
    fn code(&self) -> Option<&str> {
        GetWorkflowExecutionHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkflowExecutionHistoryError {
    /// Creates a new `GetWorkflowExecutionHistoryError`.
    pub fn new(kind: GetWorkflowExecutionHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkflowExecutionHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkflowExecutionHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkflowExecutionHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkflowExecutionHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWorkflowExecutionHistoryErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowExecutionHistoryErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowExecutionHistoryErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowExecutionHistoryErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for GetWorkflowExecutionHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkflowExecutionHistoryErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            GetWorkflowExecutionHistoryErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            GetWorkflowExecutionHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListActivityTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListActivityTypesError {
    /// Kind of error that occurred.
    pub kind: ListActivityTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListActivityTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListActivityTypesErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListActivityTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListActivityTypesErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            ListActivityTypesErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            ListActivityTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListActivityTypesError {
    fn code(&self) -> Option<&str> {
        ListActivityTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListActivityTypesError {
    /// Creates a new `ListActivityTypesError`.
    pub fn new(kind: ListActivityTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListActivityTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListActivityTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListActivityTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListActivityTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListActivityTypesErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListActivityTypesErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListActivityTypesErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListActivityTypesErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for ListActivityTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListActivityTypesErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            ListActivityTypesErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            ListActivityTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClosedWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClosedWorkflowExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListClosedWorkflowExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClosedWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClosedWorkflowExecutionsErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClosedWorkflowExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            ListClosedWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            ListClosedWorkflowExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClosedWorkflowExecutionsError {
    fn code(&self) -> Option<&str> {
        ListClosedWorkflowExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClosedWorkflowExecutionsError {
    /// Creates a new `ListClosedWorkflowExecutionsError`.
    pub fn new(kind: ListClosedWorkflowExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClosedWorkflowExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClosedWorkflowExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClosedWorkflowExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClosedWorkflowExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListClosedWorkflowExecutionsErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListClosedWorkflowExecutionsErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for ListClosedWorkflowExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            ListClosedWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            ListClosedWorkflowExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsError {
    /// Kind of error that occurred.
    pub kind: ListDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsError {
    fn code(&self) -> Option<&str> {
        ListDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsError {
    /// Creates a new `ListDomainsError`.
    pub fn new(kind: ListDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsErrorKind::OperationNotPermittedFault(_)
        )
    }
}
impl std::error::Error for ListDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            ListDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOpenWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOpenWorkflowExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListOpenWorkflowExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOpenWorkflowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOpenWorkflowExecutionsErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOpenWorkflowExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            ListOpenWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            ListOpenWorkflowExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOpenWorkflowExecutionsError {
    fn code(&self) -> Option<&str> {
        ListOpenWorkflowExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOpenWorkflowExecutionsError {
    /// Creates a new `ListOpenWorkflowExecutionsError`.
    pub fn new(kind: ListOpenWorkflowExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOpenWorkflowExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOpenWorkflowExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOpenWorkflowExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOpenWorkflowExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListOpenWorkflowExecutionsErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListOpenWorkflowExecutionsErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for ListOpenWorkflowExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            ListOpenWorkflowExecutionsErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            ListOpenWorkflowExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::LimitExceededFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkflowTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkflowTypesError {
    /// Kind of error that occurred.
    pub kind: ListWorkflowTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkflowTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkflowTypesErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkflowTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkflowTypesErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            ListWorkflowTypesErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            ListWorkflowTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkflowTypesError {
    fn code(&self) -> Option<&str> {
        ListWorkflowTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkflowTypesError {
    /// Creates a new `ListWorkflowTypesError`.
    pub fn new(kind: ListWorkflowTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkflowTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkflowTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkflowTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkflowTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWorkflowTypesErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkflowTypesErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkflowTypesErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkflowTypesErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for ListWorkflowTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkflowTypesErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            ListWorkflowTypesErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            ListWorkflowTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PollForActivityTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PollForActivityTaskError {
    /// Kind of error that occurred.
    pub kind: PollForActivityTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PollForActivityTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PollForActivityTaskErrorKind {
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PollForActivityTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PollForActivityTaskErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PollForActivityTaskErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            PollForActivityTaskErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            PollForActivityTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PollForActivityTaskError {
    fn code(&self) -> Option<&str> {
        PollForActivityTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PollForActivityTaskError {
    /// Creates a new `PollForActivityTaskError`.
    pub fn new(kind: PollForActivityTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PollForActivityTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PollForActivityTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PollForActivityTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PollForActivityTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PollForActivityTaskErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            PollForActivityTaskErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `PollForActivityTaskErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            PollForActivityTaskErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `PollForActivityTaskErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            PollForActivityTaskErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for PollForActivityTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PollForActivityTaskErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PollForActivityTaskErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            PollForActivityTaskErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            PollForActivityTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PollForDecisionTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PollForDecisionTaskError {
    /// Kind of error that occurred.
    pub kind: PollForDecisionTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PollForDecisionTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PollForDecisionTaskErrorKind {
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PollForDecisionTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PollForDecisionTaskErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PollForDecisionTaskErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            PollForDecisionTaskErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            PollForDecisionTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PollForDecisionTaskError {
    fn code(&self) -> Option<&str> {
        PollForDecisionTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PollForDecisionTaskError {
    /// Creates a new `PollForDecisionTaskError`.
    pub fn new(kind: PollForDecisionTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PollForDecisionTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PollForDecisionTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PollForDecisionTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PollForDecisionTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PollForDecisionTaskErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            PollForDecisionTaskErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `PollForDecisionTaskErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            PollForDecisionTaskErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `PollForDecisionTaskErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            PollForDecisionTaskErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for PollForDecisionTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PollForDecisionTaskErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PollForDecisionTaskErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            PollForDecisionTaskErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            PollForDecisionTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RecordActivityTaskHeartbeat` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RecordActivityTaskHeartbeatError {
    /// Kind of error that occurred.
    pub kind: RecordActivityTaskHeartbeatErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RecordActivityTaskHeartbeat` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RecordActivityTaskHeartbeatErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RecordActivityTaskHeartbeatError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RecordActivityTaskHeartbeatErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            RecordActivityTaskHeartbeatErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RecordActivityTaskHeartbeatErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RecordActivityTaskHeartbeatError {
    fn code(&self) -> Option<&str> {
        RecordActivityTaskHeartbeatError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RecordActivityTaskHeartbeatError {
    /// Creates a new `RecordActivityTaskHeartbeatError`.
    pub fn new(kind: RecordActivityTaskHeartbeatErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RecordActivityTaskHeartbeatError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RecordActivityTaskHeartbeatErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RecordActivityTaskHeartbeatError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RecordActivityTaskHeartbeatErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RecordActivityTaskHeartbeatErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RecordActivityTaskHeartbeatErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RecordActivityTaskHeartbeatErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RecordActivityTaskHeartbeatErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RecordActivityTaskHeartbeatError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RecordActivityTaskHeartbeatErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            RecordActivityTaskHeartbeatErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RecordActivityTaskHeartbeatErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterActivityTypeError {
    /// Kind of error that occurred.
    pub kind: RegisterActivityTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterActivityTypeErrorKind {
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned if the type already exists in the specified domain. You may get this fault if you are registering a type that is either already registered or deprecated, or if you undeprecate a type that is currently registered.</p>
    TypeAlreadyExistsFault(crate::error::TypeAlreadyExistsFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterActivityTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterActivityTypeErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            RegisterActivityTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            RegisterActivityTypeErrorKind::TypeAlreadyExistsFault(_inner) => _inner.fmt(f),
            RegisterActivityTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RegisterActivityTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterActivityTypeError {
    fn code(&self) -> Option<&str> {
        RegisterActivityTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterActivityTypeError {
    /// Creates a new `RegisterActivityTypeError`.
    pub fn new(kind: RegisterActivityTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterActivityTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterActivityTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterActivityTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterActivityTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterActivityTypeErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterActivityTypeErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterActivityTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterActivityTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterActivityTypeErrorKind::TypeAlreadyExistsFault`.
    pub fn is_type_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterActivityTypeErrorKind::TypeAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterActivityTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterActivityTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RegisterActivityTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterActivityTypeErrorKind::LimitExceededFault(_inner) => Some(_inner),
            RegisterActivityTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            RegisterActivityTypeErrorKind::TypeAlreadyExistsFault(_inner) => Some(_inner),
            RegisterActivityTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RegisterActivityTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterDomainError {
    /// Kind of error that occurred.
    pub kind: RegisterDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterDomainErrorKind {
    /// <p>Returned if the domain already exists. You may get this fault if you are registering a domain that is either already registered or deprecated, or if you undeprecate a domain that is currently registered.</p>
    DomainAlreadyExistsFault(crate::error::DomainAlreadyExistsFault),
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>You've exceeded the number of tags allowed for a domain.</p>
    TooManyTagsFault(crate::error::TooManyTagsFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterDomainErrorKind::DomainAlreadyExistsFault(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::TooManyTagsFault(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterDomainError {
    fn code(&self) -> Option<&str> {
        RegisterDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterDomainError {
    /// Creates a new `RegisterDomainError`.
    pub fn new(kind: RegisterDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::DomainAlreadyExistsFault`.
    pub fn is_domain_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDomainErrorKind::DomainAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, RegisterDomainErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDomainErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::TooManyTagsFault`.
    pub fn is_too_many_tags_fault(&self) -> bool {
        matches!(&self.kind, RegisterDomainErrorKind::TooManyTagsFault(_))
    }
}
impl std::error::Error for RegisterDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterDomainErrorKind::DomainAlreadyExistsFault(_inner) => Some(_inner),
            RegisterDomainErrorKind::LimitExceededFault(_inner) => Some(_inner),
            RegisterDomainErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            RegisterDomainErrorKind::TooManyTagsFault(_inner) => Some(_inner),
            RegisterDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterWorkflowTypeError {
    /// Kind of error that occurred.
    pub kind: RegisterWorkflowTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterWorkflowTypeErrorKind {
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned if the type already exists in the specified domain. You may get this fault if you are registering a type that is either already registered or deprecated, or if you undeprecate a type that is currently registered.</p>
    TypeAlreadyExistsFault(crate::error::TypeAlreadyExistsFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterWorkflowTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterWorkflowTypeErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            RegisterWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            RegisterWorkflowTypeErrorKind::TypeAlreadyExistsFault(_inner) => _inner.fmt(f),
            RegisterWorkflowTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RegisterWorkflowTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterWorkflowTypeError {
    fn code(&self) -> Option<&str> {
        RegisterWorkflowTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterWorkflowTypeError {
    /// Creates a new `RegisterWorkflowTypeError`.
    pub fn new(kind: RegisterWorkflowTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterWorkflowTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterWorkflowTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterWorkflowTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterWorkflowTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterWorkflowTypeErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkflowTypeErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkflowTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkflowTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkflowTypeErrorKind::TypeAlreadyExistsFault`.
    pub fn is_type_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkflowTypeErrorKind::TypeAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkflowTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkflowTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RegisterWorkflowTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterWorkflowTypeErrorKind::LimitExceededFault(_inner) => Some(_inner),
            RegisterWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            RegisterWorkflowTypeErrorKind::TypeAlreadyExistsFault(_inner) => Some(_inner),
            RegisterWorkflowTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RegisterWorkflowTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RequestCancelWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RequestCancelWorkflowExecutionError {
    /// Kind of error that occurred.
    pub kind: RequestCancelWorkflowExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RequestCancelWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RequestCancelWorkflowExecutionErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RequestCancelWorkflowExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RequestCancelWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            RequestCancelWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RequestCancelWorkflowExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RequestCancelWorkflowExecutionError {
    fn code(&self) -> Option<&str> {
        RequestCancelWorkflowExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RequestCancelWorkflowExecutionError {
    /// Creates a new `RequestCancelWorkflowExecutionError`.
    pub fn new(
        kind: RequestCancelWorkflowExecutionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RequestCancelWorkflowExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RequestCancelWorkflowExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RequestCancelWorkflowExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RequestCancelWorkflowExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RequestCancelWorkflowExecutionErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RequestCancelWorkflowExecutionErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RequestCancelWorkflowExecutionErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RequestCancelWorkflowExecutionErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RequestCancelWorkflowExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RequestCancelWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            RequestCancelWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RequestCancelWorkflowExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RespondActivityTaskCanceled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RespondActivityTaskCanceledError {
    /// Kind of error that occurred.
    pub kind: RespondActivityTaskCanceledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RespondActivityTaskCanceled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RespondActivityTaskCanceledErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RespondActivityTaskCanceledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RespondActivityTaskCanceledErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            RespondActivityTaskCanceledErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RespondActivityTaskCanceledErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RespondActivityTaskCanceledError {
    fn code(&self) -> Option<&str> {
        RespondActivityTaskCanceledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RespondActivityTaskCanceledError {
    /// Creates a new `RespondActivityTaskCanceledError`.
    pub fn new(kind: RespondActivityTaskCanceledErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RespondActivityTaskCanceledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RespondActivityTaskCanceledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RespondActivityTaskCanceledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RespondActivityTaskCanceledErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RespondActivityTaskCanceledErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondActivityTaskCanceledErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RespondActivityTaskCanceledErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondActivityTaskCanceledErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RespondActivityTaskCanceledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RespondActivityTaskCanceledErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            RespondActivityTaskCanceledErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RespondActivityTaskCanceledErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RespondActivityTaskCompleted` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RespondActivityTaskCompletedError {
    /// Kind of error that occurred.
    pub kind: RespondActivityTaskCompletedErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RespondActivityTaskCompleted` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RespondActivityTaskCompletedErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RespondActivityTaskCompletedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RespondActivityTaskCompletedErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            RespondActivityTaskCompletedErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RespondActivityTaskCompletedErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RespondActivityTaskCompletedError {
    fn code(&self) -> Option<&str> {
        RespondActivityTaskCompletedError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RespondActivityTaskCompletedError {
    /// Creates a new `RespondActivityTaskCompletedError`.
    pub fn new(kind: RespondActivityTaskCompletedErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RespondActivityTaskCompletedError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RespondActivityTaskCompletedErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RespondActivityTaskCompletedError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RespondActivityTaskCompletedErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RespondActivityTaskCompletedErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondActivityTaskCompletedErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RespondActivityTaskCompletedErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondActivityTaskCompletedErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RespondActivityTaskCompletedError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RespondActivityTaskCompletedErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            RespondActivityTaskCompletedErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RespondActivityTaskCompletedErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RespondActivityTaskFailed` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RespondActivityTaskFailedError {
    /// Kind of error that occurred.
    pub kind: RespondActivityTaskFailedErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RespondActivityTaskFailed` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RespondActivityTaskFailedErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RespondActivityTaskFailedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RespondActivityTaskFailedErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            RespondActivityTaskFailedErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RespondActivityTaskFailedErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RespondActivityTaskFailedError {
    fn code(&self) -> Option<&str> {
        RespondActivityTaskFailedError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RespondActivityTaskFailedError {
    /// Creates a new `RespondActivityTaskFailedError`.
    pub fn new(kind: RespondActivityTaskFailedErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RespondActivityTaskFailedError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RespondActivityTaskFailedErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RespondActivityTaskFailedError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RespondActivityTaskFailedErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RespondActivityTaskFailedErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondActivityTaskFailedErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RespondActivityTaskFailedErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondActivityTaskFailedErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RespondActivityTaskFailedError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RespondActivityTaskFailedErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            RespondActivityTaskFailedErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RespondActivityTaskFailedErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RespondDecisionTaskCompleted` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RespondDecisionTaskCompletedError {
    /// Kind of error that occurred.
    pub kind: RespondDecisionTaskCompletedErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RespondDecisionTaskCompleted` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RespondDecisionTaskCompletedErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RespondDecisionTaskCompletedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RespondDecisionTaskCompletedErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            RespondDecisionTaskCompletedErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            RespondDecisionTaskCompletedErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RespondDecisionTaskCompletedError {
    fn code(&self) -> Option<&str> {
        RespondDecisionTaskCompletedError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RespondDecisionTaskCompletedError {
    /// Creates a new `RespondDecisionTaskCompletedError`.
    pub fn new(kind: RespondDecisionTaskCompletedErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RespondDecisionTaskCompletedError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RespondDecisionTaskCompletedErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RespondDecisionTaskCompletedError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RespondDecisionTaskCompletedErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RespondDecisionTaskCompletedErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondDecisionTaskCompletedErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RespondDecisionTaskCompletedErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            RespondDecisionTaskCompletedErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for RespondDecisionTaskCompletedError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RespondDecisionTaskCompletedErrorKind::OperationNotPermittedFault(_inner) => {
                Some(_inner)
            }
            RespondDecisionTaskCompletedErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            RespondDecisionTaskCompletedErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SignalWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SignalWorkflowExecutionError {
    /// Kind of error that occurred.
    pub kind: SignalWorkflowExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SignalWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SignalWorkflowExecutionErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SignalWorkflowExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SignalWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            SignalWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            SignalWorkflowExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SignalWorkflowExecutionError {
    fn code(&self) -> Option<&str> {
        SignalWorkflowExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SignalWorkflowExecutionError {
    /// Creates a new `SignalWorkflowExecutionError`.
    pub fn new(kind: SignalWorkflowExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SignalWorkflowExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SignalWorkflowExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SignalWorkflowExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SignalWorkflowExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SignalWorkflowExecutionErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            SignalWorkflowExecutionErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `SignalWorkflowExecutionErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            SignalWorkflowExecutionErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for SignalWorkflowExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SignalWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            SignalWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            SignalWorkflowExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartWorkflowExecutionError {
    /// Kind of error that occurred.
    pub kind: StartWorkflowExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartWorkflowExecutionErrorKind {
    /// <p>The <code>StartWorkflowExecution</code> API action was called without the required parameters set.</p>
    /// <p>Some workflow execution parameters, such as the decision <code>taskList</code>, must be set to start the execution. However, these parameters might have been set as defaults when the workflow type was registered. In this case, you can omit these parameters from the <code>StartWorkflowExecution</code> call and Amazon SWF uses the values defined in the workflow type.</p> <note>
    /// <p>If these parameters aren't set and no default parameters were defined in the workflow type, this error is displayed.</p>
    /// </note>
    DefaultUndefinedFault(crate::error::DefaultUndefinedFault),
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the specified activity or workflow type was already deprecated.</p>
    TypeDeprecatedFault(crate::error::TypeDeprecatedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// <p>Returned by <code>StartWorkflowExecution</code> when an open execution with the same workflowId is already running in the specified domain.</p>
    WorkflowExecutionAlreadyStartedFault(crate::error::WorkflowExecutionAlreadyStartedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartWorkflowExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartWorkflowExecutionErrorKind::DefaultUndefinedFault(_inner) => _inner.fmt(f),
            StartWorkflowExecutionErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            StartWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            StartWorkflowExecutionErrorKind::TypeDeprecatedFault(_inner) => _inner.fmt(f),
            StartWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            StartWorkflowExecutionErrorKind::WorkflowExecutionAlreadyStartedFault(_inner) => {
                _inner.fmt(f)
            }
            StartWorkflowExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartWorkflowExecutionError {
    fn code(&self) -> Option<&str> {
        StartWorkflowExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartWorkflowExecutionError {
    /// Creates a new `StartWorkflowExecutionError`.
    pub fn new(kind: StartWorkflowExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartWorkflowExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartWorkflowExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartWorkflowExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartWorkflowExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartWorkflowExecutionErrorKind::DefaultUndefinedFault`.
    pub fn is_default_undefined_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowExecutionErrorKind::DefaultUndefinedFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowExecutionErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowExecutionErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowExecutionErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowExecutionErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowExecutionErrorKind::TypeDeprecatedFault`.
    pub fn is_type_deprecated_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowExecutionErrorKind::TypeDeprecatedFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowExecutionErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowExecutionErrorKind::UnknownResourceFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowExecutionErrorKind::WorkflowExecutionAlreadyStartedFault`.
    pub fn is_workflow_execution_already_started_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowExecutionErrorKind::WorkflowExecutionAlreadyStartedFault(_)
        )
    }
}
impl std::error::Error for StartWorkflowExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartWorkflowExecutionErrorKind::DefaultUndefinedFault(_inner) => Some(_inner),
            StartWorkflowExecutionErrorKind::LimitExceededFault(_inner) => Some(_inner),
            StartWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            StartWorkflowExecutionErrorKind::TypeDeprecatedFault(_inner) => Some(_inner),
            StartWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            StartWorkflowExecutionErrorKind::WorkflowExecutionAlreadyStartedFault(_inner) => {
                Some(_inner)
            }
            StartWorkflowExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>You've exceeded the number of tags allowed for a domain.</p>
    TooManyTagsFault(crate::error::TooManyTagsFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsFault`.
    pub fn is_too_many_tags_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsFault(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::UnknownResourceFault(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::LimitExceededFault(_inner) => Some(_inner),
            TagResourceErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsFault(_inner) => Some(_inner),
            TagResourceErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateWorkflowExecutionError {
    /// Kind of error that occurred.
    pub kind: TerminateWorkflowExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateWorkflowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateWorkflowExecutionErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateWorkflowExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => {
                _inner.fmt(f)
            }
            TerminateWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            TerminateWorkflowExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateWorkflowExecutionError {
    fn code(&self) -> Option<&str> {
        TerminateWorkflowExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateWorkflowExecutionError {
    /// Creates a new `TerminateWorkflowExecutionError`.
    pub fn new(kind: TerminateWorkflowExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateWorkflowExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateWorkflowExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateWorkflowExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateWorkflowExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TerminateWorkflowExecutionErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            TerminateWorkflowExecutionErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateWorkflowExecutionErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            TerminateWorkflowExecutionErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for TerminateWorkflowExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateWorkflowExecutionErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            TerminateWorkflowExecutionErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            TerminateWorkflowExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UndeprecateActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UndeprecateActivityTypeError {
    /// Kind of error that occurred.
    pub kind: UndeprecateActivityTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UndeprecateActivityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UndeprecateActivityTypeErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned if the type already exists in the specified domain. You may get this fault if you are registering a type that is either already registered or deprecated, or if you undeprecate a type that is currently registered.</p>
    TypeAlreadyExistsFault(crate::error::TypeAlreadyExistsFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UndeprecateActivityTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UndeprecateActivityTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            UndeprecateActivityTypeErrorKind::TypeAlreadyExistsFault(_inner) => _inner.fmt(f),
            UndeprecateActivityTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            UndeprecateActivityTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UndeprecateActivityTypeError {
    fn code(&self) -> Option<&str> {
        UndeprecateActivityTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UndeprecateActivityTypeError {
    /// Creates a new `UndeprecateActivityTypeError`.
    pub fn new(kind: UndeprecateActivityTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UndeprecateActivityTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UndeprecateActivityTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UndeprecateActivityTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UndeprecateActivityTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UndeprecateActivityTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateActivityTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `UndeprecateActivityTypeErrorKind::TypeAlreadyExistsFault`.
    pub fn is_type_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateActivityTypeErrorKind::TypeAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `UndeprecateActivityTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateActivityTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for UndeprecateActivityTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UndeprecateActivityTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            UndeprecateActivityTypeErrorKind::TypeAlreadyExistsFault(_inner) => Some(_inner),
            UndeprecateActivityTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            UndeprecateActivityTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UndeprecateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UndeprecateDomainError {
    /// Kind of error that occurred.
    pub kind: UndeprecateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UndeprecateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UndeprecateDomainErrorKind {
    /// <p>Returned if the domain already exists. You may get this fault if you are registering a domain that is either already registered or deprecated, or if you undeprecate a domain that is currently registered.</p>
    DomainAlreadyExistsFault(crate::error::DomainAlreadyExistsFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UndeprecateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UndeprecateDomainErrorKind::DomainAlreadyExistsFault(_inner) => _inner.fmt(f),
            UndeprecateDomainErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            UndeprecateDomainErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            UndeprecateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UndeprecateDomainError {
    fn code(&self) -> Option<&str> {
        UndeprecateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UndeprecateDomainError {
    /// Creates a new `UndeprecateDomainError`.
    pub fn new(kind: UndeprecateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UndeprecateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UndeprecateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UndeprecateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UndeprecateDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UndeprecateDomainErrorKind::DomainAlreadyExistsFault`.
    pub fn is_domain_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateDomainErrorKind::DomainAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `UndeprecateDomainErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateDomainErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `UndeprecateDomainErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateDomainErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for UndeprecateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UndeprecateDomainErrorKind::DomainAlreadyExistsFault(_inner) => Some(_inner),
            UndeprecateDomainErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            UndeprecateDomainErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            UndeprecateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UndeprecateWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UndeprecateWorkflowTypeError {
    /// Kind of error that occurred.
    pub kind: UndeprecateWorkflowTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UndeprecateWorkflowType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UndeprecateWorkflowTypeErrorKind {
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned if the type already exists in the specified domain. You may get this fault if you are registering a type that is either already registered or deprecated, or if you undeprecate a type that is currently registered.</p>
    TypeAlreadyExistsFault(crate::error::TypeAlreadyExistsFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UndeprecateWorkflowTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UndeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            UndeprecateWorkflowTypeErrorKind::TypeAlreadyExistsFault(_inner) => _inner.fmt(f),
            UndeprecateWorkflowTypeErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            UndeprecateWorkflowTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UndeprecateWorkflowTypeError {
    fn code(&self) -> Option<&str> {
        UndeprecateWorkflowTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UndeprecateWorkflowTypeError {
    /// Creates a new `UndeprecateWorkflowTypeError`.
    pub fn new(kind: UndeprecateWorkflowTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UndeprecateWorkflowTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UndeprecateWorkflowTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UndeprecateWorkflowTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UndeprecateWorkflowTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UndeprecateWorkflowTypeErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `UndeprecateWorkflowTypeErrorKind::TypeAlreadyExistsFault`.
    pub fn is_type_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateWorkflowTypeErrorKind::TypeAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `UndeprecateWorkflowTypeErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(
            &self.kind,
            UndeprecateWorkflowTypeErrorKind::UnknownResourceFault(_)
        )
    }
}
impl std::error::Error for UndeprecateWorkflowTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UndeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            UndeprecateWorkflowTypeErrorKind::TypeAlreadyExistsFault(_inner) => Some(_inner),
            UndeprecateWorkflowTypeErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            UndeprecateWorkflowTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::OperationNotPermittedFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::UnknownResourceFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::OperationNotPermittedFault`.
    pub fn is_operation_not_permitted_fault(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::OperationNotPermittedFault(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::UnknownResourceFault`.
    pub fn is_unknown_resource_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::UnknownResourceFault(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::LimitExceededFault(_inner) => Some(_inner),
            UntagResourceErrorKind::OperationNotPermittedFault(_inner) => Some(_inner),
            UntagResourceErrorKind::UnknownResourceFault(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnknownResourceFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnknownResourceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnknownResourceFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnknownResourceFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnknownResourceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnknownResourceFault")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnknownResourceFault {}
/// See [`UnknownResourceFault`](crate::error::UnknownResourceFault)
pub mod unknown_resource_fault {
    /// A builder for [`UnknownResourceFault`](crate::error::UnknownResourceFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnknownResourceFault`](crate::error::UnknownResourceFault)
        pub fn build(self) -> crate::error::UnknownResourceFault {
            crate::error::UnknownResourceFault {
                message: self.message,
            }
        }
    }
}
impl UnknownResourceFault {
    /// Creates a new builder-style object to manufacture [`UnknownResourceFault`](crate::error::UnknownResourceFault)
    pub fn builder() -> crate::error::unknown_resource_fault::Builder {
        crate::error::unknown_resource_fault::Builder::default()
    }
}

/// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotPermittedFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotPermittedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotPermittedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotPermittedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotPermittedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotPermittedFault")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotPermittedFault {}
/// See [`OperationNotPermittedFault`](crate::error::OperationNotPermittedFault)
pub mod operation_not_permitted_fault {
    /// A builder for [`OperationNotPermittedFault`](crate::error::OperationNotPermittedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotPermittedFault`](crate::error::OperationNotPermittedFault)
        pub fn build(self) -> crate::error::OperationNotPermittedFault {
            crate::error::OperationNotPermittedFault {
                message: self.message,
            }
        }
    }
}
impl OperationNotPermittedFault {
    /// Creates a new builder-style object to manufacture [`OperationNotPermittedFault`](crate::error::OperationNotPermittedFault)
    pub fn builder() -> crate::error::operation_not_permitted_fault::Builder {
        crate::error::operation_not_permitted_fault::Builder::default()
    }
}

/// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededFault")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededFault {}
/// See [`LimitExceededFault`](crate::error::LimitExceededFault)
pub mod limit_exceeded_fault {
    /// A builder for [`LimitExceededFault`](crate::error::LimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededFault`](crate::error::LimitExceededFault)
        pub fn build(self) -> crate::error::LimitExceededFault {
            crate::error::LimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl LimitExceededFault {
    /// Creates a new builder-style object to manufacture [`LimitExceededFault`](crate::error::LimitExceededFault)
    pub fn builder() -> crate::error::limit_exceeded_fault::Builder {
        crate::error::limit_exceeded_fault::Builder::default()
    }
}

/// <p>Returned if the type already exists in the specified domain. You may get this fault if you are registering a type that is either already registered or deprecated, or if you undeprecate a type that is currently registered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeAlreadyExistsFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TypeAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TypeAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TypeAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TypeAlreadyExistsFault")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for TypeAlreadyExistsFault {}
/// See [`TypeAlreadyExistsFault`](crate::error::TypeAlreadyExistsFault)
pub mod type_already_exists_fault {
    /// A builder for [`TypeAlreadyExistsFault`](crate::error::TypeAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeAlreadyExistsFault`](crate::error::TypeAlreadyExistsFault)
        pub fn build(self) -> crate::error::TypeAlreadyExistsFault {
            crate::error::TypeAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl TypeAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`TypeAlreadyExistsFault`](crate::error::TypeAlreadyExistsFault)
    pub fn builder() -> crate::error::type_already_exists_fault::Builder {
        crate::error::type_already_exists_fault::Builder::default()
    }
}

/// <p>Returned if the domain already exists. You may get this fault if you are registering a domain that is either already registered or deprecated, or if you undeprecate a domain that is currently registered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainAlreadyExistsFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DomainAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DomainAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DomainAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DomainAlreadyExistsFault")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DomainAlreadyExistsFault {}
/// See [`DomainAlreadyExistsFault`](crate::error::DomainAlreadyExistsFault)
pub mod domain_already_exists_fault {
    /// A builder for [`DomainAlreadyExistsFault`](crate::error::DomainAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainAlreadyExistsFault`](crate::error::DomainAlreadyExistsFault)
        pub fn build(self) -> crate::error::DomainAlreadyExistsFault {
            crate::error::DomainAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DomainAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DomainAlreadyExistsFault`](crate::error::DomainAlreadyExistsFault)
    pub fn builder() -> crate::error::domain_already_exists_fault::Builder {
        crate::error::domain_already_exists_fault::Builder::default()
    }
}

/// <p>You've exceeded the number of tags allowed for a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsFault")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsFault {}
/// See [`TooManyTagsFault`](crate::error::TooManyTagsFault)
pub mod too_many_tags_fault {
    /// A builder for [`TooManyTagsFault`](crate::error::TooManyTagsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsFault`](crate::error::TooManyTagsFault)
        pub fn build(self) -> crate::error::TooManyTagsFault {
            crate::error::TooManyTagsFault {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsFault {
    /// Creates a new builder-style object to manufacture [`TooManyTagsFault`](crate::error::TooManyTagsFault)
    pub fn builder() -> crate::error::too_many_tags_fault::Builder {
        crate::error::too_many_tags_fault::Builder::default()
    }
}

/// <p>Returned by <code>StartWorkflowExecution</code> when an open execution with the same workflowId is already running in the specified domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionAlreadyStartedFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WorkflowExecutionAlreadyStartedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionAlreadyStartedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WorkflowExecutionAlreadyStartedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WorkflowExecutionAlreadyStartedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WorkflowExecutionAlreadyStartedFault")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for WorkflowExecutionAlreadyStartedFault {}
/// See [`WorkflowExecutionAlreadyStartedFault`](crate::error::WorkflowExecutionAlreadyStartedFault)
pub mod workflow_execution_already_started_fault {
    /// A builder for [`WorkflowExecutionAlreadyStartedFault`](crate::error::WorkflowExecutionAlreadyStartedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionAlreadyStartedFault`](crate::error::WorkflowExecutionAlreadyStartedFault)
        pub fn build(self) -> crate::error::WorkflowExecutionAlreadyStartedFault {
            crate::error::WorkflowExecutionAlreadyStartedFault {
                message: self.message,
            }
        }
    }
}
impl WorkflowExecutionAlreadyStartedFault {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionAlreadyStartedFault`](crate::error::WorkflowExecutionAlreadyStartedFault)
    pub fn builder() -> crate::error::workflow_execution_already_started_fault::Builder {
        crate::error::workflow_execution_already_started_fault::Builder::default()
    }
}

/// <p>Returned when the specified activity or workflow type was already deprecated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeDeprecatedFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TypeDeprecatedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeDeprecatedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TypeDeprecatedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TypeDeprecatedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TypeDeprecatedFault")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TypeDeprecatedFault {}
/// See [`TypeDeprecatedFault`](crate::error::TypeDeprecatedFault)
pub mod type_deprecated_fault {
    /// A builder for [`TypeDeprecatedFault`](crate::error::TypeDeprecatedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeDeprecatedFault`](crate::error::TypeDeprecatedFault)
        pub fn build(self) -> crate::error::TypeDeprecatedFault {
            crate::error::TypeDeprecatedFault {
                message: self.message,
            }
        }
    }
}
impl TypeDeprecatedFault {
    /// Creates a new builder-style object to manufacture [`TypeDeprecatedFault`](crate::error::TypeDeprecatedFault)
    pub fn builder() -> crate::error::type_deprecated_fault::Builder {
        crate::error::type_deprecated_fault::Builder::default()
    }
}

/// <p>The <code>StartWorkflowExecution</code> API action was called without the required parameters set.</p>
/// <p>Some workflow execution parameters, such as the decision <code>taskList</code>, must be set to start the execution. However, these parameters might have been set as defaults when the workflow type was registered. In this case, you can omit these parameters from the <code>StartWorkflowExecution</code> call and Amazon SWF uses the values defined in the workflow type.</p> <note>
/// <p>If these parameters aren't set and no default parameters were defined in the workflow type, this error is displayed.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultUndefinedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DefaultUndefinedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultUndefinedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DefaultUndefinedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DefaultUndefinedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DefaultUndefinedFault")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for DefaultUndefinedFault {}
/// See [`DefaultUndefinedFault`](crate::error::DefaultUndefinedFault)
pub mod default_undefined_fault {
    /// A builder for [`DefaultUndefinedFault`](crate::error::DefaultUndefinedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultUndefinedFault`](crate::error::DefaultUndefinedFault)
        pub fn build(self) -> crate::error::DefaultUndefinedFault {
            crate::error::DefaultUndefinedFault {
                message: self.message,
            }
        }
    }
}
impl DefaultUndefinedFault {
    /// Creates a new builder-style object to manufacture [`DefaultUndefinedFault`](crate::error::DefaultUndefinedFault)
    pub fn builder() -> crate::error::default_undefined_fault::Builder {
        crate::error::default_undefined_fault::Builder::default()
    }
}

/// <p>Returned when the specified domain has been deprecated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainDeprecatedFault {
    /// <p>A description that may help with diagnosing the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DomainDeprecatedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainDeprecatedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DomainDeprecatedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DomainDeprecatedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DomainDeprecatedFault")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for DomainDeprecatedFault {}
/// See [`DomainDeprecatedFault`](crate::error::DomainDeprecatedFault)
pub mod domain_deprecated_fault {
    /// A builder for [`DomainDeprecatedFault`](crate::error::DomainDeprecatedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that may help with diagnosing the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainDeprecatedFault`](crate::error::DomainDeprecatedFault)
        pub fn build(self) -> crate::error::DomainDeprecatedFault {
            crate::error::DomainDeprecatedFault {
                message: self.message,
            }
        }
    }
}
impl DomainDeprecatedFault {
    /// Creates a new builder-style object to manufacture [`DomainDeprecatedFault`](crate::error::DomainDeprecatedFault)
    pub fn builder() -> crate::error::domain_deprecated_fault::Builder {
        crate::error::domain_deprecated_fault::Builder::default()
    }
}
