// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents a workflow type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowType {
    /// <p>
    /// The name of the workflow type.</p>
    /// <note>
    /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
    /// </note>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The version of the workflow type.</p>
    /// <note>
    /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
    /// </note>
    pub version: std::option::Option<std::string::String>,
}
impl WorkflowType {
    /// <p>
    /// The name of the workflow type.</p>
    /// <note>
    /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
    /// </note>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// The version of the workflow type.</p>
    /// <note>
    /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
    /// </note>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for WorkflowType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowType");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`WorkflowType`](crate::model::WorkflowType)
pub mod workflow_type {
    /// A builder for [`WorkflowType`](crate::model::WorkflowType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the workflow type.</p>
        /// <note>
        /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
        /// </note>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the workflow type.</p>
        /// <note>
        /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The version of the workflow type.</p>
        /// <note>
        /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
        /// </note>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>
        /// The version of the workflow type.</p>
        /// <note>
        /// <p>The combination of workflow type name and version must be unique with in a domain.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowType`](crate::model::WorkflowType)
        pub fn build(self) -> crate::model::WorkflowType {
            crate::model::WorkflowType {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl WorkflowType {
    /// Creates a new builder-style object to manufacture [`WorkflowType`](crate::model::WorkflowType)
    pub fn builder() -> crate::model::workflow_type::Builder {
        crate::model::workflow_type::Builder::default()
    }
}

/// <p>Represents an activity type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityType {
    /// <p>The name of this activity.</p>
    /// <note>
    /// <p>The combination of activity type name and version must be unique within a domain.</p>
    /// </note>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of this activity.</p>
    /// <note>
    /// <p>The combination of activity type name and version must be unique with in a domain.</p>
    /// </note>
    pub version: std::option::Option<std::string::String>,
}
impl ActivityType {
    /// <p>The name of this activity.</p>
    /// <note>
    /// <p>The combination of activity type name and version must be unique within a domain.</p>
    /// </note>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of this activity.</p>
    /// <note>
    /// <p>The combination of activity type name and version must be unique with in a domain.</p>
    /// </note>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for ActivityType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityType");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ActivityType`](crate::model::ActivityType)
pub mod activity_type {
    /// A builder for [`ActivityType`](crate::model::ActivityType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this activity.</p>
        /// <note>
        /// <p>The combination of activity type name and version must be unique within a domain.</p>
        /// </note>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this activity.</p>
        /// <note>
        /// <p>The combination of activity type name and version must be unique within a domain.</p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of this activity.</p>
        /// <note>
        /// <p>The combination of activity type name and version must be unique with in a domain.</p>
        /// </note>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of this activity.</p>
        /// <note>
        /// <p>The combination of activity type name and version must be unique with in a domain.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityType`](crate::model::ActivityType)
        pub fn build(self) -> crate::model::ActivityType {
            crate::model::ActivityType {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl ActivityType {
    /// Creates a new builder-style object to manufacture [`ActivityType`](crate::model::ActivityType)
    pub fn builder() -> crate::model::activity_type::Builder {
        crate::model::activity_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChildPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Abandon,
    #[allow(missing_docs)] // documentation missing in model
    RequestCancel,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChildPolicy {
    fn from(s: &str) -> Self {
        match s {
            "ABANDON" => ChildPolicy::Abandon,
            "REQUEST_CANCEL" => ChildPolicy::RequestCancel,
            "TERMINATE" => ChildPolicy::Terminate,
            other => ChildPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChildPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChildPolicy::from(s))
    }
}
impl ChildPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChildPolicy::Abandon => "ABANDON",
            ChildPolicy::RequestCancel => "REQUEST_CANCEL",
            ChildPolicy::Terminate => "TERMINATE",
            ChildPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABANDON", "REQUEST_CANCEL", "TERMINATE"]
    }
}
impl AsRef<str> for ChildPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Tags are key-value pairs that can be associated with Amazon SWF state machines and
/// activities.</p>
/// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTag {
    /// <p>The key of a tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of a tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ResourceTag {
    /// <p>The key of a tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of a tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ResourceTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ResourceTag`](crate::model::ResourceTag)
pub mod resource_tag {
    /// A builder for [`ResourceTag`](crate::model::ResourceTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of a tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of a tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of a tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTag`](crate::model::ResourceTag)
        pub fn build(self) -> crate::model::ResourceTag {
            crate::model::ResourceTag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ResourceTag {
    /// Creates a new builder-style object to manufacture [`ResourceTag`](crate::model::ResourceTag)
    pub fn builder() -> crate::model::resource_tag::Builder {
        crate::model::resource_tag::Builder::default()
    }
}

/// <p>Represents a task list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskList {
    /// <p>The name of the task list.</p>
    pub name: std::option::Option<std::string::String>,
}
impl TaskList {
    /// <p>The name of the task list.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for TaskList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskList");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`TaskList`](crate::model::TaskList)
pub mod task_list {
    /// A builder for [`TaskList`](crate::model::TaskList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the task list.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the task list.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskList`](crate::model::TaskList)
        pub fn build(self) -> crate::model::TaskList {
            crate::model::TaskList { name: self.name }
        }
    }
}
impl TaskList {
    /// Creates a new builder-style object to manufacture [`TaskList`](crate::model::TaskList)
    pub fn builder() -> crate::model::task_list::Builder {
        crate::model::task_list::Builder::default()
    }
}

/// <p>Specifies a decision made by the decider. A decision can be one of these types:</p>
/// <ul>
/// <li>
/// <p>
/// <code>CancelTimer</code> – Cancels a previously started timer and records a <code>TimerCanceled</code> event in the
/// history.</p>
/// </li>
/// <li>
/// <p>
/// <code>CancelWorkflowExecution</code> – Closes the workflow execution and records a
/// <code>WorkflowExecutionCanceled</code> event in the history.</p>
/// </li>
/// <li>
/// <p>
/// <code>CompleteWorkflowExecution</code> – Closes the workflow execution and records a
/// <code>WorkflowExecutionCompleted</code> event in the history .</p>
/// </li>
/// <li>
/// <p>
/// <code>ContinueAsNewWorkflowExecution</code> – Closes the workflow execution and starts a new workflow execution of the
/// same type using the same workflow ID and a unique run Id. A <code>WorkflowExecutionContinuedAsNew</code> event
/// is recorded in the history.</p>
/// </li>
/// <li>
/// <p>
/// <code>FailWorkflowExecution</code> – Closes the workflow execution and records a <code>WorkflowExecutionFailed</code>
/// event in the history.</p>
/// </li>
/// <li>
/// <p>
/// <code>RecordMarker</code> – Records a <code>MarkerRecorded</code> event in the history. Markers can be used for adding
/// custom information in the history for instance to let deciders know that they don't need to look at the history
/// beyond the marker event.</p>
/// </li>
/// <li>
/// <p>
/// <code>RequestCancelActivityTask</code> – Attempts to cancel a previously scheduled activity task. If the activity task
/// was scheduled but has not been assigned to a worker, then it is canceled. If the activity task was already
/// assigned to a worker, then the worker is informed that cancellation has been requested in the response to
/// <a>RecordActivityTaskHeartbeat</a>.</p>
/// </li>
/// <li>
/// <p>
/// <code>RequestCancelExternalWorkflowExecution</code> – Requests that a request be made to cancel the specified external
/// workflow execution and records a <code>RequestCancelExternalWorkflowExecutionInitiated</code> event in the
/// history.</p>
/// </li>
/// <li>
/// <p>
/// <code>ScheduleActivityTask</code> – Schedules an activity task.</p>
/// </li>
/// <li>
/// <p>
/// <code>SignalExternalWorkflowExecution</code> – Requests a signal to be delivered to the specified external workflow
/// execution and records a <code>SignalExternalWorkflowExecutionInitiated</code> event in the history.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartChildWorkflowExecution</code> – Requests that a child workflow execution be started and records a
/// <code>StartChildWorkflowExecutionInitiated</code> event in the history. The child workflow execution is a
/// separate workflow execution with its own history.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartTimer</code> – Starts a timer for this workflow execution and records a <code>TimerStarted</code> event in
/// the history. This timer fires after the specified delay and record a <code>TimerFired</code> event.</p>
/// </li>
/// </ul>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>If you grant permission to use <code>RespondDecisionTaskCompleted</code>, you can use IAM policies to express
/// permissions for the list of decisions returned by this action as if they were members of the API. Treating
/// decisions as a pseudo API maintains a uniform conceptual model and helps keep policies readable. For details and
/// example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
/// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
///
/// <p>
/// <b>Decision Failure</b>
/// </p>
///
/// <p>Decisions can fail for several reasons</p>
///
/// <ul>
/// <li>
/// <p>The ordering of decisions should follow a logical flow. Some decisions might not make sense in the current context of the workflow execution and therefore fails.</p>
/// </li>
/// <li>
/// <p>A limit on your account was reached.</p>
/// </li>
/// <li>
/// <p>The decision lacks sufficient permissions.</p>
/// </li>
/// </ul>
///
/// <p>One of the following events might be added to the history to indicate an error. The event attribute's
/// <code>cause</code> parameter indicates the cause. If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
/// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
/// in the <i>Amazon SWF Developer Guide</i>.</p>
///
/// <ul>
/// <li>
/// <p>
/// <code>ScheduleActivityTaskFailed</code> – A <code>ScheduleActivityTask</code> decision failed. This could happen if the
/// activity type specified in the decision isn't registered, is in a deprecated state, or the decision isn't
/// properly configured.</p>
/// </li>
/// <li>
/// <p>
/// <code>RequestCancelActivityTaskFailed</code> – A
/// <code>RequestCancelActivityTask</code> decision failed. This could happen if
/// there is no open activity task with the specified activityId.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartTimerFailed</code> – A <code>StartTimer</code> decision failed. This
/// could happen if there is another open timer with the same timerId.</p>
/// </li>
/// <li>
/// <p>
/// <code>CancelTimerFailed</code> – A <code>CancelTimer</code> decision failed.
/// This could happen if there is no open timer with the specified
/// timerId.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartChildWorkflowExecutionFailed</code> – A
/// <code>StartChildWorkflowExecution</code> decision failed. This could happen
/// if the workflow type specified isn't registered, is deprecated, or the decision
/// isn't properly configured.</p>
/// </li>
/// <li>
/// <p>
/// <code>SignalExternalWorkflowExecutionFailed</code> – A
/// <code>SignalExternalWorkflowExecution</code> decision failed. This could
/// happen if the <code>workflowID</code> specified in the decision was
/// incorrect.</p>
/// </li>
/// <li>
/// <p>
/// <code>RequestCancelExternalWorkflowExecutionFailed</code> – A
/// <code>RequestCancelExternalWorkflowExecution</code> decision failed. This
/// could happen if the <code>workflowID</code> specified in the decision was
/// incorrect.</p>
/// </li>
/// <li>
/// <p>
/// <code>CancelWorkflowExecutionFailed</code> – A
/// <code>CancelWorkflowExecution</code> decision failed. This could happen if
/// there is an unhandled decision task pending in the workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>CompleteWorkflowExecutionFailed</code> – A
/// <code>CompleteWorkflowExecution</code> decision failed. This could happen if
/// there is an unhandled decision task pending in the workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>ContinueAsNewWorkflowExecutionFailed</code> – A
/// <code>ContinueAsNewWorkflowExecution</code> decision failed. This could
/// happen if there is an unhandled decision task pending in the workflow execution
/// or the ContinueAsNewWorkflowExecution decision was not configured
/// correctly.</p>
/// </li>
/// <li>
/// <p>
/// <code>FailWorkflowExecutionFailed</code> – A <code>FailWorkflowExecution</code>
/// decision failed. This could happen if there is an unhandled decision task
/// pending in the workflow execution.</p>
/// </li>
/// </ul>
/// <p>The preceding error events might occur due to an error in the decider logic, which might put the workflow execution in an unstable state The cause field in the event structure for the error event indicates the cause of the error.</p>
/// <note>
/// <p>A workflow execution may be closed by the decider by returning one of the following decisions when completing
/// a decision task: <code>CompleteWorkflowExecution</code>, <code>FailWorkflowExecution</code>,
/// <code>CancelWorkflowExecution</code> and <code>ContinueAsNewWorkflowExecution</code>. An <code>UnhandledDecision</code> fault
/// is returned if a workflow closing decision is specified and a signal or activity event had been added to the
/// history while the decision task was being performed by the decider. Unlike the above situations which are logic
/// issues, this fault is always possible because of race conditions in a distributed system. The right action here is
/// to call <a>RespondDecisionTaskCompleted</a>  without any decisions. This would result in another decision task
/// with these new events included in the history. The decider should handle the new events and may decide to close
/// the workflow execution.</p>
/// </note>
/// <p>
/// <b>How to Code a Decision</b>
/// </p>
/// <p>You code a decision by first setting the decision type field to one of the above decision values, and then set the corresponding attributes field shown below:</p>
/// <ul>
/// <li>
/// <p>
/// <code>
/// <a>ScheduleActivityTaskDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>RequestCancelActivityTaskDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>CompleteWorkflowExecutionDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>FailWorkflowExecutionDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>CancelWorkflowExecutionDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>ContinueAsNewWorkflowExecutionDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>RecordMarkerDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>StartTimerDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>CancelTimerDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>SignalExternalWorkflowExecutionDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>RequestCancelExternalWorkflowExecutionDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>
/// <a>StartChildWorkflowExecutionDecisionAttributes</a>
/// </code>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Decision {
    /// <p>Specifies the type of the decision.</p>
    pub decision_type: std::option::Option<crate::model::DecisionType>,
    /// <p>Provides the details of the <code>ScheduleActivityTask</code> decision. It isn't set for other decision types.</p>
    pub schedule_activity_task_decision_attributes:
        std::option::Option<crate::model::ScheduleActivityTaskDecisionAttributes>,
    /// <p>Provides the details of the <code>RequestCancelActivityTask</code> decision. It isn't set for other decision types.</p>
    pub request_cancel_activity_task_decision_attributes:
        std::option::Option<crate::model::RequestCancelActivityTaskDecisionAttributes>,
    /// <p>Provides the details of the <code>CompleteWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub complete_workflow_execution_decision_attributes:
        std::option::Option<crate::model::CompleteWorkflowExecutionDecisionAttributes>,
    /// <p>Provides the details of the <code>FailWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub fail_workflow_execution_decision_attributes:
        std::option::Option<crate::model::FailWorkflowExecutionDecisionAttributes>,
    /// <p>Provides the details of the <code>CancelWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub cancel_workflow_execution_decision_attributes:
        std::option::Option<crate::model::CancelWorkflowExecutionDecisionAttributes>,
    /// <p>Provides the details of the <code>ContinueAsNewWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub continue_as_new_workflow_execution_decision_attributes:
        std::option::Option<crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes>,
    /// <p>Provides the details of the <code>RecordMarker</code> decision. It isn't set for other decision types.</p>
    pub record_marker_decision_attributes:
        std::option::Option<crate::model::RecordMarkerDecisionAttributes>,
    /// <p>Provides the details of the <code>StartTimer</code> decision. It isn't set for other decision types.</p>
    pub start_timer_decision_attributes:
        std::option::Option<crate::model::StartTimerDecisionAttributes>,
    /// <p>Provides the details of the <code>CancelTimer</code> decision. It isn't set for other decision types.</p>
    pub cancel_timer_decision_attributes:
        std::option::Option<crate::model::CancelTimerDecisionAttributes>,
    /// <p>Provides the details of the <code>SignalExternalWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub signal_external_workflow_execution_decision_attributes:
        std::option::Option<crate::model::SignalExternalWorkflowExecutionDecisionAttributes>,
    /// <p>Provides the details of the <code>RequestCancelExternalWorkflowExecution</code> decision.
    /// It isn't set for other decision types.</p>
    pub request_cancel_external_workflow_execution_decision_attributes:
        std::option::Option<crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes>,
    /// <p>Provides the details of the <code>StartChildWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub start_child_workflow_execution_decision_attributes:
        std::option::Option<crate::model::StartChildWorkflowExecutionDecisionAttributes>,
    /// <p>Provides the details of the <code>ScheduleLambdaFunction</code> decision. It isn't set
    /// for other decision types.</p>
    pub schedule_lambda_function_decision_attributes:
        std::option::Option<crate::model::ScheduleLambdaFunctionDecisionAttributes>,
}
impl Decision {
    /// <p>Specifies the type of the decision.</p>
    pub fn decision_type(&self) -> std::option::Option<&crate::model::DecisionType> {
        self.decision_type.as_ref()
    }
    /// <p>Provides the details of the <code>ScheduleActivityTask</code> decision. It isn't set for other decision types.</p>
    pub fn schedule_activity_task_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ScheduleActivityTaskDecisionAttributes> {
        self.schedule_activity_task_decision_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>RequestCancelActivityTask</code> decision. It isn't set for other decision types.</p>
    pub fn request_cancel_activity_task_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::RequestCancelActivityTaskDecisionAttributes> {
        self.request_cancel_activity_task_decision_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>CompleteWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub fn complete_workflow_execution_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::CompleteWorkflowExecutionDecisionAttributes> {
        self.complete_workflow_execution_decision_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>FailWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub fn fail_workflow_execution_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::FailWorkflowExecutionDecisionAttributes> {
        self.fail_workflow_execution_decision_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>CancelWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub fn cancel_workflow_execution_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::CancelWorkflowExecutionDecisionAttributes> {
        self.cancel_workflow_execution_decision_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>ContinueAsNewWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub fn continue_as_new_workflow_execution_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes> {
        self.continue_as_new_workflow_execution_decision_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>RecordMarker</code> decision. It isn't set for other decision types.</p>
    pub fn record_marker_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::RecordMarkerDecisionAttributes> {
        self.record_marker_decision_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>StartTimer</code> decision. It isn't set for other decision types.</p>
    pub fn start_timer_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::StartTimerDecisionAttributes> {
        self.start_timer_decision_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>CancelTimer</code> decision. It isn't set for other decision types.</p>
    pub fn cancel_timer_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::CancelTimerDecisionAttributes> {
        self.cancel_timer_decision_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>SignalExternalWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub fn signal_external_workflow_execution_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::SignalExternalWorkflowExecutionDecisionAttributes> {
        self.signal_external_workflow_execution_decision_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>RequestCancelExternalWorkflowExecution</code> decision.
    /// It isn't set for other decision types.</p>
    pub fn request_cancel_external_workflow_execution_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes>
    {
        self.request_cancel_external_workflow_execution_decision_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>StartChildWorkflowExecution</code> decision. It isn't set for other decision types.</p>
    pub fn start_child_workflow_execution_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::StartChildWorkflowExecutionDecisionAttributes> {
        self.start_child_workflow_execution_decision_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>ScheduleLambdaFunction</code> decision. It isn't set
    /// for other decision types.</p>
    pub fn schedule_lambda_function_decision_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ScheduleLambdaFunctionDecisionAttributes> {
        self.schedule_lambda_function_decision_attributes.as_ref()
    }
}
impl std::fmt::Debug for Decision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Decision");
        formatter.field("decision_type", &self.decision_type);
        formatter.field(
            "schedule_activity_task_decision_attributes",
            &self.schedule_activity_task_decision_attributes,
        );
        formatter.field(
            "request_cancel_activity_task_decision_attributes",
            &self.request_cancel_activity_task_decision_attributes,
        );
        formatter.field(
            "complete_workflow_execution_decision_attributes",
            &self.complete_workflow_execution_decision_attributes,
        );
        formatter.field(
            "fail_workflow_execution_decision_attributes",
            &self.fail_workflow_execution_decision_attributes,
        );
        formatter.field(
            "cancel_workflow_execution_decision_attributes",
            &self.cancel_workflow_execution_decision_attributes,
        );
        formatter.field(
            "continue_as_new_workflow_execution_decision_attributes",
            &self.continue_as_new_workflow_execution_decision_attributes,
        );
        formatter.field(
            "record_marker_decision_attributes",
            &self.record_marker_decision_attributes,
        );
        formatter.field(
            "start_timer_decision_attributes",
            &self.start_timer_decision_attributes,
        );
        formatter.field(
            "cancel_timer_decision_attributes",
            &self.cancel_timer_decision_attributes,
        );
        formatter.field(
            "signal_external_workflow_execution_decision_attributes",
            &self.signal_external_workflow_execution_decision_attributes,
        );
        formatter.field(
            "request_cancel_external_workflow_execution_decision_attributes",
            &self.request_cancel_external_workflow_execution_decision_attributes,
        );
        formatter.field(
            "start_child_workflow_execution_decision_attributes",
            &self.start_child_workflow_execution_decision_attributes,
        );
        formatter.field(
            "schedule_lambda_function_decision_attributes",
            &self.schedule_lambda_function_decision_attributes,
        );
        formatter.finish()
    }
}
/// See [`Decision`](crate::model::Decision)
pub mod decision {
    /// A builder for [`Decision`](crate::model::Decision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) decision_type: std::option::Option<crate::model::DecisionType>,
        pub(crate) schedule_activity_task_decision_attributes:
            std::option::Option<crate::model::ScheduleActivityTaskDecisionAttributes>,
        pub(crate) request_cancel_activity_task_decision_attributes:
            std::option::Option<crate::model::RequestCancelActivityTaskDecisionAttributes>,
        pub(crate) complete_workflow_execution_decision_attributes:
            std::option::Option<crate::model::CompleteWorkflowExecutionDecisionAttributes>,
        pub(crate) fail_workflow_execution_decision_attributes:
            std::option::Option<crate::model::FailWorkflowExecutionDecisionAttributes>,
        pub(crate) cancel_workflow_execution_decision_attributes:
            std::option::Option<crate::model::CancelWorkflowExecutionDecisionAttributes>,
        pub(crate) continue_as_new_workflow_execution_decision_attributes:
            std::option::Option<crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes>,
        pub(crate) record_marker_decision_attributes:
            std::option::Option<crate::model::RecordMarkerDecisionAttributes>,
        pub(crate) start_timer_decision_attributes:
            std::option::Option<crate::model::StartTimerDecisionAttributes>,
        pub(crate) cancel_timer_decision_attributes:
            std::option::Option<crate::model::CancelTimerDecisionAttributes>,
        pub(crate) signal_external_workflow_execution_decision_attributes:
            std::option::Option<crate::model::SignalExternalWorkflowExecutionDecisionAttributes>,
        pub(crate) request_cancel_external_workflow_execution_decision_attributes:
            std::option::Option<
                crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes,
            >,
        pub(crate) start_child_workflow_execution_decision_attributes:
            std::option::Option<crate::model::StartChildWorkflowExecutionDecisionAttributes>,
        pub(crate) schedule_lambda_function_decision_attributes:
            std::option::Option<crate::model::ScheduleLambdaFunctionDecisionAttributes>,
    }
    impl Builder {
        /// <p>Specifies the type of the decision.</p>
        pub fn decision_type(mut self, input: crate::model::DecisionType) -> Self {
            self.decision_type = Some(input);
            self
        }
        /// <p>Specifies the type of the decision.</p>
        pub fn set_decision_type(
            mut self,
            input: std::option::Option<crate::model::DecisionType>,
        ) -> Self {
            self.decision_type = input;
            self
        }
        /// <p>Provides the details of the <code>ScheduleActivityTask</code> decision. It isn't set for other decision types.</p>
        pub fn schedule_activity_task_decision_attributes(
            mut self,
            input: crate::model::ScheduleActivityTaskDecisionAttributes,
        ) -> Self {
            self.schedule_activity_task_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>ScheduleActivityTask</code> decision. It isn't set for other decision types.</p>
        pub fn set_schedule_activity_task_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::ScheduleActivityTaskDecisionAttributes>,
        ) -> Self {
            self.schedule_activity_task_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>RequestCancelActivityTask</code> decision. It isn't set for other decision types.</p>
        pub fn request_cancel_activity_task_decision_attributes(
            mut self,
            input: crate::model::RequestCancelActivityTaskDecisionAttributes,
        ) -> Self {
            self.request_cancel_activity_task_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>RequestCancelActivityTask</code> decision. It isn't set for other decision types.</p>
        pub fn set_request_cancel_activity_task_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::RequestCancelActivityTaskDecisionAttributes>,
        ) -> Self {
            self.request_cancel_activity_task_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>CompleteWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn complete_workflow_execution_decision_attributes(
            mut self,
            input: crate::model::CompleteWorkflowExecutionDecisionAttributes,
        ) -> Self {
            self.complete_workflow_execution_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>CompleteWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn set_complete_workflow_execution_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::CompleteWorkflowExecutionDecisionAttributes>,
        ) -> Self {
            self.complete_workflow_execution_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>FailWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn fail_workflow_execution_decision_attributes(
            mut self,
            input: crate::model::FailWorkflowExecutionDecisionAttributes,
        ) -> Self {
            self.fail_workflow_execution_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>FailWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn set_fail_workflow_execution_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::FailWorkflowExecutionDecisionAttributes>,
        ) -> Self {
            self.fail_workflow_execution_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>CancelWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn cancel_workflow_execution_decision_attributes(
            mut self,
            input: crate::model::CancelWorkflowExecutionDecisionAttributes,
        ) -> Self {
            self.cancel_workflow_execution_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>CancelWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn set_cancel_workflow_execution_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::CancelWorkflowExecutionDecisionAttributes>,
        ) -> Self {
            self.cancel_workflow_execution_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>ContinueAsNewWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn continue_as_new_workflow_execution_decision_attributes(
            mut self,
            input: crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes,
        ) -> Self {
            self.continue_as_new_workflow_execution_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>ContinueAsNewWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn set_continue_as_new_workflow_execution_decision_attributes(
            mut self,
            input: std::option::Option<
                crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes,
            >,
        ) -> Self {
            self.continue_as_new_workflow_execution_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>RecordMarker</code> decision. It isn't set for other decision types.</p>
        pub fn record_marker_decision_attributes(
            mut self,
            input: crate::model::RecordMarkerDecisionAttributes,
        ) -> Self {
            self.record_marker_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>RecordMarker</code> decision. It isn't set for other decision types.</p>
        pub fn set_record_marker_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::RecordMarkerDecisionAttributes>,
        ) -> Self {
            self.record_marker_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>StartTimer</code> decision. It isn't set for other decision types.</p>
        pub fn start_timer_decision_attributes(
            mut self,
            input: crate::model::StartTimerDecisionAttributes,
        ) -> Self {
            self.start_timer_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>StartTimer</code> decision. It isn't set for other decision types.</p>
        pub fn set_start_timer_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::StartTimerDecisionAttributes>,
        ) -> Self {
            self.start_timer_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>CancelTimer</code> decision. It isn't set for other decision types.</p>
        pub fn cancel_timer_decision_attributes(
            mut self,
            input: crate::model::CancelTimerDecisionAttributes,
        ) -> Self {
            self.cancel_timer_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>CancelTimer</code> decision. It isn't set for other decision types.</p>
        pub fn set_cancel_timer_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::CancelTimerDecisionAttributes>,
        ) -> Self {
            self.cancel_timer_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>SignalExternalWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn signal_external_workflow_execution_decision_attributes(
            mut self,
            input: crate::model::SignalExternalWorkflowExecutionDecisionAttributes,
        ) -> Self {
            self.signal_external_workflow_execution_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>SignalExternalWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn set_signal_external_workflow_execution_decision_attributes(
            mut self,
            input: std::option::Option<
                crate::model::SignalExternalWorkflowExecutionDecisionAttributes,
            >,
        ) -> Self {
            self.signal_external_workflow_execution_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>RequestCancelExternalWorkflowExecution</code> decision.
        /// It isn't set for other decision types.</p>
        pub fn request_cancel_external_workflow_execution_decision_attributes(
            mut self,
            input: crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes,
        ) -> Self {
            self.request_cancel_external_workflow_execution_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>RequestCancelExternalWorkflowExecution</code> decision.
        /// It isn't set for other decision types.</p>
        pub fn set_request_cancel_external_workflow_execution_decision_attributes(
            mut self,
            input: std::option::Option<
                crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes,
            >,
        ) -> Self {
            self.request_cancel_external_workflow_execution_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>StartChildWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn start_child_workflow_execution_decision_attributes(
            mut self,
            input: crate::model::StartChildWorkflowExecutionDecisionAttributes,
        ) -> Self {
            self.start_child_workflow_execution_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>StartChildWorkflowExecution</code> decision. It isn't set for other decision types.</p>
        pub fn set_start_child_workflow_execution_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::StartChildWorkflowExecutionDecisionAttributes>,
        ) -> Self {
            self.start_child_workflow_execution_decision_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>ScheduleLambdaFunction</code> decision. It isn't set
        /// for other decision types.</p>
        pub fn schedule_lambda_function_decision_attributes(
            mut self,
            input: crate::model::ScheduleLambdaFunctionDecisionAttributes,
        ) -> Self {
            self.schedule_lambda_function_decision_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>ScheduleLambdaFunction</code> decision. It isn't set
        /// for other decision types.</p>
        pub fn set_schedule_lambda_function_decision_attributes(
            mut self,
            input: std::option::Option<crate::model::ScheduleLambdaFunctionDecisionAttributes>,
        ) -> Self {
            self.schedule_lambda_function_decision_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Decision`](crate::model::Decision)
        pub fn build(self) -> crate::model::Decision {
            crate::model::Decision {
                decision_type: self.decision_type,
                schedule_activity_task_decision_attributes: self
                    .schedule_activity_task_decision_attributes,
                request_cancel_activity_task_decision_attributes: self
                    .request_cancel_activity_task_decision_attributes,
                complete_workflow_execution_decision_attributes: self
                    .complete_workflow_execution_decision_attributes,
                fail_workflow_execution_decision_attributes: self
                    .fail_workflow_execution_decision_attributes,
                cancel_workflow_execution_decision_attributes: self
                    .cancel_workflow_execution_decision_attributes,
                continue_as_new_workflow_execution_decision_attributes: self
                    .continue_as_new_workflow_execution_decision_attributes,
                record_marker_decision_attributes: self.record_marker_decision_attributes,
                start_timer_decision_attributes: self.start_timer_decision_attributes,
                cancel_timer_decision_attributes: self.cancel_timer_decision_attributes,
                signal_external_workflow_execution_decision_attributes: self
                    .signal_external_workflow_execution_decision_attributes,
                request_cancel_external_workflow_execution_decision_attributes: self
                    .request_cancel_external_workflow_execution_decision_attributes,
                start_child_workflow_execution_decision_attributes: self
                    .start_child_workflow_execution_decision_attributes,
                schedule_lambda_function_decision_attributes: self
                    .schedule_lambda_function_decision_attributes,
            }
        }
    }
}
impl Decision {
    /// Creates a new builder-style object to manufacture [`Decision`](crate::model::Decision)
    pub fn builder() -> crate::model::decision::Builder {
        crate::model::decision::Builder::default()
    }
}

/// <p>Decision attributes specified in <code>scheduleLambdaFunctionDecisionAttributes</code> within the list of
/// decisions <code>decisions</code> passed to <a>RespondDecisionTaskCompleted</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleLambdaFunctionDecisionAttributes {
    /// <p>A string that identifies the Lambda function execution in the event history.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name, or ARN, of the Lambda function to schedule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the Lambda task.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>The optional input data to be supplied to the Lambda function.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The timeout value, in seconds, after which the Lambda function is considered to be failed once it has started. This can be any integer from 1-300 (1s-5m). If no value is supplied, than a default value of 300s is assumed.</p>
    pub start_to_close_timeout: std::option::Option<std::string::String>,
}
impl ScheduleLambdaFunctionDecisionAttributes {
    /// <p>A string that identifies the Lambda function execution in the event history.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name, or ARN, of the Lambda function to schedule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the Lambda task.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>The optional input data to be supplied to the Lambda function.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The timeout value, in seconds, after which the Lambda function is considered to be failed once it has started. This can be any integer from 1-300 (1s-5m). If no value is supplied, than a default value of 300s is assumed.</p>
    pub fn start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.start_to_close_timeout.as_deref()
    }
}
impl std::fmt::Debug for ScheduleLambdaFunctionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleLambdaFunctionDecisionAttributes");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("control", &self.control);
        formatter.field("input", &self.input);
        formatter.field("start_to_close_timeout", &self.start_to_close_timeout);
        formatter.finish()
    }
}
/// See [`ScheduleLambdaFunctionDecisionAttributes`](crate::model::ScheduleLambdaFunctionDecisionAttributes)
pub mod schedule_lambda_function_decision_attributes {
    /// A builder for [`ScheduleLambdaFunctionDecisionAttributes`](crate::model::ScheduleLambdaFunctionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) start_to_close_timeout: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string that identifies the Lambda function execution in the event history.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A string that identifies the Lambda function execution in the event history.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name, or ARN, of the Lambda function to schedule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name, or ARN, of the Lambda function to schedule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the Lambda task.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the Lambda task.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>The optional input data to be supplied to the Lambda function.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The optional input data to be supplied to the Lambda function.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The timeout value, in seconds, after which the Lambda function is considered to be failed once it has started. This can be any integer from 1-300 (1s-5m). If no value is supplied, than a default value of 300s is assumed.</p>
        pub fn start_to_close_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The timeout value, in seconds, after which the Lambda function is considered to be failed once it has started. This can be any integer from 1-300 (1s-5m). If no value is supplied, than a default value of 300s is assumed.</p>
        pub fn set_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_to_close_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleLambdaFunctionDecisionAttributes`](crate::model::ScheduleLambdaFunctionDecisionAttributes)
        pub fn build(self) -> crate::model::ScheduleLambdaFunctionDecisionAttributes {
            crate::model::ScheduleLambdaFunctionDecisionAttributes {
                id: self.id,
                name: self.name,
                control: self.control,
                input: self.input,
                start_to_close_timeout: self.start_to_close_timeout,
            }
        }
    }
}
impl ScheduleLambdaFunctionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`ScheduleLambdaFunctionDecisionAttributes`](crate::model::ScheduleLambdaFunctionDecisionAttributes)
    pub fn builder() -> crate::model::schedule_lambda_function_decision_attributes::Builder {
        crate::model::schedule_lambda_function_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>StartChildWorkflowExecution</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>Constrain the following parameters by using a <code>Condition</code> element with the
/// appropriate keys.</p>
/// <ul>
/// <li>
/// <p>
/// <code>tagList.member.N</code> – The key is "swf:tagList.N" where N is the tag number from 0 to 4,
/// inclusive.</p>
/// </li>
/// <li>
/// <p>
/// <code>taskList</code> – String constraint. The key is <code>swf:taskList.name</code>.</p>
/// </li>
/// <li>
/// <p>
/// <code>workflowType.name</code> – String constraint. The key is <code>swf:workflowType.name</code>.</p>
/// </li>
/// <li>
/// <p>
/// <code>workflowType.version</code> – String constraint. The key is <code>swf:workflowType.version</code>.</p>
/// </li>
/// </ul>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartChildWorkflowExecutionDecisionAttributes {
    /// <p>
    /// The type of the workflow execution to be started.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>
    /// The <code>workflowId</code> of the workflow execution.</p>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the child workflow execution.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>The input to be provided to the workflow execution.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The name of the task list to be used for decision tasks of the child workflow execution.</p>
    /// <note>
    /// <p>A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.</p>
    /// </note>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// A task priority that, if set, specifies the priority for a decision task of this workflow
    /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
    /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>
    /// If set, specifies the policy to use for the child workflow executions if the workflow execution
    /// being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
    /// expired timeout. This policy overrides the default child policy specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You can
    /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
    /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
    pub tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IAM role attached to the child workflow execution.</p>
    pub lambda_role: std::option::Option<std::string::String>,
}
impl StartChildWorkflowExecutionDecisionAttributes {
    /// <p>
    /// The type of the workflow execution to be started.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>
    /// The <code>workflowId</code> of the workflow execution.</p>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the child workflow execution.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>The input to be provided to the workflow execution.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.execution_start_to_close_timeout.as_deref()
    }
    /// <p>The name of the task list to be used for decision tasks of the child workflow execution.</p>
    /// <note>
    /// <p>A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.</p>
    /// </note>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>
    /// A task priority that, if set, specifies the priority for a decision task of this workflow
    /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
    /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.task_start_to_close_timeout.as_deref()
    }
    /// <p>
    /// If set, specifies the policy to use for the child workflow executions if the workflow execution
    /// being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
    /// expired timeout. This policy overrides the default child policy specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You can
    /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
    /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
    pub fn tag_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_list.as_deref()
    }
    /// <p>The IAM role attached to the child workflow execution.</p>
    pub fn lambda_role(&self) -> std::option::Option<&str> {
        self.lambda_role.as_deref()
    }
}
impl std::fmt::Debug for StartChildWorkflowExecutionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartChildWorkflowExecutionDecisionAttributes");
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("control", &self.control);
        formatter.field("input", &self.input);
        formatter.field(
            "execution_start_to_close_timeout",
            &self.execution_start_to_close_timeout,
        );
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field(
            "task_start_to_close_timeout",
            &self.task_start_to_close_timeout,
        );
        formatter.field("child_policy", &self.child_policy);
        formatter.field("tag_list", &self.tag_list);
        formatter.field("lambda_role", &self.lambda_role);
        formatter.finish()
    }
}
/// See [`StartChildWorkflowExecutionDecisionAttributes`](crate::model::StartChildWorkflowExecutionDecisionAttributes)
pub mod start_child_workflow_execution_decision_attributes {
    /// A builder for [`StartChildWorkflowExecutionDecisionAttributes`](crate::model::StartChildWorkflowExecutionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) execution_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The type of the workflow execution to be started.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>
        /// The type of the workflow execution to be started.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>
        /// The <code>workflowId</code> of the workflow execution.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>
        /// The <code>workflowId</code> of the workflow execution.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the child workflow execution.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the child workflow execution.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>The input to be provided to the workflow execution.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input to be provided to the workflow execution.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = input;
            self
        }
        /// <p>The name of the task list to be used for decision tasks of the child workflow execution.</p>
        /// <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The name of the task list to be used for decision tasks of the child workflow execution.</p>
        /// <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>
        /// A task priority that, if set, specifies the priority for a decision task of this workflow
        /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>
        /// A task priority that, if set, specifies the priority for a decision task of this workflow
        /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
        /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
        /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = input;
            self
        }
        /// <p>
        /// If set, specifies the policy to use for the child workflow executions if the workflow execution
        /// being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
        /// expired timeout. This policy overrides the default child policy specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>
        /// If set, specifies the policy to use for the child workflow executions if the workflow execution
        /// being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
        /// expired timeout. This policy overrides the default child policy specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You can
        /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
        /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You can
        /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
        /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>The IAM role attached to the child workflow execution.</p>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_role = Some(input.into());
            self
        }
        /// <p>The IAM role attached to the child workflow execution.</p>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChildWorkflowExecutionDecisionAttributes`](crate::model::StartChildWorkflowExecutionDecisionAttributes)
        pub fn build(self) -> crate::model::StartChildWorkflowExecutionDecisionAttributes {
            crate::model::StartChildWorkflowExecutionDecisionAttributes {
                workflow_type: self.workflow_type,
                workflow_id: self.workflow_id,
                control: self.control,
                input: self.input,
                execution_start_to_close_timeout: self.execution_start_to_close_timeout,
                task_list: self.task_list,
                task_priority: self.task_priority,
                task_start_to_close_timeout: self.task_start_to_close_timeout,
                child_policy: self.child_policy,
                tag_list: self.tag_list,
                lambda_role: self.lambda_role,
            }
        }
    }
}
impl StartChildWorkflowExecutionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`StartChildWorkflowExecutionDecisionAttributes`](crate::model::StartChildWorkflowExecutionDecisionAttributes)
    pub fn builder() -> crate::model::start_child_workflow_execution_decision_attributes::Builder {
        crate::model::start_child_workflow_execution_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>RequestCancelExternalWorkflowExecution</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestCancelExternalWorkflowExecutionDecisionAttributes {
    /// <p>
    /// The <code>workflowId</code> of the external workflow execution to cancel.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The <code>runId</code> of the external workflow execution to cancel.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub control: std::option::Option<std::string::String>,
}
impl RequestCancelExternalWorkflowExecutionDecisionAttributes {
    /// <p>
    /// The <code>workflowId</code> of the external workflow execution to cancel.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The <code>runId</code> of the external workflow execution to cancel.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
}
impl std::fmt::Debug for RequestCancelExternalWorkflowExecutionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("RequestCancelExternalWorkflowExecutionDecisionAttributes");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`RequestCancelExternalWorkflowExecutionDecisionAttributes`](crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes)
pub mod request_cancel_external_workflow_execution_decision_attributes {
    /// A builder for [`RequestCancelExternalWorkflowExecutionDecisionAttributes`](crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The <code>workflowId</code> of the external workflow execution to cancel.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>
        /// The <code>workflowId</code> of the external workflow execution to cancel.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution to cancel.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution to cancel.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestCancelExternalWorkflowExecutionDecisionAttributes`](crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes)
        pub fn build(
            self,
        ) -> crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes {
            crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes {
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                control: self.control,
            }
        }
    }
}
impl RequestCancelExternalWorkflowExecutionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`RequestCancelExternalWorkflowExecutionDecisionAttributes`](crate::model::RequestCancelExternalWorkflowExecutionDecisionAttributes)
    pub fn builder(
    ) -> crate::model::request_cancel_external_workflow_execution_decision_attributes::Builder {
        crate::model::request_cancel_external_workflow_execution_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>SignalExternalWorkflowExecution</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignalExternalWorkflowExecutionDecisionAttributes {
    /// <p>
    /// The <code>workflowId</code> of the workflow execution to be signaled.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The <code>runId</code> of the workflow execution to be signaled.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the signal.The target workflow execution uses the signal name and input to
    /// process the signal.</p>
    pub signal_name: std::option::Option<std::string::String>,
    /// <p>
    /// The input data to be provided with the signal. The target workflow execution uses the signal
    /// name and input data to process the signal.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The data attached to the event that can be used by the decider in subsequent decision tasks.</p>
    pub control: std::option::Option<std::string::String>,
}
impl SignalExternalWorkflowExecutionDecisionAttributes {
    /// <p>
    /// The <code>workflowId</code> of the workflow execution to be signaled.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The <code>runId</code> of the workflow execution to be signaled.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>
    /// The name of the signal.The target workflow execution uses the signal name and input to
    /// process the signal.</p>
    pub fn signal_name(&self) -> std::option::Option<&str> {
        self.signal_name.as_deref()
    }
    /// <p>
    /// The input data to be provided with the signal. The target workflow execution uses the signal
    /// name and input data to process the signal.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The data attached to the event that can be used by the decider in subsequent decision tasks.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
}
impl std::fmt::Debug for SignalExternalWorkflowExecutionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignalExternalWorkflowExecutionDecisionAttributes");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("signal_name", &self.signal_name);
        formatter.field("input", &self.input);
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`SignalExternalWorkflowExecutionDecisionAttributes`](crate::model::SignalExternalWorkflowExecutionDecisionAttributes)
pub mod signal_external_workflow_execution_decision_attributes {
    /// A builder for [`SignalExternalWorkflowExecutionDecisionAttributes`](crate::model::SignalExternalWorkflowExecutionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) signal_name: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The <code>workflowId</code> of the workflow execution to be signaled.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>
        /// The <code>workflowId</code> of the workflow execution to be signaled.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The <code>runId</code> of the workflow execution to be signaled.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The <code>runId</code> of the workflow execution to be signaled.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>
        /// The name of the signal.The target workflow execution uses the signal name and input to
        /// process the signal.</p>
        pub fn signal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.signal_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the signal.The target workflow execution uses the signal name and input to
        /// process the signal.</p>
        pub fn set_signal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signal_name = input;
            self
        }
        /// <p>
        /// The input data to be provided with the signal. The target workflow execution uses the signal
        /// name and input data to process the signal.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>
        /// The input data to be provided with the signal. The target workflow execution uses the signal
        /// name and input data to process the signal.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent decision tasks.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent decision tasks.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`SignalExternalWorkflowExecutionDecisionAttributes`](crate::model::SignalExternalWorkflowExecutionDecisionAttributes)
        pub fn build(self) -> crate::model::SignalExternalWorkflowExecutionDecisionAttributes {
            crate::model::SignalExternalWorkflowExecutionDecisionAttributes {
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                signal_name: self.signal_name,
                input: self.input,
                control: self.control,
            }
        }
    }
}
impl SignalExternalWorkflowExecutionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`SignalExternalWorkflowExecutionDecisionAttributes`](crate::model::SignalExternalWorkflowExecutionDecisionAttributes)
    pub fn builder() -> crate::model::signal_external_workflow_execution_decision_attributes::Builder
    {
        crate::model::signal_external_workflow_execution_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>CancelTimer</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelTimerDecisionAttributes {
    /// <p>
    /// The unique ID of the timer to cancel.</p>
    pub timer_id: std::option::Option<std::string::String>,
}
impl CancelTimerDecisionAttributes {
    /// <p>
    /// The unique ID of the timer to cancel.</p>
    pub fn timer_id(&self) -> std::option::Option<&str> {
        self.timer_id.as_deref()
    }
}
impl std::fmt::Debug for CancelTimerDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelTimerDecisionAttributes");
        formatter.field("timer_id", &self.timer_id);
        formatter.finish()
    }
}
/// See [`CancelTimerDecisionAttributes`](crate::model::CancelTimerDecisionAttributes)
pub mod cancel_timer_decision_attributes {
    /// A builder for [`CancelTimerDecisionAttributes`](crate::model::CancelTimerDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The unique ID of the timer to cancel.</p>
        pub fn timer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique ID of the timer to cancel.</p>
        pub fn set_timer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelTimerDecisionAttributes`](crate::model::CancelTimerDecisionAttributes)
        pub fn build(self) -> crate::model::CancelTimerDecisionAttributes {
            crate::model::CancelTimerDecisionAttributes {
                timer_id: self.timer_id,
            }
        }
    }
}
impl CancelTimerDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`CancelTimerDecisionAttributes`](crate::model::CancelTimerDecisionAttributes)
    pub fn builder() -> crate::model::cancel_timer_decision_attributes::Builder {
        crate::model::cancel_timer_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>StartTimer</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTimerDecisionAttributes {
    /// <p>
    /// The unique ID of the timer.</p>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub timer_id: std::option::Option<std::string::String>,
    /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>
    /// The duration to wait before firing the timer.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
    pub start_to_fire_timeout: std::option::Option<std::string::String>,
}
impl StartTimerDecisionAttributes {
    /// <p>
    /// The unique ID of the timer.</p>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub fn timer_id(&self) -> std::option::Option<&str> {
        self.timer_id.as_deref()
    }
    /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>
    /// The duration to wait before firing the timer.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
    pub fn start_to_fire_timeout(&self) -> std::option::Option<&str> {
        self.start_to_fire_timeout.as_deref()
    }
}
impl std::fmt::Debug for StartTimerDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTimerDecisionAttributes");
        formatter.field("timer_id", &self.timer_id);
        formatter.field("control", &self.control);
        formatter.field("start_to_fire_timeout", &self.start_to_fire_timeout);
        formatter.finish()
    }
}
/// See [`StartTimerDecisionAttributes`](crate::model::StartTimerDecisionAttributes)
pub mod start_timer_decision_attributes {
    /// A builder for [`StartTimerDecisionAttributes`](crate::model::StartTimerDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_id: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) start_to_fire_timeout: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The unique ID of the timer.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn timer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique ID of the timer.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn set_timer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_id = input;
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>
        /// The duration to wait before firing the timer.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
        pub fn start_to_fire_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_to_fire_timeout = Some(input.into());
            self
        }
        /// <p>
        /// The duration to wait before firing the timer.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
        pub fn set_start_to_fire_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_to_fire_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTimerDecisionAttributes`](crate::model::StartTimerDecisionAttributes)
        pub fn build(self) -> crate::model::StartTimerDecisionAttributes {
            crate::model::StartTimerDecisionAttributes {
                timer_id: self.timer_id,
                control: self.control,
                start_to_fire_timeout: self.start_to_fire_timeout,
            }
        }
    }
}
impl StartTimerDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`StartTimerDecisionAttributes`](crate::model::StartTimerDecisionAttributes)
    pub fn builder() -> crate::model::start_timer_decision_attributes::Builder {
        crate::model::start_timer_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>RecordMarker</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordMarkerDecisionAttributes {
    /// <p>
    /// The name of the marker.</p>
    pub marker_name: std::option::Option<std::string::String>,
    /// <p>
    /// The details of the marker.</p>
    pub details: std::option::Option<std::string::String>,
}
impl RecordMarkerDecisionAttributes {
    /// <p>
    /// The name of the marker.</p>
    pub fn marker_name(&self) -> std::option::Option<&str> {
        self.marker_name.as_deref()
    }
    /// <p>
    /// The details of the marker.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for RecordMarkerDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordMarkerDecisionAttributes");
        formatter.field("marker_name", &self.marker_name);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`RecordMarkerDecisionAttributes`](crate::model::RecordMarkerDecisionAttributes)
pub mod record_marker_decision_attributes {
    /// A builder for [`RecordMarkerDecisionAttributes`](crate::model::RecordMarkerDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker_name: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the marker.</p>
        pub fn marker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the marker.</p>
        pub fn set_marker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker_name = input;
            self
        }
        /// <p>
        /// The details of the marker.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>
        /// The details of the marker.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordMarkerDecisionAttributes`](crate::model::RecordMarkerDecisionAttributes)
        pub fn build(self) -> crate::model::RecordMarkerDecisionAttributes {
            crate::model::RecordMarkerDecisionAttributes {
                marker_name: self.marker_name,
                details: self.details,
            }
        }
    }
}
impl RecordMarkerDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`RecordMarkerDecisionAttributes`](crate::model::RecordMarkerDecisionAttributes)
    pub fn builder() -> crate::model::record_marker_decision_attributes::Builder {
        crate::model::record_marker_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ContinueAsNewWorkflowExecution</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>Constrain the following parameters by using a <code>Condition</code> element with the
/// appropriate keys.</p>
/// <ul>
/// <li>
/// <p>
/// <code>tag</code> – A tag used to identify the workflow execution</p>
/// </li>
/// <li>
/// <p>
/// <code>taskList</code> – String constraint. The key is <code>swf:taskList.name</code>.</p>
/// </li>
/// <li>
/// <p>
/// <code>workflowType.version</code> – String constraint. The key is <code>swf:workflowType.version</code>.</p>
/// </li>
/// </ul>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinueAsNewWorkflowExecutionDecisionAttributes {
    /// <p>The input provided to the new workflow execution.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>If set, specifies the total duration for this workflow execution. This overrides the
    /// <code>defaultExecutionStartToCloseTimeout</code> specified when registering the workflow type.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this field. If neither this field is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The task list to use for the decisions of the new (continued) workflow
    /// execution.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// The task priority that, if set, specifies the priority for the decision tasks for this workflow
    /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum duration of decision tasks for the new workflow execution. This parameter overrides the
    /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A task start-to-close timeout for the new workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the policy to use for the child workflow executions of the new execution if it is terminated
    /// by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This policy
    /// overrides the default child policy specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The list of tags to associate with the new workflow execution. A maximum of 5 tags can be specified. You can
    /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
    /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
    pub tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The version of the workflow to start.</p>
    pub workflow_type_version: std::option::Option<std::string::String>,
    /// <p>The IAM role to attach to the new (continued) execution.</p>
    pub lambda_role: std::option::Option<std::string::String>,
}
impl ContinueAsNewWorkflowExecutionDecisionAttributes {
    /// <p>The input provided to the new workflow execution.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>If set, specifies the total duration for this workflow execution. This overrides the
    /// <code>defaultExecutionStartToCloseTimeout</code> specified when registering the workflow type.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this field. If neither this field is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.execution_start_to_close_timeout.as_deref()
    }
    /// <p>The task list to use for the decisions of the new (continued) workflow
    /// execution.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>
    /// The task priority that, if set, specifies the priority for the decision tasks for this workflow
    /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>Specifies the maximum duration of decision tasks for the new workflow execution. This parameter overrides the
    /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A task start-to-close timeout for the new workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.task_start_to_close_timeout.as_deref()
    }
    /// <p>If set, specifies the policy to use for the child workflow executions of the new execution if it is terminated
    /// by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This policy
    /// overrides the default child policy specified when registering the workflow type using
    /// <a>RegisterWorkflowType</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>The list of tags to associate with the new workflow execution. A maximum of 5 tags can be specified. You can
    /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
    /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
    pub fn tag_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_list.as_deref()
    }
    /// <p>The version of the workflow to start.</p>
    pub fn workflow_type_version(&self) -> std::option::Option<&str> {
        self.workflow_type_version.as_deref()
    }
    /// <p>The IAM role to attach to the new (continued) execution.</p>
    pub fn lambda_role(&self) -> std::option::Option<&str> {
        self.lambda_role.as_deref()
    }
}
impl std::fmt::Debug for ContinueAsNewWorkflowExecutionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinueAsNewWorkflowExecutionDecisionAttributes");
        formatter.field("input", &self.input);
        formatter.field(
            "execution_start_to_close_timeout",
            &self.execution_start_to_close_timeout,
        );
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field(
            "task_start_to_close_timeout",
            &self.task_start_to_close_timeout,
        );
        formatter.field("child_policy", &self.child_policy);
        formatter.field("tag_list", &self.tag_list);
        formatter.field("workflow_type_version", &self.workflow_type_version);
        formatter.field("lambda_role", &self.lambda_role);
        formatter.finish()
    }
}
/// See [`ContinueAsNewWorkflowExecutionDecisionAttributes`](crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes)
pub mod continue_as_new_workflow_execution_decision_attributes {
    /// A builder for [`ContinueAsNewWorkflowExecutionDecisionAttributes`](crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) execution_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) workflow_type_version: std::option::Option<std::string::String>,
        pub(crate) lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The input provided to the new workflow execution.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input provided to the new workflow execution.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>If set, specifies the total duration for this workflow execution. This overrides the
        /// <code>defaultExecutionStartToCloseTimeout</code> specified when registering the workflow type.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this field. If neither this field is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the total duration for this workflow execution. This overrides the
        /// <code>defaultExecutionStartToCloseTimeout</code> specified when registering the workflow type.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this field. If neither this field is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = input;
            self
        }
        /// <p>The task list to use for the decisions of the new (continued) workflow
        /// execution.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The task list to use for the decisions of the new (continued) workflow
        /// execution.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>
        /// The task priority that, if set, specifies the priority for the decision tasks for this workflow
        /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>
        /// The task priority that, if set, specifies the priority for the decision tasks for this workflow
        /// execution. This overrides the defaultTaskPriority specified when registering the workflow type.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for the new workflow execution. This parameter overrides the
        /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for the new workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for the new workflow execution. This parameter overrides the
        /// <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for the new workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = input;
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the new execution if it is terminated
        /// by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This policy
        /// overrides the default child policy specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the new execution if it is terminated
        /// by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This policy
        /// overrides the default child policy specified when registering the workflow type using
        /// <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags to associate with the new workflow execution. A maximum of 5 tags can be specified. You can
        /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
        /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags to associate with the new workflow execution. A maximum of 5 tags can be specified. You can
        /// list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
        /// <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>The version of the workflow to start.</p>
        pub fn workflow_type_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_type_version = Some(input.into());
            self
        }
        /// <p>The version of the workflow to start.</p>
        pub fn set_workflow_type_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workflow_type_version = input;
            self
        }
        /// <p>The IAM role to attach to the new (continued) execution.</p>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_role = Some(input.into());
            self
        }
        /// <p>The IAM role to attach to the new (continued) execution.</p>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinueAsNewWorkflowExecutionDecisionAttributes`](crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes)
        pub fn build(self) -> crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes {
            crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes {
                input: self.input,
                execution_start_to_close_timeout: self.execution_start_to_close_timeout,
                task_list: self.task_list,
                task_priority: self.task_priority,
                task_start_to_close_timeout: self.task_start_to_close_timeout,
                child_policy: self.child_policy,
                tag_list: self.tag_list,
                workflow_type_version: self.workflow_type_version,
                lambda_role: self.lambda_role,
            }
        }
    }
}
impl ContinueAsNewWorkflowExecutionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`ContinueAsNewWorkflowExecutionDecisionAttributes`](crate::model::ContinueAsNewWorkflowExecutionDecisionAttributes)
    pub fn builder() -> crate::model::continue_as_new_workflow_execution_decision_attributes::Builder
    {
        crate::model::continue_as_new_workflow_execution_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>CancelWorkflowExecution</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelWorkflowExecutionDecisionAttributes {
    /// <p>
    /// Details of the cancellation.</p>
    pub details: std::option::Option<std::string::String>,
}
impl CancelWorkflowExecutionDecisionAttributes {
    /// <p>
    /// Details of the cancellation.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for CancelWorkflowExecutionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelWorkflowExecutionDecisionAttributes");
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`CancelWorkflowExecutionDecisionAttributes`](crate::model::CancelWorkflowExecutionDecisionAttributes)
pub mod cancel_workflow_execution_decision_attributes {
    /// A builder for [`CancelWorkflowExecutionDecisionAttributes`](crate::model::CancelWorkflowExecutionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Details of the cancellation.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>
        /// Details of the cancellation.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelWorkflowExecutionDecisionAttributes`](crate::model::CancelWorkflowExecutionDecisionAttributes)
        pub fn build(self) -> crate::model::CancelWorkflowExecutionDecisionAttributes {
            crate::model::CancelWorkflowExecutionDecisionAttributes {
                details: self.details,
            }
        }
    }
}
impl CancelWorkflowExecutionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`CancelWorkflowExecutionDecisionAttributes`](crate::model::CancelWorkflowExecutionDecisionAttributes)
    pub fn builder() -> crate::model::cancel_workflow_execution_decision_attributes::Builder {
        crate::model::cancel_workflow_execution_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>FailWorkflowExecution</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
/// in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailWorkflowExecutionDecisionAttributes {
    /// <p>A descriptive reason for the failure that may help in diagnostics.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>
    /// Details of the failure.</p>
    pub details: std::option::Option<std::string::String>,
}
impl FailWorkflowExecutionDecisionAttributes {
    /// <p>A descriptive reason for the failure that may help in diagnostics.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>
    /// Details of the failure.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for FailWorkflowExecutionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailWorkflowExecutionDecisionAttributes");
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`FailWorkflowExecutionDecisionAttributes`](crate::model::FailWorkflowExecutionDecisionAttributes)
pub mod fail_workflow_execution_decision_attributes {
    /// A builder for [`FailWorkflowExecutionDecisionAttributes`](crate::model::FailWorkflowExecutionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A descriptive reason for the failure that may help in diagnostics.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A descriptive reason for the failure that may help in diagnostics.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>
        /// Details of the failure.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>
        /// Details of the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`FailWorkflowExecutionDecisionAttributes`](crate::model::FailWorkflowExecutionDecisionAttributes)
        pub fn build(self) -> crate::model::FailWorkflowExecutionDecisionAttributes {
            crate::model::FailWorkflowExecutionDecisionAttributes {
                reason: self.reason,
                details: self.details,
            }
        }
    }
}
impl FailWorkflowExecutionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`FailWorkflowExecutionDecisionAttributes`](crate::model::FailWorkflowExecutionDecisionAttributes)
    pub fn builder() -> crate::model::fail_workflow_execution_decision_attributes::Builder {
        crate::model::fail_workflow_execution_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>CompleteWorkflowExecution</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteWorkflowExecutionDecisionAttributes {
    /// <p>The result of the workflow execution. The form of the result is implementation defined.</p>
    pub result: std::option::Option<std::string::String>,
}
impl CompleteWorkflowExecutionDecisionAttributes {
    /// <p>The result of the workflow execution. The form of the result is implementation defined.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
}
impl std::fmt::Debug for CompleteWorkflowExecutionDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteWorkflowExecutionDecisionAttributes");
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`CompleteWorkflowExecutionDecisionAttributes`](crate::model::CompleteWorkflowExecutionDecisionAttributes)
pub mod complete_workflow_execution_decision_attributes {
    /// A builder for [`CompleteWorkflowExecutionDecisionAttributes`](crate::model::CompleteWorkflowExecutionDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The result of the workflow execution. The form of the result is implementation defined.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>The result of the workflow execution. The form of the result is implementation defined.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteWorkflowExecutionDecisionAttributes`](crate::model::CompleteWorkflowExecutionDecisionAttributes)
        pub fn build(self) -> crate::model::CompleteWorkflowExecutionDecisionAttributes {
            crate::model::CompleteWorkflowExecutionDecisionAttributes {
                result: self.result,
            }
        }
    }
}
impl CompleteWorkflowExecutionDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`CompleteWorkflowExecutionDecisionAttributes`](crate::model::CompleteWorkflowExecutionDecisionAttributes)
    pub fn builder() -> crate::model::complete_workflow_execution_decision_attributes::Builder {
        crate::model::complete_workflow_execution_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>RequestCancelActivityTask</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
/// in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestCancelActivityTaskDecisionAttributes {
    /// <p>The <code>activityId</code> of the activity task to be canceled.</p>
    pub activity_id: std::option::Option<std::string::String>,
}
impl RequestCancelActivityTaskDecisionAttributes {
    /// <p>The <code>activityId</code> of the activity task to be canceled.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
}
impl std::fmt::Debug for RequestCancelActivityTaskDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestCancelActivityTaskDecisionAttributes");
        formatter.field("activity_id", &self.activity_id);
        formatter.finish()
    }
}
/// See [`RequestCancelActivityTaskDecisionAttributes`](crate::model::RequestCancelActivityTaskDecisionAttributes)
pub mod request_cancel_activity_task_decision_attributes {
    /// A builder for [`RequestCancelActivityTaskDecisionAttributes`](crate::model::RequestCancelActivityTaskDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>activityId</code> of the activity task to be canceled.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>The <code>activityId</code> of the activity task to be canceled.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestCancelActivityTaskDecisionAttributes`](crate::model::RequestCancelActivityTaskDecisionAttributes)
        pub fn build(self) -> crate::model::RequestCancelActivityTaskDecisionAttributes {
            crate::model::RequestCancelActivityTaskDecisionAttributes {
                activity_id: self.activity_id,
            }
        }
    }
}
impl RequestCancelActivityTaskDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`RequestCancelActivityTaskDecisionAttributes`](crate::model::RequestCancelActivityTaskDecisionAttributes)
    pub fn builder() -> crate::model::request_cancel_activity_task_decision_attributes::Builder {
        crate::model::request_cancel_activity_task_decision_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ScheduleActivityTask</code> decision.</p>
/// <p>
/// <b>Access Control</b>
/// </p>
/// <p>You can use IAM policies to control this decision's access to Amazon SWF resources as follows:</p>
/// <ul>
/// <li>
/// <p>Use a <code>Resource</code> element with the domain name to limit the action to only
/// specified domains.</p>
/// </li>
/// <li>
/// <p>Use an <code>Action</code> element to allow or deny permission to call this action.</p>
/// </li>
/// <li>
/// <p>Constrain the following parameters by using a <code>Condition</code> element with the
/// appropriate keys.</p>
/// <ul>
/// <li>
/// <p>
/// <code>activityType.name</code> – String constraint. The key is <code>swf:activityType.name</code>.</p>
/// </li>
/// <li>
/// <p>
/// <code>activityType.version</code> – String constraint. The key is <code>swf:activityType.version</code>.</p>
/// </li>
/// <li>
/// <p>
/// <code>taskList</code> – String constraint. The key is <code>swf:taskList.name</code>.</p>
/// </li>
/// </ul>
/// </li>
/// </ul>
/// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
/// parameter values fall outside the specified constraints, the action fails. The associated event attribute's
/// <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see
/// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
/// in the <i>Amazon SWF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleActivityTaskDecisionAttributes {
    /// <p>
    /// The type of the activity task to schedule.</p>
    pub activity_type: std::option::Option<crate::model::ActivityType>,
    /// <p>
    /// The <code>activityId</code> of the activity task.</p>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub activity_id: std::option::Option<std::string::String>,
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>The input provided to the activity task.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The maximum duration for this activity task.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A schedule-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub schedule_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
    /// <code>defaultTaskList</code> registered with the activity type is used.</p>
    /// <note>
    /// <p>A task list for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default task list was specified at registration time then a fault is returned.</p>
    /// </note>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// If set, specifies the priority with which the activity task is to be assigned to a worker. This
    /// overrides the defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>
    /// If set, specifies the maximum duration the activity task can wait to be assigned to a worker.
    /// This overrides the default schedule-to-start timeout specified when registering the activity type using
    /// <a>RegisterActivityType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A schedule-to-start timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-start timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub schedule_to_start_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
    /// default start-to-close timeout specified when registering the activity type using <a>RegisterActivityType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A start-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the maximum time before which a worker processing a task of this type must report progress by
    /// calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
    /// out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This
    /// overrides the default heartbeat timeout specified when registering the activity type using
    /// <a>RegisterActivityType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub heartbeat_timeout: std::option::Option<std::string::String>,
}
impl ScheduleActivityTaskDecisionAttributes {
    /// <p>
    /// The type of the activity task to schedule.</p>
    pub fn activity_type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.activity_type.as_ref()
    }
    /// <p>
    /// The <code>activityId</code> of the activity task.</p>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>The input provided to the activity task.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The maximum duration for this activity task.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A schedule-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn schedule_to_close_timeout(&self) -> std::option::Option<&str> {
        self.schedule_to_close_timeout.as_deref()
    }
    /// <p>If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
    /// <code>defaultTaskList</code> registered with the activity type is used.</p>
    /// <note>
    /// <p>A task list for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default task list was specified at registration time then a fault is returned.</p>
    /// </note>
    /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
    /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>
    /// If set, specifies the priority with which the activity task is to be assigned to a worker. This
    /// overrides the defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>
    /// If set, specifies the maximum duration the activity task can wait to be assigned to a worker.
    /// This overrides the default schedule-to-start timeout specified when registering the activity type using
    /// <a>RegisterActivityType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A schedule-to-start timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-start timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn schedule_to_start_timeout(&self) -> std::option::Option<&str> {
        self.schedule_to_start_timeout.as_deref()
    }
    /// <p>If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
    /// default start-to-close timeout specified when registering the activity type using <a>RegisterActivityType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A start-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default start-to-close timeout was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.start_to_close_timeout.as_deref()
    }
    /// <p>If set, specifies the maximum time before which a worker processing a task of this type must report progress by
    /// calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
    /// out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This
    /// overrides the default heartbeat timeout specified when registering the activity type using
    /// <a>RegisterActivityType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn heartbeat_timeout(&self) -> std::option::Option<&str> {
        self.heartbeat_timeout.as_deref()
    }
}
impl std::fmt::Debug for ScheduleActivityTaskDecisionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleActivityTaskDecisionAttributes");
        formatter.field("activity_type", &self.activity_type);
        formatter.field("activity_id", &self.activity_id);
        formatter.field("control", &self.control);
        formatter.field("input", &self.input);
        formatter.field("schedule_to_close_timeout", &self.schedule_to_close_timeout);
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field("schedule_to_start_timeout", &self.schedule_to_start_timeout);
        formatter.field("start_to_close_timeout", &self.start_to_close_timeout);
        formatter.field("heartbeat_timeout", &self.heartbeat_timeout);
        formatter.finish()
    }
}
/// See [`ScheduleActivityTaskDecisionAttributes`](crate::model::ScheduleActivityTaskDecisionAttributes)
pub mod schedule_activity_task_decision_attributes {
    /// A builder for [`ScheduleActivityTaskDecisionAttributes`](crate::model::ScheduleActivityTaskDecisionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_type: std::option::Option<crate::model::ActivityType>,
        pub(crate) activity_id: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) schedule_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) schedule_to_start_timeout: std::option::Option<std::string::String>,
        pub(crate) start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) heartbeat_timeout: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The type of the activity task to schedule.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.activity_type = Some(input);
            self
        }
        /// <p>
        /// The type of the activity task to schedule.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.activity_type = input;
            self
        }
        /// <p>
        /// The <code>activityId</code> of the activity task.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>
        /// The <code>activityId</code> of the activity task.</p>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>The input provided to the activity task.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input provided to the activity task.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The maximum duration for this activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A schedule-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn schedule_to_close_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration for this activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A schedule-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_schedule_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_to_close_timeout = input;
            self
        }
        /// <p>If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
        /// <code>defaultTaskList</code> registered with the activity type is used.</p>
        /// <note>
        /// <p>A task list for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default task list was specified at registration time then a fault is returned.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
        /// <code>defaultTaskList</code> registered with the activity type is used.</p>
        /// <note>
        /// <p>A task list for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default task list was specified at registration time then a fault is returned.</p>
        /// </note>
        /// <p>The specified string must not start or end with whitespace. It must not contain a <code>:</code>
        /// (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>
        /// If set, specifies the priority with which the activity task is to be assigned to a worker. This
        /// overrides the defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>
        /// If set, specifies the priority with which the activity task is to be assigned to a worker. This
        /// overrides the defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>
        /// If set, specifies the maximum duration the activity task can wait to be assigned to a worker.
        /// This overrides the default schedule-to-start timeout specified when registering the activity type using
        /// <a>RegisterActivityType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A schedule-to-start timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-start timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn schedule_to_start_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_to_start_timeout = Some(input.into());
            self
        }
        /// <p>
        /// If set, specifies the maximum duration the activity task can wait to be assigned to a worker.
        /// This overrides the default schedule-to-start timeout specified when registering the activity type using
        /// <a>RegisterActivityType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A schedule-to-start timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-start timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_schedule_to_start_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_to_start_timeout = input;
            self
        }
        /// <p>If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
        /// default start-to-close timeout specified when registering the activity type using <a>RegisterActivityType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A start-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn start_to_close_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
        /// default start-to-close timeout specified when registering the activity type using <a>RegisterActivityType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A start-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default start-to-close timeout was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_to_close_timeout = input;
            self
        }
        /// <p>If set, specifies the maximum time before which a worker processing a task of this type must report progress by
        /// calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
        /// out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This
        /// overrides the default heartbeat timeout specified when registering the activity type using
        /// <a>RegisterActivityType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn heartbeat_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.heartbeat_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the maximum time before which a worker processing a task of this type must report progress by
        /// calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
        /// out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This
        /// overrides the default heartbeat timeout specified when registering the activity type using
        /// <a>RegisterActivityType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_heartbeat_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.heartbeat_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleActivityTaskDecisionAttributes`](crate::model::ScheduleActivityTaskDecisionAttributes)
        pub fn build(self) -> crate::model::ScheduleActivityTaskDecisionAttributes {
            crate::model::ScheduleActivityTaskDecisionAttributes {
                activity_type: self.activity_type,
                activity_id: self.activity_id,
                control: self.control,
                input: self.input,
                schedule_to_close_timeout: self.schedule_to_close_timeout,
                task_list: self.task_list,
                task_priority: self.task_priority,
                schedule_to_start_timeout: self.schedule_to_start_timeout,
                start_to_close_timeout: self.start_to_close_timeout,
                heartbeat_timeout: self.heartbeat_timeout,
            }
        }
    }
}
impl ScheduleActivityTaskDecisionAttributes {
    /// Creates a new builder-style object to manufacture [`ScheduleActivityTaskDecisionAttributes`](crate::model::ScheduleActivityTaskDecisionAttributes)
    pub fn builder() -> crate::model::schedule_activity_task_decision_attributes::Builder {
        crate::model::schedule_activity_task_decision_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DecisionType {
    #[allow(missing_docs)] // documentation missing in model
    CancelTimer,
    #[allow(missing_docs)] // documentation missing in model
    CancelWorkflowExecution,
    #[allow(missing_docs)] // documentation missing in model
    CompleteWorkflowExecution,
    #[allow(missing_docs)] // documentation missing in model
    ContinueAsNewWorkflowExecution,
    #[allow(missing_docs)] // documentation missing in model
    FailWorkflowExecution,
    #[allow(missing_docs)] // documentation missing in model
    RecordMarker,
    #[allow(missing_docs)] // documentation missing in model
    RequestCancelActivityTask,
    #[allow(missing_docs)] // documentation missing in model
    RequestCancelExternalWorkflowExecution,
    #[allow(missing_docs)] // documentation missing in model
    ScheduleActivityTask,
    #[allow(missing_docs)] // documentation missing in model
    ScheduleLambdaFunction,
    #[allow(missing_docs)] // documentation missing in model
    SignalExternalWorkflowExecution,
    #[allow(missing_docs)] // documentation missing in model
    StartChildWorkflowExecution,
    #[allow(missing_docs)] // documentation missing in model
    StartTimer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DecisionType {
    fn from(s: &str) -> Self {
        match s {
            "CancelTimer" => DecisionType::CancelTimer,
            "CancelWorkflowExecution" => DecisionType::CancelWorkflowExecution,
            "CompleteWorkflowExecution" => DecisionType::CompleteWorkflowExecution,
            "ContinueAsNewWorkflowExecution" => DecisionType::ContinueAsNewWorkflowExecution,
            "FailWorkflowExecution" => DecisionType::FailWorkflowExecution,
            "RecordMarker" => DecisionType::RecordMarker,
            "RequestCancelActivityTask" => DecisionType::RequestCancelActivityTask,
            "RequestCancelExternalWorkflowExecution" => {
                DecisionType::RequestCancelExternalWorkflowExecution
            }
            "ScheduleActivityTask" => DecisionType::ScheduleActivityTask,
            "ScheduleLambdaFunction" => DecisionType::ScheduleLambdaFunction,
            "SignalExternalWorkflowExecution" => DecisionType::SignalExternalWorkflowExecution,
            "StartChildWorkflowExecution" => DecisionType::StartChildWorkflowExecution,
            "StartTimer" => DecisionType::StartTimer,
            other => DecisionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DecisionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DecisionType::from(s))
    }
}
impl DecisionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DecisionType::CancelTimer => "CancelTimer",
            DecisionType::CancelWorkflowExecution => "CancelWorkflowExecution",
            DecisionType::CompleteWorkflowExecution => "CompleteWorkflowExecution",
            DecisionType::ContinueAsNewWorkflowExecution => "ContinueAsNewWorkflowExecution",
            DecisionType::FailWorkflowExecution => "FailWorkflowExecution",
            DecisionType::RecordMarker => "RecordMarker",
            DecisionType::RequestCancelActivityTask => "RequestCancelActivityTask",
            DecisionType::RequestCancelExternalWorkflowExecution => {
                "RequestCancelExternalWorkflowExecution"
            }
            DecisionType::ScheduleActivityTask => "ScheduleActivityTask",
            DecisionType::ScheduleLambdaFunction => "ScheduleLambdaFunction",
            DecisionType::SignalExternalWorkflowExecution => "SignalExternalWorkflowExecution",
            DecisionType::StartChildWorkflowExecution => "StartChildWorkflowExecution",
            DecisionType::StartTimer => "StartTimer",
            DecisionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CancelTimer",
            "CancelWorkflowExecution",
            "CompleteWorkflowExecution",
            "ContinueAsNewWorkflowExecution",
            "FailWorkflowExecution",
            "RecordMarker",
            "RequestCancelActivityTask",
            "RequestCancelExternalWorkflowExecution",
            "ScheduleActivityTask",
            "ScheduleLambdaFunction",
            "SignalExternalWorkflowExecution",
            "StartChildWorkflowExecution",
            "StartTimer",
        ]
    }
}
impl AsRef<str> for DecisionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Event within a workflow execution. A history event can be one of these types:</p>
/// <ul>
/// <li>
/// <p>
/// <code>ActivityTaskCancelRequested</code> – A <code>RequestCancelActivityTask</code> decision was received by the
/// system.</p>
/// </li>
/// <li>
/// <p>
/// <code>ActivityTaskCanceled</code> – The activity task was successfully canceled.</p>
/// </li>
/// <li>
/// <p>
/// <code>ActivityTaskCompleted</code> – An activity worker successfully completed an activity task by calling
/// <a>RespondActivityTaskCompleted</a>.</p>
/// </li>
/// <li>
/// <p>
/// <code>ActivityTaskFailed</code> – An activity worker failed an activity task by calling
/// <a>RespondActivityTaskFailed</a>.</p>
/// </li>
/// <li>
/// <p>
/// <code>ActivityTaskScheduled</code> – An activity task was scheduled for execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>ActivityTaskStarted</code> – The scheduled activity task was dispatched to a worker.</p>
/// </li>
/// <li>
/// <p>
/// <code>ActivityTaskTimedOut</code> – The activity task timed out.</p>
/// </li>
/// <li>
/// <p>
/// <code>CancelTimerFailed</code> – Failed to process CancelTimer decision. This happens when the decision isn't
/// configured properly, for example no timer exists with the specified timer Id.</p>
/// </li>
/// <li>
/// <p>
/// <code>CancelWorkflowExecutionFailed</code> – A request to cancel a workflow execution failed.</p>
/// </li>
/// <li>
/// <p>
/// <code>ChildWorkflowExecutionCanceled</code> – A child workflow execution, started by this workflow execution, was
/// canceled and closed.</p>
/// </li>
/// <li>
/// <p>
/// <code>ChildWorkflowExecutionCompleted</code> – A child workflow execution, started by this workflow execution,
/// completed successfully and was closed.</p>
/// </li>
/// <li>
/// <p>
/// <code>ChildWorkflowExecutionFailed</code> – A child workflow execution,
/// started by this workflow execution, failed to complete successfully and was closed.</p>
/// </li>
/// <li>
/// <p>
/// <code>ChildWorkflowExecutionStarted</code> – A child workflow execution was successfully started.</p>
/// </li>
/// <li>
/// <p>
/// <code>ChildWorkflowExecutionTerminated</code> –  A child workflow execution, started by this workflow execution, was
/// terminated.</p>
/// </li>
/// <li>
/// <p>
/// <code>ChildWorkflowExecutionTimedOut</code> –  A child workflow execution, started by this workflow execution, timed
/// out and was closed.</p>
/// </li>
/// <li>
/// <p>
/// <code>CompleteWorkflowExecutionFailed</code> – The workflow execution failed to complete.</p>
/// </li>
/// <li>
/// <p>
/// <code>ContinueAsNewWorkflowExecutionFailed</code> – The workflow execution failed to complete after being continued
/// as a new workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>DecisionTaskCompleted</code> – The decider successfully completed a decision task by calling
/// <a>RespondDecisionTaskCompleted</a>.</p>
/// </li>
/// <li>
/// <p>
/// <code>DecisionTaskScheduled</code> – A decision task was scheduled for the workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>DecisionTaskStarted</code> – The decision task was dispatched to a decider.</p>
/// </li>
/// <li>
/// <p>
/// <code>DecisionTaskTimedOut</code> – The decision task timed out.</p>
/// </li>
/// <li>
/// <p>
/// <code>ExternalWorkflowExecutionCancelRequested</code> – Request to cancel an external workflow execution was
/// successfully delivered to the target execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>ExternalWorkflowExecutionSignaled</code> – A signal, requested by this workflow execution, was successfully
/// delivered to the target external workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>FailWorkflowExecutionFailed</code> – A request to mark a workflow execution as failed, itself failed.</p>
/// </li>
/// <li>
/// <p>
/// <code>MarkerRecorded</code> – A marker was recorded in the workflow history as the result of a
/// <code>RecordMarker</code> decision.</p>
/// </li>
/// <li>
/// <p>
/// <code>RecordMarkerFailed</code> – A <code>RecordMarker</code> decision was returned as failed.</p>
/// </li>
/// <li>
/// <p>
/// <code>RequestCancelActivityTaskFailed</code> – Failed to process RequestCancelActivityTask decision. This happens
/// when the decision isn't configured properly.</p>
/// </li>
/// <li>
/// <p>
/// <code>RequestCancelExternalWorkflowExecutionFailed</code> – Request to cancel an external workflow execution
/// failed.</p>
/// </li>
/// <li>
/// <p>
/// <code>RequestCancelExternalWorkflowExecutionInitiated</code> – A request was made to request the cancellation of an
/// external workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>ScheduleActivityTaskFailed</code> – Failed to process ScheduleActivityTask decision. This happens when the
/// decision isn't configured properly, for example the activity type specified isn't registered.</p>
/// </li>
/// <li>
/// <p>
/// <code>SignalExternalWorkflowExecutionFailed</code> – The request to signal an external workflow execution
/// failed.</p>
/// </li>
/// <li>
/// <p>
/// <code>SignalExternalWorkflowExecutionInitiated</code> – A request to signal an external workflow was made.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartActivityTaskFailed</code> – A scheduled activity task failed to start.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartChildWorkflowExecutionFailed</code> – Failed to process StartChildWorkflowExecution decision. This happens
/// when the decision isn't configured properly, for example the workflow type specified isn't registered.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartChildWorkflowExecutionInitiated</code> – A request was made to start a child workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>StartTimerFailed</code> – Failed to process StartTimer decision. This happens when the decision isn't
/// configured properly, for example a timer already exists with the specified timer Id.</p>
/// </li>
/// <li>
/// <p>
/// <code>TimerCanceled</code> – A timer, previously started for this workflow execution, was successfully canceled.</p>
/// </li>
/// <li>
/// <p>
/// <code>TimerFired</code> – A timer, previously started for this workflow execution, fired.</p>
/// </li>
/// <li>
/// <p>
/// <code>TimerStarted</code> – A timer was started for the workflow execution due to a <code>StartTimer</code>
/// decision.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionCancelRequested</code> – A request to cancel this workflow execution was made.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionCanceled</code> – The workflow execution was successfully canceled and closed.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionCompleted</code> – The workflow execution was closed due to successful completion.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionContinuedAsNew</code> – The workflow execution was closed and a new execution of the same type
/// was created with the same workflowId.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionFailed</code> – The workflow execution closed due to a failure.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionSignaled</code> – An external signal was received for the workflow execution.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionStarted</code> – The workflow execution was started.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionTerminated</code> – The workflow execution was terminated.</p>
/// </li>
/// <li>
/// <p>
/// <code>WorkflowExecutionTimedOut</code> – The workflow execution was closed because a time out was exceeded.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistoryEvent {
    /// <p>The date and time when the event occurred.</p>
    pub event_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of the history event.</p>
    pub event_type: std::option::Option<crate::model::EventType>,
    /// <p>The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution history.</p>
    pub event_id: i64,
    /// <p>If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub workflow_execution_started_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionStartedEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub workflow_execution_completed_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionCompletedEventAttributes>,
    /// <p>If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub complete_workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::CompleteWorkflowExecutionFailedEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionFailedEventAttributes>,
    /// <p>If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fail_workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::FailWorkflowExecutionFailedEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub workflow_execution_timed_out_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionTimedOutEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub workflow_execution_canceled_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionCanceledEventAttributes>,
    /// <p>If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub cancel_workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::CancelWorkflowExecutionFailedEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub workflow_execution_continued_as_new_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionContinuedAsNewEventAttributes>,
    /// <p>If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub continue_as_new_workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub workflow_execution_terminated_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionTerminatedEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub workflow_execution_cancel_requested_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionCancelRequestedEventAttributes>,
    /// <p>If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub decision_task_scheduled_event_attributes:
        std::option::Option<crate::model::DecisionTaskScheduledEventAttributes>,
    /// <p>If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub decision_task_started_event_attributes:
        std::option::Option<crate::model::DecisionTaskStartedEventAttributes>,
    /// <p>If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub decision_task_completed_event_attributes:
        std::option::Option<crate::model::DecisionTaskCompletedEventAttributes>,
    /// <p>If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub decision_task_timed_out_event_attributes:
        std::option::Option<crate::model::DecisionTaskTimedOutEventAttributes>,
    /// <p>If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub activity_task_scheduled_event_attributes:
        std::option::Option<crate::model::ActivityTaskScheduledEventAttributes>,
    /// <p>If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub activity_task_started_event_attributes:
        std::option::Option<crate::model::ActivityTaskStartedEventAttributes>,
    /// <p>If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub activity_task_completed_event_attributes:
        std::option::Option<crate::model::ActivityTaskCompletedEventAttributes>,
    /// <p>If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub activity_task_failed_event_attributes:
        std::option::Option<crate::model::ActivityTaskFailedEventAttributes>,
    /// <p>If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub activity_task_timed_out_event_attributes:
        std::option::Option<crate::model::ActivityTaskTimedOutEventAttributes>,
    /// <p>If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub activity_task_canceled_event_attributes:
        std::option::Option<crate::model::ActivityTaskCanceledEventAttributes>,
    /// <p>If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub activity_task_cancel_requested_event_attributes:
        std::option::Option<crate::model::ActivityTaskCancelRequestedEventAttributes>,
    /// <p>If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub workflow_execution_signaled_event_attributes:
        std::option::Option<crate::model::WorkflowExecutionSignaledEventAttributes>,
    /// <p>If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub marker_recorded_event_attributes:
        std::option::Option<crate::model::MarkerRecordedEventAttributes>,
    /// <p>If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub record_marker_failed_event_attributes:
        std::option::Option<crate::model::RecordMarkerFailedEventAttributes>,
    /// <p>If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub timer_started_event_attributes:
        std::option::Option<crate::model::TimerStartedEventAttributes>,
    /// <p>If the event is of type <code>TimerFired</code> then this member is set and provides detailed information about
    /// the event. It isn't set for other event types.</p>
    pub timer_fired_event_attributes: std::option::Option<crate::model::TimerFiredEventAttributes>,
    /// <p>If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub timer_canceled_event_attributes:
        std::option::Option<crate::model::TimerCanceledEventAttributes>,
    /// <p>If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub start_child_workflow_execution_initiated_event_attributes:
        std::option::Option<crate::model::StartChildWorkflowExecutionInitiatedEventAttributes>,
    /// <p>If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub child_workflow_execution_started_event_attributes:
        std::option::Option<crate::model::ChildWorkflowExecutionStartedEventAttributes>,
    /// <p>If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub child_workflow_execution_completed_event_attributes:
        std::option::Option<crate::model::ChildWorkflowExecutionCompletedEventAttributes>,
    /// <p>If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub child_workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::ChildWorkflowExecutionFailedEventAttributes>,
    /// <p>If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub child_workflow_execution_timed_out_event_attributes:
        std::option::Option<crate::model::ChildWorkflowExecutionTimedOutEventAttributes>,
    /// <p>If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub child_workflow_execution_canceled_event_attributes:
        std::option::Option<crate::model::ChildWorkflowExecutionCanceledEventAttributes>,
    /// <p>If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub child_workflow_execution_terminated_event_attributes:
        std::option::Option<crate::model::ChildWorkflowExecutionTerminatedEventAttributes>,
    /// <p>If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types.</p>
    pub signal_external_workflow_execution_initiated_event_attributes:
        std::option::Option<crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes>,
    /// <p>If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub external_workflow_execution_signaled_event_attributes:
        std::option::Option<crate::model::ExternalWorkflowExecutionSignaledEventAttributes>,
    /// <p>If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub signal_external_workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::SignalExternalWorkflowExecutionFailedEventAttributes>,
    /// <p>If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types. </p>
    pub external_workflow_execution_cancel_requested_event_attributes:
        std::option::Option<crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes>,
    /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types.</p>
    pub request_cancel_external_workflow_execution_initiated_event_attributes: std::option::Option<
        crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes,
    >,
    /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types.</p>
    pub request_cancel_external_workflow_execution_failed_event_attributes: std::option::Option<
        crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes,
    >,
    /// <p>If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub schedule_activity_task_failed_event_attributes:
        std::option::Option<crate::model::ScheduleActivityTaskFailedEventAttributes>,
    /// <p>If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub request_cancel_activity_task_failed_event_attributes:
        std::option::Option<crate::model::RequestCancelActivityTaskFailedEventAttributes>,
    /// <p>If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub start_timer_failed_event_attributes:
        std::option::Option<crate::model::StartTimerFailedEventAttributes>,
    /// <p>If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub cancel_timer_failed_event_attributes:
        std::option::Option<crate::model::CancelTimerFailedEventAttributes>,
    /// <p>If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub start_child_workflow_execution_failed_event_attributes:
        std::option::Option<crate::model::StartChildWorkflowExecutionFailedEventAttributes>,
    /// <p>Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set
    /// for other event types.</p>
    pub lambda_function_scheduled_event_attributes:
        std::option::Option<crate::model::LambdaFunctionScheduledEventAttributes>,
    /// <p>Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for
    /// other event types.</p>
    pub lambda_function_started_event_attributes:
        std::option::Option<crate::model::LambdaFunctionStartedEventAttributes>,
    /// <p>Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set
    /// for other event types.</p>
    pub lambda_function_completed_event_attributes:
        std::option::Option<crate::model::LambdaFunctionCompletedEventAttributes>,
    /// <p>Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for
    /// other event types.</p>
    pub lambda_function_failed_event_attributes:
        std::option::Option<crate::model::LambdaFunctionFailedEventAttributes>,
    /// <p>Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for
    /// other event types.</p>
    pub lambda_function_timed_out_event_attributes:
        std::option::Option<crate::model::LambdaFunctionTimedOutEventAttributes>,
    /// <p>Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't
    /// set for other event types.</p>
    pub schedule_lambda_function_failed_event_attributes:
        std::option::Option<crate::model::ScheduleLambdaFunctionFailedEventAttributes>,
    /// <p>Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set
    /// for other event types.</p>
    pub start_lambda_function_failed_event_attributes:
        std::option::Option<crate::model::StartLambdaFunctionFailedEventAttributes>,
}
impl HistoryEvent {
    /// <p>The date and time when the event occurred.</p>
    pub fn event_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.event_timestamp.as_ref()
    }
    /// <p>The type of the history event.</p>
    pub fn event_type(&self) -> std::option::Option<&crate::model::EventType> {
        self.event_type.as_ref()
    }
    /// <p>The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution history.</p>
    pub fn event_id(&self) -> i64 {
        self.event_id
    }
    /// <p>If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_started_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionStartedEventAttributes> {
        self.workflow_execution_started_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_completed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionCompletedEventAttributes> {
        self.workflow_execution_completed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn complete_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::CompleteWorkflowExecutionFailedEventAttributes> {
        self.complete_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionFailedEventAttributes> {
        self.workflow_execution_failed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn fail_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::FailWorkflowExecutionFailedEventAttributes> {
        self.fail_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_timed_out_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionTimedOutEventAttributes> {
        self.workflow_execution_timed_out_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_canceled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionCanceledEventAttributes> {
        self.workflow_execution_canceled_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn cancel_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::CancelWorkflowExecutionFailedEventAttributes> {
        self.cancel_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_continued_as_new_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionContinuedAsNewEventAttributes> {
        self.workflow_execution_continued_as_new_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn continue_as_new_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes>
    {
        self.continue_as_new_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_terminated_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionTerminatedEventAttributes> {
        self.workflow_execution_terminated_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_cancel_requested_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionCancelRequestedEventAttributes> {
        self.workflow_execution_cancel_requested_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn decision_task_scheduled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::DecisionTaskScheduledEventAttributes> {
        self.decision_task_scheduled_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn decision_task_started_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::DecisionTaskStartedEventAttributes> {
        self.decision_task_started_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn decision_task_completed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::DecisionTaskCompletedEventAttributes> {
        self.decision_task_completed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn decision_task_timed_out_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::DecisionTaskTimedOutEventAttributes> {
        self.decision_task_timed_out_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn activity_task_scheduled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTaskScheduledEventAttributes> {
        self.activity_task_scheduled_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn activity_task_started_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTaskStartedEventAttributes> {
        self.activity_task_started_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn activity_task_completed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTaskCompletedEventAttributes> {
        self.activity_task_completed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn activity_task_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTaskFailedEventAttributes> {
        self.activity_task_failed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn activity_task_timed_out_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTaskTimedOutEventAttributes> {
        self.activity_task_timed_out_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn activity_task_canceled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTaskCanceledEventAttributes> {
        self.activity_task_canceled_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn activity_task_cancel_requested_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTaskCancelRequestedEventAttributes> {
        self.activity_task_cancel_requested_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn workflow_execution_signaled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionSignaledEventAttributes> {
        self.workflow_execution_signaled_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub fn marker_recorded_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::MarkerRecordedEventAttributes> {
        self.marker_recorded_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn record_marker_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::RecordMarkerFailedEventAttributes> {
        self.record_marker_failed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub fn timer_started_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::TimerStartedEventAttributes> {
        self.timer_started_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>TimerFired</code> then this member is set and provides detailed information about
    /// the event. It isn't set for other event types.</p>
    pub fn timer_fired_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::TimerFiredEventAttributes> {
        self.timer_fired_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub fn timer_canceled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::TimerCanceledEventAttributes> {
        self.timer_canceled_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn start_child_workflow_execution_initiated_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::StartChildWorkflowExecutionInitiatedEventAttributes>
    {
        self.start_child_workflow_execution_initiated_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn child_workflow_execution_started_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ChildWorkflowExecutionStartedEventAttributes> {
        self.child_workflow_execution_started_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn child_workflow_execution_completed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ChildWorkflowExecutionCompletedEventAttributes> {
        self.child_workflow_execution_completed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn child_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ChildWorkflowExecutionFailedEventAttributes> {
        self.child_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn child_workflow_execution_timed_out_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ChildWorkflowExecutionTimedOutEventAttributes> {
        self.child_workflow_execution_timed_out_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn child_workflow_execution_canceled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ChildWorkflowExecutionCanceledEventAttributes> {
        self.child_workflow_execution_canceled_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn child_workflow_execution_terminated_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ChildWorkflowExecutionTerminatedEventAttributes> {
        self.child_workflow_execution_terminated_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types.</p>
    pub fn signal_external_workflow_execution_initiated_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes>
    {
        self.signal_external_workflow_execution_initiated_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn external_workflow_execution_signaled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ExternalWorkflowExecutionSignaledEventAttributes> {
        self.external_workflow_execution_signaled_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn signal_external_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::SignalExternalWorkflowExecutionFailedEventAttributes>
    {
        self.signal_external_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types. </p>
    pub fn external_workflow_execution_cancel_requested_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes>
    {
        self.external_workflow_execution_cancel_requested_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types.</p>
    pub fn request_cancel_external_workflow_execution_initiated_event_attributes(
        &self,
    ) -> std::option::Option<
        &crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes,
    > {
        self.request_cancel_external_workflow_execution_initiated_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
    /// provides detailed information about the event. It isn't set for other event types.</p>
    pub fn request_cancel_external_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<
        &crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes,
    > {
        self.request_cancel_external_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
    /// information about the event. It isn't set for other event types.</p>
    pub fn schedule_activity_task_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ScheduleActivityTaskFailedEventAttributes> {
        self.schedule_activity_task_failed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn request_cancel_activity_task_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::RequestCancelActivityTaskFailedEventAttributes> {
        self.request_cancel_activity_task_failed_event_attributes
            .as_ref()
    }
    /// <p>If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub fn start_timer_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::StartTimerFailedEventAttributes> {
        self.start_timer_failed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed information
    /// about the event. It isn't set for other event types.</p>
    pub fn cancel_timer_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::CancelTimerFailedEventAttributes> {
        self.cancel_timer_failed_event_attributes.as_ref()
    }
    /// <p>If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
    /// detailed information about the event. It isn't set for other event types.</p>
    pub fn start_child_workflow_execution_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::StartChildWorkflowExecutionFailedEventAttributes> {
        self.start_child_workflow_execution_failed_event_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set
    /// for other event types.</p>
    pub fn lambda_function_scheduled_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionScheduledEventAttributes> {
        self.lambda_function_scheduled_event_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for
    /// other event types.</p>
    pub fn lambda_function_started_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionStartedEventAttributes> {
        self.lambda_function_started_event_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set
    /// for other event types.</p>
    pub fn lambda_function_completed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionCompletedEventAttributes> {
        self.lambda_function_completed_event_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for
    /// other event types.</p>
    pub fn lambda_function_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionFailedEventAttributes> {
        self.lambda_function_failed_event_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for
    /// other event types.</p>
    pub fn lambda_function_timed_out_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionTimedOutEventAttributes> {
        self.lambda_function_timed_out_event_attributes.as_ref()
    }
    /// <p>Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't
    /// set for other event types.</p>
    pub fn schedule_lambda_function_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::ScheduleLambdaFunctionFailedEventAttributes> {
        self.schedule_lambda_function_failed_event_attributes
            .as_ref()
    }
    /// <p>Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set
    /// for other event types.</p>
    pub fn start_lambda_function_failed_event_attributes(
        &self,
    ) -> std::option::Option<&crate::model::StartLambdaFunctionFailedEventAttributes> {
        self.start_lambda_function_failed_event_attributes.as_ref()
    }
}
impl std::fmt::Debug for HistoryEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistoryEvent");
        formatter.field("event_timestamp", &self.event_timestamp);
        formatter.field("event_type", &self.event_type);
        formatter.field("event_id", &self.event_id);
        formatter.field(
            "workflow_execution_started_event_attributes",
            &self.workflow_execution_started_event_attributes,
        );
        formatter.field(
            "workflow_execution_completed_event_attributes",
            &self.workflow_execution_completed_event_attributes,
        );
        formatter.field(
            "complete_workflow_execution_failed_event_attributes",
            &self.complete_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "workflow_execution_failed_event_attributes",
            &self.workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "fail_workflow_execution_failed_event_attributes",
            &self.fail_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "workflow_execution_timed_out_event_attributes",
            &self.workflow_execution_timed_out_event_attributes,
        );
        formatter.field(
            "workflow_execution_canceled_event_attributes",
            &self.workflow_execution_canceled_event_attributes,
        );
        formatter.field(
            "cancel_workflow_execution_failed_event_attributes",
            &self.cancel_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "workflow_execution_continued_as_new_event_attributes",
            &self.workflow_execution_continued_as_new_event_attributes,
        );
        formatter.field(
            "continue_as_new_workflow_execution_failed_event_attributes",
            &self.continue_as_new_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "workflow_execution_terminated_event_attributes",
            &self.workflow_execution_terminated_event_attributes,
        );
        formatter.field(
            "workflow_execution_cancel_requested_event_attributes",
            &self.workflow_execution_cancel_requested_event_attributes,
        );
        formatter.field(
            "decision_task_scheduled_event_attributes",
            &self.decision_task_scheduled_event_attributes,
        );
        formatter.field(
            "decision_task_started_event_attributes",
            &self.decision_task_started_event_attributes,
        );
        formatter.field(
            "decision_task_completed_event_attributes",
            &self.decision_task_completed_event_attributes,
        );
        formatter.field(
            "decision_task_timed_out_event_attributes",
            &self.decision_task_timed_out_event_attributes,
        );
        formatter.field(
            "activity_task_scheduled_event_attributes",
            &self.activity_task_scheduled_event_attributes,
        );
        formatter.field(
            "activity_task_started_event_attributes",
            &self.activity_task_started_event_attributes,
        );
        formatter.field(
            "activity_task_completed_event_attributes",
            &self.activity_task_completed_event_attributes,
        );
        formatter.field(
            "activity_task_failed_event_attributes",
            &self.activity_task_failed_event_attributes,
        );
        formatter.field(
            "activity_task_timed_out_event_attributes",
            &self.activity_task_timed_out_event_attributes,
        );
        formatter.field(
            "activity_task_canceled_event_attributes",
            &self.activity_task_canceled_event_attributes,
        );
        formatter.field(
            "activity_task_cancel_requested_event_attributes",
            &self.activity_task_cancel_requested_event_attributes,
        );
        formatter.field(
            "workflow_execution_signaled_event_attributes",
            &self.workflow_execution_signaled_event_attributes,
        );
        formatter.field(
            "marker_recorded_event_attributes",
            &self.marker_recorded_event_attributes,
        );
        formatter.field(
            "record_marker_failed_event_attributes",
            &self.record_marker_failed_event_attributes,
        );
        formatter.field(
            "timer_started_event_attributes",
            &self.timer_started_event_attributes,
        );
        formatter.field(
            "timer_fired_event_attributes",
            &self.timer_fired_event_attributes,
        );
        formatter.field(
            "timer_canceled_event_attributes",
            &self.timer_canceled_event_attributes,
        );
        formatter.field(
            "start_child_workflow_execution_initiated_event_attributes",
            &self.start_child_workflow_execution_initiated_event_attributes,
        );
        formatter.field(
            "child_workflow_execution_started_event_attributes",
            &self.child_workflow_execution_started_event_attributes,
        );
        formatter.field(
            "child_workflow_execution_completed_event_attributes",
            &self.child_workflow_execution_completed_event_attributes,
        );
        formatter.field(
            "child_workflow_execution_failed_event_attributes",
            &self.child_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "child_workflow_execution_timed_out_event_attributes",
            &self.child_workflow_execution_timed_out_event_attributes,
        );
        formatter.field(
            "child_workflow_execution_canceled_event_attributes",
            &self.child_workflow_execution_canceled_event_attributes,
        );
        formatter.field(
            "child_workflow_execution_terminated_event_attributes",
            &self.child_workflow_execution_terminated_event_attributes,
        );
        formatter.field(
            "signal_external_workflow_execution_initiated_event_attributes",
            &self.signal_external_workflow_execution_initiated_event_attributes,
        );
        formatter.field(
            "external_workflow_execution_signaled_event_attributes",
            &self.external_workflow_execution_signaled_event_attributes,
        );
        formatter.field(
            "signal_external_workflow_execution_failed_event_attributes",
            &self.signal_external_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "external_workflow_execution_cancel_requested_event_attributes",
            &self.external_workflow_execution_cancel_requested_event_attributes,
        );
        formatter.field(
            "request_cancel_external_workflow_execution_initiated_event_attributes",
            &self.request_cancel_external_workflow_execution_initiated_event_attributes,
        );
        formatter.field(
            "request_cancel_external_workflow_execution_failed_event_attributes",
            &self.request_cancel_external_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "schedule_activity_task_failed_event_attributes",
            &self.schedule_activity_task_failed_event_attributes,
        );
        formatter.field(
            "request_cancel_activity_task_failed_event_attributes",
            &self.request_cancel_activity_task_failed_event_attributes,
        );
        formatter.field(
            "start_timer_failed_event_attributes",
            &self.start_timer_failed_event_attributes,
        );
        formatter.field(
            "cancel_timer_failed_event_attributes",
            &self.cancel_timer_failed_event_attributes,
        );
        formatter.field(
            "start_child_workflow_execution_failed_event_attributes",
            &self.start_child_workflow_execution_failed_event_attributes,
        );
        formatter.field(
            "lambda_function_scheduled_event_attributes",
            &self.lambda_function_scheduled_event_attributes,
        );
        formatter.field(
            "lambda_function_started_event_attributes",
            &self.lambda_function_started_event_attributes,
        );
        formatter.field(
            "lambda_function_completed_event_attributes",
            &self.lambda_function_completed_event_attributes,
        );
        formatter.field(
            "lambda_function_failed_event_attributes",
            &self.lambda_function_failed_event_attributes,
        );
        formatter.field(
            "lambda_function_timed_out_event_attributes",
            &self.lambda_function_timed_out_event_attributes,
        );
        formatter.field(
            "schedule_lambda_function_failed_event_attributes",
            &self.schedule_lambda_function_failed_event_attributes,
        );
        formatter.field(
            "start_lambda_function_failed_event_attributes",
            &self.start_lambda_function_failed_event_attributes,
        );
        formatter.finish()
    }
}
/// See [`HistoryEvent`](crate::model::HistoryEvent)
pub mod history_event {
    /// A builder for [`HistoryEvent`](crate::model::HistoryEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_type: std::option::Option<crate::model::EventType>,
        pub(crate) event_id: std::option::Option<i64>,
        pub(crate) workflow_execution_started_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionStartedEventAttributes>,
        pub(crate) workflow_execution_completed_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionCompletedEventAttributes>,
        pub(crate) complete_workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::CompleteWorkflowExecutionFailedEventAttributes>,
        pub(crate) workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionFailedEventAttributes>,
        pub(crate) fail_workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::FailWorkflowExecutionFailedEventAttributes>,
        pub(crate) workflow_execution_timed_out_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionTimedOutEventAttributes>,
        pub(crate) workflow_execution_canceled_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionCanceledEventAttributes>,
        pub(crate) cancel_workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::CancelWorkflowExecutionFailedEventAttributes>,
        pub(crate) workflow_execution_continued_as_new_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionContinuedAsNewEventAttributes>,
        pub(crate) continue_as_new_workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes>,
        pub(crate) workflow_execution_terminated_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionTerminatedEventAttributes>,
        pub(crate) workflow_execution_cancel_requested_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionCancelRequestedEventAttributes>,
        pub(crate) decision_task_scheduled_event_attributes:
            std::option::Option<crate::model::DecisionTaskScheduledEventAttributes>,
        pub(crate) decision_task_started_event_attributes:
            std::option::Option<crate::model::DecisionTaskStartedEventAttributes>,
        pub(crate) decision_task_completed_event_attributes:
            std::option::Option<crate::model::DecisionTaskCompletedEventAttributes>,
        pub(crate) decision_task_timed_out_event_attributes:
            std::option::Option<crate::model::DecisionTaskTimedOutEventAttributes>,
        pub(crate) activity_task_scheduled_event_attributes:
            std::option::Option<crate::model::ActivityTaskScheduledEventAttributes>,
        pub(crate) activity_task_started_event_attributes:
            std::option::Option<crate::model::ActivityTaskStartedEventAttributes>,
        pub(crate) activity_task_completed_event_attributes:
            std::option::Option<crate::model::ActivityTaskCompletedEventAttributes>,
        pub(crate) activity_task_failed_event_attributes:
            std::option::Option<crate::model::ActivityTaskFailedEventAttributes>,
        pub(crate) activity_task_timed_out_event_attributes:
            std::option::Option<crate::model::ActivityTaskTimedOutEventAttributes>,
        pub(crate) activity_task_canceled_event_attributes:
            std::option::Option<crate::model::ActivityTaskCanceledEventAttributes>,
        pub(crate) activity_task_cancel_requested_event_attributes:
            std::option::Option<crate::model::ActivityTaskCancelRequestedEventAttributes>,
        pub(crate) workflow_execution_signaled_event_attributes:
            std::option::Option<crate::model::WorkflowExecutionSignaledEventAttributes>,
        pub(crate) marker_recorded_event_attributes:
            std::option::Option<crate::model::MarkerRecordedEventAttributes>,
        pub(crate) record_marker_failed_event_attributes:
            std::option::Option<crate::model::RecordMarkerFailedEventAttributes>,
        pub(crate) timer_started_event_attributes:
            std::option::Option<crate::model::TimerStartedEventAttributes>,
        pub(crate) timer_fired_event_attributes:
            std::option::Option<crate::model::TimerFiredEventAttributes>,
        pub(crate) timer_canceled_event_attributes:
            std::option::Option<crate::model::TimerCanceledEventAttributes>,
        pub(crate) start_child_workflow_execution_initiated_event_attributes:
            std::option::Option<crate::model::StartChildWorkflowExecutionInitiatedEventAttributes>,
        pub(crate) child_workflow_execution_started_event_attributes:
            std::option::Option<crate::model::ChildWorkflowExecutionStartedEventAttributes>,
        pub(crate) child_workflow_execution_completed_event_attributes:
            std::option::Option<crate::model::ChildWorkflowExecutionCompletedEventAttributes>,
        pub(crate) child_workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::ChildWorkflowExecutionFailedEventAttributes>,
        pub(crate) child_workflow_execution_timed_out_event_attributes:
            std::option::Option<crate::model::ChildWorkflowExecutionTimedOutEventAttributes>,
        pub(crate) child_workflow_execution_canceled_event_attributes:
            std::option::Option<crate::model::ChildWorkflowExecutionCanceledEventAttributes>,
        pub(crate) child_workflow_execution_terminated_event_attributes:
            std::option::Option<crate::model::ChildWorkflowExecutionTerminatedEventAttributes>,
        pub(crate) signal_external_workflow_execution_initiated_event_attributes:
            std::option::Option<
                crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes,
            >,
        pub(crate) external_workflow_execution_signaled_event_attributes:
            std::option::Option<crate::model::ExternalWorkflowExecutionSignaledEventAttributes>,
        pub(crate) signal_external_workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::SignalExternalWorkflowExecutionFailedEventAttributes>,
        pub(crate) external_workflow_execution_cancel_requested_event_attributes:
            std::option::Option<
                crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes,
            >,
        pub(crate) request_cancel_external_workflow_execution_initiated_event_attributes:
            std::option::Option<
                crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes,
            >,
        pub(crate) request_cancel_external_workflow_execution_failed_event_attributes:
            std::option::Option<
                crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes,
            >,
        pub(crate) schedule_activity_task_failed_event_attributes:
            std::option::Option<crate::model::ScheduleActivityTaskFailedEventAttributes>,
        pub(crate) request_cancel_activity_task_failed_event_attributes:
            std::option::Option<crate::model::RequestCancelActivityTaskFailedEventAttributes>,
        pub(crate) start_timer_failed_event_attributes:
            std::option::Option<crate::model::StartTimerFailedEventAttributes>,
        pub(crate) cancel_timer_failed_event_attributes:
            std::option::Option<crate::model::CancelTimerFailedEventAttributes>,
        pub(crate) start_child_workflow_execution_failed_event_attributes:
            std::option::Option<crate::model::StartChildWorkflowExecutionFailedEventAttributes>,
        pub(crate) lambda_function_scheduled_event_attributes:
            std::option::Option<crate::model::LambdaFunctionScheduledEventAttributes>,
        pub(crate) lambda_function_started_event_attributes:
            std::option::Option<crate::model::LambdaFunctionStartedEventAttributes>,
        pub(crate) lambda_function_completed_event_attributes:
            std::option::Option<crate::model::LambdaFunctionCompletedEventAttributes>,
        pub(crate) lambda_function_failed_event_attributes:
            std::option::Option<crate::model::LambdaFunctionFailedEventAttributes>,
        pub(crate) lambda_function_timed_out_event_attributes:
            std::option::Option<crate::model::LambdaFunctionTimedOutEventAttributes>,
        pub(crate) schedule_lambda_function_failed_event_attributes:
            std::option::Option<crate::model::ScheduleLambdaFunctionFailedEventAttributes>,
        pub(crate) start_lambda_function_failed_event_attributes:
            std::option::Option<crate::model::StartLambdaFunctionFailedEventAttributes>,
    }
    impl Builder {
        /// <p>The date and time when the event occurred.</p>
        pub fn event_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.event_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the event occurred.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.event_timestamp = input;
            self
        }
        /// <p>The type of the history event.</p>
        pub fn event_type(mut self, input: crate::model::EventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The type of the history event.</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution history.</p>
        pub fn event_id(mut self, input: i64) -> Self {
            self.event_id = Some(input);
            self
        }
        /// <p>The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution history.</p>
        pub fn set_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_started_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionStartedEventAttributes,
        ) -> Self {
            self.workflow_execution_started_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_started_event_attributes(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionStartedEventAttributes>,
        ) -> Self {
            self.workflow_execution_started_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_completed_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionCompletedEventAttributes,
        ) -> Self {
            self.workflow_execution_completed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_completed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionCompletedEventAttributes>,
        ) -> Self {
            self.workflow_execution_completed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn complete_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::CompleteWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.complete_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_complete_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::CompleteWorkflowExecutionFailedEventAttributes,
            >,
        ) -> Self {
            self.complete_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFailedEventAttributes>,
        ) -> Self {
            self.workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn fail_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::FailWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.fail_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_fail_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::FailWorkflowExecutionFailedEventAttributes>,
        ) -> Self {
            self.fail_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_timed_out_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionTimedOutEventAttributes,
        ) -> Self {
            self.workflow_execution_timed_out_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_timed_out_event_attributes(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionTimedOutEventAttributes>,
        ) -> Self {
            self.workflow_execution_timed_out_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_canceled_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionCanceledEventAttributes,
        ) -> Self {
            self.workflow_execution_canceled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_canceled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionCanceledEventAttributes>,
        ) -> Self {
            self.workflow_execution_canceled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn cancel_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::CancelWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.cancel_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_cancel_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::CancelWorkflowExecutionFailedEventAttributes>,
        ) -> Self {
            self.cancel_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_continued_as_new_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionContinuedAsNewEventAttributes,
        ) -> Self {
            self.workflow_execution_continued_as_new_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_continued_as_new_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::WorkflowExecutionContinuedAsNewEventAttributes,
            >,
        ) -> Self {
            self.workflow_execution_continued_as_new_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn continue_as_new_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.continue_as_new_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_continue_as_new_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes,
            >,
        ) -> Self {
            self.continue_as_new_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_terminated_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionTerminatedEventAttributes,
        ) -> Self {
            self.workflow_execution_terminated_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_terminated_event_attributes(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionTerminatedEventAttributes>,
        ) -> Self {
            self.workflow_execution_terminated_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_cancel_requested_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionCancelRequestedEventAttributes,
        ) -> Self {
            self.workflow_execution_cancel_requested_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_cancel_requested_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::WorkflowExecutionCancelRequestedEventAttributes,
            >,
        ) -> Self {
            self.workflow_execution_cancel_requested_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn decision_task_scheduled_event_attributes(
            mut self,
            input: crate::model::DecisionTaskScheduledEventAttributes,
        ) -> Self {
            self.decision_task_scheduled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_decision_task_scheduled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::DecisionTaskScheduledEventAttributes>,
        ) -> Self {
            self.decision_task_scheduled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn decision_task_started_event_attributes(
            mut self,
            input: crate::model::DecisionTaskStartedEventAttributes,
        ) -> Self {
            self.decision_task_started_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_decision_task_started_event_attributes(
            mut self,
            input: std::option::Option<crate::model::DecisionTaskStartedEventAttributes>,
        ) -> Self {
            self.decision_task_started_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn decision_task_completed_event_attributes(
            mut self,
            input: crate::model::DecisionTaskCompletedEventAttributes,
        ) -> Self {
            self.decision_task_completed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_decision_task_completed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::DecisionTaskCompletedEventAttributes>,
        ) -> Self {
            self.decision_task_completed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn decision_task_timed_out_event_attributes(
            mut self,
            input: crate::model::DecisionTaskTimedOutEventAttributes,
        ) -> Self {
            self.decision_task_timed_out_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_decision_task_timed_out_event_attributes(
            mut self,
            input: std::option::Option<crate::model::DecisionTaskTimedOutEventAttributes>,
        ) -> Self {
            self.decision_task_timed_out_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn activity_task_scheduled_event_attributes(
            mut self,
            input: crate::model::ActivityTaskScheduledEventAttributes,
        ) -> Self {
            self.activity_task_scheduled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_activity_task_scheduled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskScheduledEventAttributes>,
        ) -> Self {
            self.activity_task_scheduled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn activity_task_started_event_attributes(
            mut self,
            input: crate::model::ActivityTaskStartedEventAttributes,
        ) -> Self {
            self.activity_task_started_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_activity_task_started_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskStartedEventAttributes>,
        ) -> Self {
            self.activity_task_started_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn activity_task_completed_event_attributes(
            mut self,
            input: crate::model::ActivityTaskCompletedEventAttributes,
        ) -> Self {
            self.activity_task_completed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_activity_task_completed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskCompletedEventAttributes>,
        ) -> Self {
            self.activity_task_completed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn activity_task_failed_event_attributes(
            mut self,
            input: crate::model::ActivityTaskFailedEventAttributes,
        ) -> Self {
            self.activity_task_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_activity_task_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskFailedEventAttributes>,
        ) -> Self {
            self.activity_task_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn activity_task_timed_out_event_attributes(
            mut self,
            input: crate::model::ActivityTaskTimedOutEventAttributes,
        ) -> Self {
            self.activity_task_timed_out_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_activity_task_timed_out_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskTimedOutEventAttributes>,
        ) -> Self {
            self.activity_task_timed_out_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn activity_task_canceled_event_attributes(
            mut self,
            input: crate::model::ActivityTaskCanceledEventAttributes,
        ) -> Self {
            self.activity_task_canceled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_activity_task_canceled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskCanceledEventAttributes>,
        ) -> Self {
            self.activity_task_canceled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn activity_task_cancel_requested_event_attributes(
            mut self,
            input: crate::model::ActivityTaskCancelRequestedEventAttributes,
        ) -> Self {
            self.activity_task_cancel_requested_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_activity_task_cancel_requested_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskCancelRequestedEventAttributes>,
        ) -> Self {
            self.activity_task_cancel_requested_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn workflow_execution_signaled_event_attributes(
            mut self,
            input: crate::model::WorkflowExecutionSignaledEventAttributes,
        ) -> Self {
            self.workflow_execution_signaled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_workflow_execution_signaled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionSignaledEventAttributes>,
        ) -> Self {
            self.workflow_execution_signaled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn marker_recorded_event_attributes(
            mut self,
            input: crate::model::MarkerRecordedEventAttributes,
        ) -> Self {
            self.marker_recorded_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn set_marker_recorded_event_attributes(
            mut self,
            input: std::option::Option<crate::model::MarkerRecordedEventAttributes>,
        ) -> Self {
            self.marker_recorded_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn record_marker_failed_event_attributes(
            mut self,
            input: crate::model::RecordMarkerFailedEventAttributes,
        ) -> Self {
            self.record_marker_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_record_marker_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::RecordMarkerFailedEventAttributes>,
        ) -> Self {
            self.record_marker_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn timer_started_event_attributes(
            mut self,
            input: crate::model::TimerStartedEventAttributes,
        ) -> Self {
            self.timer_started_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn set_timer_started_event_attributes(
            mut self,
            input: std::option::Option<crate::model::TimerStartedEventAttributes>,
        ) -> Self {
            self.timer_started_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>TimerFired</code> then this member is set and provides detailed information about
        /// the event. It isn't set for other event types.</p>
        pub fn timer_fired_event_attributes(
            mut self,
            input: crate::model::TimerFiredEventAttributes,
        ) -> Self {
            self.timer_fired_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>TimerFired</code> then this member is set and provides detailed information about
        /// the event. It isn't set for other event types.</p>
        pub fn set_timer_fired_event_attributes(
            mut self,
            input: std::option::Option<crate::model::TimerFiredEventAttributes>,
        ) -> Self {
            self.timer_fired_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn timer_canceled_event_attributes(
            mut self,
            input: crate::model::TimerCanceledEventAttributes,
        ) -> Self {
            self.timer_canceled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn set_timer_canceled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::TimerCanceledEventAttributes>,
        ) -> Self {
            self.timer_canceled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn start_child_workflow_execution_initiated_event_attributes(
            mut self,
            input: crate::model::StartChildWorkflowExecutionInitiatedEventAttributes,
        ) -> Self {
            self.start_child_workflow_execution_initiated_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_start_child_workflow_execution_initiated_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::StartChildWorkflowExecutionInitiatedEventAttributes,
            >,
        ) -> Self {
            self.start_child_workflow_execution_initiated_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn child_workflow_execution_started_event_attributes(
            mut self,
            input: crate::model::ChildWorkflowExecutionStartedEventAttributes,
        ) -> Self {
            self.child_workflow_execution_started_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_child_workflow_execution_started_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ChildWorkflowExecutionStartedEventAttributes>,
        ) -> Self {
            self.child_workflow_execution_started_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn child_workflow_execution_completed_event_attributes(
            mut self,
            input: crate::model::ChildWorkflowExecutionCompletedEventAttributes,
        ) -> Self {
            self.child_workflow_execution_completed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_child_workflow_execution_completed_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::ChildWorkflowExecutionCompletedEventAttributes,
            >,
        ) -> Self {
            self.child_workflow_execution_completed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn child_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::ChildWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.child_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_child_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ChildWorkflowExecutionFailedEventAttributes>,
        ) -> Self {
            self.child_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn child_workflow_execution_timed_out_event_attributes(
            mut self,
            input: crate::model::ChildWorkflowExecutionTimedOutEventAttributes,
        ) -> Self {
            self.child_workflow_execution_timed_out_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_child_workflow_execution_timed_out_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ChildWorkflowExecutionTimedOutEventAttributes>,
        ) -> Self {
            self.child_workflow_execution_timed_out_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn child_workflow_execution_canceled_event_attributes(
            mut self,
            input: crate::model::ChildWorkflowExecutionCanceledEventAttributes,
        ) -> Self {
            self.child_workflow_execution_canceled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_child_workflow_execution_canceled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ChildWorkflowExecutionCanceledEventAttributes>,
        ) -> Self {
            self.child_workflow_execution_canceled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn child_workflow_execution_terminated_event_attributes(
            mut self,
            input: crate::model::ChildWorkflowExecutionTerminatedEventAttributes,
        ) -> Self {
            self.child_workflow_execution_terminated_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_child_workflow_execution_terminated_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::ChildWorkflowExecutionTerminatedEventAttributes,
            >,
        ) -> Self {
            self.child_workflow_execution_terminated_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types.</p>
        pub fn signal_external_workflow_execution_initiated_event_attributes(
            mut self,
            input: crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes,
        ) -> Self {
            self.signal_external_workflow_execution_initiated_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types.</p>
        pub fn set_signal_external_workflow_execution_initiated_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes,
            >,
        ) -> Self {
            self.signal_external_workflow_execution_initiated_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn external_workflow_execution_signaled_event_attributes(
            mut self,
            input: crate::model::ExternalWorkflowExecutionSignaledEventAttributes,
        ) -> Self {
            self.external_workflow_execution_signaled_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_external_workflow_execution_signaled_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::ExternalWorkflowExecutionSignaledEventAttributes,
            >,
        ) -> Self {
            self.external_workflow_execution_signaled_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn signal_external_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::SignalExternalWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.signal_external_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_signal_external_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::SignalExternalWorkflowExecutionFailedEventAttributes,
            >,
        ) -> Self {
            self.signal_external_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types. </p>
        pub fn external_workflow_execution_cancel_requested_event_attributes(
            mut self,
            input: crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes,
        ) -> Self {
            self.external_workflow_execution_cancel_requested_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types. </p>
        pub fn set_external_workflow_execution_cancel_requested_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes,
            >,
        ) -> Self {
            self.external_workflow_execution_cancel_requested_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types.</p>
        pub fn request_cancel_external_workflow_execution_initiated_event_attributes(
            mut self,
            input: crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes,
        ) -> Self {
            self.request_cancel_external_workflow_execution_initiated_event_attributes =
                Some(input);
            self
        }
        /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types.</p>
        pub fn set_request_cancel_external_workflow_execution_initiated_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes,
            >,
        ) -> Self {
            self.request_cancel_external_workflow_execution_initiated_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types.</p>
        pub fn request_cancel_external_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.request_cancel_external_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
        /// provides detailed information about the event. It isn't set for other event types.</p>
        pub fn set_request_cancel_external_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes,
            >,
        ) -> Self {
            self.request_cancel_external_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn schedule_activity_task_failed_event_attributes(
            mut self,
            input: crate::model::ScheduleActivityTaskFailedEventAttributes,
        ) -> Self {
            self.schedule_activity_task_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
        /// information about the event. It isn't set for other event types.</p>
        pub fn set_schedule_activity_task_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ScheduleActivityTaskFailedEventAttributes>,
        ) -> Self {
            self.schedule_activity_task_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn request_cancel_activity_task_failed_event_attributes(
            mut self,
            input: crate::model::RequestCancelActivityTaskFailedEventAttributes,
        ) -> Self {
            self.request_cancel_activity_task_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_request_cancel_activity_task_failed_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::RequestCancelActivityTaskFailedEventAttributes,
            >,
        ) -> Self {
            self.request_cancel_activity_task_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn start_timer_failed_event_attributes(
            mut self,
            input: crate::model::StartTimerFailedEventAttributes,
        ) -> Self {
            self.start_timer_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn set_start_timer_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::StartTimerFailedEventAttributes>,
        ) -> Self {
            self.start_timer_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn cancel_timer_failed_event_attributes(
            mut self,
            input: crate::model::CancelTimerFailedEventAttributes,
        ) -> Self {
            self.cancel_timer_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed information
        /// about the event. It isn't set for other event types.</p>
        pub fn set_cancel_timer_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::CancelTimerFailedEventAttributes>,
        ) -> Self {
            self.cancel_timer_failed_event_attributes = input;
            self
        }
        /// <p>If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn start_child_workflow_execution_failed_event_attributes(
            mut self,
            input: crate::model::StartChildWorkflowExecutionFailedEventAttributes,
        ) -> Self {
            self.start_child_workflow_execution_failed_event_attributes = Some(input);
            self
        }
        /// <p>If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
        /// detailed information about the event. It isn't set for other event types.</p>
        pub fn set_start_child_workflow_execution_failed_event_attributes(
            mut self,
            input: std::option::Option<
                crate::model::StartChildWorkflowExecutionFailedEventAttributes,
            >,
        ) -> Self {
            self.start_child_workflow_execution_failed_event_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set
        /// for other event types.</p>
        pub fn lambda_function_scheduled_event_attributes(
            mut self,
            input: crate::model::LambdaFunctionScheduledEventAttributes,
        ) -> Self {
            self.lambda_function_scheduled_event_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set
        /// for other event types.</p>
        pub fn set_lambda_function_scheduled_event_attributes(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionScheduledEventAttributes>,
        ) -> Self {
            self.lambda_function_scheduled_event_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for
        /// other event types.</p>
        pub fn lambda_function_started_event_attributes(
            mut self,
            input: crate::model::LambdaFunctionStartedEventAttributes,
        ) -> Self {
            self.lambda_function_started_event_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for
        /// other event types.</p>
        pub fn set_lambda_function_started_event_attributes(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionStartedEventAttributes>,
        ) -> Self {
            self.lambda_function_started_event_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set
        /// for other event types.</p>
        pub fn lambda_function_completed_event_attributes(
            mut self,
            input: crate::model::LambdaFunctionCompletedEventAttributes,
        ) -> Self {
            self.lambda_function_completed_event_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set
        /// for other event types.</p>
        pub fn set_lambda_function_completed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionCompletedEventAttributes>,
        ) -> Self {
            self.lambda_function_completed_event_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for
        /// other event types.</p>
        pub fn lambda_function_failed_event_attributes(
            mut self,
            input: crate::model::LambdaFunctionFailedEventAttributes,
        ) -> Self {
            self.lambda_function_failed_event_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for
        /// other event types.</p>
        pub fn set_lambda_function_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionFailedEventAttributes>,
        ) -> Self {
            self.lambda_function_failed_event_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for
        /// other event types.</p>
        pub fn lambda_function_timed_out_event_attributes(
            mut self,
            input: crate::model::LambdaFunctionTimedOutEventAttributes,
        ) -> Self {
            self.lambda_function_timed_out_event_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for
        /// other event types.</p>
        pub fn set_lambda_function_timed_out_event_attributes(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionTimedOutEventAttributes>,
        ) -> Self {
            self.lambda_function_timed_out_event_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't
        /// set for other event types.</p>
        pub fn schedule_lambda_function_failed_event_attributes(
            mut self,
            input: crate::model::ScheduleLambdaFunctionFailedEventAttributes,
        ) -> Self {
            self.schedule_lambda_function_failed_event_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't
        /// set for other event types.</p>
        pub fn set_schedule_lambda_function_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::ScheduleLambdaFunctionFailedEventAttributes>,
        ) -> Self {
            self.schedule_lambda_function_failed_event_attributes = input;
            self
        }
        /// <p>Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set
        /// for other event types.</p>
        pub fn start_lambda_function_failed_event_attributes(
            mut self,
            input: crate::model::StartLambdaFunctionFailedEventAttributes,
        ) -> Self {
            self.start_lambda_function_failed_event_attributes = Some(input);
            self
        }
        /// <p>Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set
        /// for other event types.</p>
        pub fn set_start_lambda_function_failed_event_attributes(
            mut self,
            input: std::option::Option<crate::model::StartLambdaFunctionFailedEventAttributes>,
        ) -> Self {
            self.start_lambda_function_failed_event_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`HistoryEvent`](crate::model::HistoryEvent)
        pub fn build(self) -> crate::model::HistoryEvent {
            crate::model::HistoryEvent {
                event_timestamp: self.event_timestamp,
                event_type: self.event_type,
                event_id: self.event_id.unwrap_or_default(),
                workflow_execution_started_event_attributes: self
                    .workflow_execution_started_event_attributes,
                workflow_execution_completed_event_attributes: self
                    .workflow_execution_completed_event_attributes,
                complete_workflow_execution_failed_event_attributes: self
                    .complete_workflow_execution_failed_event_attributes,
                workflow_execution_failed_event_attributes: self
                    .workflow_execution_failed_event_attributes,
                fail_workflow_execution_failed_event_attributes: self
                    .fail_workflow_execution_failed_event_attributes,
                workflow_execution_timed_out_event_attributes: self
                    .workflow_execution_timed_out_event_attributes,
                workflow_execution_canceled_event_attributes: self
                    .workflow_execution_canceled_event_attributes,
                cancel_workflow_execution_failed_event_attributes: self
                    .cancel_workflow_execution_failed_event_attributes,
                workflow_execution_continued_as_new_event_attributes: self
                    .workflow_execution_continued_as_new_event_attributes,
                continue_as_new_workflow_execution_failed_event_attributes: self
                    .continue_as_new_workflow_execution_failed_event_attributes,
                workflow_execution_terminated_event_attributes: self
                    .workflow_execution_terminated_event_attributes,
                workflow_execution_cancel_requested_event_attributes: self
                    .workflow_execution_cancel_requested_event_attributes,
                decision_task_scheduled_event_attributes: self
                    .decision_task_scheduled_event_attributes,
                decision_task_started_event_attributes: self.decision_task_started_event_attributes,
                decision_task_completed_event_attributes: self
                    .decision_task_completed_event_attributes,
                decision_task_timed_out_event_attributes: self
                    .decision_task_timed_out_event_attributes,
                activity_task_scheduled_event_attributes: self
                    .activity_task_scheduled_event_attributes,
                activity_task_started_event_attributes: self.activity_task_started_event_attributes,
                activity_task_completed_event_attributes: self
                    .activity_task_completed_event_attributes,
                activity_task_failed_event_attributes: self.activity_task_failed_event_attributes,
                activity_task_timed_out_event_attributes: self
                    .activity_task_timed_out_event_attributes,
                activity_task_canceled_event_attributes: self
                    .activity_task_canceled_event_attributes,
                activity_task_cancel_requested_event_attributes: self
                    .activity_task_cancel_requested_event_attributes,
                workflow_execution_signaled_event_attributes: self
                    .workflow_execution_signaled_event_attributes,
                marker_recorded_event_attributes: self.marker_recorded_event_attributes,
                record_marker_failed_event_attributes: self.record_marker_failed_event_attributes,
                timer_started_event_attributes: self.timer_started_event_attributes,
                timer_fired_event_attributes: self.timer_fired_event_attributes,
                timer_canceled_event_attributes: self.timer_canceled_event_attributes,
                start_child_workflow_execution_initiated_event_attributes: self
                    .start_child_workflow_execution_initiated_event_attributes,
                child_workflow_execution_started_event_attributes: self
                    .child_workflow_execution_started_event_attributes,
                child_workflow_execution_completed_event_attributes: self
                    .child_workflow_execution_completed_event_attributes,
                child_workflow_execution_failed_event_attributes: self
                    .child_workflow_execution_failed_event_attributes,
                child_workflow_execution_timed_out_event_attributes: self
                    .child_workflow_execution_timed_out_event_attributes,
                child_workflow_execution_canceled_event_attributes: self
                    .child_workflow_execution_canceled_event_attributes,
                child_workflow_execution_terminated_event_attributes: self
                    .child_workflow_execution_terminated_event_attributes,
                signal_external_workflow_execution_initiated_event_attributes: self
                    .signal_external_workflow_execution_initiated_event_attributes,
                external_workflow_execution_signaled_event_attributes: self
                    .external_workflow_execution_signaled_event_attributes,
                signal_external_workflow_execution_failed_event_attributes: self
                    .signal_external_workflow_execution_failed_event_attributes,
                external_workflow_execution_cancel_requested_event_attributes: self
                    .external_workflow_execution_cancel_requested_event_attributes,
                request_cancel_external_workflow_execution_initiated_event_attributes: self
                    .request_cancel_external_workflow_execution_initiated_event_attributes,
                request_cancel_external_workflow_execution_failed_event_attributes: self
                    .request_cancel_external_workflow_execution_failed_event_attributes,
                schedule_activity_task_failed_event_attributes: self
                    .schedule_activity_task_failed_event_attributes,
                request_cancel_activity_task_failed_event_attributes: self
                    .request_cancel_activity_task_failed_event_attributes,
                start_timer_failed_event_attributes: self.start_timer_failed_event_attributes,
                cancel_timer_failed_event_attributes: self.cancel_timer_failed_event_attributes,
                start_child_workflow_execution_failed_event_attributes: self
                    .start_child_workflow_execution_failed_event_attributes,
                lambda_function_scheduled_event_attributes: self
                    .lambda_function_scheduled_event_attributes,
                lambda_function_started_event_attributes: self
                    .lambda_function_started_event_attributes,
                lambda_function_completed_event_attributes: self
                    .lambda_function_completed_event_attributes,
                lambda_function_failed_event_attributes: self
                    .lambda_function_failed_event_attributes,
                lambda_function_timed_out_event_attributes: self
                    .lambda_function_timed_out_event_attributes,
                schedule_lambda_function_failed_event_attributes: self
                    .schedule_lambda_function_failed_event_attributes,
                start_lambda_function_failed_event_attributes: self
                    .start_lambda_function_failed_event_attributes,
            }
        }
    }
}
impl HistoryEvent {
    /// Creates a new builder-style object to manufacture [`HistoryEvent`](crate::model::HistoryEvent)
    pub fn builder() -> crate::model::history_event::Builder {
        crate::model::history_event::Builder::default()
    }
}

/// <p>Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set
/// for other event types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLambdaFunctionFailedEventAttributes {
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
    /// failed because the IAM role attached to the execution lacked sufficient permissions. For
    /// details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::StartLambdaFunctionFailedCause>,
    /// <p>A description that can help diagnose the cause of the fault.</p>
    pub message: std::option::Option<std::string::String>,
}
impl StartLambdaFunctionFailedEventAttributes {
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
    /// failed because the IAM role attached to the execution lacked sufficient permissions. For
    /// details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::StartLambdaFunctionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>A description that can help diagnose the cause of the fault.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for StartLambdaFunctionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLambdaFunctionFailedEventAttributes");
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("cause", &self.cause);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`StartLambdaFunctionFailedEventAttributes`](crate::model::StartLambdaFunctionFailedEventAttributes)
pub mod start_lambda_function_failed_event_attributes {
    /// A builder for [`StartLambdaFunctionFailedEventAttributes`](crate::model::StartLambdaFunctionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) cause: std::option::Option<crate::model::StartLambdaFunctionFailedCause>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
        /// failed because the IAM role attached to the execution lacked sufficient permissions. For
        /// details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::StartLambdaFunctionFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
        /// failed because the IAM role attached to the execution lacked sufficient permissions. For
        /// details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::StartLambdaFunctionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>A description that can help diagnose the cause of the fault.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description that can help diagnose the cause of the fault.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StartLambdaFunctionFailedEventAttributes`](crate::model::StartLambdaFunctionFailedEventAttributes)
        pub fn build(self) -> crate::model::StartLambdaFunctionFailedEventAttributes {
            crate::model::StartLambdaFunctionFailedEventAttributes {
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                cause: self.cause,
                message: self.message,
            }
        }
    }
}
impl StartLambdaFunctionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`StartLambdaFunctionFailedEventAttributes`](crate::model::StartLambdaFunctionFailedEventAttributes)
    pub fn builder() -> crate::model::start_lambda_function_failed_event_attributes::Builder {
        crate::model::start_lambda_function_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StartLambdaFunctionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    AssumeRoleFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StartLambdaFunctionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "ASSUME_ROLE_FAILED" => StartLambdaFunctionFailedCause::AssumeRoleFailed,
            other => StartLambdaFunctionFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StartLambdaFunctionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StartLambdaFunctionFailedCause::from(s))
    }
}
impl StartLambdaFunctionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StartLambdaFunctionFailedCause::AssumeRoleFailed => "ASSUME_ROLE_FAILED",
            StartLambdaFunctionFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASSUME_ROLE_FAILED"]
    }
}
impl AsRef<str> for StartLambdaFunctionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't
/// set for other event types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleLambdaFunctionFailedEventAttributes {
    /// <p>The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
    /// failed because it lacked sufficient permissions. For details and example IAM policies, see
    /// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
    /// IAM to Manage Access to Amazon SWF Workflows</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::ScheduleLambdaFunctionFailedCause>,
    /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
    /// that resulted in scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl ScheduleLambdaFunctionFailedEventAttributes {
    /// <p>The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
    /// </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
    /// failed because it lacked sufficient permissions. For details and example IAM policies, see
    /// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
    /// IAM to Manage Access to Amazon SWF Workflows</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::ScheduleLambdaFunctionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
    /// that resulted in scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for ScheduleLambdaFunctionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleLambdaFunctionFailedEventAttributes");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`ScheduleLambdaFunctionFailedEventAttributes`](crate::model::ScheduleLambdaFunctionFailedEventAttributes)
pub mod schedule_lambda_function_failed_event_attributes {
    /// A builder for [`ScheduleLambdaFunctionFailedEventAttributes`](crate::model::ScheduleLambdaFunctionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<crate::model::ScheduleLambdaFunctionFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
        /// failed because it lacked sufficient permissions. For details and example IAM policies, see
        /// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
        /// IAM to Manage Access to Amazon SWF Workflows</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::ScheduleLambdaFunctionFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision
        /// failed because it lacked sufficient permissions. For details and example IAM policies, see
        /// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
        /// IAM to Manage Access to Amazon SWF Workflows</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::ScheduleLambdaFunctionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
        /// that resulted in scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
        /// that resulted in scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleLambdaFunctionFailedEventAttributes`](crate::model::ScheduleLambdaFunctionFailedEventAttributes)
        pub fn build(self) -> crate::model::ScheduleLambdaFunctionFailedEventAttributes {
            crate::model::ScheduleLambdaFunctionFailedEventAttributes {
                id: self.id,
                name: self.name,
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl ScheduleLambdaFunctionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ScheduleLambdaFunctionFailedEventAttributes`](crate::model::ScheduleLambdaFunctionFailedEventAttributes)
    pub fn builder() -> crate::model::schedule_lambda_function_failed_event_attributes::Builder {
        crate::model::schedule_lambda_function_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduleLambdaFunctionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    IdAlreadyInUse,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionCreationRateExceeded,
    #[allow(missing_docs)] // documentation missing in model
    LambdaServiceNotAvailableInRegion,
    #[allow(missing_docs)] // documentation missing in model
    OpenLambdaFunctionsLimitExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduleLambdaFunctionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "ID_ALREADY_IN_USE" => ScheduleLambdaFunctionFailedCause::IdAlreadyInUse,
            "LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED" => {
                ScheduleLambdaFunctionFailedCause::LambdaFunctionCreationRateExceeded
            }
            "LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION" => {
                ScheduleLambdaFunctionFailedCause::LambdaServiceNotAvailableInRegion
            }
            "OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED" => {
                ScheduleLambdaFunctionFailedCause::OpenLambdaFunctionsLimitExceeded
            }
            other => ScheduleLambdaFunctionFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduleLambdaFunctionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduleLambdaFunctionFailedCause::from(s))
    }
}
impl ScheduleLambdaFunctionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduleLambdaFunctionFailedCause::IdAlreadyInUse => "ID_ALREADY_IN_USE",
            ScheduleLambdaFunctionFailedCause::LambdaFunctionCreationRateExceeded => {
                "LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED"
            }
            ScheduleLambdaFunctionFailedCause::LambdaServiceNotAvailableInRegion => {
                "LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION"
            }
            ScheduleLambdaFunctionFailedCause::OpenLambdaFunctionsLimitExceeded => {
                "OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED"
            }
            ScheduleLambdaFunctionFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ID_ALREADY_IN_USE",
            "LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED",
            "LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION",
            "OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED",
        ]
    }
}
impl AsRef<str> for ScheduleLambdaFunctionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides details of the <code>LambdaFunctionTimedOut</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionTimedOutEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>ActivityTaskStarted</code> event that was recorded when this
    /// activity task started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub started_event_id: i64,
    /// <p>The type of the timeout that caused this event.</p>
    pub timeout_type: std::option::Option<crate::model::LambdaFunctionTimeoutType>,
}
impl LambdaFunctionTimedOutEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>ActivityTaskStarted</code> event that was recorded when this
    /// activity task started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
    /// <p>The type of the timeout that caused this event.</p>
    pub fn timeout_type(&self) -> std::option::Option<&crate::model::LambdaFunctionTimeoutType> {
        self.timeout_type.as_ref()
    }
}
impl std::fmt::Debug for LambdaFunctionTimedOutEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionTimedOutEventAttributes");
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.field("timeout_type", &self.timeout_type);
        formatter.finish()
    }
}
/// See [`LambdaFunctionTimedOutEventAttributes`](crate::model::LambdaFunctionTimedOutEventAttributes)
pub mod lambda_function_timed_out_event_attributes {
    /// A builder for [`LambdaFunctionTimedOutEventAttributes`](crate::model::LambdaFunctionTimedOutEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
        pub(crate) timeout_type: std::option::Option<crate::model::LambdaFunctionTimeoutType>,
    }
    impl Builder {
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event that was recorded when this
        /// activity task started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event that was recorded when this
        /// activity task started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// <p>The type of the timeout that caused this event.</p>
        pub fn timeout_type(mut self, input: crate::model::LambdaFunctionTimeoutType) -> Self {
            self.timeout_type = Some(input);
            self
        }
        /// <p>The type of the timeout that caused this event.</p>
        pub fn set_timeout_type(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionTimeoutType>,
        ) -> Self {
            self.timeout_type = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionTimedOutEventAttributes`](crate::model::LambdaFunctionTimedOutEventAttributes)
        pub fn build(self) -> crate::model::LambdaFunctionTimedOutEventAttributes {
            crate::model::LambdaFunctionTimedOutEventAttributes {
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
                timeout_type: self.timeout_type,
            }
        }
    }
}
impl LambdaFunctionTimedOutEventAttributes {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionTimedOutEventAttributes`](crate::model::LambdaFunctionTimedOutEventAttributes)
    pub fn builder() -> crate::model::lambda_function_timed_out_event_attributes::Builder {
        crate::model::lambda_function_timed_out_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionTimeoutType {
    #[allow(missing_docs)] // documentation missing in model
    StartToClose,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionTimeoutType {
    fn from(s: &str) -> Self {
        match s {
            "START_TO_CLOSE" => LambdaFunctionTimeoutType::StartToClose,
            other => LambdaFunctionTimeoutType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionTimeoutType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionTimeoutType::from(s))
    }
}
impl LambdaFunctionTimeoutType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionTimeoutType::StartToClose => "START_TO_CLOSE",
            LambdaFunctionTimeoutType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["START_TO_CLOSE"]
    }
}
impl AsRef<str> for LambdaFunctionTimeoutType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for
/// other event types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionFailedEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
    /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub started_event_id: i64,
    /// <p>The reason provided for the failure.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The details of the failure.</p>
    pub details: std::option::Option<std::string::String>,
}
impl LambdaFunctionFailedEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
    /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
    /// <p>The reason provided for the failure.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The details of the failure.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionFailedEventAttributes");
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`LambdaFunctionFailedEventAttributes`](crate::model::LambdaFunctionFailedEventAttributes)
pub mod lambda_function_failed_event_attributes {
    /// A builder for [`LambdaFunctionFailedEventAttributes`](crate::model::LambdaFunctionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
        /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
        /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// <p>The reason provided for the failure.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason provided for the failure.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The details of the failure.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details of the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionFailedEventAttributes`](crate::model::LambdaFunctionFailedEventAttributes)
        pub fn build(self) -> crate::model::LambdaFunctionFailedEventAttributes {
            crate::model::LambdaFunctionFailedEventAttributes {
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
                reason: self.reason,
                details: self.details,
            }
        }
    }
}
impl LambdaFunctionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionFailedEventAttributes`](crate::model::LambdaFunctionFailedEventAttributes)
    pub fn builder() -> crate::model::lambda_function_failed_event_attributes::Builder {
        crate::model::lambda_function_failed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set
/// for other event types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionCompletedEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// Lambda task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
    /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub started_event_id: i64,
    /// <p>The results of the Lambda task.</p>
    pub result: std::option::Option<std::string::String>,
}
impl LambdaFunctionCompletedEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// Lambda task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
    /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
    /// <p>The results of the Lambda task.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionCompletedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionCompletedEventAttributes");
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`LambdaFunctionCompletedEventAttributes`](crate::model::LambdaFunctionCompletedEventAttributes)
pub mod lambda_function_completed_event_attributes {
    /// A builder for [`LambdaFunctionCompletedEventAttributes`](crate::model::LambdaFunctionCompletedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
        pub(crate) result: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// Lambda task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// Lambda task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
        /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this activity task
        /// started. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// <p>The results of the Lambda task.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>The results of the Lambda task.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionCompletedEventAttributes`](crate::model::LambdaFunctionCompletedEventAttributes)
        pub fn build(self) -> crate::model::LambdaFunctionCompletedEventAttributes {
            crate::model::LambdaFunctionCompletedEventAttributes {
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
                result: self.result,
            }
        }
    }
}
impl LambdaFunctionCompletedEventAttributes {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionCompletedEventAttributes`](crate::model::LambdaFunctionCompletedEventAttributes)
    pub fn builder() -> crate::model::lambda_function_completed_event_attributes::Builder {
        crate::model::lambda_function_completed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for
/// other event types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionStartedEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
}
impl LambdaFunctionStartedEventAttributes {
    /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
    /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
}
impl std::fmt::Debug for LambdaFunctionStartedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionStartedEventAttributes");
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.finish()
    }
}
/// See [`LambdaFunctionStartedEventAttributes`](crate::model::LambdaFunctionStartedEventAttributes)
pub mod lambda_function_started_event_attributes {
    /// A builder for [`LambdaFunctionStartedEventAttributes`](crate::model::LambdaFunctionStartedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this
        /// activity task was scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionStartedEventAttributes`](crate::model::LambdaFunctionStartedEventAttributes)
        pub fn build(self) -> crate::model::LambdaFunctionStartedEventAttributes {
            crate::model::LambdaFunctionStartedEventAttributes {
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
            }
        }
    }
}
impl LambdaFunctionStartedEventAttributes {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionStartedEventAttributes`](crate::model::LambdaFunctionStartedEventAttributes)
    pub fn builder() -> crate::model::lambda_function_started_event_attributes::Builder {
        crate::model::lambda_function_started_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set
/// for other event types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionScheduledEventAttributes {
    /// <p>The unique ID of the Lambda task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Data attached to the event that the decider can use in subsequent workflow tasks. This
    /// data isn't sent to the Lambda task.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>The input provided to the Lambda task.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The maximum amount of time a worker can take to process the Lambda task.</p>
    pub start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
    /// that resulted in scheduling this activity task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl LambdaFunctionScheduledEventAttributes {
    /// <p>The unique ID of the Lambda task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Data attached to the event that the decider can use in subsequent workflow tasks. This
    /// data isn't sent to the Lambda task.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>The input provided to the Lambda task.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The maximum amount of time a worker can take to process the Lambda task.</p>
    pub fn start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.start_to_close_timeout.as_deref()
    }
    /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
    /// that resulted in scheduling this activity task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for LambdaFunctionScheduledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionScheduledEventAttributes");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("control", &self.control);
        formatter.field("input", &self.input);
        formatter.field("start_to_close_timeout", &self.start_to_close_timeout);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`LambdaFunctionScheduledEventAttributes`](crate::model::LambdaFunctionScheduledEventAttributes)
pub mod lambda_function_scheduled_event_attributes {
    /// A builder for [`LambdaFunctionScheduledEventAttributes`](crate::model::LambdaFunctionScheduledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique ID of the Lambda task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Lambda task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Data attached to the event that the decider can use in subsequent workflow tasks. This
        /// data isn't sent to the Lambda task.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>Data attached to the event that the decider can use in subsequent workflow tasks. This
        /// data isn't sent to the Lambda task.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>The input provided to the Lambda task.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input provided to the Lambda task.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The maximum amount of time a worker can take to process the Lambda task.</p>
        pub fn start_to_close_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum amount of time a worker can take to process the Lambda task.</p>
        pub fn set_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_to_close_timeout = input;
            self
        }
        /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
        /// that resulted in scheduling this activity task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision
        /// that resulted in scheduling this activity task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionScheduledEventAttributes`](crate::model::LambdaFunctionScheduledEventAttributes)
        pub fn build(self) -> crate::model::LambdaFunctionScheduledEventAttributes {
            crate::model::LambdaFunctionScheduledEventAttributes {
                id: self.id,
                name: self.name,
                control: self.control,
                input: self.input,
                start_to_close_timeout: self.start_to_close_timeout,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl LambdaFunctionScheduledEventAttributes {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionScheduledEventAttributes`](crate::model::LambdaFunctionScheduledEventAttributes)
    pub fn builder() -> crate::model::lambda_function_scheduled_event_attributes::Builder {
        crate::model::lambda_function_scheduled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>StartChildWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartChildWorkflowExecutionFailedEventAttributes {
    /// <p>The workflow type provided in the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> that failed.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks sufficient permissions.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">
    /// Using IAM to Manage Access to Amazon SWF Workflows</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::StartChildWorkflowExecutionFailedCause>,
    /// <p>The <code>workflowId</code> of the child workflow execution.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is the ID of the <code>StartChildWorkflowExecutionInitiated</code>
    /// event that corresponds to the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start the workflow execution. You can use this information to diagnose
    /// problems by tracing back the chain of events leading up to this event.</p>
    /// <p>When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is set to <code>0</code> because the
    /// <code>StartChildWorkflowExecutionInitiated</code> event doesn't exist.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the child workflow execution.</p>
    pub control: std::option::Option<std::string::String>,
}
impl StartChildWorkflowExecutionFailedEventAttributes {
    /// <p>The workflow type provided in the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> that failed.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks sufficient permissions.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">
    /// Using IAM to Manage Access to Amazon SWF Workflows</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(
        &self,
    ) -> std::option::Option<&crate::model::StartChildWorkflowExecutionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The <code>workflowId</code> of the child workflow execution.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is the ID of the <code>StartChildWorkflowExecutionInitiated</code>
    /// event that corresponds to the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start the workflow execution. You can use this information to diagnose
    /// problems by tracing back the chain of events leading up to this event.</p>
    /// <p>When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is set to <code>0</code> because the
    /// <code>StartChildWorkflowExecutionInitiated</code> event doesn't exist.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the child workflow execution.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
}
impl std::fmt::Debug for StartChildWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartChildWorkflowExecutionFailedEventAttributes");
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("cause", &self.cause);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`StartChildWorkflowExecutionFailedEventAttributes`](crate::model::StartChildWorkflowExecutionFailedEventAttributes)
pub mod start_child_workflow_execution_failed_event_attributes {
    /// A builder for [`StartChildWorkflowExecutionFailedEventAttributes`](crate::model::StartChildWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) cause: std::option::Option<crate::model::StartChildWorkflowExecutionFailedCause>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) control: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The workflow type provided in the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> that failed.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The workflow type provided in the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> that failed.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks sufficient permissions.
        /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">
        /// Using IAM to Manage Access to Amazon SWF Workflows</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(
            mut self,
            input: crate::model::StartChildWorkflowExecutionFailedCause,
        ) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks sufficient permissions.
        /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">
        /// Using IAM to Manage Access to Amazon SWF Workflows</a>  in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::StartChildWorkflowExecutionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The <code>workflowId</code> of the child workflow execution.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The <code>workflowId</code> of the child workflow execution.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is the ID of the <code>StartChildWorkflowExecutionInitiated</code>
        /// event that corresponds to the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start the workflow execution. You can use this information to diagnose
        /// problems by tracing back the chain of events leading up to this event.</p>
        /// <p>When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is set to <code>0</code> because the
        /// <code>StartChildWorkflowExecutionInitiated</code> event doesn't exist.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is the ID of the <code>StartChildWorkflowExecutionInitiated</code>
        /// event that corresponds to the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start the workflow execution. You can use this information to diagnose
        /// problems by tracing back the chain of events leading up to this event.</p>
        /// <p>When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is set to <code>0</code> because the
        /// <code>StartChildWorkflowExecutionInitiated</code> event doesn't exist.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the child workflow execution.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the child workflow execution.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChildWorkflowExecutionFailedEventAttributes`](crate::model::StartChildWorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::StartChildWorkflowExecutionFailedEventAttributes {
            crate::model::StartChildWorkflowExecutionFailedEventAttributes {
                workflow_type: self.workflow_type,
                cause: self.cause,
                workflow_id: self.workflow_id,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                control: self.control,
            }
        }
    }
}
impl StartChildWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`StartChildWorkflowExecutionFailedEventAttributes`](crate::model::StartChildWorkflowExecutionFailedEventAttributes)
    pub fn builder() -> crate::model::start_child_workflow_execution_failed_event_attributes::Builder
    {
        crate::model::start_child_workflow_execution_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StartChildWorkflowExecutionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    ChildCreationRateExceeded,
    #[allow(missing_docs)] // documentation missing in model
    DefaultChildPolicyUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultExecutionStartToCloseTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultTaskListUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultTaskStartToCloseTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    OpenChildrenLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    OpenWorkflowsLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowAlreadyRunning,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowTypeDeprecated,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowTypeDoesNotExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StartChildWorkflowExecutionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "CHILD_CREATION_RATE_EXCEEDED" => {
                StartChildWorkflowExecutionFailedCause::ChildCreationRateExceeded
            }
            "DEFAULT_CHILD_POLICY_UNDEFINED" => {
                StartChildWorkflowExecutionFailedCause::DefaultChildPolicyUndefined
            }
            "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED" => {
                StartChildWorkflowExecutionFailedCause::DefaultExecutionStartToCloseTimeoutUndefined
            }
            "DEFAULT_TASK_LIST_UNDEFINED" => {
                StartChildWorkflowExecutionFailedCause::DefaultTaskListUndefined
            }
            "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED" => {
                StartChildWorkflowExecutionFailedCause::DefaultTaskStartToCloseTimeoutUndefined
            }
            "OPEN_CHILDREN_LIMIT_EXCEEDED" => {
                StartChildWorkflowExecutionFailedCause::OpenChildrenLimitExceeded
            }
            "OPEN_WORKFLOWS_LIMIT_EXCEEDED" => {
                StartChildWorkflowExecutionFailedCause::OpenWorkflowsLimitExceeded
            }
            "OPERATION_NOT_PERMITTED" => {
                StartChildWorkflowExecutionFailedCause::OperationNotPermitted
            }
            "WORKFLOW_ALREADY_RUNNING" => {
                StartChildWorkflowExecutionFailedCause::WorkflowAlreadyRunning
            }
            "WORKFLOW_TYPE_DEPRECATED" => {
                StartChildWorkflowExecutionFailedCause::WorkflowTypeDeprecated
            }
            "WORKFLOW_TYPE_DOES_NOT_EXIST" => {
                StartChildWorkflowExecutionFailedCause::WorkflowTypeDoesNotExist
            }
            other => StartChildWorkflowExecutionFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StartChildWorkflowExecutionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StartChildWorkflowExecutionFailedCause::from(s))
    }
}
impl StartChildWorkflowExecutionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StartChildWorkflowExecutionFailedCause::ChildCreationRateExceeded => "CHILD_CREATION_RATE_EXCEEDED",
            StartChildWorkflowExecutionFailedCause::DefaultChildPolicyUndefined => "DEFAULT_CHILD_POLICY_UNDEFINED",
            StartChildWorkflowExecutionFailedCause::DefaultExecutionStartToCloseTimeoutUndefined => "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            StartChildWorkflowExecutionFailedCause::DefaultTaskListUndefined => "DEFAULT_TASK_LIST_UNDEFINED",
            StartChildWorkflowExecutionFailedCause::DefaultTaskStartToCloseTimeoutUndefined => "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            StartChildWorkflowExecutionFailedCause::OpenChildrenLimitExceeded => "OPEN_CHILDREN_LIMIT_EXCEEDED",
            StartChildWorkflowExecutionFailedCause::OpenWorkflowsLimitExceeded => "OPEN_WORKFLOWS_LIMIT_EXCEEDED",
            StartChildWorkflowExecutionFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            StartChildWorkflowExecutionFailedCause::WorkflowAlreadyRunning => "WORKFLOW_ALREADY_RUNNING",
            StartChildWorkflowExecutionFailedCause::WorkflowTypeDeprecated => "WORKFLOW_TYPE_DEPRECATED",
            StartChildWorkflowExecutionFailedCause::WorkflowTypeDoesNotExist => "WORKFLOW_TYPE_DOES_NOT_EXIST",
            StartChildWorkflowExecutionFailedCause::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CHILD_CREATION_RATE_EXCEEDED",
            "DEFAULT_CHILD_POLICY_UNDEFINED",
            "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            "DEFAULT_TASK_LIST_UNDEFINED",
            "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            "OPEN_CHILDREN_LIMIT_EXCEEDED",
            "OPEN_WORKFLOWS_LIMIT_EXCEEDED",
            "OPERATION_NOT_PERMITTED",
            "WORKFLOW_ALREADY_RUNNING",
            "WORKFLOW_TYPE_DEPRECATED",
            "WORKFLOW_TYPE_DOES_NOT_EXIST",
        ]
    }
}
impl AsRef<str> for StartChildWorkflowExecutionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>CancelTimerFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelTimerFailedEventAttributes {
    /// <p>The timerId provided in the <code>CancelTimer</code> decision that failed.</p>
    pub timer_id: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::CancelTimerFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl CancelTimerFailedEventAttributes {
    /// <p>The timerId provided in the <code>CancelTimer</code> decision that failed.</p>
    pub fn timer_id(&self) -> std::option::Option<&str> {
        self.timer_id.as_deref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::CancelTimerFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for CancelTimerFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelTimerFailedEventAttributes");
        formatter.field("timer_id", &self.timer_id);
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`CancelTimerFailedEventAttributes`](crate::model::CancelTimerFailedEventAttributes)
pub mod cancel_timer_failed_event_attributes {
    /// A builder for [`CancelTimerFailedEventAttributes`](crate::model::CancelTimerFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_id: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<crate::model::CancelTimerFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The timerId provided in the <code>CancelTimer</code> decision that failed.</p>
        pub fn timer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_id = Some(input.into());
            self
        }
        /// <p>The timerId provided in the <code>CancelTimer</code> decision that failed.</p>
        pub fn set_timer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_id = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::CancelTimerFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::CancelTimerFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelTimerFailedEventAttributes`](crate::model::CancelTimerFailedEventAttributes)
        pub fn build(self) -> crate::model::CancelTimerFailedEventAttributes {
            crate::model::CancelTimerFailedEventAttributes {
                timer_id: self.timer_id,
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl CancelTimerFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`CancelTimerFailedEventAttributes`](crate::model::CancelTimerFailedEventAttributes)
    pub fn builder() -> crate::model::cancel_timer_failed_event_attributes::Builder {
        crate::model::cancel_timer_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CancelTimerFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    TimerIdUnknown,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CancelTimerFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPERATION_NOT_PERMITTED" => CancelTimerFailedCause::OperationNotPermitted,
            "TIMER_ID_UNKNOWN" => CancelTimerFailedCause::TimerIdUnknown,
            other => CancelTimerFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CancelTimerFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CancelTimerFailedCause::from(s))
    }
}
impl CancelTimerFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CancelTimerFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            CancelTimerFailedCause::TimerIdUnknown => "TIMER_ID_UNKNOWN",
            CancelTimerFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPERATION_NOT_PERMITTED", "TIMER_ID_UNKNOWN"]
    }
}
impl AsRef<str> for CancelTimerFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>StartTimerFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTimerFailedEventAttributes {
    /// <p>The timerId provided in the <code>StartTimer</code> decision that failed.</p>
    pub timer_id: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::StartTimerFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl StartTimerFailedEventAttributes {
    /// <p>The timerId provided in the <code>StartTimer</code> decision that failed.</p>
    pub fn timer_id(&self) -> std::option::Option<&str> {
        self.timer_id.as_deref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::StartTimerFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for StartTimerFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTimerFailedEventAttributes");
        formatter.field("timer_id", &self.timer_id);
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`StartTimerFailedEventAttributes`](crate::model::StartTimerFailedEventAttributes)
pub mod start_timer_failed_event_attributes {
    /// A builder for [`StartTimerFailedEventAttributes`](crate::model::StartTimerFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_id: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<crate::model::StartTimerFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The timerId provided in the <code>StartTimer</code> decision that failed.</p>
        pub fn timer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_id = Some(input.into());
            self
        }
        /// <p>The timerId provided in the <code>StartTimer</code> decision that failed.</p>
        pub fn set_timer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_id = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::StartTimerFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::StartTimerFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTimerFailedEventAttributes`](crate::model::StartTimerFailedEventAttributes)
        pub fn build(self) -> crate::model::StartTimerFailedEventAttributes {
            crate::model::StartTimerFailedEventAttributes {
                timer_id: self.timer_id,
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl StartTimerFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`StartTimerFailedEventAttributes`](crate::model::StartTimerFailedEventAttributes)
    pub fn builder() -> crate::model::start_timer_failed_event_attributes::Builder {
        crate::model::start_timer_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StartTimerFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OpenTimersLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    TimerCreationRateExceeded,
    #[allow(missing_docs)] // documentation missing in model
    TimerIdAlreadyInUse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StartTimerFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPEN_TIMERS_LIMIT_EXCEEDED" => StartTimerFailedCause::OpenTimersLimitExceeded,
            "OPERATION_NOT_PERMITTED" => StartTimerFailedCause::OperationNotPermitted,
            "TIMER_CREATION_RATE_EXCEEDED" => StartTimerFailedCause::TimerCreationRateExceeded,
            "TIMER_ID_ALREADY_IN_USE" => StartTimerFailedCause::TimerIdAlreadyInUse,
            other => StartTimerFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StartTimerFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StartTimerFailedCause::from(s))
    }
}
impl StartTimerFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StartTimerFailedCause::OpenTimersLimitExceeded => "OPEN_TIMERS_LIMIT_EXCEEDED",
            StartTimerFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            StartTimerFailedCause::TimerCreationRateExceeded => "TIMER_CREATION_RATE_EXCEEDED",
            StartTimerFailedCause::TimerIdAlreadyInUse => "TIMER_ID_ALREADY_IN_USE",
            StartTimerFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "OPEN_TIMERS_LIMIT_EXCEEDED",
            "OPERATION_NOT_PERMITTED",
            "TIMER_CREATION_RATE_EXCEEDED",
            "TIMER_ID_ALREADY_IN_USE",
        ]
    }
}
impl AsRef<str> for StartTimerFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>RequestCancelActivityTaskFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestCancelActivityTaskFailedEventAttributes {
    /// <p>The activityId provided in the <code>RequestCancelActivityTask</code> decision that failed.</p>
    pub activity_id: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::RequestCancelActivityTaskFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl RequestCancelActivityTaskFailedEventAttributes {
    /// <p>The activityId provided in the <code>RequestCancelActivityTask</code> decision that failed.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(
        &self,
    ) -> std::option::Option<&crate::model::RequestCancelActivityTaskFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for RequestCancelActivityTaskFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestCancelActivityTaskFailedEventAttributes");
        formatter.field("activity_id", &self.activity_id);
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`RequestCancelActivityTaskFailedEventAttributes`](crate::model::RequestCancelActivityTaskFailedEventAttributes)
pub mod request_cancel_activity_task_failed_event_attributes {
    /// A builder for [`RequestCancelActivityTaskFailedEventAttributes`](crate::model::RequestCancelActivityTaskFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_id: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<crate::model::RequestCancelActivityTaskFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The activityId provided in the <code>RequestCancelActivityTask</code> decision that failed.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>The activityId provided in the <code>RequestCancelActivityTask</code> decision that failed.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::RequestCancelActivityTaskFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::RequestCancelActivityTaskFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestCancelActivityTaskFailedEventAttributes`](crate::model::RequestCancelActivityTaskFailedEventAttributes)
        pub fn build(self) -> crate::model::RequestCancelActivityTaskFailedEventAttributes {
            crate::model::RequestCancelActivityTaskFailedEventAttributes {
                activity_id: self.activity_id,
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl RequestCancelActivityTaskFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`RequestCancelActivityTaskFailedEventAttributes`](crate::model::RequestCancelActivityTaskFailedEventAttributes)
    pub fn builder() -> crate::model::request_cancel_activity_task_failed_event_attributes::Builder
    {
        crate::model::request_cancel_activity_task_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestCancelActivityTaskFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    ActivityIdUnknown,
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestCancelActivityTaskFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVITY_ID_UNKNOWN" => RequestCancelActivityTaskFailedCause::ActivityIdUnknown,
            "OPERATION_NOT_PERMITTED" => {
                RequestCancelActivityTaskFailedCause::OperationNotPermitted
            }
            other => RequestCancelActivityTaskFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequestCancelActivityTaskFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestCancelActivityTaskFailedCause::from(s))
    }
}
impl RequestCancelActivityTaskFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestCancelActivityTaskFailedCause::ActivityIdUnknown => "ACTIVITY_ID_UNKNOWN",
            RequestCancelActivityTaskFailedCause::OperationNotPermitted => {
                "OPERATION_NOT_PERMITTED"
            }
            RequestCancelActivityTaskFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVITY_ID_UNKNOWN", "OPERATION_NOT_PERMITTED"]
    }
}
impl AsRef<str> for RequestCancelActivityTaskFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>ScheduleActivityTaskFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleActivityTaskFailedEventAttributes {
    /// <p>The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
    pub activity_type: std::option::Option<crate::model::ActivityType>,
    /// <p>The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
    pub activity_id: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::ScheduleActivityTaskFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
    /// scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl ScheduleActivityTaskFailedEventAttributes {
    /// <p>The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
    pub fn activity_type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.activity_type.as_ref()
    }
    /// <p>The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::ScheduleActivityTaskFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
    /// scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for ScheduleActivityTaskFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleActivityTaskFailedEventAttributes");
        formatter.field("activity_type", &self.activity_type);
        formatter.field("activity_id", &self.activity_id);
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`ScheduleActivityTaskFailedEventAttributes`](crate::model::ScheduleActivityTaskFailedEventAttributes)
pub mod schedule_activity_task_failed_event_attributes {
    /// A builder for [`ScheduleActivityTaskFailedEventAttributes`](crate::model::ScheduleActivityTaskFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_type: std::option::Option<crate::model::ActivityType>,
        pub(crate) activity_id: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<crate::model::ScheduleActivityTaskFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.activity_type = Some(input);
            self
        }
        /// <p>The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.activity_type = input;
            self
        }
        /// <p>The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::ScheduleActivityTaskFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::ScheduleActivityTaskFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
        /// scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
        /// scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleActivityTaskFailedEventAttributes`](crate::model::ScheduleActivityTaskFailedEventAttributes)
        pub fn build(self) -> crate::model::ScheduleActivityTaskFailedEventAttributes {
            crate::model::ScheduleActivityTaskFailedEventAttributes {
                activity_type: self.activity_type,
                activity_id: self.activity_id,
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl ScheduleActivityTaskFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ScheduleActivityTaskFailedEventAttributes`](crate::model::ScheduleActivityTaskFailedEventAttributes)
    pub fn builder() -> crate::model::schedule_activity_task_failed_event_attributes::Builder {
        crate::model::schedule_activity_task_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduleActivityTaskFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    ActivityCreationRateExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ActivityIdAlreadyInUse,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTypeDeprecated,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTypeDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    DefaultHeartbeatTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultScheduleToCloseTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultScheduleToStartTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultStartToCloseTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultTaskListUndefined,
    #[allow(missing_docs)] // documentation missing in model
    OpenActivitiesLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduleActivityTaskFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVITY_CREATION_RATE_EXCEEDED" => {
                ScheduleActivityTaskFailedCause::ActivityCreationRateExceeded
            }
            "ACTIVITY_ID_ALREADY_IN_USE" => ScheduleActivityTaskFailedCause::ActivityIdAlreadyInUse,
            "ACTIVITY_TYPE_DEPRECATED" => ScheduleActivityTaskFailedCause::ActivityTypeDeprecated,
            "ACTIVITY_TYPE_DOES_NOT_EXIST" => {
                ScheduleActivityTaskFailedCause::ActivityTypeDoesNotExist
            }
            "DEFAULT_HEARTBEAT_TIMEOUT_UNDEFINED" => {
                ScheduleActivityTaskFailedCause::DefaultHeartbeatTimeoutUndefined
            }
            "DEFAULT_SCHEDULE_TO_CLOSE_TIMEOUT_UNDEFINED" => {
                ScheduleActivityTaskFailedCause::DefaultScheduleToCloseTimeoutUndefined
            }
            "DEFAULT_SCHEDULE_TO_START_TIMEOUT_UNDEFINED" => {
                ScheduleActivityTaskFailedCause::DefaultScheduleToStartTimeoutUndefined
            }
            "DEFAULT_START_TO_CLOSE_TIMEOUT_UNDEFINED" => {
                ScheduleActivityTaskFailedCause::DefaultStartToCloseTimeoutUndefined
            }
            "DEFAULT_TASK_LIST_UNDEFINED" => {
                ScheduleActivityTaskFailedCause::DefaultTaskListUndefined
            }
            "OPEN_ACTIVITIES_LIMIT_EXCEEDED" => {
                ScheduleActivityTaskFailedCause::OpenActivitiesLimitExceeded
            }
            "OPERATION_NOT_PERMITTED" => ScheduleActivityTaskFailedCause::OperationNotPermitted,
            other => ScheduleActivityTaskFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduleActivityTaskFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduleActivityTaskFailedCause::from(s))
    }
}
impl ScheduleActivityTaskFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduleActivityTaskFailedCause::ActivityCreationRateExceeded => {
                "ACTIVITY_CREATION_RATE_EXCEEDED"
            }
            ScheduleActivityTaskFailedCause::ActivityIdAlreadyInUse => "ACTIVITY_ID_ALREADY_IN_USE",
            ScheduleActivityTaskFailedCause::ActivityTypeDeprecated => "ACTIVITY_TYPE_DEPRECATED",
            ScheduleActivityTaskFailedCause::ActivityTypeDoesNotExist => {
                "ACTIVITY_TYPE_DOES_NOT_EXIST"
            }
            ScheduleActivityTaskFailedCause::DefaultHeartbeatTimeoutUndefined => {
                "DEFAULT_HEARTBEAT_TIMEOUT_UNDEFINED"
            }
            ScheduleActivityTaskFailedCause::DefaultScheduleToCloseTimeoutUndefined => {
                "DEFAULT_SCHEDULE_TO_CLOSE_TIMEOUT_UNDEFINED"
            }
            ScheduleActivityTaskFailedCause::DefaultScheduleToStartTimeoutUndefined => {
                "DEFAULT_SCHEDULE_TO_START_TIMEOUT_UNDEFINED"
            }
            ScheduleActivityTaskFailedCause::DefaultStartToCloseTimeoutUndefined => {
                "DEFAULT_START_TO_CLOSE_TIMEOUT_UNDEFINED"
            }
            ScheduleActivityTaskFailedCause::DefaultTaskListUndefined => {
                "DEFAULT_TASK_LIST_UNDEFINED"
            }
            ScheduleActivityTaskFailedCause::OpenActivitiesLimitExceeded => {
                "OPEN_ACTIVITIES_LIMIT_EXCEEDED"
            }
            ScheduleActivityTaskFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            ScheduleActivityTaskFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVITY_CREATION_RATE_EXCEEDED",
            "ACTIVITY_ID_ALREADY_IN_USE",
            "ACTIVITY_TYPE_DEPRECATED",
            "ACTIVITY_TYPE_DOES_NOT_EXIST",
            "DEFAULT_HEARTBEAT_TIMEOUT_UNDEFINED",
            "DEFAULT_SCHEDULE_TO_CLOSE_TIMEOUT_UNDEFINED",
            "DEFAULT_SCHEDULE_TO_START_TIMEOUT_UNDEFINED",
            "DEFAULT_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            "DEFAULT_TASK_LIST_UNDEFINED",
            "OPEN_ACTIVITIES_LIMIT_EXCEEDED",
            "OPERATION_NOT_PERMITTED",
        ]
    }
}
impl AsRef<str> for ScheduleActivityTaskFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>RequestCancelExternalWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestCancelExternalWorkflowExecutionFailedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow to which the cancel request was to be delivered.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The <code>runId</code> of the external workflow execution.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::RequestCancelExternalWorkflowExecutionFailedCause>,
    /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the workflow execution.</p>
    pub control: std::option::Option<std::string::String>,
}
impl RequestCancelExternalWorkflowExecutionFailedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow to which the cancel request was to be delivered.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The <code>runId</code> of the external workflow execution.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(
        &self,
    ) -> std::option::Option<&crate::model::RequestCancelExternalWorkflowExecutionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the workflow execution.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
}
impl std::fmt::Debug for RequestCancelExternalWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("RequestCancelExternalWorkflowExecutionFailedEventAttributes");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("cause", &self.cause);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`RequestCancelExternalWorkflowExecutionFailedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes)
pub mod request_cancel_external_workflow_execution_failed_event_attributes {
    /// A builder for [`RequestCancelExternalWorkflowExecutionFailedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) cause:
            std::option::Option<crate::model::RequestCancelExternalWorkflowExecutionFailedCause>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) control: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>workflowId</code> of the external workflow to which the cancel request was to be delivered.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The <code>workflowId</code> of the external workflow to which the cancel request was to be delivered.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(
            mut self,
            input: crate::model::RequestCancelExternalWorkflowExecutionFailedCause,
        ) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<
                crate::model::RequestCancelExternalWorkflowExecutionFailedCause,
            >,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the workflow execution.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the workflow execution.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestCancelExternalWorkflowExecutionFailedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes)
        pub fn build(
            self,
        ) -> crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes {
            crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes {
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                cause: self.cause,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                control: self.control,
            }
        }
    }
}
impl RequestCancelExternalWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`RequestCancelExternalWorkflowExecutionFailedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionFailedEventAttributes)
    pub fn builder(
    ) -> crate::model::request_cancel_external_workflow_execution_failed_event_attributes::Builder
    {
        crate::model::request_cancel_external_workflow_execution_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestCancelExternalWorkflowExecutionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    RequestCancelExternalWorkflowExecutionRateExceeded,
    #[allow(missing_docs)] // documentation missing in model
    UnknownExternalWorkflowExecution,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestCancelExternalWorkflowExecutionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPERATION_NOT_PERMITTED" => RequestCancelExternalWorkflowExecutionFailedCause::OperationNotPermitted,
            "REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED" => RequestCancelExternalWorkflowExecutionFailedCause::RequestCancelExternalWorkflowExecutionRateExceeded,
            "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION" => RequestCancelExternalWorkflowExecutionFailedCause::UnknownExternalWorkflowExecution,
            other => RequestCancelExternalWorkflowExecutionFailedCause::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for RequestCancelExternalWorkflowExecutionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestCancelExternalWorkflowExecutionFailedCause::from(s))
    }
}
impl RequestCancelExternalWorkflowExecutionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestCancelExternalWorkflowExecutionFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            RequestCancelExternalWorkflowExecutionFailedCause::RequestCancelExternalWorkflowExecutionRateExceeded => "REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED",
            RequestCancelExternalWorkflowExecutionFailedCause::UnknownExternalWorkflowExecution => "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION",
            RequestCancelExternalWorkflowExecutionFailedCause::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "OPERATION_NOT_PERMITTED",
            "REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED",
            "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION",
        ]
    }
}
impl AsRef<str> for RequestCancelExternalWorkflowExecutionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow execution to be canceled.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The <code>runId</code> of the external workflow execution to be canceled.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub control: std::option::Option<std::string::String>,
}
impl RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow execution to be canceled.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The <code>runId</code> of the external workflow execution to be canceled.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
}
impl std::fmt::Debug for RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("RequestCancelExternalWorkflowExecutionInitiatedEventAttributes");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`RequestCancelExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)
pub mod request_cancel_external_workflow_execution_initiated_event_attributes {
    /// A builder for [`RequestCancelExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) control: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>workflowId</code> of the external workflow execution to be canceled.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The <code>workflowId</code> of the external workflow execution to be canceled.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution to be canceled.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution to be canceled.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestCancelExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)
        pub fn build(
            self,
        ) -> crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
            crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                control: self.control,
            }
        }
    }
}
impl RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
    /// Creates a new builder-style object to manufacture [`RequestCancelExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)
    pub fn builder(
    ) -> crate::model::request_cancel_external_workflow_execution_initiated_event_attributes::Builder
    {
        crate::model::request_cancel_external_workflow_execution_initiated_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ExternalWorkflowExecutionCancelRequested</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExternalWorkflowExecutionCancelRequestedEventAttributes {
    /// <p>The external workflow execution to which the cancellation request was delivered.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub initiated_event_id: i64,
}
impl ExternalWorkflowExecutionCancelRequestedEventAttributes {
    /// <p>The external workflow execution to which the cancellation request was delivered.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
}
impl std::fmt::Debug for ExternalWorkflowExecutionCancelRequestedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("ExternalWorkflowExecutionCancelRequestedEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.finish()
    }
}
/// See [`ExternalWorkflowExecutionCancelRequestedEventAttributes`](crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes)
pub mod external_workflow_execution_cancel_requested_event_attributes {
    /// A builder for [`ExternalWorkflowExecutionCancelRequestedEventAttributes`](crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The external workflow execution to which the cancellation request was delivered.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The external workflow execution to which the cancellation request was delivered.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExternalWorkflowExecutionCancelRequestedEventAttributes`](crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes)
        pub fn build(
            self,
        ) -> crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes {
            crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes {
                workflow_execution: self.workflow_execution,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ExternalWorkflowExecutionCancelRequestedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ExternalWorkflowExecutionCancelRequestedEventAttributes`](crate::model::ExternalWorkflowExecutionCancelRequestedEventAttributes)
    pub fn builder(
    ) -> crate::model::external_workflow_execution_cancel_requested_event_attributes::Builder {
        crate::model::external_workflow_execution_cancel_requested_event_attributes::Builder::default()
    }
}

/// <p>Represents a workflow execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecution {
    /// <p>The user defined identifier associated with the workflow execution.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>A system-generated unique identifier for the workflow execution.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl WorkflowExecution {
    /// <p>The user defined identifier associated with the workflow execution.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>A system-generated unique identifier for the workflow execution.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
}
impl std::fmt::Debug for WorkflowExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecution");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}
/// See [`WorkflowExecution`](crate::model::WorkflowExecution)
pub mod workflow_execution {
    /// A builder for [`WorkflowExecution`](crate::model::WorkflowExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user defined identifier associated with the workflow execution.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The user defined identifier associated with the workflow execution.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>A system-generated unique identifier for the workflow execution.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>A system-generated unique identifier for the workflow execution.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecution`](crate::model::WorkflowExecution)
        pub fn build(self) -> crate::model::WorkflowExecution {
            crate::model::WorkflowExecution {
                workflow_id: self.workflow_id,
                run_id: self.run_id,
            }
        }
    }
}
impl WorkflowExecution {
    /// Creates a new builder-style object to manufacture [`WorkflowExecution`](crate::model::WorkflowExecution)
    pub fn builder() -> crate::model::workflow_execution::Builder {
        crate::model::workflow_execution::Builder::default()
    }
}

/// <p>Provides the details of the <code>SignalExternalWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignalExternalWorkflowExecutionFailedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The <code>runId</code> of the external workflow execution that the signal was being delivered to.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::SignalExternalWorkflowExecutionFailedCause>,
    /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the workflow execution.</p>
    pub control: std::option::Option<std::string::String>,
}
impl SignalExternalWorkflowExecutionFailedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The <code>runId</code> of the external workflow execution that the signal was being delivered to.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(
        &self,
    ) -> std::option::Option<&crate::model::SignalExternalWorkflowExecutionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
    /// This data isn't sent to the workflow execution.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
}
impl std::fmt::Debug for SignalExternalWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignalExternalWorkflowExecutionFailedEventAttributes");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("cause", &self.cause);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`SignalExternalWorkflowExecutionFailedEventAttributes`](crate::model::SignalExternalWorkflowExecutionFailedEventAttributes)
pub mod signal_external_workflow_execution_failed_event_attributes {
    /// A builder for [`SignalExternalWorkflowExecutionFailedEventAttributes`](crate::model::SignalExternalWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) cause:
            std::option::Option<crate::model::SignalExternalWorkflowExecutionFailedCause>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) control: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution that the signal was being delivered to.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution that the signal was being delivered to.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(
            mut self,
            input: crate::model::SignalExternalWorkflowExecutionFailedCause,
        ) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::SignalExternalWorkflowExecutionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the workflow execution.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>The data attached to the event that the decider can use in subsequent workflow tasks.
        /// This data isn't sent to the workflow execution.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`SignalExternalWorkflowExecutionFailedEventAttributes`](crate::model::SignalExternalWorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::SignalExternalWorkflowExecutionFailedEventAttributes {
            crate::model::SignalExternalWorkflowExecutionFailedEventAttributes {
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                cause: self.cause,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                control: self.control,
            }
        }
    }
}
impl SignalExternalWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`SignalExternalWorkflowExecutionFailedEventAttributes`](crate::model::SignalExternalWorkflowExecutionFailedEventAttributes)
    pub fn builder(
    ) -> crate::model::signal_external_workflow_execution_failed_event_attributes::Builder {
        crate::model::signal_external_workflow_execution_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SignalExternalWorkflowExecutionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    SignalExternalWorkflowExecutionRateExceeded,
    #[allow(missing_docs)] // documentation missing in model
    UnknownExternalWorkflowExecution,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SignalExternalWorkflowExecutionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPERATION_NOT_PERMITTED" => SignalExternalWorkflowExecutionFailedCause::OperationNotPermitted,
            "SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED" => SignalExternalWorkflowExecutionFailedCause::SignalExternalWorkflowExecutionRateExceeded,
            "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION" => SignalExternalWorkflowExecutionFailedCause::UnknownExternalWorkflowExecution,
            other => SignalExternalWorkflowExecutionFailedCause::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for SignalExternalWorkflowExecutionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SignalExternalWorkflowExecutionFailedCause::from(s))
    }
}
impl SignalExternalWorkflowExecutionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SignalExternalWorkflowExecutionFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            SignalExternalWorkflowExecutionFailedCause::SignalExternalWorkflowExecutionRateExceeded => "SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED",
            SignalExternalWorkflowExecutionFailedCause::UnknownExternalWorkflowExecution => "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION",
            SignalExternalWorkflowExecutionFailedCause::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "OPERATION_NOT_PERMITTED",
            "SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED",
            "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION",
        ]
    }
}
impl AsRef<str> for SignalExternalWorkflowExecutionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>ExternalWorkflowExecutionSignaled</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExternalWorkflowExecutionSignaledEventAttributes {
    /// <p>The external workflow execution that the signal was delivered to.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub initiated_event_id: i64,
}
impl ExternalWorkflowExecutionSignaledEventAttributes {
    /// <p>The external workflow execution that the signal was delivered to.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
}
impl std::fmt::Debug for ExternalWorkflowExecutionSignaledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExternalWorkflowExecutionSignaledEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.finish()
    }
}
/// See [`ExternalWorkflowExecutionSignaledEventAttributes`](crate::model::ExternalWorkflowExecutionSignaledEventAttributes)
pub mod external_workflow_execution_signaled_event_attributes {
    /// A builder for [`ExternalWorkflowExecutionSignaledEventAttributes`](crate::model::ExternalWorkflowExecutionSignaledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The external workflow execution that the signal was delivered to.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The external workflow execution that the signal was delivered to.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExternalWorkflowExecutionSignaledEventAttributes`](crate::model::ExternalWorkflowExecutionSignaledEventAttributes)
        pub fn build(self) -> crate::model::ExternalWorkflowExecutionSignaledEventAttributes {
            crate::model::ExternalWorkflowExecutionSignaledEventAttributes {
                workflow_execution: self.workflow_execution,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ExternalWorkflowExecutionSignaledEventAttributes {
    /// Creates a new builder-style object to manufacture [`ExternalWorkflowExecutionSignaledEventAttributes`](crate::model::ExternalWorkflowExecutionSignaledEventAttributes)
    pub fn builder() -> crate::model::external_workflow_execution_signaled_event_attributes::Builder
    {
        crate::model::external_workflow_execution_signaled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>SignalExternalWorkflowExecutionInitiated</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignalExternalWorkflowExecutionInitiatedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow execution.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The <code>runId</code> of the external workflow execution to send the signal to.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The name of the signal.</p>
    pub signal_name: std::option::Option<std::string::String>,
    /// <p>The input provided to the signal.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks.</p>
    pub control: std::option::Option<std::string::String>,
}
impl SignalExternalWorkflowExecutionInitiatedEventAttributes {
    /// <p>The <code>workflowId</code> of the external workflow execution.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The <code>runId</code> of the external workflow execution to send the signal to.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>The name of the signal.</p>
    pub fn signal_name(&self) -> std::option::Option<&str> {
        self.signal_name.as_deref()
    }
    /// <p>The input provided to the signal.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
}
impl std::fmt::Debug for SignalExternalWorkflowExecutionInitiatedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("SignalExternalWorkflowExecutionInitiatedEventAttributes");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("signal_name", &self.signal_name);
        formatter.field("input", &self.input);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`SignalExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes)
pub mod signal_external_workflow_execution_initiated_event_attributes {
    /// A builder for [`SignalExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) signal_name: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) control: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>workflowId</code> of the external workflow execution.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The <code>workflowId</code> of the external workflow execution.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution to send the signal to.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The <code>runId</code> of the external workflow execution to send the signal to.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The name of the signal.</p>
        pub fn signal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.signal_name = Some(input.into());
            self
        }
        /// <p>The name of the signal.</p>
        pub fn set_signal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signal_name = input;
            self
        }
        /// <p>The input provided to the signal.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input provided to the signal.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`SignalExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes)
        pub fn build(
            self,
        ) -> crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes {
            crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes {
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                signal_name: self.signal_name,
                input: self.input,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                control: self.control,
            }
        }
    }
}
impl SignalExternalWorkflowExecutionInitiatedEventAttributes {
    /// Creates a new builder-style object to manufacture [`SignalExternalWorkflowExecutionInitiatedEventAttributes`](crate::model::SignalExternalWorkflowExecutionInitiatedEventAttributes)
    pub fn builder(
    ) -> crate::model::signal_external_workflow_execution_initiated_event_attributes::Builder {
        crate::model::signal_external_workflow_execution_initiated_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ChildWorkflowExecutionTerminated</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildWorkflowExecutionTerminatedEventAttributes {
    /// <p>The child workflow execution that was terminated.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The type of the child workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
}
impl ChildWorkflowExecutionTerminatedEventAttributes {
    /// <p>The child workflow execution that was terminated.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The type of the child workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for ChildWorkflowExecutionTerminatedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildWorkflowExecutionTerminatedEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`ChildWorkflowExecutionTerminatedEventAttributes`](crate::model::ChildWorkflowExecutionTerminatedEventAttributes)
pub mod child_workflow_execution_terminated_event_attributes {
    /// A builder for [`ChildWorkflowExecutionTerminatedEventAttributes`](crate::model::ChildWorkflowExecutionTerminatedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The child workflow execution that was terminated.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The child workflow execution that was terminated.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildWorkflowExecutionTerminatedEventAttributes`](crate::model::ChildWorkflowExecutionTerminatedEventAttributes)
        pub fn build(self) -> crate::model::ChildWorkflowExecutionTerminatedEventAttributes {
            crate::model::ChildWorkflowExecutionTerminatedEventAttributes {
                workflow_execution: self.workflow_execution,
                workflow_type: self.workflow_type,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ChildWorkflowExecutionTerminatedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ChildWorkflowExecutionTerminatedEventAttributes`](crate::model::ChildWorkflowExecutionTerminatedEventAttributes)
    pub fn builder() -> crate::model::child_workflow_execution_terminated_event_attributes::Builder
    {
        crate::model::child_workflow_execution_terminated_event_attributes::Builder::default()
    }
}

/// <p>Provide details of the <code>ChildWorkflowExecutionCanceled</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildWorkflowExecutionCanceledEventAttributes {
    /// <p>The child workflow execution that was canceled.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The type of the child workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>Details of the cancellation (if provided).</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
}
impl ChildWorkflowExecutionCanceledEventAttributes {
    /// <p>The child workflow execution that was canceled.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The type of the child workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>Details of the cancellation (if provided).</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for ChildWorkflowExecutionCanceledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildWorkflowExecutionCanceledEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("details", &self.details);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`ChildWorkflowExecutionCanceledEventAttributes`](crate::model::ChildWorkflowExecutionCanceledEventAttributes)
pub mod child_workflow_execution_canceled_event_attributes {
    /// A builder for [`ChildWorkflowExecutionCanceledEventAttributes`](crate::model::ChildWorkflowExecutionCanceledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The child workflow execution that was canceled.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The child workflow execution that was canceled.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>Details of the cancellation (if provided).</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>Details of the cancellation (if provided).</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildWorkflowExecutionCanceledEventAttributes`](crate::model::ChildWorkflowExecutionCanceledEventAttributes)
        pub fn build(self) -> crate::model::ChildWorkflowExecutionCanceledEventAttributes {
            crate::model::ChildWorkflowExecutionCanceledEventAttributes {
                workflow_execution: self.workflow_execution,
                workflow_type: self.workflow_type,
                details: self.details,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ChildWorkflowExecutionCanceledEventAttributes {
    /// Creates a new builder-style object to manufacture [`ChildWorkflowExecutionCanceledEventAttributes`](crate::model::ChildWorkflowExecutionCanceledEventAttributes)
    pub fn builder() -> crate::model::child_workflow_execution_canceled_event_attributes::Builder {
        crate::model::child_workflow_execution_canceled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ChildWorkflowExecutionTimedOut</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildWorkflowExecutionTimedOutEventAttributes {
    /// <p>The child workflow execution that timed out.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The type of the child workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The type of the timeout that caused the child workflow execution to time out.</p>
    pub timeout_type: std::option::Option<crate::model::WorkflowExecutionTimeoutType>,
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
}
impl ChildWorkflowExecutionTimedOutEventAttributes {
    /// <p>The child workflow execution that timed out.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The type of the child workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The type of the timeout that caused the child workflow execution to time out.</p>
    pub fn timeout_type(&self) -> std::option::Option<&crate::model::WorkflowExecutionTimeoutType> {
        self.timeout_type.as_ref()
    }
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for ChildWorkflowExecutionTimedOutEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildWorkflowExecutionTimedOutEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("timeout_type", &self.timeout_type);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`ChildWorkflowExecutionTimedOutEventAttributes`](crate::model::ChildWorkflowExecutionTimedOutEventAttributes)
pub mod child_workflow_execution_timed_out_event_attributes {
    /// A builder for [`ChildWorkflowExecutionTimedOutEventAttributes`](crate::model::ChildWorkflowExecutionTimedOutEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) timeout_type: std::option::Option<crate::model::WorkflowExecutionTimeoutType>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The child workflow execution that timed out.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The child workflow execution that timed out.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The type of the timeout that caused the child workflow execution to time out.</p>
        pub fn timeout_type(mut self, input: crate::model::WorkflowExecutionTimeoutType) -> Self {
            self.timeout_type = Some(input);
            self
        }
        /// <p>The type of the timeout that caused the child workflow execution to time out.</p>
        pub fn set_timeout_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionTimeoutType>,
        ) -> Self {
            self.timeout_type = input;
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildWorkflowExecutionTimedOutEventAttributes`](crate::model::ChildWorkflowExecutionTimedOutEventAttributes)
        pub fn build(self) -> crate::model::ChildWorkflowExecutionTimedOutEventAttributes {
            crate::model::ChildWorkflowExecutionTimedOutEventAttributes {
                workflow_execution: self.workflow_execution,
                workflow_type: self.workflow_type,
                timeout_type: self.timeout_type,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ChildWorkflowExecutionTimedOutEventAttributes {
    /// Creates a new builder-style object to manufacture [`ChildWorkflowExecutionTimedOutEventAttributes`](crate::model::ChildWorkflowExecutionTimedOutEventAttributes)
    pub fn builder() -> crate::model::child_workflow_execution_timed_out_event_attributes::Builder {
        crate::model::child_workflow_execution_timed_out_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkflowExecutionTimeoutType {
    #[allow(missing_docs)] // documentation missing in model
    StartToClose,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkflowExecutionTimeoutType {
    fn from(s: &str) -> Self {
        match s {
            "START_TO_CLOSE" => WorkflowExecutionTimeoutType::StartToClose,
            other => WorkflowExecutionTimeoutType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkflowExecutionTimeoutType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkflowExecutionTimeoutType::from(s))
    }
}
impl WorkflowExecutionTimeoutType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkflowExecutionTimeoutType::StartToClose => "START_TO_CLOSE",
            WorkflowExecutionTimeoutType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["START_TO_CLOSE"]
    }
}
impl AsRef<str> for WorkflowExecutionTimeoutType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>ChildWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildWorkflowExecutionFailedEventAttributes {
    /// <p>The child workflow execution that failed.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The type of the child workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The reason for the failure (if provided).</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The details of the failure (if provided).</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
}
impl ChildWorkflowExecutionFailedEventAttributes {
    /// <p>The child workflow execution that failed.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The type of the child workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The reason for the failure (if provided).</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The details of the failure (if provided).</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for ChildWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildWorkflowExecutionFailedEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`ChildWorkflowExecutionFailedEventAttributes`](crate::model::ChildWorkflowExecutionFailedEventAttributes)
pub mod child_workflow_execution_failed_event_attributes {
    /// A builder for [`ChildWorkflowExecutionFailedEventAttributes`](crate::model::ChildWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The child workflow execution that failed.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The child workflow execution that failed.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The reason for the failure (if provided).</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the failure (if provided).</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The details of the failure (if provided).</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details of the failure (if provided).</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildWorkflowExecutionFailedEventAttributes`](crate::model::ChildWorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::ChildWorkflowExecutionFailedEventAttributes {
            crate::model::ChildWorkflowExecutionFailedEventAttributes {
                workflow_execution: self.workflow_execution,
                workflow_type: self.workflow_type,
                reason: self.reason,
                details: self.details,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ChildWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ChildWorkflowExecutionFailedEventAttributes`](crate::model::ChildWorkflowExecutionFailedEventAttributes)
    pub fn builder() -> crate::model::child_workflow_execution_failed_event_attributes::Builder {
        crate::model::child_workflow_execution_failed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ChildWorkflowExecutionCompleted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildWorkflowExecutionCompletedEventAttributes {
    /// <p>The child workflow execution that was completed.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The type of the child workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The result of the child workflow execution.</p>
    pub result: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub initiated_event_id: i64,
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
}
impl ChildWorkflowExecutionCompletedEventAttributes {
    /// <p>The child workflow execution that was completed.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The type of the child workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The result of the child workflow execution.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
    /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
    /// started. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for ChildWorkflowExecutionCompletedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildWorkflowExecutionCompletedEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("result", &self.result);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`ChildWorkflowExecutionCompletedEventAttributes`](crate::model::ChildWorkflowExecutionCompletedEventAttributes)
pub mod child_workflow_execution_completed_event_attributes {
    /// A builder for [`ChildWorkflowExecutionCompletedEventAttributes`](crate::model::ChildWorkflowExecutionCompletedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) result: std::option::Option<std::string::String>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The child workflow execution that was completed.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The child workflow execution that was completed.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The result of the child workflow execution.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>The result of the child workflow execution.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
        /// started. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildWorkflowExecutionCompletedEventAttributes`](crate::model::ChildWorkflowExecutionCompletedEventAttributes)
        pub fn build(self) -> crate::model::ChildWorkflowExecutionCompletedEventAttributes {
            crate::model::ChildWorkflowExecutionCompletedEventAttributes {
                workflow_execution: self.workflow_execution,
                workflow_type: self.workflow_type,
                result: self.result,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ChildWorkflowExecutionCompletedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ChildWorkflowExecutionCompletedEventAttributes`](crate::model::ChildWorkflowExecutionCompletedEventAttributes)
    pub fn builder() -> crate::model::child_workflow_execution_completed_event_attributes::Builder {
        crate::model::child_workflow_execution_completed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ChildWorkflowExecutionStarted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildWorkflowExecutionStartedEventAttributes {
    /// <p>The child workflow execution that was started.</p>
    pub workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The type of the child workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub initiated_event_id: i64,
}
impl ChildWorkflowExecutionStartedEventAttributes {
    /// <p>The child workflow execution that was started.</p>
    pub fn workflow_execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.workflow_execution.as_ref()
    }
    /// <p>The type of the child workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this child workflow execution.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn initiated_event_id(&self) -> i64 {
        self.initiated_event_id
    }
}
impl std::fmt::Debug for ChildWorkflowExecutionStartedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildWorkflowExecutionStartedEventAttributes");
        formatter.field("workflow_execution", &self.workflow_execution);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("initiated_event_id", &self.initiated_event_id);
        formatter.finish()
    }
}
/// See [`ChildWorkflowExecutionStartedEventAttributes`](crate::model::ChildWorkflowExecutionStartedEventAttributes)
pub mod child_workflow_execution_started_event_attributes {
    /// A builder for [`ChildWorkflowExecutionStartedEventAttributes`](crate::model::ChildWorkflowExecutionStartedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) initiated_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The child workflow execution that was started.</p>
        pub fn workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.workflow_execution = Some(input);
            self
        }
        /// <p>The child workflow execution that was started.</p>
        pub fn set_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.workflow_execution = input;
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn initiated_event_id(mut self, input: i64) -> Self {
            self.initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this child workflow execution.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.initiated_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildWorkflowExecutionStartedEventAttributes`](crate::model::ChildWorkflowExecutionStartedEventAttributes)
        pub fn build(self) -> crate::model::ChildWorkflowExecutionStartedEventAttributes {
            crate::model::ChildWorkflowExecutionStartedEventAttributes {
                workflow_execution: self.workflow_execution,
                workflow_type: self.workflow_type,
                initiated_event_id: self.initiated_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ChildWorkflowExecutionStartedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ChildWorkflowExecutionStartedEventAttributes`](crate::model::ChildWorkflowExecutionStartedEventAttributes)
    pub fn builder() -> crate::model::child_workflow_execution_started_event_attributes::Builder {
        crate::model::child_workflow_execution_started_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>StartChildWorkflowExecutionInitiated</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartChildWorkflowExecutionInitiatedEventAttributes {
    /// <p>The <code>workflowId</code> of the child workflow execution.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The type of the child workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent to the activity.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>The inputs provided to the child workflow execution.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The maximum duration for the child workflow execution. If the workflow execution isn't closed within this duration, it is timed out and force-terminated.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The name of the task list used for the decision tasks of the child workflow execution.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// The priority assigned for the decision tasks for this workflow execution.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to request this child workflow execution. This
    /// information can be useful for diagnosing problems by tracing back the cause of events.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the
    /// <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The maximum duration allowed for the decision tasks for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The list of tags to associated with the child workflow execution.</p>
    pub tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IAM role to attach to the child workflow execution.</p>
    pub lambda_role: std::option::Option<std::string::String>,
}
impl StartChildWorkflowExecutionInitiatedEventAttributes {
    /// <p>The <code>workflowId</code> of the child workflow execution.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The type of the child workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent to the activity.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>The inputs provided to the child workflow execution.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The maximum duration for the child workflow execution. If the workflow execution isn't closed within this duration, it is timed out and force-terminated.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.execution_start_to_close_timeout.as_deref()
    }
    /// <p>The name of the task list used for the decision tasks of the child workflow execution.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>
    /// The priority assigned for the decision tasks for this workflow execution.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to request this child workflow execution. This
    /// information can be useful for diagnosing problems by tracing back the cause of events.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the
    /// <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>The maximum duration allowed for the decision tasks for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.task_start_to_close_timeout.as_deref()
    }
    /// <p>The list of tags to associated with the child workflow execution.</p>
    pub fn tag_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_list.as_deref()
    }
    /// <p>The IAM role to attach to the child workflow execution.</p>
    pub fn lambda_role(&self) -> std::option::Option<&str> {
        self.lambda_role.as_deref()
    }
}
impl std::fmt::Debug for StartChildWorkflowExecutionInitiatedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartChildWorkflowExecutionInitiatedEventAttributes");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("control", &self.control);
        formatter.field("input", &self.input);
        formatter.field(
            "execution_start_to_close_timeout",
            &self.execution_start_to_close_timeout,
        );
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("child_policy", &self.child_policy);
        formatter.field(
            "task_start_to_close_timeout",
            &self.task_start_to_close_timeout,
        );
        formatter.field("tag_list", &self.tag_list);
        formatter.field("lambda_role", &self.lambda_role);
        formatter.finish()
    }
}
/// See [`StartChildWorkflowExecutionInitiatedEventAttributes`](crate::model::StartChildWorkflowExecutionInitiatedEventAttributes)
pub mod start_child_workflow_execution_initiated_event_attributes {
    /// A builder for [`StartChildWorkflowExecutionInitiatedEventAttributes`](crate::model::StartChildWorkflowExecutionInitiatedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) execution_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>workflowId</code> of the child workflow execution.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The <code>workflowId</code> of the child workflow execution.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the child workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent to the activity.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent to the activity.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>The inputs provided to the child workflow execution.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The inputs provided to the child workflow execution.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The maximum duration for the child workflow execution. If the workflow execution isn't closed within this duration, it is timed out and force-terminated.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration for the child workflow execution. If the workflow execution isn't closed within this duration, it is timed out and force-terminated.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = input;
            self
        }
        /// <p>The name of the task list used for the decision tasks of the child workflow execution.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The name of the task list used for the decision tasks of the child workflow execution.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>
        /// The priority assigned for the decision tasks for this workflow execution.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>
        /// The priority assigned for the decision tasks for this workflow execution.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to request this child workflow execution. This
        /// information can be useful for diagnosing problems by tracing back the cause of events.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to request this child workflow execution. This
        /// information can be useful for diagnosing problems by tracing back the cause of events.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the
        /// <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the
        /// <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// <p>The maximum duration allowed for the decision tasks for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration allowed for the decision tasks for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags to associated with the child workflow execution.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags to associated with the child workflow execution.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>The IAM role to attach to the child workflow execution.</p>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_role = Some(input.into());
            self
        }
        /// <p>The IAM role to attach to the child workflow execution.</p>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChildWorkflowExecutionInitiatedEventAttributes`](crate::model::StartChildWorkflowExecutionInitiatedEventAttributes)
        pub fn build(self) -> crate::model::StartChildWorkflowExecutionInitiatedEventAttributes {
            crate::model::StartChildWorkflowExecutionInitiatedEventAttributes {
                workflow_id: self.workflow_id,
                workflow_type: self.workflow_type,
                control: self.control,
                input: self.input,
                execution_start_to_close_timeout: self.execution_start_to_close_timeout,
                task_list: self.task_list,
                task_priority: self.task_priority,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                child_policy: self.child_policy,
                task_start_to_close_timeout: self.task_start_to_close_timeout,
                tag_list: self.tag_list,
                lambda_role: self.lambda_role,
            }
        }
    }
}
impl StartChildWorkflowExecutionInitiatedEventAttributes {
    /// Creates a new builder-style object to manufacture [`StartChildWorkflowExecutionInitiatedEventAttributes`](crate::model::StartChildWorkflowExecutionInitiatedEventAttributes)
    pub fn builder(
    ) -> crate::model::start_child_workflow_execution_initiated_event_attributes::Builder {
        crate::model::start_child_workflow_execution_initiated_event_attributes::Builder::default()
    }
}

/// <p>
/// Provides the details of the <code>TimerCanceled</code> event.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimerCanceledEventAttributes {
    /// <p>The unique ID of the timer that was canceled.</p>
    pub timer_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl TimerCanceledEventAttributes {
    /// <p>The unique ID of the timer that was canceled.</p>
    pub fn timer_id(&self) -> std::option::Option<&str> {
        self.timer_id.as_deref()
    }
    /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for TimerCanceledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimerCanceledEventAttributes");
        formatter.field("timer_id", &self.timer_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`TimerCanceledEventAttributes`](crate::model::TimerCanceledEventAttributes)
pub mod timer_canceled_event_attributes {
    /// A builder for [`TimerCanceledEventAttributes`](crate::model::TimerCanceledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_id: std::option::Option<std::string::String>,
        pub(crate) started_event_id: std::option::Option<i64>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique ID of the timer that was canceled.</p>
        pub fn timer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the timer that was canceled.</p>
        pub fn set_timer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_id = input;
            self
        }
        /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TimerCanceledEventAttributes`](crate::model::TimerCanceledEventAttributes)
        pub fn build(self) -> crate::model::TimerCanceledEventAttributes {
            crate::model::TimerCanceledEventAttributes {
                timer_id: self.timer_id,
                started_event_id: self.started_event_id.unwrap_or_default(),
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl TimerCanceledEventAttributes {
    /// Creates a new builder-style object to manufacture [`TimerCanceledEventAttributes`](crate::model::TimerCanceledEventAttributes)
    pub fn builder() -> crate::model::timer_canceled_event_attributes::Builder {
        crate::model::timer_canceled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>TimerFired</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimerFiredEventAttributes {
    /// <p>The unique ID of the timer that fired.</p>
    pub timer_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
}
impl TimerFiredEventAttributes {
    /// <p>The unique ID of the timer that fired.</p>
    pub fn timer_id(&self) -> std::option::Option<&str> {
        self.timer_id.as_deref()
    }
    /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for TimerFiredEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimerFiredEventAttributes");
        formatter.field("timer_id", &self.timer_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`TimerFiredEventAttributes`](crate::model::TimerFiredEventAttributes)
pub mod timer_fired_event_attributes {
    /// A builder for [`TimerFiredEventAttributes`](crate::model::TimerFiredEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_id: std::option::Option<std::string::String>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique ID of the timer that fired.</p>
        pub fn timer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the timer that fired.</p>
        pub fn set_timer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_id = input;
            self
        }
        /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>TimerStarted</code> event that was recorded when this timer was started.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TimerFiredEventAttributes`](crate::model::TimerFiredEventAttributes)
        pub fn build(self) -> crate::model::TimerFiredEventAttributes {
            crate::model::TimerFiredEventAttributes {
                timer_id: self.timer_id,
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl TimerFiredEventAttributes {
    /// Creates a new builder-style object to manufacture [`TimerFiredEventAttributes`](crate::model::TimerFiredEventAttributes)
    pub fn builder() -> crate::model::timer_fired_event_attributes::Builder {
        crate::model::timer_fired_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>TimerStarted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimerStartedEventAttributes {
    /// <p>The unique ID of the timer that was started.</p>
    pub timer_id: std::option::Option<std::string::String>,
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>The duration of time after which the timer fires.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
    pub start_to_fire_timeout: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl TimerStartedEventAttributes {
    /// <p>The unique ID of the timer that was started.</p>
    pub fn timer_id(&self) -> std::option::Option<&str> {
        self.timer_id.as_deref()
    }
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>The duration of time after which the timer fires.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
    pub fn start_to_fire_timeout(&self) -> std::option::Option<&str> {
        self.start_to_fire_timeout.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for TimerStartedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimerStartedEventAttributes");
        formatter.field("timer_id", &self.timer_id);
        formatter.field("control", &self.control);
        formatter.field("start_to_fire_timeout", &self.start_to_fire_timeout);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`TimerStartedEventAttributes`](crate::model::TimerStartedEventAttributes)
pub mod timer_started_event_attributes {
    /// A builder for [`TimerStartedEventAttributes`](crate::model::TimerStartedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_id: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) start_to_fire_timeout: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique ID of the timer that was started.</p>
        pub fn timer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the timer that was started.</p>
        pub fn set_timer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_id = input;
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>The duration of time after which the timer fires.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
        pub fn start_to_fire_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_to_fire_timeout = Some(input.into());
            self
        }
        /// <p>The duration of time after which the timer fires.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>.</p>
        pub fn set_start_to_fire_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_to_fire_timeout = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TimerStartedEventAttributes`](crate::model::TimerStartedEventAttributes)
        pub fn build(self) -> crate::model::TimerStartedEventAttributes {
            crate::model::TimerStartedEventAttributes {
                timer_id: self.timer_id,
                control: self.control,
                start_to_fire_timeout: self.start_to_fire_timeout,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl TimerStartedEventAttributes {
    /// Creates a new builder-style object to manufacture [`TimerStartedEventAttributes`](crate::model::TimerStartedEventAttributes)
    pub fn builder() -> crate::model::timer_started_event_attributes::Builder {
        crate::model::timer_started_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>RecordMarkerFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordMarkerFailedEventAttributes {
    /// <p>The marker's name.</p>
    pub marker_name: std::option::Option<std::string::String>,
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::RecordMarkerFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RecordMarkerFailed</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl RecordMarkerFailedEventAttributes {
    /// <p>The marker's name.</p>
    pub fn marker_name(&self) -> std::option::Option<&str> {
        self.marker_name.as_deref()
    }
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::RecordMarkerFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RecordMarkerFailed</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for RecordMarkerFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordMarkerFailedEventAttributes");
        formatter.field("marker_name", &self.marker_name);
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`RecordMarkerFailedEventAttributes`](crate::model::RecordMarkerFailedEventAttributes)
pub mod record_marker_failed_event_attributes {
    /// A builder for [`RecordMarkerFailedEventAttributes`](crate::model::RecordMarkerFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker_name: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<crate::model::RecordMarkerFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The marker's name.</p>
        pub fn marker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker_name = Some(input.into());
            self
        }
        /// <p>The marker's name.</p>
        pub fn set_marker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker_name = input;
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::RecordMarkerFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::RecordMarkerFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RecordMarkerFailed</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RecordMarkerFailed</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordMarkerFailedEventAttributes`](crate::model::RecordMarkerFailedEventAttributes)
        pub fn build(self) -> crate::model::RecordMarkerFailedEventAttributes {
            crate::model::RecordMarkerFailedEventAttributes {
                marker_name: self.marker_name,
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl RecordMarkerFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`RecordMarkerFailedEventAttributes`](crate::model::RecordMarkerFailedEventAttributes)
    pub fn builder() -> crate::model::record_marker_failed_event_attributes::Builder {
        crate::model::record_marker_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordMarkerFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordMarkerFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPERATION_NOT_PERMITTED" => RecordMarkerFailedCause::OperationNotPermitted,
            other => RecordMarkerFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordMarkerFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordMarkerFailedCause::from(s))
    }
}
impl RecordMarkerFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordMarkerFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            RecordMarkerFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPERATION_NOT_PERMITTED"]
    }
}
impl AsRef<str> for RecordMarkerFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>MarkerRecorded</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarkerRecordedEventAttributes {
    /// <p>The name of the marker.</p>
    pub marker_name: std::option::Option<std::string::String>,
    /// <p>The details of the marker.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RecordMarker</code> decision that requested this marker. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl MarkerRecordedEventAttributes {
    /// <p>The name of the marker.</p>
    pub fn marker_name(&self) -> std::option::Option<&str> {
        self.marker_name.as_deref()
    }
    /// <p>The details of the marker.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RecordMarker</code> decision that requested this marker. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for MarkerRecordedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarkerRecordedEventAttributes");
        formatter.field("marker_name", &self.marker_name);
        formatter.field("details", &self.details);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`MarkerRecordedEventAttributes`](crate::model::MarkerRecordedEventAttributes)
pub mod marker_recorded_event_attributes {
    /// A builder for [`MarkerRecordedEventAttributes`](crate::model::MarkerRecordedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker_name: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the marker.</p>
        pub fn marker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker_name = Some(input.into());
            self
        }
        /// <p>The name of the marker.</p>
        pub fn set_marker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker_name = input;
            self
        }
        /// <p>The details of the marker.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details of the marker.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RecordMarker</code> decision that requested this marker. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RecordMarker</code> decision that requested this marker. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MarkerRecordedEventAttributes`](crate::model::MarkerRecordedEventAttributes)
        pub fn build(self) -> crate::model::MarkerRecordedEventAttributes {
            crate::model::MarkerRecordedEventAttributes {
                marker_name: self.marker_name,
                details: self.details,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl MarkerRecordedEventAttributes {
    /// Creates a new builder-style object to manufacture [`MarkerRecordedEventAttributes`](crate::model::MarkerRecordedEventAttributes)
    pub fn builder() -> crate::model::marker_recorded_event_attributes::Builder {
        crate::model::marker_recorded_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionSignaled</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionSignaledEventAttributes {
    /// <p>The name of the signal received. The decider can use the signal name and inputs to determine how to the process the signal.</p>
    pub signal_name: std::option::Option<std::string::String>,
    /// <p>The inputs provided with the signal. The decider can use the signal name and inputs to determine how to process the signal.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The workflow execution that sent the signal. This is set only of the signal was sent by another workflow execution.</p>
    pub external_workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID can
    /// be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event. This field is set only if
    /// the signal was initiated by another workflow execution.</p>
    pub external_initiated_event_id: i64,
}
impl WorkflowExecutionSignaledEventAttributes {
    /// <p>The name of the signal received. The decider can use the signal name and inputs to determine how to the process the signal.</p>
    pub fn signal_name(&self) -> std::option::Option<&str> {
        self.signal_name.as_deref()
    }
    /// <p>The inputs provided with the signal. The decider can use the signal name and inputs to determine how to process the signal.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The workflow execution that sent the signal. This is set only of the signal was sent by another workflow execution.</p>
    pub fn external_workflow_execution(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.external_workflow_execution.as_ref()
    }
    /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID can
    /// be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event. This field is set only if
    /// the signal was initiated by another workflow execution.</p>
    pub fn external_initiated_event_id(&self) -> i64 {
        self.external_initiated_event_id
    }
}
impl std::fmt::Debug for WorkflowExecutionSignaledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionSignaledEventAttributes");
        formatter.field("signal_name", &self.signal_name);
        formatter.field("input", &self.input);
        formatter.field(
            "external_workflow_execution",
            &self.external_workflow_execution,
        );
        formatter.field(
            "external_initiated_event_id",
            &self.external_initiated_event_id,
        );
        formatter.finish()
    }
}
/// See [`WorkflowExecutionSignaledEventAttributes`](crate::model::WorkflowExecutionSignaledEventAttributes)
pub mod workflow_execution_signaled_event_attributes {
    /// A builder for [`WorkflowExecutionSignaledEventAttributes`](crate::model::WorkflowExecutionSignaledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signal_name: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) external_workflow_execution:
            std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) external_initiated_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the signal received. The decider can use the signal name and inputs to determine how to the process the signal.</p>
        pub fn signal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.signal_name = Some(input.into());
            self
        }
        /// <p>The name of the signal received. The decider can use the signal name and inputs to determine how to the process the signal.</p>
        pub fn set_signal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signal_name = input;
            self
        }
        /// <p>The inputs provided with the signal. The decider can use the signal name and inputs to determine how to process the signal.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The inputs provided with the signal. The decider can use the signal name and inputs to determine how to process the signal.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The workflow execution that sent the signal. This is set only of the signal was sent by another workflow execution.</p>
        pub fn external_workflow_execution(
            mut self,
            input: crate::model::WorkflowExecution,
        ) -> Self {
            self.external_workflow_execution = Some(input);
            self
        }
        /// <p>The workflow execution that sent the signal. This is set only of the signal was sent by another workflow execution.</p>
        pub fn set_external_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.external_workflow_execution = input;
            self
        }
        /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID can
        /// be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event. This field is set only if
        /// the signal was initiated by another workflow execution.</p>
        pub fn external_initiated_event_id(mut self, input: i64) -> Self {
            self.external_initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID can
        /// be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event. This field is set only if
        /// the signal was initiated by another workflow execution.</p>
        pub fn set_external_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.external_initiated_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionSignaledEventAttributes`](crate::model::WorkflowExecutionSignaledEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionSignaledEventAttributes {
            crate::model::WorkflowExecutionSignaledEventAttributes {
                signal_name: self.signal_name,
                input: self.input,
                external_workflow_execution: self.external_workflow_execution,
                external_initiated_event_id: self.external_initiated_event_id.unwrap_or_default(),
            }
        }
    }
}
impl WorkflowExecutionSignaledEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionSignaledEventAttributes`](crate::model::WorkflowExecutionSignaledEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_signaled_event_attributes::Builder {
        crate::model::workflow_execution_signaled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ActivityTaskCancelRequested</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTaskCancelRequestedEventAttributes {
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>The unique ID of the task.</p>
    pub activity_id: std::option::Option<std::string::String>,
}
impl ActivityTaskCancelRequestedEventAttributes {
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>The unique ID of the task.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
}
impl std::fmt::Debug for ActivityTaskCancelRequestedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTaskCancelRequestedEventAttributes");
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("activity_id", &self.activity_id);
        formatter.finish()
    }
}
/// See [`ActivityTaskCancelRequestedEventAttributes`](crate::model::ActivityTaskCancelRequestedEventAttributes)
pub mod activity_task_cancel_requested_event_attributes {
    /// A builder for [`ActivityTaskCancelRequestedEventAttributes`](crate::model::ActivityTaskCancelRequestedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) activity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>RequestCancelActivityTask</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>The unique ID of the task.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the task.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTaskCancelRequestedEventAttributes`](crate::model::ActivityTaskCancelRequestedEventAttributes)
        pub fn build(self) -> crate::model::ActivityTaskCancelRequestedEventAttributes {
            crate::model::ActivityTaskCancelRequestedEventAttributes {
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                activity_id: self.activity_id,
            }
        }
    }
}
impl ActivityTaskCancelRequestedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ActivityTaskCancelRequestedEventAttributes`](crate::model::ActivityTaskCancelRequestedEventAttributes)
    pub fn builder() -> crate::model::activity_task_cancel_requested_event_attributes::Builder {
        crate::model::activity_task_cancel_requested_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ActivityTaskCanceled</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTaskCanceledEventAttributes {
    /// <p>Details of the cancellation.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub started_event_id: i64,
    /// <p>If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub latest_cancel_requested_event_id: i64,
}
impl ActivityTaskCanceledEventAttributes {
    /// <p>Details of the cancellation.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
    /// <p>If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn latest_cancel_requested_event_id(&self) -> i64 {
        self.latest_cancel_requested_event_id
    }
}
impl std::fmt::Debug for ActivityTaskCanceledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTaskCanceledEventAttributes");
        formatter.field("details", &self.details);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.field(
            "latest_cancel_requested_event_id",
            &self.latest_cancel_requested_event_id,
        );
        formatter.finish()
    }
}
/// See [`ActivityTaskCanceledEventAttributes`](crate::model::ActivityTaskCanceledEventAttributes)
pub mod activity_task_canceled_event_attributes {
    /// A builder for [`ActivityTaskCanceledEventAttributes`](crate::model::ActivityTaskCanceledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
        pub(crate) latest_cancel_requested_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Details of the cancellation.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>Details of the cancellation.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// <p>If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn latest_cancel_requested_event_id(mut self, input: i64) -> Self {
            self.latest_cancel_requested_event_id = Some(input);
            self
        }
        /// <p>If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_latest_cancel_requested_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.latest_cancel_requested_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTaskCanceledEventAttributes`](crate::model::ActivityTaskCanceledEventAttributes)
        pub fn build(self) -> crate::model::ActivityTaskCanceledEventAttributes {
            crate::model::ActivityTaskCanceledEventAttributes {
                details: self.details,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
                latest_cancel_requested_event_id: self
                    .latest_cancel_requested_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl ActivityTaskCanceledEventAttributes {
    /// Creates a new builder-style object to manufacture [`ActivityTaskCanceledEventAttributes`](crate::model::ActivityTaskCanceledEventAttributes)
    pub fn builder() -> crate::model::activity_task_canceled_event_attributes::Builder {
        crate::model::activity_task_canceled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ActivityTaskTimedOut</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTaskTimedOutEventAttributes {
    /// <p>The type of the timeout that caused this event.</p>
    pub timeout_type: std::option::Option<crate::model::ActivityTaskTimeoutType>,
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub started_event_id: i64,
    /// <p>Contains the content of the <code>details</code> parameter for the last call made by the activity to
    /// <code>RecordActivityTaskHeartbeat</code>.</p>
    pub details: std::option::Option<std::string::String>,
}
impl ActivityTaskTimedOutEventAttributes {
    /// <p>The type of the timeout that caused this event.</p>
    pub fn timeout_type(&self) -> std::option::Option<&crate::model::ActivityTaskTimeoutType> {
        self.timeout_type.as_ref()
    }
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
    /// <p>Contains the content of the <code>details</code> parameter for the last call made by the activity to
    /// <code>RecordActivityTaskHeartbeat</code>.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for ActivityTaskTimedOutEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTaskTimedOutEventAttributes");
        formatter.field("timeout_type", &self.timeout_type);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`ActivityTaskTimedOutEventAttributes`](crate::model::ActivityTaskTimedOutEventAttributes)
pub mod activity_task_timed_out_event_attributes {
    /// A builder for [`ActivityTaskTimedOutEventAttributes`](crate::model::ActivityTaskTimedOutEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_type: std::option::Option<crate::model::ActivityTaskTimeoutType>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the timeout that caused this event.</p>
        pub fn timeout_type(mut self, input: crate::model::ActivityTaskTimeoutType) -> Self {
            self.timeout_type = Some(input);
            self
        }
        /// <p>The type of the timeout that caused this event.</p>
        pub fn set_timeout_type(
            mut self,
            input: std::option::Option<crate::model::ActivityTaskTimeoutType>,
        ) -> Self {
            self.timeout_type = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// <p>Contains the content of the <code>details</code> parameter for the last call made by the activity to
        /// <code>RecordActivityTaskHeartbeat</code>.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>Contains the content of the <code>details</code> parameter for the last call made by the activity to
        /// <code>RecordActivityTaskHeartbeat</code>.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTaskTimedOutEventAttributes`](crate::model::ActivityTaskTimedOutEventAttributes)
        pub fn build(self) -> crate::model::ActivityTaskTimedOutEventAttributes {
            crate::model::ActivityTaskTimedOutEventAttributes {
                timeout_type: self.timeout_type,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
                details: self.details,
            }
        }
    }
}
impl ActivityTaskTimedOutEventAttributes {
    /// Creates a new builder-style object to manufacture [`ActivityTaskTimedOutEventAttributes`](crate::model::ActivityTaskTimedOutEventAttributes)
    pub fn builder() -> crate::model::activity_task_timed_out_event_attributes::Builder {
        crate::model::activity_task_timed_out_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActivityTaskTimeoutType {
    #[allow(missing_docs)] // documentation missing in model
    Heartbeat,
    #[allow(missing_docs)] // documentation missing in model
    ScheduleToClose,
    #[allow(missing_docs)] // documentation missing in model
    ScheduleToStart,
    #[allow(missing_docs)] // documentation missing in model
    StartToClose,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActivityTaskTimeoutType {
    fn from(s: &str) -> Self {
        match s {
            "HEARTBEAT" => ActivityTaskTimeoutType::Heartbeat,
            "SCHEDULE_TO_CLOSE" => ActivityTaskTimeoutType::ScheduleToClose,
            "SCHEDULE_TO_START" => ActivityTaskTimeoutType::ScheduleToStart,
            "START_TO_CLOSE" => ActivityTaskTimeoutType::StartToClose,
            other => ActivityTaskTimeoutType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActivityTaskTimeoutType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActivityTaskTimeoutType::from(s))
    }
}
impl ActivityTaskTimeoutType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActivityTaskTimeoutType::Heartbeat => "HEARTBEAT",
            ActivityTaskTimeoutType::ScheduleToClose => "SCHEDULE_TO_CLOSE",
            ActivityTaskTimeoutType::ScheduleToStart => "SCHEDULE_TO_START",
            ActivityTaskTimeoutType::StartToClose => "START_TO_CLOSE",
            ActivityTaskTimeoutType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "HEARTBEAT",
            "SCHEDULE_TO_CLOSE",
            "SCHEDULE_TO_START",
            "START_TO_CLOSE",
        ]
    }
}
impl AsRef<str> for ActivityTaskTimeoutType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>ActivityTaskFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTaskFailedEventAttributes {
    /// <p>The reason provided for the failure.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The details of the failure.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub started_event_id: i64,
}
impl ActivityTaskFailedEventAttributes {
    /// <p>The reason provided for the failure.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The details of the failure.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for ActivityTaskFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTaskFailedEventAttributes");
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`ActivityTaskFailedEventAttributes`](crate::model::ActivityTaskFailedEventAttributes)
pub mod activity_task_failed_event_attributes {
    /// A builder for [`ActivityTaskFailedEventAttributes`](crate::model::ActivityTaskFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The reason provided for the failure.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason provided for the failure.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The details of the failure.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details of the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTaskFailedEventAttributes`](crate::model::ActivityTaskFailedEventAttributes)
        pub fn build(self) -> crate::model::ActivityTaskFailedEventAttributes {
            crate::model::ActivityTaskFailedEventAttributes {
                reason: self.reason,
                details: self.details,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ActivityTaskFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ActivityTaskFailedEventAttributes`](crate::model::ActivityTaskFailedEventAttributes)
    pub fn builder() -> crate::model::activity_task_failed_event_attributes::Builder {
        crate::model::activity_task_failed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ActivityTaskCompleted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTaskCompletedEventAttributes {
    /// <p>The results of the activity task.</p>
    pub result: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub started_event_id: i64,
}
impl ActivityTaskCompletedEventAttributes {
    /// <p>The results of the activity task.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for ActivityTaskCompletedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTaskCompletedEventAttributes");
        formatter.field("result", &self.result);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`ActivityTaskCompletedEventAttributes`](crate::model::ActivityTaskCompletedEventAttributes)
pub mod activity_task_completed_event_attributes {
    /// A builder for [`ActivityTaskCompletedEventAttributes`](crate::model::ActivityTaskCompletedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result: std::option::Option<std::string::String>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The results of the activity task.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>The results of the activity task.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTaskCompletedEventAttributes`](crate::model::ActivityTaskCompletedEventAttributes)
        pub fn build(self) -> crate::model::ActivityTaskCompletedEventAttributes {
            crate::model::ActivityTaskCompletedEventAttributes {
                result: self.result,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ActivityTaskCompletedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ActivityTaskCompletedEventAttributes`](crate::model::ActivityTaskCompletedEventAttributes)
    pub fn builder() -> crate::model::activity_task_completed_event_attributes::Builder {
        crate::model::activity_task_completed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ActivityTaskStarted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTaskStartedEventAttributes {
    /// <p>Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The form of this identity is user defined.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub scheduled_event_id: i64,
}
impl ActivityTaskStartedEventAttributes {
    /// <p>Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The form of this identity is user defined.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
}
impl std::fmt::Debug for ActivityTaskStartedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTaskStartedEventAttributes");
        formatter.field("identity", &self.identity);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.finish()
    }
}
/// See [`ActivityTaskStartedEventAttributes`](crate::model::ActivityTaskStartedEventAttributes)
pub mod activity_task_started_event_attributes {
    /// A builder for [`ActivityTaskStartedEventAttributes`](crate::model::ActivityTaskStartedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTaskStartedEventAttributes`](crate::model::ActivityTaskStartedEventAttributes)
        pub fn build(self) -> crate::model::ActivityTaskStartedEventAttributes {
            crate::model::ActivityTaskStartedEventAttributes {
                identity: self.identity,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
            }
        }
    }
}
impl ActivityTaskStartedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ActivityTaskStartedEventAttributes`](crate::model::ActivityTaskStartedEventAttributes)
    pub fn builder() -> crate::model::activity_task_started_event_attributes::Builder {
        crate::model::activity_task_started_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>ActivityTaskScheduled</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTaskScheduledEventAttributes {
    /// <p>The type of the activity task.</p>
    pub activity_type: std::option::Option<crate::model::ActivityType>,
    /// <p>The unique ID of the activity task.</p>
    pub activity_id: std::option::Option<std::string::String>,
    /// <p>The input provided to the activity task.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
    pub control: std::option::Option<std::string::String>,
    /// <p>The maximum amount of time the activity task can wait to be assigned to a worker.</p>
    pub schedule_to_start_timeout: std::option::Option<std::string::String>,
    /// <p>The maximum amount of time for this activity task.</p>
    pub schedule_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The maximum amount of time a worker may take to process the activity task.</p>
    pub start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The task list in which the activity task has been scheduled.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// The priority to assign to the scheduled activity task. If set, this overrides any default
    /// priority value that was assigned when the activity type was registered.</p>
    /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>The maximum time before which the worker processing this task must report progress by calling
    /// <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out. If
    /// the worker subsequently attempts to record a heartbeat or return a result, it is ignored.</p>
    pub heartbeat_timeout: std::option::Option<std::string::String>,
}
impl ActivityTaskScheduledEventAttributes {
    /// <p>The type of the activity task.</p>
    pub fn activity_type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.activity_type.as_ref()
    }
    /// <p>The unique ID of the activity task.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
    /// <p>The input provided to the activity task.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
    pub fn control(&self) -> std::option::Option<&str> {
        self.control.as_deref()
    }
    /// <p>The maximum amount of time the activity task can wait to be assigned to a worker.</p>
    pub fn schedule_to_start_timeout(&self) -> std::option::Option<&str> {
        self.schedule_to_start_timeout.as_deref()
    }
    /// <p>The maximum amount of time for this activity task.</p>
    pub fn schedule_to_close_timeout(&self) -> std::option::Option<&str> {
        self.schedule_to_close_timeout.as_deref()
    }
    /// <p>The maximum amount of time a worker may take to process the activity task.</p>
    pub fn start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.start_to_close_timeout.as_deref()
    }
    /// <p>The task list in which the activity task has been scheduled.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>
    /// The priority to assign to the scheduled activity task. If set, this overrides any default
    /// priority value that was assigned when the activity type was registered.</p>
    /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>The maximum time before which the worker processing this task must report progress by calling
    /// <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out. If
    /// the worker subsequently attempts to record a heartbeat or return a result, it is ignored.</p>
    pub fn heartbeat_timeout(&self) -> std::option::Option<&str> {
        self.heartbeat_timeout.as_deref()
    }
}
impl std::fmt::Debug for ActivityTaskScheduledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTaskScheduledEventAttributes");
        formatter.field("activity_type", &self.activity_type);
        formatter.field("activity_id", &self.activity_id);
        formatter.field("input", &self.input);
        formatter.field("control", &self.control);
        formatter.field("schedule_to_start_timeout", &self.schedule_to_start_timeout);
        formatter.field("schedule_to_close_timeout", &self.schedule_to_close_timeout);
        formatter.field("start_to_close_timeout", &self.start_to_close_timeout);
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("heartbeat_timeout", &self.heartbeat_timeout);
        formatter.finish()
    }
}
/// See [`ActivityTaskScheduledEventAttributes`](crate::model::ActivityTaskScheduledEventAttributes)
pub mod activity_task_scheduled_event_attributes {
    /// A builder for [`ActivityTaskScheduledEventAttributes`](crate::model::ActivityTaskScheduledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_type: std::option::Option<crate::model::ActivityType>,
        pub(crate) activity_id: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) control: std::option::Option<std::string::String>,
        pub(crate) schedule_to_start_timeout: std::option::Option<std::string::String>,
        pub(crate) schedule_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) heartbeat_timeout: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the activity task.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.activity_type = Some(input);
            self
        }
        /// <p>The type of the activity task.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.activity_type = input;
            self
        }
        /// <p>The unique ID of the activity task.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the activity task.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// <p>The input provided to the activity task.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input provided to the activity task.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
        pub fn control(mut self, input: impl Into<std::string::String>) -> Self {
            self.control = Some(input.into());
            self
        }
        /// <p>Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.</p>
        pub fn set_control(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control = input;
            self
        }
        /// <p>The maximum amount of time the activity task can wait to be assigned to a worker.</p>
        pub fn schedule_to_start_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_to_start_timeout = Some(input.into());
            self
        }
        /// <p>The maximum amount of time the activity task can wait to be assigned to a worker.</p>
        pub fn set_schedule_to_start_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_to_start_timeout = input;
            self
        }
        /// <p>The maximum amount of time for this activity task.</p>
        pub fn schedule_to_close_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum amount of time for this activity task.</p>
        pub fn set_schedule_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_to_close_timeout = input;
            self
        }
        /// <p>The maximum amount of time a worker may take to process the activity task.</p>
        pub fn start_to_close_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum amount of time a worker may take to process the activity task.</p>
        pub fn set_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_to_close_timeout = input;
            self
        }
        /// <p>The task list in which the activity task has been scheduled.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The task list in which the activity task has been scheduled.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>
        /// The priority to assign to the scheduled activity task. If set, this overrides any default
        /// priority value that was assigned when the activity type was registered.</p>
        /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>
        /// The priority to assign to the scheduled activity task. If set, this overrides any default
        /// priority value that was assigned when the activity type was registered.</p>
        /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>The maximum time before which the worker processing this task must report progress by calling
        /// <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out. If
        /// the worker subsequently attempts to record a heartbeat or return a result, it is ignored.</p>
        pub fn heartbeat_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.heartbeat_timeout = Some(input.into());
            self
        }
        /// <p>The maximum time before which the worker processing this task must report progress by calling
        /// <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out. If
        /// the worker subsequently attempts to record a heartbeat or return a result, it is ignored.</p>
        pub fn set_heartbeat_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.heartbeat_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTaskScheduledEventAttributes`](crate::model::ActivityTaskScheduledEventAttributes)
        pub fn build(self) -> crate::model::ActivityTaskScheduledEventAttributes {
            crate::model::ActivityTaskScheduledEventAttributes {
                activity_type: self.activity_type,
                activity_id: self.activity_id,
                input: self.input,
                control: self.control,
                schedule_to_start_timeout: self.schedule_to_start_timeout,
                schedule_to_close_timeout: self.schedule_to_close_timeout,
                start_to_close_timeout: self.start_to_close_timeout,
                task_list: self.task_list,
                task_priority: self.task_priority,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                heartbeat_timeout: self.heartbeat_timeout,
            }
        }
    }
}
impl ActivityTaskScheduledEventAttributes {
    /// Creates a new builder-style object to manufacture [`ActivityTaskScheduledEventAttributes`](crate::model::ActivityTaskScheduledEventAttributes)
    pub fn builder() -> crate::model::activity_task_scheduled_event_attributes::Builder {
        crate::model::activity_task_scheduled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>DecisionTaskTimedOut</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecisionTaskTimedOutEventAttributes {
    /// <p>The type of timeout that expired before the decision task could be completed.</p>
    pub timeout_type: std::option::Option<crate::model::DecisionTaskTimeoutType>,
    /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub started_event_id: i64,
}
impl DecisionTaskTimedOutEventAttributes {
    /// <p>The type of timeout that expired before the decision task could be completed.</p>
    pub fn timeout_type(&self) -> std::option::Option<&crate::model::DecisionTaskTimeoutType> {
        self.timeout_type.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
    /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
    /// event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for DecisionTaskTimedOutEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecisionTaskTimedOutEventAttributes");
        formatter.field("timeout_type", &self.timeout_type);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`DecisionTaskTimedOutEventAttributes`](crate::model::DecisionTaskTimedOutEventAttributes)
pub mod decision_task_timed_out_event_attributes {
    /// A builder for [`DecisionTaskTimedOutEventAttributes`](crate::model::DecisionTaskTimedOutEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_type: std::option::Option<crate::model::DecisionTaskTimeoutType>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The type of timeout that expired before the decision task could be completed.</p>
        pub fn timeout_type(mut self, input: crate::model::DecisionTaskTimeoutType) -> Self {
            self.timeout_type = Some(input);
            self
        }
        /// <p>The type of timeout that expired before the decision task could be completed.</p>
        pub fn set_timeout_type(
            mut self,
            input: std::option::Option<crate::model::DecisionTaskTimeoutType>,
        ) -> Self {
            self.timeout_type = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
        /// information can be useful for diagnosing problems by tracing back the chain of events leading up to this
        /// event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DecisionTaskTimedOutEventAttributes`](crate::model::DecisionTaskTimedOutEventAttributes)
        pub fn build(self) -> crate::model::DecisionTaskTimedOutEventAttributes {
            crate::model::DecisionTaskTimedOutEventAttributes {
                timeout_type: self.timeout_type,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl DecisionTaskTimedOutEventAttributes {
    /// Creates a new builder-style object to manufacture [`DecisionTaskTimedOutEventAttributes`](crate::model::DecisionTaskTimedOutEventAttributes)
    pub fn builder() -> crate::model::decision_task_timed_out_event_attributes::Builder {
        crate::model::decision_task_timed_out_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DecisionTaskTimeoutType {
    #[allow(missing_docs)] // documentation missing in model
    StartToClose,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DecisionTaskTimeoutType {
    fn from(s: &str) -> Self {
        match s {
            "START_TO_CLOSE" => DecisionTaskTimeoutType::StartToClose,
            other => DecisionTaskTimeoutType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DecisionTaskTimeoutType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DecisionTaskTimeoutType::from(s))
    }
}
impl DecisionTaskTimeoutType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DecisionTaskTimeoutType::StartToClose => "START_TO_CLOSE",
            DecisionTaskTimeoutType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["START_TO_CLOSE"]
    }
}
impl AsRef<str> for DecisionTaskTimeoutType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>DecisionTaskCompleted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecisionTaskCompletedEventAttributes {
    /// <p>User defined context for the workflow execution.</p>
    pub execution_context: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub scheduled_event_id: i64,
    /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub started_event_id: i64,
}
impl DecisionTaskCompletedEventAttributes {
    /// <p>User defined context for the workflow execution.</p>
    pub fn execution_context(&self) -> std::option::Option<&str> {
        self.execution_context.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
    /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn started_event_id(&self) -> i64 {
        self.started_event_id
    }
}
impl std::fmt::Debug for DecisionTaskCompletedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecisionTaskCompletedEventAttributes");
        formatter.field("execution_context", &self.execution_context);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.field("started_event_id", &self.started_event_id);
        formatter.finish()
    }
}
/// See [`DecisionTaskCompletedEventAttributes`](crate::model::DecisionTaskCompletedEventAttributes)
pub mod decision_task_completed_event_attributes {
    /// A builder for [`DecisionTaskCompletedEventAttributes`](crate::model::DecisionTaskCompletedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_context: std::option::Option<std::string::String>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
        pub(crate) started_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>User defined context for the workflow execution.</p>
        pub fn execution_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_context = Some(input.into());
            self
        }
        /// <p>User defined context for the workflow execution.</p>
        pub fn set_execution_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_context = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn started_event_id(mut self, input: i64) -> Self {
            self.started_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_started_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.started_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DecisionTaskCompletedEventAttributes`](crate::model::DecisionTaskCompletedEventAttributes)
        pub fn build(self) -> crate::model::DecisionTaskCompletedEventAttributes {
            crate::model::DecisionTaskCompletedEventAttributes {
                execution_context: self.execution_context,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
                started_event_id: self.started_event_id.unwrap_or_default(),
            }
        }
    }
}
impl DecisionTaskCompletedEventAttributes {
    /// Creates a new builder-style object to manufacture [`DecisionTaskCompletedEventAttributes`](crate::model::DecisionTaskCompletedEventAttributes)
    pub fn builder() -> crate::model::decision_task_completed_event_attributes::Builder {
        crate::model::decision_task_completed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>DecisionTaskStarted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecisionTaskStartedEventAttributes {
    /// <p>Identity of the decider making the request. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub scheduled_event_id: i64,
}
impl DecisionTaskStartedEventAttributes {
    /// <p>Identity of the decider making the request. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
    /// This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn scheduled_event_id(&self) -> i64 {
        self.scheduled_event_id
    }
}
impl std::fmt::Debug for DecisionTaskStartedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecisionTaskStartedEventAttributes");
        formatter.field("identity", &self.identity);
        formatter.field("scheduled_event_id", &self.scheduled_event_id);
        formatter.finish()
    }
}
/// See [`DecisionTaskStartedEventAttributes`](crate::model::DecisionTaskStartedEventAttributes)
pub mod decision_task_started_event_attributes {
    /// A builder for [`DecisionTaskStartedEventAttributes`](crate::model::DecisionTaskStartedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) scheduled_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Identity of the decider making the request. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>Identity of the decider making the request. This enables diagnostic tracing when problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn scheduled_event_id(mut self, input: i64) -> Self {
            self.scheduled_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
        /// This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_scheduled_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.scheduled_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DecisionTaskStartedEventAttributes`](crate::model::DecisionTaskStartedEventAttributes)
        pub fn build(self) -> crate::model::DecisionTaskStartedEventAttributes {
            crate::model::DecisionTaskStartedEventAttributes {
                identity: self.identity,
                scheduled_event_id: self.scheduled_event_id.unwrap_or_default(),
            }
        }
    }
}
impl DecisionTaskStartedEventAttributes {
    /// Creates a new builder-style object to manufacture [`DecisionTaskStartedEventAttributes`](crate::model::DecisionTaskStartedEventAttributes)
    pub fn builder() -> crate::model::decision_task_started_event_attributes::Builder {
        crate::model::decision_task_started_event_attributes::Builder::default()
    }
}

/// <p>Provides details about the <code>DecisionTaskScheduled</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecisionTaskScheduledEventAttributes {
    /// <p>The name of the task list in which the decision task was scheduled.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// A task priority that, if set, specifies the priority for this decision task.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>The maximum duration for this decision task. The task is considered timed out if it doesn't completed within this duration.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub start_to_close_timeout: std::option::Option<std::string::String>,
}
impl DecisionTaskScheduledEventAttributes {
    /// <p>The name of the task list in which the decision task was scheduled.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>
    /// A task priority that, if set, specifies the priority for this decision task.
    /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>The maximum duration for this decision task. The task is considered timed out if it doesn't completed within this duration.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.start_to_close_timeout.as_deref()
    }
}
impl std::fmt::Debug for DecisionTaskScheduledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecisionTaskScheduledEventAttributes");
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field("start_to_close_timeout", &self.start_to_close_timeout);
        formatter.finish()
    }
}
/// See [`DecisionTaskScheduledEventAttributes`](crate::model::DecisionTaskScheduledEventAttributes)
pub mod decision_task_scheduled_event_attributes {
    /// A builder for [`DecisionTaskScheduledEventAttributes`](crate::model::DecisionTaskScheduledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) start_to_close_timeout: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the task list in which the decision task was scheduled.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The name of the task list in which the decision task was scheduled.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>
        /// A task priority that, if set, specifies the priority for this decision task.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>
        /// A task priority that, if set, specifies the priority for this decision task.
        /// Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>The maximum duration for this decision task. The task is considered timed out if it doesn't completed within this duration.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn start_to_close_timeout(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration for this decision task. The task is considered timed out if it doesn't completed within this duration.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_to_close_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`DecisionTaskScheduledEventAttributes`](crate::model::DecisionTaskScheduledEventAttributes)
        pub fn build(self) -> crate::model::DecisionTaskScheduledEventAttributes {
            crate::model::DecisionTaskScheduledEventAttributes {
                task_list: self.task_list,
                task_priority: self.task_priority,
                start_to_close_timeout: self.start_to_close_timeout,
            }
        }
    }
}
impl DecisionTaskScheduledEventAttributes {
    /// Creates a new builder-style object to manufacture [`DecisionTaskScheduledEventAttributes`](crate::model::DecisionTaskScheduledEventAttributes)
    pub fn builder() -> crate::model::decision_task_scheduled_event_attributes::Builder {
        crate::model::decision_task_scheduled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionCancelRequested</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionCancelRequestedEventAttributes {
    /// <p>The external workflow execution for which the cancellation was requested.</p>
    pub external_workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source event
    /// with this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub external_initiated_event_id: i64,
    /// <p>If set, indicates that the request to cancel the workflow execution was automatically generated, and specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child policy is set to cancel child executions.</p>
    pub cause: std::option::Option<crate::model::WorkflowExecutionCancelRequestedCause>,
}
impl WorkflowExecutionCancelRequestedEventAttributes {
    /// <p>The external workflow execution for which the cancellation was requested.</p>
    pub fn external_workflow_execution(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.external_workflow_execution.as_ref()
    }
    /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source event
    /// with this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn external_initiated_event_id(&self) -> i64 {
        self.external_initiated_event_id
    }
    /// <p>If set, indicates that the request to cancel the workflow execution was automatically generated, and specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child policy is set to cancel child executions.</p>
    pub fn cause(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecutionCancelRequestedCause> {
        self.cause.as_ref()
    }
}
impl std::fmt::Debug for WorkflowExecutionCancelRequestedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionCancelRequestedEventAttributes");
        formatter.field(
            "external_workflow_execution",
            &self.external_workflow_execution,
        );
        formatter.field(
            "external_initiated_event_id",
            &self.external_initiated_event_id,
        );
        formatter.field("cause", &self.cause);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionCancelRequestedEventAttributes`](crate::model::WorkflowExecutionCancelRequestedEventAttributes)
pub mod workflow_execution_cancel_requested_event_attributes {
    /// A builder for [`WorkflowExecutionCancelRequestedEventAttributes`](crate::model::WorkflowExecutionCancelRequestedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_workflow_execution:
            std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) external_initiated_event_id: std::option::Option<i64>,
        pub(crate) cause: std::option::Option<crate::model::WorkflowExecutionCancelRequestedCause>,
    }
    impl Builder {
        /// <p>The external workflow execution for which the cancellation was requested.</p>
        pub fn external_workflow_execution(
            mut self,
            input: crate::model::WorkflowExecution,
        ) -> Self {
            self.external_workflow_execution = Some(input);
            self
        }
        /// <p>The external workflow execution for which the cancellation was requested.</p>
        pub fn set_external_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.external_workflow_execution = input;
            self
        }
        /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source event
        /// with this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn external_initiated_event_id(mut self, input: i64) -> Self {
            self.external_initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source event
        /// with this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_external_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.external_initiated_event_id = input;
            self
        }
        /// <p>If set, indicates that the request to cancel the workflow execution was automatically generated, and specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child policy is set to cancel child executions.</p>
        pub fn cause(mut self, input: crate::model::WorkflowExecutionCancelRequestedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>If set, indicates that the request to cancel the workflow execution was automatically generated, and specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child policy is set to cancel child executions.</p>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionCancelRequestedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionCancelRequestedEventAttributes`](crate::model::WorkflowExecutionCancelRequestedEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionCancelRequestedEventAttributes {
            crate::model::WorkflowExecutionCancelRequestedEventAttributes {
                external_workflow_execution: self.external_workflow_execution,
                external_initiated_event_id: self.external_initiated_event_id.unwrap_or_default(),
                cause: self.cause,
            }
        }
    }
}
impl WorkflowExecutionCancelRequestedEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionCancelRequestedEventAttributes`](crate::model::WorkflowExecutionCancelRequestedEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_cancel_requested_event_attributes::Builder
    {
        crate::model::workflow_execution_cancel_requested_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkflowExecutionCancelRequestedCause {
    #[allow(missing_docs)] // documentation missing in model
    ChildPolicyApplied,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkflowExecutionCancelRequestedCause {
    fn from(s: &str) -> Self {
        match s {
            "CHILD_POLICY_APPLIED" => WorkflowExecutionCancelRequestedCause::ChildPolicyApplied,
            other => WorkflowExecutionCancelRequestedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkflowExecutionCancelRequestedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkflowExecutionCancelRequestedCause::from(s))
    }
}
impl WorkflowExecutionCancelRequestedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkflowExecutionCancelRequestedCause::ChildPolicyApplied => "CHILD_POLICY_APPLIED",
            WorkflowExecutionCancelRequestedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHILD_POLICY_APPLIED"]
    }
}
impl AsRef<str> for WorkflowExecutionCancelRequestedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionTerminated</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionTerminatedEventAttributes {
    /// <p>The reason provided for the termination.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The details provided for the termination.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The policy used for the child workflow executions of this workflow execution.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This happens if the parent workflow execution times out or is terminated and the child policy is set to terminate child executions.</p>
    pub cause: std::option::Option<crate::model::WorkflowExecutionTerminatedCause>,
}
impl WorkflowExecutionTerminatedEventAttributes {
    /// <p>The reason provided for the termination.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The details provided for the termination.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The policy used for the child workflow executions of this workflow execution.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This happens if the parent workflow execution times out or is terminated and the child policy is set to terminate child executions.</p>
    pub fn cause(&self) -> std::option::Option<&crate::model::WorkflowExecutionTerminatedCause> {
        self.cause.as_ref()
    }
}
impl std::fmt::Debug for WorkflowExecutionTerminatedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionTerminatedEventAttributes");
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.field("child_policy", &self.child_policy);
        formatter.field("cause", &self.cause);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionTerminatedEventAttributes`](crate::model::WorkflowExecutionTerminatedEventAttributes)
pub mod workflow_execution_terminated_event_attributes {
    /// A builder for [`WorkflowExecutionTerminatedEventAttributes`](crate::model::WorkflowExecutionTerminatedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) cause: std::option::Option<crate::model::WorkflowExecutionTerminatedCause>,
    }
    impl Builder {
        /// <p>The reason provided for the termination.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason provided for the termination.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The details provided for the termination.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details provided for the termination.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The policy used for the child workflow executions of this workflow execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>The policy used for the child workflow executions of this workflow execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// <p>If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This happens if the parent workflow execution times out or is terminated and the child policy is set to terminate child executions.</p>
        pub fn cause(mut self, input: crate::model::WorkflowExecutionTerminatedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This happens if the parent workflow execution times out or is terminated and the child policy is set to terminate child executions.</p>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionTerminatedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionTerminatedEventAttributes`](crate::model::WorkflowExecutionTerminatedEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionTerminatedEventAttributes {
            crate::model::WorkflowExecutionTerminatedEventAttributes {
                reason: self.reason,
                details: self.details,
                child_policy: self.child_policy,
                cause: self.cause,
            }
        }
    }
}
impl WorkflowExecutionTerminatedEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionTerminatedEventAttributes`](crate::model::WorkflowExecutionTerminatedEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_terminated_event_attributes::Builder {
        crate::model::workflow_execution_terminated_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkflowExecutionTerminatedCause {
    #[allow(missing_docs)] // documentation missing in model
    ChildPolicyApplied,
    #[allow(missing_docs)] // documentation missing in model
    EventLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    OperatorInitiated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkflowExecutionTerminatedCause {
    fn from(s: &str) -> Self {
        match s {
            "CHILD_POLICY_APPLIED" => WorkflowExecutionTerminatedCause::ChildPolicyApplied,
            "EVENT_LIMIT_EXCEEDED" => WorkflowExecutionTerminatedCause::EventLimitExceeded,
            "OPERATOR_INITIATED" => WorkflowExecutionTerminatedCause::OperatorInitiated,
            other => WorkflowExecutionTerminatedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkflowExecutionTerminatedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkflowExecutionTerminatedCause::from(s))
    }
}
impl WorkflowExecutionTerminatedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkflowExecutionTerminatedCause::ChildPolicyApplied => "CHILD_POLICY_APPLIED",
            WorkflowExecutionTerminatedCause::EventLimitExceeded => "EVENT_LIMIT_EXCEEDED",
            WorkflowExecutionTerminatedCause::OperatorInitiated => "OPERATOR_INITIATED",
            WorkflowExecutionTerminatedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CHILD_POLICY_APPLIED",
            "EVENT_LIMIT_EXCEEDED",
            "OPERATOR_INITIATED",
        ]
    }
}
impl AsRef<str> for WorkflowExecutionTerminatedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>ContinueAsNewWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinueAsNewWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::ContinueAsNewWorkflowExecutionFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl ContinueAsNewWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(
        &self,
    ) -> std::option::Option<&crate::model::ContinueAsNewWorkflowExecutionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for ContinueAsNewWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinueAsNewWorkflowExecutionFailedEventAttributes");
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`ContinueAsNewWorkflowExecutionFailedEventAttributes`](crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes)
pub mod continue_as_new_workflow_execution_failed_event_attributes {
    /// A builder for [`ContinueAsNewWorkflowExecutionFailedEventAttributes`](crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cause:
            std::option::Option<crate::model::ContinueAsNewWorkflowExecutionFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(
            mut self,
            input: crate::model::ContinueAsNewWorkflowExecutionFailedCause,
        ) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::ContinueAsNewWorkflowExecutionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinueAsNewWorkflowExecutionFailedEventAttributes`](crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes {
            crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes {
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl ContinueAsNewWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`ContinueAsNewWorkflowExecutionFailedEventAttributes`](crate::model::ContinueAsNewWorkflowExecutionFailedEventAttributes)
    pub fn builder(
    ) -> crate::model::continue_as_new_workflow_execution_failed_event_attributes::Builder {
        crate::model::continue_as_new_workflow_execution_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContinueAsNewWorkflowExecutionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    ContinueAsNewWorkflowExecutionRateExceeded,
    #[allow(missing_docs)] // documentation missing in model
    DefaultChildPolicyUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultExecutionStartToCloseTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultTaskListUndefined,
    #[allow(missing_docs)] // documentation missing in model
    DefaultTaskStartToCloseTimeoutUndefined,
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    UnhandledDecision,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowTypeDeprecated,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowTypeDoesNotExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContinueAsNewWorkflowExecutionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED" => ContinueAsNewWorkflowExecutionFailedCause::ContinueAsNewWorkflowExecutionRateExceeded,
            "DEFAULT_CHILD_POLICY_UNDEFINED" => ContinueAsNewWorkflowExecutionFailedCause::DefaultChildPolicyUndefined,
            "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED" => ContinueAsNewWorkflowExecutionFailedCause::DefaultExecutionStartToCloseTimeoutUndefined,
            "DEFAULT_TASK_LIST_UNDEFINED" => ContinueAsNewWorkflowExecutionFailedCause::DefaultTaskListUndefined,
            "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED" => ContinueAsNewWorkflowExecutionFailedCause::DefaultTaskStartToCloseTimeoutUndefined,
            "OPERATION_NOT_PERMITTED" => ContinueAsNewWorkflowExecutionFailedCause::OperationNotPermitted,
            "UNHANDLED_DECISION" => ContinueAsNewWorkflowExecutionFailedCause::UnhandledDecision,
            "WORKFLOW_TYPE_DEPRECATED" => ContinueAsNewWorkflowExecutionFailedCause::WorkflowTypeDeprecated,
            "WORKFLOW_TYPE_DOES_NOT_EXIST" => ContinueAsNewWorkflowExecutionFailedCause::WorkflowTypeDoesNotExist,
            other => ContinueAsNewWorkflowExecutionFailedCause::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for ContinueAsNewWorkflowExecutionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContinueAsNewWorkflowExecutionFailedCause::from(s))
    }
}
impl ContinueAsNewWorkflowExecutionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContinueAsNewWorkflowExecutionFailedCause::ContinueAsNewWorkflowExecutionRateExceeded => "CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED",
            ContinueAsNewWorkflowExecutionFailedCause::DefaultChildPolicyUndefined => "DEFAULT_CHILD_POLICY_UNDEFINED",
            ContinueAsNewWorkflowExecutionFailedCause::DefaultExecutionStartToCloseTimeoutUndefined => "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            ContinueAsNewWorkflowExecutionFailedCause::DefaultTaskListUndefined => "DEFAULT_TASK_LIST_UNDEFINED",
            ContinueAsNewWorkflowExecutionFailedCause::DefaultTaskStartToCloseTimeoutUndefined => "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            ContinueAsNewWorkflowExecutionFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            ContinueAsNewWorkflowExecutionFailedCause::UnhandledDecision => "UNHANDLED_DECISION",
            ContinueAsNewWorkflowExecutionFailedCause::WorkflowTypeDeprecated => "WORKFLOW_TYPE_DEPRECATED",
            ContinueAsNewWorkflowExecutionFailedCause::WorkflowTypeDoesNotExist => "WORKFLOW_TYPE_DOES_NOT_EXIST",
            ContinueAsNewWorkflowExecutionFailedCause::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED",
            "DEFAULT_CHILD_POLICY_UNDEFINED",
            "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            "DEFAULT_TASK_LIST_UNDEFINED",
            "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED",
            "OPERATION_NOT_PERMITTED",
            "UNHANDLED_DECISION",
            "WORKFLOW_TYPE_DEPRECATED",
            "WORKFLOW_TYPE_DOES_NOT_EXIST",
        ]
    }
}
impl AsRef<str> for ContinueAsNewWorkflowExecutionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionContinuedAsNew</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionContinuedAsNewEventAttributes {
    /// <p>The input provided to the new workflow execution.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
    /// <p>The <code>runId</code> of the new workflow execution.</p>
    pub new_execution_run_id: std::option::Option<std::string::String>,
    /// <p>The total duration allowed for the new workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The task list to use for the decisions of the new (continued) workflow
    /// execution.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>The priority of the task to use for the decisions of the new (continued) workflow
    /// execution.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>The maximum duration of decision tasks for the new workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The policy to use for the child workflow executions of the new execution if it is terminated by calling the
    /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The list of tags associated with the new workflow execution.</p>
    pub tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The workflow type of this execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The IAM role to attach to the new (continued) workflow execution.</p>
    pub lambda_role: std::option::Option<std::string::String>,
}
impl WorkflowExecutionContinuedAsNewEventAttributes {
    /// <p>The input provided to the new workflow execution.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
    /// <p>The <code>runId</code> of the new workflow execution.</p>
    pub fn new_execution_run_id(&self) -> std::option::Option<&str> {
        self.new_execution_run_id.as_deref()
    }
    /// <p>The total duration allowed for the new workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.execution_start_to_close_timeout.as_deref()
    }
    /// <p>The task list to use for the decisions of the new (continued) workflow
    /// execution.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>The priority of the task to use for the decisions of the new (continued) workflow
    /// execution.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>The maximum duration of decision tasks for the new workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.task_start_to_close_timeout.as_deref()
    }
    /// <p>The policy to use for the child workflow executions of the new execution if it is terminated by calling the
    /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>The list of tags associated with the new workflow execution.</p>
    pub fn tag_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_list.as_deref()
    }
    /// <p>The workflow type of this execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The IAM role to attach to the new (continued) workflow execution.</p>
    pub fn lambda_role(&self) -> std::option::Option<&str> {
        self.lambda_role.as_deref()
    }
}
impl std::fmt::Debug for WorkflowExecutionContinuedAsNewEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionContinuedAsNewEventAttributes");
        formatter.field("input", &self.input);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.field("new_execution_run_id", &self.new_execution_run_id);
        formatter.field(
            "execution_start_to_close_timeout",
            &self.execution_start_to_close_timeout,
        );
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field(
            "task_start_to_close_timeout",
            &self.task_start_to_close_timeout,
        );
        formatter.field("child_policy", &self.child_policy);
        formatter.field("tag_list", &self.tag_list);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("lambda_role", &self.lambda_role);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionContinuedAsNewEventAttributes`](crate::model::WorkflowExecutionContinuedAsNewEventAttributes)
pub mod workflow_execution_continued_as_new_event_attributes {
    /// A builder for [`WorkflowExecutionContinuedAsNewEventAttributes`](crate::model::WorkflowExecutionContinuedAsNewEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
        pub(crate) new_execution_run_id: std::option::Option<std::string::String>,
        pub(crate) execution_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The input provided to the new workflow execution.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input provided to the new workflow execution.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// <p>The <code>runId</code> of the new workflow execution.</p>
        pub fn new_execution_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_execution_run_id = Some(input.into());
            self
        }
        /// <p>The <code>runId</code> of the new workflow execution.</p>
        pub fn set_new_execution_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_execution_run_id = input;
            self
        }
        /// <p>The total duration allowed for the new workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The total duration allowed for the new workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = input;
            self
        }
        /// <p>The task list to use for the decisions of the new (continued) workflow
        /// execution.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The task list to use for the decisions of the new (continued) workflow
        /// execution.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>The priority of the task to use for the decisions of the new (continued) workflow
        /// execution.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>The priority of the task to use for the decisions of the new (continued) workflow
        /// execution.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>The maximum duration of decision tasks for the new workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration of decision tasks for the new workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = input;
            self
        }
        /// <p>The policy to use for the child workflow executions of the new execution if it is terminated by calling the
        /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>The policy to use for the child workflow executions of the new execution if it is terminated by calling the
        /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags associated with the new workflow execution.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags associated with the new workflow execution.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>The workflow type of this execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The workflow type of this execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The IAM role to attach to the new (continued) workflow execution.</p>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_role = Some(input.into());
            self
        }
        /// <p>The IAM role to attach to the new (continued) workflow execution.</p>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionContinuedAsNewEventAttributes`](crate::model::WorkflowExecutionContinuedAsNewEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionContinuedAsNewEventAttributes {
            crate::model::WorkflowExecutionContinuedAsNewEventAttributes {
                input: self.input,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
                new_execution_run_id: self.new_execution_run_id,
                execution_start_to_close_timeout: self.execution_start_to_close_timeout,
                task_list: self.task_list,
                task_priority: self.task_priority,
                task_start_to_close_timeout: self.task_start_to_close_timeout,
                child_policy: self.child_policy,
                tag_list: self.tag_list,
                workflow_type: self.workflow_type,
                lambda_role: self.lambda_role,
            }
        }
    }
}
impl WorkflowExecutionContinuedAsNewEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionContinuedAsNewEventAttributes`](crate::model::WorkflowExecutionContinuedAsNewEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_continued_as_new_event_attributes::Builder
    {
        crate::model::workflow_execution_continued_as_new_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>CancelWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::CancelWorkflowExecutionFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl CancelWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::CancelWorkflowExecutionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for CancelWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelWorkflowExecutionFailedEventAttributes");
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`CancelWorkflowExecutionFailedEventAttributes`](crate::model::CancelWorkflowExecutionFailedEventAttributes)
pub mod cancel_workflow_execution_failed_event_attributes {
    /// A builder for [`CancelWorkflowExecutionFailedEventAttributes`](crate::model::CancelWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cause: std::option::Option<crate::model::CancelWorkflowExecutionFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::CancelWorkflowExecutionFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::CancelWorkflowExecutionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelWorkflowExecutionFailedEventAttributes`](crate::model::CancelWorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::CancelWorkflowExecutionFailedEventAttributes {
            crate::model::CancelWorkflowExecutionFailedEventAttributes {
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl CancelWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`CancelWorkflowExecutionFailedEventAttributes`](crate::model::CancelWorkflowExecutionFailedEventAttributes)
    pub fn builder() -> crate::model::cancel_workflow_execution_failed_event_attributes::Builder {
        crate::model::cancel_workflow_execution_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CancelWorkflowExecutionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    UnhandledDecision,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CancelWorkflowExecutionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPERATION_NOT_PERMITTED" => CancelWorkflowExecutionFailedCause::OperationNotPermitted,
            "UNHANDLED_DECISION" => CancelWorkflowExecutionFailedCause::UnhandledDecision,
            other => CancelWorkflowExecutionFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CancelWorkflowExecutionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CancelWorkflowExecutionFailedCause::from(s))
    }
}
impl CancelWorkflowExecutionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CancelWorkflowExecutionFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            CancelWorkflowExecutionFailedCause::UnhandledDecision => "UNHANDLED_DECISION",
            CancelWorkflowExecutionFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPERATION_NOT_PERMITTED", "UNHANDLED_DECISION"]
    }
}
impl AsRef<str> for CancelWorkflowExecutionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionCanceled</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionCanceledEventAttributes {
    /// <p>The details of the cancellation.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl WorkflowExecutionCanceledEventAttributes {
    /// <p>The details of the cancellation.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for WorkflowExecutionCanceledEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionCanceledEventAttributes");
        formatter.field("details", &self.details);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`WorkflowExecutionCanceledEventAttributes`](crate::model::WorkflowExecutionCanceledEventAttributes)
pub mod workflow_execution_canceled_event_attributes {
    /// A builder for [`WorkflowExecutionCanceledEventAttributes`](crate::model::WorkflowExecutionCanceledEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The details of the cancellation.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details of the cancellation.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionCanceledEventAttributes`](crate::model::WorkflowExecutionCanceledEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionCanceledEventAttributes {
            crate::model::WorkflowExecutionCanceledEventAttributes {
                details: self.details,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl WorkflowExecutionCanceledEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionCanceledEventAttributes`](crate::model::WorkflowExecutionCanceledEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_canceled_event_attributes::Builder {
        crate::model::workflow_execution_canceled_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionTimedOut</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionTimedOutEventAttributes {
    /// <p>The type of timeout that caused this event.</p>
    pub timeout_type: std::option::Option<crate::model::WorkflowExecutionTimeoutType>,
    /// <p>The policy used for the child workflow executions of this workflow execution.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
}
impl WorkflowExecutionTimedOutEventAttributes {
    /// <p>The type of timeout that caused this event.</p>
    pub fn timeout_type(&self) -> std::option::Option<&crate::model::WorkflowExecutionTimeoutType> {
        self.timeout_type.as_ref()
    }
    /// <p>The policy used for the child workflow executions of this workflow execution.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
}
impl std::fmt::Debug for WorkflowExecutionTimedOutEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionTimedOutEventAttributes");
        formatter.field("timeout_type", &self.timeout_type);
        formatter.field("child_policy", &self.child_policy);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionTimedOutEventAttributes`](crate::model::WorkflowExecutionTimedOutEventAttributes)
pub mod workflow_execution_timed_out_event_attributes {
    /// A builder for [`WorkflowExecutionTimedOutEventAttributes`](crate::model::WorkflowExecutionTimedOutEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_type: std::option::Option<crate::model::WorkflowExecutionTimeoutType>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
    }
    impl Builder {
        /// <p>The type of timeout that caused this event.</p>
        pub fn timeout_type(mut self, input: crate::model::WorkflowExecutionTimeoutType) -> Self {
            self.timeout_type = Some(input);
            self
        }
        /// <p>The type of timeout that caused this event.</p>
        pub fn set_timeout_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionTimeoutType>,
        ) -> Self {
            self.timeout_type = input;
            self
        }
        /// <p>The policy used for the child workflow executions of this workflow execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>The policy used for the child workflow executions of this workflow execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionTimedOutEventAttributes`](crate::model::WorkflowExecutionTimedOutEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionTimedOutEventAttributes {
            crate::model::WorkflowExecutionTimedOutEventAttributes {
                timeout_type: self.timeout_type,
                child_policy: self.child_policy,
            }
        }
    }
}
impl WorkflowExecutionTimedOutEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionTimedOutEventAttributes`](crate::model::WorkflowExecutionTimedOutEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_timed_out_event_attributes::Builder {
        crate::model::workflow_execution_timed_out_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>FailWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::FailWorkflowExecutionFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl FailWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(&self) -> std::option::Option<&crate::model::FailWorkflowExecutionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for FailWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailWorkflowExecutionFailedEventAttributes");
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`FailWorkflowExecutionFailedEventAttributes`](crate::model::FailWorkflowExecutionFailedEventAttributes)
pub mod fail_workflow_execution_failed_event_attributes {
    /// A builder for [`FailWorkflowExecutionFailedEventAttributes`](crate::model::FailWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cause: std::option::Option<crate::model::FailWorkflowExecutionFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::FailWorkflowExecutionFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::FailWorkflowExecutionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FailWorkflowExecutionFailedEventAttributes`](crate::model::FailWorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::FailWorkflowExecutionFailedEventAttributes {
            crate::model::FailWorkflowExecutionFailedEventAttributes {
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl FailWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`FailWorkflowExecutionFailedEventAttributes`](crate::model::FailWorkflowExecutionFailedEventAttributes)
    pub fn builder() -> crate::model::fail_workflow_execution_failed_event_attributes::Builder {
        crate::model::fail_workflow_execution_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailWorkflowExecutionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    UnhandledDecision,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailWorkflowExecutionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPERATION_NOT_PERMITTED" => FailWorkflowExecutionFailedCause::OperationNotPermitted,
            "UNHANDLED_DECISION" => FailWorkflowExecutionFailedCause::UnhandledDecision,
            other => FailWorkflowExecutionFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailWorkflowExecutionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailWorkflowExecutionFailedCause::from(s))
    }
}
impl FailWorkflowExecutionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailWorkflowExecutionFailedCause::OperationNotPermitted => "OPERATION_NOT_PERMITTED",
            FailWorkflowExecutionFailedCause::UnhandledDecision => "UNHANDLED_DECISION",
            FailWorkflowExecutionFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPERATION_NOT_PERMITTED", "UNHANDLED_DECISION"]
    }
}
impl AsRef<str> for FailWorkflowExecutionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionFailedEventAttributes {
    /// <p>The descriptive reason provided for the failure.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The details of the failure.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl WorkflowExecutionFailedEventAttributes {
    /// <p>The descriptive reason provided for the failure.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The details of the failure.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for WorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionFailedEventAttributes");
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`WorkflowExecutionFailedEventAttributes`](crate::model::WorkflowExecutionFailedEventAttributes)
pub mod workflow_execution_failed_event_attributes {
    /// A builder for [`WorkflowExecutionFailedEventAttributes`](crate::model::WorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The descriptive reason provided for the failure.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The descriptive reason provided for the failure.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The details of the failure.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details of the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>FailWorkflowExecution</code> decision to fail this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionFailedEventAttributes`](crate::model::WorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionFailedEventAttributes {
            crate::model::WorkflowExecutionFailedEventAttributes {
                reason: self.reason,
                details: self.details,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl WorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionFailedEventAttributes`](crate::model::WorkflowExecutionFailedEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_failed_event_attributes::Builder {
        crate::model::workflow_execution_failed_event_attributes::Builder::default()
    }
}

/// <p>Provides the details of the <code>CompleteWorkflowExecutionFailed</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub cause: std::option::Option<crate::model::CompleteWorkflowExecutionFailedCause>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl CompleteWorkflowExecutionFailedEventAttributes {
    /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
    /// <note>
    /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
    /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
    /// in the <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn cause(
        &self,
    ) -> std::option::Option<&crate::model::CompleteWorkflowExecutionFailedCause> {
        self.cause.as_ref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for CompleteWorkflowExecutionFailedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteWorkflowExecutionFailedEventAttributes");
        formatter.field("cause", &self.cause);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`CompleteWorkflowExecutionFailedEventAttributes`](crate::model::CompleteWorkflowExecutionFailedEventAttributes)
pub mod complete_workflow_execution_failed_event_attributes {
    /// A builder for [`CompleteWorkflowExecutionFailedEventAttributes`](crate::model::CompleteWorkflowExecutionFailedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cause: std::option::Option<crate::model::CompleteWorkflowExecutionFailedCause>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn cause(mut self, input: crate::model::CompleteWorkflowExecutionFailedCause) -> Self {
            self.cause = Some(input);
            self
        }
        /// <p>The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.</p>
        /// <note>
        /// <p>If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed
        /// because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows</a>
        /// in the <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_cause(
            mut self,
            input: std::option::Option<crate::model::CompleteWorkflowExecutionFailedCause>,
        ) -> Self {
            self.cause = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteWorkflowExecutionFailedEventAttributes`](crate::model::CompleteWorkflowExecutionFailedEventAttributes)
        pub fn build(self) -> crate::model::CompleteWorkflowExecutionFailedEventAttributes {
            crate::model::CompleteWorkflowExecutionFailedEventAttributes {
                cause: self.cause,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl CompleteWorkflowExecutionFailedEventAttributes {
    /// Creates a new builder-style object to manufacture [`CompleteWorkflowExecutionFailedEventAttributes`](crate::model::CompleteWorkflowExecutionFailedEventAttributes)
    pub fn builder() -> crate::model::complete_workflow_execution_failed_event_attributes::Builder {
        crate::model::complete_workflow_execution_failed_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CompleteWorkflowExecutionFailedCause {
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    UnhandledDecision,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CompleteWorkflowExecutionFailedCause {
    fn from(s: &str) -> Self {
        match s {
            "OPERATION_NOT_PERMITTED" => {
                CompleteWorkflowExecutionFailedCause::OperationNotPermitted
            }
            "UNHANDLED_DECISION" => CompleteWorkflowExecutionFailedCause::UnhandledDecision,
            other => CompleteWorkflowExecutionFailedCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CompleteWorkflowExecutionFailedCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CompleteWorkflowExecutionFailedCause::from(s))
    }
}
impl CompleteWorkflowExecutionFailedCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CompleteWorkflowExecutionFailedCause::OperationNotPermitted => {
                "OPERATION_NOT_PERMITTED"
            }
            CompleteWorkflowExecutionFailedCause::UnhandledDecision => "UNHANDLED_DECISION",
            CompleteWorkflowExecutionFailedCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPERATION_NOT_PERMITTED", "UNHANDLED_DECISION"]
    }
}
impl AsRef<str> for CompleteWorkflowExecutionFailedCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of the <code>WorkflowExecutionCompleted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionCompletedEventAttributes {
    /// <p>The result produced by the workflow execution upon successful completion.</p>
    pub result: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub decision_task_completed_event_id: i64,
}
impl WorkflowExecutionCompletedEventAttributes {
    /// <p>The result produced by the workflow execution upon successful completion.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
    /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
    /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn decision_task_completed_event_id(&self) -> i64 {
        self.decision_task_completed_event_id
    }
}
impl std::fmt::Debug for WorkflowExecutionCompletedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionCompletedEventAttributes");
        formatter.field("result", &self.result);
        formatter.field(
            "decision_task_completed_event_id",
            &self.decision_task_completed_event_id,
        );
        formatter.finish()
    }
}
/// See [`WorkflowExecutionCompletedEventAttributes`](crate::model::WorkflowExecutionCompletedEventAttributes)
pub mod workflow_execution_completed_event_attributes {
    /// A builder for [`WorkflowExecutionCompletedEventAttributes`](crate::model::WorkflowExecutionCompletedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result: std::option::Option<std::string::String>,
        pub(crate) decision_task_completed_event_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The result produced by the workflow execution upon successful completion.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>The result produced by the workflow execution upon successful completion.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn decision_task_completed_event_id(mut self, input: i64) -> Self {
            self.decision_task_completed_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
        /// <code>CompleteWorkflowExecution</code> decision to complete this execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_decision_task_completed_event_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.decision_task_completed_event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionCompletedEventAttributes`](crate::model::WorkflowExecutionCompletedEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionCompletedEventAttributes {
            crate::model::WorkflowExecutionCompletedEventAttributes {
                result: self.result,
                decision_task_completed_event_id: self
                    .decision_task_completed_event_id
                    .unwrap_or_default(),
            }
        }
    }
}
impl WorkflowExecutionCompletedEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionCompletedEventAttributes`](crate::model::WorkflowExecutionCompletedEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_completed_event_attributes::Builder {
        crate::model::workflow_execution_completed_event_attributes::Builder::default()
    }
}

/// <p>Provides details of <code>WorkflowExecutionStarted</code> event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionStartedEventAttributes {
    /// <p>The input provided to the workflow execution.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The maximum duration for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The maximum duration of decision tasks for this workflow type.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
    /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The name of the task list for scheduling the decision tasks for this workflow execution.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>The priority of the decision tasks in the workflow execution.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>The workflow type of this execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The list of tags associated with this workflow execution. An execution can have up to 5 tags.</p>
    pub tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
    /// contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
    /// execution.</p>
    pub continued_execution_run_id: std::option::Option<std::string::String>,
    /// <p>The source workflow execution that started this workflow execution. The member isn't set if the workflow execution was not started by a workflow.</p>
    pub parent_workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this workflow execution. The source event with
    /// this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub parent_initiated_event_id: i64,
    /// <p>The IAM role attached to the workflow execution.</p>
    pub lambda_role: std::option::Option<std::string::String>,
}
impl WorkflowExecutionStartedEventAttributes {
    /// <p>The input provided to the workflow execution.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The maximum duration for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.execution_start_to_close_timeout.as_deref()
    }
    /// <p>The maximum duration of decision tasks for this workflow type.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.task_start_to_close_timeout.as_deref()
    }
    /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
    /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>The name of the task list for scheduling the decision tasks for this workflow execution.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>The priority of the decision tasks in the workflow execution.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>The workflow type of this execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The list of tags associated with this workflow execution. An execution can have up to 5 tags.</p>
    pub fn tag_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_list.as_deref()
    }
    /// <p>If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
    /// contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
    /// execution.</p>
    pub fn continued_execution_run_id(&self) -> std::option::Option<&str> {
        self.continued_execution_run_id.as_deref()
    }
    /// <p>The source workflow execution that started this workflow execution. The member isn't set if the workflow execution was not started by a workflow.</p>
    pub fn parent_workflow_execution(
        &self,
    ) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.parent_workflow_execution.as_ref()
    }
    /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a> to start this workflow execution. The source event with
    /// this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
    /// events leading up to this event.</p>
    pub fn parent_initiated_event_id(&self) -> i64 {
        self.parent_initiated_event_id
    }
    /// <p>The IAM role attached to the workflow execution.</p>
    pub fn lambda_role(&self) -> std::option::Option<&str> {
        self.lambda_role.as_deref()
    }
}
impl std::fmt::Debug for WorkflowExecutionStartedEventAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionStartedEventAttributes");
        formatter.field("input", &self.input);
        formatter.field(
            "execution_start_to_close_timeout",
            &self.execution_start_to_close_timeout,
        );
        formatter.field(
            "task_start_to_close_timeout",
            &self.task_start_to_close_timeout,
        );
        formatter.field("child_policy", &self.child_policy);
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("tag_list", &self.tag_list);
        formatter.field(
            "continued_execution_run_id",
            &self.continued_execution_run_id,
        );
        formatter.field("parent_workflow_execution", &self.parent_workflow_execution);
        formatter.field("parent_initiated_event_id", &self.parent_initiated_event_id);
        formatter.field("lambda_role", &self.lambda_role);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionStartedEventAttributes`](crate::model::WorkflowExecutionStartedEventAttributes)
pub mod workflow_execution_started_event_attributes {
    /// A builder for [`WorkflowExecutionStartedEventAttributes`](crate::model::WorkflowExecutionStartedEventAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) execution_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) continued_execution_run_id: std::option::Option<std::string::String>,
        pub(crate) parent_workflow_execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) parent_initiated_event_id: std::option::Option<i64>,
        pub(crate) lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The input provided to the workflow execution.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input provided to the workflow execution.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The maximum duration for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = input;
            self
        }
        /// <p>The maximum duration of decision tasks for this workflow type.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration of decision tasks for this workflow type.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = input;
            self
        }
        /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
        /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
        /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// <p>The name of the task list for scheduling the decision tasks for this workflow execution.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The name of the task list for scheduling the decision tasks for this workflow execution.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>The priority of the decision tasks in the workflow execution.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>The priority of the decision tasks in the workflow execution.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>The workflow type of this execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The workflow type of this execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags associated with this workflow execution. An execution can have up to 5 tags.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags associated with this workflow execution. An execution can have up to 5 tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
        /// contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
        /// execution.</p>
        pub fn continued_execution_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.continued_execution_run_id = Some(input.into());
            self
        }
        /// <p>If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
        /// contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
        /// execution.</p>
        pub fn set_continued_execution_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continued_execution_run_id = input;
            self
        }
        /// <p>The source workflow execution that started this workflow execution. The member isn't set if the workflow execution was not started by a workflow.</p>
        pub fn parent_workflow_execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.parent_workflow_execution = Some(input);
            self
        }
        /// <p>The source workflow execution that started this workflow execution. The member isn't set if the workflow execution was not started by a workflow.</p>
        pub fn set_parent_workflow_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.parent_workflow_execution = input;
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this workflow execution. The source event with
        /// this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn parent_initiated_event_id(mut self, input: i64) -> Self {
            self.parent_initiated_event_id = Some(input);
            self
        }
        /// <p>The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a> to start this workflow execution. The source event with
        /// this ID can be found in the history of the source workflow execution. This information can be useful for diagnosing problems by tracing back the chain of
        /// events leading up to this event.</p>
        pub fn set_parent_initiated_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.parent_initiated_event_id = input;
            self
        }
        /// <p>The IAM role attached to the workflow execution.</p>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_role = Some(input.into());
            self
        }
        /// <p>The IAM role attached to the workflow execution.</p>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionStartedEventAttributes`](crate::model::WorkflowExecutionStartedEventAttributes)
        pub fn build(self) -> crate::model::WorkflowExecutionStartedEventAttributes {
            crate::model::WorkflowExecutionStartedEventAttributes {
                input: self.input,
                execution_start_to_close_timeout: self.execution_start_to_close_timeout,
                task_start_to_close_timeout: self.task_start_to_close_timeout,
                child_policy: self.child_policy,
                task_list: self.task_list,
                task_priority: self.task_priority,
                workflow_type: self.workflow_type,
                tag_list: self.tag_list,
                continued_execution_run_id: self.continued_execution_run_id,
                parent_workflow_execution: self.parent_workflow_execution,
                parent_initiated_event_id: self.parent_initiated_event_id.unwrap_or_default(),
                lambda_role: self.lambda_role,
            }
        }
    }
}
impl WorkflowExecutionStartedEventAttributes {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionStartedEventAttributes`](crate::model::WorkflowExecutionStartedEventAttributes)
    pub fn builder() -> crate::model::workflow_execution_started_event_attributes::Builder {
        crate::model::workflow_execution_started_event_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    ActivityTaskCancelRequested,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTaskCanceled,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTaskCompleted,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTaskFailed,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTaskScheduled,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTaskStarted,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTaskTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    CancelTimerFailed,
    #[allow(missing_docs)] // documentation missing in model
    CancelWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ChildWorkflowExecutionCanceled,
    #[allow(missing_docs)] // documentation missing in model
    ChildWorkflowExecutionCompleted,
    #[allow(missing_docs)] // documentation missing in model
    ChildWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ChildWorkflowExecutionStarted,
    #[allow(missing_docs)] // documentation missing in model
    ChildWorkflowExecutionTerminated,
    #[allow(missing_docs)] // documentation missing in model
    ChildWorkflowExecutionTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    CompleteWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ContinueAsNewWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    DecisionTaskCompleted,
    #[allow(missing_docs)] // documentation missing in model
    DecisionTaskScheduled,
    #[allow(missing_docs)] // documentation missing in model
    DecisionTaskStarted,
    #[allow(missing_docs)] // documentation missing in model
    DecisionTaskTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    ExternalWorkflowExecutionCancelRequested,
    #[allow(missing_docs)] // documentation missing in model
    ExternalWorkflowExecutionSignaled,
    #[allow(missing_docs)] // documentation missing in model
    FailWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionCompleted,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionFailed,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionScheduled,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionStarted,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    MarkerRecorded,
    #[allow(missing_docs)] // documentation missing in model
    RecordMarkerFailed,
    #[allow(missing_docs)] // documentation missing in model
    RequestCancelActivityTaskFailed,
    #[allow(missing_docs)] // documentation missing in model
    RequestCancelExternalWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    RequestCancelExternalWorkflowExecutionInitiated,
    #[allow(missing_docs)] // documentation missing in model
    ScheduleActivityTaskFailed,
    #[allow(missing_docs)] // documentation missing in model
    ScheduleLambdaFunctionFailed,
    #[allow(missing_docs)] // documentation missing in model
    SignalExternalWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    SignalExternalWorkflowExecutionInitiated,
    #[allow(missing_docs)] // documentation missing in model
    StartChildWorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    StartChildWorkflowExecutionInitiated,
    #[allow(missing_docs)] // documentation missing in model
    StartLambdaFunctionFailed,
    #[allow(missing_docs)] // documentation missing in model
    StartTimerFailed,
    #[allow(missing_docs)] // documentation missing in model
    TimerCanceled,
    #[allow(missing_docs)] // documentation missing in model
    TimerFired,
    #[allow(missing_docs)] // documentation missing in model
    TimerStarted,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionCancelRequested,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionCanceled,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionCompleted,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionContinuedAsNew,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionSignaled,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionStarted,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionTerminated,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowExecutionTimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "ActivityTaskCancelRequested" => EventType::ActivityTaskCancelRequested,
            "ActivityTaskCanceled" => EventType::ActivityTaskCanceled,
            "ActivityTaskCompleted" => EventType::ActivityTaskCompleted,
            "ActivityTaskFailed" => EventType::ActivityTaskFailed,
            "ActivityTaskScheduled" => EventType::ActivityTaskScheduled,
            "ActivityTaskStarted" => EventType::ActivityTaskStarted,
            "ActivityTaskTimedOut" => EventType::ActivityTaskTimedOut,
            "CancelTimerFailed" => EventType::CancelTimerFailed,
            "CancelWorkflowExecutionFailed" => EventType::CancelWorkflowExecutionFailed,
            "ChildWorkflowExecutionCanceled" => EventType::ChildWorkflowExecutionCanceled,
            "ChildWorkflowExecutionCompleted" => EventType::ChildWorkflowExecutionCompleted,
            "ChildWorkflowExecutionFailed" => EventType::ChildWorkflowExecutionFailed,
            "ChildWorkflowExecutionStarted" => EventType::ChildWorkflowExecutionStarted,
            "ChildWorkflowExecutionTerminated" => EventType::ChildWorkflowExecutionTerminated,
            "ChildWorkflowExecutionTimedOut" => EventType::ChildWorkflowExecutionTimedOut,
            "CompleteWorkflowExecutionFailed" => EventType::CompleteWorkflowExecutionFailed,
            "ContinueAsNewWorkflowExecutionFailed" => {
                EventType::ContinueAsNewWorkflowExecutionFailed
            }
            "DecisionTaskCompleted" => EventType::DecisionTaskCompleted,
            "DecisionTaskScheduled" => EventType::DecisionTaskScheduled,
            "DecisionTaskStarted" => EventType::DecisionTaskStarted,
            "DecisionTaskTimedOut" => EventType::DecisionTaskTimedOut,
            "ExternalWorkflowExecutionCancelRequested" => {
                EventType::ExternalWorkflowExecutionCancelRequested
            }
            "ExternalWorkflowExecutionSignaled" => EventType::ExternalWorkflowExecutionSignaled,
            "FailWorkflowExecutionFailed" => EventType::FailWorkflowExecutionFailed,
            "LambdaFunctionCompleted" => EventType::LambdaFunctionCompleted,
            "LambdaFunctionFailed" => EventType::LambdaFunctionFailed,
            "LambdaFunctionScheduled" => EventType::LambdaFunctionScheduled,
            "LambdaFunctionStarted" => EventType::LambdaFunctionStarted,
            "LambdaFunctionTimedOut" => EventType::LambdaFunctionTimedOut,
            "MarkerRecorded" => EventType::MarkerRecorded,
            "RecordMarkerFailed" => EventType::RecordMarkerFailed,
            "RequestCancelActivityTaskFailed" => EventType::RequestCancelActivityTaskFailed,
            "RequestCancelExternalWorkflowExecutionFailed" => {
                EventType::RequestCancelExternalWorkflowExecutionFailed
            }
            "RequestCancelExternalWorkflowExecutionInitiated" => {
                EventType::RequestCancelExternalWorkflowExecutionInitiated
            }
            "ScheduleActivityTaskFailed" => EventType::ScheduleActivityTaskFailed,
            "ScheduleLambdaFunctionFailed" => EventType::ScheduleLambdaFunctionFailed,
            "SignalExternalWorkflowExecutionFailed" => {
                EventType::SignalExternalWorkflowExecutionFailed
            }
            "SignalExternalWorkflowExecutionInitiated" => {
                EventType::SignalExternalWorkflowExecutionInitiated
            }
            "StartChildWorkflowExecutionFailed" => EventType::StartChildWorkflowExecutionFailed,
            "StartChildWorkflowExecutionInitiated" => {
                EventType::StartChildWorkflowExecutionInitiated
            }
            "StartLambdaFunctionFailed" => EventType::StartLambdaFunctionFailed,
            "StartTimerFailed" => EventType::StartTimerFailed,
            "TimerCanceled" => EventType::TimerCanceled,
            "TimerFired" => EventType::TimerFired,
            "TimerStarted" => EventType::TimerStarted,
            "WorkflowExecutionCancelRequested" => EventType::WorkflowExecutionCancelRequested,
            "WorkflowExecutionCanceled" => EventType::WorkflowExecutionCanceled,
            "WorkflowExecutionCompleted" => EventType::WorkflowExecutionCompleted,
            "WorkflowExecutionContinuedAsNew" => EventType::WorkflowExecutionContinuedAsNew,
            "WorkflowExecutionFailed" => EventType::WorkflowExecutionFailed,
            "WorkflowExecutionSignaled" => EventType::WorkflowExecutionSignaled,
            "WorkflowExecutionStarted" => EventType::WorkflowExecutionStarted,
            "WorkflowExecutionTerminated" => EventType::WorkflowExecutionTerminated,
            "WorkflowExecutionTimedOut" => EventType::WorkflowExecutionTimedOut,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::ActivityTaskCancelRequested => "ActivityTaskCancelRequested",
            EventType::ActivityTaskCanceled => "ActivityTaskCanceled",
            EventType::ActivityTaskCompleted => "ActivityTaskCompleted",
            EventType::ActivityTaskFailed => "ActivityTaskFailed",
            EventType::ActivityTaskScheduled => "ActivityTaskScheduled",
            EventType::ActivityTaskStarted => "ActivityTaskStarted",
            EventType::ActivityTaskTimedOut => "ActivityTaskTimedOut",
            EventType::CancelTimerFailed => "CancelTimerFailed",
            EventType::CancelWorkflowExecutionFailed => "CancelWorkflowExecutionFailed",
            EventType::ChildWorkflowExecutionCanceled => "ChildWorkflowExecutionCanceled",
            EventType::ChildWorkflowExecutionCompleted => "ChildWorkflowExecutionCompleted",
            EventType::ChildWorkflowExecutionFailed => "ChildWorkflowExecutionFailed",
            EventType::ChildWorkflowExecutionStarted => "ChildWorkflowExecutionStarted",
            EventType::ChildWorkflowExecutionTerminated => "ChildWorkflowExecutionTerminated",
            EventType::ChildWorkflowExecutionTimedOut => "ChildWorkflowExecutionTimedOut",
            EventType::CompleteWorkflowExecutionFailed => "CompleteWorkflowExecutionFailed",
            EventType::ContinueAsNewWorkflowExecutionFailed => {
                "ContinueAsNewWorkflowExecutionFailed"
            }
            EventType::DecisionTaskCompleted => "DecisionTaskCompleted",
            EventType::DecisionTaskScheduled => "DecisionTaskScheduled",
            EventType::DecisionTaskStarted => "DecisionTaskStarted",
            EventType::DecisionTaskTimedOut => "DecisionTaskTimedOut",
            EventType::ExternalWorkflowExecutionCancelRequested => {
                "ExternalWorkflowExecutionCancelRequested"
            }
            EventType::ExternalWorkflowExecutionSignaled => "ExternalWorkflowExecutionSignaled",
            EventType::FailWorkflowExecutionFailed => "FailWorkflowExecutionFailed",
            EventType::LambdaFunctionCompleted => "LambdaFunctionCompleted",
            EventType::LambdaFunctionFailed => "LambdaFunctionFailed",
            EventType::LambdaFunctionScheduled => "LambdaFunctionScheduled",
            EventType::LambdaFunctionStarted => "LambdaFunctionStarted",
            EventType::LambdaFunctionTimedOut => "LambdaFunctionTimedOut",
            EventType::MarkerRecorded => "MarkerRecorded",
            EventType::RecordMarkerFailed => "RecordMarkerFailed",
            EventType::RequestCancelActivityTaskFailed => "RequestCancelActivityTaskFailed",
            EventType::RequestCancelExternalWorkflowExecutionFailed => {
                "RequestCancelExternalWorkflowExecutionFailed"
            }
            EventType::RequestCancelExternalWorkflowExecutionInitiated => {
                "RequestCancelExternalWorkflowExecutionInitiated"
            }
            EventType::ScheduleActivityTaskFailed => "ScheduleActivityTaskFailed",
            EventType::ScheduleLambdaFunctionFailed => "ScheduleLambdaFunctionFailed",
            EventType::SignalExternalWorkflowExecutionFailed => {
                "SignalExternalWorkflowExecutionFailed"
            }
            EventType::SignalExternalWorkflowExecutionInitiated => {
                "SignalExternalWorkflowExecutionInitiated"
            }
            EventType::StartChildWorkflowExecutionFailed => "StartChildWorkflowExecutionFailed",
            EventType::StartChildWorkflowExecutionInitiated => {
                "StartChildWorkflowExecutionInitiated"
            }
            EventType::StartLambdaFunctionFailed => "StartLambdaFunctionFailed",
            EventType::StartTimerFailed => "StartTimerFailed",
            EventType::TimerCanceled => "TimerCanceled",
            EventType::TimerFired => "TimerFired",
            EventType::TimerStarted => "TimerStarted",
            EventType::WorkflowExecutionCancelRequested => "WorkflowExecutionCancelRequested",
            EventType::WorkflowExecutionCanceled => "WorkflowExecutionCanceled",
            EventType::WorkflowExecutionCompleted => "WorkflowExecutionCompleted",
            EventType::WorkflowExecutionContinuedAsNew => "WorkflowExecutionContinuedAsNew",
            EventType::WorkflowExecutionFailed => "WorkflowExecutionFailed",
            EventType::WorkflowExecutionSignaled => "WorkflowExecutionSignaled",
            EventType::WorkflowExecutionStarted => "WorkflowExecutionStarted",
            EventType::WorkflowExecutionTerminated => "WorkflowExecutionTerminated",
            EventType::WorkflowExecutionTimedOut => "WorkflowExecutionTimedOut",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ActivityTaskCancelRequested",
            "ActivityTaskCanceled",
            "ActivityTaskCompleted",
            "ActivityTaskFailed",
            "ActivityTaskScheduled",
            "ActivityTaskStarted",
            "ActivityTaskTimedOut",
            "CancelTimerFailed",
            "CancelWorkflowExecutionFailed",
            "ChildWorkflowExecutionCanceled",
            "ChildWorkflowExecutionCompleted",
            "ChildWorkflowExecutionFailed",
            "ChildWorkflowExecutionStarted",
            "ChildWorkflowExecutionTerminated",
            "ChildWorkflowExecutionTimedOut",
            "CompleteWorkflowExecutionFailed",
            "ContinueAsNewWorkflowExecutionFailed",
            "DecisionTaskCompleted",
            "DecisionTaskScheduled",
            "DecisionTaskStarted",
            "DecisionTaskTimedOut",
            "ExternalWorkflowExecutionCancelRequested",
            "ExternalWorkflowExecutionSignaled",
            "FailWorkflowExecutionFailed",
            "LambdaFunctionCompleted",
            "LambdaFunctionFailed",
            "LambdaFunctionScheduled",
            "LambdaFunctionStarted",
            "LambdaFunctionTimedOut",
            "MarkerRecorded",
            "RecordMarkerFailed",
            "RequestCancelActivityTaskFailed",
            "RequestCancelExternalWorkflowExecutionFailed",
            "RequestCancelExternalWorkflowExecutionInitiated",
            "ScheduleActivityTaskFailed",
            "ScheduleLambdaFunctionFailed",
            "SignalExternalWorkflowExecutionFailed",
            "SignalExternalWorkflowExecutionInitiated",
            "StartChildWorkflowExecutionFailed",
            "StartChildWorkflowExecutionInitiated",
            "StartLambdaFunctionFailed",
            "StartTimerFailed",
            "TimerCanceled",
            "TimerFired",
            "TimerStarted",
            "WorkflowExecutionCancelRequested",
            "WorkflowExecutionCanceled",
            "WorkflowExecutionCompleted",
            "WorkflowExecutionContinuedAsNew",
            "WorkflowExecutionFailed",
            "WorkflowExecutionSignaled",
            "WorkflowExecutionStarted",
            "WorkflowExecutionTerminated",
            "WorkflowExecutionTimedOut",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a workflow type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowTypeInfo {
    /// <p>The workflow type this information is about.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The current status of the workflow type.</p>
    pub status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>The description of the type registered through <a>RegisterWorkflowType</a>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date when this type was registered.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the type is in deprecated state, then it is set to the date when the type was deprecated.</p>
    pub deprecation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl WorkflowTypeInfo {
    /// <p>The workflow type this information is about.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The current status of the workflow type.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.status.as_ref()
    }
    /// <p>The description of the type registered through <a>RegisterWorkflowType</a>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date when this type was registered.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>If the type is in deprecated state, then it is set to the date when the type was deprecated.</p>
    pub fn deprecation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deprecation_date.as_ref()
    }
}
impl std::fmt::Debug for WorkflowTypeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowTypeInfo");
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("deprecation_date", &self.deprecation_date);
        formatter.finish()
    }
}
/// See [`WorkflowTypeInfo`](crate::model::WorkflowTypeInfo)
pub mod workflow_type_info {
    /// A builder for [`WorkflowTypeInfo`](crate::model::WorkflowTypeInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deprecation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The workflow type this information is about.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The workflow type this information is about.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The current status of the workflow type.</p>
        pub fn status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the workflow type.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the type registered through <a>RegisterWorkflowType</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the type registered through <a>RegisterWorkflowType</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date when this type was registered.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when this type was registered.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>If the type is in deprecated state, then it is set to the date when the type was deprecated.</p>
        pub fn deprecation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deprecation_date = Some(input);
            self
        }
        /// <p>If the type is in deprecated state, then it is set to the date when the type was deprecated.</p>
        pub fn set_deprecation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deprecation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowTypeInfo`](crate::model::WorkflowTypeInfo)
        pub fn build(self) -> crate::model::WorkflowTypeInfo {
            crate::model::WorkflowTypeInfo {
                workflow_type: self.workflow_type,
                status: self.status,
                description: self.description,
                creation_date: self.creation_date,
                deprecation_date: self.deprecation_date,
            }
        }
    }
}
impl WorkflowTypeInfo {
    /// Creates a new builder-style object to manufacture [`WorkflowTypeInfo`](crate::model::WorkflowTypeInfo)
    pub fn builder() -> crate::model::workflow_type_info::Builder {
        crate::model::workflow_type_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegistrationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegistrationStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEPRECATED" => RegistrationStatus::Deprecated,
            "REGISTERED" => RegistrationStatus::Registered,
            other => RegistrationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegistrationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegistrationStatus::from(s))
    }
}
impl RegistrationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegistrationStatus::Deprecated => "DEPRECATED",
            RegistrationStatus::Registered => "REGISTERED",
            RegistrationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPRECATED", "REGISTERED"]
    }
}
impl AsRef<str> for RegistrationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a workflow execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionInfo {
    /// <p>The workflow execution this information is about.</p>
    pub execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The type of the workflow execution.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The time when the execution was started.</p>
    pub start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the workflow execution was closed. Set only if the execution status is CLOSED.</p>
    pub close_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the execution.</p>
    pub execution_status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>If the execution status is closed then this specifies how the execution was closed:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> – the execution was successfully completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELED</code> – the execution was canceled.Cancellation allows the implementation to gracefully clean
    /// up before the execution is closed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TERMINATED</code> – the execution was force terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – the execution failed to complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIMED_OUT</code> – the execution did not complete in the alloted time and was automatically timed
    /// out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONTINUED_AS_NEW</code> – the execution is logically continued. This means the current execution was
    /// completed and a new execution was started to carry on the workflow.</p>
    /// </li>
    /// </ul>
    pub close_status: std::option::Option<crate::model::CloseStatus>,
    /// <p>If this workflow execution is a child of another execution then contains the workflow execution that started this execution.</p>
    pub parent: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>The list of tags associated with the workflow execution. Tags can be used to identify and list workflow executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.</p>
    pub tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Set to true if a cancellation is requested for this workflow execution.</p>
    pub cancel_requested: bool,
}
impl WorkflowExecutionInfo {
    /// <p>The workflow execution this information is about.</p>
    pub fn execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.execution.as_ref()
    }
    /// <p>The type of the workflow execution.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The time when the execution was started.</p>
    pub fn start_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_timestamp.as_ref()
    }
    /// <p>The time when the workflow execution was closed. Set only if the execution status is CLOSED.</p>
    pub fn close_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.close_timestamp.as_ref()
    }
    /// <p>The current status of the execution.</p>
    pub fn execution_status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.execution_status.as_ref()
    }
    /// <p>If the execution status is closed then this specifies how the execution was closed:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> – the execution was successfully completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELED</code> – the execution was canceled.Cancellation allows the implementation to gracefully clean
    /// up before the execution is closed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TERMINATED</code> – the execution was force terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – the execution failed to complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIMED_OUT</code> – the execution did not complete in the alloted time and was automatically timed
    /// out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONTINUED_AS_NEW</code> – the execution is logically continued. This means the current execution was
    /// completed and a new execution was started to carry on the workflow.</p>
    /// </li>
    /// </ul>
    pub fn close_status(&self) -> std::option::Option<&crate::model::CloseStatus> {
        self.close_status.as_ref()
    }
    /// <p>If this workflow execution is a child of another execution then contains the workflow execution that started this execution.</p>
    pub fn parent(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.parent.as_ref()
    }
    /// <p>The list of tags associated with the workflow execution. Tags can be used to identify and list workflow executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.</p>
    pub fn tag_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_list.as_deref()
    }
    /// <p>Set to true if a cancellation is requested for this workflow execution.</p>
    pub fn cancel_requested(&self) -> bool {
        self.cancel_requested
    }
}
impl std::fmt::Debug for WorkflowExecutionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionInfo");
        formatter.field("execution", &self.execution);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("start_timestamp", &self.start_timestamp);
        formatter.field("close_timestamp", &self.close_timestamp);
        formatter.field("execution_status", &self.execution_status);
        formatter.field("close_status", &self.close_status);
        formatter.field("parent", &self.parent);
        formatter.field("tag_list", &self.tag_list);
        formatter.field("cancel_requested", &self.cancel_requested);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionInfo`](crate::model::WorkflowExecutionInfo)
pub mod workflow_execution_info {
    /// A builder for [`WorkflowExecutionInfo`](crate::model::WorkflowExecutionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) close_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) execution_status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) close_status: std::option::Option<crate::model::CloseStatus>,
        pub(crate) parent: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cancel_requested: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The workflow execution this information is about.</p>
        pub fn execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.execution = Some(input);
            self
        }
        /// <p>The workflow execution this information is about.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// <p>The type of the workflow execution.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the workflow execution.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The time when the execution was started.</p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_timestamp = Some(input);
            self
        }
        /// <p>The time when the execution was started.</p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_timestamp = input;
            self
        }
        /// <p>The time when the workflow execution was closed. Set only if the execution status is CLOSED.</p>
        pub fn close_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.close_timestamp = Some(input);
            self
        }
        /// <p>The time when the workflow execution was closed. Set only if the execution status is CLOSED.</p>
        pub fn set_close_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.close_timestamp = input;
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn execution_status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.execution_status = Some(input);
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn set_execution_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.execution_status = input;
            self
        }
        /// <p>If the execution status is closed then this specifies how the execution was closed:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> – the execution was successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELED</code> – the execution was canceled.Cancellation allows the implementation to gracefully clean
        /// up before the execution is closed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATED</code> – the execution was force terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – the execution failed to complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIMED_OUT</code> – the execution did not complete in the alloted time and was automatically timed
        /// out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONTINUED_AS_NEW</code> – the execution is logically continued. This means the current execution was
        /// completed and a new execution was started to carry on the workflow.</p>
        /// </li>
        /// </ul>
        pub fn close_status(mut self, input: crate::model::CloseStatus) -> Self {
            self.close_status = Some(input);
            self
        }
        /// <p>If the execution status is closed then this specifies how the execution was closed:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> – the execution was successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELED</code> – the execution was canceled.Cancellation allows the implementation to gracefully clean
        /// up before the execution is closed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATED</code> – the execution was force terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – the execution failed to complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIMED_OUT</code> – the execution did not complete in the alloted time and was automatically timed
        /// out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONTINUED_AS_NEW</code> – the execution is logically continued. This means the current execution was
        /// completed and a new execution was started to carry on the workflow.</p>
        /// </li>
        /// </ul>
        pub fn set_close_status(
            mut self,
            input: std::option::Option<crate::model::CloseStatus>,
        ) -> Self {
            self.close_status = input;
            self
        }
        /// <p>If this workflow execution is a child of another execution then contains the workflow execution that started this execution.</p>
        pub fn parent(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.parent = Some(input);
            self
        }
        /// <p>If this workflow execution is a child of another execution then contains the workflow execution that started this execution.</p>
        pub fn set_parent(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.parent = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags associated with the workflow execution. Tags can be used to identify and list workflow executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags associated with the workflow execution. Tags can be used to identify and list workflow executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>Set to true if a cancellation is requested for this workflow execution.</p>
        pub fn cancel_requested(mut self, input: bool) -> Self {
            self.cancel_requested = Some(input);
            self
        }
        /// <p>Set to true if a cancellation is requested for this workflow execution.</p>
        pub fn set_cancel_requested(mut self, input: std::option::Option<bool>) -> Self {
            self.cancel_requested = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionInfo`](crate::model::WorkflowExecutionInfo)
        pub fn build(self) -> crate::model::WorkflowExecutionInfo {
            crate::model::WorkflowExecutionInfo {
                execution: self.execution,
                workflow_type: self.workflow_type,
                start_timestamp: self.start_timestamp,
                close_timestamp: self.close_timestamp,
                execution_status: self.execution_status,
                close_status: self.close_status,
                parent: self.parent,
                tag_list: self.tag_list,
                cancel_requested: self.cancel_requested.unwrap_or_default(),
            }
        }
    }
}
impl WorkflowExecutionInfo {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionInfo`](crate::model::WorkflowExecutionInfo)
    pub fn builder() -> crate::model::workflow_execution_info::Builder {
        crate::model::workflow_execution_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloseStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    ContinuedAsNew,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloseStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => CloseStatus::Canceled,
            "COMPLETED" => CloseStatus::Completed,
            "CONTINUED_AS_NEW" => CloseStatus::ContinuedAsNew,
            "FAILED" => CloseStatus::Failed,
            "TERMINATED" => CloseStatus::Terminated,
            "TIMED_OUT" => CloseStatus::TimedOut,
            other => CloseStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloseStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloseStatus::from(s))
    }
}
impl CloseStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloseStatus::Canceled => "CANCELED",
            CloseStatus::Completed => "COMPLETED",
            CloseStatus::ContinuedAsNew => "CONTINUED_AS_NEW",
            CloseStatus::Failed => "FAILED",
            CloseStatus::Terminated => "TERMINATED",
            CloseStatus::TimedOut => "TIMED_OUT",
            CloseStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "COMPLETED",
            "CONTINUED_AS_NEW",
            "FAILED",
            "TERMINATED",
            "TIMED_OUT",
        ]
    }
}
impl AsRef<str> for CloseStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CLOSED" => ExecutionStatus::Closed,
            "OPEN" => ExecutionStatus::Open,
            other => ExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionStatus::from(s))
    }
}
impl ExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionStatus::Closed => "CLOSED",
            ExecutionStatus::Open => "OPEN",
            ExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSED", "OPEN"]
    }
}
impl AsRef<str> for ExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Used to filter the workflow executions in visibility APIs by their <code>workflowId</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionFilter {
    /// <p>The workflowId to pass of match the criteria of this filter.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl WorkflowExecutionFilter {
    /// <p>The workflowId to pass of match the criteria of this filter.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for WorkflowExecutionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionFilter");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionFilter`](crate::model::WorkflowExecutionFilter)
pub mod workflow_execution_filter {
    /// A builder for [`WorkflowExecutionFilter`](crate::model::WorkflowExecutionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The workflowId to pass of match the criteria of this filter.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The workflowId to pass of match the criteria of this filter.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionFilter`](crate::model::WorkflowExecutionFilter)
        pub fn build(self) -> crate::model::WorkflowExecutionFilter {
            crate::model::WorkflowExecutionFilter {
                workflow_id: self.workflow_id,
            }
        }
    }
}
impl WorkflowExecutionFilter {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionFilter`](crate::model::WorkflowExecutionFilter)
    pub fn builder() -> crate::model::workflow_execution_filter::Builder {
        crate::model::workflow_execution_filter::Builder::default()
    }
}

/// <p>Used to filter the workflow executions in visibility APIs based on a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagFilter {
    /// <p>
    /// Specifies the tag that must be associated with the execution for it to meet the filter
    /// criteria.</p>
    /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub tag: std::option::Option<std::string::String>,
}
impl TagFilter {
    /// <p>
    /// Specifies the tag that must be associated with the execution for it to meet the filter
    /// criteria.</p>
    /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub fn tag(&self) -> std::option::Option<&str> {
        self.tag.as_deref()
    }
}
impl std::fmt::Debug for TagFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagFilter");
        formatter.field("tag", &self.tag);
        formatter.finish()
    }
}
/// See [`TagFilter`](crate::model::TagFilter)
pub mod tag_filter {
    /// A builder for [`TagFilter`](crate::model::TagFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Specifies the tag that must be associated with the execution for it to meet the filter
        /// criteria.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag = Some(input.into());
            self
        }
        /// <p>
        /// Specifies the tag that must be associated with the execution for it to meet the filter
        /// criteria.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag = input;
            self
        }
        /// Consumes the builder and constructs a [`TagFilter`](crate::model::TagFilter)
        pub fn build(self) -> crate::model::TagFilter {
            crate::model::TagFilter { tag: self.tag }
        }
    }
}
impl TagFilter {
    /// Creates a new builder-style object to manufacture [`TagFilter`](crate::model::TagFilter)
    pub fn builder() -> crate::model::tag_filter::Builder {
        crate::model::tag_filter::Builder::default()
    }
}

/// <p>Used to filter workflow execution query results by type. Each parameter, if specified, defines a rule that must be satisfied by each returned result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowTypeFilter {
    /// <p>
    /// Name of the workflow type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Version of the workflow type.</p>
    pub version: std::option::Option<std::string::String>,
}
impl WorkflowTypeFilter {
    /// <p>
    /// Name of the workflow type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Version of the workflow type.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for WorkflowTypeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowTypeFilter");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`WorkflowTypeFilter`](crate::model::WorkflowTypeFilter)
pub mod workflow_type_filter {
    /// A builder for [`WorkflowTypeFilter`](crate::model::WorkflowTypeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Name of the workflow type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// Name of the workflow type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version of the workflow type.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version of the workflow type.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowTypeFilter`](crate::model::WorkflowTypeFilter)
        pub fn build(self) -> crate::model::WorkflowTypeFilter {
            crate::model::WorkflowTypeFilter {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl WorkflowTypeFilter {
    /// Creates a new builder-style object to manufacture [`WorkflowTypeFilter`](crate::model::WorkflowTypeFilter)
    pub fn builder() -> crate::model::workflow_type_filter::Builder {
        crate::model::workflow_type_filter::Builder::default()
    }
}

/// <p>Used to filter the workflow executions in visibility APIs by various time-based rules. Each parameter, if
/// specified, defines a rule that must be satisfied by each returned query result. The parameter values are in the <a href="https://en.wikipedia.org/wiki/Unix_time">Unix Time format</a>. For example:
/// <code>"oldestDate": 1325376070.</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionTimeFilter {
    /// <p>Specifies the oldest start or close date and time to return.</p>
    pub oldest_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the latest start or close date and time to return.</p>
    pub latest_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl ExecutionTimeFilter {
    /// <p>Specifies the oldest start or close date and time to return.</p>
    pub fn oldest_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.oldest_date.as_ref()
    }
    /// <p>Specifies the latest start or close date and time to return.</p>
    pub fn latest_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_date.as_ref()
    }
}
impl std::fmt::Debug for ExecutionTimeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionTimeFilter");
        formatter.field("oldest_date", &self.oldest_date);
        formatter.field("latest_date", &self.latest_date);
        formatter.finish()
    }
}
/// See [`ExecutionTimeFilter`](crate::model::ExecutionTimeFilter)
pub mod execution_time_filter {
    /// A builder for [`ExecutionTimeFilter`](crate::model::ExecutionTimeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) oldest_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Specifies the oldest start or close date and time to return.</p>
        pub fn oldest_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.oldest_date = Some(input);
            self
        }
        /// <p>Specifies the oldest start or close date and time to return.</p>
        pub fn set_oldest_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.oldest_date = input;
            self
        }
        /// <p>Specifies the latest start or close date and time to return.</p>
        pub fn latest_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_date = Some(input);
            self
        }
        /// <p>Specifies the latest start or close date and time to return.</p>
        pub fn set_latest_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionTimeFilter`](crate::model::ExecutionTimeFilter)
        pub fn build(self) -> crate::model::ExecutionTimeFilter {
            crate::model::ExecutionTimeFilter {
                oldest_date: self.oldest_date,
                latest_date: self.latest_date,
            }
        }
    }
}
impl ExecutionTimeFilter {
    /// Creates a new builder-style object to manufacture [`ExecutionTimeFilter`](crate::model::ExecutionTimeFilter)
    pub fn builder() -> crate::model::execution_time_filter::Builder {
        crate::model::execution_time_filter::Builder::default()
    }
}

/// <p>Contains general information about a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainInfo {
    /// <p>The name of the domain. This name is unique within the account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the domain:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain
    /// for registering types and creating new workflow executions.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is
    /// still in use. You should not create new workflow executions in this domain.
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>The description of the domain provided through <a>RegisterDomain</a>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the domain.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DomainInfo {
    /// <p>The name of the domain. This name is unique within the account.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the domain:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain
    /// for registering types and creating new workflow executions.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is
    /// still in use. You should not create new workflow executions in this domain.
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.status.as_ref()
    }
    /// <p>The description of the domain provided through <a>RegisterDomain</a>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the domain.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DomainInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainInfo");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DomainInfo`](crate::model::DomainInfo)
pub mod domain_info {
    /// A builder for [`DomainInfo`](crate::model::DomainInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain. This name is unique within the account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain. This name is unique within the account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the domain:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain
        /// for registering types and creating new workflow executions.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is
        /// still in use. You should not create new workflow executions in this domain.
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the domain:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain
        /// for registering types and creating new workflow executions.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is
        /// still in use. You should not create new workflow executions in this domain.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the domain provided through <a>RegisterDomain</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the domain provided through <a>RegisterDomain</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the domain.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the domain.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainInfo`](crate::model::DomainInfo)
        pub fn build(self) -> crate::model::DomainInfo {
            crate::model::DomainInfo {
                name: self.name,
                status: self.status,
                description: self.description,
                arn: self.arn,
            }
        }
    }
}
impl DomainInfo {
    /// Creates a new builder-style object to manufacture [`DomainInfo`](crate::model::DomainInfo)
    pub fn builder() -> crate::model::domain_info::Builder {
        crate::model::domain_info::Builder::default()
    }
}

/// <p>Used to filter the closed workflow executions in visibility APIs by their close status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloseStatusFilter {
    /// <p>
    /// The close status that must match the close status of an execution for it to meet the criteria of
    /// this filter.</p>
    pub status: std::option::Option<crate::model::CloseStatus>,
}
impl CloseStatusFilter {
    /// <p>
    /// The close status that must match the close status of an execution for it to meet the criteria of
    /// this filter.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CloseStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CloseStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloseStatusFilter");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CloseStatusFilter`](crate::model::CloseStatusFilter)
pub mod close_status_filter {
    /// A builder for [`CloseStatusFilter`](crate::model::CloseStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::CloseStatus>,
    }
    impl Builder {
        /// <p>
        /// The close status that must match the close status of an execution for it to meet the criteria of
        /// this filter.</p>
        pub fn status(mut self, input: crate::model::CloseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The close status that must match the close status of an execution for it to meet the criteria of
        /// this filter.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::CloseStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CloseStatusFilter`](crate::model::CloseStatusFilter)
        pub fn build(self) -> crate::model::CloseStatusFilter {
            crate::model::CloseStatusFilter {
                status: self.status,
            }
        }
    }
}
impl CloseStatusFilter {
    /// Creates a new builder-style object to manufacture [`CloseStatusFilter`](crate::model::CloseStatusFilter)
    pub fn builder() -> crate::model::close_status_filter::Builder {
        crate::model::close_status_filter::Builder::default()
    }
}

/// <p>Detailed information about an activity type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTypeInfo {
    /// <p>The <a>ActivityType</a> type structure representing the activity type.</p>
    pub activity_type: std::option::Option<crate::model::ActivityType>,
    /// <p>The current status of the activity type.</p>
    pub status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>The description of the activity type provided in <a>RegisterActivityType</a>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time this activity type was created through <a>RegisterActivityType</a>.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.</p>
    pub deprecation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl ActivityTypeInfo {
    /// <p>The <a>ActivityType</a> type structure representing the activity type.</p>
    pub fn activity_type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.activity_type.as_ref()
    }
    /// <p>The current status of the activity type.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.status.as_ref()
    }
    /// <p>The description of the activity type provided in <a>RegisterActivityType</a>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time this activity type was created through <a>RegisterActivityType</a>.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.</p>
    pub fn deprecation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deprecation_date.as_ref()
    }
}
impl std::fmt::Debug for ActivityTypeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTypeInfo");
        formatter.field("activity_type", &self.activity_type);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("deprecation_date", &self.deprecation_date);
        formatter.finish()
    }
}
/// See [`ActivityTypeInfo`](crate::model::ActivityTypeInfo)
pub mod activity_type_info {
    /// A builder for [`ActivityTypeInfo`](crate::model::ActivityTypeInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_type: std::option::Option<crate::model::ActivityType>,
        pub(crate) status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deprecation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The <a>ActivityType</a> type structure representing the activity type.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.activity_type = Some(input);
            self
        }
        /// <p>The <a>ActivityType</a> type structure representing the activity type.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.activity_type = input;
            self
        }
        /// <p>The current status of the activity type.</p>
        pub fn status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the activity type.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the activity type provided in <a>RegisterActivityType</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the activity type provided in <a>RegisterActivityType</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time this activity type was created through <a>RegisterActivityType</a>.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time this activity type was created through <a>RegisterActivityType</a>.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.</p>
        pub fn deprecation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deprecation_date = Some(input);
            self
        }
        /// <p>If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.</p>
        pub fn set_deprecation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deprecation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTypeInfo`](crate::model::ActivityTypeInfo)
        pub fn build(self) -> crate::model::ActivityTypeInfo {
            crate::model::ActivityTypeInfo {
                activity_type: self.activity_type,
                status: self.status,
                description: self.description,
                creation_date: self.creation_date,
                deprecation_date: self.deprecation_date,
            }
        }
    }
}
impl ActivityTypeInfo {
    /// Creates a new builder-style object to manufacture [`ActivityTypeInfo`](crate::model::ActivityTypeInfo)
    pub fn builder() -> crate::model::activity_type_info::Builder {
        crate::model::activity_type_info::Builder::default()
    }
}

/// <p>The configuration settings of a workflow type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowTypeConfiguration {
    /// <p>
    /// The default maximum duration, specified when registering the workflow type, that a decision task
    /// for executions of this workflow type might take before returning completion or failure. If the task doesn'tdo  close
    /// in the specified time then the task is automatically timed out and rescheduled. If the decider eventually reports
    /// a completion or failure, it is ignored. This default can be overridden when starting a workflow execution using
    /// the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>
    /// The default maximum duration, specified when registering the workflow type, for executions of
    /// this workflow type. This default can be overridden when starting a workflow execution using the
    /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>
    /// The default task list, specified when registering the workflow type, for decisions tasks
    /// scheduled for workflow executions of this type. This default can be overridden when starting a workflow execution
    /// using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    pub default_task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// The default task priority, specified when registering the workflow type, for all decision tasks
    /// of this workflow type. This default can be overridden when starting a workflow execution using the
    /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
    /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub default_task_priority: std::option::Option<std::string::String>,
    /// <p>
    /// The default policy to use for the child workflow executions when a workflow execution of this
    /// type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
    /// timeout. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
    /// action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub default_child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The default IAM role attached to this workflow type.</p>
    /// <note>
    /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
    /// don't specify an IAM role when starting this workflow type, the default Lambda role is
    /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub default_lambda_role: std::option::Option<std::string::String>,
}
impl WorkflowTypeConfiguration {
    /// <p>
    /// The default maximum duration, specified when registering the workflow type, that a decision task
    /// for executions of this workflow type might take before returning completion or failure. If the task doesn'tdo  close
    /// in the specified time then the task is automatically timed out and rescheduled. If the decider eventually reports
    /// a completion or failure, it is ignored. This default can be overridden when starting a workflow execution using
    /// the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_task_start_to_close_timeout.as_deref()
    }
    /// <p>
    /// The default maximum duration, specified when registering the workflow type, for executions of
    /// this workflow type. This default can be overridden when starting a workflow execution using the
    /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_execution_start_to_close_timeout.as_deref()
    }
    /// <p>
    /// The default task list, specified when registering the workflow type, for decisions tasks
    /// scheduled for workflow executions of this type. This default can be overridden when starting a workflow execution
    /// using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    pub fn default_task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.default_task_list.as_ref()
    }
    /// <p>
    /// The default task priority, specified when registering the workflow type, for all decision tasks
    /// of this workflow type. This default can be overridden when starting a workflow execution using the
    /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
    /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn default_task_priority(&self) -> std::option::Option<&str> {
        self.default_task_priority.as_deref()
    }
    /// <p>
    /// The default policy to use for the child workflow executions when a workflow execution of this
    /// type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
    /// timeout. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
    /// action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub fn default_child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.default_child_policy.as_ref()
    }
    /// <p>The default IAM role attached to this workflow type.</p>
    /// <note>
    /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
    /// don't specify an IAM role when starting this workflow type, the default Lambda role is
    /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn default_lambda_role(&self) -> std::option::Option<&str> {
        self.default_lambda_role.as_deref()
    }
}
impl std::fmt::Debug for WorkflowTypeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowTypeConfiguration");
        formatter.field(
            "default_task_start_to_close_timeout",
            &self.default_task_start_to_close_timeout,
        );
        formatter.field(
            "default_execution_start_to_close_timeout",
            &self.default_execution_start_to_close_timeout,
        );
        formatter.field("default_task_list", &self.default_task_list);
        formatter.field("default_task_priority", &self.default_task_priority);
        formatter.field("default_child_policy", &self.default_child_policy);
        formatter.field("default_lambda_role", &self.default_lambda_role);
        formatter.finish()
    }
}
/// See [`WorkflowTypeConfiguration`](crate::model::WorkflowTypeConfiguration)
pub mod workflow_type_configuration {
    /// A builder for [`WorkflowTypeConfiguration`](crate::model::WorkflowTypeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) default_execution_start_to_close_timeout:
            std::option::Option<std::string::String>,
        pub(crate) default_task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) default_task_priority: std::option::Option<std::string::String>,
        pub(crate) default_child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) default_lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The default maximum duration, specified when registering the workflow type, that a decision task
        /// for executions of this workflow type might take before returning completion or failure. If the task doesn'tdo  close
        /// in the specified time then the task is automatically timed out and rescheduled. If the decider eventually reports
        /// a completion or failure, it is ignored. This default can be overridden when starting a workflow execution using
        /// the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>
        /// The default maximum duration, specified when registering the workflow type, that a decision task
        /// for executions of this workflow type might take before returning completion or failure. If the task doesn'tdo  close
        /// in the specified time then the task is automatically timed out and rescheduled. If the decider eventually reports
        /// a completion or failure, it is ignored. This default can be overridden when starting a workflow execution using
        /// the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = input;
            self
        }
        /// <p>
        /// The default maximum duration, specified when registering the workflow type, for executions of
        /// this workflow type. This default can be overridden when starting a workflow execution using the
        /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>
        /// The default maximum duration, specified when registering the workflow type, for executions of
        /// this workflow type. This default can be overridden when starting a workflow execution using the
        /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_execution_start_to_close_timeout = input;
            self
        }
        /// <p>
        /// The default task list, specified when registering the workflow type, for decisions tasks
        /// scheduled for workflow executions of this type. This default can be overridden when starting a workflow execution
        /// using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        pub fn default_task_list(mut self, input: crate::model::TaskList) -> Self {
            self.default_task_list = Some(input);
            self
        }
        /// <p>
        /// The default task list, specified when registering the workflow type, for decisions tasks
        /// scheduled for workflow executions of this type. This default can be overridden when starting a workflow execution
        /// using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.default_task_list = input;
            self
        }
        /// <p>
        /// The default task priority, specified when registering the workflow type, for all decision tasks
        /// of this workflow type. This default can be overridden when starting a workflow execution using the
        /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
        /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn default_task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_task_priority = Some(input.into());
            self
        }
        /// <p>
        /// The default task priority, specified when registering the workflow type, for all decision tasks
        /// of this workflow type. This default can be overridden when starting a workflow execution using the
        /// <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
        /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_priority = input;
            self
        }
        /// <p>
        /// The default policy to use for the child workflow executions when a workflow execution of this
        /// type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
        /// timeout. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
        /// action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn default_child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.default_child_policy = Some(input);
            self
        }
        /// <p>
        /// The default policy to use for the child workflow executions when a workflow execution of this
        /// type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
        /// timeout. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
        /// action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn set_default_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.default_child_policy = input;
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't specify an IAM role when starting this workflow type, the default Lambda role is
        /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn default_lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_lambda_role = Some(input.into());
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't specify an IAM role when starting this workflow type, the default Lambda role is
        /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_default_lambda_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowTypeConfiguration`](crate::model::WorkflowTypeConfiguration)
        pub fn build(self) -> crate::model::WorkflowTypeConfiguration {
            crate::model::WorkflowTypeConfiguration {
                default_task_start_to_close_timeout: self.default_task_start_to_close_timeout,
                default_execution_start_to_close_timeout: self
                    .default_execution_start_to_close_timeout,
                default_task_list: self.default_task_list,
                default_task_priority: self.default_task_priority,
                default_child_policy: self.default_child_policy,
                default_lambda_role: self.default_lambda_role,
            }
        }
    }
}
impl WorkflowTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`WorkflowTypeConfiguration`](crate::model::WorkflowTypeConfiguration)
    pub fn builder() -> crate::model::workflow_type_configuration::Builder {
        crate::model::workflow_type_configuration::Builder::default()
    }
}

/// <p>Contains the counts of open tasks, child workflow executions and timers for a workflow execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionOpenCounts {
    /// <p>The count of activity tasks whose status is <code>OPEN</code>.</p>
    pub open_activity_tasks: i32,
    /// <p>The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision task.</p>
    pub open_decision_tasks: i32,
    /// <p>The count of timers started by this workflow execution that have not fired yet.</p>
    pub open_timers: i32,
    /// <p>The count of child workflow executions whose status is <code>OPEN</code>.</p>
    pub open_child_workflow_executions: i32,
    /// <p>The count of Lambda tasks whose status is <code>OPEN</code>.</p>
    pub open_lambda_functions: i32,
}
impl WorkflowExecutionOpenCounts {
    /// <p>The count of activity tasks whose status is <code>OPEN</code>.</p>
    pub fn open_activity_tasks(&self) -> i32 {
        self.open_activity_tasks
    }
    /// <p>The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision task.</p>
    pub fn open_decision_tasks(&self) -> i32 {
        self.open_decision_tasks
    }
    /// <p>The count of timers started by this workflow execution that have not fired yet.</p>
    pub fn open_timers(&self) -> i32 {
        self.open_timers
    }
    /// <p>The count of child workflow executions whose status is <code>OPEN</code>.</p>
    pub fn open_child_workflow_executions(&self) -> i32 {
        self.open_child_workflow_executions
    }
    /// <p>The count of Lambda tasks whose status is <code>OPEN</code>.</p>
    pub fn open_lambda_functions(&self) -> i32 {
        self.open_lambda_functions
    }
}
impl std::fmt::Debug for WorkflowExecutionOpenCounts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionOpenCounts");
        formatter.field("open_activity_tasks", &self.open_activity_tasks);
        formatter.field("open_decision_tasks", &self.open_decision_tasks);
        formatter.field("open_timers", &self.open_timers);
        formatter.field(
            "open_child_workflow_executions",
            &self.open_child_workflow_executions,
        );
        formatter.field("open_lambda_functions", &self.open_lambda_functions);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionOpenCounts`](crate::model::WorkflowExecutionOpenCounts)
pub mod workflow_execution_open_counts {
    /// A builder for [`WorkflowExecutionOpenCounts`](crate::model::WorkflowExecutionOpenCounts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_activity_tasks: std::option::Option<i32>,
        pub(crate) open_decision_tasks: std::option::Option<i32>,
        pub(crate) open_timers: std::option::Option<i32>,
        pub(crate) open_child_workflow_executions: std::option::Option<i32>,
        pub(crate) open_lambda_functions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The count of activity tasks whose status is <code>OPEN</code>.</p>
        pub fn open_activity_tasks(mut self, input: i32) -> Self {
            self.open_activity_tasks = Some(input);
            self
        }
        /// <p>The count of activity tasks whose status is <code>OPEN</code>.</p>
        pub fn set_open_activity_tasks(mut self, input: std::option::Option<i32>) -> Self {
            self.open_activity_tasks = input;
            self
        }
        /// <p>The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision task.</p>
        pub fn open_decision_tasks(mut self, input: i32) -> Self {
            self.open_decision_tasks = Some(input);
            self
        }
        /// <p>The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision task.</p>
        pub fn set_open_decision_tasks(mut self, input: std::option::Option<i32>) -> Self {
            self.open_decision_tasks = input;
            self
        }
        /// <p>The count of timers started by this workflow execution that have not fired yet.</p>
        pub fn open_timers(mut self, input: i32) -> Self {
            self.open_timers = Some(input);
            self
        }
        /// <p>The count of timers started by this workflow execution that have not fired yet.</p>
        pub fn set_open_timers(mut self, input: std::option::Option<i32>) -> Self {
            self.open_timers = input;
            self
        }
        /// <p>The count of child workflow executions whose status is <code>OPEN</code>.</p>
        pub fn open_child_workflow_executions(mut self, input: i32) -> Self {
            self.open_child_workflow_executions = Some(input);
            self
        }
        /// <p>The count of child workflow executions whose status is <code>OPEN</code>.</p>
        pub fn set_open_child_workflow_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.open_child_workflow_executions = input;
            self
        }
        /// <p>The count of Lambda tasks whose status is <code>OPEN</code>.</p>
        pub fn open_lambda_functions(mut self, input: i32) -> Self {
            self.open_lambda_functions = Some(input);
            self
        }
        /// <p>The count of Lambda tasks whose status is <code>OPEN</code>.</p>
        pub fn set_open_lambda_functions(mut self, input: std::option::Option<i32>) -> Self {
            self.open_lambda_functions = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionOpenCounts`](crate::model::WorkflowExecutionOpenCounts)
        pub fn build(self) -> crate::model::WorkflowExecutionOpenCounts {
            crate::model::WorkflowExecutionOpenCounts {
                open_activity_tasks: self.open_activity_tasks.unwrap_or_default(),
                open_decision_tasks: self.open_decision_tasks.unwrap_or_default(),
                open_timers: self.open_timers.unwrap_or_default(),
                open_child_workflow_executions: self
                    .open_child_workflow_executions
                    .unwrap_or_default(),
                open_lambda_functions: self.open_lambda_functions.unwrap_or_default(),
            }
        }
    }
}
impl WorkflowExecutionOpenCounts {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionOpenCounts`](crate::model::WorkflowExecutionOpenCounts)
    pub fn builder() -> crate::model::workflow_execution_open_counts::Builder {
        crate::model::workflow_execution_open_counts::Builder::default()
    }
}

/// <p>The configuration settings for a workflow execution including timeout values, tasklist etc. These configuration settings are determined from the defaults specified when registering the workflow type and those specified when starting the workflow execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowExecutionConfiguration {
    /// <p>The maximum duration allowed for decision tasks for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The total duration for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The task list used for the decision tasks generated for this workflow execution.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
    /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The IAM role attached to the child workflow execution.</p>
    pub lambda_role: std::option::Option<std::string::String>,
}
impl WorkflowExecutionConfiguration {
    /// <p>The maximum duration allowed for decision tasks for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.task_start_to_close_timeout.as_deref()
    }
    /// <p>The total duration for this workflow execution.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.execution_start_to_close_timeout.as_deref()
    }
    /// <p>The task list used for the decision tasks generated for this workflow execution.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
    /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
    /// to take appropriate actions when it receives an execution history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
    /// </li>
    /// </ul>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>The IAM role attached to the child workflow execution.</p>
    pub fn lambda_role(&self) -> std::option::Option<&str> {
        self.lambda_role.as_deref()
    }
}
impl std::fmt::Debug for WorkflowExecutionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowExecutionConfiguration");
        formatter.field(
            "task_start_to_close_timeout",
            &self.task_start_to_close_timeout,
        );
        formatter.field(
            "execution_start_to_close_timeout",
            &self.execution_start_to_close_timeout,
        );
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field("child_policy", &self.child_policy);
        formatter.field("lambda_role", &self.lambda_role);
        formatter.finish()
    }
}
/// See [`WorkflowExecutionConfiguration`](crate::model::WorkflowExecutionConfiguration)
pub mod workflow_execution_configuration {
    /// A builder for [`WorkflowExecutionConfiguration`](crate::model::WorkflowExecutionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) execution_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum duration allowed for decision tasks for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The maximum duration allowed for decision tasks for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = input;
            self
        }
        /// <p>The total duration for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The total duration for this workflow execution.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = input;
            self
        }
        /// <p>The task list used for the decision tasks generated for this workflow execution.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The task list used for the decision tasks generated for this workflow execution.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
        /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
        /// <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider
        /// to take appropriate actions when it receives an execution history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to run.</p>
        /// </li>
        /// </ul>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// <p>The IAM role attached to the child workflow execution.</p>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_role = Some(input.into());
            self
        }
        /// <p>The IAM role attached to the child workflow execution.</p>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowExecutionConfiguration`](crate::model::WorkflowExecutionConfiguration)
        pub fn build(self) -> crate::model::WorkflowExecutionConfiguration {
            crate::model::WorkflowExecutionConfiguration {
                task_start_to_close_timeout: self.task_start_to_close_timeout,
                execution_start_to_close_timeout: self.execution_start_to_close_timeout,
                task_list: self.task_list,
                task_priority: self.task_priority,
                child_policy: self.child_policy,
                lambda_role: self.lambda_role,
            }
        }
    }
}
impl WorkflowExecutionConfiguration {
    /// Creates a new builder-style object to manufacture [`WorkflowExecutionConfiguration`](crate::model::WorkflowExecutionConfiguration)
    pub fn builder() -> crate::model::workflow_execution_configuration::Builder {
        crate::model::workflow_execution_configuration::Builder::default()
    }
}

/// <p>Contains the configuration settings of a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainConfiguration {
    /// <p>The retention period for workflow executions in this domain.</p>
    pub workflow_execution_retention_period_in_days: std::option::Option<std::string::String>,
}
impl DomainConfiguration {
    /// <p>The retention period for workflow executions in this domain.</p>
    pub fn workflow_execution_retention_period_in_days(&self) -> std::option::Option<&str> {
        self.workflow_execution_retention_period_in_days.as_deref()
    }
}
impl std::fmt::Debug for DomainConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainConfiguration");
        formatter.field(
            "workflow_execution_retention_period_in_days",
            &self.workflow_execution_retention_period_in_days,
        );
        formatter.finish()
    }
}
/// See [`DomainConfiguration`](crate::model::DomainConfiguration)
pub mod domain_configuration {
    /// A builder for [`DomainConfiguration`](crate::model::DomainConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_execution_retention_period_in_days:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The retention period for workflow executions in this domain.</p>
        pub fn workflow_execution_retention_period_in_days(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.workflow_execution_retention_period_in_days = Some(input.into());
            self
        }
        /// <p>The retention period for workflow executions in this domain.</p>
        pub fn set_workflow_execution_retention_period_in_days(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workflow_execution_retention_period_in_days = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainConfiguration`](crate::model::DomainConfiguration)
        pub fn build(self) -> crate::model::DomainConfiguration {
            crate::model::DomainConfiguration {
                workflow_execution_retention_period_in_days: self
                    .workflow_execution_retention_period_in_days,
            }
        }
    }
}
impl DomainConfiguration {
    /// Creates a new builder-style object to manufacture [`DomainConfiguration`](crate::model::DomainConfiguration)
    pub fn builder() -> crate::model::domain_configuration::Builder {
        crate::model::domain_configuration::Builder::default()
    }
}

/// <p>Configuration settings registered with the activity type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTypeConfiguration {
    /// <p>
    /// The default maximum duration for tasks of an activity type specified when registering the activity
    /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>
    /// The default maximum time, in seconds, before which a worker processing a task must report
    /// progress by calling <a>RecordActivityTaskHeartbeat</a>.</p>
    /// <p>You can specify this value only when <i>registering</i> an activity type. The registered default value can be
    /// overridden when you schedule a task through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>. If the activity
    /// worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an
    /// <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid;
    /// the activity worker should clean up the activity task.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_heartbeat_timeout: std::option::Option<std::string::String>,
    /// <p>
    /// The default task list specified for this activity type at registration. This default is used if
    /// a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>. You can override the default registered task list when scheduling a task through the
    /// <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    pub default_task_list: std::option::Option<crate::model::TaskList>,
    /// <p>
    /// The default task priority for tasks of this activity type, specified at registration. If not
    /// set, then <code>0</code> is used as the default priority. This default can be overridden when scheduling an activity
    /// task.</p>
    /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub default_task_priority: std::option::Option<std::string::String>,
    /// <p>
    /// The default maximum duration, specified when registering the activity type, that a task of an
    /// activity type can wait before being assigned to a worker. You can override this default when scheduling a task
    /// through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_schedule_to_start_timeout: std::option::Option<std::string::String>,
    /// <p>
    /// The default maximum duration, specified when registering the activity type, for tasks of this activity
    /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_schedule_to_close_timeout: std::option::Option<std::string::String>,
}
impl ActivityTypeConfiguration {
    /// <p>
    /// The default maximum duration for tasks of an activity type specified when registering the activity
    /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_task_start_to_close_timeout.as_deref()
    }
    /// <p>
    /// The default maximum time, in seconds, before which a worker processing a task must report
    /// progress by calling <a>RecordActivityTaskHeartbeat</a>.</p>
    /// <p>You can specify this value only when <i>registering</i> an activity type. The registered default value can be
    /// overridden when you schedule a task through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>. If the activity
    /// worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an
    /// <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid;
    /// the activity worker should clean up the activity task.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_heartbeat_timeout(&self) -> std::option::Option<&str> {
        self.default_task_heartbeat_timeout.as_deref()
    }
    /// <p>
    /// The default task list specified for this activity type at registration. This default is used if
    /// a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>. You can override the default registered task list when scheduling a task through the
    /// <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    pub fn default_task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.default_task_list.as_ref()
    }
    /// <p>
    /// The default task priority for tasks of this activity type, specified at registration. If not
    /// set, then <code>0</code> is used as the default priority. This default can be overridden when scheduling an activity
    /// task.</p>
    /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
    /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn default_task_priority(&self) -> std::option::Option<&str> {
        self.default_task_priority.as_deref()
    }
    /// <p>
    /// The default maximum duration, specified when registering the activity type, that a task of an
    /// activity type can wait before being assigned to a worker. You can override this default when scheduling a task
    /// through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_schedule_to_start_timeout(&self) -> std::option::Option<&str> {
        self.default_task_schedule_to_start_timeout.as_deref()
    }
    /// <p>
    /// The default maximum duration, specified when registering the activity type, for tasks of this activity
    /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_schedule_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_task_schedule_to_close_timeout.as_deref()
    }
}
impl std::fmt::Debug for ActivityTypeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTypeConfiguration");
        formatter.field(
            "default_task_start_to_close_timeout",
            &self.default_task_start_to_close_timeout,
        );
        formatter.field(
            "default_task_heartbeat_timeout",
            &self.default_task_heartbeat_timeout,
        );
        formatter.field("default_task_list", &self.default_task_list);
        formatter.field("default_task_priority", &self.default_task_priority);
        formatter.field(
            "default_task_schedule_to_start_timeout",
            &self.default_task_schedule_to_start_timeout,
        );
        formatter.field(
            "default_task_schedule_to_close_timeout",
            &self.default_task_schedule_to_close_timeout,
        );
        formatter.finish()
    }
}
/// See [`ActivityTypeConfiguration`](crate::model::ActivityTypeConfiguration)
pub mod activity_type_configuration {
    /// A builder for [`ActivityTypeConfiguration`](crate::model::ActivityTypeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) default_task_heartbeat_timeout: std::option::Option<std::string::String>,
        pub(crate) default_task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) default_task_priority: std::option::Option<std::string::String>,
        pub(crate) default_task_schedule_to_start_timeout: std::option::Option<std::string::String>,
        pub(crate) default_task_schedule_to_close_timeout: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The default maximum duration for tasks of an activity type specified when registering the activity
        /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>
        /// The default maximum duration for tasks of an activity type specified when registering the activity
        /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = input;
            self
        }
        /// <p>
        /// The default maximum time, in seconds, before which a worker processing a task must report
        /// progress by calling <a>RecordActivityTaskHeartbeat</a>.</p>
        /// <p>You can specify this value only when <i>registering</i> an activity type. The registered default value can be
        /// overridden when you schedule a task through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. If the activity
        /// worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an
        /// <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid;
        /// the activity worker should clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_heartbeat_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_heartbeat_timeout = Some(input.into());
            self
        }
        /// <p>
        /// The default maximum time, in seconds, before which a worker processing a task must report
        /// progress by calling <a>RecordActivityTaskHeartbeat</a>.</p>
        /// <p>You can specify this value only when <i>registering</i> an activity type. The registered default value can be
        /// overridden when you schedule a task through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. If the activity
        /// worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an
        /// <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid;
        /// the activity worker should clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_heartbeat_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_heartbeat_timeout = input;
            self
        }
        /// <p>
        /// The default task list specified for this activity type at registration. This default is used if
        /// a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. You can override the default registered task list when scheduling a task through the
        /// <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        pub fn default_task_list(mut self, input: crate::model::TaskList) -> Self {
            self.default_task_list = Some(input);
            self
        }
        /// <p>
        /// The default task list specified for this activity type at registration. This default is used if
        /// a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. You can override the default registered task list when scheduling a task through the
        /// <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.default_task_list = input;
            self
        }
        /// <p>
        /// The default task priority for tasks of this activity type, specified at registration. If not
        /// set, then <code>0</code> is used as the default priority. This default can be overridden when scheduling an activity
        /// task.</p>
        /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn default_task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_task_priority = Some(input.into());
            self
        }
        /// <p>
        /// The default task priority for tasks of this activity type, specified at registration. If not
        /// set, then <code>0</code> is used as the default priority. This default can be overridden when scheduling an activity
        /// task.</p>
        /// <p>Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
        /// (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_priority = input;
            self
        }
        /// <p>
        /// The default maximum duration, specified when registering the activity type, that a task of an
        /// activity type can wait before being assigned to a worker. You can override this default when scheduling a task
        /// through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_start_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_start_timeout = Some(input.into());
            self
        }
        /// <p>
        /// The default maximum duration, specified when registering the activity type, that a task of an
        /// activity type can wait before being assigned to a worker. You can override this default when scheduling a task
        /// through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_start_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_start_timeout = input;
            self
        }
        /// <p>
        /// The default maximum duration, specified when registering the activity type, for tasks of this activity
        /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_close_timeout = Some(input.into());
            self
        }
        /// <p>
        /// The default maximum duration, specified when registering the activity type, for tasks of this activity
        /// type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_close_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTypeConfiguration`](crate::model::ActivityTypeConfiguration)
        pub fn build(self) -> crate::model::ActivityTypeConfiguration {
            crate::model::ActivityTypeConfiguration {
                default_task_start_to_close_timeout: self.default_task_start_to_close_timeout,
                default_task_heartbeat_timeout: self.default_task_heartbeat_timeout,
                default_task_list: self.default_task_list,
                default_task_priority: self.default_task_priority,
                default_task_schedule_to_start_timeout: self.default_task_schedule_to_start_timeout,
                default_task_schedule_to_close_timeout: self.default_task_schedule_to_close_timeout,
            }
        }
    }
}
impl ActivityTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`ActivityTypeConfiguration`](crate::model::ActivityTypeConfiguration)
    pub fn builder() -> crate::model::activity_type_configuration::Builder {
        crate::model::activity_type_configuration::Builder::default()
    }
}
