// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CountClosedWorkflowExecutionsInput`](crate::input::CountClosedWorkflowExecutionsInput)
pub mod count_closed_workflow_executions_input {
    /// A builder for [`CountClosedWorkflowExecutionsInput`](crate::input::CountClosedWorkflowExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
        pub(crate) close_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
        pub(crate) execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
        pub(crate) type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
        pub(crate) tag_filter: std::option::Option<crate::model::TagFilter>,
        pub(crate) close_status_filter: std::option::Option<crate::model::CloseStatusFilter>,
    }
    impl Builder {
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>If specified, only workflow executions that meet the start time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.start_time_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the start time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.start_time_filter = input;
            self
        }
        /// <p>If specified, only workflow executions that meet the close time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn close_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.close_time_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the close time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_close_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.close_time_filter = input;
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.execution_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.execution_filter = input;
            self
        }
        /// <p>If specified, indicates the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.type_filter = Some(input);
            self
        }
        /// <p>If specified, indicates the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.type_filter = input;
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.tag_filter = Some(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.tag_filter = input;
            self
        }
        /// <p>If specified, only workflow executions that match this close status are counted. This
        /// filter has an affect only if <code>executionStatus</code> is specified as
        /// <code>CLOSED</code>.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn close_status_filter(mut self, input: crate::model::CloseStatusFilter) -> Self {
            self.close_status_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions that match this close status are counted. This
        /// filter has an affect only if <code>executionStatus</code> is specified as
        /// <code>CLOSED</code>.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_close_status_filter(
            mut self,
            input: std::option::Option<crate::model::CloseStatusFilter>,
        ) -> Self {
            self.close_status_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`CountClosedWorkflowExecutionsInput`](crate::input::CountClosedWorkflowExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CountClosedWorkflowExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CountClosedWorkflowExecutionsInput {
                domain: self.domain,
                start_time_filter: self.start_time_filter,
                close_time_filter: self.close_time_filter,
                execution_filter: self.execution_filter,
                type_filter: self.type_filter,
                tag_filter: self.tag_filter,
                close_status_filter: self.close_status_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type CountClosedWorkflowExecutionsInputOperationOutputAlias =
    crate::operation::CountClosedWorkflowExecutions;
#[doc(hidden)]
pub type CountClosedWorkflowExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CountClosedWorkflowExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`CountClosedWorkflowExecutions`](crate::operation::CountClosedWorkflowExecutions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CountClosedWorkflowExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CountClosedWorkflowExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CountClosedWorkflowExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CountClosedWorkflowExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.CountClosedWorkflowExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_count_closed_workflow_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CountClosedWorkflowExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CountClosedWorkflowExecutions",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CountClosedWorkflowExecutionsInput`](crate::input::CountClosedWorkflowExecutionsInput)
    pub fn builder() -> crate::input::count_closed_workflow_executions_input::Builder {
        crate::input::count_closed_workflow_executions_input::Builder::default()
    }
}

/// See [`CountOpenWorkflowExecutionsInput`](crate::input::CountOpenWorkflowExecutionsInput)
pub mod count_open_workflow_executions_input {
    /// A builder for [`CountOpenWorkflowExecutionsInput`](crate::input::CountOpenWorkflowExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
        pub(crate) type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
        pub(crate) tag_filter: std::option::Option<crate::model::TagFilter>,
        pub(crate) execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
    }
    impl Builder {
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Specifies the start time criteria that workflow executions must meet in order to be
        /// counted.</p>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.start_time_filter = Some(input);
            self
        }
        /// <p>Specifies the start time criteria that workflow executions must meet in order to be
        /// counted.</p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.start_time_filter = input;
            self
        }
        /// <p>Specifies the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.type_filter = Some(input);
            self
        }
        /// <p>Specifies the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.type_filter = input;
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.tag_filter = Some(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.tag_filter = input;
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.execution_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.execution_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`CountOpenWorkflowExecutionsInput`](crate::input::CountOpenWorkflowExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CountOpenWorkflowExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CountOpenWorkflowExecutionsInput {
                domain: self.domain,
                start_time_filter: self.start_time_filter,
                type_filter: self.type_filter,
                tag_filter: self.tag_filter,
                execution_filter: self.execution_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type CountOpenWorkflowExecutionsInputOperationOutputAlias =
    crate::operation::CountOpenWorkflowExecutions;
#[doc(hidden)]
pub type CountOpenWorkflowExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CountOpenWorkflowExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`CountOpenWorkflowExecutions`](crate::operation::CountOpenWorkflowExecutions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CountOpenWorkflowExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CountOpenWorkflowExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CountOpenWorkflowExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CountOpenWorkflowExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.CountOpenWorkflowExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_count_open_workflow_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CountOpenWorkflowExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CountOpenWorkflowExecutions",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CountOpenWorkflowExecutionsInput`](crate::input::CountOpenWorkflowExecutionsInput)
    pub fn builder() -> crate::input::count_open_workflow_executions_input::Builder {
        crate::input::count_open_workflow_executions_input::Builder::default()
    }
}

/// See [`CountPendingActivityTasksInput`](crate::input::CountPendingActivityTasksInput)
pub mod count_pending_activity_tasks_input {
    /// A builder for [`CountPendingActivityTasksInput`](crate::input::CountPendingActivityTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
    }
    impl Builder {
        /// <p>The name of the domain that contains the task list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The name of the task list.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CountPendingActivityTasksInput`](crate::input::CountPendingActivityTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CountPendingActivityTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CountPendingActivityTasksInput {
                domain: self.domain,
                task_list: self.task_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CountPendingActivityTasksInputOperationOutputAlias =
    crate::operation::CountPendingActivityTasks;
#[doc(hidden)]
pub type CountPendingActivityTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CountPendingActivityTasksInput {
    /// Consumes the builder and constructs an Operation<[`CountPendingActivityTasks`](crate::operation::CountPendingActivityTasks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CountPendingActivityTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CountPendingActivityTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CountPendingActivityTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CountPendingActivityTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.CountPendingActivityTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_count_pending_activity_tasks(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CountPendingActivityTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CountPendingActivityTasks",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CountPendingActivityTasksInput`](crate::input::CountPendingActivityTasksInput)
    pub fn builder() -> crate::input::count_pending_activity_tasks_input::Builder {
        crate::input::count_pending_activity_tasks_input::Builder::default()
    }
}

/// See [`CountPendingDecisionTasksInput`](crate::input::CountPendingDecisionTasksInput)
pub mod count_pending_decision_tasks_input {
    /// A builder for [`CountPendingDecisionTasksInput`](crate::input::CountPendingDecisionTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
    }
    impl Builder {
        /// <p>The name of the domain that contains the task list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The name of the task list.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CountPendingDecisionTasksInput`](crate::input::CountPendingDecisionTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CountPendingDecisionTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CountPendingDecisionTasksInput {
                domain: self.domain,
                task_list: self.task_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CountPendingDecisionTasksInputOperationOutputAlias =
    crate::operation::CountPendingDecisionTasks;
#[doc(hidden)]
pub type CountPendingDecisionTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CountPendingDecisionTasksInput {
    /// Consumes the builder and constructs an Operation<[`CountPendingDecisionTasks`](crate::operation::CountPendingDecisionTasks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CountPendingDecisionTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CountPendingDecisionTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CountPendingDecisionTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CountPendingDecisionTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.CountPendingDecisionTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_count_pending_decision_tasks(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CountPendingDecisionTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CountPendingDecisionTasks",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CountPendingDecisionTasksInput`](crate::input::CountPendingDecisionTasksInput)
    pub fn builder() -> crate::input::count_pending_decision_tasks_input::Builder {
        crate::input::count_pending_decision_tasks_input::Builder::default()
    }
}

/// See [`DeprecateActivityTypeInput`](crate::input::DeprecateActivityTypeInput)
pub mod deprecate_activity_type_input {
    /// A builder for [`DeprecateActivityTypeInput`](crate::input::DeprecateActivityTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) activity_type: std::option::Option<crate::model::ActivityType>,
    }
    impl Builder {
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The activity type to deprecate.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.activity_type = Some(input);
            self
        }
        /// <p>The activity type to deprecate.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.activity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprecateActivityTypeInput`](crate::input::DeprecateActivityTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeprecateActivityTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeprecateActivityTypeInput {
                domain: self.domain,
                activity_type: self.activity_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeprecateActivityTypeInputOperationOutputAlias = crate::operation::DeprecateActivityType;
#[doc(hidden)]
pub type DeprecateActivityTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeprecateActivityTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeprecateActivityType`](crate::operation::DeprecateActivityType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeprecateActivityType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeprecateActivityTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeprecateActivityTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeprecateActivityTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.DeprecateActivityType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deprecate_activity_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeprecateActivityType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeprecateActivityType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeprecateActivityTypeInput`](crate::input::DeprecateActivityTypeInput)
    pub fn builder() -> crate::input::deprecate_activity_type_input::Builder {
        crate::input::deprecate_activity_type_input::Builder::default()
    }
}

/// See [`DeprecateDomainInput`](crate::input::DeprecateDomainInput)
pub mod deprecate_domain_input {
    /// A builder for [`DeprecateDomainInput`](crate::input::DeprecateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain to deprecate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain to deprecate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprecateDomainInput`](crate::input::DeprecateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeprecateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeprecateDomainInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeprecateDomainInputOperationOutputAlias = crate::operation::DeprecateDomain;
#[doc(hidden)]
pub type DeprecateDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeprecateDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeprecateDomain`](crate::operation::DeprecateDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeprecateDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeprecateDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeprecateDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeprecateDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.DeprecateDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deprecate_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeprecateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeprecateDomain",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeprecateDomainInput`](crate::input::DeprecateDomainInput)
    pub fn builder() -> crate::input::deprecate_domain_input::Builder {
        crate::input::deprecate_domain_input::Builder::default()
    }
}

/// See [`DeprecateWorkflowTypeInput`](crate::input::DeprecateWorkflowTypeInput)
pub mod deprecate_workflow_type_input {
    /// A builder for [`DeprecateWorkflowTypeInput`](crate::input::DeprecateWorkflowTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
    }
    impl Builder {
        /// <p>The name of the domain in which the workflow type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which the workflow type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The workflow type to deprecate.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The workflow type to deprecate.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprecateWorkflowTypeInput`](crate::input::DeprecateWorkflowTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeprecateWorkflowTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeprecateWorkflowTypeInput {
                domain: self.domain,
                workflow_type: self.workflow_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeprecateWorkflowTypeInputOperationOutputAlias = crate::operation::DeprecateWorkflowType;
#[doc(hidden)]
pub type DeprecateWorkflowTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeprecateWorkflowTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeprecateWorkflowType`](crate::operation::DeprecateWorkflowType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeprecateWorkflowType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeprecateWorkflowTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeprecateWorkflowTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeprecateWorkflowTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.DeprecateWorkflowType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deprecate_workflow_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeprecateWorkflowType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeprecateWorkflowType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeprecateWorkflowTypeInput`](crate::input::DeprecateWorkflowTypeInput)
    pub fn builder() -> crate::input::deprecate_workflow_type_input::Builder {
        crate::input::deprecate_workflow_type_input::Builder::default()
    }
}

/// See [`DescribeActivityTypeInput`](crate::input::DescribeActivityTypeInput)
pub mod describe_activity_type_input {
    /// A builder for [`DescribeActivityTypeInput`](crate::input::DescribeActivityTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) activity_type: std::option::Option<crate::model::ActivityType>,
    }
    impl Builder {
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The activity type to get information about. Activity types are identified by the
        /// <code>name</code> and <code>version</code> that were supplied when the activity was
        /// registered.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.activity_type = Some(input);
            self
        }
        /// <p>The activity type to get information about. Activity types are identified by the
        /// <code>name</code> and <code>version</code> that were supplied when the activity was
        /// registered.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.activity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivityTypeInput`](crate::input::DescribeActivityTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActivityTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActivityTypeInput {
                domain: self.domain,
                activity_type: self.activity_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeActivityTypeInputOperationOutputAlias = crate::operation::DescribeActivityType;
#[doc(hidden)]
pub type DescribeActivityTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeActivityTypeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeActivityType`](crate::operation::DescribeActivityType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeActivityType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeActivityTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeActivityTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeActivityTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.DescribeActivityType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_activity_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeActivityType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeActivityType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeActivityTypeInput`](crate::input::DescribeActivityTypeInput)
    pub fn builder() -> crate::input::describe_activity_type_input::Builder {
        crate::input::describe_activity_type_input::Builder::default()
    }
}

/// See [`DescribeDomainInput`](crate::input::DescribeDomainInput)
pub mod describe_domain_input {
    /// A builder for [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain to describe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain to describe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainInput`](crate::input::DescribeDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainInputOperationOutputAlias = crate::operation::DescribeDomain;
#[doc(hidden)]
pub type DescribeDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDomainInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomain`](crate::operation::DescribeDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.DescribeDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomain",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
}

/// See [`DescribeWorkflowExecutionInput`](crate::input::DescribeWorkflowExecutionInput)
pub mod describe_workflow_execution_input {
    /// A builder for [`DescribeWorkflowExecutionInput`](crate::input::DescribeWorkflowExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) execution: std::option::Option<crate::model::WorkflowExecution>,
    }
    impl Builder {
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The workflow execution to describe.</p>
        pub fn execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.execution = Some(input);
            self
        }
        /// <p>The workflow execution to describe.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkflowExecutionInput`](crate::input::DescribeWorkflowExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkflowExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkflowExecutionInput {
                domain: self.domain,
                execution: self.execution,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkflowExecutionInputOperationOutputAlias =
    crate::operation::DescribeWorkflowExecution;
#[doc(hidden)]
pub type DescribeWorkflowExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkflowExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkflowExecution`](crate::operation::DescribeWorkflowExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkflowExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkflowExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkflowExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkflowExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.DescribeWorkflowExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workflow_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkflowExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkflowExecution",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkflowExecutionInput`](crate::input::DescribeWorkflowExecutionInput)
    pub fn builder() -> crate::input::describe_workflow_execution_input::Builder {
        crate::input::describe_workflow_execution_input::Builder::default()
    }
}

/// See [`DescribeWorkflowTypeInput`](crate::input::DescribeWorkflowTypeInput)
pub mod describe_workflow_type_input {
    /// A builder for [`DescribeWorkflowTypeInput`](crate::input::DescribeWorkflowTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
    }
    impl Builder {
        /// <p>The name of the domain in which this workflow type is registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which this workflow type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The workflow type to describe.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The workflow type to describe.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkflowTypeInput`](crate::input::DescribeWorkflowTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkflowTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkflowTypeInput {
                domain: self.domain,
                workflow_type: self.workflow_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkflowTypeInputOperationOutputAlias = crate::operation::DescribeWorkflowType;
#[doc(hidden)]
pub type DescribeWorkflowTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkflowTypeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkflowType`](crate::operation::DescribeWorkflowType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkflowType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkflowTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkflowTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkflowTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.DescribeWorkflowType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workflow_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkflowType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkflowType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkflowTypeInput`](crate::input::DescribeWorkflowTypeInput)
    pub fn builder() -> crate::input::describe_workflow_type_input::Builder {
        crate::input::describe_workflow_type_input::Builder::default()
    }
}

/// See [`GetWorkflowExecutionHistoryInput`](crate::input::GetWorkflowExecutionHistoryInput)
pub mod get_workflow_execution_history_input {
    /// A builder for [`GetWorkflowExecutionHistoryInput`](crate::input::GetWorkflowExecutionHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) execution: std::option::Option<crate::model::WorkflowExecution>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) maximum_page_size: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Specifies the workflow execution for which to return the history.</p>
        pub fn execution(mut self, input: crate::model::WorkflowExecution) -> Self {
            self.execution = Some(input);
            self
        }
        /// <p>Specifies the workflow execution for which to return the history.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.maximum_page_size = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_page_size = input;
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimeStamp</code> of the
        /// events.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimeStamp</code> of the
        /// events.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkflowExecutionHistoryInput`](crate::input::GetWorkflowExecutionHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkflowExecutionHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkflowExecutionHistoryInput {
                domain: self.domain,
                execution: self.execution,
                next_page_token: self.next_page_token,
                maximum_page_size: self.maximum_page_size.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkflowExecutionHistoryInputOperationOutputAlias =
    crate::operation::GetWorkflowExecutionHistory;
#[doc(hidden)]
pub type GetWorkflowExecutionHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetWorkflowExecutionHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkflowExecutionHistory`](crate::operation::GetWorkflowExecutionHistory)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkflowExecutionHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWorkflowExecutionHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWorkflowExecutionHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWorkflowExecutionHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.GetWorkflowExecutionHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_workflow_execution_history(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkflowExecutionHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkflowExecutionHistory",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWorkflowExecutionHistoryInput`](crate::input::GetWorkflowExecutionHistoryInput)
    pub fn builder() -> crate::input::get_workflow_execution_history_input::Builder {
        crate::input::get_workflow_execution_history_input::Builder::default()
    }
}

/// See [`ListActivityTypesInput`](crate::input::ListActivityTypesInput)
pub mod list_activity_types_input {
    /// A builder for [`ListActivityTypesInput`](crate::input::ListActivityTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) registration_status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) maximum_page_size: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain in which the activity types have been registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which the activity types have been registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>If specified, only lists the activity types that have this name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>If specified, only lists the activity types that have this name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the registration status of the activity types to list.</p>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.registration_status = Some(input);
            self
        }
        /// <p>Specifies the registration status of the activity types to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.registration_status = input;
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.maximum_page_size = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_page_size = input;
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the activity
        /// types.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the activity
        /// types.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActivityTypesInput`](crate::input::ListActivityTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListActivityTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListActivityTypesInput {
                domain: self.domain,
                name: self.name,
                registration_status: self.registration_status,
                next_page_token: self.next_page_token,
                maximum_page_size: self.maximum_page_size.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListActivityTypesInputOperationOutputAlias = crate::operation::ListActivityTypes;
#[doc(hidden)]
pub type ListActivityTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListActivityTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListActivityTypes`](crate::operation::ListActivityTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListActivityTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListActivityTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListActivityTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListActivityTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.ListActivityTypes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_activity_types(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListActivityTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListActivityTypes",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListActivityTypesInput`](crate::input::ListActivityTypesInput)
    pub fn builder() -> crate::input::list_activity_types_input::Builder {
        crate::input::list_activity_types_input::Builder::default()
    }
}

/// See [`ListClosedWorkflowExecutionsInput`](crate::input::ListClosedWorkflowExecutionsInput)
pub mod list_closed_workflow_executions_input {
    /// A builder for [`ListClosedWorkflowExecutionsInput`](crate::input::ListClosedWorkflowExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
        pub(crate) close_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
        pub(crate) execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
        pub(crate) close_status_filter: std::option::Option<crate::model::CloseStatusFilter>,
        pub(crate) type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
        pub(crate) tag_filter: std::option::Option<crate::model::TagFilter>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) maximum_page_size: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their start times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their start times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.start_time_filter = Some(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their start times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their start times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.start_time_filter = input;
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their close times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their close times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn close_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.close_time_filter = Some(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their close times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their close times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_close_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.close_time_filter = input;
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.execution_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.execution_filter = input;
            self
        }
        /// <p>If specified, only workflow executions that match this <i>close
        /// status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED
        /// workflow executions are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn close_status_filter(mut self, input: crate::model::CloseStatusFilter) -> Self {
            self.close_status_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions that match this <i>close
        /// status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED
        /// workflow executions are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_close_status_filter(
            mut self,
            input: std::option::Option<crate::model::CloseStatusFilter>,
        ) -> Self {
            self.close_status_filter = input;
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.type_filter = Some(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.type_filter = input;
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.tag_filter = Some(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.tag_filter = input;
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.maximum_page_size = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_page_size = input;
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start or the close time of the
        /// executions.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start or the close time of the
        /// executions.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClosedWorkflowExecutionsInput`](crate::input::ListClosedWorkflowExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClosedWorkflowExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListClosedWorkflowExecutionsInput {
                domain: self.domain,
                start_time_filter: self.start_time_filter,
                close_time_filter: self.close_time_filter,
                execution_filter: self.execution_filter,
                close_status_filter: self.close_status_filter,
                type_filter: self.type_filter,
                tag_filter: self.tag_filter,
                next_page_token: self.next_page_token,
                maximum_page_size: self.maximum_page_size.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListClosedWorkflowExecutionsInputOperationOutputAlias =
    crate::operation::ListClosedWorkflowExecutions;
#[doc(hidden)]
pub type ListClosedWorkflowExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListClosedWorkflowExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListClosedWorkflowExecutions`](crate::operation::ListClosedWorkflowExecutions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClosedWorkflowExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListClosedWorkflowExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListClosedWorkflowExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListClosedWorkflowExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.ListClosedWorkflowExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_closed_workflow_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClosedWorkflowExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClosedWorkflowExecutions",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListClosedWorkflowExecutionsInput`](crate::input::ListClosedWorkflowExecutionsInput)
    pub fn builder() -> crate::input::list_closed_workflow_executions_input::Builder {
        crate::input::list_closed_workflow_executions_input::Builder::default()
    }
}

/// See [`ListDomainsInput`](crate::input::ListDomainsInput)
pub mod list_domains_input {
    /// A builder for [`ListDomainsInput`](crate::input::ListDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) registration_status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) maximum_page_size: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>Specifies the registration status of the domains to list.</p>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.registration_status = Some(input);
            self
        }
        /// <p>Specifies the registration status of the domains to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.registration_status = input;
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.maximum_page_size = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_page_size = input;
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the
        /// domains.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the
        /// domains.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsInput`](crate::input::ListDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainsInput {
                next_page_token: self.next_page_token,
                registration_status: self.registration_status,
                maximum_page_size: self.maximum_page_size.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainsInputOperationOutputAlias = crate::operation::ListDomains;
#[doc(hidden)]
pub type ListDomainsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDomainsInput {
    /// Consumes the builder and constructs an Operation<[`ListDomains`](crate::operation::ListDomains)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomains,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDomainsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDomainsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDomainsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.ListDomains",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_domains(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomains",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
}

/// See [`ListOpenWorkflowExecutionsInput`](crate::input::ListOpenWorkflowExecutionsInput)
pub mod list_open_workflow_executions_input {
    /// A builder for [`ListOpenWorkflowExecutionsInput`](crate::input::ListOpenWorkflowExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
        pub(crate) type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
        pub(crate) tag_filter: std::option::Option<crate::model::TagFilter>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) maximum_page_size: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
        pub(crate) execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
    }
    impl Builder {
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Workflow executions are included in the returned results based on whether their start
        /// times are within the range specified by this filter.</p>
        pub fn start_time_filter(mut self, input: crate::model::ExecutionTimeFilter) -> Self {
            self.start_time_filter = Some(input);
            self
        }
        /// <p>Workflow executions are included in the returned results based on whether their start
        /// times are within the range specified by this filter.</p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.start_time_filter = input;
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, input: crate::model::WorkflowTypeFilter) -> Self {
            self.type_filter = Some(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.type_filter = input;
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, input: crate::model::TagFilter) -> Self {
            self.tag_filter = Some(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.tag_filter = input;
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.maximum_page_size = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_page_size = input;
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start time of the executions.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start time of the executions.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, input: crate::model::WorkflowExecutionFilter) -> Self {
            self.execution_filter = Some(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.execution_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpenWorkflowExecutionsInput`](crate::input::ListOpenWorkflowExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOpenWorkflowExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOpenWorkflowExecutionsInput {
                domain: self.domain,
                start_time_filter: self.start_time_filter,
                type_filter: self.type_filter,
                tag_filter: self.tag_filter,
                next_page_token: self.next_page_token,
                maximum_page_size: self.maximum_page_size.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
                execution_filter: self.execution_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOpenWorkflowExecutionsInputOperationOutputAlias =
    crate::operation::ListOpenWorkflowExecutions;
#[doc(hidden)]
pub type ListOpenWorkflowExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOpenWorkflowExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListOpenWorkflowExecutions`](crate::operation::ListOpenWorkflowExecutions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOpenWorkflowExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOpenWorkflowExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOpenWorkflowExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOpenWorkflowExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.ListOpenWorkflowExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_open_workflow_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOpenWorkflowExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOpenWorkflowExecutions",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOpenWorkflowExecutionsInput`](crate::input::ListOpenWorkflowExecutionsInput)
    pub fn builder() -> crate::input::list_open_workflow_executions_input::Builder {
        crate::input::list_open_workflow_executions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWorkflowTypesInput`](crate::input::ListWorkflowTypesInput)
pub mod list_workflow_types_input {
    /// A builder for [`ListWorkflowTypesInput`](crate::input::ListWorkflowTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) registration_status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) maximum_page_size: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain in which the workflow types have been registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which the workflow types have been registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>If specified, lists the workflow type with this name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>If specified, lists the workflow type with this name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the registration status of the workflow types to list.</p>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.registration_status = Some(input);
            self
        }
        /// <p>Specifies the registration status of the workflow types to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.registration_status = input;
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.maximum_page_size = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_page_size = input;
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in ascending alphabetical order of the <code>name</code> of the workflow
        /// types.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in ascending alphabetical order of the <code>name</code> of the workflow
        /// types.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkflowTypesInput`](crate::input::ListWorkflowTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkflowTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkflowTypesInput {
                domain: self.domain,
                name: self.name,
                registration_status: self.registration_status,
                next_page_token: self.next_page_token,
                maximum_page_size: self.maximum_page_size.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkflowTypesInputOperationOutputAlias = crate::operation::ListWorkflowTypes;
#[doc(hidden)]
pub type ListWorkflowTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkflowTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkflowTypes`](crate::operation::ListWorkflowTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkflowTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkflowTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkflowTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkflowTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.ListWorkflowTypes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_workflow_types(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkflowTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkflowTypes",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkflowTypesInput`](crate::input::ListWorkflowTypesInput)
    pub fn builder() -> crate::input::list_workflow_types_input::Builder {
        crate::input::list_workflow_types_input::Builder::default()
    }
}

/// See [`PollForActivityTaskInput`](crate::input::PollForActivityTaskInput)
pub mod poll_for_activity_task_input {
    /// A builder for [`PollForActivityTaskInput`](crate::input::PollForActivityTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that contains the task lists being polled.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain that contains the task lists being polled.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Specifies the task list to poll for activity tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>Specifies the task list to poll for activity tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>Identity of the worker making the request, recorded in the
        /// <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic
        /// tracing when problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>Identity of the worker making the request, recorded in the
        /// <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic
        /// tracing when problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// Consumes the builder and constructs a [`PollForActivityTaskInput`](crate::input::PollForActivityTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PollForActivityTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PollForActivityTaskInput {
                domain: self.domain,
                task_list: self.task_list,
                identity: self.identity,
            })
        }
    }
}
#[doc(hidden)]
pub type PollForActivityTaskInputOperationOutputAlias = crate::operation::PollForActivityTask;
#[doc(hidden)]
pub type PollForActivityTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PollForActivityTaskInput {
    /// Consumes the builder and constructs an Operation<[`PollForActivityTask`](crate::operation::PollForActivityTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PollForActivityTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PollForActivityTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PollForActivityTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PollForActivityTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.PollForActivityTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_poll_for_activity_task(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PollForActivityTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PollForActivityTask",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PollForActivityTaskInput`](crate::input::PollForActivityTaskInput)
    pub fn builder() -> crate::input::poll_for_activity_task_input::Builder {
        crate::input::poll_for_activity_task_input::Builder::default()
    }
}

/// See [`PollForDecisionTaskInput`](crate::input::PollForDecisionTaskInput)
pub mod poll_for_decision_task_input {
    /// A builder for [`PollForDecisionTaskInput`](crate::input::PollForDecisionTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) maximum_page_size: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain containing the task lists to poll.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain containing the task lists to poll.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Specifies the task list to poll for decision tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>Specifies the task list to poll for decision tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>Identity of the decider making the request, which is recorded in the
        /// DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when
        /// problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>Identity of the decider making the request, which is recorded in the
        /// DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when
        /// problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        /// <note>
        /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to retrieve
        /// the next page of history records. Calling <a>PollForDecisionTask</a> with a
        /// <code>nextPageToken</code> doesn't return a new decision task.</p>
        /// </note>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        /// <note>
        /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to retrieve
        /// the next page of history records. Calling <a>PollForDecisionTask</a> with a
        /// <code>nextPageToken</code> doesn't return a new decision task.</p>
        /// </note>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>  
        /// <p>This
        /// is an upper limit only; the actual number of results returned per call may be fewer than the
        /// specified maximum.</p>
        pub fn maximum_page_size(mut self, input: i32) -> Self {
            self.maximum_page_size = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>  
        /// <p>This
        /// is an upper limit only; the actual number of results returned per call may be fewer than the
        /// specified maximum.</p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_page_size = input;
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimestamp</code> of the
        /// events.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimestamp</code> of the
        /// events.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Consumes the builder and constructs a [`PollForDecisionTaskInput`](crate::input::PollForDecisionTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PollForDecisionTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PollForDecisionTaskInput {
                domain: self.domain,
                task_list: self.task_list,
                identity: self.identity,
                next_page_token: self.next_page_token,
                maximum_page_size: self.maximum_page_size.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PollForDecisionTaskInputOperationOutputAlias = crate::operation::PollForDecisionTask;
#[doc(hidden)]
pub type PollForDecisionTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PollForDecisionTaskInput {
    /// Consumes the builder and constructs an Operation<[`PollForDecisionTask`](crate::operation::PollForDecisionTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PollForDecisionTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PollForDecisionTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PollForDecisionTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PollForDecisionTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.PollForDecisionTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_poll_for_decision_task(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PollForDecisionTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PollForDecisionTask",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PollForDecisionTaskInput`](crate::input::PollForDecisionTaskInput)
    pub fn builder() -> crate::input::poll_for_decision_task_input::Builder {
        crate::input::poll_for_decision_task_input::Builder::default()
    }
}

/// See [`RecordActivityTaskHeartbeatInput`](crate::input::RecordActivityTaskHeartbeatInput)
pub mod record_activity_task_heartbeat_input {
    /// A builder for [`RecordActivityTaskHeartbeatInput`](crate::input::RecordActivityTaskHeartbeatInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results. </p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results. </p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// <p>If specified, contains details about the progress of the task.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>If specified, contains details about the progress of the task.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordActivityTaskHeartbeatInput`](crate::input::RecordActivityTaskHeartbeatInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RecordActivityTaskHeartbeatInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RecordActivityTaskHeartbeatInput {
                task_token: self.task_token,
                details: self.details,
            })
        }
    }
}
#[doc(hidden)]
pub type RecordActivityTaskHeartbeatInputOperationOutputAlias =
    crate::operation::RecordActivityTaskHeartbeat;
#[doc(hidden)]
pub type RecordActivityTaskHeartbeatInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RecordActivityTaskHeartbeatInput {
    /// Consumes the builder and constructs an Operation<[`RecordActivityTaskHeartbeat`](crate::operation::RecordActivityTaskHeartbeat)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RecordActivityTaskHeartbeat,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RecordActivityTaskHeartbeatInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RecordActivityTaskHeartbeatInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RecordActivityTaskHeartbeatInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RecordActivityTaskHeartbeat",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_record_activity_task_heartbeat(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RecordActivityTaskHeartbeat::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RecordActivityTaskHeartbeat",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RecordActivityTaskHeartbeatInput`](crate::input::RecordActivityTaskHeartbeatInput)
    pub fn builder() -> crate::input::record_activity_task_heartbeat_input::Builder {
        crate::input::record_activity_task_heartbeat_input::Builder::default()
    }
}

/// See [`RegisterActivityTypeInput`](crate::input::RegisterActivityTypeInput)
pub mod register_activity_type_input {
    /// A builder for [`RegisterActivityTypeInput`](crate::input::RegisterActivityTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) default_task_heartbeat_timeout: std::option::Option<std::string::String>,
        pub(crate) default_task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) default_task_priority: std::option::Option<std::string::String>,
        pub(crate) default_task_schedule_to_start_timeout: std::option::Option<std::string::String>,
        pub(crate) default_task_schedule_to_close_timeout: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain in which this activity is to be registered.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which this activity is to be registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The name of the activity type within the domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the activity type within the domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the activity type.</p>
        /// <note>
        /// <p>The activity type consists of the name and version, the combination of which must be
        /// unique within the domain.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the activity type.</p>
        /// <note>
        /// <p>The activity type consists of the name and version, the combination of which must be
        /// unique within the domain.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>A textual description of the activity type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A textual description of the activity type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If set, specifies the default maximum duration that a worker can take to process tasks
        /// of this activity type. This default can be overridden when scheduling an activity task using
        /// the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration that a worker can take to process tasks
        /// of this activity type. This default can be overridden when scheduling an activity task using
        /// the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = input;
            self
        }
        /// <p>If set, specifies the default maximum time before which a worker processing a task of
        /// this type must report progress by calling <a>RecordActivityTaskHeartbeat</a>. If
        /// the timeout is exceeded, the activity task is automatically timed out. This default can be
        /// overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. If the activity worker subsequently attempts to record a heartbeat
        /// or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In
        /// this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should
        /// clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_heartbeat_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_heartbeat_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the default maximum time before which a worker processing a task of
        /// this type must report progress by calling <a>RecordActivityTaskHeartbeat</a>. If
        /// the timeout is exceeded, the activity task is automatically timed out. This default can be
        /// overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. If the activity worker subsequently attempts to record a heartbeat
        /// or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In
        /// this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should
        /// clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_heartbeat_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_heartbeat_timeout = input;
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling tasks of this activity
        /// type. This default task list is used if a task list isn't provided when a task is scheduled
        /// through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        pub fn default_task_list(mut self, input: crate::model::TaskList) -> Self {
            self.default_task_list = Some(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling tasks of this activity
        /// type. This default task list is used if a task list isn't provided when a task is scheduled
        /// through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.default_task_list = input;
            self
        }
        /// <p>The default task priority to assign to the activity type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>in the
        /// <i>Amazon SWF Developer Guide</i>.</i>.</p>
        pub fn default_task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_task_priority = Some(input.into());
            self
        }
        /// <p>The default task priority to assign to the activity type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>in the
        /// <i>Amazon SWF Developer Guide</i>.</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_priority = input;
            self
        }
        /// <p>If set, specifies the default maximum duration that a task of this activity type can
        /// wait before being assigned to a worker. This default can be overridden when scheduling an
        /// activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_start_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_start_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration that a task of this activity type can
        /// wait before being assigned to a worker. This default can be overridden when scheduling an
        /// activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_start_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_start_timeout = input;
            self
        }
        /// <p>If set, specifies the default maximum duration for a task of this activity type. This
        /// default can be overridden when scheduling an activity task using the
        /// <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_close_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration for a task of this activity type. This
        /// default can be overridden when scheduling an activity task using the
        /// <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_schedule_to_close_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterActivityTypeInput`](crate::input::RegisterActivityTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterActivityTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterActivityTypeInput {
                domain: self.domain,
                name: self.name,
                version: self.version,
                description: self.description,
                default_task_start_to_close_timeout: self.default_task_start_to_close_timeout,
                default_task_heartbeat_timeout: self.default_task_heartbeat_timeout,
                default_task_list: self.default_task_list,
                default_task_priority: self.default_task_priority,
                default_task_schedule_to_start_timeout: self.default_task_schedule_to_start_timeout,
                default_task_schedule_to_close_timeout: self.default_task_schedule_to_close_timeout,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterActivityTypeInputOperationOutputAlias = crate::operation::RegisterActivityType;
#[doc(hidden)]
pub type RegisterActivityTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterActivityTypeInput {
    /// Consumes the builder and constructs an Operation<[`RegisterActivityType`](crate::operation::RegisterActivityType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterActivityType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterActivityTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterActivityTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterActivityTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RegisterActivityType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_activity_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterActivityType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterActivityType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterActivityTypeInput`](crate::input::RegisterActivityTypeInput)
    pub fn builder() -> crate::input::register_activity_type_input::Builder {
        crate::input::register_activity_type_input::Builder::default()
    }
}

/// See [`RegisterDomainInput`](crate::input::RegisterDomainInput)
pub mod register_domain_input {
    /// A builder for [`RegisterDomainInput`](crate::input::RegisterDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) workflow_execution_retention_period_in_days:
            std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    }
    impl Builder {
        /// <p>Name of the domain to register. The name must be unique in the region that the domain
        /// is registered in.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the domain to register. The name must be unique in the region that the domain
        /// is registered in.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A text description of the domain.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A text description of the domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The duration (in days) that records and histories of workflow executions on the domain
        /// should be kept by the service. After the retention period, the workflow execution isn't
        /// available in the results of visibility calls.</p>
        /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow
        /// execution history isn't retained. As soon as the workflow execution completes, the execution
        /// record and its history are deleted.</p>
        /// <p>The maximum workflow execution retention period is 90 days. For more information about
        /// Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        pub fn workflow_execution_retention_period_in_days(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.workflow_execution_retention_period_in_days = Some(input.into());
            self
        }
        /// <p>The duration (in days) that records and histories of workflow executions on the domain
        /// should be kept by the service. After the retention period, the workflow execution isn't
        /// available in the results of visibility calls.</p>
        /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow
        /// execution history isn't retained. As soon as the workflow execution completes, the execution
        /// record and its history are deleted.</p>
        /// <p>The maximum workflow execution retention period is 90 days. For more information about
        /// Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_workflow_execution_retention_period_in_days(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workflow_execution_retention_period_in_days = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be added when registering a domain.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::ResourceTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be added when registering a domain.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDomainInput`](crate::input::RegisterDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterDomainInput {
                name: self.name,
                description: self.description,
                workflow_execution_retention_period_in_days: self
                    .workflow_execution_retention_period_in_days,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterDomainInputOperationOutputAlias = crate::operation::RegisterDomain;
#[doc(hidden)]
pub type RegisterDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterDomainInput {
    /// Consumes the builder and constructs an Operation<[`RegisterDomain`](crate::operation::RegisterDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RegisterDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterDomain",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterDomainInput`](crate::input::RegisterDomainInput)
    pub fn builder() -> crate::input::register_domain_input::Builder {
        crate::input::register_domain_input::Builder::default()
    }
}

/// See [`RegisterWorkflowTypeInput`](crate::input::RegisterWorkflowTypeInput)
pub mod register_workflow_type_input {
    /// A builder for [`RegisterWorkflowTypeInput`](crate::input::RegisterWorkflowTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) default_execution_start_to_close_timeout:
            std::option::Option<std::string::String>,
        pub(crate) default_task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) default_task_priority: std::option::Option<std::string::String>,
        pub(crate) default_child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) default_lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain in which to register the workflow type.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which to register the workflow type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The name of the workflow type.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the workflow type.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the workflow type.</p>
        /// <note>
        /// <p>The workflow type consists of the name and version, the combination of which must be
        /// unique within the domain. To get a list of all currently registered workflow types, use the
        /// <a>ListWorkflowTypes</a> action.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the workflow type.</p>
        /// <note>
        /// <p>The workflow type consists of the name and version, the combination of which must be
        /// unique within the domain. To get a list of all currently registered workflow types, use the
        /// <a>ListWorkflowTypes</a> action.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Textual description of the workflow type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Textual description of the workflow type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If set, specifies the default maximum duration of decision tasks for this workflow
        /// type. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration of decision tasks for this workflow
        /// type. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_start_to_close_timeout = input;
            self
        }
        /// <p>If set, specifies the default maximum duration for executions of this workflow type.
        /// You can override this default when starting an execution through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike
        /// some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
        /// <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time
        /// that a workflow execution can run. Exceeding this limit always causes the workflow execution
        /// to time out.</p>
        pub fn default_execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>If set, specifies the default maximum duration for executions of this workflow type.
        /// You can override this default when starting an execution through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike
        /// some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
        /// <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time
        /// that a workflow execution can run. Exceeding this limit always causes the workflow execution
        /// to time out.</p>
        pub fn set_default_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_execution_start_to_close_timeout = input;
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling decision tasks for
        /// executions of this workflow type. This default is used only if a task list isn't provided when
        /// starting the execution through the <a>StartWorkflowExecution</a> Action or
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        pub fn default_task_list(mut self, input: crate::model::TaskList) -> Self {
            self.default_task_list = Some(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling decision tasks for
        /// executions of this workflow type. This default is used only if a task list isn't provided when
        /// starting the execution through the <a>StartWorkflowExecution</a> Action or
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.default_task_list = input;
            self
        }
        /// <p>The default task priority to assign to the workflow type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn default_task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_task_priority = Some(input.into());
            self
        }
        /// <p>The default task priority to assign to the workflow type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_task_priority = input;
            self
        }
        /// <p>If set, specifies the default policy to use for the child workflow executions when a
        /// workflow execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This
        /// default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        pub fn default_child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.default_child_policy = Some(input);
            self
        }
        /// <p>If set, specifies the default policy to use for the child workflow executions when a
        /// workflow execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This
        /// default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        pub fn set_default_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.default_child_policy = input;
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't specify an IAM role when you start this workflow type, the default Lambda role is
        /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn default_lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_lambda_role = Some(input.into());
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't specify an IAM role when you start this workflow type, the default Lambda role is
        /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_default_lambda_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterWorkflowTypeInput`](crate::input::RegisterWorkflowTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterWorkflowTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterWorkflowTypeInput {
                domain: self.domain,
                name: self.name,
                version: self.version,
                description: self.description,
                default_task_start_to_close_timeout: self.default_task_start_to_close_timeout,
                default_execution_start_to_close_timeout: self
                    .default_execution_start_to_close_timeout,
                default_task_list: self.default_task_list,
                default_task_priority: self.default_task_priority,
                default_child_policy: self.default_child_policy,
                default_lambda_role: self.default_lambda_role,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterWorkflowTypeInputOperationOutputAlias = crate::operation::RegisterWorkflowType;
#[doc(hidden)]
pub type RegisterWorkflowTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterWorkflowTypeInput {
    /// Consumes the builder and constructs an Operation<[`RegisterWorkflowType`](crate::operation::RegisterWorkflowType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterWorkflowType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterWorkflowTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterWorkflowTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterWorkflowTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RegisterWorkflowType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_workflow_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterWorkflowType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterWorkflowType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterWorkflowTypeInput`](crate::input::RegisterWorkflowTypeInput)
    pub fn builder() -> crate::input::register_workflow_type_input::Builder {
        crate::input::register_workflow_type_input::Builder::default()
    }
}

/// See [`RequestCancelWorkflowExecutionInput`](crate::input::RequestCancelWorkflowExecutionInput)
pub mod request_cancel_workflow_execution_input {
    /// A builder for [`RequestCancelWorkflowExecutionInput`](crate::input::RequestCancelWorkflowExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain containing the workflow execution to cancel.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution to cancel.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The workflowId of the workflow execution to cancel.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The workflowId of the workflow execution to cancel.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The runId of the workflow execution to cancel.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The runId of the workflow execution to cancel.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestCancelWorkflowExecutionInput`](crate::input::RequestCancelWorkflowExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RequestCancelWorkflowExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RequestCancelWorkflowExecutionInput {
                domain: self.domain,
                workflow_id: self.workflow_id,
                run_id: self.run_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RequestCancelWorkflowExecutionInputOperationOutputAlias =
    crate::operation::RequestCancelWorkflowExecution;
#[doc(hidden)]
pub type RequestCancelWorkflowExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RequestCancelWorkflowExecutionInput {
    /// Consumes the builder and constructs an Operation<[`RequestCancelWorkflowExecution`](crate::operation::RequestCancelWorkflowExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RequestCancelWorkflowExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RequestCancelWorkflowExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RequestCancelWorkflowExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RequestCancelWorkflowExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RequestCancelWorkflowExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_request_cancel_workflow_execution(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RequestCancelWorkflowExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RequestCancelWorkflowExecution",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RequestCancelWorkflowExecutionInput`](crate::input::RequestCancelWorkflowExecutionInput)
    pub fn builder() -> crate::input::request_cancel_workflow_execution_input::Builder {
        crate::input::request_cancel_workflow_execution_input::Builder::default()
    }
}

/// See [`RespondActivityTaskCanceledInput`](crate::input::RespondActivityTaskCanceledInput)
pub mod respond_activity_task_canceled_input {
    /// A builder for [`RespondActivityTaskCanceledInput`](crate::input::RespondActivityTaskCanceledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// <p> Information about the cancellation.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p> Information about the cancellation.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`RespondActivityTaskCanceledInput`](crate::input::RespondActivityTaskCanceledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RespondActivityTaskCanceledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RespondActivityTaskCanceledInput {
                task_token: self.task_token,
                details: self.details,
            })
        }
    }
}
#[doc(hidden)]
pub type RespondActivityTaskCanceledInputOperationOutputAlias =
    crate::operation::RespondActivityTaskCanceled;
#[doc(hidden)]
pub type RespondActivityTaskCanceledInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RespondActivityTaskCanceledInput {
    /// Consumes the builder and constructs an Operation<[`RespondActivityTaskCanceled`](crate::operation::RespondActivityTaskCanceled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RespondActivityTaskCanceled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RespondActivityTaskCanceledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RespondActivityTaskCanceledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RespondActivityTaskCanceledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RespondActivityTaskCanceled",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_respond_activity_task_canceled(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RespondActivityTaskCanceled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RespondActivityTaskCanceled",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RespondActivityTaskCanceledInput`](crate::input::RespondActivityTaskCanceledInput)
    pub fn builder() -> crate::input::respond_activity_task_canceled_input::Builder {
        crate::input::respond_activity_task_canceled_input::Builder::default()
    }
}

/// See [`RespondActivityTaskCompletedInput`](crate::input::RespondActivityTaskCompletedInput)
pub mod respond_activity_task_completed_input {
    /// A builder for [`RespondActivityTaskCompletedInput`](crate::input::RespondActivityTaskCompletedInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) result: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// <p>The result of the activity task. It is a free form string that is implementation
        /// specific.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>The result of the activity task. It is a free form string that is implementation
        /// specific.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`RespondActivityTaskCompletedInput`](crate::input::RespondActivityTaskCompletedInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RespondActivityTaskCompletedInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RespondActivityTaskCompletedInput {
                task_token: self.task_token,
                result: self.result,
            })
        }
    }
}
#[doc(hidden)]
pub type RespondActivityTaskCompletedInputOperationOutputAlias =
    crate::operation::RespondActivityTaskCompleted;
#[doc(hidden)]
pub type RespondActivityTaskCompletedInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RespondActivityTaskCompletedInput {
    /// Consumes the builder and constructs an Operation<[`RespondActivityTaskCompleted`](crate::operation::RespondActivityTaskCompleted)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RespondActivityTaskCompleted,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RespondActivityTaskCompletedInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RespondActivityTaskCompletedInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RespondActivityTaskCompletedInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RespondActivityTaskCompleted",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_respond_activity_task_completed(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RespondActivityTaskCompleted::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RespondActivityTaskCompleted",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RespondActivityTaskCompletedInput`](crate::input::RespondActivityTaskCompletedInput)
    pub fn builder() -> crate::input::respond_activity_task_completed_input::Builder {
        crate::input::respond_activity_task_completed_input::Builder::default()
    }
}

/// See [`RespondActivityTaskFailedInput`](crate::input::RespondActivityTaskFailedInput)
pub mod respond_activity_task_failed_input {
    /// A builder for [`RespondActivityTaskFailedInput`](crate::input::RespondActivityTaskFailedInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        ///
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        ///
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// <p>Description of the error that may assist in diagnostics.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Description of the error that may assist in diagnostics.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p> Detailed information about the failure.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p> Detailed information about the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`RespondActivityTaskFailedInput`](crate::input::RespondActivityTaskFailedInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RespondActivityTaskFailedInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RespondActivityTaskFailedInput {
                task_token: self.task_token,
                reason: self.reason,
                details: self.details,
            })
        }
    }
}
#[doc(hidden)]
pub type RespondActivityTaskFailedInputOperationOutputAlias =
    crate::operation::RespondActivityTaskFailed;
#[doc(hidden)]
pub type RespondActivityTaskFailedInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RespondActivityTaskFailedInput {
    /// Consumes the builder and constructs an Operation<[`RespondActivityTaskFailed`](crate::operation::RespondActivityTaskFailed)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RespondActivityTaskFailed,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RespondActivityTaskFailedInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RespondActivityTaskFailedInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RespondActivityTaskFailedInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RespondActivityTaskFailed",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_respond_activity_task_failed(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RespondActivityTaskFailed::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RespondActivityTaskFailed",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RespondActivityTaskFailedInput`](crate::input::RespondActivityTaskFailedInput)
    pub fn builder() -> crate::input::respond_activity_task_failed_input::Builder {
        crate::input::respond_activity_task_failed_input::Builder::default()
    }
}

/// See [`RespondDecisionTaskCompletedInput`](crate::input::RespondDecisionTaskCompletedInput)
pub mod respond_decision_task_completed_input {
    /// A builder for [`RespondDecisionTaskCompletedInput`](crate::input::RespondDecisionTaskCompletedInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) decisions: std::option::Option<std::vec::Vec<crate::model::Decision>>,
        pub(crate) execution_context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// Appends an item to `decisions`.
        ///
        /// To override the contents of this collection use [`set_decisions`](Self::set_decisions).
        ///
        /// <p>The list of decisions (possibly empty) made by the decider while processing this
        /// decision task. See the docs for the <a>Decision</a> structure for
        /// details.</p>
        pub fn decisions(mut self, input: impl Into<crate::model::Decision>) -> Self {
            let mut v = self.decisions.unwrap_or_default();
            v.push(input.into());
            self.decisions = Some(v);
            self
        }
        /// <p>The list of decisions (possibly empty) made by the decider while processing this
        /// decision task. See the docs for the <a>Decision</a> structure for
        /// details.</p>
        pub fn set_decisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Decision>>,
        ) -> Self {
            self.decisions = input;
            self
        }
        /// <p>User defined context to add to workflow execution.</p>
        pub fn execution_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_context = Some(input.into());
            self
        }
        /// <p>User defined context to add to workflow execution.</p>
        pub fn set_execution_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_context = input;
            self
        }
        /// Consumes the builder and constructs a [`RespondDecisionTaskCompletedInput`](crate::input::RespondDecisionTaskCompletedInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RespondDecisionTaskCompletedInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RespondDecisionTaskCompletedInput {
                task_token: self.task_token,
                decisions: self.decisions,
                execution_context: self.execution_context,
            })
        }
    }
}
#[doc(hidden)]
pub type RespondDecisionTaskCompletedInputOperationOutputAlias =
    crate::operation::RespondDecisionTaskCompleted;
#[doc(hidden)]
pub type RespondDecisionTaskCompletedInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RespondDecisionTaskCompletedInput {
    /// Consumes the builder and constructs an Operation<[`RespondDecisionTaskCompleted`](crate::operation::RespondDecisionTaskCompleted)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RespondDecisionTaskCompleted,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RespondDecisionTaskCompletedInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RespondDecisionTaskCompletedInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RespondDecisionTaskCompletedInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.RespondDecisionTaskCompleted",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_respond_decision_task_completed(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RespondDecisionTaskCompleted::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RespondDecisionTaskCompleted",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RespondDecisionTaskCompletedInput`](crate::input::RespondDecisionTaskCompletedInput)
    pub fn builder() -> crate::input::respond_decision_task_completed_input::Builder {
        crate::input::respond_decision_task_completed_input::Builder::default()
    }
}

/// See [`SignalWorkflowExecutionInput`](crate::input::SignalWorkflowExecutionInput)
pub mod signal_workflow_execution_input {
    /// A builder for [`SignalWorkflowExecutionInput`](crate::input::SignalWorkflowExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) signal_name: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain containing the workflow execution to signal.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain containing the workflow execution to signal.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The workflowId of the workflow execution to signal.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The workflowId of the workflow execution to signal.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The runId of the workflow execution to signal.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The runId of the workflow execution to signal.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
        pub fn signal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.signal_name = Some(input.into());
            self
        }
        /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
        pub fn set_signal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signal_name = input;
            self
        }
        /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target
        /// workflow execution's history.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target
        /// workflow execution's history.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// Consumes the builder and constructs a [`SignalWorkflowExecutionInput`](crate::input::SignalWorkflowExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SignalWorkflowExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SignalWorkflowExecutionInput {
                domain: self.domain,
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                signal_name: self.signal_name,
                input: self.input,
            })
        }
    }
}
#[doc(hidden)]
pub type SignalWorkflowExecutionInputOperationOutputAlias =
    crate::operation::SignalWorkflowExecution;
#[doc(hidden)]
pub type SignalWorkflowExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SignalWorkflowExecutionInput {
    /// Consumes the builder and constructs an Operation<[`SignalWorkflowExecution`](crate::operation::SignalWorkflowExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SignalWorkflowExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SignalWorkflowExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SignalWorkflowExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SignalWorkflowExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.SignalWorkflowExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_signal_workflow_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SignalWorkflowExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SignalWorkflowExecution",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SignalWorkflowExecutionInput`](crate::input::SignalWorkflowExecutionInput)
    pub fn builder() -> crate::input::signal_workflow_execution_input::Builder {
        crate::input::signal_workflow_execution_input::Builder::default()
    }
}

/// See [`StartWorkflowExecutionInput`](crate::input::StartWorkflowExecutionInput)
pub mod start_workflow_execution_input {
    /// A builder for [`StartWorkflowExecutionInput`](crate::input::StartWorkflowExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) task_list: std::option::Option<crate::model::TaskList>,
        pub(crate) task_priority: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) execution_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) task_start_to_close_timeout: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
        pub(crate) lambda_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain in which the workflow execution is created.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain in which the workflow execution is created.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The user defined identifier associated with the workflow execution. You can use this to
        /// associate a custom identifier with the workflow execution. You may specify the same identifier
        /// if a workflow execution is logically a <i>restart</i> of a previous execution.
        /// You cannot have two open workflow executions with the same <code>workflowId</code> at the same
        /// time within the same domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The user defined identifier associated with the workflow execution. You can use this to
        /// associate a custom identifier with the workflow execution. You may specify the same identifier
        /// if a workflow execution is logically a <i>restart</i> of a previous execution.
        /// You cannot have two open workflow executions with the same <code>workflowId</code> at the same
        /// time within the same domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The type of the workflow to start.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of the workflow to start.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>The task list to use for the decision tasks generated for this workflow execution. This
        /// overrides the <code>defaultTaskList</code> specified when registering the workflow
        /// type.</p>
        /// <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the
        /// workflow type or through this parameter. If neither this parameter is set nor a default task
        /// list was specified at registration time then a fault is returned.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, input: crate::model::TaskList) -> Self {
            self.task_list = Some(input);
            self
        }
        /// <p>The task list to use for the decision tasks generated for this workflow execution. This
        /// overrides the <code>defaultTaskList</code> specified when registering the workflow
        /// type.</p>
        /// <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the
        /// workflow type or through this parameter. If neither this parameter is set nor a default task
        /// list was specified at registration time then a fault is returned.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.task_list = input;
            self
        }
        /// <p>The task priority to use for this workflow execution. This overrides any default
        /// priority that was assigned when the workflow type was registered. If not set, then the default
        /// task priority for the workflow type is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_priority = Some(input.into());
            self
        }
        /// <p>The task priority to use for this workflow execution. This overrides any default
        /// priority that was assigned when the workflow type was registered. If not set, then the default
        /// task priority for the workflow type is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_priority = input;
            self
        }
        /// <p>The input for the workflow execution. This is a free form string which should be
        /// meaningful to the workflow you are starting. This <code>input</code> is made available to the
        /// new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The input for the workflow execution. This is a free form string which should be
        /// meaningful to the workflow you are starting. This <code>input</code> is made available to the
        /// new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the
        /// defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to
        /// <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some
        /// of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this
        /// timeout; there is a one-year max limit on the time that a workflow execution can
        /// run.</p>
        ///
        /// <note>
        /// <p>An execution start-to-close timeout must be specified either through this parameter
        /// or as a default when the workflow type is registered. If neither this parameter nor a
        /// default execution start-to-close timeout is specified, a fault is returned.</p>
        /// </note>
        pub fn execution_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the
        /// defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to
        /// <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some
        /// of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this
        /// timeout; there is a one-year max limit on the time that a workflow execution can
        /// run.</p>
        ///
        /// <note>
        /// <p>An execution start-to-close timeout must be specified either through this parameter
        /// or as a default when the workflow type is registered. If neither this parameter nor a
        /// default execution start-to-close timeout is specified, a fault is returned.</p>
        /// </note>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_to_close_timeout = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of
        /// 5 tags. You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or <a>ListClosedWorkflowExecutions</a> and
        /// specifying a <a>TagFilter</a>.</p>
        pub fn tag_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of
        /// 5 tags. You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or <a>ListClosedWorkflowExecutions</a> and
        /// specifying a <a>TagFilter</a>.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This
        /// parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering
        /// the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as
        /// a default for the workflow type or through this parameter. If neither this parameter is set
        /// nor a default task start-to-close timeout was specified at registration time then a fault is
        /// returned.</p>
        /// </note>
        pub fn task_start_to_close_timeout(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = Some(input.into());
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This
        /// parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering
        /// the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as
        /// a default for the workflow type or through this parameter. If neither this parameter is set
        /// nor a default task start-to-close timeout was specified at registration time then a fault is
        /// returned.</p>
        /// </note>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_start_to_close_timeout = input;
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of this workflow
        /// execution if it is terminated, by calling the <a>TerminateWorkflowExecution</a>
        /// action explicitly or due to an expired timeout. This policy overrides the default child policy
        /// specified when registering the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of this workflow
        /// execution if it is terminated, by calling the <a>TerminateWorkflowExecution</a>
        /// action explicitly or due to an expired timeout. This policy overrides the default child policy
        /// specified when registering the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// <p>The IAM role to attach to this workflow execution.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a
        /// <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn lambda_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_role = Some(input.into());
            self
        }
        /// <p>The IAM role to attach to this workflow execution.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a
        /// <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_role = input;
            self
        }
        /// Consumes the builder and constructs a [`StartWorkflowExecutionInput`](crate::input::StartWorkflowExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartWorkflowExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartWorkflowExecutionInput {
                domain: self.domain,
                workflow_id: self.workflow_id,
                workflow_type: self.workflow_type,
                task_list: self.task_list,
                task_priority: self.task_priority,
                input: self.input,
                execution_start_to_close_timeout: self.execution_start_to_close_timeout,
                tag_list: self.tag_list,
                task_start_to_close_timeout: self.task_start_to_close_timeout,
                child_policy: self.child_policy,
                lambda_role: self.lambda_role,
            })
        }
    }
}
#[doc(hidden)]
pub type StartWorkflowExecutionInputOperationOutputAlias = crate::operation::StartWorkflowExecution;
#[doc(hidden)]
pub type StartWorkflowExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartWorkflowExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartWorkflowExecution`](crate::operation::StartWorkflowExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartWorkflowExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartWorkflowExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartWorkflowExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartWorkflowExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.StartWorkflowExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_workflow_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartWorkflowExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartWorkflowExecution",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartWorkflowExecutionInput`](crate::input::StartWorkflowExecutionInput)
    pub fn builder() -> crate::input::start_workflow_execution_input::Builder {
        crate::input::start_workflow_execution_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a domain. </p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::ResourceTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags to add to a domain. </p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TerminateWorkflowExecutionInput`](crate::input::TerminateWorkflowExecutionInput)
pub mod terminate_workflow_execution_input {
    /// A builder for [`TerminateWorkflowExecutionInput`](crate::input::TerminateWorkflowExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) child_policy: std::option::Option<crate::model::ChildPolicy>,
    }
    impl Builder {
        /// <p>The domain of the workflow execution to terminate.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain of the workflow execution to terminate.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The workflowId of the workflow execution to terminate.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>The workflowId of the workflow execution to terminate.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The runId of the workflow execution to terminate.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The runId of the workflow execution to terminate.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p> A descriptive reason for terminating the workflow execution.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p> A descriptive reason for terminating the workflow execution.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p> Details for terminating the workflow execution.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p> Details for terminating the workflow execution.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the workflow
        /// execution being terminated. This policy overrides the child policy specified for the workflow
        /// execution at registration time or when starting the execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, input: crate::model::ChildPolicy) -> Self {
            self.child_policy = Some(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the workflow
        /// execution being terminated. This policy overrides the child policy specified for the workflow
        /// execution at registration time or when starting the execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.child_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateWorkflowExecutionInput`](crate::input::TerminateWorkflowExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateWorkflowExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateWorkflowExecutionInput {
                domain: self.domain,
                workflow_id: self.workflow_id,
                run_id: self.run_id,
                reason: self.reason,
                details: self.details,
                child_policy: self.child_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateWorkflowExecutionInputOperationOutputAlias =
    crate::operation::TerminateWorkflowExecution;
#[doc(hidden)]
pub type TerminateWorkflowExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TerminateWorkflowExecutionInput {
    /// Consumes the builder and constructs an Operation<[`TerminateWorkflowExecution`](crate::operation::TerminateWorkflowExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateWorkflowExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TerminateWorkflowExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TerminateWorkflowExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TerminateWorkflowExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.TerminateWorkflowExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_terminate_workflow_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateWorkflowExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateWorkflowExecution",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TerminateWorkflowExecutionInput`](crate::input::TerminateWorkflowExecutionInput)
    pub fn builder() -> crate::input::terminate_workflow_execution_input::Builder {
        crate::input::terminate_workflow_execution_input::Builder::default()
    }
}

/// See [`UndeprecateActivityTypeInput`](crate::input::UndeprecateActivityTypeInput)
pub mod undeprecate_activity_type_input {
    /// A builder for [`UndeprecateActivityTypeInput`](crate::input::UndeprecateActivityTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) activity_type: std::option::Option<crate::model::ActivityType>,
    }
    impl Builder {
        /// <p>The name of the domain of the deprecated activity type.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain of the deprecated activity type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The activity type to undeprecate.</p>
        pub fn activity_type(mut self, input: crate::model::ActivityType) -> Self {
            self.activity_type = Some(input);
            self
        }
        /// <p>The activity type to undeprecate.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.activity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UndeprecateActivityTypeInput`](crate::input::UndeprecateActivityTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UndeprecateActivityTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UndeprecateActivityTypeInput {
                domain: self.domain,
                activity_type: self.activity_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UndeprecateActivityTypeInputOperationOutputAlias =
    crate::operation::UndeprecateActivityType;
#[doc(hidden)]
pub type UndeprecateActivityTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UndeprecateActivityTypeInput {
    /// Consumes the builder and constructs an Operation<[`UndeprecateActivityType`](crate::operation::UndeprecateActivityType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UndeprecateActivityType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UndeprecateActivityTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UndeprecateActivityTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UndeprecateActivityTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.UndeprecateActivityType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_undeprecate_activity_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UndeprecateActivityType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UndeprecateActivityType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UndeprecateActivityTypeInput`](crate::input::UndeprecateActivityTypeInput)
    pub fn builder() -> crate::input::undeprecate_activity_type_input::Builder {
        crate::input::undeprecate_activity_type_input::Builder::default()
    }
}

/// See [`UndeprecateDomainInput`](crate::input::UndeprecateDomainInput)
pub mod undeprecate_domain_input {
    /// A builder for [`UndeprecateDomainInput`](crate::input::UndeprecateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UndeprecateDomainInput`](crate::input::UndeprecateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UndeprecateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UndeprecateDomainInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type UndeprecateDomainInputOperationOutputAlias = crate::operation::UndeprecateDomain;
#[doc(hidden)]
pub type UndeprecateDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UndeprecateDomainInput {
    /// Consumes the builder and constructs an Operation<[`UndeprecateDomain`](crate::operation::UndeprecateDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UndeprecateDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UndeprecateDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UndeprecateDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UndeprecateDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.UndeprecateDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_undeprecate_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UndeprecateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UndeprecateDomain",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UndeprecateDomainInput`](crate::input::UndeprecateDomainInput)
    pub fn builder() -> crate::input::undeprecate_domain_input::Builder {
        crate::input::undeprecate_domain_input::Builder::default()
    }
}

/// See [`UndeprecateWorkflowTypeInput`](crate::input::UndeprecateWorkflowTypeInput)
pub mod undeprecate_workflow_type_input {
    /// A builder for [`UndeprecateWorkflowTypeInput`](crate::input::UndeprecateWorkflowTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
    }
    impl Builder {
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UndeprecateWorkflowTypeInput`](crate::input::UndeprecateWorkflowTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UndeprecateWorkflowTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UndeprecateWorkflowTypeInput {
                domain: self.domain,
                workflow_type: self.workflow_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UndeprecateWorkflowTypeInputOperationOutputAlias =
    crate::operation::UndeprecateWorkflowType;
#[doc(hidden)]
pub type UndeprecateWorkflowTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UndeprecateWorkflowTypeInput {
    /// Consumes the builder and constructs an Operation<[`UndeprecateWorkflowType`](crate::operation::UndeprecateWorkflowType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UndeprecateWorkflowType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UndeprecateWorkflowTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UndeprecateWorkflowTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UndeprecateWorkflowTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.UndeprecateWorkflowType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_undeprecate_workflow_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UndeprecateWorkflowType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UndeprecateWorkflowType",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UndeprecateWorkflowTypeInput`](crate::input::UndeprecateWorkflowTypeInput)
    pub fn builder() -> crate::input::undeprecate_workflow_type_input::Builder {
        crate::input::undeprecate_workflow_type_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tags to remove from the Amazon SWF domain.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tags to remove from the Amazon SWF domain.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SimpleWorkflowService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "swf",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tags to remove from the Amazon SWF domain.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tags to remove from the Amazon SWF domain.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UndeprecateWorkflowTypeInput {
    /// <p>The name of the domain of the deprecated workflow type.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The name of the domain of the deprecated workflow type.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
}
impl UndeprecateWorkflowTypeInput {
    /// <p>The name of the domain of the deprecated workflow type.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The name of the domain of the deprecated workflow type.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
}
impl std::fmt::Debug for UndeprecateWorkflowTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UndeprecateWorkflowTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UndeprecateDomainInput {
    /// <p>The name of the domain of the deprecated workflow type.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UndeprecateDomainInput {
    /// <p>The name of the domain of the deprecated workflow type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UndeprecateDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UndeprecateDomainInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UndeprecateActivityTypeInput {
    /// <p>The name of the domain of the deprecated activity type.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The activity type to undeprecate.</p>
    pub activity_type: std::option::Option<crate::model::ActivityType>,
}
impl UndeprecateActivityTypeInput {
    /// <p>The name of the domain of the deprecated activity type.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The activity type to undeprecate.</p>
    pub fn activity_type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.activity_type.as_ref()
    }
}
impl std::fmt::Debug for UndeprecateActivityTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UndeprecateActivityTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("activity_type", &self.activity_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateWorkflowExecutionInput {
    /// <p>The domain of the workflow execution to terminate.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The workflowId of the workflow execution to terminate.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The runId of the workflow execution to terminate.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p> A descriptive reason for terminating the workflow execution.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p> Details for terminating the workflow execution.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>If set, specifies the policy to use for the child workflow executions of the workflow
    /// execution being terminated. This policy overrides the child policy specified for the workflow
    /// execution at registration time or when starting the execution.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
    /// history. It is up to the decider to take appropriate actions when it receives an execution
    /// history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to
    /// run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for
    /// the workflow type or through this parameter. If neither this parameter is set nor a default
    /// child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
}
impl TerminateWorkflowExecutionInput {
    /// <p>The domain of the workflow execution to terminate.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The workflowId of the workflow execution to terminate.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The runId of the workflow execution to terminate.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p> A descriptive reason for terminating the workflow execution.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p> Details for terminating the workflow execution.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>If set, specifies the policy to use for the child workflow executions of the workflow
    /// execution being terminated. This policy overrides the child policy specified for the workflow
    /// execution at registration time or when starting the execution.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
    /// history. It is up to the decider to take appropriate actions when it receives an execution
    /// history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to
    /// run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for
    /// the workflow type or through this parameter. If neither this parameter is set nor a default
    /// child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
}
impl std::fmt::Debug for TerminateWorkflowExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateWorkflowExecutionInput");
        formatter.field("domain", &self.domain);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.field("child_policy", &self.child_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tags to add to a domain. </p>
    /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tags to add to a domain. </p>
    /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::ResourceTag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartWorkflowExecutionInput {
    /// <p>The name of the domain in which the workflow execution is created.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The user defined identifier associated with the workflow execution. You can use this to
    /// associate a custom identifier with the workflow execution. You may specify the same identifier
    /// if a workflow execution is logically a <i>restart</i> of a previous execution.
    /// You cannot have two open workflow executions with the same <code>workflowId</code> at the same
    /// time within the same domain.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The type of the workflow to start.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>The task list to use for the decision tasks generated for this workflow execution. This
    /// overrides the <code>defaultTaskList</code> specified when registering the workflow
    /// type.</p>
    /// <note>
    /// <p>A task list for this workflow execution must be specified either as a default for the
    /// workflow type or through this parameter. If neither this parameter is set nor a default task
    /// list was specified at registration time then a fault is returned.</p>
    /// </note>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>The task priority to use for this workflow execution. This overrides any default
    /// priority that was assigned when the workflow type was registered. If not set, then the default
    /// task priority for the workflow type is used. Valid values are integers that range from Java's
    /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
    /// Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
    /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub task_priority: std::option::Option<std::string::String>,
    /// <p>The input for the workflow execution. This is a free form string which should be
    /// meaningful to the workflow you are starting. This <code>input</code> is made available to the
    /// new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The total duration for this workflow execution. This overrides the
    /// defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
    ///
    /// <p>The duration is specified in seconds; an integer greater than or equal to
    /// <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some
    /// of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this
    /// timeout; there is a one-year max limit on the time that a workflow execution can
    /// run.</p>
    ///
    /// <note>
    /// <p>An execution start-to-close timeout must be specified either through this parameter
    /// or as a default when the workflow type is registered. If neither this parameter nor a
    /// default execution start-to-close timeout is specified, a fault is returned.</p>
    /// </note>
    pub execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of
    /// 5 tags. You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or <a>ListClosedWorkflowExecutions</a> and
    /// specifying a <a>TagFilter</a>.</p>
    pub tag_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This
    /// parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering
    /// the workflow type using <a>RegisterWorkflowType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A task start-to-close timeout for this workflow execution must be specified either as
    /// a default for the workflow type or through this parameter. If neither this parameter is set
    /// nor a default task start-to-close timeout was specified at registration time then a fault is
    /// returned.</p>
    /// </note>
    pub task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the policy to use for the child workflow executions of this workflow
    /// execution if it is terminated, by calling the <a>TerminateWorkflowExecution</a>
    /// action explicitly or due to an expired timeout. This policy overrides the default child policy
    /// specified when registering the workflow type using <a>RegisterWorkflowType</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
    /// history. It is up to the decider to take appropriate actions when it receives an execution
    /// history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to
    /// run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for
    /// the workflow type or through this parameter. If neither this parameter is set nor a default
    /// child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The IAM role to attach to this workflow execution.</p>
    /// <note>
    /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
    /// don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a
    /// <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub lambda_role: std::option::Option<std::string::String>,
}
impl StartWorkflowExecutionInput {
    /// <p>The name of the domain in which the workflow execution is created.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The user defined identifier associated with the workflow execution. You can use this to
    /// associate a custom identifier with the workflow execution. You may specify the same identifier
    /// if a workflow execution is logically a <i>restart</i> of a previous execution.
    /// You cannot have two open workflow executions with the same <code>workflowId</code> at the same
    /// time within the same domain.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The type of the workflow to start.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>The task list to use for the decision tasks generated for this workflow execution. This
    /// overrides the <code>defaultTaskList</code> specified when registering the workflow
    /// type.</p>
    /// <note>
    /// <p>A task list for this workflow execution must be specified either as a default for the
    /// workflow type or through this parameter. If neither this parameter is set nor a default task
    /// list was specified at registration time then a fault is returned.</p>
    /// </note>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>The task priority to use for this workflow execution. This overrides any default
    /// priority that was assigned when the workflow type was registered. If not set, then the default
    /// task priority for the workflow type is used. Valid values are integers that range from Java's
    /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
    /// Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
    /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn task_priority(&self) -> std::option::Option<&str> {
        self.task_priority.as_deref()
    }
    /// <p>The input for the workflow execution. This is a free form string which should be
    /// meaningful to the workflow you are starting. This <code>input</code> is made available to the
    /// new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>The total duration for this workflow execution. This overrides the
    /// defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
    ///
    /// <p>The duration is specified in seconds; an integer greater than or equal to
    /// <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some
    /// of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this
    /// timeout; there is a one-year max limit on the time that a workflow execution can
    /// run.</p>
    ///
    /// <note>
    /// <p>An execution start-to-close timeout must be specified either through this parameter
    /// or as a default when the workflow type is registered. If neither this parameter nor a
    /// default execution start-to-close timeout is specified, a fault is returned.</p>
    /// </note>
    pub fn execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.execution_start_to_close_timeout.as_deref()
    }
    /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of
    /// 5 tags. You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or <a>ListClosedWorkflowExecutions</a> and
    /// specifying a <a>TagFilter</a>.</p>
    pub fn tag_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_list.as_deref()
    }
    /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This
    /// parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering
    /// the workflow type using <a>RegisterWorkflowType</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    /// <note>
    /// <p>A task start-to-close timeout for this workflow execution must be specified either as
    /// a default for the workflow type or through this parameter. If neither this parameter is set
    /// nor a default task start-to-close timeout was specified at registration time then a fault is
    /// returned.</p>
    /// </note>
    pub fn task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.task_start_to_close_timeout.as_deref()
    }
    /// <p>If set, specifies the policy to use for the child workflow executions of this workflow
    /// execution if it is terminated, by calling the <a>TerminateWorkflowExecution</a>
    /// action explicitly or due to an expired timeout. This policy overrides the default child policy
    /// specified when registering the workflow type using <a>RegisterWorkflowType</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
    /// history. It is up to the decider to take appropriate actions when it receives an execution
    /// history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to
    /// run.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>A child policy for this workflow execution must be specified either as a default for
    /// the workflow type or through this parameter. If neither this parameter is set nor a default
    /// child policy was specified at registration time then a fault is returned.</p>
    /// </note>
    pub fn child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.child_policy.as_ref()
    }
    /// <p>The IAM role to attach to this workflow execution.</p>
    /// <note>
    /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
    /// don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a
    /// <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn lambda_role(&self) -> std::option::Option<&str> {
        self.lambda_role.as_deref()
    }
}
impl std::fmt::Debug for StartWorkflowExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartWorkflowExecutionInput");
        formatter.field("domain", &self.domain);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("task_list", &self.task_list);
        formatter.field("task_priority", &self.task_priority);
        formatter.field("input", &self.input);
        formatter.field(
            "execution_start_to_close_timeout",
            &self.execution_start_to_close_timeout,
        );
        formatter.field("tag_list", &self.tag_list);
        formatter.field(
            "task_start_to_close_timeout",
            &self.task_start_to_close_timeout,
        );
        formatter.field("child_policy", &self.child_policy);
        formatter.field("lambda_role", &self.lambda_role);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignalWorkflowExecutionInput {
    /// <p>The name of the domain containing the workflow execution to signal.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The workflowId of the workflow execution to signal.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The runId of the workflow execution to signal.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
    pub signal_name: std::option::Option<std::string::String>,
    /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target
    /// workflow execution's history.</p>
    pub input: std::option::Option<std::string::String>,
}
impl SignalWorkflowExecutionInput {
    /// <p>The name of the domain containing the workflow execution to signal.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The workflowId of the workflow execution to signal.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The runId of the workflow execution to signal.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
    pub fn signal_name(&self) -> std::option::Option<&str> {
        self.signal_name.as_deref()
    }
    /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target
    /// workflow execution's history.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
}
impl std::fmt::Debug for SignalWorkflowExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignalWorkflowExecutionInput");
        formatter.field("domain", &self.domain);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("signal_name", &self.signal_name);
        formatter.field("input", &self.input);
        formatter.finish()
    }
}

/// <p>Input data for a TaskCompleted response to a decision task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RespondDecisionTaskCompletedInput {
    /// <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub task_token: std::option::Option<std::string::String>,
    /// <p>The list of decisions (possibly empty) made by the decider while processing this
    /// decision task. See the docs for the <a>Decision</a> structure for
    /// details.</p>
    pub decisions: std::option::Option<std::vec::Vec<crate::model::Decision>>,
    /// <p>User defined context to add to workflow execution.</p>
    pub execution_context: std::option::Option<std::string::String>,
}
impl RespondDecisionTaskCompletedInput {
    /// <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p>The list of decisions (possibly empty) made by the decider while processing this
    /// decision task. See the docs for the <a>Decision</a> structure for
    /// details.</p>
    pub fn decisions(&self) -> std::option::Option<&[crate::model::Decision]> {
        self.decisions.as_deref()
    }
    /// <p>User defined context to add to workflow execution.</p>
    pub fn execution_context(&self) -> std::option::Option<&str> {
        self.execution_context.as_deref()
    }
}
impl std::fmt::Debug for RespondDecisionTaskCompletedInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RespondDecisionTaskCompletedInput");
        formatter.field("task_token", &self.task_token);
        formatter.field("decisions", &self.decisions);
        formatter.field("execution_context", &self.execution_context);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RespondActivityTaskFailedInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    ///
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub task_token: std::option::Option<std::string::String>,
    /// <p>Description of the error that may assist in diagnostics.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p> Detailed information about the failure.</p>
    pub details: std::option::Option<std::string::String>,
}
impl RespondActivityTaskFailedInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    ///
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p>Description of the error that may assist in diagnostics.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p> Detailed information about the failure.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for RespondActivityTaskFailedInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RespondActivityTaskFailedInput");
        formatter.field("task_token", &self.task_token);
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RespondActivityTaskCompletedInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub task_token: std::option::Option<std::string::String>,
    /// <p>The result of the activity task. It is a free form string that is implementation
    /// specific.</p>
    pub result: std::option::Option<std::string::String>,
}
impl RespondActivityTaskCompletedInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p>The result of the activity task. It is a free form string that is implementation
    /// specific.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
}
impl std::fmt::Debug for RespondActivityTaskCompletedInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RespondActivityTaskCompletedInput");
        formatter.field("task_token", &self.task_token);
        formatter.field("result", &self.result);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RespondActivityTaskCanceledInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub task_token: std::option::Option<std::string::String>,
    /// <p> Information about the cancellation.</p>
    pub details: std::option::Option<std::string::String>,
}
impl RespondActivityTaskCanceledInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results.</p>
    /// </important>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p> Information about the cancellation.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for RespondActivityTaskCanceledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RespondActivityTaskCanceledInput");
        formatter.field("task_token", &self.task_token);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestCancelWorkflowExecutionInput {
    /// <p>The name of the domain containing the workflow execution to cancel.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The workflowId of the workflow execution to cancel.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The runId of the workflow execution to cancel.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl RequestCancelWorkflowExecutionInput {
    /// <p>The name of the domain containing the workflow execution to cancel.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The workflowId of the workflow execution to cancel.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The runId of the workflow execution to cancel.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
}
impl std::fmt::Debug for RequestCancelWorkflowExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestCancelWorkflowExecutionInput");
        formatter.field("domain", &self.domain);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterWorkflowTypeInput {
    /// <p>The name of the domain in which to register the workflow type.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The name of the workflow type.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the workflow type.</p>
    /// <note>
    /// <p>The workflow type consists of the name and version, the combination of which must be
    /// unique within the domain. To get a list of all currently registered workflow types, use the
    /// <a>ListWorkflowTypes</a> action.</p>
    /// </note>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Textual description of the workflow type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default maximum duration of decision tasks for this workflow
    /// type. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default maximum duration for executions of this workflow type.
    /// You can override this default when starting an execution through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    ///
    /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike
    /// some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
    /// <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time
    /// that a workflow execution can run. Exceeding this limit always causes the workflow execution
    /// to time out.</p>
    pub default_execution_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default task list to use for scheduling decision tasks for
    /// executions of this workflow type. This default is used only if a task list isn't provided when
    /// starting the execution through the <a>StartWorkflowExecution</a> Action or
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    pub default_task_list: std::option::Option<crate::model::TaskList>,
    /// <p>The default task priority to assign to the workflow type. If not assigned, then
    /// <code>0</code> is used. Valid values are integers that range from Java's
    /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
    /// Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
    /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub default_task_priority: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default policy to use for the child workflow executions when a
    /// workflow execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This
    /// default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
    /// history. It is up to the decider to take appropriate actions when it receives an execution
    /// history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to
    /// run.</p>
    /// </li>
    /// </ul>
    pub default_child_policy: std::option::Option<crate::model::ChildPolicy>,
    /// <p>The default IAM role attached to this workflow type.</p>
    /// <note>
    /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
    /// don't specify an IAM role when you start this workflow type, the default Lambda role is
    /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub default_lambda_role: std::option::Option<std::string::String>,
}
impl RegisterWorkflowTypeInput {
    /// <p>The name of the domain in which to register the workflow type.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The name of the workflow type.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the workflow type.</p>
    /// <note>
    /// <p>The workflow type consists of the name and version, the combination of which must be
    /// unique within the domain. To get a list of all currently registered workflow types, use the
    /// <a>ListWorkflowTypes</a> action.</p>
    /// </note>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Textual description of the workflow type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>If set, specifies the default maximum duration of decision tasks for this workflow
    /// type. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_task_start_to_close_timeout.as_deref()
    }
    /// <p>If set, specifies the default maximum duration for executions of this workflow type.
    /// You can override this default when starting an execution through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    ///
    /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike
    /// some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
    /// <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time
    /// that a workflow execution can run. Exceeding this limit always causes the workflow execution
    /// to time out.</p>
    pub fn default_execution_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_execution_start_to_close_timeout.as_deref()
    }
    /// <p>If set, specifies the default task list to use for scheduling decision tasks for
    /// executions of this workflow type. This default is used only if a task list isn't provided when
    /// starting the execution through the <a>StartWorkflowExecution</a> Action or
    /// <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    pub fn default_task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.default_task_list.as_ref()
    }
    /// <p>The default task priority to assign to the workflow type. If not assigned, then
    /// <code>0</code> is used. Valid values are integers that range from Java's
    /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
    /// Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
    /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    pub fn default_task_priority(&self) -> std::option::Option<&str> {
        self.default_task_priority.as_deref()
    }
    /// <p>If set, specifies the default policy to use for the child workflow executions when a
    /// workflow execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This
    /// default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
    /// <a>Decision</a>.</p>
    /// <p>The supported child policies are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE</code> – The child executions are terminated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
    /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
    /// history. It is up to the decider to take appropriate actions when it receives an execution
    /// history with this event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ABANDON</code> – No action is taken. The child executions continue to
    /// run.</p>
    /// </li>
    /// </ul>
    pub fn default_child_policy(&self) -> std::option::Option<&crate::model::ChildPolicy> {
        self.default_child_policy.as_ref()
    }
    /// <p>The default IAM role attached to this workflow type.</p>
    /// <note>
    /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
    /// don't specify an IAM role when you start this workflow type, the default Lambda role is
    /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    /// </note>
    pub fn default_lambda_role(&self) -> std::option::Option<&str> {
        self.default_lambda_role.as_deref()
    }
}
impl std::fmt::Debug for RegisterWorkflowTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterWorkflowTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("description", &self.description);
        formatter.field(
            "default_task_start_to_close_timeout",
            &self.default_task_start_to_close_timeout,
        );
        formatter.field(
            "default_execution_start_to_close_timeout",
            &self.default_execution_start_to_close_timeout,
        );
        formatter.field("default_task_list", &self.default_task_list);
        formatter.field("default_task_priority", &self.default_task_priority);
        formatter.field("default_child_policy", &self.default_child_policy);
        formatter.field("default_lambda_role", &self.default_lambda_role);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDomainInput {
    /// <p>Name of the domain to register. The name must be unique in the region that the domain
    /// is registered in.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A text description of the domain.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The duration (in days) that records and histories of workflow executions on the domain
    /// should be kept by the service. After the retention period, the workflow execution isn't
    /// available in the results of visibility calls.</p>
    /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow
    /// execution history isn't retained. As soon as the workflow execution completes, the execution
    /// record and its history are deleted.</p>
    /// <p>The maximum workflow execution retention period is 90 days. For more information about
    /// Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    pub workflow_execution_retention_period_in_days: std::option::Option<std::string::String>,
    /// <p>Tags to be added when registering a domain.</p>
    /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
}
impl RegisterDomainInput {
    /// <p>Name of the domain to register. The name must be unique in the region that the domain
    /// is registered in.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A text description of the domain.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The duration (in days) that records and histories of workflow executions on the domain
    /// should be kept by the service. After the retention period, the workflow execution isn't
    /// available in the results of visibility calls.</p>
    /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow
    /// execution history isn't retained. As soon as the workflow execution completes, the execution
    /// record and its history are deleted.</p>
    /// <p>The maximum workflow execution retention period is 90 days. For more information about
    /// Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    pub fn workflow_execution_retention_period_in_days(&self) -> std::option::Option<&str> {
        self.workflow_execution_retention_period_in_days.as_deref()
    }
    /// <p>Tags to be added when registering a domain.</p>
    /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::ResourceTag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for RegisterDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDomainInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "workflow_execution_retention_period_in_days",
            &self.workflow_execution_retention_period_in_days,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterActivityTypeInput {
    /// <p>The name of the domain in which this activity is to be registered.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The name of the activity type within the domain.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the activity type.</p>
    /// <note>
    /// <p>The activity type consists of the name and version, the combination of which must be
    /// unique within the domain.</p>
    /// </note>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>A textual description of the activity type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default maximum duration that a worker can take to process tasks
    /// of this activity type. This default can be overridden when scheduling an activity task using
    /// the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_start_to_close_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default maximum time before which a worker processing a task of
    /// this type must report progress by calling <a>RecordActivityTaskHeartbeat</a>. If
    /// the timeout is exceeded, the activity task is automatically timed out. This default can be
    /// overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>. If the activity worker subsequently attempts to record a heartbeat
    /// or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In
    /// this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should
    /// clean up the activity task.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_heartbeat_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default task list to use for scheduling tasks of this activity
    /// type. This default task list is used if a task list isn't provided when a task is scheduled
    /// through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    pub default_task_list: std::option::Option<crate::model::TaskList>,
    /// <p>The default task priority to assign to the activity type. If not assigned, then
    /// <code>0</code> is used. Valid values are integers that range from Java's
    /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
    /// Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
    /// Priority</a> in the <i>in the
    /// <i>Amazon SWF Developer Guide</i>.</i>.</p>
    pub default_task_priority: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default maximum duration that a task of this activity type can
    /// wait before being assigned to a worker. This default can be overridden when scheduling an
    /// activity task using the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_schedule_to_start_timeout: std::option::Option<std::string::String>,
    /// <p>If set, specifies the default maximum duration for a task of this activity type. This
    /// default can be overridden when scheduling an activity task using the
    /// <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub default_task_schedule_to_close_timeout: std::option::Option<std::string::String>,
}
impl RegisterActivityTypeInput {
    /// <p>The name of the domain in which this activity is to be registered.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The name of the activity type within the domain.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the activity type.</p>
    /// <note>
    /// <p>The activity type consists of the name and version, the combination of which must be
    /// unique within the domain.</p>
    /// </note>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>A textual description of the activity type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>If set, specifies the default maximum duration that a worker can take to process tasks
    /// of this activity type. This default can be overridden when scheduling an activity task using
    /// the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_start_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_task_start_to_close_timeout.as_deref()
    }
    /// <p>If set, specifies the default maximum time before which a worker processing a task of
    /// this type must report progress by calling <a>RecordActivityTaskHeartbeat</a>. If
    /// the timeout is exceeded, the activity task is automatically timed out. This default can be
    /// overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>. If the activity worker subsequently attempts to record a heartbeat
    /// or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In
    /// this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should
    /// clean up the activity task.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_heartbeat_timeout(&self) -> std::option::Option<&str> {
        self.default_task_heartbeat_timeout.as_deref()
    }
    /// <p>If set, specifies the default task list to use for scheduling tasks of this activity
    /// type. This default task list is used if a task list isn't provided when a task is scheduled
    /// through the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    pub fn default_task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.default_task_list.as_ref()
    }
    /// <p>The default task priority to assign to the activity type. If not assigned, then
    /// <code>0</code> is used. Valid values are integers that range from Java's
    /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
    /// Higher numbers indicate higher priority.</p>
    /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
    /// Priority</a> in the <i>in the
    /// <i>Amazon SWF Developer Guide</i>.</i>.</p>
    pub fn default_task_priority(&self) -> std::option::Option<&str> {
        self.default_task_priority.as_deref()
    }
    /// <p>If set, specifies the default maximum duration that a task of this activity type can
    /// wait before being assigned to a worker. This default can be overridden when scheduling an
    /// activity task using the <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_schedule_to_start_timeout(&self) -> std::option::Option<&str> {
        self.default_task_schedule_to_start_timeout.as_deref()
    }
    /// <p>If set, specifies the default maximum duration for a task of this activity type. This
    /// default can be overridden when scheduling an activity task using the
    /// <code>ScheduleActivityTask</code>
    /// <a>Decision</a>.</p>
    /// <p>The duration is specified in seconds, an integer greater than or equal to
    /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
    pub fn default_task_schedule_to_close_timeout(&self) -> std::option::Option<&str> {
        self.default_task_schedule_to_close_timeout.as_deref()
    }
}
impl std::fmt::Debug for RegisterActivityTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterActivityTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("description", &self.description);
        formatter.field(
            "default_task_start_to_close_timeout",
            &self.default_task_start_to_close_timeout,
        );
        formatter.field(
            "default_task_heartbeat_timeout",
            &self.default_task_heartbeat_timeout,
        );
        formatter.field("default_task_list", &self.default_task_list);
        formatter.field("default_task_priority", &self.default_task_priority);
        formatter.field(
            "default_task_schedule_to_start_timeout",
            &self.default_task_schedule_to_start_timeout,
        );
        formatter.field(
            "default_task_schedule_to_close_timeout",
            &self.default_task_schedule_to_close_timeout,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordActivityTaskHeartbeatInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results. </p>
    /// </important>
    pub task_token: std::option::Option<std::string::String>,
    /// <p>If specified, contains details about the progress of the task.</p>
    pub details: std::option::Option<std::string::String>,
}
impl RecordActivityTaskHeartbeatInput {
    /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
    /// <important>
    /// <p>
    /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
    /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
    /// This enables it to provide its progress and respond with results. </p>
    /// </important>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p>If specified, contains details about the progress of the task.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for RecordActivityTaskHeartbeatInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordActivityTaskHeartbeatInput");
        formatter.field("task_token", &self.task_token);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PollForDecisionTaskInput {
    /// <p>The name of the domain containing the task lists to poll.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>Specifies the task list to poll for decision tasks.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>Identity of the decider making the request, which is recorded in the
    /// DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when
    /// problems arise. The form of this identity is user defined.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    /// <note>
    /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to retrieve
    /// the next page of history records. Calling <a>PollForDecisionTask</a> with a
    /// <code>nextPageToken</code> doesn't return a new decision task.</p>
    /// </note>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>  
    /// <p>This
    /// is an upper limit only; the actual number of results returned per call may be fewer than the
    /// specified maximum.</p>
    pub maximum_page_size: i32,
    /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
    /// results are returned in ascending order of the <code>eventTimestamp</code> of the
    /// events.</p>
    pub reverse_order: bool,
}
impl PollForDecisionTaskInput {
    /// <p>The name of the domain containing the task lists to poll.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>Specifies the task list to poll for decision tasks.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>Identity of the decider making the request, which is recorded in the
    /// DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when
    /// problems arise. The form of this identity is user defined.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    /// <note>
    /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to retrieve
    /// the next page of history records. Calling <a>PollForDecisionTask</a> with a
    /// <code>nextPageToken</code> doesn't return a new decision task.</p>
    /// </note>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>  
    /// <p>This
    /// is an upper limit only; the actual number of results returned per call may be fewer than the
    /// specified maximum.</p>
    pub fn maximum_page_size(&self) -> i32 {
        self.maximum_page_size
    }
    /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
    /// results are returned in ascending order of the <code>eventTimestamp</code> of the
    /// events.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
}
impl std::fmt::Debug for PollForDecisionTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PollForDecisionTaskInput");
        formatter.field("domain", &self.domain);
        formatter.field("task_list", &self.task_list);
        formatter.field("identity", &self.identity);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("maximum_page_size", &self.maximum_page_size);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PollForActivityTaskInput {
    /// <p>The name of the domain that contains the task lists being polled.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>Specifies the task list to poll for activity tasks.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
    /// <p>Identity of the worker making the request, recorded in the
    /// <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic
    /// tracing when problems arise. The form of this identity is user defined.</p>
    pub identity: std::option::Option<std::string::String>,
}
impl PollForActivityTaskInput {
    /// <p>The name of the domain that contains the task lists being polled.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>Specifies the task list to poll for activity tasks.</p>
    ///
    /// <p>The specified string must not start or end with whitespace. It must not contain a
    /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
    /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
    /// not <i>be</i> the literal string <code>arn</code>.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
    /// <p>Identity of the worker making the request, recorded in the
    /// <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic
    /// tracing when problems arise. The form of this identity is user defined.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
}
impl std::fmt::Debug for PollForActivityTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PollForActivityTaskInput");
        formatter.field("domain", &self.domain);
        formatter.field("task_list", &self.task_list);
        formatter.field("identity", &self.identity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkflowTypesInput {
    /// <p>The name of the domain in which the workflow types have been registered.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>If specified, lists the workflow type with this name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the registration status of the workflow types to list.</p>
    pub registration_status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub maximum_page_size: i32,
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
    /// results are returned in ascending alphabetical order of the <code>name</code> of the workflow
    /// types.</p>
    pub reverse_order: bool,
}
impl ListWorkflowTypesInput {
    /// <p>The name of the domain in which the workflow types have been registered.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>If specified, lists the workflow type with this name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the registration status of the workflow types to list.</p>
    pub fn registration_status(&self) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.registration_status.as_ref()
    }
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub fn maximum_page_size(&self) -> i32 {
        self.maximum_page_size
    }
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
    /// results are returned in ascending alphabetical order of the <code>name</code> of the workflow
    /// types.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
}
impl std::fmt::Debug for ListWorkflowTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkflowTypesInput");
        formatter.field("domain", &self.domain);
        formatter.field("name", &self.name);
        formatter.field("registration_status", &self.registration_status);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("maximum_page_size", &self.maximum_page_size);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOpenWorkflowExecutionsInput {
    /// <p>The name of the domain that contains the workflow executions to list.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>Workflow executions are included in the returned results based on whether their start
    /// times are within the range specified by this filter.</p>
    pub start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
    /// <p>If specified, only executions of the type specified in the filter are
    /// returned.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
    /// <p>If specified, only executions that have the matching tag are listed.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub tag_filter: std::option::Option<crate::model::TagFilter>,
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub maximum_page_size: i32,
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
    /// results are returned in descending order of the start time of the executions.</p>
    pub reverse_order: bool,
    /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
    /// are returned.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
}
impl ListOpenWorkflowExecutionsInput {
    /// <p>The name of the domain that contains the workflow executions to list.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>Workflow executions are included in the returned results based on whether their start
    /// times are within the range specified by this filter.</p>
    pub fn start_time_filter(&self) -> std::option::Option<&crate::model::ExecutionTimeFilter> {
        self.start_time_filter.as_ref()
    }
    /// <p>If specified, only executions of the type specified in the filter are
    /// returned.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub fn type_filter(&self) -> std::option::Option<&crate::model::WorkflowTypeFilter> {
        self.type_filter.as_ref()
    }
    /// <p>If specified, only executions that have the matching tag are listed.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub fn tag_filter(&self) -> std::option::Option<&crate::model::TagFilter> {
        self.tag_filter.as_ref()
    }
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub fn maximum_page_size(&self) -> i32 {
        self.maximum_page_size
    }
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
    /// results are returned in descending order of the start time of the executions.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
    /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
    /// are returned.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub fn execution_filter(&self) -> std::option::Option<&crate::model::WorkflowExecutionFilter> {
        self.execution_filter.as_ref()
    }
}
impl std::fmt::Debug for ListOpenWorkflowExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOpenWorkflowExecutionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("start_time_filter", &self.start_time_filter);
        formatter.field("type_filter", &self.type_filter);
        formatter.field("tag_filter", &self.tag_filter);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("maximum_page_size", &self.maximum_page_size);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.field("execution_filter", &self.execution_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsInput {
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>Specifies the registration status of the domains to list.</p>
    pub registration_status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub maximum_page_size: i32,
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
    /// results are returned in ascending alphabetical order by <code>name</code> of the
    /// domains.</p>
    pub reverse_order: bool,
}
impl ListDomainsInput {
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>Specifies the registration status of the domains to list.</p>
    pub fn registration_status(&self) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.registration_status.as_ref()
    }
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub fn maximum_page_size(&self) -> i32 {
        self.maximum_page_size
    }
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
    /// results are returned in ascending alphabetical order by <code>name</code> of the
    /// domains.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
}
impl std::fmt::Debug for ListDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsInput");
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("registration_status", &self.registration_status);
        formatter.field("maximum_page_size", &self.maximum_page_size);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClosedWorkflowExecutionsInput {
    /// <p>The name of the domain that contains the workflow executions to list.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>If specified, the workflow executions are included in the returned results based on
    /// whether their start times are within the range specified by this filter. Also, if this
    /// parameter is specified, the returned results are ordered by their start times.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
    /// <p>If specified, the workflow executions are included in the returned results based on
    /// whether their close times are within the range specified by this filter. Also, if this
    /// parameter is specified, the returned results are ordered by their close times.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub close_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
    /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
    /// are returned.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
    /// <p>If specified, only workflow executions that match this <i>close
    /// status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED
    /// workflow executions are listed.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub close_status_filter: std::option::Option<crate::model::CloseStatusFilter>,
    /// <p>If specified, only executions of the type specified in the filter are
    /// returned.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
    /// <p>If specified, only executions that have the matching tag are listed.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub tag_filter: std::option::Option<crate::model::TagFilter>,
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub maximum_page_size: i32,
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
    /// results are returned in descending order of the start or the close time of the
    /// executions.</p>
    pub reverse_order: bool,
}
impl ListClosedWorkflowExecutionsInput {
    /// <p>The name of the domain that contains the workflow executions to list.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>If specified, the workflow executions are included in the returned results based on
    /// whether their start times are within the range specified by this filter. Also, if this
    /// parameter is specified, the returned results are ordered by their start times.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub fn start_time_filter(&self) -> std::option::Option<&crate::model::ExecutionTimeFilter> {
        self.start_time_filter.as_ref()
    }
    /// <p>If specified, the workflow executions are included in the returned results based on
    /// whether their close times are within the range specified by this filter. Also, if this
    /// parameter is specified, the returned results are ordered by their close times.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub fn close_time_filter(&self) -> std::option::Option<&crate::model::ExecutionTimeFilter> {
        self.close_time_filter.as_ref()
    }
    /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
    /// are returned.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn execution_filter(&self) -> std::option::Option<&crate::model::WorkflowExecutionFilter> {
        self.execution_filter.as_ref()
    }
    /// <p>If specified, only workflow executions that match this <i>close
    /// status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED
    /// workflow executions are listed.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn close_status_filter(&self) -> std::option::Option<&crate::model::CloseStatusFilter> {
        self.close_status_filter.as_ref()
    }
    /// <p>If specified, only executions of the type specified in the filter are
    /// returned.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn type_filter(&self) -> std::option::Option<&crate::model::WorkflowTypeFilter> {
        self.type_filter.as_ref()
    }
    /// <p>If specified, only executions that have the matching tag are listed.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn tag_filter(&self) -> std::option::Option<&crate::model::TagFilter> {
        self.tag_filter.as_ref()
    }
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub fn maximum_page_size(&self) -> i32 {
        self.maximum_page_size
    }
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
    /// results are returned in descending order of the start or the close time of the
    /// executions.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
}
impl std::fmt::Debug for ListClosedWorkflowExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClosedWorkflowExecutionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("start_time_filter", &self.start_time_filter);
        formatter.field("close_time_filter", &self.close_time_filter);
        formatter.field("execution_filter", &self.execution_filter);
        formatter.field("close_status_filter", &self.close_status_filter);
        formatter.field("type_filter", &self.type_filter);
        formatter.field("tag_filter", &self.tag_filter);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("maximum_page_size", &self.maximum_page_size);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActivityTypesInput {
    /// <p>The name of the domain in which the activity types have been registered.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>If specified, only lists the activity types that have this name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the registration status of the activity types to list.</p>
    pub registration_status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub maximum_page_size: i32,
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
    /// results are returned in ascending alphabetical order by <code>name</code> of the activity
    /// types.</p>
    pub reverse_order: bool,
}
impl ListActivityTypesInput {
    /// <p>The name of the domain in which the activity types have been registered.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>If specified, only lists the activity types that have this name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the registration status of the activity types to list.</p>
    pub fn registration_status(&self) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.registration_status.as_ref()
    }
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub fn maximum_page_size(&self) -> i32 {
        self.maximum_page_size
    }
    /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
    /// results are returned in ascending alphabetical order by <code>name</code> of the activity
    /// types.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
}
impl std::fmt::Debug for ListActivityTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActivityTypesInput");
        formatter.field("domain", &self.domain);
        formatter.field("name", &self.name);
        formatter.field("registration_status", &self.registration_status);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("maximum_page_size", &self.maximum_page_size);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkflowExecutionHistoryInput {
    /// <p>The name of the domain containing the workflow execution.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>Specifies the workflow execution for which to return the history.</p>
    pub execution: std::option::Option<crate::model::WorkflowExecution>,
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub maximum_page_size: i32,
    /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
    /// results are returned in ascending order of the <code>eventTimeStamp</code> of the
    /// events.</p>
    pub reverse_order: bool,
}
impl GetWorkflowExecutionHistoryInput {
    /// <p>The name of the domain containing the workflow execution.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>Specifies the workflow execution for which to return the history.</p>
    pub fn execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.execution.as_ref()
    }
    /// <p>If <code>NextPageToken</code> is returned there are more results
    /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
    /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
    /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
    /// exceeded its maximum lifetime</code>". </p>
    ///
    /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
    /// in a single call. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The maximum number of results that are returned per call.
    /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
    pub fn maximum_page_size(&self) -> i32 {
        self.maximum_page_size
    }
    /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
    /// results are returned in ascending order of the <code>eventTimeStamp</code> of the
    /// events.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
}
impl std::fmt::Debug for GetWorkflowExecutionHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkflowExecutionHistoryInput");
        formatter.field("domain", &self.domain);
        formatter.field("execution", &self.execution);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("maximum_page_size", &self.maximum_page_size);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkflowTypeInput {
    /// <p>The name of the domain in which this workflow type is registered.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The workflow type to describe.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
}
impl DescribeWorkflowTypeInput {
    /// <p>The name of the domain in which this workflow type is registered.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The workflow type to describe.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkflowTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkflowTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkflowExecutionInput {
    /// <p>The name of the domain containing the workflow execution.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The workflow execution to describe.</p>
    pub execution: std::option::Option<crate::model::WorkflowExecution>,
}
impl DescribeWorkflowExecutionInput {
    /// <p>The name of the domain containing the workflow execution.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The workflow execution to describe.</p>
    pub fn execution(&self) -> std::option::Option<&crate::model::WorkflowExecution> {
        self.execution.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkflowExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkflowExecutionInput");
        formatter.field("domain", &self.domain);
        formatter.field("execution", &self.execution);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainInput {
    /// <p>The name of the domain to describe.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeDomainInput {
    /// <p>The name of the domain to describe.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActivityTypeInput {
    /// <p>The name of the domain in which the activity type is registered.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The activity type to get information about. Activity types are identified by the
    /// <code>name</code> and <code>version</code> that were supplied when the activity was
    /// registered.</p>
    pub activity_type: std::option::Option<crate::model::ActivityType>,
}
impl DescribeActivityTypeInput {
    /// <p>The name of the domain in which the activity type is registered.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The activity type to get information about. Activity types are identified by the
    /// <code>name</code> and <code>version</code> that were supplied when the activity was
    /// registered.</p>
    pub fn activity_type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.activity_type.as_ref()
    }
}
impl std::fmt::Debug for DescribeActivityTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActivityTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("activity_type", &self.activity_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateWorkflowTypeInput {
    /// <p>The name of the domain in which the workflow type is registered.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The workflow type to deprecate.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
}
impl DeprecateWorkflowTypeInput {
    /// <p>The name of the domain in which the workflow type is registered.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The workflow type to deprecate.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
}
impl std::fmt::Debug for DeprecateWorkflowTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateWorkflowTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateDomainInput {
    /// <p>The name of the domain to deprecate.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeprecateDomainInput {
    /// <p>The name of the domain to deprecate.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeprecateDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateDomainInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateActivityTypeInput {
    /// <p>The name of the domain in which the activity type is registered.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The activity type to deprecate.</p>
    pub activity_type: std::option::Option<crate::model::ActivityType>,
}
impl DeprecateActivityTypeInput {
    /// <p>The name of the domain in which the activity type is registered.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The activity type to deprecate.</p>
    pub fn activity_type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.activity_type.as_ref()
    }
}
impl std::fmt::Debug for DeprecateActivityTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateActivityTypeInput");
        formatter.field("domain", &self.domain);
        formatter.field("activity_type", &self.activity_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CountPendingDecisionTasksInput {
    /// <p>The name of the domain that contains the task list.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The name of the task list.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
}
impl CountPendingDecisionTasksInput {
    /// <p>The name of the domain that contains the task list.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The name of the task list.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
}
impl std::fmt::Debug for CountPendingDecisionTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CountPendingDecisionTasksInput");
        formatter.field("domain", &self.domain);
        formatter.field("task_list", &self.task_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CountPendingActivityTasksInput {
    /// <p>The name of the domain that contains the task list.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The name of the task list.</p>
    pub task_list: std::option::Option<crate::model::TaskList>,
}
impl CountPendingActivityTasksInput {
    /// <p>The name of the domain that contains the task list.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The name of the task list.</p>
    pub fn task_list(&self) -> std::option::Option<&crate::model::TaskList> {
        self.task_list.as_ref()
    }
}
impl std::fmt::Debug for CountPendingActivityTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CountPendingActivityTasksInput");
        formatter.field("domain", &self.domain);
        formatter.field("task_list", &self.task_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CountOpenWorkflowExecutionsInput {
    /// <p>The name of the domain containing the workflow executions to count.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>Specifies the start time criteria that workflow executions must meet in order to be
    /// counted.</p>
    pub start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
    /// <p>Specifies the type of the workflow executions to be counted.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
    /// <p>If specified, only executions that have a tag that matches the filter are
    /// counted.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub tag_filter: std::option::Option<crate::model::TagFilter>,
    /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
    /// filter are counted.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
}
impl CountOpenWorkflowExecutionsInput {
    /// <p>The name of the domain containing the workflow executions to count.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>Specifies the start time criteria that workflow executions must meet in order to be
    /// counted.</p>
    pub fn start_time_filter(&self) -> std::option::Option<&crate::model::ExecutionTimeFilter> {
        self.start_time_filter.as_ref()
    }
    /// <p>Specifies the type of the workflow executions to be counted.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub fn type_filter(&self) -> std::option::Option<&crate::model::WorkflowTypeFilter> {
        self.type_filter.as_ref()
    }
    /// <p>If specified, only executions that have a tag that matches the filter are
    /// counted.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub fn tag_filter(&self) -> std::option::Option<&crate::model::TagFilter> {
        self.tag_filter.as_ref()
    }
    /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
    /// filter are counted.</p>
    /// <note>
    /// <p>
    /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
    /// mutually exclusive. You can specify at most one of these in a request.</p>
    /// </note>
    pub fn execution_filter(&self) -> std::option::Option<&crate::model::WorkflowExecutionFilter> {
        self.execution_filter.as_ref()
    }
}
impl std::fmt::Debug for CountOpenWorkflowExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CountOpenWorkflowExecutionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("start_time_filter", &self.start_time_filter);
        formatter.field("type_filter", &self.type_filter);
        formatter.field("tag_filter", &self.tag_filter);
        formatter.field("execution_filter", &self.execution_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CountClosedWorkflowExecutionsInput {
    /// <p>The name of the domain containing the workflow executions to count.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>If specified, only workflow executions that meet the start time criteria of the filter
    /// are counted.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub start_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
    /// <p>If specified, only workflow executions that meet the close time criteria of the filter
    /// are counted.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub close_time_filter: std::option::Option<crate::model::ExecutionTimeFilter>,
    /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
    /// filter are counted.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub execution_filter: std::option::Option<crate::model::WorkflowExecutionFilter>,
    /// <p>If specified, indicates the type of the workflow executions to be counted.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub type_filter: std::option::Option<crate::model::WorkflowTypeFilter>,
    /// <p>If specified, only executions that have a tag that matches the filter are
    /// counted.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub tag_filter: std::option::Option<crate::model::TagFilter>,
    /// <p>If specified, only workflow executions that match this close status are counted. This
    /// filter has an affect only if <code>executionStatus</code> is specified as
    /// <code>CLOSED</code>.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub close_status_filter: std::option::Option<crate::model::CloseStatusFilter>,
}
impl CountClosedWorkflowExecutionsInput {
    /// <p>The name of the domain containing the workflow executions to count.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>If specified, only workflow executions that meet the start time criteria of the filter
    /// are counted.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub fn start_time_filter(&self) -> std::option::Option<&crate::model::ExecutionTimeFilter> {
        self.start_time_filter.as_ref()
    }
    /// <p>If specified, only workflow executions that meet the close time criteria of the filter
    /// are counted.</p>
    /// <note>
    /// <p>
    /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
    /// must specify one of these in a request but not both.</p>
    /// </note>
    pub fn close_time_filter(&self) -> std::option::Option<&crate::model::ExecutionTimeFilter> {
        self.close_time_filter.as_ref()
    }
    /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
    /// filter are counted.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn execution_filter(&self) -> std::option::Option<&crate::model::WorkflowExecutionFilter> {
        self.execution_filter.as_ref()
    }
    /// <p>If specified, indicates the type of the workflow executions to be counted.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn type_filter(&self) -> std::option::Option<&crate::model::WorkflowTypeFilter> {
        self.type_filter.as_ref()
    }
    /// <p>If specified, only executions that have a tag that matches the filter are
    /// counted.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn tag_filter(&self) -> std::option::Option<&crate::model::TagFilter> {
        self.tag_filter.as_ref()
    }
    /// <p>If specified, only workflow executions that match this close status are counted. This
    /// filter has an affect only if <code>executionStatus</code> is specified as
    /// <code>CLOSED</code>.</p>
    /// <note>
    /// <p>
    /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
    /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
    /// request.</p>
    /// </note>
    pub fn close_status_filter(&self) -> std::option::Option<&crate::model::CloseStatusFilter> {
        self.close_status_filter.as_ref()
    }
}
impl std::fmt::Debug for CountClosedWorkflowExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CountClosedWorkflowExecutionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("start_time_filter", &self.start_time_filter);
        formatter.field("close_time_filter", &self.close_time_filter);
        formatter.field("execution_filter", &self.execution_filter);
        formatter.field("type_filter", &self.type_filter);
        formatter.field("tag_filter", &self.tag_filter);
        formatter.field("close_status_filter", &self.close_status_filter);
        formatter.finish()
    }
}
