// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `SimpleWorkflowService`.
///
/// This client allows ergonomic access to a `SimpleWorkflowService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CountClosedWorkflowExecutions` operation.
    ///
    /// See [`CountClosedWorkflowExecutions`](crate::client::fluent_builders::CountClosedWorkflowExecutions) for more information about the
    /// operation and its arguments.
    pub fn count_closed_workflow_executions(
        &self,
    ) -> fluent_builders::CountClosedWorkflowExecutions<C, M, R> {
        fluent_builders::CountClosedWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CountOpenWorkflowExecutions` operation.
    ///
    /// See [`CountOpenWorkflowExecutions`](crate::client::fluent_builders::CountOpenWorkflowExecutions) for more information about the
    /// operation and its arguments.
    pub fn count_open_workflow_executions(
        &self,
    ) -> fluent_builders::CountOpenWorkflowExecutions<C, M, R> {
        fluent_builders::CountOpenWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CountPendingActivityTasks` operation.
    ///
    /// See [`CountPendingActivityTasks`](crate::client::fluent_builders::CountPendingActivityTasks) for more information about the
    /// operation and its arguments.
    pub fn count_pending_activity_tasks(
        &self,
    ) -> fluent_builders::CountPendingActivityTasks<C, M, R> {
        fluent_builders::CountPendingActivityTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CountPendingDecisionTasks` operation.
    ///
    /// See [`CountPendingDecisionTasks`](crate::client::fluent_builders::CountPendingDecisionTasks) for more information about the
    /// operation and its arguments.
    pub fn count_pending_decision_tasks(
        &self,
    ) -> fluent_builders::CountPendingDecisionTasks<C, M, R> {
        fluent_builders::CountPendingDecisionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprecateActivityType` operation.
    ///
    /// See [`DeprecateActivityType`](crate::client::fluent_builders::DeprecateActivityType) for more information about the
    /// operation and its arguments.
    pub fn deprecate_activity_type(&self) -> fluent_builders::DeprecateActivityType<C, M, R> {
        fluent_builders::DeprecateActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprecateDomain` operation.
    ///
    /// See [`DeprecateDomain`](crate::client::fluent_builders::DeprecateDomain) for more information about the
    /// operation and its arguments.
    pub fn deprecate_domain(&self) -> fluent_builders::DeprecateDomain<C, M, R> {
        fluent_builders::DeprecateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprecateWorkflowType` operation.
    ///
    /// See [`DeprecateWorkflowType`](crate::client::fluent_builders::DeprecateWorkflowType) for more information about the
    /// operation and its arguments.
    pub fn deprecate_workflow_type(&self) -> fluent_builders::DeprecateWorkflowType<C, M, R> {
        fluent_builders::DeprecateWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeActivityType` operation.
    ///
    /// See [`DescribeActivityType`](crate::client::fluent_builders::DescribeActivityType) for more information about the
    /// operation and its arguments.
    pub fn describe_activity_type(&self) -> fluent_builders::DescribeActivityType<C, M, R> {
        fluent_builders::DescribeActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomain` operation.
    ///
    /// See [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) for more information about the
    /// operation and its arguments.
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkflowExecution` operation.
    ///
    /// See [`DescribeWorkflowExecution`](crate::client::fluent_builders::DescribeWorkflowExecution) for more information about the
    /// operation and its arguments.
    pub fn describe_workflow_execution(
        &self,
    ) -> fluent_builders::DescribeWorkflowExecution<C, M, R> {
        fluent_builders::DescribeWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkflowType` operation.
    ///
    /// See [`DescribeWorkflowType`](crate::client::fluent_builders::DescribeWorkflowType) for more information about the
    /// operation and its arguments.
    pub fn describe_workflow_type(&self) -> fluent_builders::DescribeWorkflowType<C, M, R> {
        fluent_builders::DescribeWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkflowExecutionHistory` operation.
    ///
    /// See [`GetWorkflowExecutionHistory`](crate::client::fluent_builders::GetWorkflowExecutionHistory) for more information about the
    /// operation and its arguments.
    pub fn get_workflow_execution_history(
        &self,
    ) -> fluent_builders::GetWorkflowExecutionHistory<C, M, R> {
        fluent_builders::GetWorkflowExecutionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListActivityTypes` operation.
    ///
    /// See [`ListActivityTypes`](crate::client::fluent_builders::ListActivityTypes) for more information about the
    /// operation and its arguments.
    pub fn list_activity_types(&self) -> fluent_builders::ListActivityTypes<C, M, R> {
        fluent_builders::ListActivityTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListClosedWorkflowExecutions` operation.
    ///
    /// See [`ListClosedWorkflowExecutions`](crate::client::fluent_builders::ListClosedWorkflowExecutions) for more information about the
    /// operation and its arguments.
    pub fn list_closed_workflow_executions(
        &self,
    ) -> fluent_builders::ListClosedWorkflowExecutions<C, M, R> {
        fluent_builders::ListClosedWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomains` operation.
    ///
    /// See [`ListDomains`](crate::client::fluent_builders::ListDomains) for more information about the
    /// operation and its arguments.
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOpenWorkflowExecutions` operation.
    ///
    /// See [`ListOpenWorkflowExecutions`](crate::client::fluent_builders::ListOpenWorkflowExecutions) for more information about the
    /// operation and its arguments.
    pub fn list_open_workflow_executions(
        &self,
    ) -> fluent_builders::ListOpenWorkflowExecutions<C, M, R> {
        fluent_builders::ListOpenWorkflowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkflowTypes` operation.
    ///
    /// See [`ListWorkflowTypes`](crate::client::fluent_builders::ListWorkflowTypes) for more information about the
    /// operation and its arguments.
    pub fn list_workflow_types(&self) -> fluent_builders::ListWorkflowTypes<C, M, R> {
        fluent_builders::ListWorkflowTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PollForActivityTask` operation.
    ///
    /// See [`PollForActivityTask`](crate::client::fluent_builders::PollForActivityTask) for more information about the
    /// operation and its arguments.
    pub fn poll_for_activity_task(&self) -> fluent_builders::PollForActivityTask<C, M, R> {
        fluent_builders::PollForActivityTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PollForDecisionTask` operation.
    ///
    /// See [`PollForDecisionTask`](crate::client::fluent_builders::PollForDecisionTask) for more information about the
    /// operation and its arguments.
    pub fn poll_for_decision_task(&self) -> fluent_builders::PollForDecisionTask<C, M, R> {
        fluent_builders::PollForDecisionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RecordActivityTaskHeartbeat` operation.
    ///
    /// See [`RecordActivityTaskHeartbeat`](crate::client::fluent_builders::RecordActivityTaskHeartbeat) for more information about the
    /// operation and its arguments.
    pub fn record_activity_task_heartbeat(
        &self,
    ) -> fluent_builders::RecordActivityTaskHeartbeat<C, M, R> {
        fluent_builders::RecordActivityTaskHeartbeat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterActivityType` operation.
    ///
    /// See [`RegisterActivityType`](crate::client::fluent_builders::RegisterActivityType) for more information about the
    /// operation and its arguments.
    pub fn register_activity_type(&self) -> fluent_builders::RegisterActivityType<C, M, R> {
        fluent_builders::RegisterActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterDomain` operation.
    ///
    /// See [`RegisterDomain`](crate::client::fluent_builders::RegisterDomain) for more information about the
    /// operation and its arguments.
    pub fn register_domain(&self) -> fluent_builders::RegisterDomain<C, M, R> {
        fluent_builders::RegisterDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterWorkflowType` operation.
    ///
    /// See [`RegisterWorkflowType`](crate::client::fluent_builders::RegisterWorkflowType) for more information about the
    /// operation and its arguments.
    pub fn register_workflow_type(&self) -> fluent_builders::RegisterWorkflowType<C, M, R> {
        fluent_builders::RegisterWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RequestCancelWorkflowExecution` operation.
    ///
    /// See [`RequestCancelWorkflowExecution`](crate::client::fluent_builders::RequestCancelWorkflowExecution) for more information about the
    /// operation and its arguments.
    pub fn request_cancel_workflow_execution(
        &self,
    ) -> fluent_builders::RequestCancelWorkflowExecution<C, M, R> {
        fluent_builders::RequestCancelWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RespondActivityTaskCanceled` operation.
    ///
    /// See [`RespondActivityTaskCanceled`](crate::client::fluent_builders::RespondActivityTaskCanceled) for more information about the
    /// operation and its arguments.
    pub fn respond_activity_task_canceled(
        &self,
    ) -> fluent_builders::RespondActivityTaskCanceled<C, M, R> {
        fluent_builders::RespondActivityTaskCanceled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RespondActivityTaskCompleted` operation.
    ///
    /// See [`RespondActivityTaskCompleted`](crate::client::fluent_builders::RespondActivityTaskCompleted) for more information about the
    /// operation and its arguments.
    pub fn respond_activity_task_completed(
        &self,
    ) -> fluent_builders::RespondActivityTaskCompleted<C, M, R> {
        fluent_builders::RespondActivityTaskCompleted::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RespondActivityTaskFailed` operation.
    ///
    /// See [`RespondActivityTaskFailed`](crate::client::fluent_builders::RespondActivityTaskFailed) for more information about the
    /// operation and its arguments.
    pub fn respond_activity_task_failed(
        &self,
    ) -> fluent_builders::RespondActivityTaskFailed<C, M, R> {
        fluent_builders::RespondActivityTaskFailed::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RespondDecisionTaskCompleted` operation.
    ///
    /// See [`RespondDecisionTaskCompleted`](crate::client::fluent_builders::RespondDecisionTaskCompleted) for more information about the
    /// operation and its arguments.
    pub fn respond_decision_task_completed(
        &self,
    ) -> fluent_builders::RespondDecisionTaskCompleted<C, M, R> {
        fluent_builders::RespondDecisionTaskCompleted::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SignalWorkflowExecution` operation.
    ///
    /// See [`SignalWorkflowExecution`](crate::client::fluent_builders::SignalWorkflowExecution) for more information about the
    /// operation and its arguments.
    pub fn signal_workflow_execution(&self) -> fluent_builders::SignalWorkflowExecution<C, M, R> {
        fluent_builders::SignalWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartWorkflowExecution` operation.
    ///
    /// See [`StartWorkflowExecution`](crate::client::fluent_builders::StartWorkflowExecution) for more information about the
    /// operation and its arguments.
    pub fn start_workflow_execution(&self) -> fluent_builders::StartWorkflowExecution<C, M, R> {
        fluent_builders::StartWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateWorkflowExecution` operation.
    ///
    /// See [`TerminateWorkflowExecution`](crate::client::fluent_builders::TerminateWorkflowExecution) for more information about the
    /// operation and its arguments.
    pub fn terminate_workflow_execution(
        &self,
    ) -> fluent_builders::TerminateWorkflowExecution<C, M, R> {
        fluent_builders::TerminateWorkflowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UndeprecateActivityType` operation.
    ///
    /// See [`UndeprecateActivityType`](crate::client::fluent_builders::UndeprecateActivityType) for more information about the
    /// operation and its arguments.
    pub fn undeprecate_activity_type(&self) -> fluent_builders::UndeprecateActivityType<C, M, R> {
        fluent_builders::UndeprecateActivityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UndeprecateDomain` operation.
    ///
    /// See [`UndeprecateDomain`](crate::client::fluent_builders::UndeprecateDomain) for more information about the
    /// operation and its arguments.
    pub fn undeprecate_domain(&self) -> fluent_builders::UndeprecateDomain<C, M, R> {
        fluent_builders::UndeprecateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UndeprecateWorkflowType` operation.
    ///
    /// See [`UndeprecateWorkflowType`](crate::client::fluent_builders::UndeprecateWorkflowType) for more information about the
    /// operation and its arguments.
    pub fn undeprecate_workflow_type(&self) -> fluent_builders::UndeprecateWorkflowType<C, M, R> {
        fluent_builders::UndeprecateWorkflowType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CountClosedWorkflowExecutions`.
    ///
    /// <p>Returns the number of closed workflow executions within the given domain that meet the
    /// specified filtering criteria.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tagFilter.tag</code>: String constraint. The key is
    /// <code>swf:tagFilter.tag</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.name</code>: String constraint. The key is
    /// <code>swf:typeFilter.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.version</code>: String constraint. The key is
    /// <code>swf:typeFilter.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CountClosedWorkflowExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::count_closed_workflow_executions_input::Builder,
    }
    impl<C, M, R> CountClosedWorkflowExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CountClosedWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountClosedWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::CountClosedWorkflowExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CountClosedWorkflowExecutionsInputOperationOutputAlias,
                crate::output::CountClosedWorkflowExecutionsOutput,
                crate::error::CountClosedWorkflowExecutionsError,
                crate::input::CountClosedWorkflowExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the start time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn start_time_filter(mut self, inp: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions that meet the start time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that meet the close time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn close_time_filter(mut self, inp: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.close_time_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions that meet the close time criteria of the filter
        /// are counted.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_close_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn execution_filter(mut self, inp: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
        /// <p>If specified, indicates the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn type_filter(mut self, inp: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(inp);
            self
        }
        /// <p>If specified, indicates the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn tag_filter(mut self, inp: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(inp);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that match this close status are counted. This
        /// filter has an affect only if <code>executionStatus</code> is specified as
        /// <code>CLOSED</code>.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn close_status_filter(mut self, inp: crate::model::CloseStatusFilter) -> Self {
            self.inner = self.inner.close_status_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions that match this close status are counted. This
        /// filter has an affect only if <code>executionStatus</code> is specified as
        /// <code>CLOSED</code>.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_close_status_filter(
            mut self,
            input: std::option::Option<crate::model::CloseStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_status_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CountOpenWorkflowExecutions`.
    ///
    /// <p>Returns the number of open workflow executions within the given domain that meet the
    /// specified filtering criteria.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tagFilter.tag</code>: String constraint. The key is
    /// <code>swf:tagFilter.tag</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.name</code>: String constraint. The key is
    /// <code>swf:typeFilter.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.version</code>: String constraint. The key is
    /// <code>swf:typeFilter.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CountOpenWorkflowExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::count_open_workflow_executions_input::Builder,
    }
    impl<C, M, R> CountOpenWorkflowExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CountOpenWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountOpenWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::CountOpenWorkflowExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CountOpenWorkflowExecutionsInputOperationOutputAlias,
                crate::output::CountOpenWorkflowExecutionsOutput,
                crate::error::CountOpenWorkflowExecutionsError,
                crate::input::CountOpenWorkflowExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain containing the workflow executions to count.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the start time criteria that workflow executions must meet in order to be
        /// counted.</p>
        pub fn start_time_filter(mut self, inp: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(inp);
            self
        }
        /// <p>Specifies the start time criteria that workflow executions must meet in order to be
        /// counted.</p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>Specifies the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, inp: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(inp);
            self
        }
        /// <p>Specifies the type of the workflow executions to be counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, inp: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(inp);
            self
        }
        /// <p>If specified, only executions that have a tag that matches the filter are
        /// counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, inp: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions matching the <code>WorkflowId</code> in the
        /// filter are counted.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CountPendingActivityTasks`.
    ///
    /// <p>Returns the estimated number of activity tasks in the specified task list. The count
    /// returned is an approximation and isn't guaranteed to be exact. If you specify a task list that
    /// no activity task was ever scheduled in then <code>0</code> is returned.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the <code>taskList.name</code> parameter by using a
    /// <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the
    /// action to access only certain task lists.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CountPendingActivityTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::count_pending_activity_tasks_input::Builder,
    }
    impl<C, M, R> CountPendingActivityTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CountPendingActivityTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountPendingActivityTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::CountPendingActivityTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CountPendingActivityTasksInputOperationOutputAlias,
                crate::output::CountPendingActivityTasksOutput,
                crate::error::CountPendingActivityTasksError,
                crate::input::CountPendingActivityTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn task_list(mut self, inp: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(inp);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CountPendingDecisionTasks`.
    ///
    /// <p>Returns the estimated number of decision tasks in the specified task list. The count
    /// returned is an approximation and isn't guaranteed to be exact. If you specify a task list that
    /// no decision task was ever scheduled in then <code>0</code> is returned.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the <code>taskList.name</code> parameter by using a
    /// <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the
    /// action to access only certain task lists.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CountPendingDecisionTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::count_pending_decision_tasks_input::Builder,
    }
    impl<C, M, R> CountPendingDecisionTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CountPendingDecisionTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CountPendingDecisionTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::CountPendingDecisionTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CountPendingDecisionTasksInputOperationOutputAlias,
                crate::output::CountPendingDecisionTasksOutput,
                crate::error::CountPendingDecisionTasksError,
                crate::input::CountPendingDecisionTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain that contains the task list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn task_list(mut self, inp: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(inp);
            self
        }
        /// <p>The name of the task list.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateActivityType`.
    ///
    /// <p>Deprecates the specified <i>activity type</i>. After an activity type has
    /// been deprecated, you cannot create new tasks of that activity type. Tasks of this type that
    /// were scheduled before the type was deprecated continue to run.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>activityType.name</code>: String constraint. The key is
    /// <code>swf:activityType.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>activityType.version</code>: String constraint. The key is
    /// <code>swf:activityType.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeprecateActivityType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprecate_activity_type_input::Builder,
    }
    impl<C, M, R> DeprecateActivityType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprecateActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateActivityTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprecateActivityTypeInputOperationOutputAlias,
                crate::output::DeprecateActivityTypeOutput,
                crate::error::DeprecateActivityTypeError,
                crate::input::DeprecateActivityTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The activity type to deprecate.</p>
        pub fn activity_type(mut self, inp: crate::model::ActivityType) -> Self {
            self.inner = self.inner.activity_type(inp);
            self
        }
        /// <p>The activity type to deprecate.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.inner = self.inner.set_activity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateDomain`.
    ///
    /// <p>Deprecates the specified domain. After a domain has been deprecated it cannot be used
    /// to create new workflow executions or register new types. However, you can still use visibility
    /// actions on this domain. Deprecating a domain also deprecates all activity and workflow types
    /// registered in the domain. Executions that were started before the domain was deprecated
    /// continues to run.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeprecateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprecate_domain_input::Builder,
    }
    impl<C, M, R> DeprecateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprecateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprecateDomainInputOperationOutputAlias,
                crate::output::DeprecateDomainOutput,
                crate::error::DeprecateDomainError,
                crate::input::DeprecateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain to deprecate.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the domain to deprecate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateWorkflowType`.
    ///
    /// <p>Deprecates the specified <i>workflow type</i>. After a workflow type has
    /// been deprecated, you cannot create new executions of that type. Executions that were started
    /// before the type was deprecated continues to run. A deprecated workflow type may still be used
    /// when calling visibility actions.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>workflowType.name</code>: String constraint. The key is
    /// <code>swf:workflowType.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>workflowType.version</code>: String constraint. The key is
    /// <code>swf:workflowType.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeprecateWorkflowType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprecate_workflow_type_input::Builder,
    }
    impl<C, M, R> DeprecateWorkflowType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprecateWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateWorkflowTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprecateWorkflowTypeInputOperationOutputAlias,
                crate::output::DeprecateWorkflowTypeOutput,
                crate::error::DeprecateWorkflowTypeError,
                crate::input::DeprecateWorkflowTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the workflow type is registered.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which the workflow type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflow type to deprecate.</p>
        pub fn workflow_type(mut self, inp: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(inp);
            self
        }
        /// <p>The workflow type to deprecate.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActivityType`.
    ///
    /// <p>Returns information about the specified activity type. This includes configuration
    /// settings provided when the type was registered and other general information about the
    /// type.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>activityType.name</code>: String constraint. The key is
    /// <code>swf:activityType.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>activityType.version</code>: String constraint. The key is
    /// <code>swf:activityType.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeActivityType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_activity_type_input::Builder,
    }
    impl<C, M, R> DescribeActivityType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActivityTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeActivityTypeInputOperationOutputAlias,
                crate::output::DescribeActivityTypeOutput,
                crate::error::DescribeActivityTypeError,
                crate::input::DescribeActivityTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which the activity type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The activity type to get information about. Activity types are identified by the
        /// <code>name</code> and <code>version</code> that were supplied when the activity was
        /// registered.</p>
        pub fn activity_type(mut self, inp: crate::model::ActivityType) -> Self {
            self.inner = self.inner.activity_type(inp);
            self
        }
        /// <p>The activity type to get information about. Activity types are identified by the
        /// <code>name</code> and <code>version</code> that were supplied when the activity was
        /// registered.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.inner = self.inner.set_activity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Returns information about the specified domain, including description and
    /// status.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain to describe.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the domain to describe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkflowExecution`.
    ///
    /// <p>Returns information about the specified workflow execution including its type and some
    /// statistics.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeWorkflowExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workflow_execution_input::Builder,
    }
    impl<C, M, R> DescribeWorkflowExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkflowExecutionInputOperationOutputAlias,
                crate::output::DescribeWorkflowExecutionOutput,
                crate::error::DescribeWorkflowExecutionError,
                crate::input::DescribeWorkflowExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflow execution to describe.</p>
        pub fn execution(mut self, inp: crate::model::WorkflowExecution) -> Self {
            self.inner = self.inner.execution(inp);
            self
        }
        /// <p>The workflow execution to describe.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.inner = self.inner.set_execution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkflowType`.
    ///
    /// <p>Returns information about the specified <i>workflow type</i>. This
    /// includes configuration settings specified when the type was registered and other information
    /// such as creation date, current status, etc.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>workflowType.name</code>: String constraint. The key is
    /// <code>swf:workflowType.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>workflowType.version</code>: String constraint. The key is
    /// <code>swf:workflowType.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeWorkflowType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workflow_type_input::Builder,
    }
    impl<C, M, R> DescribeWorkflowType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkflowTypeInputOperationOutputAlias,
                crate::output::DescribeWorkflowTypeOutput,
                crate::error::DescribeWorkflowTypeError,
                crate::input::DescribeWorkflowTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which this workflow type is registered.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which this workflow type is registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflow type to describe.</p>
        pub fn workflow_type(mut self, inp: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(inp);
            self
        }
        /// <p>The workflow type to describe.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflowExecutionHistory`.
    ///
    /// <p>Returns the history of the specified workflow execution. The results may be split into
    /// multiple pages. To retrieve subsequent pages, make the call again using the
    /// <code>nextPageToken</code> returned by the initial call.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWorkflowExecutionHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workflow_execution_history_input::Builder,
    }
    impl<C, M, R> GetWorkflowExecutionHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkflowExecutionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowExecutionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowExecutionHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkflowExecutionHistoryInputOperationOutputAlias,
                crate::output::GetWorkflowExecutionHistoryOutput,
                crate::error::GetWorkflowExecutionHistoryError,
                crate::input::GetWorkflowExecutionHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain containing the workflow execution.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the workflow execution for which to return the history.</p>
        pub fn execution(mut self, inp: crate::model::WorkflowExecution) -> Self {
            self.inner = self.inner.execution(inp);
            self
        }
        /// <p>Specifies the workflow execution for which to return the history.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecution>,
        ) -> Self {
            self.inner = self.inner.set_execution(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(inp);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_page_size(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimeStamp</code> of the
        /// events.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimeStamp</code> of the
        /// events.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActivityTypes`.
    ///
    /// <p>Returns information about all activities registered in the specified domain that match
    /// the specified name and registration status. The result includes information like creation
    /// date, current status of the activity, etc. The results may be split into multiple pages. To
    /// retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned
    /// by the initial call.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListActivityTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_activity_types_input::Builder,
    }
    impl<C, M, R> ListActivityTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListActivityTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActivityTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActivityTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListActivityTypesInputOperationOutputAlias,
                crate::output::ListActivityTypesOutput,
                crate::error::ListActivityTypesError,
                crate::input::ListActivityTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the activity types have been registered.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which the activity types have been registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, only lists the activity types that have this name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>If specified, only lists the activity types that have this name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the registration status of the activity types to list.</p>
        pub fn registration_status(mut self, inp: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(inp);
            self
        }
        /// <p>Specifies the registration status of the activity types to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(inp);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_page_size(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the activity
        /// types.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the activity
        /// types.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClosedWorkflowExecutions`.
    ///
    /// <p>Returns a list of closed workflow executions in the specified domain that meet the
    /// filtering criteria. The results may be split into multiple pages. To retrieve subsequent
    /// pages, make the call again using the nextPageToken returned by the initial call.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tagFilter.tag</code>: String constraint. The key is
    /// <code>swf:tagFilter.tag</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.name</code>: String constraint. The key is
    /// <code>swf:typeFilter.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.version</code>: String constraint. The key is
    /// <code>swf:typeFilter.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListClosedWorkflowExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_closed_workflow_executions_input::Builder,
    }
    impl<C, M, R> ListClosedWorkflowExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListClosedWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClosedWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClosedWorkflowExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListClosedWorkflowExecutionsInputOperationOutputAlias,
                crate::output::ListClosedWorkflowExecutionsOutput,
                crate::error::ListClosedWorkflowExecutionsError,
                crate::input::ListClosedWorkflowExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their start times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their start times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn start_time_filter(mut self, inp: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(inp);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their start times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their start times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their close times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their close times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn close_time_filter(mut self, inp: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.close_time_filter(inp);
            self
        }
        /// <p>If specified, the workflow executions are included in the returned results based on
        /// whether their close times are within the range specified by this filter. Also, if this
        /// parameter is specified, the returned results are ordered by their close times.</p>
        /// <note>
        /// <p>
        /// <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You
        /// must specify one of these in a request but not both.</p>
        /// </note>
        pub fn set_close_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_time_filter(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn execution_filter(mut self, inp: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
        /// <p>If specified, only workflow executions that match this <i>close
        /// status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED
        /// workflow executions are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn close_status_filter(mut self, inp: crate::model::CloseStatusFilter) -> Self {
            self.inner = self.inner.close_status_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions that match this <i>close
        /// status</i> are listed. For example, if TERMINATED is specified, then only TERMINATED
        /// workflow executions are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_close_status_filter(
            mut self,
            input: std::option::Option<crate::model::CloseStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_close_status_filter(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn type_filter(mut self, inp: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(inp);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn tag_filter(mut self, inp: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(inp);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
        /// <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a
        /// request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(inp);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_page_size(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start or the close time of the
        /// executions.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start or the close time of the
        /// executions.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Returns the list of domains registered in the account. The results may be split into
    /// multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
    /// returned by the initial call.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains. The element must be set to
    /// <code>arn:aws:swf::AccountID:domain/*</code>, where <i>AccountID</i> is
    /// the account ID, with no dashes.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(inp);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>Specifies the registration status of the domains to list.</p>
        pub fn registration_status(mut self, inp: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(inp);
            self
        }
        /// <p>Specifies the registration status of the domains to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_page_size(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the
        /// domains.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default, the
        /// results are returned in ascending alphabetical order by <code>name</code> of the
        /// domains.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpenWorkflowExecutions`.
    ///
    /// <p>Returns a list of open workflow executions in the specified domain that meet the
    /// filtering criteria. The results may be split into multiple pages. To retrieve subsequent
    /// pages, make the call again using the nextPageToken returned by the initial call.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tagFilter.tag</code>: String constraint. The key is
    /// <code>swf:tagFilter.tag</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.name</code>: String constraint. The key is
    /// <code>swf:typeFilter.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>typeFilter.version</code>: String constraint. The key is
    /// <code>swf:typeFilter.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOpenWorkflowExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_open_workflow_executions_input::Builder,
    }
    impl<C, M, R> ListOpenWorkflowExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOpenWorkflowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpenWorkflowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpenWorkflowExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOpenWorkflowExecutionsInputOperationOutputAlias,
                crate::output::ListOpenWorkflowExecutionsOutput,
                crate::error::ListOpenWorkflowExecutionsError,
                crate::input::ListOpenWorkflowExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain that contains the workflow executions to list.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Workflow executions are included in the returned results based on whether their start
        /// times are within the range specified by this filter.</p>
        pub fn start_time_filter(mut self, inp: crate::model::ExecutionTimeFilter) -> Self {
            self.inner = self.inner.start_time_filter(inp);
            self
        }
        /// <p>Workflow executions are included in the returned results based on whether their start
        /// times are within the range specified by this filter.</p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimeFilter>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn type_filter(mut self, inp: crate::model::WorkflowTypeFilter) -> Self {
            self.inner = self.inner.type_filter(inp);
            self
        }
        /// <p>If specified, only executions of the type specified in the filter are
        /// returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_type_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_type_filter(input);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn tag_filter(mut self, inp: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filter(inp);
            self
        }
        /// <p>If specified, only executions that have the matching tag are listed.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_tag_filter(
            mut self,
            input: std::option::Option<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.set_tag_filter(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(inp);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_page_size(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start time of the executions.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in descending order of the start time of the executions.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn execution_filter(mut self, inp: crate::model::WorkflowExecutionFilter) -> Self {
            self.inner = self.inner.execution_filter(inp);
            self
        }
        /// <p>If specified, only workflow executions matching the workflow ID specified in the filter
        /// are returned.</p>
        /// <note>
        /// <p>
        /// <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
        /// mutually exclusive. You can specify at most one of these in a request.</p>
        /// </note>
        pub fn set_execution_filter(
            mut self,
            input: std::option::Option<crate::model::WorkflowExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_execution_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags for a given domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkflowTypes`.
    ///
    /// <p>Returns information about workflow types in the specified domain. The results may be
    /// split into multiple pages that can be retrieved by making the call repeatedly.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWorkflowTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workflow_types_input::Builder,
    }
    impl<C, M, R> ListWorkflowTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkflowTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkflowTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkflowTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkflowTypesInputOperationOutputAlias,
                crate::output::ListWorkflowTypesOutput,
                crate::error::ListWorkflowTypesError,
                crate::input::ListWorkflowTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the workflow types have been registered.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which the workflow types have been registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>If specified, lists the workflow type with this name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>If specified, lists the workflow type with this name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the registration status of the workflow types to list.</p>
        pub fn registration_status(mut self, inp: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(inp);
            self
        }
        /// <p>Specifies the registration status of the workflow types to list.</p>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn next_page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(inp);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn maximum_page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_page_size(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in ascending alphabetical order of the <code>name</code> of the workflow
        /// types.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>When set to <code>true</code>, returns the results in reverse order. By default the
        /// results are returned in ascending alphabetical order of the <code>name</code> of the workflow
        /// types.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PollForActivityTask`.
    ///
    /// <p>Used by workers to get an <a>ActivityTask</a> from the specified activity
    /// <code>taskList</code>. This initiates a long poll, where the service holds the HTTP
    /// connection open and responds as soon as a task becomes available. The maximum time the service
    /// holds on to the request before responding is 60 seconds. If no task is available within 60
    /// seconds, the poll returns an empty result. An empty result, in this context, means that an
    /// ActivityTask is returned, but that the value of taskToken is an empty string. If a task is
    /// returned, the worker should use its type to identify and process it correctly.</p>
    /// <important>
    /// <p>Workers should set their client side socket timeout to at least 70 seconds (10
    /// seconds higher than the maximum time service may hold the poll request).</p>
    /// </important>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the <code>taskList.name</code> parameter by using a
    /// <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the
    /// action to access only certain task lists.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PollForActivityTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::poll_for_activity_task_input::Builder,
    }
    impl<C, M, R> PollForActivityTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PollForActivityTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PollForActivityTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::PollForActivityTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PollForActivityTaskInputOperationOutputAlias,
                crate::output::PollForActivityTaskOutput,
                crate::error::PollForActivityTaskError,
                crate::input::PollForActivityTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the task lists being polled.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain that contains the task lists being polled.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the task list to poll for activity tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, inp: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(inp);
            self
        }
        /// <p>Specifies the task list to poll for activity tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
        /// <p>Identity of the worker making the request, recorded in the
        /// <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic
        /// tracing when problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>Identity of the worker making the request, recorded in the
        /// <code>ActivityTaskStarted</code> event in the workflow history. This enables diagnostic
        /// tracing when problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PollForDecisionTask`.
    ///
    /// <p>Used by deciders to get a <a>DecisionTask</a> from the specified decision
    /// <code>taskList</code>. A decision task may be returned for any open workflow execution that
    /// is using the specified task list. The task includes a paginated view of the history of the
    /// workflow execution. The decider should use the workflow type and the history to determine how
    /// to properly handle the task.</p>
    /// <p>This action initiates a long poll, where the service holds the HTTP connection open and
    /// responds as soon a task becomes available. If no decision task is available in the specified
    /// task list before the timeout of 60 seconds expires, an empty result is returned. An empty
    /// result, in this context, means that a DecisionTask is returned, but that the value of
    /// taskToken is an empty string.</p>
    /// <important>
    /// <p>Deciders should set their client side socket timeout to at least 70 seconds (10
    /// seconds higher than the timeout).</p>
    /// </important>
    /// <important>
    /// <p>Because the number of workflow history events for a single workflow execution might
    /// be very large, the result returned might be split up across a number of pages. To retrieve
    /// subsequent pages, make additional calls to <code>PollForDecisionTask</code> using the
    /// <code>nextPageToken</code> returned by the initial call. Note that you do
    /// <i>not</i> call <code>GetWorkflowExecutionHistory</code> with this
    /// <code>nextPageToken</code>. Instead, call <code>PollForDecisionTask</code>
    /// again.</p>
    /// </important>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the <code>taskList.name</code> parameter by using a
    /// <code>Condition</code> element with the <code>swf:taskList.name</code> key to allow the
    /// action to access only certain task lists.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PollForDecisionTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::poll_for_decision_task_input::Builder,
    }
    impl<C, M, R> PollForDecisionTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PollForDecisionTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PollForDecisionTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::PollForDecisionTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PollForDecisionTaskInputOperationOutputAlias,
                crate::output::PollForDecisionTaskOutput,
                crate::error::PollForDecisionTaskError,
                crate::input::PollForDecisionTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the task lists to poll.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain containing the task lists to poll.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specifies the task list to poll for decision tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, inp: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(inp);
            self
        }
        /// <p>Specifies the task list to poll for decision tasks.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
        /// <p>Identity of the decider making the request, which is recorded in the
        /// DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when
        /// problems arise. The form of this identity is user defined.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>Identity of the decider making the request, which is recorded in the
        /// DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when
        /// problems arise. The form of this identity is user defined.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        /// <note>
        /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to retrieve
        /// the next page of history records. Calling <a>PollForDecisionTask</a> with a
        /// <code>nextPageToken</code> doesn't return a new decision task.</p>
        /// </note>
        pub fn next_page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(inp);
            self
        }
        /// <p>If <code>NextPageToken</code> is returned there are more results
        /// available.  The value of <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using
        /// the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
        /// after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "<code>Specified token has
        /// exceeded its maximum lifetime</code>". </p>
        ///
        /// <p>The configured <code>maximumPageSize</code> determines how many results can be returned
        /// in a single call. </p>
        /// <note>
        /// <p>The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to retrieve
        /// the next page of history records. Calling <a>PollForDecisionTask</a> with a
        /// <code>nextPageToken</code> doesn't return a new decision task.</p>
        /// </note>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>  
        /// <p>This
        /// is an upper limit only; the actual number of results returned per call may be fewer than the
        /// specified maximum.</p>
        pub fn maximum_page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_page_size(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call.
        /// Use <code>nextPageToken</code> to obtain further pages of results. </p>  
        /// <p>This
        /// is an upper limit only; the actual number of results returned per call may be fewer than the
        /// specified maximum.</p>
        pub fn set_maximum_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_page_size(input);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimestamp</code> of the
        /// events.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>When set to <code>true</code>, returns the events in reverse order. By default the
        /// results are returned in ascending order of the <code>eventTimestamp</code> of the
        /// events.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RecordActivityTaskHeartbeat`.
    ///
    /// <p>Used by activity workers to report to the service that the <a>ActivityTask</a> represented by the specified <code>taskToken</code> is still making progress. The worker
    /// can also specify details of the progress, for example percent complete, using the
    /// <code>details</code> parameter. This action can also be used by the worker as a mechanism to
    /// check if cancellation is being requested for the activity task. If a cancellation is being
    /// attempted for the specified task, then the boolean <code>cancelRequested</code> flag returned
    /// by the service is set to <code>true</code>.</p>
    /// <p>This action resets the <code>taskHeartbeatTimeout</code> clock. The
    /// <code>taskHeartbeatTimeout</code> is specified in <a>RegisterActivityType</a>.</p>
    /// <p>This action doesn't in itself create an event in the workflow execution history.
    /// However, if the task times out, the workflow execution history contains a
    /// <code>ActivityTaskTimedOut</code> event that contains the information from the last
    /// heartbeat generated by the activity worker.</p>
    /// <note>
    /// <p>The <code>taskStartToCloseTimeout</code> of an activity type is the maximum duration
    /// of an activity task, regardless of the number of <a>RecordActivityTaskHeartbeat</a> requests received. The <code>taskStartToCloseTimeout</code> is also specified in <a>RegisterActivityType</a>.</p>
    /// </note>
    /// <note>
    /// <p>This operation is only useful for long-lived activities to report liveliness of the
    /// task and to determine if a cancellation is being attempted.</p>
    /// </note>
    /// <important>
    /// <p>If the <code>cancelRequested</code> flag returns <code>true</code>, a cancellation is
    /// being attempted. If the worker can cancel the activity, it should respond with <a>RespondActivityTaskCanceled</a>. Otherwise, it should ignore the cancellation
    /// request.</p>
    /// </important>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RecordActivityTaskHeartbeat<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::record_activity_task_heartbeat_input::Builder,
    }
    impl<C, M, R> RecordActivityTaskHeartbeat<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RecordActivityTaskHeartbeat`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RecordActivityTaskHeartbeatOutput,
            aws_smithy_http::result::SdkError<crate::error::RecordActivityTaskHeartbeatError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RecordActivityTaskHeartbeatInputOperationOutputAlias,
                crate::output::RecordActivityTaskHeartbeatOutput,
                crate::error::RecordActivityTaskHeartbeatError,
                crate::input::RecordActivityTaskHeartbeatInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results. </p>
        /// </important>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results. </p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>If specified, contains details about the progress of the task.</p>
        pub fn details(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p>If specified, contains details about the progress of the task.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterActivityType`.
    ///
    /// <p>Registers a new <i>activity type</i> along with its configuration
    /// settings in the specified domain.</p>
    /// <important>
    /// <p>A <code>TypeAlreadyExists</code> fault is returned if the type already exists in the
    /// domain. You cannot change any configuration settings of the type after its registration, and
    /// it must be registered as a new version.</p>
    /// </important>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>defaultTaskList.name</code>: String constraint. The key is
    /// <code>swf:defaultTaskList.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>name</code>: String constraint. The key is <code>swf:name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>version</code>: String constraint. The key is
    /// <code>swf:version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterActivityType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_activity_type_input::Builder,
    }
    impl<C, M, R> RegisterActivityType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterActivityTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterActivityTypeInputOperationOutputAlias,
                crate::output::RegisterActivityTypeOutput,
                crate::error::RegisterActivityTypeError,
                crate::input::RegisterActivityTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which this activity is to be registered.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which this activity is to be registered.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the activity type within the domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the activity type within the domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the activity type.</p>
        /// <note>
        /// <p>The activity type consists of the name and version, the combination of which must be
        /// unique within the domain.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The version of the activity type.</p>
        /// <note>
        /// <p>The activity type consists of the name and version, the combination of which must be
        /// unique within the domain.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>A textual description of the activity type.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A textual description of the activity type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If set, specifies the default maximum duration that a worker can take to process tasks
        /// of this activity type. This default can be overridden when scheduling an activity task using
        /// the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_start_to_close_timeout(inp);
            self
        }
        /// <p>If set, specifies the default maximum duration that a worker can take to process tasks
        /// of this activity type. This default can be overridden when scheduling an activity task using
        /// the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the default maximum time before which a worker processing a task of
        /// this type must report progress by calling <a>RecordActivityTaskHeartbeat</a>. If
        /// the timeout is exceeded, the activity task is automatically timed out. This default can be
        /// overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. If the activity worker subsequently attempts to record a heartbeat
        /// or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In
        /// this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should
        /// clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_heartbeat_timeout(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_heartbeat_timeout(inp);
            self
        }
        /// <p>If set, specifies the default maximum time before which a worker processing a task of
        /// this type must report progress by calling <a>RecordActivityTaskHeartbeat</a>. If
        /// the timeout is exceeded, the activity task is automatically timed out. This default can be
        /// overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>. If the activity worker subsequently attempts to record a heartbeat
        /// or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In
        /// this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should
        /// clean up the activity task.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_heartbeat_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_heartbeat_timeout(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling tasks of this activity
        /// type. This default task list is used if a task list isn't provided when a task is scheduled
        /// through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        pub fn default_task_list(mut self, inp: crate::model::TaskList) -> Self {
            self.inner = self.inner.default_task_list(inp);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling tasks of this activity
        /// type. This default task list is used if a task list isn't provided when a task is scheduled
        /// through the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.inner = self.inner.set_default_task_list(input);
            self
        }
        /// <p>The default task priority to assign to the activity type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>in the
        /// <i>Amazon SWF Developer Guide</i>.</i>.</p>
        pub fn default_task_priority(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_task_priority(inp);
            self
        }
        /// <p>The default task priority to assign to the activity type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>in the
        /// <i>Amazon SWF Developer Guide</i>.</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_priority(input);
            self
        }
        /// <p>If set, specifies the default maximum duration that a task of this activity type can
        /// wait before being assigned to a worker. This default can be overridden when scheduling an
        /// activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_start_timeout(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_schedule_to_start_timeout(inp);
            self
        }
        /// <p>If set, specifies the default maximum duration that a task of this activity type can
        /// wait before being assigned to a worker. This default can be overridden when scheduling an
        /// activity task using the <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_start_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_schedule_to_start_timeout(input);
            self
        }
        /// <p>If set, specifies the default maximum duration for a task of this activity type. This
        /// default can be overridden when scheduling an activity task using the
        /// <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_schedule_to_close_timeout(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_schedule_to_close_timeout(inp);
            self
        }
        /// <p>If set, specifies the default maximum duration for a task of this activity type. This
        /// default can be overridden when scheduling an activity task using the
        /// <code>ScheduleActivityTask</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_schedule_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_schedule_to_close_timeout(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDomain`.
    ///
    /// <p>Registers a new domain.</p>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>You cannot use an IAM policy to control domain access for this action. The name of
    /// the domain being registered is available as the resource of this action.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_domain_input::Builder,
    }
    impl<C, M, R> RegisterDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterDomainInputOperationOutputAlias,
                crate::output::RegisterDomainOutput,
                crate::error::RegisterDomainError,
                crate::input::RegisterDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the domain to register. The name must be unique in the region that the domain
        /// is registered in.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the domain to register. The name must be unique in the region that the domain
        /// is registered in.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A text description of the domain.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A text description of the domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The duration (in days) that records and histories of workflow executions on the domain
        /// should be kept by the service. After the retention period, the workflow execution isn't
        /// available in the results of visibility calls.</p>
        /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow
        /// execution history isn't retained. As soon as the workflow execution completes, the execution
        /// record and its history are deleted.</p>
        /// <p>The maximum workflow execution retention period is 90 days. For more information about
        /// Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        pub fn workflow_execution_retention_period_in_days(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.workflow_execution_retention_period_in_days(inp);
            self
        }
        /// <p>The duration (in days) that records and histories of workflow executions on the domain
        /// should be kept by the service. After the retention period, the workflow execution isn't
        /// available in the results of visibility calls.</p>
        /// <p>If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow
        /// execution history isn't retained. As soon as the workflow execution completes, the execution
        /// record and its history are deleted.</p>
        /// <p>The maximum workflow execution retention period is 90 days. For more information about
        /// Amazon SWF service limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service Limits</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_workflow_execution_retention_period_in_days(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_workflow_execution_retention_period_in_days(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be added when registering a domain.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::ResourceTag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be added when registering a domain.</p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterWorkflowType`.
    ///
    /// <p>Registers a new <i>workflow type</i> and its configuration settings in
    /// the specified domain.</p>
    /// <p>The retention period for the workflow history is set by the <a>RegisterDomain</a> action.</p>
    /// <important>
    /// <p>If the type already exists, then a <code>TypeAlreadyExists</code> fault is returned.
    /// You cannot change the configuration settings of a workflow type once it is registered and it
    /// must be registered as a new version.</p>
    /// </important>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>defaultTaskList.name</code>: String constraint. The key is
    /// <code>swf:defaultTaskList.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>name</code>: String constraint. The key is <code>swf:name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>version</code>: String constraint. The key is
    /// <code>swf:version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterWorkflowType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_workflow_type_input::Builder,
    }
    impl<C, M, R> RegisterWorkflowType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterWorkflowTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterWorkflowTypeInputOperationOutputAlias,
                crate::output::RegisterWorkflowTypeOutput,
                crate::error::RegisterWorkflowTypeError,
                crate::input::RegisterWorkflowTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which to register the workflow type.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which to register the workflow type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the workflow type.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the workflow type.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the workflow type.</p>
        /// <note>
        /// <p>The workflow type consists of the name and version, the combination of which must be
        /// unique within the domain. To get a list of all currently registered workflow types, use the
        /// <a>ListWorkflowTypes</a> action.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The version of the workflow type.</p>
        /// <note>
        /// <p>The workflow type consists of the name and version, the combination of which must be
        /// unique within the domain. To get a list of all currently registered workflow types, use the
        /// <a>ListWorkflowTypes</a> action.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>Textual description of the workflow type.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Textual description of the workflow type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If set, specifies the default maximum duration of decision tasks for this workflow
        /// type. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn default_task_start_to_close_timeout(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_task_start_to_close_timeout(inp);
            self
        }
        /// <p>If set, specifies the default maximum duration of decision tasks for this workflow
        /// type. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        pub fn set_default_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the default maximum duration for executions of this workflow type.
        /// You can override this default when starting an execution through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike
        /// some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
        /// <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time
        /// that a workflow execution can run. Exceeding this limit always causes the workflow execution
        /// to time out.</p>
        pub fn default_execution_start_to_close_timeout(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_execution_start_to_close_timeout(inp);
            self
        }
        /// <p>If set, specifies the default maximum duration for executions of this workflow type.
        /// You can override this default when starting an execution through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to 0. Unlike
        /// some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
        /// <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time
        /// that a workflow execution can run. Exceeding this limit always causes the workflow execution
        /// to time out.</p>
        pub fn set_default_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_default_execution_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling decision tasks for
        /// executions of this workflow type. This default is used only if a task list isn't provided when
        /// starting the execution through the <a>StartWorkflowExecution</a> Action or
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        pub fn default_task_list(mut self, inp: crate::model::TaskList) -> Self {
            self.inner = self.inner.default_task_list(inp);
            self
        }
        /// <p>If set, specifies the default task list to use for scheduling decision tasks for
        /// executions of this workflow type. This default is used only if a task list isn't provided when
        /// starting the execution through the <a>StartWorkflowExecution</a> Action or
        /// <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        pub fn set_default_task_list(
            mut self,
            input: std::option::Option<crate::model::TaskList>,
        ) -> Self {
            self.inner = self.inner.set_default_task_list(input);
            self
        }
        /// <p>The default task priority to assign to the workflow type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn default_task_priority(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_task_priority(inp);
            self
        }
        /// <p>The default task priority to assign to the workflow type. If not assigned, then
        /// <code>0</code> is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_default_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_task_priority(input);
            self
        }
        /// <p>If set, specifies the default policy to use for the child workflow executions when a
        /// workflow execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This
        /// default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        pub fn default_child_policy(mut self, inp: crate::model::ChildPolicy) -> Self {
            self.inner = self.inner.default_child_policy(inp);
            self
        }
        /// <p>If set, specifies the default policy to use for the child workflow executions when a
        /// workflow execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This
        /// default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
        /// <a>Decision</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        pub fn set_default_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.inner = self.inner.set_default_child_policy(input);
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't specify an IAM role when you start this workflow type, the default Lambda role is
        /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn default_lambda_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_lambda_role(inp);
            self
        }
        /// <p>The default IAM role attached to this workflow type.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't specify an IAM role when you start this workflow type, the default Lambda role is
        /// attached to the execution. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_default_lambda_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_lambda_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RequestCancelWorkflowExecution`.
    ///
    /// <p>Records a <code>WorkflowExecutionCancelRequested</code> event in the currently running
    /// workflow execution identified by the given domain, workflowId, and runId. This logically
    /// requests the cancellation of the workflow execution as a whole. It is up to the decider to
    /// take appropriate actions when it receives an execution history with this event.</p>
    ///
    /// <note>
    /// <p>If the runId isn't specified, the <code>WorkflowExecutionCancelRequested</code> event
    /// is recorded in the history of the current open workflow execution with the specified
    /// workflowId in the domain.</p>
    /// </note>
    ///
    /// <note>
    /// <p>Because this action allows the workflow to properly clean up and gracefully close, it
    /// should be used instead of <a>TerminateWorkflowExecution</a> when
    /// possible.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RequestCancelWorkflowExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::request_cancel_workflow_execution_input::Builder,
    }
    impl<C, M, R> RequestCancelWorkflowExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RequestCancelWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RequestCancelWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::RequestCancelWorkflowExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RequestCancelWorkflowExecutionInputOperationOutputAlias,
                crate::output::RequestCancelWorkflowExecutionOutput,
                crate::error::RequestCancelWorkflowExecutionError,
                crate::input::RequestCancelWorkflowExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow execution to cancel.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain containing the workflow execution to cancel.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflowId of the workflow execution to cancel.</p>
        pub fn workflow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(inp);
            self
        }
        /// <p>The workflowId of the workflow execution to cancel.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The runId of the workflow execution to cancel.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The runId of the workflow execution to cancel.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondActivityTaskCanceled`.
    ///
    /// <p>Used by workers to tell the service that the <a>ActivityTask</a> identified
    /// by the <code>taskToken</code> was successfully canceled. Additional <code>details</code> can
    /// be provided using the <code>details</code> argument.</p>
    ///
    /// <p>These <code>details</code> (if provided) appear in the
    /// <code>ActivityTaskCanceled</code> event added to the workflow history.</p>
    ///
    /// <important>
    /// <p>Only use this operation if the <code>canceled</code> flag of a <a>RecordActivityTaskHeartbeat</a> request returns <code>true</code> and if the
    /// activity can be safely undone or abandoned.</p>
    /// </important>
    ///
    /// <p>A task is considered open from the time that it is scheduled until it is closed.
    /// Therefore a task is reported as open while a worker is processing it. A task is closed after
    /// it has been specified in a call to <a>RespondActivityTaskCompleted</a>,
    /// RespondActivityTaskCanceled, <a>RespondActivityTaskFailed</a>, or the task has
    /// <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
    /// out</a>.</p>
    ///
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RespondActivityTaskCanceled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::respond_activity_task_canceled_input::Builder,
    }
    impl<C, M, R> RespondActivityTaskCanceled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RespondActivityTaskCanceled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondActivityTaskCanceledOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCanceledError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RespondActivityTaskCanceledInputOperationOutputAlias,
                crate::output::RespondActivityTaskCanceledOutput,
                crate::error::RespondActivityTaskCanceledError,
                crate::input::RespondActivityTaskCanceledInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p> Information about the cancellation.</p>
        pub fn details(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p> Information about the cancellation.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondActivityTaskCompleted`.
    ///
    /// <p>Used by workers to tell the service that the <a>ActivityTask</a> identified
    /// by the <code>taskToken</code> completed successfully with a <code>result</code> (if provided).
    /// The <code>result</code> appears in the <code>ActivityTaskCompleted</code> event in the
    /// workflow history.</p>
    ///
    /// <important>
    /// <p>If the requested task doesn't complete successfully, use <a>RespondActivityTaskFailed</a> instead. If the worker finds that the task is
    /// canceled through the <code>canceled</code> flag returned by <a>RecordActivityTaskHeartbeat</a>, it should cancel the task, clean up and then call
    /// <a>RespondActivityTaskCanceled</a>.</p>
    /// </important>
    ///
    /// <p>A task is considered open from the time that it is scheduled until it is closed.
    /// Therefore a task is reported as open while a worker is processing it. A task is closed after
    /// it has been specified in a call to RespondActivityTaskCompleted, <a>RespondActivityTaskCanceled</a>, <a>RespondActivityTaskFailed</a>, or the
    /// task has <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
    /// out</a>.</p>
    ///
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RespondActivityTaskCompleted<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::respond_activity_task_completed_input::Builder,
    }
    impl<C, M, R> RespondActivityTaskCompleted<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RespondActivityTaskCompleted`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondActivityTaskCompletedOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCompletedError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RespondActivityTaskCompletedInputOperationOutputAlias,
                crate::output::RespondActivityTaskCompletedOutput,
                crate::error::RespondActivityTaskCompletedError,
                crate::input::RespondActivityTaskCompletedInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>The result of the activity task. It is a free form string that is implementation
        /// specific.</p>
        pub fn result(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result(inp);
            self
        }
        /// <p>The result of the activity task. It is a free form string that is implementation
        /// specific.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_result(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondActivityTaskFailed`.
    ///
    /// <p>Used by workers to tell the service that the <a>ActivityTask</a> identified
    /// by the <code>taskToken</code> has failed with <code>reason</code> (if specified). The
    /// <code>reason</code> and <code>details</code> appear in the <code>ActivityTaskFailed</code>
    /// event added to the workflow history.</p>
    ///
    /// <p>A task is considered open from the time that it is scheduled until it is closed.
    /// Therefore a task is reported as open while a worker is processing it. A task is closed after
    /// it has been specified in a call to <a>RespondActivityTaskCompleted</a>, <a>RespondActivityTaskCanceled</a>, RespondActivityTaskFailed, or the task has <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
    /// out</a>.</p>
    ///
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RespondActivityTaskFailed<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::respond_activity_task_failed_input::Builder,
    }
    impl<C, M, R> RespondActivityTaskFailed<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RespondActivityTaskFailed`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondActivityTaskFailedOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskFailedError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RespondActivityTaskFailedInputOperationOutputAlias,
                crate::output::RespondActivityTaskFailedOutput,
                crate::error::RespondActivityTaskFailedError,
                crate::input::RespondActivityTaskFailedInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        ///
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
        ///
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>Description of the error that may assist in diagnostics.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>Description of the error that may assist in diagnostics.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p> Detailed information about the failure.</p>
        pub fn details(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p> Detailed information about the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondDecisionTaskCompleted`.
    ///
    /// <p>Used by deciders to tell the service that the <a>DecisionTask</a> identified
    /// by the <code>taskToken</code> has successfully completed. The <code>decisions</code> argument
    /// specifies the list of decisions made while processing the task.</p>
    ///
    /// <p>A <code>DecisionTaskCompleted</code> event is added to the workflow history. The
    /// <code>executionContext</code> specified is attached to the event in the workflow execution
    /// history.</p>
    ///
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    ///
    /// <p>If an IAM policy grants permission to use <code>RespondDecisionTaskCompleted</code>, it
    /// can express permissions for the list of decisions in the <code>decisions</code> parameter.
    /// Each of the decisions has one or more parameters, much like a regular API call. To allow for
    /// policies to be as readable as possible, you can express permissions on decisions as if they
    /// were actual API calls, including applying conditions to some parameters. For more information,
    /// see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
    /// IAM to Manage Access to Amazon SWF Workflows</a> in the
    /// <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RespondDecisionTaskCompleted<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::respond_decision_task_completed_input::Builder,
    }
    impl<C, M, R> RespondDecisionTaskCompleted<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RespondDecisionTaskCompleted`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondDecisionTaskCompletedOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondDecisionTaskCompletedError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RespondDecisionTaskCompletedInputOperationOutputAlias,
                crate::output::RespondDecisionTaskCompletedOutput,
                crate::error::RespondDecisionTaskCompletedError,
                crate::input::RespondDecisionTaskCompletedInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>
        /// <important>
        /// <p>
        /// <code>taskToken</code> is generated by the service and should be treated as an opaque value.
        /// If the task is passed to another process, its <code>taskToken</code> must also be passed.
        /// This enables it to provide its progress and respond with results.</p>
        /// </important>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// Appends an item to `decisions`.
        ///
        /// To override the contents of this collection use [`set_decisions`](Self::set_decisions).
        ///
        /// <p>The list of decisions (possibly empty) made by the decider while processing this
        /// decision task. See the docs for the <a>Decision</a> structure for
        /// details.</p>
        pub fn decisions(mut self, inp: impl Into<crate::model::Decision>) -> Self {
            self.inner = self.inner.decisions(inp);
            self
        }
        /// <p>The list of decisions (possibly empty) made by the decider while processing this
        /// decision task. See the docs for the <a>Decision</a> structure for
        /// details.</p>
        pub fn set_decisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Decision>>,
        ) -> Self {
            self.inner = self.inner.set_decisions(input);
            self
        }
        /// <p>User defined context to add to workflow execution.</p>
        pub fn execution_context(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_context(inp);
            self
        }
        /// <p>User defined context to add to workflow execution.</p>
        pub fn set_execution_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SignalWorkflowExecution`.
    ///
    /// <p>Records a <code>WorkflowExecutionSignaled</code> event in the workflow execution
    /// history and creates a decision task for the workflow execution identified by the given domain,
    /// workflowId and runId. The event is recorded with the specified user defined signalName and
    /// input (if provided).</p>
    ///
    /// <note>
    /// <p>If a runId isn't specified, then the <code>WorkflowExecutionSignaled</code> event is
    /// recorded in the history of the current open workflow with the matching workflowId in the
    /// domain.</p>
    /// </note>
    ///
    /// <note>
    /// <p>If the specified workflow execution isn't open, this method fails with
    /// <code>UnknownResource</code>.</p>
    /// </note>
    ///
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SignalWorkflowExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::signal_workflow_execution_input::Builder,
    }
    impl<C, M, R> SignalWorkflowExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SignalWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SignalWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::SignalWorkflowExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SignalWorkflowExecutionInputOperationOutputAlias,
                crate::output::SignalWorkflowExecutionOutput,
                crate::error::SignalWorkflowExecutionError,
                crate::input::SignalWorkflowExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain containing the workflow execution to signal.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain containing the workflow execution to signal.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflowId of the workflow execution to signal.</p>
        pub fn workflow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(inp);
            self
        }
        /// <p>The workflowId of the workflow execution to signal.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The runId of the workflow execution to signal.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The runId of the workflow execution to signal.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
        pub fn signal_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.signal_name(inp);
            self
        }
        /// <p>The name of the signal. This name must be meaningful to the target workflow.</p>
        pub fn set_signal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_signal_name(input);
            self
        }
        /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target
        /// workflow execution's history.</p>
        pub fn input(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(inp);
            self
        }
        /// <p>Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target
        /// workflow execution's history.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartWorkflowExecution`.
    ///
    /// <p>Starts an execution of the workflow type in the specified domain using the provided
    /// <code>workflowId</code> and input data.</p>
    ///
    /// <p>This action returns the newly started workflow execution.</p>
    ///
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tagList.member.0</code>: The key is <code>swf:tagList.member.0</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tagList.member.1</code>: The key is <code>swf:tagList.member.1</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tagList.member.2</code>: The key is <code>swf:tagList.member.2</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tagList.member.3</code>: The key is <code>swf:tagList.member.3</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tagList.member.4</code>: The key is <code>swf:tagList.member.4</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>taskList</code>: String constraint. The key is
    /// <code>swf:taskList.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>workflowType.name</code>: String constraint. The key is
    /// <code>swf:workflowType.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>workflowType.version</code>: String constraint. The key is
    /// <code>swf:workflowType.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartWorkflowExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_workflow_execution_input::Builder,
    }
    impl<C, M, R> StartWorkflowExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartWorkflowExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartWorkflowExecutionInputOperationOutputAlias,
                crate::output::StartWorkflowExecutionOutput,
                crate::error::StartWorkflowExecutionError,
                crate::input::StartWorkflowExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain in which the workflow execution is created.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain in which the workflow execution is created.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The user defined identifier associated with the workflow execution. You can use this to
        /// associate a custom identifier with the workflow execution. You may specify the same identifier
        /// if a workflow execution is logically a <i>restart</i> of a previous execution.
        /// You cannot have two open workflow executions with the same <code>workflowId</code> at the same
        /// time within the same domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn workflow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(inp);
            self
        }
        /// <p>The user defined identifier associated with the workflow execution. You can use this to
        /// associate a custom identifier with the workflow execution. You may specify the same identifier
        /// if a workflow execution is logically a <i>restart</i> of a previous execution.
        /// You cannot have two open workflow executions with the same <code>workflowId</code> at the same
        /// time within the same domain.</p>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The type of the workflow to start.</p>
        pub fn workflow_type(mut self, inp: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(inp);
            self
        }
        /// <p>The type of the workflow to start.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
        /// <p>The task list to use for the decision tasks generated for this workflow execution. This
        /// overrides the <code>defaultTaskList</code> specified when registering the workflow
        /// type.</p>
        /// <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the
        /// workflow type or through this parameter. If neither this parameter is set nor a default task
        /// list was specified at registration time then a fault is returned.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn task_list(mut self, inp: crate::model::TaskList) -> Self {
            self.inner = self.inner.task_list(inp);
            self
        }
        /// <p>The task list to use for the decision tasks generated for this workflow execution. This
        /// overrides the <code>defaultTaskList</code> specified when registering the workflow
        /// type.</p>
        /// <note>
        /// <p>A task list for this workflow execution must be specified either as a default for the
        /// workflow type or through this parameter. If neither this parameter is set nor a default task
        /// list was specified at registration time then a fault is returned.</p>
        /// </note>
        ///
        /// <p>The specified string must not start or end with whitespace. It must not contain a
        /// <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any
        /// control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
        /// not <i>be</i> the literal string <code>arn</code>.</p>
        pub fn set_task_list(mut self, input: std::option::Option<crate::model::TaskList>) -> Self {
            self.inner = self.inner.set_task_list(input);
            self
        }
        /// <p>The task priority to use for this workflow execution. This overrides any default
        /// priority that was assigned when the workflow type was registered. If not set, then the default
        /// task priority for the workflow type is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn task_priority(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_priority(inp);
            self
        }
        /// <p>The task priority to use for this workflow execution. This overrides any default
        /// priority that was assigned when the workflow type was registered. If not set, then the default
        /// task priority for the workflow type is used. Valid values are integers that range from Java's
        /// <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
        /// Higher numbers indicate higher priority.</p>
        /// <p>For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
        /// Priority</a> in the <i>Amazon SWF Developer Guide</i>.</p>
        pub fn set_task_priority(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_priority(input);
            self
        }
        /// <p>The input for the workflow execution. This is a free form string which should be
        /// meaningful to the workflow you are starting. This <code>input</code> is made available to the
        /// new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
        pub fn input(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(inp);
            self
        }
        /// <p>The input for the workflow execution. This is a free form string which should be
        /// meaningful to the workflow you are starting. This <code>input</code> is made available to the
        /// new workflow execution in the <code>WorkflowExecutionStarted</code> history event.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the
        /// defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to
        /// <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some
        /// of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this
        /// timeout; there is a one-year max limit on the time that a workflow execution can
        /// run.</p>
        ///
        /// <note>
        /// <p>An execution start-to-close timeout must be specified either through this parameter
        /// or as a default when the workflow type is registered. If neither this parameter nor a
        /// default execution start-to-close timeout is specified, a fault is returned.</p>
        /// </note>
        pub fn execution_start_to_close_timeout(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.execution_start_to_close_timeout(inp);
            self
        }
        /// <p>The total duration for this workflow execution. This overrides the
        /// defaultExecutionStartToCloseTimeout specified when registering the workflow type.</p>
        ///
        /// <p>The duration is specified in seconds; an integer greater than or equal to
        /// <code>0</code>. Exceeding this limit causes the workflow execution to time out. Unlike some
        /// of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this
        /// timeout; there is a one-year max limit on the time that a workflow execution can
        /// run.</p>
        ///
        /// <note>
        /// <p>An execution start-to-close timeout must be specified either through this parameter
        /// or as a default when the workflow type is registered. If neither this parameter nor a
        /// default execution start-to-close timeout is specified, a fault is returned.</p>
        /// </note>
        pub fn set_execution_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_start_to_close_timeout(input);
            self
        }
        /// Appends an item to `tagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of
        /// 5 tags. You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or <a>ListClosedWorkflowExecutions</a> and
        /// specifying a <a>TagFilter</a>.</p>
        pub fn tag_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_list(inp);
            self
        }
        /// <p>The list of tags to associate with the workflow execution. You can specify a maximum of
        /// 5 tags. You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or <a>ListClosedWorkflowExecutions</a> and
        /// specifying a <a>TagFilter</a>.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This
        /// parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering
        /// the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as
        /// a default for the workflow type or through this parameter. If neither this parameter is set
        /// nor a default task start-to-close timeout was specified at registration time then a fault is
        /// returned.</p>
        /// </note>
        pub fn task_start_to_close_timeout(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_start_to_close_timeout(inp);
            self
        }
        /// <p>Specifies the maximum duration of decision tasks for this workflow execution. This
        /// parameter overrides the <code>defaultTaskStartToCloseTimout</code> specified when registering
        /// the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The duration is specified in seconds, an integer greater than or equal to
        /// <code>0</code>. You can use <code>NONE</code> to specify unlimited duration.</p>
        /// <note>
        /// <p>A task start-to-close timeout for this workflow execution must be specified either as
        /// a default for the workflow type or through this parameter. If neither this parameter is set
        /// nor a default task start-to-close timeout was specified at registration time then a fault is
        /// returned.</p>
        /// </note>
        pub fn set_task_start_to_close_timeout(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_start_to_close_timeout(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of this workflow
        /// execution if it is terminated, by calling the <a>TerminateWorkflowExecution</a>
        /// action explicitly or due to an expired timeout. This policy overrides the default child policy
        /// specified when registering the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, inp: crate::model::ChildPolicy) -> Self {
            self.inner = self.inner.child_policy(inp);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of this workflow
        /// execution if it is terminated, by calling the <a>TerminateWorkflowExecution</a>
        /// action explicitly or due to an expired timeout. This policy overrides the default child policy
        /// specified when registering the workflow type using <a>RegisterWorkflowType</a>.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.inner = self.inner.set_child_policy(input);
            self
        }
        /// <p>The IAM role to attach to this workflow execution.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a
        /// <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn lambda_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lambda_role(inp);
            self
        }
        /// <p>The IAM role to attach to this workflow execution.</p>
        /// <note>
        /// <p>Executions of this workflow type need IAM roles to invoke Lambda functions. If you
        /// don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a
        /// <code>ScheduleLambdaFunctionFailed</code> history event. For more information, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the
        /// <i>Amazon SWF Developer Guide</i>.</p>
        /// </note>
        pub fn set_lambda_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lambda_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add a tag to a Amazon SWF domain.</p>
    /// <note>
    /// <p>Amazon SWF supports a maximum of 50 tags per resource.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a domain. </p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::ResourceTag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags to add to a domain. </p>
        /// <p>Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateWorkflowExecution`.
    ///
    /// <p>Records a <code>WorkflowExecutionTerminated</code> event and forces closure of the
    /// workflow execution identified by the given domain, runId, and workflowId. The child policy,
    /// registered with the workflow type or specified when starting this execution, is applied to any
    /// open child workflow executions of this workflow execution.</p>
    ///
    /// <important>
    /// <p>If the identified workflow execution was in progress, it is terminated
    /// immediately.</p>
    /// </important>
    ///
    /// <note>
    /// <p>If a runId isn't specified, then the <code>WorkflowExecutionTerminated</code> event
    /// is recorded in the history of the current open workflow with the matching workflowId in the
    /// domain.</p>
    /// </note>
    ///
    /// <note>
    /// <p>You should consider using <a>RequestCancelWorkflowExecution</a> action
    /// instead because it allows the workflow to gracefully close while <a>TerminateWorkflowExecution</a> doesn't.</p>
    /// </note>
    ///
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TerminateWorkflowExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_workflow_execution_input::Builder,
    }
    impl<C, M, R> TerminateWorkflowExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateWorkflowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateWorkflowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateWorkflowExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateWorkflowExecutionInputOperationOutputAlias,
                crate::output::TerminateWorkflowExecutionOutput,
                crate::error::TerminateWorkflowExecutionError,
                crate::input::TerminateWorkflowExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain of the workflow execution to terminate.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain of the workflow execution to terminate.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The workflowId of the workflow execution to terminate.</p>
        pub fn workflow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(inp);
            self
        }
        /// <p>The workflowId of the workflow execution to terminate.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The runId of the workflow execution to terminate.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The runId of the workflow execution to terminate.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// <p> A descriptive reason for terminating the workflow execution.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p> A descriptive reason for terminating the workflow execution.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p> Details for terminating the workflow execution.</p>
        pub fn details(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p> Details for terminating the workflow execution.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the workflow
        /// execution being terminated. This policy overrides the child policy specified for the workflow
        /// execution at registration time or when starting the execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn child_policy(mut self, inp: crate::model::ChildPolicy) -> Self {
            self.inner = self.inner.child_policy(inp);
            self
        }
        /// <p>If set, specifies the policy to use for the child workflow executions of the workflow
        /// execution being terminated. This policy overrides the child policy specified for the workflow
        /// execution at registration time or when starting the execution.</p>
        /// <p>The supported child policies are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE</code> – The child executions are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
        /// execution by recording a <code>WorkflowExecutionCancelRequested</code> event in its
        /// history. It is up to the decider to take appropriate actions when it receives an execution
        /// history with this event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ABANDON</code> – No action is taken. The child executions continue to
        /// run.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>A child policy for this workflow execution must be specified either as a default for
        /// the workflow type or through this parameter. If neither this parameter is set nor a default
        /// child policy was specified at registration time then a fault is returned.</p>
        /// </note>
        pub fn set_child_policy(
            mut self,
            input: std::option::Option<crate::model::ChildPolicy>,
        ) -> Self {
            self.inner = self.inner.set_child_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeprecateActivityType`.
    ///
    /// <p>Undeprecates a previously deprecated <i>activity type</i>. After an activity type has
    /// been undeprecated, you can create new tasks of that activity type.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>activityType.name</code>: String constraint. The key is
    /// <code>swf:activityType.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>activityType.version</code>: String constraint. The key is
    /// <code>swf:activityType.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UndeprecateActivityType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::undeprecate_activity_type_input::Builder,
    }
    impl<C, M, R> UndeprecateActivityType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UndeprecateActivityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeprecateActivityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeprecateActivityTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UndeprecateActivityTypeInputOperationOutputAlias,
                crate::output::UndeprecateActivityTypeOutput,
                crate::error::UndeprecateActivityTypeError,
                crate::input::UndeprecateActivityTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain of the deprecated activity type.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain of the deprecated activity type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The activity type to undeprecate.</p>
        pub fn activity_type(mut self, inp: crate::model::ActivityType) -> Self {
            self.inner = self.inner.activity_type(inp);
            self
        }
        /// <p>The activity type to undeprecate.</p>
        pub fn set_activity_type(
            mut self,
            input: std::option::Option<crate::model::ActivityType>,
        ) -> Self {
            self.inner = self.inner.set_activity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeprecateDomain`.
    ///
    /// <p>Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used
    /// to create new workflow executions or register new types.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use an IAM policy to constrain this action's parameters.</p>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UndeprecateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::undeprecate_domain_input::Builder,
    }
    impl<C, M, R> UndeprecateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UndeprecateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeprecateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeprecateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UndeprecateDomainInputOperationOutputAlias,
                crate::output::UndeprecateDomainOutput,
                crate::error::UndeprecateDomainError,
                crate::input::UndeprecateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeprecateWorkflowType`.
    ///
    /// <p>Undeprecates a previously deprecated <i>workflow type</i>. After a workflow type has
    /// been undeprecated, you can create new executions of that type. </p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not
    /// exactly reflect recent updates and changes.</p>
    /// </note>
    /// <p>
    /// <b>Access Control</b>
    /// </p>
    /// <p>You can use IAM policies to control this action's access to Amazon SWF resources as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>Use a <code>Resource</code> element with the domain name to limit the action to
    /// only specified domains.</p>
    /// </li>
    /// <li>
    /// <p>Use an <code>Action</code> element to allow or deny permission to call this
    /// action.</p>
    /// </li>
    /// <li>
    /// <p>Constrain the following parameters by using a <code>Condition</code> element with
    /// the appropriate keys.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>workflowType.name</code>: String constraint. The key is
    /// <code>swf:workflowType.name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>workflowType.version</code>: String constraint. The key is
    /// <code>swf:workflowType.version</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If the caller doesn't have sufficient permissions to invoke the action, or the
    /// parameter values fall outside the specified constraints, the action fails. The associated
    /// event attribute's <code>cause</code> parameter is set to <code>OPERATION_NOT_PERMITTED</code>.
    /// For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
    /// Workflows</a> in the <i>Amazon SWF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UndeprecateWorkflowType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::undeprecate_workflow_type_input::Builder,
    }
    impl<C, M, R> UndeprecateWorkflowType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UndeprecateWorkflowType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeprecateWorkflowTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeprecateWorkflowTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UndeprecateWorkflowTypeInputOperationOutputAlias,
                crate::output::UndeprecateWorkflowTypeOutput,
                crate::error::UndeprecateWorkflowTypeError,
                crate::input::UndeprecateWorkflowTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn workflow_type(mut self, inp: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(inp);
            self
        }
        /// <p>The name of the domain of the deprecated workflow type.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove a tag from a Amazon SWF domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon SWF domain.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tags to remove from the Amazon SWF domain.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tags to remove from the Amazon SWF domain.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
