// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CountClosedWorkflowExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`count_closed_workflow_executions`](crate::client::Client::count_closed_workflow_executions).
///
/// See [`crate::client::fluent_builders::CountClosedWorkflowExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CountClosedWorkflowExecutions {
    _private: (),
}
impl CountClosedWorkflowExecutions {
    /// Creates a new builder-style object to manufacture [`CountClosedWorkflowExecutionsInput`](crate::input::CountClosedWorkflowExecutionsInput)
    pub fn builder() -> crate::input::count_closed_workflow_executions_input::Builder {
        crate::input::count_closed_workflow_executions_input::Builder::default()
    }
    /// Creates a new `CountClosedWorkflowExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CountClosedWorkflowExecutions {
    type Output = std::result::Result<
        crate::output::CountClosedWorkflowExecutionsOutput,
        crate::error::CountClosedWorkflowExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_count_closed_workflow_executions_error(response)
        } else {
            crate::operation_deser::parse_count_closed_workflow_executions_response(response)
        }
    }
}

/// Operation shape for `CountOpenWorkflowExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`count_open_workflow_executions`](crate::client::Client::count_open_workflow_executions).
///
/// See [`crate::client::fluent_builders::CountOpenWorkflowExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CountOpenWorkflowExecutions {
    _private: (),
}
impl CountOpenWorkflowExecutions {
    /// Creates a new builder-style object to manufacture [`CountOpenWorkflowExecutionsInput`](crate::input::CountOpenWorkflowExecutionsInput)
    pub fn builder() -> crate::input::count_open_workflow_executions_input::Builder {
        crate::input::count_open_workflow_executions_input::Builder::default()
    }
    /// Creates a new `CountOpenWorkflowExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CountOpenWorkflowExecutions {
    type Output = std::result::Result<
        crate::output::CountOpenWorkflowExecutionsOutput,
        crate::error::CountOpenWorkflowExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_count_open_workflow_executions_error(response)
        } else {
            crate::operation_deser::parse_count_open_workflow_executions_response(response)
        }
    }
}

/// Operation shape for `CountPendingActivityTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`count_pending_activity_tasks`](crate::client::Client::count_pending_activity_tasks).
///
/// See [`crate::client::fluent_builders::CountPendingActivityTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CountPendingActivityTasks {
    _private: (),
}
impl CountPendingActivityTasks {
    /// Creates a new builder-style object to manufacture [`CountPendingActivityTasksInput`](crate::input::CountPendingActivityTasksInput)
    pub fn builder() -> crate::input::count_pending_activity_tasks_input::Builder {
        crate::input::count_pending_activity_tasks_input::Builder::default()
    }
    /// Creates a new `CountPendingActivityTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CountPendingActivityTasks {
    type Output = std::result::Result<
        crate::output::CountPendingActivityTasksOutput,
        crate::error::CountPendingActivityTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_count_pending_activity_tasks_error(response)
        } else {
            crate::operation_deser::parse_count_pending_activity_tasks_response(response)
        }
    }
}

/// Operation shape for `CountPendingDecisionTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`count_pending_decision_tasks`](crate::client::Client::count_pending_decision_tasks).
///
/// See [`crate::client::fluent_builders::CountPendingDecisionTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CountPendingDecisionTasks {
    _private: (),
}
impl CountPendingDecisionTasks {
    /// Creates a new builder-style object to manufacture [`CountPendingDecisionTasksInput`](crate::input::CountPendingDecisionTasksInput)
    pub fn builder() -> crate::input::count_pending_decision_tasks_input::Builder {
        crate::input::count_pending_decision_tasks_input::Builder::default()
    }
    /// Creates a new `CountPendingDecisionTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CountPendingDecisionTasks {
    type Output = std::result::Result<
        crate::output::CountPendingDecisionTasksOutput,
        crate::error::CountPendingDecisionTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_count_pending_decision_tasks_error(response)
        } else {
            crate::operation_deser::parse_count_pending_decision_tasks_response(response)
        }
    }
}

/// Operation shape for `DeprecateActivityType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprecate_activity_type`](crate::client::Client::deprecate_activity_type).
///
/// See [`crate::client::fluent_builders::DeprecateActivityType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprecateActivityType {
    _private: (),
}
impl DeprecateActivityType {
    /// Creates a new builder-style object to manufacture [`DeprecateActivityTypeInput`](crate::input::DeprecateActivityTypeInput)
    pub fn builder() -> crate::input::deprecate_activity_type_input::Builder {
        crate::input::deprecate_activity_type_input::Builder::default()
    }
    /// Creates a new `DeprecateActivityType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprecateActivityType {
    type Output = std::result::Result<
        crate::output::DeprecateActivityTypeOutput,
        crate::error::DeprecateActivityTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprecate_activity_type_error(response)
        } else {
            crate::operation_deser::parse_deprecate_activity_type_response(response)
        }
    }
}

/// Operation shape for `DeprecateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprecate_domain`](crate::client::Client::deprecate_domain).
///
/// See [`crate::client::fluent_builders::DeprecateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprecateDomain {
    _private: (),
}
impl DeprecateDomain {
    /// Creates a new builder-style object to manufacture [`DeprecateDomainInput`](crate::input::DeprecateDomainInput)
    pub fn builder() -> crate::input::deprecate_domain_input::Builder {
        crate::input::deprecate_domain_input::Builder::default()
    }
    /// Creates a new `DeprecateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprecateDomain {
    type Output = std::result::Result<
        crate::output::DeprecateDomainOutput,
        crate::error::DeprecateDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprecate_domain_error(response)
        } else {
            crate::operation_deser::parse_deprecate_domain_response(response)
        }
    }
}

/// Operation shape for `DeprecateWorkflowType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprecate_workflow_type`](crate::client::Client::deprecate_workflow_type).
///
/// See [`crate::client::fluent_builders::DeprecateWorkflowType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprecateWorkflowType {
    _private: (),
}
impl DeprecateWorkflowType {
    /// Creates a new builder-style object to manufacture [`DeprecateWorkflowTypeInput`](crate::input::DeprecateWorkflowTypeInput)
    pub fn builder() -> crate::input::deprecate_workflow_type_input::Builder {
        crate::input::deprecate_workflow_type_input::Builder::default()
    }
    /// Creates a new `DeprecateWorkflowType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprecateWorkflowType {
    type Output = std::result::Result<
        crate::output::DeprecateWorkflowTypeOutput,
        crate::error::DeprecateWorkflowTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprecate_workflow_type_error(response)
        } else {
            crate::operation_deser::parse_deprecate_workflow_type_response(response)
        }
    }
}

/// Operation shape for `DescribeActivityType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_activity_type`](crate::client::Client::describe_activity_type).
///
/// See [`crate::client::fluent_builders::DescribeActivityType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeActivityType {
    _private: (),
}
impl DescribeActivityType {
    /// Creates a new builder-style object to manufacture [`DescribeActivityTypeInput`](crate::input::DescribeActivityTypeInput)
    pub fn builder() -> crate::input::describe_activity_type_input::Builder {
        crate::input::describe_activity_type_input::Builder::default()
    }
    /// Creates a new `DescribeActivityType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeActivityType {
    type Output = std::result::Result<
        crate::output::DescribeActivityTypeOutput,
        crate::error::DescribeActivityTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_activity_type_error(response)
        } else {
            crate::operation_deser::parse_describe_activity_type_response(response)
        }
    }
}

/// Operation shape for `DescribeDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain`](crate::client::Client::describe_domain).
///
/// See [`crate::client::fluent_builders::DescribeDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomain {
    _private: (),
}
impl DescribeDomain {
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
    /// Creates a new `DescribeDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomain {
    type Output =
        std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkflowExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workflow_execution`](crate::client::Client::describe_workflow_execution).
///
/// See [`crate::client::fluent_builders::DescribeWorkflowExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkflowExecution {
    _private: (),
}
impl DescribeWorkflowExecution {
    /// Creates a new builder-style object to manufacture [`DescribeWorkflowExecutionInput`](crate::input::DescribeWorkflowExecutionInput)
    pub fn builder() -> crate::input::describe_workflow_execution_input::Builder {
        crate::input::describe_workflow_execution_input::Builder::default()
    }
    /// Creates a new `DescribeWorkflowExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkflowExecution {
    type Output = std::result::Result<
        crate::output::DescribeWorkflowExecutionOutput,
        crate::error::DescribeWorkflowExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workflow_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_workflow_execution_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkflowType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workflow_type`](crate::client::Client::describe_workflow_type).
///
/// See [`crate::client::fluent_builders::DescribeWorkflowType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkflowType {
    _private: (),
}
impl DescribeWorkflowType {
    /// Creates a new builder-style object to manufacture [`DescribeWorkflowTypeInput`](crate::input::DescribeWorkflowTypeInput)
    pub fn builder() -> crate::input::describe_workflow_type_input::Builder {
        crate::input::describe_workflow_type_input::Builder::default()
    }
    /// Creates a new `DescribeWorkflowType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkflowType {
    type Output = std::result::Result<
        crate::output::DescribeWorkflowTypeOutput,
        crate::error::DescribeWorkflowTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workflow_type_error(response)
        } else {
            crate::operation_deser::parse_describe_workflow_type_response(response)
        }
    }
}

/// Operation shape for `GetWorkflowExecutionHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_workflow_execution_history`](crate::client::Client::get_workflow_execution_history).
///
/// See [`crate::client::fluent_builders::GetWorkflowExecutionHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkflowExecutionHistory {
    _private: (),
}
impl GetWorkflowExecutionHistory {
    /// Creates a new builder-style object to manufacture [`GetWorkflowExecutionHistoryInput`](crate::input::GetWorkflowExecutionHistoryInput)
    pub fn builder() -> crate::input::get_workflow_execution_history_input::Builder {
        crate::input::get_workflow_execution_history_input::Builder::default()
    }
    /// Creates a new `GetWorkflowExecutionHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkflowExecutionHistory {
    type Output = std::result::Result<
        crate::output::GetWorkflowExecutionHistoryOutput,
        crate::error::GetWorkflowExecutionHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_workflow_execution_history_error(response)
        } else {
            crate::operation_deser::parse_get_workflow_execution_history_response(response)
        }
    }
}

/// Operation shape for `ListActivityTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_activity_types`](crate::client::Client::list_activity_types).
///
/// See [`crate::client::fluent_builders::ListActivityTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListActivityTypes {
    _private: (),
}
impl ListActivityTypes {
    /// Creates a new builder-style object to manufacture [`ListActivityTypesInput`](crate::input::ListActivityTypesInput)
    pub fn builder() -> crate::input::list_activity_types_input::Builder {
        crate::input::list_activity_types_input::Builder::default()
    }
    /// Creates a new `ListActivityTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListActivityTypes {
    type Output = std::result::Result<
        crate::output::ListActivityTypesOutput,
        crate::error::ListActivityTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_activity_types_error(response)
        } else {
            crate::operation_deser::parse_list_activity_types_response(response)
        }
    }
}

/// Operation shape for `ListClosedWorkflowExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_closed_workflow_executions`](crate::client::Client::list_closed_workflow_executions).
///
/// See [`crate::client::fluent_builders::ListClosedWorkflowExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListClosedWorkflowExecutions {
    _private: (),
}
impl ListClosedWorkflowExecutions {
    /// Creates a new builder-style object to manufacture [`ListClosedWorkflowExecutionsInput`](crate::input::ListClosedWorkflowExecutionsInput)
    pub fn builder() -> crate::input::list_closed_workflow_executions_input::Builder {
        crate::input::list_closed_workflow_executions_input::Builder::default()
    }
    /// Creates a new `ListClosedWorkflowExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListClosedWorkflowExecutions {
    type Output = std::result::Result<
        crate::output::ListClosedWorkflowExecutionsOutput,
        crate::error::ListClosedWorkflowExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_closed_workflow_executions_error(response)
        } else {
            crate::operation_deser::parse_list_closed_workflow_executions_response(response)
        }
    }
}

/// Operation shape for `ListDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domains`](crate::client::Client::list_domains).
///
/// See [`crate::client::fluent_builders::ListDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomains {
    _private: (),
}
impl ListDomains {
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
    /// Creates a new `ListDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomains {
    type Output =
        std::result::Result<crate::output::ListDomainsOutput, crate::error::ListDomainsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domains_error(response)
        } else {
            crate::operation_deser::parse_list_domains_response(response)
        }
    }
}

/// Operation shape for `ListOpenWorkflowExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_open_workflow_executions`](crate::client::Client::list_open_workflow_executions).
///
/// See [`crate::client::fluent_builders::ListOpenWorkflowExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOpenWorkflowExecutions {
    _private: (),
}
impl ListOpenWorkflowExecutions {
    /// Creates a new builder-style object to manufacture [`ListOpenWorkflowExecutionsInput`](crate::input::ListOpenWorkflowExecutionsInput)
    pub fn builder() -> crate::input::list_open_workflow_executions_input::Builder {
        crate::input::list_open_workflow_executions_input::Builder::default()
    }
    /// Creates a new `ListOpenWorkflowExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOpenWorkflowExecutions {
    type Output = std::result::Result<
        crate::output::ListOpenWorkflowExecutionsOutput,
        crate::error::ListOpenWorkflowExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_open_workflow_executions_error(response)
        } else {
            crate::operation_deser::parse_list_open_workflow_executions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWorkflowTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workflow_types`](crate::client::Client::list_workflow_types).
///
/// See [`crate::client::fluent_builders::ListWorkflowTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkflowTypes {
    _private: (),
}
impl ListWorkflowTypes {
    /// Creates a new builder-style object to manufacture [`ListWorkflowTypesInput`](crate::input::ListWorkflowTypesInput)
    pub fn builder() -> crate::input::list_workflow_types_input::Builder {
        crate::input::list_workflow_types_input::Builder::default()
    }
    /// Creates a new `ListWorkflowTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkflowTypes {
    type Output = std::result::Result<
        crate::output::ListWorkflowTypesOutput,
        crate::error::ListWorkflowTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workflow_types_error(response)
        } else {
            crate::operation_deser::parse_list_workflow_types_response(response)
        }
    }
}

/// Operation shape for `PollForActivityTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`poll_for_activity_task`](crate::client::Client::poll_for_activity_task).
///
/// See [`crate::client::fluent_builders::PollForActivityTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PollForActivityTask {
    _private: (),
}
impl PollForActivityTask {
    /// Creates a new builder-style object to manufacture [`PollForActivityTaskInput`](crate::input::PollForActivityTaskInput)
    pub fn builder() -> crate::input::poll_for_activity_task_input::Builder {
        crate::input::poll_for_activity_task_input::Builder::default()
    }
    /// Creates a new `PollForActivityTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PollForActivityTask {
    type Output = std::result::Result<
        crate::output::PollForActivityTaskOutput,
        crate::error::PollForActivityTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_poll_for_activity_task_error(response)
        } else {
            crate::operation_deser::parse_poll_for_activity_task_response(response)
        }
    }
}

/// Operation shape for `PollForDecisionTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`poll_for_decision_task`](crate::client::Client::poll_for_decision_task).
///
/// See [`crate::client::fluent_builders::PollForDecisionTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PollForDecisionTask {
    _private: (),
}
impl PollForDecisionTask {
    /// Creates a new builder-style object to manufacture [`PollForDecisionTaskInput`](crate::input::PollForDecisionTaskInput)
    pub fn builder() -> crate::input::poll_for_decision_task_input::Builder {
        crate::input::poll_for_decision_task_input::Builder::default()
    }
    /// Creates a new `PollForDecisionTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PollForDecisionTask {
    type Output = std::result::Result<
        crate::output::PollForDecisionTaskOutput,
        crate::error::PollForDecisionTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_poll_for_decision_task_error(response)
        } else {
            crate::operation_deser::parse_poll_for_decision_task_response(response)
        }
    }
}

/// Operation shape for `RecordActivityTaskHeartbeat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`record_activity_task_heartbeat`](crate::client::Client::record_activity_task_heartbeat).
///
/// See [`crate::client::fluent_builders::RecordActivityTaskHeartbeat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RecordActivityTaskHeartbeat {
    _private: (),
}
impl RecordActivityTaskHeartbeat {
    /// Creates a new builder-style object to manufacture [`RecordActivityTaskHeartbeatInput`](crate::input::RecordActivityTaskHeartbeatInput)
    pub fn builder() -> crate::input::record_activity_task_heartbeat_input::Builder {
        crate::input::record_activity_task_heartbeat_input::Builder::default()
    }
    /// Creates a new `RecordActivityTaskHeartbeat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RecordActivityTaskHeartbeat {
    type Output = std::result::Result<
        crate::output::RecordActivityTaskHeartbeatOutput,
        crate::error::RecordActivityTaskHeartbeatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_record_activity_task_heartbeat_error(response)
        } else {
            crate::operation_deser::parse_record_activity_task_heartbeat_response(response)
        }
    }
}

/// Operation shape for `RegisterActivityType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_activity_type`](crate::client::Client::register_activity_type).
///
/// See [`crate::client::fluent_builders::RegisterActivityType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterActivityType {
    _private: (),
}
impl RegisterActivityType {
    /// Creates a new builder-style object to manufacture [`RegisterActivityTypeInput`](crate::input::RegisterActivityTypeInput)
    pub fn builder() -> crate::input::register_activity_type_input::Builder {
        crate::input::register_activity_type_input::Builder::default()
    }
    /// Creates a new `RegisterActivityType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterActivityType {
    type Output = std::result::Result<
        crate::output::RegisterActivityTypeOutput,
        crate::error::RegisterActivityTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_activity_type_error(response)
        } else {
            crate::operation_deser::parse_register_activity_type_response(response)
        }
    }
}

/// Operation shape for `RegisterDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_domain`](crate::client::Client::register_domain).
///
/// See [`crate::client::fluent_builders::RegisterDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterDomain {
    _private: (),
}
impl RegisterDomain {
    /// Creates a new builder-style object to manufacture [`RegisterDomainInput`](crate::input::RegisterDomainInput)
    pub fn builder() -> crate::input::register_domain_input::Builder {
        crate::input::register_domain_input::Builder::default()
    }
    /// Creates a new `RegisterDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterDomain {
    type Output =
        std::result::Result<crate::output::RegisterDomainOutput, crate::error::RegisterDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_domain_error(response)
        } else {
            crate::operation_deser::parse_register_domain_response(response)
        }
    }
}

/// Operation shape for `RegisterWorkflowType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_workflow_type`](crate::client::Client::register_workflow_type).
///
/// See [`crate::client::fluent_builders::RegisterWorkflowType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterWorkflowType {
    _private: (),
}
impl RegisterWorkflowType {
    /// Creates a new builder-style object to manufacture [`RegisterWorkflowTypeInput`](crate::input::RegisterWorkflowTypeInput)
    pub fn builder() -> crate::input::register_workflow_type_input::Builder {
        crate::input::register_workflow_type_input::Builder::default()
    }
    /// Creates a new `RegisterWorkflowType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterWorkflowType {
    type Output = std::result::Result<
        crate::output::RegisterWorkflowTypeOutput,
        crate::error::RegisterWorkflowTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_workflow_type_error(response)
        } else {
            crate::operation_deser::parse_register_workflow_type_response(response)
        }
    }
}

/// Operation shape for `RequestCancelWorkflowExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`request_cancel_workflow_execution`](crate::client::Client::request_cancel_workflow_execution).
///
/// See [`crate::client::fluent_builders::RequestCancelWorkflowExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RequestCancelWorkflowExecution {
    _private: (),
}
impl RequestCancelWorkflowExecution {
    /// Creates a new builder-style object to manufacture [`RequestCancelWorkflowExecutionInput`](crate::input::RequestCancelWorkflowExecutionInput)
    pub fn builder() -> crate::input::request_cancel_workflow_execution_input::Builder {
        crate::input::request_cancel_workflow_execution_input::Builder::default()
    }
    /// Creates a new `RequestCancelWorkflowExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RequestCancelWorkflowExecution {
    type Output = std::result::Result<
        crate::output::RequestCancelWorkflowExecutionOutput,
        crate::error::RequestCancelWorkflowExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_request_cancel_workflow_execution_error(response)
        } else {
            crate::operation_deser::parse_request_cancel_workflow_execution_response(response)
        }
    }
}

/// Operation shape for `RespondActivityTaskCanceled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`respond_activity_task_canceled`](crate::client::Client::respond_activity_task_canceled).
///
/// See [`crate::client::fluent_builders::RespondActivityTaskCanceled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RespondActivityTaskCanceled {
    _private: (),
}
impl RespondActivityTaskCanceled {
    /// Creates a new builder-style object to manufacture [`RespondActivityTaskCanceledInput`](crate::input::RespondActivityTaskCanceledInput)
    pub fn builder() -> crate::input::respond_activity_task_canceled_input::Builder {
        crate::input::respond_activity_task_canceled_input::Builder::default()
    }
    /// Creates a new `RespondActivityTaskCanceled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RespondActivityTaskCanceled {
    type Output = std::result::Result<
        crate::output::RespondActivityTaskCanceledOutput,
        crate::error::RespondActivityTaskCanceledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_respond_activity_task_canceled_error(response)
        } else {
            crate::operation_deser::parse_respond_activity_task_canceled_response(response)
        }
    }
}

/// Operation shape for `RespondActivityTaskCompleted`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`respond_activity_task_completed`](crate::client::Client::respond_activity_task_completed).
///
/// See [`crate::client::fluent_builders::RespondActivityTaskCompleted`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RespondActivityTaskCompleted {
    _private: (),
}
impl RespondActivityTaskCompleted {
    /// Creates a new builder-style object to manufacture [`RespondActivityTaskCompletedInput`](crate::input::RespondActivityTaskCompletedInput)
    pub fn builder() -> crate::input::respond_activity_task_completed_input::Builder {
        crate::input::respond_activity_task_completed_input::Builder::default()
    }
    /// Creates a new `RespondActivityTaskCompleted` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RespondActivityTaskCompleted {
    type Output = std::result::Result<
        crate::output::RespondActivityTaskCompletedOutput,
        crate::error::RespondActivityTaskCompletedError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_respond_activity_task_completed_error(response)
        } else {
            crate::operation_deser::parse_respond_activity_task_completed_response(response)
        }
    }
}

/// Operation shape for `RespondActivityTaskFailed`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`respond_activity_task_failed`](crate::client::Client::respond_activity_task_failed).
///
/// See [`crate::client::fluent_builders::RespondActivityTaskFailed`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RespondActivityTaskFailed {
    _private: (),
}
impl RespondActivityTaskFailed {
    /// Creates a new builder-style object to manufacture [`RespondActivityTaskFailedInput`](crate::input::RespondActivityTaskFailedInput)
    pub fn builder() -> crate::input::respond_activity_task_failed_input::Builder {
        crate::input::respond_activity_task_failed_input::Builder::default()
    }
    /// Creates a new `RespondActivityTaskFailed` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RespondActivityTaskFailed {
    type Output = std::result::Result<
        crate::output::RespondActivityTaskFailedOutput,
        crate::error::RespondActivityTaskFailedError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_respond_activity_task_failed_error(response)
        } else {
            crate::operation_deser::parse_respond_activity_task_failed_response(response)
        }
    }
}

/// Operation shape for `RespondDecisionTaskCompleted`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`respond_decision_task_completed`](crate::client::Client::respond_decision_task_completed).
///
/// See [`crate::client::fluent_builders::RespondDecisionTaskCompleted`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RespondDecisionTaskCompleted {
    _private: (),
}
impl RespondDecisionTaskCompleted {
    /// Creates a new builder-style object to manufacture [`RespondDecisionTaskCompletedInput`](crate::input::RespondDecisionTaskCompletedInput)
    pub fn builder() -> crate::input::respond_decision_task_completed_input::Builder {
        crate::input::respond_decision_task_completed_input::Builder::default()
    }
    /// Creates a new `RespondDecisionTaskCompleted` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RespondDecisionTaskCompleted {
    type Output = std::result::Result<
        crate::output::RespondDecisionTaskCompletedOutput,
        crate::error::RespondDecisionTaskCompletedError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_respond_decision_task_completed_error(response)
        } else {
            crate::operation_deser::parse_respond_decision_task_completed_response(response)
        }
    }
}

/// Operation shape for `SignalWorkflowExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`signal_workflow_execution`](crate::client::Client::signal_workflow_execution).
///
/// See [`crate::client::fluent_builders::SignalWorkflowExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SignalWorkflowExecution {
    _private: (),
}
impl SignalWorkflowExecution {
    /// Creates a new builder-style object to manufacture [`SignalWorkflowExecutionInput`](crate::input::SignalWorkflowExecutionInput)
    pub fn builder() -> crate::input::signal_workflow_execution_input::Builder {
        crate::input::signal_workflow_execution_input::Builder::default()
    }
    /// Creates a new `SignalWorkflowExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SignalWorkflowExecution {
    type Output = std::result::Result<
        crate::output::SignalWorkflowExecutionOutput,
        crate::error::SignalWorkflowExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_signal_workflow_execution_error(response)
        } else {
            crate::operation_deser::parse_signal_workflow_execution_response(response)
        }
    }
}

/// Operation shape for `StartWorkflowExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_workflow_execution`](crate::client::Client::start_workflow_execution).
///
/// See [`crate::client::fluent_builders::StartWorkflowExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartWorkflowExecution {
    _private: (),
}
impl StartWorkflowExecution {
    /// Creates a new builder-style object to manufacture [`StartWorkflowExecutionInput`](crate::input::StartWorkflowExecutionInput)
    pub fn builder() -> crate::input::start_workflow_execution_input::Builder {
        crate::input::start_workflow_execution_input::Builder::default()
    }
    /// Creates a new `StartWorkflowExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartWorkflowExecution {
    type Output = std::result::Result<
        crate::output::StartWorkflowExecutionOutput,
        crate::error::StartWorkflowExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_workflow_execution_error(response)
        } else {
            crate::operation_deser::parse_start_workflow_execution_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TerminateWorkflowExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_workflow_execution`](crate::client::Client::terminate_workflow_execution).
///
/// See [`crate::client::fluent_builders::TerminateWorkflowExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateWorkflowExecution {
    _private: (),
}
impl TerminateWorkflowExecution {
    /// Creates a new builder-style object to manufacture [`TerminateWorkflowExecutionInput`](crate::input::TerminateWorkflowExecutionInput)
    pub fn builder() -> crate::input::terminate_workflow_execution_input::Builder {
        crate::input::terminate_workflow_execution_input::Builder::default()
    }
    /// Creates a new `TerminateWorkflowExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateWorkflowExecution {
    type Output = std::result::Result<
        crate::output::TerminateWorkflowExecutionOutput,
        crate::error::TerminateWorkflowExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_workflow_execution_error(response)
        } else {
            crate::operation_deser::parse_terminate_workflow_execution_response(response)
        }
    }
}

/// Operation shape for `UndeprecateActivityType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`undeprecate_activity_type`](crate::client::Client::undeprecate_activity_type).
///
/// See [`crate::client::fluent_builders::UndeprecateActivityType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UndeprecateActivityType {
    _private: (),
}
impl UndeprecateActivityType {
    /// Creates a new builder-style object to manufacture [`UndeprecateActivityTypeInput`](crate::input::UndeprecateActivityTypeInput)
    pub fn builder() -> crate::input::undeprecate_activity_type_input::Builder {
        crate::input::undeprecate_activity_type_input::Builder::default()
    }
    /// Creates a new `UndeprecateActivityType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UndeprecateActivityType {
    type Output = std::result::Result<
        crate::output::UndeprecateActivityTypeOutput,
        crate::error::UndeprecateActivityTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_undeprecate_activity_type_error(response)
        } else {
            crate::operation_deser::parse_undeprecate_activity_type_response(response)
        }
    }
}

/// Operation shape for `UndeprecateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`undeprecate_domain`](crate::client::Client::undeprecate_domain).
///
/// See [`crate::client::fluent_builders::UndeprecateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UndeprecateDomain {
    _private: (),
}
impl UndeprecateDomain {
    /// Creates a new builder-style object to manufacture [`UndeprecateDomainInput`](crate::input::UndeprecateDomainInput)
    pub fn builder() -> crate::input::undeprecate_domain_input::Builder {
        crate::input::undeprecate_domain_input::Builder::default()
    }
    /// Creates a new `UndeprecateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UndeprecateDomain {
    type Output = std::result::Result<
        crate::output::UndeprecateDomainOutput,
        crate::error::UndeprecateDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_undeprecate_domain_error(response)
        } else {
            crate::operation_deser::parse_undeprecate_domain_response(response)
        }
    }
}

/// Operation shape for `UndeprecateWorkflowType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`undeprecate_workflow_type`](crate::client::Client::undeprecate_workflow_type).
///
/// See [`crate::client::fluent_builders::UndeprecateWorkflowType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UndeprecateWorkflowType {
    _private: (),
}
impl UndeprecateWorkflowType {
    /// Creates a new builder-style object to manufacture [`UndeprecateWorkflowTypeInput`](crate::input::UndeprecateWorkflowTypeInput)
    pub fn builder() -> crate::input::undeprecate_workflow_type_input::Builder {
        crate::input::undeprecate_workflow_type_input::Builder::default()
    }
    /// Creates a new `UndeprecateWorkflowType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UndeprecateWorkflowType {
    type Output = std::result::Result<
        crate::output::UndeprecateWorkflowTypeOutput,
        crate::error::UndeprecateWorkflowTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_undeprecate_workflow_type_error(response)
        } else {
            crate::operation_deser::parse_undeprecate_workflow_type_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
