// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The <code>StartWorkflowExecution</code> API action was called without the required
    /// parameters set.</p>
    /// <p>Some workflow execution parameters, such as the decision <code>taskList</code>, must be
    /// set to start the execution. However, these parameters might have been set as defaults when the
    /// workflow type was registered. In this case, you can omit these parameters from the
    /// <code>StartWorkflowExecution</code> call and Amazon SWF uses the values defined in the workflow
    /// type.</p>
    /// <note>
    /// <p>If these parameters aren't set and no default parameters were defined in the workflow
    /// type, this error is displayed.</p>
    /// </note>
    DefaultUndefinedFault(crate::error::DefaultUndefinedFault),
    /// <p>Returned if the domain already exists. You may get this fault if you are registering a domain that is either already registered or deprecated, or if you undeprecate a domain that is currently registered.</p>
    DomainAlreadyExistsFault(crate::error::DomainAlreadyExistsFault),
    /// <p>Returned when the specified domain has been deprecated.</p>
    DomainDeprecatedFault(crate::error::DomainDeprecatedFault),
    /// <p>Returned by any operation if a system imposed limitation has been reached. To address this fault you should either clean up unused resources or increase the limit by contacting AWS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>Returned when the caller doesn't have sufficient permissions to invoke the action.</p>
    OperationNotPermittedFault(crate::error::OperationNotPermittedFault),
    /// <p>You've exceeded the number of tags allowed for a domain.</p>
    TooManyTagsFault(crate::error::TooManyTagsFault),
    /// <p>Returned if the type already exists in the specified domain. You may get this fault if you are registering a type that is either already registered or deprecated, or if you undeprecate a type that is currently registered.</p>
    TypeAlreadyExistsFault(crate::error::TypeAlreadyExistsFault),
    /// <p>Returned when the specified activity or workflow type was already deprecated.</p>
    TypeDeprecatedFault(crate::error::TypeDeprecatedFault),
    /// <p>Returned when the named resource cannot be found with in the scope of this operation (region or domain). This could happen if the named resource was never created or is no longer available for this operation.</p>
    UnknownResourceFault(crate::error::UnknownResourceFault),
    /// <p>Returned by <a>StartWorkflowExecution</a> when an open execution with the same workflowId is already running in
    /// the specified domain.</p>
    WorkflowExecutionAlreadyStartedFault(crate::error::WorkflowExecutionAlreadyStartedFault),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::DefaultUndefinedFault(inner) => inner.fmt(f),
            Error::DomainAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DomainDeprecatedFault(inner) => inner.fmt(f),
            Error::LimitExceededFault(inner) => inner.fmt(f),
            Error::OperationNotPermittedFault(inner) => inner.fmt(f),
            Error::TooManyTagsFault(inner) => inner.fmt(f),
            Error::TypeAlreadyExistsFault(inner) => inner.fmt(f),
            Error::TypeDeprecatedFault(inner) => inner.fmt(f),
            Error::UnknownResourceFault(inner) => inner.fmt(f),
            Error::WorkflowExecutionAlreadyStartedFault(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CountClosedWorkflowExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CountClosedWorkflowExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CountClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(inner) => Error::OperationNotPermittedFault(inner),
                crate::error::CountClosedWorkflowExecutionsErrorKind::UnknownResourceFault(inner) => Error::UnknownResourceFault(inner),
                crate::error::CountClosedWorkflowExecutionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CountOpenWorkflowExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CountOpenWorkflowExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CountOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::CountOpenWorkflowExecutionsErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::CountOpenWorkflowExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CountPendingActivityTasksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CountPendingActivityTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CountPendingActivityTasksErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::CountPendingActivityTasksErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::CountPendingActivityTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CountPendingDecisionTasksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CountPendingDecisionTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CountPendingDecisionTasksErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::CountPendingDecisionTasksErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::CountPendingDecisionTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeprecateActivityTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeprecateActivityTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeprecateActivityTypeErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::DeprecateActivityTypeErrorKind::TypeDeprecatedFault(inner) => {
                    Error::TypeDeprecatedFault(inner)
                }
                crate::error::DeprecateActivityTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::DeprecateActivityTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeprecateDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeprecateDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeprecateDomainErrorKind::DomainDeprecatedFault(inner) => {
                    Error::DomainDeprecatedFault(inner)
                }
                crate::error::DeprecateDomainErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::DeprecateDomainErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::DeprecateDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeprecateWorkflowTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeprecateWorkflowTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::DeprecateWorkflowTypeErrorKind::TypeDeprecatedFault(inner) => {
                    Error::TypeDeprecatedFault(inner)
                }
                crate::error::DeprecateWorkflowTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::DeprecateWorkflowTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeActivityTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeActivityTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeActivityTypeErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::DescribeActivityTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::DescribeActivityTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDomainErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::DescribeDomainErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::DescribeDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeWorkflowExecutionErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::DescribeWorkflowExecutionErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::DescribeWorkflowExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeWorkflowTypeErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::DescribeWorkflowTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::DescribeWorkflowTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetWorkflowExecutionHistoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetWorkflowExecutionHistoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetWorkflowExecutionHistoryErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::GetWorkflowExecutionHistoryErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::GetWorkflowExecutionHistoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListActivityTypesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListActivityTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListActivityTypesErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::ListActivityTypesErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::ListActivityTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListClosedWorkflowExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListClosedWorkflowExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListClosedWorkflowExecutionsErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::ListClosedWorkflowExecutionsErrorKind::UnknownResourceFault(
                    inner,
                ) => Error::UnknownResourceFault(inner),
                crate::error::ListClosedWorkflowExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDomainsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListDomainsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDomainsErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::ListDomainsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOpenWorkflowExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListOpenWorkflowExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListOpenWorkflowExecutionsErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::ListOpenWorkflowExecutionsErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::ListOpenWorkflowExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListWorkflowTypesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListWorkflowTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListWorkflowTypesErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::ListWorkflowTypesErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::ListWorkflowTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PollForActivityTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PollForActivityTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PollForActivityTaskErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::PollForActivityTaskErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::PollForActivityTaskErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::PollForActivityTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PollForDecisionTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PollForDecisionTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PollForDecisionTaskErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::PollForDecisionTaskErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::PollForDecisionTaskErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::PollForDecisionTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RecordActivityTaskHeartbeatError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RecordActivityTaskHeartbeatError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RecordActivityTaskHeartbeatErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::RecordActivityTaskHeartbeatErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::RecordActivityTaskHeartbeatErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterActivityTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterActivityTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterActivityTypeErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::RegisterActivityTypeErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::RegisterActivityTypeErrorKind::TypeAlreadyExistsFault(inner) => {
                    Error::TypeAlreadyExistsFault(inner)
                }
                crate::error::RegisterActivityTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::RegisterActivityTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RegisterDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterDomainErrorKind::DomainAlreadyExistsFault(inner) => {
                    Error::DomainAlreadyExistsFault(inner)
                }
                crate::error::RegisterDomainErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::RegisterDomainErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::RegisterDomainErrorKind::TooManyTagsFault(inner) => {
                    Error::TooManyTagsFault(inner)
                }
                crate::error::RegisterDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterWorkflowTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterWorkflowTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterWorkflowTypeErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::RegisterWorkflowTypeErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::RegisterWorkflowTypeErrorKind::TypeAlreadyExistsFault(inner) => {
                    Error::TypeAlreadyExistsFault(inner)
                }
                crate::error::RegisterWorkflowTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::RegisterWorkflowTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RequestCancelWorkflowExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RequestCancelWorkflowExecutionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RequestCancelWorkflowExecutionErrorKind::OperationNotPermittedFault(inner) => Error::OperationNotPermittedFault(inner),
                crate::error::RequestCancelWorkflowExecutionErrorKind::UnknownResourceFault(inner) => Error::UnknownResourceFault(inner),
                crate::error::RequestCancelWorkflowExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCanceledError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCanceledError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RespondActivityTaskCanceledErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::RespondActivityTaskCanceledErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::RespondActivityTaskCanceledErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCompletedError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskCompletedError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RespondActivityTaskCompletedErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::RespondActivityTaskCompletedErrorKind::UnknownResourceFault(
                    inner,
                ) => Error::UnknownResourceFault(inner),
                crate::error::RespondActivityTaskCompletedErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskFailedError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RespondActivityTaskFailedError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RespondActivityTaskFailedErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::RespondActivityTaskFailedErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::RespondActivityTaskFailedErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RespondDecisionTaskCompletedError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RespondDecisionTaskCompletedError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RespondDecisionTaskCompletedErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::RespondDecisionTaskCompletedErrorKind::UnknownResourceFault(
                    inner,
                ) => Error::UnknownResourceFault(inner),
                crate::error::RespondDecisionTaskCompletedErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SignalWorkflowExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SignalWorkflowExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SignalWorkflowExecutionErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::SignalWorkflowExecutionErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::SignalWorkflowExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartWorkflowExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartWorkflowExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartWorkflowExecutionErrorKind::DefaultUndefinedFault(inner) => Error::DefaultUndefinedFault(inner),
                crate::error::StartWorkflowExecutionErrorKind::LimitExceededFault(inner) => Error::LimitExceededFault(inner),
                crate::error::StartWorkflowExecutionErrorKind::OperationNotPermittedFault(inner) => Error::OperationNotPermittedFault(inner),
                crate::error::StartWorkflowExecutionErrorKind::TypeDeprecatedFault(inner) => Error::TypeDeprecatedFault(inner),
                crate::error::StartWorkflowExecutionErrorKind::UnknownResourceFault(inner) => Error::UnknownResourceFault(inner),
                crate::error::StartWorkflowExecutionErrorKind::WorkflowExecutionAlreadyStartedFault(inner) => Error::WorkflowExecutionAlreadyStartedFault(inner),
                crate::error::StartWorkflowExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::TagResourceErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::TagResourceErrorKind::TooManyTagsFault(inner) => {
                    Error::TooManyTagsFault(inner)
                }
                crate::error::TagResourceErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TerminateWorkflowExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::TerminateWorkflowExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TerminateWorkflowExecutionErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::TerminateWorkflowExecutionErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::TerminateWorkflowExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UndeprecateActivityTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UndeprecateActivityTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UndeprecateActivityTypeErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::UndeprecateActivityTypeErrorKind::TypeAlreadyExistsFault(inner) => {
                    Error::TypeAlreadyExistsFault(inner)
                }
                crate::error::UndeprecateActivityTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::UndeprecateActivityTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UndeprecateDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UndeprecateDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UndeprecateDomainErrorKind::DomainAlreadyExistsFault(inner) => {
                    Error::DomainAlreadyExistsFault(inner)
                }
                crate::error::UndeprecateDomainErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::UndeprecateDomainErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::UndeprecateDomainErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UndeprecateWorkflowTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UndeprecateWorkflowTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UndeprecateWorkflowTypeErrorKind::OperationNotPermittedFault(
                    inner,
                ) => Error::OperationNotPermittedFault(inner),
                crate::error::UndeprecateWorkflowTypeErrorKind::TypeAlreadyExistsFault(inner) => {
                    Error::TypeAlreadyExistsFault(inner)
                }
                crate::error::UndeprecateWorkflowTypeErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::UndeprecateWorkflowTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::UntagResourceErrorKind::OperationNotPermittedFault(inner) => {
                    Error::OperationNotPermittedFault(inner)
                }
                crate::error::UntagResourceErrorKind::UnknownResourceFault(inner) => {
                    Error::UnknownResourceFault(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
