// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddAttachmentsToSetInput`](crate::input::AddAttachmentsToSetInput)
pub mod add_attachments_to_set_input {
    /// A builder for [`AddAttachmentsToSetInput`](crate::input::AddAttachmentsToSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment_set_id: std::option::Option<std::string::String>,
        pub(crate) attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
    }
    impl Builder {
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>
        pub fn attachment_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_set_id = input;
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p>
        /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn attachments(mut self, input: crate::model::Attachment) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input);
            self.attachments = Some(v);
            self
        }
        /// <p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p>
        /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// Consumes the builder and constructs a [`AddAttachmentsToSetInput`](crate::input::AddAttachmentsToSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddAttachmentsToSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddAttachmentsToSetInput {
                attachment_set_id: self.attachment_set_id,
                attachments: self.attachments,
            })
        }
    }
}
#[doc(hidden)]
pub type AddAttachmentsToSetInputOperationOutputAlias = crate::operation::AddAttachmentsToSet;
#[doc(hidden)]
pub type AddAttachmentsToSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddAttachmentsToSetInput {
    /// Consumes the builder and constructs an Operation<[`AddAttachmentsToSet`](crate::operation::AddAttachmentsToSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddAttachmentsToSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddAttachmentsToSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddAttachmentsToSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddAttachmentsToSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.AddAttachmentsToSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_attachments_to_set(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddAttachmentsToSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddAttachmentsToSet",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddAttachmentsToSetInput`](crate::input::AddAttachmentsToSetInput)
    pub fn builder() -> crate::input::add_attachments_to_set_input::Builder {
        crate::input::add_attachments_to_set_input::Builder::default()
    }
}

/// See [`AddCommunicationToCaseInput`](crate::input::AddCommunicationToCaseInput)
pub mod add_communication_to_case_input {
    /// A builder for [`AddCommunicationToCaseInput`](crate::input::AddCommunicationToCaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_id: std::option::Option<std::string::String>,
        pub(crate) communication_body: std::option::Option<std::string::String>,
        pub(crate) cc_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attachment_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// <p>The body of an email communication to add to the support case.</p>
        pub fn communication_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.communication_body = Some(input.into());
            self
        }
        /// <p>The body of an email communication to add to the support case.</p>
        pub fn set_communication_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.communication_body = input;
            self
        }
        /// Appends an item to `cc_email_addresses`.
        ///
        /// To override the contents of this collection use [`set_cc_email_addresses`](Self::set_cc_email_addresses).
        ///
        /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
        pub fn cc_email_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cc_email_addresses.unwrap_or_default();
            v.push(input.into());
            self.cc_email_addresses = Some(v);
            self
        }
        /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
        pub fn set_cc_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cc_email_addresses = input;
            self
        }
        /// <p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <code>AddAttachmentsToSet</code> </p>
        pub fn attachment_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_set_id = Some(input.into());
            self
        }
        /// <p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <code>AddAttachmentsToSet</code> </p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddCommunicationToCaseInput`](crate::input::AddCommunicationToCaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddCommunicationToCaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddCommunicationToCaseInput {
                case_id: self.case_id,
                communication_body: self.communication_body,
                cc_email_addresses: self.cc_email_addresses,
                attachment_set_id: self.attachment_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AddCommunicationToCaseInputOperationOutputAlias = crate::operation::AddCommunicationToCase;
#[doc(hidden)]
pub type AddCommunicationToCaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddCommunicationToCaseInput {
    /// Consumes the builder and constructs an Operation<[`AddCommunicationToCase`](crate::operation::AddCommunicationToCase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddCommunicationToCase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddCommunicationToCaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddCommunicationToCaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddCommunicationToCaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.AddCommunicationToCase",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_communication_to_case(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddCommunicationToCase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddCommunicationToCase",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddCommunicationToCaseInput`](crate::input::AddCommunicationToCaseInput)
    pub fn builder() -> crate::input::add_communication_to_case_input::Builder {
        crate::input::add_communication_to_case_input::Builder::default()
    }
}

/// See [`CreateCaseInput`](crate::input::CreateCaseInput)
pub mod create_case_input {
    /// A builder for [`CreateCaseInput`](crate::input::CreateCaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) severity_code: std::option::Option<std::string::String>,
        pub(crate) category_code: std::option::Option<std::string::String>,
        pub(crate) communication_body: std::option::Option<std::string::String>,
        pub(crate) cc_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) language: std::option::Option<std::string::String>,
        pub(crate) issue_type: std::option::Option<std::string::String>,
        pub(crate) attachment_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The code for the Amazon Web Services service. You can use the <code>DescribeServices</code> operation to get the possible <code>serviceCode</code> values.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The code for the Amazon Web Services service. You can use the <code>DescribeServices</code> operation to get the possible <code>serviceCode</code> values.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <code>DescribeSeverityLevels</code> operation to get the possible values for <code>severityCode</code>. </p>
        /// <p>For more information, see <code>SeverityLevel</code> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note>
        /// <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p>
        /// </note>
        pub fn severity_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity_code = Some(input.into());
            self
        }
        /// <p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <code>DescribeSeverityLevels</code> operation to get the possible values for <code>severityCode</code>. </p>
        /// <p>For more information, see <code>SeverityLevel</code> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note>
        /// <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p>
        /// </note>
        pub fn set_severity_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.severity_code = input;
            self
        }
        /// <p>The category of problem for the support case. You also use the <code>DescribeServices</code> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>
        pub fn category_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.category_code = Some(input.into());
            self
        }
        /// <p>The category of problem for the support case. You also use the <code>DescribeServices</code> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>
        pub fn set_category_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.category_code = input;
            self
        }
        /// <p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn communication_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.communication_body = Some(input.into());
            self
        }
        /// <p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn set_communication_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.communication_body = input;
            self
        }
        /// Appends an item to `cc_email_addresses`.
        ///
        /// To override the contents of this collection use [`set_cc_email_addresses`](Self::set_cc_email_addresses).
        ///
        /// <p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>
        pub fn cc_email_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cc_email_addresses.unwrap_or_default();
            v.push(input.into());
            self.cc_email_addresses = Some(v);
            self
        }
        /// <p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>
        pub fn set_cc_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cc_email_addresses = input;
            self
        }
        /// <p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// <p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.</p>
        pub fn issue_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.issue_type = Some(input.into());
            self
        }
        /// <p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.</p>
        pub fn set_issue_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issue_type = input;
            self
        }
        /// <p>The ID of a set of one or more attachments for the case. Create the set by using the <code>AddAttachmentsToSet</code> operation.</p>
        pub fn attachment_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_set_id = Some(input.into());
            self
        }
        /// <p>The ID of a set of one or more attachments for the case. Create the set by using the <code>AddAttachmentsToSet</code> operation.</p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCaseInput`](crate::input::CreateCaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCaseInput {
                subject: self.subject,
                service_code: self.service_code,
                severity_code: self.severity_code,
                category_code: self.category_code,
                communication_body: self.communication_body,
                cc_email_addresses: self.cc_email_addresses,
                language: self.language,
                issue_type: self.issue_type,
                attachment_set_id: self.attachment_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCaseInputOperationOutputAlias = crate::operation::CreateCase;
#[doc(hidden)]
pub type CreateCaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCaseInput {
    /// Consumes the builder and constructs an Operation<[`CreateCase`](crate::operation::CreateCase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.CreateCase",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_case(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCase",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCaseInput`](crate::input::CreateCaseInput)
    pub fn builder() -> crate::input::create_case_input::Builder {
        crate::input::create_case_input::Builder::default()
    }
}

/// See [`DescribeAttachmentInput`](crate::input::DescribeAttachmentInput)
pub mod describe_attachment_input {
    /// A builder for [`DescribeAttachmentInput`](crate::input::DescribeAttachmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the attachment to return. Attachment IDs are returned by the <code>DescribeCommunications</code> operation.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment to return. Attachment IDs are returned by the <code>DescribeCommunications</code> operation.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAttachmentInput`](crate::input::DescribeAttachmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAttachmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAttachmentInput {
                attachment_id: self.attachment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAttachmentInputOperationOutputAlias = crate::operation::DescribeAttachment;
#[doc(hidden)]
pub type DescribeAttachmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAttachmentInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAttachment`](crate::operation::DescribeAttachment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAttachment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAttachmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAttachmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAttachmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeAttachment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_attachment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAttachment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAttachment",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAttachmentInput`](crate::input::DescribeAttachmentInput)
    pub fn builder() -> crate::input::describe_attachment_input::Builder {
        crate::input::describe_attachment_input::Builder::default()
    }
}

/// See [`DescribeCasesInput`](crate::input::DescribeCasesInput)
pub mod describe_cases_input {
    /// A builder for [`DescribeCasesInput`](crate::input::DescribeCasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) display_id: std::option::Option<std::string::String>,
        pub(crate) after_time: std::option::Option<std::string::String>,
        pub(crate) before_time: std::option::Option<std::string::String>,
        pub(crate) include_resolved_cases: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) language: std::option::Option<std::string::String>,
        pub(crate) include_communications: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `case_id_list`.
        ///
        /// To override the contents of this collection use [`set_case_id_list`](Self::set_case_id_list).
        ///
        /// <p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>
        pub fn case_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.case_id_list.unwrap_or_default();
            v.push(input.into());
            self.case_id_list = Some(v);
            self
        }
        /// <p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>
        pub fn set_case_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.case_id_list = input;
            self
        }
        /// <p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>
        pub fn display_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_id = Some(input.into());
            self
        }
        /// <p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>
        pub fn set_display_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_id = input;
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn after_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_time = Some(input.into());
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_after_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.after_time = input;
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn before_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_time = Some(input.into());
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_before_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.before_time = input;
            self
        }
        /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren't included.</p>
        pub fn include_resolved_cases(mut self, input: bool) -> Self {
            self.include_resolved_cases = Some(input);
            self
        }
        /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren't included.</p>
        pub fn set_include_resolved_cases(mut self, input: std::option::Option<bool>) -> Self {
            self.include_resolved_cases = input;
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// <p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>
        pub fn include_communications(mut self, input: bool) -> Self {
            self.include_communications = Some(input);
            self
        }
        /// <p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>
        pub fn set_include_communications(mut self, input: std::option::Option<bool>) -> Self {
            self.include_communications = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCasesInput`](crate::input::DescribeCasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCasesInput {
                case_id_list: self.case_id_list,
                display_id: self.display_id,
                after_time: self.after_time,
                before_time: self.before_time,
                include_resolved_cases: self.include_resolved_cases.unwrap_or_default(),
                next_token: self.next_token,
                max_results: self.max_results,
                language: self.language,
                include_communications: self.include_communications,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCasesInputOperationOutputAlias = crate::operation::DescribeCases;
#[doc(hidden)]
pub type DescribeCasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCasesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCases`](crate::operation::DescribeCases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeCases",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cases(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCases",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCasesInput`](crate::input::DescribeCasesInput)
    pub fn builder() -> crate::input::describe_cases_input::Builder {
        crate::input::describe_cases_input::Builder::default()
    }
}

/// See [`DescribeCommunicationsInput`](crate::input::DescribeCommunicationsInput)
pub mod describe_communications_input {
    /// A builder for [`DescribeCommunicationsInput`](crate::input::DescribeCommunicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_id: std::option::Option<std::string::String>,
        pub(crate) before_time: std::option::Option<std::string::String>,
        pub(crate) after_time: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn before_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_time = Some(input.into());
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_before_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.before_time = input;
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn after_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_time = Some(input.into());
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_after_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.after_time = input;
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCommunicationsInput`](crate::input::DescribeCommunicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCommunicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCommunicationsInput {
                case_id: self.case_id,
                before_time: self.before_time,
                after_time: self.after_time,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCommunicationsInputOperationOutputAlias = crate::operation::DescribeCommunications;
#[doc(hidden)]
pub type DescribeCommunicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCommunicationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCommunications`](crate::operation::DescribeCommunications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCommunications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCommunicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCommunicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCommunicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeCommunications",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_communications(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCommunications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCommunications",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCommunicationsInput`](crate::input::DescribeCommunicationsInput)
    pub fn builder() -> crate::input::describe_communications_input::Builder {
        crate::input::describe_communications_input::Builder::default()
    }
}

/// See [`DescribeServicesInput`](crate::input::DescribeServicesInput)
pub mod describe_services_input {
    /// A builder for [`DescribeServicesInput`](crate::input::DescribeServicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_code_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_code_list`.
        ///
        /// To override the contents of this collection use [`set_service_code_list`](Self::set_service_code_list).
        ///
        /// <p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>
        pub fn service_code_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.service_code_list.unwrap_or_default();
            v.push(input.into());
            self.service_code_list = Some(v);
            self
        }
        /// <p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>
        pub fn set_service_code_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.service_code_list = input;
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServicesInput`](crate::input::DescribeServicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServicesInput {
                service_code_list: self.service_code_list,
                language: self.language,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeServicesInputOperationOutputAlias = crate::operation::DescribeServices;
#[doc(hidden)]
pub type DescribeServicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeServicesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServices`](crate::operation::DescribeServices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeServices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_services(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServices",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServicesInput`](crate::input::DescribeServicesInput)
    pub fn builder() -> crate::input::describe_services_input::Builder {
        crate::input::describe_services_input::Builder::default()
    }
}

/// See [`DescribeSeverityLevelsInput`](crate::input::DescribeSeverityLevelsInput)
pub mod describe_severity_levels_input {
    /// A builder for [`DescribeSeverityLevelsInput`](crate::input::DescribeSeverityLevelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSeverityLevelsInput`](crate::input::DescribeSeverityLevelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSeverityLevelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSeverityLevelsInput {
                language: self.language,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSeverityLevelsInputOperationOutputAlias = crate::operation::DescribeSeverityLevels;
#[doc(hidden)]
pub type DescribeSeverityLevelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSeverityLevelsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSeverityLevels`](crate::operation::DescribeSeverityLevels)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSeverityLevels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSeverityLevelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSeverityLevelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSeverityLevelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeSeverityLevels",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_severity_levels(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSeverityLevels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSeverityLevels",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSeverityLevelsInput`](crate::input::DescribeSeverityLevelsInput)
    pub fn builder() -> crate::input::describe_severity_levels_input::Builder {
        crate::input::describe_severity_levels_input::Builder::default()
    }
}

/// See [`DescribeTrustedAdvisorCheckRefreshStatusesInput`](crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput)
pub mod describe_trusted_advisor_check_refresh_statuses_input {
    /// A builder for [`DescribeTrustedAdvisorCheckRefreshStatusesInput`](crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `check_ids`.
        ///
        /// To override the contents of this collection use [`set_check_ids`](Self::set_check_ids).
        ///
        /// <p>The IDs of the Trusted Advisor checks to get the status.</p> <note>
        /// <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn check_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.check_ids.unwrap_or_default();
            v.push(input.into());
            self.check_ids = Some(v);
            self
        }
        /// <p>The IDs of the Trusted Advisor checks to get the status.</p> <note>
        /// <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn set_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.check_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorCheckRefreshStatusesInput`](crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput {
                    check_ids: self.check_ids,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeTrustedAdvisorCheckRefreshStatusesInputOperationOutputAlias =
    crate::operation::DescribeTrustedAdvisorCheckRefreshStatuses;
#[doc(hidden)]
pub type DescribeTrustedAdvisorCheckRefreshStatusesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTrustedAdvisorCheckRefreshStatusesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTrustedAdvisorCheckRefreshStatuses`](crate::operation::DescribeTrustedAdvisorCheckRefreshStatuses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTrustedAdvisorCheckRefreshStatuses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeTrustedAdvisorCheckRefreshStatuses",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_trusted_advisor_check_refresh_statuses(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTrustedAdvisorCheckRefreshStatuses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTrustedAdvisorCheckRefreshStatuses",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorCheckRefreshStatusesInput`](crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInput)
    pub fn builder() -> crate::input::describe_trusted_advisor_check_refresh_statuses_input::Builder
    {
        crate::input::describe_trusted_advisor_check_refresh_statuses_input::Builder::default()
    }
}

/// See [`DescribeTrustedAdvisorCheckResultInput`](crate::input::DescribeTrustedAdvisorCheckResultInput)
pub mod describe_trusted_advisor_check_result_input {
    /// A builder for [`DescribeTrustedAdvisorCheckResultInput`](crate::input::DescribeTrustedAdvisorCheckResultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_id: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_id = input;
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorCheckResultInput`](crate::input::DescribeTrustedAdvisorCheckResultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrustedAdvisorCheckResultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTrustedAdvisorCheckResultInput {
                check_id: self.check_id,
                language: self.language,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTrustedAdvisorCheckResultInputOperationOutputAlias =
    crate::operation::DescribeTrustedAdvisorCheckResult;
#[doc(hidden)]
pub type DescribeTrustedAdvisorCheckResultInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTrustedAdvisorCheckResultInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTrustedAdvisorCheckResult`](crate::operation::DescribeTrustedAdvisorCheckResult)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTrustedAdvisorCheckResult,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTrustedAdvisorCheckResultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTrustedAdvisorCheckResultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTrustedAdvisorCheckResultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeTrustedAdvisorCheckResult",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_trusted_advisor_check_result(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTrustedAdvisorCheckResult::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTrustedAdvisorCheckResult",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorCheckResultInput`](crate::input::DescribeTrustedAdvisorCheckResultInput)
    pub fn builder() -> crate::input::describe_trusted_advisor_check_result_input::Builder {
        crate::input::describe_trusted_advisor_check_result_input::Builder::default()
    }
}

/// See [`DescribeTrustedAdvisorChecksInput`](crate::input::DescribeTrustedAdvisorChecksInput)
pub mod describe_trusted_advisor_checks_input {
    /// A builder for [`DescribeTrustedAdvisorChecksInput`](crate::input::DescribeTrustedAdvisorChecksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorChecksInput`](crate::input::DescribeTrustedAdvisorChecksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrustedAdvisorChecksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTrustedAdvisorChecksInput {
                language: self.language,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTrustedAdvisorChecksInputOperationOutputAlias =
    crate::operation::DescribeTrustedAdvisorChecks;
#[doc(hidden)]
pub type DescribeTrustedAdvisorChecksInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTrustedAdvisorChecksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTrustedAdvisorChecks`](crate::operation::DescribeTrustedAdvisorChecks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTrustedAdvisorChecks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTrustedAdvisorChecksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTrustedAdvisorChecksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTrustedAdvisorChecksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeTrustedAdvisorChecks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_trusted_advisor_checks(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTrustedAdvisorChecks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTrustedAdvisorChecks",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorChecksInput`](crate::input::DescribeTrustedAdvisorChecksInput)
    pub fn builder() -> crate::input::describe_trusted_advisor_checks_input::Builder {
        crate::input::describe_trusted_advisor_checks_input::Builder::default()
    }
}

/// See [`DescribeTrustedAdvisorCheckSummariesInput`](crate::input::DescribeTrustedAdvisorCheckSummariesInput)
pub mod describe_trusted_advisor_check_summaries_input {
    /// A builder for [`DescribeTrustedAdvisorCheckSummariesInput`](crate::input::DescribeTrustedAdvisorCheckSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `check_ids`.
        ///
        /// To override the contents of this collection use [`set_check_ids`](Self::set_check_ids).
        ///
        /// <p>The IDs of the Trusted Advisor checks.</p>
        pub fn check_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.check_ids.unwrap_or_default();
            v.push(input.into());
            self.check_ids = Some(v);
            self
        }
        /// <p>The IDs of the Trusted Advisor checks.</p>
        pub fn set_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.check_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorCheckSummariesInput`](crate::input::DescribeTrustedAdvisorCheckSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrustedAdvisorCheckSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTrustedAdvisorCheckSummariesInput {
                check_ids: self.check_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTrustedAdvisorCheckSummariesInputOperationOutputAlias =
    crate::operation::DescribeTrustedAdvisorCheckSummaries;
#[doc(hidden)]
pub type DescribeTrustedAdvisorCheckSummariesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTrustedAdvisorCheckSummariesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTrustedAdvisorCheckSummaries`](crate::operation::DescribeTrustedAdvisorCheckSummaries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTrustedAdvisorCheckSummaries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTrustedAdvisorCheckSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTrustedAdvisorCheckSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTrustedAdvisorCheckSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.DescribeTrustedAdvisorCheckSummaries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_trusted_advisor_check_summaries(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTrustedAdvisorCheckSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTrustedAdvisorCheckSummaries",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorCheckSummariesInput`](crate::input::DescribeTrustedAdvisorCheckSummariesInput)
    pub fn builder() -> crate::input::describe_trusted_advisor_check_summaries_input::Builder {
        crate::input::describe_trusted_advisor_check_summaries_input::Builder::default()
    }
}

/// See [`RefreshTrustedAdvisorCheckInput`](crate::input::RefreshTrustedAdvisorCheckInput)
pub mod refresh_trusted_advisor_check_input {
    /// A builder for [`RefreshTrustedAdvisorCheckInput`](crate::input::RefreshTrustedAdvisorCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Trusted Advisor check to refresh.</p> <note>
        /// <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check to refresh.</p> <note>
        /// <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshTrustedAdvisorCheckInput`](crate::input::RefreshTrustedAdvisorCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RefreshTrustedAdvisorCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RefreshTrustedAdvisorCheckInput {
                check_id: self.check_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RefreshTrustedAdvisorCheckInputOperationOutputAlias =
    crate::operation::RefreshTrustedAdvisorCheck;
#[doc(hidden)]
pub type RefreshTrustedAdvisorCheckInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RefreshTrustedAdvisorCheckInput {
    /// Consumes the builder and constructs an Operation<[`RefreshTrustedAdvisorCheck`](crate::operation::RefreshTrustedAdvisorCheck)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RefreshTrustedAdvisorCheck,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RefreshTrustedAdvisorCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RefreshTrustedAdvisorCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RefreshTrustedAdvisorCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.RefreshTrustedAdvisorCheck",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_refresh_trusted_advisor_check(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RefreshTrustedAdvisorCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RefreshTrustedAdvisorCheck",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RefreshTrustedAdvisorCheckInput`](crate::input::RefreshTrustedAdvisorCheckInput)
    pub fn builder() -> crate::input::refresh_trusted_advisor_check_input::Builder {
        crate::input::refresh_trusted_advisor_check_input::Builder::default()
    }
}

/// See [`ResolveCaseInput`](crate::input::ResolveCaseInput)
pub mod resolve_case_input {
    /// A builder for [`ResolveCaseInput`](crate::input::ResolveCaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveCaseInput`](crate::input::ResolveCaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResolveCaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResolveCaseInput {
                case_id: self.case_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ResolveCaseInputOperationOutputAlias = crate::operation::ResolveCase;
#[doc(hidden)]
pub type ResolveCaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResolveCaseInput {
    /// Consumes the builder and constructs an Operation<[`ResolveCase`](crate::operation::ResolveCase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResolveCase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResolveCaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResolveCaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResolveCaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSupport_20130415.ResolveCase",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_resolve_case(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResolveCase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResolveCase",
            "support",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResolveCaseInput`](crate::input::ResolveCaseInput)
    pub fn builder() -> crate::input::resolve_case_input::Builder {
        crate::input::resolve_case_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveCaseInput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub case_id: std::option::Option<std::string::String>,
}
impl ResolveCaseInput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
}
impl std::fmt::Debug for ResolveCaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveCaseInput");
        formatter.field("case_id", &self.case_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshTrustedAdvisorCheckInput {
    /// <p>The unique identifier for the Trusted Advisor check to refresh.</p> <note>
    /// <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p>
    /// </note>
    pub check_id: std::option::Option<std::string::String>,
}
impl RefreshTrustedAdvisorCheckInput {
    /// <p>The unique identifier for the Trusted Advisor check to refresh.</p> <note>
    /// <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p>
    /// </note>
    pub fn check_id(&self) -> std::option::Option<&str> {
        self.check_id.as_deref()
    }
}
impl std::fmt::Debug for RefreshTrustedAdvisorCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshTrustedAdvisorCheckInput");
        formatter.field("check_id", &self.check_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorCheckSummariesInput {
    /// <p>The IDs of the Trusted Advisor checks.</p>
    pub check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeTrustedAdvisorCheckSummariesInput {
    /// <p>The IDs of the Trusted Advisor checks.</p>
    pub fn check_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.check_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorCheckSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorCheckSummariesInput");
        formatter.field("check_ids", &self.check_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorChecksInput {
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub language: std::option::Option<std::string::String>,
}
impl DescribeTrustedAdvisorChecksInput {
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorChecksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorChecksInput");
        formatter.field("language", &self.language);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorCheckResultInput {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub check_id: std::option::Option<std::string::String>,
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub language: std::option::Option<std::string::String>,
}
impl DescribeTrustedAdvisorCheckResultInput {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub fn check_id(&self) -> std::option::Option<&str> {
        self.check_id.as_deref()
    }
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorCheckResultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorCheckResultInput");
        formatter.field("check_id", &self.check_id);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorCheckRefreshStatusesInput {
    /// <p>The IDs of the Trusted Advisor checks to get the status.</p> <note>
    /// <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p>
    /// </note>
    pub check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeTrustedAdvisorCheckRefreshStatusesInput {
    /// <p>The IDs of the Trusted Advisor checks to get the status.</p> <note>
    /// <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p>
    /// </note>
    pub fn check_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.check_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorCheckRefreshStatusesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorCheckRefreshStatusesInput");
        formatter.field("check_ids", &self.check_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSeverityLevelsInput {
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub language: std::option::Option<std::string::String>,
}
impl DescribeSeverityLevelsInput {
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for DescribeSeverityLevelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSeverityLevelsInput");
        formatter.field("language", &self.language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServicesInput {
    /// <p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>
    pub service_code_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub language: std::option::Option<std::string::String>,
}
impl DescribeServicesInput {
    /// <p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>
    pub fn service_code_list(&self) -> std::option::Option<&[std::string::String]> {
        self.service_code_list.as_deref()
    }
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for DescribeServicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServicesInput");
        formatter.field("service_code_list", &self.service_code_list);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCommunicationsInput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub case_id: std::option::Option<std::string::String>,
    /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub before_time: std::option::Option<std::string::String>,
    /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub after_time: std::option::Option<std::string::String>,
    /// <p>A resumption point for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return before paginating.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeCommunicationsInput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
    /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub fn before_time(&self) -> std::option::Option<&str> {
        self.before_time.as_deref()
    }
    /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub fn after_time(&self) -> std::option::Option<&str> {
        self.after_time.as_deref()
    }
    /// <p>A resumption point for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return before paginating.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeCommunicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCommunicationsInput");
        formatter.field("case_id", &self.case_id);
        formatter.field("before_time", &self.before_time);
        formatter.field("after_time", &self.after_time);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCasesInput {
    /// <p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>
    pub case_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>
    pub display_id: std::option::Option<std::string::String>,
    /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub after_time: std::option::Option<std::string::String>,
    /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub before_time: std::option::Option<std::string::String>,
    /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren't included.</p>
    pub include_resolved_cases: bool,
    /// <p>A resumption point for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return before paginating.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub language: std::option::Option<std::string::String>,
    /// <p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>
    pub include_communications: std::option::Option<bool>,
}
impl DescribeCasesInput {
    /// <p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>
    pub fn case_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.case_id_list.as_deref()
    }
    /// <p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>
    pub fn display_id(&self) -> std::option::Option<&str> {
        self.display_id.as_deref()
    }
    /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub fn after_time(&self) -> std::option::Option<&str> {
        self.after_time.as_deref()
    }
    /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    pub fn before_time(&self) -> std::option::Option<&str> {
        self.before_time.as_deref()
    }
    /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren't included.</p>
    pub fn include_resolved_cases(&self) -> bool {
        self.include_resolved_cases
    }
    /// <p>A resumption point for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return before paginating.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
    /// <p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>
    pub fn include_communications(&self) -> std::option::Option<bool> {
        self.include_communications
    }
}
impl std::fmt::Debug for DescribeCasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCasesInput");
        formatter.field("case_id_list", &self.case_id_list);
        formatter.field("display_id", &self.display_id);
        formatter.field("after_time", &self.after_time);
        formatter.field("before_time", &self.before_time);
        formatter.field("include_resolved_cases", &self.include_resolved_cases);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("language", &self.language);
        formatter.field("include_communications", &self.include_communications);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAttachmentInput {
    /// <p>The ID of the attachment to return. Attachment IDs are returned by the <code>DescribeCommunications</code> operation.</p>
    pub attachment_id: std::option::Option<std::string::String>,
}
impl DescribeAttachmentInput {
    /// <p>The ID of the attachment to return. Attachment IDs are returned by the <code>DescribeCommunications</code> operation.</p>
    pub fn attachment_id(&self) -> std::option::Option<&str> {
        self.attachment_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAttachmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAttachmentInput");
        formatter.field("attachment_id", &self.attachment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCaseInput {
    /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The code for the Amazon Web Services service. You can use the <code>DescribeServices</code> operation to get the possible <code>serviceCode</code> values.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <code>DescribeSeverityLevels</code> operation to get the possible values for <code>severityCode</code>. </p>
    /// <p>For more information, see <code>SeverityLevel</code> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note>
    /// <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p>
    /// </note>
    pub severity_code: std::option::Option<std::string::String>,
    /// <p>The category of problem for the support case. You also use the <code>DescribeServices</code> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>
    pub category_code: std::option::Option<std::string::String>,
    /// <p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    pub communication_body: std::option::Option<std::string::String>,
    /// <p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>
    pub cc_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>
    pub language: std::option::Option<std::string::String>,
    /// <p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.</p>
    pub issue_type: std::option::Option<std::string::String>,
    /// <p>The ID of a set of one or more attachments for the case. Create the set by using the <code>AddAttachmentsToSet</code> operation.</p>
    pub attachment_set_id: std::option::Option<std::string::String>,
}
impl CreateCaseInput {
    /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The code for the Amazon Web Services service. You can use the <code>DescribeServices</code> operation to get the possible <code>serviceCode</code> values.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <code>DescribeSeverityLevels</code> operation to get the possible values for <code>severityCode</code>. </p>
    /// <p>For more information, see <code>SeverityLevel</code> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note>
    /// <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p>
    /// </note>
    pub fn severity_code(&self) -> std::option::Option<&str> {
        self.severity_code.as_deref()
    }
    /// <p>The category of problem for the support case. You also use the <code>DescribeServices</code> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>
    pub fn category_code(&self) -> std::option::Option<&str> {
        self.category_code.as_deref()
    }
    /// <p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    pub fn communication_body(&self) -> std::option::Option<&str> {
        self.communication_body.as_deref()
    }
    /// <p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>
    pub fn cc_email_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.cc_email_addresses.as_deref()
    }
    /// <p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
    /// <p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.</p>
    pub fn issue_type(&self) -> std::option::Option<&str> {
        self.issue_type.as_deref()
    }
    /// <p>The ID of a set of one or more attachments for the case. Create the set by using the <code>AddAttachmentsToSet</code> operation.</p>
    pub fn attachment_set_id(&self) -> std::option::Option<&str> {
        self.attachment_set_id.as_deref()
    }
}
impl std::fmt::Debug for CreateCaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCaseInput");
        formatter.field("subject", &self.subject);
        formatter.field("service_code", &self.service_code);
        formatter.field("severity_code", &self.severity_code);
        formatter.field("category_code", &self.category_code);
        formatter.field("communication_body", &self.communication_body);
        formatter.field("cc_email_addresses", &self.cc_email_addresses);
        formatter.field("language", &self.language);
        formatter.field("issue_type", &self.issue_type);
        formatter.field("attachment_set_id", &self.attachment_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddCommunicationToCaseInput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub case_id: std::option::Option<std::string::String>,
    /// <p>The body of an email communication to add to the support case.</p>
    pub communication_body: std::option::Option<std::string::String>,
    /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
    pub cc_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <code>AddAttachmentsToSet</code> </p>
    pub attachment_set_id: std::option::Option<std::string::String>,
}
impl AddCommunicationToCaseInput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
    /// <p>The body of an email communication to add to the support case.</p>
    pub fn communication_body(&self) -> std::option::Option<&str> {
        self.communication_body.as_deref()
    }
    /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
    pub fn cc_email_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.cc_email_addresses.as_deref()
    }
    /// <p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <code>AddAttachmentsToSet</code> </p>
    pub fn attachment_set_id(&self) -> std::option::Option<&str> {
        self.attachment_set_id.as_deref()
    }
}
impl std::fmt::Debug for AddCommunicationToCaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddCommunicationToCaseInput");
        formatter.field("case_id", &self.case_id);
        formatter.field("communication_body", &self.communication_body);
        formatter.field("cc_email_addresses", &self.cc_email_addresses);
        formatter.field("attachment_set_id", &self.attachment_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddAttachmentsToSetInput {
    /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>
    pub attachment_set_id: std::option::Option<std::string::String>,
    /// <p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p>
    /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
    pub attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
}
impl AddAttachmentsToSetInput {
    /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>
    pub fn attachment_set_id(&self) -> std::option::Option<&str> {
        self.attachment_set_id.as_deref()
    }
    /// <p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p>
    /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
    pub fn attachments(&self) -> std::option::Option<&[crate::model::Attachment]> {
        self.attachments.as_deref()
    }
}
impl std::fmt::Debug for AddAttachmentsToSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddAttachmentsToSetInput");
        formatter.field("attachment_set_id", &self.attachment_set_id);
        formatter.field("attachments", &self.attachments);
        formatter.finish()
    }
}
