// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The refresh status of a Trusted Advisor check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorCheckRefreshStatus {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub check_id: std::option::Option<std::string::String>,
    /// <p>The status of the Trusted Advisor check for which a refresh has been requested: </p>
    /// <ul>
    /// <li> <p> <code>none</code> - The check is not refreshed or the non-success status exceeds the timeout</p> </li>
    /// <li> <p> <code>enqueued</code> - The check refresh requests has entered the refresh queue</p> </li>
    /// <li> <p> <code>processing</code> - The check refresh request is picked up by the rule processing engine</p> </li>
    /// <li> <p> <code>success</code> - The check is successfully refreshed</p> </li>
    /// <li> <p> <code>abandoned</code> - The check refresh has failed</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.</p>
    pub millis_until_next_refreshable: i64,
}
impl TrustedAdvisorCheckRefreshStatus {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub fn check_id(&self) -> std::option::Option<&str> {
        self.check_id.as_deref()
    }
    /// <p>The status of the Trusted Advisor check for which a refresh has been requested: </p>
    /// <ul>
    /// <li> <p> <code>none</code> - The check is not refreshed or the non-success status exceeds the timeout</p> </li>
    /// <li> <p> <code>enqueued</code> - The check refresh requests has entered the refresh queue</p> </li>
    /// <li> <p> <code>processing</code> - The check refresh request is picked up by the rule processing engine</p> </li>
    /// <li> <p> <code>success</code> - The check is successfully refreshed</p> </li>
    /// <li> <p> <code>abandoned</code> - The check refresh has failed</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.</p>
    pub fn millis_until_next_refreshable(&self) -> i64 {
        self.millis_until_next_refreshable
    }
}
impl std::fmt::Debug for TrustedAdvisorCheckRefreshStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorCheckRefreshStatus");
        formatter.field("check_id", &self.check_id);
        formatter.field("status", &self.status);
        formatter.field(
            "millis_until_next_refreshable",
            &self.millis_until_next_refreshable,
        );
        formatter.finish()
    }
}
/// See [`TrustedAdvisorCheckRefreshStatus`](crate::model::TrustedAdvisorCheckRefreshStatus)
pub mod trusted_advisor_check_refresh_status {
    /// A builder for [`TrustedAdvisorCheckRefreshStatus`](crate::model::TrustedAdvisorCheckRefreshStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) millis_until_next_refreshable: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_id = input;
            self
        }
        /// <p>The status of the Trusted Advisor check for which a refresh has been requested: </p>
        /// <ul>
        /// <li> <p> <code>none</code> - The check is not refreshed or the non-success status exceeds the timeout</p> </li>
        /// <li> <p> <code>enqueued</code> - The check refresh requests has entered the refresh queue</p> </li>
        /// <li> <p> <code>processing</code> - The check refresh request is picked up by the rule processing engine</p> </li>
        /// <li> <p> <code>success</code> - The check is successfully refreshed</p> </li>
        /// <li> <p> <code>abandoned</code> - The check refresh has failed</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Trusted Advisor check for which a refresh has been requested: </p>
        /// <ul>
        /// <li> <p> <code>none</code> - The check is not refreshed or the non-success status exceeds the timeout</p> </li>
        /// <li> <p> <code>enqueued</code> - The check refresh requests has entered the refresh queue</p> </li>
        /// <li> <p> <code>processing</code> - The check refresh request is picked up by the rule processing engine</p> </li>
        /// <li> <p> <code>success</code> - The check is successfully refreshed</p> </li>
        /// <li> <p> <code>abandoned</code> - The check refresh has failed</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.</p>
        pub fn millis_until_next_refreshable(mut self, input: i64) -> Self {
            self.millis_until_next_refreshable = Some(input);
            self
        }
        /// <p>The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.</p>
        pub fn set_millis_until_next_refreshable(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.millis_until_next_refreshable = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorCheckRefreshStatus`](crate::model::TrustedAdvisorCheckRefreshStatus)
        pub fn build(self) -> crate::model::TrustedAdvisorCheckRefreshStatus {
            crate::model::TrustedAdvisorCheckRefreshStatus {
                check_id: self.check_id,
                status: self.status,
                millis_until_next_refreshable: self
                    .millis_until_next_refreshable
                    .unwrap_or_default(),
            }
        }
    }
}
impl TrustedAdvisorCheckRefreshStatus {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorCheckRefreshStatus`](crate::model::TrustedAdvisorCheckRefreshStatus)
    pub fn builder() -> crate::model::trusted_advisor_check_refresh_status::Builder {
        crate::model::trusted_advisor_check_refresh_status::Builder::default()
    }
}

/// <p>A summary of a Trusted Advisor check result, including the alert status, last refresh, and number of resources examined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorCheckSummary {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub check_id: std::option::Option<std::string::String>,
    /// <p>The time of the last refresh of the check.</p>
    pub timestamp: std::option::Option<std::string::String>,
    /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Trusted Advisor check has flagged resources.</p>
    pub has_flagged_resources: bool,
    /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
    pub resources_summary: std::option::Option<crate::model::TrustedAdvisorResourcesSummary>,
    /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
    pub category_specific_summary:
        std::option::Option<crate::model::TrustedAdvisorCategorySpecificSummary>,
}
impl TrustedAdvisorCheckSummary {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub fn check_id(&self) -> std::option::Option<&str> {
        self.check_id.as_deref()
    }
    /// <p>The time of the last refresh of the check.</p>
    pub fn timestamp(&self) -> std::option::Option<&str> {
        self.timestamp.as_deref()
    }
    /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Specifies whether the Trusted Advisor check has flagged resources.</p>
    pub fn has_flagged_resources(&self) -> bool {
        self.has_flagged_resources
    }
    /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
    pub fn resources_summary(
        &self,
    ) -> std::option::Option<&crate::model::TrustedAdvisorResourcesSummary> {
        self.resources_summary.as_ref()
    }
    /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
    pub fn category_specific_summary(
        &self,
    ) -> std::option::Option<&crate::model::TrustedAdvisorCategorySpecificSummary> {
        self.category_specific_summary.as_ref()
    }
}
impl std::fmt::Debug for TrustedAdvisorCheckSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorCheckSummary");
        formatter.field("check_id", &self.check_id);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("status", &self.status);
        formatter.field("has_flagged_resources", &self.has_flagged_resources);
        formatter.field("resources_summary", &self.resources_summary);
        formatter.field("category_specific_summary", &self.category_specific_summary);
        formatter.finish()
    }
}
/// See [`TrustedAdvisorCheckSummary`](crate::model::TrustedAdvisorCheckSummary)
pub mod trusted_advisor_check_summary {
    /// A builder for [`TrustedAdvisorCheckSummary`](crate::model::TrustedAdvisorCheckSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_id: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) has_flagged_resources: std::option::Option<bool>,
        pub(crate) resources_summary:
            std::option::Option<crate::model::TrustedAdvisorResourcesSummary>,
        pub(crate) category_specific_summary:
            std::option::Option<crate::model::TrustedAdvisorCategorySpecificSummary>,
    }
    impl Builder {
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_id = input;
            self
        }
        /// <p>The time of the last refresh of the check.</p>
        pub fn timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp = Some(input.into());
            self
        }
        /// <p>The time of the last refresh of the check.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies whether the Trusted Advisor check has flagged resources.</p>
        pub fn has_flagged_resources(mut self, input: bool) -> Self {
            self.has_flagged_resources = Some(input);
            self
        }
        /// <p>Specifies whether the Trusted Advisor check has flagged resources.</p>
        pub fn set_has_flagged_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.has_flagged_resources = input;
            self
        }
        /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
        pub fn resources_summary(
            mut self,
            input: crate::model::TrustedAdvisorResourcesSummary,
        ) -> Self {
            self.resources_summary = Some(input);
            self
        }
        /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
        pub fn set_resources_summary(
            mut self,
            input: std::option::Option<crate::model::TrustedAdvisorResourcesSummary>,
        ) -> Self {
            self.resources_summary = input;
            self
        }
        /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
        pub fn category_specific_summary(
            mut self,
            input: crate::model::TrustedAdvisorCategorySpecificSummary,
        ) -> Self {
            self.category_specific_summary = Some(input);
            self
        }
        /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
        pub fn set_category_specific_summary(
            mut self,
            input: std::option::Option<crate::model::TrustedAdvisorCategorySpecificSummary>,
        ) -> Self {
            self.category_specific_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorCheckSummary`](crate::model::TrustedAdvisorCheckSummary)
        pub fn build(self) -> crate::model::TrustedAdvisorCheckSummary {
            crate::model::TrustedAdvisorCheckSummary {
                check_id: self.check_id,
                timestamp: self.timestamp,
                status: self.status,
                has_flagged_resources: self.has_flagged_resources.unwrap_or_default(),
                resources_summary: self.resources_summary,
                category_specific_summary: self.category_specific_summary,
            }
        }
    }
}
impl TrustedAdvisorCheckSummary {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorCheckSummary`](crate::model::TrustedAdvisorCheckSummary)
    pub fn builder() -> crate::model::trusted_advisor_check_summary::Builder {
        crate::model::trusted_advisor_check_summary::Builder::default()
    }
}

/// <p>The container for summary information that relates to the category of the Trusted Advisor check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorCategorySpecificSummary {
    /// <p>The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing category.</p>
    pub cost_optimizing: std::option::Option<crate::model::TrustedAdvisorCostOptimizingSummary>,
}
impl TrustedAdvisorCategorySpecificSummary {
    /// <p>The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing category.</p>
    pub fn cost_optimizing(
        &self,
    ) -> std::option::Option<&crate::model::TrustedAdvisorCostOptimizingSummary> {
        self.cost_optimizing.as_ref()
    }
}
impl std::fmt::Debug for TrustedAdvisorCategorySpecificSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorCategorySpecificSummary");
        formatter.field("cost_optimizing", &self.cost_optimizing);
        formatter.finish()
    }
}
/// See [`TrustedAdvisorCategorySpecificSummary`](crate::model::TrustedAdvisorCategorySpecificSummary)
pub mod trusted_advisor_category_specific_summary {
    /// A builder for [`TrustedAdvisorCategorySpecificSummary`](crate::model::TrustedAdvisorCategorySpecificSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_optimizing:
            std::option::Option<crate::model::TrustedAdvisorCostOptimizingSummary>,
    }
    impl Builder {
        /// <p>The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing category.</p>
        pub fn cost_optimizing(
            mut self,
            input: crate::model::TrustedAdvisorCostOptimizingSummary,
        ) -> Self {
            self.cost_optimizing = Some(input);
            self
        }
        /// <p>The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing category.</p>
        pub fn set_cost_optimizing(
            mut self,
            input: std::option::Option<crate::model::TrustedAdvisorCostOptimizingSummary>,
        ) -> Self {
            self.cost_optimizing = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorCategorySpecificSummary`](crate::model::TrustedAdvisorCategorySpecificSummary)
        pub fn build(self) -> crate::model::TrustedAdvisorCategorySpecificSummary {
            crate::model::TrustedAdvisorCategorySpecificSummary {
                cost_optimizing: self.cost_optimizing,
            }
        }
    }
}
impl TrustedAdvisorCategorySpecificSummary {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorCategorySpecificSummary`](crate::model::TrustedAdvisorCategorySpecificSummary)
    pub fn builder() -> crate::model::trusted_advisor_category_specific_summary::Builder {
        crate::model::trusted_advisor_category_specific_summary::Builder::default()
    }
}

/// <p>The estimated cost savings that might be realized if the recommended operations are taken.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorCostOptimizingSummary {
    /// <p>The estimated monthly savings that might be realized if the recommended operations are taken.</p>
    pub estimated_monthly_savings: f64,
    /// <p>The estimated percentage of savings that might be realized if the recommended operations are taken.</p>
    pub estimated_percent_monthly_savings: f64,
}
impl TrustedAdvisorCostOptimizingSummary {
    /// <p>The estimated monthly savings that might be realized if the recommended operations are taken.</p>
    pub fn estimated_monthly_savings(&self) -> f64 {
        self.estimated_monthly_savings
    }
    /// <p>The estimated percentage of savings that might be realized if the recommended operations are taken.</p>
    pub fn estimated_percent_monthly_savings(&self) -> f64 {
        self.estimated_percent_monthly_savings
    }
}
impl std::fmt::Debug for TrustedAdvisorCostOptimizingSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorCostOptimizingSummary");
        formatter.field("estimated_monthly_savings", &self.estimated_monthly_savings);
        formatter.field(
            "estimated_percent_monthly_savings",
            &self.estimated_percent_monthly_savings,
        );
        formatter.finish()
    }
}
/// See [`TrustedAdvisorCostOptimizingSummary`](crate::model::TrustedAdvisorCostOptimizingSummary)
pub mod trusted_advisor_cost_optimizing_summary {
    /// A builder for [`TrustedAdvisorCostOptimizingSummary`](crate::model::TrustedAdvisorCostOptimizingSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) estimated_monthly_savings: std::option::Option<f64>,
        pub(crate) estimated_percent_monthly_savings: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The estimated monthly savings that might be realized if the recommended operations are taken.</p>
        pub fn estimated_monthly_savings(mut self, input: f64) -> Self {
            self.estimated_monthly_savings = Some(input);
            self
        }
        /// <p>The estimated monthly savings that might be realized if the recommended operations are taken.</p>
        pub fn set_estimated_monthly_savings(mut self, input: std::option::Option<f64>) -> Self {
            self.estimated_monthly_savings = input;
            self
        }
        /// <p>The estimated percentage of savings that might be realized if the recommended operations are taken.</p>
        pub fn estimated_percent_monthly_savings(mut self, input: f64) -> Self {
            self.estimated_percent_monthly_savings = Some(input);
            self
        }
        /// <p>The estimated percentage of savings that might be realized if the recommended operations are taken.</p>
        pub fn set_estimated_percent_monthly_savings(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.estimated_percent_monthly_savings = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorCostOptimizingSummary`](crate::model::TrustedAdvisorCostOptimizingSummary)
        pub fn build(self) -> crate::model::TrustedAdvisorCostOptimizingSummary {
            crate::model::TrustedAdvisorCostOptimizingSummary {
                estimated_monthly_savings: self.estimated_monthly_savings.unwrap_or_default(),
                estimated_percent_monthly_savings: self
                    .estimated_percent_monthly_savings
                    .unwrap_or_default(),
            }
        }
    }
}
impl TrustedAdvisorCostOptimizingSummary {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorCostOptimizingSummary`](crate::model::TrustedAdvisorCostOptimizingSummary)
    pub fn builder() -> crate::model::trusted_advisor_cost_optimizing_summary::Builder {
        crate::model::trusted_advisor_cost_optimizing_summary::Builder::default()
    }
}

/// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorResourcesSummary {
    /// <p>The number of Amazon Web Services resources that were analyzed by the Trusted Advisor check.</p>
    pub resources_processed: i64,
    /// <p>The number of Amazon Web Services resources that were flagged (listed) by the Trusted Advisor check.</p>
    pub resources_flagged: i64,
    /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because information was unavailable.</p>
    pub resources_ignored: i64,
    /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because they were marked as suppressed by the user.</p>
    pub resources_suppressed: i64,
}
impl TrustedAdvisorResourcesSummary {
    /// <p>The number of Amazon Web Services resources that were analyzed by the Trusted Advisor check.</p>
    pub fn resources_processed(&self) -> i64 {
        self.resources_processed
    }
    /// <p>The number of Amazon Web Services resources that were flagged (listed) by the Trusted Advisor check.</p>
    pub fn resources_flagged(&self) -> i64 {
        self.resources_flagged
    }
    /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because information was unavailable.</p>
    pub fn resources_ignored(&self) -> i64 {
        self.resources_ignored
    }
    /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because they were marked as suppressed by the user.</p>
    pub fn resources_suppressed(&self) -> i64 {
        self.resources_suppressed
    }
}
impl std::fmt::Debug for TrustedAdvisorResourcesSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorResourcesSummary");
        formatter.field("resources_processed", &self.resources_processed);
        formatter.field("resources_flagged", &self.resources_flagged);
        formatter.field("resources_ignored", &self.resources_ignored);
        formatter.field("resources_suppressed", &self.resources_suppressed);
        formatter.finish()
    }
}
/// See [`TrustedAdvisorResourcesSummary`](crate::model::TrustedAdvisorResourcesSummary)
pub mod trusted_advisor_resources_summary {
    /// A builder for [`TrustedAdvisorResourcesSummary`](crate::model::TrustedAdvisorResourcesSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources_processed: std::option::Option<i64>,
        pub(crate) resources_flagged: std::option::Option<i64>,
        pub(crate) resources_ignored: std::option::Option<i64>,
        pub(crate) resources_suppressed: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of Amazon Web Services resources that were analyzed by the Trusted Advisor check.</p>
        pub fn resources_processed(mut self, input: i64) -> Self {
            self.resources_processed = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services resources that were analyzed by the Trusted Advisor check.</p>
        pub fn set_resources_processed(mut self, input: std::option::Option<i64>) -> Self {
            self.resources_processed = input;
            self
        }
        /// <p>The number of Amazon Web Services resources that were flagged (listed) by the Trusted Advisor check.</p>
        pub fn resources_flagged(mut self, input: i64) -> Self {
            self.resources_flagged = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services resources that were flagged (listed) by the Trusted Advisor check.</p>
        pub fn set_resources_flagged(mut self, input: std::option::Option<i64>) -> Self {
            self.resources_flagged = input;
            self
        }
        /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because information was unavailable.</p>
        pub fn resources_ignored(mut self, input: i64) -> Self {
            self.resources_ignored = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because information was unavailable.</p>
        pub fn set_resources_ignored(mut self, input: std::option::Option<i64>) -> Self {
            self.resources_ignored = input;
            self
        }
        /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because they were marked as suppressed by the user.</p>
        pub fn resources_suppressed(mut self, input: i64) -> Self {
            self.resources_suppressed = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services resources ignored by Trusted Advisor because they were marked as suppressed by the user.</p>
        pub fn set_resources_suppressed(mut self, input: std::option::Option<i64>) -> Self {
            self.resources_suppressed = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorResourcesSummary`](crate::model::TrustedAdvisorResourcesSummary)
        pub fn build(self) -> crate::model::TrustedAdvisorResourcesSummary {
            crate::model::TrustedAdvisorResourcesSummary {
                resources_processed: self.resources_processed.unwrap_or_default(),
                resources_flagged: self.resources_flagged.unwrap_or_default(),
                resources_ignored: self.resources_ignored.unwrap_or_default(),
                resources_suppressed: self.resources_suppressed.unwrap_or_default(),
            }
        }
    }
}
impl TrustedAdvisorResourcesSummary {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorResourcesSummary`](crate::model::TrustedAdvisorResourcesSummary)
    pub fn builder() -> crate::model::trusted_advisor_resources_summary::Builder {
        crate::model::trusted_advisor_resources_summary::Builder::default()
    }
}

/// <p>The description and metadata for a Trusted Advisor check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorCheckDescription {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The display name for the Trusted Advisor check.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Trusted Advisor check, which includes the alert criteria and recommended operations (contains HTML markup).</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The category of the Trusted Advisor check.</p>
    pub category: std::option::Option<std::string::String>,
    /// <p>The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the <b>Metadata</b> element of the <code>TrustedAdvisorResourceDetail</code> for the check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data. </p>
    pub metadata: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TrustedAdvisorCheckDescription {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The display name for the Trusted Advisor check.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the Trusted Advisor check, which includes the alert criteria and recommended operations (contains HTML markup).</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The category of the Trusted Advisor check.</p>
    pub fn category(&self) -> std::option::Option<&str> {
        self.category.as_deref()
    }
    /// <p>The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the <b>Metadata</b> element of the <code>TrustedAdvisorResourceDetail</code> for the check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data. </p>
    pub fn metadata(&self) -> std::option::Option<&[std::string::String]> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for TrustedAdvisorCheckDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorCheckDescription");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("category", &self.category);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`TrustedAdvisorCheckDescription`](crate::model::TrustedAdvisorCheckDescription)
pub mod trusted_advisor_check_description {
    /// A builder for [`TrustedAdvisorCheckDescription`](crate::model::TrustedAdvisorCheckDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The display name for the Trusted Advisor check.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The display name for the Trusted Advisor check.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Trusted Advisor check, which includes the alert criteria and recommended operations (contains HTML markup).</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Trusted Advisor check, which includes the alert criteria and recommended operations (contains HTML markup).</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The category of the Trusted Advisor check.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>The category of the Trusted Advisor check.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// Appends an item to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the <b>Metadata</b> element of the <code>TrustedAdvisorResourceDetail</code> for the check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data. </p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metadata.unwrap_or_default();
            v.push(input.into());
            self.metadata = Some(v);
            self
        }
        /// <p>The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the <b>Metadata</b> element of the <code>TrustedAdvisorResourceDetail</code> for the check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data. </p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorCheckDescription`](crate::model::TrustedAdvisorCheckDescription)
        pub fn build(self) -> crate::model::TrustedAdvisorCheckDescription {
            crate::model::TrustedAdvisorCheckDescription {
                id: self.id,
                name: self.name,
                description: self.description,
                category: self.category,
                metadata: self.metadata,
            }
        }
    }
}
impl TrustedAdvisorCheckDescription {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorCheckDescription`](crate::model::TrustedAdvisorCheckDescription)
    pub fn builder() -> crate::model::trusted_advisor_check_description::Builder {
        crate::model::trusted_advisor_check_description::Builder::default()
    }
}

/// <p>The results of a Trusted Advisor check returned by <code>DescribeTrustedAdvisorCheckResult</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorCheckResult {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub check_id: std::option::Option<std::string::String>,
    /// <p>The time of the last refresh of the check.</p>
    pub timestamp: std::option::Option<std::string::String>,
    /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
    pub resources_summary: std::option::Option<crate::model::TrustedAdvisorResourcesSummary>,
    /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
    pub category_specific_summary:
        std::option::Option<crate::model::TrustedAdvisorCategorySpecificSummary>,
    /// <p>The details about each resource listed in the check result.</p>
    pub flagged_resources:
        std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorResourceDetail>>,
}
impl TrustedAdvisorCheckResult {
    /// <p>The unique identifier for the Trusted Advisor check.</p>
    pub fn check_id(&self) -> std::option::Option<&str> {
        self.check_id.as_deref()
    }
    /// <p>The time of the last refresh of the check.</p>
    pub fn timestamp(&self) -> std::option::Option<&str> {
        self.timestamp.as_deref()
    }
    /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
    pub fn resources_summary(
        &self,
    ) -> std::option::Option<&crate::model::TrustedAdvisorResourcesSummary> {
        self.resources_summary.as_ref()
    }
    /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
    pub fn category_specific_summary(
        &self,
    ) -> std::option::Option<&crate::model::TrustedAdvisorCategorySpecificSummary> {
        self.category_specific_summary.as_ref()
    }
    /// <p>The details about each resource listed in the check result.</p>
    pub fn flagged_resources(
        &self,
    ) -> std::option::Option<&[crate::model::TrustedAdvisorResourceDetail]> {
        self.flagged_resources.as_deref()
    }
}
impl std::fmt::Debug for TrustedAdvisorCheckResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorCheckResult");
        formatter.field("check_id", &self.check_id);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("status", &self.status);
        formatter.field("resources_summary", &self.resources_summary);
        formatter.field("category_specific_summary", &self.category_specific_summary);
        formatter.field("flagged_resources", &self.flagged_resources);
        formatter.finish()
    }
}
/// See [`TrustedAdvisorCheckResult`](crate::model::TrustedAdvisorCheckResult)
pub mod trusted_advisor_check_result {
    /// A builder for [`TrustedAdvisorCheckResult`](crate::model::TrustedAdvisorCheckResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_id: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) resources_summary:
            std::option::Option<crate::model::TrustedAdvisorResourcesSummary>,
        pub(crate) category_specific_summary:
            std::option::Option<crate::model::TrustedAdvisorCategorySpecificSummary>,
        pub(crate) flagged_resources:
            std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorResourceDetail>>,
    }
    impl Builder {
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_id = input;
            self
        }
        /// <p>The time of the last refresh of the check.</p>
        pub fn timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp = Some(input.into());
            self
        }
        /// <p>The time of the last refresh of the check.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
        pub fn resources_summary(
            mut self,
            input: crate::model::TrustedAdvisorResourcesSummary,
        ) -> Self {
            self.resources_summary = Some(input);
            self
        }
        /// <p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <code>DescribeTrustedAdvisorCheckSummaries</code>.</p>
        pub fn set_resources_summary(
            mut self,
            input: std::option::Option<crate::model::TrustedAdvisorResourcesSummary>,
        ) -> Self {
            self.resources_summary = input;
            self
        }
        /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
        pub fn category_specific_summary(
            mut self,
            input: crate::model::TrustedAdvisorCategorySpecificSummary,
        ) -> Self {
            self.category_specific_summary = Some(input);
            self
        }
        /// <p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>
        pub fn set_category_specific_summary(
            mut self,
            input: std::option::Option<crate::model::TrustedAdvisorCategorySpecificSummary>,
        ) -> Self {
            self.category_specific_summary = input;
            self
        }
        /// Appends an item to `flagged_resources`.
        ///
        /// To override the contents of this collection use [`set_flagged_resources`](Self::set_flagged_resources).
        ///
        /// <p>The details about each resource listed in the check result.</p>
        pub fn flagged_resources(
            mut self,
            input: crate::model::TrustedAdvisorResourceDetail,
        ) -> Self {
            let mut v = self.flagged_resources.unwrap_or_default();
            v.push(input);
            self.flagged_resources = Some(v);
            self
        }
        /// <p>The details about each resource listed in the check result.</p>
        pub fn set_flagged_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorResourceDetail>>,
        ) -> Self {
            self.flagged_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorCheckResult`](crate::model::TrustedAdvisorCheckResult)
        pub fn build(self) -> crate::model::TrustedAdvisorCheckResult {
            crate::model::TrustedAdvisorCheckResult {
                check_id: self.check_id,
                timestamp: self.timestamp,
                status: self.status,
                resources_summary: self.resources_summary,
                category_specific_summary: self.category_specific_summary,
                flagged_resources: self.flagged_resources,
            }
        }
    }
}
impl TrustedAdvisorCheckResult {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorCheckResult`](crate::model::TrustedAdvisorCheckResult)
    pub fn builder() -> crate::model::trusted_advisor_check_result::Builder {
        crate::model::trusted_advisor_check_result::Builder::default()
    }
}

/// <p>Contains information about a resource identified by a Trusted Advisor check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedAdvisorResourceDetail {
    /// <p>The status code for the resource identified in the Trusted Advisor check.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region in which the identified resource is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the identified resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as suppressed by the user.</p>
    pub is_suppressed: bool,
    /// <p>Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the <code>TrustedAdvisorCheckDescription</code> object returned by the call to <code>DescribeTrustedAdvisorChecks</code>. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.</p>
    pub metadata: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TrustedAdvisorResourceDetail {
    /// <p>The status code for the resource identified in the Trusted Advisor check.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The Amazon Web Services Region in which the identified resource is located.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The unique identifier for the identified resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as suppressed by the user.</p>
    pub fn is_suppressed(&self) -> bool {
        self.is_suppressed
    }
    /// <p>Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the <code>TrustedAdvisorCheckDescription</code> object returned by the call to <code>DescribeTrustedAdvisorChecks</code>. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.</p>
    pub fn metadata(&self) -> std::option::Option<&[std::string::String]> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for TrustedAdvisorResourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedAdvisorResourceDetail");
        formatter.field("status", &self.status);
        formatter.field("region", &self.region);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("is_suppressed", &self.is_suppressed);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`TrustedAdvisorResourceDetail`](crate::model::TrustedAdvisorResourceDetail)
pub mod trusted_advisor_resource_detail {
    /// A builder for [`TrustedAdvisorResourceDetail`](crate::model::TrustedAdvisorResourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) is_suppressed: std::option::Option<bool>,
        pub(crate) metadata: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The status code for the resource identified in the Trusted Advisor check.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status code for the resource identified in the Trusted Advisor check.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services Region in which the identified resource is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region in which the identified resource is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The unique identifier for the identified resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the identified resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as suppressed by the user.</p>
        pub fn is_suppressed(mut self, input: bool) -> Self {
            self.is_suppressed = Some(input);
            self
        }
        /// <p>Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as suppressed by the user.</p>
        pub fn set_is_suppressed(mut self, input: std::option::Option<bool>) -> Self {
            self.is_suppressed = input;
            self
        }
        /// Appends an item to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the <code>TrustedAdvisorCheckDescription</code> object returned by the call to <code>DescribeTrustedAdvisorChecks</code>. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metadata.unwrap_or_default();
            v.push(input.into());
            self.metadata = Some(v);
            self
        }
        /// <p>Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the <code>TrustedAdvisorCheckDescription</code> object returned by the call to <code>DescribeTrustedAdvisorChecks</code>. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedAdvisorResourceDetail`](crate::model::TrustedAdvisorResourceDetail)
        pub fn build(self) -> crate::model::TrustedAdvisorResourceDetail {
            crate::model::TrustedAdvisorResourceDetail {
                status: self.status,
                region: self.region,
                resource_id: self.resource_id,
                is_suppressed: self.is_suppressed.unwrap_or_default(),
                metadata: self.metadata,
            }
        }
    }
}
impl TrustedAdvisorResourceDetail {
    /// Creates a new builder-style object to manufacture [`TrustedAdvisorResourceDetail`](crate::model::TrustedAdvisorResourceDetail)
    pub fn builder() -> crate::model::trusted_advisor_resource_detail::Builder {
        crate::model::trusted_advisor_resource_detail::Builder::default()
    }
}

/// <p>A code and name pair that represents the severity level of a support case. The available values depend on the support plan for the account. For more information, see <a href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SeverityLevel {
    /// <p>The code for case severity level.</p>
    /// <p>Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> | <code>critical</code> </p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The name of the severity level that corresponds to the severity level code.</p> <note>
    /// <p>The values returned by the API are different from the values that appear in the Amazon Web Services Support Center. For example, the API uses the code <code>low</code>, but the name appears as General guidance in Support Center. </p>
    /// <p>The following are the API code names and how they appear in the console:</p>
    /// <ul>
    /// <li> <p> <code>low</code> - General guidance</p> </li>
    /// <li> <p> <code>normal</code> - System impaired</p> </li>
    /// <li> <p> <code>high</code> - Production system impaired</p> </li>
    /// <li> <p> <code>urgent</code> - Production system down</p> </li>
    /// <li> <p> <code>critical</code> - Business-critical system down</p> </li>
    /// </ul>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl SeverityLevel {
    /// <p>The code for case severity level.</p>
    /// <p>Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> | <code>critical</code> </p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The name of the severity level that corresponds to the severity level code.</p> <note>
    /// <p>The values returned by the API are different from the values that appear in the Amazon Web Services Support Center. For example, the API uses the code <code>low</code>, but the name appears as General guidance in Support Center. </p>
    /// <p>The following are the API code names and how they appear in the console:</p>
    /// <ul>
    /// <li> <p> <code>low</code> - General guidance</p> </li>
    /// <li> <p> <code>normal</code> - System impaired</p> </li>
    /// <li> <p> <code>high</code> - Production system impaired</p> </li>
    /// <li> <p> <code>urgent</code> - Production system down</p> </li>
    /// <li> <p> <code>critical</code> - Business-critical system down</p> </li>
    /// </ul>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for SeverityLevel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SeverityLevel");
        formatter.field("code", &self.code);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`SeverityLevel`](crate::model::SeverityLevel)
pub mod severity_level {
    /// A builder for [`SeverityLevel`](crate::model::SeverityLevel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The code for case severity level.</p>
        /// <p>Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> | <code>critical</code> </p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The code for case severity level.</p>
        /// <p>Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> | <code>critical</code> </p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The name of the severity level that corresponds to the severity level code.</p> <note>
        /// <p>The values returned by the API are different from the values that appear in the Amazon Web Services Support Center. For example, the API uses the code <code>low</code>, but the name appears as General guidance in Support Center. </p>
        /// <p>The following are the API code names and how they appear in the console:</p>
        /// <ul>
        /// <li> <p> <code>low</code> - General guidance</p> </li>
        /// <li> <p> <code>normal</code> - System impaired</p> </li>
        /// <li> <p> <code>high</code> - Production system impaired</p> </li>
        /// <li> <p> <code>urgent</code> - Production system down</p> </li>
        /// <li> <p> <code>critical</code> - Business-critical system down</p> </li>
        /// </ul>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the severity level that corresponds to the severity level code.</p> <note>
        /// <p>The values returned by the API are different from the values that appear in the Amazon Web Services Support Center. For example, the API uses the code <code>low</code>, but the name appears as General guidance in Support Center. </p>
        /// <p>The following are the API code names and how they appear in the console:</p>
        /// <ul>
        /// <li> <p> <code>low</code> - General guidance</p> </li>
        /// <li> <p> <code>normal</code> - System impaired</p> </li>
        /// <li> <p> <code>high</code> - Production system impaired</p> </li>
        /// <li> <p> <code>urgent</code> - Production system down</p> </li>
        /// <li> <p> <code>critical</code> - Business-critical system down</p> </li>
        /// </ul>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`SeverityLevel`](crate::model::SeverityLevel)
        pub fn build(self) -> crate::model::SeverityLevel {
            crate::model::SeverityLevel {
                code: self.code,
                name: self.name,
            }
        }
    }
}
impl SeverityLevel {
    /// Creates a new builder-style object to manufacture [`SeverityLevel`](crate::model::SeverityLevel)
    pub fn builder() -> crate::model::severity_level::Builder {
        crate::model::severity_level::Builder::default()
    }
}

/// <p>Information about an Amazon Web Services service returned by the <code>DescribeServices</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// <p>The code for an Amazon Web Services service returned by the <code>DescribeServices</code> response. The <code>name</code> element contains the corresponding friendly name.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The friendly name for an Amazon Web Services service. The <code>code</code> element contains the corresponding code.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of categories that describe the type of support issue a case describes. Categories consist of a category name and a category code. Category names and codes are passed to Amazon Web Services Support when you call <code>CreateCase</code>.</p>
    pub categories: std::option::Option<std::vec::Vec<crate::model::Category>>,
}
impl Service {
    /// <p>The code for an Amazon Web Services service returned by the <code>DescribeServices</code> response. The <code>name</code> element contains the corresponding friendly name.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The friendly name for an Amazon Web Services service. The <code>code</code> element contains the corresponding code.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of categories that describe the type of support issue a case describes. Categories consist of a category name and a category code. Category names and codes are passed to Amazon Web Services Support when you call <code>CreateCase</code>.</p>
    pub fn categories(&self) -> std::option::Option<&[crate::model::Category]> {
        self.categories.as_deref()
    }
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("code", &self.code);
        formatter.field("name", &self.name);
        formatter.field("categories", &self.categories);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) categories: std::option::Option<std::vec::Vec<crate::model::Category>>,
    }
    impl Builder {
        /// <p>The code for an Amazon Web Services service returned by the <code>DescribeServices</code> response. The <code>name</code> element contains the corresponding friendly name.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The code for an Amazon Web Services service returned by the <code>DescribeServices</code> response. The <code>name</code> element contains the corresponding friendly name.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The friendly name for an Amazon Web Services service. The <code>code</code> element contains the corresponding code.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name for an Amazon Web Services service. The <code>code</code> element contains the corresponding code.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `categories`.
        ///
        /// To override the contents of this collection use [`set_categories`](Self::set_categories).
        ///
        /// <p>A list of categories that describe the type of support issue a case describes. Categories consist of a category name and a category code. Category names and codes are passed to Amazon Web Services Support when you call <code>CreateCase</code>.</p>
        pub fn categories(mut self, input: crate::model::Category) -> Self {
            let mut v = self.categories.unwrap_or_default();
            v.push(input);
            self.categories = Some(v);
            self
        }
        /// <p>A list of categories that describe the type of support issue a case describes. Categories consist of a category name and a category code. Category names and codes are passed to Amazon Web Services Support when you call <code>CreateCase</code>.</p>
        pub fn set_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Category>>,
        ) -> Self {
            self.categories = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                code: self.code,
                name: self.name,
                categories: self.categories,
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

/// <p>A JSON-formatted name/value pair that represents the category name and category code of the problem, selected from the <code>DescribeServices</code> response for each Amazon Web Services service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Category {
    /// <p>The category code for the support case.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The category name for the support case.</p>
    pub name: std::option::Option<std::string::String>,
}
impl Category {
    /// <p>The category code for the support case.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The category name for the support case.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for Category {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Category");
        formatter.field("code", &self.code);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Category`](crate::model::Category)
pub mod category {
    /// A builder for [`Category`](crate::model::Category)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The category code for the support case.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The category code for the support case.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The category name for the support case.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The category name for the support case.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Category`](crate::model::Category)
        pub fn build(self) -> crate::model::Category {
            crate::model::Category {
                code: self.code,
                name: self.name,
            }
        }
    }
}
impl Category {
    /// Creates a new builder-style object to manufacture [`Category`](crate::model::Category)
    pub fn builder() -> crate::model::category::Builder {
        crate::model::category::Builder::default()
    }
}

/// <p>A communication associated with a support case. The communication consists of the case ID, the message body, attachment information, the submitter of the communication, and the date and time of the communication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Communication {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub case_id: std::option::Option<std::string::String>,
    /// <p>The text of the communication between the customer and Amazon Web Services Support.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The identity of the account that submitted, or responded to, the support case. Customer entries include the role or IAM user as well as the email address. For example, "AdminRole (Role) <janedoe@example.com>
    /// . Entries from the Amazon Web Services Support team display "Amazon Web Services," and don't show an email address.
    /// </janedoe@example.com></p>
    pub submitted_by: std::option::Option<std::string::String>,
    /// <p>The time the communication was created.</p>
    pub time_created: std::option::Option<std::string::String>,
    /// <p>Information about the attachments to the case communication.</p>
    pub attachment_set: std::option::Option<std::vec::Vec<crate::model::AttachmentDetails>>,
}
impl Communication {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
    /// <p>The text of the communication between the customer and Amazon Web Services Support.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The identity of the account that submitted, or responded to, the support case. Customer entries include the role or IAM user as well as the email address. For example, "AdminRole (Role) <janedoe@example.com>
    /// . Entries from the Amazon Web Services Support team display "Amazon Web Services," and don't show an email address.
    /// </janedoe@example.com></p>
    pub fn submitted_by(&self) -> std::option::Option<&str> {
        self.submitted_by.as_deref()
    }
    /// <p>The time the communication was created.</p>
    pub fn time_created(&self) -> std::option::Option<&str> {
        self.time_created.as_deref()
    }
    /// <p>Information about the attachments to the case communication.</p>
    pub fn attachment_set(&self) -> std::option::Option<&[crate::model::AttachmentDetails]> {
        self.attachment_set.as_deref()
    }
}
impl std::fmt::Debug for Communication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Communication");
        formatter.field("case_id", &self.case_id);
        formatter.field("body", &self.body);
        formatter.field("submitted_by", &self.submitted_by);
        formatter.field("time_created", &self.time_created);
        formatter.field("attachment_set", &self.attachment_set);
        formatter.finish()
    }
}
/// See [`Communication`](crate::model::Communication)
pub mod communication {
    /// A builder for [`Communication`](crate::model::Communication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_id: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) submitted_by: std::option::Option<std::string::String>,
        pub(crate) time_created: std::option::Option<std::string::String>,
        pub(crate) attachment_set:
            std::option::Option<std::vec::Vec<crate::model::AttachmentDetails>>,
    }
    impl Builder {
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// <p>The text of the communication between the customer and Amazon Web Services Support.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The text of the communication between the customer and Amazon Web Services Support.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The identity of the account that submitted, or responded to, the support case. Customer entries include the role or IAM user as well as the email address. For example, "AdminRole (Role) <janedoe@example.com>
        /// . Entries from the Amazon Web Services Support team display "Amazon Web Services," and don't show an email address.
        /// </janedoe@example.com></p>
        pub fn submitted_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.submitted_by = Some(input.into());
            self
        }
        /// <p>The identity of the account that submitted, or responded to, the support case. Customer entries include the role or IAM user as well as the email address. For example, "AdminRole (Role) <janedoe@example.com>
        /// . Entries from the Amazon Web Services Support team display "Amazon Web Services," and don't show an email address.
        /// </janedoe@example.com></p>
        pub fn set_submitted_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.submitted_by = input;
            self
        }
        /// <p>The time the communication was created.</p>
        pub fn time_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_created = Some(input.into());
            self
        }
        /// <p>The time the communication was created.</p>
        pub fn set_time_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_created = input;
            self
        }
        /// Appends an item to `attachment_set`.
        ///
        /// To override the contents of this collection use [`set_attachment_set`](Self::set_attachment_set).
        ///
        /// <p>Information about the attachments to the case communication.</p>
        pub fn attachment_set(mut self, input: crate::model::AttachmentDetails) -> Self {
            let mut v = self.attachment_set.unwrap_or_default();
            v.push(input);
            self.attachment_set = Some(v);
            self
        }
        /// <p>Information about the attachments to the case communication.</p>
        pub fn set_attachment_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentDetails>>,
        ) -> Self {
            self.attachment_set = input;
            self
        }
        /// Consumes the builder and constructs a [`Communication`](crate::model::Communication)
        pub fn build(self) -> crate::model::Communication {
            crate::model::Communication {
                case_id: self.case_id,
                body: self.body,
                submitted_by: self.submitted_by,
                time_created: self.time_created,
                attachment_set: self.attachment_set,
            }
        }
    }
}
impl Communication {
    /// Creates a new builder-style object to manufacture [`Communication`](crate::model::Communication)
    pub fn builder() -> crate::model::communication::Builder {
        crate::model::communication::Builder::default()
    }
}

/// <p>The file name and ID of an attachment to a case communication. You can use the ID to retrieve the attachment with the <code>DescribeAttachment</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentDetails {
    /// <p>The ID of the attachment.</p>
    pub attachment_id: std::option::Option<std::string::String>,
    /// <p>The file name of the attachment.</p>
    pub file_name: std::option::Option<std::string::String>,
}
impl AttachmentDetails {
    /// <p>The ID of the attachment.</p>
    pub fn attachment_id(&self) -> std::option::Option<&str> {
        self.attachment_id.as_deref()
    }
    /// <p>The file name of the attachment.</p>
    pub fn file_name(&self) -> std::option::Option<&str> {
        self.file_name.as_deref()
    }
}
impl std::fmt::Debug for AttachmentDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentDetails");
        formatter.field("attachment_id", &self.attachment_id);
        formatter.field("file_name", &self.file_name);
        formatter.finish()
    }
}
/// See [`AttachmentDetails`](crate::model::AttachmentDetails)
pub mod attachment_details {
    /// A builder for [`AttachmentDetails`](crate::model::AttachmentDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment_id: std::option::Option<std::string::String>,
        pub(crate) file_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_id = input;
            self
        }
        /// <p>The file name of the attachment.</p>
        pub fn file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_name = Some(input.into());
            self
        }
        /// <p>The file name of the attachment.</p>
        pub fn set_file_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentDetails`](crate::model::AttachmentDetails)
        pub fn build(self) -> crate::model::AttachmentDetails {
            crate::model::AttachmentDetails {
                attachment_id: self.attachment_id,
                file_name: self.file_name,
            }
        }
    }
}
impl AttachmentDetails {
    /// Creates a new builder-style object to manufacture [`AttachmentDetails`](crate::model::AttachmentDetails)
    pub fn builder() -> crate::model::attachment_details::Builder {
        crate::model::attachment_details::Builder::default()
    }
}

/// <p>A JSON-formatted object that contains the metadata for a support case. It is contained in the response from a <code>DescribeCases</code> request. <b>CaseDetails</b> contains the following fields:</p>
/// <ul>
/// <li> <p> <b>caseId</b> - The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>.</p> </li>
/// <li> <p> <b>categoryCode</b> - The category of problem for the support case. Corresponds to the <code>CategoryCode</code> values returned by a call to <code>DescribeServices</code>.</p> </li>
/// <li> <p> <b>displayId</b> - The identifier for the case on pages in the Amazon Web Services Support Center.</p> </li>
/// <li> <p> <b>language</b> - The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p> </li>
/// <li> <p> <b>nextToken</b> - A resumption point for pagination.</p> </li>
/// <li> <p> <b>recentCommunications</b> - One or more <code>Communication</code> objects. Fields of these objects are <code>attachments</code>, <code>body</code>, <code>caseId</code>, <code>submittedBy</code>, and <code>timeCreated</code>.</p> </li>
/// <li> <p> <b>serviceCode</b> - The identifier for the Amazon Web Services service that corresponds to the service code defined in the call to <code>DescribeServices</code>.</p> </li>
/// <li> <p> <b>severityCode</b> - The severity code assigned to the case. Contains one of the values returned by the call to <code>DescribeSeverityLevels</code>. The possible values are: <code>low</code>, <code>normal</code>, <code>high</code>, <code>urgent</code>, and <code>critical</code>.</p> </li>
/// <li> <p> <b>status</b> - The status of the case in the Amazon Web Services Support Center. Valid values:</p>
/// <ul>
/// <li> <p> <code>opened</code> </p> </li>
/// <li> <p> <code>pending-customer-action</code> </p> </li>
/// <li> <p> <code>reopened</code> </p> </li>
/// <li> <p> <code>resolved</code> </p> </li>
/// <li> <p> <code>unassigned</code> </p> </li>
/// <li> <p> <code>work-in-progress</code> </p> </li>
/// </ul> </li>
/// <li> <p> <b>subject</b> - The subject line of the case.</p> </li>
/// <li> <p> <b>submittedBy</b> - The email address of the account that submitted the case.</p> </li>
/// <li> <p> <b>timeCreated</b> - The time the case was created, in ISO-8601 format.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaseDetails {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub case_id: std::option::Option<std::string::String>,
    /// <p>The ID displayed for the case in the Amazon Web Services Support Center. This is a numeric string.</p>
    pub display_id: std::option::Option<std::string::String>,
    /// <p>The subject line for the case in the Amazon Web Services Support Center.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The status of the case.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li> <p> <code>opened</code> </p> </li>
    /// <li> <p> <code>pending-customer-action</code> </p> </li>
    /// <li> <p> <code>reopened</code> </p> </li>
    /// <li> <p> <code>resolved</code> </p> </li>
    /// <li> <p> <code>unassigned</code> </p> </li>
    /// <li> <p> <code>work-in-progress</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The code for the Amazon Web Services service. You can get a list of codes and the corresponding service names by calling <code>DescribeServices</code>.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The category of problem for the support case.</p>
    pub category_code: std::option::Option<std::string::String>,
    /// <p>The code for the severity level returned by the call to <code>DescribeSeverityLevels</code>.</p>
    pub severity_code: std::option::Option<std::string::String>,
    /// <p>The email address of the account that submitted the case.</p>
    pub submitted_by: std::option::Option<std::string::String>,
    /// <p>The time that the case was created in the Amazon Web Services Support Center.</p>
    pub time_created: std::option::Option<std::string::String>,
    /// <p>The five most recent communications between you and Amazon Web Services Support Center, including the IDs of any attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.</p>
    pub recent_communications: std::option::Option<crate::model::RecentCaseCommunications>,
    /// <p>The email addresses that receive copies of communication about the case.</p>
    pub cc_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub language: std::option::Option<std::string::String>,
}
impl CaseDetails {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
    /// <p>The ID displayed for the case in the Amazon Web Services Support Center. This is a numeric string.</p>
    pub fn display_id(&self) -> std::option::Option<&str> {
        self.display_id.as_deref()
    }
    /// <p>The subject line for the case in the Amazon Web Services Support Center.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The status of the case.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li> <p> <code>opened</code> </p> </li>
    /// <li> <p> <code>pending-customer-action</code> </p> </li>
    /// <li> <p> <code>reopened</code> </p> </li>
    /// <li> <p> <code>resolved</code> </p> </li>
    /// <li> <p> <code>unassigned</code> </p> </li>
    /// <li> <p> <code>work-in-progress</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The code for the Amazon Web Services service. You can get a list of codes and the corresponding service names by calling <code>DescribeServices</code>.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The category of problem for the support case.</p>
    pub fn category_code(&self) -> std::option::Option<&str> {
        self.category_code.as_deref()
    }
    /// <p>The code for the severity level returned by the call to <code>DescribeSeverityLevels</code>.</p>
    pub fn severity_code(&self) -> std::option::Option<&str> {
        self.severity_code.as_deref()
    }
    /// <p>The email address of the account that submitted the case.</p>
    pub fn submitted_by(&self) -> std::option::Option<&str> {
        self.submitted_by.as_deref()
    }
    /// <p>The time that the case was created in the Amazon Web Services Support Center.</p>
    pub fn time_created(&self) -> std::option::Option<&str> {
        self.time_created.as_deref()
    }
    /// <p>The five most recent communications between you and Amazon Web Services Support Center, including the IDs of any attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.</p>
    pub fn recent_communications(
        &self,
    ) -> std::option::Option<&crate::model::RecentCaseCommunications> {
        self.recent_communications.as_ref()
    }
    /// <p>The email addresses that receive copies of communication about the case.</p>
    pub fn cc_email_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.cc_email_addresses.as_deref()
    }
    /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for CaseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaseDetails");
        formatter.field("case_id", &self.case_id);
        formatter.field("display_id", &self.display_id);
        formatter.field("subject", &self.subject);
        formatter.field("status", &self.status);
        formatter.field("service_code", &self.service_code);
        formatter.field("category_code", &self.category_code);
        formatter.field("severity_code", &self.severity_code);
        formatter.field("submitted_by", &self.submitted_by);
        formatter.field("time_created", &self.time_created);
        formatter.field("recent_communications", &self.recent_communications);
        formatter.field("cc_email_addresses", &self.cc_email_addresses);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}
/// See [`CaseDetails`](crate::model::CaseDetails)
pub mod case_details {
    /// A builder for [`CaseDetails`](crate::model::CaseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_id: std::option::Option<std::string::String>,
        pub(crate) display_id: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) category_code: std::option::Option<std::string::String>,
        pub(crate) severity_code: std::option::Option<std::string::String>,
        pub(crate) submitted_by: std::option::Option<std::string::String>,
        pub(crate) time_created: std::option::Option<std::string::String>,
        pub(crate) recent_communications:
            std::option::Option<crate::model::RecentCaseCommunications>,
        pub(crate) cc_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// <p>The ID displayed for the case in the Amazon Web Services Support Center. This is a numeric string.</p>
        pub fn display_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_id = Some(input.into());
            self
        }
        /// <p>The ID displayed for the case in the Amazon Web Services Support Center. This is a numeric string.</p>
        pub fn set_display_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_id = input;
            self
        }
        /// <p>The subject line for the case in the Amazon Web Services Support Center.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject line for the case in the Amazon Web Services Support Center.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The status of the case.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>opened</code> </p> </li>
        /// <li> <p> <code>pending-customer-action</code> </p> </li>
        /// <li> <p> <code>reopened</code> </p> </li>
        /// <li> <p> <code>resolved</code> </p> </li>
        /// <li> <p> <code>unassigned</code> </p> </li>
        /// <li> <p> <code>work-in-progress</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the case.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>opened</code> </p> </li>
        /// <li> <p> <code>pending-customer-action</code> </p> </li>
        /// <li> <p> <code>reopened</code> </p> </li>
        /// <li> <p> <code>resolved</code> </p> </li>
        /// <li> <p> <code>unassigned</code> </p> </li>
        /// <li> <p> <code>work-in-progress</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The code for the Amazon Web Services service. You can get a list of codes and the corresponding service names by calling <code>DescribeServices</code>.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The code for the Amazon Web Services service. You can get a list of codes and the corresponding service names by calling <code>DescribeServices</code>.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The category of problem for the support case.</p>
        pub fn category_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.category_code = Some(input.into());
            self
        }
        /// <p>The category of problem for the support case.</p>
        pub fn set_category_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.category_code = input;
            self
        }
        /// <p>The code for the severity level returned by the call to <code>DescribeSeverityLevels</code>.</p>
        pub fn severity_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity_code = Some(input.into());
            self
        }
        /// <p>The code for the severity level returned by the call to <code>DescribeSeverityLevels</code>.</p>
        pub fn set_severity_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.severity_code = input;
            self
        }
        /// <p>The email address of the account that submitted the case.</p>
        pub fn submitted_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.submitted_by = Some(input.into());
            self
        }
        /// <p>The email address of the account that submitted the case.</p>
        pub fn set_submitted_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.submitted_by = input;
            self
        }
        /// <p>The time that the case was created in the Amazon Web Services Support Center.</p>
        pub fn time_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_created = Some(input.into());
            self
        }
        /// <p>The time that the case was created in the Amazon Web Services Support Center.</p>
        pub fn set_time_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_created = input;
            self
        }
        /// <p>The five most recent communications between you and Amazon Web Services Support Center, including the IDs of any attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.</p>
        pub fn recent_communications(
            mut self,
            input: crate::model::RecentCaseCommunications,
        ) -> Self {
            self.recent_communications = Some(input);
            self
        }
        /// <p>The five most recent communications between you and Amazon Web Services Support Center, including the IDs of any attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.</p>
        pub fn set_recent_communications(
            mut self,
            input: std::option::Option<crate::model::RecentCaseCommunications>,
        ) -> Self {
            self.recent_communications = input;
            self
        }
        /// Appends an item to `cc_email_addresses`.
        ///
        /// To override the contents of this collection use [`set_cc_email_addresses`](Self::set_cc_email_addresses).
        ///
        /// <p>The email addresses that receive copies of communication about the case.</p>
        pub fn cc_email_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cc_email_addresses.unwrap_or_default();
            v.push(input.into());
            self.cc_email_addresses = Some(v);
            self
        }
        /// <p>The email addresses that receive copies of communication about the case.</p>
        pub fn set_cc_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cc_email_addresses = input;
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`CaseDetails`](crate::model::CaseDetails)
        pub fn build(self) -> crate::model::CaseDetails {
            crate::model::CaseDetails {
                case_id: self.case_id,
                display_id: self.display_id,
                subject: self.subject,
                status: self.status,
                service_code: self.service_code,
                category_code: self.category_code,
                severity_code: self.severity_code,
                submitted_by: self.submitted_by,
                time_created: self.time_created,
                recent_communications: self.recent_communications,
                cc_email_addresses: self.cc_email_addresses,
                language: self.language,
            }
        }
    }
}
impl CaseDetails {
    /// Creates a new builder-style object to manufacture [`CaseDetails`](crate::model::CaseDetails)
    pub fn builder() -> crate::model::case_details::Builder {
        crate::model::case_details::Builder::default()
    }
}

/// <p>The five most recent communications associated with the case.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecentCaseCommunications {
    /// <p>The five most recent communications associated with the case.</p>
    pub communications: std::option::Option<std::vec::Vec<crate::model::Communication>>,
    /// <p>A resumption point for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl RecentCaseCommunications {
    /// <p>The five most recent communications associated with the case.</p>
    pub fn communications(&self) -> std::option::Option<&[crate::model::Communication]> {
        self.communications.as_deref()
    }
    /// <p>A resumption point for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for RecentCaseCommunications {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecentCaseCommunications");
        formatter.field("communications", &self.communications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`RecentCaseCommunications`](crate::model::RecentCaseCommunications)
pub mod recent_case_communications {
    /// A builder for [`RecentCaseCommunications`](crate::model::RecentCaseCommunications)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) communications: std::option::Option<std::vec::Vec<crate::model::Communication>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `communications`.
        ///
        /// To override the contents of this collection use [`set_communications`](Self::set_communications).
        ///
        /// <p>The five most recent communications associated with the case.</p>
        pub fn communications(mut self, input: crate::model::Communication) -> Self {
            let mut v = self.communications.unwrap_or_default();
            v.push(input);
            self.communications = Some(v);
            self
        }
        /// <p>The five most recent communications associated with the case.</p>
        pub fn set_communications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Communication>>,
        ) -> Self {
            self.communications = input;
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`RecentCaseCommunications`](crate::model::RecentCaseCommunications)
        pub fn build(self) -> crate::model::RecentCaseCommunications {
            crate::model::RecentCaseCommunications {
                communications: self.communications,
                next_token: self.next_token,
            }
        }
    }
}
impl RecentCaseCommunications {
    /// Creates a new builder-style object to manufacture [`RecentCaseCommunications`](crate::model::RecentCaseCommunications)
    pub fn builder() -> crate::model::recent_case_communications::Builder {
        crate::model::recent_case_communications::Builder::default()
    }
}

/// <p>An attachment to a case communication. The attachment consists of the file name and the content of the file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attachment {
    /// <p>The name of the attachment file.</p>
    pub file_name: std::option::Option<std::string::String>,
    /// <p>The content of the attachment file.</p>
    pub data: std::option::Option<aws_smithy_types::Blob>,
}
impl Attachment {
    /// <p>The name of the attachment file.</p>
    pub fn file_name(&self) -> std::option::Option<&str> {
        self.file_name.as_deref()
    }
    /// <p>The content of the attachment file.</p>
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
}
impl std::fmt::Debug for Attachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attachment");
        formatter.field("file_name", &self.file_name);
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`Attachment`](crate::model::Attachment)
pub mod attachment {
    /// A builder for [`Attachment`](crate::model::Attachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_name: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The name of the attachment file.</p>
        pub fn file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_name = Some(input.into());
            self
        }
        /// <p>The name of the attachment file.</p>
        pub fn set_file_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_name = input;
            self
        }
        /// <p>The content of the attachment file.</p>
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The content of the attachment file.</p>
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`Attachment`](crate::model::Attachment)
        pub fn build(self) -> crate::model::Attachment {
            crate::model::Attachment {
                file_name: self.file_name,
                data: self.data,
            }
        }
    }
}
impl Attachment {
    /// Creates a new builder-style object to manufacture [`Attachment`](crate::model::Attachment)
    pub fn builder() -> crate::model::attachment::Builder {
        crate::model::attachment::Builder::default()
    }
}
