// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The status of the case returned by the <code>ResolveCase</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveCaseOutput {
    /// <p>The status of the case when the <code>ResolveCase</code> request was sent.</p>
    pub initial_case_status: std::option::Option<std::string::String>,
    /// <p>The status of the case after the <code>ResolveCase</code> request was processed.</p>
    pub final_case_status: std::option::Option<std::string::String>,
}
impl ResolveCaseOutput {
    /// <p>The status of the case when the <code>ResolveCase</code> request was sent.</p>
    pub fn initial_case_status(&self) -> std::option::Option<&str> {
        self.initial_case_status.as_deref()
    }
    /// <p>The status of the case after the <code>ResolveCase</code> request was processed.</p>
    pub fn final_case_status(&self) -> std::option::Option<&str> {
        self.final_case_status.as_deref()
    }
}
impl std::fmt::Debug for ResolveCaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveCaseOutput");
        formatter.field("initial_case_status", &self.initial_case_status);
        formatter.field("final_case_status", &self.final_case_status);
        formatter.finish()
    }
}
/// See [`ResolveCaseOutput`](crate::output::ResolveCaseOutput)
pub mod resolve_case_output {
    /// A builder for [`ResolveCaseOutput`](crate::output::ResolveCaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_case_status: std::option::Option<std::string::String>,
        pub(crate) final_case_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the case when the <code>ResolveCase</code> request was sent.</p>
        pub fn initial_case_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_case_status = Some(input.into());
            self
        }
        /// <p>The status of the case when the <code>ResolveCase</code> request was sent.</p>
        pub fn set_initial_case_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_case_status = input;
            self
        }
        /// <p>The status of the case after the <code>ResolveCase</code> request was processed.</p>
        pub fn final_case_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_case_status = Some(input.into());
            self
        }
        /// <p>The status of the case after the <code>ResolveCase</code> request was processed.</p>
        pub fn set_final_case_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_case_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveCaseOutput`](crate::output::ResolveCaseOutput)
        pub fn build(self) -> crate::output::ResolveCaseOutput {
            crate::output::ResolveCaseOutput {
                initial_case_status: self.initial_case_status,
                final_case_status: self.final_case_status,
            }
        }
    }
}
impl ResolveCaseOutput {
    /// Creates a new builder-style object to manufacture [`ResolveCaseOutput`](crate::output::ResolveCaseOutput)
    pub fn builder() -> crate::output::resolve_case_output::Builder {
        crate::output::resolve_case_output::Builder::default()
    }
}

/// <p>The current refresh status of a Trusted Advisor check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshTrustedAdvisorCheckOutput {
    /// <p>The current refresh status for a check, including the amount of time until the check is eligible for refresh.</p>
    pub status: std::option::Option<crate::model::TrustedAdvisorCheckRefreshStatus>,
}
impl RefreshTrustedAdvisorCheckOutput {
    /// <p>The current refresh status for a check, including the amount of time until the check is eligible for refresh.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TrustedAdvisorCheckRefreshStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for RefreshTrustedAdvisorCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshTrustedAdvisorCheckOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RefreshTrustedAdvisorCheckOutput`](crate::output::RefreshTrustedAdvisorCheckOutput)
pub mod refresh_trusted_advisor_check_output {
    /// A builder for [`RefreshTrustedAdvisorCheckOutput`](crate::output::RefreshTrustedAdvisorCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::TrustedAdvisorCheckRefreshStatus>,
    }
    impl Builder {
        /// <p>The current refresh status for a check, including the amount of time until the check is eligible for refresh.</p>
        pub fn status(mut self, input: crate::model::TrustedAdvisorCheckRefreshStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current refresh status for a check, including the amount of time until the check is eligible for refresh.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TrustedAdvisorCheckRefreshStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshTrustedAdvisorCheckOutput`](crate::output::RefreshTrustedAdvisorCheckOutput)
        pub fn build(self) -> crate::output::RefreshTrustedAdvisorCheckOutput {
            crate::output::RefreshTrustedAdvisorCheckOutput {
                status: self.status,
            }
        }
    }
}
impl RefreshTrustedAdvisorCheckOutput {
    /// Creates a new builder-style object to manufacture [`RefreshTrustedAdvisorCheckOutput`](crate::output::RefreshTrustedAdvisorCheckOutput)
    pub fn builder() -> crate::output::refresh_trusted_advisor_check_output::Builder {
        crate::output::refresh_trusted_advisor_check_output::Builder::default()
    }
}

/// <p>The summaries of the Trusted Advisor checks returned by the <code>DescribeTrustedAdvisorCheckSummaries</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorCheckSummariesOutput {
    /// <p>The summary information for the requested Trusted Advisor checks.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckSummary>>,
}
impl DescribeTrustedAdvisorCheckSummariesOutput {
    /// <p>The summary information for the requested Trusted Advisor checks.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::TrustedAdvisorCheckSummary]> {
        self.summaries.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorCheckSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorCheckSummariesOutput");
        formatter.field("summaries", &self.summaries);
        formatter.finish()
    }
}
/// See [`DescribeTrustedAdvisorCheckSummariesOutput`](crate::output::DescribeTrustedAdvisorCheckSummariesOutput)
pub mod describe_trusted_advisor_check_summaries_output {
    /// A builder for [`DescribeTrustedAdvisorCheckSummariesOutput`](crate::output::DescribeTrustedAdvisorCheckSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries:
            std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckSummary>>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>The summary information for the requested Trusted Advisor checks.</p>
        pub fn summaries(mut self, input: crate::model::TrustedAdvisorCheckSummary) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input);
            self.summaries = Some(v);
            self
        }
        /// <p>The summary information for the requested Trusted Advisor checks.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorCheckSummariesOutput`](crate::output::DescribeTrustedAdvisorCheckSummariesOutput)
        pub fn build(self) -> crate::output::DescribeTrustedAdvisorCheckSummariesOutput {
            crate::output::DescribeTrustedAdvisorCheckSummariesOutput {
                summaries: self.summaries,
            }
        }
    }
}
impl DescribeTrustedAdvisorCheckSummariesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorCheckSummariesOutput`](crate::output::DescribeTrustedAdvisorCheckSummariesOutput)
    pub fn builder() -> crate::output::describe_trusted_advisor_check_summaries_output::Builder {
        crate::output::describe_trusted_advisor_check_summaries_output::Builder::default()
    }
}

/// <p>Information about the Trusted Advisor checks returned by the <code>DescribeTrustedAdvisorChecks</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorChecksOutput {
    /// <p>Information about all available Trusted Advisor checks.</p>
    pub checks: std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckDescription>>,
}
impl DescribeTrustedAdvisorChecksOutput {
    /// <p>Information about all available Trusted Advisor checks.</p>
    pub fn checks(&self) -> std::option::Option<&[crate::model::TrustedAdvisorCheckDescription]> {
        self.checks.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorChecksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorChecksOutput");
        formatter.field("checks", &self.checks);
        formatter.finish()
    }
}
/// See [`DescribeTrustedAdvisorChecksOutput`](crate::output::DescribeTrustedAdvisorChecksOutput)
pub mod describe_trusted_advisor_checks_output {
    /// A builder for [`DescribeTrustedAdvisorChecksOutput`](crate::output::DescribeTrustedAdvisorChecksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) checks:
            std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckDescription>>,
    }
    impl Builder {
        /// Appends an item to `checks`.
        ///
        /// To override the contents of this collection use [`set_checks`](Self::set_checks).
        ///
        /// <p>Information about all available Trusted Advisor checks.</p>
        pub fn checks(mut self, input: crate::model::TrustedAdvisorCheckDescription) -> Self {
            let mut v = self.checks.unwrap_or_default();
            v.push(input);
            self.checks = Some(v);
            self
        }
        /// <p>Information about all available Trusted Advisor checks.</p>
        pub fn set_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckDescription>>,
        ) -> Self {
            self.checks = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorChecksOutput`](crate::output::DescribeTrustedAdvisorChecksOutput)
        pub fn build(self) -> crate::output::DescribeTrustedAdvisorChecksOutput {
            crate::output::DescribeTrustedAdvisorChecksOutput {
                checks: self.checks,
            }
        }
    }
}
impl DescribeTrustedAdvisorChecksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorChecksOutput`](crate::output::DescribeTrustedAdvisorChecksOutput)
    pub fn builder() -> crate::output::describe_trusted_advisor_checks_output::Builder {
        crate::output::describe_trusted_advisor_checks_output::Builder::default()
    }
}

/// <p>The result of the Trusted Advisor check returned by the <code>DescribeTrustedAdvisorCheckResult</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorCheckResultOutput {
    /// <p>The detailed results of the Trusted Advisor check.</p>
    pub result: std::option::Option<crate::model::TrustedAdvisorCheckResult>,
}
impl DescribeTrustedAdvisorCheckResultOutput {
    /// <p>The detailed results of the Trusted Advisor check.</p>
    pub fn result(&self) -> std::option::Option<&crate::model::TrustedAdvisorCheckResult> {
        self.result.as_ref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorCheckResultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorCheckResultOutput");
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`DescribeTrustedAdvisorCheckResultOutput`](crate::output::DescribeTrustedAdvisorCheckResultOutput)
pub mod describe_trusted_advisor_check_result_output {
    /// A builder for [`DescribeTrustedAdvisorCheckResultOutput`](crate::output::DescribeTrustedAdvisorCheckResultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result: std::option::Option<crate::model::TrustedAdvisorCheckResult>,
    }
    impl Builder {
        /// <p>The detailed results of the Trusted Advisor check.</p>
        pub fn result(mut self, input: crate::model::TrustedAdvisorCheckResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The detailed results of the Trusted Advisor check.</p>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::TrustedAdvisorCheckResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorCheckResultOutput`](crate::output::DescribeTrustedAdvisorCheckResultOutput)
        pub fn build(self) -> crate::output::DescribeTrustedAdvisorCheckResultOutput {
            crate::output::DescribeTrustedAdvisorCheckResultOutput {
                result: self.result,
            }
        }
    }
}
impl DescribeTrustedAdvisorCheckResultOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorCheckResultOutput`](crate::output::DescribeTrustedAdvisorCheckResultOutput)
    pub fn builder() -> crate::output::describe_trusted_advisor_check_result_output::Builder {
        crate::output::describe_trusted_advisor_check_result_output::Builder::default()
    }
}

/// <p>The statuses of the Trusted Advisor checks returned by the <code>DescribeTrustedAdvisorCheckRefreshStatuses</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustedAdvisorCheckRefreshStatusesOutput {
    /// <p>The refresh status of the specified Trusted Advisor checks.</p>
    pub statuses:
        std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckRefreshStatus>>,
}
impl DescribeTrustedAdvisorCheckRefreshStatusesOutput {
    /// <p>The refresh status of the specified Trusted Advisor checks.</p>
    pub fn statuses(
        &self,
    ) -> std::option::Option<&[crate::model::TrustedAdvisorCheckRefreshStatus]> {
        self.statuses.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustedAdvisorCheckRefreshStatusesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustedAdvisorCheckRefreshStatusesOutput");
        formatter.field("statuses", &self.statuses);
        formatter.finish()
    }
}
/// See [`DescribeTrustedAdvisorCheckRefreshStatusesOutput`](crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput)
pub mod describe_trusted_advisor_check_refresh_statuses_output {
    /// A builder for [`DescribeTrustedAdvisorCheckRefreshStatusesOutput`](crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statuses:
            std::option::Option<std::vec::Vec<crate::model::TrustedAdvisorCheckRefreshStatus>>,
    }
    impl Builder {
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p>The refresh status of the specified Trusted Advisor checks.</p>
        pub fn statuses(mut self, input: crate::model::TrustedAdvisorCheckRefreshStatus) -> Self {
            let mut v = self.statuses.unwrap_or_default();
            v.push(input);
            self.statuses = Some(v);
            self
        }
        /// <p>The refresh status of the specified Trusted Advisor checks.</p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::TrustedAdvisorCheckRefreshStatus>,
            >,
        ) -> Self {
            self.statuses = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustedAdvisorCheckRefreshStatusesOutput`](crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput)
        pub fn build(self) -> crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput {
            crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput {
                statuses: self.statuses,
            }
        }
    }
}
impl DescribeTrustedAdvisorCheckRefreshStatusesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrustedAdvisorCheckRefreshStatusesOutput`](crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput)
    pub fn builder(
    ) -> crate::output::describe_trusted_advisor_check_refresh_statuses_output::Builder {
        crate::output::describe_trusted_advisor_check_refresh_statuses_output::Builder::default()
    }
}

/// <p>The list of severity levels returned by the <code>DescribeSeverityLevels</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSeverityLevelsOutput {
    /// <p>The available severity levels for the support case. Available severity levels are defined by your service level agreement with Amazon Web Services.</p>
    pub severity_levels: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
}
impl DescribeSeverityLevelsOutput {
    /// <p>The available severity levels for the support case. Available severity levels are defined by your service level agreement with Amazon Web Services.</p>
    pub fn severity_levels(&self) -> std::option::Option<&[crate::model::SeverityLevel]> {
        self.severity_levels.as_deref()
    }
}
impl std::fmt::Debug for DescribeSeverityLevelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSeverityLevelsOutput");
        formatter.field("severity_levels", &self.severity_levels);
        formatter.finish()
    }
}
/// See [`DescribeSeverityLevelsOutput`](crate::output::DescribeSeverityLevelsOutput)
pub mod describe_severity_levels_output {
    /// A builder for [`DescribeSeverityLevelsOutput`](crate::output::DescribeSeverityLevelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) severity_levels: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
    }
    impl Builder {
        /// Appends an item to `severity_levels`.
        ///
        /// To override the contents of this collection use [`set_severity_levels`](Self::set_severity_levels).
        ///
        /// <p>The available severity levels for the support case. Available severity levels are defined by your service level agreement with Amazon Web Services.</p>
        pub fn severity_levels(mut self, input: crate::model::SeverityLevel) -> Self {
            let mut v = self.severity_levels.unwrap_or_default();
            v.push(input);
            self.severity_levels = Some(v);
            self
        }
        /// <p>The available severity levels for the support case. Available severity levels are defined by your service level agreement with Amazon Web Services.</p>
        pub fn set_severity_levels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
        ) -> Self {
            self.severity_levels = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSeverityLevelsOutput`](crate::output::DescribeSeverityLevelsOutput)
        pub fn build(self) -> crate::output::DescribeSeverityLevelsOutput {
            crate::output::DescribeSeverityLevelsOutput {
                severity_levels: self.severity_levels,
            }
        }
    }
}
impl DescribeSeverityLevelsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSeverityLevelsOutput`](crate::output::DescribeSeverityLevelsOutput)
    pub fn builder() -> crate::output::describe_severity_levels_output::Builder {
        crate::output::describe_severity_levels_output::Builder::default()
    }
}

/// <p>The list of Amazon Web Services services returned by the <code>DescribeServices</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServicesOutput {
    /// <p>A JSON-formatted list of Amazon Web Services services.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::Service>>,
}
impl DescribeServicesOutput {
    /// <p>A JSON-formatted list of Amazon Web Services services.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::Service]> {
        self.services.as_deref()
    }
}
impl std::fmt::Debug for DescribeServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServicesOutput");
        formatter.field("services", &self.services);
        formatter.finish()
    }
}
/// See [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
pub mod describe_services_output {
    /// A builder for [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::Service>>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>A JSON-formatted list of Amazon Web Services services.</p>
        pub fn services(mut self, input: crate::model::Service) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input);
            self.services = Some(v);
            self
        }
        /// <p>A JSON-formatted list of Amazon Web Services services.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Service>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
        pub fn build(self) -> crate::output::DescribeServicesOutput {
            crate::output::DescribeServicesOutput {
                services: self.services,
            }
        }
    }
}
impl DescribeServicesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
    pub fn builder() -> crate::output::describe_services_output::Builder {
        crate::output::describe_services_output::Builder::default()
    }
}

/// <p>The communications returned by the <code>DescribeCommunications</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCommunicationsOutput {
    /// <p>The communications for the case.</p>
    pub communications: std::option::Option<std::vec::Vec<crate::model::Communication>>,
    /// <p>A resumption point for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeCommunicationsOutput {
    /// <p>The communications for the case.</p>
    pub fn communications(&self) -> std::option::Option<&[crate::model::Communication]> {
        self.communications.as_deref()
    }
    /// <p>A resumption point for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeCommunicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCommunicationsOutput");
        formatter.field("communications", &self.communications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeCommunicationsOutput`](crate::output::DescribeCommunicationsOutput)
pub mod describe_communications_output {
    /// A builder for [`DescribeCommunicationsOutput`](crate::output::DescribeCommunicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) communications: std::option::Option<std::vec::Vec<crate::model::Communication>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `communications`.
        ///
        /// To override the contents of this collection use [`set_communications`](Self::set_communications).
        ///
        /// <p>The communications for the case.</p>
        pub fn communications(mut self, input: crate::model::Communication) -> Self {
            let mut v = self.communications.unwrap_or_default();
            v.push(input);
            self.communications = Some(v);
            self
        }
        /// <p>The communications for the case.</p>
        pub fn set_communications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Communication>>,
        ) -> Self {
            self.communications = input;
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCommunicationsOutput`](crate::output::DescribeCommunicationsOutput)
        pub fn build(self) -> crate::output::DescribeCommunicationsOutput {
            crate::output::DescribeCommunicationsOutput {
                communications: self.communications,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeCommunicationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCommunicationsOutput`](crate::output::DescribeCommunicationsOutput)
    pub fn builder() -> crate::output::describe_communications_output::Builder {
        crate::output::describe_communications_output::Builder::default()
    }
}

/// <p>Returns an array of <a href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> objects and a <code>nextToken</code> that defines a point for pagination in the result set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCasesOutput {
    /// <p>The details for the cases that match the request.</p>
    pub cases: std::option::Option<std::vec::Vec<crate::model::CaseDetails>>,
    /// <p>A resumption point for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeCasesOutput {
    /// <p>The details for the cases that match the request.</p>
    pub fn cases(&self) -> std::option::Option<&[crate::model::CaseDetails]> {
        self.cases.as_deref()
    }
    /// <p>A resumption point for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeCasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCasesOutput");
        formatter.field("cases", &self.cases);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeCasesOutput`](crate::output::DescribeCasesOutput)
pub mod describe_cases_output {
    /// A builder for [`DescribeCasesOutput`](crate::output::DescribeCasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cases: std::option::Option<std::vec::Vec<crate::model::CaseDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cases`.
        ///
        /// To override the contents of this collection use [`set_cases`](Self::set_cases).
        ///
        /// <p>The details for the cases that match the request.</p>
        pub fn cases(mut self, input: crate::model::CaseDetails) -> Self {
            let mut v = self.cases.unwrap_or_default();
            v.push(input);
            self.cases = Some(v);
            self
        }
        /// <p>The details for the cases that match the request.</p>
        pub fn set_cases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaseDetails>>,
        ) -> Self {
            self.cases = input;
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCasesOutput`](crate::output::DescribeCasesOutput)
        pub fn build(self) -> crate::output::DescribeCasesOutput {
            crate::output::DescribeCasesOutput {
                cases: self.cases,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeCasesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCasesOutput`](crate::output::DescribeCasesOutput)
    pub fn builder() -> crate::output::describe_cases_output::Builder {
        crate::output::describe_cases_output::Builder::default()
    }
}

/// <p>The content and file name of the attachment returned by the <code>DescribeAttachment</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAttachmentOutput {
    /// <p>This object includes the attachment content and file name.</p>
    /// <p>In the previous response syntax, the value for the <code>data</code> parameter appears as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
    pub attachment: std::option::Option<crate::model::Attachment>,
}
impl DescribeAttachmentOutput {
    /// <p>This object includes the attachment content and file name.</p>
    /// <p>In the previous response syntax, the value for the <code>data</code> parameter appears as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
}
impl std::fmt::Debug for DescribeAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAttachmentOutput");
        formatter.field("attachment", &self.attachment);
        formatter.finish()
    }
}
/// See [`DescribeAttachmentOutput`](crate::output::DescribeAttachmentOutput)
pub mod describe_attachment_output {
    /// A builder for [`DescribeAttachmentOutput`](crate::output::DescribeAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
    }
    impl Builder {
        /// <p>This object includes the attachment content and file name.</p>
        /// <p>In the previous response syntax, the value for the <code>data</code> parameter appears as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>This object includes the attachment content and file name.</p>
        /// <p>In the previous response syntax, the value for the <code>data</code> parameter appears as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAttachmentOutput`](crate::output::DescribeAttachmentOutput)
        pub fn build(self) -> crate::output::DescribeAttachmentOutput {
            crate::output::DescribeAttachmentOutput {
                attachment: self.attachment,
            }
        }
    }
}
impl DescribeAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAttachmentOutput`](crate::output::DescribeAttachmentOutput)
    pub fn builder() -> crate::output::describe_attachment_output::Builder {
        crate::output::describe_attachment_output::Builder::default()
    }
}

/// <p>The support case ID returned by a successful completion of the <code>CreateCase</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCaseOutput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string in the following format: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub case_id: std::option::Option<std::string::String>,
}
impl CreateCaseOutput {
    /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string in the following format: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
}
impl std::fmt::Debug for CreateCaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCaseOutput");
        formatter.field("case_id", &self.case_id);
        formatter.finish()
    }
}
/// See [`CreateCaseOutput`](crate::output::CreateCaseOutput)
pub mod create_case_output {
    /// A builder for [`CreateCaseOutput`](crate::output::CreateCaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string in the following format: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string in the following format: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCaseOutput`](crate::output::CreateCaseOutput)
        pub fn build(self) -> crate::output::CreateCaseOutput {
            crate::output::CreateCaseOutput {
                case_id: self.case_id,
            }
        }
    }
}
impl CreateCaseOutput {
    /// Creates a new builder-style object to manufacture [`CreateCaseOutput`](crate::output::CreateCaseOutput)
    pub fn builder() -> crate::output::create_case_output::Builder {
        crate::output::create_case_output::Builder::default()
    }
}

/// <p>The result of the <code>AddCommunicationToCase</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddCommunicationToCaseOutput {
    /// <p>True if <code>AddCommunicationToCase</code> succeeds. Otherwise, returns an error.</p>
    pub result: bool,
}
impl AddCommunicationToCaseOutput {
    /// <p>True if <code>AddCommunicationToCase</code> succeeds. Otherwise, returns an error.</p>
    pub fn result(&self) -> bool {
        self.result
    }
}
impl std::fmt::Debug for AddCommunicationToCaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddCommunicationToCaseOutput");
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`AddCommunicationToCaseOutput`](crate::output::AddCommunicationToCaseOutput)
pub mod add_communication_to_case_output {
    /// A builder for [`AddCommunicationToCaseOutput`](crate::output::AddCommunicationToCaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>True if <code>AddCommunicationToCase</code> succeeds. Otherwise, returns an error.</p>
        pub fn result(mut self, input: bool) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>True if <code>AddCommunicationToCase</code> succeeds. Otherwise, returns an error.</p>
        pub fn set_result(mut self, input: std::option::Option<bool>) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`AddCommunicationToCaseOutput`](crate::output::AddCommunicationToCaseOutput)
        pub fn build(self) -> crate::output::AddCommunicationToCaseOutput {
            crate::output::AddCommunicationToCaseOutput {
                result: self.result.unwrap_or_default(),
            }
        }
    }
}
impl AddCommunicationToCaseOutput {
    /// Creates a new builder-style object to manufacture [`AddCommunicationToCaseOutput`](crate::output::AddCommunicationToCaseOutput)
    pub fn builder() -> crate::output::add_communication_to_case_output::Builder {
        crate::output::add_communication_to_case_output::Builder::default()
    }
}

/// <p>The ID and expiry time of the attachment set returned by the <code>AddAttachmentsToSet</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddAttachmentsToSetOutput {
    /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the attachments are added to the specified set, if it exists.</p>
    pub attachment_set_id: std::option::Option<std::string::String>,
    /// <p>The time and date when the attachment set expires.</p>
    pub expiry_time: std::option::Option<std::string::String>,
}
impl AddAttachmentsToSetOutput {
    /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the attachments are added to the specified set, if it exists.</p>
    pub fn attachment_set_id(&self) -> std::option::Option<&str> {
        self.attachment_set_id.as_deref()
    }
    /// <p>The time and date when the attachment set expires.</p>
    pub fn expiry_time(&self) -> std::option::Option<&str> {
        self.expiry_time.as_deref()
    }
}
impl std::fmt::Debug for AddAttachmentsToSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddAttachmentsToSetOutput");
        formatter.field("attachment_set_id", &self.attachment_set_id);
        formatter.field("expiry_time", &self.expiry_time);
        formatter.finish()
    }
}
/// See [`AddAttachmentsToSetOutput`](crate::output::AddAttachmentsToSetOutput)
pub mod add_attachments_to_set_output {
    /// A builder for [`AddAttachmentsToSetOutput`](crate::output::AddAttachmentsToSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment_set_id: std::option::Option<std::string::String>,
        pub(crate) expiry_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the attachments are added to the specified set, if it exists.</p>
        pub fn attachment_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the attachments are added to the specified set, if it exists.</p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_set_id = input;
            self
        }
        /// <p>The time and date when the attachment set expires.</p>
        pub fn expiry_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiry_time = Some(input.into());
            self
        }
        /// <p>The time and date when the attachment set expires.</p>
        pub fn set_expiry_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expiry_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AddAttachmentsToSetOutput`](crate::output::AddAttachmentsToSetOutput)
        pub fn build(self) -> crate::output::AddAttachmentsToSetOutput {
            crate::output::AddAttachmentsToSetOutput {
                attachment_set_id: self.attachment_set_id,
                expiry_time: self.expiry_time,
            }
        }
    }
}
impl AddAttachmentsToSetOutput {
    /// Creates a new builder-style object to manufacture [`AddAttachmentsToSetOutput`](crate::output::AddAttachmentsToSetOutput)
    pub fn builder() -> crate::output::add_attachments_to_set_output::Builder {
        crate::output::add_attachments_to_set_output::Builder::default()
    }
}
