// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Support
///
/// Client for invoking operations on AWS Support. Each operation on AWS Support is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_support::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_support::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_support::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddAttachmentsToSet`](crate::client::fluent_builders::AddAttachmentsToSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_set_id(impl Into<String>)`](crate::client::fluent_builders::AddAttachmentsToSet::attachment_set_id) / [`set_attachment_set_id(Option<String>)`](crate::client::fluent_builders::AddAttachmentsToSet::set_attachment_set_id): <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>
    ///   - [`attachments(Vec<Attachment>)`](crate::client::fluent_builders::AddAttachmentsToSet::attachments) / [`set_attachments(Option<Vec<Attachment>>)`](crate::client::fluent_builders::AddAttachmentsToSet::set_attachments): <p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p>  <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
    /// - On success, responds with [`AddAttachmentsToSetOutput`](crate::output::AddAttachmentsToSetOutput) with field(s):
    ///   - [`attachment_set_id(Option<String>)`](crate::output::AddAttachmentsToSetOutput::attachment_set_id): <p>The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the attachments are added to the specified set, if it exists.</p>
    ///   - [`expiry_time(Option<String>)`](crate::output::AddAttachmentsToSetOutput::expiry_time): <p>The time and date when the attachment set expires.</p>
    /// - On failure, responds with [`SdkError<AddAttachmentsToSetError>`](crate::error::AddAttachmentsToSetError)
    pub fn add_attachments_to_set(&self) -> fluent_builders::AddAttachmentsToSet {
        fluent_builders::AddAttachmentsToSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddCommunicationToCase`](crate::client::fluent_builders::AddCommunicationToCase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`case_id(impl Into<String>)`](crate::client::fluent_builders::AddCommunicationToCase::case_id) / [`set_case_id(Option<String>)`](crate::client::fluent_builders::AddCommunicationToCase::set_case_id): <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    ///   - [`communication_body(impl Into<String>)`](crate::client::fluent_builders::AddCommunicationToCase::communication_body) / [`set_communication_body(Option<String>)`](crate::client::fluent_builders::AddCommunicationToCase::set_communication_body): <p>The body of an email communication to add to the support case.</p>
    ///   - [`cc_email_addresses(Vec<String>)`](crate::client::fluent_builders::AddCommunicationToCase::cc_email_addresses) / [`set_cc_email_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::AddCommunicationToCase::set_cc_email_addresses): <p>The email addresses in the CC line of an email to be added to the support case.</p>
    ///   - [`attachment_set_id(impl Into<String>)`](crate::client::fluent_builders::AddCommunicationToCase::attachment_set_id) / [`set_attachment_set_id(Option<String>)`](crate::client::fluent_builders::AddCommunicationToCase::set_attachment_set_id): <p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <code>AddAttachmentsToSet</code> </p>
    /// - On success, responds with [`AddCommunicationToCaseOutput`](crate::output::AddCommunicationToCaseOutput) with field(s):
    ///   - [`result(bool)`](crate::output::AddCommunicationToCaseOutput::result): <p>True if <code>AddCommunicationToCase</code> succeeds. Otherwise, returns an error.</p>
    /// - On failure, responds with [`SdkError<AddCommunicationToCaseError>`](crate::error::AddCommunicationToCaseError)
    pub fn add_communication_to_case(&self) -> fluent_builders::AddCommunicationToCase {
        fluent_builders::AddCommunicationToCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCase`](crate::client::fluent_builders::CreateCase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subject(impl Into<String>)`](crate::client::fluent_builders::CreateCase::subject) / [`set_subject(Option<String>)`](crate::client::fluent_builders::CreateCase::set_subject): <p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::CreateCase::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::CreateCase::set_service_code): <p>The code for the Amazon Web Services service. You can use the <code>DescribeServices</code> operation to get the possible <code>serviceCode</code> values.</p>
    ///   - [`severity_code(impl Into<String>)`](crate::client::fluent_builders::CreateCase::severity_code) / [`set_severity_code(Option<String>)`](crate::client::fluent_builders::CreateCase::set_severity_code): <p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <code>DescribeSeverityLevels</code> operation to get the possible values for <code>severityCode</code>. </p>  <p>For more information, see <code>SeverityLevel</code> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note>   <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p>  </note>
    ///   - [`category_code(impl Into<String>)`](crate::client::fluent_builders::CreateCase::category_code) / [`set_category_code(Option<String>)`](crate::client::fluent_builders::CreateCase::set_category_code): <p>The category of problem for the support case. You also use the <code>DescribeServices</code> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>
    ///   - [`communication_body(impl Into<String>)`](crate::client::fluent_builders::CreateCase::communication_body) / [`set_communication_body(Option<String>)`](crate::client::fluent_builders::CreateCase::set_communication_body): <p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    ///   - [`cc_email_addresses(Vec<String>)`](crate::client::fluent_builders::CreateCase::cc_email_addresses) / [`set_cc_email_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCase::set_cc_email_addresses): <p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::CreateCase::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::CreateCase::set_language): <p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>
    ///   - [`issue_type(impl Into<String>)`](crate::client::fluent_builders::CreateCase::issue_type) / [`set_issue_type(Option<String>)`](crate::client::fluent_builders::CreateCase::set_issue_type): <p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.</p>
    ///   - [`attachment_set_id(impl Into<String>)`](crate::client::fluent_builders::CreateCase::attachment_set_id) / [`set_attachment_set_id(Option<String>)`](crate::client::fluent_builders::CreateCase::set_attachment_set_id): <p>The ID of a set of one or more attachments for the case. Create the set by using the <code>AddAttachmentsToSet</code> operation.</p>
    /// - On success, responds with [`CreateCaseOutput`](crate::output::CreateCaseOutput) with field(s):
    ///   - [`case_id(Option<String>)`](crate::output::CreateCaseOutput::case_id): <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string in the following format: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    /// - On failure, responds with [`SdkError<CreateCaseError>`](crate::error::CreateCaseError)
    pub fn create_case(&self) -> fluent_builders::CreateCase {
        fluent_builders::CreateCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAttachment`](crate::client::fluent_builders::DescribeAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::DescribeAttachment::set_attachment_id): <p>The ID of the attachment to return. Attachment IDs are returned by the <code>DescribeCommunications</code> operation.</p>
    /// - On success, responds with [`DescribeAttachmentOutput`](crate::output::DescribeAttachmentOutput) with field(s):
    ///   - [`attachment(Option<Attachment>)`](crate::output::DescribeAttachmentOutput::attachment): <p>This object includes the attachment content and file name.</p>  <p>In the previous response syntax, the value for the <code>data</code> parameter appears as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeAttachmentError>`](crate::error::DescribeAttachmentError)
    pub fn describe_attachment(&self) -> fluent_builders::DescribeAttachment {
        fluent_builders::DescribeAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCases`](crate::client::fluent_builders::DescribeCases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`case_id_list(Vec<String>)`](crate::client::fluent_builders::DescribeCases::case_id_list) / [`set_case_id_list(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCases::set_case_id_list): <p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>
    ///   - [`display_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCases::display_id) / [`set_display_id(Option<String>)`](crate::client::fluent_builders::DescribeCases::set_display_id): <p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>
    ///   - [`after_time(impl Into<String>)`](crate::client::fluent_builders::DescribeCases::after_time) / [`set_after_time(Option<String>)`](crate::client::fluent_builders::DescribeCases::set_after_time): <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    ///   - [`before_time(impl Into<String>)`](crate::client::fluent_builders::DescribeCases::before_time) / [`set_before_time(Option<String>)`](crate::client::fluent_builders::DescribeCases::set_before_time): <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    ///   - [`include_resolved_cases(bool)`](crate::client::fluent_builders::DescribeCases::include_resolved_cases) / [`set_include_resolved_cases(bool)`](crate::client::fluent_builders::DescribeCases::set_include_resolved_cases): <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren't included.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCases::set_next_token): <p>A resumption point for pagination.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCases::set_max_results): <p>The maximum number of results to return before paginating.</p>
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::DescribeCases::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::DescribeCases::set_language): <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    ///   - [`include_communications(bool)`](crate::client::fluent_builders::DescribeCases::include_communications) / [`set_include_communications(Option<bool>)`](crate::client::fluent_builders::DescribeCases::set_include_communications): <p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>
    /// - On success, responds with [`DescribeCasesOutput`](crate::output::DescribeCasesOutput) with field(s):
    ///   - [`cases(Option<Vec<CaseDetails>>)`](crate::output::DescribeCasesOutput::cases): <p>The details for the cases that match the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCasesOutput::next_token): <p>A resumption point for pagination.</p>
    /// - On failure, responds with [`SdkError<DescribeCasesError>`](crate::error::DescribeCasesError)
    pub fn describe_cases(&self) -> fluent_builders::DescribeCases {
        fluent_builders::DescribeCases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCommunications`](crate::client::fluent_builders::DescribeCommunications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCommunications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`case_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCommunications::case_id) / [`set_case_id(Option<String>)`](crate::client::fluent_builders::DescribeCommunications::set_case_id): <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    ///   - [`before_time(impl Into<String>)`](crate::client::fluent_builders::DescribeCommunications::before_time) / [`set_before_time(Option<String>)`](crate::client::fluent_builders::DescribeCommunications::set_before_time): <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    ///   - [`after_time(impl Into<String>)`](crate::client::fluent_builders::DescribeCommunications::after_time) / [`set_after_time(Option<String>)`](crate::client::fluent_builders::DescribeCommunications::set_after_time): <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCommunications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCommunications::set_next_token): <p>A resumption point for pagination.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCommunications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCommunications::set_max_results): <p>The maximum number of results to return before paginating.</p>
    /// - On success, responds with [`DescribeCommunicationsOutput`](crate::output::DescribeCommunicationsOutput) with field(s):
    ///   - [`communications(Option<Vec<Communication>>)`](crate::output::DescribeCommunicationsOutput::communications): <p>The communications for the case.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCommunicationsOutput::next_token): <p>A resumption point for pagination.</p>
    /// - On failure, responds with [`SdkError<DescribeCommunicationsError>`](crate::error::DescribeCommunicationsError)
    pub fn describe_communications(&self) -> fluent_builders::DescribeCommunications {
        fluent_builders::DescribeCommunications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServices`](crate::client::fluent_builders::DescribeServices) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code_list(Vec<String>)`](crate::client::fluent_builders::DescribeServices::service_code_list) / [`set_service_code_list(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeServices::set_service_code_list): <p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::DescribeServices::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::DescribeServices::set_language): <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    /// - On success, responds with [`DescribeServicesOutput`](crate::output::DescribeServicesOutput) with field(s):
    ///   - [`services(Option<Vec<Service>>)`](crate::output::DescribeServicesOutput::services): <p>A JSON-formatted list of Amazon Web Services services.</p>
    /// - On failure, responds with [`SdkError<DescribeServicesError>`](crate::error::DescribeServicesError)
    pub fn describe_services(&self) -> fluent_builders::DescribeServices {
        fluent_builders::DescribeServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSeverityLevels`](crate::client::fluent_builders::DescribeSeverityLevels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::DescribeSeverityLevels::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::DescribeSeverityLevels::set_language): <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    /// - On success, responds with [`DescribeSeverityLevelsOutput`](crate::output::DescribeSeverityLevelsOutput) with field(s):
    ///   - [`severity_levels(Option<Vec<SeverityLevel>>)`](crate::output::DescribeSeverityLevelsOutput::severity_levels): <p>The available severity levels for the support case. Available severity levels are defined by your service level agreement with Amazon Web Services.</p>
    /// - On failure, responds with [`SdkError<DescribeSeverityLevelsError>`](crate::error::DescribeSeverityLevelsError)
    pub fn describe_severity_levels(&self) -> fluent_builders::DescribeSeverityLevels {
        fluent_builders::DescribeSeverityLevels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrustedAdvisorCheckRefreshStatuses`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses::check_ids) / [`set_check_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses::set_check_ids): <p>The IDs of the Trusted Advisor checks to get the status.</p> <note>   <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p>  </note>
    /// - On success, responds with [`DescribeTrustedAdvisorCheckRefreshStatusesOutput`](crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput) with field(s):
    ///   - [`statuses(Option<Vec<TrustedAdvisorCheckRefreshStatus>>)`](crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput::statuses): <p>The refresh status of the specified Trusted Advisor checks.</p>
    /// - On failure, responds with [`SdkError<DescribeTrustedAdvisorCheckRefreshStatusesError>`](crate::error::DescribeTrustedAdvisorCheckRefreshStatusesError)
    pub fn describe_trusted_advisor_check_refresh_statuses(
        &self,
    ) -> fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses {
        fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrustedAdvisorCheckResult`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckResult) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckResult::check_id) / [`set_check_id(Option<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckResult::set_check_id): <p>The unique identifier for the Trusted Advisor check.</p>
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckResult::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckResult::set_language): <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    /// - On success, responds with [`DescribeTrustedAdvisorCheckResultOutput`](crate::output::DescribeTrustedAdvisorCheckResultOutput) with field(s):
    ///   - [`result(Option<TrustedAdvisorCheckResult>)`](crate::output::DescribeTrustedAdvisorCheckResultOutput::result): <p>The detailed results of the Trusted Advisor check.</p>
    /// - On failure, responds with [`SdkError<DescribeTrustedAdvisorCheckResultError>`](crate::error::DescribeTrustedAdvisorCheckResultError)
    pub fn describe_trusted_advisor_check_result(
        &self,
    ) -> fluent_builders::DescribeTrustedAdvisorCheckResult {
        fluent_builders::DescribeTrustedAdvisorCheckResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrustedAdvisorChecks`](crate::client::fluent_builders::DescribeTrustedAdvisorChecks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorChecks::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorChecks::set_language): <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
    /// - On success, responds with [`DescribeTrustedAdvisorChecksOutput`](crate::output::DescribeTrustedAdvisorChecksOutput) with field(s):
    ///   - [`checks(Option<Vec<TrustedAdvisorCheckDescription>>)`](crate::output::DescribeTrustedAdvisorChecksOutput::checks): <p>Information about all available Trusted Advisor checks.</p>
    /// - On failure, responds with [`SdkError<DescribeTrustedAdvisorChecksError>`](crate::error::DescribeTrustedAdvisorChecksError)
    pub fn describe_trusted_advisor_checks(&self) -> fluent_builders::DescribeTrustedAdvisorChecks {
        fluent_builders::DescribeTrustedAdvisorChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrustedAdvisorCheckSummaries`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckSummaries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckSummaries::check_ids) / [`set_check_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckSummaries::set_check_ids): <p>The IDs of the Trusted Advisor checks.</p>
    /// - On success, responds with [`DescribeTrustedAdvisorCheckSummariesOutput`](crate::output::DescribeTrustedAdvisorCheckSummariesOutput) with field(s):
    ///   - [`summaries(Option<Vec<TrustedAdvisorCheckSummary>>)`](crate::output::DescribeTrustedAdvisorCheckSummariesOutput::summaries): <p>The summary information for the requested Trusted Advisor checks.</p>
    /// - On failure, responds with [`SdkError<DescribeTrustedAdvisorCheckSummariesError>`](crate::error::DescribeTrustedAdvisorCheckSummariesError)
    pub fn describe_trusted_advisor_check_summaries(
        &self,
    ) -> fluent_builders::DescribeTrustedAdvisorCheckSummaries {
        fluent_builders::DescribeTrustedAdvisorCheckSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RefreshTrustedAdvisorCheck`](crate::client::fluent_builders::RefreshTrustedAdvisorCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_id(impl Into<String>)`](crate::client::fluent_builders::RefreshTrustedAdvisorCheck::check_id) / [`set_check_id(Option<String>)`](crate::client::fluent_builders::RefreshTrustedAdvisorCheck::set_check_id): <p>The unique identifier for the Trusted Advisor check to refresh.</p> <note>   <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p>  </note>
    /// - On success, responds with [`RefreshTrustedAdvisorCheckOutput`](crate::output::RefreshTrustedAdvisorCheckOutput) with field(s):
    ///   - [`status(Option<TrustedAdvisorCheckRefreshStatus>)`](crate::output::RefreshTrustedAdvisorCheckOutput::status): <p>The current refresh status for a check, including the amount of time until the check is eligible for refresh.</p>
    /// - On failure, responds with [`SdkError<RefreshTrustedAdvisorCheckError>`](crate::error::RefreshTrustedAdvisorCheckError)
    pub fn refresh_trusted_advisor_check(&self) -> fluent_builders::RefreshTrustedAdvisorCheck {
        fluent_builders::RefreshTrustedAdvisorCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResolveCase`](crate::client::fluent_builders::ResolveCase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`case_id(impl Into<String>)`](crate::client::fluent_builders::ResolveCase::case_id) / [`set_case_id(Option<String>)`](crate::client::fluent_builders::ResolveCase::set_case_id): <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
    /// - On success, responds with [`ResolveCaseOutput`](crate::output::ResolveCaseOutput) with field(s):
    ///   - [`initial_case_status(Option<String>)`](crate::output::ResolveCaseOutput::initial_case_status): <p>The status of the case when the <code>ResolveCase</code> request was sent.</p>
    ///   - [`final_case_status(Option<String>)`](crate::output::ResolveCaseOutput::final_case_status): <p>The status of the case after the <code>ResolveCase</code> request was processed.</p>
    /// - On failure, responds with [`SdkError<ResolveCaseError>`](crate::error::ResolveCaseError)
    pub fn resolve_case(&self) -> fluent_builders::ResolveCase {
        fluent_builders::ResolveCase::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddAttachmentsToSet`.
    ///
    /// <p>Adds one or more attachments to an attachment set. </p>
    /// <p>An attachment set is a temporary container for attachments that you add to a case or case communication. The set is available for 1 hour after it's created. The <code>expiryTime</code> returned in the response is when the set expires. </p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddAttachmentsToSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_attachments_to_set_input::Builder,
    }
    impl AddAttachmentsToSet {
        /// Creates a new `AddAttachmentsToSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddAttachmentsToSetOutput,
            aws_smithy_http::result::SdkError<crate::error::AddAttachmentsToSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>
        pub fn attachment_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_set_id(input.into());
            self
        }
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_set_id(input);
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p>
        /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn attachments(mut self, input: crate::model::Attachment) -> Self {
            self.inner = self.inner.attachments(input);
            self
        }
        /// <p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p>
        /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        ) -> Self {
            self.inner = self.inner.set_attachments(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddCommunicationToCase`.
    ///
    /// <p>Adds additional customer communication to an Amazon Web Services Support case. Use the <code>caseId</code> parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the <code>ccEmailAddresses</code> parameter. The <code>communicationBody</code> value contains the text of the communication.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddCommunicationToCase {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_communication_to_case_input::Builder,
    }
    impl AddCommunicationToCase {
        /// Creates a new `AddCommunicationToCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddCommunicationToCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::AddCommunicationToCaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_case_id(input);
            self
        }
        /// <p>The body of an email communication to add to the support case.</p>
        pub fn communication_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.communication_body(input.into());
            self
        }
        /// <p>The body of an email communication to add to the support case.</p>
        pub fn set_communication_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_communication_body(input);
            self
        }
        /// Appends an item to `ccEmailAddresses`.
        ///
        /// To override the contents of this collection use [`set_cc_email_addresses`](Self::set_cc_email_addresses).
        ///
        /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
        pub fn cc_email_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cc_email_addresses(input.into());
            self
        }
        /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
        pub fn set_cc_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cc_email_addresses(input);
            self
        }
        /// <p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <code>AddAttachmentsToSet</code> </p>
        pub fn attachment_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_set_id(input.into());
            self
        }
        /// <p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <code>AddAttachmentsToSet</code> </p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCase`.
    ///
    /// <p>Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    /// <p>The Amazon Web Services Support API doesn't support requesting service limit increases. You can submit a service limit increase in the following ways: </p>
    /// <ul>
    /// <li> <p>Submit a request from the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p> </li>
    /// <li> <p>Use the Service Quotas <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html">RequestServiceQuotaIncrease</a> operation.</p> </li>
    /// </ul>
    /// <p>A successful <code>CreateCase</code> request returns an Amazon Web Services Support case number. You can use the <code>DescribeCases</code> operation and specify the case number to get existing Amazon Web Services Support cases. After you create a case, use the <code>AddCommunicationToCase</code> operation to add additional communication or attachments to an existing case.</p>
    /// <p>The <code>caseId</code> is separate from the <code>displayId</code> that appears in the <a href="https://console.aws.amazon.com/support">Amazon Web Services Support Center</a>. Use the <code>DescribeCases</code> operation to get the <code>displayId</code>.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCase {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_case_input::Builder,
    }
    impl CreateCase {
        /// Creates a new `CreateCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subject(input.into());
            self
        }
        /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subject(input);
            self
        }
        /// <p>The code for the Amazon Web Services service. You can use the <code>DescribeServices</code> operation to get the possible <code>serviceCode</code> values.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The code for the Amazon Web Services service. You can use the <code>DescribeServices</code> operation to get the possible <code>serviceCode</code> values.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <code>DescribeSeverityLevels</code> operation to get the possible values for <code>severityCode</code>. </p>
        /// <p>For more information, see <code>SeverityLevel</code> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note>
        /// <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p>
        /// </note>
        pub fn severity_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity_code(input.into());
            self
        }
        /// <p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <code>DescribeSeverityLevels</code> operation to get the possible values for <code>severityCode</code>. </p>
        /// <p>For more information, see <code>SeverityLevel</code> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note>
        /// <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p>
        /// </note>
        pub fn set_severity_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_severity_code(input);
            self
        }
        /// <p>The category of problem for the support case. You also use the <code>DescribeServices</code> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>
        pub fn category_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category_code(input.into());
            self
        }
        /// <p>The category of problem for the support case. You also use the <code>DescribeServices</code> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>
        pub fn set_category_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_category_code(input);
            self
        }
        /// <p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn communication_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.communication_body(input.into());
            self
        }
        /// <p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn set_communication_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_communication_body(input);
            self
        }
        /// Appends an item to `ccEmailAddresses`.
        ///
        /// To override the contents of this collection use [`set_cc_email_addresses`](Self::set_cc_email_addresses).
        ///
        /// <p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>
        pub fn cc_email_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cc_email_addresses(input.into());
            self
        }
        /// <p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>
        pub fn set_cc_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cc_email_addresses(input);
            self
        }
        /// <p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// <p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.</p>
        pub fn issue_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.issue_type(input.into());
            self
        }
        /// <p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.</p>
        pub fn set_issue_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_issue_type(input);
            self
        }
        /// <p>The ID of a set of one or more attachments for the case. Create the set by using the <code>AddAttachmentsToSet</code> operation.</p>
        pub fn attachment_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_set_id(input.into());
            self
        }
        /// <p>The ID of a set of one or more attachments for the case. Create the set by using the <code>AddAttachmentsToSet</code> operation.</p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAttachment`.
    ///
    /// <p>Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files that describe your issue. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the <code>AttachmentDetails</code> objects that are returned by the <code>DescribeCommunications</code> operation.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_attachment_input::Builder,
    }
    impl DescribeAttachment {
        /// Creates a new `DescribeAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment to return. Attachment IDs are returned by the <code>DescribeCommunications</code> operation.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment to return. Attachment IDs are returned by the <code>DescribeCommunications</code> operation.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCases`.
    ///
    /// <p>Returns a list of cases that you specify by passing one or more case IDs. You can use the <code>afterTime</code> and <code>beforeTime</code> parameters to filter the cases by date. You can set values for the <code>includeResolvedCases</code> and <code>includeCommunications</code> parameters to specify how much information to return.</p>
    /// <p>The response returns the following in JSON format:</p>
    /// <ul>
    /// <li> <p>One or more <a href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> data types.</p> </li>
    /// <li> <p>One or more <code>nextToken</code> values, which specify where to paginate the returned records represented by the <code>CaseDetails</code> objects.</p> </li>
    /// </ul>
    /// <p>Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request might return an error.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cases_input::Builder,
    }
    impl DescribeCases {
        /// Creates a new `DescribeCases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCasesPaginator {
            crate::paginator::DescribeCasesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `caseIdList`.
        ///
        /// To override the contents of this collection use [`set_case_id_list`](Self::set_case_id_list).
        ///
        /// <p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>
        pub fn case_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id_list(input.into());
            self
        }
        /// <p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>
        pub fn set_case_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_case_id_list(input);
            self
        }
        /// <p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>
        pub fn display_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_id(input.into());
            self
        }
        /// <p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>
        pub fn set_display_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_id(input);
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn after_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_time(input.into());
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_after_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after_time(input);
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn before_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_time(input.into());
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_before_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_before_time(input);
            self
        }
        /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren't included.</p>
        pub fn include_resolved_cases(mut self, input: bool) -> Self {
            self.inner = self.inner.include_resolved_cases(input);
            self
        }
        /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren't included.</p>
        pub fn set_include_resolved_cases(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_resolved_cases(input);
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// <p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>
        pub fn include_communications(mut self, input: bool) -> Self {
            self.inner = self.inner.include_communications(input);
            self
        }
        /// <p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>
        pub fn set_include_communications(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_communications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCommunications`.
    ///
    /// <p>Returns communications and attachments for one or more support cases. Use the <code>afterTime</code> and <code>beforeTime</code> parameters to filter by date. You can use the <code>caseId</code> parameter to restrict the results to a specific case.</p>
    /// <p>Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error.</p>
    /// <p>You can use the <code>maxResults</code> and <code>nextToken</code> parameters to control the pagination of the results. Set <code>maxResults</code> to the number of cases that you want to display on each page, and use <code>nextToken</code> to specify the resumption of pagination.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCommunications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_communications_input::Builder,
    }
    impl DescribeCommunications {
        /// Creates a new `DescribeCommunications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCommunicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCommunicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCommunicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCommunicationsPaginator {
            crate::paginator::DescribeCommunicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_case_id(input);
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn before_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_time(input.into());
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_before_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_before_time(input);
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn after_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_time(input.into());
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>
        pub fn set_after_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after_time(input);
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServices`.
    ///
    /// <p>Returns the current list of Amazon Web Services services and a list of service categories for each service. You then use service names and categories in your <code>CreateCase</code> requests. Each Amazon Web Services service has its own set of categories.</p>
    /// <p>The service codes and category codes correspond to the values that appear in the <b>Service</b> and <b>Category</b> lists on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. The values in those fields don't necessarily match the service codes and categories returned by the <code>DescribeServices</code> operation. Always use the service codes and categories that the <code>DescribeServices</code> operation returns, so that you have the most recent set of service and category codes.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_services_input::Builder,
    }
    impl DescribeServices {
        /// Creates a new `DescribeServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `serviceCodeList`.
        ///
        /// To override the contents of this collection use [`set_service_code_list`](Self::set_service_code_list).
        ///
        /// <p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>
        pub fn service_code_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code_list(input.into());
            self
        }
        /// <p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>
        pub fn set_service_code_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_service_code_list(input);
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSeverityLevels`.
    ///
    /// <p>Returns the list of severity levels that you can assign to a support case. The severity level for a case is also a field in the <code>CaseDetails</code> data type that you include for a <code>CreateCase</code> request.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSeverityLevels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_severity_levels_input::Builder,
    }
    impl DescribeSeverityLevels {
        /// Creates a new `DescribeSeverityLevels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSeverityLevelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSeverityLevelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorCheckRefreshStatuses`.
    ///
    /// <p>Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check IDs by calling the <code>DescribeTrustedAdvisorChecks</code> operation.</p>
    /// <p>Some checks are refreshed automatically, and you can't return their refresh statuses by using the <code>DescribeTrustedAdvisorCheckRefreshStatuses</code> operation. If you call this operation for these checks, you might see an <code>InvalidParameterValue</code> error.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorCheckRefreshStatuses {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_trusted_advisor_check_refresh_statuses_input::Builder,
    }
    impl DescribeTrustedAdvisorCheckRefreshStatuses {
        /// Creates a new `DescribeTrustedAdvisorCheckRefreshStatuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeTrustedAdvisorCheckRefreshStatusesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `checkIds`.
        ///
        /// To override the contents of this collection use [`set_check_ids`](Self::set_check_ids).
        ///
        /// <p>The IDs of the Trusted Advisor checks to get the status.</p> <note>
        /// <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn check_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_ids(input.into());
            self
        }
        /// <p>The IDs of the Trusted Advisor checks to get the status.</p> <note>
        /// <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn set_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_check_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorCheckResult`.
    ///
    /// <p>Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by calling the <code>DescribeTrustedAdvisorChecks</code> operation.</p>
    /// <p>The response contains a <code>TrustedAdvisorCheckResult</code> object, which contains these three objects:</p>
    /// <ul>
    /// <li> <p> <code>TrustedAdvisorCategorySpecificSummary</code> </p> </li>
    /// <li> <p> <code>TrustedAdvisorResourceDetail</code> </p> </li>
    /// <li> <p> <code>TrustedAdvisorResourcesSummary</code> </p> </li>
    /// </ul>
    /// <p>In addition, the response contains these fields:</p>
    /// <ul>
    /// <li> <p> <b>status</b> - The alert status of the check can be <code>ok</code> (green), <code>warning</code> (yellow), <code>error</code> (red), or <code>not_available</code>.</p> </li>
    /// <li> <p> <b>timestamp</b> - The time of the last refresh of the check.</p> </li>
    /// <li> <p> <b>checkId</b> - The unique identifier for the check.</p> </li>
    /// </ul> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorCheckResult {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_trusted_advisor_check_result_input::Builder,
    }
    impl DescribeTrustedAdvisorCheckResult {
        /// Creates a new `DescribeTrustedAdvisorCheckResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorCheckResultOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrustedAdvisorCheckResultError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_id(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_id(input);
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorChecks`.
    ///
    /// <p>Returns information about all available Trusted Advisor checks, including the name, ID, category, description, and metadata. You must specify a language code. The Amazon Web Services Support API currently supports English ("en") and Japanese ("ja"). The response contains a <code>TrustedAdvisorCheckDescription</code> object for each check. You must set the Amazon Web Services Region to us-east-1.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// <li> <p>The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the check ID in your code to uniquely identify a check.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorChecks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_trusted_advisor_checks_input::Builder,
    }
    impl DescribeTrustedAdvisorChecks {
        /// Creates a new `DescribeTrustedAdvisorChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrustedAdvisorChecksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorCheckSummaries`.
    ///
    /// <p>Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the check IDs by calling the <code>DescribeTrustedAdvisorChecks</code> operation.</p>
    /// <p>The response contains an array of <code>TrustedAdvisorCheckSummary</code> objects.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorCheckSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_trusted_advisor_check_summaries_input::Builder,
    }
    impl DescribeTrustedAdvisorCheckSummaries {
        /// Creates a new `DescribeTrustedAdvisorCheckSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorCheckSummariesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeTrustedAdvisorCheckSummariesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `checkIds`.
        ///
        /// To override the contents of this collection use [`set_check_ids`](Self::set_check_ids).
        ///
        /// <p>The IDs of the Trusted Advisor checks.</p>
        pub fn check_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_ids(input.into());
            self
        }
        /// <p>The IDs of the Trusted Advisor checks.</p>
        pub fn set_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_check_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshTrustedAdvisorCheck`.
    ///
    /// <p>Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the <code>DescribeTrustedAdvisorChecks</code> operation.</p> <note>
    /// <p>Some checks are refreshed automatically. If you call the <code>RefreshTrustedAdvisorCheck</code> operation to refresh them, you might see the <code>InvalidParameterValue</code> error.</p>
    /// </note>
    /// <p>The response contains a <code>TrustedAdvisorCheckRefreshStatus</code> object.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RefreshTrustedAdvisorCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::refresh_trusted_advisor_check_input::Builder,
    }
    impl RefreshTrustedAdvisorCheck {
        /// Creates a new `RefreshTrustedAdvisorCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshTrustedAdvisorCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshTrustedAdvisorCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Trusted Advisor check to refresh.</p> <note>
        /// <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_id(input.into());
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check to refresh.</p> <note>
        /// <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResolveCase`.
    ///
    /// <p>Resolves a support case. This operation takes a <code>caseId</code> and returns the initial and final state of the case.</p> <note>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li>
    /// <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResolveCase {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::resolve_case_input::Builder,
    }
    impl ResolveCase {
        /// Creates a new `ResolveCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResolveCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::ResolveCaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id(input.into());
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_case_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
