// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSSupport_20130415`.
///
/// This client allows ergonomic access to a `AWSSupport_20130415`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddAttachmentsToSet` operation.
    ///
    /// See [`AddAttachmentsToSet`](crate::client::fluent_builders::AddAttachmentsToSet) for more information about the
    /// operation and its arguments.
    pub fn add_attachments_to_set(&self) -> fluent_builders::AddAttachmentsToSet<C, M, R> {
        fluent_builders::AddAttachmentsToSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddCommunicationToCase` operation.
    ///
    /// See [`AddCommunicationToCase`](crate::client::fluent_builders::AddCommunicationToCase) for more information about the
    /// operation and its arguments.
    pub fn add_communication_to_case(&self) -> fluent_builders::AddCommunicationToCase<C, M, R> {
        fluent_builders::AddCommunicationToCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCase` operation.
    ///
    /// See [`CreateCase`](crate::client::fluent_builders::CreateCase) for more information about the
    /// operation and its arguments.
    pub fn create_case(&self) -> fluent_builders::CreateCase<C, M, R> {
        fluent_builders::CreateCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAttachment` operation.
    ///
    /// See [`DescribeAttachment`](crate::client::fluent_builders::DescribeAttachment) for more information about the
    /// operation and its arguments.
    pub fn describe_attachment(&self) -> fluent_builders::DescribeAttachment<C, M, R> {
        fluent_builders::DescribeAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCases` operation.
    ///
    /// See [`DescribeCases`](crate::client::fluent_builders::DescribeCases) for more information about the
    /// operation and its arguments.
    pub fn describe_cases(&self) -> fluent_builders::DescribeCases<C, M, R> {
        fluent_builders::DescribeCases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCommunications` operation.
    ///
    /// See [`DescribeCommunications`](crate::client::fluent_builders::DescribeCommunications) for more information about the
    /// operation and its arguments.
    pub fn describe_communications(&self) -> fluent_builders::DescribeCommunications<C, M, R> {
        fluent_builders::DescribeCommunications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeServices` operation.
    ///
    /// See [`DescribeServices`](crate::client::fluent_builders::DescribeServices) for more information about the
    /// operation and its arguments.
    pub fn describe_services(&self) -> fluent_builders::DescribeServices<C, M, R> {
        fluent_builders::DescribeServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSeverityLevels` operation.
    ///
    /// See [`DescribeSeverityLevels`](crate::client::fluent_builders::DescribeSeverityLevels) for more information about the
    /// operation and its arguments.
    pub fn describe_severity_levels(&self) -> fluent_builders::DescribeSeverityLevels<C, M, R> {
        fluent_builders::DescribeSeverityLevels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrustedAdvisorCheckRefreshStatuses` operation.
    ///
    /// See [`DescribeTrustedAdvisorCheckRefreshStatuses`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses) for more information about the
    /// operation and its arguments.
    pub fn describe_trusted_advisor_check_refresh_statuses(
        &self,
    ) -> fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses<C, M, R> {
        fluent_builders::DescribeTrustedAdvisorCheckRefreshStatuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrustedAdvisorCheckResult` operation.
    ///
    /// See [`DescribeTrustedAdvisorCheckResult`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckResult) for more information about the
    /// operation and its arguments.
    pub fn describe_trusted_advisor_check_result(
        &self,
    ) -> fluent_builders::DescribeTrustedAdvisorCheckResult<C, M, R> {
        fluent_builders::DescribeTrustedAdvisorCheckResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrustedAdvisorChecks` operation.
    ///
    /// See [`DescribeTrustedAdvisorChecks`](crate::client::fluent_builders::DescribeTrustedAdvisorChecks) for more information about the
    /// operation and its arguments.
    pub fn describe_trusted_advisor_checks(
        &self,
    ) -> fluent_builders::DescribeTrustedAdvisorChecks<C, M, R> {
        fluent_builders::DescribeTrustedAdvisorChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrustedAdvisorCheckSummaries` operation.
    ///
    /// See [`DescribeTrustedAdvisorCheckSummaries`](crate::client::fluent_builders::DescribeTrustedAdvisorCheckSummaries) for more information about the
    /// operation and its arguments.
    pub fn describe_trusted_advisor_check_summaries(
        &self,
    ) -> fluent_builders::DescribeTrustedAdvisorCheckSummaries<C, M, R> {
        fluent_builders::DescribeTrustedAdvisorCheckSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RefreshTrustedAdvisorCheck` operation.
    ///
    /// See [`RefreshTrustedAdvisorCheck`](crate::client::fluent_builders::RefreshTrustedAdvisorCheck) for more information about the
    /// operation and its arguments.
    pub fn refresh_trusted_advisor_check(
        &self,
    ) -> fluent_builders::RefreshTrustedAdvisorCheck<C, M, R> {
        fluent_builders::RefreshTrustedAdvisorCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResolveCase` operation.
    ///
    /// See [`ResolveCase`](crate::client::fluent_builders::ResolveCase) for more information about the
    /// operation and its arguments.
    pub fn resolve_case(&self) -> fluent_builders::ResolveCase<C, M, R> {
        fluent_builders::ResolveCase::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddAttachmentsToSet`.
    ///
    /// <p>Adds one or more attachments to an attachment set. </p>
    /// <p>An attachment set is a temporary container for attachments that you add to a case or
    /// case communication. The set is available for 1 hour after it's created. The
    /// <code>expiryTime</code> returned in the response is when the set expires. </p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AddAttachmentsToSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_attachments_to_set_input::Builder,
    }
    impl<C, M, R> AddAttachmentsToSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddAttachmentsToSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddAttachmentsToSetOutput,
            aws_smithy_http::result::SdkError<crate::error::AddAttachmentsToSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddAttachmentsToSetInputOperationOutputAlias,
                crate::output::AddAttachmentsToSetOutput,
                crate::error::AddAttachmentsToSetError,
                crate::input::AddAttachmentsToSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a
        /// new attachment set is created, and the ID of the set is returned in the response. If an
        /// <code>attachmentSetId</code> is specified, the attachments are added to the
        /// specified set, if it exists.</p>
        pub fn attachment_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_set_id(inp);
            self
        }
        /// <p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a
        /// new attachment set is created, and the ID of the set is returned in the response. If an
        /// <code>attachmentSetId</code> is specified, the attachments are added to the
        /// specified set, if it exists.</p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_set_id(input);
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>One or more attachments to add to the set. You can add up to three attachments per
        /// set. The size limit is 5 MB per attachment.</p>
        /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify
        /// the contents of the attachment file. In the previous request syntax, the value for
        /// <code>data</code> appear as <code>blob</code>, which is represented as a
        /// base64-encoded string. The value for <code>fileName</code> is the name of the
        /// attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn attachments(mut self, inp: impl Into<crate::model::Attachment>) -> Self {
            self.inner = self.inner.attachments(inp);
            self
        }
        /// <p>One or more attachments to add to the set. You can add up to three attachments per
        /// set. The size limit is 5 MB per attachment.</p>
        /// <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify
        /// the contents of the attachment file. In the previous request syntax, the value for
        /// <code>data</code> appear as <code>blob</code>, which is represented as a
        /// base64-encoded string. The value for <code>fileName</code> is the name of the
        /// attachment, such as <code>troubleshoot-screenshot.png</code>.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        ) -> Self {
            self.inner = self.inner.set_attachments(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddCommunicationToCase`.
    ///
    /// <p>Adds additional customer communication to an AWS Support case. Use the <code>caseId</code>
    /// parameter to identify the case to which to add communication. You can list a set of
    /// email addresses to copy on the communication by using the <code>ccEmailAddresses</code>
    /// parameter. The <code>communicationBody</code> value contains the text of the
    /// communication.</p>
    ///
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AddCommunicationToCase<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_communication_to_case_input::Builder,
    }
    impl<C, M, R> AddCommunicationToCase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddCommunicationToCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddCommunicationToCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::AddCommunicationToCaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddCommunicationToCaseInputOperationOutputAlias,
                crate::output::AddCommunicationToCaseOutput,
                crate::error::AddCommunicationToCaseError,
                crate::input::AddCommunicationToCaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an
        /// alphanumeric string formatted as shown in this example:
        /// case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
        /// </p>
        pub fn case_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id(inp);
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an
        /// alphanumeric string formatted as shown in this example:
        /// case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
        /// </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_case_id(input);
            self
        }
        /// <p>The body of an email communication to add to the support case.</p>
        pub fn communication_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.communication_body(inp);
            self
        }
        /// <p>The body of an email communication to add to the support case.</p>
        pub fn set_communication_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_communication_body(input);
            self
        }
        /// Appends an item to `ccEmailAddresses`.
        ///
        /// To override the contents of this collection use [`set_cc_email_addresses`](Self::set_cc_email_addresses).
        ///
        /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
        pub fn cc_email_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cc_email_addresses(inp);
            self
        }
        /// <p>The email addresses in the CC line of an email to be added to the support case.</p>
        pub fn set_cc_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cc_email_addresses(input);
            self
        }
        /// <p>The ID of a set of one or more attachments for the communication to add to the case.
        /// Create the set by calling <a>AddAttachmentsToSet</a>
        /// </p>
        pub fn attachment_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_set_id(inp);
            self
        }
        /// <p>The ID of a set of one or more attachments for the communication to add to the case.
        /// Create the set by calling <a>AddAttachmentsToSet</a>
        /// </p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCase`.
    ///
    /// <p>Creates a case in the AWS Support Center. This operation is similar to how you create a case
    /// in the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create
    /// Case</a> page.</p>
    /// <p>The AWS Support API doesn't support requesting service limit increases. You can submit a
    /// service limit increase in the following ways: </p>
    /// <ul>
    /// <li>
    /// <p>Submit a request from the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
    /// </li>
    /// <li>
    /// <p>Use the Service Quotas <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html">RequestServiceQuotaIncrease</a> operation.</p>
    /// </li>
    /// </ul>
    /// <p>A successful <code>CreateCase</code> request returns an AWS Support case number. You can use
    /// the <a>DescribeCases</a> operation and specify the case number to get
    /// existing AWS Support cases. After you create a case, use the <a>AddCommunicationToCase</a> operation to add additional communication or
    /// attachments to an existing case.</p>
    /// <p>The <code>caseId</code> is separate from the <code>displayId</code> that appears in
    /// the <a href="https://console.aws.amazon.com/support">AWS Support Center</a>. Use the <a>DescribeCases</a> operation to get the <code>displayId</code>.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateCase<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_case_input::Builder,
    }
    impl<C, M, R> CreateCase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCaseInputOperationOutputAlias,
                crate::output::CreateCaseOutput,
                crate::error::CreateCaseError,
                crate::input::CreateCaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subject(inp);
            self
        }
        /// <p>The title of the support case. The title appears in the <b>Subject</b> field on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subject(input);
            self
        }
        /// <p>The code for the AWS service. You can use the <a>DescribeServices</a>
        /// operation to get the possible <code>serviceCode</code> values.</p>
        pub fn service_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(inp);
            self
        }
        /// <p>The code for the AWS service. You can use the <a>DescribeServices</a>
        /// operation to get the possible <code>serviceCode</code> values.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>A value that indicates the urgency of the case. This value determines the response
        /// time according to your service level agreement with AWS Support. You can use the <a>DescribeSeverityLevels</a> operation to get the possible values for
        /// <code>severityCode</code>. </p>
        /// <p>For more information, see <a>SeverityLevel</a> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a
        /// Severity</a> in the <i>AWS Support User Guide</i>.</p>
        /// <note>
        /// <p>The availability of severity levels depends on the support plan for the AWS
        /// account.</p>
        /// </note>
        pub fn severity_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity_code(inp);
            self
        }
        /// <p>A value that indicates the urgency of the case. This value determines the response
        /// time according to your service level agreement with AWS Support. You can use the <a>DescribeSeverityLevels</a> operation to get the possible values for
        /// <code>severityCode</code>. </p>
        /// <p>For more information, see <a>SeverityLevel</a> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a
        /// Severity</a> in the <i>AWS Support User Guide</i>.</p>
        /// <note>
        /// <p>The availability of severity levels depends on the support plan for the AWS
        /// account.</p>
        /// </note>
        pub fn set_severity_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_severity_code(input);
            self
        }
        /// <p>The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get the category code for a service. Each
        /// AWS service defines its own set of category codes.</p>
        pub fn category_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category_code(inp);
            self
        }
        /// <p>The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get the category code for a service. Each
        /// AWS service defines its own set of category codes.</p>
        pub fn set_category_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_category_code(input);
            self
        }
        /// <p>The communication body text that describes the issue. This text appears in the
        /// <b>Description</b> field on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn communication_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.communication_body(inp);
            self
        }
        /// <p>The communication body text that describes the issue. This text appears in the
        /// <b>Description</b> field on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>
        pub fn set_communication_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_communication_body(input);
            self
        }
        /// Appends an item to `ccEmailAddresses`.
        ///
        /// To override the contents of this collection use [`set_cc_email_addresses`](Self::set_cc_email_addresses).
        ///
        /// <p>A list of email addresses that AWS Support copies on case correspondence. AWS Support
        /// identifies the account that creates the case when you specify your AWS credentials in an
        /// HTTP POST method or use the <a href="http://aws.amazon.com/tools/">AWS SDKs</a>.
        /// </p>
        pub fn cc_email_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cc_email_addresses(inp);
            self
        }
        /// <p>A list of email addresses that AWS Support copies on case correspondence. AWS Support
        /// identifies the account that creates the case when you specify your AWS credentials in an
        /// HTTP POST method or use the <a href="http://aws.amazon.com/tools/">AWS SDKs</a>.
        /// </p>
        pub fn set_cc_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cc_email_addresses(input);
            self
        }
        /// <p>The language in which AWS Support handles the case. You must specify the ISO 639-1
        /// code for the <code>language</code> parameter if you want support in that language.
        /// Currently, English ("en") and Japanese ("ja") are supported.</p>
        pub fn language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The language in which AWS Support handles the case. You must specify the ISO 639-1
        /// code for the <code>language</code> parameter if you want support in that language.
        /// Currently, English ("en") and Japanese ("ja") are supported.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// <p>The type of issue for the case. You can specify <code>customer-service</code> or
        /// <code>technical</code>. If you don't specify a value, the default is
        /// <code>technical</code>.</p>
        pub fn issue_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.issue_type(inp);
            self
        }
        /// <p>The type of issue for the case. You can specify <code>customer-service</code> or
        /// <code>technical</code>. If you don't specify a value, the default is
        /// <code>technical</code>.</p>
        pub fn set_issue_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_issue_type(input);
            self
        }
        /// <p>The ID of a set of one or more attachments for the case. Create the set by using the
        /// <a>AddAttachmentsToSet</a> operation.</p>
        pub fn attachment_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_set_id(inp);
            self
        }
        /// <p>The ID of a set of one or more attachments for the case. Create the set by using the
        /// <a>AddAttachmentsToSet</a> operation.</p>
        pub fn set_attachment_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAttachment`.
    ///
    /// <p>Returns the attachment that has the specified ID. Attachments can include screenshots,
    /// error logs, or other files that describe your issue. Attachment IDs are generated by the
    /// case management system when you add an attachment to a case or case communication.
    /// Attachment IDs are returned in the <a>AttachmentDetails</a> objects that are
    /// returned by the <a>DescribeCommunications</a> operation.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_attachment_input::Builder,
    }
    impl<C, M, R> DescribeAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAttachmentInputOperationOutputAlias,
                crate::output::DescribeAttachmentOutput,
                crate::error::DescribeAttachmentError,
                crate::input::DescribeAttachmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a> operation.</p>
        pub fn attachment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(inp);
            self
        }
        /// <p>The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a> operation.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCases`.
    ///
    /// <p>Returns a list of cases that you specify by passing one or more case IDs. You can use
    /// the <code>afterTime</code> and <code>beforeTime</code> parameters to filter the cases by
    /// date. You can set values for the <code>includeResolvedCases</code> and
    /// <code>includeCommunications</code> parameters to specify how much information to
    /// return.</p>
    /// <p>The response returns the following in JSON format:</p>
    /// <ul>
    /// <li>
    /// <p>One or more <a href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> data types.</p>
    /// </li>
    /// <li>
    /// <p>One or more <code>nextToken</code> values, which specify where to paginate the
    /// returned records represented by the <code>CaseDetails</code> objects.</p>
    /// </li>
    /// </ul>
    /// <p>Case data is available for 12 months after creation. If a case was created more than
    /// 12 months ago, a request might return an error.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cases_input::Builder,
    }
    impl<C, M, R> DescribeCases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCasesInputOperationOutputAlias,
                crate::output::DescribeCasesOutput,
                crate::error::DescribeCasesError,
                crate::input::DescribeCasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `caseIdList`.
        ///
        /// To override the contents of this collection use [`set_case_id_list`](Self::set_case_id_list).
        ///
        /// <p>A list of ID numbers of the support cases you want returned. The maximum number of
        /// cases is 100.</p>
        pub fn case_id_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id_list(inp);
            self
        }
        /// <p>A list of ID numbers of the support cases you want returned. The maximum number of
        /// cases is 100.</p>
        pub fn set_case_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_case_id_list(input);
            self
        }
        /// <p>The ID displayed for a case in the AWS Support Center user interface.</p>
        pub fn display_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_id(inp);
            self
        }
        /// <p>The ID displayed for a case in the AWS Support Center user interface.</p>
        pub fn set_display_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_id(input);
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn after_time(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_time(inp);
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn set_after_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after_time(input);
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn before_time(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_time(inp);
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn set_before_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_before_time(input);
            self
        }
        /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code>
        /// response. By default, resolved cases aren't included.</p>
        pub fn include_resolved_cases(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_resolved_cases(inp);
            self
        }
        /// <p>Specifies whether to include resolved support cases in the <code>DescribeCases</code>
        /// response. By default, resolved cases aren't included.</p>
        pub fn set_include_resolved_cases(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_resolved_cases(input);
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// <p>Specifies whether to include communications in the <code>DescribeCases</code>
        /// response. By default, communications are included.</p>
        pub fn include_communications(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_communications(inp);
            self
        }
        /// <p>Specifies whether to include communications in the <code>DescribeCases</code>
        /// response. By default, communications are included.</p>
        pub fn set_include_communications(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_communications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCommunications`.
    ///
    /// <p>Returns communications and attachments for one or more support cases. Use the
    /// <code>afterTime</code> and <code>beforeTime</code> parameters to filter by date. You
    /// can use the <code>caseId</code> parameter to restrict the results to a specific
    /// case.</p>
    /// <p>Case data is available for 12 months after creation. If a case was created more than
    /// 12 months ago, a request for data might cause an error.</p>
    /// <p>You can use the <code>maxResults</code> and <code>nextToken</code> parameters to
    /// control the pagination of the results. Set <code>maxResults</code> to the number of
    /// cases that you want to display on each page, and use <code>nextToken</code> to specify
    /// the resumption of pagination.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCommunications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_communications_input::Builder,
    }
    impl<C, M, R> DescribeCommunications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCommunications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCommunicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCommunicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCommunicationsInputOperationOutputAlias,
                crate::output::DescribeCommunicationsOutput,
                crate::error::DescribeCommunicationsError,
                crate::input::DescribeCommunicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an
        /// alphanumeric string formatted as shown in this example:
        /// case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
        /// </p>
        pub fn case_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id(inp);
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an
        /// alphanumeric string formatted as shown in this example:
        /// case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
        /// </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_case_id(input);
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn before_time(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_time(inp);
            self
        }
        /// <p>The end date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn set_before_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_before_time(input);
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn after_time(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_time(inp);
            self
        }
        /// <p>The start date for a filtered date search on support case communications. Case
        /// communications are available for 12 months after creation.</p>
        pub fn set_after_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after_time(input);
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A resumption point for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return before paginating.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServices`.
    ///
    /// <p>Returns the current list of AWS services and a list of service categories for each
    /// service. You then use service names and categories in your <a>CreateCase</a>
    /// requests. Each AWS service has its own set of categories.</p>
    /// <p>The service codes and category codes correspond to the values that appear in the
    /// <b>Service</b> and <b>Category</b> lists on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. The values in those fields
    /// don't necessarily match the service codes and categories returned by the
    /// <code>DescribeServices</code> operation. Always use the service codes and categories
    /// that the <code>DescribeServices</code> operation returns, so that you have the most
    /// recent set of service and category codes.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeServices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_services_input::Builder,
    }
    impl<C, M, R> DescribeServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeServicesInputOperationOutputAlias,
                crate::output::DescribeServicesOutput,
                crate::error::DescribeServicesError,
                crate::input::DescribeServicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `serviceCodeList`.
        ///
        /// To override the contents of this collection use [`set_service_code_list`](Self::set_service_code_list).
        ///
        /// <p>A JSON-formatted list of service codes available for AWS services.</p>
        pub fn service_code_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code_list(inp);
            self
        }
        /// <p>A JSON-formatted list of service codes available for AWS services.</p>
        pub fn set_service_code_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_service_code_list(input);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSeverityLevels`.
    ///
    /// <p>Returns the list of severity levels that you can assign to a support case. The severity
    /// level for a case is also a field in the <a>CaseDetails</a> data type that you
    /// include for a <a>CreateCase</a> request.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSeverityLevels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_severity_levels_input::Builder,
    }
    impl<C, M, R> DescribeSeverityLevels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSeverityLevels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSeverityLevelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSeverityLevelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSeverityLevelsInputOperationOutputAlias,
                crate::output::DescribeSeverityLevelsOutput,
                crate::error::DescribeSeverityLevelsError,
                crate::input::DescribeSeverityLevelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorCheckRefreshStatuses`.
    ///
    /// <p>Returns the refresh status of the AWS Trusted Advisor checks that have the specified check
    /// IDs. You can get the check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.</p>
    /// <p>Some checks are refreshed automatically, and you can't return their refresh statuses
    /// by using the <code>DescribeTrustedAdvisorCheckRefreshStatuses</code> operation. If you
    /// call this operation for these checks, you might see an
    /// <code>InvalidParameterValue</code> error.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorCheckRefreshStatuses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trusted_advisor_check_refresh_statuses_input::Builder,
    }
    impl<C, M, R> DescribeTrustedAdvisorCheckRefreshStatuses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrustedAdvisorCheckRefreshStatuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeTrustedAdvisorCheckRefreshStatusesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInputOperationOutputAlias,
                crate::output::DescribeTrustedAdvisorCheckRefreshStatusesOutput,
                crate::error::DescribeTrustedAdvisorCheckRefreshStatusesError,
                crate::input::DescribeTrustedAdvisorCheckRefreshStatusesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `checkIds`.
        ///
        /// To override the contents of this collection use [`set_check_ids`](Self::set_check_ids).
        ///
        /// <p>The IDs of the Trusted Advisor checks to get the status.</p>
        /// <note>
        /// <p>If you specify the check ID of a check that is automatically refreshed, you might
        /// see an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn check_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_ids(inp);
            self
        }
        /// <p>The IDs of the Trusted Advisor checks to get the status.</p>
        /// <note>
        /// <p>If you specify the check ID of a check that is automatically refreshed, you might
        /// see an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn set_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_check_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorCheckResult`.
    ///
    /// <p>Returns the results of the AWS Trusted Advisor check that has the specified check ID. You
    /// can get the check IDs by calling the <a>DescribeTrustedAdvisorChecks</a>
    /// operation.</p>
    /// <p>The response contains a <a>TrustedAdvisorCheckResult</a> object, which
    /// contains these three objects:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>TrustedAdvisorCategorySpecificSummary</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>TrustedAdvisorResourceDetail</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>TrustedAdvisorResourcesSummary</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>In addition, the response contains these fields:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>status</b> - The alert status of the check
    /// can be <code>ok</code> (green), <code>warning</code> (yellow),
    /// <code>error</code> (red), or <code>not_available</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>timestamp</b> - The time of the last refresh
    /// of the check.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>checkId</b> - The unique identifier for the
    /// check.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorCheckResult<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trusted_advisor_check_result_input::Builder,
    }
    impl<C, M, R> DescribeTrustedAdvisorCheckResult<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrustedAdvisorCheckResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorCheckResultOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrustedAdvisorCheckResultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrustedAdvisorCheckResultInputOperationOutputAlias,
                crate::output::DescribeTrustedAdvisorCheckResultOutput,
                crate::error::DescribeTrustedAdvisorCheckResultError,
                crate::input::DescribeTrustedAdvisorCheckResultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn check_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_id(inp);
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check.</p>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_id(input);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorChecks`.
    ///
    /// <p>Returns information about all available AWS Trusted Advisor checks, including the name, ID,
    /// category, description, and metadata. You must specify a language code. The AWS Support API
    /// currently supports English ("en") and Japanese ("ja"). The response contains a <a>TrustedAdvisorCheckDescription</a> object for each check. You must set the
    /// AWS Region to us-east-1.</p>
    ///
    ///
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// <li>
    /// <p>The names and descriptions for Trusted Advisor checks are subject to change. We recommend
    /// that you specify the check ID in your code to uniquely identify a check.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorChecks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trusted_advisor_checks_input::Builder,
    }
    impl<C, M, R> DescribeTrustedAdvisorChecks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrustedAdvisorChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrustedAdvisorChecksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrustedAdvisorChecksInputOperationOutputAlias,
                crate::output::DescribeTrustedAdvisorChecksOutput,
                crate::error::DescribeTrustedAdvisorChecksError,
                crate::input::DescribeTrustedAdvisorChecksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The ISO 639-1 code for the language in which AWS provides support. AWS Support
        /// currently supports English ("en") and Japanese ("ja"). Language parameters must be
        /// passed explicitly for operations that take them.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrustedAdvisorCheckSummaries`.
    ///
    /// <p>Returns the results for the AWS Trusted Advisor check summaries for the check IDs that you
    /// specified. You can get the check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.</p>
    /// <p>The response contains an array of <a>TrustedAdvisorCheckSummary</a>
    /// objects.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTrustedAdvisorCheckSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trusted_advisor_check_summaries_input::Builder,
    }
    impl<C, M, R> DescribeTrustedAdvisorCheckSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrustedAdvisorCheckSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustedAdvisorCheckSummariesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeTrustedAdvisorCheckSummariesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrustedAdvisorCheckSummariesInputOperationOutputAlias,
                crate::output::DescribeTrustedAdvisorCheckSummariesOutput,
                crate::error::DescribeTrustedAdvisorCheckSummariesError,
                crate::input::DescribeTrustedAdvisorCheckSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `checkIds`.
        ///
        /// To override the contents of this collection use [`set_check_ids`](Self::set_check_ids).
        ///
        /// <p>The IDs of the Trusted Advisor checks.</p>
        pub fn check_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_ids(inp);
            self
        }
        /// <p>The IDs of the Trusted Advisor checks.</p>
        pub fn set_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_check_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshTrustedAdvisorCheck`.
    ///
    /// <p>Refreshes the AWS Trusted Advisor check that you specify using the check ID. You can get the
    /// check IDs by calling the <a>DescribeTrustedAdvisorChecks</a>
    /// operation.</p>
    /// <note>
    /// <p>Some checks are refreshed automatically. If you call the
    /// <code>RefreshTrustedAdvisorCheck</code> operation to refresh them, you might see
    /// the <code>InvalidParameterValue</code> error.</p>
    /// </note>
    /// <p>The response contains a <a>TrustedAdvisorCheckRefreshStatus</a>
    /// object.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RefreshTrustedAdvisorCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::refresh_trusted_advisor_check_input::Builder,
    }
    impl<C, M, R> RefreshTrustedAdvisorCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RefreshTrustedAdvisorCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshTrustedAdvisorCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshTrustedAdvisorCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RefreshTrustedAdvisorCheckInputOperationOutputAlias,
                crate::output::RefreshTrustedAdvisorCheckOutput,
                crate::error::RefreshTrustedAdvisorCheckError,
                crate::input::RefreshTrustedAdvisorCheckInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Trusted Advisor check to refresh.</p>     
        /// <note>
        /// <p>Specifying the check ID of a check that is automatically refreshed
        /// causes an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn check_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_id(inp);
            self
        }
        /// <p>The unique identifier for the Trusted Advisor check to refresh.</p>     
        /// <note>
        /// <p>Specifying the check ID of a check that is automatically refreshed
        /// causes an <code>InvalidParameterValue</code> error.</p>
        /// </note>
        pub fn set_check_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResolveCase`.
    ///
    /// <p>Resolves a support case. This operation takes a <code>caseId</code> and returns the
    /// initial and final state of the case.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You must have a Business or Enterprise Support plan to use the AWS Support
    /// API. </p>
    /// </li>
    /// <li>
    /// <p>If you call the AWS Support API from an account that does not have a
    /// Business or Enterprise Support plan, the
    /// <code>SubscriptionRequiredException</code> error message appears. For
    /// information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ResolveCase<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resolve_case_input::Builder,
    }
    impl<C, M, R> ResolveCase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResolveCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResolveCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::ResolveCaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResolveCaseInputOperationOutputAlias,
                crate::output::ResolveCaseOutput,
                crate::error::ResolveCaseError,
                crate::input::ResolveCaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an
        /// alphanumeric string formatted as shown in this example:
        /// case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
        /// </p>
        pub fn case_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.case_id(inp);
            self
        }
        /// <p>The support case ID requested or returned in the call. The case ID is an
        /// alphanumeric string formatted as shown in this example:
        /// case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
        /// </p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_case_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
