// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddAttachmentsToSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddAttachmentsToSetError {
    /// Kind of error that occurred.
    pub kind: AddAttachmentsToSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddAttachmentsToSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddAttachmentsToSetErrorKind {
    /// <p>The limit for the number of attachment sets created in a short period of time has been
    /// exceeded.</p>
    AttachmentLimitExceeded(crate::error::AttachmentLimitExceeded),
    /// <p>The expiration time of the attachment set has passed. The set expires 1 hour after it
    /// is created.</p>
    AttachmentSetExpired(crate::error::AttachmentSetExpired),
    /// <p>An attachment set with the specified ID could not be found.</p>
    AttachmentSetIdNotFound(crate::error::AttachmentSetIdNotFound),
    /// <p>A limit for the size of an attachment set has been exceeded. The limits are three
    /// attachments and 5 MB per attachment.</p>
    AttachmentSetSizeLimitExceeded(crate::error::AttachmentSetSizeLimitExceeded),
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddAttachmentsToSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddAttachmentsToSetErrorKind::AttachmentLimitExceeded(_inner) => _inner.fmt(f),
            AddAttachmentsToSetErrorKind::AttachmentSetExpired(_inner) => _inner.fmt(f),
            AddAttachmentsToSetErrorKind::AttachmentSetIdNotFound(_inner) => _inner.fmt(f),
            AddAttachmentsToSetErrorKind::AttachmentSetSizeLimitExceeded(_inner) => _inner.fmt(f),
            AddAttachmentsToSetErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddAttachmentsToSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddAttachmentsToSetError {
    fn code(&self) -> Option<&str> {
        AddAttachmentsToSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddAttachmentsToSetError {
    /// Creates a new `AddAttachmentsToSetError`.
    pub fn new(kind: AddAttachmentsToSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddAttachmentsToSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddAttachmentsToSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddAttachmentsToSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddAttachmentsToSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddAttachmentsToSetErrorKind::AttachmentLimitExceeded`.
    pub fn is_attachment_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            AddAttachmentsToSetErrorKind::AttachmentLimitExceeded(_)
        )
    }
    /// Returns true if the error kind is `AddAttachmentsToSetErrorKind::AttachmentSetExpired`.
    pub fn is_attachment_set_expired(&self) -> bool {
        matches!(
            &self.kind,
            AddAttachmentsToSetErrorKind::AttachmentSetExpired(_)
        )
    }
    /// Returns true if the error kind is `AddAttachmentsToSetErrorKind::AttachmentSetIdNotFound`.
    pub fn is_attachment_set_id_not_found(&self) -> bool {
        matches!(
            &self.kind,
            AddAttachmentsToSetErrorKind::AttachmentSetIdNotFound(_)
        )
    }
    /// Returns true if the error kind is `AddAttachmentsToSetErrorKind::AttachmentSetSizeLimitExceeded`.
    pub fn is_attachment_set_size_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            AddAttachmentsToSetErrorKind::AttachmentSetSizeLimitExceeded(_)
        )
    }
    /// Returns true if the error kind is `AddAttachmentsToSetErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AddAttachmentsToSetErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for AddAttachmentsToSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddAttachmentsToSetErrorKind::AttachmentLimitExceeded(_inner) => Some(_inner),
            AddAttachmentsToSetErrorKind::AttachmentSetExpired(_inner) => Some(_inner),
            AddAttachmentsToSetErrorKind::AttachmentSetIdNotFound(_inner) => Some(_inner),
            AddAttachmentsToSetErrorKind::AttachmentSetSizeLimitExceeded(_inner) => Some(_inner),
            AddAttachmentsToSetErrorKind::InternalServerError(_inner) => Some(_inner),
            AddAttachmentsToSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddCommunicationToCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddCommunicationToCaseError {
    /// Kind of error that occurred.
    pub kind: AddCommunicationToCaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddCommunicationToCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddCommunicationToCaseErrorKind {
    /// <p>The expiration time of the attachment set has passed. The set expires 1 hour after it
    /// is created.</p>
    AttachmentSetExpired(crate::error::AttachmentSetExpired),
    /// <p>An attachment set with the specified ID could not be found.</p>
    AttachmentSetIdNotFound(crate::error::AttachmentSetIdNotFound),
    /// <p>The requested <code>caseId</code> couldn't be located.</p>
    CaseIdNotFound(crate::error::CaseIdNotFound),
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddCommunicationToCaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddCommunicationToCaseErrorKind::AttachmentSetExpired(_inner) => _inner.fmt(f),
            AddCommunicationToCaseErrorKind::AttachmentSetIdNotFound(_inner) => _inner.fmt(f),
            AddCommunicationToCaseErrorKind::CaseIdNotFound(_inner) => _inner.fmt(f),
            AddCommunicationToCaseErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddCommunicationToCaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddCommunicationToCaseError {
    fn code(&self) -> Option<&str> {
        AddCommunicationToCaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddCommunicationToCaseError {
    /// Creates a new `AddCommunicationToCaseError`.
    pub fn new(kind: AddCommunicationToCaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddCommunicationToCaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddCommunicationToCaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddCommunicationToCaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddCommunicationToCaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddCommunicationToCaseErrorKind::AttachmentSetExpired`.
    pub fn is_attachment_set_expired(&self) -> bool {
        matches!(
            &self.kind,
            AddCommunicationToCaseErrorKind::AttachmentSetExpired(_)
        )
    }
    /// Returns true if the error kind is `AddCommunicationToCaseErrorKind::AttachmentSetIdNotFound`.
    pub fn is_attachment_set_id_not_found(&self) -> bool {
        matches!(
            &self.kind,
            AddCommunicationToCaseErrorKind::AttachmentSetIdNotFound(_)
        )
    }
    /// Returns true if the error kind is `AddCommunicationToCaseErrorKind::CaseIdNotFound`.
    pub fn is_case_id_not_found(&self) -> bool {
        matches!(
            &self.kind,
            AddCommunicationToCaseErrorKind::CaseIdNotFound(_)
        )
    }
    /// Returns true if the error kind is `AddCommunicationToCaseErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AddCommunicationToCaseErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for AddCommunicationToCaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddCommunicationToCaseErrorKind::AttachmentSetExpired(_inner) => Some(_inner),
            AddCommunicationToCaseErrorKind::AttachmentSetIdNotFound(_inner) => Some(_inner),
            AddCommunicationToCaseErrorKind::CaseIdNotFound(_inner) => Some(_inner),
            AddCommunicationToCaseErrorKind::InternalServerError(_inner) => Some(_inner),
            AddCommunicationToCaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCaseError {
    /// Kind of error that occurred.
    pub kind: CreateCaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCaseErrorKind {
    /// <p>The expiration time of the attachment set has passed. The set expires 1 hour after it
    /// is created.</p>
    AttachmentSetExpired(crate::error::AttachmentSetExpired),
    /// <p>An attachment set with the specified ID could not be found.</p>
    AttachmentSetIdNotFound(crate::error::AttachmentSetIdNotFound),
    /// <p>The case creation limit for the account has been exceeded.</p>
    CaseCreationLimitExceeded(crate::error::CaseCreationLimitExceeded),
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCaseErrorKind::AttachmentSetExpired(_inner) => _inner.fmt(f),
            CreateCaseErrorKind::AttachmentSetIdNotFound(_inner) => _inner.fmt(f),
            CreateCaseErrorKind::CaseCreationLimitExceeded(_inner) => _inner.fmt(f),
            CreateCaseErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateCaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCaseError {
    fn code(&self) -> Option<&str> {
        CreateCaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCaseError {
    /// Creates a new `CreateCaseError`.
    pub fn new(kind: CreateCaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateCaseErrorKind::AttachmentSetExpired`.
    pub fn is_attachment_set_expired(&self) -> bool {
        matches!(&self.kind, CreateCaseErrorKind::AttachmentSetExpired(_))
    }
    /// Returns true if the error kind is `CreateCaseErrorKind::AttachmentSetIdNotFound`.
    pub fn is_attachment_set_id_not_found(&self) -> bool {
        matches!(&self.kind, CreateCaseErrorKind::AttachmentSetIdNotFound(_))
    }
    /// Returns true if the error kind is `CreateCaseErrorKind::CaseCreationLimitExceeded`.
    pub fn is_case_creation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateCaseErrorKind::CaseCreationLimitExceeded(_)
        )
    }
    /// Returns true if the error kind is `CreateCaseErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateCaseErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for CreateCaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCaseErrorKind::AttachmentSetExpired(_inner) => Some(_inner),
            CreateCaseErrorKind::AttachmentSetIdNotFound(_inner) => Some(_inner),
            CreateCaseErrorKind::CaseCreationLimitExceeded(_inner) => Some(_inner),
            CreateCaseErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateCaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAttachmentError {
    /// Kind of error that occurred.
    pub kind: DescribeAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAttachmentErrorKind {
    /// <p>An attachment with the specified ID could not be found.</p>
    AttachmentIdNotFound(crate::error::AttachmentIdNotFound),
    /// <p>The limit for the number of <a>DescribeAttachment</a> requests in a short
    /// period of time has been exceeded.</p>
    DescribeAttachmentLimitExceeded(crate::error::DescribeAttachmentLimitExceeded),
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAttachmentErrorKind::AttachmentIdNotFound(_inner) => _inner.fmt(f),
            DescribeAttachmentErrorKind::DescribeAttachmentLimitExceeded(_inner) => _inner.fmt(f),
            DescribeAttachmentErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAttachmentError {
    fn code(&self) -> Option<&str> {
        DescribeAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAttachmentError {
    /// Creates a new `DescribeAttachmentError`.
    pub fn new(kind: DescribeAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAttachmentErrorKind::AttachmentIdNotFound`.
    pub fn is_attachment_id_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAttachmentErrorKind::AttachmentIdNotFound(_)
        )
    }
    /// Returns true if the error kind is `DescribeAttachmentErrorKind::DescribeAttachmentLimitExceeded`.
    pub fn is_describe_attachment_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAttachmentErrorKind::DescribeAttachmentLimitExceeded(_)
        )
    }
    /// Returns true if the error kind is `DescribeAttachmentErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAttachmentErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAttachmentErrorKind::AttachmentIdNotFound(_inner) => Some(_inner),
            DescribeAttachmentErrorKind::DescribeAttachmentLimitExceeded(_inner) => Some(_inner),
            DescribeAttachmentErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCasesError {
    /// Kind of error that occurred.
    pub kind: DescribeCasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCasesErrorKind {
    /// <p>The requested <code>caseId</code> couldn't be located.</p>
    CaseIdNotFound(crate::error::CaseIdNotFound),
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCasesErrorKind::CaseIdNotFound(_inner) => _inner.fmt(f),
            DescribeCasesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeCasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCasesError {
    fn code(&self) -> Option<&str> {
        DescribeCasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCasesError {
    /// Creates a new `DescribeCasesError`.
    pub fn new(kind: DescribeCasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCasesErrorKind::CaseIdNotFound`.
    pub fn is_case_id_not_found(&self) -> bool {
        matches!(&self.kind, DescribeCasesErrorKind::CaseIdNotFound(_))
    }
    /// Returns true if the error kind is `DescribeCasesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeCasesErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for DescribeCasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCasesErrorKind::CaseIdNotFound(_inner) => Some(_inner),
            DescribeCasesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeCasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCommunications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCommunicationsError {
    /// Kind of error that occurred.
    pub kind: DescribeCommunicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCommunications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCommunicationsErrorKind {
    /// <p>The requested <code>caseId</code> couldn't be located.</p>
    CaseIdNotFound(crate::error::CaseIdNotFound),
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCommunicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCommunicationsErrorKind::CaseIdNotFound(_inner) => _inner.fmt(f),
            DescribeCommunicationsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeCommunicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCommunicationsError {
    fn code(&self) -> Option<&str> {
        DescribeCommunicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCommunicationsError {
    /// Creates a new `DescribeCommunicationsError`.
    pub fn new(kind: DescribeCommunicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCommunicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCommunicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCommunicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCommunicationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCommunicationsErrorKind::CaseIdNotFound`.
    pub fn is_case_id_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCommunicationsErrorKind::CaseIdNotFound(_)
        )
    }
    /// Returns true if the error kind is `DescribeCommunicationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCommunicationsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeCommunicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCommunicationsErrorKind::CaseIdNotFound(_inner) => Some(_inner),
            DescribeCommunicationsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeCommunicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServicesError {
    /// Kind of error that occurred.
    pub kind: DescribeServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServicesErrorKind {
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServicesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServicesError {
    fn code(&self) -> Option<&str> {
        DescribeServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServicesError {
    /// Creates a new `DescribeServicesError`.
    pub fn new(kind: DescribeServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeServicesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServicesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServicesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSeverityLevels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSeverityLevelsError {
    /// Kind of error that occurred.
    pub kind: DescribeSeverityLevelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSeverityLevels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSeverityLevelsErrorKind {
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSeverityLevelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSeverityLevelsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeSeverityLevelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSeverityLevelsError {
    fn code(&self) -> Option<&str> {
        DescribeSeverityLevelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSeverityLevelsError {
    /// Creates a new `DescribeSeverityLevelsError`.
    pub fn new(kind: DescribeSeverityLevelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSeverityLevelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSeverityLevelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSeverityLevelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSeverityLevelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSeverityLevelsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSeverityLevelsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeSeverityLevelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSeverityLevelsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeSeverityLevelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTrustedAdvisorCheckRefreshStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTrustedAdvisorCheckRefreshStatusesError {
    /// Kind of error that occurred.
    pub kind: DescribeTrustedAdvisorCheckRefreshStatusesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTrustedAdvisorCheckRefreshStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTrustedAdvisorCheckRefreshStatusesErrorKind {
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTrustedAdvisorCheckRefreshStatusesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTrustedAdvisorCheckRefreshStatusesError {
    fn code(&self) -> Option<&str> {
        DescribeTrustedAdvisorCheckRefreshStatusesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTrustedAdvisorCheckRefreshStatusesError {
    /// Creates a new `DescribeTrustedAdvisorCheckRefreshStatusesError`.
    pub fn new(
        kind: DescribeTrustedAdvisorCheckRefreshStatusesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTrustedAdvisorCheckRefreshStatusesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTrustedAdvisorCheckRefreshStatusesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeTrustedAdvisorCheckRefreshStatusesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeTrustedAdvisorCheckRefreshStatusesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeTrustedAdvisorCheckResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTrustedAdvisorCheckResultError {
    /// Kind of error that occurred.
    pub kind: DescribeTrustedAdvisorCheckResultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTrustedAdvisorCheckResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTrustedAdvisorCheckResultErrorKind {
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTrustedAdvisorCheckResultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTrustedAdvisorCheckResultErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeTrustedAdvisorCheckResultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTrustedAdvisorCheckResultError {
    fn code(&self) -> Option<&str> {
        DescribeTrustedAdvisorCheckResultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTrustedAdvisorCheckResultError {
    /// Creates a new `DescribeTrustedAdvisorCheckResultError`.
    pub fn new(
        kind: DescribeTrustedAdvisorCheckResultErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTrustedAdvisorCheckResultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTrustedAdvisorCheckResultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTrustedAdvisorCheckResultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTrustedAdvisorCheckResultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTrustedAdvisorCheckResultErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustedAdvisorCheckResultErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeTrustedAdvisorCheckResultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTrustedAdvisorCheckResultErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTrustedAdvisorCheckResultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTrustedAdvisorChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTrustedAdvisorChecksError {
    /// Kind of error that occurred.
    pub kind: DescribeTrustedAdvisorChecksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTrustedAdvisorChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTrustedAdvisorChecksErrorKind {
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTrustedAdvisorChecksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTrustedAdvisorChecksErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTrustedAdvisorChecksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTrustedAdvisorChecksError {
    fn code(&self) -> Option<&str> {
        DescribeTrustedAdvisorChecksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTrustedAdvisorChecksError {
    /// Creates a new `DescribeTrustedAdvisorChecksError`.
    pub fn new(kind: DescribeTrustedAdvisorChecksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTrustedAdvisorChecksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTrustedAdvisorChecksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTrustedAdvisorChecksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTrustedAdvisorChecksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTrustedAdvisorChecksErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustedAdvisorChecksErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeTrustedAdvisorChecksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTrustedAdvisorChecksErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTrustedAdvisorChecksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTrustedAdvisorCheckSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTrustedAdvisorCheckSummariesError {
    /// Kind of error that occurred.
    pub kind: DescribeTrustedAdvisorCheckSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTrustedAdvisorCheckSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTrustedAdvisorCheckSummariesErrorKind {
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTrustedAdvisorCheckSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTrustedAdvisorCheckSummariesErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeTrustedAdvisorCheckSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTrustedAdvisorCheckSummariesError {
    fn code(&self) -> Option<&str> {
        DescribeTrustedAdvisorCheckSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTrustedAdvisorCheckSummariesError {
    /// Creates a new `DescribeTrustedAdvisorCheckSummariesError`.
    pub fn new(
        kind: DescribeTrustedAdvisorCheckSummariesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTrustedAdvisorCheckSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTrustedAdvisorCheckSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTrustedAdvisorCheckSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTrustedAdvisorCheckSummariesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTrustedAdvisorCheckSummariesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustedAdvisorCheckSummariesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeTrustedAdvisorCheckSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTrustedAdvisorCheckSummariesErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeTrustedAdvisorCheckSummariesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RefreshTrustedAdvisorCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RefreshTrustedAdvisorCheckError {
    /// Kind of error that occurred.
    pub kind: RefreshTrustedAdvisorCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RefreshTrustedAdvisorCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RefreshTrustedAdvisorCheckErrorKind {
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RefreshTrustedAdvisorCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RefreshTrustedAdvisorCheckErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RefreshTrustedAdvisorCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RefreshTrustedAdvisorCheckError {
    fn code(&self) -> Option<&str> {
        RefreshTrustedAdvisorCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RefreshTrustedAdvisorCheckError {
    /// Creates a new `RefreshTrustedAdvisorCheckError`.
    pub fn new(kind: RefreshTrustedAdvisorCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RefreshTrustedAdvisorCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RefreshTrustedAdvisorCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RefreshTrustedAdvisorCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RefreshTrustedAdvisorCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RefreshTrustedAdvisorCheckErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RefreshTrustedAdvisorCheckErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for RefreshTrustedAdvisorCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RefreshTrustedAdvisorCheckErrorKind::InternalServerError(_inner) => Some(_inner),
            RefreshTrustedAdvisorCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResolveCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResolveCaseError {
    /// Kind of error that occurred.
    pub kind: ResolveCaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResolveCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResolveCaseErrorKind {
    /// <p>The requested <code>caseId</code> couldn't be located.</p>
    CaseIdNotFound(crate::error::CaseIdNotFound),
    /// <p>An internal server error occurred.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResolveCaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResolveCaseErrorKind::CaseIdNotFound(_inner) => _inner.fmt(f),
            ResolveCaseErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ResolveCaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResolveCaseError {
    fn code(&self) -> Option<&str> {
        ResolveCaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResolveCaseError {
    /// Creates a new `ResolveCaseError`.
    pub fn new(kind: ResolveCaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResolveCaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResolveCaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResolveCaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResolveCaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ResolveCaseErrorKind::CaseIdNotFound`.
    pub fn is_case_id_not_found(&self) -> bool {
        matches!(&self.kind, ResolveCaseErrorKind::CaseIdNotFound(_))
    }
    /// Returns true if the error kind is `ResolveCaseErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ResolveCaseErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for ResolveCaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResolveCaseErrorKind::CaseIdNotFound(_inner) => Some(_inner),
            ResolveCaseErrorKind::InternalServerError(_inner) => Some(_inner),
            ResolveCaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An internal server error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    /// <p>An internal server error occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An internal server error occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An internal server error occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>The requested <code>caseId</code> couldn't be located.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaseIdNotFound {
    /// <p>The requested <code>CaseId</code> could not be located.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CaseIdNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaseIdNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CaseIdNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CaseIdNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CaseIdNotFound")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for CaseIdNotFound {}
/// See [`CaseIdNotFound`](crate::error::CaseIdNotFound)
pub mod case_id_not_found {
    /// A builder for [`CaseIdNotFound`](crate::error::CaseIdNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The requested <code>CaseId</code> could not be located.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The requested <code>CaseId</code> could not be located.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CaseIdNotFound`](crate::error::CaseIdNotFound)
        pub fn build(self) -> crate::error::CaseIdNotFound {
            crate::error::CaseIdNotFound {
                message: self.message,
            }
        }
    }
}
impl CaseIdNotFound {
    /// Creates a new builder-style object to manufacture [`CaseIdNotFound`](crate::error::CaseIdNotFound)
    pub fn builder() -> crate::error::case_id_not_found::Builder {
        crate::error::case_id_not_found::Builder::default()
    }
}

/// <p>The limit for the number of <a>DescribeAttachment</a> requests in a short
/// period of time has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAttachmentLimitExceeded {
    /// <p>The limit for the number of <a>DescribeAttachment</a> requests in a short
    /// period of time has been exceeded.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeAttachmentLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAttachmentLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DescribeAttachmentLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DescribeAttachmentLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DescribeAttachmentLimitExceeded")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for DescribeAttachmentLimitExceeded {}
/// See [`DescribeAttachmentLimitExceeded`](crate::error::DescribeAttachmentLimitExceeded)
pub mod describe_attachment_limit_exceeded {
    /// A builder for [`DescribeAttachmentLimitExceeded`](crate::error::DescribeAttachmentLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The limit for the number of <a>DescribeAttachment</a> requests in a short
        /// period of time has been exceeded.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The limit for the number of <a>DescribeAttachment</a> requests in a short
        /// period of time has been exceeded.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAttachmentLimitExceeded`](crate::error::DescribeAttachmentLimitExceeded)
        pub fn build(self) -> crate::error::DescribeAttachmentLimitExceeded {
            crate::error::DescribeAttachmentLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl DescribeAttachmentLimitExceeded {
    /// Creates a new builder-style object to manufacture [`DescribeAttachmentLimitExceeded`](crate::error::DescribeAttachmentLimitExceeded)
    pub fn builder() -> crate::error::describe_attachment_limit_exceeded::Builder {
        crate::error::describe_attachment_limit_exceeded::Builder::default()
    }
}

/// <p>An attachment with the specified ID could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentIdNotFound {
    /// <p>An attachment with the specified ID could not be found.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentIdNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentIdNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AttachmentIdNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AttachmentIdNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AttachmentIdNotFound")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for AttachmentIdNotFound {}
/// See [`AttachmentIdNotFound`](crate::error::AttachmentIdNotFound)
pub mod attachment_id_not_found {
    /// A builder for [`AttachmentIdNotFound`](crate::error::AttachmentIdNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An attachment with the specified ID could not be found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An attachment with the specified ID could not be found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentIdNotFound`](crate::error::AttachmentIdNotFound)
        pub fn build(self) -> crate::error::AttachmentIdNotFound {
            crate::error::AttachmentIdNotFound {
                message: self.message,
            }
        }
    }
}
impl AttachmentIdNotFound {
    /// Creates a new builder-style object to manufacture [`AttachmentIdNotFound`](crate::error::AttachmentIdNotFound)
    pub fn builder() -> crate::error::attachment_id_not_found::Builder {
        crate::error::attachment_id_not_found::Builder::default()
    }
}

/// <p>The case creation limit for the account has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaseCreationLimitExceeded {
    /// <p>An error message that indicates that you have exceeded the number of cases you can
    /// have open.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CaseCreationLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaseCreationLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CaseCreationLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CaseCreationLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CaseCreationLimitExceeded")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for CaseCreationLimitExceeded {}
/// See [`CaseCreationLimitExceeded`](crate::error::CaseCreationLimitExceeded)
pub mod case_creation_limit_exceeded {
    /// A builder for [`CaseCreationLimitExceeded`](crate::error::CaseCreationLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An error message that indicates that you have exceeded the number of cases you can
        /// have open.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An error message that indicates that you have exceeded the number of cases you can
        /// have open.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CaseCreationLimitExceeded`](crate::error::CaseCreationLimitExceeded)
        pub fn build(self) -> crate::error::CaseCreationLimitExceeded {
            crate::error::CaseCreationLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl CaseCreationLimitExceeded {
    /// Creates a new builder-style object to manufacture [`CaseCreationLimitExceeded`](crate::error::CaseCreationLimitExceeded)
    pub fn builder() -> crate::error::case_creation_limit_exceeded::Builder {
        crate::error::case_creation_limit_exceeded::Builder::default()
    }
}

/// <p>An attachment set with the specified ID could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentSetIdNotFound {
    /// <p>An attachment set with the specified ID could not be found.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentSetIdNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentSetIdNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AttachmentSetIdNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AttachmentSetIdNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AttachmentSetIdNotFound")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AttachmentSetIdNotFound {}
/// See [`AttachmentSetIdNotFound`](crate::error::AttachmentSetIdNotFound)
pub mod attachment_set_id_not_found {
    /// A builder for [`AttachmentSetIdNotFound`](crate::error::AttachmentSetIdNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An attachment set with the specified ID could not be found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An attachment set with the specified ID could not be found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentSetIdNotFound`](crate::error::AttachmentSetIdNotFound)
        pub fn build(self) -> crate::error::AttachmentSetIdNotFound {
            crate::error::AttachmentSetIdNotFound {
                message: self.message,
            }
        }
    }
}
impl AttachmentSetIdNotFound {
    /// Creates a new builder-style object to manufacture [`AttachmentSetIdNotFound`](crate::error::AttachmentSetIdNotFound)
    pub fn builder() -> crate::error::attachment_set_id_not_found::Builder {
        crate::error::attachment_set_id_not_found::Builder::default()
    }
}

/// <p>The expiration time of the attachment set has passed. The set expires 1 hour after it
/// is created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentSetExpired {
    /// <p>The expiration time of the attachment set has passed. The set expires one hour after
    /// it is created.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentSetExpired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentSetExpired");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AttachmentSetExpired {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AttachmentSetExpired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AttachmentSetExpired")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AttachmentSetExpired {}
/// See [`AttachmentSetExpired`](crate::error::AttachmentSetExpired)
pub mod attachment_set_expired {
    /// A builder for [`AttachmentSetExpired`](crate::error::AttachmentSetExpired)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The expiration time of the attachment set has passed. The set expires one hour after
        /// it is created.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The expiration time of the attachment set has passed. The set expires one hour after
        /// it is created.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentSetExpired`](crate::error::AttachmentSetExpired)
        pub fn build(self) -> crate::error::AttachmentSetExpired {
            crate::error::AttachmentSetExpired {
                message: self.message,
            }
        }
    }
}
impl AttachmentSetExpired {
    /// Creates a new builder-style object to manufacture [`AttachmentSetExpired`](crate::error::AttachmentSetExpired)
    pub fn builder() -> crate::error::attachment_set_expired::Builder {
        crate::error::attachment_set_expired::Builder::default()
    }
}

/// <p>A limit for the size of an attachment set has been exceeded. The limits are three
/// attachments and 5 MB per attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentSetSizeLimitExceeded {
    /// <p>A limit for the size of an attachment set has been exceeded. The limits are three
    /// attachments and 5 MB per attachment.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentSetSizeLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentSetSizeLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AttachmentSetSizeLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AttachmentSetSizeLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AttachmentSetSizeLimitExceeded")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AttachmentSetSizeLimitExceeded {}
/// See [`AttachmentSetSizeLimitExceeded`](crate::error::AttachmentSetSizeLimitExceeded)
pub mod attachment_set_size_limit_exceeded {
    /// A builder for [`AttachmentSetSizeLimitExceeded`](crate::error::AttachmentSetSizeLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A limit for the size of an attachment set has been exceeded. The limits are three
        /// attachments and 5 MB per attachment.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A limit for the size of an attachment set has been exceeded. The limits are three
        /// attachments and 5 MB per attachment.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentSetSizeLimitExceeded`](crate::error::AttachmentSetSizeLimitExceeded)
        pub fn build(self) -> crate::error::AttachmentSetSizeLimitExceeded {
            crate::error::AttachmentSetSizeLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl AttachmentSetSizeLimitExceeded {
    /// Creates a new builder-style object to manufacture [`AttachmentSetSizeLimitExceeded`](crate::error::AttachmentSetSizeLimitExceeded)
    pub fn builder() -> crate::error::attachment_set_size_limit_exceeded::Builder {
        crate::error::attachment_set_size_limit_exceeded::Builder::default()
    }
}

/// <p>The limit for the number of attachment sets created in a short period of time has been
/// exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentLimitExceeded {
    /// <p>The limit for the number of attachment sets created in a short period of time has been
    /// exceeded.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AttachmentLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AttachmentLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AttachmentLimitExceeded")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AttachmentLimitExceeded {}
/// See [`AttachmentLimitExceeded`](crate::error::AttachmentLimitExceeded)
pub mod attachment_limit_exceeded {
    /// A builder for [`AttachmentLimitExceeded`](crate::error::AttachmentLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The limit for the number of attachment sets created in a short period of time has been
        /// exceeded.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The limit for the number of attachment sets created in a short period of time has been
        /// exceeded.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentLimitExceeded`](crate::error::AttachmentLimitExceeded)
        pub fn build(self) -> crate::error::AttachmentLimitExceeded {
            crate::error::AttachmentLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl AttachmentLimitExceeded {
    /// Creates a new builder-style object to manufacture [`AttachmentLimitExceeded`](crate::error::AttachmentLimitExceeded)
    pub fn builder() -> crate::error::attachment_limit_exceeded::Builder {
        crate::error::attachment_limit_exceeded::Builder::default()
    }
}
