// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssumeRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssumeRoleError {
    /// Kind of error that occurred.
    pub kind: AssumeRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssumeRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssumeRoleErrorKind {
    /// <p>The web identity token that was passed is expired or is not valid. Get a new identity token from the identity provider and then retry the request.</p>
    ExpiredTokenException(crate::error::ExpiredTokenException),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because the total packed size of the session policies and session tags combined was too large. An Amazon Web Services conversion compresses the session policy document, session policy ARNs, and session tags into a packed binary format that has a separate limit. The error message indicates by percentage how close the policies and tags are to the upper size limit. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html">Passing Session Tags in STS</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You could receive this error even though you meet other defined session policy and session tag limits. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length">IAM and STS Entity Character Limits</a> in the <i>IAM User Guide</i>.</p>
    PackedPolicyTooLargeException(crate::error::PackedPolicyTooLargeException),
    /// <p>STS is not activated in the requested region for the account that is being asked to generate credentials. The account administrator must use the IAM console to activate STS in that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>IAM User Guide</i>.</p>
    RegionDisabledException(crate::error::RegionDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssumeRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssumeRoleErrorKind::ExpiredTokenException(_inner) => _inner.fmt(f),
            AssumeRoleErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            AssumeRoleErrorKind::PackedPolicyTooLargeException(_inner) => _inner.fmt(f),
            AssumeRoleErrorKind::RegionDisabledException(_inner) => _inner.fmt(f),
            AssumeRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssumeRoleError {
    fn code(&self) -> Option<&str> {
        AssumeRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssumeRoleError {
    /// Creates a new `AssumeRoleError`.
    pub fn new(kind: AssumeRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssumeRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssumeRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssumeRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssumeRoleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssumeRoleErrorKind::ExpiredTokenException`.
    pub fn is_expired_token_exception(&self) -> bool {
        matches!(&self.kind, AssumeRoleErrorKind::ExpiredTokenException(_))
    }
    /// Returns `true` if the error kind is `AssumeRoleErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleErrorKind::PackedPolicyTooLargeException`.
    pub fn is_packed_policy_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleErrorKind::PackedPolicyTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleErrorKind::RegionDisabledException`.
    pub fn is_region_disabled_exception(&self) -> bool {
        matches!(&self.kind, AssumeRoleErrorKind::RegionDisabledException(_))
    }
}
impl std::error::Error for AssumeRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssumeRoleErrorKind::ExpiredTokenException(_inner) => Some(_inner),
            AssumeRoleErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            AssumeRoleErrorKind::PackedPolicyTooLargeException(_inner) => Some(_inner),
            AssumeRoleErrorKind::RegionDisabledException(_inner) => Some(_inner),
            AssumeRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssumeRoleWithSAML` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssumeRoleWithSAMLError {
    /// Kind of error that occurred.
    pub kind: AssumeRoleWithSAMLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssumeRoleWithSAML` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssumeRoleWithSAMLErrorKind {
    /// <p>The web identity token that was passed is expired or is not valid. Get a new identity token from the identity provider and then retry the request.</p>
    ExpiredTokenException(crate::error::ExpiredTokenException),
    /// <p>The identity provider (IdP) reported that authentication failed. This might be because the claim is invalid.</p>
    /// <p>If this error is returned for the <code>AssumeRoleWithWebIdentity</code> operation, it can also mean that the claim has expired or has been explicitly revoked. </p>
    IdpRejectedClaimException(crate::error::IdpRejectedClaimException),
    /// <p>The web identity token that was passed could not be validated by Amazon Web Services. Get a new identity token from the identity provider and then retry the request.</p>
    InvalidIdentityTokenException(crate::error::InvalidIdentityTokenException),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because the total packed size of the session policies and session tags combined was too large. An Amazon Web Services conversion compresses the session policy document, session policy ARNs, and session tags into a packed binary format that has a separate limit. The error message indicates by percentage how close the policies and tags are to the upper size limit. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html">Passing Session Tags in STS</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You could receive this error even though you meet other defined session policy and session tag limits. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length">IAM and STS Entity Character Limits</a> in the <i>IAM User Guide</i>.</p>
    PackedPolicyTooLargeException(crate::error::PackedPolicyTooLargeException),
    /// <p>STS is not activated in the requested region for the account that is being asked to generate credentials. The account administrator must use the IAM console to activate STS in that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>IAM User Guide</i>.</p>
    RegionDisabledException(crate::error::RegionDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssumeRoleWithSAMLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssumeRoleWithSAMLErrorKind::ExpiredTokenException(_inner) => _inner.fmt(f),
            AssumeRoleWithSAMLErrorKind::IdpRejectedClaimException(_inner) => _inner.fmt(f),
            AssumeRoleWithSAMLErrorKind::InvalidIdentityTokenException(_inner) => _inner.fmt(f),
            AssumeRoleWithSAMLErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            AssumeRoleWithSAMLErrorKind::PackedPolicyTooLargeException(_inner) => _inner.fmt(f),
            AssumeRoleWithSAMLErrorKind::RegionDisabledException(_inner) => _inner.fmt(f),
            AssumeRoleWithSAMLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssumeRoleWithSAMLError {
    fn code(&self) -> Option<&str> {
        AssumeRoleWithSAMLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssumeRoleWithSAMLError {
    /// Creates a new `AssumeRoleWithSAMLError`.
    pub fn new(kind: AssumeRoleWithSAMLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssumeRoleWithSAMLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssumeRoleWithSAMLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssumeRoleWithSAMLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssumeRoleWithSAMLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssumeRoleWithSAMLErrorKind::ExpiredTokenException`.
    pub fn is_expired_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithSAMLErrorKind::ExpiredTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithSAMLErrorKind::IdpRejectedClaimException`.
    pub fn is_idp_rejected_claim_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithSAMLErrorKind::IdpRejectedClaimException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithSAMLErrorKind::InvalidIdentityTokenException`.
    pub fn is_invalid_identity_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithSAMLErrorKind::InvalidIdentityTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithSAMLErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithSAMLErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithSAMLErrorKind::PackedPolicyTooLargeException`.
    pub fn is_packed_policy_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithSAMLErrorKind::PackedPolicyTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithSAMLErrorKind::RegionDisabledException`.
    pub fn is_region_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithSAMLErrorKind::RegionDisabledException(_)
        )
    }
}
impl std::error::Error for AssumeRoleWithSAMLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssumeRoleWithSAMLErrorKind::ExpiredTokenException(_inner) => Some(_inner),
            AssumeRoleWithSAMLErrorKind::IdpRejectedClaimException(_inner) => Some(_inner),
            AssumeRoleWithSAMLErrorKind::InvalidIdentityTokenException(_inner) => Some(_inner),
            AssumeRoleWithSAMLErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            AssumeRoleWithSAMLErrorKind::PackedPolicyTooLargeException(_inner) => Some(_inner),
            AssumeRoleWithSAMLErrorKind::RegionDisabledException(_inner) => Some(_inner),
            AssumeRoleWithSAMLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssumeRoleWithWebIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssumeRoleWithWebIdentityError {
    /// Kind of error that occurred.
    pub kind: AssumeRoleWithWebIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssumeRoleWithWebIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssumeRoleWithWebIdentityErrorKind {
    /// <p>The web identity token that was passed is expired or is not valid. Get a new identity token from the identity provider and then retry the request.</p>
    ExpiredTokenException(crate::error::ExpiredTokenException),
    /// <p>The request could not be fulfilled because the identity provider (IDP) that was asked to verify the incoming identity token could not be reached. This is often a transient error caused by network conditions. Retry the request a limited number of times so that you don't exceed the request rate. If the error persists, the identity provider might be down or not responding.</p>
    IdpCommunicationErrorException(crate::error::IdpCommunicationErrorException),
    /// <p>The identity provider (IdP) reported that authentication failed. This might be because the claim is invalid.</p>
    /// <p>If this error is returned for the <code>AssumeRoleWithWebIdentity</code> operation, it can also mean that the claim has expired or has been explicitly revoked. </p>
    IdpRejectedClaimException(crate::error::IdpRejectedClaimException),
    /// <p>The web identity token that was passed could not be validated by Amazon Web Services. Get a new identity token from the identity provider and then retry the request.</p>
    InvalidIdentityTokenException(crate::error::InvalidIdentityTokenException),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because the total packed size of the session policies and session tags combined was too large. An Amazon Web Services conversion compresses the session policy document, session policy ARNs, and session tags into a packed binary format that has a separate limit. The error message indicates by percentage how close the policies and tags are to the upper size limit. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html">Passing Session Tags in STS</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You could receive this error even though you meet other defined session policy and session tag limits. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length">IAM and STS Entity Character Limits</a> in the <i>IAM User Guide</i>.</p>
    PackedPolicyTooLargeException(crate::error::PackedPolicyTooLargeException),
    /// <p>STS is not activated in the requested region for the account that is being asked to generate credentials. The account administrator must use the IAM console to activate STS in that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>IAM User Guide</i>.</p>
    RegionDisabledException(crate::error::RegionDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssumeRoleWithWebIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssumeRoleWithWebIdentityErrorKind::ExpiredTokenException(_inner) => _inner.fmt(f),
            AssumeRoleWithWebIdentityErrorKind::IdpCommunicationErrorException(_inner) => {
                _inner.fmt(f)
            }
            AssumeRoleWithWebIdentityErrorKind::IdpRejectedClaimException(_inner) => _inner.fmt(f),
            AssumeRoleWithWebIdentityErrorKind::InvalidIdentityTokenException(_inner) => {
                _inner.fmt(f)
            }
            AssumeRoleWithWebIdentityErrorKind::MalformedPolicyDocumentException(_inner) => {
                _inner.fmt(f)
            }
            AssumeRoleWithWebIdentityErrorKind::PackedPolicyTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            AssumeRoleWithWebIdentityErrorKind::RegionDisabledException(_inner) => _inner.fmt(f),
            AssumeRoleWithWebIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssumeRoleWithWebIdentityError {
    fn code(&self) -> Option<&str> {
        AssumeRoleWithWebIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssumeRoleWithWebIdentityError {
    /// Creates a new `AssumeRoleWithWebIdentityError`.
    pub fn new(kind: AssumeRoleWithWebIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssumeRoleWithWebIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssumeRoleWithWebIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssumeRoleWithWebIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssumeRoleWithWebIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssumeRoleWithWebIdentityErrorKind::ExpiredTokenException`.
    pub fn is_expired_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithWebIdentityErrorKind::ExpiredTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithWebIdentityErrorKind::IdpCommunicationErrorException`.
    pub fn is_idp_communication_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithWebIdentityErrorKind::IdpCommunicationErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithWebIdentityErrorKind::IdpRejectedClaimException`.
    pub fn is_idp_rejected_claim_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithWebIdentityErrorKind::IdpRejectedClaimException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithWebIdentityErrorKind::InvalidIdentityTokenException`.
    pub fn is_invalid_identity_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithWebIdentityErrorKind::InvalidIdentityTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithWebIdentityErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithWebIdentityErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithWebIdentityErrorKind::PackedPolicyTooLargeException`.
    pub fn is_packed_policy_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithWebIdentityErrorKind::PackedPolicyTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `AssumeRoleWithWebIdentityErrorKind::RegionDisabledException`.
    pub fn is_region_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssumeRoleWithWebIdentityErrorKind::RegionDisabledException(_)
        )
    }
}
impl std::error::Error for AssumeRoleWithWebIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssumeRoleWithWebIdentityErrorKind::ExpiredTokenException(_inner) => Some(_inner),
            AssumeRoleWithWebIdentityErrorKind::IdpCommunicationErrorException(_inner) => {
                Some(_inner)
            }
            AssumeRoleWithWebIdentityErrorKind::IdpRejectedClaimException(_inner) => Some(_inner),
            AssumeRoleWithWebIdentityErrorKind::InvalidIdentityTokenException(_inner) => {
                Some(_inner)
            }
            AssumeRoleWithWebIdentityErrorKind::MalformedPolicyDocumentException(_inner) => {
                Some(_inner)
            }
            AssumeRoleWithWebIdentityErrorKind::PackedPolicyTooLargeException(_inner) => {
                Some(_inner)
            }
            AssumeRoleWithWebIdentityErrorKind::RegionDisabledException(_inner) => Some(_inner),
            AssumeRoleWithWebIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DecodeAuthorizationMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DecodeAuthorizationMessageError {
    /// Kind of error that occurred.
    pub kind: DecodeAuthorizationMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DecodeAuthorizationMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DecodeAuthorizationMessageErrorKind {
    /// <p>The error returned if the message passed to <code>DecodeAuthorizationMessage</code> was invalid. This can happen if the token contains invalid characters, such as linebreaks. </p>
    InvalidAuthorizationMessageException(crate::error::InvalidAuthorizationMessageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DecodeAuthorizationMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DecodeAuthorizationMessageErrorKind::InvalidAuthorizationMessageException(_inner) => {
                _inner.fmt(f)
            }
            DecodeAuthorizationMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DecodeAuthorizationMessageError {
    fn code(&self) -> Option<&str> {
        DecodeAuthorizationMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DecodeAuthorizationMessageError {
    /// Creates a new `DecodeAuthorizationMessageError`.
    pub fn new(kind: DecodeAuthorizationMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DecodeAuthorizationMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DecodeAuthorizationMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DecodeAuthorizationMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DecodeAuthorizationMessageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DecodeAuthorizationMessageErrorKind::InvalidAuthorizationMessageException`.
    pub fn is_invalid_authorization_message_exception(&self) -> bool {
        matches!(
            &self.kind,
            DecodeAuthorizationMessageErrorKind::InvalidAuthorizationMessageException(_)
        )
    }
}
impl std::error::Error for DecodeAuthorizationMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DecodeAuthorizationMessageErrorKind::InvalidAuthorizationMessageException(_inner) => {
                Some(_inner)
            }
            DecodeAuthorizationMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccessKeyInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccessKeyInfoError {
    /// Kind of error that occurred.
    pub kind: GetAccessKeyInfoErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccessKeyInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccessKeyInfoErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccessKeyInfoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccessKeyInfoErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccessKeyInfoError {
    fn code(&self) -> Option<&str> {
        GetAccessKeyInfoError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccessKeyInfoError {
    /// Creates a new `GetAccessKeyInfoError`.
    pub fn new(kind: GetAccessKeyInfoErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccessKeyInfoError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccessKeyInfoErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccessKeyInfoError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccessKeyInfoErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetAccessKeyInfoError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccessKeyInfoErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCallerIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCallerIdentityError {
    /// Kind of error that occurred.
    pub kind: GetCallerIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCallerIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCallerIdentityErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCallerIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCallerIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCallerIdentityError {
    fn code(&self) -> Option<&str> {
        GetCallerIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCallerIdentityError {
    /// Creates a new `GetCallerIdentityError`.
    pub fn new(kind: GetCallerIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCallerIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCallerIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCallerIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCallerIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetCallerIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCallerIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFederationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFederationTokenError {
    /// Kind of error that occurred.
    pub kind: GetFederationTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFederationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFederationTokenErrorKind {
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because the total packed size of the session policies and session tags combined was too large. An Amazon Web Services conversion compresses the session policy document, session policy ARNs, and session tags into a packed binary format that has a separate limit. The error message indicates by percentage how close the policies and tags are to the upper size limit. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html">Passing Session Tags in STS</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You could receive this error even though you meet other defined session policy and session tag limits. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length">IAM and STS Entity Character Limits</a> in the <i>IAM User Guide</i>.</p>
    PackedPolicyTooLargeException(crate::error::PackedPolicyTooLargeException),
    /// <p>STS is not activated in the requested region for the account that is being asked to generate credentials. The account administrator must use the IAM console to activate STS in that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>IAM User Guide</i>.</p>
    RegionDisabledException(crate::error::RegionDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFederationTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFederationTokenErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::PackedPolicyTooLargeException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::RegionDisabledException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFederationTokenError {
    fn code(&self) -> Option<&str> {
        GetFederationTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFederationTokenError {
    /// Creates a new `GetFederationTokenError`.
    pub fn new(kind: GetFederationTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFederationTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFederationTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFederationTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFederationTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::PackedPolicyTooLargeException`.
    pub fn is_packed_policy_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::PackedPolicyTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::RegionDisabledException`.
    pub fn is_region_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::RegionDisabledException(_)
        )
    }
}
impl std::error::Error for GetFederationTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFederationTokenErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::PackedPolicyTooLargeException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::RegionDisabledException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSessionToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSessionTokenError {
    /// Kind of error that occurred.
    pub kind: GetSessionTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSessionToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSessionTokenErrorKind {
    /// <p>STS is not activated in the requested region for the account that is being asked to generate credentials. The account administrator must use the IAM console to activate STS in that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>IAM User Guide</i>.</p>
    RegionDisabledException(crate::error::RegionDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSessionTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSessionTokenErrorKind::RegionDisabledException(_inner) => _inner.fmt(f),
            GetSessionTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSessionTokenError {
    fn code(&self) -> Option<&str> {
        GetSessionTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSessionTokenError {
    /// Creates a new `GetSessionTokenError`.
    pub fn new(kind: GetSessionTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSessionTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSessionTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSessionTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSessionTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSessionTokenErrorKind::RegionDisabledException`.
    pub fn is_region_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionTokenErrorKind::RegionDisabledException(_)
        )
    }
}
impl std::error::Error for GetSessionTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSessionTokenErrorKind::RegionDisabledException(_inner) => Some(_inner),
            GetSessionTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>STS is not activated in the requested region for the account that is being asked to generate credentials. The account administrator must use the IAM console to activate STS in that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>IAM User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegionDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RegionDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RegionDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RegionDisabledException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for RegionDisabledException {}
/// See [`RegionDisabledException`](crate::error::RegionDisabledException)
pub mod region_disabled_exception {
    /// A builder for [`RegionDisabledException`](crate::error::RegionDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionDisabledException`](crate::error::RegionDisabledException)
        pub fn build(self) -> crate::error::RegionDisabledException {
            crate::error::RegionDisabledException {
                message: self.message,
            }
        }
    }
}
impl RegionDisabledException {
    /// Creates a new builder-style object to manufacture [`RegionDisabledException`](crate::error::RegionDisabledException)
    pub fn builder() -> crate::error::region_disabled_exception::Builder {
        crate::error::region_disabled_exception::Builder::default()
    }
}

/// <p>The request was rejected because the total packed size of the session policies and session tags combined was too large. An Amazon Web Services conversion compresses the session policy document, session policy ARNs, and session tags into a packed binary format that has a separate limit. The error message indicates by percentage how close the policies and tags are to the upper size limit. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html">Passing Session Tags in STS</a> in the <i>IAM User Guide</i>.</p>
/// <p>You could receive this error even though you meet other defined session policy and session tag limits. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length">IAM and STS Entity Character Limits</a> in the <i>IAM User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackedPolicyTooLargeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PackedPolicyTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackedPolicyTooLargeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PackedPolicyTooLargeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PackedPolicyTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PackedPolicyTooLargeException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for PackedPolicyTooLargeException {}
/// See [`PackedPolicyTooLargeException`](crate::error::PackedPolicyTooLargeException)
pub mod packed_policy_too_large_exception {
    /// A builder for [`PackedPolicyTooLargeException`](crate::error::PackedPolicyTooLargeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PackedPolicyTooLargeException`](crate::error::PackedPolicyTooLargeException)
        pub fn build(self) -> crate::error::PackedPolicyTooLargeException {
            crate::error::PackedPolicyTooLargeException {
                message: self.message,
            }
        }
    }
}
impl PackedPolicyTooLargeException {
    /// Creates a new builder-style object to manufacture [`PackedPolicyTooLargeException`](crate::error::PackedPolicyTooLargeException)
    pub fn builder() -> crate::error::packed_policy_too_large_exception::Builder {
        crate::error::packed_policy_too_large_exception::Builder::default()
    }
}

/// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedPolicyDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedPolicyDocumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedPolicyDocumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedPolicyDocumentException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedPolicyDocumentException {}
/// See [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
pub mod malformed_policy_document_exception {
    /// A builder for [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
        pub fn build(self) -> crate::error::MalformedPolicyDocumentException {
            crate::error::MalformedPolicyDocumentException {
                message: self.message,
            }
        }
    }
}
impl MalformedPolicyDocumentException {
    /// Creates a new builder-style object to manufacture [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    pub fn builder() -> crate::error::malformed_policy_document_exception::Builder {
        crate::error::malformed_policy_document_exception::Builder::default()
    }
}

/// <p>The error returned if the message passed to <code>DecodeAuthorizationMessage</code> was invalid. This can happen if the token contains invalid characters, such as linebreaks. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAuthorizationMessageException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAuthorizationMessageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAuthorizationMessageException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAuthorizationMessageException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAuthorizationMessageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAuthorizationMessageException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAuthorizationMessageException {}
/// See [`InvalidAuthorizationMessageException`](crate::error::InvalidAuthorizationMessageException)
pub mod invalid_authorization_message_exception {
    /// A builder for [`InvalidAuthorizationMessageException`](crate::error::InvalidAuthorizationMessageException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAuthorizationMessageException`](crate::error::InvalidAuthorizationMessageException)
        pub fn build(self) -> crate::error::InvalidAuthorizationMessageException {
            crate::error::InvalidAuthorizationMessageException {
                message: self.message,
            }
        }
    }
}
impl InvalidAuthorizationMessageException {
    /// Creates a new builder-style object to manufacture [`InvalidAuthorizationMessageException`](crate::error::InvalidAuthorizationMessageException)
    pub fn builder() -> crate::error::invalid_authorization_message_exception::Builder {
        crate::error::invalid_authorization_message_exception::Builder::default()
    }
}

/// <p>The web identity token that was passed could not be validated by Amazon Web Services. Get a new identity token from the identity provider and then retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidIdentityTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidIdentityTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidIdentityTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidIdentityTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidIdentityTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidIdentityTokenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidIdentityTokenException {}
/// See [`InvalidIdentityTokenException`](crate::error::InvalidIdentityTokenException)
pub mod invalid_identity_token_exception {
    /// A builder for [`InvalidIdentityTokenException`](crate::error::InvalidIdentityTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidIdentityTokenException`](crate::error::InvalidIdentityTokenException)
        pub fn build(self) -> crate::error::InvalidIdentityTokenException {
            crate::error::InvalidIdentityTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidIdentityTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidIdentityTokenException`](crate::error::InvalidIdentityTokenException)
    pub fn builder() -> crate::error::invalid_identity_token_exception::Builder {
        crate::error::invalid_identity_token_exception::Builder::default()
    }
}

/// <p>The identity provider (IdP) reported that authentication failed. This might be because the claim is invalid.</p>
/// <p>If this error is returned for the <code>AssumeRoleWithWebIdentity</code> operation, it can also mean that the claim has expired or has been explicitly revoked. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdpRejectedClaimException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdpRejectedClaimException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdpRejectedClaimException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdpRejectedClaimException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdpRejectedClaimException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdpRejectedClaimException [IDPRejectedClaimException]")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdpRejectedClaimException {}
/// See [`IdpRejectedClaimException`](crate::error::IdpRejectedClaimException)
pub mod idp_rejected_claim_exception {
    /// A builder for [`IdpRejectedClaimException`](crate::error::IdpRejectedClaimException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdpRejectedClaimException`](crate::error::IdpRejectedClaimException)
        pub fn build(self) -> crate::error::IdpRejectedClaimException {
            crate::error::IdpRejectedClaimException {
                message: self.message,
            }
        }
    }
}
impl IdpRejectedClaimException {
    /// Creates a new builder-style object to manufacture [`IdpRejectedClaimException`](crate::error::IdpRejectedClaimException)
    pub fn builder() -> crate::error::idp_rejected_claim_exception::Builder {
        crate::error::idp_rejected_claim_exception::Builder::default()
    }
}

/// <p>The request could not be fulfilled because the identity provider (IDP) that was asked to verify the incoming identity token could not be reached. This is often a transient error caused by network conditions. Retry the request a limited number of times so that you don't exceed the request rate. If the error persists, the identity provider might be down or not responding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdpCommunicationErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdpCommunicationErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdpCommunicationErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdpCommunicationErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdpCommunicationErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "IdpCommunicationErrorException [IDPCommunicationErrorException]"
        )?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdpCommunicationErrorException {}
/// See [`IdpCommunicationErrorException`](crate::error::IdpCommunicationErrorException)
pub mod idp_communication_error_exception {
    /// A builder for [`IdpCommunicationErrorException`](crate::error::IdpCommunicationErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdpCommunicationErrorException`](crate::error::IdpCommunicationErrorException)
        pub fn build(self) -> crate::error::IdpCommunicationErrorException {
            crate::error::IdpCommunicationErrorException {
                message: self.message,
            }
        }
    }
}
impl IdpCommunicationErrorException {
    /// Creates a new builder-style object to manufacture [`IdpCommunicationErrorException`](crate::error::IdpCommunicationErrorException)
    pub fn builder() -> crate::error::idp_communication_error_exception::Builder {
        crate::error::idp_communication_error_exception::Builder::default()
    }
}

/// <p>The web identity token that was passed is expired or is not valid. Get a new identity token from the identity provider and then retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiredTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExpiredTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiredTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExpiredTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExpiredTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExpiredTokenException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExpiredTokenException {}
/// See [`ExpiredTokenException`](crate::error::ExpiredTokenException)
pub mod expired_token_exception {
    /// A builder for [`ExpiredTokenException`](crate::error::ExpiredTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiredTokenException`](crate::error::ExpiredTokenException)
        pub fn build(self) -> crate::error::ExpiredTokenException {
            crate::error::ExpiredTokenException {
                message: self.message,
            }
        }
    }
}
impl ExpiredTokenException {
    /// Creates a new builder-style object to manufacture [`ExpiredTokenException`](crate::error::ExpiredTokenException)
    pub fn builder() -> crate::error::expired_token_exception::Builder {
        crate::error::expired_token_exception::Builder::default()
    }
}
