// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the response to a successful <code>GetSessionToken</code> request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSessionTokenOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub credentials: std::option::Option<crate::model::Credentials>,
}
impl GetSessionTokenOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn credentials(&self) -> std::option::Option<&crate::model::Credentials> {
        self.credentials.as_ref()
    }
}
impl std::fmt::Debug for GetSessionTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionTokenOutput");
        formatter.field("credentials", &self.credentials);
        formatter.finish()
    }
}
/// See [`GetSessionTokenOutput`](crate::output::GetSessionTokenOutput)
pub mod get_session_token_output {
    /// A builder for [`GetSessionTokenOutput`](crate::output::GetSessionTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
    }
    impl Builder {
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionTokenOutput`](crate::output::GetSessionTokenOutput)
        pub fn build(self) -> crate::output::GetSessionTokenOutput {
            crate::output::GetSessionTokenOutput {
                credentials: self.credentials,
            }
        }
    }
}
impl GetSessionTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetSessionTokenOutput`](crate::output::GetSessionTokenOutput)
    pub fn builder() -> crate::output::get_session_token_output::Builder {
        crate::output::get_session_token_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetFederationToken</code> request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFederationTokenOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub credentials: std::option::Option<crate::model::Credentials>,
    /// <p>Identifiers for the federated user associated with the credentials (such as <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can use the federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy. </p>
    pub federated_user: std::option::Option<crate::model::FederatedUser>,
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub packed_policy_size: std::option::Option<i32>,
}
impl GetFederationTokenOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn credentials(&self) -> std::option::Option<&crate::model::Credentials> {
        self.credentials.as_ref()
    }
    /// <p>Identifiers for the federated user associated with the credentials (such as <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can use the federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy. </p>
    pub fn federated_user(&self) -> std::option::Option<&crate::model::FederatedUser> {
        self.federated_user.as_ref()
    }
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub fn packed_policy_size(&self) -> std::option::Option<i32> {
        self.packed_policy_size
    }
}
impl std::fmt::Debug for GetFederationTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFederationTokenOutput");
        formatter.field("credentials", &self.credentials);
        formatter.field("federated_user", &self.federated_user);
        formatter.field("packed_policy_size", &self.packed_policy_size);
        formatter.finish()
    }
}
/// See [`GetFederationTokenOutput`](crate::output::GetFederationTokenOutput)
pub mod get_federation_token_output {
    /// A builder for [`GetFederationTokenOutput`](crate::output::GetFederationTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
        pub(crate) federated_user: std::option::Option<crate::model::FederatedUser>,
        pub(crate) packed_policy_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// <p>Identifiers for the federated user associated with the credentials (such as <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can use the federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy. </p>
        pub fn federated_user(mut self, input: crate::model::FederatedUser) -> Self {
            self.federated_user = Some(input);
            self
        }
        /// <p>Identifiers for the federated user associated with the credentials (such as <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can use the federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy. </p>
        pub fn set_federated_user(
            mut self,
            input: std::option::Option<crate::model::FederatedUser>,
        ) -> Self {
            self.federated_user = input;
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn packed_policy_size(mut self, input: i32) -> Self {
            self.packed_policy_size = Some(input);
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn set_packed_policy_size(mut self, input: std::option::Option<i32>) -> Self {
            self.packed_policy_size = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFederationTokenOutput`](crate::output::GetFederationTokenOutput)
        pub fn build(self) -> crate::output::GetFederationTokenOutput {
            crate::output::GetFederationTokenOutput {
                credentials: self.credentials,
                federated_user: self.federated_user,
                packed_policy_size: self.packed_policy_size,
            }
        }
    }
}
impl GetFederationTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetFederationTokenOutput`](crate::output::GetFederationTokenOutput)
    pub fn builder() -> crate::output::get_federation_token_output::Builder {
        crate::output::get_federation_token_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetCallerIdentity</code> request, including information about the entity making the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCallerIdentityOutput {
    /// <p>The unique identifier of the calling entity. The exact value depends on the type of entity that is making the call. The values returned are those listed in the <b>aws:userid</b> column in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable">Principal table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID number of the account that owns or contains the calling entity.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services ARN associated with the calling entity.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetCallerIdentityOutput {
    /// <p>The unique identifier of the calling entity. The exact value depends on the type of entity that is making the call. The values returned are those listed in the <b>aws:userid</b> column in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable">Principal table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID number of the account that owns or contains the calling entity.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
    /// <p>The Amazon Web Services ARN associated with the calling entity.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetCallerIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCallerIdentityOutput");
        formatter.field("user_id", &self.user_id);
        formatter.field("account", &self.account);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`GetCallerIdentityOutput`](crate::output::GetCallerIdentityOutput)
pub mod get_caller_identity_output {
    /// A builder for [`GetCallerIdentityOutput`](crate::output::GetCallerIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the calling entity. The exact value depends on the type of entity that is making the call. The values returned are those listed in the <b>aws:userid</b> column in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable">Principal table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the calling entity. The exact value depends on the type of entity that is making the call. The values returned are those listed in the <b>aws:userid</b> column in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable">Principal table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID number of the account that owns or contains the calling entity.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID number of the account that owns or contains the calling entity.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>The Amazon Web Services ARN associated with the calling entity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services ARN associated with the calling entity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCallerIdentityOutput`](crate::output::GetCallerIdentityOutput)
        pub fn build(self) -> crate::output::GetCallerIdentityOutput {
            crate::output::GetCallerIdentityOutput {
                user_id: self.user_id,
                account: self.account,
                arn: self.arn,
            }
        }
    }
}
impl GetCallerIdentityOutput {
    /// Creates a new builder-style object to manufacture [`GetCallerIdentityOutput`](crate::output::GetCallerIdentityOutput)
    pub fn builder() -> crate::output::get_caller_identity_output::Builder {
        crate::output::get_caller_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessKeyInfoOutput {
    /// <p>The number used to identify the Amazon Web Services account.</p>
    pub account: std::option::Option<std::string::String>,
}
impl GetAccessKeyInfoOutput {
    /// <p>The number used to identify the Amazon Web Services account.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
}
impl std::fmt::Debug for GetAccessKeyInfoOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessKeyInfoOutput");
        formatter.field("account", &self.account);
        formatter.finish()
    }
}
/// See [`GetAccessKeyInfoOutput`](crate::output::GetAccessKeyInfoOutput)
pub mod get_access_key_info_output {
    /// A builder for [`GetAccessKeyInfoOutput`](crate::output::GetAccessKeyInfoOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number used to identify the Amazon Web Services account.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The number used to identify the Amazon Web Services account.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessKeyInfoOutput`](crate::output::GetAccessKeyInfoOutput)
        pub fn build(self) -> crate::output::GetAccessKeyInfoOutput {
            crate::output::GetAccessKeyInfoOutput {
                account: self.account,
            }
        }
    }
}
impl GetAccessKeyInfoOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessKeyInfoOutput`](crate::output::GetAccessKeyInfoOutput)
    pub fn builder() -> crate::output::get_access_key_info_output::Builder {
        crate::output::get_access_key_info_output::Builder::default()
    }
}

/// <p>A document that contains additional information about the authorization status of a request from an encoded message that is returned in response to an Amazon Web Services request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecodeAuthorizationMessageOutput {
    /// <p>The API returns a response with the decoded message.</p>
    pub decoded_message: std::option::Option<std::string::String>,
}
impl DecodeAuthorizationMessageOutput {
    /// <p>The API returns a response with the decoded message.</p>
    pub fn decoded_message(&self) -> std::option::Option<&str> {
        self.decoded_message.as_deref()
    }
}
impl std::fmt::Debug for DecodeAuthorizationMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecodeAuthorizationMessageOutput");
        formatter.field("decoded_message", &self.decoded_message);
        formatter.finish()
    }
}
/// See [`DecodeAuthorizationMessageOutput`](crate::output::DecodeAuthorizationMessageOutput)
pub mod decode_authorization_message_output {
    /// A builder for [`DecodeAuthorizationMessageOutput`](crate::output::DecodeAuthorizationMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) decoded_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API returns a response with the decoded message.</p>
        pub fn decoded_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.decoded_message = Some(input.into());
            self
        }
        /// <p>The API returns a response with the decoded message.</p>
        pub fn set_decoded_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.decoded_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DecodeAuthorizationMessageOutput`](crate::output::DecodeAuthorizationMessageOutput)
        pub fn build(self) -> crate::output::DecodeAuthorizationMessageOutput {
            crate::output::DecodeAuthorizationMessageOutput {
                decoded_message: self.decoded_message,
            }
        }
    }
}
impl DecodeAuthorizationMessageOutput {
    /// Creates a new builder-style object to manufacture [`DecodeAuthorizationMessageOutput`](crate::output::DecodeAuthorizationMessageOutput)
    pub fn builder() -> crate::output::decode_authorization_message_output::Builder {
        crate::output::decode_authorization_message_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>AssumeRoleWithWebIdentity</code> request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssumeRoleWithWebIdentityOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub credentials: std::option::Option<crate::model::Credentials>,
    /// <p>The unique user identifier that is returned by the identity provider. This identifier is associated with the <code>WebIdentityToken</code> that was submitted with the <code>AssumeRoleWithWebIdentity</code> call. The identifier is typically unique to the user and the application that acquired the <code>WebIdentityToken</code> (pairwise identifier). For OpenID Connect ID tokens, this field contains the value returned by the identity provider as the token's <code>sub</code> (Subject) claim. </p>
    pub subject_from_web_identity_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
    pub assumed_role_user: std::option::Option<crate::model::AssumedRoleUser>,
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub packed_policy_size: std::option::Option<i32>,
    /// <p> The issuing authority of the web identity token presented. For OpenID Connect ID tokens, this contains the value of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code> request.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The intended audience (also known as client ID) of the web identity token. This is traditionally the client identifier issued to the application that requested the web identity token.</p>
    pub audience: std::option::Option<std::string::String>,
    /// <p>The value of the source identity that is returned in the JSON web token (JWT) from the identity provider.</p>
    /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithWebIdentity</code>. You do this by adding a claim to the JSON web token. To learn more about OIDC tokens and claims, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html">Using Tokens with User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
    pub source_identity: std::option::Option<std::string::String>,
}
impl AssumeRoleWithWebIdentityOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn credentials(&self) -> std::option::Option<&crate::model::Credentials> {
        self.credentials.as_ref()
    }
    /// <p>The unique user identifier that is returned by the identity provider. This identifier is associated with the <code>WebIdentityToken</code> that was submitted with the <code>AssumeRoleWithWebIdentity</code> call. The identifier is typically unique to the user and the application that acquired the <code>WebIdentityToken</code> (pairwise identifier). For OpenID Connect ID tokens, this field contains the value returned by the identity provider as the token's <code>sub</code> (Subject) claim. </p>
    pub fn subject_from_web_identity_token(&self) -> std::option::Option<&str> {
        self.subject_from_web_identity_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
    pub fn assumed_role_user(&self) -> std::option::Option<&crate::model::AssumedRoleUser> {
        self.assumed_role_user.as_ref()
    }
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub fn packed_policy_size(&self) -> std::option::Option<i32> {
        self.packed_policy_size
    }
    /// <p> The issuing authority of the web identity token presented. For OpenID Connect ID tokens, this contains the value of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code> request.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>The intended audience (also known as client ID) of the web identity token. This is traditionally the client identifier issued to the application that requested the web identity token.</p>
    pub fn audience(&self) -> std::option::Option<&str> {
        self.audience.as_deref()
    }
    /// <p>The value of the source identity that is returned in the JSON web token (JWT) from the identity provider.</p>
    /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithWebIdentity</code>. You do this by adding a claim to the JSON web token. To learn more about OIDC tokens and claims, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html">Using Tokens with User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
    pub fn source_identity(&self) -> std::option::Option<&str> {
        self.source_identity.as_deref()
    }
}
impl std::fmt::Debug for AssumeRoleWithWebIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssumeRoleWithWebIdentityOutput");
        formatter.field("credentials", &self.credentials);
        formatter.field(
            "subject_from_web_identity_token",
            &self.subject_from_web_identity_token,
        );
        formatter.field("assumed_role_user", &self.assumed_role_user);
        formatter.field("packed_policy_size", &self.packed_policy_size);
        formatter.field("provider", &self.provider);
        formatter.field("audience", &self.audience);
        formatter.field("source_identity", &self.source_identity);
        formatter.finish()
    }
}
/// See [`AssumeRoleWithWebIdentityOutput`](crate::output::AssumeRoleWithWebIdentityOutput)
pub mod assume_role_with_web_identity_output {
    /// A builder for [`AssumeRoleWithWebIdentityOutput`](crate::output::AssumeRoleWithWebIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
        pub(crate) subject_from_web_identity_token: std::option::Option<std::string::String>,
        pub(crate) assumed_role_user: std::option::Option<crate::model::AssumedRoleUser>,
        pub(crate) packed_policy_size: std::option::Option<i32>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) audience: std::option::Option<std::string::String>,
        pub(crate) source_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// <p>The unique user identifier that is returned by the identity provider. This identifier is associated with the <code>WebIdentityToken</code> that was submitted with the <code>AssumeRoleWithWebIdentity</code> call. The identifier is typically unique to the user and the application that acquired the <code>WebIdentityToken</code> (pairwise identifier). For OpenID Connect ID tokens, this field contains the value returned by the identity provider as the token's <code>sub</code> (Subject) claim. </p>
        pub fn subject_from_web_identity_token(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.subject_from_web_identity_token = Some(input.into());
            self
        }
        /// <p>The unique user identifier that is returned by the identity provider. This identifier is associated with the <code>WebIdentityToken</code> that was submitted with the <code>AssumeRoleWithWebIdentity</code> call. The identifier is typically unique to the user and the application that acquired the <code>WebIdentityToken</code> (pairwise identifier). For OpenID Connect ID tokens, this field contains the value returned by the identity provider as the token's <code>sub</code> (Subject) claim. </p>
        pub fn set_subject_from_web_identity_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subject_from_web_identity_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
        pub fn assumed_role_user(mut self, input: crate::model::AssumedRoleUser) -> Self {
            self.assumed_role_user = Some(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
        pub fn set_assumed_role_user(
            mut self,
            input: std::option::Option<crate::model::AssumedRoleUser>,
        ) -> Self {
            self.assumed_role_user = input;
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn packed_policy_size(mut self, input: i32) -> Self {
            self.packed_policy_size = Some(input);
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn set_packed_policy_size(mut self, input: std::option::Option<i32>) -> Self {
            self.packed_policy_size = input;
            self
        }
        /// <p> The issuing authority of the web identity token presented. For OpenID Connect ID tokens, this contains the value of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code> request.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p> The issuing authority of the web identity token presented. For OpenID Connect ID tokens, this contains the value of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code> request.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The intended audience (also known as client ID) of the web identity token. This is traditionally the client identifier issued to the application that requested the web identity token.</p>
        pub fn audience(mut self, input: impl Into<std::string::String>) -> Self {
            self.audience = Some(input.into());
            self
        }
        /// <p>The intended audience (also known as client ID) of the web identity token. This is traditionally the client identifier issued to the application that requested the web identity token.</p>
        pub fn set_audience(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.audience = input;
            self
        }
        /// <p>The value of the source identity that is returned in the JSON web token (JWT) from the identity provider.</p>
        /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithWebIdentity</code>. You do this by adding a claim to the JSON web token. To learn more about OIDC tokens and claims, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html">Using Tokens with User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
        pub fn source_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identity = Some(input.into());
            self
        }
        /// <p>The value of the source identity that is returned in the JSON web token (JWT) from the identity provider.</p>
        /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithWebIdentity</code>. You do this by adding a claim to the JSON web token. To learn more about OIDC tokens and claims, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html">Using Tokens with User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
        pub fn set_source_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`AssumeRoleWithWebIdentityOutput`](crate::output::AssumeRoleWithWebIdentityOutput)
        pub fn build(self) -> crate::output::AssumeRoleWithWebIdentityOutput {
            crate::output::AssumeRoleWithWebIdentityOutput {
                credentials: self.credentials,
                subject_from_web_identity_token: self.subject_from_web_identity_token,
                assumed_role_user: self.assumed_role_user,
                packed_policy_size: self.packed_policy_size,
                provider: self.provider,
                audience: self.audience,
                source_identity: self.source_identity,
            }
        }
    }
}
impl AssumeRoleWithWebIdentityOutput {
    /// Creates a new builder-style object to manufacture [`AssumeRoleWithWebIdentityOutput`](crate::output::AssumeRoleWithWebIdentityOutput)
    pub fn builder() -> crate::output::assume_role_with_web_identity_output::Builder {
        crate::output::assume_role_with_web_identity_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>AssumeRoleWithSAML</code> request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssumeRoleWithSamlOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub credentials: std::option::Option<crate::model::Credentials>,
    /// <p>The identifiers for the temporary security credentials that the operation returns.</p>
    pub assumed_role_user: std::option::Option<crate::model::AssumedRoleUser>,
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub packed_policy_size: std::option::Option<i32>,
    /// <p>The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML assertion.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p> The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code> element of the SAML assertion. Typical examples of the format are <code>transient</code> or <code>persistent</code>. </p>
    /// <p> If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix is removed. For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned as <code>transient</code>. If the format includes any other prefix, the format is returned with no modifications.</p>
    pub subject_type: std::option::Option<std::string::String>,
    /// <p>The value of the <code>Issuer</code> element of the SAML assertion.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p> The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element of the SAML assertion. </p>
    pub audience: std::option::Option<std::string::String>,
    /// <p>A hash value based on the concatenation of the following:</p>
    /// <ul>
    /// <li> <p>The <code>Issuer</code> response value.</p> </li>
    /// <li> <p>The Amazon Web Services account ID.</p> </li>
    /// <li> <p>The friendly name (the last part of the ARN) of the SAML provider in IAM.</p> </li>
    /// </ul>
    /// <p>The combination of <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.</p>
    /// <p>The following pseudocode shows how the hash value is calculated:</p>
    /// <p> <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code> </p>
    pub name_qualifier: std::option::Option<std::string::String>,
    /// <p>The value in the <code>SourceIdentity</code> attribute in the SAML assertion. </p>
    /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your SAML identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithSAML</code>. You do this by adding an attribute to the SAML assertion. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
    pub source_identity: std::option::Option<std::string::String>,
}
impl AssumeRoleWithSamlOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn credentials(&self) -> std::option::Option<&crate::model::Credentials> {
        self.credentials.as_ref()
    }
    /// <p>The identifiers for the temporary security credentials that the operation returns.</p>
    pub fn assumed_role_user(&self) -> std::option::Option<&crate::model::AssumedRoleUser> {
        self.assumed_role_user.as_ref()
    }
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub fn packed_policy_size(&self) -> std::option::Option<i32> {
        self.packed_policy_size
    }
    /// <p>The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML assertion.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p> The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code> element of the SAML assertion. Typical examples of the format are <code>transient</code> or <code>persistent</code>. </p>
    /// <p> If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix is removed. For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned as <code>transient</code>. If the format includes any other prefix, the format is returned with no modifications.</p>
    pub fn subject_type(&self) -> std::option::Option<&str> {
        self.subject_type.as_deref()
    }
    /// <p>The value of the <code>Issuer</code> element of the SAML assertion.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p> The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element of the SAML assertion. </p>
    pub fn audience(&self) -> std::option::Option<&str> {
        self.audience.as_deref()
    }
    /// <p>A hash value based on the concatenation of the following:</p>
    /// <ul>
    /// <li> <p>The <code>Issuer</code> response value.</p> </li>
    /// <li> <p>The Amazon Web Services account ID.</p> </li>
    /// <li> <p>The friendly name (the last part of the ARN) of the SAML provider in IAM.</p> </li>
    /// </ul>
    /// <p>The combination of <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.</p>
    /// <p>The following pseudocode shows how the hash value is calculated:</p>
    /// <p> <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code> </p>
    pub fn name_qualifier(&self) -> std::option::Option<&str> {
        self.name_qualifier.as_deref()
    }
    /// <p>The value in the <code>SourceIdentity</code> attribute in the SAML assertion. </p>
    /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your SAML identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithSAML</code>. You do this by adding an attribute to the SAML assertion. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
    pub fn source_identity(&self) -> std::option::Option<&str> {
        self.source_identity.as_deref()
    }
}
impl std::fmt::Debug for AssumeRoleWithSamlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssumeRoleWithSamlOutput");
        formatter.field("credentials", &self.credentials);
        formatter.field("assumed_role_user", &self.assumed_role_user);
        formatter.field("packed_policy_size", &self.packed_policy_size);
        formatter.field("subject", &self.subject);
        formatter.field("subject_type", &self.subject_type);
        formatter.field("issuer", &self.issuer);
        formatter.field("audience", &self.audience);
        formatter.field("name_qualifier", &self.name_qualifier);
        formatter.field("source_identity", &self.source_identity);
        formatter.finish()
    }
}
/// See [`AssumeRoleWithSamlOutput`](crate::output::AssumeRoleWithSamlOutput)
pub mod assume_role_with_saml_output {
    /// A builder for [`AssumeRoleWithSamlOutput`](crate::output::AssumeRoleWithSamlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
        pub(crate) assumed_role_user: std::option::Option<crate::model::AssumedRoleUser>,
        pub(crate) packed_policy_size: std::option::Option<i32>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) subject_type: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) audience: std::option::Option<std::string::String>,
        pub(crate) name_qualifier: std::option::Option<std::string::String>,
        pub(crate) source_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// <p>The identifiers for the temporary security credentials that the operation returns.</p>
        pub fn assumed_role_user(mut self, input: crate::model::AssumedRoleUser) -> Self {
            self.assumed_role_user = Some(input);
            self
        }
        /// <p>The identifiers for the temporary security credentials that the operation returns.</p>
        pub fn set_assumed_role_user(
            mut self,
            input: std::option::Option<crate::model::AssumedRoleUser>,
        ) -> Self {
            self.assumed_role_user = input;
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn packed_policy_size(mut self, input: i32) -> Self {
            self.packed_policy_size = Some(input);
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn set_packed_policy_size(mut self, input: std::option::Option<i32>) -> Self {
            self.packed_policy_size = input;
            self
        }
        /// <p>The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML assertion.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML assertion.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p> The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code> element of the SAML assertion. Typical examples of the format are <code>transient</code> or <code>persistent</code>. </p>
        /// <p> If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix is removed. For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned as <code>transient</code>. If the format includes any other prefix, the format is returned with no modifications.</p>
        pub fn subject_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject_type = Some(input.into());
            self
        }
        /// <p> The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code> element of the SAML assertion. Typical examples of the format are <code>transient</code> or <code>persistent</code>. </p>
        /// <p> If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix is removed. For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned as <code>transient</code>. If the format includes any other prefix, the format is returned with no modifications.</p>
        pub fn set_subject_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject_type = input;
            self
        }
        /// <p>The value of the <code>Issuer</code> element of the SAML assertion.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The value of the <code>Issuer</code> element of the SAML assertion.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p> The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element of the SAML assertion. </p>
        pub fn audience(mut self, input: impl Into<std::string::String>) -> Self {
            self.audience = Some(input.into());
            self
        }
        /// <p> The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element of the SAML assertion. </p>
        pub fn set_audience(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.audience = input;
            self
        }
        /// <p>A hash value based on the concatenation of the following:</p>
        /// <ul>
        /// <li> <p>The <code>Issuer</code> response value.</p> </li>
        /// <li> <p>The Amazon Web Services account ID.</p> </li>
        /// <li> <p>The friendly name (the last part of the ARN) of the SAML provider in IAM.</p> </li>
        /// </ul>
        /// <p>The combination of <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.</p>
        /// <p>The following pseudocode shows how the hash value is calculated:</p>
        /// <p> <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code> </p>
        pub fn name_qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_qualifier = Some(input.into());
            self
        }
        /// <p>A hash value based on the concatenation of the following:</p>
        /// <ul>
        /// <li> <p>The <code>Issuer</code> response value.</p> </li>
        /// <li> <p>The Amazon Web Services account ID.</p> </li>
        /// <li> <p>The friendly name (the last part of the ARN) of the SAML provider in IAM.</p> </li>
        /// </ul>
        /// <p>The combination of <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.</p>
        /// <p>The following pseudocode shows how the hash value is calculated:</p>
        /// <p> <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code> </p>
        pub fn set_name_qualifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_qualifier = input;
            self
        }
        /// <p>The value in the <code>SourceIdentity</code> attribute in the SAML assertion. </p>
        /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your SAML identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithSAML</code>. You do this by adding an attribute to the SAML assertion. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
        pub fn source_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identity = Some(input.into());
            self
        }
        /// <p>The value in the <code>SourceIdentity</code> attribute in the SAML assertion. </p>
        /// <p>You can require users to set a source identity value when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining">chained role</a> sessions. You can configure your SAML identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling <code>AssumeRoleWithSAML</code>. You do this by adding an attribute to the SAML assertion. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
        pub fn set_source_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`AssumeRoleWithSamlOutput`](crate::output::AssumeRoleWithSamlOutput)
        pub fn build(self) -> crate::output::AssumeRoleWithSamlOutput {
            crate::output::AssumeRoleWithSamlOutput {
                credentials: self.credentials,
                assumed_role_user: self.assumed_role_user,
                packed_policy_size: self.packed_policy_size,
                subject: self.subject,
                subject_type: self.subject_type,
                issuer: self.issuer,
                audience: self.audience,
                name_qualifier: self.name_qualifier,
                source_identity: self.source_identity,
            }
        }
    }
}
impl AssumeRoleWithSamlOutput {
    /// Creates a new builder-style object to manufacture [`AssumeRoleWithSamlOutput`](crate::output::AssumeRoleWithSamlOutput)
    pub fn builder() -> crate::output::assume_role_with_saml_output::Builder {
        crate::output::assume_role_with_saml_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>AssumeRole</code> request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssumeRoleOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub credentials: std::option::Option<crate::model::Credentials>,
    /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
    pub assumed_role_user: std::option::Option<crate::model::AssumedRoleUser>,
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub packed_policy_size: std::option::Option<i32>,
    /// <p>The source identity specified by the principal that is calling the <code>AssumeRole</code> operation.</p>
    /// <p>You can require users to specify a source identity when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. You can use source identity information in CloudTrail logs to determine who took actions with a role. You can use the <code>aws:SourceIdentity</code> condition key to further control access to Amazon Web Services resources based on the value of source identity. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
    pub source_identity: std::option::Option<std::string::String>,
}
impl AssumeRoleOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn credentials(&self) -> std::option::Option<&crate::model::Credentials> {
        self.credentials.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
    pub fn assumed_role_user(&self) -> std::option::Option<&crate::model::AssumedRoleUser> {
        self.assumed_role_user.as_ref()
    }
    /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
    pub fn packed_policy_size(&self) -> std::option::Option<i32> {
        self.packed_policy_size
    }
    /// <p>The source identity specified by the principal that is calling the <code>AssumeRole</code> operation.</p>
    /// <p>You can require users to specify a source identity when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. You can use source identity information in CloudTrail logs to determine who took actions with a role. You can use the <code>aws:SourceIdentity</code> condition key to further control access to Amazon Web Services resources based on the value of source identity. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
    pub fn source_identity(&self) -> std::option::Option<&str> {
        self.source_identity.as_deref()
    }
}
impl std::fmt::Debug for AssumeRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssumeRoleOutput");
        formatter.field("credentials", &self.credentials);
        formatter.field("assumed_role_user", &self.assumed_role_user);
        formatter.field("packed_policy_size", &self.packed_policy_size);
        formatter.field("source_identity", &self.source_identity);
        formatter.finish()
    }
}
/// See [`AssumeRoleOutput`](crate::output::AssumeRoleOutput)
pub mod assume_role_output {
    /// A builder for [`AssumeRoleOutput`](crate::output::AssumeRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
        pub(crate) assumed_role_user: std::option::Option<crate::model::AssumedRoleUser>,
        pub(crate) packed_policy_size: std::option::Option<i32>,
        pub(crate) source_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p> <note>
        /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
        /// </note>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
        pub fn assumed_role_user(mut self, input: crate::model::AssumedRoleUser) -> Self {
            self.assumed_role_user = Some(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>. </p>
        pub fn set_assumed_role_user(
            mut self,
            input: std::option::Option<crate::model::AssumedRoleUser>,
        ) -> Self {
            self.assumed_role_user = input;
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn packed_policy_size(mut self, input: i32) -> Self {
            self.packed_policy_size = Some(input);
            self
        }
        /// <p>A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.</p>
        pub fn set_packed_policy_size(mut self, input: std::option::Option<i32>) -> Self {
            self.packed_policy_size = input;
            self
        }
        /// <p>The source identity specified by the principal that is calling the <code>AssumeRole</code> operation.</p>
        /// <p>You can require users to specify a source identity when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. You can use source identity information in CloudTrail logs to determine who took actions with a role. You can use the <code>aws:SourceIdentity</code> condition key to further control access to Amazon Web Services resources based on the value of source identity. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
        pub fn source_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identity = Some(input.into());
            self
        }
        /// <p>The source identity specified by the principal that is calling the <code>AssumeRole</code> operation.</p>
        /// <p>You can require users to specify a source identity when they assume a role. You do this by using the <code>sts:SourceIdentity</code> condition key in a role trust policy. You can use source identity information in CloudTrail logs to determine who took actions with a role. You can use the <code>aws:SourceIdentity</code> condition key to further control access to Amazon Web Services resources based on the value of source identity. For more information about using source identity, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">Monitor and control actions taken with assumed roles</a> in the <i>IAM User Guide</i>.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-</p>
        pub fn set_source_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`AssumeRoleOutput`](crate::output::AssumeRoleOutput)
        pub fn build(self) -> crate::output::AssumeRoleOutput {
            crate::output::AssumeRoleOutput {
                credentials: self.credentials,
                assumed_role_user: self.assumed_role_user,
                packed_policy_size: self.packed_policy_size,
                source_identity: self.source_identity,
            }
        }
    }
}
impl AssumeRoleOutput {
    /// Creates a new builder-style object to manufacture [`AssumeRoleOutput`](crate::output::AssumeRoleOutput)
    pub fn builder() -> crate::output::assume_role_output::Builder {
        crate::output::assume_role_output::Builder::default()
    }
}
