// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_assume_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssumeRoleOutput, crate::error::AssumeRoleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssumeRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssumeRoleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExpiredTokenException" => crate::error::AssumeRoleError {
            meta: generic,
            kind: crate::error::AssumeRoleErrorKind::ExpiredTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_token_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_expired_token_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::AssumeRoleError {
            meta: generic,
            kind: crate::error::AssumeRoleErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PackedPolicyTooLarge" => crate::error::AssumeRoleError {
            meta: generic,
            kind: crate::error::AssumeRoleErrorKind::PackedPolicyTooLargeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::packed_policy_too_large_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_packed_policy_too_large_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RegionDisabledException" => crate::error::AssumeRoleError {
            meta: generic,
            kind: crate::error::AssumeRoleErrorKind::RegionDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::region_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_region_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssumeRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_assume_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssumeRoleOutput, crate::error::AssumeRoleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::assume_role_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_assume_role(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssumeRoleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_assume_role_with_saml_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssumeRoleWithSamlOutput,
    crate::error::AssumeRoleWithSAMLError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssumeRoleWithSAMLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExpiredTokenException" => crate::error::AssumeRoleWithSAMLError {
            meta: generic,
            kind: crate::error::AssumeRoleWithSAMLErrorKind::ExpiredTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_token_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_expired_token_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IDPRejectedClaim" => crate::error::AssumeRoleWithSAMLError {
            meta: generic,
            kind: crate::error::AssumeRoleWithSAMLErrorKind::IdpRejectedClaimException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::idp_rejected_claim_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_idp_rejected_claim_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIdentityToken" => crate::error::AssumeRoleWithSAMLError {
            meta: generic,
            kind: crate::error::AssumeRoleWithSAMLErrorKind::InvalidIdentityTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_identity_token_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_identity_token_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::AssumeRoleWithSAMLError {
            meta: generic,
            kind: crate::error::AssumeRoleWithSAMLErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PackedPolicyTooLarge" => crate::error::AssumeRoleWithSAMLError {
            meta: generic,
            kind: crate::error::AssumeRoleWithSAMLErrorKind::PackedPolicyTooLargeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::packed_policy_too_large_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_packed_policy_too_large_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RegionDisabledException" => crate::error::AssumeRoleWithSAMLError {
            meta: generic,
            kind: crate::error::AssumeRoleWithSAMLErrorKind::RegionDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::region_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_region_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssumeRoleWithSAMLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_assume_role_with_saml_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssumeRoleWithSamlOutput,
    crate::error::AssumeRoleWithSAMLError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::assume_role_with_saml_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_assume_role_with_saml(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssumeRoleWithSAMLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_assume_role_with_web_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssumeRoleWithWebIdentityOutput,
    crate::error::AssumeRoleWithWebIdentityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssumeRoleWithWebIdentityError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExpiredTokenException" => crate::error::AssumeRoleWithWebIdentityError {
            meta: generic,
            kind: crate::error::AssumeRoleWithWebIdentityErrorKind::ExpiredTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_token_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_expired_token_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IDPCommunicationError" => crate::error::AssumeRoleWithWebIdentityError {
            meta: generic,
            kind: crate::error::AssumeRoleWithWebIdentityErrorKind::IdpCommunicationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::idp_communication_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_idp_communication_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "IDPRejectedClaim" => crate::error::AssumeRoleWithWebIdentityError {
            meta: generic,
            kind: crate::error::AssumeRoleWithWebIdentityErrorKind::IdpRejectedClaimException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::idp_rejected_claim_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_idp_rejected_claim_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIdentityToken" => crate::error::AssumeRoleWithWebIdentityError {
            meta: generic,
            kind: crate::error::AssumeRoleWithWebIdentityErrorKind::InvalidIdentityTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_identity_token_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_identity_token_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "MalformedPolicyDocument" => crate::error::AssumeRoleWithWebIdentityError {
            meta: generic,
            kind:
                crate::error::AssumeRoleWithWebIdentityErrorKind::MalformedPolicyDocumentException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::malformed_policy_document_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "PackedPolicyTooLarge" => crate::error::AssumeRoleWithWebIdentityError {
            meta: generic,
            kind: crate::error::AssumeRoleWithWebIdentityErrorKind::PackedPolicyTooLargeException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::packed_policy_too_large_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_packed_policy_too_large_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "RegionDisabledException" => crate::error::AssumeRoleWithWebIdentityError {
            meta: generic,
            kind: crate::error::AssumeRoleWithWebIdentityErrorKind::RegionDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::region_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_region_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssumeRoleWithWebIdentityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_assume_role_with_web_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssumeRoleWithWebIdentityOutput,
    crate::error::AssumeRoleWithWebIdentityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::assume_role_with_web_identity_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_assume_role_with_web_identity(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssumeRoleWithWebIdentityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decode_authorization_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DecodeAuthorizationMessageOutput,
    crate::error::DecodeAuthorizationMessageError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DecodeAuthorizationMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DecodeAuthorizationMessageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidAuthorizationMessageException" => crate::error::DecodeAuthorizationMessageError { meta: generic, kind: crate::error::DecodeAuthorizationMessageErrorKind::InvalidAuthorizationMessageException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_authorization_message_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authorization_message_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DecodeAuthorizationMessageError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DecodeAuthorizationMessageError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decode_authorization_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DecodeAuthorizationMessageOutput,
    crate::error::DecodeAuthorizationMessageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::decode_authorization_message_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_decode_authorization_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DecodeAuthorizationMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_key_info_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccessKeyInfoOutput, crate::error::GetAccessKeyInfoError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessKeyInfoError::unhandled)?;
    Err(crate::error::GetAccessKeyInfoError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_key_info_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccessKeyInfoOutput, crate::error::GetAccessKeyInfoError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_access_key_info_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_key_info(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccessKeyInfoError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_caller_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCallerIdentityOutput, crate::error::GetCallerIdentityError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCallerIdentityError::unhandled)?;
    Err(crate::error::GetCallerIdentityError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_caller_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCallerIdentityOutput, crate::error::GetCallerIdentityError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_caller_identity_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_caller_identity(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCallerIdentityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_federation_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFederationTokenOutput,
    crate::error::GetFederationTokenError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFederationTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetFederationTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "MalformedPolicyDocument" => crate::error::GetFederationTokenError {
            meta: generic,
            kind: crate::error::GetFederationTokenErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFederationTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PackedPolicyTooLarge" => crate::error::GetFederationTokenError {
            meta: generic,
            kind: crate::error::GetFederationTokenErrorKind::PackedPolicyTooLargeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::packed_policy_too_large_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_packed_policy_too_large_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFederationTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RegionDisabledException" => crate::error::GetFederationTokenError {
            meta: generic,
            kind: crate::error::GetFederationTokenErrorKind::RegionDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::region_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_region_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFederationTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFederationTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_federation_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFederationTokenOutput,
    crate::error::GetFederationTokenError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_federation_token_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_federation_token(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetFederationTokenError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_session_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSessionTokenOutput, crate::error::GetSessionTokenError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSessionTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSessionTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RegionDisabledException" => crate::error::GetSessionTokenError {
            meta: generic,
            kind: crate::error::GetSessionTokenErrorKind::RegionDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::region_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_region_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSessionTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSessionTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_session_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSessionTokenOutput, crate::error::GetSessionTokenError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_session_token_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_session_token(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSessionTokenError::unhandled)?;
        output.build()
    })
}
