// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ActivateGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`activate_gateway`](crate::client::Client::activate_gateway).
///
/// See [`crate::client::fluent_builders::ActivateGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ActivateGateway {
    _private: (),
}
impl ActivateGateway {
    /// Creates a new builder-style object to manufacture [`ActivateGatewayInput`](crate::input::ActivateGatewayInput)
    pub fn builder() -> crate::input::activate_gateway_input::Builder {
        crate::input::activate_gateway_input::Builder::default()
    }
    /// Creates a new `ActivateGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ActivateGateway {
    type Output = std::result::Result<
        crate::output::ActivateGatewayOutput,
        crate::error::ActivateGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_activate_gateway_error(response)
        } else {
            crate::operation_deser::parse_activate_gateway_response(response)
        }
    }
}

/// Operation shape for `AddCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_cache`](crate::client::Client::add_cache).
///
/// See [`crate::client::fluent_builders::AddCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddCache {
    _private: (),
}
impl AddCache {
    /// Creates a new builder-style object to manufacture [`AddCacheInput`](crate::input::AddCacheInput)
    pub fn builder() -> crate::input::add_cache_input::Builder {
        crate::input::add_cache_input::Builder::default()
    }
    /// Creates a new `AddCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddCache {
    type Output = std::result::Result<crate::output::AddCacheOutput, crate::error::AddCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_cache_error(response)
        } else {
            crate::operation_deser::parse_add_cache_response(response)
        }
    }
}

/// Operation shape for `AddTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_resource`](crate::client::Client::add_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToResource {
    _private: (),
}
impl AddTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToResource {
    type Output = std::result::Result<
        crate::output::AddTagsToResourceOutput,
        crate::error::AddTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `AddUploadBuffer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_upload_buffer`](crate::client::Client::add_upload_buffer).
///
/// See [`crate::client::fluent_builders::AddUploadBuffer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddUploadBuffer {
    _private: (),
}
impl AddUploadBuffer {
    /// Creates a new builder-style object to manufacture [`AddUploadBufferInput`](crate::input::AddUploadBufferInput)
    pub fn builder() -> crate::input::add_upload_buffer_input::Builder {
        crate::input::add_upload_buffer_input::Builder::default()
    }
    /// Creates a new `AddUploadBuffer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddUploadBuffer {
    type Output = std::result::Result<
        crate::output::AddUploadBufferOutput,
        crate::error::AddUploadBufferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_upload_buffer_error(response)
        } else {
            crate::operation_deser::parse_add_upload_buffer_response(response)
        }
    }
}

/// Operation shape for `AddWorkingStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_working_storage`](crate::client::Client::add_working_storage).
///
/// See [`crate::client::fluent_builders::AddWorkingStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddWorkingStorage {
    _private: (),
}
impl AddWorkingStorage {
    /// Creates a new builder-style object to manufacture [`AddWorkingStorageInput`](crate::input::AddWorkingStorageInput)
    pub fn builder() -> crate::input::add_working_storage_input::Builder {
        crate::input::add_working_storage_input::Builder::default()
    }
    /// Creates a new `AddWorkingStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddWorkingStorage {
    type Output = std::result::Result<
        crate::output::AddWorkingStorageOutput,
        crate::error::AddWorkingStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_working_storage_error(response)
        } else {
            crate::operation_deser::parse_add_working_storage_response(response)
        }
    }
}

/// Operation shape for `AssignTapePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`assign_tape_pool`](crate::client::Client::assign_tape_pool).
///
/// See [`crate::client::fluent_builders::AssignTapePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssignTapePool {
    _private: (),
}
impl AssignTapePool {
    /// Creates a new builder-style object to manufacture [`AssignTapePoolInput`](crate::input::AssignTapePoolInput)
    pub fn builder() -> crate::input::assign_tape_pool_input::Builder {
        crate::input::assign_tape_pool_input::Builder::default()
    }
    /// Creates a new `AssignTapePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssignTapePool {
    type Output =
        std::result::Result<crate::output::AssignTapePoolOutput, crate::error::AssignTapePoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_assign_tape_pool_error(response)
        } else {
            crate::operation_deser::parse_assign_tape_pool_response(response)
        }
    }
}

/// Operation shape for `AssociateFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_file_system`](crate::client::Client::associate_file_system).
///
/// See [`crate::client::fluent_builders::AssociateFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateFileSystem {
    _private: (),
}
impl AssociateFileSystem {
    /// Creates a new builder-style object to manufacture [`AssociateFileSystemInput`](crate::input::AssociateFileSystemInput)
    pub fn builder() -> crate::input::associate_file_system_input::Builder {
        crate::input::associate_file_system_input::Builder::default()
    }
    /// Creates a new `AssociateFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateFileSystem {
    type Output = std::result::Result<
        crate::output::AssociateFileSystemOutput,
        crate::error::AssociateFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_file_system_error(response)
        } else {
            crate::operation_deser::parse_associate_file_system_response(response)
        }
    }
}

/// Operation shape for `AttachVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_volume`](crate::client::Client::attach_volume).
///
/// See [`crate::client::fluent_builders::AttachVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachVolume {
    _private: (),
}
impl AttachVolume {
    /// Creates a new builder-style object to manufacture [`AttachVolumeInput`](crate::input::AttachVolumeInput)
    pub fn builder() -> crate::input::attach_volume_input::Builder {
        crate::input::attach_volume_input::Builder::default()
    }
    /// Creates a new `AttachVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachVolume {
    type Output =
        std::result::Result<crate::output::AttachVolumeOutput, crate::error::AttachVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_volume_error(response)
        } else {
            crate::operation_deser::parse_attach_volume_response(response)
        }
    }
}

/// Operation shape for `CancelArchival`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_archival`](crate::client::Client::cancel_archival).
///
/// See [`crate::client::fluent_builders::CancelArchival`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelArchival {
    _private: (),
}
impl CancelArchival {
    /// Creates a new builder-style object to manufacture [`CancelArchivalInput`](crate::input::CancelArchivalInput)
    pub fn builder() -> crate::input::cancel_archival_input::Builder {
        crate::input::cancel_archival_input::Builder::default()
    }
    /// Creates a new `CancelArchival` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelArchival {
    type Output =
        std::result::Result<crate::output::CancelArchivalOutput, crate::error::CancelArchivalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_archival_error(response)
        } else {
            crate::operation_deser::parse_cancel_archival_response(response)
        }
    }
}

/// Operation shape for `CancelRetrieval`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_retrieval`](crate::client::Client::cancel_retrieval).
///
/// See [`crate::client::fluent_builders::CancelRetrieval`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelRetrieval {
    _private: (),
}
impl CancelRetrieval {
    /// Creates a new builder-style object to manufacture [`CancelRetrievalInput`](crate::input::CancelRetrievalInput)
    pub fn builder() -> crate::input::cancel_retrieval_input::Builder {
        crate::input::cancel_retrieval_input::Builder::default()
    }
    /// Creates a new `CancelRetrieval` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelRetrieval {
    type Output = std::result::Result<
        crate::output::CancelRetrievalOutput,
        crate::error::CancelRetrievalError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_retrieval_error(response)
        } else {
            crate::operation_deser::parse_cancel_retrieval_response(response)
        }
    }
}

/// Operation shape for `CreateCachediSCSIVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cachedi_scsi_volume`](crate::client::Client::create_cachedi_scsi_volume).
///
/// See [`crate::client::fluent_builders::CreateCachediSCSIVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCachediSCSIVolume {
    _private: (),
}
impl CreateCachediSCSIVolume {
    /// Creates a new builder-style object to manufacture [`CreateCachediScsiVolumeInput`](crate::input::CreateCachediScsiVolumeInput)
    pub fn builder() -> crate::input::create_cachedi_scsi_volume_input::Builder {
        crate::input::create_cachedi_scsi_volume_input::Builder::default()
    }
    /// Creates a new `CreateCachediSCSIVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCachediSCSIVolume {
    type Output = std::result::Result<
        crate::output::CreateCachediScsiVolumeOutput,
        crate::error::CreateCachediSCSIVolumeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cachedi_scsi_volume_error(response)
        } else {
            crate::operation_deser::parse_create_cachedi_scsi_volume_response(response)
        }
    }
}

/// Operation shape for `CreateNFSFileShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_nfs_file_share`](crate::client::Client::create_nfs_file_share).
///
/// See [`crate::client::fluent_builders::CreateNFSFileShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNFSFileShare {
    _private: (),
}
impl CreateNFSFileShare {
    /// Creates a new builder-style object to manufacture [`CreateNfsFileShareInput`](crate::input::CreateNfsFileShareInput)
    pub fn builder() -> crate::input::create_nfs_file_share_input::Builder {
        crate::input::create_nfs_file_share_input::Builder::default()
    }
    /// Creates a new `CreateNFSFileShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNFSFileShare {
    type Output = std::result::Result<
        crate::output::CreateNfsFileShareOutput,
        crate::error::CreateNFSFileShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_nfs_file_share_error(response)
        } else {
            crate::operation_deser::parse_create_nfs_file_share_response(response)
        }
    }
}

/// Operation shape for `CreateSMBFileShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_smb_file_share`](crate::client::Client::create_smb_file_share).
///
/// See [`crate::client::fluent_builders::CreateSMBFileShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSMBFileShare {
    _private: (),
}
impl CreateSMBFileShare {
    /// Creates a new builder-style object to manufacture [`CreateSmbFileShareInput`](crate::input::CreateSmbFileShareInput)
    pub fn builder() -> crate::input::create_smb_file_share_input::Builder {
        crate::input::create_smb_file_share_input::Builder::default()
    }
    /// Creates a new `CreateSMBFileShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSMBFileShare {
    type Output = std::result::Result<
        crate::output::CreateSmbFileShareOutput,
        crate::error::CreateSMBFileShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_smb_file_share_error(response)
        } else {
            crate::operation_deser::parse_create_smb_file_share_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot`](crate::client::Client::create_snapshot).
///
/// See [`crate::client::fluent_builders::CreateSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshot {
    _private: (),
}
impl CreateSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshot {
    type Output =
        std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshotFromVolumeRecoveryPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot_from_volume_recovery_point`](crate::client::Client::create_snapshot_from_volume_recovery_point).
///
/// See [`crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshotFromVolumeRecoveryPoint {
    _private: (),
}
impl CreateSnapshotFromVolumeRecoveryPoint {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotFromVolumeRecoveryPointInput`](crate::input::CreateSnapshotFromVolumeRecoveryPointInput)
    pub fn builder() -> crate::input::create_snapshot_from_volume_recovery_point_input::Builder {
        crate::input::create_snapshot_from_volume_recovery_point_input::Builder::default()
    }
    /// Creates a new `CreateSnapshotFromVolumeRecoveryPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshotFromVolumeRecoveryPoint {
    type Output = std::result::Result<
        crate::output::CreateSnapshotFromVolumeRecoveryPointOutput,
        crate::error::CreateSnapshotFromVolumeRecoveryPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_from_volume_recovery_point_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_from_volume_recovery_point_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateStorediSCSIVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_storedi_scsi_volume`](crate::client::Client::create_storedi_scsi_volume).
///
/// See [`crate::client::fluent_builders::CreateStorediSCSIVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStorediSCSIVolume {
    _private: (),
}
impl CreateStorediSCSIVolume {
    /// Creates a new builder-style object to manufacture [`CreateStorediScsiVolumeInput`](crate::input::CreateStorediScsiVolumeInput)
    pub fn builder() -> crate::input::create_storedi_scsi_volume_input::Builder {
        crate::input::create_storedi_scsi_volume_input::Builder::default()
    }
    /// Creates a new `CreateStorediSCSIVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStorediSCSIVolume {
    type Output = std::result::Result<
        crate::output::CreateStorediScsiVolumeOutput,
        crate::error::CreateStorediSCSIVolumeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_storedi_scsi_volume_error(response)
        } else {
            crate::operation_deser::parse_create_storedi_scsi_volume_response(response)
        }
    }
}

/// Operation shape for `CreateTapePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tape_pool`](crate::client::Client::create_tape_pool).
///
/// See [`crate::client::fluent_builders::CreateTapePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTapePool {
    _private: (),
}
impl CreateTapePool {
    /// Creates a new builder-style object to manufacture [`CreateTapePoolInput`](crate::input::CreateTapePoolInput)
    pub fn builder() -> crate::input::create_tape_pool_input::Builder {
        crate::input::create_tape_pool_input::Builder::default()
    }
    /// Creates a new `CreateTapePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTapePool {
    type Output =
        std::result::Result<crate::output::CreateTapePoolOutput, crate::error::CreateTapePoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tape_pool_error(response)
        } else {
            crate::operation_deser::parse_create_tape_pool_response(response)
        }
    }
}

/// Operation shape for `CreateTapes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tapes`](crate::client::Client::create_tapes).
///
/// See [`crate::client::fluent_builders::CreateTapes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTapes {
    _private: (),
}
impl CreateTapes {
    /// Creates a new builder-style object to manufacture [`CreateTapesInput`](crate::input::CreateTapesInput)
    pub fn builder() -> crate::input::create_tapes_input::Builder {
        crate::input::create_tapes_input::Builder::default()
    }
    /// Creates a new `CreateTapes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTapes {
    type Output =
        std::result::Result<crate::output::CreateTapesOutput, crate::error::CreateTapesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tapes_error(response)
        } else {
            crate::operation_deser::parse_create_tapes_response(response)
        }
    }
}

/// Operation shape for `CreateTapeWithBarcode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tape_with_barcode`](crate::client::Client::create_tape_with_barcode).
///
/// See [`crate::client::fluent_builders::CreateTapeWithBarcode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTapeWithBarcode {
    _private: (),
}
impl CreateTapeWithBarcode {
    /// Creates a new builder-style object to manufacture [`CreateTapeWithBarcodeInput`](crate::input::CreateTapeWithBarcodeInput)
    pub fn builder() -> crate::input::create_tape_with_barcode_input::Builder {
        crate::input::create_tape_with_barcode_input::Builder::default()
    }
    /// Creates a new `CreateTapeWithBarcode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTapeWithBarcode {
    type Output = std::result::Result<
        crate::output::CreateTapeWithBarcodeOutput,
        crate::error::CreateTapeWithBarcodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tape_with_barcode_error(response)
        } else {
            crate::operation_deser::parse_create_tape_with_barcode_response(response)
        }
    }
}

/// Operation shape for `DeleteAutomaticTapeCreationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_automatic_tape_creation_policy`](crate::client::Client::delete_automatic_tape_creation_policy).
///
/// See [`crate::client::fluent_builders::DeleteAutomaticTapeCreationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAutomaticTapeCreationPolicy {
    _private: (),
}
impl DeleteAutomaticTapeCreationPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteAutomaticTapeCreationPolicyInput`](crate::input::DeleteAutomaticTapeCreationPolicyInput)
    pub fn builder() -> crate::input::delete_automatic_tape_creation_policy_input::Builder {
        crate::input::delete_automatic_tape_creation_policy_input::Builder::default()
    }
    /// Creates a new `DeleteAutomaticTapeCreationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAutomaticTapeCreationPolicy {
    type Output = std::result::Result<
        crate::output::DeleteAutomaticTapeCreationPolicyOutput,
        crate::error::DeleteAutomaticTapeCreationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_automatic_tape_creation_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_automatic_tape_creation_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteBandwidthRateLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bandwidth_rate_limit`](crate::client::Client::delete_bandwidth_rate_limit).
///
/// See [`crate::client::fluent_builders::DeleteBandwidthRateLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBandwidthRateLimit {
    _private: (),
}
impl DeleteBandwidthRateLimit {
    /// Creates a new builder-style object to manufacture [`DeleteBandwidthRateLimitInput`](crate::input::DeleteBandwidthRateLimitInput)
    pub fn builder() -> crate::input::delete_bandwidth_rate_limit_input::Builder {
        crate::input::delete_bandwidth_rate_limit_input::Builder::default()
    }
    /// Creates a new `DeleteBandwidthRateLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBandwidthRateLimit {
    type Output = std::result::Result<
        crate::output::DeleteBandwidthRateLimitOutput,
        crate::error::DeleteBandwidthRateLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_bandwidth_rate_limit_error(response)
        } else {
            crate::operation_deser::parse_delete_bandwidth_rate_limit_response(response)
        }
    }
}

/// Operation shape for `DeleteChapCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_chap_credentials`](crate::client::Client::delete_chap_credentials).
///
/// See [`crate::client::fluent_builders::DeleteChapCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChapCredentials {
    _private: (),
}
impl DeleteChapCredentials {
    /// Creates a new builder-style object to manufacture [`DeleteChapCredentialsInput`](crate::input::DeleteChapCredentialsInput)
    pub fn builder() -> crate::input::delete_chap_credentials_input::Builder {
        crate::input::delete_chap_credentials_input::Builder::default()
    }
    /// Creates a new `DeleteChapCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChapCredentials {
    type Output = std::result::Result<
        crate::output::DeleteChapCredentialsOutput,
        crate::error::DeleteChapCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_chap_credentials_error(response)
        } else {
            crate::operation_deser::parse_delete_chap_credentials_response(response)
        }
    }
}

/// Operation shape for `DeleteFileShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_file_share`](crate::client::Client::delete_file_share).
///
/// See [`crate::client::fluent_builders::DeleteFileShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFileShare {
    _private: (),
}
impl DeleteFileShare {
    /// Creates a new builder-style object to manufacture [`DeleteFileShareInput`](crate::input::DeleteFileShareInput)
    pub fn builder() -> crate::input::delete_file_share_input::Builder {
        crate::input::delete_file_share_input::Builder::default()
    }
    /// Creates a new `DeleteFileShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFileShare {
    type Output = std::result::Result<
        crate::output::DeleteFileShareOutput,
        crate::error::DeleteFileShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_file_share_error(response)
        } else {
            crate::operation_deser::parse_delete_file_share_response(response)
        }
    }
}

/// Operation shape for `DeleteGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_gateway`](crate::client::Client::delete_gateway).
///
/// See [`crate::client::fluent_builders::DeleteGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGateway {
    _private: (),
}
impl DeleteGateway {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
    pub fn builder() -> crate::input::delete_gateway_input::Builder {
        crate::input::delete_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGateway {
    type Output =
        std::result::Result<crate::output::DeleteGatewayOutput, crate::error::DeleteGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteSnapshotSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_snapshot_schedule`](crate::client::Client::delete_snapshot_schedule).
///
/// See [`crate::client::fluent_builders::DeleteSnapshotSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSnapshotSchedule {
    _private: (),
}
impl DeleteSnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
    pub fn builder() -> crate::input::delete_snapshot_schedule_input::Builder {
        crate::input::delete_snapshot_schedule_input::Builder::default()
    }
    /// Creates a new `DeleteSnapshotSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSnapshotSchedule {
    type Output = std::result::Result<
        crate::output::DeleteSnapshotScheduleOutput,
        crate::error::DeleteSnapshotScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_snapshot_schedule_error(response)
        } else {
            crate::operation_deser::parse_delete_snapshot_schedule_response(response)
        }
    }
}

/// Operation shape for `DeleteTape`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tape`](crate::client::Client::delete_tape).
///
/// See [`crate::client::fluent_builders::DeleteTape`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTape {
    _private: (),
}
impl DeleteTape {
    /// Creates a new builder-style object to manufacture [`DeleteTapeInput`](crate::input::DeleteTapeInput)
    pub fn builder() -> crate::input::delete_tape_input::Builder {
        crate::input::delete_tape_input::Builder::default()
    }
    /// Creates a new `DeleteTape` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTape {
    type Output =
        std::result::Result<crate::output::DeleteTapeOutput, crate::error::DeleteTapeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tape_error(response)
        } else {
            crate::operation_deser::parse_delete_tape_response(response)
        }
    }
}

/// Operation shape for `DeleteTapeArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tape_archive`](crate::client::Client::delete_tape_archive).
///
/// See [`crate::client::fluent_builders::DeleteTapeArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTapeArchive {
    _private: (),
}
impl DeleteTapeArchive {
    /// Creates a new builder-style object to manufacture [`DeleteTapeArchiveInput`](crate::input::DeleteTapeArchiveInput)
    pub fn builder() -> crate::input::delete_tape_archive_input::Builder {
        crate::input::delete_tape_archive_input::Builder::default()
    }
    /// Creates a new `DeleteTapeArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTapeArchive {
    type Output = std::result::Result<
        crate::output::DeleteTapeArchiveOutput,
        crate::error::DeleteTapeArchiveError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tape_archive_error(response)
        } else {
            crate::operation_deser::parse_delete_tape_archive_response(response)
        }
    }
}

/// Operation shape for `DeleteTapePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tape_pool`](crate::client::Client::delete_tape_pool).
///
/// See [`crate::client::fluent_builders::DeleteTapePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTapePool {
    _private: (),
}
impl DeleteTapePool {
    /// Creates a new builder-style object to manufacture [`DeleteTapePoolInput`](crate::input::DeleteTapePoolInput)
    pub fn builder() -> crate::input::delete_tape_pool_input::Builder {
        crate::input::delete_tape_pool_input::Builder::default()
    }
    /// Creates a new `DeleteTapePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTapePool {
    type Output =
        std::result::Result<crate::output::DeleteTapePoolOutput, crate::error::DeleteTapePoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tape_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_tape_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_volume`](crate::client::Client::delete_volume).
///
/// See [`crate::client::fluent_builders::DeleteVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVolume {
    _private: (),
}
impl DeleteVolume {
    /// Creates a new builder-style object to manufacture [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
    pub fn builder() -> crate::input::delete_volume_input::Builder {
        crate::input::delete_volume_input::Builder::default()
    }
    /// Creates a new `DeleteVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVolume {
    type Output =
        std::result::Result<crate::output::DeleteVolumeOutput, crate::error::DeleteVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_volume_error(response)
        } else {
            crate::operation_deser::parse_delete_volume_response(response)
        }
    }
}

/// Operation shape for `DescribeAvailabilityMonitorTest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_availability_monitor_test`](crate::client::Client::describe_availability_monitor_test).
///
/// See [`crate::client::fluent_builders::DescribeAvailabilityMonitorTest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAvailabilityMonitorTest {
    _private: (),
}
impl DescribeAvailabilityMonitorTest {
    /// Creates a new builder-style object to manufacture [`DescribeAvailabilityMonitorTestInput`](crate::input::DescribeAvailabilityMonitorTestInput)
    pub fn builder() -> crate::input::describe_availability_monitor_test_input::Builder {
        crate::input::describe_availability_monitor_test_input::Builder::default()
    }
    /// Creates a new `DescribeAvailabilityMonitorTest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAvailabilityMonitorTest {
    type Output = std::result::Result<
        crate::output::DescribeAvailabilityMonitorTestOutput,
        crate::error::DescribeAvailabilityMonitorTestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_availability_monitor_test_error(response)
        } else {
            crate::operation_deser::parse_describe_availability_monitor_test_response(response)
        }
    }
}

/// Operation shape for `DescribeBandwidthRateLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bandwidth_rate_limit`](crate::client::Client::describe_bandwidth_rate_limit).
///
/// See [`crate::client::fluent_builders::DescribeBandwidthRateLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBandwidthRateLimit {
    _private: (),
}
impl DescribeBandwidthRateLimit {
    /// Creates a new builder-style object to manufacture [`DescribeBandwidthRateLimitInput`](crate::input::DescribeBandwidthRateLimitInput)
    pub fn builder() -> crate::input::describe_bandwidth_rate_limit_input::Builder {
        crate::input::describe_bandwidth_rate_limit_input::Builder::default()
    }
    /// Creates a new `DescribeBandwidthRateLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBandwidthRateLimit {
    type Output = std::result::Result<
        crate::output::DescribeBandwidthRateLimitOutput,
        crate::error::DescribeBandwidthRateLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bandwidth_rate_limit_error(response)
        } else {
            crate::operation_deser::parse_describe_bandwidth_rate_limit_response(response)
        }
    }
}

/// Operation shape for `DescribeBandwidthRateLimitSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bandwidth_rate_limit_schedule`](crate::client::Client::describe_bandwidth_rate_limit_schedule).
///
/// See [`crate::client::fluent_builders::DescribeBandwidthRateLimitSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBandwidthRateLimitSchedule {
    _private: (),
}
impl DescribeBandwidthRateLimitSchedule {
    /// Creates a new builder-style object to manufacture [`DescribeBandwidthRateLimitScheduleInput`](crate::input::DescribeBandwidthRateLimitScheduleInput)
    pub fn builder() -> crate::input::describe_bandwidth_rate_limit_schedule_input::Builder {
        crate::input::describe_bandwidth_rate_limit_schedule_input::Builder::default()
    }
    /// Creates a new `DescribeBandwidthRateLimitSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBandwidthRateLimitSchedule {
    type Output = std::result::Result<
        crate::output::DescribeBandwidthRateLimitScheduleOutput,
        crate::error::DescribeBandwidthRateLimitScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bandwidth_rate_limit_schedule_error(response)
        } else {
            crate::operation_deser::parse_describe_bandwidth_rate_limit_schedule_response(response)
        }
    }
}

/// Operation shape for `DescribeCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cache`](crate::client::Client::describe_cache).
///
/// See [`crate::client::fluent_builders::DescribeCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCache {
    _private: (),
}
impl DescribeCache {
    /// Creates a new builder-style object to manufacture [`DescribeCacheInput`](crate::input::DescribeCacheInput)
    pub fn builder() -> crate::input::describe_cache_input::Builder {
        crate::input::describe_cache_input::Builder::default()
    }
    /// Creates a new `DescribeCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCache {
    type Output =
        std::result::Result<crate::output::DescribeCacheOutput, crate::error::DescribeCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cache_error(response)
        } else {
            crate::operation_deser::parse_describe_cache_response(response)
        }
    }
}

/// Operation shape for `DescribeCachediSCSIVolumes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cachedi_scsi_volumes`](crate::client::Client::describe_cachedi_scsi_volumes).
///
/// See [`crate::client::fluent_builders::DescribeCachediSCSIVolumes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCachediSCSIVolumes {
    _private: (),
}
impl DescribeCachediSCSIVolumes {
    /// Creates a new builder-style object to manufacture [`DescribeCachediScsiVolumesInput`](crate::input::DescribeCachediScsiVolumesInput)
    pub fn builder() -> crate::input::describe_cachedi_scsi_volumes_input::Builder {
        crate::input::describe_cachedi_scsi_volumes_input::Builder::default()
    }
    /// Creates a new `DescribeCachediSCSIVolumes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCachediSCSIVolumes {
    type Output = std::result::Result<
        crate::output::DescribeCachediScsiVolumesOutput,
        crate::error::DescribeCachediSCSIVolumesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cachedi_scsi_volumes_error(response)
        } else {
            crate::operation_deser::parse_describe_cachedi_scsi_volumes_response(response)
        }
    }
}

/// Operation shape for `DescribeChapCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_chap_credentials`](crate::client::Client::describe_chap_credentials).
///
/// See [`crate::client::fluent_builders::DescribeChapCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChapCredentials {
    _private: (),
}
impl DescribeChapCredentials {
    /// Creates a new builder-style object to manufacture [`DescribeChapCredentialsInput`](crate::input::DescribeChapCredentialsInput)
    pub fn builder() -> crate::input::describe_chap_credentials_input::Builder {
        crate::input::describe_chap_credentials_input::Builder::default()
    }
    /// Creates a new `DescribeChapCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChapCredentials {
    type Output = std::result::Result<
        crate::output::DescribeChapCredentialsOutput,
        crate::error::DescribeChapCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_chap_credentials_error(response)
        } else {
            crate::operation_deser::parse_describe_chap_credentials_response(response)
        }
    }
}

/// Operation shape for `DescribeFileSystemAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_file_system_associations`](crate::client::Client::describe_file_system_associations).
///
/// See [`crate::client::fluent_builders::DescribeFileSystemAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFileSystemAssociations {
    _private: (),
}
impl DescribeFileSystemAssociations {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemAssociationsInput`](crate::input::DescribeFileSystemAssociationsInput)
    pub fn builder() -> crate::input::describe_file_system_associations_input::Builder {
        crate::input::describe_file_system_associations_input::Builder::default()
    }
    /// Creates a new `DescribeFileSystemAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFileSystemAssociations {
    type Output = std::result::Result<
        crate::output::DescribeFileSystemAssociationsOutput,
        crate::error::DescribeFileSystemAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_file_system_associations_error(response)
        } else {
            crate::operation_deser::parse_describe_file_system_associations_response(response)
        }
    }
}

/// Operation shape for `DescribeGatewayInformation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_gateway_information`](crate::client::Client::describe_gateway_information).
///
/// See [`crate::client::fluent_builders::DescribeGatewayInformation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGatewayInformation {
    _private: (),
}
impl DescribeGatewayInformation {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayInformationInput`](crate::input::DescribeGatewayInformationInput)
    pub fn builder() -> crate::input::describe_gateway_information_input::Builder {
        crate::input::describe_gateway_information_input::Builder::default()
    }
    /// Creates a new `DescribeGatewayInformation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGatewayInformation {
    type Output = std::result::Result<
        crate::output::DescribeGatewayInformationOutput,
        crate::error::DescribeGatewayInformationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_gateway_information_error(response)
        } else {
            crate::operation_deser::parse_describe_gateway_information_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceStartTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_start_time`](crate::client::Client::describe_maintenance_start_time).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceStartTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceStartTime {
    _private: (),
}
impl DescribeMaintenanceStartTime {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceStartTimeInput`](crate::input::DescribeMaintenanceStartTimeInput)
    pub fn builder() -> crate::input::describe_maintenance_start_time_input::Builder {
        crate::input::describe_maintenance_start_time_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceStartTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceStartTime {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceStartTimeOutput,
        crate::error::DescribeMaintenanceStartTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_start_time_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_start_time_response(response)
        }
    }
}

/// Operation shape for `DescribeNFSFileShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_nfs_file_shares`](crate::client::Client::describe_nfs_file_shares).
///
/// See [`crate::client::fluent_builders::DescribeNFSFileShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNFSFileShares {
    _private: (),
}
impl DescribeNFSFileShares {
    /// Creates a new builder-style object to manufacture [`DescribeNfsFileSharesInput`](crate::input::DescribeNfsFileSharesInput)
    pub fn builder() -> crate::input::describe_nfs_file_shares_input::Builder {
        crate::input::describe_nfs_file_shares_input::Builder::default()
    }
    /// Creates a new `DescribeNFSFileShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNFSFileShares {
    type Output = std::result::Result<
        crate::output::DescribeNfsFileSharesOutput,
        crate::error::DescribeNFSFileSharesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_nfs_file_shares_error(response)
        } else {
            crate::operation_deser::parse_describe_nfs_file_shares_response(response)
        }
    }
}

/// Operation shape for `DescribeSMBFileShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_smb_file_shares`](crate::client::Client::describe_smb_file_shares).
///
/// See [`crate::client::fluent_builders::DescribeSMBFileShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSMBFileShares {
    _private: (),
}
impl DescribeSMBFileShares {
    /// Creates a new builder-style object to manufacture [`DescribeSmbFileSharesInput`](crate::input::DescribeSmbFileSharesInput)
    pub fn builder() -> crate::input::describe_smb_file_shares_input::Builder {
        crate::input::describe_smb_file_shares_input::Builder::default()
    }
    /// Creates a new `DescribeSMBFileShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSMBFileShares {
    type Output = std::result::Result<
        crate::output::DescribeSmbFileSharesOutput,
        crate::error::DescribeSMBFileSharesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_smb_file_shares_error(response)
        } else {
            crate::operation_deser::parse_describe_smb_file_shares_response(response)
        }
    }
}

/// Operation shape for `DescribeSMBSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_smb_settings`](crate::client::Client::describe_smb_settings).
///
/// See [`crate::client::fluent_builders::DescribeSMBSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSMBSettings {
    _private: (),
}
impl DescribeSMBSettings {
    /// Creates a new builder-style object to manufacture [`DescribeSmbSettingsInput`](crate::input::DescribeSmbSettingsInput)
    pub fn builder() -> crate::input::describe_smb_settings_input::Builder {
        crate::input::describe_smb_settings_input::Builder::default()
    }
    /// Creates a new `DescribeSMBSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSMBSettings {
    type Output = std::result::Result<
        crate::output::DescribeSmbSettingsOutput,
        crate::error::DescribeSMBSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_smb_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_smb_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshotSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshot_schedule`](crate::client::Client::describe_snapshot_schedule).
///
/// See [`crate::client::fluent_builders::DescribeSnapshotSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshotSchedule {
    _private: (),
}
impl DescribeSnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotScheduleInput`](crate::input::DescribeSnapshotScheduleInput)
    pub fn builder() -> crate::input::describe_snapshot_schedule_input::Builder {
        crate::input::describe_snapshot_schedule_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshotSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshotSchedule {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotScheduleOutput,
        crate::error::DescribeSnapshotScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshot_schedule_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshot_schedule_response(response)
        }
    }
}

/// Operation shape for `DescribeStorediSCSIVolumes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_storedi_scsi_volumes`](crate::client::Client::describe_storedi_scsi_volumes).
///
/// See [`crate::client::fluent_builders::DescribeStorediSCSIVolumes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStorediSCSIVolumes {
    _private: (),
}
impl DescribeStorediSCSIVolumes {
    /// Creates a new builder-style object to manufacture [`DescribeStorediScsiVolumesInput`](crate::input::DescribeStorediScsiVolumesInput)
    pub fn builder() -> crate::input::describe_storedi_scsi_volumes_input::Builder {
        crate::input::describe_storedi_scsi_volumes_input::Builder::default()
    }
    /// Creates a new `DescribeStorediSCSIVolumes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStorediSCSIVolumes {
    type Output = std::result::Result<
        crate::output::DescribeStorediScsiVolumesOutput,
        crate::error::DescribeStorediSCSIVolumesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_storedi_scsi_volumes_error(response)
        } else {
            crate::operation_deser::parse_describe_storedi_scsi_volumes_response(response)
        }
    }
}

/// Operation shape for `DescribeTapeArchives`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tape_archives`](crate::client::Client::describe_tape_archives).
///
/// See [`crate::client::fluent_builders::DescribeTapeArchives`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTapeArchives {
    _private: (),
}
impl DescribeTapeArchives {
    /// Creates a new builder-style object to manufacture [`DescribeTapeArchivesInput`](crate::input::DescribeTapeArchivesInput)
    pub fn builder() -> crate::input::describe_tape_archives_input::Builder {
        crate::input::describe_tape_archives_input::Builder::default()
    }
    /// Creates a new `DescribeTapeArchives` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTapeArchives {
    type Output = std::result::Result<
        crate::output::DescribeTapeArchivesOutput,
        crate::error::DescribeTapeArchivesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tape_archives_error(response)
        } else {
            crate::operation_deser::parse_describe_tape_archives_response(response)
        }
    }
}

/// Operation shape for `DescribeTapeRecoveryPoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tape_recovery_points`](crate::client::Client::describe_tape_recovery_points).
///
/// See [`crate::client::fluent_builders::DescribeTapeRecoveryPoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTapeRecoveryPoints {
    _private: (),
}
impl DescribeTapeRecoveryPoints {
    /// Creates a new builder-style object to manufacture [`DescribeTapeRecoveryPointsInput`](crate::input::DescribeTapeRecoveryPointsInput)
    pub fn builder() -> crate::input::describe_tape_recovery_points_input::Builder {
        crate::input::describe_tape_recovery_points_input::Builder::default()
    }
    /// Creates a new `DescribeTapeRecoveryPoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTapeRecoveryPoints {
    type Output = std::result::Result<
        crate::output::DescribeTapeRecoveryPointsOutput,
        crate::error::DescribeTapeRecoveryPointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tape_recovery_points_error(response)
        } else {
            crate::operation_deser::parse_describe_tape_recovery_points_response(response)
        }
    }
}

/// Operation shape for `DescribeTapes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tapes`](crate::client::Client::describe_tapes).
///
/// See [`crate::client::fluent_builders::DescribeTapes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTapes {
    _private: (),
}
impl DescribeTapes {
    /// Creates a new builder-style object to manufacture [`DescribeTapesInput`](crate::input::DescribeTapesInput)
    pub fn builder() -> crate::input::describe_tapes_input::Builder {
        crate::input::describe_tapes_input::Builder::default()
    }
    /// Creates a new `DescribeTapes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTapes {
    type Output =
        std::result::Result<crate::output::DescribeTapesOutput, crate::error::DescribeTapesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tapes_error(response)
        } else {
            crate::operation_deser::parse_describe_tapes_response(response)
        }
    }
}

/// Operation shape for `DescribeUploadBuffer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_upload_buffer`](crate::client::Client::describe_upload_buffer).
///
/// See [`crate::client::fluent_builders::DescribeUploadBuffer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUploadBuffer {
    _private: (),
}
impl DescribeUploadBuffer {
    /// Creates a new builder-style object to manufacture [`DescribeUploadBufferInput`](crate::input::DescribeUploadBufferInput)
    pub fn builder() -> crate::input::describe_upload_buffer_input::Builder {
        crate::input::describe_upload_buffer_input::Builder::default()
    }
    /// Creates a new `DescribeUploadBuffer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUploadBuffer {
    type Output = std::result::Result<
        crate::output::DescribeUploadBufferOutput,
        crate::error::DescribeUploadBufferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_upload_buffer_error(response)
        } else {
            crate::operation_deser::parse_describe_upload_buffer_response(response)
        }
    }
}

/// Operation shape for `DescribeVTLDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vtl_devices`](crate::client::Client::describe_vtl_devices).
///
/// See [`crate::client::fluent_builders::DescribeVTLDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVTLDevices {
    _private: (),
}
impl DescribeVTLDevices {
    /// Creates a new builder-style object to manufacture [`DescribeVtlDevicesInput`](crate::input::DescribeVtlDevicesInput)
    pub fn builder() -> crate::input::describe_vtl_devices_input::Builder {
        crate::input::describe_vtl_devices_input::Builder::default()
    }
    /// Creates a new `DescribeVTLDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVTLDevices {
    type Output = std::result::Result<
        crate::output::DescribeVtlDevicesOutput,
        crate::error::DescribeVTLDevicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vtl_devices_error(response)
        } else {
            crate::operation_deser::parse_describe_vtl_devices_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkingStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_working_storage`](crate::client::Client::describe_working_storage).
///
/// See [`crate::client::fluent_builders::DescribeWorkingStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkingStorage {
    _private: (),
}
impl DescribeWorkingStorage {
    /// Creates a new builder-style object to manufacture [`DescribeWorkingStorageInput`](crate::input::DescribeWorkingStorageInput)
    pub fn builder() -> crate::input::describe_working_storage_input::Builder {
        crate::input::describe_working_storage_input::Builder::default()
    }
    /// Creates a new `DescribeWorkingStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkingStorage {
    type Output = std::result::Result<
        crate::output::DescribeWorkingStorageOutput,
        crate::error::DescribeWorkingStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_working_storage_error(response)
        } else {
            crate::operation_deser::parse_describe_working_storage_response(response)
        }
    }
}

/// Operation shape for `DetachVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_volume`](crate::client::Client::detach_volume).
///
/// See [`crate::client::fluent_builders::DetachVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachVolume {
    _private: (),
}
impl DetachVolume {
    /// Creates a new builder-style object to manufacture [`DetachVolumeInput`](crate::input::DetachVolumeInput)
    pub fn builder() -> crate::input::detach_volume_input::Builder {
        crate::input::detach_volume_input::Builder::default()
    }
    /// Creates a new `DetachVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachVolume {
    type Output =
        std::result::Result<crate::output::DetachVolumeOutput, crate::error::DetachVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_volume_error(response)
        } else {
            crate::operation_deser::parse_detach_volume_response(response)
        }
    }
}

/// Operation shape for `DisableGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_gateway`](crate::client::Client::disable_gateway).
///
/// See [`crate::client::fluent_builders::DisableGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableGateway {
    _private: (),
}
impl DisableGateway {
    /// Creates a new builder-style object to manufacture [`DisableGatewayInput`](crate::input::DisableGatewayInput)
    pub fn builder() -> crate::input::disable_gateway_input::Builder {
        crate::input::disable_gateway_input::Builder::default()
    }
    /// Creates a new `DisableGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableGateway {
    type Output =
        std::result::Result<crate::output::DisableGatewayOutput, crate::error::DisableGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_gateway_error(response)
        } else {
            crate::operation_deser::parse_disable_gateway_response(response)
        }
    }
}

/// Operation shape for `DisassociateFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_file_system`](crate::client::Client::disassociate_file_system).
///
/// See [`crate::client::fluent_builders::DisassociateFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFileSystem {
    _private: (),
}
impl DisassociateFileSystem {
    /// Creates a new builder-style object to manufacture [`DisassociateFileSystemInput`](crate::input::DisassociateFileSystemInput)
    pub fn builder() -> crate::input::disassociate_file_system_input::Builder {
        crate::input::disassociate_file_system_input::Builder::default()
    }
    /// Creates a new `DisassociateFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFileSystem {
    type Output = std::result::Result<
        crate::output::DisassociateFileSystemOutput,
        crate::error::DisassociateFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_file_system_error(response)
        } else {
            crate::operation_deser::parse_disassociate_file_system_response(response)
        }
    }
}

/// Operation shape for `JoinDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`join_domain`](crate::client::Client::join_domain).
///
/// See [`crate::client::fluent_builders::JoinDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct JoinDomain {
    _private: (),
}
impl JoinDomain {
    /// Creates a new builder-style object to manufacture [`JoinDomainInput`](crate::input::JoinDomainInput)
    pub fn builder() -> crate::input::join_domain_input::Builder {
        crate::input::join_domain_input::Builder::default()
    }
    /// Creates a new `JoinDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for JoinDomain {
    type Output =
        std::result::Result<crate::output::JoinDomainOutput, crate::error::JoinDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_join_domain_error(response)
        } else {
            crate::operation_deser::parse_join_domain_response(response)
        }
    }
}

/// Operation shape for `ListAutomaticTapeCreationPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_automatic_tape_creation_policies`](crate::client::Client::list_automatic_tape_creation_policies).
///
/// See [`crate::client::fluent_builders::ListAutomaticTapeCreationPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAutomaticTapeCreationPolicies {
    _private: (),
}
impl ListAutomaticTapeCreationPolicies {
    /// Creates a new builder-style object to manufacture [`ListAutomaticTapeCreationPoliciesInput`](crate::input::ListAutomaticTapeCreationPoliciesInput)
    pub fn builder() -> crate::input::list_automatic_tape_creation_policies_input::Builder {
        crate::input::list_automatic_tape_creation_policies_input::Builder::default()
    }
    /// Creates a new `ListAutomaticTapeCreationPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAutomaticTapeCreationPolicies {
    type Output = std::result::Result<
        crate::output::ListAutomaticTapeCreationPoliciesOutput,
        crate::error::ListAutomaticTapeCreationPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_automatic_tape_creation_policies_error(response)
        } else {
            crate::operation_deser::parse_list_automatic_tape_creation_policies_response(response)
        }
    }
}

/// Operation shape for `ListFileShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_file_shares`](crate::client::Client::list_file_shares).
///
/// See [`crate::client::fluent_builders::ListFileShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFileShares {
    _private: (),
}
impl ListFileShares {
    /// Creates a new builder-style object to manufacture [`ListFileSharesInput`](crate::input::ListFileSharesInput)
    pub fn builder() -> crate::input::list_file_shares_input::Builder {
        crate::input::list_file_shares_input::Builder::default()
    }
    /// Creates a new `ListFileShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFileShares {
    type Output =
        std::result::Result<crate::output::ListFileSharesOutput, crate::error::ListFileSharesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_file_shares_error(response)
        } else {
            crate::operation_deser::parse_list_file_shares_response(response)
        }
    }
}

/// Operation shape for `ListFileSystemAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_file_system_associations`](crate::client::Client::list_file_system_associations).
///
/// See [`crate::client::fluent_builders::ListFileSystemAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFileSystemAssociations {
    _private: (),
}
impl ListFileSystemAssociations {
    /// Creates a new builder-style object to manufacture [`ListFileSystemAssociationsInput`](crate::input::ListFileSystemAssociationsInput)
    pub fn builder() -> crate::input::list_file_system_associations_input::Builder {
        crate::input::list_file_system_associations_input::Builder::default()
    }
    /// Creates a new `ListFileSystemAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFileSystemAssociations {
    type Output = std::result::Result<
        crate::output::ListFileSystemAssociationsOutput,
        crate::error::ListFileSystemAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_file_system_associations_error(response)
        } else {
            crate::operation_deser::parse_list_file_system_associations_response(response)
        }
    }
}

/// Operation shape for `ListGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_gateways`](crate::client::Client::list_gateways).
///
/// See [`crate::client::fluent_builders::ListGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGateways {
    _private: (),
}
impl ListGateways {
    /// Creates a new builder-style object to manufacture [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    pub fn builder() -> crate::input::list_gateways_input::Builder {
        crate::input::list_gateways_input::Builder::default()
    }
    /// Creates a new `ListGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGateways {
    type Output =
        std::result::Result<crate::output::ListGatewaysOutput, crate::error::ListGatewaysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_gateways_error(response)
        } else {
            crate::operation_deser::parse_list_gateways_response(response)
        }
    }
}

/// Operation shape for `ListLocalDisks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_local_disks`](crate::client::Client::list_local_disks).
///
/// See [`crate::client::fluent_builders::ListLocalDisks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLocalDisks {
    _private: (),
}
impl ListLocalDisks {
    /// Creates a new builder-style object to manufacture [`ListLocalDisksInput`](crate::input::ListLocalDisksInput)
    pub fn builder() -> crate::input::list_local_disks_input::Builder {
        crate::input::list_local_disks_input::Builder::default()
    }
    /// Creates a new `ListLocalDisks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLocalDisks {
    type Output =
        std::result::Result<crate::output::ListLocalDisksOutput, crate::error::ListLocalDisksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_local_disks_error(response)
        } else {
            crate::operation_deser::parse_list_local_disks_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTapePools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tape_pools`](crate::client::Client::list_tape_pools).
///
/// See [`crate::client::fluent_builders::ListTapePools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTapePools {
    _private: (),
}
impl ListTapePools {
    /// Creates a new builder-style object to manufacture [`ListTapePoolsInput`](crate::input::ListTapePoolsInput)
    pub fn builder() -> crate::input::list_tape_pools_input::Builder {
        crate::input::list_tape_pools_input::Builder::default()
    }
    /// Creates a new `ListTapePools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTapePools {
    type Output =
        std::result::Result<crate::output::ListTapePoolsOutput, crate::error::ListTapePoolsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tape_pools_error(response)
        } else {
            crate::operation_deser::parse_list_tape_pools_response(response)
        }
    }
}

/// Operation shape for `ListTapes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tapes`](crate::client::Client::list_tapes).
///
/// See [`crate::client::fluent_builders::ListTapes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTapes {
    _private: (),
}
impl ListTapes {
    /// Creates a new builder-style object to manufacture [`ListTapesInput`](crate::input::ListTapesInput)
    pub fn builder() -> crate::input::list_tapes_input::Builder {
        crate::input::list_tapes_input::Builder::default()
    }
    /// Creates a new `ListTapes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTapes {
    type Output = std::result::Result<crate::output::ListTapesOutput, crate::error::ListTapesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tapes_error(response)
        } else {
            crate::operation_deser::parse_list_tapes_response(response)
        }
    }
}

/// Operation shape for `ListVolumeInitiators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_volume_initiators`](crate::client::Client::list_volume_initiators).
///
/// See [`crate::client::fluent_builders::ListVolumeInitiators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVolumeInitiators {
    _private: (),
}
impl ListVolumeInitiators {
    /// Creates a new builder-style object to manufacture [`ListVolumeInitiatorsInput`](crate::input::ListVolumeInitiatorsInput)
    pub fn builder() -> crate::input::list_volume_initiators_input::Builder {
        crate::input::list_volume_initiators_input::Builder::default()
    }
    /// Creates a new `ListVolumeInitiators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVolumeInitiators {
    type Output = std::result::Result<
        crate::output::ListVolumeInitiatorsOutput,
        crate::error::ListVolumeInitiatorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_volume_initiators_error(response)
        } else {
            crate::operation_deser::parse_list_volume_initiators_response(response)
        }
    }
}

/// Operation shape for `ListVolumeRecoveryPoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_volume_recovery_points`](crate::client::Client::list_volume_recovery_points).
///
/// See [`crate::client::fluent_builders::ListVolumeRecoveryPoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVolumeRecoveryPoints {
    _private: (),
}
impl ListVolumeRecoveryPoints {
    /// Creates a new builder-style object to manufacture [`ListVolumeRecoveryPointsInput`](crate::input::ListVolumeRecoveryPointsInput)
    pub fn builder() -> crate::input::list_volume_recovery_points_input::Builder {
        crate::input::list_volume_recovery_points_input::Builder::default()
    }
    /// Creates a new `ListVolumeRecoveryPoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVolumeRecoveryPoints {
    type Output = std::result::Result<
        crate::output::ListVolumeRecoveryPointsOutput,
        crate::error::ListVolumeRecoveryPointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_volume_recovery_points_error(response)
        } else {
            crate::operation_deser::parse_list_volume_recovery_points_response(response)
        }
    }
}

/// Operation shape for `ListVolumes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_volumes`](crate::client::Client::list_volumes).
///
/// See [`crate::client::fluent_builders::ListVolumes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVolumes {
    _private: (),
}
impl ListVolumes {
    /// Creates a new builder-style object to manufacture [`ListVolumesInput`](crate::input::ListVolumesInput)
    pub fn builder() -> crate::input::list_volumes_input::Builder {
        crate::input::list_volumes_input::Builder::default()
    }
    /// Creates a new `ListVolumes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVolumes {
    type Output =
        std::result::Result<crate::output::ListVolumesOutput, crate::error::ListVolumesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_volumes_error(response)
        } else {
            crate::operation_deser::parse_list_volumes_response(response)
        }
    }
}

/// Operation shape for `NotifyWhenUploaded`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`notify_when_uploaded`](crate::client::Client::notify_when_uploaded).
///
/// See [`crate::client::fluent_builders::NotifyWhenUploaded`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct NotifyWhenUploaded {
    _private: (),
}
impl NotifyWhenUploaded {
    /// Creates a new builder-style object to manufacture [`NotifyWhenUploadedInput`](crate::input::NotifyWhenUploadedInput)
    pub fn builder() -> crate::input::notify_when_uploaded_input::Builder {
        crate::input::notify_when_uploaded_input::Builder::default()
    }
    /// Creates a new `NotifyWhenUploaded` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for NotifyWhenUploaded {
    type Output = std::result::Result<
        crate::output::NotifyWhenUploadedOutput,
        crate::error::NotifyWhenUploadedError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_notify_when_uploaded_error(response)
        } else {
            crate::operation_deser::parse_notify_when_uploaded_response(response)
        }
    }
}

/// Operation shape for `RefreshCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`refresh_cache`](crate::client::Client::refresh_cache).
///
/// See [`crate::client::fluent_builders::RefreshCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RefreshCache {
    _private: (),
}
impl RefreshCache {
    /// Creates a new builder-style object to manufacture [`RefreshCacheInput`](crate::input::RefreshCacheInput)
    pub fn builder() -> crate::input::refresh_cache_input::Builder {
        crate::input::refresh_cache_input::Builder::default()
    }
    /// Creates a new `RefreshCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RefreshCache {
    type Output =
        std::result::Result<crate::output::RefreshCacheOutput, crate::error::RefreshCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_refresh_cache_error(response)
        } else {
            crate::operation_deser::parse_refresh_cache_response(response)
        }
    }
}

/// Operation shape for `RemoveTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_resource`](crate::client::Client::remove_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromResource {
    _private: (),
}
impl RemoveTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromResourceOutput,
        crate::error::RemoveTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `ResetCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_cache`](crate::client::Client::reset_cache).
///
/// See [`crate::client::fluent_builders::ResetCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetCache {
    _private: (),
}
impl ResetCache {
    /// Creates a new builder-style object to manufacture [`ResetCacheInput`](crate::input::ResetCacheInput)
    pub fn builder() -> crate::input::reset_cache_input::Builder {
        crate::input::reset_cache_input::Builder::default()
    }
    /// Creates a new `ResetCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetCache {
    type Output =
        std::result::Result<crate::output::ResetCacheOutput, crate::error::ResetCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_cache_error(response)
        } else {
            crate::operation_deser::parse_reset_cache_response(response)
        }
    }
}

/// Operation shape for `RetrieveTapeArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retrieve_tape_archive`](crate::client::Client::retrieve_tape_archive).
///
/// See [`crate::client::fluent_builders::RetrieveTapeArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetrieveTapeArchive {
    _private: (),
}
impl RetrieveTapeArchive {
    /// Creates a new builder-style object to manufacture [`RetrieveTapeArchiveInput`](crate::input::RetrieveTapeArchiveInput)
    pub fn builder() -> crate::input::retrieve_tape_archive_input::Builder {
        crate::input::retrieve_tape_archive_input::Builder::default()
    }
    /// Creates a new `RetrieveTapeArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetrieveTapeArchive {
    type Output = std::result::Result<
        crate::output::RetrieveTapeArchiveOutput,
        crate::error::RetrieveTapeArchiveError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retrieve_tape_archive_error(response)
        } else {
            crate::operation_deser::parse_retrieve_tape_archive_response(response)
        }
    }
}

/// Operation shape for `RetrieveTapeRecoveryPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retrieve_tape_recovery_point`](crate::client::Client::retrieve_tape_recovery_point).
///
/// See [`crate::client::fluent_builders::RetrieveTapeRecoveryPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetrieveTapeRecoveryPoint {
    _private: (),
}
impl RetrieveTapeRecoveryPoint {
    /// Creates a new builder-style object to manufacture [`RetrieveTapeRecoveryPointInput`](crate::input::RetrieveTapeRecoveryPointInput)
    pub fn builder() -> crate::input::retrieve_tape_recovery_point_input::Builder {
        crate::input::retrieve_tape_recovery_point_input::Builder::default()
    }
    /// Creates a new `RetrieveTapeRecoveryPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetrieveTapeRecoveryPoint {
    type Output = std::result::Result<
        crate::output::RetrieveTapeRecoveryPointOutput,
        crate::error::RetrieveTapeRecoveryPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retrieve_tape_recovery_point_error(response)
        } else {
            crate::operation_deser::parse_retrieve_tape_recovery_point_response(response)
        }
    }
}

/// Operation shape for `SetLocalConsolePassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_local_console_password`](crate::client::Client::set_local_console_password).
///
/// See [`crate::client::fluent_builders::SetLocalConsolePassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetLocalConsolePassword {
    _private: (),
}
impl SetLocalConsolePassword {
    /// Creates a new builder-style object to manufacture [`SetLocalConsolePasswordInput`](crate::input::SetLocalConsolePasswordInput)
    pub fn builder() -> crate::input::set_local_console_password_input::Builder {
        crate::input::set_local_console_password_input::Builder::default()
    }
    /// Creates a new `SetLocalConsolePassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetLocalConsolePassword {
    type Output = std::result::Result<
        crate::output::SetLocalConsolePasswordOutput,
        crate::error::SetLocalConsolePasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_local_console_password_error(response)
        } else {
            crate::operation_deser::parse_set_local_console_password_response(response)
        }
    }
}

/// Operation shape for `SetSMBGuestPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_smb_guest_password`](crate::client::Client::set_smb_guest_password).
///
/// See [`crate::client::fluent_builders::SetSMBGuestPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetSMBGuestPassword {
    _private: (),
}
impl SetSMBGuestPassword {
    /// Creates a new builder-style object to manufacture [`SetSmbGuestPasswordInput`](crate::input::SetSmbGuestPasswordInput)
    pub fn builder() -> crate::input::set_smb_guest_password_input::Builder {
        crate::input::set_smb_guest_password_input::Builder::default()
    }
    /// Creates a new `SetSMBGuestPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetSMBGuestPassword {
    type Output = std::result::Result<
        crate::output::SetSmbGuestPasswordOutput,
        crate::error::SetSMBGuestPasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_smb_guest_password_error(response)
        } else {
            crate::operation_deser::parse_set_smb_guest_password_response(response)
        }
    }
}

/// Operation shape for `ShutdownGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`shutdown_gateway`](crate::client::Client::shutdown_gateway).
///
/// See [`crate::client::fluent_builders::ShutdownGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ShutdownGateway {
    _private: (),
}
impl ShutdownGateway {
    /// Creates a new builder-style object to manufacture [`ShutdownGatewayInput`](crate::input::ShutdownGatewayInput)
    pub fn builder() -> crate::input::shutdown_gateway_input::Builder {
        crate::input::shutdown_gateway_input::Builder::default()
    }
    /// Creates a new `ShutdownGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ShutdownGateway {
    type Output = std::result::Result<
        crate::output::ShutdownGatewayOutput,
        crate::error::ShutdownGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_shutdown_gateway_error(response)
        } else {
            crate::operation_deser::parse_shutdown_gateway_response(response)
        }
    }
}

/// Operation shape for `StartAvailabilityMonitorTest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_availability_monitor_test`](crate::client::Client::start_availability_monitor_test).
///
/// See [`crate::client::fluent_builders::StartAvailabilityMonitorTest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAvailabilityMonitorTest {
    _private: (),
}
impl StartAvailabilityMonitorTest {
    /// Creates a new builder-style object to manufacture [`StartAvailabilityMonitorTestInput`](crate::input::StartAvailabilityMonitorTestInput)
    pub fn builder() -> crate::input::start_availability_monitor_test_input::Builder {
        crate::input::start_availability_monitor_test_input::Builder::default()
    }
    /// Creates a new `StartAvailabilityMonitorTest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAvailabilityMonitorTest {
    type Output = std::result::Result<
        crate::output::StartAvailabilityMonitorTestOutput,
        crate::error::StartAvailabilityMonitorTestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_availability_monitor_test_error(response)
        } else {
            crate::operation_deser::parse_start_availability_monitor_test_response(response)
        }
    }
}

/// Operation shape for `StartGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_gateway`](crate::client::Client::start_gateway).
///
/// See [`crate::client::fluent_builders::StartGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartGateway {
    _private: (),
}
impl StartGateway {
    /// Creates a new builder-style object to manufacture [`StartGatewayInput`](crate::input::StartGatewayInput)
    pub fn builder() -> crate::input::start_gateway_input::Builder {
        crate::input::start_gateway_input::Builder::default()
    }
    /// Creates a new `StartGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartGateway {
    type Output =
        std::result::Result<crate::output::StartGatewayOutput, crate::error::StartGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_gateway_error(response)
        } else {
            crate::operation_deser::parse_start_gateway_response(response)
        }
    }
}

/// Operation shape for `UpdateAutomaticTapeCreationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_automatic_tape_creation_policy`](crate::client::Client::update_automatic_tape_creation_policy).
///
/// See [`crate::client::fluent_builders::UpdateAutomaticTapeCreationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAutomaticTapeCreationPolicy {
    _private: (),
}
impl UpdateAutomaticTapeCreationPolicy {
    /// Creates a new builder-style object to manufacture [`UpdateAutomaticTapeCreationPolicyInput`](crate::input::UpdateAutomaticTapeCreationPolicyInput)
    pub fn builder() -> crate::input::update_automatic_tape_creation_policy_input::Builder {
        crate::input::update_automatic_tape_creation_policy_input::Builder::default()
    }
    /// Creates a new `UpdateAutomaticTapeCreationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAutomaticTapeCreationPolicy {
    type Output = std::result::Result<
        crate::output::UpdateAutomaticTapeCreationPolicyOutput,
        crate::error::UpdateAutomaticTapeCreationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_automatic_tape_creation_policy_error(response)
        } else {
            crate::operation_deser::parse_update_automatic_tape_creation_policy_response(response)
        }
    }
}

/// Operation shape for `UpdateBandwidthRateLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bandwidth_rate_limit`](crate::client::Client::update_bandwidth_rate_limit).
///
/// See [`crate::client::fluent_builders::UpdateBandwidthRateLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBandwidthRateLimit {
    _private: (),
}
impl UpdateBandwidthRateLimit {
    /// Creates a new builder-style object to manufacture [`UpdateBandwidthRateLimitInput`](crate::input::UpdateBandwidthRateLimitInput)
    pub fn builder() -> crate::input::update_bandwidth_rate_limit_input::Builder {
        crate::input::update_bandwidth_rate_limit_input::Builder::default()
    }
    /// Creates a new `UpdateBandwidthRateLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBandwidthRateLimit {
    type Output = std::result::Result<
        crate::output::UpdateBandwidthRateLimitOutput,
        crate::error::UpdateBandwidthRateLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_bandwidth_rate_limit_error(response)
        } else {
            crate::operation_deser::parse_update_bandwidth_rate_limit_response(response)
        }
    }
}

/// Operation shape for `UpdateBandwidthRateLimitSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bandwidth_rate_limit_schedule`](crate::client::Client::update_bandwidth_rate_limit_schedule).
///
/// See [`crate::client::fluent_builders::UpdateBandwidthRateLimitSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBandwidthRateLimitSchedule {
    _private: (),
}
impl UpdateBandwidthRateLimitSchedule {
    /// Creates a new builder-style object to manufacture [`UpdateBandwidthRateLimitScheduleInput`](crate::input::UpdateBandwidthRateLimitScheduleInput)
    pub fn builder() -> crate::input::update_bandwidth_rate_limit_schedule_input::Builder {
        crate::input::update_bandwidth_rate_limit_schedule_input::Builder::default()
    }
    /// Creates a new `UpdateBandwidthRateLimitSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBandwidthRateLimitSchedule {
    type Output = std::result::Result<
        crate::output::UpdateBandwidthRateLimitScheduleOutput,
        crate::error::UpdateBandwidthRateLimitScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_bandwidth_rate_limit_schedule_error(response)
        } else {
            crate::operation_deser::parse_update_bandwidth_rate_limit_schedule_response(response)
        }
    }
}

/// Operation shape for `UpdateChapCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_chap_credentials`](crate::client::Client::update_chap_credentials).
///
/// See [`crate::client::fluent_builders::UpdateChapCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChapCredentials {
    _private: (),
}
impl UpdateChapCredentials {
    /// Creates a new builder-style object to manufacture [`UpdateChapCredentialsInput`](crate::input::UpdateChapCredentialsInput)
    pub fn builder() -> crate::input::update_chap_credentials_input::Builder {
        crate::input::update_chap_credentials_input::Builder::default()
    }
    /// Creates a new `UpdateChapCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChapCredentials {
    type Output = std::result::Result<
        crate::output::UpdateChapCredentialsOutput,
        crate::error::UpdateChapCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_chap_credentials_error(response)
        } else {
            crate::operation_deser::parse_update_chap_credentials_response(response)
        }
    }
}

/// Operation shape for `UpdateFileSystemAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_file_system_association`](crate::client::Client::update_file_system_association).
///
/// See [`crate::client::fluent_builders::UpdateFileSystemAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFileSystemAssociation {
    _private: (),
}
impl UpdateFileSystemAssociation {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemAssociationInput`](crate::input::UpdateFileSystemAssociationInput)
    pub fn builder() -> crate::input::update_file_system_association_input::Builder {
        crate::input::update_file_system_association_input::Builder::default()
    }
    /// Creates a new `UpdateFileSystemAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFileSystemAssociation {
    type Output = std::result::Result<
        crate::output::UpdateFileSystemAssociationOutput,
        crate::error::UpdateFileSystemAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_file_system_association_error(response)
        } else {
            crate::operation_deser::parse_update_file_system_association_response(response)
        }
    }
}

/// Operation shape for `UpdateGatewayInformation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway_information`](crate::client::Client::update_gateway_information).
///
/// See [`crate::client::fluent_builders::UpdateGatewayInformation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGatewayInformation {
    _private: (),
}
impl UpdateGatewayInformation {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInformationInput`](crate::input::UpdateGatewayInformationInput)
    pub fn builder() -> crate::input::update_gateway_information_input::Builder {
        crate::input::update_gateway_information_input::Builder::default()
    }
    /// Creates a new `UpdateGatewayInformation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGatewayInformation {
    type Output = std::result::Result<
        crate::output::UpdateGatewayInformationOutput,
        crate::error::UpdateGatewayInformationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gateway_information_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_information_response(response)
        }
    }
}

/// Operation shape for `UpdateGatewaySoftwareNow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway_software_now`](crate::client::Client::update_gateway_software_now).
///
/// See [`crate::client::fluent_builders::UpdateGatewaySoftwareNow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGatewaySoftwareNow {
    _private: (),
}
impl UpdateGatewaySoftwareNow {
    /// Creates a new builder-style object to manufacture [`UpdateGatewaySoftwareNowInput`](crate::input::UpdateGatewaySoftwareNowInput)
    pub fn builder() -> crate::input::update_gateway_software_now_input::Builder {
        crate::input::update_gateway_software_now_input::Builder::default()
    }
    /// Creates a new `UpdateGatewaySoftwareNow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGatewaySoftwareNow {
    type Output = std::result::Result<
        crate::output::UpdateGatewaySoftwareNowOutput,
        crate::error::UpdateGatewaySoftwareNowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gateway_software_now_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_software_now_response(response)
        }
    }
}

/// Operation shape for `UpdateMaintenanceStartTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_maintenance_start_time`](crate::client::Client::update_maintenance_start_time).
///
/// See [`crate::client::fluent_builders::UpdateMaintenanceStartTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMaintenanceStartTime {
    _private: (),
}
impl UpdateMaintenanceStartTime {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceStartTimeInput`](crate::input::UpdateMaintenanceStartTimeInput)
    pub fn builder() -> crate::input::update_maintenance_start_time_input::Builder {
        crate::input::update_maintenance_start_time_input::Builder::default()
    }
    /// Creates a new `UpdateMaintenanceStartTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMaintenanceStartTime {
    type Output = std::result::Result<
        crate::output::UpdateMaintenanceStartTimeOutput,
        crate::error::UpdateMaintenanceStartTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_maintenance_start_time_error(response)
        } else {
            crate::operation_deser::parse_update_maintenance_start_time_response(response)
        }
    }
}

/// Operation shape for `UpdateNFSFileShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_nfs_file_share`](crate::client::Client::update_nfs_file_share).
///
/// See [`crate::client::fluent_builders::UpdateNFSFileShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNFSFileShare {
    _private: (),
}
impl UpdateNFSFileShare {
    /// Creates a new builder-style object to manufacture [`UpdateNfsFileShareInput`](crate::input::UpdateNfsFileShareInput)
    pub fn builder() -> crate::input::update_nfs_file_share_input::Builder {
        crate::input::update_nfs_file_share_input::Builder::default()
    }
    /// Creates a new `UpdateNFSFileShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNFSFileShare {
    type Output = std::result::Result<
        crate::output::UpdateNfsFileShareOutput,
        crate::error::UpdateNFSFileShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_nfs_file_share_error(response)
        } else {
            crate::operation_deser::parse_update_nfs_file_share_response(response)
        }
    }
}

/// Operation shape for `UpdateSMBFileShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_smb_file_share`](crate::client::Client::update_smb_file_share).
///
/// See [`crate::client::fluent_builders::UpdateSMBFileShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSMBFileShare {
    _private: (),
}
impl UpdateSMBFileShare {
    /// Creates a new builder-style object to manufacture [`UpdateSmbFileShareInput`](crate::input::UpdateSmbFileShareInput)
    pub fn builder() -> crate::input::update_smb_file_share_input::Builder {
        crate::input::update_smb_file_share_input::Builder::default()
    }
    /// Creates a new `UpdateSMBFileShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSMBFileShare {
    type Output = std::result::Result<
        crate::output::UpdateSmbFileShareOutput,
        crate::error::UpdateSMBFileShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_smb_file_share_error(response)
        } else {
            crate::operation_deser::parse_update_smb_file_share_response(response)
        }
    }
}

/// Operation shape for `UpdateSMBFileShareVisibility`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_smb_file_share_visibility`](crate::client::Client::update_smb_file_share_visibility).
///
/// See [`crate::client::fluent_builders::UpdateSMBFileShareVisibility`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSMBFileShareVisibility {
    _private: (),
}
impl UpdateSMBFileShareVisibility {
    /// Creates a new builder-style object to manufacture [`UpdateSmbFileShareVisibilityInput`](crate::input::UpdateSmbFileShareVisibilityInput)
    pub fn builder() -> crate::input::update_smb_file_share_visibility_input::Builder {
        crate::input::update_smb_file_share_visibility_input::Builder::default()
    }
    /// Creates a new `UpdateSMBFileShareVisibility` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSMBFileShareVisibility {
    type Output = std::result::Result<
        crate::output::UpdateSmbFileShareVisibilityOutput,
        crate::error::UpdateSMBFileShareVisibilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_smb_file_share_visibility_error(response)
        } else {
            crate::operation_deser::parse_update_smb_file_share_visibility_response(response)
        }
    }
}

/// Operation shape for `UpdateSMBLocalGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_smb_local_groups`](crate::client::Client::update_smb_local_groups).
///
/// See [`crate::client::fluent_builders::UpdateSMBLocalGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSMBLocalGroups {
    _private: (),
}
impl UpdateSMBLocalGroups {
    /// Creates a new builder-style object to manufacture [`UpdateSmbLocalGroupsInput`](crate::input::UpdateSmbLocalGroupsInput)
    pub fn builder() -> crate::input::update_smb_local_groups_input::Builder {
        crate::input::update_smb_local_groups_input::Builder::default()
    }
    /// Creates a new `UpdateSMBLocalGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSMBLocalGroups {
    type Output = std::result::Result<
        crate::output::UpdateSmbLocalGroupsOutput,
        crate::error::UpdateSMBLocalGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_smb_local_groups_error(response)
        } else {
            crate::operation_deser::parse_update_smb_local_groups_response(response)
        }
    }
}

/// Operation shape for `UpdateSMBSecurityStrategy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_smb_security_strategy`](crate::client::Client::update_smb_security_strategy).
///
/// See [`crate::client::fluent_builders::UpdateSMBSecurityStrategy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSMBSecurityStrategy {
    _private: (),
}
impl UpdateSMBSecurityStrategy {
    /// Creates a new builder-style object to manufacture [`UpdateSmbSecurityStrategyInput`](crate::input::UpdateSmbSecurityStrategyInput)
    pub fn builder() -> crate::input::update_smb_security_strategy_input::Builder {
        crate::input::update_smb_security_strategy_input::Builder::default()
    }
    /// Creates a new `UpdateSMBSecurityStrategy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSMBSecurityStrategy {
    type Output = std::result::Result<
        crate::output::UpdateSmbSecurityStrategyOutput,
        crate::error::UpdateSMBSecurityStrategyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_smb_security_strategy_error(response)
        } else {
            crate::operation_deser::parse_update_smb_security_strategy_response(response)
        }
    }
}

/// Operation shape for `UpdateSnapshotSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_snapshot_schedule`](crate::client::Client::update_snapshot_schedule).
///
/// See [`crate::client::fluent_builders::UpdateSnapshotSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSnapshotSchedule {
    _private: (),
}
impl UpdateSnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`UpdateSnapshotScheduleInput`](crate::input::UpdateSnapshotScheduleInput)
    pub fn builder() -> crate::input::update_snapshot_schedule_input::Builder {
        crate::input::update_snapshot_schedule_input::Builder::default()
    }
    /// Creates a new `UpdateSnapshotSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSnapshotSchedule {
    type Output = std::result::Result<
        crate::output::UpdateSnapshotScheduleOutput,
        crate::error::UpdateSnapshotScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_snapshot_schedule_error(response)
        } else {
            crate::operation_deser::parse_update_snapshot_schedule_response(response)
        }
    }
}

/// Operation shape for `UpdateVTLDeviceType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_vtl_device_type`](crate::client::Client::update_vtl_device_type).
///
/// See [`crate::client::fluent_builders::UpdateVTLDeviceType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVTLDeviceType {
    _private: (),
}
impl UpdateVTLDeviceType {
    /// Creates a new builder-style object to manufacture [`UpdateVtlDeviceTypeInput`](crate::input::UpdateVtlDeviceTypeInput)
    pub fn builder() -> crate::input::update_vtl_device_type_input::Builder {
        crate::input::update_vtl_device_type_input::Builder::default()
    }
    /// Creates a new `UpdateVTLDeviceType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVTLDeviceType {
    type Output = std::result::Result<
        crate::output::UpdateVtlDeviceTypeOutput,
        crate::error::UpdateVTLDeviceTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_vtl_device_type_error(response)
        } else {
            crate::operation_deser::parse_update_vtl_device_type_response(response)
        }
    }
}
