// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>UpdateVTLDeviceTypeOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVtlDeviceTypeOutput {
    /// <p>The Amazon Resource Name (ARN) of the medium changer you have selected.</p>
    pub vtl_device_arn: std::option::Option<std::string::String>,
}
impl UpdateVtlDeviceTypeOutput {
    /// <p>The Amazon Resource Name (ARN) of the medium changer you have selected.</p>
    pub fn vtl_device_arn(&self) -> std::option::Option<&str> {
        self.vtl_device_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateVtlDeviceTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVtlDeviceTypeOutput");
        formatter.field("vtl_device_arn", &self.vtl_device_arn);
        formatter.finish()
    }
}
/// See [`UpdateVtlDeviceTypeOutput`](crate::output::UpdateVtlDeviceTypeOutput)
pub mod update_vtl_device_type_output {
    /// A builder for [`UpdateVtlDeviceTypeOutput`](crate::output::UpdateVtlDeviceTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vtl_device_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the medium changer you have selected.</p>
        pub fn vtl_device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vtl_device_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the medium changer you have selected.</p>
        pub fn set_vtl_device_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vtl_device_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVtlDeviceTypeOutput`](crate::output::UpdateVtlDeviceTypeOutput)
        pub fn build(self) -> crate::output::UpdateVtlDeviceTypeOutput {
            crate::output::UpdateVtlDeviceTypeOutput {
                vtl_device_arn: self.vtl_device_arn,
            }
        }
    }
}
impl UpdateVtlDeviceTypeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVtlDeviceTypeOutput`](crate::output::UpdateVtlDeviceTypeOutput)
    pub fn builder() -> crate::output::update_vtl_device_type_output::Builder {
        crate::output::update_vtl_device_type_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the updated storage volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSnapshotScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl UpdateSnapshotScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateSnapshotScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSnapshotScheduleOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}
/// See [`UpdateSnapshotScheduleOutput`](crate::output::UpdateSnapshotScheduleOutput)
pub mod update_snapshot_schedule_output {
    /// A builder for [`UpdateSnapshotScheduleOutput`](crate::output::UpdateSnapshotScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSnapshotScheduleOutput`](crate::output::UpdateSnapshotScheduleOutput)
        pub fn build(self) -> crate::output::UpdateSnapshotScheduleOutput {
            crate::output::UpdateSnapshotScheduleOutput {
                volume_arn: self.volume_arn,
            }
        }
    }
}
impl UpdateSnapshotScheduleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSnapshotScheduleOutput`](crate::output::UpdateSnapshotScheduleOutput)
    pub fn builder() -> crate::output::update_snapshot_schedule_output::Builder {
        crate::output::update_snapshot_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbSecurityStrategyOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateSmbSecurityStrategyOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateSmbSecurityStrategyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbSecurityStrategyOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateSmbSecurityStrategyOutput`](crate::output::UpdateSmbSecurityStrategyOutput)
pub mod update_smb_security_strategy_output {
    /// A builder for [`UpdateSmbSecurityStrategyOutput`](crate::output::UpdateSmbSecurityStrategyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbSecurityStrategyOutput`](crate::output::UpdateSmbSecurityStrategyOutput)
        pub fn build(self) -> crate::output::UpdateSmbSecurityStrategyOutput {
            crate::output::UpdateSmbSecurityStrategyOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateSmbSecurityStrategyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSmbSecurityStrategyOutput`](crate::output::UpdateSmbSecurityStrategyOutput)
    pub fn builder() -> crate::output::update_smb_security_strategy_output::Builder {
        crate::output::update_smb_security_strategy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbLocalGroupsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateSmbLocalGroupsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateSmbLocalGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbLocalGroupsOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateSmbLocalGroupsOutput`](crate::output::UpdateSmbLocalGroupsOutput)
pub mod update_smb_local_groups_output {
    /// A builder for [`UpdateSmbLocalGroupsOutput`](crate::output::UpdateSmbLocalGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbLocalGroupsOutput`](crate::output::UpdateSmbLocalGroupsOutput)
        pub fn build(self) -> crate::output::UpdateSmbLocalGroupsOutput {
            crate::output::UpdateSmbLocalGroupsOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateSmbLocalGroupsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSmbLocalGroupsOutput`](crate::output::UpdateSmbLocalGroupsOutput)
    pub fn builder() -> crate::output::update_smb_local_groups_output::Builder {
        crate::output::update_smb_local_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbFileShareVisibilityOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateSmbFileShareVisibilityOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateSmbFileShareVisibilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbFileShareVisibilityOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateSmbFileShareVisibilityOutput`](crate::output::UpdateSmbFileShareVisibilityOutput)
pub mod update_smb_file_share_visibility_output {
    /// A builder for [`UpdateSmbFileShareVisibilityOutput`](crate::output::UpdateSmbFileShareVisibilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbFileShareVisibilityOutput`](crate::output::UpdateSmbFileShareVisibilityOutput)
        pub fn build(self) -> crate::output::UpdateSmbFileShareVisibilityOutput {
            crate::output::UpdateSmbFileShareVisibilityOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateSmbFileShareVisibilityOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSmbFileShareVisibilityOutput`](crate::output::UpdateSmbFileShareVisibilityOutput)
    pub fn builder() -> crate::output::update_smb_file_share_visibility_output::Builder {
        crate::output::update_smb_file_share_visibility_output::Builder::default()
    }
}

/// <p>UpdateSMBFileShareOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated SMB file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
}
impl UpdateSmbFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated SMB file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateSmbFileShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbFileShareOutput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.finish()
    }
}
/// See [`UpdateSmbFileShareOutput`](crate::output::UpdateSmbFileShareOutput)
pub mod update_smb_file_share_output {
    /// A builder for [`UpdateSmbFileShareOutput`](crate::output::UpdateSmbFileShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated SMB file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated SMB file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbFileShareOutput`](crate::output::UpdateSmbFileShareOutput)
        pub fn build(self) -> crate::output::UpdateSmbFileShareOutput {
            crate::output::UpdateSmbFileShareOutput {
                file_share_arn: self.file_share_arn,
            }
        }
    }
}
impl UpdateSmbFileShareOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSmbFileShareOutput`](crate::output::UpdateSmbFileShareOutput)
    pub fn builder() -> crate::output::update_smb_file_share_output::Builder {
        crate::output::update_smb_file_share_output::Builder::default()
    }
}

/// <p>UpdateNFSFileShareOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNfsFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
}
impl UpdateNfsFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateNfsFileShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNfsFileShareOutput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.finish()
    }
}
/// See [`UpdateNfsFileShareOutput`](crate::output::UpdateNfsFileShareOutput)
pub mod update_nfs_file_share_output {
    /// A builder for [`UpdateNfsFileShareOutput`](crate::output::UpdateNfsFileShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNfsFileShareOutput`](crate::output::UpdateNfsFileShareOutput)
        pub fn build(self) -> crate::output::UpdateNfsFileShareOutput {
            crate::output::UpdateNfsFileShareOutput {
                file_share_arn: self.file_share_arn,
            }
        }
    }
}
impl UpdateNfsFileShareOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNfsFileShareOutput`](crate::output::UpdateNfsFileShareOutput)
    pub fn builder() -> crate::output::update_nfs_file_share_output::Builder {
        crate::output::update_nfs_file_share_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway whose maintenance start time is updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMaintenanceStartTimeOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateMaintenanceStartTimeOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateMaintenanceStartTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMaintenanceStartTimeOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateMaintenanceStartTimeOutput`](crate::output::UpdateMaintenanceStartTimeOutput)
pub mod update_maintenance_start_time_output {
    /// A builder for [`UpdateMaintenanceStartTimeOutput`](crate::output::UpdateMaintenanceStartTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMaintenanceStartTimeOutput`](crate::output::UpdateMaintenanceStartTimeOutput)
        pub fn build(self) -> crate::output::UpdateMaintenanceStartTimeOutput {
            crate::output::UpdateMaintenanceStartTimeOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateMaintenanceStartTimeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceStartTimeOutput`](crate::output::UpdateMaintenanceStartTimeOutput)
    pub fn builder() -> crate::output::update_maintenance_start_time_output::Builder {
        crate::output::update_maintenance_start_time_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewaySoftwareNowOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateGatewaySoftwareNowOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateGatewaySoftwareNowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewaySoftwareNowOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateGatewaySoftwareNowOutput`](crate::output::UpdateGatewaySoftwareNowOutput)
pub mod update_gateway_software_now_output {
    /// A builder for [`UpdateGatewaySoftwareNowOutput`](crate::output::UpdateGatewaySoftwareNowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewaySoftwareNowOutput`](crate::output::UpdateGatewaySoftwareNowOutput)
        pub fn build(self) -> crate::output::UpdateGatewaySoftwareNowOutput {
            crate::output::UpdateGatewaySoftwareNowOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateGatewaySoftwareNowOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGatewaySoftwareNowOutput`](crate::output::UpdateGatewaySoftwareNowOutput)
    pub fn builder() -> crate::output::update_gateway_software_now_output::Builder {
        crate::output::update_gateway_software_now_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayInformationOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The name you configured for your gateway.</p>
    pub gateway_name: std::option::Option<std::string::String>,
}
impl UpdateGatewayInformationOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The name you configured for your gateway.</p>
    pub fn gateway_name(&self) -> std::option::Option<&str> {
        self.gateway_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateGatewayInformationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayInformationOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("gateway_name", &self.gateway_name);
        formatter.finish()
    }
}
/// See [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
pub mod update_gateway_information_output {
    /// A builder for [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
        pub fn build(self) -> crate::output::UpdateGatewayInformationOutput {
            crate::output::UpdateGatewayInformationOutput {
                gateway_arn: self.gateway_arn,
                gateway_name: self.gateway_name,
            }
        }
    }
}
impl UpdateGatewayInformationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
    pub fn builder() -> crate::output::update_gateway_information_output::Builder {
        crate::output::update_gateway_information_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemAssociationOutput {
    /// <p>The ARN of the updated file system association.</p>
    pub file_system_association_arn: std::option::Option<std::string::String>,
}
impl UpdateFileSystemAssociationOutput {
    /// <p>The ARN of the updated file system association.</p>
    pub fn file_system_association_arn(&self) -> std::option::Option<&str> {
        self.file_system_association_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateFileSystemAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemAssociationOutput");
        formatter.field(
            "file_system_association_arn",
            &self.file_system_association_arn,
        );
        formatter.finish()
    }
}
/// See [`UpdateFileSystemAssociationOutput`](crate::output::UpdateFileSystemAssociationOutput)
pub mod update_file_system_association_output {
    /// A builder for [`UpdateFileSystemAssociationOutput`](crate::output::UpdateFileSystemAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the updated file system association.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the updated file system association.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemAssociationOutput`](crate::output::UpdateFileSystemAssociationOutput)
        pub fn build(self) -> crate::output::UpdateFileSystemAssociationOutput {
            crate::output::UpdateFileSystemAssociationOutput {
                file_system_association_arn: self.file_system_association_arn,
            }
        }
    }
}
impl UpdateFileSystemAssociationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemAssociationOutput`](crate::output::UpdateFileSystemAssociationOutput)
    pub fn builder() -> crate::output::update_file_system_association_output::Builder {
        crate::output::update_file_system_association_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChapCredentialsOutput {
    /// <p>The Amazon Resource Name (ARN) of the target. This is the same target specified in the request.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The iSCSI initiator that connects to the target. This is the same initiator name specified in the request.</p>
    pub initiator_name: std::option::Option<std::string::String>,
}
impl UpdateChapCredentialsOutput {
    /// <p>The Amazon Resource Name (ARN) of the target. This is the same target specified in the request.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The iSCSI initiator that connects to the target. This is the same initiator name specified in the request.</p>
    pub fn initiator_name(&self) -> std::option::Option<&str> {
        self.initiator_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateChapCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChapCredentialsOutput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("initiator_name", &self.initiator_name);
        formatter.finish()
    }
}
/// See [`UpdateChapCredentialsOutput`](crate::output::UpdateChapCredentialsOutput)
pub mod update_chap_credentials_output {
    /// A builder for [`UpdateChapCredentialsOutput`](crate::output::UpdateChapCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) initiator_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target. This is the same target specified in the request.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target. This is the same target specified in the request.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The iSCSI initiator that connects to the target. This is the same initiator name specified in the request.</p>
        pub fn initiator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.initiator_name = Some(input.into());
            self
        }
        /// <p>The iSCSI initiator that connects to the target. This is the same initiator name specified in the request.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initiator_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChapCredentialsOutput`](crate::output::UpdateChapCredentialsOutput)
        pub fn build(self) -> crate::output::UpdateChapCredentialsOutput {
            crate::output::UpdateChapCredentialsOutput {
                target_arn: self.target_arn,
                initiator_name: self.initiator_name,
            }
        }
    }
}
impl UpdateChapCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChapCredentialsOutput`](crate::output::UpdateChapCredentialsOutput)
    pub fn builder() -> crate::output::update_chap_credentials_output::Builder {
        crate::output::update_chap_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBandwidthRateLimitScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateBandwidthRateLimitScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateBandwidthRateLimitScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBandwidthRateLimitScheduleOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateBandwidthRateLimitScheduleOutput`](crate::output::UpdateBandwidthRateLimitScheduleOutput)
pub mod update_bandwidth_rate_limit_schedule_output {
    /// A builder for [`UpdateBandwidthRateLimitScheduleOutput`](crate::output::UpdateBandwidthRateLimitScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBandwidthRateLimitScheduleOutput`](crate::output::UpdateBandwidthRateLimitScheduleOutput)
        pub fn build(self) -> crate::output::UpdateBandwidthRateLimitScheduleOutput {
            crate::output::UpdateBandwidthRateLimitScheduleOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateBandwidthRateLimitScheduleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBandwidthRateLimitScheduleOutput`](crate::output::UpdateBandwidthRateLimitScheduleOutput)
    pub fn builder() -> crate::output::update_bandwidth_rate_limit_schedule_output::Builder {
        crate::output::update_bandwidth_rate_limit_schedule_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway whose throttle information was updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBandwidthRateLimitOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateBandwidthRateLimitOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateBandwidthRateLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBandwidthRateLimitOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateBandwidthRateLimitOutput`](crate::output::UpdateBandwidthRateLimitOutput)
pub mod update_bandwidth_rate_limit_output {
    /// A builder for [`UpdateBandwidthRateLimitOutput`](crate::output::UpdateBandwidthRateLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBandwidthRateLimitOutput`](crate::output::UpdateBandwidthRateLimitOutput)
        pub fn build(self) -> crate::output::UpdateBandwidthRateLimitOutput {
            crate::output::UpdateBandwidthRateLimitOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateBandwidthRateLimitOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBandwidthRateLimitOutput`](crate::output::UpdateBandwidthRateLimitOutput)
    pub fn builder() -> crate::output::update_bandwidth_rate_limit_output::Builder {
        crate::output::update_bandwidth_rate_limit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAutomaticTapeCreationPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateAutomaticTapeCreationPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAutomaticTapeCreationPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAutomaticTapeCreationPolicyOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateAutomaticTapeCreationPolicyOutput`](crate::output::UpdateAutomaticTapeCreationPolicyOutput)
pub mod update_automatic_tape_creation_policy_output {
    /// A builder for [`UpdateAutomaticTapeCreationPolicyOutput`](crate::output::UpdateAutomaticTapeCreationPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAutomaticTapeCreationPolicyOutput`](crate::output::UpdateAutomaticTapeCreationPolicyOutput)
        pub fn build(self) -> crate::output::UpdateAutomaticTapeCreationPolicyOutput {
            crate::output::UpdateAutomaticTapeCreationPolicyOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateAutomaticTapeCreationPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAutomaticTapeCreationPolicyOutput`](crate::output::UpdateAutomaticTapeCreationPolicyOutput)
    pub fn builder() -> crate::output::update_automatic_tape_creation_policy_output::Builder {
        crate::output::update_automatic_tape_creation_policy_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was restarted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl StartGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for StartGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartGatewayOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`StartGatewayOutput`](crate::output::StartGatewayOutput)
pub mod start_gateway_output {
    /// A builder for [`StartGatewayOutput`](crate::output::StartGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartGatewayOutput`](crate::output::StartGatewayOutput)
        pub fn build(self) -> crate::output::StartGatewayOutput {
            crate::output::StartGatewayOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl StartGatewayOutput {
    /// Creates a new builder-style object to manufacture [`StartGatewayOutput`](crate::output::StartGatewayOutput)
    pub fn builder() -> crate::output::start_gateway_output::Builder {
        crate::output::start_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAvailabilityMonitorTestOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl StartAvailabilityMonitorTestOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for StartAvailabilityMonitorTestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAvailabilityMonitorTestOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`StartAvailabilityMonitorTestOutput`](crate::output::StartAvailabilityMonitorTestOutput)
pub mod start_availability_monitor_test_output {
    /// A builder for [`StartAvailabilityMonitorTestOutput`](crate::output::StartAvailabilityMonitorTestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAvailabilityMonitorTestOutput`](crate::output::StartAvailabilityMonitorTestOutput)
        pub fn build(self) -> crate::output::StartAvailabilityMonitorTestOutput {
            crate::output::StartAvailabilityMonitorTestOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl StartAvailabilityMonitorTestOutput {
    /// Creates a new builder-style object to manufacture [`StartAvailabilityMonitorTestOutput`](crate::output::StartAvailabilityMonitorTestOutput)
    pub fn builder() -> crate::output::start_availability_monitor_test_output::Builder {
        crate::output::start_availability_monitor_test_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was shut down.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShutdownGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ShutdownGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ShutdownGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShutdownGatewayOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`ShutdownGatewayOutput`](crate::output::ShutdownGatewayOutput)
pub mod shutdown_gateway_output {
    /// A builder for [`ShutdownGatewayOutput`](crate::output::ShutdownGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ShutdownGatewayOutput`](crate::output::ShutdownGatewayOutput)
        pub fn build(self) -> crate::output::ShutdownGatewayOutput {
            crate::output::ShutdownGatewayOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl ShutdownGatewayOutput {
    /// Creates a new builder-style object to manufacture [`ShutdownGatewayOutput`](crate::output::ShutdownGatewayOutput)
    pub fn builder() -> crate::output::shutdown_gateway_output::Builder {
        crate::output::shutdown_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSmbGuestPasswordOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl SetSmbGuestPasswordOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for SetSmbGuestPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSmbGuestPasswordOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`SetSmbGuestPasswordOutput`](crate::output::SetSmbGuestPasswordOutput)
pub mod set_smb_guest_password_output {
    /// A builder for [`SetSmbGuestPasswordOutput`](crate::output::SetSmbGuestPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSmbGuestPasswordOutput`](crate::output::SetSmbGuestPasswordOutput)
        pub fn build(self) -> crate::output::SetSmbGuestPasswordOutput {
            crate::output::SetSmbGuestPasswordOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl SetSmbGuestPasswordOutput {
    /// Creates a new builder-style object to manufacture [`SetSmbGuestPasswordOutput`](crate::output::SetSmbGuestPasswordOutput)
    pub fn builder() -> crate::output::set_smb_guest_password_output::Builder {
        crate::output::set_smb_guest_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetLocalConsolePasswordOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl SetLocalConsolePasswordOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for SetLocalConsolePasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetLocalConsolePasswordOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`SetLocalConsolePasswordOutput`](crate::output::SetLocalConsolePasswordOutput)
pub mod set_local_console_password_output {
    /// A builder for [`SetLocalConsolePasswordOutput`](crate::output::SetLocalConsolePasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SetLocalConsolePasswordOutput`](crate::output::SetLocalConsolePasswordOutput)
        pub fn build(self) -> crate::output::SetLocalConsolePasswordOutput {
            crate::output::SetLocalConsolePasswordOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl SetLocalConsolePasswordOutput {
    /// Creates a new builder-style object to manufacture [`SetLocalConsolePasswordOutput`](crate::output::SetLocalConsolePasswordOutput)
    pub fn builder() -> crate::output::set_local_console_password_output::Builder {
        crate::output::set_local_console_password_output::Builder::default()
    }
}

/// <p>RetrieveTapeRecoveryPointOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveTapeRecoveryPointOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which the recovery point was retrieved.</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl RetrieveTapeRecoveryPointOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which the recovery point was retrieved.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for RetrieveTapeRecoveryPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveTapeRecoveryPointOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`RetrieveTapeRecoveryPointOutput`](crate::output::RetrieveTapeRecoveryPointOutput)
pub mod retrieve_tape_recovery_point_output {
    /// A builder for [`RetrieveTapeRecoveryPointOutput`](crate::output::RetrieveTapeRecoveryPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which the recovery point was retrieved.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which the recovery point was retrieved.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveTapeRecoveryPointOutput`](crate::output::RetrieveTapeRecoveryPointOutput)
        pub fn build(self) -> crate::output::RetrieveTapeRecoveryPointOutput {
            crate::output::RetrieveTapeRecoveryPointOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl RetrieveTapeRecoveryPointOutput {
    /// Creates a new builder-style object to manufacture [`RetrieveTapeRecoveryPointOutput`](crate::output::RetrieveTapeRecoveryPointOutput)
    pub fn builder() -> crate::output::retrieve_tape_recovery_point_output::Builder {
        crate::output::retrieve_tape_recovery_point_output::Builder::default()
    }
}

/// <p>RetrieveTapeArchiveOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveTapeArchiveOutput {
    /// <p>The Amazon Resource Name (ARN) of the retrieved virtual tape.</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl RetrieveTapeArchiveOutput {
    /// <p>The Amazon Resource Name (ARN) of the retrieved virtual tape.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for RetrieveTapeArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveTapeArchiveOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`RetrieveTapeArchiveOutput`](crate::output::RetrieveTapeArchiveOutput)
pub mod retrieve_tape_archive_output {
    /// A builder for [`RetrieveTapeArchiveOutput`](crate::output::RetrieveTapeArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the retrieved virtual tape.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the retrieved virtual tape.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveTapeArchiveOutput`](crate::output::RetrieveTapeArchiveOutput)
        pub fn build(self) -> crate::output::RetrieveTapeArchiveOutput {
            crate::output::RetrieveTapeArchiveOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl RetrieveTapeArchiveOutput {
    /// Creates a new builder-style object to manufacture [`RetrieveTapeArchiveOutput`](crate::output::RetrieveTapeArchiveOutput)
    pub fn builder() -> crate::output::retrieve_tape_archive_output::Builder {
        crate::output::retrieve_tape_archive_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ResetCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ResetCacheOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetCacheOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`ResetCacheOutput`](crate::output::ResetCacheOutput)
pub mod reset_cache_output {
    /// A builder for [`ResetCacheOutput`](crate::output::ResetCacheOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetCacheOutput`](crate::output::ResetCacheOutput)
        pub fn build(self) -> crate::output::ResetCacheOutput {
            crate::output::ResetCacheOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl ResetCacheOutput {
    /// Creates a new builder-style object to manufacture [`ResetCacheOutput`](crate::output::ResetCacheOutput)
    pub fn builder() -> crate::output::reset_cache_output::Builder {
        crate::output::reset_cache_output::Builder::default()
    }
}

/// <p>RemoveTagsFromResourceOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource that the tags were removed from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl RemoveTagsFromResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource that the tags were removed from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
pub mod remove_tags_from_resource_output {
    /// A builder for [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that the tags were removed from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the tags were removed from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromResourceOutput {
            crate::output::RemoveTagsFromResourceOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl RemoveTagsFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    pub fn builder() -> crate::output::remove_tags_from_resource_output::Builder {
        crate::output::remove_tags_from_resource_output::Builder::default()
    }
}

/// <p>RefreshCacheOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
    pub notification_id: std::option::Option<std::string::String>,
}
impl RefreshCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
    /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
    pub fn notification_id(&self) -> std::option::Option<&str> {
        self.notification_id.as_deref()
    }
}
impl std::fmt::Debug for RefreshCacheOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshCacheOutput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("notification_id", &self.notification_id);
        formatter.finish()
    }
}
/// See [`RefreshCacheOutput`](crate::output::RefreshCacheOutput)
pub mod refresh_cache_output {
    /// A builder for [`RefreshCacheOutput`](crate::output::RefreshCacheOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) notification_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
        pub fn notification_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_id = Some(input.into());
            self
        }
        /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
        pub fn set_notification_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshCacheOutput`](crate::output::RefreshCacheOutput)
        pub fn build(self) -> crate::output::RefreshCacheOutput {
            crate::output::RefreshCacheOutput {
                file_share_arn: self.file_share_arn,
                notification_id: self.notification_id,
            }
        }
    }
}
impl RefreshCacheOutput {
    /// Creates a new builder-style object to manufacture [`RefreshCacheOutput`](crate::output::RefreshCacheOutput)
    pub fn builder() -> crate::output::refresh_cache_output::Builder {
        crate::output::refresh_cache_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyWhenUploadedOutput {
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
    pub notification_id: std::option::Option<std::string::String>,
}
impl NotifyWhenUploadedOutput {
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
    /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
    pub fn notification_id(&self) -> std::option::Option<&str> {
        self.notification_id.as_deref()
    }
}
impl std::fmt::Debug for NotifyWhenUploadedOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyWhenUploadedOutput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("notification_id", &self.notification_id);
        formatter.finish()
    }
}
/// See [`NotifyWhenUploadedOutput`](crate::output::NotifyWhenUploadedOutput)
pub mod notify_when_uploaded_output {
    /// A builder for [`NotifyWhenUploadedOutput`](crate::output::NotifyWhenUploadedOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) notification_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
        pub fn notification_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_id = Some(input.into());
            self
        }
        /// <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
        pub fn set_notification_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyWhenUploadedOutput`](crate::output::NotifyWhenUploadedOutput)
        pub fn build(self) -> crate::output::NotifyWhenUploadedOutput {
            crate::output::NotifyWhenUploadedOutput {
                file_share_arn: self.file_share_arn,
                notification_id: self.notification_id,
            }
        }
    }
}
impl NotifyWhenUploadedOutput {
    /// Creates a new builder-style object to manufacture [`NotifyWhenUploadedOutput`](crate::output::NotifyWhenUploadedOutput)
    pub fn builder() -> crate::output::notify_when_uploaded_output::Builder {
        crate::output::notify_when_uploaded_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
/// <ul>
/// <li> <p> <code>ListVolumesOutput$Marker</code> </p> </li>
/// <li> <p> <code>ListVolumesOutput$VolumeInfos</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVolumesOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to list, this field does not appear in the response body.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>VolumeInfo</code> objects, where each object describes an iSCSI volume. If no volumes are defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".</p>
    pub volume_infos: std::option::Option<std::vec::Vec<crate::model::VolumeInfo>>,
}
impl ListVolumesOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to list, this field does not appear in the response body.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An array of <code>VolumeInfo</code> objects, where each object describes an iSCSI volume. If no volumes are defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".</p>
    pub fn volume_infos(&self) -> std::option::Option<&[crate::model::VolumeInfo]> {
        self.volume_infos.as_deref()
    }
}
impl std::fmt::Debug for ListVolumesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVolumesOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("marker", &self.marker);
        formatter.field("volume_infos", &self.volume_infos);
        formatter.finish()
    }
}
/// See [`ListVolumesOutput`](crate::output::ListVolumesOutput)
pub mod list_volumes_output {
    /// A builder for [`ListVolumesOutput`](crate::output::ListVolumesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) volume_infos: std::option::Option<std::vec::Vec<crate::model::VolumeInfo>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to list, this field does not appear in the response body.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to list, this field does not appear in the response body.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `volume_infos`.
        ///
        /// To override the contents of this collection use [`set_volume_infos`](Self::set_volume_infos).
        ///
        /// <p>An array of <code>VolumeInfo</code> objects, where each object describes an iSCSI volume. If no volumes are defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".</p>
        pub fn volume_infos(mut self, input: crate::model::VolumeInfo) -> Self {
            let mut v = self.volume_infos.unwrap_or_default();
            v.push(input);
            self.volume_infos = Some(v);
            self
        }
        /// <p>An array of <code>VolumeInfo</code> objects, where each object describes an iSCSI volume. If no volumes are defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".</p>
        pub fn set_volume_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeInfo>>,
        ) -> Self {
            self.volume_infos = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVolumesOutput`](crate::output::ListVolumesOutput)
        pub fn build(self) -> crate::output::ListVolumesOutput {
            crate::output::ListVolumesOutput {
                gateway_arn: self.gateway_arn,
                marker: self.marker,
                volume_infos: self.volume_infos,
            }
        }
    }
}
impl ListVolumesOutput {
    /// Creates a new builder-style object to manufacture [`ListVolumesOutput`](crate::output::ListVolumesOutput)
    pub fn builder() -> crate::output::list_volumes_output::Builder {
        crate::output::list_volumes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVolumeRecoveryPointsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An array of <code>VolumeRecoveryPointInfo</code> objects.</p>
    pub volume_recovery_point_infos:
        std::option::Option<std::vec::Vec<crate::model::VolumeRecoveryPointInfo>>,
}
impl ListVolumeRecoveryPointsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An array of <code>VolumeRecoveryPointInfo</code> objects.</p>
    pub fn volume_recovery_point_infos(
        &self,
    ) -> std::option::Option<&[crate::model::VolumeRecoveryPointInfo]> {
        self.volume_recovery_point_infos.as_deref()
    }
}
impl std::fmt::Debug for ListVolumeRecoveryPointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVolumeRecoveryPointsOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field(
            "volume_recovery_point_infos",
            &self.volume_recovery_point_infos,
        );
        formatter.finish()
    }
}
/// See [`ListVolumeRecoveryPointsOutput`](crate::output::ListVolumeRecoveryPointsOutput)
pub mod list_volume_recovery_points_output {
    /// A builder for [`ListVolumeRecoveryPointsOutput`](crate::output::ListVolumeRecoveryPointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) volume_recovery_point_infos:
            std::option::Option<std::vec::Vec<crate::model::VolumeRecoveryPointInfo>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `volume_recovery_point_infos`.
        ///
        /// To override the contents of this collection use [`set_volume_recovery_point_infos`](Self::set_volume_recovery_point_infos).
        ///
        /// <p>An array of <code>VolumeRecoveryPointInfo</code> objects.</p>
        pub fn volume_recovery_point_infos(
            mut self,
            input: crate::model::VolumeRecoveryPointInfo,
        ) -> Self {
            let mut v = self.volume_recovery_point_infos.unwrap_or_default();
            v.push(input);
            self.volume_recovery_point_infos = Some(v);
            self
        }
        /// <p>An array of <code>VolumeRecoveryPointInfo</code> objects.</p>
        pub fn set_volume_recovery_point_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeRecoveryPointInfo>>,
        ) -> Self {
            self.volume_recovery_point_infos = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVolumeRecoveryPointsOutput`](crate::output::ListVolumeRecoveryPointsOutput)
        pub fn build(self) -> crate::output::ListVolumeRecoveryPointsOutput {
            crate::output::ListVolumeRecoveryPointsOutput {
                gateway_arn: self.gateway_arn,
                volume_recovery_point_infos: self.volume_recovery_point_infos,
            }
        }
    }
}
impl ListVolumeRecoveryPointsOutput {
    /// Creates a new builder-style object to manufacture [`ListVolumeRecoveryPointsOutput`](crate::output::ListVolumeRecoveryPointsOutput)
    pub fn builder() -> crate::output::list_volume_recovery_points_output::Builder {
        crate::output::list_volume_recovery_points_output::Builder::default()
    }
}

/// <p>ListVolumeInitiatorsOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVolumeInitiatorsOutput {
    /// <p>The host names and port numbers of all iSCSI initiators that are connected to the gateway.</p>
    pub initiators: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListVolumeInitiatorsOutput {
    /// <p>The host names and port numbers of all iSCSI initiators that are connected to the gateway.</p>
    pub fn initiators(&self) -> std::option::Option<&[std::string::String]> {
        self.initiators.as_deref()
    }
}
impl std::fmt::Debug for ListVolumeInitiatorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVolumeInitiatorsOutput");
        formatter.field("initiators", &self.initiators);
        formatter.finish()
    }
}
/// See [`ListVolumeInitiatorsOutput`](crate::output::ListVolumeInitiatorsOutput)
pub mod list_volume_initiators_output {
    /// A builder for [`ListVolumeInitiatorsOutput`](crate::output::ListVolumeInitiatorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initiators: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `initiators`.
        ///
        /// To override the contents of this collection use [`set_initiators`](Self::set_initiators).
        ///
        /// <p>The host names and port numbers of all iSCSI initiators that are connected to the gateway.</p>
        pub fn initiators(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.initiators.unwrap_or_default();
            v.push(input.into());
            self.initiators = Some(v);
            self
        }
        /// <p>The host names and port numbers of all iSCSI initiators that are connected to the gateway.</p>
        pub fn set_initiators(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.initiators = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVolumeInitiatorsOutput`](crate::output::ListVolumeInitiatorsOutput)
        pub fn build(self) -> crate::output::ListVolumeInitiatorsOutput {
            crate::output::ListVolumeInitiatorsOutput {
                initiators: self.initiators,
            }
        }
    }
}
impl ListVolumeInitiatorsOutput {
    /// Creates a new builder-style object to manufacture [`ListVolumeInitiatorsOutput`](crate::output::ListVolumeInitiatorsOutput)
    pub fn builder() -> crate::output::list_volume_initiators_output::Builder {
        crate::output::list_volume_initiators_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
/// <ul>
/// <li> <p> <code>ListTapesOutput$Marker</code> </p> </li>
/// <li> <p> <code>ListTapesOutput$VolumeInfos</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTapesOutput {
    /// <p>An array of <code>TapeInfo</code> objects, where each object describes a single tape. If there are no tapes in the tape library or VTS, then the <code>TapeInfos</code> is an empty array.</p>
    pub tape_infos: std::option::Option<std::vec::Vec<crate::model::TapeInfo>>,
    /// <p>A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in the response body.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListTapesOutput {
    /// <p>An array of <code>TapeInfo</code> objects, where each object describes a single tape. If there are no tapes in the tape library or VTS, then the <code>TapeInfos</code> is an empty array.</p>
    pub fn tape_infos(&self) -> std::option::Option<&[crate::model::TapeInfo]> {
        self.tape_infos.as_deref()
    }
    /// <p>A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in the response body.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListTapesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTapesOutput");
        formatter.field("tape_infos", &self.tape_infos);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListTapesOutput`](crate::output::ListTapesOutput)
pub mod list_tapes_output {
    /// A builder for [`ListTapesOutput`](crate::output::ListTapesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_infos: std::option::Option<std::vec::Vec<crate::model::TapeInfo>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tape_infos`.
        ///
        /// To override the contents of this collection use [`set_tape_infos`](Self::set_tape_infos).
        ///
        /// <p>An array of <code>TapeInfo</code> objects, where each object describes a single tape. If there are no tapes in the tape library or VTS, then the <code>TapeInfos</code> is an empty array.</p>
        pub fn tape_infos(mut self, input: crate::model::TapeInfo) -> Self {
            let mut v = self.tape_infos.unwrap_or_default();
            v.push(input);
            self.tape_infos = Some(v);
            self
        }
        /// <p>An array of <code>TapeInfo</code> objects, where each object describes a single tape. If there are no tapes in the tape library or VTS, then the <code>TapeInfos</code> is an empty array.</p>
        pub fn set_tape_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TapeInfo>>,
        ) -> Self {
            self.tape_infos = input;
            self
        }
        /// <p>A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in the response body.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in the response body.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTapesOutput`](crate::output::ListTapesOutput)
        pub fn build(self) -> crate::output::ListTapesOutput {
            crate::output::ListTapesOutput {
                tape_infos: self.tape_infos,
                marker: self.marker,
            }
        }
    }
}
impl ListTapesOutput {
    /// Creates a new builder-style object to manufacture [`ListTapesOutput`](crate::output::ListTapesOutput)
    pub fn builder() -> crate::output::list_tapes_output::Builder {
        crate::output::list_tapes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTapePoolsOutput {
    /// <p>An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no custom tape pools, the <code>PoolInfos</code> is an empty array. </p>
    pub pool_infos: std::option::Option<std::vec::Vec<crate::model::PoolInfo>>,
    /// <p>A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not appear in the response body. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListTapePoolsOutput {
    /// <p>An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no custom tape pools, the <code>PoolInfos</code> is an empty array. </p>
    pub fn pool_infos(&self) -> std::option::Option<&[crate::model::PoolInfo]> {
        self.pool_infos.as_deref()
    }
    /// <p>A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not appear in the response body. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListTapePoolsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTapePoolsOutput");
        formatter.field("pool_infos", &self.pool_infos);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListTapePoolsOutput`](crate::output::ListTapePoolsOutput)
pub mod list_tape_pools_output {
    /// A builder for [`ListTapePoolsOutput`](crate::output::ListTapePoolsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_infos: std::option::Option<std::vec::Vec<crate::model::PoolInfo>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pool_infos`.
        ///
        /// To override the contents of this collection use [`set_pool_infos`](Self::set_pool_infos).
        ///
        /// <p>An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no custom tape pools, the <code>PoolInfos</code> is an empty array. </p>
        pub fn pool_infos(mut self, input: crate::model::PoolInfo) -> Self {
            let mut v = self.pool_infos.unwrap_or_default();
            v.push(input);
            self.pool_infos = Some(v);
            self
        }
        /// <p>An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no custom tape pools, the <code>PoolInfos</code> is an empty array. </p>
        pub fn set_pool_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PoolInfo>>,
        ) -> Self {
            self.pool_infos = input;
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not appear in the response body. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not appear in the response body. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTapePoolsOutput`](crate::output::ListTapePoolsOutput)
        pub fn build(self) -> crate::output::ListTapePoolsOutput {
            crate::output::ListTapePoolsOutput {
                pool_infos: self.pool_infos,
                marker: self.marker,
            }
        }
    }
}
impl ListTapePoolsOutput {
    /// Creates a new builder-style object to manufacture [`ListTapePoolsOutput`](crate::output::ListTapePoolsOutput)
    pub fn builder() -> crate::output::list_tape_pools_output::Builder {
        crate::output::list_tape_pools_output::Builder::default()
    }
}

/// <p>ListTagsForResourceOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An opaque string that indicates the position at which to stop returning the list of tags.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An array that contains the tags for the specified resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to stop returning the list of tags.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An array that contains the tags for the specified resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("marker", &self.marker);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to stop returning the list of tags.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to stop returning the list of tags.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array that contains the tags for the specified resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array that contains the tags for the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                resource_arn: self.resource_arn,
                marker: self.marker,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLocalDisksOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>A JSON object containing the following fields:</p>
    /// <ul>
    /// <li> <p> <code>ListLocalDisksOutput$Disks</code> </p> </li>
    /// </ul>
    pub disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
}
impl ListLocalDisksOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>A JSON object containing the following fields:</p>
    /// <ul>
    /// <li> <p> <code>ListLocalDisksOutput$Disks</code> </p> </li>
    /// </ul>
    pub fn disks(&self) -> std::option::Option<&[crate::model::Disk]> {
        self.disks.as_deref()
    }
}
impl std::fmt::Debug for ListLocalDisksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLocalDisksOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("disks", &self.disks);
        formatter.finish()
    }
}
/// See [`ListLocalDisksOutput`](crate::output::ListLocalDisksOutput)
pub mod list_local_disks_output {
    /// A builder for [`ListLocalDisksOutput`](crate::output::ListLocalDisksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `disks`.
        ///
        /// To override the contents of this collection use [`set_disks`](Self::set_disks).
        ///
        /// <p>A JSON object containing the following fields:</p>
        /// <ul>
        /// <li> <p> <code>ListLocalDisksOutput$Disks</code> </p> </li>
        /// </ul>
        pub fn disks(mut self, input: crate::model::Disk) -> Self {
            let mut v = self.disks.unwrap_or_default();
            v.push(input);
            self.disks = Some(v);
            self
        }
        /// <p>A JSON object containing the following fields:</p>
        /// <ul>
        /// <li> <p> <code>ListLocalDisksOutput$Disks</code> </p> </li>
        /// </ul>
        pub fn set_disks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        ) -> Self {
            self.disks = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLocalDisksOutput`](crate::output::ListLocalDisksOutput)
        pub fn build(self) -> crate::output::ListLocalDisksOutput {
            crate::output::ListLocalDisksOutput {
                gateway_arn: self.gateway_arn,
                disks: self.disks,
            }
        }
    }
}
impl ListLocalDisksOutput {
    /// Creates a new builder-style object to manufacture [`ListLocalDisksOutput`](crate::output::ListLocalDisksOutput)
    pub fn builder() -> crate::output::list_local_disks_output::Builder {
        crate::output::list_local_disks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewaysOutput {
    /// <p>An array of <code>GatewayInfo</code> objects.</p>
    pub gateways: std::option::Option<std::vec::Vec<crate::model::GatewayInfo>>,
    /// <p>Use the marker in your next request to fetch the next set of gateways in the list. If there are no more gateways to list, this field does not appear in the response.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListGatewaysOutput {
    /// <p>An array of <code>GatewayInfo</code> objects.</p>
    pub fn gateways(&self) -> std::option::Option<&[crate::model::GatewayInfo]> {
        self.gateways.as_deref()
    }
    /// <p>Use the marker in your next request to fetch the next set of gateways in the list. If there are no more gateways to list, this field does not appear in the response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListGatewaysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewaysOutput");
        formatter.field("gateways", &self.gateways);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
pub mod list_gateways_output {
    /// A builder for [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateways: std::option::Option<std::vec::Vec<crate::model::GatewayInfo>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `gateways`.
        ///
        /// To override the contents of this collection use [`set_gateways`](Self::set_gateways).
        ///
        /// <p>An array of <code>GatewayInfo</code> objects.</p>
        pub fn gateways(mut self, input: crate::model::GatewayInfo) -> Self {
            let mut v = self.gateways.unwrap_or_default();
            v.push(input);
            self.gateways = Some(v);
            self
        }
        /// <p>An array of <code>GatewayInfo</code> objects.</p>
        pub fn set_gateways(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GatewayInfo>>,
        ) -> Self {
            self.gateways = input;
            self
        }
        /// <p>Use the marker in your next request to fetch the next set of gateways in the list. If there are no more gateways to list, this field does not appear in the response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use the marker in your next request to fetch the next set of gateways in the list. If there are no more gateways to list, this field does not appear in the response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
        pub fn build(self) -> crate::output::ListGatewaysOutput {
            crate::output::ListGatewaysOutput {
                gateways: self.gateways,
                marker: self.marker,
            }
        }
    }
}
impl ListGatewaysOutput {
    /// Creates a new builder-style object to manufacture [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
    pub fn builder() -> crate::output::list_gateways_output::Builder {
        crate::output::list_gateways_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFileSystemAssociationsOutput {
    /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>If a value is present, there are more file system associations to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system associations.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of information about the Amazon FSx gateway's file system associations.</p>
    pub file_system_association_summary_list:
        std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationSummary>>,
}
impl ListFileSystemAssociationsOutput {
    /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>If a value is present, there are more file system associations to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system associations.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of information about the Amazon FSx gateway's file system associations.</p>
    pub fn file_system_association_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::FileSystemAssociationSummary]> {
        self.file_system_association_summary_list.as_deref()
    }
}
impl std::fmt::Debug for ListFileSystemAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFileSystemAssociationsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("next_marker", &self.next_marker);
        formatter.field(
            "file_system_association_summary_list",
            &self.file_system_association_summary_list,
        );
        formatter.finish()
    }
}
/// See [`ListFileSystemAssociationsOutput`](crate::output::ListFileSystemAssociationsOutput)
pub mod list_file_system_associations_output {
    /// A builder for [`ListFileSystemAssociationsOutput`](crate::output::ListFileSystemAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) file_system_association_summary_list:
            std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationSummary>>,
    }
    impl Builder {
        /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>If a value is present, there are more file system associations to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system associations.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If a value is present, there are more file system associations to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system associations.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `file_system_association_summary_list`.
        ///
        /// To override the contents of this collection use [`set_file_system_association_summary_list`](Self::set_file_system_association_summary_list).
        ///
        /// <p>An array of information about the Amazon FSx gateway's file system associations.</p>
        pub fn file_system_association_summary_list(
            mut self,
            input: crate::model::FileSystemAssociationSummary,
        ) -> Self {
            let mut v = self
                .file_system_association_summary_list
                .unwrap_or_default();
            v.push(input);
            self.file_system_association_summary_list = Some(v);
            self
        }
        /// <p>An array of information about the Amazon FSx gateway's file system associations.</p>
        pub fn set_file_system_association_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationSummary>>,
        ) -> Self {
            self.file_system_association_summary_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFileSystemAssociationsOutput`](crate::output::ListFileSystemAssociationsOutput)
        pub fn build(self) -> crate::output::ListFileSystemAssociationsOutput {
            crate::output::ListFileSystemAssociationsOutput {
                marker: self.marker,
                next_marker: self.next_marker,
                file_system_association_summary_list: self.file_system_association_summary_list,
            }
        }
    }
}
impl ListFileSystemAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListFileSystemAssociationsOutput`](crate::output::ListFileSystemAssociationsOutput)
    pub fn builder() -> crate::output::list_file_system_associations_output::Builder {
        crate::output::list_file_system_associations_output::Builder::default()
    }
}

/// <p>ListFileShareOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFileSharesOutput {
    /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of information about the S3 File Gateway's file shares.</p>
    pub file_share_info_list: std::option::Option<std::vec::Vec<crate::model::FileShareInfo>>,
}
impl ListFileSharesOutput {
    /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of information about the S3 File Gateway's file shares.</p>
    pub fn file_share_info_list(&self) -> std::option::Option<&[crate::model::FileShareInfo]> {
        self.file_share_info_list.as_deref()
    }
}
impl std::fmt::Debug for ListFileSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFileSharesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("file_share_info_list", &self.file_share_info_list);
        formatter.finish()
    }
}
/// See [`ListFileSharesOutput`](crate::output::ListFileSharesOutput)
pub mod list_file_shares_output {
    /// A builder for [`ListFileSharesOutput`](crate::output::ListFileSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) file_share_info_list:
            std::option::Option<std::vec::Vec<crate::model::FileShareInfo>>,
    }
    impl Builder {
        /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `file_share_info_list`.
        ///
        /// To override the contents of this collection use [`set_file_share_info_list`](Self::set_file_share_info_list).
        ///
        /// <p>An array of information about the S3 File Gateway's file shares.</p>
        pub fn file_share_info_list(mut self, input: crate::model::FileShareInfo) -> Self {
            let mut v = self.file_share_info_list.unwrap_or_default();
            v.push(input);
            self.file_share_info_list = Some(v);
            self
        }
        /// <p>An array of information about the S3 File Gateway's file shares.</p>
        pub fn set_file_share_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileShareInfo>>,
        ) -> Self {
            self.file_share_info_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFileSharesOutput`](crate::output::ListFileSharesOutput)
        pub fn build(self) -> crate::output::ListFileSharesOutput {
            crate::output::ListFileSharesOutput {
                marker: self.marker,
                next_marker: self.next_marker,
                file_share_info_list: self.file_share_info_list,
            }
        }
    }
}
impl ListFileSharesOutput {
    /// Creates a new builder-style object to manufacture [`ListFileSharesOutput`](crate::output::ListFileSharesOutput)
    pub fn builder() -> crate::output::list_file_shares_output::Builder {
        crate::output::list_file_shares_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAutomaticTapeCreationPoliciesOutput {
    /// <p>Gets a listing of information about the gateway's automatic tape creation policies, including the automatic tape creation rules and the gateway that is using the policies.</p>
    pub automatic_tape_creation_policy_infos:
        std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationPolicyInfo>>,
}
impl ListAutomaticTapeCreationPoliciesOutput {
    /// <p>Gets a listing of information about the gateway's automatic tape creation policies, including the automatic tape creation rules and the gateway that is using the policies.</p>
    pub fn automatic_tape_creation_policy_infos(
        &self,
    ) -> std::option::Option<&[crate::model::AutomaticTapeCreationPolicyInfo]> {
        self.automatic_tape_creation_policy_infos.as_deref()
    }
}
impl std::fmt::Debug for ListAutomaticTapeCreationPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAutomaticTapeCreationPoliciesOutput");
        formatter.field(
            "automatic_tape_creation_policy_infos",
            &self.automatic_tape_creation_policy_infos,
        );
        formatter.finish()
    }
}
/// See [`ListAutomaticTapeCreationPoliciesOutput`](crate::output::ListAutomaticTapeCreationPoliciesOutput)
pub mod list_automatic_tape_creation_policies_output {
    /// A builder for [`ListAutomaticTapeCreationPoliciesOutput`](crate::output::ListAutomaticTapeCreationPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatic_tape_creation_policy_infos:
            std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationPolicyInfo>>,
    }
    impl Builder {
        /// Appends an item to `automatic_tape_creation_policy_infos`.
        ///
        /// To override the contents of this collection use [`set_automatic_tape_creation_policy_infos`](Self::set_automatic_tape_creation_policy_infos).
        ///
        /// <p>Gets a listing of information about the gateway's automatic tape creation policies, including the automatic tape creation rules and the gateway that is using the policies.</p>
        pub fn automatic_tape_creation_policy_infos(
            mut self,
            input: crate::model::AutomaticTapeCreationPolicyInfo,
        ) -> Self {
            let mut v = self
                .automatic_tape_creation_policy_infos
                .unwrap_or_default();
            v.push(input);
            self.automatic_tape_creation_policy_infos = Some(v);
            self
        }
        /// <p>Gets a listing of information about the gateway's automatic tape creation policies, including the automatic tape creation rules and the gateway that is using the policies.</p>
        pub fn set_automatic_tape_creation_policy_infos(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AutomaticTapeCreationPolicyInfo>,
            >,
        ) -> Self {
            self.automatic_tape_creation_policy_infos = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAutomaticTapeCreationPoliciesOutput`](crate::output::ListAutomaticTapeCreationPoliciesOutput)
        pub fn build(self) -> crate::output::ListAutomaticTapeCreationPoliciesOutput {
            crate::output::ListAutomaticTapeCreationPoliciesOutput {
                automatic_tape_creation_policy_infos: self.automatic_tape_creation_policy_infos,
            }
        }
    }
}
impl ListAutomaticTapeCreationPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListAutomaticTapeCreationPoliciesOutput`](crate::output::ListAutomaticTapeCreationPoliciesOutput)
    pub fn builder() -> crate::output::list_automatic_tape_creation_policies_output::Builder {
        crate::output::list_automatic_tape_creation_policies_output::Builder::default()
    }
}

/// <p>JoinDomainOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JoinDomainOutput {
    /// <p>The unique Amazon Resource Name (ARN) of the gateway that joined the domain.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>Indicates the status of the gateway as a member of the Active Directory domain.</p>
    /// <ul>
    /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
    /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
    /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
    /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
    /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
    /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
    /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
    /// </ul>
    pub active_directory_status: std::option::Option<crate::model::ActiveDirectoryStatus>,
}
impl JoinDomainOutput {
    /// <p>The unique Amazon Resource Name (ARN) of the gateway that joined the domain.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>Indicates the status of the gateway as a member of the Active Directory domain.</p>
    /// <ul>
    /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
    /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
    /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
    /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
    /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
    /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
    /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
    /// </ul>
    pub fn active_directory_status(
        &self,
    ) -> std::option::Option<&crate::model::ActiveDirectoryStatus> {
        self.active_directory_status.as_ref()
    }
}
impl std::fmt::Debug for JoinDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JoinDomainOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("active_directory_status", &self.active_directory_status);
        formatter.finish()
    }
}
/// See [`JoinDomainOutput`](crate::output::JoinDomainOutput)
pub mod join_domain_output {
    /// A builder for [`JoinDomainOutput`](crate::output::JoinDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) active_directory_status:
            std::option::Option<crate::model::ActiveDirectoryStatus>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that joined the domain.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that joined the domain.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>Indicates the status of the gateway as a member of the Active Directory domain.</p>
        /// <ul>
        /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
        /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
        /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
        /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
        /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
        /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
        /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
        /// </ul>
        pub fn active_directory_status(
            mut self,
            input: crate::model::ActiveDirectoryStatus,
        ) -> Self {
            self.active_directory_status = Some(input);
            self
        }
        /// <p>Indicates the status of the gateway as a member of the Active Directory domain.</p>
        /// <ul>
        /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
        /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
        /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
        /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
        /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
        /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
        /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
        /// </ul>
        pub fn set_active_directory_status(
            mut self,
            input: std::option::Option<crate::model::ActiveDirectoryStatus>,
        ) -> Self {
            self.active_directory_status = input;
            self
        }
        /// Consumes the builder and constructs a [`JoinDomainOutput`](crate::output::JoinDomainOutput)
        pub fn build(self) -> crate::output::JoinDomainOutput {
            crate::output::JoinDomainOutput {
                gateway_arn: self.gateway_arn,
                active_directory_status: self.active_directory_status,
            }
        }
    }
}
impl JoinDomainOutput {
    /// Creates a new builder-style object to manufacture [`JoinDomainOutput`](crate::output::JoinDomainOutput)
    pub fn builder() -> crate::output::join_domain_output::Builder {
        crate::output::join_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFileSystemOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted file system association.</p>
    pub file_system_association_arn: std::option::Option<std::string::String>,
}
impl DisassociateFileSystemOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted file system association.</p>
    pub fn file_system_association_arn(&self) -> std::option::Option<&str> {
        self.file_system_association_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFileSystemOutput");
        formatter.field(
            "file_system_association_arn",
            &self.file_system_association_arn,
        );
        formatter.finish()
    }
}
/// See [`DisassociateFileSystemOutput`](crate::output::DisassociateFileSystemOutput)
pub mod disassociate_file_system_output {
    /// A builder for [`DisassociateFileSystemOutput`](crate::output::DisassociateFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deleted file system association.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted file system association.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFileSystemOutput`](crate::output::DisassociateFileSystemOutput)
        pub fn build(self) -> crate::output::DisassociateFileSystemOutput {
            crate::output::DisassociateFileSystemOutput {
                file_system_association_arn: self.file_system_association_arn,
            }
        }
    }
}
impl DisassociateFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateFileSystemOutput`](crate::output::DisassociateFileSystemOutput)
    pub fn builder() -> crate::output::disassociate_file_system_output::Builder {
        crate::output::disassociate_file_system_output::Builder::default()
    }
}

/// <p>DisableGatewayOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableGatewayOutput {
    /// <p>The unique Amazon Resource Name (ARN) of the disabled gateway.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DisableGatewayOutput {
    /// <p>The unique Amazon Resource Name (ARN) of the disabled gateway.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DisableGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableGatewayOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`DisableGatewayOutput`](crate::output::DisableGatewayOutput)
pub mod disable_gateway_output {
    /// A builder for [`DisableGatewayOutput`](crate::output::DisableGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) of the disabled gateway.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the disabled gateway.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableGatewayOutput`](crate::output::DisableGatewayOutput)
        pub fn build(self) -> crate::output::DisableGatewayOutput {
            crate::output::DisableGatewayOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl DisableGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DisableGatewayOutput`](crate::output::DisableGatewayOutput)
    pub fn builder() -> crate::output::disable_gateway_output::Builder {
        crate::output::disable_gateway_output::Builder::default()
    }
}

/// <p>AttachVolumeOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume that was detached.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl DetachVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume that was detached.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for DetachVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachVolumeOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}
/// See [`DetachVolumeOutput`](crate::output::DetachVolumeOutput)
pub mod detach_volume_output {
    /// A builder for [`DetachVolumeOutput`](crate::output::DetachVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume that was detached.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume that was detached.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachVolumeOutput`](crate::output::DetachVolumeOutput)
        pub fn build(self) -> crate::output::DetachVolumeOutput {
            crate::output::DetachVolumeOutput {
                volume_arn: self.volume_arn,
            }
        }
    }
}
impl DetachVolumeOutput {
    /// Creates a new builder-style object to manufacture [`DetachVolumeOutput`](crate::output::DetachVolumeOutput)
    pub fn builder() -> crate::output::detach_volume_output::Builder {
        crate::output::detach_volume_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkingStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
    pub disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
    pub working_storage_used_in_bytes: i64,
    /// <p>The total working storage in bytes allocated for the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
    pub working_storage_allocated_in_bytes: i64,
}
impl DescribeWorkingStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
    pub fn disk_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.disk_ids.as_deref()
    }
    /// <p>The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
    pub fn working_storage_used_in_bytes(&self) -> i64 {
        self.working_storage_used_in_bytes
    }
    /// <p>The total working storage in bytes allocated for the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
    pub fn working_storage_allocated_in_bytes(&self) -> i64 {
        self.working_storage_allocated_in_bytes
    }
}
impl std::fmt::Debug for DescribeWorkingStorageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkingStorageOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("disk_ids", &self.disk_ids);
        formatter.field(
            "working_storage_used_in_bytes",
            &self.working_storage_used_in_bytes,
        );
        formatter.field(
            "working_storage_allocated_in_bytes",
            &self.working_storage_allocated_in_bytes,
        );
        formatter.finish()
    }
}
/// See [`DescribeWorkingStorageOutput`](crate::output::DescribeWorkingStorageOutput)
pub mod describe_working_storage_output {
    /// A builder for [`DescribeWorkingStorageOutput`](crate::output::DescribeWorkingStorageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) working_storage_used_in_bytes: std::option::Option<i64>,
        pub(crate) working_storage_allocated_in_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `disk_ids`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disk_ids.unwrap_or_default();
            v.push(input.into());
            self.disk_ids = Some(v);
            self
        }
        /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disk_ids = input;
            self
        }
        /// <p>The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
        pub fn working_storage_used_in_bytes(mut self, input: i64) -> Self {
            self.working_storage_used_in_bytes = Some(input);
            self
        }
        /// <p>The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
        pub fn set_working_storage_used_in_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.working_storage_used_in_bytes = input;
            self
        }
        /// <p>The total working storage in bytes allocated for the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
        pub fn working_storage_allocated_in_bytes(mut self, input: i64) -> Self {
            self.working_storage_allocated_in_bytes = Some(input);
            self
        }
        /// <p>The total working storage in bytes allocated for the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
        pub fn set_working_storage_allocated_in_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.working_storage_allocated_in_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkingStorageOutput`](crate::output::DescribeWorkingStorageOutput)
        pub fn build(self) -> crate::output::DescribeWorkingStorageOutput {
            crate::output::DescribeWorkingStorageOutput {
                gateway_arn: self.gateway_arn,
                disk_ids: self.disk_ids,
                working_storage_used_in_bytes: self
                    .working_storage_used_in_bytes
                    .unwrap_or_default(),
                working_storage_allocated_in_bytes: self
                    .working_storage_allocated_in_bytes
                    .unwrap_or_default(),
            }
        }
    }
}
impl DescribeWorkingStorageOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkingStorageOutput`](crate::output::DescribeWorkingStorageOutput)
    pub fn builder() -> crate::output::describe_working_storage_output::Builder {
        crate::output::describe_working_storage_output::Builder::default()
    }
}

/// <p>DescribeVTLDevicesOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVtlDevicesOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.</p>
    pub vtl_devices: std::option::Option<std::vec::Vec<crate::model::VtlDevice>>,
    /// <p>An opaque string that indicates the position at which the VTL devices that were fetched for description ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL devices to describe, this field does not appear in the response.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeVtlDevicesOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.</p>
    pub fn vtl_devices(&self) -> std::option::Option<&[crate::model::VtlDevice]> {
        self.vtl_devices.as_deref()
    }
    /// <p>An opaque string that indicates the position at which the VTL devices that were fetched for description ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL devices to describe, this field does not appear in the response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeVtlDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVtlDevicesOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("vtl_devices", &self.vtl_devices);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeVtlDevicesOutput`](crate::output::DescribeVtlDevicesOutput)
pub mod describe_vtl_devices_output {
    /// A builder for [`DescribeVtlDevicesOutput`](crate::output::DescribeVtlDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) vtl_devices: std::option::Option<std::vec::Vec<crate::model::VtlDevice>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `vtl_devices`.
        ///
        /// To override the contents of this collection use [`set_vtl_devices`](Self::set_vtl_devices).
        ///
        /// <p>An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.</p>
        pub fn vtl_devices(mut self, input: crate::model::VtlDevice) -> Self {
            let mut v = self.vtl_devices.unwrap_or_default();
            v.push(input);
            self.vtl_devices = Some(v);
            self
        }
        /// <p>An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.</p>
        pub fn set_vtl_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VtlDevice>>,
        ) -> Self {
            self.vtl_devices = input;
            self
        }
        /// <p>An opaque string that indicates the position at which the VTL devices that were fetched for description ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL devices to describe, this field does not appear in the response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which the VTL devices that were fetched for description ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL devices to describe, this field does not appear in the response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVtlDevicesOutput`](crate::output::DescribeVtlDevicesOutput)
        pub fn build(self) -> crate::output::DescribeVtlDevicesOutput {
            crate::output::DescribeVtlDevicesOutput {
                gateway_arn: self.gateway_arn,
                vtl_devices: self.vtl_devices,
                marker: self.marker,
            }
        }
    }
}
impl DescribeVtlDevicesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVtlDevicesOutput`](crate::output::DescribeVtlDevicesOutput)
    pub fn builder() -> crate::output::describe_vtl_devices_output::Builder {
        crate::output::describe_vtl_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUploadBufferOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
    pub disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The total number of bytes being used in the gateway's upload buffer.</p>
    pub upload_buffer_used_in_bytes: i64,
    /// <p>The total number of bytes allocated in the gateway's as upload buffer.</p>
    pub upload_buffer_allocated_in_bytes: i64,
}
impl DescribeUploadBufferOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
    pub fn disk_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.disk_ids.as_deref()
    }
    /// <p>The total number of bytes being used in the gateway's upload buffer.</p>
    pub fn upload_buffer_used_in_bytes(&self) -> i64 {
        self.upload_buffer_used_in_bytes
    }
    /// <p>The total number of bytes allocated in the gateway's as upload buffer.</p>
    pub fn upload_buffer_allocated_in_bytes(&self) -> i64 {
        self.upload_buffer_allocated_in_bytes
    }
}
impl std::fmt::Debug for DescribeUploadBufferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUploadBufferOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("disk_ids", &self.disk_ids);
        formatter.field(
            "upload_buffer_used_in_bytes",
            &self.upload_buffer_used_in_bytes,
        );
        formatter.field(
            "upload_buffer_allocated_in_bytes",
            &self.upload_buffer_allocated_in_bytes,
        );
        formatter.finish()
    }
}
/// See [`DescribeUploadBufferOutput`](crate::output::DescribeUploadBufferOutput)
pub mod describe_upload_buffer_output {
    /// A builder for [`DescribeUploadBufferOutput`](crate::output::DescribeUploadBufferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) upload_buffer_used_in_bytes: std::option::Option<i64>,
        pub(crate) upload_buffer_allocated_in_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `disk_ids`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disk_ids.unwrap_or_default();
            v.push(input.into());
            self.disk_ids = Some(v);
            self
        }
        /// <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disk_ids = input;
            self
        }
        /// <p>The total number of bytes being used in the gateway's upload buffer.</p>
        pub fn upload_buffer_used_in_bytes(mut self, input: i64) -> Self {
            self.upload_buffer_used_in_bytes = Some(input);
            self
        }
        /// <p>The total number of bytes being used in the gateway's upload buffer.</p>
        pub fn set_upload_buffer_used_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.upload_buffer_used_in_bytes = input;
            self
        }
        /// <p>The total number of bytes allocated in the gateway's as upload buffer.</p>
        pub fn upload_buffer_allocated_in_bytes(mut self, input: i64) -> Self {
            self.upload_buffer_allocated_in_bytes = Some(input);
            self
        }
        /// <p>The total number of bytes allocated in the gateway's as upload buffer.</p>
        pub fn set_upload_buffer_allocated_in_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.upload_buffer_allocated_in_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUploadBufferOutput`](crate::output::DescribeUploadBufferOutput)
        pub fn build(self) -> crate::output::DescribeUploadBufferOutput {
            crate::output::DescribeUploadBufferOutput {
                gateway_arn: self.gateway_arn,
                disk_ids: self.disk_ids,
                upload_buffer_used_in_bytes: self.upload_buffer_used_in_bytes.unwrap_or_default(),
                upload_buffer_allocated_in_bytes: self
                    .upload_buffer_allocated_in_bytes
                    .unwrap_or_default(),
            }
        }
    }
}
impl DescribeUploadBufferOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUploadBufferOutput`](crate::output::DescribeUploadBufferOutput)
    pub fn builder() -> crate::output::describe_upload_buffer_output::Builder {
        crate::output::describe_upload_buffer_output::Builder::default()
    }
}

/// <p>DescribeTapesOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTapesOutput {
    /// <p>An array of virtual tape descriptions.</p>
    pub tapes: std::option::Option<std::vec::Vec<crate::model::Tape>>,
    /// <p>An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the next page of results.</p>
    /// <p>If a response does not contain a marker, then there are no more results to be retrieved.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeTapesOutput {
    /// <p>An array of virtual tape descriptions.</p>
    pub fn tapes(&self) -> std::option::Option<&[crate::model::Tape]> {
        self.tapes.as_deref()
    }
    /// <p>An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the next page of results.</p>
    /// <p>If a response does not contain a marker, then there are no more results to be retrieved.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeTapesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTapesOutput");
        formatter.field("tapes", &self.tapes);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeTapesOutput`](crate::output::DescribeTapesOutput)
pub mod describe_tapes_output {
    /// A builder for [`DescribeTapesOutput`](crate::output::DescribeTapesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tapes: std::option::Option<std::vec::Vec<crate::model::Tape>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tapes`.
        ///
        /// To override the contents of this collection use [`set_tapes`](Self::set_tapes).
        ///
        /// <p>An array of virtual tape descriptions.</p>
        pub fn tapes(mut self, input: crate::model::Tape) -> Self {
            let mut v = self.tapes.unwrap_or_default();
            v.push(input);
            self.tapes = Some(v);
            self
        }
        /// <p>An array of virtual tape descriptions.</p>
        pub fn set_tapes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tape>>,
        ) -> Self {
            self.tapes = input;
            self
        }
        /// <p>An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the next page of results.</p>
        /// <p>If a response does not contain a marker, then there are no more results to be retrieved.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the next page of results.</p>
        /// <p>If a response does not contain a marker, then there are no more results to be retrieved.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTapesOutput`](crate::output::DescribeTapesOutput)
        pub fn build(self) -> crate::output::DescribeTapesOutput {
            crate::output::DescribeTapesOutput {
                tapes: self.tapes,
                marker: self.marker,
            }
        }
    }
}
impl DescribeTapesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTapesOutput`](crate::output::DescribeTapesOutput)
    pub fn builder() -> crate::output::describe_tapes_output::Builder {
        crate::output::describe_tapes_output::Builder::default()
    }
}

/// <p>DescribeTapeRecoveryPointsOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTapeRecoveryPointsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An array of TapeRecoveryPointInfos that are available for the specified gateway.</p>
    pub tape_recovery_point_infos:
        std::option::Option<std::vec::Vec<crate::model::TapeRecoveryPointInfo>>,
    /// <p>An opaque string that indicates the position at which the virtual tape recovery points that were listed for description ended.</p>
    /// <p>Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there are no more recovery points to describe, this field does not appear in the response.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeTapeRecoveryPointsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An array of TapeRecoveryPointInfos that are available for the specified gateway.</p>
    pub fn tape_recovery_point_infos(
        &self,
    ) -> std::option::Option<&[crate::model::TapeRecoveryPointInfo]> {
        self.tape_recovery_point_infos.as_deref()
    }
    /// <p>An opaque string that indicates the position at which the virtual tape recovery points that were listed for description ended.</p>
    /// <p>Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there are no more recovery points to describe, this field does not appear in the response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeTapeRecoveryPointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTapeRecoveryPointsOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("tape_recovery_point_infos", &self.tape_recovery_point_infos);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeTapeRecoveryPointsOutput`](crate::output::DescribeTapeRecoveryPointsOutput)
pub mod describe_tape_recovery_points_output {
    /// A builder for [`DescribeTapeRecoveryPointsOutput`](crate::output::DescribeTapeRecoveryPointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tape_recovery_point_infos:
            std::option::Option<std::vec::Vec<crate::model::TapeRecoveryPointInfo>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `tape_recovery_point_infos`.
        ///
        /// To override the contents of this collection use [`set_tape_recovery_point_infos`](Self::set_tape_recovery_point_infos).
        ///
        /// <p>An array of TapeRecoveryPointInfos that are available for the specified gateway.</p>
        pub fn tape_recovery_point_infos(
            mut self,
            input: crate::model::TapeRecoveryPointInfo,
        ) -> Self {
            let mut v = self.tape_recovery_point_infos.unwrap_or_default();
            v.push(input);
            self.tape_recovery_point_infos = Some(v);
            self
        }
        /// <p>An array of TapeRecoveryPointInfos that are available for the specified gateway.</p>
        pub fn set_tape_recovery_point_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TapeRecoveryPointInfo>>,
        ) -> Self {
            self.tape_recovery_point_infos = input;
            self
        }
        /// <p>An opaque string that indicates the position at which the virtual tape recovery points that were listed for description ended.</p>
        /// <p>Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there are no more recovery points to describe, this field does not appear in the response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which the virtual tape recovery points that were listed for description ended.</p>
        /// <p>Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there are no more recovery points to describe, this field does not appear in the response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTapeRecoveryPointsOutput`](crate::output::DescribeTapeRecoveryPointsOutput)
        pub fn build(self) -> crate::output::DescribeTapeRecoveryPointsOutput {
            crate::output::DescribeTapeRecoveryPointsOutput {
                gateway_arn: self.gateway_arn,
                tape_recovery_point_infos: self.tape_recovery_point_infos,
                marker: self.marker,
            }
        }
    }
}
impl DescribeTapeRecoveryPointsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTapeRecoveryPointsOutput`](crate::output::DescribeTapeRecoveryPointsOutput)
    pub fn builder() -> crate::output::describe_tape_recovery_points_output::Builder {
        crate::output::describe_tape_recovery_points_output::Builder::default()
    }
}

/// <p>DescribeTapeArchivesOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTapeArchivesOutput {
    /// <p>An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.</p>
    pub tape_archives: std::option::Option<std::vec::Vec<crate::model::TapeArchive>>,
    /// <p>An opaque string that indicates the position at which the virtual tapes that were fetched for description ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeTapeArchivesOutput {
    /// <p>An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.</p>
    pub fn tape_archives(&self) -> std::option::Option<&[crate::model::TapeArchive]> {
        self.tape_archives.as_deref()
    }
    /// <p>An opaque string that indicates the position at which the virtual tapes that were fetched for description ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeTapeArchivesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTapeArchivesOutput");
        formatter.field("tape_archives", &self.tape_archives);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeTapeArchivesOutput`](crate::output::DescribeTapeArchivesOutput)
pub mod describe_tape_archives_output {
    /// A builder for [`DescribeTapeArchivesOutput`](crate::output::DescribeTapeArchivesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_archives: std::option::Option<std::vec::Vec<crate::model::TapeArchive>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tape_archives`.
        ///
        /// To override the contents of this collection use [`set_tape_archives`](Self::set_tape_archives).
        ///
        /// <p>An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.</p>
        pub fn tape_archives(mut self, input: crate::model::TapeArchive) -> Self {
            let mut v = self.tape_archives.unwrap_or_default();
            v.push(input);
            self.tape_archives = Some(v);
            self
        }
        /// <p>An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.</p>
        pub fn set_tape_archives(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TapeArchive>>,
        ) -> Self {
            self.tape_archives = input;
            self
        }
        /// <p>An opaque string that indicates the position at which the virtual tapes that were fetched for description ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which the virtual tapes that were fetched for description ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTapeArchivesOutput`](crate::output::DescribeTapeArchivesOutput)
        pub fn build(self) -> crate::output::DescribeTapeArchivesOutput {
            crate::output::DescribeTapeArchivesOutput {
                tape_archives: self.tape_archives,
                marker: self.marker,
            }
        }
    }
}
impl DescribeTapeArchivesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTapeArchivesOutput`](crate::output::DescribeTapeArchivesOutput)
    pub fn builder() -> crate::output::describe_tape_archives_output::Builder {
        crate::output::describe_tape_archives_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStorediScsiVolumesOutput {
    /// <p>Describes a single unit of output from <code>DescribeStorediSCSIVolumes</code>. The following fields are returned:</p>
    /// <ul>
    /// <li> <p> <code>ChapEnabled</code>: Indicates whether mutual CHAP is enabled for the iSCSI target.</p> </li>
    /// <li> <p> <code>LunNumber</code>: The logical disk number.</p> </li>
    /// <li> <p> <code>NetworkInterfaceId</code>: The network interface ID of the stored volume that initiator use to map the stored volume as an iSCSI target.</p> </li>
    /// <li> <p> <code>NetworkInterfacePort</code>: The port used to communicate with iSCSI targets.</p> </li>
    /// <li> <p> <code>PreservedExistingData</code>: Indicates when the stored volume was created, existing data on the underlying local disk was preserved.</p> </li>
    /// <li> <p> <code>SourceSnapshotId</code>: If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. <code>snap-1122aabb</code>. Otherwise, this field is not included.</p> </li>
    /// <li> <p> <code>StorediSCSIVolumes</code>: An array of StorediSCSIVolume objects where each object contains metadata about one stored volume.</p> </li>
    /// <li> <p> <code>TargetARN</code>: The Amazon Resource Name (ARN) of the volume target.</p> </li>
    /// <li> <p> <code>VolumeARN</code>: The Amazon Resource Name (ARN) of the stored volume.</p> </li>
    /// <li> <p> <code>VolumeDiskId</code>: The disk ID of the local disk that was specified in the <code>CreateStorediSCSIVolume</code> operation.</p> </li>
    /// <li> <p> <code>VolumeId</code>: The unique identifier of the storage volume, e.g. <code>vol-1122AABB</code>.</p> </li>
    /// <li> <p> <code>VolumeiSCSIAttributes</code>: An <code>VolumeiSCSIAttributes</code> object that represents a collection of iSCSI attributes for one stored volume.</p> </li>
    /// <li> <p> <code>VolumeProgress</code>: Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p> </li>
    /// <li> <p> <code>VolumeSizeInBytes</code>: The size of the volume in bytes.</p> </li>
    /// <li> <p> <code>VolumeStatus</code>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.</p> </li>
    /// <li> <p> <code>VolumeType</code>: One of the enumeration values describing the type of the volume. Currently, only <code>STORED</code> volumes are supported.</p> </li>
    /// </ul>
    pub storedi_scsi_volumes: std::option::Option<std::vec::Vec<crate::model::StorediScsiVolume>>,
}
impl DescribeStorediScsiVolumesOutput {
    /// <p>Describes a single unit of output from <code>DescribeStorediSCSIVolumes</code>. The following fields are returned:</p>
    /// <ul>
    /// <li> <p> <code>ChapEnabled</code>: Indicates whether mutual CHAP is enabled for the iSCSI target.</p> </li>
    /// <li> <p> <code>LunNumber</code>: The logical disk number.</p> </li>
    /// <li> <p> <code>NetworkInterfaceId</code>: The network interface ID of the stored volume that initiator use to map the stored volume as an iSCSI target.</p> </li>
    /// <li> <p> <code>NetworkInterfacePort</code>: The port used to communicate with iSCSI targets.</p> </li>
    /// <li> <p> <code>PreservedExistingData</code>: Indicates when the stored volume was created, existing data on the underlying local disk was preserved.</p> </li>
    /// <li> <p> <code>SourceSnapshotId</code>: If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. <code>snap-1122aabb</code>. Otherwise, this field is not included.</p> </li>
    /// <li> <p> <code>StorediSCSIVolumes</code>: An array of StorediSCSIVolume objects where each object contains metadata about one stored volume.</p> </li>
    /// <li> <p> <code>TargetARN</code>: The Amazon Resource Name (ARN) of the volume target.</p> </li>
    /// <li> <p> <code>VolumeARN</code>: The Amazon Resource Name (ARN) of the stored volume.</p> </li>
    /// <li> <p> <code>VolumeDiskId</code>: The disk ID of the local disk that was specified in the <code>CreateStorediSCSIVolume</code> operation.</p> </li>
    /// <li> <p> <code>VolumeId</code>: The unique identifier of the storage volume, e.g. <code>vol-1122AABB</code>.</p> </li>
    /// <li> <p> <code>VolumeiSCSIAttributes</code>: An <code>VolumeiSCSIAttributes</code> object that represents a collection of iSCSI attributes for one stored volume.</p> </li>
    /// <li> <p> <code>VolumeProgress</code>: Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p> </li>
    /// <li> <p> <code>VolumeSizeInBytes</code>: The size of the volume in bytes.</p> </li>
    /// <li> <p> <code>VolumeStatus</code>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.</p> </li>
    /// <li> <p> <code>VolumeType</code>: One of the enumeration values describing the type of the volume. Currently, only <code>STORED</code> volumes are supported.</p> </li>
    /// </ul>
    pub fn storedi_scsi_volumes(&self) -> std::option::Option<&[crate::model::StorediScsiVolume]> {
        self.storedi_scsi_volumes.as_deref()
    }
}
impl std::fmt::Debug for DescribeStorediScsiVolumesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStorediScsiVolumesOutput");
        formatter.field("storedi_scsi_volumes", &self.storedi_scsi_volumes);
        formatter.finish()
    }
}
/// See [`DescribeStorediScsiVolumesOutput`](crate::output::DescribeStorediScsiVolumesOutput)
pub mod describe_storedi_scsi_volumes_output {
    /// A builder for [`DescribeStorediScsiVolumesOutput`](crate::output::DescribeStorediScsiVolumesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storedi_scsi_volumes:
            std::option::Option<std::vec::Vec<crate::model::StorediScsiVolume>>,
    }
    impl Builder {
        /// Appends an item to `storedi_scsi_volumes`.
        ///
        /// To override the contents of this collection use [`set_storedi_scsi_volumes`](Self::set_storedi_scsi_volumes).
        ///
        /// <p>Describes a single unit of output from <code>DescribeStorediSCSIVolumes</code>. The following fields are returned:</p>
        /// <ul>
        /// <li> <p> <code>ChapEnabled</code>: Indicates whether mutual CHAP is enabled for the iSCSI target.</p> </li>
        /// <li> <p> <code>LunNumber</code>: The logical disk number.</p> </li>
        /// <li> <p> <code>NetworkInterfaceId</code>: The network interface ID of the stored volume that initiator use to map the stored volume as an iSCSI target.</p> </li>
        /// <li> <p> <code>NetworkInterfacePort</code>: The port used to communicate with iSCSI targets.</p> </li>
        /// <li> <p> <code>PreservedExistingData</code>: Indicates when the stored volume was created, existing data on the underlying local disk was preserved.</p> </li>
        /// <li> <p> <code>SourceSnapshotId</code>: If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. <code>snap-1122aabb</code>. Otherwise, this field is not included.</p> </li>
        /// <li> <p> <code>StorediSCSIVolumes</code>: An array of StorediSCSIVolume objects where each object contains metadata about one stored volume.</p> </li>
        /// <li> <p> <code>TargetARN</code>: The Amazon Resource Name (ARN) of the volume target.</p> </li>
        /// <li> <p> <code>VolumeARN</code>: The Amazon Resource Name (ARN) of the stored volume.</p> </li>
        /// <li> <p> <code>VolumeDiskId</code>: The disk ID of the local disk that was specified in the <code>CreateStorediSCSIVolume</code> operation.</p> </li>
        /// <li> <p> <code>VolumeId</code>: The unique identifier of the storage volume, e.g. <code>vol-1122AABB</code>.</p> </li>
        /// <li> <p> <code>VolumeiSCSIAttributes</code>: An <code>VolumeiSCSIAttributes</code> object that represents a collection of iSCSI attributes for one stored volume.</p> </li>
        /// <li> <p> <code>VolumeProgress</code>: Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p> </li>
        /// <li> <p> <code>VolumeSizeInBytes</code>: The size of the volume in bytes.</p> </li>
        /// <li> <p> <code>VolumeStatus</code>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.</p> </li>
        /// <li> <p> <code>VolumeType</code>: One of the enumeration values describing the type of the volume. Currently, only <code>STORED</code> volumes are supported.</p> </li>
        /// </ul>
        pub fn storedi_scsi_volumes(mut self, input: crate::model::StorediScsiVolume) -> Self {
            let mut v = self.storedi_scsi_volumes.unwrap_or_default();
            v.push(input);
            self.storedi_scsi_volumes = Some(v);
            self
        }
        /// <p>Describes a single unit of output from <code>DescribeStorediSCSIVolumes</code>. The following fields are returned:</p>
        /// <ul>
        /// <li> <p> <code>ChapEnabled</code>: Indicates whether mutual CHAP is enabled for the iSCSI target.</p> </li>
        /// <li> <p> <code>LunNumber</code>: The logical disk number.</p> </li>
        /// <li> <p> <code>NetworkInterfaceId</code>: The network interface ID of the stored volume that initiator use to map the stored volume as an iSCSI target.</p> </li>
        /// <li> <p> <code>NetworkInterfacePort</code>: The port used to communicate with iSCSI targets.</p> </li>
        /// <li> <p> <code>PreservedExistingData</code>: Indicates when the stored volume was created, existing data on the underlying local disk was preserved.</p> </li>
        /// <li> <p> <code>SourceSnapshotId</code>: If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. <code>snap-1122aabb</code>. Otherwise, this field is not included.</p> </li>
        /// <li> <p> <code>StorediSCSIVolumes</code>: An array of StorediSCSIVolume objects where each object contains metadata about one stored volume.</p> </li>
        /// <li> <p> <code>TargetARN</code>: The Amazon Resource Name (ARN) of the volume target.</p> </li>
        /// <li> <p> <code>VolumeARN</code>: The Amazon Resource Name (ARN) of the stored volume.</p> </li>
        /// <li> <p> <code>VolumeDiskId</code>: The disk ID of the local disk that was specified in the <code>CreateStorediSCSIVolume</code> operation.</p> </li>
        /// <li> <p> <code>VolumeId</code>: The unique identifier of the storage volume, e.g. <code>vol-1122AABB</code>.</p> </li>
        /// <li> <p> <code>VolumeiSCSIAttributes</code>: An <code>VolumeiSCSIAttributes</code> object that represents a collection of iSCSI attributes for one stored volume.</p> </li>
        /// <li> <p> <code>VolumeProgress</code>: Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p> </li>
        /// <li> <p> <code>VolumeSizeInBytes</code>: The size of the volume in bytes.</p> </li>
        /// <li> <p> <code>VolumeStatus</code>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.</p> </li>
        /// <li> <p> <code>VolumeType</code>: One of the enumeration values describing the type of the volume. Currently, only <code>STORED</code> volumes are supported.</p> </li>
        /// </ul>
        pub fn set_storedi_scsi_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorediScsiVolume>>,
        ) -> Self {
            self.storedi_scsi_volumes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStorediScsiVolumesOutput`](crate::output::DescribeStorediScsiVolumesOutput)
        pub fn build(self) -> crate::output::DescribeStorediScsiVolumesOutput {
            crate::output::DescribeStorediScsiVolumesOutput {
                storedi_scsi_volumes: self.storedi_scsi_volumes,
            }
        }
    }
}
impl DescribeStorediScsiVolumesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStorediScsiVolumesOutput`](crate::output::DescribeStorediScsiVolumesOutput)
    pub fn builder() -> crate::output::describe_storedi_scsi_volumes_output::Builder {
        crate::output::describe_storedi_scsi_volumes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume that was specified in the request.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
    pub start_at: std::option::Option<i32>,
    /// <p>The number of hours between snapshots.</p>
    pub recurrence_in_hours: std::option::Option<i32>,
    /// <p>The snapshot description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A value that indicates the time zone of the gateway.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DescribeSnapshotScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume that was specified in the request.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
    pub fn start_at(&self) -> std::option::Option<i32> {
        self.start_at
    }
    /// <p>The number of hours between snapshots.</p>
    pub fn recurrence_in_hours(&self) -> std::option::Option<i32> {
        self.recurrence_in_hours
    }
    /// <p>The snapshot description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A value that indicates the time zone of the gateway.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for DescribeSnapshotScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotScheduleOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("start_at", &self.start_at);
        formatter.field("recurrence_in_hours", &self.recurrence_in_hours);
        formatter.field("description", &self.description);
        formatter.field("timezone", &self.timezone);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeSnapshotScheduleOutput`](crate::output::DescribeSnapshotScheduleOutput)
pub mod describe_snapshot_schedule_output {
    /// A builder for [`DescribeSnapshotScheduleOutput`](crate::output::DescribeSnapshotScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) start_at: std::option::Option<i32>,
        pub(crate) recurrence_in_hours: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume that was specified in the request.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume that was specified in the request.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn start_at(mut self, input: i32) -> Self {
            self.start_at = Some(input);
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn set_start_at(mut self, input: std::option::Option<i32>) -> Self {
            self.start_at = input;
            self
        }
        /// <p>The number of hours between snapshots.</p>
        pub fn recurrence_in_hours(mut self, input: i32) -> Self {
            self.recurrence_in_hours = Some(input);
            self
        }
        /// <p>The number of hours between snapshots.</p>
        pub fn set_recurrence_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.recurrence_in_hours = input;
            self
        }
        /// <p>The snapshot description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The snapshot description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotScheduleOutput`](crate::output::DescribeSnapshotScheduleOutput)
        pub fn build(self) -> crate::output::DescribeSnapshotScheduleOutput {
            crate::output::DescribeSnapshotScheduleOutput {
                volume_arn: self.volume_arn,
                start_at: self.start_at,
                recurrence_in_hours: self.recurrence_in_hours,
                description: self.description,
                timezone: self.timezone,
                tags: self.tags,
            }
        }
    }
}
impl DescribeSnapshotScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotScheduleOutput`](crate::output::DescribeSnapshotScheduleOutput)
    pub fn builder() -> crate::output::describe_snapshot_schedule_output::Builder {
        crate::output::describe_snapshot_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSmbSettingsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The name of the domain that the gateway is joined to.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Indicates the status of a gateway that is a member of the Active Directory domain.</p>
    /// <ul>
    /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
    /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
    /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
    /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
    /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
    /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
    /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
    /// </ul>
    pub active_directory_status: std::option::Option<crate::model::ActiveDirectoryStatus>,
    /// <p>This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise <code>false</code>. Only supported for S3 File Gateways.</p>
    /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
    pub smb_guest_password_set: std::option::Option<bool>,
    /// <p>The type of security strategy that was specified for file gateway.</p>
    /// <ul>
    /// <li> <p> <code>ClientSpecified</code>: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.</p> </li>
    /// <li> <p> <code>MandatorySigning</code>: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p> </li>
    /// <li> <p> <code>MandatoryEncryption</code>: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p> </li>
    /// </ul>
    pub smb_security_strategy: std::option::Option<crate::model::SmbSecurityStrategy>,
    /// <p>The shares on this gateway appear when listing shares. Only supported for S3 File Gateways. </p>
    pub file_shares_visible: std::option::Option<bool>,
    /// <p>A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.</p>
    pub smb_local_groups: std::option::Option<crate::model::SmbLocalGroups>,
}
impl DescribeSmbSettingsOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The name of the domain that the gateway is joined to.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Indicates the status of a gateway that is a member of the Active Directory domain.</p>
    /// <ul>
    /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
    /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
    /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
    /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
    /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
    /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
    /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
    /// </ul>
    pub fn active_directory_status(
        &self,
    ) -> std::option::Option<&crate::model::ActiveDirectoryStatus> {
        self.active_directory_status.as_ref()
    }
    /// <p>This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise <code>false</code>. Only supported for S3 File Gateways.</p>
    /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
    pub fn smb_guest_password_set(&self) -> std::option::Option<bool> {
        self.smb_guest_password_set
    }
    /// <p>The type of security strategy that was specified for file gateway.</p>
    /// <ul>
    /// <li> <p> <code>ClientSpecified</code>: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.</p> </li>
    /// <li> <p> <code>MandatorySigning</code>: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p> </li>
    /// <li> <p> <code>MandatoryEncryption</code>: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p> </li>
    /// </ul>
    pub fn smb_security_strategy(&self) -> std::option::Option<&crate::model::SmbSecurityStrategy> {
        self.smb_security_strategy.as_ref()
    }
    /// <p>The shares on this gateway appear when listing shares. Only supported for S3 File Gateways. </p>
    pub fn file_shares_visible(&self) -> std::option::Option<bool> {
        self.file_shares_visible
    }
    /// <p>A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.</p>
    pub fn smb_local_groups(&self) -> std::option::Option<&crate::model::SmbLocalGroups> {
        self.smb_local_groups.as_ref()
    }
}
impl std::fmt::Debug for DescribeSmbSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSmbSettingsOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("active_directory_status", &self.active_directory_status);
        formatter.field("smb_guest_password_set", &self.smb_guest_password_set);
        formatter.field("smb_security_strategy", &self.smb_security_strategy);
        formatter.field("file_shares_visible", &self.file_shares_visible);
        formatter.field("smb_local_groups", &self.smb_local_groups);
        formatter.finish()
    }
}
/// See [`DescribeSmbSettingsOutput`](crate::output::DescribeSmbSettingsOutput)
pub mod describe_smb_settings_output {
    /// A builder for [`DescribeSmbSettingsOutput`](crate::output::DescribeSmbSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) active_directory_status:
            std::option::Option<crate::model::ActiveDirectoryStatus>,
        pub(crate) smb_guest_password_set: std::option::Option<bool>,
        pub(crate) smb_security_strategy: std::option::Option<crate::model::SmbSecurityStrategy>,
        pub(crate) file_shares_visible: std::option::Option<bool>,
        pub(crate) smb_local_groups: std::option::Option<crate::model::SmbLocalGroups>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The name of the domain that the gateway is joined to.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that the gateway is joined to.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Indicates the status of a gateway that is a member of the Active Directory domain.</p>
        /// <ul>
        /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
        /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
        /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
        /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
        /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
        /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
        /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
        /// </ul>
        pub fn active_directory_status(
            mut self,
            input: crate::model::ActiveDirectoryStatus,
        ) -> Self {
            self.active_directory_status = Some(input);
            self
        }
        /// <p>Indicates the status of a gateway that is a member of the Active Directory domain.</p>
        /// <ul>
        /// <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>
        /// <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>
        /// <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>
        /// <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>
        /// <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>
        /// <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>
        /// <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>
        /// </ul>
        pub fn set_active_directory_status(
            mut self,
            input: std::option::Option<crate::model::ActiveDirectoryStatus>,
        ) -> Self {
            self.active_directory_status = input;
            self
        }
        /// <p>This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise <code>false</code>. Only supported for S3 File Gateways.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn smb_guest_password_set(mut self, input: bool) -> Self {
            self.smb_guest_password_set = Some(input);
            self
        }
        /// <p>This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise <code>false</code>. Only supported for S3 File Gateways.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_smb_guest_password_set(mut self, input: std::option::Option<bool>) -> Self {
            self.smb_guest_password_set = input;
            self
        }
        /// <p>The type of security strategy that was specified for file gateway.</p>
        /// <ul>
        /// <li> <p> <code>ClientSpecified</code>: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.</p> </li>
        /// <li> <p> <code>MandatorySigning</code>: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p> </li>
        /// <li> <p> <code>MandatoryEncryption</code>: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p> </li>
        /// </ul>
        pub fn smb_security_strategy(mut self, input: crate::model::SmbSecurityStrategy) -> Self {
            self.smb_security_strategy = Some(input);
            self
        }
        /// <p>The type of security strategy that was specified for file gateway.</p>
        /// <ul>
        /// <li> <p> <code>ClientSpecified</code>: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.</p> </li>
        /// <li> <p> <code>MandatorySigning</code>: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p> </li>
        /// <li> <p> <code>MandatoryEncryption</code>: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p> </li>
        /// </ul>
        pub fn set_smb_security_strategy(
            mut self,
            input: std::option::Option<crate::model::SmbSecurityStrategy>,
        ) -> Self {
            self.smb_security_strategy = input;
            self
        }
        /// <p>The shares on this gateway appear when listing shares. Only supported for S3 File Gateways. </p>
        pub fn file_shares_visible(mut self, input: bool) -> Self {
            self.file_shares_visible = Some(input);
            self
        }
        /// <p>The shares on this gateway appear when listing shares. Only supported for S3 File Gateways. </p>
        pub fn set_file_shares_visible(mut self, input: std::option::Option<bool>) -> Self {
            self.file_shares_visible = input;
            self
        }
        /// <p>A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.</p>
        pub fn smb_local_groups(mut self, input: crate::model::SmbLocalGroups) -> Self {
            self.smb_local_groups = Some(input);
            self
        }
        /// <p>A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.</p>
        pub fn set_smb_local_groups(
            mut self,
            input: std::option::Option<crate::model::SmbLocalGroups>,
        ) -> Self {
            self.smb_local_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSmbSettingsOutput`](crate::output::DescribeSmbSettingsOutput)
        pub fn build(self) -> crate::output::DescribeSmbSettingsOutput {
            crate::output::DescribeSmbSettingsOutput {
                gateway_arn: self.gateway_arn,
                domain_name: self.domain_name,
                active_directory_status: self.active_directory_status,
                smb_guest_password_set: self.smb_guest_password_set,
                smb_security_strategy: self.smb_security_strategy,
                file_shares_visible: self.file_shares_visible,
                smb_local_groups: self.smb_local_groups,
            }
        }
    }
}
impl DescribeSmbSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSmbSettingsOutput`](crate::output::DescribeSmbSettingsOutput)
    pub fn builder() -> crate::output::describe_smb_settings_output::Builder {
        crate::output::describe_smb_settings_output::Builder::default()
    }
}

/// <p>DescribeSMBFileSharesOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSmbFileSharesOutput {
    /// <p>An array containing a description for each requested file share.</p>
    pub smb_file_share_info_list:
        std::option::Option<std::vec::Vec<crate::model::SmbFileShareInfo>>,
}
impl DescribeSmbFileSharesOutput {
    /// <p>An array containing a description for each requested file share.</p>
    pub fn smb_file_share_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::SmbFileShareInfo]> {
        self.smb_file_share_info_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeSmbFileSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSmbFileSharesOutput");
        formatter.field("smb_file_share_info_list", &self.smb_file_share_info_list);
        formatter.finish()
    }
}
/// See [`DescribeSmbFileSharesOutput`](crate::output::DescribeSmbFileSharesOutput)
pub mod describe_smb_file_shares_output {
    /// A builder for [`DescribeSmbFileSharesOutput`](crate::output::DescribeSmbFileSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) smb_file_share_info_list:
            std::option::Option<std::vec::Vec<crate::model::SmbFileShareInfo>>,
    }
    impl Builder {
        /// Appends an item to `smb_file_share_info_list`.
        ///
        /// To override the contents of this collection use [`set_smb_file_share_info_list`](Self::set_smb_file_share_info_list).
        ///
        /// <p>An array containing a description for each requested file share.</p>
        pub fn smb_file_share_info_list(mut self, input: crate::model::SmbFileShareInfo) -> Self {
            let mut v = self.smb_file_share_info_list.unwrap_or_default();
            v.push(input);
            self.smb_file_share_info_list = Some(v);
            self
        }
        /// <p>An array containing a description for each requested file share.</p>
        pub fn set_smb_file_share_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SmbFileShareInfo>>,
        ) -> Self {
            self.smb_file_share_info_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSmbFileSharesOutput`](crate::output::DescribeSmbFileSharesOutput)
        pub fn build(self) -> crate::output::DescribeSmbFileSharesOutput {
            crate::output::DescribeSmbFileSharesOutput {
                smb_file_share_info_list: self.smb_file_share_info_list,
            }
        }
    }
}
impl DescribeSmbFileSharesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSmbFileSharesOutput`](crate::output::DescribeSmbFileSharesOutput)
    pub fn builder() -> crate::output::describe_smb_file_shares_output::Builder {
        crate::output::describe_smb_file_shares_output::Builder::default()
    }
}

/// <p>DescribeNFSFileSharesOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNfsFileSharesOutput {
    /// <p>An array containing a description for each requested file share.</p>
    pub nfs_file_share_info_list:
        std::option::Option<std::vec::Vec<crate::model::NfsFileShareInfo>>,
}
impl DescribeNfsFileSharesOutput {
    /// <p>An array containing a description for each requested file share.</p>
    pub fn nfs_file_share_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::NfsFileShareInfo]> {
        self.nfs_file_share_info_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeNfsFileSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNfsFileSharesOutput");
        formatter.field("nfs_file_share_info_list", &self.nfs_file_share_info_list);
        formatter.finish()
    }
}
/// See [`DescribeNfsFileSharesOutput`](crate::output::DescribeNfsFileSharesOutput)
pub mod describe_nfs_file_shares_output {
    /// A builder for [`DescribeNfsFileSharesOutput`](crate::output::DescribeNfsFileSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nfs_file_share_info_list:
            std::option::Option<std::vec::Vec<crate::model::NfsFileShareInfo>>,
    }
    impl Builder {
        /// Appends an item to `nfs_file_share_info_list`.
        ///
        /// To override the contents of this collection use [`set_nfs_file_share_info_list`](Self::set_nfs_file_share_info_list).
        ///
        /// <p>An array containing a description for each requested file share.</p>
        pub fn nfs_file_share_info_list(mut self, input: crate::model::NfsFileShareInfo) -> Self {
            let mut v = self.nfs_file_share_info_list.unwrap_or_default();
            v.push(input);
            self.nfs_file_share_info_list = Some(v);
            self
        }
        /// <p>An array containing a description for each requested file share.</p>
        pub fn set_nfs_file_share_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NfsFileShareInfo>>,
        ) -> Self {
            self.nfs_file_share_info_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNfsFileSharesOutput`](crate::output::DescribeNfsFileSharesOutput)
        pub fn build(self) -> crate::output::DescribeNfsFileSharesOutput {
            crate::output::DescribeNfsFileSharesOutput {
                nfs_file_share_info_list: self.nfs_file_share_info_list,
            }
        }
    }
}
impl DescribeNfsFileSharesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNfsFileSharesOutput`](crate::output::DescribeNfsFileSharesOutput)
    pub fn builder() -> crate::output::describe_nfs_file_shares_output::Builder {
        crate::output::describe_nfs_file_shares_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
/// <ul>
/// <li> <p> <code>DescribeMaintenanceStartTimeOutput$DayOfMonth</code> </p> </li>
/// <li> <p> <code>DescribeMaintenanceStartTimeOutput$DayOfWeek</code> </p> </li>
/// <li> <p> <code>DescribeMaintenanceStartTimeOutput$HourOfDay</code> </p> </li>
/// <li> <p> <code>DescribeMaintenanceStartTimeOutput$MinuteOfHour</code> </p> </li>
/// <li> <p> <code>DescribeMaintenanceStartTimeOutput$Timezone</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceStartTimeOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
    pub hour_of_day: std::option::Option<i32>,
    /// <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>
    pub minute_of_hour: std::option::Option<i32>,
    /// <p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>
    pub day_of_week: std::option::Option<i32>,
    /// <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
    pub day_of_month: std::option::Option<i32>,
    /// <p>A value that indicates the time zone that is set for the gateway. The start time and day of week specified should be in the time zone of the gateway.</p>
    pub timezone: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceStartTimeOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
    pub fn hour_of_day(&self) -> std::option::Option<i32> {
        self.hour_of_day
    }
    /// <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>
    pub fn minute_of_hour(&self) -> std::option::Option<i32> {
        self.minute_of_hour
    }
    /// <p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>
    pub fn day_of_week(&self) -> std::option::Option<i32> {
        self.day_of_week
    }
    /// <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
    pub fn day_of_month(&self) -> std::option::Option<i32> {
        self.day_of_month
    }
    /// <p>A value that indicates the time zone that is set for the gateway. The start time and day of week specified should be in the time zone of the gateway.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceStartTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceStartTimeOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("hour_of_day", &self.hour_of_day);
        formatter.field("minute_of_hour", &self.minute_of_hour);
        formatter.field("day_of_week", &self.day_of_week);
        formatter.field("day_of_month", &self.day_of_month);
        formatter.field("timezone", &self.timezone);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceStartTimeOutput`](crate::output::DescribeMaintenanceStartTimeOutput)
pub mod describe_maintenance_start_time_output {
    /// A builder for [`DescribeMaintenanceStartTimeOutput`](crate::output::DescribeMaintenanceStartTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) hour_of_day: std::option::Option<i32>,
        pub(crate) minute_of_hour: std::option::Option<i32>,
        pub(crate) day_of_week: std::option::Option<i32>,
        pub(crate) day_of_month: std::option::Option<i32>,
        pub(crate) timezone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn hour_of_day(mut self, input: i32) -> Self {
            self.hour_of_day = Some(input);
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn set_hour_of_day(mut self, input: std::option::Option<i32>) -> Self {
            self.hour_of_day = input;
            self
        }
        /// <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>
        pub fn minute_of_hour(mut self, input: i32) -> Self {
            self.minute_of_hour = Some(input);
            self
        }
        /// <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>
        pub fn set_minute_of_hour(mut self, input: std::option::Option<i32>) -> Self {
            self.minute_of_hour = input;
            self
        }
        /// <p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>
        pub fn day_of_week(mut self, input: i32) -> Self {
            self.day_of_week = Some(input);
            self
        }
        /// <p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>
        pub fn set_day_of_week(mut self, input: std::option::Option<i32>) -> Self {
            self.day_of_week = input;
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
        pub fn day_of_month(mut self, input: i32) -> Self {
            self.day_of_month = Some(input);
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<i32>) -> Self {
            self.day_of_month = input;
            self
        }
        /// <p>A value that indicates the time zone that is set for the gateway. The start time and day of week specified should be in the time zone of the gateway.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>A value that indicates the time zone that is set for the gateway. The start time and day of week specified should be in the time zone of the gateway.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceStartTimeOutput`](crate::output::DescribeMaintenanceStartTimeOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceStartTimeOutput {
            crate::output::DescribeMaintenanceStartTimeOutput {
                gateway_arn: self.gateway_arn,
                hour_of_day: self.hour_of_day,
                minute_of_hour: self.minute_of_hour,
                day_of_week: self.day_of_week,
                day_of_month: self.day_of_month,
                timezone: self.timezone,
            }
        }
    }
}
impl DescribeMaintenanceStartTimeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceStartTimeOutput`](crate::output::DescribeMaintenanceStartTimeOutput)
    pub fn builder() -> crate::output::describe_maintenance_start_time_output::Builder {
        crate::output::describe_maintenance_start_time_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayInformationOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The name you configured for your gateway.</p>
    pub gateway_name: std::option::Option<std::string::String>,
    /// <p>A value that indicates the time zone configured for the gateway.</p>
    pub gateway_timezone: std::option::Option<std::string::String>,
    /// <p>A value that indicates the operating state of the gateway.</p>
    pub gateway_state: std::option::Option<std::string::String>,
    /// <p>A <code>NetworkInterface</code> array that contains descriptions of the gateway network interfaces.</p>
    pub gateway_network_interfaces:
        std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    /// <p>The type of the gateway.</p>
    pub gateway_type: std::option::Option<std::string::String>,
    /// <p>The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.</p>
    pub next_update_availability_date: std::option::Option<std::string::String>,
    /// <p>The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response. This only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
    pub last_software_update: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
    pub ec2_instance_region: std::option::Option<std::string::String>,
    /// <p>A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.</p>
    pub vpc_endpoint: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway. This field only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
    pub cloud_watch_log_group_arn: std::option::Option<std::string::String>,
    /// <p>The type of hardware or software platform on which the gateway is running.</p>
    pub host_environment: std::option::Option<crate::model::HostEnvironment>,
    /// <p>The type of endpoint for your gateway.</p>
    /// <p>Valid Values: <code>STANDARD</code> | <code>FIPS</code> </p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>Date after which this gateway will not receive software updates for new features.</p>
    pub software_updates_end_date: std::option::Option<std::string::String>,
    /// <p>Date after which this gateway will not receive software updates for new features and bug fixes.</p>
    pub deprecation_date: std::option::Option<std::string::String>,
    /// <p>Specifies the size of the gateway's metadata cache.</p>
    pub gateway_capacity: std::option::Option<crate::model::GatewayCapacity>,
    /// <p>A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.</p>
    pub supported_gateway_capacities:
        std::option::Option<std::vec::Vec<crate::model::GatewayCapacity>>,
    /// <p>A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.</p>
    pub host_environment_id: std::option::Option<std::string::String>,
}
impl DescribeGatewayInformationOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The name you configured for your gateway.</p>
    pub fn gateway_name(&self) -> std::option::Option<&str> {
        self.gateway_name.as_deref()
    }
    /// <p>A value that indicates the time zone configured for the gateway.</p>
    pub fn gateway_timezone(&self) -> std::option::Option<&str> {
        self.gateway_timezone.as_deref()
    }
    /// <p>A value that indicates the operating state of the gateway.</p>
    pub fn gateway_state(&self) -> std::option::Option<&str> {
        self.gateway_state.as_deref()
    }
    /// <p>A <code>NetworkInterface</code> array that contains descriptions of the gateway network interfaces.</p>
    pub fn gateway_network_interfaces(
        &self,
    ) -> std::option::Option<&[crate::model::NetworkInterface]> {
        self.gateway_network_interfaces.as_deref()
    }
    /// <p>The type of the gateway.</p>
    pub fn gateway_type(&self) -> std::option::Option<&str> {
        self.gateway_type.as_deref()
    }
    /// <p>The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.</p>
    pub fn next_update_availability_date(&self) -> std::option::Option<&str> {
        self.next_update_availability_date.as_deref()
    }
    /// <p>The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response. This only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
    pub fn last_software_update(&self) -> std::option::Option<&str> {
        self.last_software_update.as_deref()
    }
    /// <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
    pub fn ec2_instance_id(&self) -> std::option::Option<&str> {
        self.ec2_instance_id.as_deref()
    }
    /// <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
    pub fn ec2_instance_region(&self) -> std::option::Option<&str> {
        self.ec2_instance_region.as_deref()
    }
    /// <p>A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.</p>
    pub fn vpc_endpoint(&self) -> std::option::Option<&str> {
        self.vpc_endpoint.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway. This field only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
    pub fn cloud_watch_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_log_group_arn.as_deref()
    }
    /// <p>The type of hardware or software platform on which the gateway is running.</p>
    pub fn host_environment(&self) -> std::option::Option<&crate::model::HostEnvironment> {
        self.host_environment.as_ref()
    }
    /// <p>The type of endpoint for your gateway.</p>
    /// <p>Valid Values: <code>STANDARD</code> | <code>FIPS</code> </p>
    pub fn endpoint_type(&self) -> std::option::Option<&str> {
        self.endpoint_type.as_deref()
    }
    /// <p>Date after which this gateway will not receive software updates for new features.</p>
    pub fn software_updates_end_date(&self) -> std::option::Option<&str> {
        self.software_updates_end_date.as_deref()
    }
    /// <p>Date after which this gateway will not receive software updates for new features and bug fixes.</p>
    pub fn deprecation_date(&self) -> std::option::Option<&str> {
        self.deprecation_date.as_deref()
    }
    /// <p>Specifies the size of the gateway's metadata cache.</p>
    pub fn gateway_capacity(&self) -> std::option::Option<&crate::model::GatewayCapacity> {
        self.gateway_capacity.as_ref()
    }
    /// <p>A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.</p>
    pub fn supported_gateway_capacities(
        &self,
    ) -> std::option::Option<&[crate::model::GatewayCapacity]> {
        self.supported_gateway_capacities.as_deref()
    }
    /// <p>A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.</p>
    pub fn host_environment_id(&self) -> std::option::Option<&str> {
        self.host_environment_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeGatewayInformationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayInformationOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("gateway_name", &self.gateway_name);
        formatter.field("gateway_timezone", &self.gateway_timezone);
        formatter.field("gateway_state", &self.gateway_state);
        formatter.field(
            "gateway_network_interfaces",
            &self.gateway_network_interfaces,
        );
        formatter.field("gateway_type", &self.gateway_type);
        formatter.field(
            "next_update_availability_date",
            &self.next_update_availability_date,
        );
        formatter.field("last_software_update", &self.last_software_update);
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("ec2_instance_region", &self.ec2_instance_region);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_endpoint", &self.vpc_endpoint);
        formatter.field("cloud_watch_log_group_arn", &self.cloud_watch_log_group_arn);
        formatter.field("host_environment", &self.host_environment);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("software_updates_end_date", &self.software_updates_end_date);
        formatter.field("deprecation_date", &self.deprecation_date);
        formatter.field("gateway_capacity", &self.gateway_capacity);
        formatter.field(
            "supported_gateway_capacities",
            &self.supported_gateway_capacities,
        );
        formatter.field("host_environment_id", &self.host_environment_id);
        formatter.finish()
    }
}
/// See [`DescribeGatewayInformationOutput`](crate::output::DescribeGatewayInformationOutput)
pub mod describe_gateway_information_output {
    /// A builder for [`DescribeGatewayInformationOutput`](crate::output::DescribeGatewayInformationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
        pub(crate) gateway_timezone: std::option::Option<std::string::String>,
        pub(crate) gateway_state: std::option::Option<std::string::String>,
        pub(crate) gateway_network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        pub(crate) gateway_type: std::option::Option<std::string::String>,
        pub(crate) next_update_availability_date: std::option::Option<std::string::String>,
        pub(crate) last_software_update: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) vpc_endpoint: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) host_environment: std::option::Option<crate::model::HostEnvironment>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) software_updates_end_date: std::option::Option<std::string::String>,
        pub(crate) deprecation_date: std::option::Option<std::string::String>,
        pub(crate) gateway_capacity: std::option::Option<crate::model::GatewayCapacity>,
        pub(crate) supported_gateway_capacities:
            std::option::Option<std::vec::Vec<crate::model::GatewayCapacity>>,
        pub(crate) host_environment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// <p>A value that indicates the time zone configured for the gateway.</p>
        pub fn gateway_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_timezone = Some(input.into());
            self
        }
        /// <p>A value that indicates the time zone configured for the gateway.</p>
        pub fn set_gateway_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_timezone = input;
            self
        }
        /// <p>A value that indicates the operating state of the gateway.</p>
        pub fn gateway_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_state = Some(input.into());
            self
        }
        /// <p>A value that indicates the operating state of the gateway.</p>
        pub fn set_gateway_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_state = input;
            self
        }
        /// Appends an item to `gateway_network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_gateway_network_interfaces`](Self::set_gateway_network_interfaces).
        ///
        /// <p>A <code>NetworkInterface</code> array that contains descriptions of the gateway network interfaces.</p>
        pub fn gateway_network_interfaces(mut self, input: crate::model::NetworkInterface) -> Self {
            let mut v = self.gateway_network_interfaces.unwrap_or_default();
            v.push(input);
            self.gateway_network_interfaces = Some(v);
            self
        }
        /// <p>A <code>NetworkInterface</code> array that contains descriptions of the gateway network interfaces.</p>
        pub fn set_gateway_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.gateway_network_interfaces = input;
            self
        }
        /// <p>The type of the gateway.</p>
        pub fn gateway_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_type = Some(input.into());
            self
        }
        /// <p>The type of the gateway.</p>
        pub fn set_gateway_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_type = input;
            self
        }
        /// <p>The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.</p>
        pub fn next_update_availability_date(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.next_update_availability_date = Some(input.into());
            self
        }
        /// <p>The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.</p>
        pub fn set_next_update_availability_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_update_availability_date = input;
            self
        }
        /// <p>The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response. This only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
        pub fn last_software_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_software_update = Some(input.into());
            self
        }
        /// <p>The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response. This only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
        pub fn set_last_software_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_software_update = input;
            self
        }
        /// <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
        pub fn ec2_instance_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
        pub fn set_ec2_instance_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_region = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.</p>
        pub fn vpc_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint = Some(input.into());
            self
        }
        /// <p>The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.</p>
        pub fn set_vpc_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_endpoint = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway. This field only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_log_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway. This field only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_log_group_arn = input;
            self
        }
        /// <p>The type of hardware or software platform on which the gateway is running.</p>
        pub fn host_environment(mut self, input: crate::model::HostEnvironment) -> Self {
            self.host_environment = Some(input);
            self
        }
        /// <p>The type of hardware or software platform on which the gateway is running.</p>
        pub fn set_host_environment(
            mut self,
            input: std::option::Option<crate::model::HostEnvironment>,
        ) -> Self {
            self.host_environment = input;
            self
        }
        /// <p>The type of endpoint for your gateway.</p>
        /// <p>Valid Values: <code>STANDARD</code> | <code>FIPS</code> </p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of endpoint for your gateway.</p>
        /// <p>Valid Values: <code>STANDARD</code> | <code>FIPS</code> </p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>Date after which this gateway will not receive software updates for new features.</p>
        pub fn software_updates_end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.software_updates_end_date = Some(input.into());
            self
        }
        /// <p>Date after which this gateway will not receive software updates for new features.</p>
        pub fn set_software_updates_end_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.software_updates_end_date = input;
            self
        }
        /// <p>Date after which this gateway will not receive software updates for new features and bug fixes.</p>
        pub fn deprecation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.deprecation_date = Some(input.into());
            self
        }
        /// <p>Date after which this gateway will not receive software updates for new features and bug fixes.</p>
        pub fn set_deprecation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deprecation_date = input;
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn gateway_capacity(mut self, input: crate::model::GatewayCapacity) -> Self {
            self.gateway_capacity = Some(input);
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn set_gateway_capacity(
            mut self,
            input: std::option::Option<crate::model::GatewayCapacity>,
        ) -> Self {
            self.gateway_capacity = input;
            self
        }
        /// Appends an item to `supported_gateway_capacities`.
        ///
        /// To override the contents of this collection use [`set_supported_gateway_capacities`](Self::set_supported_gateway_capacities).
        ///
        /// <p>A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.</p>
        pub fn supported_gateway_capacities(
            mut self,
            input: crate::model::GatewayCapacity,
        ) -> Self {
            let mut v = self.supported_gateway_capacities.unwrap_or_default();
            v.push(input);
            self.supported_gateway_capacities = Some(v);
            self
        }
        /// <p>A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.</p>
        pub fn set_supported_gateway_capacities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GatewayCapacity>>,
        ) -> Self {
            self.supported_gateway_capacities = input;
            self
        }
        /// <p>A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.</p>
        pub fn host_environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_environment_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.</p>
        pub fn set_host_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_environment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayInformationOutput`](crate::output::DescribeGatewayInformationOutput)
        pub fn build(self) -> crate::output::DescribeGatewayInformationOutput {
            crate::output::DescribeGatewayInformationOutput {
                gateway_arn: self.gateway_arn,
                gateway_id: self.gateway_id,
                gateway_name: self.gateway_name,
                gateway_timezone: self.gateway_timezone,
                gateway_state: self.gateway_state,
                gateway_network_interfaces: self.gateway_network_interfaces,
                gateway_type: self.gateway_type,
                next_update_availability_date: self.next_update_availability_date,
                last_software_update: self.last_software_update,
                ec2_instance_id: self.ec2_instance_id,
                ec2_instance_region: self.ec2_instance_region,
                tags: self.tags,
                vpc_endpoint: self.vpc_endpoint,
                cloud_watch_log_group_arn: self.cloud_watch_log_group_arn,
                host_environment: self.host_environment,
                endpoint_type: self.endpoint_type,
                software_updates_end_date: self.software_updates_end_date,
                deprecation_date: self.deprecation_date,
                gateway_capacity: self.gateway_capacity,
                supported_gateway_capacities: self.supported_gateway_capacities,
                host_environment_id: self.host_environment_id,
            }
        }
    }
}
impl DescribeGatewayInformationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayInformationOutput`](crate::output::DescribeGatewayInformationOutput)
    pub fn builder() -> crate::output::describe_gateway_information_output::Builder {
        crate::output::describe_gateway_information_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemAssociationsOutput {
    /// <p>An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to be described. </p>
    pub file_system_association_info_list:
        std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationInfo>>,
}
impl DescribeFileSystemAssociationsOutput {
    /// <p>An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to be described. </p>
    pub fn file_system_association_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::FileSystemAssociationInfo]> {
        self.file_system_association_info_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemAssociationsOutput");
        formatter.field(
            "file_system_association_info_list",
            &self.file_system_association_info_list,
        );
        formatter.finish()
    }
}
/// See [`DescribeFileSystemAssociationsOutput`](crate::output::DescribeFileSystemAssociationsOutput)
pub mod describe_file_system_associations_output {
    /// A builder for [`DescribeFileSystemAssociationsOutput`](crate::output::DescribeFileSystemAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_info_list:
            std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationInfo>>,
    }
    impl Builder {
        /// Appends an item to `file_system_association_info_list`.
        ///
        /// To override the contents of this collection use [`set_file_system_association_info_list`](Self::set_file_system_association_info_list).
        ///
        /// <p>An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to be described. </p>
        pub fn file_system_association_info_list(
            mut self,
            input: crate::model::FileSystemAssociationInfo,
        ) -> Self {
            let mut v = self.file_system_association_info_list.unwrap_or_default();
            v.push(input);
            self.file_system_association_info_list = Some(v);
            self
        }
        /// <p>An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to be described. </p>
        pub fn set_file_system_association_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationInfo>>,
        ) -> Self {
            self.file_system_association_info_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemAssociationsOutput`](crate::output::DescribeFileSystemAssociationsOutput)
        pub fn build(self) -> crate::output::DescribeFileSystemAssociationsOutput {
            crate::output::DescribeFileSystemAssociationsOutput {
                file_system_association_info_list: self.file_system_association_info_list,
            }
        }
    }
}
impl DescribeFileSystemAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemAssociationsOutput`](crate::output::DescribeFileSystemAssociationsOutput)
    pub fn builder() -> crate::output::describe_file_system_associations_output::Builder {
        crate::output::describe_file_system_associations_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChapCredentialsOutput {
    /// <p>An array of <code>ChapInfo</code> objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:</p>
    /// <ul>
    /// <li> <p> <b>InitiatorName</b>: The iSCSI initiator that connects to the target.</p> </li>
    /// <li> <p> <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> </li>
    /// <li> <p> <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> </li>
    /// <li> <p> <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.</p> </li>
    /// </ul>
    pub chap_credentials: std::option::Option<std::vec::Vec<crate::model::ChapInfo>>,
}
impl DescribeChapCredentialsOutput {
    /// <p>An array of <code>ChapInfo</code> objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:</p>
    /// <ul>
    /// <li> <p> <b>InitiatorName</b>: The iSCSI initiator that connects to the target.</p> </li>
    /// <li> <p> <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> </li>
    /// <li> <p> <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> </li>
    /// <li> <p> <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.</p> </li>
    /// </ul>
    pub fn chap_credentials(&self) -> std::option::Option<&[crate::model::ChapInfo]> {
        self.chap_credentials.as_deref()
    }
}
impl std::fmt::Debug for DescribeChapCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChapCredentialsOutput");
        formatter.field("chap_credentials", &self.chap_credentials);
        formatter.finish()
    }
}
/// See [`DescribeChapCredentialsOutput`](crate::output::DescribeChapCredentialsOutput)
pub mod describe_chap_credentials_output {
    /// A builder for [`DescribeChapCredentialsOutput`](crate::output::DescribeChapCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) chap_credentials: std::option::Option<std::vec::Vec<crate::model::ChapInfo>>,
    }
    impl Builder {
        /// Appends an item to `chap_credentials`.
        ///
        /// To override the contents of this collection use [`set_chap_credentials`](Self::set_chap_credentials).
        ///
        /// <p>An array of <code>ChapInfo</code> objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:</p>
        /// <ul>
        /// <li> <p> <b>InitiatorName</b>: The iSCSI initiator that connects to the target.</p> </li>
        /// <li> <p> <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> </li>
        /// <li> <p> <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> </li>
        /// <li> <p> <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.</p> </li>
        /// </ul>
        pub fn chap_credentials(mut self, input: crate::model::ChapInfo) -> Self {
            let mut v = self.chap_credentials.unwrap_or_default();
            v.push(input);
            self.chap_credentials = Some(v);
            self
        }
        /// <p>An array of <code>ChapInfo</code> objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:</p>
        /// <ul>
        /// <li> <p> <b>InitiatorName</b>: The iSCSI initiator that connects to the target.</p> </li>
        /// <li> <p> <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> </li>
        /// <li> <p> <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> </li>
        /// <li> <p> <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.</p> </li>
        /// </ul>
        pub fn set_chap_credentials(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChapInfo>>,
        ) -> Self {
            self.chap_credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChapCredentialsOutput`](crate::output::DescribeChapCredentialsOutput)
        pub fn build(self) -> crate::output::DescribeChapCredentialsOutput {
            crate::output::DescribeChapCredentialsOutput {
                chap_credentials: self.chap_credentials,
            }
        }
    }
}
impl DescribeChapCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChapCredentialsOutput`](crate::output::DescribeChapCredentialsOutput)
    pub fn builder() -> crate::output::describe_chap_credentials_output::Builder {
        crate::output::describe_chap_credentials_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCachediScsiVolumesOutput {
    /// <p>An array of objects where each object contains metadata about one cached volume.</p>
    pub cachedi_scsi_volumes: std::option::Option<std::vec::Vec<crate::model::CachediScsiVolume>>,
}
impl DescribeCachediScsiVolumesOutput {
    /// <p>An array of objects where each object contains metadata about one cached volume.</p>
    pub fn cachedi_scsi_volumes(&self) -> std::option::Option<&[crate::model::CachediScsiVolume]> {
        self.cachedi_scsi_volumes.as_deref()
    }
}
impl std::fmt::Debug for DescribeCachediScsiVolumesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCachediScsiVolumesOutput");
        formatter.field("cachedi_scsi_volumes", &self.cachedi_scsi_volumes);
        formatter.finish()
    }
}
/// See [`DescribeCachediScsiVolumesOutput`](crate::output::DescribeCachediScsiVolumesOutput)
pub mod describe_cachedi_scsi_volumes_output {
    /// A builder for [`DescribeCachediScsiVolumesOutput`](crate::output::DescribeCachediScsiVolumesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cachedi_scsi_volumes:
            std::option::Option<std::vec::Vec<crate::model::CachediScsiVolume>>,
    }
    impl Builder {
        /// Appends an item to `cachedi_scsi_volumes`.
        ///
        /// To override the contents of this collection use [`set_cachedi_scsi_volumes`](Self::set_cachedi_scsi_volumes).
        ///
        /// <p>An array of objects where each object contains metadata about one cached volume.</p>
        pub fn cachedi_scsi_volumes(mut self, input: crate::model::CachediScsiVolume) -> Self {
            let mut v = self.cachedi_scsi_volumes.unwrap_or_default();
            v.push(input);
            self.cachedi_scsi_volumes = Some(v);
            self
        }
        /// <p>An array of objects where each object contains metadata about one cached volume.</p>
        pub fn set_cachedi_scsi_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CachediScsiVolume>>,
        ) -> Self {
            self.cachedi_scsi_volumes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCachediScsiVolumesOutput`](crate::output::DescribeCachediScsiVolumesOutput)
        pub fn build(self) -> crate::output::DescribeCachediScsiVolumesOutput {
            crate::output::DescribeCachediScsiVolumesOutput {
                cachedi_scsi_volumes: self.cachedi_scsi_volumes,
            }
        }
    }
}
impl DescribeCachediScsiVolumesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCachediScsiVolumesOutput`](crate::output::DescribeCachediScsiVolumesOutput)
    pub fn builder() -> crate::output::describe_cachedi_scsi_volumes_output::Builder {
        crate::output::describe_cachedi_scsi_volumes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
    pub disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The amount of cache in bytes allocated to a gateway.</p>
    pub cache_allocated_in_bytes: i64,
    /// <p>Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.</p>
    pub cache_used_percentage: f64,
    /// <p>The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.</p>
    pub cache_dirty_percentage: f64,
    /// <p>Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.</p>
    pub cache_hit_percentage: f64,
    /// <p>Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.</p>
    pub cache_miss_percentage: f64,
}
impl DescribeCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
    pub fn disk_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.disk_ids.as_deref()
    }
    /// <p>The amount of cache in bytes allocated to a gateway.</p>
    pub fn cache_allocated_in_bytes(&self) -> i64 {
        self.cache_allocated_in_bytes
    }
    /// <p>Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.</p>
    pub fn cache_used_percentage(&self) -> f64 {
        self.cache_used_percentage
    }
    /// <p>The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.</p>
    pub fn cache_dirty_percentage(&self) -> f64 {
        self.cache_dirty_percentage
    }
    /// <p>Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.</p>
    pub fn cache_hit_percentage(&self) -> f64 {
        self.cache_hit_percentage
    }
    /// <p>Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.</p>
    pub fn cache_miss_percentage(&self) -> f64 {
        self.cache_miss_percentage
    }
}
impl std::fmt::Debug for DescribeCacheOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("disk_ids", &self.disk_ids);
        formatter.field("cache_allocated_in_bytes", &self.cache_allocated_in_bytes);
        formatter.field("cache_used_percentage", &self.cache_used_percentage);
        formatter.field("cache_dirty_percentage", &self.cache_dirty_percentage);
        formatter.field("cache_hit_percentage", &self.cache_hit_percentage);
        formatter.field("cache_miss_percentage", &self.cache_miss_percentage);
        formatter.finish()
    }
}
/// See [`DescribeCacheOutput`](crate::output::DescribeCacheOutput)
pub mod describe_cache_output {
    /// A builder for [`DescribeCacheOutput`](crate::output::DescribeCacheOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cache_allocated_in_bytes: std::option::Option<i64>,
        pub(crate) cache_used_percentage: std::option::Option<f64>,
        pub(crate) cache_dirty_percentage: std::option::Option<f64>,
        pub(crate) cache_hit_percentage: std::option::Option<f64>,
        pub(crate) cache_miss_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `disk_ids`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disk_ids.unwrap_or_default();
            v.push(input.into());
            self.disk_ids = Some(v);
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disk_ids = input;
            self
        }
        /// <p>The amount of cache in bytes allocated to a gateway.</p>
        pub fn cache_allocated_in_bytes(mut self, input: i64) -> Self {
            self.cache_allocated_in_bytes = Some(input);
            self
        }
        /// <p>The amount of cache in bytes allocated to a gateway.</p>
        pub fn set_cache_allocated_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.cache_allocated_in_bytes = input;
            self
        }
        /// <p>Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.</p>
        pub fn cache_used_percentage(mut self, input: f64) -> Self {
            self.cache_used_percentage = Some(input);
            self
        }
        /// <p>Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.</p>
        pub fn set_cache_used_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.cache_used_percentage = input;
            self
        }
        /// <p>The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.</p>
        pub fn cache_dirty_percentage(mut self, input: f64) -> Self {
            self.cache_dirty_percentage = Some(input);
            self
        }
        /// <p>The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.</p>
        pub fn set_cache_dirty_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.cache_dirty_percentage = input;
            self
        }
        /// <p>Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.</p>
        pub fn cache_hit_percentage(mut self, input: f64) -> Self {
            self.cache_hit_percentage = Some(input);
            self
        }
        /// <p>Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.</p>
        pub fn set_cache_hit_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.cache_hit_percentage = input;
            self
        }
        /// <p>Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.</p>
        pub fn cache_miss_percentage(mut self, input: f64) -> Self {
            self.cache_miss_percentage = Some(input);
            self
        }
        /// <p>Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.</p>
        pub fn set_cache_miss_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.cache_miss_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheOutput`](crate::output::DescribeCacheOutput)
        pub fn build(self) -> crate::output::DescribeCacheOutput {
            crate::output::DescribeCacheOutput {
                gateway_arn: self.gateway_arn,
                disk_ids: self.disk_ids,
                cache_allocated_in_bytes: self.cache_allocated_in_bytes.unwrap_or_default(),
                cache_used_percentage: self.cache_used_percentage.unwrap_or_default(),
                cache_dirty_percentage: self.cache_dirty_percentage.unwrap_or_default(),
                cache_hit_percentage: self.cache_hit_percentage.unwrap_or_default(),
                cache_miss_percentage: self.cache_miss_percentage.unwrap_or_default(),
            }
        }
    }
}
impl DescribeCacheOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCacheOutput`](crate::output::DescribeCacheOutput)
    pub fn builder() -> crate::output::describe_cache_output::Builder {
        crate::output::describe_cache_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBandwidthRateLimitScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p> An array that contains the bandwidth rate limit intervals for a tape or volume gateway. </p>
    pub bandwidth_rate_limit_intervals:
        std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
}
impl DescribeBandwidthRateLimitScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p> An array that contains the bandwidth rate limit intervals for a tape or volume gateway. </p>
    pub fn bandwidth_rate_limit_intervals(
        &self,
    ) -> std::option::Option<&[crate::model::BandwidthRateLimitInterval]> {
        self.bandwidth_rate_limit_intervals.as_deref()
    }
}
impl std::fmt::Debug for DescribeBandwidthRateLimitScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBandwidthRateLimitScheduleOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field(
            "bandwidth_rate_limit_intervals",
            &self.bandwidth_rate_limit_intervals,
        );
        formatter.finish()
    }
}
/// See [`DescribeBandwidthRateLimitScheduleOutput`](crate::output::DescribeBandwidthRateLimitScheduleOutput)
pub mod describe_bandwidth_rate_limit_schedule_output {
    /// A builder for [`DescribeBandwidthRateLimitScheduleOutput`](crate::output::DescribeBandwidthRateLimitScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_rate_limit_intervals:
            std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `bandwidth_rate_limit_intervals`.
        ///
        /// To override the contents of this collection use [`set_bandwidth_rate_limit_intervals`](Self::set_bandwidth_rate_limit_intervals).
        ///
        /// <p> An array that contains the bandwidth rate limit intervals for a tape or volume gateway. </p>
        pub fn bandwidth_rate_limit_intervals(
            mut self,
            input: crate::model::BandwidthRateLimitInterval,
        ) -> Self {
            let mut v = self.bandwidth_rate_limit_intervals.unwrap_or_default();
            v.push(input);
            self.bandwidth_rate_limit_intervals = Some(v);
            self
        }
        /// <p> An array that contains the bandwidth rate limit intervals for a tape or volume gateway. </p>
        pub fn set_bandwidth_rate_limit_intervals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
        ) -> Self {
            self.bandwidth_rate_limit_intervals = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBandwidthRateLimitScheduleOutput`](crate::output::DescribeBandwidthRateLimitScheduleOutput)
        pub fn build(self) -> crate::output::DescribeBandwidthRateLimitScheduleOutput {
            crate::output::DescribeBandwidthRateLimitScheduleOutput {
                gateway_arn: self.gateway_arn,
                bandwidth_rate_limit_intervals: self.bandwidth_rate_limit_intervals,
            }
        }
    }
}
impl DescribeBandwidthRateLimitScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBandwidthRateLimitScheduleOutput`](crate::output::DescribeBandwidthRateLimitScheduleOutput)
    pub fn builder() -> crate::output::describe_bandwidth_rate_limit_schedule_output::Builder {
        crate::output::describe_bandwidth_rate_limit_schedule_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBandwidthRateLimitOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the upload rate limit is not set.</p>
    pub average_upload_rate_limit_in_bits_per_sec: std::option::Option<i64>,
    /// <p>The average download bandwidth rate limit in bits per second. This field does not appear in the response if the download rate limit is not set.</p>
    pub average_download_rate_limit_in_bits_per_sec: std::option::Option<i64>,
}
impl DescribeBandwidthRateLimitOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the upload rate limit is not set.</p>
    pub fn average_upload_rate_limit_in_bits_per_sec(&self) -> std::option::Option<i64> {
        self.average_upload_rate_limit_in_bits_per_sec
    }
    /// <p>The average download bandwidth rate limit in bits per second. This field does not appear in the response if the download rate limit is not set.</p>
    pub fn average_download_rate_limit_in_bits_per_sec(&self) -> std::option::Option<i64> {
        self.average_download_rate_limit_in_bits_per_sec
    }
}
impl std::fmt::Debug for DescribeBandwidthRateLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBandwidthRateLimitOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field(
            "average_upload_rate_limit_in_bits_per_sec",
            &self.average_upload_rate_limit_in_bits_per_sec,
        );
        formatter.field(
            "average_download_rate_limit_in_bits_per_sec",
            &self.average_download_rate_limit_in_bits_per_sec,
        );
        formatter.finish()
    }
}
/// See [`DescribeBandwidthRateLimitOutput`](crate::output::DescribeBandwidthRateLimitOutput)
pub mod describe_bandwidth_rate_limit_output {
    /// A builder for [`DescribeBandwidthRateLimitOutput`](crate::output::DescribeBandwidthRateLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) average_upload_rate_limit_in_bits_per_sec: std::option::Option<i64>,
        pub(crate) average_download_rate_limit_in_bits_per_sec: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the upload rate limit is not set.</p>
        pub fn average_upload_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.average_upload_rate_limit_in_bits_per_sec = Some(input);
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the upload rate limit is not set.</p>
        pub fn set_average_upload_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.average_upload_rate_limit_in_bits_per_sec = input;
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second. This field does not appear in the response if the download rate limit is not set.</p>
        pub fn average_download_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.average_download_rate_limit_in_bits_per_sec = Some(input);
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second. This field does not appear in the response if the download rate limit is not set.</p>
        pub fn set_average_download_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.average_download_rate_limit_in_bits_per_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBandwidthRateLimitOutput`](crate::output::DescribeBandwidthRateLimitOutput)
        pub fn build(self) -> crate::output::DescribeBandwidthRateLimitOutput {
            crate::output::DescribeBandwidthRateLimitOutput {
                gateway_arn: self.gateway_arn,
                average_upload_rate_limit_in_bits_per_sec: self
                    .average_upload_rate_limit_in_bits_per_sec,
                average_download_rate_limit_in_bits_per_sec: self
                    .average_download_rate_limit_in_bits_per_sec,
            }
        }
    }
}
impl DescribeBandwidthRateLimitOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBandwidthRateLimitOutput`](crate::output::DescribeBandwidthRateLimitOutput)
    pub fn builder() -> crate::output::describe_bandwidth_rate_limit_output::Builder {
        crate::output::describe_bandwidth_rate_limit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAvailabilityMonitorTestOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The status of the high availability monitoring test. If a test hasn't been performed, the value of this field is null.</p>
    pub status: std::option::Option<crate::model::AvailabilityMonitorTestStatus>,
    /// <p>The time the high availability monitoring test was started. If a test hasn't been performed, the value of this field is null.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeAvailabilityMonitorTestOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The status of the high availability monitoring test. If a test hasn't been performed, the value of this field is null.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AvailabilityMonitorTestStatus> {
        self.status.as_ref()
    }
    /// <p>The time the high availability monitoring test was started. If a test hasn't been performed, the value of this field is null.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeAvailabilityMonitorTestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAvailabilityMonitorTestOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.finish()
    }
}
/// See [`DescribeAvailabilityMonitorTestOutput`](crate::output::DescribeAvailabilityMonitorTestOutput)
pub mod describe_availability_monitor_test_output {
    /// A builder for [`DescribeAvailabilityMonitorTestOutput`](crate::output::DescribeAvailabilityMonitorTestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AvailabilityMonitorTestStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The status of the high availability monitoring test. If a test hasn't been performed, the value of this field is null.</p>
        pub fn status(mut self, input: crate::model::AvailabilityMonitorTestStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the high availability monitoring test. If a test hasn't been performed, the value of this field is null.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AvailabilityMonitorTestStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time the high availability monitoring test was started. If a test hasn't been performed, the value of this field is null.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the high availability monitoring test was started. If a test hasn't been performed, the value of this field is null.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAvailabilityMonitorTestOutput`](crate::output::DescribeAvailabilityMonitorTestOutput)
        pub fn build(self) -> crate::output::DescribeAvailabilityMonitorTestOutput {
            crate::output::DescribeAvailabilityMonitorTestOutput {
                gateway_arn: self.gateway_arn,
                status: self.status,
                start_time: self.start_time,
            }
        }
    }
}
impl DescribeAvailabilityMonitorTestOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAvailabilityMonitorTestOutput`](crate::output::DescribeAvailabilityMonitorTestOutput)
    pub fn builder() -> crate::output::describe_availability_monitor_test_output::Builder {
        crate::output::describe_availability_monitor_test_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the storage volume that was deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is the same ARN you provided in the request.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl DeleteVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is the same ARN you provided in the request.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVolumeOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}
/// See [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
pub mod delete_volume_output {
    /// A builder for [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is the same ARN you provided in the request.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is the same ARN you provided in the request.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
        pub fn build(self) -> crate::output::DeleteVolumeOutput {
            crate::output::DeleteVolumeOutput {
                volume_arn: self.volume_arn,
            }
        }
    }
}
impl DeleteVolumeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
    pub fn builder() -> crate::output::delete_volume_output::Builder {
        crate::output::delete_volume_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTapePoolOutput {
    /// <p>The Amazon Resource Name (ARN) of the custom tape pool being deleted.</p>
    pub pool_arn: std::option::Option<std::string::String>,
}
impl DeleteTapePoolOutput {
    /// <p>The Amazon Resource Name (ARN) of the custom tape pool being deleted.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteTapePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTapePoolOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.finish()
    }
}
/// See [`DeleteTapePoolOutput`](crate::output::DeleteTapePoolOutput)
pub mod delete_tape_pool_output {
    /// A builder for [`DeleteTapePoolOutput`](crate::output::DeleteTapePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool being deleted.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool being deleted.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTapePoolOutput`](crate::output::DeleteTapePoolOutput)
        pub fn build(self) -> crate::output::DeleteTapePoolOutput {
            crate::output::DeleteTapePoolOutput {
                pool_arn: self.pool_arn,
            }
        }
    }
}
impl DeleteTapePoolOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTapePoolOutput`](crate::output::DeleteTapePoolOutput)
    pub fn builder() -> crate::output::delete_tape_pool_output::Builder {
        crate::output::delete_tape_pool_output::Builder::default()
    }
}

/// <p>DeleteTapeArchiveOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTapeArchiveOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape that was deleted from the virtual tape shelf (VTS).</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl DeleteTapeArchiveOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape that was deleted from the virtual tape shelf (VTS).</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteTapeArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTapeArchiveOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`DeleteTapeArchiveOutput`](crate::output::DeleteTapeArchiveOutput)
pub mod delete_tape_archive_output {
    /// A builder for [`DeleteTapeArchiveOutput`](crate::output::DeleteTapeArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape that was deleted from the virtual tape shelf (VTS).</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape that was deleted from the virtual tape shelf (VTS).</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTapeArchiveOutput`](crate::output::DeleteTapeArchiveOutput)
        pub fn build(self) -> crate::output::DeleteTapeArchiveOutput {
            crate::output::DeleteTapeArchiveOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl DeleteTapeArchiveOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTapeArchiveOutput`](crate::output::DeleteTapeArchiveOutput)
    pub fn builder() -> crate::output::delete_tape_archive_output::Builder {
        crate::output::delete_tape_archive_output::Builder::default()
    }
}

/// <p>DeleteTapeOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTapeOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted virtual tape.</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl DeleteTapeOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted virtual tape.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteTapeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTapeOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`DeleteTapeOutput`](crate::output::DeleteTapeOutput)
pub mod delete_tape_output {
    /// A builder for [`DeleteTapeOutput`](crate::output::DeleteTapeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deleted virtual tape.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted virtual tape.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTapeOutput`](crate::output::DeleteTapeOutput)
        pub fn build(self) -> crate::output::DeleteTapeOutput {
            crate::output::DeleteTapeOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl DeleteTapeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTapeOutput`](crate::output::DeleteTapeOutput)
    pub fn builder() -> crate::output::delete_tape_output::Builder {
        crate::output::delete_tape_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotScheduleOutput {
    /// <p>The volume which snapshot schedule was deleted.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl DeleteSnapshotScheduleOutput {
    /// <p>The volume which snapshot schedule was deleted.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSnapshotScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotScheduleOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}
/// See [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
pub mod delete_snapshot_schedule_output {
    /// A builder for [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The volume which snapshot schedule was deleted.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The volume which snapshot schedule was deleted.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
        pub fn build(self) -> crate::output::DeleteSnapshotScheduleOutput {
            crate::output::DeleteSnapshotScheduleOutput {
                volume_arn: self.volume_arn,
            }
        }
    }
}
impl DeleteSnapshotScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
    pub fn builder() -> crate::output::delete_snapshot_schedule_output::Builder {
        crate::output::delete_snapshot_schedule_output::Builder::default()
    }
}

/// <p>A JSON object containing the ID of the deleted gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DeleteGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
pub mod delete_gateway_output {
    /// A builder for [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
        pub fn build(self) -> crate::output::DeleteGatewayOutput {
            crate::output::DeleteGatewayOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl DeleteGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
    pub fn builder() -> crate::output::delete_gateway_output::Builder {
        crate::output::delete_gateway_output::Builder::default()
    }
}

/// <p>DeleteFileShareOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
}
impl DeleteFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileShareOutput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.finish()
    }
}
/// See [`DeleteFileShareOutput`](crate::output::DeleteFileShareOutput)
pub mod delete_file_share_output {
    /// A builder for [`DeleteFileShareOutput`](crate::output::DeleteFileShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deleted file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileShareOutput`](crate::output::DeleteFileShareOutput)
        pub fn build(self) -> crate::output::DeleteFileShareOutput {
            crate::output::DeleteFileShareOutput {
                file_share_arn: self.file_share_arn,
            }
        }
    }
}
impl DeleteFileShareOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFileShareOutput`](crate::output::DeleteFileShareOutput)
    pub fn builder() -> crate::output::delete_file_share_output::Builder {
        crate::output::delete_file_share_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChapCredentialsOutput {
    /// <p>The Amazon Resource Name (ARN) of the target.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The iSCSI initiator that connects to the target.</p>
    pub initiator_name: std::option::Option<std::string::String>,
}
impl DeleteChapCredentialsOutput {
    /// <p>The Amazon Resource Name (ARN) of the target.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The iSCSI initiator that connects to the target.</p>
    pub fn initiator_name(&self) -> std::option::Option<&str> {
        self.initiator_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteChapCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChapCredentialsOutput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("initiator_name", &self.initiator_name);
        formatter.finish()
    }
}
/// See [`DeleteChapCredentialsOutput`](crate::output::DeleteChapCredentialsOutput)
pub mod delete_chap_credentials_output {
    /// A builder for [`DeleteChapCredentialsOutput`](crate::output::DeleteChapCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) initiator_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.initiator_name = Some(input.into());
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initiator_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChapCredentialsOutput`](crate::output::DeleteChapCredentialsOutput)
        pub fn build(self) -> crate::output::DeleteChapCredentialsOutput {
            crate::output::DeleteChapCredentialsOutput {
                target_arn: self.target_arn,
                initiator_name: self.initiator_name,
            }
        }
    }
}
impl DeleteChapCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChapCredentialsOutput`](crate::output::DeleteChapCredentialsOutput)
    pub fn builder() -> crate::output::delete_chap_credentials_output::Builder {
        crate::output::delete_chap_credentials_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway whose bandwidth rate information was deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBandwidthRateLimitOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DeleteBandwidthRateLimitOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteBandwidthRateLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBandwidthRateLimitOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`DeleteBandwidthRateLimitOutput`](crate::output::DeleteBandwidthRateLimitOutput)
pub mod delete_bandwidth_rate_limit_output {
    /// A builder for [`DeleteBandwidthRateLimitOutput`](crate::output::DeleteBandwidthRateLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBandwidthRateLimitOutput`](crate::output::DeleteBandwidthRateLimitOutput)
        pub fn build(self) -> crate::output::DeleteBandwidthRateLimitOutput {
            crate::output::DeleteBandwidthRateLimitOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl DeleteBandwidthRateLimitOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBandwidthRateLimitOutput`](crate::output::DeleteBandwidthRateLimitOutput)
    pub fn builder() -> crate::output::delete_bandwidth_rate_limit_output::Builder {
        crate::output::delete_bandwidth_rate_limit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAutomaticTapeCreationPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DeleteAutomaticTapeCreationPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAutomaticTapeCreationPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAutomaticTapeCreationPolicyOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`DeleteAutomaticTapeCreationPolicyOutput`](crate::output::DeleteAutomaticTapeCreationPolicyOutput)
pub mod delete_automatic_tape_creation_policy_output {
    /// A builder for [`DeleteAutomaticTapeCreationPolicyOutput`](crate::output::DeleteAutomaticTapeCreationPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAutomaticTapeCreationPolicyOutput`](crate::output::DeleteAutomaticTapeCreationPolicyOutput)
        pub fn build(self) -> crate::output::DeleteAutomaticTapeCreationPolicyOutput {
            crate::output::DeleteAutomaticTapeCreationPolicyOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl DeleteAutomaticTapeCreationPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAutomaticTapeCreationPolicyOutput`](crate::output::DeleteAutomaticTapeCreationPolicyOutput)
    pub fn builder() -> crate::output::delete_automatic_tape_creation_policy_output::Builder {
        crate::output::delete_automatic_tape_creation_policy_output::Builder::default()
    }
}

/// <p>CreateTapeOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTapeWithBarcodeOutput {
    /// <p>A unique Amazon Resource Name (ARN) that represents the virtual tape that was created.</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl CreateTapeWithBarcodeOutput {
    /// <p>A unique Amazon Resource Name (ARN) that represents the virtual tape that was created.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateTapeWithBarcodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTapeWithBarcodeOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`CreateTapeWithBarcodeOutput`](crate::output::CreateTapeWithBarcodeOutput)
pub mod create_tape_with_barcode_output {
    /// A builder for [`CreateTapeWithBarcodeOutput`](crate::output::CreateTapeWithBarcodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique Amazon Resource Name (ARN) that represents the virtual tape that was created.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>A unique Amazon Resource Name (ARN) that represents the virtual tape that was created.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTapeWithBarcodeOutput`](crate::output::CreateTapeWithBarcodeOutput)
        pub fn build(self) -> crate::output::CreateTapeWithBarcodeOutput {
            crate::output::CreateTapeWithBarcodeOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl CreateTapeWithBarcodeOutput {
    /// Creates a new builder-style object to manufacture [`CreateTapeWithBarcodeOutput`](crate::output::CreateTapeWithBarcodeOutput)
    pub fn builder() -> crate::output::create_tape_with_barcode_output::Builder {
        crate::output::create_tape_with_barcode_output::Builder::default()
    }
}

/// <p>CreateTapeOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTapesOutput {
    /// <p>A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.</p>
    pub tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateTapesOutput {
    /// <p>A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.</p>
    pub fn tape_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.tape_ar_ns.as_deref()
    }
}
impl std::fmt::Debug for CreateTapesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTapesOutput");
        formatter.field("tape_ar_ns", &self.tape_ar_ns);
        formatter.finish()
    }
}
/// See [`CreateTapesOutput`](crate::output::CreateTapesOutput)
pub mod create_tapes_output {
    /// A builder for [`CreateTapesOutput`](crate::output::CreateTapesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `tape_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.</p>
        pub fn tape_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tape_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.tape_ar_ns = Some(v);
            self
        }
        /// <p>A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tape_ar_ns = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTapesOutput`](crate::output::CreateTapesOutput)
        pub fn build(self) -> crate::output::CreateTapesOutput {
            crate::output::CreateTapesOutput {
                tape_ar_ns: self.tape_ar_ns,
            }
        }
    }
}
impl CreateTapesOutput {
    /// Creates a new builder-style object to manufacture [`CreateTapesOutput`](crate::output::CreateTapesOutput)
    pub fn builder() -> crate::output::create_tapes_output::Builder {
        crate::output::create_tapes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTapePoolOutput {
    /// <p>The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <code>ListTapePools</code> operation to return a list of tape pools for your account and Amazon Web Services Region.</p>
    pub pool_arn: std::option::Option<std::string::String>,
}
impl CreateTapePoolOutput {
    /// <p>The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <code>ListTapePools</code> operation to return a list of tape pools for your account and Amazon Web Services Region.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateTapePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTapePoolOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.finish()
    }
}
/// See [`CreateTapePoolOutput`](crate::output::CreateTapePoolOutput)
pub mod create_tape_pool_output {
    /// A builder for [`CreateTapePoolOutput`](crate::output::CreateTapePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <code>ListTapePools</code> operation to return a list of tape pools for your account and Amazon Web Services Region.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <code>ListTapePools</code> operation to return a list of tape pools for your account and Amazon Web Services Region.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTapePoolOutput`](crate::output::CreateTapePoolOutput)
        pub fn build(self) -> crate::output::CreateTapePoolOutput {
            crate::output::CreateTapePoolOutput {
                pool_arn: self.pool_arn,
            }
        }
    }
}
impl CreateTapePoolOutput {
    /// Creates a new builder-style object to manufacture [`CreateTapePoolOutput`](crate::output::CreateTapePoolOutput)
    pub fn builder() -> crate::output::create_tape_pool_output::Builder {
        crate::output::create_tape_pool_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStorediScsiVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The size of the volume in bytes.</p>
    pub volume_size_in_bytes: i64,
    /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
    pub target_arn: std::option::Option<std::string::String>,
}
impl CreateStorediScsiVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The size of the volume in bytes.</p>
    pub fn volume_size_in_bytes(&self) -> i64 {
        self.volume_size_in_bytes
    }
    /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateStorediScsiVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStorediScsiVolumeOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("volume_size_in_bytes", &self.volume_size_in_bytes);
        formatter.field("target_arn", &self.target_arn);
        formatter.finish()
    }
}
/// See [`CreateStorediScsiVolumeOutput`](crate::output::CreateStorediScsiVolumeOutput)
pub mod create_storedi_scsi_volume_output {
    /// A builder for [`CreateStorediScsiVolumeOutput`](crate::output::CreateStorediScsiVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) volume_size_in_bytes: std::option::Option<i64>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn volume_size_in_bytes(mut self, input: i64) -> Self {
            self.volume_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_size_in_bytes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStorediScsiVolumeOutput`](crate::output::CreateStorediScsiVolumeOutput)
        pub fn build(self) -> crate::output::CreateStorediScsiVolumeOutput {
            crate::output::CreateStorediScsiVolumeOutput {
                volume_arn: self.volume_arn,
                volume_size_in_bytes: self.volume_size_in_bytes.unwrap_or_default(),
                target_arn: self.target_arn,
            }
        }
    }
}
impl CreateStorediScsiVolumeOutput {
    /// Creates a new builder-style object to manufacture [`CreateStorediScsiVolumeOutput`](crate::output::CreateStorediScsiVolumeOutput)
    pub fn builder() -> crate::output::create_storedi_scsi_volume_output::Builder {
        crate::output::create_storedi_scsi_volume_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotFromVolumeRecoveryPointOutput {
    /// <p>The ID of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The time the volume was created from the recovery point.</p>
    pub volume_recovery_point_time: std::option::Option<std::string::String>,
}
impl CreateSnapshotFromVolumeRecoveryPointOutput {
    /// <p>The ID of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The time the volume was created from the recovery point.</p>
    pub fn volume_recovery_point_time(&self) -> std::option::Option<&str> {
        self.volume_recovery_point_time.as_deref()
    }
}
impl std::fmt::Debug for CreateSnapshotFromVolumeRecoveryPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotFromVolumeRecoveryPointOutput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field(
            "volume_recovery_point_time",
            &self.volume_recovery_point_time,
        );
        formatter.finish()
    }
}
/// See [`CreateSnapshotFromVolumeRecoveryPointOutput`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput)
pub mod create_snapshot_from_volume_recovery_point_output {
    /// A builder for [`CreateSnapshotFromVolumeRecoveryPointOutput`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) volume_recovery_point_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The time the volume was created from the recovery point.</p>
        pub fn volume_recovery_point_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_recovery_point_time = Some(input.into());
            self
        }
        /// <p>The time the volume was created from the recovery point.</p>
        pub fn set_volume_recovery_point_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_recovery_point_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotFromVolumeRecoveryPointOutput`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput)
        pub fn build(self) -> crate::output::CreateSnapshotFromVolumeRecoveryPointOutput {
            crate::output::CreateSnapshotFromVolumeRecoveryPointOutput {
                snapshot_id: self.snapshot_id,
                volume_arn: self.volume_arn,
                volume_recovery_point_time: self.volume_recovery_point_time,
            }
        }
    }
}
impl CreateSnapshotFromVolumeRecoveryPointOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotFromVolumeRecoveryPointOutput`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput)
    pub fn builder() -> crate::output::create_snapshot_from_volume_recovery_point_output::Builder {
        crate::output::create_snapshot_from_volume_recovery_point_output::Builder::default()
    }
}

/// <p>A JSON object containing the following fields:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The snapshot ID that is used to refer to the snapshot in future operations such as describing snapshots (Amazon Elastic Compute Cloud API <code>DescribeSnapshots</code>) or creating a volume from a snapshot (<code>CreateStorediSCSIVolume</code>).</p>
    pub snapshot_id: std::option::Option<std::string::String>,
}
impl CreateSnapshotOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The snapshot ID that is used to refer to the snapshot in future operations such as describing snapshots (Amazon Elastic Compute Cloud API <code>DescribeSnapshots</code>) or creating a volume from a snapshot (<code>CreateStorediSCSIVolume</code>).</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for CreateSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.finish()
    }
}
/// See [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
pub mod create_snapshot_output {
    /// A builder for [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The snapshot ID that is used to refer to the snapshot in future operations such as describing snapshots (Amazon Elastic Compute Cloud API <code>DescribeSnapshots</code>) or creating a volume from a snapshot (<code>CreateStorediSCSIVolume</code>).</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot ID that is used to refer to the snapshot in future operations such as describing snapshots (Amazon Elastic Compute Cloud API <code>DescribeSnapshots</code>) or creating a volume from a snapshot (<code>CreateStorediSCSIVolume</code>).</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
        pub fn build(self) -> crate::output::CreateSnapshotOutput {
            crate::output::CreateSnapshotOutput {
                volume_arn: self.volume_arn,
                snapshot_id: self.snapshot_id,
            }
        }
    }
}
impl CreateSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    pub fn builder() -> crate::output::create_snapshot_output::Builder {
        crate::output::create_snapshot_output::Builder::default()
    }
}

/// <p>CreateSMBFileShareOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSmbFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
}
impl CreateSmbFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateSmbFileShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSmbFileShareOutput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.finish()
    }
}
/// See [`CreateSmbFileShareOutput`](crate::output::CreateSmbFileShareOutput)
pub mod create_smb_file_share_output {
    /// A builder for [`CreateSmbFileShareOutput`](crate::output::CreateSmbFileShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSmbFileShareOutput`](crate::output::CreateSmbFileShareOutput)
        pub fn build(self) -> crate::output::CreateSmbFileShareOutput {
            crate::output::CreateSmbFileShareOutput {
                file_share_arn: self.file_share_arn,
            }
        }
    }
}
impl CreateSmbFileShareOutput {
    /// Creates a new builder-style object to manufacture [`CreateSmbFileShareOutput`](crate::output::CreateSmbFileShareOutput)
    pub fn builder() -> crate::output::create_smb_file_share_output::Builder {
        crate::output::create_smb_file_share_output::Builder::default()
    }
}

/// <p>CreateNFSFileShareOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNfsFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
}
impl CreateNfsFileShareOutput {
    /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateNfsFileShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNfsFileShareOutput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.finish()
    }
}
/// See [`CreateNfsFileShareOutput`](crate::output::CreateNfsFileShareOutput)
pub mod create_nfs_file_share_output {
    /// A builder for [`CreateNfsFileShareOutput`](crate::output::CreateNfsFileShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNfsFileShareOutput`](crate::output::CreateNfsFileShareOutput)
        pub fn build(self) -> crate::output::CreateNfsFileShareOutput {
            crate::output::CreateNfsFileShareOutput {
                file_share_arn: self.file_share_arn,
            }
        }
    }
}
impl CreateNfsFileShareOutput {
    /// Creates a new builder-style object to manufacture [`CreateNfsFileShareOutput`](crate::output::CreateNfsFileShareOutput)
    pub fn builder() -> crate::output::create_nfs_file_share_output::Builder {
        crate::output::create_nfs_file_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCachediScsiVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
    pub target_arn: std::option::Option<std::string::String>,
}
impl CreateCachediScsiVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateCachediScsiVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCachediScsiVolumeOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("target_arn", &self.target_arn);
        formatter.finish()
    }
}
/// See [`CreateCachediScsiVolumeOutput`](crate::output::CreateCachediScsiVolumeOutput)
pub mod create_cachedi_scsi_volume_output {
    /// A builder for [`CreateCachediScsiVolumeOutput`](crate::output::CreateCachediScsiVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the configured volume.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCachediScsiVolumeOutput`](crate::output::CreateCachediScsiVolumeOutput)
        pub fn build(self) -> crate::output::CreateCachediScsiVolumeOutput {
            crate::output::CreateCachediScsiVolumeOutput {
                volume_arn: self.volume_arn,
                target_arn: self.target_arn,
            }
        }
    }
}
impl CreateCachediScsiVolumeOutput {
    /// Creates a new builder-style object to manufacture [`CreateCachediScsiVolumeOutput`](crate::output::CreateCachediScsiVolumeOutput)
    pub fn builder() -> crate::output::create_cachedi_scsi_volume_output::Builder {
        crate::output::create_cachedi_scsi_volume_output::Builder::default()
    }
}

/// <p>CancelRetrievalOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelRetrievalOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which retrieval was canceled.</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl CancelRetrievalOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which retrieval was canceled.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for CancelRetrievalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelRetrievalOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`CancelRetrievalOutput`](crate::output::CancelRetrievalOutput)
pub mod cancel_retrieval_output {
    /// A builder for [`CancelRetrievalOutput`](crate::output::CancelRetrievalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which retrieval was canceled.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which retrieval was canceled.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelRetrievalOutput`](crate::output::CancelRetrievalOutput)
        pub fn build(self) -> crate::output::CancelRetrievalOutput {
            crate::output::CancelRetrievalOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl CancelRetrievalOutput {
    /// Creates a new builder-style object to manufacture [`CancelRetrievalOutput`](crate::output::CancelRetrievalOutput)
    pub fn builder() -> crate::output::cancel_retrieval_output::Builder {
        crate::output::cancel_retrieval_output::Builder::default()
    }
}

/// <p>CancelArchivalOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelArchivalOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl CancelArchivalOutput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for CancelArchivalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelArchivalOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`CancelArchivalOutput`](crate::output::CancelArchivalOutput)
pub mod cancel_archival_output {
    /// A builder for [`CancelArchivalOutput`](crate::output::CancelArchivalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelArchivalOutput`](crate::output::CancelArchivalOutput)
        pub fn build(self) -> crate::output::CancelArchivalOutput {
            crate::output::CancelArchivalOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl CancelArchivalOutput {
    /// Creates a new builder-style object to manufacture [`CancelArchivalOutput`](crate::output::CancelArchivalOutput)
    pub fn builder() -> crate::output::cancel_archival_output::Builder {
        crate::output::cancel_archival_output::Builder::default()
    }
}

/// <p>AttachVolumeOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume that was attached to the gateway.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was used to connect to the target.</p>
    pub target_arn: std::option::Option<std::string::String>,
}
impl AttachVolumeOutput {
    /// <p>The Amazon Resource Name (ARN) of the volume that was attached to the gateway.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was used to connect to the target.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
}
impl std::fmt::Debug for AttachVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachVolumeOutput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("target_arn", &self.target_arn);
        formatter.finish()
    }
}
/// See [`AttachVolumeOutput`](crate::output::AttachVolumeOutput)
pub mod attach_volume_output {
    /// A builder for [`AttachVolumeOutput`](crate::output::AttachVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume that was attached to the gateway.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume that was attached to the gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was used to connect to the target.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was used to connect to the target.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachVolumeOutput`](crate::output::AttachVolumeOutput)
        pub fn build(self) -> crate::output::AttachVolumeOutput {
            crate::output::AttachVolumeOutput {
                volume_arn: self.volume_arn,
                target_arn: self.target_arn,
            }
        }
    }
}
impl AttachVolumeOutput {
    /// Creates a new builder-style object to manufacture [`AttachVolumeOutput`](crate::output::AttachVolumeOutput)
    pub fn builder() -> crate::output::attach_volume_output::Builder {
        crate::output::attach_volume_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFileSystemOutput {
    /// <p>The ARN of the newly created file system association.</p>
    pub file_system_association_arn: std::option::Option<std::string::String>,
}
impl AssociateFileSystemOutput {
    /// <p>The ARN of the newly created file system association.</p>
    pub fn file_system_association_arn(&self) -> std::option::Option<&str> {
        self.file_system_association_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFileSystemOutput");
        formatter.field(
            "file_system_association_arn",
            &self.file_system_association_arn,
        );
        formatter.finish()
    }
}
/// See [`AssociateFileSystemOutput`](crate::output::AssociateFileSystemOutput)
pub mod associate_file_system_output {
    /// A builder for [`AssociateFileSystemOutput`](crate::output::AssociateFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the newly created file system association.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the newly created file system association.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFileSystemOutput`](crate::output::AssociateFileSystemOutput)
        pub fn build(self) -> crate::output::AssociateFileSystemOutput {
            crate::output::AssociateFileSystemOutput {
                file_system_association_arn: self.file_system_association_arn,
            }
        }
    }
}
impl AssociateFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`AssociateFileSystemOutput`](crate::output::AssociateFileSystemOutput)
    pub fn builder() -> crate::output::associate_file_system_output::Builder {
        crate::output::associate_file_system_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssignTapePoolOutput {
    /// <p>The unique Amazon Resource Names (ARN) of the virtual tape that was added to the tape pool.</p>
    pub tape_arn: std::option::Option<std::string::String>,
}
impl AssignTapePoolOutput {
    /// <p>The unique Amazon Resource Names (ARN) of the virtual tape that was added to the tape pool.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
}
impl std::fmt::Debug for AssignTapePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssignTapePoolOutput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.finish()
    }
}
/// See [`AssignTapePoolOutput`](crate::output::AssignTapePoolOutput)
pub mod assign_tape_pool_output {
    /// A builder for [`AssignTapePoolOutput`](crate::output::AssignTapePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Names (ARN) of the virtual tape that was added to the tape pool.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Names (ARN) of the virtual tape that was added to the tape pool.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssignTapePoolOutput`](crate::output::AssignTapePoolOutput)
        pub fn build(self) -> crate::output::AssignTapePoolOutput {
            crate::output::AssignTapePoolOutput {
                tape_arn: self.tape_arn,
            }
        }
    }
}
impl AssignTapePoolOutput {
    /// Creates a new builder-style object to manufacture [`AssignTapePoolOutput`](crate::output::AssignTapePoolOutput)
    pub fn builder() -> crate::output::assign_tape_pool_output::Builder {
        crate::output::assign_tape_pool_output::Builder::default()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway for which working storage was configured.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddWorkingStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl AddWorkingStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for AddWorkingStorageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddWorkingStorageOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`AddWorkingStorageOutput`](crate::output::AddWorkingStorageOutput)
pub mod add_working_storage_output {
    /// A builder for [`AddWorkingStorageOutput`](crate::output::AddWorkingStorageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AddWorkingStorageOutput`](crate::output::AddWorkingStorageOutput)
        pub fn build(self) -> crate::output::AddWorkingStorageOutput {
            crate::output::AddWorkingStorageOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl AddWorkingStorageOutput {
    /// Creates a new builder-style object to manufacture [`AddWorkingStorageOutput`](crate::output::AddWorkingStorageOutput)
    pub fn builder() -> crate::output::add_working_storage_output::Builder {
        crate::output::add_working_storage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddUploadBufferOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl AddUploadBufferOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for AddUploadBufferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddUploadBufferOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`AddUploadBufferOutput`](crate::output::AddUploadBufferOutput)
pub mod add_upload_buffer_output {
    /// A builder for [`AddUploadBufferOutput`](crate::output::AddUploadBufferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AddUploadBufferOutput`](crate::output::AddUploadBufferOutput)
        pub fn build(self) -> crate::output::AddUploadBufferOutput {
            crate::output::AddUploadBufferOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl AddUploadBufferOutput {
    /// Creates a new builder-style object to manufacture [`AddUploadBufferOutput`](crate::output::AddUploadBufferOutput)
    pub fn builder() -> crate::output::add_upload_buffer_output::Builder {
        crate::output::add_upload_buffer_output::Builder::default()
    }
}

/// <p>AddTagsToResourceOutput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl AddTagsToResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for AddTagsToResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
pub mod add_tags_to_resource_output {
    /// A builder for [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
        pub fn build(self) -> crate::output::AddTagsToResourceOutput {
            crate::output::AddTagsToResourceOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl AddTagsToResourceOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    pub fn builder() -> crate::output::add_tags_to_resource_output::Builder {
        crate::output::add_tags_to_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl AddCacheOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for AddCacheOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddCacheOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`AddCacheOutput`](crate::output::AddCacheOutput)
pub mod add_cache_output {
    /// A builder for [`AddCacheOutput`](crate::output::AddCacheOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AddCacheOutput`](crate::output::AddCacheOutput)
        pub fn build(self) -> crate::output::AddCacheOutput {
            crate::output::AddCacheOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl AddCacheOutput {
    /// Creates a new builder-style object to manufacture [`AddCacheOutput`](crate::output::AddCacheOutput)
    pub fn builder() -> crate::output::add_cache_output::Builder {
        crate::output::add_cache_output::Builder::default()
    }
}

/// <p>Storage Gateway returns the Amazon Resource Name (ARN) of the activated gateway. It is a string made of information such as your account, gateway name, and Amazon Web Services Region. This ARN is used to reference the gateway in other API operations as well as resource-based authorization.</p> <note>
/// <p>For gateways activated prior to September 02, 2015, the gateway ARN contains the gateway name rather than the gateway ID. Changing the name of the gateway has no effect on the gateway ARN.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ActivateGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ActivateGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateGatewayOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`ActivateGatewayOutput`](crate::output::ActivateGatewayOutput)
pub mod activate_gateway_output {
    /// A builder for [`ActivateGatewayOutput`](crate::output::ActivateGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateGatewayOutput`](crate::output::ActivateGatewayOutput)
        pub fn build(self) -> crate::output::ActivateGatewayOutput {
            crate::output::ActivateGatewayOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl ActivateGatewayOutput {
    /// Creates a new builder-style object to manufacture [`ActivateGatewayOutput`](crate::output::ActivateGatewayOutput)
    pub fn builder() -> crate::output::activate_gateway_output::Builder {
        crate::output::activate_gateway_output::Builder::default()
    }
}
