// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Storage Gateway
///
/// Client for invoking operations on AWS Storage Gateway. Each operation on AWS Storage Gateway is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_storagegateway::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_storagegateway::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_storagegateway::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`ActivateGateway`](crate::client::fluent_builders::ActivateGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`activation_key(impl Into<String>)`](crate::client::fluent_builders::ActivateGateway::activation_key) / [`set_activation_key(Option<String>)`](crate::client::fluent_builders::ActivateGateway::set_activation_key): <p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include other activation-related parameters, however, these are merely defaults -- the arguments you pass to the <code>ActivateGateway</code> API call determine the actual configuration of your gateway.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation key</a> in the <i>Storage Gateway User Guide</i>.</p>
    ///   - [`gateway_name(impl Into<String>)`](crate::client::fluent_builders::ActivateGateway::gateway_name) / [`set_gateway_name(Option<String>)`](crate::client::fluent_builders::ActivateGateway::set_gateway_name): <p>The name you configured for your gateway.</p>
    ///   - [`gateway_timezone(impl Into<String>)`](crate::client::fluent_builders::ActivateGateway::gateway_timezone) / [`set_gateway_timezone(Option<String>)`](crate::client::fluent_builders::ActivateGateway::set_gateway_timezone): <p>A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.</p>
    ///   - [`gateway_region(impl Into<String>)`](crate::client::fluent_builders::ActivateGateway::gateway_region) / [`set_gateway_region(Option<String>)`](crate::client::fluent_builders::ActivateGateway::set_gateway_region): <p>A value that indicates the Amazon Web Services Region where you want to store your data. The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web Services Region in your <code>Host</code> header in the request. For more information about available Amazon Web Services Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>  <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>. </p>
    ///   - [`gateway_type(impl Into<String>)`](crate::client::fluent_builders::ActivateGateway::gateway_type) / [`set_gateway_type(Option<String>)`](crate::client::fluent_builders::ActivateGateway::set_gateway_type): <p>A value that defines the type of gateway to activate. The type specified is critical to all later functions of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.</p>  <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>VTL_SNOW</code> | <code>FILE_S3</code> | <code>FILE_FSX_SMB</code> </p>
    ///   - [`tape_drive_type(impl Into<String>)`](crate::client::fluent_builders::ActivateGateway::tape_drive_type) / [`set_tape_drive_type(Option<String>)`](crate::client::fluent_builders::ActivateGateway::set_tape_drive_type): <p>The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p>  <p>Valid Values: <code>IBM-ULT3580-TD5</code> </p>
    ///   - [`medium_changer_type(impl Into<String>)`](crate::client::fluent_builders::ActivateGateway::medium_changer_type) / [`set_medium_changer_type(Option<String>)`](crate::client::fluent_builders::ActivateGateway::set_medium_changer_type): <p>The value that indicates the type of medium changer to use for tape gateway. This field is optional.</p>  <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ActivateGateway::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ActivateGateway::set_tags): <p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.</p>  </note>
    /// - On success, responds with [`ActivateGatewayOutput`](crate::output::ActivateGatewayOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::ActivateGatewayOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<ActivateGatewayError>`](crate::error::ActivateGatewayError)
    pub fn activate_gateway(&self) -> fluent_builders::ActivateGateway {
        fluent_builders::ActivateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddCache`](crate::client::fluent_builders::AddCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::AddCache::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::AddCache::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disk_ids(Vec<String>)`](crate::client::fluent_builders::AddCache::disk_ids) / [`set_disk_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AddCache::set_disk_ids): <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
    /// - On success, responds with [`AddCacheOutput`](crate::output::AddCacheOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::AddCacheOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<AddCacheError>`](crate::error::AddCacheError)
    pub fn add_cache(&self) -> fluent_builders::AddCache {
        fluent_builders::AddCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tags): <p>The key-value pair that represents the tag you want to add to the resource. The value can be an empty string.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::AddTagsToResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddUploadBuffer`](crate::client::fluent_builders::AddUploadBuffer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::AddUploadBuffer::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::AddUploadBuffer::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disk_ids(Vec<String>)`](crate::client::fluent_builders::AddUploadBuffer::disk_ids) / [`set_disk_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AddUploadBuffer::set_disk_ids): <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
    /// - On success, responds with [`AddUploadBufferOutput`](crate::output::AddUploadBufferOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::AddUploadBufferOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<AddUploadBufferError>`](crate::error::AddUploadBufferError)
    pub fn add_upload_buffer(&self) -> fluent_builders::AddUploadBuffer {
        fluent_builders::AddUploadBuffer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddWorkingStorage`](crate::client::fluent_builders::AddWorkingStorage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::AddWorkingStorage::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::AddWorkingStorage::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disk_ids(Vec<String>)`](crate::client::fluent_builders::AddWorkingStorage::disk_ids) / [`set_disk_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AddWorkingStorage::set_disk_ids): <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
    /// - On success, responds with [`AddWorkingStorageOutput`](crate::output::AddWorkingStorageOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::AddWorkingStorageOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<AddWorkingStorageError>`](crate::error::AddWorkingStorageError)
    pub fn add_working_storage(&self) -> fluent_builders::AddWorkingStorage {
        fluent_builders::AddWorkingStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssignTapePool`](crate::client::fluent_builders::AssignTapePool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tape_arn(impl Into<String>)`](crate::client::fluent_builders::AssignTapePool::tape_arn) / [`set_tape_arn(Option<String>)`](crate::client::fluent_builders::AssignTapePool::set_tape_arn): <p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.</p>
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::AssignTapePool::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::AssignTapePool::set_pool_id): <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///   - [`bypass_governance_retention(bool)`](crate::client::fluent_builders::AssignTapePool::bypass_governance_retention) / [`set_bypass_governance_retention(bool)`](crate::client::fluent_builders::AssignTapePool::set_bypass_governance_retention): <p>Set permissions to bypass governance retention. If the lock type of the archived tape is <code>Governance</code>, the tape's archived age is not older than <code>RetentionLockInDays</code>, and the user does not already have <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass the retention lock. This parameter is set to true by default for calls from the console.</p>  <p>Valid values: <code>TRUE</code> | <code>FALSE</code> </p>
    /// - On success, responds with [`AssignTapePoolOutput`](crate::output::AssignTapePoolOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::AssignTapePoolOutput::tape_arn): <p>The unique Amazon Resource Names (ARN) of the virtual tape that was added to the tape pool.</p>
    /// - On failure, responds with [`SdkError<AssignTapePoolError>`](crate::error::AssignTapePoolError)
    pub fn assign_tape_pool(&self) -> fluent_builders::AssignTapePool {
        fluent_builders::AssignTapePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateFileSystem`](crate::client::fluent_builders::AssociateFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystem::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::AssociateFileSystem::set_user_name): <p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystem::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::AssociateFileSystem::set_password): <p>The password of the user credential.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystem::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateFileSystem::set_client_token): <p>A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system association creation.</p>
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystem::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::AssociateFileSystem::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystem::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::AssociateFileSystem::set_location_arn): <p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AssociateFileSystem::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AssociateFileSystem::set_tags): <p>A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.</p>
    ///   - [`audit_destination_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystem::audit_destination_arn) / [`set_audit_destination_arn(Option<String>)`](crate::client::fluent_builders::AssociateFileSystem::set_audit_destination_arn): <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
    ///   - [`cache_attributes(CacheAttributes)`](crate::client::fluent_builders::AssociateFileSystem::cache_attributes) / [`set_cache_attributes(Option<CacheAttributes>)`](crate::client::fluent_builders::AssociateFileSystem::set_cache_attributes): <p>The refresh cache information for the file share or FSx file systems.</p>
    ///   - [`endpoint_network_configuration(EndpointNetworkConfiguration)`](crate::client::fluent_builders::AssociateFileSystem::endpoint_network_configuration) / [`set_endpoint_network_configuration(Option<EndpointNetworkConfiguration>)`](crate::client::fluent_builders::AssociateFileSystem::set_endpoint_network_configuration): <p>Specifies the network configuration information for the gateway associated with the Amazon FSx file system.</p> <note>   <p>If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is required.</p>  </note>
    /// - On success, responds with [`AssociateFileSystemOutput`](crate::output::AssociateFileSystemOutput) with field(s):
    ///   - [`file_system_association_arn(Option<String>)`](crate::output::AssociateFileSystemOutput::file_system_association_arn): <p>The ARN of the newly created file system association.</p>
    /// - On failure, responds with [`SdkError<AssociateFileSystemError>`](crate::error::AssociateFileSystemError)
    pub fn associate_file_system(&self) -> fluent_builders::AssociateFileSystem {
        fluent_builders::AssociateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachVolume`](crate::client::fluent_builders::AttachVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.</p>
    ///   - [`target_name(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::target_name) / [`set_target_name(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_target_name): <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>  <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_volume_arn): <p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_network_interface_id): <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>  <p>Valid Values: A valid IP address.</p>
    ///   - [`disk_id(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::disk_id) / [`set_disk_id(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_disk_id): <p>The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This value is only required when you are attaching a stored volume.</p>
    /// - On success, responds with [`AttachVolumeOutput`](crate::output::AttachVolumeOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::AttachVolumeOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the volume that was attached to the gateway.</p>
    ///   - [`target_arn(Option<String>)`](crate::output::AttachVolumeOutput::target_arn): <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was used to connect to the target.</p>
    /// - On failure, responds with [`SdkError<AttachVolumeError>`](crate::error::AttachVolumeError)
    pub fn attach_volume(&self) -> fluent_builders::AttachVolume {
        fluent_builders::AttachVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelArchival`](crate::client::fluent_builders::CancelArchival) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CancelArchival::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CancelArchival::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`tape_arn(impl Into<String>)`](crate::client::fluent_builders::CancelArchival::tape_arn) / [`set_tape_arn(Option<String>)`](crate::client::fluent_builders::CancelArchival::set_tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving for.</p>
    /// - On success, responds with [`CancelArchivalOutput`](crate::output::CancelArchivalOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::CancelArchivalOutput::tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.</p>
    /// - On failure, responds with [`SdkError<CancelArchivalError>`](crate::error::CancelArchivalError)
    pub fn cancel_archival(&self) -> fluent_builders::CancelArchival {
        fluent_builders::CancelArchival::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelRetrieval`](crate::client::fluent_builders::CancelRetrieval) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CancelRetrieval::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CancelRetrieval::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`tape_arn(impl Into<String>)`](crate::client::fluent_builders::CancelRetrieval::tape_arn) / [`set_tape_arn(Option<String>)`](crate::client::fluent_builders::CancelRetrieval::set_tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval for.</p>
    /// - On success, responds with [`CancelRetrievalOutput`](crate::output::CancelRetrievalOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::CancelRetrievalOutput::tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape for which retrieval was canceled.</p>
    /// - On failure, responds with [`SdkError<CancelRetrievalError>`](crate::error::CancelRetrievalError)
    pub fn cancel_retrieval(&self) -> fluent_builders::CancelRetrieval {
        fluent_builders::CancelRetrieval::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCachediSCSIVolume`](crate::client::fluent_builders::CreateCachediSCSIVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`volume_size_in_bytes(i64)`](crate::client::fluent_builders::CreateCachediSCSIVolume::volume_size_in_bytes) / [`set_volume_size_in_bytes(i64)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_volume_size_in_bytes): <p>The size of the volume in bytes.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_snapshot_id): <p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
    ///   - [`target_name(impl Into<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::target_name) / [`set_target_name(Option<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_target_name): <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>  <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
    ///   - [`source_volume_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::source_volume_arn) / [`set_source_volume_arn(Option<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_source_volume_arn): <p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than the size of the existing volume, in bytes.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_network_interface_id): <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>  <p>Valid Values: A valid IP address.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_client_token): <p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::CreateCachediSCSIVolume::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCachediSCSIVolume::set_tags): <p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.</p>  </note>
    /// - On success, responds with [`CreateCachediScsiVolumeOutput`](crate::output::CreateCachediScsiVolumeOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::CreateCachediScsiVolumeOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the configured volume.</p>
    ///   - [`target_arn(Option<String>)`](crate::output::CreateCachediScsiVolumeOutput::target_arn): <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
    /// - On failure, responds with [`SdkError<CreateCachediSCSIVolumeError>`](crate::error::CreateCachediSCSIVolumeError)
    pub fn create_cachedi_scsi_volume(&self) -> fluent_builders::CreateCachediSCSIVolume {
        fluent_builders::CreateCachediSCSIVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNFSFileShare`](crate::client::fluent_builders::CreateNFSFileShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_client_token): <p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>
    ///   - [`nfs_file_share_defaults(NfsFileShareDefaults)`](crate::client::fluent_builders::CreateNFSFileShare::nfs_file_share_defaults) / [`set_nfs_file_share_defaults(Option<NfsFileShareDefaults>)`](crate::client::fluent_builders::CreateNFSFileShare::set_nfs_file_share_defaults): <p>File share default values. Optional.</p>
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file share.</p>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::CreateNFSFileShare::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateNFSFileShare::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_role): <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_location_arn): <p>A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).</p> <note>   <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.</p>   <p>Bucket ARN:</p>   <p> <code>arn:aws:s3:::my-bucket/prefix/</code> </p>   <p>Access point ARN:</p>   <p> <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code> </p>   <p>If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>   <p>Access point alias:</p>   <p> <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code> </p>  </note>
    ///   - [`default_storage_class(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::default_storage_class) / [`set_default_storage_class(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_default_storage_class): <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>  <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
    ///   - [`object_acl(ObjectAcl)`](crate::client::fluent_builders::CreateNFSFileShare::object_acl) / [`set_object_acl(Option<ObjectAcl>)`](crate::client::fluent_builders::CreateNFSFileShare::set_object_acl): <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    ///   - [`client_list(Vec<String>)`](crate::client::fluent_builders::CreateNFSFileShare::client_list) / [`set_client_list(Option<Vec<String>>)`](crate::client::fluent_builders::CreateNFSFileShare::set_client_list): <p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>
    ///   - [`squash(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::squash) / [`set_squash(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_squash): <p>A value that maps a user to anonymous user.</p>  <p>Valid values are the following:</p>  <ul>   <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li>   <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li>   <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li>  </ul>
    ///   - [`read_only(bool)`](crate::client::fluent_builders::CreateNFSFileShare::read_only) / [`set_read_only(Option<bool>)`](crate::client::fluent_builders::CreateNFSFileShare::set_read_only): <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`guess_mime_type_enabled(bool)`](crate::client::fluent_builders::CreateNFSFileShare::guess_mime_type_enabled) / [`set_guess_mime_type_enabled(Option<bool>)`](crate::client::fluent_builders::CreateNFSFileShare::set_guess_mime_type_enabled): <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`requester_pays(bool)`](crate::client::fluent_builders::CreateNFSFileShare::requester_pays) / [`set_requester_pays(Option<bool>)`](crate::client::fluent_builders::CreateNFSFileShare::set_requester_pays): <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>   <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>  </note>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateNFSFileShare::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateNFSFileShare::set_tags): <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    ///   - [`file_share_name(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::file_share_name) / [`set_file_share_name(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_file_share_name): <p>The name of the file share. Optional.</p> <note>   <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>  </note>
    ///   - [`cache_attributes(CacheAttributes)`](crate::client::fluent_builders::CreateNFSFileShare::cache_attributes) / [`set_cache_attributes(Option<CacheAttributes>)`](crate::client::fluent_builders::CreateNFSFileShare::set_cache_attributes): <p>Specifies refresh cache information for the file share.</p>
    ///   - [`notification_policy(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::notification_policy) / [`set_notification_policy(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_notification_policy): <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>   <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>  </note>  <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>  <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>  <p>The following example sets <code>NotificationPolicy</code> off.</p>  <p> <code>{}</code> </p>
    ///   - [`vpc_endpoint_dns_name(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::vpc_endpoint_dns_name) / [`set_vpc_endpoint_dns_name(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_vpc_endpoint_dns_name): <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.</p> <note>   <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>  </note>
    ///   - [`bucket_region(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::bucket_region) / [`set_bucket_region(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_bucket_region): <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p> <note>   <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>  </note>
    ///   - [`audit_destination_arn(impl Into<String>)`](crate::client::fluent_builders::CreateNFSFileShare::audit_destination_arn) / [`set_audit_destination_arn(Option<String>)`](crate::client::fluent_builders::CreateNFSFileShare::set_audit_destination_arn): <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    /// - On success, responds with [`CreateNfsFileShareOutput`](crate::output::CreateNfsFileShareOutput) with field(s):
    ///   - [`file_share_arn(Option<String>)`](crate::output::CreateNfsFileShareOutput::file_share_arn): <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
    /// - On failure, responds with [`SdkError<CreateNFSFileShareError>`](crate::error::CreateNFSFileShareError)
    pub fn create_nfs_file_share(&self) -> fluent_builders::CreateNFSFileShare {
        fluent_builders::CreateNFSFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSMBFileShare`](crate::client::fluent_builders::CreateSMBFileShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_client_token): <p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_gateway_arn): <p>The ARN of the S3 File Gateway on which you want to create a file share.</p>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::CreateSMBFileShare::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateSMBFileShare::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_role): <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_location_arn): <p>A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).</p> <note>   <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.</p>   <p>Bucket ARN:</p>   <p> <code>arn:aws:s3:::my-bucket/prefix/</code> </p>   <p>Access point ARN:</p>   <p> <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code> </p>   <p>If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>   <p>Access point alias:</p>   <p> <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code> </p>  </note>
    ///   - [`default_storage_class(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::default_storage_class) / [`set_default_storage_class(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_default_storage_class): <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>  <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
    ///   - [`object_acl(ObjectAcl)`](crate::client::fluent_builders::CreateSMBFileShare::object_acl) / [`set_object_acl(Option<ObjectAcl>)`](crate::client::fluent_builders::CreateSMBFileShare::set_object_acl): <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    ///   - [`read_only(bool)`](crate::client::fluent_builders::CreateSMBFileShare::read_only) / [`set_read_only(Option<bool>)`](crate::client::fluent_builders::CreateSMBFileShare::set_read_only): <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`guess_mime_type_enabled(bool)`](crate::client::fluent_builders::CreateSMBFileShare::guess_mime_type_enabled) / [`set_guess_mime_type_enabled(Option<bool>)`](crate::client::fluent_builders::CreateSMBFileShare::set_guess_mime_type_enabled): <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`requester_pays(bool)`](crate::client::fluent_builders::CreateSMBFileShare::requester_pays) / [`set_requester_pays(Option<bool>)`](crate::client::fluent_builders::CreateSMBFileShare::set_requester_pays): <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>   <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>  </note>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`smbacl_enabled(bool)`](crate::client::fluent_builders::CreateSMBFileShare::smbacl_enabled) / [`set_smbacl_enabled(Option<bool>)`](crate::client::fluent_builders::CreateSMBFileShare::set_smbacl_enabled): <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`access_based_enumeration(bool)`](crate::client::fluent_builders::CreateSMBFileShare::access_based_enumeration) / [`set_access_based_enumeration(Option<bool>)`](crate::client::fluent_builders::CreateSMBFileShare::set_access_based_enumeration): <p>The files and folders on this share will only be visible to users with read access.</p>
    ///   - [`admin_user_list(Vec<String>)`](crate::client::fluent_builders::CreateSMBFileShare::admin_user_list) / [`set_admin_user_list(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSMBFileShare::set_admin_user_list): <p>A list of users or groups in the Active Directory that will be granted administrator privileges on the file share. These users can do all file operations as the super-user. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>.</p> <important>   <p>Use this option very carefully, because any user in this list can do anything they like on the file share, regardless of file permissions.</p>  </important>
    ///   - [`valid_user_list(Vec<String>)`](crate::client::fluent_builders::CreateSMBFileShare::valid_user_list) / [`set_valid_user_list(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSMBFileShare::set_valid_user_list): <p>A list of users or groups in the Active Directory that are allowed to access the file <code></code> share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
    ///   - [`invalid_user_list(Vec<String>)`](crate::client::fluent_builders::CreateSMBFileShare::invalid_user_list) / [`set_invalid_user_list(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSMBFileShare::set_invalid_user_list): <p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
    ///   - [`audit_destination_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::audit_destination_arn) / [`set_audit_destination_arn(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_audit_destination_arn): <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    ///   - [`authentication(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::authentication) / [`set_authentication(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_authentication): <p>The authentication method that users use to access the file share. The default is <code>ActiveDirectory</code>.</p>  <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code> </p>
    ///   - [`case_sensitivity(CaseSensitivity)`](crate::client::fluent_builders::CreateSMBFileShare::case_sensitivity) / [`set_case_sensitivity(Option<CaseSensitivity>)`](crate::client::fluent_builders::CreateSMBFileShare::set_case_sensitivity): <p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSMBFileShare::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSMBFileShare::set_tags): <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    ///   - [`file_share_name(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::file_share_name) / [`set_file_share_name(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_file_share_name): <p>The name of the file share. Optional.</p> <note>   <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>  </note>
    ///   - [`cache_attributes(CacheAttributes)`](crate::client::fluent_builders::CreateSMBFileShare::cache_attributes) / [`set_cache_attributes(Option<CacheAttributes>)`](crate::client::fluent_builders::CreateSMBFileShare::set_cache_attributes): <p>Specifies refresh cache information for the file share.</p>
    ///   - [`notification_policy(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::notification_policy) / [`set_notification_policy(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_notification_policy): <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>   <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>  </note>  <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>  <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>  <p>The following example sets <code>NotificationPolicy</code> off.</p>  <p> <code>{}</code> </p>
    ///   - [`vpc_endpoint_dns_name(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::vpc_endpoint_dns_name) / [`set_vpc_endpoint_dns_name(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_vpc_endpoint_dns_name): <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.</p> <note>   <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>  </note>
    ///   - [`bucket_region(impl Into<String>)`](crate::client::fluent_builders::CreateSMBFileShare::bucket_region) / [`set_bucket_region(Option<String>)`](crate::client::fluent_builders::CreateSMBFileShare::set_bucket_region): <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p> <note>   <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>  </note>
    ///   - [`oplocks_enabled(bool)`](crate::client::fluent_builders::CreateSMBFileShare::oplocks_enabled) / [`set_oplocks_enabled(Option<bool>)`](crate::client::fluent_builders::CreateSMBFileShare::set_oplocks_enabled): <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note>   <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p>  </note>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    /// - On success, responds with [`CreateSmbFileShareOutput`](crate::output::CreateSmbFileShareOutput) with field(s):
    ///   - [`file_share_arn(Option<String>)`](crate::output::CreateSmbFileShareOutput::file_share_arn): <p>The Amazon Resource Name (ARN) of the newly created file share.</p>
    /// - On failure, responds with [`SdkError<CreateSMBFileShareError>`](crate::error::CreateSMBFileShareError)
    pub fn create_smb_file_share(&self) -> fluent_builders::CreateSMBFileShare {
        fluent_builders::CreateSMBFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_volume_arn): <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
    ///   - [`snapshot_description(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::snapshot_description) / [`set_snapshot_description(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_snapshot_description): <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSnapshot::set_tags): <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::CreateSnapshotOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.</p>
    ///   - [`snapshot_id(Option<String>)`](crate::output::CreateSnapshotOutput::snapshot_id): <p>The snapshot ID that is used to refer to the snapshot in future operations such as describing snapshots (Amazon Elastic Compute Cloud API <code>DescribeSnapshots</code>) or creating a volume from a snapshot (<code>CreateStorediSCSIVolume</code>).</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotError>`](crate::error::CreateSnapshotError)
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshotFromVolumeRecoveryPoint`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::set_volume_arn): <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
    ///   - [`snapshot_description(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::snapshot_description) / [`set_snapshot_description(Option<String>)`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::set_snapshot_description): <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::set_tags): <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`CreateSnapshotFromVolumeRecoveryPointOutput`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput) with field(s):
    ///   - [`snapshot_id(Option<String>)`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput::snapshot_id): <p>The ID of the snapshot.</p>
    ///   - [`volume_arn(Option<String>)`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
    ///   - [`volume_recovery_point_time(Option<String>)`](crate::output::CreateSnapshotFromVolumeRecoveryPointOutput::volume_recovery_point_time): <p>The time the volume was created from the recovery point.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotFromVolumeRecoveryPointError>`](crate::error::CreateSnapshotFromVolumeRecoveryPointError)
    pub fn create_snapshot_from_volume_recovery_point(
        &self,
    ) -> fluent_builders::CreateSnapshotFromVolumeRecoveryPoint {
        fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStorediSCSIVolume`](crate::client::fluent_builders::CreateStorediSCSIVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disk_id(impl Into<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::disk_id) / [`set_disk_id(Option<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_disk_id): <p>The unique identifier for the gateway local disk that is configured as a stored volume. Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to list disk IDs for a gateway.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_snapshot_id): <p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
    ///   - [`preserve_existing_data(bool)`](crate::client::fluent_builders::CreateStorediSCSIVolume::preserve_existing_data) / [`set_preserve_existing_data(bool)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_preserve_existing_data): <p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to <code>false</code> to create an empty volume.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`target_name(impl Into<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::target_name) / [`set_target_name(Option<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_target_name): <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>  <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_network_interface_id): <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>  <p>Valid Values: A valid IP address.</p>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::CreateStorediSCSIVolume::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateStorediSCSIVolume::set_tags): <p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`CreateStorediScsiVolumeOutput`](crate::output::CreateStorediScsiVolumeOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::CreateStorediScsiVolumeOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the configured volume.</p>
    ///   - [`volume_size_in_bytes(i64)`](crate::output::CreateStorediScsiVolumeOutput::volume_size_in_bytes): <p>The size of the volume in bytes.</p>
    ///   - [`target_arn(Option<String>)`](crate::output::CreateStorediScsiVolumeOutput::target_arn): <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>
    /// - On failure, responds with [`SdkError<CreateStorediSCSIVolumeError>`](crate::error::CreateStorediSCSIVolumeError)
    pub fn create_storedi_scsi_volume(&self) -> fluent_builders::CreateStorediSCSIVolume {
        fluent_builders::CreateStorediSCSIVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTapePool`](crate::client::fluent_builders::CreateTapePool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::CreateTapePool::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::CreateTapePool::set_pool_name): <p>The name of the new custom tape pool.</p>
    ///   - [`storage_class(TapeStorageClass)`](crate::client::fluent_builders::CreateTapePool::storage_class) / [`set_storage_class(Option<TapeStorageClass>)`](crate::client::fluent_builders::CreateTapePool::set_storage_class): <p>The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///   - [`retention_lock_type(RetentionLockType)`](crate::client::fluent_builders::CreateTapePool::retention_lock_type) / [`set_retention_lock_type(Option<RetentionLockType>)`](crate::client::fluent_builders::CreateTapePool::set_retention_lock_type): <p>Tape retention lock can be configured in two modes. When configured in governance mode, Amazon Web Services accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root Amazon Web Services account.</p>
    ///   - [`retention_lock_time_in_days(i32)`](crate::client::fluent_builders::CreateTapePool::retention_lock_time_in_days) / [`set_retention_lock_time_in_days(Option<i32>)`](crate::client::fluent_builders::CreateTapePool::set_retention_lock_time_in_days): <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTapePool::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTapePool::set_tags): <p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`CreateTapePoolOutput`](crate::output::CreateTapePoolOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::CreateTapePoolOutput::pool_arn): <p>The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <code>ListTapePools</code> operation to return a list of tape pools for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<CreateTapePoolError>`](crate::error::CreateTapePoolError)
    pub fn create_tape_pool(&self) -> fluent_builders::CreateTapePool {
        fluent_builders::CreateTapePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTapes`](crate::client::fluent_builders::CreateTapes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTapes::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CreateTapes::set_gateway_arn): <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`tape_size_in_bytes(i64)`](crate::client::fluent_builders::CreateTapes::tape_size_in_bytes) / [`set_tape_size_in_bytes(Option<i64>)`](crate::client::fluent_builders::CreateTapes::set_tape_size_in_bytes): <p>The size, in bytes, of the virtual tapes that you want to create.</p> <note>   <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>  </note>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTapes::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTapes::set_client_token): <p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p> <note>   <p>Using the same <code>ClientToken</code> prevents creating the tape multiple times.</p>  </note>
    ///   - [`num_tapes_to_create(i32)`](crate::client::fluent_builders::CreateTapes::num_tapes_to_create) / [`set_num_tapes_to_create(Option<i32>)`](crate::client::fluent_builders::CreateTapes::set_num_tapes_to_create): <p>The number of virtual tapes that you want to create.</p>
    ///   - [`tape_barcode_prefix(impl Into<String>)`](crate::client::fluent_builders::CreateTapes::tape_barcode_prefix) / [`set_tape_barcode_prefix(Option<String>)`](crate::client::fluent_builders::CreateTapes::set_tape_barcode_prefix): <p>A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.</p> <note>   <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.</p>  </note>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::CreateTapes::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateTapes::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateTapes::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateTapes::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateTapes::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::CreateTapes::set_pool_id): <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///   - [`worm(bool)`](crate::client::fluent_builders::CreateTapes::worm) / [`set_worm(bool)`](crate::client::fluent_builders::CreateTapes::set_worm): <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTapes::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTapes::set_tags): <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`CreateTapesOutput`](crate::output::CreateTapesOutput) with field(s):
    ///   - [`tape_ar_ns(Option<Vec<String>>)`](crate::output::CreateTapesOutput::tape_ar_ns): <p>A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.</p>
    /// - On failure, responds with [`SdkError<CreateTapesError>`](crate::error::CreateTapesError)
    pub fn create_tapes(&self) -> fluent_builders::CreateTapes {
        fluent_builders::CreateTapes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTapeWithBarcode`](crate::client::fluent_builders::CreateTapeWithBarcode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_gateway_arn): <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`tape_size_in_bytes(i64)`](crate::client::fluent_builders::CreateTapeWithBarcode::tape_size_in_bytes) / [`set_tape_size_in_bytes(Option<i64>)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_tape_size_in_bytes): <p>The size, in bytes, of the virtual tape that you want to create.</p> <note>   <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>  </note>
    ///   - [`tape_barcode(impl Into<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::tape_barcode) / [`set_tape_barcode(Option<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_tape_barcode): <p>The barcode that you want to assign to the tape.</p> <note>   <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.</p>  </note>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::CreateTapeWithBarcode::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_pool_id): <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
    ///   - [`worm(bool)`](crate::client::fluent_builders::CreateTapeWithBarcode::worm) / [`set_worm(bool)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_worm): <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTapeWithBarcode::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTapeWithBarcode::set_tags): <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`CreateTapeWithBarcodeOutput`](crate::output::CreateTapeWithBarcodeOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::CreateTapeWithBarcodeOutput::tape_arn): <p>A unique Amazon Resource Name (ARN) that represents the virtual tape that was created.</p>
    /// - On failure, responds with [`SdkError<CreateTapeWithBarcodeError>`](crate::error::CreateTapeWithBarcodeError)
    pub fn create_tape_with_barcode(&self) -> fluent_builders::CreateTapeWithBarcode {
        fluent_builders::CreateTapeWithBarcode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAutomaticTapeCreationPolicy`](crate::client::fluent_builders::DeleteAutomaticTapeCreationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAutomaticTapeCreationPolicy::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DeleteAutomaticTapeCreationPolicy::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DeleteAutomaticTapeCreationPolicyOutput`](crate::output::DeleteAutomaticTapeCreationPolicyOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DeleteAutomaticTapeCreationPolicyOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<DeleteAutomaticTapeCreationPolicyError>`](crate::error::DeleteAutomaticTapeCreationPolicyError)
    pub fn delete_automatic_tape_creation_policy(
        &self,
    ) -> fluent_builders::DeleteAutomaticTapeCreationPolicy {
        fluent_builders::DeleteAutomaticTapeCreationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBandwidthRateLimit`](crate::client::fluent_builders::DeleteBandwidthRateLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteBandwidthRateLimit::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DeleteBandwidthRateLimit::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`bandwidth_type(impl Into<String>)`](crate::client::fluent_builders::DeleteBandwidthRateLimit::bandwidth_type) / [`set_bandwidth_type(Option<String>)`](crate::client::fluent_builders::DeleteBandwidthRateLimit::set_bandwidth_type): <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.</p>  <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code> </p>
    /// - On success, responds with [`DeleteBandwidthRateLimitOutput`](crate::output::DeleteBandwidthRateLimitOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DeleteBandwidthRateLimitOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<DeleteBandwidthRateLimitError>`](crate::error::DeleteBandwidthRateLimitError)
    pub fn delete_bandwidth_rate_limit(&self) -> fluent_builders::DeleteBandwidthRateLimit {
        fluent_builders::DeleteBandwidthRateLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChapCredentials`](crate::client::fluent_builders::DeleteChapCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChapCredentials::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::DeleteChapCredentials::set_target_arn): <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
    ///   - [`initiator_name(impl Into<String>)`](crate::client::fluent_builders::DeleteChapCredentials::initiator_name) / [`set_initiator_name(Option<String>)`](crate::client::fluent_builders::DeleteChapCredentials::set_initiator_name): <p>The iSCSI initiator that connects to the target.</p>
    /// - On success, responds with [`DeleteChapCredentialsOutput`](crate::output::DeleteChapCredentialsOutput) with field(s):
    ///   - [`target_arn(Option<String>)`](crate::output::DeleteChapCredentialsOutput::target_arn): <p>The Amazon Resource Name (ARN) of the target.</p>
    ///   - [`initiator_name(Option<String>)`](crate::output::DeleteChapCredentialsOutput::initiator_name): <p>The iSCSI initiator that connects to the target.</p>
    /// - On failure, responds with [`SdkError<DeleteChapCredentialsError>`](crate::error::DeleteChapCredentialsError)
    pub fn delete_chap_credentials(&self) -> fluent_builders::DeleteChapCredentials {
        fluent_builders::DeleteChapCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFileShare`](crate::client::fluent_builders::DeleteFileShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_share_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFileShare::file_share_arn) / [`set_file_share_arn(Option<String>)`](crate::client::fluent_builders::DeleteFileShare::set_file_share_arn): <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::DeleteFileShare::force_delete) / [`set_force_delete(bool)`](crate::client::fluent_builders::DeleteFileShare::set_force_delete): <p>If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    /// - On success, responds with [`DeleteFileShareOutput`](crate::output::DeleteFileShareOutput) with field(s):
    ///   - [`file_share_arn(Option<String>)`](crate::output::DeleteFileShareOutput::file_share_arn): <p>The Amazon Resource Name (ARN) of the deleted file share.</p>
    /// - On failure, responds with [`SdkError<DeleteFileShareError>`](crate::error::DeleteFileShareError)
    pub fn delete_file_share(&self) -> fluent_builders::DeleteFileShare {
        fluent_builders::DeleteFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGateway`](crate::client::fluent_builders::DeleteGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteGateway::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DeleteGateway::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DeleteGatewayOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<DeleteGatewayError>`](crate::error::DeleteGatewayError)
    pub fn delete_gateway(&self) -> fluent_builders::DeleteGateway {
        fluent_builders::DeleteGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshotSchedule`](crate::client::fluent_builders::DeleteSnapshotSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshotSchedule::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::DeleteSnapshotSchedule::set_volume_arn): <p>The volume which snapshot schedule to delete.</p>
    /// - On success, responds with [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::DeleteSnapshotScheduleOutput::volume_arn): <p>The volume which snapshot schedule was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteSnapshotScheduleError>`](crate::error::DeleteSnapshotScheduleError)
    pub fn delete_snapshot_schedule(&self) -> fluent_builders::DeleteSnapshotSchedule {
        fluent_builders::DeleteSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTape`](crate::client::fluent_builders::DeleteTape) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTape::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DeleteTape::set_gateway_arn): <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`tape_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTape::tape_arn) / [`set_tape_arn(Option<String>)`](crate::client::fluent_builders::DeleteTape::set_tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
    ///   - [`bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteTape::bypass_governance_retention) / [`set_bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteTape::set_bypass_governance_retention): <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.</p>
    /// - On success, responds with [`DeleteTapeOutput`](crate::output::DeleteTapeOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::DeleteTapeOutput::tape_arn): <p>The Amazon Resource Name (ARN) of the deleted virtual tape.</p>
    /// - On failure, responds with [`SdkError<DeleteTapeError>`](crate::error::DeleteTapeError)
    pub fn delete_tape(&self) -> fluent_builders::DeleteTape {
        fluent_builders::DeleteTape::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTapeArchive`](crate::client::fluent_builders::DeleteTapeArchive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tape_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTapeArchive::tape_arn) / [`set_tape_arn(Option<String>)`](crate::client::fluent_builders::DeleteTapeArchive::set_tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).</p>
    ///   - [`bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteTapeArchive::bypass_governance_retention) / [`set_bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteTapeArchive::set_bypass_governance_retention): <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.</p>
    /// - On success, responds with [`DeleteTapeArchiveOutput`](crate::output::DeleteTapeArchiveOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::DeleteTapeArchiveOutput::tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape that was deleted from the virtual tape shelf (VTS).</p>
    /// - On failure, responds with [`SdkError<DeleteTapeArchiveError>`](crate::error::DeleteTapeArchiveError)
    pub fn delete_tape_archive(&self) -> fluent_builders::DeleteTapeArchive {
        fluent_builders::DeleteTapeArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTapePool`](crate::client::fluent_builders::DeleteTapePool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTapePool::pool_arn) / [`set_pool_arn(Option<String>)`](crate::client::fluent_builders::DeleteTapePool::set_pool_arn): <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
    /// - On success, responds with [`DeleteTapePoolOutput`](crate::output::DeleteTapePoolOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::DeleteTapePoolOutput::pool_arn): <p>The Amazon Resource Name (ARN) of the custom tape pool being deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteTapePoolError>`](crate::error::DeleteTapePoolError)
    pub fn delete_tape_pool(&self) -> fluent_builders::DeleteTapePool {
        fluent_builders::DeleteTapePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVolume`](crate::client::fluent_builders::DeleteVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteVolume::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::DeleteVolume::set_volume_arn): <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
    /// - On success, responds with [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::DeleteVolumeOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is the same ARN you provided in the request.</p>
    /// - On failure, responds with [`SdkError<DeleteVolumeError>`](crate::error::DeleteVolumeError)
    pub fn delete_volume(&self) -> fluent_builders::DeleteVolume {
        fluent_builders::DeleteVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAvailabilityMonitorTest`](crate::client::fluent_builders::DescribeAvailabilityMonitorTest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAvailabilityMonitorTest::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeAvailabilityMonitorTest::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeAvailabilityMonitorTestOutput`](crate::output::DescribeAvailabilityMonitorTestOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeAvailabilityMonitorTestOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`status(Option<AvailabilityMonitorTestStatus>)`](crate::output::DescribeAvailabilityMonitorTestOutput::status): <p>The status of the high availability monitoring test. If a test hasn't been performed, the value of this field is null.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeAvailabilityMonitorTestOutput::start_time): <p>The time the high availability monitoring test was started. If a test hasn't been performed, the value of this field is null.</p>
    /// - On failure, responds with [`SdkError<DescribeAvailabilityMonitorTestError>`](crate::error::DescribeAvailabilityMonitorTestError)
    pub fn describe_availability_monitor_test(
        &self,
    ) -> fluent_builders::DescribeAvailabilityMonitorTest {
        fluent_builders::DescribeAvailabilityMonitorTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBandwidthRateLimit`](crate::client::fluent_builders::DescribeBandwidthRateLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeBandwidthRateLimit::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeBandwidthRateLimit::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeBandwidthRateLimitOutput`](crate::output::DescribeBandwidthRateLimitOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeBandwidthRateLimitOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`average_upload_rate_limit_in_bits_per_sec(Option<i64>)`](crate::output::DescribeBandwidthRateLimitOutput::average_upload_rate_limit_in_bits_per_sec): <p>The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the upload rate limit is not set.</p>
    ///   - [`average_download_rate_limit_in_bits_per_sec(Option<i64>)`](crate::output::DescribeBandwidthRateLimitOutput::average_download_rate_limit_in_bits_per_sec): <p>The average download bandwidth rate limit in bits per second. This field does not appear in the response if the download rate limit is not set.</p>
    /// - On failure, responds with [`SdkError<DescribeBandwidthRateLimitError>`](crate::error::DescribeBandwidthRateLimitError)
    pub fn describe_bandwidth_rate_limit(&self) -> fluent_builders::DescribeBandwidthRateLimit {
        fluent_builders::DescribeBandwidthRateLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBandwidthRateLimitSchedule`](crate::client::fluent_builders::DescribeBandwidthRateLimitSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeBandwidthRateLimitSchedule::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeBandwidthRateLimitSchedule::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeBandwidthRateLimitScheduleOutput`](crate::output::DescribeBandwidthRateLimitScheduleOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeBandwidthRateLimitScheduleOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`bandwidth_rate_limit_intervals(Option<Vec<BandwidthRateLimitInterval>>)`](crate::output::DescribeBandwidthRateLimitScheduleOutput::bandwidth_rate_limit_intervals): <p> An array that contains the bandwidth rate limit intervals for a tape or volume gateway. </p>
    /// - On failure, responds with [`SdkError<DescribeBandwidthRateLimitScheduleError>`](crate::error::DescribeBandwidthRateLimitScheduleError)
    pub fn describe_bandwidth_rate_limit_schedule(
        &self,
    ) -> fluent_builders::DescribeBandwidthRateLimitSchedule {
        fluent_builders::DescribeBandwidthRateLimitSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCache`](crate::client::fluent_builders::DescribeCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCache::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeCache::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeCacheOutput`](crate::output::DescribeCacheOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeCacheOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disk_ids(Option<Vec<String>>)`](crate::output::DescribeCacheOutput::disk_ids): <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
    ///   - [`cache_allocated_in_bytes(i64)`](crate::output::DescribeCacheOutput::cache_allocated_in_bytes): <p>The amount of cache in bytes allocated to a gateway.</p>
    ///   - [`cache_used_percentage(f64)`](crate::output::DescribeCacheOutput::cache_used_percentage): <p>Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.</p>
    ///   - [`cache_dirty_percentage(f64)`](crate::output::DescribeCacheOutput::cache_dirty_percentage): <p>The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.</p>
    ///   - [`cache_hit_percentage(f64)`](crate::output::DescribeCacheOutput::cache_hit_percentage): <p>Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.</p>
    ///   - [`cache_miss_percentage(f64)`](crate::output::DescribeCacheOutput::cache_miss_percentage): <p>Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.</p>
    /// - On failure, responds with [`SdkError<DescribeCacheError>`](crate::error::DescribeCacheError)
    pub fn describe_cache(&self) -> fluent_builders::DescribeCache {
        fluent_builders::DescribeCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCachediSCSIVolumes`](crate::client::fluent_builders::DescribeCachediSCSIVolumes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_ar_ns(Vec<String>)`](crate::client::fluent_builders::DescribeCachediSCSIVolumes::volume_ar_ns) / [`set_volume_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCachediSCSIVolumes::set_volume_ar_ns): <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a cached volume. All of the specified cached volumes must be from the same gateway. Use <code>ListVolumes</code> to get volume ARNs for a gateway.</p>
    /// - On success, responds with [`DescribeCachediScsiVolumesOutput`](crate::output::DescribeCachediScsiVolumesOutput) with field(s):
    ///   - [`cachedi_scsi_volumes(Option<Vec<CachediScsiVolume>>)`](crate::output::DescribeCachediScsiVolumesOutput::cachedi_scsi_volumes): <p>An array of objects where each object contains metadata about one cached volume.</p>
    /// - On failure, responds with [`SdkError<DescribeCachediSCSIVolumesError>`](crate::error::DescribeCachediSCSIVolumesError)
    pub fn describe_cachedi_scsi_volumes(&self) -> fluent_builders::DescribeCachediSCSIVolumes {
        fluent_builders::DescribeCachediSCSIVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChapCredentials`](crate::client::fluent_builders::DescribeChapCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChapCredentials::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::DescribeChapCredentials::set_target_arn): <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
    /// - On success, responds with [`DescribeChapCredentialsOutput`](crate::output::DescribeChapCredentialsOutput) with field(s):
    ///   - [`chap_credentials(Option<Vec<ChapInfo>>)`](crate::output::DescribeChapCredentialsOutput::chap_credentials): <p>An array of <code>ChapInfo</code> objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:</p>  <ul>   <li> <p> <b>InitiatorName</b>: The iSCSI initiator that connects to the target.</p> </li>   <li> <p> <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> </li>   <li> <p> <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> </li>   <li> <p> <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeChapCredentialsError>`](crate::error::DescribeChapCredentialsError)
    pub fn describe_chap_credentials(&self) -> fluent_builders::DescribeChapCredentials {
        fluent_builders::DescribeChapCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFileSystemAssociations`](crate::client::fluent_builders::DescribeFileSystemAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_association_arn_list(Vec<String>)`](crate::client::fluent_builders::DescribeFileSystemAssociations::file_system_association_arn_list) / [`set_file_system_association_arn_list(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFileSystemAssociations::set_file_system_association_arn_list): <p>An array containing the Amazon Resource Name (ARN) of each file system association to be described.</p>
    /// - On success, responds with [`DescribeFileSystemAssociationsOutput`](crate::output::DescribeFileSystemAssociationsOutput) with field(s):
    ///   - [`file_system_association_info_list(Option<Vec<FileSystemAssociationInfo>>)`](crate::output::DescribeFileSystemAssociationsOutput::file_system_association_info_list): <p>An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to be described. </p>
    /// - On failure, responds with [`SdkError<DescribeFileSystemAssociationsError>`](crate::error::DescribeFileSystemAssociationsError)
    pub fn describe_file_system_associations(
        &self,
    ) -> fluent_builders::DescribeFileSystemAssociations {
        fluent_builders::DescribeFileSystemAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGatewayInformation`](crate::client::fluent_builders::DescribeGatewayInformation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeGatewayInformation::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeGatewayInformation::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeGatewayInformationOutput`](crate::output::DescribeGatewayInformationOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeGatewayInformationOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`gateway_id(Option<String>)`](crate::output::DescribeGatewayInformationOutput::gateway_id): <p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>
    ///   - [`gateway_name(Option<String>)`](crate::output::DescribeGatewayInformationOutput::gateway_name): <p>The name you configured for your gateway.</p>
    ///   - [`gateway_timezone(Option<String>)`](crate::output::DescribeGatewayInformationOutput::gateway_timezone): <p>A value that indicates the time zone configured for the gateway.</p>
    ///   - [`gateway_state(Option<String>)`](crate::output::DescribeGatewayInformationOutput::gateway_state): <p>A value that indicates the operating state of the gateway.</p>
    ///   - [`gateway_network_interfaces(Option<Vec<NetworkInterface>>)`](crate::output::DescribeGatewayInformationOutput::gateway_network_interfaces): <p>A <code>NetworkInterface</code> array that contains descriptions of the gateway network interfaces.</p>
    ///   - [`gateway_type(Option<String>)`](crate::output::DescribeGatewayInformationOutput::gateway_type): <p>The type of the gateway.</p>
    ///   - [`next_update_availability_date(Option<String>)`](crate::output::DescribeGatewayInformationOutput::next_update_availability_date): <p>The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.</p>
    ///   - [`last_software_update(Option<String>)`](crate::output::DescribeGatewayInformationOutput::last_software_update): <p>The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response. This only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
    ///   - [`ec2_instance_id(Option<String>)`](crate::output::DescribeGatewayInformationOutput::ec2_instance_id): <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
    ///   - [`ec2_instance_region(Option<String>)`](crate::output::DescribeGatewayInformationOutput::ec2_instance_region): <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribeGatewayInformationOutput::tags): <p>A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
    ///   - [`vpc_endpoint(Option<String>)`](crate::output::DescribeGatewayInformationOutput::vpc_endpoint): <p>The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.</p>
    ///   - [`cloud_watch_log_group_arn(Option<String>)`](crate::output::DescribeGatewayInformationOutput::cloud_watch_log_group_arn): <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway. This field only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM</p>
    ///   - [`host_environment(Option<HostEnvironment>)`](crate::output::DescribeGatewayInformationOutput::host_environment): <p>The type of hardware or software platform on which the gateway is running.</p>
    ///   - [`endpoint_type(Option<String>)`](crate::output::DescribeGatewayInformationOutput::endpoint_type): <p>The type of endpoint for your gateway.</p>  <p>Valid Values: <code>STANDARD</code> | <code>FIPS</code> </p>
    ///   - [`software_updates_end_date(Option<String>)`](crate::output::DescribeGatewayInformationOutput::software_updates_end_date): <p>Date after which this gateway will not receive software updates for new features.</p>
    ///   - [`deprecation_date(Option<String>)`](crate::output::DescribeGatewayInformationOutput::deprecation_date): <p>Date after which this gateway will not receive software updates for new features and bug fixes.</p>
    ///   - [`gateway_capacity(Option<GatewayCapacity>)`](crate::output::DescribeGatewayInformationOutput::gateway_capacity): <p>Specifies the size of the gateway's metadata cache.</p>
    ///   - [`supported_gateway_capacities(Option<Vec<GatewayCapacity>>)`](crate::output::DescribeGatewayInformationOutput::supported_gateway_capacities): <p>A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.</p>
    ///   - [`host_environment_id(Option<String>)`](crate::output::DescribeGatewayInformationOutput::host_environment_id): <p>A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.</p>
    /// - On failure, responds with [`SdkError<DescribeGatewayInformationError>`](crate::error::DescribeGatewayInformationError)
    pub fn describe_gateway_information(&self) -> fluent_builders::DescribeGatewayInformation {
        fluent_builders::DescribeGatewayInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceStartTime`](crate::client::fluent_builders::DescribeMaintenanceStartTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceStartTime::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceStartTime::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeMaintenanceStartTimeOutput`](crate::output::DescribeMaintenanceStartTimeOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeMaintenanceStartTimeOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`hour_of_day(Option<i32>)`](crate::output::DescribeMaintenanceStartTimeOutput::hour_of_day): <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
    ///   - [`minute_of_hour(Option<i32>)`](crate::output::DescribeMaintenanceStartTimeOutput::minute_of_hour): <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>
    ///   - [`day_of_week(Option<i32>)`](crate::output::DescribeMaintenanceStartTimeOutput::day_of_week): <p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>
    ///   - [`day_of_month(Option<i32>)`](crate::output::DescribeMaintenanceStartTimeOutput::day_of_month): <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
    ///   - [`timezone(Option<String>)`](crate::output::DescribeMaintenanceStartTimeOutput::timezone): <p>A value that indicates the time zone that is set for the gateway. The start time and day of week specified should be in the time zone of the gateway.</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceStartTimeError>`](crate::error::DescribeMaintenanceStartTimeError)
    pub fn describe_maintenance_start_time(&self) -> fluent_builders::DescribeMaintenanceStartTime {
        fluent_builders::DescribeMaintenanceStartTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNFSFileShares`](crate::client::fluent_builders::DescribeNFSFileShares) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_share_arn_list(Vec<String>)`](crate::client::fluent_builders::DescribeNFSFileShares::file_share_arn_list) / [`set_file_share_arn_list(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNFSFileShares::set_file_share_arn_list): <p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>
    /// - On success, responds with [`DescribeNfsFileSharesOutput`](crate::output::DescribeNfsFileSharesOutput) with field(s):
    ///   - [`nfs_file_share_info_list(Option<Vec<NfsFileShareInfo>>)`](crate::output::DescribeNfsFileSharesOutput::nfs_file_share_info_list): <p>An array containing a description for each requested file share.</p>
    /// - On failure, responds with [`SdkError<DescribeNFSFileSharesError>`](crate::error::DescribeNFSFileSharesError)
    pub fn describe_nfs_file_shares(&self) -> fluent_builders::DescribeNFSFileShares {
        fluent_builders::DescribeNFSFileShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSMBFileShares`](crate::client::fluent_builders::DescribeSMBFileShares) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_share_arn_list(Vec<String>)`](crate::client::fluent_builders::DescribeSMBFileShares::file_share_arn_list) / [`set_file_share_arn_list(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSMBFileShares::set_file_share_arn_list): <p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>
    /// - On success, responds with [`DescribeSmbFileSharesOutput`](crate::output::DescribeSmbFileSharesOutput) with field(s):
    ///   - [`smb_file_share_info_list(Option<Vec<SmbFileShareInfo>>)`](crate::output::DescribeSmbFileSharesOutput::smb_file_share_info_list): <p>An array containing a description for each requested file share.</p>
    /// - On failure, responds with [`SdkError<DescribeSMBFileSharesError>`](crate::error::DescribeSMBFileSharesError)
    pub fn describe_smb_file_shares(&self) -> fluent_builders::DescribeSMBFileShares {
        fluent_builders::DescribeSMBFileShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSMBSettings`](crate::client::fluent_builders::DescribeSMBSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeSMBSettings::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeSMBSettings::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeSmbSettingsOutput`](crate::output::DescribeSmbSettingsOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeSmbSettingsOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`domain_name(Option<String>)`](crate::output::DescribeSmbSettingsOutput::domain_name): <p>The name of the domain that the gateway is joined to.</p>
    ///   - [`active_directory_status(Option<ActiveDirectoryStatus>)`](crate::output::DescribeSmbSettingsOutput::active_directory_status): <p>Indicates the status of a gateway that is a member of the Active Directory domain.</p>  <ul>   <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>   <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>   <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>   <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>   <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>   <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>   <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>  </ul>
    ///   - [`smb_guest_password_set(Option<bool>)`](crate::output::DescribeSmbSettingsOutput::smb_guest_password_set): <p>This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise <code>false</code>. Only supported for S3 File Gateways.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`smb_security_strategy(Option<SmbSecurityStrategy>)`](crate::output::DescribeSmbSettingsOutput::smb_security_strategy): <p>The type of security strategy that was specified for file gateway.</p>  <ul>   <li> <p> <code>ClientSpecified</code>: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.</p> </li>   <li> <p> <code>MandatorySigning</code>: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p> </li>   <li> <p> <code>MandatoryEncryption</code>: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p> </li>  </ul>
    ///   - [`file_shares_visible(Option<bool>)`](crate::output::DescribeSmbSettingsOutput::file_shares_visible): <p>The shares on this gateway appear when listing shares. Only supported for S3 File Gateways. </p>
    ///   - [`smb_local_groups(Option<SmbLocalGroups>)`](crate::output::DescribeSmbSettingsOutput::smb_local_groups): <p>A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.</p>
    /// - On failure, responds with [`SdkError<DescribeSMBSettingsError>`](crate::error::DescribeSMBSettingsError)
    pub fn describe_smb_settings(&self) -> fluent_builders::DescribeSMBSettings {
        fluent_builders::DescribeSMBSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshotSchedule`](crate::client::fluent_builders::DescribeSnapshotSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedule::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedule::set_volume_arn): <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
    /// - On success, responds with [`DescribeSnapshotScheduleOutput`](crate::output::DescribeSnapshotScheduleOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::DescribeSnapshotScheduleOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the volume that was specified in the request.</p>
    ///   - [`start_at(Option<i32>)`](crate::output::DescribeSnapshotScheduleOutput::start_at): <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
    ///   - [`recurrence_in_hours(Option<i32>)`](crate::output::DescribeSnapshotScheduleOutput::recurrence_in_hours): <p>The number of hours between snapshots.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeSnapshotScheduleOutput::description): <p>The snapshot description.</p>
    ///   - [`timezone(Option<String>)`](crate::output::DescribeSnapshotScheduleOutput::timezone): <p>A value that indicates the time zone of the gateway.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribeSnapshotScheduleOutput::tags): <p>A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotScheduleError>`](crate::error::DescribeSnapshotScheduleError)
    pub fn describe_snapshot_schedule(&self) -> fluent_builders::DescribeSnapshotSchedule {
        fluent_builders::DescribeSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStorediSCSIVolumes`](crate::client::fluent_builders::DescribeStorediSCSIVolumes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_ar_ns(Vec<String>)`](crate::client::fluent_builders::DescribeStorediSCSIVolumes::volume_ar_ns) / [`set_volume_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeStorediSCSIVolumes::set_volume_ar_ns): <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of the specified stored volumes must be from the same gateway. Use <code>ListVolumes</code> to get volume ARNs for a gateway.</p>
    /// - On success, responds with [`DescribeStorediScsiVolumesOutput`](crate::output::DescribeStorediScsiVolumesOutput) with field(s):
    ///   - [`storedi_scsi_volumes(Option<Vec<StorediScsiVolume>>)`](crate::output::DescribeStorediScsiVolumesOutput::storedi_scsi_volumes): <p>Describes a single unit of output from <code>DescribeStorediSCSIVolumes</code>. The following fields are returned:</p>  <ul>   <li> <p> <code>ChapEnabled</code>: Indicates whether mutual CHAP is enabled for the iSCSI target.</p> </li>   <li> <p> <code>LunNumber</code>: The logical disk number.</p> </li>   <li> <p> <code>NetworkInterfaceId</code>: The network interface ID of the stored volume that initiator use to map the stored volume as an iSCSI target.</p> </li>   <li> <p> <code>NetworkInterfacePort</code>: The port used to communicate with iSCSI targets.</p> </li>   <li> <p> <code>PreservedExistingData</code>: Indicates when the stored volume was created, existing data on the underlying local disk was preserved.</p> </li>   <li> <p> <code>SourceSnapshotId</code>: If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. <code>snap-1122aabb</code>. Otherwise, this field is not included.</p> </li>   <li> <p> <code>StorediSCSIVolumes</code>: An array of StorediSCSIVolume objects where each object contains metadata about one stored volume.</p> </li>   <li> <p> <code>TargetARN</code>: The Amazon Resource Name (ARN) of the volume target.</p> </li>   <li> <p> <code>VolumeARN</code>: The Amazon Resource Name (ARN) of the stored volume.</p> </li>   <li> <p> <code>VolumeDiskId</code>: The disk ID of the local disk that was specified in the <code>CreateStorediSCSIVolume</code> operation.</p> </li>   <li> <p> <code>VolumeId</code>: The unique identifier of the storage volume, e.g. <code>vol-1122AABB</code>.</p> </li>   <li> <p> <code>VolumeiSCSIAttributes</code>: An <code>VolumeiSCSIAttributes</code> object that represents a collection of iSCSI attributes for one stored volume.</p> </li>   <li> <p> <code>VolumeProgress</code>: Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p> </li>   <li> <p> <code>VolumeSizeInBytes</code>: The size of the volume in bytes.</p> </li>   <li> <p> <code>VolumeStatus</code>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.</p> </li>   <li> <p> <code>VolumeType</code>: One of the enumeration values describing the type of the volume. Currently, only <code>STORED</code> volumes are supported.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeStorediSCSIVolumesError>`](crate::error::DescribeStorediSCSIVolumesError)
    pub fn describe_storedi_scsi_volumes(&self) -> fluent_builders::DescribeStorediSCSIVolumes {
        fluent_builders::DescribeStorediSCSIVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTapeArchives`](crate::client::fluent_builders::DescribeTapeArchives) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTapeArchives::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`tape_ar_ns(Vec<String>)`](crate::client::fluent_builders::DescribeTapeArchives::tape_ar_ns) / [`set_tape_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTapeArchives::set_tape_ar_ns): <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTapeArchives::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTapeArchives::set_marker): <p>An opaque string that indicates the position at which to begin describing virtual tapes.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeTapeArchives::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeTapeArchives::set_limit): <p>Specifies that the number of virtual tapes described be limited to the specified number.</p>
    /// - On success, responds with [`DescribeTapeArchivesOutput`](crate::output::DescribeTapeArchivesOutput) with field(s):
    ///   - [`tape_archives(Option<Vec<TapeArchive>>)`](crate::output::DescribeTapeArchivesOutput::tape_archives): <p>An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeTapeArchivesOutput::marker): <p>An opaque string that indicates the position at which the virtual tapes that were fetched for description ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.</p>
    /// - On failure, responds with [`SdkError<DescribeTapeArchivesError>`](crate::error::DescribeTapeArchivesError)
    pub fn describe_tape_archives(&self) -> fluent_builders::DescribeTapeArchives {
        fluent_builders::DescribeTapeArchives::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTapeRecoveryPoints`](crate::client::fluent_builders::DescribeTapeRecoveryPoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTapeRecoveryPoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTapeRecoveryPoints::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeTapeRecoveryPoints::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTapeRecoveryPoints::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTapeRecoveryPoints::set_marker): <p>An opaque string that indicates the position at which to begin describing the virtual tape recovery points.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeTapeRecoveryPoints::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeTapeRecoveryPoints::set_limit): <p>Specifies that the number of virtual tape recovery points that are described be limited to the specified number.</p>
    /// - On success, responds with [`DescribeTapeRecoveryPointsOutput`](crate::output::DescribeTapeRecoveryPointsOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeTapeRecoveryPointsOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`tape_recovery_point_infos(Option<Vec<TapeRecoveryPointInfo>>)`](crate::output::DescribeTapeRecoveryPointsOutput::tape_recovery_point_infos): <p>An array of TapeRecoveryPointInfos that are available for the specified gateway.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeTapeRecoveryPointsOutput::marker): <p>An opaque string that indicates the position at which the virtual tape recovery points that were listed for description ended.</p>  <p>Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there are no more recovery points to describe, this field does not appear in the response.</p>
    /// - On failure, responds with [`SdkError<DescribeTapeRecoveryPointsError>`](crate::error::DescribeTapeRecoveryPointsError)
    pub fn describe_tape_recovery_points(&self) -> fluent_builders::DescribeTapeRecoveryPoints {
        fluent_builders::DescribeTapeRecoveryPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTapes`](crate::client::fluent_builders::DescribeTapes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTapes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTapes::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeTapes::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`tape_ar_ns(Vec<String>)`](crate::client::fluent_builders::DescribeTapes::tape_ar_ns) / [`set_tape_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTapes::set_tape_ar_ns): <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes associated with the specified gateway.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTapes::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTapes::set_marker): <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which page of results to retrieve.</p>  <p>If not specified, the first page of results is retrieved.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeTapes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeTapes::set_limit): <p>Specifies that the number of virtual tapes described be limited to the specified number.</p> <note>   <p>Amazon Web Services may impose its own limit, if this field is not set.</p>  </note>
    /// - On success, responds with [`DescribeTapesOutput`](crate::output::DescribeTapesOutput) with field(s):
    ///   - [`tapes(Option<Vec<Tape>>)`](crate::output::DescribeTapesOutput::tapes): <p>An array of virtual tape descriptions.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeTapesOutput::marker): <p>An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the next page of results.</p>  <p>If a response does not contain a marker, then there are no more results to be retrieved.</p>
    /// - On failure, responds with [`SdkError<DescribeTapesError>`](crate::error::DescribeTapesError)
    pub fn describe_tapes(&self) -> fluent_builders::DescribeTapes {
        fluent_builders::DescribeTapes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUploadBuffer`](crate::client::fluent_builders::DescribeUploadBuffer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeUploadBuffer::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeUploadBuffer::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeUploadBufferOutput`](crate::output::DescribeUploadBufferOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeUploadBufferOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disk_ids(Option<Vec<String>>)`](crate::output::DescribeUploadBufferOutput::disk_ids): <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
    ///   - [`upload_buffer_used_in_bytes(i64)`](crate::output::DescribeUploadBufferOutput::upload_buffer_used_in_bytes): <p>The total number of bytes being used in the gateway's upload buffer.</p>
    ///   - [`upload_buffer_allocated_in_bytes(i64)`](crate::output::DescribeUploadBufferOutput::upload_buffer_allocated_in_bytes): <p>The total number of bytes allocated in the gateway's as upload buffer.</p>
    /// - On failure, responds with [`SdkError<DescribeUploadBufferError>`](crate::error::DescribeUploadBufferError)
    pub fn describe_upload_buffer(&self) -> fluent_builders::DescribeUploadBuffer {
        fluent_builders::DescribeUploadBuffer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVTLDevices`](crate::client::fluent_builders::DescribeVTLDevices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeVTLDevices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeVTLDevices::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeVTLDevices::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`vtl_device_ar_ns(Vec<String>)`](crate::client::fluent_builders::DescribeVTLDevices::vtl_device_ar_ns) / [`set_vtl_device_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeVTLDevices::set_vtl_device_ar_ns): <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p> <note>   <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result will contain all devices on the specified gateway.</p>  </note>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeVTLDevices::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeVTLDevices::set_marker): <p>An opaque string that indicates the position at which to begin describing the VTL devices.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeVTLDevices::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeVTLDevices::set_limit): <p>Specifies that the number of VTL devices described be limited to the specified number.</p>
    /// - On success, responds with [`DescribeVtlDevicesOutput`](crate::output::DescribeVtlDevicesOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeVtlDevicesOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`vtl_devices(Option<Vec<VtlDevice>>)`](crate::output::DescribeVtlDevicesOutput::vtl_devices): <p>An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeVtlDevicesOutput::marker): <p>An opaque string that indicates the position at which the VTL devices that were fetched for description ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL devices to describe, this field does not appear in the response.</p>
    /// - On failure, responds with [`SdkError<DescribeVTLDevicesError>`](crate::error::DescribeVTLDevicesError)
    pub fn describe_vtl_devices(&self) -> fluent_builders::DescribeVTLDevices {
        fluent_builders::DescribeVTLDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkingStorage`](crate::client::fluent_builders::DescribeWorkingStorage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkingStorage::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DescribeWorkingStorage::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DescribeWorkingStorageOutput`](crate::output::DescribeWorkingStorageOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeWorkingStorageOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disk_ids(Option<Vec<String>>)`](crate::output::DescribeWorkingStorageOutput::disk_ids): <p>An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>
    ///   - [`working_storage_used_in_bytes(i64)`](crate::output::DescribeWorkingStorageOutput::working_storage_used_in_bytes): <p>The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
    ///   - [`working_storage_allocated_in_bytes(i64)`](crate::output::DescribeWorkingStorageOutput::working_storage_allocated_in_bytes): <p>The total working storage in bytes allocated for the gateway. If no working storage is configured for the gateway, this field returns 0.</p>
    /// - On failure, responds with [`SdkError<DescribeWorkingStorageError>`](crate::error::DescribeWorkingStorageError)
    pub fn describe_working_storage(&self) -> fluent_builders::DescribeWorkingStorage {
        fluent_builders::DescribeWorkingStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachVolume`](crate::client::fluent_builders::DetachVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::DetachVolume::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::DetachVolume::set_volume_arn): <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
    ///   - [`force_detach(bool)`](crate::client::fluent_builders::DetachVolume::force_detach) / [`set_force_detach(Option<bool>)`](crate::client::fluent_builders::DetachVolume::set_force_detach): <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the volume. The default is <code>false</code>. If this value is set to <code>false</code>, you must manually disconnect the iSCSI connection from the target volume.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    /// - On success, responds with [`DetachVolumeOutput`](crate::output::DetachVolumeOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::DetachVolumeOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the volume that was detached.</p>
    /// - On failure, responds with [`SdkError<DetachVolumeError>`](crate::error::DetachVolumeError)
    pub fn detach_volume(&self) -> fluent_builders::DetachVolume {
        fluent_builders::DetachVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableGateway`](crate::client::fluent_builders::DisableGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DisableGateway::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DisableGateway::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DisableGatewayOutput`](crate::output::DisableGatewayOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DisableGatewayOutput::gateway_arn): <p>The unique Amazon Resource Name (ARN) of the disabled gateway.</p>
    /// - On failure, responds with [`SdkError<DisableGatewayError>`](crate::error::DisableGatewayError)
    pub fn disable_gateway(&self) -> fluent_builders::DisableGateway {
        fluent_builders::DisableGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFileSystem`](crate::client::fluent_builders::DisassociateFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_association_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateFileSystem::file_system_association_arn) / [`set_file_system_association_arn(Option<String>)`](crate::client::fluent_builders::DisassociateFileSystem::set_file_system_association_arn): <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::DisassociateFileSystem::force_delete) / [`set_force_delete(bool)`](crate::client::fluent_builders::DisassociateFileSystem::set_force_delete): <p>If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends all data uploads to the file system, and the file system association enters the <code>FORCE_DELETING</code> status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.</p>
    /// - On success, responds with [`DisassociateFileSystemOutput`](crate::output::DisassociateFileSystemOutput) with field(s):
    ///   - [`file_system_association_arn(Option<String>)`](crate::output::DisassociateFileSystemOutput::file_system_association_arn): <p>The Amazon Resource Name (ARN) of the deleted file system association.</p>
    /// - On failure, responds with [`SdkError<DisassociateFileSystemError>`](crate::error::DisassociateFileSystemError)
    pub fn disassociate_file_system(&self) -> fluent_builders::DisassociateFileSystem {
        fluent_builders::DisassociateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`JoinDomain`](crate::client::fluent_builders::JoinDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::JoinDomain::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::JoinDomain::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::JoinDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::JoinDomain::set_domain_name): <p>The name of the domain that you want the gateway to join.</p>
    ///   - [`organizational_unit(impl Into<String>)`](crate::client::fluent_builders::JoinDomain::organizational_unit) / [`set_organizational_unit(Option<String>)`](crate::client::fluent_builders::JoinDomain::set_organizational_unit): <p>The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.</p>
    ///   - [`domain_controllers(Vec<String>)`](crate::client::fluent_builders::JoinDomain::domain_controllers) / [`set_domain_controllers(Option<Vec<String>>)`](crate::client::fluent_builders::JoinDomain::set_domain_controllers): <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.</p>
    ///   - [`timeout_in_seconds(i32)`](crate::client::fluent_builders::JoinDomain::timeout_in_seconds) / [`set_timeout_in_seconds(Option<i32>)`](crate::client::fluent_builders::JoinDomain::set_timeout_in_seconds): <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is 20 seconds.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::JoinDomain::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::JoinDomain::set_user_name): <p>Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user account should be enabled to join computers to the domain. For example, you can use the domain administrator account or an account with delegated permissions to join computers to the domain.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::JoinDomain::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::JoinDomain::set_password): <p>Sets the password of the user who has permission to add the gateway to the Active Directory domain.</p>
    /// - On success, responds with [`JoinDomainOutput`](crate::output::JoinDomainOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::JoinDomainOutput::gateway_arn): <p>The unique Amazon Resource Name (ARN) of the gateway that joined the domain.</p>
    ///   - [`active_directory_status(Option<ActiveDirectoryStatus>)`](crate::output::JoinDomainOutput::active_directory_status): <p>Indicates the status of the gateway as a member of the Active Directory domain.</p>  <ul>   <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li>   <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li>   <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li>   <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li>   <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li>   <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within the allotted time.</p> </li>   <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<JoinDomainError>`](crate::error::JoinDomainError)
    pub fn join_domain(&self) -> fluent_builders::JoinDomain {
        fluent_builders::JoinDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAutomaticTapeCreationPolicies`](crate::client::fluent_builders::ListAutomaticTapeCreationPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ListAutomaticTapeCreationPolicies::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ListAutomaticTapeCreationPolicies::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`ListAutomaticTapeCreationPoliciesOutput`](crate::output::ListAutomaticTapeCreationPoliciesOutput) with field(s):
    ///   - [`automatic_tape_creation_policy_infos(Option<Vec<AutomaticTapeCreationPolicyInfo>>)`](crate::output::ListAutomaticTapeCreationPoliciesOutput::automatic_tape_creation_policy_infos): <p>Gets a listing of information about the gateway's automatic tape creation policies, including the automatic tape creation rules and the gateway that is using the policies.</p>
    /// - On failure, responds with [`SdkError<ListAutomaticTapeCreationPoliciesError>`](crate::error::ListAutomaticTapeCreationPoliciesError)
    pub fn list_automatic_tape_creation_policies(
        &self,
    ) -> fluent_builders::ListAutomaticTapeCreationPolicies {
        fluent_builders::ListAutomaticTapeCreationPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFileShares`](crate::client::fluent_builders::ListFileShares) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFileShares::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ListFileShares::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ListFileShares::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If this field is not present, all file shares under your account are listed.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListFileShares::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListFileShares::set_limit): <p>The maximum number of file shares to return in the response. The value must be an integer with a value greater than zero. Optional.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFileShares::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFileShares::set_marker): <p>Opaque pagination token returned from a previous ListFileShares operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to ListFileShares. Optional.</p>
    /// - On success, responds with [`ListFileSharesOutput`](crate::output::ListFileSharesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::ListFileSharesOutput::marker): <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListFileSharesOutput::next_marker): <p>If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.</p>
    ///   - [`file_share_info_list(Option<Vec<FileShareInfo>>)`](crate::output::ListFileSharesOutput::file_share_info_list): <p>An array of information about the S3 File Gateway's file shares.</p>
    /// - On failure, responds with [`SdkError<ListFileSharesError>`](crate::error::ListFileSharesError)
    pub fn list_file_shares(&self) -> fluent_builders::ListFileShares {
        fluent_builders::ListFileShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFileSystemAssociations`](crate::client::fluent_builders::ListFileSystemAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFileSystemAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ListFileSystemAssociations::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ListFileSystemAssociations::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListFileSystemAssociations::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListFileSystemAssociations::set_limit): <p>The maximum number of file system associations to return in the response. If present, <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFileSystemAssociations::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFileSystemAssociations::set_marker): <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code> operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
    /// - On success, responds with [`ListFileSystemAssociationsOutput`](crate::output::ListFileSystemAssociationsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::ListFileSystemAssociationsOutput::marker): <p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListFileSystemAssociationsOutput::next_marker): <p>If a value is present, there are more file system associations to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system associations.</p>
    ///   - [`file_system_association_summary_list(Option<Vec<FileSystemAssociationSummary>>)`](crate::output::ListFileSystemAssociationsOutput::file_system_association_summary_list): <p>An array of information about the Amazon FSx gateway's file system associations.</p>
    /// - On failure, responds with [`SdkError<ListFileSystemAssociationsError>`](crate::error::ListFileSystemAssociationsError)
    pub fn list_file_system_associations(&self) -> fluent_builders::ListFileSystemAssociations {
        fluent_builders::ListFileSystemAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGateways`](crate::client::fluent_builders::ListGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListGateways::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListGateways::set_marker): <p>An opaque string that indicates the position at which to begin the returned list of gateways.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListGateways::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListGateways::set_limit): <p>Specifies that the list of gateways returned be limited to the specified number of items.</p>
    /// - On success, responds with [`ListGatewaysOutput`](crate::output::ListGatewaysOutput) with field(s):
    ///   - [`gateways(Option<Vec<GatewayInfo>>)`](crate::output::ListGatewaysOutput::gateways): <p>An array of <code>GatewayInfo</code> objects.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListGatewaysOutput::marker): <p>Use the marker in your next request to fetch the next set of gateways in the list. If there are no more gateways to list, this field does not appear in the response.</p>
    /// - On failure, responds with [`SdkError<ListGatewaysError>`](crate::error::ListGatewaysError)
    pub fn list_gateways(&self) -> fluent_builders::ListGateways {
        fluent_builders::ListGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLocalDisks`](crate::client::fluent_builders::ListLocalDisks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ListLocalDisks::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ListLocalDisks::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`ListLocalDisksOutput`](crate::output::ListLocalDisksOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::ListLocalDisksOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`disks(Option<Vec<Disk>>)`](crate::output::ListLocalDisksOutput::disks): <p>A JSON object containing the following fields:</p>  <ul>   <li> <p> <code>ListLocalDisksOutput$Disks</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ListLocalDisksError>`](crate::error::ListLocalDisksError)
    pub fn list_local_disks(&self) -> fluent_builders::ListLocalDisks {
        fluent_builders::ListLocalDisks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_marker): <p>An opaque string that indicates the position at which to begin returning the list of tags.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTagsForResource::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_limit): <p>Specifies that the list of tags returned be limited to the specified number of items.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::ListTagsForResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListTagsForResourceOutput::marker): <p>An opaque string that indicates the position at which to stop returning the list of tags.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array that contains the tags for the specified resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTapePools`](crate::client::fluent_builders::ListTapePools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTapePools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_ar_ns(Vec<String>)`](crate::client::fluent_builders::ListTapePools::pool_ar_ns) / [`set_pool_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::ListTapePools::set_pool_ar_ns): <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListTapePools::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListTapePools::set_marker): <p>A string that indicates the position at which to begin the returned list of tape pools.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTapePools::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTapePools::set_limit): <p>An optional number limit for the tape pools in the list returned by this call.</p>
    /// - On success, responds with [`ListTapePoolsOutput`](crate::output::ListTapePoolsOutput) with field(s):
    ///   - [`pool_infos(Option<Vec<PoolInfo>>)`](crate::output::ListTapePoolsOutput::pool_infos): <p>An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no custom tape pools, the <code>PoolInfos</code> is an empty array. </p>
    ///   - [`marker(Option<String>)`](crate::output::ListTapePoolsOutput::marker): <p>A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not appear in the response body. </p>
    /// - On failure, responds with [`SdkError<ListTapePoolsError>`](crate::error::ListTapePoolsError)
    pub fn list_tape_pools(&self) -> fluent_builders::ListTapePools {
        fluent_builders::ListTapePools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTapes`](crate::client::fluent_builders::ListTapes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTapes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`tape_ar_ns(Vec<String>)`](crate::client::fluent_builders::ListTapes::tape_ar_ns) / [`set_tape_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::ListTapes::set_tape_ar_ns): <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListTapes::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListTapes::set_marker): <p>A string that indicates the position at which to begin the returned list of tapes.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTapes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTapes::set_limit): <p>An optional number limit for the tapes in the list returned by this call.</p>
    /// - On success, responds with [`ListTapesOutput`](crate::output::ListTapesOutput) with field(s):
    ///   - [`tape_infos(Option<Vec<TapeInfo>>)`](crate::output::ListTapesOutput::tape_infos): <p>An array of <code>TapeInfo</code> objects, where each object describes a single tape. If there are no tapes in the tape library or VTS, then the <code>TapeInfos</code> is an empty array.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListTapesOutput::marker): <p>A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in the response body.</p>
    /// - On failure, responds with [`SdkError<ListTapesError>`](crate::error::ListTapesError)
    pub fn list_tapes(&self) -> fluent_builders::ListTapes {
        fluent_builders::ListTapes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVolumeInitiators`](crate::client::fluent_builders::ListVolumeInitiators) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::ListVolumeInitiators::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::ListVolumeInitiators::set_volume_arn): <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes for the gateway.</p>
    /// - On success, responds with [`ListVolumeInitiatorsOutput`](crate::output::ListVolumeInitiatorsOutput) with field(s):
    ///   - [`initiators(Option<Vec<String>>)`](crate::output::ListVolumeInitiatorsOutput::initiators): <p>The host names and port numbers of all iSCSI initiators that are connected to the gateway.</p>
    /// - On failure, responds with [`SdkError<ListVolumeInitiatorsError>`](crate::error::ListVolumeInitiatorsError)
    pub fn list_volume_initiators(&self) -> fluent_builders::ListVolumeInitiators {
        fluent_builders::ListVolumeInitiators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVolumeRecoveryPoints`](crate::client::fluent_builders::ListVolumeRecoveryPoints) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ListVolumeRecoveryPoints::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ListVolumeRecoveryPoints::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`ListVolumeRecoveryPointsOutput`](crate::output::ListVolumeRecoveryPointsOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::ListVolumeRecoveryPointsOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`volume_recovery_point_infos(Option<Vec<VolumeRecoveryPointInfo>>)`](crate::output::ListVolumeRecoveryPointsOutput::volume_recovery_point_infos): <p>An array of <code>VolumeRecoveryPointInfo</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListVolumeRecoveryPointsError>`](crate::error::ListVolumeRecoveryPointsError)
    pub fn list_volume_recovery_points(&self) -> fluent_builders::ListVolumeRecoveryPoints {
        fluent_builders::ListVolumeRecoveryPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVolumes`](crate::client::fluent_builders::ListVolumes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVolumes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ListVolumes::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ListVolumes::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListVolumes::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListVolumes::set_marker): <p>A string that indicates the position at which to begin the returned list of volumes. Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListVolumes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListVolumes::set_limit): <p>Specifies that the list of volumes returned be limited to the specified number of items.</p>
    /// - On success, responds with [`ListVolumesOutput`](crate::output::ListVolumesOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::ListVolumesOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListVolumesOutput::marker): <p>Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to list, this field does not appear in the response body.</p>
    ///   - [`volume_infos(Option<Vec<VolumeInfo>>)`](crate::output::ListVolumesOutput::volume_infos): <p>An array of <code>VolumeInfo</code> objects, where each object describes an iSCSI volume. If no volumes are defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".</p>
    /// - On failure, responds with [`SdkError<ListVolumesError>`](crate::error::ListVolumesError)
    pub fn list_volumes(&self) -> fluent_builders::ListVolumes {
        fluent_builders::ListVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`NotifyWhenUploaded`](crate::client::fluent_builders::NotifyWhenUploaded) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_share_arn(impl Into<String>)`](crate::client::fluent_builders::NotifyWhenUploaded::file_share_arn) / [`set_file_share_arn(Option<String>)`](crate::client::fluent_builders::NotifyWhenUploaded::set_file_share_arn): <p>The Amazon Resource Name (ARN) of the file share.</p>
    /// - On success, responds with [`NotifyWhenUploadedOutput`](crate::output::NotifyWhenUploadedOutput) with field(s):
    ///   - [`file_share_arn(Option<String>)`](crate::output::NotifyWhenUploadedOutput::file_share_arn): <p>The Amazon Resource Name (ARN) of the file share.</p>
    ///   - [`notification_id(Option<String>)`](crate::output::NotifyWhenUploadedOutput::notification_id): <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
    /// - On failure, responds with [`SdkError<NotifyWhenUploadedError>`](crate::error::NotifyWhenUploadedError)
    pub fn notify_when_uploaded(&self) -> fluent_builders::NotifyWhenUploaded {
        fluent_builders::NotifyWhenUploaded::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RefreshCache`](crate::client::fluent_builders::RefreshCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_share_arn(impl Into<String>)`](crate::client::fluent_builders::RefreshCache::file_share_arn) / [`set_file_share_arn(Option<String>)`](crate::client::fluent_builders::RefreshCache::set_file_share_arn): <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
    ///   - [`folder_list(Vec<String>)`](crate::client::fluent_builders::RefreshCache::folder_list) / [`set_folder_list(Option<Vec<String>>)`](crate::client::fluent_builders::RefreshCache::set_folder_list): <p>A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3 bucket that the file share has access to is refreshed.</p>
    ///   - [`recursive(bool)`](crate::client::fluent_builders::RefreshCache::recursive) / [`set_recursive(Option<bool>)`](crate::client::fluent_builders::RefreshCache::set_recursive): <p>A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that were in the cache the last time the gateway listed the folder's contents. If this value set to <code>true</code>, each folder that is listed in <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in <code>FolderList</code> are not refreshed. Only objects that are in folders listed directly under <code>FolderList</code> are found and used for the update. The default is <code>true</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    /// - On success, responds with [`RefreshCacheOutput`](crate::output::RefreshCacheOutput) with field(s):
    ///   - [`file_share_arn(Option<String>)`](crate::output::RefreshCacheOutput::file_share_arn): <p>The Amazon Resource Name (ARN) of the file share.</p>
    ///   - [`notification_id(Option<String>)`](crate::output::RefreshCacheOutput::notification_id): <p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>
    /// - On failure, responds with [`SdkError<RefreshCacheError>`](crate::error::RefreshCacheError)
    pub fn refresh_cache(&self) -> fluent_builders::RefreshCache {
        fluent_builders::RefreshCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_keys): <p>The keys of the tags you want to remove from the specified resource. A tag is composed of a key-value pair.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::RemoveTagsFromResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the resource that the tags were removed from.</p>
    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetCache`](crate::client::fluent_builders::ResetCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ResetCache::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ResetCache::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`ResetCacheOutput`](crate::output::ResetCacheOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::ResetCacheOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<ResetCacheError>`](crate::error::ResetCacheError)
    pub fn reset_cache(&self) -> fluent_builders::ResetCache {
        fluent_builders::ResetCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetrieveTapeArchive`](crate::client::fluent_builders::RetrieveTapeArchive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tape_arn(impl Into<String>)`](crate::client::fluent_builders::RetrieveTapeArchive::tape_arn) / [`set_tape_arn(Option<String>)`](crate::client::fluent_builders::RetrieveTapeArchive::set_tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).</p>
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::RetrieveTapeArchive::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::RetrieveTapeArchive::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>  <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.</p>
    /// - On success, responds with [`RetrieveTapeArchiveOutput`](crate::output::RetrieveTapeArchiveOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::RetrieveTapeArchiveOutput::tape_arn): <p>The Amazon Resource Name (ARN) of the retrieved virtual tape.</p>
    /// - On failure, responds with [`SdkError<RetrieveTapeArchiveError>`](crate::error::RetrieveTapeArchiveError)
    pub fn retrieve_tape_archive(&self) -> fluent_builders::RetrieveTapeArchive {
        fluent_builders::RetrieveTapeArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetrieveTapeRecoveryPoint`](crate::client::fluent_builders::RetrieveTapeRecoveryPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tape_arn(impl Into<String>)`](crate::client::fluent_builders::RetrieveTapeRecoveryPoint::tape_arn) / [`set_tape_arn(Option<String>)`](crate::client::fluent_builders::RetrieveTapeRecoveryPoint::set_tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the recovery point.</p>
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::RetrieveTapeRecoveryPoint::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::RetrieveTapeRecoveryPoint::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`RetrieveTapeRecoveryPointOutput`](crate::output::RetrieveTapeRecoveryPointOutput) with field(s):
    ///   - [`tape_arn(Option<String>)`](crate::output::RetrieveTapeRecoveryPointOutput::tape_arn): <p>The Amazon Resource Name (ARN) of the virtual tape for which the recovery point was retrieved.</p>
    /// - On failure, responds with [`SdkError<RetrieveTapeRecoveryPointError>`](crate::error::RetrieveTapeRecoveryPointError)
    pub fn retrieve_tape_recovery_point(&self) -> fluent_builders::RetrieveTapeRecoveryPoint {
        fluent_builders::RetrieveTapeRecoveryPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetLocalConsolePassword`](crate::client::fluent_builders::SetLocalConsolePassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::SetLocalConsolePassword::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::SetLocalConsolePassword::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`local_console_password(impl Into<String>)`](crate::client::fluent_builders::SetLocalConsolePassword::local_console_password) / [`set_local_console_password(Option<String>)`](crate::client::fluent_builders::SetLocalConsolePassword::set_local_console_password): <p>The password you want to set for your VM local console.</p>
    /// - On success, responds with [`SetLocalConsolePasswordOutput`](crate::output::SetLocalConsolePasswordOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::SetLocalConsolePasswordOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<SetLocalConsolePasswordError>`](crate::error::SetLocalConsolePasswordError)
    pub fn set_local_console_password(&self) -> fluent_builders::SetLocalConsolePassword {
        fluent_builders::SetLocalConsolePassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetSMBGuestPassword`](crate::client::fluent_builders::SetSMBGuestPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::SetSMBGuestPassword::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::SetSMBGuestPassword::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::SetSMBGuestPassword::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::SetSMBGuestPassword::set_password): <p>The password that you want to set for your SMB server.</p>
    /// - On success, responds with [`SetSmbGuestPasswordOutput`](crate::output::SetSmbGuestPasswordOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::SetSmbGuestPasswordOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<SetSMBGuestPasswordError>`](crate::error::SetSMBGuestPasswordError)
    pub fn set_smb_guest_password(&self) -> fluent_builders::SetSMBGuestPassword {
        fluent_builders::SetSMBGuestPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ShutdownGateway`](crate::client::fluent_builders::ShutdownGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::ShutdownGateway::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::ShutdownGateway::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`ShutdownGatewayOutput`](crate::output::ShutdownGatewayOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::ShutdownGatewayOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<ShutdownGatewayError>`](crate::error::ShutdownGatewayError)
    pub fn shutdown_gateway(&self) -> fluent_builders::ShutdownGateway {
        fluent_builders::ShutdownGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAvailabilityMonitorTest`](crate::client::fluent_builders::StartAvailabilityMonitorTest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::StartAvailabilityMonitorTest::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::StartAvailabilityMonitorTest::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`StartAvailabilityMonitorTestOutput`](crate::output::StartAvailabilityMonitorTestOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::StartAvailabilityMonitorTestOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<StartAvailabilityMonitorTestError>`](crate::error::StartAvailabilityMonitorTestError)
    pub fn start_availability_monitor_test(&self) -> fluent_builders::StartAvailabilityMonitorTest {
        fluent_builders::StartAvailabilityMonitorTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartGateway`](crate::client::fluent_builders::StartGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::StartGateway::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::StartGateway::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`StartGatewayOutput`](crate::output::StartGatewayOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::StartGatewayOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<StartGatewayError>`](crate::error::StartGatewayError)
    pub fn start_gateway(&self) -> fluent_builders::StartGateway {
        fluent_builders::StartGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAutomaticTapeCreationPolicy`](crate::client::fluent_builders::UpdateAutomaticTapeCreationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`automatic_tape_creation_rules(Vec<AutomaticTapeCreationRule>)`](crate::client::fluent_builders::UpdateAutomaticTapeCreationPolicy::automatic_tape_creation_rules) / [`set_automatic_tape_creation_rules(Option<Vec<AutomaticTapeCreationRule>>)`](crate::client::fluent_builders::UpdateAutomaticTapeCreationPolicy::set_automatic_tape_creation_rules): <p>An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine when and how to automatically create new tapes.</p>
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAutomaticTapeCreationPolicy::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateAutomaticTapeCreationPolicy::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`UpdateAutomaticTapeCreationPolicyOutput`](crate::output::UpdateAutomaticTapeCreationPolicyOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateAutomaticTapeCreationPolicyOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateAutomaticTapeCreationPolicyError>`](crate::error::UpdateAutomaticTapeCreationPolicyError)
    pub fn update_automatic_tape_creation_policy(
        &self,
    ) -> fluent_builders::UpdateAutomaticTapeCreationPolicy {
        fluent_builders::UpdateAutomaticTapeCreationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBandwidthRateLimit`](crate::client::fluent_builders::UpdateBandwidthRateLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateBandwidthRateLimit::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateBandwidthRateLimit::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`average_upload_rate_limit_in_bits_per_sec(i64)`](crate::client::fluent_builders::UpdateBandwidthRateLimit::average_upload_rate_limit_in_bits_per_sec) / [`set_average_upload_rate_limit_in_bits_per_sec(Option<i64>)`](crate::client::fluent_builders::UpdateBandwidthRateLimit::set_average_upload_rate_limit_in_bits_per_sec): <p>The average upload bandwidth rate limit in bits per second.</p>
    ///   - [`average_download_rate_limit_in_bits_per_sec(i64)`](crate::client::fluent_builders::UpdateBandwidthRateLimit::average_download_rate_limit_in_bits_per_sec) / [`set_average_download_rate_limit_in_bits_per_sec(Option<i64>)`](crate::client::fluent_builders::UpdateBandwidthRateLimit::set_average_download_rate_limit_in_bits_per_sec): <p>The average download bandwidth rate limit in bits per second.</p>
    /// - On success, responds with [`UpdateBandwidthRateLimitOutput`](crate::output::UpdateBandwidthRateLimitOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateBandwidthRateLimitOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateBandwidthRateLimitError>`](crate::error::UpdateBandwidthRateLimitError)
    pub fn update_bandwidth_rate_limit(&self) -> fluent_builders::UpdateBandwidthRateLimit {
        fluent_builders::UpdateBandwidthRateLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBandwidthRateLimitSchedule`](crate::client::fluent_builders::UpdateBandwidthRateLimitSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateBandwidthRateLimitSchedule::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateBandwidthRateLimitSchedule::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`bandwidth_rate_limit_intervals(Vec<BandwidthRateLimitInterval>)`](crate::client::fluent_builders::UpdateBandwidthRateLimitSchedule::bandwidth_rate_limit_intervals) / [`set_bandwidth_rate_limit_intervals(Option<Vec<BandwidthRateLimitInterval>>)`](crate::client::fluent_builders::UpdateBandwidthRateLimitSchedule::set_bandwidth_rate_limit_intervals): <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the array is empty. </p>
    /// - On success, responds with [`UpdateBandwidthRateLimitScheduleOutput`](crate::output::UpdateBandwidthRateLimitScheduleOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateBandwidthRateLimitScheduleOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateBandwidthRateLimitScheduleError>`](crate::error::UpdateBandwidthRateLimitScheduleError)
    pub fn update_bandwidth_rate_limit_schedule(
        &self,
    ) -> fluent_builders::UpdateBandwidthRateLimitSchedule {
        fluent_builders::UpdateBandwidthRateLimitSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChapCredentials`](crate::client::fluent_builders::UpdateChapCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChapCredentials::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::UpdateChapCredentials::set_target_arn): <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return the TargetARN for specified VolumeARN.</p>
    ///   - [`secret_to_authenticate_initiator(impl Into<String>)`](crate::client::fluent_builders::UpdateChapCredentials::secret_to_authenticate_initiator) / [`set_secret_to_authenticate_initiator(Option<String>)`](crate::client::fluent_builders::UpdateChapCredentials::set_secret_to_authenticate_initiator): <p>The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> <note>   <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>  </note>
    ///   - [`initiator_name(impl Into<String>)`](crate::client::fluent_builders::UpdateChapCredentials::initiator_name) / [`set_initiator_name(Option<String>)`](crate::client::fluent_builders::UpdateChapCredentials::set_initiator_name): <p>The iSCSI initiator that connects to the target.</p>
    ///   - [`secret_to_authenticate_target(impl Into<String>)`](crate::client::fluent_builders::UpdateChapCredentials::secret_to_authenticate_target) / [`set_secret_to_authenticate_target(Option<String>)`](crate::client::fluent_builders::UpdateChapCredentials::set_secret_to_authenticate_target): <p>The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p>  <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p> <note>   <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>  </note>
    /// - On success, responds with [`UpdateChapCredentialsOutput`](crate::output::UpdateChapCredentialsOutput) with field(s):
    ///   - [`target_arn(Option<String>)`](crate::output::UpdateChapCredentialsOutput::target_arn): <p>The Amazon Resource Name (ARN) of the target. This is the same target specified in the request.</p>
    ///   - [`initiator_name(Option<String>)`](crate::output::UpdateChapCredentialsOutput::initiator_name): <p>The iSCSI initiator that connects to the target. This is the same initiator name specified in the request.</p>
    /// - On failure, responds with [`SdkError<UpdateChapCredentialsError>`](crate::error::UpdateChapCredentialsError)
    pub fn update_chap_credentials(&self) -> fluent_builders::UpdateChapCredentials {
        fluent_builders::UpdateChapCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFileSystemAssociation`](crate::client::fluent_builders::UpdateFileSystemAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_association_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::file_system_association_arn) / [`set_file_system_association_arn(Option<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::set_file_system_association_arn): <p>The Amazon Resource Name (ARN) of the file system association that you want to update.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::set_user_name): <p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::set_password): <p>The password of the user credential.</p>
    ///   - [`audit_destination_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::audit_destination_arn) / [`set_audit_destination_arn(Option<String>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::set_audit_destination_arn): <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
    ///   - [`cache_attributes(CacheAttributes)`](crate::client::fluent_builders::UpdateFileSystemAssociation::cache_attributes) / [`set_cache_attributes(Option<CacheAttributes>)`](crate::client::fluent_builders::UpdateFileSystemAssociation::set_cache_attributes): <p>The refresh cache information for the file share or FSx file systems.</p>
    /// - On success, responds with [`UpdateFileSystemAssociationOutput`](crate::output::UpdateFileSystemAssociationOutput) with field(s):
    ///   - [`file_system_association_arn(Option<String>)`](crate::output::UpdateFileSystemAssociationOutput::file_system_association_arn): <p>The ARN of the updated file system association.</p>
    /// - On failure, responds with [`SdkError<UpdateFileSystemAssociationError>`](crate::error::UpdateFileSystemAssociationError)
    pub fn update_file_system_association(&self) -> fluent_builders::UpdateFileSystemAssociation {
        fluent_builders::UpdateFileSystemAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGatewayInformation`](crate::client::fluent_builders::UpdateGatewayInformation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`gateway_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::gateway_name) / [`set_gateway_name(Option<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::set_gateway_name): <p>The name you configured for your gateway.</p>
    ///   - [`gateway_timezone(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::gateway_timezone) / [`set_gateway_timezone(Option<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::set_gateway_timezone): <p>A value that indicates the time zone of the gateway.</p>
    ///   - [`cloud_watch_log_group_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::cloud_watch_log_group_arn) / [`set_cloud_watch_log_group_arn(Option<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::set_cloud_watch_log_group_arn): <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log events in the gateway.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch Logs?</a> </p>
    ///   - [`gateway_capacity(GatewayCapacity)`](crate::client::fluent_builders::UpdateGatewayInformation::gateway_capacity) / [`set_gateway_capacity(Option<GatewayCapacity>)`](crate::client::fluent_builders::UpdateGatewayInformation::set_gateway_capacity): <p>Specifies the size of the gateway's metadata cache.</p>
    /// - On success, responds with [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateGatewayInformationOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`gateway_name(Option<String>)`](crate::output::UpdateGatewayInformationOutput::gateway_name): <p>The name you configured for your gateway.</p>
    /// - On failure, responds with [`SdkError<UpdateGatewayInformationError>`](crate::error::UpdateGatewayInformationError)
    pub fn update_gateway_information(&self) -> fluent_builders::UpdateGatewayInformation {
        fluent_builders::UpdateGatewayInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGatewaySoftwareNow`](crate::client::fluent_builders::UpdateGatewaySoftwareNow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewaySoftwareNow::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateGatewaySoftwareNow::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`UpdateGatewaySoftwareNowOutput`](crate::output::UpdateGatewaySoftwareNowOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateGatewaySoftwareNowOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateGatewaySoftwareNowError>`](crate::error::UpdateGatewaySoftwareNowError)
    pub fn update_gateway_software_now(&self) -> fluent_builders::UpdateGatewaySoftwareNow {
        fluent_builders::UpdateGatewaySoftwareNow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMaintenanceStartTime`](crate::client::fluent_builders::UpdateMaintenanceStartTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`hour_of_day(i32)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::hour_of_day) / [`set_hour_of_day(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::set_hour_of_day): <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time zone of the gateway.</p>
    ///   - [`minute_of_hour(i32)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::minute_of_hour) / [`set_minute_of_hour(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::set_minute_of_hour): <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.</p>
    ///   - [`day_of_week(i32)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::day_of_week) / [`set_day_of_week(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::set_day_of_week): <p>The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
    ///   - [`day_of_month(i32)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::day_of_month) / [`set_day_of_month(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceStartTime::set_day_of_month): <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
    /// - On success, responds with [`UpdateMaintenanceStartTimeOutput`](crate::output::UpdateMaintenanceStartTimeOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateMaintenanceStartTimeOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateMaintenanceStartTimeError>`](crate::error::UpdateMaintenanceStartTimeError)
    pub fn update_maintenance_start_time(&self) -> fluent_builders::UpdateMaintenanceStartTime {
        fluent_builders::UpdateMaintenanceStartTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNFSFileShare`](crate::client::fluent_builders::UpdateNFSFileShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_share_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::file_share_arn) / [`set_file_share_arn(Option<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_file_share_arn): <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::UpdateNFSFileShare::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`nfs_file_share_defaults(NfsFileShareDefaults)`](crate::client::fluent_builders::UpdateNFSFileShare::nfs_file_share_defaults) / [`set_nfs_file_share_defaults(Option<NfsFileShareDefaults>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_nfs_file_share_defaults): <p>The default values for the file share. Optional.</p>
    ///   - [`default_storage_class(impl Into<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::default_storage_class) / [`set_default_storage_class(Option<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_default_storage_class): <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>  <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
    ///   - [`object_acl(ObjectAcl)`](crate::client::fluent_builders::UpdateNFSFileShare::object_acl) / [`set_object_acl(Option<ObjectAcl>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_object_acl): <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    ///   - [`client_list(Vec<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::client_list) / [`set_client_list(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_client_list): <p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>
    ///   - [`squash(impl Into<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::squash) / [`set_squash(Option<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_squash): <p>The user mapped to anonymous user.</p>  <p>Valid values are the following:</p>  <ul>   <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li>   <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li>   <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li>  </ul>
    ///   - [`read_only(bool)`](crate::client::fluent_builders::UpdateNFSFileShare::read_only) / [`set_read_only(Option<bool>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_read_only): <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`guess_mime_type_enabled(bool)`](crate::client::fluent_builders::UpdateNFSFileShare::guess_mime_type_enabled) / [`set_guess_mime_type_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_guess_mime_type_enabled): <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`requester_pays(bool)`](crate::client::fluent_builders::UpdateNFSFileShare::requester_pays) / [`set_requester_pays(Option<bool>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_requester_pays): <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>   <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>  </note>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`file_share_name(impl Into<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::file_share_name) / [`set_file_share_name(Option<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_file_share_name): <p>The name of the file share. Optional.</p> <note>   <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>  </note>
    ///   - [`cache_attributes(CacheAttributes)`](crate::client::fluent_builders::UpdateNFSFileShare::cache_attributes) / [`set_cache_attributes(Option<CacheAttributes>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_cache_attributes): <p>Specifies refresh cache information for the file share.</p>
    ///   - [`notification_policy(impl Into<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::notification_policy) / [`set_notification_policy(Option<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_notification_policy): <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>   <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>  </note>  <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>  <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>  <p>The following example sets <code>NotificationPolicy</code> off.</p>  <p> <code>{}</code> </p>
    ///   - [`audit_destination_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::audit_destination_arn) / [`set_audit_destination_arn(Option<String>)`](crate::client::fluent_builders::UpdateNFSFileShare::set_audit_destination_arn): <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    /// - On success, responds with [`UpdateNfsFileShareOutput`](crate::output::UpdateNfsFileShareOutput) with field(s):
    ///   - [`file_share_arn(Option<String>)`](crate::output::UpdateNfsFileShareOutput::file_share_arn): <p>The Amazon Resource Name (ARN) of the updated file share.</p>
    /// - On failure, responds with [`SdkError<UpdateNFSFileShareError>`](crate::error::UpdateNFSFileShareError)
    pub fn update_nfs_file_share(&self) -> fluent_builders::UpdateNFSFileShare {
        fluent_builders::UpdateNFSFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSMBFileShare`](crate::client::fluent_builders::UpdateSMBFileShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_share_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::file_share_arn) / [`set_file_share_arn(Option<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_file_share_arn): <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
    ///   - [`kms_encrypted(bool)`](crate::client::fluent_builders::UpdateSMBFileShare::kms_encrypted) / [`set_kms_encrypted(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_kms_encrypted): <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_kms_key): <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    ///   - [`default_storage_class(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::default_storage_class) / [`set_default_storage_class(Option<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_default_storage_class): <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>  <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
    ///   - [`object_acl(ObjectAcl)`](crate::client::fluent_builders::UpdateSMBFileShare::object_acl) / [`set_object_acl(Option<ObjectAcl>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_object_acl): <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    ///   - [`read_only(bool)`](crate::client::fluent_builders::UpdateSMBFileShare::read_only) / [`set_read_only(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_read_only): <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set write status to read-only, otherwise set to <code>false</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`guess_mime_type_enabled(bool)`](crate::client::fluent_builders::UpdateSMBFileShare::guess_mime_type_enabled) / [`set_guess_mime_type_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_guess_mime_type_enabled): <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`requester_pays(bool)`](crate::client::fluent_builders::UpdateSMBFileShare::requester_pays) / [`set_requester_pays(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_requester_pays): <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>   <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>  </note>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`smbacl_enabled(bool)`](crate::client::fluent_builders::UpdateSMBFileShare::smbacl_enabled) / [`set_smbacl_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_smbacl_enabled): <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`access_based_enumeration(bool)`](crate::client::fluent_builders::UpdateSMBFileShare::access_based_enumeration) / [`set_access_based_enumeration(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_access_based_enumeration): <p>The files and folders on this share will only be visible to users with read access.</p>
    ///   - [`admin_user_list(Vec<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::admin_user_list) / [`set_admin_user_list(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_admin_user_list): <p>A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
    ///   - [`valid_user_list(Vec<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::valid_user_list) / [`set_valid_user_list(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_valid_user_list): <p>A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
    ///   - [`invalid_user_list(Vec<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::invalid_user_list) / [`set_invalid_user_list(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_invalid_user_list): <p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
    ///   - [`audit_destination_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::audit_destination_arn) / [`set_audit_destination_arn(Option<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_audit_destination_arn): <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    ///   - [`case_sensitivity(CaseSensitivity)`](crate::client::fluent_builders::UpdateSMBFileShare::case_sensitivity) / [`set_case_sensitivity(Option<CaseSensitivity>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_case_sensitivity): <p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>
    ///   - [`file_share_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::file_share_name) / [`set_file_share_name(Option<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_file_share_name): <p>The name of the file share. Optional.</p> <note>   <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>  </note>
    ///   - [`cache_attributes(CacheAttributes)`](crate::client::fluent_builders::UpdateSMBFileShare::cache_attributes) / [`set_cache_attributes(Option<CacheAttributes>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_cache_attributes): <p>Specifies refresh cache information for the file share.</p>
    ///   - [`notification_policy(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::notification_policy) / [`set_notification_policy(Option<String>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_notification_policy): <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>   <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>  </note>  <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>  <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>  <p>The following example sets <code>NotificationPolicy</code> off.</p>  <p> <code>{}</code> </p>
    ///   - [`oplocks_enabled(bool)`](crate::client::fluent_builders::UpdateSMBFileShare::oplocks_enabled) / [`set_oplocks_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShare::set_oplocks_enabled): <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note>   <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p>  </note>  <p>Valid Values: <code>true</code> | <code>false</code> </p>
    /// - On success, responds with [`UpdateSmbFileShareOutput`](crate::output::UpdateSmbFileShareOutput) with field(s):
    ///   - [`file_share_arn(Option<String>)`](crate::output::UpdateSmbFileShareOutput::file_share_arn): <p>The Amazon Resource Name (ARN) of the updated SMB file share.</p>
    /// - On failure, responds with [`SdkError<UpdateSMBFileShareError>`](crate::error::UpdateSMBFileShareError)
    pub fn update_smb_file_share(&self) -> fluent_builders::UpdateSMBFileShare {
        fluent_builders::UpdateSMBFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSMBFileShareVisibility`](crate::client::fluent_builders::UpdateSMBFileShareVisibility) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBFileShareVisibility::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateSMBFileShareVisibility::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`file_shares_visible(bool)`](crate::client::fluent_builders::UpdateSMBFileShareVisibility::file_shares_visible) / [`set_file_shares_visible(Option<bool>)`](crate::client::fluent_builders::UpdateSMBFileShareVisibility::set_file_shares_visible): <p>The shares on this gateway appear when listing shares.</p>
    /// - On success, responds with [`UpdateSmbFileShareVisibilityOutput`](crate::output::UpdateSmbFileShareVisibilityOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateSmbFileShareVisibilityOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateSMBFileShareVisibilityError>`](crate::error::UpdateSMBFileShareVisibilityError)
    pub fn update_smb_file_share_visibility(
        &self,
    ) -> fluent_builders::UpdateSMBFileShareVisibility {
        fluent_builders::UpdateSMBFileShareVisibility::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSMBLocalGroups`](crate::client::fluent_builders::UpdateSMBLocalGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBLocalGroups::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateSMBLocalGroups::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`smb_local_groups(SmbLocalGroups)`](crate::client::fluent_builders::UpdateSMBLocalGroups::smb_local_groups) / [`set_smb_local_groups(Option<SmbLocalGroups>)`](crate::client::fluent_builders::UpdateSMBLocalGroups::set_smb_local_groups): <p>A list of Active Directory users and groups that you want to grant special permissions for SMB file shares on the gateway.</p>
    /// - On success, responds with [`UpdateSmbLocalGroupsOutput`](crate::output::UpdateSmbLocalGroupsOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateSmbLocalGroupsOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateSMBLocalGroupsError>`](crate::error::UpdateSMBLocalGroupsError)
    pub fn update_smb_local_groups(&self) -> fluent_builders::UpdateSMBLocalGroups {
        fluent_builders::UpdateSMBLocalGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSMBSecurityStrategy`](crate::client::fluent_builders::UpdateSMBSecurityStrategy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSMBSecurityStrategy::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateSMBSecurityStrategy::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`smb_security_strategy(SmbSecurityStrategy)`](crate::client::fluent_builders::UpdateSMBSecurityStrategy::smb_security_strategy) / [`set_smb_security_strategy(Option<SmbSecurityStrategy>)`](crate::client::fluent_builders::UpdateSMBSecurityStrategy::set_smb_security_strategy): <p>Specifies the type of security strategy.</p>  <p>ClientSpecified: if you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Supported only in S3 File Gateway.</p>  <p>MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p>  <p>MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p>
    /// - On success, responds with [`UpdateSmbSecurityStrategyOutput`](crate::output::UpdateSmbSecurityStrategyOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateSmbSecurityStrategyOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<UpdateSMBSecurityStrategyError>`](crate::error::UpdateSMBSecurityStrategyError)
    pub fn update_smb_security_strategy(&self) -> fluent_builders::UpdateSMBSecurityStrategy {
        fluent_builders::UpdateSMBSecurityStrategy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSnapshotSchedule`](crate::client::fluent_builders::UpdateSnapshotSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::volume_arn) / [`set_volume_arn(Option<String>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::set_volume_arn): <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
    ///   - [`start_at(i32)`](crate::client::fluent_builders::UpdateSnapshotSchedule::start_at) / [`set_start_at(Option<i32>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::set_start_at): <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
    ///   - [`recurrence_in_hours(i32)`](crate::client::fluent_builders::UpdateSnapshotSchedule::recurrence_in_hours) / [`set_recurrence_in_hours(Option<i32>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::set_recurrence_in_hours): <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::set_description): <p>Optional description of the snapshot that overwrites the existing description.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateSnapshotSchedule::set_tags): <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>  </note>
    /// - On success, responds with [`UpdateSnapshotScheduleOutput`](crate::output::UpdateSnapshotScheduleOutput) with field(s):
    ///   - [`volume_arn(Option<String>)`](crate::output::UpdateSnapshotScheduleOutput::volume_arn): <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
    /// - On failure, responds with [`SdkError<UpdateSnapshotScheduleError>`](crate::error::UpdateSnapshotScheduleError)
    pub fn update_snapshot_schedule(&self) -> fluent_builders::UpdateSnapshotSchedule {
        fluent_builders::UpdateSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVTLDeviceType`](crate::client::fluent_builders::UpdateVTLDeviceType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vtl_device_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateVTLDeviceType::vtl_device_arn) / [`set_vtl_device_arn(Option<String>)`](crate::client::fluent_builders::UpdateVTLDeviceType::set_vtl_device_arn): <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
    ///   - [`device_type(impl Into<String>)`](crate::client::fluent_builders::UpdateVTLDeviceType::device_type) / [`set_device_type(Option<String>)`](crate::client::fluent_builders::UpdateVTLDeviceType::set_device_type): <p>The type of medium changer you want to select.</p>  <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>
    /// - On success, responds with [`UpdateVtlDeviceTypeOutput`](crate::output::UpdateVtlDeviceTypeOutput) with field(s):
    ///   - [`vtl_device_arn(Option<String>)`](crate::output::UpdateVtlDeviceTypeOutput::vtl_device_arn): <p>The Amazon Resource Name (ARN) of the medium changer you have selected.</p>
    /// - On failure, responds with [`SdkError<UpdateVTLDeviceTypeError>`](crate::error::UpdateVTLDeviceTypeError)
    pub fn update_vtl_device_type(&self) -> fluent_builders::UpdateVTLDeviceType {
        fluent_builders::UpdateVTLDeviceType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateGateway`.
    ///
    /// <p>Activates the gateway you previously deployed on your host. In the activation process, you specify information such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The activation process also associates your gateway with your account. For more information, see <code>UpdateGatewayInformation</code>.</p> <note>
    /// <p>You must turn on the gateway VM before you can activate your gateway.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivateGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::activate_gateway_input::Builder,
    }
    impl ActivateGateway {
        /// Creates a new `ActivateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include other activation-related parameters, however, these are merely defaults -- the arguments you pass to the <code>ActivateGateway</code> API call determine the actual configuration of your gateway.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation key</a> in the <i>Storage Gateway User Guide</i>.</p>
        pub fn activation_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_key(input.into());
            self
        }
        /// <p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include other activation-related parameters, however, these are merely defaults -- the arguments you pass to the <code>ActivateGateway</code> API call determine the actual configuration of your gateway.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation key</a> in the <i>Storage Gateway User Guide</i>.</p>
        pub fn set_activation_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_key(input);
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(input.into());
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
        /// <p>A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.</p>
        pub fn gateway_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_timezone(input.into());
            self
        }
        /// <p>A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.</p>
        pub fn set_gateway_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_timezone(input);
            self
        }
        /// <p>A value that indicates the Amazon Web Services Region where you want to store your data. The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web Services Region in your <code>Host</code> header in the request. For more information about available Amazon Web Services Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>. </p>
        pub fn gateway_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_region(input.into());
            self
        }
        /// <p>A value that indicates the Amazon Web Services Region where you want to store your data. The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web Services Region in your <code>Host</code> header in the request. For more information about available Amazon Web Services Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_gateway_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_region(input);
            self
        }
        /// <p>A value that defines the type of gateway to activate. The type specified is critical to all later functions of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.</p>
        /// <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>VTL_SNOW</code> | <code>FILE_S3</code> | <code>FILE_FSX_SMB</code> </p>
        pub fn gateway_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_type(input.into());
            self
        }
        /// <p>A value that defines the type of gateway to activate. The type specified is critical to all later functions of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.</p>
        /// <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>VTL_SNOW</code> | <code>FILE_S3</code> | <code>FILE_FSX_SMB</code> </p>
        pub fn set_gateway_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_type(input);
            self
        }
        /// <p>The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p>
        /// <p>Valid Values: <code>IBM-ULT3580-TD5</code> </p>
        pub fn tape_drive_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_drive_type(input.into());
            self
        }
        /// <p>The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p>
        /// <p>Valid Values: <code>IBM-ULT3580-TD5</code> </p>
        pub fn set_tape_drive_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tape_drive_type(input);
            self
        }
        /// <p>The value that indicates the type of medium changer to use for tape gateway. This field is optional.</p>
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>
        pub fn medium_changer_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.medium_changer_type(input.into());
            self
        }
        /// <p>The value that indicates the type of medium changer to use for tape gateway. This field is optional.</p>
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>
        pub fn set_medium_changer_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_medium_changer_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddCache`.
    ///
    /// <p>Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached volume, tape, and file gateway type (see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">How Storage Gateway works (architecture)</a>.</p>
    /// <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or more disk IDs that you want to configure as cache.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_cache_input::Builder,
    }
    impl AddCache {
        /// Creates a new `AddCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::AddCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `DiskIds`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_ids(input.into());
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_disk_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team. Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway resources:</p>
    /// <ul>
    /// <li> <p>Storage gateways of all types</p> </li>
    /// <li> <p>Storage volumes</p> </li>
    /// <li> <p>Virtual tapes</p> </li>
    /// <li> <p>NFS and SMB file shares</p> </li>
    /// <li> <p>File System associations</p> </li>
    /// </ul>
    /// <p>You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes that are recovered to a new gateway maintain their tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl AddTagsToResource {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag you want to add to the resource. The value can be an empty string.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag you want to add to the resource. The value can be an empty string.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddUploadBuffer`.
    ///
    /// <p>Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.</p>
    /// <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and one or more disk IDs that you want to configure as upload buffer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddUploadBuffer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_upload_buffer_input::Builder,
    }
    impl AddUploadBuffer {
        /// Creates a new `AddUploadBuffer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddUploadBufferOutput,
            aws_smithy_http::result::SdkError<crate::error::AddUploadBufferError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `DiskIds`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_ids(input.into());
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_disk_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddWorkingStorage`.
    ///
    /// <p>Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use <code>AddUploadBuffer</code> instead.</p> <note>
    /// <p>Working storage is also referred to as upload buffer. You can also use the <code>AddUploadBuffer</code> operation to add upload buffer to a stored volume gateway.</p>
    /// </note>
    /// <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and one or more disk IDs that you want to configure as working storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddWorkingStorage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_working_storage_input::Builder,
    }
    impl AddWorkingStorage {
        /// Creates a new `AddWorkingStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddWorkingStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::AddWorkingStorageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `DiskIds`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_ids(input.into());
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <code>ListLocalDisks</code> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_disk_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssignTapePool`.
    ///
    /// <p>Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssignTapePool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::assign_tape_pool_input::Builder,
    }
    impl AssignTapePool {
        /// Creates a new `AssignTapePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssignTapePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::AssignTapePoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>Set permissions to bypass governance retention. If the lock type of the archived tape is <code>Governance</code>, the tape's archived age is not older than <code>RetentionLockInDays</code>, and the user does not already have <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass the retention lock. This parameter is set to true by default for calls from the console.</p>
        /// <p>Valid values: <code>TRUE</code> | <code>FALSE</code> </p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(input);
            self
        }
        /// <p>Set permissions to bypass governance retention. If the lock type of the archived tape is <code>Governance</code>, the tape's archived age is not older than <code>RetentionLockInDays</code>, and the user does not already have <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass the retention lock. This parameter is set to true by default for calls from the console.</p>
        /// <p>Valid values: <code>TRUE</code> | <code>FALSE</code> </p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateFileSystem`.
    ///
    /// <p>Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the file shares on the Amazon FSx file system are available for access through the gateway. This operation only supports the FSx File Gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_file_system_input::Builder,
    }
    impl AssociateFileSystem {
        /// Creates a new `AssociateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system association creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system association creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>Specifies the network configuration information for the gateway associated with the Amazon FSx file system.</p> <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn endpoint_network_configuration(
            mut self,
            input: crate::model::EndpointNetworkConfiguration,
        ) -> Self {
            self.inner = self.inner.endpoint_network_configuration(input);
            self
        }
        /// <p>Specifies the network configuration information for the gateway associated with the Amazon FSx file system.</p> <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn set_endpoint_network_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointNetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_network_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachVolume`.
    ///
    /// <p>Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::attach_volume_input::Builder,
    }
    impl AttachVolume {
        /// Creates a new `AttachVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This value is only required when you are attaching a stored volume.</p>
        pub fn disk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_id(input.into());
            self
        }
        /// <p>The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This value is only required when you are attaching a stored volume.</p>
        pub fn set_disk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelArchival`.
    ///
    /// <p>Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelArchival {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_archival_input::Builder,
    }
    impl CancelArchival {
        /// Creates a new `CancelArchival`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelArchivalOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelArchivalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving for.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving for.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelRetrieval`.
    ///
    /// <p>Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelRetrieval {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_retrieval_input::Builder,
    }
    impl CancelRetrieval {
        /// Creates a new `CancelRetrieval`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelRetrievalOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelRetrievalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval for.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval for.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCachediSCSIVolume`.
    ///
    /// <p>Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached volume gateway type.</p> <note>
    /// <p>Cache storage must be allocated to the gateway before you can create a cached volume. Use the <code>AddCache</code> operation to add cache storage to a gateway.</p>
    /// </note>
    /// <p>In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.</p>
    /// <p>Optionally, you can provide the ARN for an existing volume as the <code>SourceVolumeARN</code> for this cached volume, which creates an exact copy of the existing volume’s latest recovery point. The <code>VolumeSizeInBytes</code> value must be equal to or larger than the size of the copied volume, in bytes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCachediSCSIVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cachedi_scsi_volume_input::Builder,
    }
    impl CreateCachediSCSIVolume {
        /// Creates a new `CreateCachediSCSIVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCachediScsiVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCachediSCSIVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn volume_size_in_bytes(mut self, input: i64) -> Self {
            self.inner = self.inner.volume_size_in_bytes(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_volume_size_in_bytes(input);
            self
        }
        /// <p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
        /// <p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than the size of the existing volume, in bytes.</p>
        pub fn source_volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_volume_arn(input.into());
            self
        }
        /// <p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than the size of the existing volume, in bytes.</p>
        pub fn set_source_volume_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_volume_arn(input);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNFSFileShare`.
    ///
    /// <p>Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS interface. This operation is only supported for S3 File Gateways.</p> <important>
    /// <p>S3 File gateway requires Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your S3 File Gateway in. If Amazon Web Services STS is not activated in the Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access Management User Guide</i>.</p>
    /// <p>S3 File Gateways do not support creating hard or symbolic links on a file share.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNFSFileShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_nfs_file_share_input::Builder,
    }
    impl CreateNFSFileShare {
        /// Creates a new `CreateNFSFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNfsFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNFSFileShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>File share default values. Optional.</p>
        pub fn nfs_file_share_defaults(
            mut self,
            input: crate::model::NfsFileShareDefaults,
        ) -> Self {
            self.inner = self.inner.nfs_file_share_defaults(input);
            self
        }
        /// <p>File share default values. Optional.</p>
        pub fn set_nfs_file_share_defaults(
            mut self,
            input: std::option::Option<crate::model::NfsFileShareDefaults>,
        ) -> Self {
            self.inner = self.inner.set_nfs_file_share_defaults(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file share.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file share.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).</p> <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.</p>
        /// <p>Bucket ARN:</p>
        /// <p> <code>arn:aws:s3:::my-bucket/prefix/</code> </p>
        /// <p>Access point ARN:</p>
        /// <p> <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code> </p>
        /// <p>If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>Access point alias:</p>
        /// <p> <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code> </p>
        /// </note>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).</p> <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.</p>
        /// <p>Bucket ARN:</p>
        /// <p> <code>arn:aws:s3:::my-bucket/prefix/</code> </p>
        /// <p>Access point ARN:</p>
        /// <p> <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code> </p>
        /// <p>If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>Access point alias:</p>
        /// <p> <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code> </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// Appends an item to `ClientList`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn client_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_list(input.into());
            self
        }
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_client_list(input);
            self
        }
        /// <p>A value that maps a user to anonymous user.</p>
        /// <p>Valid values are the following:</p>
        /// <ul>
        /// <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li>
        /// </ul>
        pub fn squash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.squash(input.into());
            self
        }
        /// <p>A value that maps a user to anonymous user.</p>
        /// <p>Valid values are the following:</p>
        /// <ul>
        /// <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li>
        /// </ul>
        pub fn set_squash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_squash(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.inner = self.inner.read_only(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.inner = self.inner.requester_pays(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.</p> <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_dns_name(input.into());
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.</p> <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_dns_name(input);
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p> <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_region(input.into());
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p> <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bucket_region(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSMBFileShare`.
    ///
    /// <p>Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB interface. This operation is only supported for S3 File Gateways.</p> <important>
    /// <p>S3 File Gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your S3 File Gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access Management User Guide</i>.</p>
    /// <p>File gateways don't support creating hard or symbolic links on a file share.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSMBFileShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_smb_file_share_input::Builder,
    }
    impl CreateSMBFileShare {
        /// Creates a new `CreateSMBFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSmbFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSMBFileShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ARN of the S3 File Gateway on which you want to create a file share.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The ARN of the S3 File Gateway on which you want to create a file share.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).</p> <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.</p>
        /// <p>Bucket ARN:</p>
        /// <p> <code>arn:aws:s3:::my-bucket/prefix/</code> </p>
        /// <p>Access point ARN:</p>
        /// <p> <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code> </p>
        /// <p>If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>Access point alias:</p>
        /// <p> <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code> </p>
        /// </note>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).</p> <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.</p>
        /// <p>Bucket ARN:</p>
        /// <p> <code>arn:aws:s3:::my-bucket/prefix/</code> </p>
        /// <p>Access point ARN:</p>
        /// <p> <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code> </p>
        /// <p>If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>Access point alias:</p>
        /// <p> <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code> </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.inner = self.inner.read_only(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.inner = self.inner.requester_pays(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn smbacl_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.smbacl_enabled(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_smbacl_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_smbacl_enabled(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read access.</p>
        pub fn access_based_enumeration(mut self, input: bool) -> Self {
            self.inner = self.inner.access_based_enumeration(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read access.</p>
        pub fn set_access_based_enumeration(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_access_based_enumeration(input);
            self
        }
        /// Appends an item to `AdminUserList`.
        ///
        /// To override the contents of this collection use [`set_admin_user_list`](Self::set_admin_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that will be granted administrator privileges on the file share. These users can do all file operations as the super-user. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>.</p> <important>
        /// <p>Use this option very carefully, because any user in this list can do anything they like on the file share, regardless of file permissions.</p>
        /// </important>
        pub fn admin_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_user_list(input.into());
            self
        }
        /// <p>A list of users or groups in the Active Directory that will be granted administrator privileges on the file share. These users can do all file operations as the super-user. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>.</p> <important>
        /// <p>Use this option very carefully, because any user in this list can do anything they like on the file share, regardless of file permissions.</p>
        /// </important>
        pub fn set_admin_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_admin_user_list(input);
            self
        }
        /// Appends an item to `ValidUserList`.
        ///
        /// To override the contents of this collection use [`set_valid_user_list`](Self::set_valid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file <code></code> share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn valid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.valid_user_list(input.into());
            self
        }
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file <code></code> share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn set_valid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_valid_user_list(input);
            self
        }
        /// Appends an item to `InvalidUserList`.
        ///
        /// To override the contents of this collection use [`set_invalid_user_list`](Self::set_invalid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn invalid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invalid_user_list(input.into());
            self
        }
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn set_invalid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_invalid_user_list(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The authentication method that users use to access the file share. The default is <code>ActiveDirectory</code>.</p>
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code> </p>
        pub fn authentication(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication(input.into());
            self
        }
        /// <p>The authentication method that users use to access the file share. The default is <code>ActiveDirectory</code>.</p>
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code> </p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>
        pub fn case_sensitivity(mut self, input: crate::model::CaseSensitivity) -> Self {
            self.inner = self.inner.case_sensitivity(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>
        pub fn set_case_sensitivity(
            mut self,
            input: std::option::Option<crate::model::CaseSensitivity>,
        ) -> Self {
            self.inner = self.inner.set_case_sensitivity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.</p> <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_dns_name(input.into());
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.</p> <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_dns_name(input);
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p> <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_region(input.into());
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p> <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bucket_region(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn oplocks_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.oplocks_enabled(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_oplocks_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_oplocks_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Initiates a snapshot of a volume.</p>
    /// <p>Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage (Amazon S3) for durable off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc basis. This API enables you to take an ad hoc snapshot. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot">Editing a snapshot schedule</a>.</p>
    /// <p>In the <code>CreateSnapshot</code> request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide description for the snapshot. When Storage Gateway takes the snapshot of specified volume, the snapshot and description appears in the Storage Gateway console. In response, Storage Gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot. This operation is only supported in stored and cached volume gateway type.</p> <note>
    /// <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
    /// </note> <important>
    /// <p>Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note on the <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome</a> page.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl CreateSnapshot {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>
        pub fn snapshot_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_description(input.into());
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>
        pub fn set_snapshot_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshotFromVolumeRecoveryPoint`.
    ///
    /// <p>Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached volume gateway type.</p>
    /// <p>A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot. To get a list of volume recovery point for cached volume gateway, use <code>ListVolumeRecoveryPoints</code>.</p>
    /// <p>In the <code>CreateSnapshotFromVolumeRecoveryPoint</code> request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a snapshot of the specified volume, the snapshot and its description appear in the Storage Gateway console. In response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot.</p> <note>
    /// <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshotFromVolumeRecoveryPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_from_volume_recovery_point_input::Builder,
    }
    impl CreateSnapshotFromVolumeRecoveryPoint {
        /// Creates a new `CreateSnapshotFromVolumeRecoveryPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotFromVolumeRecoveryPointOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateSnapshotFromVolumeRecoveryPointError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>
        pub fn snapshot_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_description(input.into());
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>
        pub fn set_snapshot_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStorediSCSIVolume`.
    ///
    /// <p>Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.</p>
    /// <p>The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty gateway volume, then any existing data on the disk is erased.</p>
    /// <p>In the request, you must specify the gateway and the disk information on which you are creating the volume. In response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStorediSCSIVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_storedi_scsi_volume_input::Builder,
    }
    impl CreateStorediSCSIVolume {
        /// Creates a new `CreateStorediSCSIVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStorediScsiVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStorediSCSIVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The unique identifier for the gateway local disk that is configured as a stored volume. Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to list disk IDs for a gateway.</p>
        pub fn disk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_id(input.into());
            self
        }
        /// <p>The unique identifier for the gateway local disk that is configured as a stored volume. Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to list disk IDs for a gateway.</p>
        pub fn set_disk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_id(input);
            self
        }
        /// <p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to <code>false</code> to create an empty volume.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn preserve_existing_data(mut self, input: bool) -> Self {
            self.inner = self.inner.preserve_existing_data(input);
            self
        }
        /// <p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to <code>false</code> to create an empty volume.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_preserve_existing_data(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_preserve_existing_data(input);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p>
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <code>DescribeGatewayInformation</code> to get a list of the network interfaces available on a gateway.</p>
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTapePool`.
    ///
    /// <p>Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are archived in the custom pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTapePool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tape_pool_input::Builder,
    }
    impl CreateTapePool {
        /// Creates a new `CreateTapePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTapePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTapePoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new custom tape pool.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>The name of the new custom tape pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// <p>The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn storage_class(mut self, input: crate::model::TapeStorageClass) -> Self {
            self.inner = self.inner.storage_class(input);
            self
        }
        /// <p>The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TapeStorageClass>,
        ) -> Self {
            self.inner = self.inner.set_storage_class(input);
            self
        }
        /// <p>Tape retention lock can be configured in two modes. When configured in governance mode, Amazon Web Services accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root Amazon Web Services account.</p>
        pub fn retention_lock_type(mut self, input: crate::model::RetentionLockType) -> Self {
            self.inner = self.inner.retention_lock_type(input);
            self
        }
        /// <p>Tape retention lock can be configured in two modes. When configured in governance mode, Amazon Web Services accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root Amazon Web Services account.</p>
        pub fn set_retention_lock_type(
            mut self,
            input: std::option::Option<crate::model::RetentionLockType>,
        ) -> Self {
            self.inner = self.inner.set_retention_lock_type(input);
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).</p>
        pub fn retention_lock_time_in_days(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_lock_time_in_days(input);
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).</p>
        pub fn set_retention_lock_time_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_lock_time_in_days(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTapes`.
    ///
    /// <p>Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation is only supported in the tape gateway type.</p> <note>
    /// <p>Cache storage must be allocated to the gateway before you can create virtual tapes. Use the <code>AddCache</code> operation to add cache storage to a gateway.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTapes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tapes_input::Builder,
    }
    impl CreateTapes {
        /// Creates a new `CreateTapes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTapesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTapesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tapes that you want to create.</p> <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.inner = self.inner.tape_size_in_bytes(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tapes that you want to create.</p> <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_tape_size_in_bytes(input);
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p> <note>
        /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple times.</p>
        /// </note>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p> <note>
        /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple times.</p>
        /// </note>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The number of virtual tapes that you want to create.</p>
        pub fn num_tapes_to_create(mut self, input: i32) -> Self {
            self.inner = self.inner.num_tapes_to_create(input);
            self
        }
        /// <p>The number of virtual tapes that you want to create.</p>
        pub fn set_num_tapes_to_create(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_tapes_to_create(input);
            self
        }
        /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.</p> <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.</p>
        /// </note>
        pub fn tape_barcode_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_barcode_prefix(input.into());
            self
        }
        /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.</p> <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.</p>
        /// </note>
        pub fn set_tape_barcode_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tape_barcode_prefix(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>
        pub fn worm(mut self, input: bool) -> Self {
            self.inner = self.inner.worm(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_worm(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTapeWithBarcode`.
    ///
    /// <p>Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on deleted tapes. This operation is only supported in the tape gateway type.</p> <note>
    /// <p>Cache storage must be allocated to the gateway before you can create a virtual tape. Use the <code>AddCache</code> operation to add cache storage to a gateway.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTapeWithBarcode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tape_with_barcode_input::Builder,
    }
    impl CreateTapeWithBarcode {
        /// Creates a new `CreateTapeWithBarcode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTapeWithBarcodeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTapeWithBarcodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tape that you want to create.</p> <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.inner = self.inner.tape_size_in_bytes(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tape that you want to create.</p> <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_tape_size_in_bytes(input);
            self
        }
        /// <p>The barcode that you want to assign to the tape.</p> <note>
        /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.</p>
        /// </note>
        pub fn tape_barcode(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_barcode(input.into());
            self
        }
        /// <p>The barcode that you want to assign to the tape.</p> <note>
        /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.</p>
        /// </note>
        pub fn set_tape_barcode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_barcode(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>
        pub fn worm(mut self, input: bool) -> Self {
            self.inner = self.inner.worm(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_worm(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAutomaticTapeCreationPolicy`.
    ///
    /// <p>Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAutomaticTapeCreationPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_automatic_tape_creation_policy_input::Builder,
    }
    impl DeleteAutomaticTapeCreationPolicy {
        /// Creates a new `DeleteAutomaticTapeCreationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAutomaticTapeCreationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAutomaticTapeCreationPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBandwidthRateLimit`.
    ///
    /// <p>Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This operation is supported only for the stored volume, cached volume, and tape gateway types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBandwidthRateLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bandwidth_rate_limit_input::Builder,
    }
    impl DeleteBandwidthRateLimit {
        /// Creates a new `DeleteBandwidthRateLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBandwidthRateLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBandwidthRateLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.</p>
        /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code> </p>
        pub fn bandwidth_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth_type(input.into());
            self
        }
        /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.</p>
        /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code> </p>
        pub fn set_bandwidth_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChapCredentials`.
    ///
    /// <p>Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair. This operation is supported in volume and tape gateway types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChapCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_chap_credentials_input::Builder,
    }
    impl DeleteChapCredentials {
        /// Creates a new `DeleteChapCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChapCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChapCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initiator_name(input.into());
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initiator_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFileShare`.
    ///
    /// <p>Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFileShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_file_share_input::Builder,
    }
    impl DeleteFileShare {
        /// Creates a new `DeleteFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// <p>If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGateway`.
    ///
    /// <p>Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from your host computer.</p>
    /// <p>After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next step is to remove it from your environment.</p> <important>
    /// <p>You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots persist and you will continue to be billed for these snapshots.&nbsp;You can choose to remove all remaining Amazon EBS snapshots by canceling your Amazon EC2 subscription.&nbsp; If you prefer not to cancel your Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2 console. For more information, see the <a href="http://aws.amazon.com/storagegateway">Storage Gateway detail page</a>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_gateway_input::Builder,
    }
    impl DeleteGateway {
        /// Creates a new `DeleteGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshotSchedule`.
    ///
    /// <p>Deletes a snapshot of a volume.</p>
    /// <p>You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to delete a snapshot schedule for a volume. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html">Backing up your volumes</a>. In the <code>DeleteSnapshotSchedule</code> request, you identify the volume by providing its Amazon Resource Name (ARN). This operation is only supported for cached volume gateway types.</p> <note>
    /// <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSnapshotSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_snapshot_schedule_input::Builder,
    }
    impl DeleteSnapshotSchedule {
        /// Creates a new `DeleteSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The volume which snapshot schedule to delete.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The volume which snapshot schedule to delete.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTape`.
    ///
    /// <p>Deletes the specified virtual tape. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTape {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tape_input::Builder,
    }
    impl DeleteTape {
        /// Creates a new `DeleteTape`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTapeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTapeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTapeArchive`.
    ///
    /// <p>Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTapeArchive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tape_archive_input::Builder,
    }
    impl DeleteTapeArchive {
        /// Creates a new `DeleteTapeArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTapeArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTapeArchiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTapePool`.
    ///
    /// <p>Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there are no automatic tape creation policies that reference the custom tape pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTapePool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tape_pool_input::Builder,
    }
    impl DeleteTapePool {
        /// Creates a new `DeleteTapePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTapePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTapePoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVolume`.
    ///
    /// <p>Deletes the specified storage volume that you previously created using the <code>CreateCachediSCSIVolume</code> or <code>CreateStorediSCSIVolume</code> API. This operation is only supported in the cached volume and stored volume types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You can reuse the local disk to create another storage volume.</p>
    /// <p>Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are deleting and check the snapshot status. For more information, go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
    /// <p>In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_volume_input::Builder,
    }
    impl DeleteVolume {
        /// Creates a new `DeleteVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAvailabilityMonitorTest`.
    ///
    /// <p>Returns information about the most recent high availability monitoring test that was performed on the host in a cluster. If a test isn't performed, the status and start time in the response would be null.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAvailabilityMonitorTest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_availability_monitor_test_input::Builder,
    }
    impl DescribeAvailabilityMonitorTest {
        /// Creates a new `DescribeAvailabilityMonitorTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAvailabilityMonitorTestOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAvailabilityMonitorTestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBandwidthRateLimit`.
    ///
    /// <p>Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth rate limiting is in effect. This operation is supported only for the stored volume, cached volume, and tape gateway types. To describe bandwidth rate limits for S3 file gateways, use <code>DescribeBandwidthRateLimitSchedule</code>.</p>
    /// <p>This operation returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for the gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBandwidthRateLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_bandwidth_rate_limit_input::Builder,
    }
    impl DescribeBandwidthRateLimit {
        /// Creates a new `DescribeBandwidthRateLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBandwidthRateLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBandwidthRateLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBandwidthRateLimitSchedule`.
    ///
    /// <p> Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported only for volume, tape and S3 file gateways. FSx file gateways do not support bandwidth rate limits.</p>
    /// <p>This operation returns information about a gateway's bandwidth rate limit schedule. A bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the week, during which bandwidth rate limits are specified for uploading, downloading, or both. </p>
    /// <p> A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute, an ending hour and minute, and bandwidth rate limits for uploading and downloading </p>
    /// <p> If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an empty response. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBandwidthRateLimitSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_bandwidth_rate_limit_schedule_input::Builder,
    }
    impl DescribeBandwidthRateLimitSchedule {
        /// Creates a new `DescribeBandwidthRateLimitSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBandwidthRateLimitScheduleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeBandwidthRateLimitScheduleError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCache`.
    ///
    /// <p>Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape, and file gateway types.</p>
    /// <p>The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cache_input::Builder,
    }
    impl DescribeCache {
        /// Creates a new `DescribeCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCachediSCSIVolumes`.
    ///
    /// <p>Returns a description of the gateway volumes specified in the request. This operation is only supported in the cached volume gateway types.</p>
    /// <p>The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume Amazon Resource Name (ARN).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCachediSCSIVolumes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cachedi_scsi_volumes_input::Builder,
    }
    impl DescribeCachediSCSIVolumes {
        /// Creates a new `DescribeCachediSCSIVolumes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCachediScsiVolumesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCachediSCSIVolumesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `VolumeARNs`.
        ///
        /// To override the contents of this collection use [`set_volume_ar_ns`](Self::set_volume_ar_ns).
        ///
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a cached volume. All of the specified cached volumes must be from the same gateway. Use <code>ListVolumes</code> to get volume ARNs for a gateway.</p>
        pub fn volume_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_ar_ns(input.into());
            self
        }
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a cached volume. All of the specified cached volumes must be from the same gateway. Use <code>ListVolumes</code> to get volume ARNs for a gateway.</p>
        pub fn set_volume_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_volume_ar_ns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChapCredentials`.
    ///
    /// <p>Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChapCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_chap_credentials_input::Builder,
    }
    impl DescribeChapCredentials {
        /// Creates a new `DescribeChapCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChapCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChapCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return to retrieve the TargetARN for specified VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystemAssociations`.
    ///
    /// <p>Gets the file system association information. This operation is only supported for FSx File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFileSystemAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_file_system_associations_input::Builder,
    }
    impl DescribeFileSystemAssociations {
        /// Creates a new `DescribeFileSystemAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FileSystemAssociationARNList`.
        ///
        /// To override the contents of this collection use [`set_file_system_association_arn_list`](Self::set_file_system_association_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be described.</p>
        pub fn file_system_association_arn_list(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.file_system_association_arn_list(input.into());
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be described.</p>
        pub fn set_file_system_association_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_association_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGatewayInformation`.
    ///
    /// <p>Returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not). To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGatewayInformation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_gateway_information_input::Builder,
    }
    impl DescribeGatewayInformation {
        /// Creates a new `DescribeGatewayInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGatewayInformationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceStartTime`.
    ///
    /// <p>Returns your gateway's weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway's time zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceStartTime {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_start_time_input::Builder,
    }
    impl DescribeMaintenanceStartTime {
        /// Creates a new `DescribeMaintenanceStartTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceStartTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceStartTimeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNFSFileShares`.
    ///
    /// <p>Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation is only supported for S3 File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNFSFileShares {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_nfs_file_shares_input::Builder,
    }
    impl DescribeNFSFileShares {
        /// Creates a new `DescribeNFSFileShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNfsFileSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNFSFileSharesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FileShareARNList`.
        ///
        /// To override the contents of this collection use [`set_file_share_arn_list`](Self::set_file_share_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>
        pub fn file_share_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn_list(input.into());
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>
        pub fn set_file_share_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSMBFileShares`.
    ///
    /// <p>Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation is only supported for S3 File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSMBFileShares {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_smb_file_shares_input::Builder,
    }
    impl DescribeSMBFileShares {
        /// Creates a new `DescribeSMBFileShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSmbFileSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSMBFileSharesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FileShareARNList`.
        ///
        /// To override the contents of this collection use [`set_file_share_arn_list`](Self::set_file_share_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>
        pub fn file_share_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn_list(input.into());
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>
        pub fn set_file_share_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSMBSettings`.
    ///
    /// <p>Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is only supported for file gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSMBSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_smb_settings_input::Builder,
    }
    impl DescribeSMBSettings {
        /// Creates a new `DescribeSMBSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSmbSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSMBSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshotSchedule`.
    ///
    /// <p>Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the cached volume and stored volume types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSnapshotSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_snapshot_schedule_input::Builder,
    }
    impl DescribeSnapshotSchedule {
        /// Creates a new `DescribeSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStorediSCSIVolumes`.
    ///
    /// <p>Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported in stored volume gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStorediSCSIVolumes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_storedi_scsi_volumes_input::Builder,
    }
    impl DescribeStorediSCSIVolumes {
        /// Creates a new `DescribeStorediSCSIVolumes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStorediScsiVolumesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStorediSCSIVolumesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `VolumeARNs`.
        ///
        /// To override the contents of this collection use [`set_volume_ar_ns`](Self::set_volume_ar_ns).
        ///
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of the specified stored volumes must be from the same gateway. Use <code>ListVolumes</code> to get volume ARNs for a gateway.</p>
        pub fn volume_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_ar_ns(input.into());
            self
        }
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of the specified stored volumes must be from the same gateway. Use <code>ListVolumes</code> to get volume ARNs for a gateway.</p>
        pub fn set_volume_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_volume_ar_ns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTapeArchives`.
    ///
    /// <p>Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.</p>
    /// <p>If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes found in the VTS associated with your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTapeArchives {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tape_archives_input::Builder,
    }
    impl DescribeTapeArchives {
        /// Creates a new `DescribeTapeArchives`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTapeArchivesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTapeArchivesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTapeArchivesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTapeArchivesPaginator {
            crate::paginator::DescribeTapeArchivesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `TapeARNs`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe.</p>
        pub fn tape_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_ar_ns(input.into());
            self
        }
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tape_ar_ns(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing virtual tapes.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing virtual tapes.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified number.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTapeRecoveryPoints`.
    ///
    /// <p>Returns a list of virtual tape recovery points that are available for the specified tape gateway.</p>
    /// <p>A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTapeRecoveryPoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tape_recovery_points_input::Builder,
    }
    impl DescribeTapeRecoveryPoints {
        /// Creates a new `DescribeTapeRecoveryPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTapeRecoveryPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTapeRecoveryPointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTapeRecoveryPointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTapeRecoveryPointsPaginator {
            crate::paginator::DescribeTapeRecoveryPointsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the virtual tape recovery points.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the virtual tape recovery points.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of virtual tape recovery points that are described be limited to the specified number.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies that the number of virtual tape recovery points that are described be limited to the specified number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTapes`.
    ///
    /// <p>Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is not specified, returns a description of all virtual tapes associated with the specified gateway. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTapes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tapes_input::Builder,
    }
    impl DescribeTapes {
        /// Creates a new `DescribeTapes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTapesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTapesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTapesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTapesPaginator {
            crate::paginator::DescribeTapesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `TapeARNs`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes associated with the specified gateway.</p>
        pub fn tape_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_ar_ns(input.into());
            self
        }
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes associated with the specified gateway.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tape_ar_ns(input);
            self
        }
        /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which page of results to retrieve.</p>
        /// <p>If not specified, the first page of results is retrieved.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which page of results to retrieve.</p>
        /// <p>If not specified, the first page of results is retrieved.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified number.</p> <note>
        /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
        /// </note>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified number.</p> <note>
        /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
        /// </note>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUploadBuffer`.
    ///
    /// <p>Returns information about the upload buffer of a gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.</p>
    /// <p>The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload buffer space allocated and used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUploadBuffer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_upload_buffer_input::Builder,
    }
    impl DescribeUploadBuffer {
        /// Creates a new `DescribeUploadBuffer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUploadBufferOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUploadBufferError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVTLDevices`.
    ///
    /// <p>Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, Storage Gateway returns VTL device information.</p>
    /// <p>This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVTLDevices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_vtl_devices_input::Builder,
    }
    impl DescribeVTLDevices {
        /// Creates a new `DescribeVTLDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVtlDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVTLDevicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeVtlDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeVtlDevicesPaginator {
            crate::paginator::DescribeVtlDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `VTLDeviceARNs`.
        ///
        /// To override the contents of this collection use [`set_vtl_device_ar_ns`](Self::set_vtl_device_ar_ns).
        ///
        /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p> <note>
        /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result will contain all devices on the specified gateway.</p>
        /// </note>
        pub fn vtl_device_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vtl_device_ar_ns(input.into());
            self
        }
        /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p> <note>
        /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result will contain all devices on the specified gateway.</p>
        /// </note>
        pub fn set_vtl_device_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vtl_device_ar_ns(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the VTL devices.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the VTL devices.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of VTL devices described be limited to the specified number.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies that the number of VTL devices described be limited to the specified number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkingStorage`.
    ///
    /// <p>Returns information about the working storage of a gateway. This operation is only supported in the stored volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use DescribeUploadBuffer instead.</p> <note>
    /// <p>Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.</p>
    /// </note>
    /// <p>The response includes disk IDs that are configured as working storage, and it includes the amount of working storage allocated and used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkingStorage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_working_storage_input::Builder,
    }
    impl DescribeWorkingStorage {
        /// Creates a new `DescribeWorkingStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkingStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkingStorageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachVolume`.
    ///
    /// <p>Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance. This operation is only supported in the volume gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detach_volume_input::Builder,
    }
    impl DetachVolume {
        /// Creates a new `DetachVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the volume. The default is <code>false</code>. If this value is set to <code>false</code>, you must manually disconnect the iSCSI connection from the target volume.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn force_detach(mut self, input: bool) -> Self {
            self.inner = self.inner.force_detach(input);
            self
        }
        /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the volume. The default is <code>false</code>. If this value is set to <code>false</code>, you must manually disconnect the iSCSI connection from the target volume.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_force_detach(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_detach(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableGateway`.
    ///
    /// <p>Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.</p>
    /// <p>Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported in the tape gateway type.</p> <important>
    /// <p>After a gateway is disabled, it cannot be enabled.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_gateway_input::Builder,
    }
    impl DisableGateway {
        /// Creates a new `DisableGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFileSystem`.
    ///
    /// <p>Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes, the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File Gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_file_system_input::Builder,
    }
    impl DisassociateFileSystem {
        /// Creates a new `DisassociateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.file_system_association_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_association_arn(input);
            self
        }
        /// <p>If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends all data uploads to the file system, and the file system association enters the <code>FORCE_DELETING</code> status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends all data uploads to the file system, and the file system association enters the <code>FORCE_DELETING</code> status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `JoinDomain`.
    ///
    /// <p>Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that support the SMB file protocol.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct JoinDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::join_domain_input::Builder,
    }
    impl JoinDomain {
        /// Creates a new `JoinDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::JoinDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::JoinDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The name of the domain that you want the gateway to join.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want the gateway to join.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.</p>
        pub fn organizational_unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit(input.into());
            self
        }
        /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.</p>
        pub fn set_organizational_unit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit(input);
            self
        }
        /// Appends an item to `DomainControllers`.
        ///
        /// To override the contents of this collection use [`set_domain_controllers`](Self::set_domain_controllers).
        ///
        /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.</p>
        pub fn domain_controllers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_controllers(input.into());
            self
        }
        /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.</p>
        pub fn set_domain_controllers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_controllers(input);
            self
        }
        /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is 20 seconds.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_seconds(input);
            self
        }
        /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is 20 seconds.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_seconds(input);
            self
        }
        /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user account should be enabled to join computers to the domain. For example, you can use the domain administrator account or an account with delegated permissions to join computers to the domain.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user account should be enabled to join computers to the domain. For example, you can use the domain administrator account or an account with delegated permissions to join computers to the domain.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Sets the password of the user who has permission to add the gateway to the Active Directory domain.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>Sets the password of the user who has permission to add the gateway to the Active Directory domain.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAutomaticTapeCreationPolicies`.
    ///
    /// <p>Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for the gateway, it returns an empty list.</p>
    /// <p>This operation is only supported for tape gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAutomaticTapeCreationPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_automatic_tape_creation_policies_input::Builder,
    }
    impl ListAutomaticTapeCreationPolicies {
        /// Creates a new `ListAutomaticTapeCreationPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAutomaticTapeCreationPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAutomaticTapeCreationPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFileShares`.
    ///
    /// <p>Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the calling user account. This operation is only supported for S3 File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFileShares {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_file_shares_input::Builder,
    }
    impl ListFileShares {
        /// Creates a new `ListFileShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFileSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFileSharesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFileSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFileSharesPaginator {
            crate::paginator::ListFileSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If this field is not present, all file shares under your account are listed.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If this field is not present, all file shares under your account are listed.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The maximum number of file shares to return in the response. The value must be an integer with a value greater than zero. Optional.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of file shares to return in the response. The value must be an integer with a value greater than zero. Optional.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to ListFileShares. Optional.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to ListFileShares. Optional.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFileSystemAssociations`.
    ///
    /// <p>Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system association. This operation is only supported for FSx File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFileSystemAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_file_system_associations_input::Builder,
    }
    impl ListFileSystemAssociations {
        /// Creates a new `ListFileSystemAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFileSystemAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFileSystemAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFileSystemAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFileSystemAssociationsPaginator {
            crate::paginator::ListFileSystemAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The maximum number of file system associations to return in the response. If present, <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of file system associations to return in the response. If present, <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code> operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code> operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGateways`.
    ///
    /// <p>Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).</p>
    /// <p>By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you to optionally reduce the number of gateways returned in a response.</p>
    /// <p>If you have more gateways than are returned in a response (that is, the response returns only a truncated list of your gateways), the response contains a marker that you can specify in your next request to fetch the next page of gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGateways {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_gateways_input::Builder,
    }
    impl ListGateways {
        /// Creates a new `ListGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewaysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGatewaysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGatewaysPaginator {
            crate::paginator::ListGatewaysPaginator::new(self.handle, self.inner)
        }
        /// <p>An opaque string that indicates the position at which to begin the returned list of gateways.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the returned list of gateways.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the list of gateways returned be limited to the specified number of items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies that the list of gateways returned be limited to the specified number of items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLocalDisks`.
    ///
    /// <p>Returns a list of the gateway's local disks. To specify which gateway to describe, you use the Amazon Resource Name (ARN) of the gateway in the body of the request.</p>
    /// <p>The request returns a list of all disks, specifying which are configured as working storage, cache storage, or stored volume or not configured at all. The response includes a <code>DiskStatus</code> field. This field can have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway), or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLocalDisks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_local_disks_input::Builder,
    }
    impl ListLocalDisks {
        /// Creates a new `ListLocalDisks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLocalDisksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLocalDisksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of all types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the list of tags.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the list of tags.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the list of tags returned be limited to the specified number of items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies that the list of tags returned be limited to the specified number of items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTapePools`.
    ///
    /// <p>Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.</p>
    /// <p>This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to limit the number of tape pools in the response. If the number of tape pools returned in the response is truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to retrieve the next set of tape pools.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTapePools {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tape_pools_input::Builder,
    }
    impl ListTapePools {
        /// Creates a new `ListTapePools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTapePoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTapePoolsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTapePoolsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTapePoolsPaginator {
            crate::paginator::ListTapePoolsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `PoolARNs`.
        ///
        /// To override the contents of this collection use [`set_pool_ar_ns`](Self::set_pool_ar_ns).
        ///
        /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
        pub fn pool_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_ar_ns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
        pub fn set_pool_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pool_ar_ns(input);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape pools.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape pools.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTapes`.
    ///
    /// <p>Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation lists all virtual tapes in both your VTL and VTS.</p>
    /// <p>This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTapes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tapes_input::Builder,
    }
    impl ListTapes {
        /// Creates a new `ListTapes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTapesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTapesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTapesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTapesPaginator {
            crate::paginator::ListTapesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `TapeARNs`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
        pub fn tape_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_ar_ns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tape_ar_ns(input);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tapes.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tapes.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>An optional number limit for the tapes in the list returned by this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>An optional number limit for the tapes in the list returned by this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVolumeInitiators`.
    ///
    /// <p>Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume is being used or not. This operation is only supported in the cached volume and stored volume gateway types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVolumeInitiators {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_volume_initiators_input::Builder,
    }
    impl ListVolumeInitiators {
        /// Creates a new `ListVolumeInitiators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVolumeInitiatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVolumeInitiatorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes for the gateway.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes for the gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVolumeRecoveryPoints`.
    ///
    /// <p>Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway type.</p>
    /// <p>Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume. To create a snapshot from a volume recovery point use the <code>CreateSnapshotFromVolumeRecoveryPoint</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVolumeRecoveryPoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_volume_recovery_points_input::Builder,
    }
    impl ListVolumeRecoveryPoints {
        /// Creates a new `ListVolumeRecoveryPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVolumeRecoveryPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVolumeRecoveryPointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVolumes`.
    ///
    /// <p>Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the volume ARNs. If you want additional volume information, use the <code>DescribeStorediSCSIVolumes</code> or the <code>DescribeCachediSCSIVolumes</code> API.</p>
    /// <p>The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If the number of volumes returned in the response is truncated, the response includes a Marker field. You can use this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only supported in the cached volume and stored volume gateway types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVolumes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_volumes_input::Builder,
    }
    impl ListVolumes {
        /// Creates a new `ListVolumes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVolumesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVolumesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVolumesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVolumesPaginator {
            crate::paginator::ListVolumesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of volumes. Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of volumes. Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the list of volumes returned be limited to the specified number of items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies that the list of volumes returned be limited to the specified number of items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyWhenUploaded`.
    ///
    /// <p>Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to S3. Amazon S3.</p>
    /// <p>Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file share up to that point in time have been uploaded to Amazon S3. These files include files written to the file share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File Gateways.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification">Getting file upload notification</a> in the <i>Storage Gateway User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct NotifyWhenUploaded {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::notify_when_uploaded_input::Builder,
    }
    impl NotifyWhenUploaded {
        /// Creates a new `NotifyWhenUploaded`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyWhenUploadedOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyWhenUploadedError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshCache`.
    ///
    /// <p>Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only supported in the S3 File Gateway types.</p>
    /// <p>You can subscribe to be notified through an Amazon CloudWatch event when your <code>RefreshCache</code> operation completes. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>. This operation is Only supported for S3 File Gateways.</p>
    /// <p>When this API is called, it only initiates the refresh operation. When the API call completes and returns a success code, it doesn't necessarily mean that the file refresh has completed. You should use the refresh-complete notification to determine that the operation has completed before you check for new files on the gateway file share. You can subscribe to be notified through a CloudWatch event when your <code>RefreshCache</code> operation completes.</p>
    /// <p>Throttle limit: This API is asynchronous, so the gateway will accept no more than two refreshes at any time. We recommend using the refresh-complete CloudWatch event notification before issuing additional requests. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.</p> <important>
    /// <ul>
    /// <li> <p>Wait at least 60 seconds between consecutive RefreshCache API requests.</p> </li>
    /// <li> <p>RefreshCache does not evict cache entries if invoked consecutively within 60 seconds of a previous RefreshCache request.</p> </li>
    /// <li> <p>If you invoke the RefreshCache API when two requests are already being processed, any new request will cause an <code>InvalidGatewayRequestException</code> error because too many requests were sent to the server.</p> </li>
    /// </ul>
    /// </important> <note>
    /// <p>The S3 bucket name does not need to be included when entering the list of folders in the FolderList parameter.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RefreshCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::refresh_cache_input::Builder,
    }
    impl RefreshCache {
        /// Creates a new `RefreshCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// Appends an item to `FolderList`.
        ///
        /// To override the contents of this collection use [`set_folder_list`](Self::set_folder_list).
        ///
        /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3 bucket that the file share has access to is refreshed.</p>
        pub fn folder_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_list(input.into());
            self
        }
        /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3 bucket that the file share has access to is refreshed.</p>
        pub fn set_folder_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_folder_list(input);
            self
        }
        /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that were in the cache the last time the gateway listed the folder's contents. If this value set to <code>true</code>, each folder that is listed in <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in <code>FolderList</code> are not refreshed. Only objects that are in folders listed directly under <code>FolderList</code> are found and used for the update. The default is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.recursive(input);
            self
        }
        /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that were in the cache the last time the gateway listed the folder's contents. If this value set to <code>true</code>, each folder that is listed in <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in <code>FolderList</code> are not refreshed. Only objects that are in folders listed directly under <code>FolderList</code> are found and used for the update. The default is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes one or more tags from the specified resource. This operation is supported in storage gateways of all types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl RemoveTagsFromResource {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed of a key-value pair.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed of a key-value pair.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetCache`.
    ///
    /// <p>Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks. This operation is only supported in the cached volume and tape types.</p> <important>
    /// <p>If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must configure at least one new cache disk for your gateway to function properly.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reset_cache_input::Builder,
    }
    impl ResetCache {
        /// Creates a new `ResetCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveTapeArchive`.
    ///
    /// <p>Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway, even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway type.</p>
    /// <p>Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must archive the tape again before you can retrieve it to another gateway. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetrieveTapeArchive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retrieve_tape_archive_input::Builder,
    }
    impl RetrieveTapeArchive {
        /// Creates a new `RetrieveTapeArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveTapeArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveTapeArchiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveTapeRecoveryPoint`.
    ///
    /// <p>Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway type.</p>
    /// <p>A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.</p> <note>
    /// <p>The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge for retrieving recovery points.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetrieveTapeRecoveryPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retrieve_tape_recovery_point_input::Builder,
    }
    impl RetrieveTapeRecoveryPoint {
        /// Creates a new `RetrieveTapeRecoveryPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveTapeRecoveryPointOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveTapeRecoveryPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the recovery point.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the recovery point.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetLocalConsolePassword`.
    ///
    /// <p>Sets the password for your VM local console. When you log in to the local console for the first time, you log in to the VM with the default credentials. We recommend that you set a new password. You don't need to know the default password to set a new password.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetLocalConsolePassword {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_local_console_password_input::Builder,
    }
    impl SetLocalConsolePassword {
        /// Creates a new `SetLocalConsolePassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetLocalConsolePasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::SetLocalConsolePasswordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The password you want to set for your VM local console.</p>
        pub fn local_console_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.local_console_password(input.into());
            self
        }
        /// <p>The password you want to set for your VM local console.</p>
        pub fn set_local_console_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_local_console_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetSMBGuestPassword`.
    ///
    /// <p>Sets the password for the guest user <code>smbguest</code>. The <code>smbguest</code> user is the user when the authentication method for the file share is set to <code>GuestAccess</code>. This operation only supported for S3 File Gateways</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetSMBGuestPassword {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_smb_guest_password_input::Builder,
    }
    impl SetSMBGuestPassword {
        /// Creates a new `SetSMBGuestPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetSmbGuestPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::SetSMBGuestPasswordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The password that you want to set for your SMB server.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password that you want to set for your SMB server.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ShutdownGateway`.
    ///
    /// <p>Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in the body of your request.</p>
    /// <p>The operation shuts down the gateway service component running in the gateway's virtual machine (VM) and not the host VM.</p> <note>
    /// <p>If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to avoid unpredictable conditions.</p>
    /// </note>
    /// <p>After the gateway is shutdown, you cannot call any other API except <code>StartGateway</code>, <code>DescribeGatewayInformation</code>, and <code>ListGateways</code>. For more information, see <code>ActivateGateway</code>. Your applications cannot read from or write to the gateway's storage volumes, and there are no snapshots taken.</p> <note>
    /// <p>When you make a shutdown request, you will get a <code>200 OK</code> success response immediately. However, it might take some time for the gateway to shut down. You can call the <code>DescribeGatewayInformation</code> API to check the status. For more information, see <code>ActivateGateway</code>.</p>
    /// </note>
    /// <p>If do not intend to use the gateway again, you must delete the gateway (using <code>DeleteGateway</code>) to no longer pay software charges associated with the gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ShutdownGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::shutdown_gateway_input::Builder,
    }
    impl ShutdownGateway {
        /// Creates a new `ShutdownGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ShutdownGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::ShutdownGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAvailabilityMonitorTest`.
    ///
    /// <p>Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host environment. This request only initiates the test and that a successful response only indicates that the test was started. It doesn't indicate that the test passed. For the status of the test, invoke the <code>DescribeAvailabilityMonitorTest</code> API.</p> <note>
    /// <p>Starting this test will cause your gateway to go offline for a brief period.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartAvailabilityMonitorTest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_availability_monitor_test_input::Builder,
    }
    impl StartAvailabilityMonitorTest {
        /// Creates a new `StartAvailabilityMonitorTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAvailabilityMonitorTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAvailabilityMonitorTestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartGateway`.
    ///
    /// <p>Starts a gateway that you previously shut down (see <code>ShutdownGateway</code>). After the gateway starts, you can then make other API calls, your applications can read from or write to the gateway's storage volumes and you will be able to take snapshot backups.</p> <note>
    /// <p>When you make a request, you will get a 200 OK success response immediately. However, it might take some time for the gateway to be ready. You should call <code>DescribeGatewayInformation</code> and check the status before making any additional API calls. For more information, see <code>ActivateGateway</code>.</p>
    /// </note>
    /// <p>To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_gateway_input::Builder,
    }
    impl StartGateway {
        /// Creates a new `StartGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::StartGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAutomaticTapeCreationPolicy`.
    ///
    /// <p>Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of automatic tape creation rules. This is only supported for tape gateways.</p>
    /// <p>By default, there is no automatic tape creation policy.</p> <note>
    /// <p>A gateway can have only one automatic tape creation policy.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAutomaticTapeCreationPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_automatic_tape_creation_policy_input::Builder,
    }
    impl UpdateAutomaticTapeCreationPolicy {
        /// Creates a new `UpdateAutomaticTapeCreationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAutomaticTapeCreationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAutomaticTapeCreationPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AutomaticTapeCreationRules`.
        ///
        /// To override the contents of this collection use [`set_automatic_tape_creation_rules`](Self::set_automatic_tape_creation_rules).
        ///
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine when and how to automatically create new tapes.</p>
        pub fn automatic_tape_creation_rules(
            mut self,
            input: crate::model::AutomaticTapeCreationRule,
        ) -> Self {
            self.inner = self.inner.automatic_tape_creation_rules(input);
            self
        }
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine when and how to automatically create new tapes.</p>
        pub fn set_automatic_tape_creation_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
        ) -> Self {
            self.inner = self.inner.set_automatic_tape_creation_rules(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBandwidthRateLimit`.
    ///
    /// <p>Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This operation is supported only for the stored volume, cached volume, and tape gateway types. To update bandwidth rate limits for S3 file gateways, use <code>UpdateBandwidthRateLimitSchedule</code>.</p>
    /// <p>By default, a gateway's bandwidth rate limits are not set. If you don't set any limit, the gateway does not have any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.</p>
    /// <p>To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBandwidthRateLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_bandwidth_rate_limit_input::Builder,
    }
    impl UpdateBandwidthRateLimit {
        /// Creates a new `UpdateBandwidthRateLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBandwidthRateLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBandwidthRateLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second.</p>
        pub fn average_upload_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.inner = self.inner.average_upload_rate_limit_in_bits_per_sec(input);
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second.</p>
        pub fn set_average_upload_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self
                .inner
                .set_average_upload_rate_limit_in_bits_per_sec(input);
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second.</p>
        pub fn average_download_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.inner = self
                .inner
                .average_download_rate_limit_in_bits_per_sec(input);
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second.</p>
        pub fn set_average_download_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self
                .inner
                .set_average_download_rate_limit_in_bits_per_sec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBandwidthRateLimitSchedule`.
    ///
    /// <p> Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a gateway's bandwidth rate limit schedule. This operation is supported only for volume, tape and S3 file gateways. FSx file gateways do not support bandwidth rate limits.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBandwidthRateLimitSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_bandwidth_rate_limit_schedule_input::Builder,
    }
    impl UpdateBandwidthRateLimitSchedule {
        /// Creates a new `UpdateBandwidthRateLimitSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBandwidthRateLimitScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBandwidthRateLimitScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `BandwidthRateLimitIntervals`.
        ///
        /// To override the contents of this collection use [`set_bandwidth_rate_limit_intervals`](Self::set_bandwidth_rate_limit_intervals).
        ///
        /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the array is empty. </p>
        pub fn bandwidth_rate_limit_intervals(
            mut self,
            input: crate::model::BandwidthRateLimitInterval,
        ) -> Self {
            self.inner = self.inner.bandwidth_rate_limit_intervals(input);
            self
        }
        /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the array is empty. </p>
        pub fn set_bandwidth_rate_limit_intervals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth_rate_limit_intervals(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChapCredentials`.
    ///
    /// <p>Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is supported in the volume and tape gateway types.</p> <important>
    /// <p>When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect with the new credentials.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChapCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_chap_credentials_input::Builder,
    }
    impl UpdateChapCredentials {
        /// Creates a new `UpdateChapCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChapCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChapCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return the TargetARN for specified VolumeARN.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <code>DescribeStorediSCSIVolumes</code> operation to return the TargetARN for specified VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn secret_to_authenticate_initiator(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.secret_to_authenticate_initiator(input.into());
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn set_secret_to_authenticate_initiator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_to_authenticate_initiator(input);
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initiator_name(input.into());
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initiator_name(input);
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p>
        /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p> <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn secret_to_authenticate_target(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.secret_to_authenticate_target(input.into());
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p>
        /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p> <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn set_secret_to_authenticate_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_to_authenticate_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFileSystemAssociation`.
    ///
    /// <p>Updates a file system association. This operation is only supported in the FSx File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFileSystemAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_file_system_association_input::Builder,
    }
    impl UpdateFileSystemAssociation {
        /// Creates a new `UpdateFileSystemAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFileSystemAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association that you want to update.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.file_system_association_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association that you want to update.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_association_arn(input);
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayInformation`.
    ///
    /// <p>Updates a gateway's metadata, which includes the gateway's name and time zone. To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.</p> <note>
    /// <p>For gateways activated after September 2, 2015, the gateway's ARN contains the gateway ID rather than the gateway name. However, changing the name of the gateway has no effect on the gateway's ARN.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGatewayInformation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_gateway_information_input::Builder,
    }
    impl UpdateGatewayInformation {
        /// Creates a new `UpdateGatewayInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayInformationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(input.into());
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn gateway_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_timezone(input.into());
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn set_gateway_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_timezone(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log events in the gateway.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch Logs?</a> </p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_log_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log events in the gateway.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch Logs?</a> </p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_log_group_arn(input);
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn gateway_capacity(mut self, input: crate::model::GatewayCapacity) -> Self {
            self.inner = self.inner.gateway_capacity(input);
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn set_gateway_capacity(
            mut self,
            input: std::option::Option<crate::model::GatewayCapacity>,
        ) -> Self {
            self.inner = self.inner.set_gateway_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewaySoftwareNow`.
    ///
    /// <p>Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.</p> <note>
    /// <p>When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take some time for the update to complete. You can call <code>DescribeGatewayInformation</code> to verify the gateway is in the <code>STATE_RUNNING</code> state.</p>
    /// </note> <important>
    /// <p>A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your applications by increasing your iSCSI Initiators' timeouts. For more information about increasing iSCSI Initiator timeouts for Windows and Linux, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings">Customizing your Windows iSCSI settings</a> and <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings">Customizing your Linux iSCSI settings</a>, respectively.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGatewaySoftwareNow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_gateway_software_now_input::Builder,
    }
    impl UpdateGatewaySoftwareNow {
        /// Creates a new `UpdateGatewaySoftwareNow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewaySoftwareNowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewaySoftwareNowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMaintenanceStartTime`.
    ///
    /// <p>Updates a gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMaintenanceStartTime {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_maintenance_start_time_input::Builder,
    }
    impl UpdateMaintenanceStartTime {
        /// Creates a new `UpdateMaintenanceStartTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMaintenanceStartTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceStartTimeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn hour_of_day(mut self, input: i32) -> Self {
            self.inner = self.inner.hour_of_day(input);
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn set_hour_of_day(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_hour_of_day(input);
            self
        }
        /// <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.</p>
        pub fn minute_of_hour(mut self, input: i32) -> Self {
            self.inner = self.inner.minute_of_hour(input);
            self
        }
        /// <p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.</p>
        pub fn set_minute_of_hour(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minute_of_hour(input);
            self
        }
        /// <p>The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
        pub fn day_of_week(mut self, input: i32) -> Self {
            self.inner = self.inner.day_of_week(input);
            self
        }
        /// <p>The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
        pub fn set_day_of_week(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_day_of_week(input);
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
        pub fn day_of_month(mut self, input: i32) -> Self {
            self.inner = self.inner.day_of_month(input);
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_day_of_month(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNFSFileShare`.
    ///
    /// <p>Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.</p> <note>
    /// <p>To leave a file share field unchanged, set the corresponding input field to null.</p>
    /// </note>
    /// <p>Updates the following file share settings:</p>
    /// <ul>
    /// <li> <p>Default storage class for your S3 bucket</p> </li>
    /// <li> <p>Metadata defaults for your S3 bucket</p> </li>
    /// <li> <p>Allowed NFS clients for your file share</p> </li>
    /// <li> <p>Squash settings</p> </li>
    /// <li> <p>Write status of your file share</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNFSFileShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_nfs_file_share_input::Builder,
    }
    impl UpdateNFSFileShare {
        /// Creates a new `UpdateNFSFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNfsFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNFSFileShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The default values for the file share. Optional.</p>
        pub fn nfs_file_share_defaults(
            mut self,
            input: crate::model::NfsFileShareDefaults,
        ) -> Self {
            self.inner = self.inner.nfs_file_share_defaults(input);
            self
        }
        /// <p>The default values for the file share. Optional.</p>
        pub fn set_nfs_file_share_defaults(
            mut self,
            input: std::option::Option<crate::model::NfsFileShareDefaults>,
        ) -> Self {
            self.inner = self.inner.set_nfs_file_share_defaults(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// Appends an item to `ClientList`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn client_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_list(input.into());
            self
        }
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_client_list(input);
            self
        }
        /// <p>The user mapped to anonymous user.</p>
        /// <p>Valid values are the following:</p>
        /// <ul>
        /// <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li>
        /// </ul>
        pub fn squash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.squash(input.into());
            self
        }
        /// <p>The user mapped to anonymous user.</p>
        /// <p>Valid values are the following:</p>
        /// <ul>
        /// <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li>
        /// <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li>
        /// </ul>
        pub fn set_squash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_squash(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.inner = self.inner.read_only(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.inner = self.inner.requester_pays(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBFileShare`.
    ///
    /// <p>Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.</p> <note>
    /// <p>To leave a file share field unchanged, set the corresponding input field to null.</p>
    /// </note> <important>
    /// <p>File gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your file gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access Management User Guide</i>.</p>
    /// <p>File gateways don't support creating hard or symbolic links on a file share.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSMBFileShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_smb_file_share_input::Builder,
    }
    impl UpdateSMBFileShare {
        /// Creates a new `UpdateSMBFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.kms_encrypted(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_STANDARD</code>. Optional.</p>
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.inner = self.inner.read_only(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code> to set write status to read-only, otherwise set to <code>false</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.inner = self.inner.requester_pays(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
        /// <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn smbacl_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.smbacl_enabled(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_smbacl_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_smbacl_enabled(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read access.</p>
        pub fn access_based_enumeration(mut self, input: bool) -> Self {
            self.inner = self.inner.access_based_enumeration(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read access.</p>
        pub fn set_access_based_enumeration(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_access_based_enumeration(input);
            self
        }
        /// Appends an item to `AdminUserList`.
        ///
        /// To override the contents of this collection use [`set_admin_user_list`](Self::set_admin_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn admin_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_user_list(input.into());
            self
        }
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn set_admin_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_admin_user_list(input);
            self
        }
        /// Appends an item to `ValidUserList`.
        ///
        /// To override the contents of this collection use [`set_valid_user_list`](Self::set_valid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn valid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.valid_user_list(input.into());
            self
        }
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn set_valid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_valid_user_list(input);
            self
        }
        /// Appends an item to `InvalidUserList`.
        ///
        /// To override the contents of this collection use [`set_invalid_user_list`](Self::set_invalid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn invalid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invalid_user_list(input.into());
            self
        }
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>
        pub fn set_invalid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_invalid_user_list(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>
        pub fn case_sensitivity(mut self, input: crate::model::CaseSensitivity) -> Self {
            self.inner = self.inner.case_sensitivity(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>
        pub fn set_case_sensitivity(
            mut self,
            input: std::option::Option<crate::model::CaseSensitivity>,
        ) -> Self {
            self.inner = self.inner.set_case_sensitivity(input);
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p> <note>
        /// <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note>
        /// <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        /// <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p>
        /// <p> <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code> </p>
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        /// <p> <code>{}</code> </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn oplocks_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.oplocks_enabled(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_oplocks_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_oplocks_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBFileShareVisibility`.
    ///
    /// <p>Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only supported for S3 File Gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSMBFileShareVisibility {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_smb_file_share_visibility_input::Builder,
    }
    impl UpdateSMBFileShareVisibility {
        /// Creates a new `UpdateSMBFileShareVisibility`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbFileShareVisibilityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareVisibilityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The shares on this gateway appear when listing shares.</p>
        pub fn file_shares_visible(mut self, input: bool) -> Self {
            self.inner = self.inner.file_shares_visible(input);
            self
        }
        /// <p>The shares on this gateway appear when listing shares.</p>
        pub fn set_file_shares_visible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_file_shares_visible(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBLocalGroups`.
    ///
    /// <p>Updates the list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSMBLocalGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_smb_local_groups_input::Builder,
    }
    impl UpdateSMBLocalGroups {
        /// Creates a new `UpdateSMBLocalGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbLocalGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBLocalGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>A list of Active Directory users and groups that you want to grant special permissions for SMB file shares on the gateway.</p>
        pub fn smb_local_groups(mut self, input: crate::model::SmbLocalGroups) -> Self {
            self.inner = self.inner.smb_local_groups(input);
            self
        }
        /// <p>A list of Active Directory users and groups that you want to grant special permissions for SMB file shares on the gateway.</p>
        pub fn set_smb_local_groups(
            mut self,
            input: std::option::Option<crate::model::SmbLocalGroups>,
        ) -> Self {
            self.inner = self.inner.set_smb_local_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBSecurityStrategy`.
    ///
    /// <p>Updates the SMB security strategy on a file gateway. This action is only supported in file gateways.</p> <note>
    /// <p>This API is called Security level in the User Guide.</p>
    /// <p>A higher security level can affect performance of the gateway.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSMBSecurityStrategy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_smb_security_strategy_input::Builder,
    }
    impl UpdateSMBSecurityStrategy {
        /// Creates a new `UpdateSMBSecurityStrategy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbSecurityStrategyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBSecurityStrategyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>Specifies the type of security strategy.</p>
        /// <p>ClientSpecified: if you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Supported only in S3 File Gateway.</p>
        /// <p>MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p>
        /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p>
        pub fn smb_security_strategy(mut self, input: crate::model::SmbSecurityStrategy) -> Self {
            self.inner = self.inner.smb_security_strategy(input);
            self
        }
        /// <p>Specifies the type of security strategy.</p>
        /// <p>ClientSpecified: if you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Supported only in S3 File Gateway.</p>
        /// <p>MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p>
        /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p>
        pub fn set_smb_security_strategy(
            mut self,
            input: std::option::Option<crate::model::SmbSecurityStrategy>,
        ) -> Self {
            self.inner = self.inner.set_smb_security_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSnapshotSchedule`.
    ///
    /// <p>Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached volume and stored volume gateway types.</p>
    /// <p>The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You can use this API to change the snapshot schedule configured for the volume.</p>
    /// <p>In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSnapshotSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_snapshot_schedule_input::Builder,
    }
    impl UpdateSnapshotSchedule {
        /// Creates a new `UpdateSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSnapshotScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <code>ListVolumes</code> operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn start_at(mut self, input: i32) -> Self {
            self.inner = self.inner.start_at(input);
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>
        pub fn set_start_at(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_start_at(input);
            self
        }
        /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
        pub fn recurrence_in_hours(mut self, input: i32) -> Self {
            self.inner = self.inner.recurrence_in_hours(input);
            self
        }
        /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
        pub fn set_recurrence_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_recurrence_in_hours(input);
            self
        }
        /// <p>Optional description of the snapshot that overwrites the existing description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Optional description of the snapshot that overwrites the existing description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVTLDeviceType`.
    ///
    /// <p>Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium changer type for the tape gateway. This operation enables you to select a different type of medium changer after a tape gateway is activated. This operation is only supported in the tape gateway type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVTLDeviceType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_vtl_device_type_input::Builder,
    }
    impl UpdateVTLDeviceType {
        /// Creates a new `UpdateVTLDeviceType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVtlDeviceTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVTLDeviceTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
        pub fn vtl_device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vtl_device_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
        pub fn set_vtl_device_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vtl_device_arn(input);
            self
        }
        /// <p>The type of medium changer you want to select.</p>
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_type(input.into());
            self
        }
        /// <p>The type of medium changer you want to select.</p>
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
