// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ActivateGatewayInput`](crate::input::ActivateGatewayInput)
pub mod activate_gateway_input {
    /// A builder for [`ActivateGatewayInput`](crate::input::ActivateGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activation_key: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
        pub(crate) gateway_timezone: std::option::Option<std::string::String>,
        pub(crate) gateway_region: std::option::Option<std::string::String>,
        pub(crate) gateway_type: std::option::Option<std::string::String>,
        pub(crate) tape_drive_type: std::option::Option<std::string::String>,
        pub(crate) medium_changer_type: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET
        /// request with redirects enabled to the gateway IP address (port 80). The redirect URL
        /// returned in the response provides you the activation key for your gateway in the query
        /// string parameter <code>activationKey</code>. It may also include other activation-related
        /// parameters, however, these are merely defaults -- the arguments you pass to the
        /// <code>ActivateGateway</code> API call determine the actual configuration of your
        /// gateway.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
        /// key</a> in the <i>Storage Gateway User Guide</i>.</p>
        pub fn activation_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.activation_key = Some(input.into());
            self
        }
        /// <p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET
        /// request with redirects enabled to the gateway IP address (port 80). The redirect URL
        /// returned in the response provides you the activation key for your gateway in the query
        /// string parameter <code>activationKey</code>. It may also include other activation-related
        /// parameters, however, these are merely defaults -- the arguments you pass to the
        /// <code>ActivateGateway</code> API call determine the actual configuration of your
        /// gateway.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
        /// key</a> in the <i>Storage Gateway User Guide</i>.</p>
        pub fn set_activation_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activation_key = input;
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// <p>A value that indicates the time zone you want to set for the gateway. The time zone is
        /// of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4
        /// hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is
        /// used, for example, for scheduling snapshots and your gateway's maintenance
        /// schedule.</p>
        pub fn gateway_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_timezone = Some(input.into());
            self
        }
        /// <p>A value that indicates the time zone you want to set for the gateway. The time zone is
        /// of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4
        /// hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is
        /// used, for example, for scheduling snapshots and your gateway's maintenance
        /// schedule.</p>
        pub fn set_gateway_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_timezone = input;
            self
        }
        /// <p>A value that indicates the Amazon Web Services Region where you want to store your data.
        /// The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region
        /// as the Amazon Web Services Region in your <code>Host</code> header in the request. For more
        /// information about available Amazon Web Services Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.</p>
        ///
        /// <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.
        ///
        /// </p>
        pub fn gateway_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_region = Some(input.into());
            self
        }
        /// <p>A value that indicates the Amazon Web Services Region where you want to store your data.
        /// The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region
        /// as the Amazon Web Services Region in your <code>Host</code> header in the request. For more
        /// information about available Amazon Web Services Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.</p>
        ///
        /// <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.
        ///
        /// </p>
        pub fn set_gateway_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_region = input;
            self
        }
        /// <p>A value that defines the type of gateway to activate. The type specified is critical to
        /// all later functions of the gateway and cannot be changed after activation. The default
        /// value is <code>CACHED</code>.</p>
        ///
        /// <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> |
        /// <code>FILE_S3</code> | <code>FILE_FSX_SMB|</code>
        /// </p>
        pub fn gateway_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_type = Some(input.into());
            self
        }
        /// <p>A value that defines the type of gateway to activate. The type specified is critical to
        /// all later functions of the gateway and cannot be changed after activation. The default
        /// value is <code>CACHED</code>.</p>
        ///
        /// <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> |
        /// <code>FILE_S3</code> | <code>FILE_FSX_SMB|</code>
        /// </p>
        pub fn set_gateway_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_type = input;
            self
        }
        /// <p>The value that indicates the type of tape drive to use for tape gateway. This field is
        /// optional.</p>
        ///
        /// <p>Valid Values: <code>IBM-ULT3580-TD5</code>
        /// </p>
        pub fn tape_drive_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_drive_type = Some(input.into());
            self
        }
        /// <p>The value that indicates the type of tape drive to use for tape gateway. This field is
        /// optional.</p>
        ///
        /// <p>Valid Values: <code>IBM-ULT3580-TD5</code>
        /// </p>
        pub fn set_tape_drive_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tape_drive_type = input;
            self
        }
        /// <p>The value that indicates the type of medium changer to use for tape gateway. This field
        /// is optional.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn medium_changer_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.medium_changer_type = Some(input.into());
            self
        }
        /// <p>The value that indicates the type of medium changer to use for tape gateway. This field
        /// is optional.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn set_medium_changer_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.medium_changer_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that can be
        /// represented in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that can be
        /// represented in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateGatewayInput`](crate::input::ActivateGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateGatewayInput {
                activation_key: self.activation_key,
                gateway_name: self.gateway_name,
                gateway_timezone: self.gateway_timezone,
                gateway_region: self.gateway_region,
                gateway_type: self.gateway_type,
                tape_drive_type: self.tape_drive_type,
                medium_changer_type: self.medium_changer_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type ActivateGatewayInputOperationOutputAlias = crate::operation::ActivateGateway;
#[doc(hidden)]
pub type ActivateGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ActivateGatewayInput {
    /// Consumes the builder and constructs an Operation<[`ActivateGateway`](crate::operation::ActivateGateway)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ActivateGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ActivateGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ActivateGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ActivateGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_activate_gateway(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateGateway",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ActivateGatewayInput`](crate::input::ActivateGatewayInput)
    pub fn builder() -> crate::input::activate_gateway_input::Builder {
        crate::input::activate_gateway_input::Builder::default()
    }
}

/// See [`AddCacheInput`](crate::input::AddCacheInput)
pub mod add_cache_input {
    /// A builder for [`AddCacheInput`](crate::input::AddCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `disk_ids`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disk_ids.unwrap_or_default();
            v.push(input.into());
            self.disk_ids = Some(v);
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disk_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AddCacheInput`](crate::input::AddCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddCacheInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddCacheInput {
                gateway_arn: self.gateway_arn,
                disk_ids: self.disk_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AddCacheInputOperationOutputAlias = crate::operation::AddCache;
#[doc(hidden)]
pub type AddCacheInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddCacheInput {
    /// Consumes the builder and constructs an Operation<[`AddCache`](crate::operation::AddCache)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddCache,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddCacheInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddCacheInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddCacheInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.AddCache",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_cache(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddCache::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddCache",
                    "storagegateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddCacheInput`](crate::input::AddCacheInput)
    pub fn builder() -> crate::input::add_cache_input::Builder {
        crate::input::add_cache_input::Builder::default()
    }
}

/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag you want to add to the resource. The value
        /// can be an empty string.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The key-value pair that represents the tag you want to add to the resource. The value
        /// can be an empty string.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.AddTagsToResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`AddUploadBufferInput`](crate::input::AddUploadBufferInput)
pub mod add_upload_buffer_input {
    /// A builder for [`AddUploadBufferInput`](crate::input::AddUploadBufferInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `disk_ids`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disk_ids.unwrap_or_default();
            v.push(input.into());
            self.disk_ids = Some(v);
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disk_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AddUploadBufferInput`](crate::input::AddUploadBufferInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddUploadBufferInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddUploadBufferInput {
                gateway_arn: self.gateway_arn,
                disk_ids: self.disk_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AddUploadBufferInputOperationOutputAlias = crate::operation::AddUploadBuffer;
#[doc(hidden)]
pub type AddUploadBufferInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddUploadBufferInput {
    /// Consumes the builder and constructs an Operation<[`AddUploadBuffer`](crate::operation::AddUploadBuffer)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddUploadBuffer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddUploadBufferInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddUploadBufferInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddUploadBufferInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.AddUploadBuffer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_upload_buffer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddUploadBuffer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddUploadBuffer",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddUploadBufferInput`](crate::input::AddUploadBufferInput)
    pub fn builder() -> crate::input::add_upload_buffer_input::Builder {
        crate::input::add_upload_buffer_input::Builder::default()
    }
}

/// See [`AddWorkingStorageInput`](crate::input::AddWorkingStorageInput)
pub mod add_working_storage_input {
    /// A builder for [`AddWorkingStorageInput`](crate::input::AddWorkingStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disk_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `disk_ids`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn disk_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disk_ids.unwrap_or_default();
            v.push(input.into());
            self.disk_ids = Some(v);
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disk_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AddWorkingStorageInput`](crate::input::AddWorkingStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddWorkingStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddWorkingStorageInput {
                gateway_arn: self.gateway_arn,
                disk_ids: self.disk_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AddWorkingStorageInputOperationOutputAlias = crate::operation::AddWorkingStorage;
#[doc(hidden)]
pub type AddWorkingStorageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddWorkingStorageInput {
    /// Consumes the builder and constructs an Operation<[`AddWorkingStorage`](crate::operation::AddWorkingStorage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddWorkingStorage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddWorkingStorageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddWorkingStorageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddWorkingStorageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.AddWorkingStorage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_working_storage(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddWorkingStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddWorkingStorage",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddWorkingStorageInput`](crate::input::AddWorkingStorageInput)
    pub fn builder() -> crate::input::add_working_storage_input::Builder {
        crate::input::add_working_storage_input::Builder::default()
    }
}

/// See [`AssignTapePoolInput`](crate::input::AssignTapePoolInput)
pub mod assign_tape_pool_input {
    /// A builder for [`AssignTapePoolInput`](crate::input::AssignTapePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the
        /// tape pool.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the
        /// tape pool.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>Set permissions to bypass governance retention. If the lock type of the archived tape is
        /// <code>Governance</code>, the tape's archived age is not older than
        /// <code>RetentionLockInDays</code>, and the user does not already have
        /// <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass
        /// the retention lock. This parameter is set to true by default for calls from the
        /// console.</p>
        ///
        /// <p>Valid values: <code>TRUE</code> | <code>FALSE</code>
        /// </p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Set permissions to bypass governance retention. If the lock type of the archived tape is
        /// <code>Governance</code>, the tape's archived age is not older than
        /// <code>RetentionLockInDays</code>, and the user does not already have
        /// <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass
        /// the retention lock. This parameter is set to true by default for calls from the
        /// console.</p>
        ///
        /// <p>Valid values: <code>TRUE</code> | <code>FALSE</code>
        /// </p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// Consumes the builder and constructs a [`AssignTapePoolInput`](crate::input::AssignTapePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssignTapePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssignTapePoolInput {
                tape_arn: self.tape_arn,
                pool_id: self.pool_id,
                bypass_governance_retention: self.bypass_governance_retention.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AssignTapePoolInputOperationOutputAlias = crate::operation::AssignTapePool;
#[doc(hidden)]
pub type AssignTapePoolInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssignTapePoolInput {
    /// Consumes the builder and constructs an Operation<[`AssignTapePool`](crate::operation::AssignTapePool)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssignTapePool,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssignTapePoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssignTapePoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssignTapePoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.AssignTapePool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_assign_tape_pool(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssignTapePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssignTapePool",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssignTapePoolInput`](crate::input::AssignTapePoolInput)
    pub fn builder() -> crate::input::assign_tape_pool_input::Builder {
        crate::input::assign_tape_pool_input::Builder::default()
    }
}

/// See [`AssociateFileSystemInput`](crate::input::AssociateFileSystemInput)
pub mod associate_file_system_input {
    /// A builder for [`AssociateFileSystemInput`](crate::input::AssociateFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) endpoint_network_configuration:
            std::option::Option<crate::model::EndpointNetworkConfiguration>,
    }
    impl Builder {
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>A unique string value that you supply that is used by the FSx File Gateway to ensure
        /// idempotent file system association creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique string value that you supply that is used by the FSx File Gateway to ensure
        /// idempotent file system association creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with
        /// the FSx File Gateway.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with
        /// the FSx File Gateway.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the file system association. Each tag is
        /// a key-value pair.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the file system association. Each tag is
        /// a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>Specifies the network configuration information for the gateway associated with the
        /// Amazon FSx file system.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's
        /// <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn endpoint_network_configuration(
            mut self,
            input: crate::model::EndpointNetworkConfiguration,
        ) -> Self {
            self.endpoint_network_configuration = Some(input);
            self
        }
        /// <p>Specifies the network configuration information for the gateway associated with the
        /// Amazon FSx file system.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's
        /// <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn set_endpoint_network_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointNetworkConfiguration>,
        ) -> Self {
            self.endpoint_network_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFileSystemInput`](crate::input::AssociateFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateFileSystemInput {
                user_name: self.user_name,
                password: self.password,
                client_token: self.client_token,
                gateway_arn: self.gateway_arn,
                location_arn: self.location_arn,
                tags: self.tags,
                audit_destination_arn: self.audit_destination_arn,
                cache_attributes: self.cache_attributes,
                endpoint_network_configuration: self.endpoint_network_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateFileSystemInputOperationOutputAlias = crate::operation::AssociateFileSystem;
#[doc(hidden)]
pub type AssociateFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`AssociateFileSystem`](crate::operation::AssociateFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.AssociateFileSystem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_file_system(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateFileSystem",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateFileSystemInput`](crate::input::AssociateFileSystemInput)
    pub fn builder() -> crate::input::associate_file_system_input::Builder {
        crate::input::associate_file_system_input::Builder::default()
    }
}

/// See [`AttachVolumeInput`](crate::input::AttachVolumeInput)
pub mod attach_volume_input {
    /// A builder for [`AttachVolumeInput`](crate::input::AttachVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) target_name: std::option::Option<std::string::String>,
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) disk_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume
        /// to.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume
        /// to.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_name = Some(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The unique device ID or other distinguishing data that identifies the local disk used to
        /// create the volume. This value is only required when you are attaching a stored
        /// volume.</p>
        pub fn disk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_id = Some(input.into());
            self
        }
        /// <p>The unique device ID or other distinguishing data that identifies the local disk used to
        /// create the volume. This value is only required when you are attaching a stored
        /// volume.</p>
        pub fn set_disk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachVolumeInput`](crate::input::AttachVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachVolumeInput {
                gateway_arn: self.gateway_arn,
                target_name: self.target_name,
                volume_arn: self.volume_arn,
                network_interface_id: self.network_interface_id,
                disk_id: self.disk_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachVolumeInputOperationOutputAlias = crate::operation::AttachVolume;
#[doc(hidden)]
pub type AttachVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AttachVolumeInput {
    /// Consumes the builder and constructs an Operation<[`AttachVolume`](crate::operation::AttachVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.AttachVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_attach_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachVolume",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachVolumeInput`](crate::input::AttachVolumeInput)
    pub fn builder() -> crate::input::attach_volume_input::Builder {
        crate::input::attach_volume_input::Builder::default()
    }
}

/// See [`CancelArchivalInput`](crate::input::CancelArchivalInput)
pub mod cancel_archival_input {
    /// A builder for [`CancelArchivalInput`](crate::input::CancelArchivalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
        /// for.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
        /// for.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelArchivalInput`](crate::input::CancelArchivalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelArchivalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelArchivalInput {
                gateway_arn: self.gateway_arn,
                tape_arn: self.tape_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelArchivalInputOperationOutputAlias = crate::operation::CancelArchival;
#[doc(hidden)]
pub type CancelArchivalInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelArchivalInput {
    /// Consumes the builder and constructs an Operation<[`CancelArchival`](crate::operation::CancelArchival)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelArchival,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelArchivalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelArchivalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelArchivalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CancelArchival",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_archival(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelArchival::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelArchival",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelArchivalInput`](crate::input::CancelArchivalInput)
    pub fn builder() -> crate::input::cancel_archival_input::Builder {
        crate::input::cancel_archival_input::Builder::default()
    }
}

/// See [`CancelRetrievalInput`](crate::input::CancelRetrievalInput)
pub mod cancel_retrieval_input {
    /// A builder for [`CancelRetrievalInput`](crate::input::CancelRetrievalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tape_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
        /// for.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
        /// for.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelRetrievalInput`](crate::input::CancelRetrievalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelRetrievalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelRetrievalInput {
                gateway_arn: self.gateway_arn,
                tape_arn: self.tape_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelRetrievalInputOperationOutputAlias = crate::operation::CancelRetrieval;
#[doc(hidden)]
pub type CancelRetrievalInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelRetrievalInput {
    /// Consumes the builder and constructs an Operation<[`CancelRetrieval`](crate::operation::CancelRetrieval)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelRetrieval,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelRetrievalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelRetrievalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelRetrievalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CancelRetrieval",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_retrieval(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelRetrieval::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelRetrieval",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelRetrievalInput`](crate::input::CancelRetrievalInput)
    pub fn builder() -> crate::input::cancel_retrieval_input::Builder {
        crate::input::cancel_retrieval_input::Builder::default()
    }
}

/// See [`CreateCachediScsiVolumeInput`](crate::input::CreateCachediScsiVolumeInput)
pub mod create_cachedi_scsi_volume_input {
    /// A builder for [`CreateCachediScsiVolumeInput`](crate::input::CreateCachediScsiVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) volume_size_in_bytes: std::option::Option<i64>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) target_name: std::option::Option<std::string::String>,
        pub(crate) source_volume_arn: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn volume_size_in_bytes(mut self, input: i64) -> Self {
            self.volume_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_size_in_bytes = input;
            self
        }
        /// <p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_name = Some(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_name = input;
            self
        }
        /// <p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact
        /// copy of the specified existing volume's latest recovery point. The
        /// <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than
        /// the size of the existing volume, in bytes.</p>
        pub fn source_volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_volume_arn = Some(input.into());
            self
        }
        /// <p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact
        /// copy of the specified existing volume's latest recovery point. The
        /// <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than
        /// the size of the existing volume, in bytes.</p>
        pub fn set_source_volume_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_volume_arn = input;
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that you can
        /// represent in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that you can
        /// represent in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCachediScsiVolumeInput`](crate::input::CreateCachediScsiVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCachediScsiVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCachediScsiVolumeInput {
                gateway_arn: self.gateway_arn,
                volume_size_in_bytes: self.volume_size_in_bytes.unwrap_or_default(),
                snapshot_id: self.snapshot_id,
                target_name: self.target_name,
                source_volume_arn: self.source_volume_arn,
                network_interface_id: self.network_interface_id,
                client_token: self.client_token,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCachediScsiVolumeInputOperationOutputAlias =
    crate::operation::CreateCachediSCSIVolume;
#[doc(hidden)]
pub type CreateCachediScsiVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCachediScsiVolumeInput {
    /// Consumes the builder and constructs an Operation<[`CreateCachediSCSIVolume`](crate::operation::CreateCachediSCSIVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCachediSCSIVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCachediScsiVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCachediScsiVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCachediScsiVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateCachediSCSIVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_cachedi_scsi_volume(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCachediSCSIVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCachediSCSIVolume",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCachediScsiVolumeInput`](crate::input::CreateCachediScsiVolumeInput)
    pub fn builder() -> crate::input::create_cachedi_scsi_volume_input::Builder {
        crate::input::create_cachedi_scsi_volume_input::Builder::default()
    }
}

/// See [`CreateNfsFileShareInput`](crate::input::CreateNfsFileShareInput)
pub mod create_nfs_file_share_input {
    /// A builder for [`CreateNfsFileShareInput`](crate::input::CreateNfsFileShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) nfs_file_share_defaults: std::option::Option<crate::model::NfsFileShareDefaults>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) default_storage_class: std::option::Option<std::string::String>,
        pub(crate) object_acl: std::option::Option<crate::model::ObjectAcl>,
        pub(crate) client_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) squash: std::option::Option<std::string::String>,
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) guess_mime_type_enabled: std::option::Option<bool>,
        pub(crate) requester_pays: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_share_name: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) notification_policy: std::option::Option<std::string::String>,
        pub(crate) vpc_endpoint_dns_name: std::option::Option<std::string::String>,
        pub(crate) bucket_region: std::option::Option<std::string::String>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>File share default values. Optional.</p>
        pub fn nfs_file_share_defaults(
            mut self,
            input: crate::model::NfsFileShareDefaults,
        ) -> Self {
            self.nfs_file_share_defaults = Some(input);
            self
        }
        /// <p>File share default values. Optional.</p>
        pub fn set_nfs_file_share_defaults(
            mut self,
            input: std::option::Option<crate::model::NfsFileShareDefaults>,
        ) -> Self {
            self.nfs_file_share_defaults = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file
        /// share.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file
        /// share.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_storage_class = Some(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_storage_class = input;
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.object_acl = Some(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.object_acl = input;
            self
        }
        /// Appends an item to `client_list`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn client_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.client_list.unwrap_or_default();
            v.push(input.into());
            self.client_list = Some(v);
            self
        }
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.client_list = input;
            self
        }
        /// <p>A value that maps a user to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn squash(mut self, input: impl Into<std::string::String>) -> Self {
            self.squash = Some(input.into());
            self
        }
        /// <p>A value that maps a user to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn set_squash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.squash = input;
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.guess_mime_type_enabled = Some(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.guess_mime_type_enabled = input;
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.requester_pays = Some(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_name = Some(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_name = input;
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_policy = Some(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_policy = input;
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_dns_name = Some(input.into());
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_dns_name = input;
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_region = Some(input.into());
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_region = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNfsFileShareInput`](crate::input::CreateNfsFileShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNfsFileShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNfsFileShareInput {
                client_token: self.client_token,
                nfs_file_share_defaults: self.nfs_file_share_defaults,
                gateway_arn: self.gateway_arn,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                role: self.role,
                location_arn: self.location_arn,
                default_storage_class: self.default_storage_class,
                object_acl: self.object_acl,
                client_list: self.client_list,
                squash: self.squash,
                read_only: self.read_only,
                guess_mime_type_enabled: self.guess_mime_type_enabled,
                requester_pays: self.requester_pays,
                tags: self.tags,
                file_share_name: self.file_share_name,
                cache_attributes: self.cache_attributes,
                notification_policy: self.notification_policy,
                vpc_endpoint_dns_name: self.vpc_endpoint_dns_name,
                bucket_region: self.bucket_region,
                audit_destination_arn: self.audit_destination_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNfsFileShareInputOperationOutputAlias = crate::operation::CreateNFSFileShare;
#[doc(hidden)]
pub type CreateNfsFileShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNfsFileShareInput {
    /// Consumes the builder and constructs an Operation<[`CreateNFSFileShare`](crate::operation::CreateNFSFileShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNFSFileShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNfsFileShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNfsFileShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNfsFileShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateNFSFileShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_nfs_file_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNFSFileShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNFSFileShare",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNfsFileShareInput`](crate::input::CreateNfsFileShareInput)
    pub fn builder() -> crate::input::create_nfs_file_share_input::Builder {
        crate::input::create_nfs_file_share_input::Builder::default()
    }
}

/// See [`CreateSmbFileShareInput`](crate::input::CreateSmbFileShareInput)
pub mod create_smb_file_share_input {
    /// A builder for [`CreateSmbFileShareInput`](crate::input::CreateSmbFileShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) default_storage_class: std::option::Option<std::string::String>,
        pub(crate) object_acl: std::option::Option<crate::model::ObjectAcl>,
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) guess_mime_type_enabled: std::option::Option<bool>,
        pub(crate) requester_pays: std::option::Option<bool>,
        pub(crate) smbacl_enabled: std::option::Option<bool>,
        pub(crate) access_based_enumeration: std::option::Option<bool>,
        pub(crate) admin_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) valid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) invalid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
        pub(crate) authentication: std::option::Option<std::string::String>,
        pub(crate) case_sensitivity: std::option::Option<crate::model::CaseSensitivity>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_share_name: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) notification_policy: std::option::Option<std::string::String>,
        pub(crate) vpc_endpoint_dns_name: std::option::Option<std::string::String>,
        pub(crate) bucket_region: std::option::Option<std::string::String>,
        pub(crate) oplocks_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The ARN of the S3 File Gateway on which you want to create a file share.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 File Gateway on which you want to create a file share.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_storage_class = Some(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_storage_class = input;
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.object_acl = Some(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.object_acl = input;
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.guess_mime_type_enabled = Some(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.guess_mime_type_enabled = input;
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.requester_pays = Some(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays = input;
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn smbacl_enabled(mut self, input: bool) -> Self {
            self.smbacl_enabled = Some(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_smbacl_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.smbacl_enabled = input;
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn access_based_enumeration(mut self, input: bool) -> Self {
            self.access_based_enumeration = Some(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn set_access_based_enumeration(mut self, input: std::option::Option<bool>) -> Self {
            self.access_based_enumeration = input;
            self
        }
        /// Appends an item to `admin_user_list`.
        ///
        /// To override the contents of this collection use [`set_admin_user_list`](Self::set_admin_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that will be granted administrator
        /// privileges on the file share. These users can do all file operations as the super-user.
        /// Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
        /// <code>@group1</code>, and <code>@DOMAIN\group1</code>.</p>
        ///
        /// <important>
        /// <p>Use this option very carefully, because any user in this list can do anything they
        /// like on the file share, regardless of file permissions.</p>
        /// </important>
        pub fn admin_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.admin_user_list.unwrap_or_default();
            v.push(input.into());
            self.admin_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that will be granted administrator
        /// privileges on the file share. These users can do all file operations as the super-user.
        /// Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
        /// <code>@group1</code>, and <code>@DOMAIN\group1</code>.</p>
        ///
        /// <important>
        /// <p>Use this option very carefully, because any user in this list can do anything they
        /// like on the file share, regardless of file permissions.</p>
        /// </important>
        pub fn set_admin_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.admin_user_list = input;
            self
        }
        /// Appends an item to `valid_user_list`.
        ///
        /// To override the contents of this collection use [`set_valid_user_list`](Self::set_valid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// <a href=""></a> share. A group must be prefixed with the @ character. Acceptable formats
        /// include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn valid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.valid_user_list.unwrap_or_default();
            v.push(input.into());
            self.valid_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// <a href=""></a> share. A group must be prefixed with the @ character. Acceptable formats
        /// include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_valid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.valid_user_list = input;
            self
        }
        /// Appends an item to `invalid_user_list`.
        ///
        /// To override the contents of this collection use [`set_invalid_user_list`](Self::set_invalid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn invalid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.invalid_user_list.unwrap_or_default();
            v.push(input.into());
            self.invalid_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_invalid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.invalid_user_list = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// <p>The authentication method that users use to access the file share. The default is
        /// <code>ActiveDirectory</code>.</p>
        ///
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code>
        /// </p>
        pub fn authentication(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication = Some(input.into());
            self
        }
        /// <p>The authentication method that users use to access the file share. The default is
        /// <code>ActiveDirectory</code>.</p>
        ///
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code>
        /// </p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn case_sensitivity(mut self, input: crate::model::CaseSensitivity) -> Self {
            self.case_sensitivity = Some(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn set_case_sensitivity(
            mut self,
            input: std::option::Option<crate::model::CaseSensitivity>,
        ) -> Self {
            self.case_sensitivity = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_name = Some(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_name = input;
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_policy = Some(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_policy = input;
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_dns_name = Some(input.into());
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_dns_name = input;
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_region = Some(input.into());
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_region = input;
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn oplocks_enabled(mut self, input: bool) -> Self {
            self.oplocks_enabled = Some(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_oplocks_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.oplocks_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSmbFileShareInput`](crate::input::CreateSmbFileShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSmbFileShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSmbFileShareInput {
                client_token: self.client_token,
                gateway_arn: self.gateway_arn,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                role: self.role,
                location_arn: self.location_arn,
                default_storage_class: self.default_storage_class,
                object_acl: self.object_acl,
                read_only: self.read_only,
                guess_mime_type_enabled: self.guess_mime_type_enabled,
                requester_pays: self.requester_pays,
                smbacl_enabled: self.smbacl_enabled,
                access_based_enumeration: self.access_based_enumeration,
                admin_user_list: self.admin_user_list,
                valid_user_list: self.valid_user_list,
                invalid_user_list: self.invalid_user_list,
                audit_destination_arn: self.audit_destination_arn,
                authentication: self.authentication,
                case_sensitivity: self.case_sensitivity,
                tags: self.tags,
                file_share_name: self.file_share_name,
                cache_attributes: self.cache_attributes,
                notification_policy: self.notification_policy,
                vpc_endpoint_dns_name: self.vpc_endpoint_dns_name,
                bucket_region: self.bucket_region,
                oplocks_enabled: self.oplocks_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSmbFileShareInputOperationOutputAlias = crate::operation::CreateSMBFileShare;
#[doc(hidden)]
pub type CreateSmbFileShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSmbFileShareInput {
    /// Consumes the builder and constructs an Operation<[`CreateSMBFileShare`](crate::operation::CreateSMBFileShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSMBFileShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSmbFileShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSmbFileShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSmbFileShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateSMBFileShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_smb_file_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSMBFileShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSMBFileShare",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSmbFileShareInput`](crate::input::CreateSmbFileShareInput)
    pub fn builder() -> crate::input::create_smb_file_share_input::Builder {
        crate::input::create_smb_file_share_input::Builder::default()
    }
}

/// See [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
pub mod create_snapshot_input {
    /// A builder for [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) snapshot_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn snapshot_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_description = Some(input.into());
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn set_snapshot_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotInput {
                volume_arn: self.volume_arn,
                snapshot_description: self.snapshot_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotInputOperationOutputAlias = crate::operation::CreateSnapshot;
#[doc(hidden)]
pub type CreateSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshot`](crate::operation::CreateSnapshot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateSnapshot",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshot",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
}

/// See [`CreateSnapshotFromVolumeRecoveryPointInput`](crate::input::CreateSnapshotFromVolumeRecoveryPointInput)
pub mod create_snapshot_from_volume_recovery_point_input {
    /// A builder for [`CreateSnapshotFromVolumeRecoveryPointInput`](crate::input::CreateSnapshotFromVolumeRecoveryPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) snapshot_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn snapshot_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_description = Some(input.into());
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn set_snapshot_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotFromVolumeRecoveryPointInput`](crate::input::CreateSnapshotFromVolumeRecoveryPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotFromVolumeRecoveryPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotFromVolumeRecoveryPointInput {
                volume_arn: self.volume_arn,
                snapshot_description: self.snapshot_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotFromVolumeRecoveryPointInputOperationOutputAlias =
    crate::operation::CreateSnapshotFromVolumeRecoveryPoint;
#[doc(hidden)]
pub type CreateSnapshotFromVolumeRecoveryPointInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateSnapshotFromVolumeRecoveryPointInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshotFromVolumeRecoveryPoint`](crate::operation::CreateSnapshotFromVolumeRecoveryPoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshotFromVolumeRecoveryPoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSnapshotFromVolumeRecoveryPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSnapshotFromVolumeRecoveryPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSnapshotFromVolumeRecoveryPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateSnapshotFromVolumeRecoveryPoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot_from_volume_recovery_point(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshotFromVolumeRecoveryPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshotFromVolumeRecoveryPoint",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotFromVolumeRecoveryPointInput`](crate::input::CreateSnapshotFromVolumeRecoveryPointInput)
    pub fn builder() -> crate::input::create_snapshot_from_volume_recovery_point_input::Builder {
        crate::input::create_snapshot_from_volume_recovery_point_input::Builder::default()
    }
}

/// See [`CreateStorediScsiVolumeInput`](crate::input::CreateStorediScsiVolumeInput)
pub mod create_storedi_scsi_volume_input {
    /// A builder for [`CreateStorediScsiVolumeInput`](crate::input::CreateStorediScsiVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) disk_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) preserve_existing_data: std::option::Option<bool>,
        pub(crate) target_name: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The unique identifier for the gateway local disk that is configured as a stored volume.
        /// Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to
        /// list disk IDs for a gateway.</p>
        pub fn disk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the gateway local disk that is configured as a stored volume.
        /// Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to
        /// list disk IDs for a gateway.</p>
        pub fn set_disk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_id = input;
            self
        }
        /// <p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise,
        /// set to <code>false</code> to create an empty volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn preserve_existing_data(mut self, input: bool) -> Self {
            self.preserve_existing_data = Some(input);
            self
        }
        /// <p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise,
        /// set to <code>false</code> to create an empty volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_preserve_existing_data(mut self, input: std::option::Option<bool>) -> Self {
            self.preserve_existing_data = input;
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_name = Some(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_name = input;
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStorediScsiVolumeInput`](crate::input::CreateStorediScsiVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStorediScsiVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStorediScsiVolumeInput {
                gateway_arn: self.gateway_arn,
                disk_id: self.disk_id,
                snapshot_id: self.snapshot_id,
                preserve_existing_data: self.preserve_existing_data.unwrap_or_default(),
                target_name: self.target_name,
                network_interface_id: self.network_interface_id,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStorediScsiVolumeInputOperationOutputAlias =
    crate::operation::CreateStorediSCSIVolume;
#[doc(hidden)]
pub type CreateStorediScsiVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStorediScsiVolumeInput {
    /// Consumes the builder and constructs an Operation<[`CreateStorediSCSIVolume`](crate::operation::CreateStorediSCSIVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStorediSCSIVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStorediScsiVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStorediScsiVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStorediScsiVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateStorediSCSIVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_storedi_scsi_volume(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStorediSCSIVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStorediSCSIVolume",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStorediScsiVolumeInput`](crate::input::CreateStorediScsiVolumeInput)
    pub fn builder() -> crate::input::create_storedi_scsi_volume_input::Builder {
        crate::input::create_storedi_scsi_volume_input::Builder::default()
    }
}

/// See [`CreateTapePoolInput`](crate::input::CreateTapePoolInput)
pub mod create_tape_pool_input {
    /// A builder for [`CreateTapePoolInput`](crate::input::CreateTapePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_name: std::option::Option<std::string::String>,
        pub(crate) storage_class: std::option::Option<crate::model::TapeStorageClass>,
        pub(crate) retention_lock_type: std::option::Option<crate::model::RetentionLockType>,
        pub(crate) retention_lock_time_in_days: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the new custom tape pool.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_name = Some(input.into());
            self
        }
        /// <p>The name of the new custom tape pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_name = input;
            self
        }
        /// <p>The storage class that is associated with the new custom pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn storage_class(mut self, input: crate::model::TapeStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The storage class that is associated with the new custom pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TapeStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>Tape retention lock can be configured in two modes. When configured in governance mode,
        /// Amazon Web Services accounts with specific IAM permissions are authorized to remove the
        /// tape retention lock from archived virtual tapes. When configured in compliance mode, the
        /// tape retention lock cannot be removed by any user, including the root Amazon Web Services account.</p>
        pub fn retention_lock_type(mut self, input: crate::model::RetentionLockType) -> Self {
            self.retention_lock_type = Some(input);
            self
        }
        /// <p>Tape retention lock can be configured in two modes. When configured in governance mode,
        /// Amazon Web Services accounts with specific IAM permissions are authorized to remove the
        /// tape retention lock from archived virtual tapes. When configured in compliance mode, the
        /// tape retention lock cannot be removed by any user, including the root Amazon Web Services account.</p>
        pub fn set_retention_lock_type(
            mut self,
            input: std::option::Option<crate::model::RetentionLockType>,
        ) -> Self {
            self.retention_lock_type = input;
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to
        /// 100 years (36,500 days).</p>
        pub fn retention_lock_time_in_days(mut self, input: i32) -> Self {
            self.retention_lock_time_in_days = Some(input);
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to
        /// 100 years (36,500 days).</p>
        pub fn set_retention_lock_time_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_lock_time_in_days = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTapePoolInput`](crate::input::CreateTapePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTapePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTapePoolInput {
                pool_name: self.pool_name,
                storage_class: self.storage_class,
                retention_lock_type: self.retention_lock_type,
                retention_lock_time_in_days: self.retention_lock_time_in_days,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTapePoolInputOperationOutputAlias = crate::operation::CreateTapePool;
#[doc(hidden)]
pub type CreateTapePoolInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTapePoolInput {
    /// Consumes the builder and constructs an Operation<[`CreateTapePool`](crate::operation::CreateTapePool)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTapePool,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTapePoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTapePoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTapePoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateTapePool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_tape_pool(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTapePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTapePool",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTapePoolInput`](crate::input::CreateTapePoolInput)
    pub fn builder() -> crate::input::create_tape_pool_input::Builder {
        crate::input::create_tape_pool_input::Builder::default()
    }
}

/// See [`CreateTapesInput`](crate::input::CreateTapesInput)
pub mod create_tapes_input {
    /// A builder for [`CreateTapesInput`](crate::input::CreateTapesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tape_size_in_bytes: std::option::Option<i64>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) num_tapes_to_create: std::option::Option<i32>,
        pub(crate) tape_barcode_prefix: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) worm: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tapes with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tapes with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The size, in bytes, of the virtual tapes that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.tape_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tapes that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_size_in_bytes = input;
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        ///
        /// <note>
        /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple
        /// times.</p>
        /// </note>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        ///
        /// <note>
        /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple
        /// times.</p>
        /// </note>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The number of virtual tapes that you want to create.</p>
        pub fn num_tapes_to_create(mut self, input: i32) -> Self {
            self.num_tapes_to_create = Some(input);
            self
        }
        /// <p>The number of virtual tapes that you want to create.</p>
        pub fn set_num_tapes_to_create(mut self, input: std::option::Option<i32>) -> Self {
            self.num_tapes_to_create = input;
            self
        }
        /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This
        /// prefix makes the barcode unique.</p>
        ///
        /// <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
        /// from A to Z.</p>
        /// </note>
        pub fn tape_barcode_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_barcode_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This
        /// prefix makes the barcode unique.</p>
        ///
        /// <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
        /// from A to Z.</p>
        /// </note>
        pub fn set_tape_barcode_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tape_barcode_prefix = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn worm(mut self, input: bool) -> Self {
            self.worm = Some(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.worm = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTapesInput`](crate::input::CreateTapesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTapesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTapesInput {
                gateway_arn: self.gateway_arn,
                tape_size_in_bytes: self.tape_size_in_bytes,
                client_token: self.client_token,
                num_tapes_to_create: self.num_tapes_to_create,
                tape_barcode_prefix: self.tape_barcode_prefix,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                pool_id: self.pool_id,
                worm: self.worm.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTapesInputOperationOutputAlias = crate::operation::CreateTapes;
#[doc(hidden)]
pub type CreateTapesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTapesInput {
    /// Consumes the builder and constructs an Operation<[`CreateTapes`](crate::operation::CreateTapes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTapes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTapesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTapesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTapesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateTapes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_tapes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTapes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTapes",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTapesInput`](crate::input::CreateTapesInput)
    pub fn builder() -> crate::input::create_tapes_input::Builder {
        crate::input::create_tapes_input::Builder::default()
    }
}

/// See [`CreateTapeWithBarcodeInput`](crate::input::CreateTapeWithBarcodeInput)
pub mod create_tape_with_barcode_input {
    /// A builder for [`CreateTapeWithBarcodeInput`](crate::input::CreateTapeWithBarcodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tape_size_in_bytes: std::option::Option<i64>,
        pub(crate) tape_barcode: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) worm: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tape with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tape with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The size, in bytes, of the virtual tape that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.tape_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tape that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_size_in_bytes = input;
            self
        }
        /// <p>The barcode that you want to assign to the tape.</p>
        ///
        /// <note>
        /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been
        /// deleted.</p>
        /// </note>
        pub fn tape_barcode(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_barcode = Some(input.into());
            self
        }
        /// <p>The barcode that you want to assign to the tape.</p>
        ///
        /// <note>
        /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been
        /// deleted.</p>
        /// </note>
        pub fn set_tape_barcode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_barcode = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn worm(mut self, input: bool) -> Self {
            self.worm = Some(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.worm = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
        /// tag is a key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
        /// tag is a key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTapeWithBarcodeInput`](crate::input::CreateTapeWithBarcodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTapeWithBarcodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTapeWithBarcodeInput {
                gateway_arn: self.gateway_arn,
                tape_size_in_bytes: self.tape_size_in_bytes,
                tape_barcode: self.tape_barcode,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                pool_id: self.pool_id,
                worm: self.worm.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTapeWithBarcodeInputOperationOutputAlias = crate::operation::CreateTapeWithBarcode;
#[doc(hidden)]
pub type CreateTapeWithBarcodeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTapeWithBarcodeInput {
    /// Consumes the builder and constructs an Operation<[`CreateTapeWithBarcode`](crate::operation::CreateTapeWithBarcode)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTapeWithBarcode,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTapeWithBarcodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTapeWithBarcodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTapeWithBarcodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.CreateTapeWithBarcode",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_tape_with_barcode(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTapeWithBarcode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTapeWithBarcode",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTapeWithBarcodeInput`](crate::input::CreateTapeWithBarcodeInput)
    pub fn builder() -> crate::input::create_tape_with_barcode_input::Builder {
        crate::input::create_tape_with_barcode_input::Builder::default()
    }
}

/// See [`DeleteAutomaticTapeCreationPolicyInput`](crate::input::DeleteAutomaticTapeCreationPolicyInput)
pub mod delete_automatic_tape_creation_policy_input {
    /// A builder for [`DeleteAutomaticTapeCreationPolicyInput`](crate::input::DeleteAutomaticTapeCreationPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAutomaticTapeCreationPolicyInput`](crate::input::DeleteAutomaticTapeCreationPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAutomaticTapeCreationPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAutomaticTapeCreationPolicyInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAutomaticTapeCreationPolicyInputOperationOutputAlias =
    crate::operation::DeleteAutomaticTapeCreationPolicy;
#[doc(hidden)]
pub type DeleteAutomaticTapeCreationPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAutomaticTapeCreationPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAutomaticTapeCreationPolicy`](crate::operation::DeleteAutomaticTapeCreationPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAutomaticTapeCreationPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAutomaticTapeCreationPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAutomaticTapeCreationPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAutomaticTapeCreationPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteAutomaticTapeCreationPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_automatic_tape_creation_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAutomaticTapeCreationPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAutomaticTapeCreationPolicy",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAutomaticTapeCreationPolicyInput`](crate::input::DeleteAutomaticTapeCreationPolicyInput)
    pub fn builder() -> crate::input::delete_automatic_tape_creation_policy_input::Builder {
        crate::input::delete_automatic_tape_creation_policy_input::Builder::default()
    }
}

/// See [`DeleteBandwidthRateLimitInput`](crate::input::DeleteBandwidthRateLimitInput)
pub mod delete_bandwidth_rate_limit_input {
    /// A builder for [`DeleteBandwidthRateLimitInput`](crate::input::DeleteBandwidthRateLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to
        /// delete.</p>
        ///
        /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code>
        /// </p>
        pub fn bandwidth_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth_type = Some(input.into());
            self
        }
        /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to
        /// delete.</p>
        ///
        /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code>
        /// </p>
        pub fn set_bandwidth_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bandwidth_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBandwidthRateLimitInput`](crate::input::DeleteBandwidthRateLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBandwidthRateLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBandwidthRateLimitInput {
                gateway_arn: self.gateway_arn,
                bandwidth_type: self.bandwidth_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBandwidthRateLimitInputOperationOutputAlias =
    crate::operation::DeleteBandwidthRateLimit;
#[doc(hidden)]
pub type DeleteBandwidthRateLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBandwidthRateLimitInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBandwidthRateLimit`](crate::operation::DeleteBandwidthRateLimit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBandwidthRateLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBandwidthRateLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBandwidthRateLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBandwidthRateLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteBandwidthRateLimit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_bandwidth_rate_limit(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBandwidthRateLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBandwidthRateLimit",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBandwidthRateLimitInput`](crate::input::DeleteBandwidthRateLimitInput)
    pub fn builder() -> crate::input::delete_bandwidth_rate_limit_input::Builder {
        crate::input::delete_bandwidth_rate_limit_input::Builder::default()
    }
}

/// See [`DeleteChapCredentialsInput`](crate::input::DeleteChapCredentialsInput)
pub mod delete_chap_credentials_input {
    /// A builder for [`DeleteChapCredentialsInput`](crate::input::DeleteChapCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) initiator_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.initiator_name = Some(input.into());
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initiator_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChapCredentialsInput`](crate::input::DeleteChapCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChapCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChapCredentialsInput {
                target_arn: self.target_arn,
                initiator_name: self.initiator_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChapCredentialsInputOperationOutputAlias = crate::operation::DeleteChapCredentials;
#[doc(hidden)]
pub type DeleteChapCredentialsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteChapCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChapCredentials`](crate::operation::DeleteChapCredentials)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChapCredentials,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChapCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChapCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChapCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteChapCredentials",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_chap_credentials(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChapCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChapCredentials",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChapCredentialsInput`](crate::input::DeleteChapCredentialsInput)
    pub fn builder() -> crate::input::delete_chap_credentials_input::Builder {
        crate::input::delete_chap_credentials_input::Builder::default()
    }
}

/// See [`DeleteFileShareInput`](crate::input::DeleteFileShareInput)
pub mod delete_file_share_input {
    /// A builder for [`DeleteFileShareInput`](crate::input::DeleteFileShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>If this value is set to <code>true</code>, the operation deletes a file share
        /// immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is
        /// not deleted until all data is uploaded to Amazon Web Services. This process aborts the data
        /// upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>If this value is set to <code>true</code>, the operation deletes a file share
        /// immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is
        /// not deleted until all data is uploaded to Amazon Web Services. This process aborts the data
        /// upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileShareInput`](crate::input::DeleteFileShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFileShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFileShareInput {
                file_share_arn: self.file_share_arn,
                force_delete: self.force_delete.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFileShareInputOperationOutputAlias = crate::operation::DeleteFileShare;
#[doc(hidden)]
pub type DeleteFileShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFileShareInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFileShare`](crate::operation::DeleteFileShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFileShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFileShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFileShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFileShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteFileShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_file_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFileShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFileShare",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFileShareInput`](crate::input::DeleteFileShareInput)
    pub fn builder() -> crate::input::delete_file_share_input::Builder {
        crate::input::delete_file_share_input::Builder::default()
    }
}

/// See [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
pub mod delete_gateway_input {
    /// A builder for [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGatewayInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGatewayInputOperationOutputAlias = crate::operation::DeleteGateway;
#[doc(hidden)]
pub type DeleteGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGateway`](crate::operation::DeleteGateway)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_gateway(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGateway",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
    pub fn builder() -> crate::input::delete_gateway_input::Builder {
        crate::input::delete_gateway_input::Builder::default()
    }
}

/// See [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
pub mod delete_snapshot_schedule_input {
    /// A builder for [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The volume which snapshot schedule to delete.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The volume which snapshot schedule to delete.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSnapshotScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSnapshotScheduleInput {
                volume_arn: self.volume_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSnapshotScheduleInputOperationOutputAlias = crate::operation::DeleteSnapshotSchedule;
#[doc(hidden)]
pub type DeleteSnapshotScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSnapshotScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSnapshotSchedule`](crate::operation::DeleteSnapshotSchedule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSnapshotSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSnapshotScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSnapshotScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSnapshotScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteSnapshotSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_snapshot_schedule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSnapshotSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSnapshotSchedule",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
    pub fn builder() -> crate::input::delete_snapshot_schedule_input::Builder {
        crate::input::delete_snapshot_schedule_input::Builder::default()
    }
}

/// See [`DeleteTapeInput`](crate::input::DeleteTapeInput)
pub mod delete_tape_input {
    /// A builder for [`DeleteTapeInput`](crate::input::DeleteTapeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
        /// associated with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
        /// associated with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTapeInput`](crate::input::DeleteTapeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTapeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTapeInput {
                gateway_arn: self.gateway_arn,
                tape_arn: self.tape_arn,
                bypass_governance_retention: self.bypass_governance_retention.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTapeInputOperationOutputAlias = crate::operation::DeleteTape;
#[doc(hidden)]
pub type DeleteTapeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTapeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTape`](crate::operation::DeleteTape)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTape,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTapeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTapeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTapeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteTape",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_tape(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTape::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTape",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTapeInput`](crate::input::DeleteTapeInput)
    pub fn builder() -> crate::input::delete_tape_input::Builder {
        crate::input::delete_tape_input::Builder::default()
    }
}

/// See [`DeleteTapeArchiveInput`](crate::input::DeleteTapeArchiveInput)
pub mod delete_tape_archive_input {
    /// A builder for [`DeleteTapeArchiveInput`](crate::input::DeleteTapeArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
        /// (VTS).</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
        /// (VTS).</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTapeArchiveInput`](crate::input::DeleteTapeArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTapeArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTapeArchiveInput {
                tape_arn: self.tape_arn,
                bypass_governance_retention: self.bypass_governance_retention.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTapeArchiveInputOperationOutputAlias = crate::operation::DeleteTapeArchive;
#[doc(hidden)]
pub type DeleteTapeArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTapeArchiveInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTapeArchive`](crate::operation::DeleteTapeArchive)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTapeArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTapeArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTapeArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTapeArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteTapeArchive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_tape_archive(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTapeArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTapeArchive",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTapeArchiveInput`](crate::input::DeleteTapeArchiveInput)
    pub fn builder() -> crate::input::delete_tape_archive_input::Builder {
        crate::input::delete_tape_archive_input::Builder::default()
    }
}

/// See [`DeleteTapePoolInput`](crate::input::DeleteTapePoolInput)
pub mod delete_tape_pool_input {
    /// A builder for [`DeleteTapePoolInput`](crate::input::DeleteTapePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTapePoolInput`](crate::input::DeleteTapePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTapePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTapePoolInput {
                pool_arn: self.pool_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTapePoolInputOperationOutputAlias = crate::operation::DeleteTapePool;
#[doc(hidden)]
pub type DeleteTapePoolInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTapePoolInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTapePool`](crate::operation::DeleteTapePool)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTapePool,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTapePoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTapePoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTapePoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteTapePool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_tape_pool(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTapePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTapePool",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTapePoolInput`](crate::input::DeleteTapePoolInput)
    pub fn builder() -> crate::input::delete_tape_pool_input::Builder {
        crate::input::delete_tape_pool_input::Builder::default()
    }
}

/// See [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
pub mod delete_volume_input {
    /// A builder for [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVolumeInput {
                volume_arn: self.volume_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVolumeInputOperationOutputAlias = crate::operation::DeleteVolume;
#[doc(hidden)]
pub type DeleteVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVolumeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVolume`](crate::operation::DeleteVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DeleteVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVolume",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
    pub fn builder() -> crate::input::delete_volume_input::Builder {
        crate::input::delete_volume_input::Builder::default()
    }
}

/// See [`DescribeAvailabilityMonitorTestInput`](crate::input::DescribeAvailabilityMonitorTestInput)
pub mod describe_availability_monitor_test_input {
    /// A builder for [`DescribeAvailabilityMonitorTestInput`](crate::input::DescribeAvailabilityMonitorTestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAvailabilityMonitorTestInput`](crate::input::DescribeAvailabilityMonitorTestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAvailabilityMonitorTestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAvailabilityMonitorTestInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAvailabilityMonitorTestInputOperationOutputAlias =
    crate::operation::DescribeAvailabilityMonitorTest;
#[doc(hidden)]
pub type DescribeAvailabilityMonitorTestInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAvailabilityMonitorTestInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAvailabilityMonitorTest`](crate::operation::DescribeAvailabilityMonitorTest)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAvailabilityMonitorTest,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAvailabilityMonitorTestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAvailabilityMonitorTestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAvailabilityMonitorTestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeAvailabilityMonitorTest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_availability_monitor_test(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAvailabilityMonitorTest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAvailabilityMonitorTest",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAvailabilityMonitorTestInput`](crate::input::DescribeAvailabilityMonitorTestInput)
    pub fn builder() -> crate::input::describe_availability_monitor_test_input::Builder {
        crate::input::describe_availability_monitor_test_input::Builder::default()
    }
}

/// See [`DescribeBandwidthRateLimitInput`](crate::input::DescribeBandwidthRateLimitInput)
pub mod describe_bandwidth_rate_limit_input {
    /// A builder for [`DescribeBandwidthRateLimitInput`](crate::input::DescribeBandwidthRateLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBandwidthRateLimitInput`](crate::input::DescribeBandwidthRateLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBandwidthRateLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBandwidthRateLimitInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBandwidthRateLimitInputOperationOutputAlias =
    crate::operation::DescribeBandwidthRateLimit;
#[doc(hidden)]
pub type DescribeBandwidthRateLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBandwidthRateLimitInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBandwidthRateLimit`](crate::operation::DescribeBandwidthRateLimit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBandwidthRateLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBandwidthRateLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBandwidthRateLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBandwidthRateLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeBandwidthRateLimit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_bandwidth_rate_limit(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBandwidthRateLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBandwidthRateLimit",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBandwidthRateLimitInput`](crate::input::DescribeBandwidthRateLimitInput)
    pub fn builder() -> crate::input::describe_bandwidth_rate_limit_input::Builder {
        crate::input::describe_bandwidth_rate_limit_input::Builder::default()
    }
}

/// See [`DescribeBandwidthRateLimitScheduleInput`](crate::input::DescribeBandwidthRateLimitScheduleInput)
pub mod describe_bandwidth_rate_limit_schedule_input {
    /// A builder for [`DescribeBandwidthRateLimitScheduleInput`](crate::input::DescribeBandwidthRateLimitScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBandwidthRateLimitScheduleInput`](crate::input::DescribeBandwidthRateLimitScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBandwidthRateLimitScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBandwidthRateLimitScheduleInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBandwidthRateLimitScheduleInputOperationOutputAlias =
    crate::operation::DescribeBandwidthRateLimitSchedule;
#[doc(hidden)]
pub type DescribeBandwidthRateLimitScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBandwidthRateLimitScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBandwidthRateLimitSchedule`](crate::operation::DescribeBandwidthRateLimitSchedule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBandwidthRateLimitSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBandwidthRateLimitScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBandwidthRateLimitScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBandwidthRateLimitScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeBandwidthRateLimitSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_bandwidth_rate_limit_schedule(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBandwidthRateLimitSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBandwidthRateLimitSchedule",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBandwidthRateLimitScheduleInput`](crate::input::DescribeBandwidthRateLimitScheduleInput)
    pub fn builder() -> crate::input::describe_bandwidth_rate_limit_schedule_input::Builder {
        crate::input::describe_bandwidth_rate_limit_schedule_input::Builder::default()
    }
}

/// See [`DescribeCacheInput`](crate::input::DescribeCacheInput)
pub mod describe_cache_input {
    /// A builder for [`DescribeCacheInput`](crate::input::DescribeCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheInput`](crate::input::DescribeCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCacheInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCacheInputOperationOutputAlias = crate::operation::DescribeCache;
#[doc(hidden)]
pub type DescribeCacheInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCacheInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCache`](crate::operation::DescribeCache)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCache,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCacheInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCacheInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCacheInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeCache",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_cache(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCache",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCacheInput`](crate::input::DescribeCacheInput)
    pub fn builder() -> crate::input::describe_cache_input::Builder {
        crate::input::describe_cache_input::Builder::default()
    }
}

/// See [`DescribeCachediScsiVolumesInput`](crate::input::DescribeCachediScsiVolumesInput)
pub mod describe_cachedi_scsi_volumes_input {
    /// A builder for [`DescribeCachediScsiVolumesInput`](crate::input::DescribeCachediScsiVolumesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `volume_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_volume_ar_ns`](Self::set_volume_ar_ns).
        ///
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// cached volume. All of the specified cached volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn volume_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.volume_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.volume_ar_ns = Some(v);
            self
        }
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// cached volume. All of the specified cached volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn set_volume_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.volume_ar_ns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCachediScsiVolumesInput`](crate::input::DescribeCachediScsiVolumesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCachediScsiVolumesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCachediScsiVolumesInput {
                volume_ar_ns: self.volume_ar_ns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCachediScsiVolumesInputOperationOutputAlias =
    crate::operation::DescribeCachediSCSIVolumes;
#[doc(hidden)]
pub type DescribeCachediScsiVolumesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCachediScsiVolumesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCachediSCSIVolumes`](crate::operation::DescribeCachediSCSIVolumes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCachediSCSIVolumes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCachediScsiVolumesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCachediScsiVolumesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCachediScsiVolumesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeCachediSCSIVolumes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cachedi_scsi_volumes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCachediSCSIVolumes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCachediSCSIVolumes",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCachediScsiVolumesInput`](crate::input::DescribeCachediScsiVolumesInput)
    pub fn builder() -> crate::input::describe_cachedi_scsi_volumes_input::Builder {
        crate::input::describe_cachedi_scsi_volumes_input::Builder::default()
    }
}

/// See [`DescribeChapCredentialsInput`](crate::input::DescribeChapCredentialsInput)
pub mod describe_chap_credentials_input {
    /// A builder for [`DescribeChapCredentialsInput`](crate::input::DescribeChapCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChapCredentialsInput`](crate::input::DescribeChapCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChapCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChapCredentialsInput {
                target_arn: self.target_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChapCredentialsInputOperationOutputAlias =
    crate::operation::DescribeChapCredentials;
#[doc(hidden)]
pub type DescribeChapCredentialsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeChapCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChapCredentials`](crate::operation::DescribeChapCredentials)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChapCredentials,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChapCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChapCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChapCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeChapCredentials",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_chap_credentials(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChapCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChapCredentials",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChapCredentialsInput`](crate::input::DescribeChapCredentialsInput)
    pub fn builder() -> crate::input::describe_chap_credentials_input::Builder {
        crate::input::describe_chap_credentials_input::Builder::default()
    }
}

/// See [`DescribeFileSystemAssociationsInput`](crate::input::DescribeFileSystemAssociationsInput)
pub mod describe_file_system_associations_input {
    /// A builder for [`DescribeFileSystemAssociationsInput`](crate::input::DescribeFileSystemAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_arn_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `file_system_association_arn_list`.
        ///
        /// To override the contents of this collection use [`set_file_system_association_arn_list`](Self::set_file_system_association_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be
        /// described.</p>
        pub fn file_system_association_arn_list(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.file_system_association_arn_list.unwrap_or_default();
            v.push(input.into());
            self.file_system_association_arn_list = Some(v);
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be
        /// described.</p>
        pub fn set_file_system_association_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.file_system_association_arn_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemAssociationsInput`](crate::input::DescribeFileSystemAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFileSystemAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFileSystemAssociationsInput {
                file_system_association_arn_list: self.file_system_association_arn_list,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFileSystemAssociationsInputOperationOutputAlias =
    crate::operation::DescribeFileSystemAssociations;
#[doc(hidden)]
pub type DescribeFileSystemAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFileSystemAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFileSystemAssociations`](crate::operation::DescribeFileSystemAssociations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFileSystemAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFileSystemAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFileSystemAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFileSystemAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeFileSystemAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_file_system_associations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFileSystemAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFileSystemAssociations",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemAssociationsInput`](crate::input::DescribeFileSystemAssociationsInput)
    pub fn builder() -> crate::input::describe_file_system_associations_input::Builder {
        crate::input::describe_file_system_associations_input::Builder::default()
    }
}

/// See [`DescribeGatewayInformationInput`](crate::input::DescribeGatewayInformationInput)
pub mod describe_gateway_information_input {
    /// A builder for [`DescribeGatewayInformationInput`](crate::input::DescribeGatewayInformationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayInformationInput`](crate::input::DescribeGatewayInformationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGatewayInformationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGatewayInformationInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGatewayInformationInputOperationOutputAlias =
    crate::operation::DescribeGatewayInformation;
#[doc(hidden)]
pub type DescribeGatewayInformationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGatewayInformationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGatewayInformation`](crate::operation::DescribeGatewayInformation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGatewayInformation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGatewayInformationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGatewayInformationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGatewayInformationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeGatewayInformation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_gateway_information(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGatewayInformation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGatewayInformation",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGatewayInformationInput`](crate::input::DescribeGatewayInformationInput)
    pub fn builder() -> crate::input::describe_gateway_information_input::Builder {
        crate::input::describe_gateway_information_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceStartTimeInput`](crate::input::DescribeMaintenanceStartTimeInput)
pub mod describe_maintenance_start_time_input {
    /// A builder for [`DescribeMaintenanceStartTimeInput`](crate::input::DescribeMaintenanceStartTimeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceStartTimeInput`](crate::input::DescribeMaintenanceStartTimeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceStartTimeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceStartTimeInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceStartTimeInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceStartTime;
#[doc(hidden)]
pub type DescribeMaintenanceStartTimeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceStartTimeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceStartTime`](crate::operation::DescribeMaintenanceStartTime)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceStartTime,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceStartTimeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceStartTimeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceStartTimeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeMaintenanceStartTime",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_start_time(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceStartTime::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceStartTime",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceStartTimeInput`](crate::input::DescribeMaintenanceStartTimeInput)
    pub fn builder() -> crate::input::describe_maintenance_start_time_input::Builder {
        crate::input::describe_maintenance_start_time_input::Builder::default()
    }
}

/// See [`DescribeNfsFileSharesInput`](crate::input::DescribeNfsFileSharesInput)
pub mod describe_nfs_file_shares_input {
    /// A builder for [`DescribeNfsFileSharesInput`](crate::input::DescribeNfsFileSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `file_share_arn_list`.
        ///
        /// To override the contents of this collection use [`set_file_share_arn_list`](Self::set_file_share_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn file_share_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.file_share_arn_list.unwrap_or_default();
            v.push(input.into());
            self.file_share_arn_list = Some(v);
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn set_file_share_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.file_share_arn_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNfsFileSharesInput`](crate::input::DescribeNfsFileSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNfsFileSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNfsFileSharesInput {
                file_share_arn_list: self.file_share_arn_list,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNfsFileSharesInputOperationOutputAlias = crate::operation::DescribeNFSFileShares;
#[doc(hidden)]
pub type DescribeNfsFileSharesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNfsFileSharesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNFSFileShares`](crate::operation::DescribeNFSFileShares)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNFSFileShares,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNfsFileSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNfsFileSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNfsFileSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeNFSFileShares",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_nfs_file_shares(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNFSFileShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNFSFileShares",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNfsFileSharesInput`](crate::input::DescribeNfsFileSharesInput)
    pub fn builder() -> crate::input::describe_nfs_file_shares_input::Builder {
        crate::input::describe_nfs_file_shares_input::Builder::default()
    }
}

/// See [`DescribeSmbFileSharesInput`](crate::input::DescribeSmbFileSharesInput)
pub mod describe_smb_file_shares_input {
    /// A builder for [`DescribeSmbFileSharesInput`](crate::input::DescribeSmbFileSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `file_share_arn_list`.
        ///
        /// To override the contents of this collection use [`set_file_share_arn_list`](Self::set_file_share_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn file_share_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.file_share_arn_list.unwrap_or_default();
            v.push(input.into());
            self.file_share_arn_list = Some(v);
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn set_file_share_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.file_share_arn_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSmbFileSharesInput`](crate::input::DescribeSmbFileSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSmbFileSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSmbFileSharesInput {
                file_share_arn_list: self.file_share_arn_list,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSmbFileSharesInputOperationOutputAlias = crate::operation::DescribeSMBFileShares;
#[doc(hidden)]
pub type DescribeSmbFileSharesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSmbFileSharesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSMBFileShares`](crate::operation::DescribeSMBFileShares)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSMBFileShares,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSmbFileSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSmbFileSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSmbFileSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeSMBFileShares",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_smb_file_shares(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSMBFileShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSMBFileShares",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSmbFileSharesInput`](crate::input::DescribeSmbFileSharesInput)
    pub fn builder() -> crate::input::describe_smb_file_shares_input::Builder {
        crate::input::describe_smb_file_shares_input::Builder::default()
    }
}

/// See [`DescribeSmbSettingsInput`](crate::input::DescribeSmbSettingsInput)
pub mod describe_smb_settings_input {
    /// A builder for [`DescribeSmbSettingsInput`](crate::input::DescribeSmbSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSmbSettingsInput`](crate::input::DescribeSmbSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSmbSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSmbSettingsInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSmbSettingsInputOperationOutputAlias = crate::operation::DescribeSMBSettings;
#[doc(hidden)]
pub type DescribeSmbSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSmbSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSMBSettings`](crate::operation::DescribeSMBSettings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSMBSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSmbSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSmbSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSmbSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeSMBSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_smb_settings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSMBSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSMBSettings",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSmbSettingsInput`](crate::input::DescribeSmbSettingsInput)
    pub fn builder() -> crate::input::describe_smb_settings_input::Builder {
        crate::input::describe_smb_settings_input::Builder::default()
    }
}

/// See [`DescribeSnapshotScheduleInput`](crate::input::DescribeSnapshotScheduleInput)
pub mod describe_snapshot_schedule_input {
    /// A builder for [`DescribeSnapshotScheduleInput`](crate::input::DescribeSnapshotScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotScheduleInput`](crate::input::DescribeSnapshotScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSnapshotScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSnapshotScheduleInput {
                volume_arn: self.volume_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSnapshotScheduleInputOperationOutputAlias =
    crate::operation::DescribeSnapshotSchedule;
#[doc(hidden)]
pub type DescribeSnapshotScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSnapshotScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSnapshotSchedule`](crate::operation::DescribeSnapshotSchedule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSnapshotSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSnapshotScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSnapshotScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSnapshotScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeSnapshotSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_snapshot_schedule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSnapshotSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSnapshotSchedule",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotScheduleInput`](crate::input::DescribeSnapshotScheduleInput)
    pub fn builder() -> crate::input::describe_snapshot_schedule_input::Builder {
        crate::input::describe_snapshot_schedule_input::Builder::default()
    }
}

/// See [`DescribeStorediScsiVolumesInput`](crate::input::DescribeStorediScsiVolumesInput)
pub mod describe_storedi_scsi_volumes_input {
    /// A builder for [`DescribeStorediScsiVolumesInput`](crate::input::DescribeStorediScsiVolumesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `volume_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_volume_ar_ns`](Self::set_volume_ar_ns).
        ///
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// stored volume. All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn volume_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.volume_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.volume_ar_ns = Some(v);
            self
        }
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// stored volume. All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn set_volume_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.volume_ar_ns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStorediScsiVolumesInput`](crate::input::DescribeStorediScsiVolumesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStorediScsiVolumesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStorediScsiVolumesInput {
                volume_ar_ns: self.volume_ar_ns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStorediScsiVolumesInputOperationOutputAlias =
    crate::operation::DescribeStorediSCSIVolumes;
#[doc(hidden)]
pub type DescribeStorediScsiVolumesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStorediScsiVolumesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStorediSCSIVolumes`](crate::operation::DescribeStorediSCSIVolumes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStorediSCSIVolumes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStorediScsiVolumesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStorediScsiVolumesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStorediScsiVolumesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeStorediSCSIVolumes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_storedi_scsi_volumes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStorediSCSIVolumes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStorediSCSIVolumes",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStorediScsiVolumesInput`](crate::input::DescribeStorediScsiVolumesInput)
    pub fn builder() -> crate::input::describe_storedi_scsi_volumes_input::Builder {
        crate::input::describe_storedi_scsi_volumes_input::Builder::default()
    }
}

/// See [`DescribeTapeArchivesInput`](crate::input::DescribeTapeArchivesInput)
pub mod describe_tape_archives_input {
    /// A builder for [`DescribeTapeArchivesInput`](crate::input::DescribeTapeArchivesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `tape_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe.</p>
        pub fn tape_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tape_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.tape_ar_ns = Some(v);
            self
        }
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tape_ar_ns = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing virtual
        /// tapes.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing virtual
        /// tapes.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTapeArchivesInput`](crate::input::DescribeTapeArchivesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTapeArchivesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTapeArchivesInput {
                tape_ar_ns: self.tape_ar_ns,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTapeArchivesInputOperationOutputAlias = crate::operation::DescribeTapeArchives;
#[doc(hidden)]
pub type DescribeTapeArchivesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTapeArchivesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTapeArchives`](crate::operation::DescribeTapeArchives)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTapeArchives,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTapeArchivesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTapeArchivesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTapeArchivesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeTapeArchives",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_tape_archives(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTapeArchives::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTapeArchives",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTapeArchivesInput`](crate::input::DescribeTapeArchivesInput)
    pub fn builder() -> crate::input::describe_tape_archives_input::Builder {
        crate::input::describe_tape_archives_input::Builder::default()
    }
}

/// See [`DescribeTapeRecoveryPointsInput`](crate::input::DescribeTapeRecoveryPointsInput)
pub mod describe_tape_recovery_points_input {
    /// A builder for [`DescribeTapeRecoveryPointsInput`](crate::input::DescribeTapeRecoveryPointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the virtual
        /// tape recovery points.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the virtual
        /// tape recovery points.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specifies that the number of virtual tape recovery points that are described be limited
        /// to the specified number.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies that the number of virtual tape recovery points that are described be limited
        /// to the specified number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTapeRecoveryPointsInput`](crate::input::DescribeTapeRecoveryPointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTapeRecoveryPointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTapeRecoveryPointsInput {
                gateway_arn: self.gateway_arn,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTapeRecoveryPointsInputOperationOutputAlias =
    crate::operation::DescribeTapeRecoveryPoints;
#[doc(hidden)]
pub type DescribeTapeRecoveryPointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTapeRecoveryPointsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTapeRecoveryPoints`](crate::operation::DescribeTapeRecoveryPoints)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTapeRecoveryPoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTapeRecoveryPointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTapeRecoveryPointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTapeRecoveryPointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeTapeRecoveryPoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_tape_recovery_points(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTapeRecoveryPoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTapeRecoveryPoints",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTapeRecoveryPointsInput`](crate::input::DescribeTapeRecoveryPointsInput)
    pub fn builder() -> crate::input::describe_tape_recovery_points_input::Builder {
        crate::input::describe_tape_recovery_points_input::Builder::default()
    }
}

/// See [`DescribeTapesInput`](crate::input::DescribeTapesInput)
pub mod describe_tapes_input {
    /// A builder for [`DescribeTapesInput`](crate::input::DescribeTapesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `tape_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe. If this parameter is not specified, Tape gateway returns a
        /// description of all virtual tapes associated with the specified gateway.</p>
        pub fn tape_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tape_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.tape_ar_ns = Some(v);
            self
        }
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe. If this parameter is not specified, Tape gateway returns a
        /// description of all virtual tapes associated with the specified gateway.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tape_ar_ns = input;
            self
        }
        /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker
        /// indicates which page of results to retrieve.</p>
        ///
        /// <p>If not specified, the first page of results is retrieved.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker
        /// indicates which page of results to retrieve.</p>
        ///
        /// <p>If not specified, the first page of results is retrieved.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        ///
        /// <note>
        /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
        /// </note>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        ///
        /// <note>
        /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
        /// </note>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTapesInput`](crate::input::DescribeTapesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTapesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTapesInput {
                gateway_arn: self.gateway_arn,
                tape_ar_ns: self.tape_ar_ns,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTapesInputOperationOutputAlias = crate::operation::DescribeTapes;
#[doc(hidden)]
pub type DescribeTapesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTapesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTapes`](crate::operation::DescribeTapes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTapes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTapesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTapesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTapesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeTapes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tapes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTapes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTapes",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTapesInput`](crate::input::DescribeTapesInput)
    pub fn builder() -> crate::input::describe_tapes_input::Builder {
        crate::input::describe_tapes_input::Builder::default()
    }
}

/// See [`DescribeUploadBufferInput`](crate::input::DescribeUploadBufferInput)
pub mod describe_upload_buffer_input {
    /// A builder for [`DescribeUploadBufferInput`](crate::input::DescribeUploadBufferInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUploadBufferInput`](crate::input::DescribeUploadBufferInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUploadBufferInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUploadBufferInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUploadBufferInputOperationOutputAlias = crate::operation::DescribeUploadBuffer;
#[doc(hidden)]
pub type DescribeUploadBufferInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeUploadBufferInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUploadBuffer`](crate::operation::DescribeUploadBuffer)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUploadBuffer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUploadBufferInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUploadBufferInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUploadBufferInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeUploadBuffer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_upload_buffer(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUploadBuffer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUploadBuffer",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUploadBufferInput`](crate::input::DescribeUploadBufferInput)
    pub fn builder() -> crate::input::describe_upload_buffer_input::Builder {
        crate::input::describe_upload_buffer_input::Builder::default()
    }
}

/// See [`DescribeVtlDevicesInput`](crate::input::DescribeVtlDevicesInput)
pub mod describe_vtl_devices_input {
    /// A builder for [`DescribeVtlDevicesInput`](crate::input::DescribeVtlDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) vtl_device_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `vtl_device_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_vtl_device_ar_ns`](Self::set_vtl_device_ar_ns).
        ///
        /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a
        /// VTL device.</p>
        ///
        /// <note>
        /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are
        /// specified, the result will contain all devices on the specified gateway.</p>
        /// </note>
        pub fn vtl_device_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vtl_device_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.vtl_device_ar_ns = Some(v);
            self
        }
        /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a
        /// VTL device.</p>
        ///
        /// <note>
        /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are
        /// specified, the result will contain all devices on the specified gateway.</p>
        /// </note>
        pub fn set_vtl_device_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vtl_device_ar_ns = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the VTL
        /// devices.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the VTL
        /// devices.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specifies that the number of VTL devices described be limited to the specified
        /// number.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies that the number of VTL devices described be limited to the specified
        /// number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVtlDevicesInput`](crate::input::DescribeVtlDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVtlDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVtlDevicesInput {
                gateway_arn: self.gateway_arn,
                vtl_device_ar_ns: self.vtl_device_ar_ns,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVtlDevicesInputOperationOutputAlias = crate::operation::DescribeVTLDevices;
#[doc(hidden)]
pub type DescribeVtlDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeVtlDevicesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVTLDevices`](crate::operation::DescribeVTLDevices)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVTLDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVtlDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVtlDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVtlDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeVTLDevices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_vtl_devices(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVTLDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVTLDevices",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVtlDevicesInput`](crate::input::DescribeVtlDevicesInput)
    pub fn builder() -> crate::input::describe_vtl_devices_input::Builder {
        crate::input::describe_vtl_devices_input::Builder::default()
    }
}

/// See [`DescribeWorkingStorageInput`](crate::input::DescribeWorkingStorageInput)
pub mod describe_working_storage_input {
    /// A builder for [`DescribeWorkingStorageInput`](crate::input::DescribeWorkingStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkingStorageInput`](crate::input::DescribeWorkingStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkingStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkingStorageInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkingStorageInputOperationOutputAlias = crate::operation::DescribeWorkingStorage;
#[doc(hidden)]
pub type DescribeWorkingStorageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkingStorageInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkingStorage`](crate::operation::DescribeWorkingStorage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkingStorage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkingStorageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkingStorageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkingStorageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DescribeWorkingStorage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_working_storage(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkingStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkingStorage",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkingStorageInput`](crate::input::DescribeWorkingStorageInput)
    pub fn builder() -> crate::input::describe_working_storage_input::Builder {
        crate::input::describe_working_storage_input::Builder::default()
    }
}

/// See [`DetachVolumeInput`](crate::input::DetachVolumeInput)
pub mod detach_volume_input {
    /// A builder for [`DetachVolumeInput`](crate::input::DetachVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) force_detach: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume
        /// and detach the volume. The default is <code>false</code>. If this value is set to
        /// <code>false</code>, you must manually disconnect the iSCSI connection from the target
        /// volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn force_detach(mut self, input: bool) -> Self {
            self.force_detach = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume
        /// and detach the volume. The default is <code>false</code>. If this value is set to
        /// <code>false</code>, you must manually disconnect the iSCSI connection from the target
        /// volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_force_detach(mut self, input: std::option::Option<bool>) -> Self {
            self.force_detach = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachVolumeInput`](crate::input::DetachVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachVolumeInput {
                volume_arn: self.volume_arn,
                force_detach: self.force_detach,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachVolumeInputOperationOutputAlias = crate::operation::DetachVolume;
#[doc(hidden)]
pub type DetachVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetachVolumeInput {
    /// Consumes the builder and constructs an Operation<[`DetachVolume`](crate::operation::DetachVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DetachVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_detach_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachVolume",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachVolumeInput`](crate::input::DetachVolumeInput)
    pub fn builder() -> crate::input::detach_volume_input::Builder {
        crate::input::detach_volume_input::Builder::default()
    }
}

/// See [`DisableGatewayInput`](crate::input::DisableGatewayInput)
pub mod disable_gateway_input {
    /// A builder for [`DisableGatewayInput`](crate::input::DisableGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableGatewayInput`](crate::input::DisableGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableGatewayInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableGatewayInputOperationOutputAlias = crate::operation::DisableGateway;
#[doc(hidden)]
pub type DisableGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DisableGateway`](crate::operation::DisableGateway)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DisableGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_gateway(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableGateway",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableGatewayInput`](crate::input::DisableGatewayInput)
    pub fn builder() -> crate::input::disable_gateway_input::Builder {
        crate::input::disable_gateway_input::Builder::default()
    }
}

/// See [`DisassociateFileSystemInput`](crate::input::DisassociateFileSystemInput)
pub mod disassociate_file_system_input {
    /// A builder for [`DisassociateFileSystemInput`](crate::input::DisassociateFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_arn: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = input;
            self
        }
        /// <p>If this value is set to true, the operation disassociates an Amazon FSx file
        /// system immediately. It ends all data uploads to the file system, and the file system
        /// association enters the <code>FORCE_DELETING</code> status. If this value is set to false,
        /// the Amazon FSx file system does not disassociate until all data is uploaded.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>If this value is set to true, the operation disassociates an Amazon FSx file
        /// system immediately. It ends all data uploads to the file system, and the file system
        /// association enters the <code>FORCE_DELETING</code> status. If this value is set to false,
        /// the Amazon FSx file system does not disassociate until all data is uploaded.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFileSystemInput`](crate::input::DisassociateFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFileSystemInput {
                file_system_association_arn: self.file_system_association_arn,
                force_delete: self.force_delete.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateFileSystemInputOperationOutputAlias = crate::operation::DisassociateFileSystem;
#[doc(hidden)]
pub type DisassociateFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFileSystem`](crate::operation::DisassociateFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.DisassociateFileSystem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_file_system(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFileSystem",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFileSystemInput`](crate::input::DisassociateFileSystemInput)
    pub fn builder() -> crate::input::disassociate_file_system_input::Builder {
        crate::input::disassociate_file_system_input::Builder::default()
    }
}

/// See [`JoinDomainInput`](crate::input::JoinDomainInput)
pub mod join_domain_input {
    /// A builder for [`JoinDomainInput`](crate::input::JoinDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) organizational_unit: std::option::Option<std::string::String>,
        pub(crate) domain_controllers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The name of the domain that you want the gateway to join.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want the gateway to join.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users,
        /// groups, computers, and other OUs and this parameter specifies the OU that the gateway will
        /// join within the AD domain.</p>
        pub fn organizational_unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit = Some(input.into());
            self
        }
        /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users,
        /// groups, computers, and other OUs and this parameter specifies the OU that the gateway will
        /// join within the AD domain.</p>
        pub fn set_organizational_unit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit = input;
            self
        }
        /// Appends an item to `domain_controllers`.
        ///
        /// To override the contents of this collection use [`set_domain_controllers`](Self::set_domain_controllers).
        ///
        /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
        /// to specify the port number include it after the colon (“:”). For example,
        /// <code>mydc.mydomain.com:389</code>.</p>
        pub fn domain_controllers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domain_controllers.unwrap_or_default();
            v.push(input.into());
            self.domain_controllers = Some(v);
            self
        }
        /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
        /// to specify the port number include it after the colon (“:”). For example,
        /// <code>mydc.mydomain.com:389</code>.</p>
        pub fn set_domain_controllers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domain_controllers = input;
            self
        }
        /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must
        /// complete. The default is 20 seconds.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must
        /// complete. The default is 20 seconds.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory
        /// domain. The domain user account should be enabled to join computers to the domain. For
        /// example, you can use the domain administrator account or an account with delegated
        /// permissions to join computers to the domain.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory
        /// domain. The domain user account should be enabled to join computers to the domain. For
        /// example, you can use the domain administrator account or an account with delegated
        /// permissions to join computers to the domain.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Sets the password of the user who has permission to add the gateway to the Active
        /// Directory domain.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Sets the password of the user who has permission to add the gateway to the Active
        /// Directory domain.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`JoinDomainInput`](crate::input::JoinDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::JoinDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::JoinDomainInput {
                gateway_arn: self.gateway_arn,
                domain_name: self.domain_name,
                organizational_unit: self.organizational_unit,
                domain_controllers: self.domain_controllers,
                timeout_in_seconds: self.timeout_in_seconds,
                user_name: self.user_name,
                password: self.password,
            })
        }
    }
}
#[doc(hidden)]
pub type JoinDomainInputOperationOutputAlias = crate::operation::JoinDomain;
#[doc(hidden)]
pub type JoinDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl JoinDomainInput {
    /// Consumes the builder and constructs an Operation<[`JoinDomain`](crate::operation::JoinDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::JoinDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::JoinDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::JoinDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::JoinDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.JoinDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_join_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::JoinDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "JoinDomain",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`JoinDomainInput`](crate::input::JoinDomainInput)
    pub fn builder() -> crate::input::join_domain_input::Builder {
        crate::input::join_domain_input::Builder::default()
    }
}

/// See [`ListAutomaticTapeCreationPoliciesInput`](crate::input::ListAutomaticTapeCreationPoliciesInput)
pub mod list_automatic_tape_creation_policies_input {
    /// A builder for [`ListAutomaticTapeCreationPoliciesInput`](crate::input::ListAutomaticTapeCreationPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAutomaticTapeCreationPoliciesInput`](crate::input::ListAutomaticTapeCreationPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAutomaticTapeCreationPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAutomaticTapeCreationPoliciesInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAutomaticTapeCreationPoliciesInputOperationOutputAlias =
    crate::operation::ListAutomaticTapeCreationPolicies;
#[doc(hidden)]
pub type ListAutomaticTapeCreationPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAutomaticTapeCreationPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListAutomaticTapeCreationPolicies`](crate::operation::ListAutomaticTapeCreationPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAutomaticTapeCreationPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAutomaticTapeCreationPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAutomaticTapeCreationPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAutomaticTapeCreationPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListAutomaticTapeCreationPolicies",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_automatic_tape_creation_policies(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAutomaticTapeCreationPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAutomaticTapeCreationPolicies",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAutomaticTapeCreationPoliciesInput`](crate::input::ListAutomaticTapeCreationPoliciesInput)
    pub fn builder() -> crate::input::list_automatic_tape_creation_policies_input::Builder {
        crate::input::list_automatic_tape_creation_policies_input::Builder::default()
    }
}

/// See [`ListFileSharesInput`](crate::input::ListFileSharesInput)
pub mod list_file_shares_input {
    /// A builder for [`ListFileSharesInput`](crate::input::ListFileSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
        /// this field is not present, all file shares under your account are listed.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
        /// this field is not present, all file shares under your account are listed.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The maximum number of file shares to return in the response. The value must be an
        /// integer with a value greater than zero. Optional.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of file shares to return in the response. The value must be an
        /// integer with a value greater than zero. Optional.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present,
        /// <code>Marker</code> specifies where to continue the list from after a previous call to
        /// ListFileShares. Optional.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present,
        /// <code>Marker</code> specifies where to continue the list from after a previous call to
        /// ListFileShares. Optional.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFileSharesInput`](crate::input::ListFileSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFileSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFileSharesInput {
                gateway_arn: self.gateway_arn,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFileSharesInputOperationOutputAlias = crate::operation::ListFileShares;
#[doc(hidden)]
pub type ListFileSharesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFileSharesInput {
    /// Consumes the builder and constructs an Operation<[`ListFileShares`](crate::operation::ListFileShares)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFileShares,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFileSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFileSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFileSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListFileShares",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_file_shares(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFileShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFileShares",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFileSharesInput`](crate::input::ListFileSharesInput)
    pub fn builder() -> crate::input::list_file_shares_input::Builder {
        crate::input::list_file_shares_input::Builder::default()
    }
}

/// See [`ListFileSystemAssociationsInput`](crate::input::ListFileSystemAssociationsInput)
pub mod list_file_system_associations_input {
    /// A builder for [`ListFileSystemAssociationsInput`](crate::input::ListFileSystemAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The maximum number of file system associations to return in the response. If present,
        /// <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of file system associations to return in the response. If present,
        /// <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code>
        /// operation. If present, <code>Marker</code> specifies where to continue the list from after
        /// a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code>
        /// operation. If present, <code>Marker</code> specifies where to continue the list from after
        /// a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFileSystemAssociationsInput`](crate::input::ListFileSystemAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFileSystemAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFileSystemAssociationsInput {
                gateway_arn: self.gateway_arn,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFileSystemAssociationsInputOperationOutputAlias =
    crate::operation::ListFileSystemAssociations;
#[doc(hidden)]
pub type ListFileSystemAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFileSystemAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListFileSystemAssociations`](crate::operation::ListFileSystemAssociations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFileSystemAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFileSystemAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFileSystemAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFileSystemAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListFileSystemAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_file_system_associations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFileSystemAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFileSystemAssociations",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFileSystemAssociationsInput`](crate::input::ListFileSystemAssociationsInput)
    pub fn builder() -> crate::input::list_file_system_associations_input::Builder {
        crate::input::list_file_system_associations_input::Builder::default()
    }
}

/// See [`ListGatewaysInput`](crate::input::ListGatewaysInput)
pub mod list_gateways_input {
    /// A builder for [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An opaque string that indicates the position at which to begin the returned list of
        /// gateways.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the returned list of
        /// gateways.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specifies that the list of gateways returned be limited to the specified number of
        /// items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies that the list of gateways returned be limited to the specified number of
        /// items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewaysInput`](crate::input::ListGatewaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGatewaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGatewaysInput {
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGatewaysInputOperationOutputAlias = crate::operation::ListGateways;
#[doc(hidden)]
pub type ListGatewaysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGatewaysInput {
    /// Consumes the builder and constructs an Operation<[`ListGateways`](crate::operation::ListGateways)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGateways,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGatewaysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGatewaysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGatewaysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListGateways",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_gateways(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGateways::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGateways",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    pub fn builder() -> crate::input::list_gateways_input::Builder {
        crate::input::list_gateways_input::Builder::default()
    }
}

/// See [`ListLocalDisksInput`](crate::input::ListLocalDisksInput)
pub mod list_local_disks_input {
    /// A builder for [`ListLocalDisksInput`](crate::input::ListLocalDisksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLocalDisksInput`](crate::input::ListLocalDisksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLocalDisksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLocalDisksInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLocalDisksInputOperationOutputAlias = crate::operation::ListLocalDisks;
#[doc(hidden)]
pub type ListLocalDisksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLocalDisksInput {
    /// Consumes the builder and constructs an Operation<[`ListLocalDisks`](crate::operation::ListLocalDisks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLocalDisks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLocalDisksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLocalDisksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLocalDisksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListLocalDisks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_local_disks(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLocalDisks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLocalDisks",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLocalDisksInput`](crate::input::ListLocalDisksInput)
    pub fn builder() -> crate::input::list_local_disks_input::Builder {
        crate::input::list_local_disks_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the list of
        /// tags.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the list of
        /// tags.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specifies that the list of tags returned be limited to the specified number of
        /// items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies that the list of tags returned be limited to the specified number of
        /// items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTapePoolsInput`](crate::input::ListTapePoolsInput)
pub mod list_tape_pools_input {
    /// A builder for [`ListTapePoolsInput`](crate::input::ListTapePoolsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `pool_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_pool_ar_ns`](Self::set_pool_ar_ns).
        ///
        /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you
        /// don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
        pub fn pool_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pool_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.pool_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you
        /// don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
        pub fn set_pool_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pool_ar_ns = input;
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape
        /// pools.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape
        /// pools.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTapePoolsInput`](crate::input::ListTapePoolsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTapePoolsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTapePoolsInput {
                pool_ar_ns: self.pool_ar_ns,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTapePoolsInputOperationOutputAlias = crate::operation::ListTapePools;
#[doc(hidden)]
pub type ListTapePoolsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTapePoolsInput {
    /// Consumes the builder and constructs an Operation<[`ListTapePools`](crate::operation::ListTapePools)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTapePools,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTapePoolsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTapePoolsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTapePoolsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListTapePools",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tape_pools(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTapePools::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTapePools",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTapePoolsInput`](crate::input::ListTapePoolsInput)
    pub fn builder() -> crate::input::list_tape_pools_input::Builder {
        crate::input::list_tape_pools_input::Builder::default()
    }
}

/// See [`ListTapesInput`](crate::input::ListTapesInput)
pub mod list_tapes_input {
    /// A builder for [`ListTapesInput`](crate::input::ListTapesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `tape_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't
        /// specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
        pub fn tape_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tape_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.tape_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't
        /// specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tape_ar_ns = input;
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of
        /// tapes.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of
        /// tapes.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>An optional number limit for the tapes in the list returned by this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>An optional number limit for the tapes in the list returned by this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTapesInput`](crate::input::ListTapesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTapesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTapesInput {
                tape_ar_ns: self.tape_ar_ns,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTapesInputOperationOutputAlias = crate::operation::ListTapes;
#[doc(hidden)]
pub type ListTapesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTapesInput {
    /// Consumes the builder and constructs an Operation<[`ListTapes`](crate::operation::ListTapes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTapes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTapesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTapesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTapesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListTapes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tapes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTapes::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTapes",
                    "storagegateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTapesInput`](crate::input::ListTapesInput)
    pub fn builder() -> crate::input::list_tapes_input::Builder {
        crate::input::list_tapes_input::Builder::default()
    }
}

/// See [`ListVolumeInitiatorsInput`](crate::input::ListVolumeInitiatorsInput)
pub mod list_volume_initiators_input {
    /// A builder for [`ListVolumeInitiatorsInput`](crate::input::ListVolumeInitiatorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes for the gateway.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes for the gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVolumeInitiatorsInput`](crate::input::ListVolumeInitiatorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVolumeInitiatorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVolumeInitiatorsInput {
                volume_arn: self.volume_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVolumeInitiatorsInputOperationOutputAlias = crate::operation::ListVolumeInitiators;
#[doc(hidden)]
pub type ListVolumeInitiatorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVolumeInitiatorsInput {
    /// Consumes the builder and constructs an Operation<[`ListVolumeInitiators`](crate::operation::ListVolumeInitiators)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVolumeInitiators,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVolumeInitiatorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVolumeInitiatorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVolumeInitiatorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListVolumeInitiators",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_volume_initiators(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVolumeInitiators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVolumeInitiators",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVolumeInitiatorsInput`](crate::input::ListVolumeInitiatorsInput)
    pub fn builder() -> crate::input::list_volume_initiators_input::Builder {
        crate::input::list_volume_initiators_input::Builder::default()
    }
}

/// See [`ListVolumeRecoveryPointsInput`](crate::input::ListVolumeRecoveryPointsInput)
pub mod list_volume_recovery_points_input {
    /// A builder for [`ListVolumeRecoveryPointsInput`](crate::input::ListVolumeRecoveryPointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVolumeRecoveryPointsInput`](crate::input::ListVolumeRecoveryPointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVolumeRecoveryPointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVolumeRecoveryPointsInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVolumeRecoveryPointsInputOperationOutputAlias =
    crate::operation::ListVolumeRecoveryPoints;
#[doc(hidden)]
pub type ListVolumeRecoveryPointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVolumeRecoveryPointsInput {
    /// Consumes the builder and constructs an Operation<[`ListVolumeRecoveryPoints`](crate::operation::ListVolumeRecoveryPoints)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVolumeRecoveryPoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVolumeRecoveryPointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVolumeRecoveryPointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVolumeRecoveryPointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListVolumeRecoveryPoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_volume_recovery_points(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVolumeRecoveryPoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVolumeRecoveryPoints",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVolumeRecoveryPointsInput`](crate::input::ListVolumeRecoveryPointsInput)
    pub fn builder() -> crate::input::list_volume_recovery_points_input::Builder {
        crate::input::list_volume_recovery_points_input::Builder::default()
    }
}

/// See [`ListVolumesInput`](crate::input::ListVolumesInput)
pub mod list_volumes_input {
    /// A builder for [`ListVolumesInput`](crate::input::ListVolumesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of volumes.
        /// Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of volumes.
        /// Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specifies that the list of volumes returned be limited to the specified number of
        /// items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies that the list of volumes returned be limited to the specified number of
        /// items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVolumesInput`](crate::input::ListVolumesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVolumesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVolumesInput {
                gateway_arn: self.gateway_arn,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVolumesInputOperationOutputAlias = crate::operation::ListVolumes;
#[doc(hidden)]
pub type ListVolumesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVolumesInput {
    /// Consumes the builder and constructs an Operation<[`ListVolumes`](crate::operation::ListVolumes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVolumes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVolumesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVolumesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVolumesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ListVolumes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_volumes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVolumes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVolumes",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVolumesInput`](crate::input::ListVolumesInput)
    pub fn builder() -> crate::input::list_volumes_input::Builder {
        crate::input::list_volumes_input::Builder::default()
    }
}

/// See [`NotifyWhenUploadedInput`](crate::input::NotifyWhenUploadedInput)
pub mod notify_when_uploaded_input {
    /// A builder for [`NotifyWhenUploadedInput`](crate::input::NotifyWhenUploadedInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyWhenUploadedInput`](crate::input::NotifyWhenUploadedInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::NotifyWhenUploadedInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::NotifyWhenUploadedInput {
                file_share_arn: self.file_share_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type NotifyWhenUploadedInputOperationOutputAlias = crate::operation::NotifyWhenUploaded;
#[doc(hidden)]
pub type NotifyWhenUploadedInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl NotifyWhenUploadedInput {
    /// Consumes the builder and constructs an Operation<[`NotifyWhenUploaded`](crate::operation::NotifyWhenUploaded)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::NotifyWhenUploaded,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::NotifyWhenUploadedInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::NotifyWhenUploadedInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::NotifyWhenUploadedInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.NotifyWhenUploaded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_notify_when_uploaded(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::NotifyWhenUploaded::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "NotifyWhenUploaded",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`NotifyWhenUploadedInput`](crate::input::NotifyWhenUploadedInput)
    pub fn builder() -> crate::input::notify_when_uploaded_input::Builder {
        crate::input::notify_when_uploaded_input::Builder::default()
    }
}

/// See [`RefreshCacheInput`](crate::input::RefreshCacheInput)
pub mod refresh_cache_input {
    /// A builder for [`RefreshCacheInput`](crate::input::RefreshCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) folder_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recursive: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// Appends an item to `folder_list`.
        ///
        /// To override the contents of this collection use [`set_folder_list`](Self::set_folder_list).
        ///
        /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is
        /// [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3
        /// bucket that the file share has access to is refreshed.</p>
        pub fn folder_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.folder_list.unwrap_or_default();
            v.push(input.into());
            self.folder_list = Some(v);
            self
        }
        /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is
        /// [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3
        /// bucket that the file share has access to is refreshed.</p>
        pub fn set_folder_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.folder_list = input;
            self
        }
        /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh
        /// includes folders that were in the cache the last time the gateway listed the folder's
        /// contents. If this value set to <code>true</code>, each folder that is listed in
        /// <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in
        /// <code>FolderList</code> are not refreshed. Only objects that are in folders listed
        /// directly under <code>FolderList</code> are found and used for the update. The default is
        /// <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn recursive(mut self, input: bool) -> Self {
            self.recursive = Some(input);
            self
        }
        /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh
        /// includes folders that were in the cache the last time the gateway listed the folder's
        /// contents. If this value set to <code>true</code>, each folder that is listed in
        /// <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in
        /// <code>FolderList</code> are not refreshed. Only objects that are in folders listed
        /// directly under <code>FolderList</code> are found and used for the update. The default is
        /// <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.recursive = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshCacheInput`](crate::input::RefreshCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RefreshCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RefreshCacheInput {
                file_share_arn: self.file_share_arn,
                folder_list: self.folder_list,
                recursive: self.recursive,
            })
        }
    }
}
#[doc(hidden)]
pub type RefreshCacheInputOperationOutputAlias = crate::operation::RefreshCache;
#[doc(hidden)]
pub type RefreshCacheInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RefreshCacheInput {
    /// Consumes the builder and constructs an Operation<[`RefreshCache`](crate::operation::RefreshCache)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RefreshCache,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RefreshCacheInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RefreshCacheInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RefreshCacheInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.RefreshCache",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_refresh_cache(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RefreshCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RefreshCache",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RefreshCacheInput`](crate::input::RefreshCacheInput)
    pub fn builder() -> crate::input::refresh_cache_input::Builder {
        crate::input::refresh_cache_input::Builder::default()
    }
}

/// See [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
pub mod remove_tags_from_resource_input {
    /// A builder for [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed
        /// of a key-value pair.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed
        /// of a key-value pair.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationOutputAlias = crate::operation::RemoveTagsFromResource;
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromResource`](crate::operation::RemoveTagsFromResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.RemoveTagsFromResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromResource",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
}

/// See [`ResetCacheInput`](crate::input::ResetCacheInput)
pub mod reset_cache_input {
    /// A builder for [`ResetCacheInput`](crate::input::ResetCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetCacheInput`](crate::input::ResetCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetCacheInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetCacheInputOperationOutputAlias = crate::operation::ResetCache;
#[doc(hidden)]
pub type ResetCacheInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResetCacheInput {
    /// Consumes the builder and constructs an Operation<[`ResetCache`](crate::operation::ResetCache)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetCache,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetCacheInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetCacheInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetCacheInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ResetCache",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_reset_cache(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetCache",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetCacheInput`](crate::input::ResetCacheInput)
    pub fn builder() -> crate::input::reset_cache_input::Builder {
        crate::input::reset_cache_input::Builder::default()
    }
}

/// See [`RetrieveTapeArchiveInput`](crate::input::RetrieveTapeArchiveInput)
pub mod retrieve_tape_archive_input {
    /// A builder for [`RetrieveTapeArchiveInput`](crate::input::RetrieveTapeArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual
        /// tape shelf (VTS).</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual
        /// tape shelf (VTS).</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to.
        /// Use the <a>ListGateways</a> operation to return a list of gateways for your
        /// account and Amazon Web Services Region.</p>
        ///
        /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape
        /// gateway.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to.
        /// Use the <a>ListGateways</a> operation to return a list of gateways for your
        /// account and Amazon Web Services Region.</p>
        ///
        /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape
        /// gateway.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveTapeArchiveInput`](crate::input::RetrieveTapeArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RetrieveTapeArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RetrieveTapeArchiveInput {
                tape_arn: self.tape_arn,
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RetrieveTapeArchiveInputOperationOutputAlias = crate::operation::RetrieveTapeArchive;
#[doc(hidden)]
pub type RetrieveTapeArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RetrieveTapeArchiveInput {
    /// Consumes the builder and constructs an Operation<[`RetrieveTapeArchive`](crate::operation::RetrieveTapeArchive)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RetrieveTapeArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RetrieveTapeArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RetrieveTapeArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RetrieveTapeArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.RetrieveTapeArchive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_retrieve_tape_archive(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RetrieveTapeArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RetrieveTapeArchive",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RetrieveTapeArchiveInput`](crate::input::RetrieveTapeArchiveInput)
    pub fn builder() -> crate::input::retrieve_tape_archive_input::Builder {
        crate::input::retrieve_tape_archive_input::Builder::default()
    }
}

/// See [`RetrieveTapeRecoveryPointInput`](crate::input::RetrieveTapeRecoveryPointInput)
pub mod retrieve_tape_recovery_point_input {
    /// A builder for [`RetrieveTapeRecoveryPointInput`](crate::input::RetrieveTapeRecoveryPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the
        /// recovery point.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the
        /// recovery point.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveTapeRecoveryPointInput`](crate::input::RetrieveTapeRecoveryPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RetrieveTapeRecoveryPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RetrieveTapeRecoveryPointInput {
                tape_arn: self.tape_arn,
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RetrieveTapeRecoveryPointInputOperationOutputAlias =
    crate::operation::RetrieveTapeRecoveryPoint;
#[doc(hidden)]
pub type RetrieveTapeRecoveryPointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RetrieveTapeRecoveryPointInput {
    /// Consumes the builder and constructs an Operation<[`RetrieveTapeRecoveryPoint`](crate::operation::RetrieveTapeRecoveryPoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RetrieveTapeRecoveryPoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RetrieveTapeRecoveryPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RetrieveTapeRecoveryPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RetrieveTapeRecoveryPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.RetrieveTapeRecoveryPoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_retrieve_tape_recovery_point(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RetrieveTapeRecoveryPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RetrieveTapeRecoveryPoint",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RetrieveTapeRecoveryPointInput`](crate::input::RetrieveTapeRecoveryPointInput)
    pub fn builder() -> crate::input::retrieve_tape_recovery_point_input::Builder {
        crate::input::retrieve_tape_recovery_point_input::Builder::default()
    }
}

/// See [`SetLocalConsolePasswordInput`](crate::input::SetLocalConsolePasswordInput)
pub mod set_local_console_password_input {
    /// A builder for [`SetLocalConsolePasswordInput`](crate::input::SetLocalConsolePasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) local_console_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The password you want to set for your VM local console.</p>
        pub fn local_console_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.local_console_password = Some(input.into());
            self
        }
        /// <p>The password you want to set for your VM local console.</p>
        pub fn set_local_console_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_console_password = input;
            self
        }
        /// Consumes the builder and constructs a [`SetLocalConsolePasswordInput`](crate::input::SetLocalConsolePasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetLocalConsolePasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetLocalConsolePasswordInput {
                gateway_arn: self.gateway_arn,
                local_console_password: self.local_console_password,
            })
        }
    }
}
#[doc(hidden)]
pub type SetLocalConsolePasswordInputOperationOutputAlias =
    crate::operation::SetLocalConsolePassword;
#[doc(hidden)]
pub type SetLocalConsolePasswordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetLocalConsolePasswordInput {
    /// Consumes the builder and constructs an Operation<[`SetLocalConsolePassword`](crate::operation::SetLocalConsolePassword)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetLocalConsolePassword,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetLocalConsolePasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetLocalConsolePasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetLocalConsolePasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.SetLocalConsolePassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_local_console_password(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetLocalConsolePassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetLocalConsolePassword",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetLocalConsolePasswordInput`](crate::input::SetLocalConsolePasswordInput)
    pub fn builder() -> crate::input::set_local_console_password_input::Builder {
        crate::input::set_local_console_password_input::Builder::default()
    }
}

/// See [`SetSmbGuestPasswordInput`](crate::input::SetSmbGuestPasswordInput)
pub mod set_smb_guest_password_input {
    /// A builder for [`SetSmbGuestPasswordInput`](crate::input::SetSmbGuestPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated
        /// with.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated
        /// with.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The password that you want to set for your SMB server.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password that you want to set for your SMB server.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSmbGuestPasswordInput`](crate::input::SetSmbGuestPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetSmbGuestPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetSmbGuestPasswordInput {
                gateway_arn: self.gateway_arn,
                password: self.password,
            })
        }
    }
}
#[doc(hidden)]
pub type SetSmbGuestPasswordInputOperationOutputAlias = crate::operation::SetSMBGuestPassword;
#[doc(hidden)]
pub type SetSmbGuestPasswordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetSmbGuestPasswordInput {
    /// Consumes the builder and constructs an Operation<[`SetSMBGuestPassword`](crate::operation::SetSMBGuestPassword)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetSMBGuestPassword,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetSmbGuestPasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetSmbGuestPasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetSmbGuestPasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.SetSMBGuestPassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_smb_guest_password(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetSMBGuestPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetSMBGuestPassword",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetSmbGuestPasswordInput`](crate::input::SetSmbGuestPasswordInput)
    pub fn builder() -> crate::input::set_smb_guest_password_input::Builder {
        crate::input::set_smb_guest_password_input::Builder::default()
    }
}

/// See [`ShutdownGatewayInput`](crate::input::ShutdownGatewayInput)
pub mod shutdown_gateway_input {
    /// A builder for [`ShutdownGatewayInput`](crate::input::ShutdownGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ShutdownGatewayInput`](crate::input::ShutdownGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ShutdownGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ShutdownGatewayInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ShutdownGatewayInputOperationOutputAlias = crate::operation::ShutdownGateway;
#[doc(hidden)]
pub type ShutdownGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ShutdownGatewayInput {
    /// Consumes the builder and constructs an Operation<[`ShutdownGateway`](crate::operation::ShutdownGateway)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ShutdownGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ShutdownGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ShutdownGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ShutdownGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.ShutdownGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_shutdown_gateway(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ShutdownGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ShutdownGateway",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ShutdownGatewayInput`](crate::input::ShutdownGatewayInput)
    pub fn builder() -> crate::input::shutdown_gateway_input::Builder {
        crate::input::shutdown_gateway_input::Builder::default()
    }
}

/// See [`StartAvailabilityMonitorTestInput`](crate::input::StartAvailabilityMonitorTestInput)
pub mod start_availability_monitor_test_input {
    /// A builder for [`StartAvailabilityMonitorTestInput`](crate::input::StartAvailabilityMonitorTestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAvailabilityMonitorTestInput`](crate::input::StartAvailabilityMonitorTestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartAvailabilityMonitorTestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartAvailabilityMonitorTestInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StartAvailabilityMonitorTestInputOperationOutputAlias =
    crate::operation::StartAvailabilityMonitorTest;
#[doc(hidden)]
pub type StartAvailabilityMonitorTestInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartAvailabilityMonitorTestInput {
    /// Consumes the builder and constructs an Operation<[`StartAvailabilityMonitorTest`](crate::operation::StartAvailabilityMonitorTest)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartAvailabilityMonitorTest,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartAvailabilityMonitorTestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartAvailabilityMonitorTestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartAvailabilityMonitorTestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.StartAvailabilityMonitorTest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_availability_monitor_test(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartAvailabilityMonitorTest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartAvailabilityMonitorTest",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartAvailabilityMonitorTestInput`](crate::input::StartAvailabilityMonitorTestInput)
    pub fn builder() -> crate::input::start_availability_monitor_test_input::Builder {
        crate::input::start_availability_monitor_test_input::Builder::default()
    }
}

/// See [`StartGatewayInput`](crate::input::StartGatewayInput)
pub mod start_gateway_input {
    /// A builder for [`StartGatewayInput`](crate::input::StartGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartGatewayInput`](crate::input::StartGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartGatewayInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StartGatewayInputOperationOutputAlias = crate::operation::StartGateway;
#[doc(hidden)]
pub type StartGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartGatewayInput {
    /// Consumes the builder and constructs an Operation<[`StartGateway`](crate::operation::StartGateway)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.StartGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_gateway(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartGateway",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartGatewayInput`](crate::input::StartGatewayInput)
    pub fn builder() -> crate::input::start_gateway_input::Builder {
        crate::input::start_gateway_input::Builder::default()
    }
}

/// See [`UpdateAutomaticTapeCreationPolicyInput`](crate::input::UpdateAutomaticTapeCreationPolicyInput)
pub mod update_automatic_tape_creation_policy_input {
    /// A builder for [`UpdateAutomaticTapeCreationPolicyInput`](crate::input::UpdateAutomaticTapeCreationPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatic_tape_creation_rules:
            std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `automatic_tape_creation_rules`.
        ///
        /// To override the contents of this collection use [`set_automatic_tape_creation_rules`](Self::set_automatic_tape_creation_rules).
        ///
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
        /// The rules determine when and how to automatically create new tapes.</p>
        pub fn automatic_tape_creation_rules(
            mut self,
            input: impl Into<crate::model::AutomaticTapeCreationRule>,
        ) -> Self {
            let mut v = self.automatic_tape_creation_rules.unwrap_or_default();
            v.push(input.into());
            self.automatic_tape_creation_rules = Some(v);
            self
        }
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
        /// The rules determine when and how to automatically create new tapes.</p>
        pub fn set_automatic_tape_creation_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
        ) -> Self {
            self.automatic_tape_creation_rules = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAutomaticTapeCreationPolicyInput`](crate::input::UpdateAutomaticTapeCreationPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAutomaticTapeCreationPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAutomaticTapeCreationPolicyInput {
                automatic_tape_creation_rules: self.automatic_tape_creation_rules,
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAutomaticTapeCreationPolicyInputOperationOutputAlias =
    crate::operation::UpdateAutomaticTapeCreationPolicy;
#[doc(hidden)]
pub type UpdateAutomaticTapeCreationPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAutomaticTapeCreationPolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAutomaticTapeCreationPolicy`](crate::operation::UpdateAutomaticTapeCreationPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAutomaticTapeCreationPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAutomaticTapeCreationPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAutomaticTapeCreationPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAutomaticTapeCreationPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateAutomaticTapeCreationPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_automatic_tape_creation_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAutomaticTapeCreationPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAutomaticTapeCreationPolicy",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAutomaticTapeCreationPolicyInput`](crate::input::UpdateAutomaticTapeCreationPolicyInput)
    pub fn builder() -> crate::input::update_automatic_tape_creation_policy_input::Builder {
        crate::input::update_automatic_tape_creation_policy_input::Builder::default()
    }
}

/// See [`UpdateBandwidthRateLimitInput`](crate::input::UpdateBandwidthRateLimitInput)
pub mod update_bandwidth_rate_limit_input {
    /// A builder for [`UpdateBandwidthRateLimitInput`](crate::input::UpdateBandwidthRateLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) average_upload_rate_limit_in_bits_per_sec: std::option::Option<i64>,
        pub(crate) average_download_rate_limit_in_bits_per_sec: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second.</p>
        pub fn average_upload_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.average_upload_rate_limit_in_bits_per_sec = Some(input);
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second.</p>
        pub fn set_average_upload_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.average_upload_rate_limit_in_bits_per_sec = input;
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second.</p>
        pub fn average_download_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.average_download_rate_limit_in_bits_per_sec = Some(input);
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second.</p>
        pub fn set_average_download_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.average_download_rate_limit_in_bits_per_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBandwidthRateLimitInput`](crate::input::UpdateBandwidthRateLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBandwidthRateLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBandwidthRateLimitInput {
                gateway_arn: self.gateway_arn,
                average_upload_rate_limit_in_bits_per_sec: self
                    .average_upload_rate_limit_in_bits_per_sec,
                average_download_rate_limit_in_bits_per_sec: self
                    .average_download_rate_limit_in_bits_per_sec,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBandwidthRateLimitInputOperationOutputAlias =
    crate::operation::UpdateBandwidthRateLimit;
#[doc(hidden)]
pub type UpdateBandwidthRateLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBandwidthRateLimitInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBandwidthRateLimit`](crate::operation::UpdateBandwidthRateLimit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBandwidthRateLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBandwidthRateLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBandwidthRateLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBandwidthRateLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateBandwidthRateLimit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_bandwidth_rate_limit(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBandwidthRateLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBandwidthRateLimit",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBandwidthRateLimitInput`](crate::input::UpdateBandwidthRateLimitInput)
    pub fn builder() -> crate::input::update_bandwidth_rate_limit_input::Builder {
        crate::input::update_bandwidth_rate_limit_input::Builder::default()
    }
}

/// See [`UpdateBandwidthRateLimitScheduleInput`](crate::input::UpdateBandwidthRateLimitScheduleInput)
pub mod update_bandwidth_rate_limit_schedule_input {
    /// A builder for [`UpdateBandwidthRateLimitScheduleInput`](crate::input::UpdateBandwidthRateLimitScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_rate_limit_intervals:
            std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `bandwidth_rate_limit_intervals`.
        ///
        /// To override the contents of this collection use [`set_bandwidth_rate_limit_intervals`](Self::set_bandwidth_rate_limit_intervals).
        ///
        /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no
        /// bandwidth rate limit intervals have been scheduled, the array is empty. </p>
        pub fn bandwidth_rate_limit_intervals(
            mut self,
            input: impl Into<crate::model::BandwidthRateLimitInterval>,
        ) -> Self {
            let mut v = self.bandwidth_rate_limit_intervals.unwrap_or_default();
            v.push(input.into());
            self.bandwidth_rate_limit_intervals = Some(v);
            self
        }
        /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no
        /// bandwidth rate limit intervals have been scheduled, the array is empty. </p>
        pub fn set_bandwidth_rate_limit_intervals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
        ) -> Self {
            self.bandwidth_rate_limit_intervals = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBandwidthRateLimitScheduleInput`](crate::input::UpdateBandwidthRateLimitScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBandwidthRateLimitScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBandwidthRateLimitScheduleInput {
                gateway_arn: self.gateway_arn,
                bandwidth_rate_limit_intervals: self.bandwidth_rate_limit_intervals,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBandwidthRateLimitScheduleInputOperationOutputAlias =
    crate::operation::UpdateBandwidthRateLimitSchedule;
#[doc(hidden)]
pub type UpdateBandwidthRateLimitScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBandwidthRateLimitScheduleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBandwidthRateLimitSchedule`](crate::operation::UpdateBandwidthRateLimitSchedule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBandwidthRateLimitSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBandwidthRateLimitScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBandwidthRateLimitScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBandwidthRateLimitScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateBandwidthRateLimitSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_bandwidth_rate_limit_schedule(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBandwidthRateLimitSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBandwidthRateLimitSchedule",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBandwidthRateLimitScheduleInput`](crate::input::UpdateBandwidthRateLimitScheduleInput)
    pub fn builder() -> crate::input::update_bandwidth_rate_limit_schedule_input::Builder {
        crate::input::update_bandwidth_rate_limit_schedule_input::Builder::default()
    }
}

/// See [`UpdateChapCredentialsInput`](crate::input::UpdateChapCredentialsInput)
pub mod update_chap_credentials_input {
    /// A builder for [`UpdateChapCredentialsInput`](crate::input::UpdateChapCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) secret_to_authenticate_initiator: std::option::Option<std::string::String>,
        pub(crate) initiator_name: std::option::Option<std::string::String>,
        pub(crate) secret_to_authenticate_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified
        /// VolumeARN.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified
        /// VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to
        /// participate in mutual CHAP with the target.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn secret_to_authenticate_initiator(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_initiator = Some(input.into());
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to
        /// participate in mutual CHAP with the target.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn set_secret_to_authenticate_initiator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_initiator = input;
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.initiator_name = Some(input.into());
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initiator_name = input;
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the
        /// initiator (e.g. Windows client).</p>
        ///
        /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn secret_to_authenticate_target(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_target = Some(input.into());
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the
        /// initiator (e.g. Windows client).</p>
        ///
        /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn set_secret_to_authenticate_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_target = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChapCredentialsInput`](crate::input::UpdateChapCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChapCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChapCredentialsInput {
                target_arn: self.target_arn,
                secret_to_authenticate_initiator: self.secret_to_authenticate_initiator,
                initiator_name: self.initiator_name,
                secret_to_authenticate_target: self.secret_to_authenticate_target,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChapCredentialsInputOperationOutputAlias = crate::operation::UpdateChapCredentials;
#[doc(hidden)]
pub type UpdateChapCredentialsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateChapCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChapCredentials`](crate::operation::UpdateChapCredentials)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChapCredentials,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateChapCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateChapCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateChapCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateChapCredentials",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_chap_credentials(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChapCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChapCredentials",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateChapCredentialsInput`](crate::input::UpdateChapCredentialsInput)
    pub fn builder() -> crate::input::update_chap_credentials_input::Builder {
        crate::input::update_chap_credentials_input::Builder::default()
    }
}

/// See [`UpdateFileSystemAssociationInput`](crate::input::UpdateFileSystemAssociationInput)
pub mod update_file_system_association_input {
    /// A builder for [`UpdateFileSystemAssociationInput`](crate::input::UpdateFileSystemAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_arn: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file system association that you want to
        /// update.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association that you want to
        /// update.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = input;
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemAssociationInput`](crate::input::UpdateFileSystemAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFileSystemAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFileSystemAssociationInput {
                file_system_association_arn: self.file_system_association_arn,
                user_name: self.user_name,
                password: self.password,
                audit_destination_arn: self.audit_destination_arn,
                cache_attributes: self.cache_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFileSystemAssociationInputOperationOutputAlias =
    crate::operation::UpdateFileSystemAssociation;
#[doc(hidden)]
pub type UpdateFileSystemAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFileSystemAssociationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFileSystemAssociation`](crate::operation::UpdateFileSystemAssociation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFileSystemAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFileSystemAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFileSystemAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFileSystemAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateFileSystemAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_file_system_association(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFileSystemAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFileSystemAssociation",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemAssociationInput`](crate::input::UpdateFileSystemAssociationInput)
    pub fn builder() -> crate::input::update_file_system_association_input::Builder {
        crate::input::update_file_system_association_input::Builder::default()
    }
}

/// See [`UpdateGatewayInformationInput`](crate::input::UpdateGatewayInformationInput)
pub mod update_gateway_information_input {
    /// A builder for [`UpdateGatewayInformationInput`](crate::input::UpdateGatewayInformationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
        pub(crate) gateway_timezone: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_capacity: std::option::Option<crate::model::GatewayCapacity>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn gateway_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_timezone = Some(input.into());
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn set_gateway_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_timezone = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
        /// to monitor and log events in the gateway.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
        /// Logs?</a>
        /// </p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_log_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
        /// to monitor and log events in the gateway.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
        /// Logs?</a>
        /// </p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_log_group_arn = input;
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn gateway_capacity(mut self, input: crate::model::GatewayCapacity) -> Self {
            self.gateway_capacity = Some(input);
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn set_gateway_capacity(
            mut self,
            input: std::option::Option<crate::model::GatewayCapacity>,
        ) -> Self {
            self.gateway_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayInformationInput`](crate::input::UpdateGatewayInformationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGatewayInformationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGatewayInformationInput {
                gateway_arn: self.gateway_arn,
                gateway_name: self.gateway_name,
                gateway_timezone: self.gateway_timezone,
                cloud_watch_log_group_arn: self.cloud_watch_log_group_arn,
                gateway_capacity: self.gateway_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGatewayInformationInputOperationOutputAlias =
    crate::operation::UpdateGatewayInformation;
#[doc(hidden)]
pub type UpdateGatewayInformationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGatewayInformationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGatewayInformation`](crate::operation::UpdateGatewayInformation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGatewayInformation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGatewayInformationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGatewayInformationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGatewayInformationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateGatewayInformation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_gateway_information(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGatewayInformation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGatewayInformation",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInformationInput`](crate::input::UpdateGatewayInformationInput)
    pub fn builder() -> crate::input::update_gateway_information_input::Builder {
        crate::input::update_gateway_information_input::Builder::default()
    }
}

/// See [`UpdateGatewaySoftwareNowInput`](crate::input::UpdateGatewaySoftwareNowInput)
pub mod update_gateway_software_now_input {
    /// A builder for [`UpdateGatewaySoftwareNowInput`](crate::input::UpdateGatewaySoftwareNowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewaySoftwareNowInput`](crate::input::UpdateGatewaySoftwareNowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGatewaySoftwareNowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGatewaySoftwareNowInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGatewaySoftwareNowInputOperationOutputAlias =
    crate::operation::UpdateGatewaySoftwareNow;
#[doc(hidden)]
pub type UpdateGatewaySoftwareNowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGatewaySoftwareNowInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGatewaySoftwareNow`](crate::operation::UpdateGatewaySoftwareNow)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGatewaySoftwareNow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGatewaySoftwareNowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGatewaySoftwareNowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGatewaySoftwareNowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateGatewaySoftwareNow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_gateway_software_now(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGatewaySoftwareNow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGatewaySoftwareNow",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGatewaySoftwareNowInput`](crate::input::UpdateGatewaySoftwareNowInput)
    pub fn builder() -> crate::input::update_gateway_software_now_input::Builder {
        crate::input::update_gateway_software_now_input::Builder::default()
    }
}

/// See [`UpdateMaintenanceStartTimeInput`](crate::input::UpdateMaintenanceStartTimeInput)
pub mod update_maintenance_start_time_input {
    /// A builder for [`UpdateMaintenanceStartTimeInput`](crate::input::UpdateMaintenanceStartTimeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) hour_of_day: std::option::Option<i32>,
        pub(crate) minute_of_hour: std::option::Option<i32>,
        pub(crate) day_of_week: std::option::Option<i32>,
        pub(crate) day_of_month: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>,
        /// where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time
        /// zone of the gateway.</p>
        pub fn hour_of_day(mut self, input: i32) -> Self {
            self.hour_of_day = Some(input);
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>,
        /// where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time
        /// zone of the gateway.</p>
        pub fn set_hour_of_day(mut self, input: std::option::Option<i32>) -> Self {
            self.hour_of_day = input;
            self
        }
        /// <p>The minute component of the maintenance start time represented as
        /// <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The
        /// minute of the hour is in the time zone of the gateway.</p>
        pub fn minute_of_hour(mut self, input: i32) -> Self {
            self.minute_of_hour = Some(input);
            self
        }
        /// <p>The minute component of the maintenance start time represented as
        /// <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The
        /// minute of the hour is in the time zone of the gateway.</p>
        pub fn set_minute_of_hour(mut self, input: std::option::Option<i32>) -> Self {
            self.minute_of_hour = input;
            self
        }
        /// <p>The day of the week component of the maintenance start time week represented as an
        /// ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
        pub fn day_of_week(mut self, input: i32) -> Self {
            self.day_of_week = Some(input);
            self
        }
        /// <p>The day of the week component of the maintenance start time week represented as an
        /// ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
        pub fn set_day_of_week(mut self, input: std::option::Option<i32>) -> Self {
            self.day_of_week = input;
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal
        /// number from 1 to 28, where 1 represents the first day of the month and 28 represents the
        /// last day of the month.</p>
        pub fn day_of_month(mut self, input: i32) -> Self {
            self.day_of_month = Some(input);
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal
        /// number from 1 to 28, where 1 represents the first day of the month and 28 represents the
        /// last day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<i32>) -> Self {
            self.day_of_month = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMaintenanceStartTimeInput`](crate::input::UpdateMaintenanceStartTimeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMaintenanceStartTimeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMaintenanceStartTimeInput {
                gateway_arn: self.gateway_arn,
                hour_of_day: self.hour_of_day,
                minute_of_hour: self.minute_of_hour,
                day_of_week: self.day_of_week,
                day_of_month: self.day_of_month,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMaintenanceStartTimeInputOperationOutputAlias =
    crate::operation::UpdateMaintenanceStartTime;
#[doc(hidden)]
pub type UpdateMaintenanceStartTimeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateMaintenanceStartTimeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMaintenanceStartTime`](crate::operation::UpdateMaintenanceStartTime)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMaintenanceStartTime,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMaintenanceStartTimeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMaintenanceStartTimeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMaintenanceStartTimeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateMaintenanceStartTime",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_maintenance_start_time(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMaintenanceStartTime::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMaintenanceStartTime",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceStartTimeInput`](crate::input::UpdateMaintenanceStartTimeInput)
    pub fn builder() -> crate::input::update_maintenance_start_time_input::Builder {
        crate::input::update_maintenance_start_time_input::Builder::default()
    }
}

/// See [`UpdateNfsFileShareInput`](crate::input::UpdateNfsFileShareInput)
pub mod update_nfs_file_share_input {
    /// A builder for [`UpdateNfsFileShareInput`](crate::input::UpdateNfsFileShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) nfs_file_share_defaults: std::option::Option<crate::model::NfsFileShareDefaults>,
        pub(crate) default_storage_class: std::option::Option<std::string::String>,
        pub(crate) object_acl: std::option::Option<crate::model::ObjectAcl>,
        pub(crate) client_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) squash: std::option::Option<std::string::String>,
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) guess_mime_type_enabled: std::option::Option<bool>,
        pub(crate) requester_pays: std::option::Option<bool>,
        pub(crate) file_share_name: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) notification_policy: std::option::Option<std::string::String>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The default values for the file share. Optional.</p>
        pub fn nfs_file_share_defaults(
            mut self,
            input: crate::model::NfsFileShareDefaults,
        ) -> Self {
            self.nfs_file_share_defaults = Some(input);
            self
        }
        /// <p>The default values for the file share. Optional.</p>
        pub fn set_nfs_file_share_defaults(
            mut self,
            input: std::option::Option<crate::model::NfsFileShareDefaults>,
        ) -> Self {
            self.nfs_file_share_defaults = input;
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_storage_class = Some(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_storage_class = input;
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.object_acl = Some(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.object_acl = input;
            self
        }
        /// Appends an item to `client_list`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn client_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.client_list.unwrap_or_default();
            v.push(input.into());
            self.client_list = Some(v);
            self
        }
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.client_list = input;
            self
        }
        /// <p>The user mapped to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn squash(mut self, input: impl Into<std::string::String>) -> Self {
            self.squash = Some(input.into());
            self
        }
        /// <p>The user mapped to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn set_squash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.squash = input;
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.guess_mime_type_enabled = Some(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.guess_mime_type_enabled = input;
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.requester_pays = Some(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays = input;
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_name = Some(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_name = input;
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_policy = Some(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_policy = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNfsFileShareInput`](crate::input::UpdateNfsFileShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNfsFileShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNfsFileShareInput {
                file_share_arn: self.file_share_arn,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                nfs_file_share_defaults: self.nfs_file_share_defaults,
                default_storage_class: self.default_storage_class,
                object_acl: self.object_acl,
                client_list: self.client_list,
                squash: self.squash,
                read_only: self.read_only,
                guess_mime_type_enabled: self.guess_mime_type_enabled,
                requester_pays: self.requester_pays,
                file_share_name: self.file_share_name,
                cache_attributes: self.cache_attributes,
                notification_policy: self.notification_policy,
                audit_destination_arn: self.audit_destination_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNfsFileShareInputOperationOutputAlias = crate::operation::UpdateNFSFileShare;
#[doc(hidden)]
pub type UpdateNfsFileShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateNfsFileShareInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNFSFileShare`](crate::operation::UpdateNFSFileShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNFSFileShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNfsFileShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNfsFileShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNfsFileShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateNFSFileShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_nfs_file_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNFSFileShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNFSFileShare",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNfsFileShareInput`](crate::input::UpdateNfsFileShareInput)
    pub fn builder() -> crate::input::update_nfs_file_share_input::Builder {
        crate::input::update_nfs_file_share_input::Builder::default()
    }
}

/// See [`UpdateSmbFileShareInput`](crate::input::UpdateSmbFileShareInput)
pub mod update_smb_file_share_input {
    /// A builder for [`UpdateSmbFileShareInput`](crate::input::UpdateSmbFileShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) default_storage_class: std::option::Option<std::string::String>,
        pub(crate) object_acl: std::option::Option<crate::model::ObjectAcl>,
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) guess_mime_type_enabled: std::option::Option<bool>,
        pub(crate) requester_pays: std::option::Option<bool>,
        pub(crate) smbacl_enabled: std::option::Option<bool>,
        pub(crate) access_based_enumeration: std::option::Option<bool>,
        pub(crate) admin_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) valid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) invalid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
        pub(crate) case_sensitivity: std::option::Option<crate::model::CaseSensitivity>,
        pub(crate) file_share_name: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) notification_policy: std::option::Option<std::string::String>,
        pub(crate) oplocks_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_storage_class = Some(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_storage_class = input;
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.object_acl = Some(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.object_acl = input;
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.guess_mime_type_enabled = Some(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.guess_mime_type_enabled = input;
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.requester_pays = Some(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays = input;
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn smbacl_enabled(mut self, input: bool) -> Self {
            self.smbacl_enabled = Some(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_smbacl_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.smbacl_enabled = input;
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn access_based_enumeration(mut self, input: bool) -> Self {
            self.access_based_enumeration = Some(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn set_access_based_enumeration(mut self, input: std::option::Option<bool>) -> Self {
            self.access_based_enumeration = input;
            self
        }
        /// Appends an item to `admin_user_list`.
        ///
        /// To override the contents of this collection use [`set_admin_user_list`](Self::set_admin_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn admin_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.admin_user_list.unwrap_or_default();
            v.push(input.into());
            self.admin_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_admin_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.admin_user_list = input;
            self
        }
        /// Appends an item to `valid_user_list`.
        ///
        /// To override the contents of this collection use [`set_valid_user_list`](Self::set_valid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn valid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.valid_user_list.unwrap_or_default();
            v.push(input.into());
            self.valid_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_valid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.valid_user_list = input;
            self
        }
        /// Appends an item to `invalid_user_list`.
        ///
        /// To override the contents of this collection use [`set_invalid_user_list`](Self::set_invalid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn invalid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.invalid_user_list.unwrap_or_default();
            v.push(input.into());
            self.invalid_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_invalid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.invalid_user_list = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn case_sensitivity(mut self, input: crate::model::CaseSensitivity) -> Self {
            self.case_sensitivity = Some(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn set_case_sensitivity(
            mut self,
            input: std::option::Option<crate::model::CaseSensitivity>,
        ) -> Self {
            self.case_sensitivity = input;
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_name = Some(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_name = input;
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_policy = Some(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_policy = input;
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn oplocks_enabled(mut self, input: bool) -> Self {
            self.oplocks_enabled = Some(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_oplocks_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.oplocks_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbFileShareInput`](crate::input::UpdateSmbFileShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSmbFileShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSmbFileShareInput {
                file_share_arn: self.file_share_arn,
                kms_encrypted: self.kms_encrypted,
                kms_key: self.kms_key,
                default_storage_class: self.default_storage_class,
                object_acl: self.object_acl,
                read_only: self.read_only,
                guess_mime_type_enabled: self.guess_mime_type_enabled,
                requester_pays: self.requester_pays,
                smbacl_enabled: self.smbacl_enabled,
                access_based_enumeration: self.access_based_enumeration,
                admin_user_list: self.admin_user_list,
                valid_user_list: self.valid_user_list,
                invalid_user_list: self.invalid_user_list,
                audit_destination_arn: self.audit_destination_arn,
                case_sensitivity: self.case_sensitivity,
                file_share_name: self.file_share_name,
                cache_attributes: self.cache_attributes,
                notification_policy: self.notification_policy,
                oplocks_enabled: self.oplocks_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSmbFileShareInputOperationOutputAlias = crate::operation::UpdateSMBFileShare;
#[doc(hidden)]
pub type UpdateSmbFileShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSmbFileShareInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSMBFileShare`](crate::operation::UpdateSMBFileShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSMBFileShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSmbFileShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSmbFileShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSmbFileShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateSMBFileShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_smb_file_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSMBFileShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSMBFileShare",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSmbFileShareInput`](crate::input::UpdateSmbFileShareInput)
    pub fn builder() -> crate::input::update_smb_file_share_input::Builder {
        crate::input::update_smb_file_share_input::Builder::default()
    }
}

/// See [`UpdateSmbFileShareVisibilityInput`](crate::input::UpdateSmbFileShareVisibilityInput)
pub mod update_smb_file_share_visibility_input {
    /// A builder for [`UpdateSmbFileShareVisibilityInput`](crate::input::UpdateSmbFileShareVisibilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) file_shares_visible: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The shares on this gateway appear when listing shares.</p>
        pub fn file_shares_visible(mut self, input: bool) -> Self {
            self.file_shares_visible = Some(input);
            self
        }
        /// <p>The shares on this gateway appear when listing shares.</p>
        pub fn set_file_shares_visible(mut self, input: std::option::Option<bool>) -> Self {
            self.file_shares_visible = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbFileShareVisibilityInput`](crate::input::UpdateSmbFileShareVisibilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSmbFileShareVisibilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSmbFileShareVisibilityInput {
                gateway_arn: self.gateway_arn,
                file_shares_visible: self.file_shares_visible,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSmbFileShareVisibilityInputOperationOutputAlias =
    crate::operation::UpdateSMBFileShareVisibility;
#[doc(hidden)]
pub type UpdateSmbFileShareVisibilityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSmbFileShareVisibilityInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSMBFileShareVisibility`](crate::operation::UpdateSMBFileShareVisibility)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSMBFileShareVisibility,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSmbFileShareVisibilityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSmbFileShareVisibilityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSmbFileShareVisibilityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateSMBFileShareVisibility",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_smb_file_share_visibility(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSMBFileShareVisibility::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSMBFileShareVisibility",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSmbFileShareVisibilityInput`](crate::input::UpdateSmbFileShareVisibilityInput)
    pub fn builder() -> crate::input::update_smb_file_share_visibility_input::Builder {
        crate::input::update_smb_file_share_visibility_input::Builder::default()
    }
}

/// See [`UpdateSmbLocalGroupsInput`](crate::input::UpdateSmbLocalGroupsInput)
pub mod update_smb_local_groups_input {
    /// A builder for [`UpdateSmbLocalGroupsInput`](crate::input::UpdateSmbLocalGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) smb_local_groups: std::option::Option<crate::model::SmbLocalGroups>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>A list of Active Directory users and groups that you want to grant special permissions
        /// for SMB file shares on the gateway.</p>
        pub fn smb_local_groups(mut self, input: crate::model::SmbLocalGroups) -> Self {
            self.smb_local_groups = Some(input);
            self
        }
        /// <p>A list of Active Directory users and groups that you want to grant special permissions
        /// for SMB file shares on the gateway.</p>
        pub fn set_smb_local_groups(
            mut self,
            input: std::option::Option<crate::model::SmbLocalGroups>,
        ) -> Self {
            self.smb_local_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbLocalGroupsInput`](crate::input::UpdateSmbLocalGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSmbLocalGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSmbLocalGroupsInput {
                gateway_arn: self.gateway_arn,
                smb_local_groups: self.smb_local_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSmbLocalGroupsInputOperationOutputAlias = crate::operation::UpdateSMBLocalGroups;
#[doc(hidden)]
pub type UpdateSmbLocalGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSmbLocalGroupsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSMBLocalGroups`](crate::operation::UpdateSMBLocalGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSMBLocalGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSmbLocalGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSmbLocalGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSmbLocalGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateSMBLocalGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_smb_local_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSMBLocalGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSMBLocalGroups",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSmbLocalGroupsInput`](crate::input::UpdateSmbLocalGroupsInput)
    pub fn builder() -> crate::input::update_smb_local_groups_input::Builder {
        crate::input::update_smb_local_groups_input::Builder::default()
    }
}

/// See [`UpdateSmbSecurityStrategyInput`](crate::input::UpdateSmbSecurityStrategyInput)
pub mod update_smb_security_strategy_input {
    /// A builder for [`UpdateSmbSecurityStrategyInput`](crate::input::UpdateSmbSecurityStrategyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) smb_security_strategy: std::option::Option<crate::model::SmbSecurityStrategy>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>Specifies the type of security strategy.</p>
        ///
        /// <p>ClientSpecified: if you use this option, requests are established based on what is
        /// negotiated by the client. This option is recommended when you want to maximize
        /// compatibility across different clients in your environment. Supported only in S3 File
        /// Gateway.</p>
        ///
        /// <p>MandatorySigning: if you use this option, file gateway only allows connections from
        /// SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on
        /// Microsoft Windows Vista, Windows Server 2008 or newer.</p>
        ///
        /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from
        /// SMBv3 clients that have encryption enabled. This option is highly recommended for
        /// environments that handle sensitive data. This option works with SMB clients on Microsoft
        /// Windows 8, Windows Server 2012 or newer.</p>
        pub fn smb_security_strategy(mut self, input: crate::model::SmbSecurityStrategy) -> Self {
            self.smb_security_strategy = Some(input);
            self
        }
        /// <p>Specifies the type of security strategy.</p>
        ///
        /// <p>ClientSpecified: if you use this option, requests are established based on what is
        /// negotiated by the client. This option is recommended when you want to maximize
        /// compatibility across different clients in your environment. Supported only in S3 File
        /// Gateway.</p>
        ///
        /// <p>MandatorySigning: if you use this option, file gateway only allows connections from
        /// SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on
        /// Microsoft Windows Vista, Windows Server 2008 or newer.</p>
        ///
        /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from
        /// SMBv3 clients that have encryption enabled. This option is highly recommended for
        /// environments that handle sensitive data. This option works with SMB clients on Microsoft
        /// Windows 8, Windows Server 2012 or newer.</p>
        pub fn set_smb_security_strategy(
            mut self,
            input: std::option::Option<crate::model::SmbSecurityStrategy>,
        ) -> Self {
            self.smb_security_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmbSecurityStrategyInput`](crate::input::UpdateSmbSecurityStrategyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSmbSecurityStrategyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSmbSecurityStrategyInput {
                gateway_arn: self.gateway_arn,
                smb_security_strategy: self.smb_security_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSmbSecurityStrategyInputOperationOutputAlias =
    crate::operation::UpdateSMBSecurityStrategy;
#[doc(hidden)]
pub type UpdateSmbSecurityStrategyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSmbSecurityStrategyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSMBSecurityStrategy`](crate::operation::UpdateSMBSecurityStrategy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSMBSecurityStrategy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSmbSecurityStrategyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSmbSecurityStrategyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSmbSecurityStrategyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateSMBSecurityStrategy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_smb_security_strategy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSMBSecurityStrategy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSMBSecurityStrategy",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSmbSecurityStrategyInput`](crate::input::UpdateSmbSecurityStrategyInput)
    pub fn builder() -> crate::input::update_smb_security_strategy_input::Builder {
        crate::input::update_smb_security_strategy_input::Builder::default()
    }
}

/// See [`UpdateSnapshotScheduleInput`](crate::input::UpdateSnapshotScheduleInput)
pub mod update_snapshot_schedule_input {
    /// A builder for [`UpdateSnapshotScheduleInput`](crate::input::UpdateSnapshotScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) start_at: std::option::Option<i32>,
        pub(crate) recurrence_in_hours: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as
        /// <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour
        /// of the day is in the time zone of the gateway.</p>
        pub fn start_at(mut self, input: i32) -> Self {
            self.start_at = Some(input);
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as
        /// <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour
        /// of the day is in the time zone of the gateway.</p>
        pub fn set_start_at(mut self, input: std::option::Option<i32>) -> Self {
            self.start_at = input;
            self
        }
        /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
        pub fn recurrence_in_hours(mut self, input: i32) -> Self {
            self.recurrence_in_hours = Some(input);
            self
        }
        /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
        pub fn set_recurrence_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.recurrence_in_hours = input;
            self
        }
        /// <p>Optional description of the snapshot that overwrites the existing description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Optional description of the snapshot that overwrites the existing description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSnapshotScheduleInput`](crate::input::UpdateSnapshotScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSnapshotScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSnapshotScheduleInput {
                volume_arn: self.volume_arn,
                start_at: self.start_at,
                recurrence_in_hours: self.recurrence_in_hours,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSnapshotScheduleInputOperationOutputAlias = crate::operation::UpdateSnapshotSchedule;
#[doc(hidden)]
pub type UpdateSnapshotScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSnapshotScheduleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSnapshotSchedule`](crate::operation::UpdateSnapshotSchedule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSnapshotSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSnapshotScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSnapshotScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSnapshotScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateSnapshotSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_snapshot_schedule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSnapshotSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSnapshotSchedule",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSnapshotScheduleInput`](crate::input::UpdateSnapshotScheduleInput)
    pub fn builder() -> crate::input::update_snapshot_schedule_input::Builder {
        crate::input::update_snapshot_schedule_input::Builder::default()
    }
}

/// See [`UpdateVtlDeviceTypeInput`](crate::input::UpdateVtlDeviceTypeInput)
pub mod update_vtl_device_type_input {
    /// A builder for [`UpdateVtlDeviceTypeInput`](crate::input::UpdateVtlDeviceTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vtl_device_arn: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
        pub fn vtl_device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vtl_device_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
        pub fn set_vtl_device_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vtl_device_arn = input;
            self
        }
        /// <p>The type of medium changer you want to select.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The type of medium changer you want to select.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVtlDeviceTypeInput`](crate::input::UpdateVtlDeviceTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVtlDeviceTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVtlDeviceTypeInput {
                vtl_device_arn: self.vtl_device_arn,
                device_type: self.device_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVtlDeviceTypeInputOperationOutputAlias = crate::operation::UpdateVTLDeviceType;
#[doc(hidden)]
pub type UpdateVtlDeviceTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateVtlDeviceTypeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVTLDeviceType`](crate::operation::UpdateVTLDeviceType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVTLDeviceType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateVtlDeviceTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateVtlDeviceTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateVtlDeviceTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StorageGateway_20130630.UpdateVTLDeviceType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_vtl_device_type(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVTLDeviceType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVTLDeviceType",
            "storagegateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateVtlDeviceTypeInput`](crate::input::UpdateVtlDeviceTypeInput)
    pub fn builder() -> crate::input::update_vtl_device_type_input::Builder {
        crate::input::update_vtl_device_type_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVtlDeviceTypeInput {
    /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
    pub vtl_device_arn: std::option::Option<std::string::String>,
    /// <p>The type of medium changer you want to select.</p>
    ///
    /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
    /// <code>IBM-03584L32-0402</code>
    /// </p>
    pub device_type: std::option::Option<std::string::String>,
}
impl UpdateVtlDeviceTypeInput {
    /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
    pub fn vtl_device_arn(&self) -> std::option::Option<&str> {
        self.vtl_device_arn.as_deref()
    }
    /// <p>The type of medium changer you want to select.</p>
    ///
    /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
    /// <code>IBM-03584L32-0402</code>
    /// </p>
    pub fn device_type(&self) -> std::option::Option<&str> {
        self.device_type.as_deref()
    }
}
impl std::fmt::Debug for UpdateVtlDeviceTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVtlDeviceTypeInput");
        formatter.field("vtl_device_arn", &self.vtl_device_arn);
        formatter.field("device_type", &self.device_type);
        formatter.finish()
    }
}

/// <p>A JSON object containing one or more of the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>UpdateSnapshotScheduleInput$Description</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateSnapshotScheduleInput$RecurrenceInHours</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateSnapshotScheduleInput$StartAt</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateSnapshotScheduleInput$VolumeARN</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSnapshotScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The hour of the day at which the snapshot schedule begins represented as
    /// <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour
    /// of the day is in the time zone of the gateway.</p>
    pub start_at: std::option::Option<i32>,
    /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
    pub recurrence_in_hours: std::option::Option<i32>,
    /// <p>Optional description of the snapshot that overwrites the existing description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
    /// pair.</p>
    ///
    /// <note>
    /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
    /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
    /// of a tag's key is 128 characters, and the maximum length for a tag's value is
    /// 256.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UpdateSnapshotScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The hour of the day at which the snapshot schedule begins represented as
    /// <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour
    /// of the day is in the time zone of the gateway.</p>
    pub fn start_at(&self) -> std::option::Option<i32> {
        self.start_at
    }
    /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
    pub fn recurrence_in_hours(&self) -> std::option::Option<i32> {
        self.recurrence_in_hours
    }
    /// <p>Optional description of the snapshot that overwrites the existing description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
    /// pair.</p>
    ///
    /// <note>
    /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
    /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
    /// of a tag's key is 128 characters, and the maximum length for a tag's value is
    /// 256.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UpdateSnapshotScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSnapshotScheduleInput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("start_at", &self.start_at);
        formatter.field("recurrence_in_hours", &self.recurrence_in_hours);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbSecurityStrategyInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the type of security strategy.</p>
    ///
    /// <p>ClientSpecified: if you use this option, requests are established based on what is
    /// negotiated by the client. This option is recommended when you want to maximize
    /// compatibility across different clients in your environment. Supported only in S3 File
    /// Gateway.</p>
    ///
    /// <p>MandatorySigning: if you use this option, file gateway only allows connections from
    /// SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on
    /// Microsoft Windows Vista, Windows Server 2008 or newer.</p>
    ///
    /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from
    /// SMBv3 clients that have encryption enabled. This option is highly recommended for
    /// environments that handle sensitive data. This option works with SMB clients on Microsoft
    /// Windows 8, Windows Server 2012 or newer.</p>
    pub smb_security_strategy: std::option::Option<crate::model::SmbSecurityStrategy>,
}
impl UpdateSmbSecurityStrategyInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>Specifies the type of security strategy.</p>
    ///
    /// <p>ClientSpecified: if you use this option, requests are established based on what is
    /// negotiated by the client. This option is recommended when you want to maximize
    /// compatibility across different clients in your environment. Supported only in S3 File
    /// Gateway.</p>
    ///
    /// <p>MandatorySigning: if you use this option, file gateway only allows connections from
    /// SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on
    /// Microsoft Windows Vista, Windows Server 2008 or newer.</p>
    ///
    /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from
    /// SMBv3 clients that have encryption enabled. This option is highly recommended for
    /// environments that handle sensitive data. This option works with SMB clients on Microsoft
    /// Windows 8, Windows Server 2012 or newer.</p>
    pub fn smb_security_strategy(&self) -> std::option::Option<&crate::model::SmbSecurityStrategy> {
        self.smb_security_strategy.as_ref()
    }
}
impl std::fmt::Debug for UpdateSmbSecurityStrategyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbSecurityStrategyInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("smb_security_strategy", &self.smb_security_strategy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbLocalGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>A list of Active Directory users and groups that you want to grant special permissions
    /// for SMB file shares on the gateway.</p>
    pub smb_local_groups: std::option::Option<crate::model::SmbLocalGroups>,
}
impl UpdateSmbLocalGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>A list of Active Directory users and groups that you want to grant special permissions
    /// for SMB file shares on the gateway.</p>
    pub fn smb_local_groups(&self) -> std::option::Option<&crate::model::SmbLocalGroups> {
        self.smb_local_groups.as_ref()
    }
}
impl std::fmt::Debug for UpdateSmbLocalGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbLocalGroupsInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("smb_local_groups", &self.smb_local_groups);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbFileShareVisibilityInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The shares on this gateway appear when listing shares.</p>
    pub file_shares_visible: std::option::Option<bool>,
}
impl UpdateSmbFileShareVisibilityInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The shares on this gateway appear when listing shares.</p>
    pub fn file_shares_visible(&self) -> std::option::Option<bool> {
        self.file_shares_visible
    }
}
impl std::fmt::Debug for UpdateSmbFileShareVisibilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbFileShareVisibilityInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("file_shares_visible", &self.file_shares_visible);
        formatter.finish()
    }
}

/// <p>UpdateSMBFileShareInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSmbFileShareInput {
    /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub kms_encrypted: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
    /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
    ///
    /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
    /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
    /// </p>
    pub default_storage_class: std::option::Option<std::string::String>,
    /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
    /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    pub object_acl: std::option::Option<crate::model::ObjectAcl>,
    /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
    /// to set write status to read-only, otherwise set to <code>false</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub read_only: std::option::Option<bool>,
    /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
    /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
    /// to <code>false</code>. The default value is <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub guess_mime_type_enabled: std::option::Option<bool>,
    /// <p>A value that sets who pays the cost of the request and the cost associated with data
    /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
    /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
    /// the cost of storing data.</p>
    ///
    /// <note>
    /// <p>
    /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
    /// share, so make sure that the configuration on the file share is the same as the S3
    /// bucket configuration.</p>
    /// </note>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub requester_pays: std::option::Option<bool>,
    /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
    /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
    /// permissions.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
    /// control access to an SMB file share</a> in the <i>Storage Gateway User
    /// Guide</i>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub smbacl_enabled: std::option::Option<bool>,
    /// <p>The files and folders on this share will only be visible to users with read
    /// access.</p>
    pub access_based_enumeration: std::option::Option<bool>,
    /// <p>A list of users or groups in the Active Directory that have administrator rights to the
    /// file share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub admin_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of users or groups in the Active Directory that are allowed to access the file
    /// share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub valid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of users or groups in the Active Directory that are not allowed to access the
    /// file share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub invalid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    pub audit_destination_arn: std::option::Option<std::string::String>,
    /// <p>The case of an object name in an Amazon S3 bucket. For
    /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
    /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
    /// value is <code>ClientSpecified</code>.</p>
    pub case_sensitivity: std::option::Option<crate::model::CaseSensitivity>,
    /// <p>The name of the file share. Optional.</p>
    ///
    /// <note>
    /// <p>
    /// <code>FileShareName</code> must be set if an S3 prefix name is set in
    /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
    /// </note>
    pub file_share_name: std::option::Option<std::string::String>,
    /// <p>Specifies refresh cache information for the file share.</p>
    pub cache_attributes: std::option::Option<crate::model::CacheAttributes>,
    /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
    /// the number of seconds to wait after the last point in time a client wrote to a file before
    /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
    /// writes to files, it's best to set this parameter for as long as possible to avoid
    /// generating multiple notifications for the same file in a small time period.</p>
    ///
    /// <note>
    /// <p>
    /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
    /// uploading to Amazon S3, only the timing of the notification.</p>
    /// </note>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> on with
    /// <code>SettlingTimeInSeconds</code> set to 60.</p>
    ///
    /// <p>
    /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
    /// </p>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
    ///
    /// <p>
    /// <code>{}</code>
    /// </p>
    pub notification_policy: std::option::Option<std::string::String>,
    /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
    /// <note>
    /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
    /// workloads that involve access to files with the same name in different case.</p>
    /// </note>
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub oplocks_enabled: std::option::Option<bool>,
}
impl UpdateSmbFileShareInput {
    /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn kms_encrypted(&self) -> std::option::Option<bool> {
        self.kms_encrypted
    }
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub fn kms_key(&self) -> std::option::Option<&str> {
        self.kms_key.as_deref()
    }
    /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
    /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
    ///
    /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
    /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
    /// </p>
    pub fn default_storage_class(&self) -> std::option::Option<&str> {
        self.default_storage_class.as_deref()
    }
    /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
    /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    pub fn object_acl(&self) -> std::option::Option<&crate::model::ObjectAcl> {
        self.object_acl.as_ref()
    }
    /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
    /// to set write status to read-only, otherwise set to <code>false</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn read_only(&self) -> std::option::Option<bool> {
        self.read_only
    }
    /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
    /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
    /// to <code>false</code>. The default value is <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn guess_mime_type_enabled(&self) -> std::option::Option<bool> {
        self.guess_mime_type_enabled
    }
    /// <p>A value that sets who pays the cost of the request and the cost associated with data
    /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
    /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
    /// the cost of storing data.</p>
    ///
    /// <note>
    /// <p>
    /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
    /// share, so make sure that the configuration on the file share is the same as the S3
    /// bucket configuration.</p>
    /// </note>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn requester_pays(&self) -> std::option::Option<bool> {
        self.requester_pays
    }
    /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
    /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
    /// permissions.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
    /// control access to an SMB file share</a> in the <i>Storage Gateway User
    /// Guide</i>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn smbacl_enabled(&self) -> std::option::Option<bool> {
        self.smbacl_enabled
    }
    /// <p>The files and folders on this share will only be visible to users with read
    /// access.</p>
    pub fn access_based_enumeration(&self) -> std::option::Option<bool> {
        self.access_based_enumeration
    }
    /// <p>A list of users or groups in the Active Directory that have administrator rights to the
    /// file share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub fn admin_user_list(&self) -> std::option::Option<&[std::string::String]> {
        self.admin_user_list.as_deref()
    }
    /// <p>A list of users or groups in the Active Directory that are allowed to access the file
    /// share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub fn valid_user_list(&self) -> std::option::Option<&[std::string::String]> {
        self.valid_user_list.as_deref()
    }
    /// <p>A list of users or groups in the Active Directory that are not allowed to access the
    /// file share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub fn invalid_user_list(&self) -> std::option::Option<&[std::string::String]> {
        self.invalid_user_list.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    pub fn audit_destination_arn(&self) -> std::option::Option<&str> {
        self.audit_destination_arn.as_deref()
    }
    /// <p>The case of an object name in an Amazon S3 bucket. For
    /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
    /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
    /// value is <code>ClientSpecified</code>.</p>
    pub fn case_sensitivity(&self) -> std::option::Option<&crate::model::CaseSensitivity> {
        self.case_sensitivity.as_ref()
    }
    /// <p>The name of the file share. Optional.</p>
    ///
    /// <note>
    /// <p>
    /// <code>FileShareName</code> must be set if an S3 prefix name is set in
    /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
    /// </note>
    pub fn file_share_name(&self) -> std::option::Option<&str> {
        self.file_share_name.as_deref()
    }
    /// <p>Specifies refresh cache information for the file share.</p>
    pub fn cache_attributes(&self) -> std::option::Option<&crate::model::CacheAttributes> {
        self.cache_attributes.as_ref()
    }
    /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
    /// the number of seconds to wait after the last point in time a client wrote to a file before
    /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
    /// writes to files, it's best to set this parameter for as long as possible to avoid
    /// generating multiple notifications for the same file in a small time period.</p>
    ///
    /// <note>
    /// <p>
    /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
    /// uploading to Amazon S3, only the timing of the notification.</p>
    /// </note>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> on with
    /// <code>SettlingTimeInSeconds</code> set to 60.</p>
    ///
    /// <p>
    /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
    /// </p>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
    ///
    /// <p>
    /// <code>{}</code>
    /// </p>
    pub fn notification_policy(&self) -> std::option::Option<&str> {
        self.notification_policy.as_deref()
    }
    /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
    /// <note>
    /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
    /// workloads that involve access to files with the same name in different case.</p>
    /// </note>
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn oplocks_enabled(&self) -> std::option::Option<bool> {
        self.oplocks_enabled
    }
}
impl std::fmt::Debug for UpdateSmbFileShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSmbFileShareInput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("kms_encrypted", &self.kms_encrypted);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("default_storage_class", &self.default_storage_class);
        formatter.field("object_acl", &self.object_acl);
        formatter.field("read_only", &self.read_only);
        formatter.field("guess_mime_type_enabled", &self.guess_mime_type_enabled);
        formatter.field("requester_pays", &self.requester_pays);
        formatter.field("smbacl_enabled", &self.smbacl_enabled);
        formatter.field("access_based_enumeration", &self.access_based_enumeration);
        formatter.field("admin_user_list", &self.admin_user_list);
        formatter.field("valid_user_list", &self.valid_user_list);
        formatter.field("invalid_user_list", &self.invalid_user_list);
        formatter.field("audit_destination_arn", &self.audit_destination_arn);
        formatter.field("case_sensitivity", &self.case_sensitivity);
        formatter.field("file_share_name", &self.file_share_name);
        formatter.field("cache_attributes", &self.cache_attributes);
        formatter.field("notification_policy", &self.notification_policy);
        formatter.field("oplocks_enabled", &self.oplocks_enabled);
        formatter.finish()
    }
}

/// <p>UpdateNFSFileShareInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNfsFileShareInput {
    /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub kms_encrypted: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The default values for the file share. Optional.</p>
    pub nfs_file_share_defaults: std::option::Option<crate::model::NfsFileShareDefaults>,
    /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
    /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
    ///
    /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
    /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
    /// </p>
    pub default_storage_class: std::option::Option<std::string::String>,
    /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
    /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    pub object_acl: std::option::Option<crate::model::ObjectAcl>,
    /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
    /// contain either valid IP addresses or valid CIDR blocks.</p>
    pub client_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user mapped to anonymous user.</p>
    ///
    /// <p>Valid values are the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
    /// </li>
    /// </ul>
    pub squash: std::option::Option<std::string::String>,
    /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
    /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub read_only: std::option::Option<bool>,
    /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
    /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
    /// to <code>false</code>. The default value is <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub guess_mime_type_enabled: std::option::Option<bool>,
    /// <p>A value that sets who pays the cost of the request and the cost associated with data
    /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
    /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
    /// the cost of storing data.</p>
    ///
    /// <note>
    /// <p>
    /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
    /// share, so make sure that the configuration on the file share is the same as the S3
    /// bucket configuration.</p>
    /// </note>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub requester_pays: std::option::Option<bool>,
    /// <p>The name of the file share. Optional.</p>
    ///
    /// <note>
    /// <p>
    /// <code>FileShareName</code> must be set if an S3 prefix name is set in
    /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
    /// </note>
    pub file_share_name: std::option::Option<std::string::String>,
    /// <p>Specifies refresh cache information for the file share.</p>
    pub cache_attributes: std::option::Option<crate::model::CacheAttributes>,
    /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
    /// the number of seconds to wait after the last point in time a client wrote to a file before
    /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
    /// writes to files, it's best to set this parameter for as long as possible to avoid
    /// generating multiple notifications for the same file in a small time period.</p>
    ///
    /// <note>
    /// <p>
    /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
    /// uploading to Amazon S3, only the timing of the notification.</p>
    /// </note>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> on with
    /// <code>SettlingTimeInSeconds</code> set to 60.</p>
    ///
    /// <p>
    /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
    /// </p>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
    ///
    /// <p>
    /// <code>{}</code>
    /// </p>
    pub notification_policy: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    pub audit_destination_arn: std::option::Option<std::string::String>,
}
impl UpdateNfsFileShareInput {
    /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn kms_encrypted(&self) -> std::option::Option<bool> {
        self.kms_encrypted
    }
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub fn kms_key(&self) -> std::option::Option<&str> {
        self.kms_key.as_deref()
    }
    /// <p>The default values for the file share. Optional.</p>
    pub fn nfs_file_share_defaults(
        &self,
    ) -> std::option::Option<&crate::model::NfsFileShareDefaults> {
        self.nfs_file_share_defaults.as_ref()
    }
    /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
    /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
    ///
    /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
    /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
    /// </p>
    pub fn default_storage_class(&self) -> std::option::Option<&str> {
        self.default_storage_class.as_deref()
    }
    /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
    /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
    pub fn object_acl(&self) -> std::option::Option<&crate::model::ObjectAcl> {
        self.object_acl.as_ref()
    }
    /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
    /// contain either valid IP addresses or valid CIDR blocks.</p>
    pub fn client_list(&self) -> std::option::Option<&[std::string::String]> {
        self.client_list.as_deref()
    }
    /// <p>The user mapped to anonymous user.</p>
    ///
    /// <p>Valid values are the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
    /// </li>
    /// </ul>
    pub fn squash(&self) -> std::option::Option<&str> {
        self.squash.as_deref()
    }
    /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
    /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn read_only(&self) -> std::option::Option<bool> {
        self.read_only
    }
    /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
    /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
    /// to <code>false</code>. The default value is <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn guess_mime_type_enabled(&self) -> std::option::Option<bool> {
        self.guess_mime_type_enabled
    }
    /// <p>A value that sets who pays the cost of the request and the cost associated with data
    /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
    /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
    /// the cost of storing data.</p>
    ///
    /// <note>
    /// <p>
    /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
    /// share, so make sure that the configuration on the file share is the same as the S3
    /// bucket configuration.</p>
    /// </note>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn requester_pays(&self) -> std::option::Option<bool> {
        self.requester_pays
    }
    /// <p>The name of the file share. Optional.</p>
    ///
    /// <note>
    /// <p>
    /// <code>FileShareName</code> must be set if an S3 prefix name is set in
    /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
    /// </note>
    pub fn file_share_name(&self) -> std::option::Option<&str> {
        self.file_share_name.as_deref()
    }
    /// <p>Specifies refresh cache information for the file share.</p>
    pub fn cache_attributes(&self) -> std::option::Option<&crate::model::CacheAttributes> {
        self.cache_attributes.as_ref()
    }
    /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
    /// the number of seconds to wait after the last point in time a client wrote to a file before
    /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
    /// writes to files, it's best to set this parameter for as long as possible to avoid
    /// generating multiple notifications for the same file in a small time period.</p>
    ///
    /// <note>
    /// <p>
    /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
    /// uploading to Amazon S3, only the timing of the notification.</p>
    /// </note>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> on with
    /// <code>SettlingTimeInSeconds</code> set to 60.</p>
    ///
    /// <p>
    /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
    /// </p>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
    ///
    /// <p>
    /// <code>{}</code>
    /// </p>
    pub fn notification_policy(&self) -> std::option::Option<&str> {
        self.notification_policy.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    pub fn audit_destination_arn(&self) -> std::option::Option<&str> {
        self.audit_destination_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateNfsFileShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNfsFileShareInput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("kms_encrypted", &self.kms_encrypted);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("nfs_file_share_defaults", &self.nfs_file_share_defaults);
        formatter.field("default_storage_class", &self.default_storage_class);
        formatter.field("object_acl", &self.object_acl);
        formatter.field("client_list", &self.client_list);
        formatter.field("squash", &self.squash);
        formatter.field("read_only", &self.read_only);
        formatter.field("guess_mime_type_enabled", &self.guess_mime_type_enabled);
        formatter.field("requester_pays", &self.requester_pays);
        formatter.field("file_share_name", &self.file_share_name);
        formatter.field("cache_attributes", &self.cache_attributes);
        formatter.field("notification_policy", &self.notification_policy);
        formatter.field("audit_destination_arn", &self.audit_destination_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>UpdateMaintenanceStartTimeInput$DayOfMonth</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateMaintenanceStartTimeInput$DayOfWeek</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateMaintenanceStartTimeInput$HourOfDay</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateMaintenanceStartTimeInput$MinuteOfHour</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMaintenanceStartTimeInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The hour component of the maintenance start time represented as <i>hh</i>,
    /// where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time
    /// zone of the gateway.</p>
    pub hour_of_day: std::option::Option<i32>,
    /// <p>The minute component of the maintenance start time represented as
    /// <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The
    /// minute of the hour is in the time zone of the gateway.</p>
    pub minute_of_hour: std::option::Option<i32>,
    /// <p>The day of the week component of the maintenance start time week represented as an
    /// ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
    pub day_of_week: std::option::Option<i32>,
    /// <p>The day of the month component of the maintenance start time represented as an ordinal
    /// number from 1 to 28, where 1 represents the first day of the month and 28 represents the
    /// last day of the month.</p>
    pub day_of_month: std::option::Option<i32>,
}
impl UpdateMaintenanceStartTimeInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The hour component of the maintenance start time represented as <i>hh</i>,
    /// where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time
    /// zone of the gateway.</p>
    pub fn hour_of_day(&self) -> std::option::Option<i32> {
        self.hour_of_day
    }
    /// <p>The minute component of the maintenance start time represented as
    /// <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The
    /// minute of the hour is in the time zone of the gateway.</p>
    pub fn minute_of_hour(&self) -> std::option::Option<i32> {
        self.minute_of_hour
    }
    /// <p>The day of the week component of the maintenance start time week represented as an
    /// ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
    pub fn day_of_week(&self) -> std::option::Option<i32> {
        self.day_of_week
    }
    /// <p>The day of the month component of the maintenance start time represented as an ordinal
    /// number from 1 to 28, where 1 represents the first day of the month and 28 represents the
    /// last day of the month.</p>
    pub fn day_of_month(&self) -> std::option::Option<i32> {
        self.day_of_month
    }
}
impl std::fmt::Debug for UpdateMaintenanceStartTimeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMaintenanceStartTimeInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("hour_of_day", &self.hour_of_day);
        formatter.field("minute_of_hour", &self.minute_of_hour);
        formatter.field("day_of_week", &self.day_of_week);
        formatter.field("day_of_month", &self.day_of_month);
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway to update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewaySoftwareNowInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateGatewaySoftwareNowInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateGatewaySoftwareNowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewaySoftwareNowInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayInformationInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The name you configured for your gateway.</p>
    pub gateway_name: std::option::Option<std::string::String>,
    /// <p>A value that indicates the time zone of the gateway.</p>
    pub gateway_timezone: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
    /// to monitor and log events in the gateway.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
    /// Logs?</a>
    /// </p>
    pub cloud_watch_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the size of the gateway's metadata cache.</p>
    pub gateway_capacity: std::option::Option<crate::model::GatewayCapacity>,
}
impl UpdateGatewayInformationInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The name you configured for your gateway.</p>
    pub fn gateway_name(&self) -> std::option::Option<&str> {
        self.gateway_name.as_deref()
    }
    /// <p>A value that indicates the time zone of the gateway.</p>
    pub fn gateway_timezone(&self) -> std::option::Option<&str> {
        self.gateway_timezone.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
    /// to monitor and log events in the gateway.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
    /// Logs?</a>
    /// </p>
    pub fn cloud_watch_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_log_group_arn.as_deref()
    }
    /// <p>Specifies the size of the gateway's metadata cache.</p>
    pub fn gateway_capacity(&self) -> std::option::Option<&crate::model::GatewayCapacity> {
        self.gateway_capacity.as_ref()
    }
}
impl std::fmt::Debug for UpdateGatewayInformationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayInformationInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("gateway_name", &self.gateway_name);
        formatter.field("gateway_timezone", &self.gateway_timezone);
        formatter.field("cloud_watch_log_group_arn", &self.cloud_watch_log_group_arn);
        formatter.field("gateway_capacity", &self.gateway_capacity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemAssociationInput {
    /// <p>The Amazon Resource Name (ARN) of the file system association that you want to
    /// update.</p>
    pub file_system_association_arn: std::option::Option<std::string::String>,
    /// <p>The user name of the user credential that has permission to access the root share D$ of
    /// the Amazon FSx file system. The user account must belong to the Amazon FSx
    /// delegated admin user group.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The password of the user credential.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
    pub audit_destination_arn: std::option::Option<std::string::String>,
    /// <p>The refresh cache information for the file share or FSx file systems.</p>
    pub cache_attributes: std::option::Option<crate::model::CacheAttributes>,
}
impl UpdateFileSystemAssociationInput {
    /// <p>The Amazon Resource Name (ARN) of the file system association that you want to
    /// update.</p>
    pub fn file_system_association_arn(&self) -> std::option::Option<&str> {
        self.file_system_association_arn.as_deref()
    }
    /// <p>The user name of the user credential that has permission to access the root share D$ of
    /// the Amazon FSx file system. The user account must belong to the Amazon FSx
    /// delegated admin user group.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The password of the user credential.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
    pub fn audit_destination_arn(&self) -> std::option::Option<&str> {
        self.audit_destination_arn.as_deref()
    }
    /// <p>The refresh cache information for the file share or FSx file systems.</p>
    pub fn cache_attributes(&self) -> std::option::Option<&crate::model::CacheAttributes> {
        self.cache_attributes.as_ref()
    }
}
impl std::fmt::Debug for UpdateFileSystemAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemAssociationInput");
        formatter.field(
            "file_system_association_arn",
            &self.file_system_association_arn,
        );
        formatter.field("user_name", &self.user_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("audit_destination_arn", &self.audit_destination_arn);
        formatter.field("cache_attributes", &self.cache_attributes);
        formatter.finish()
    }
}

/// <p>A JSON object containing one or more of the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>UpdateChapCredentialsInput$InitiatorName</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateChapCredentialsInput$SecretToAuthenticateInitiator</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateChapCredentialsInput$SecretToAuthenticateTarget</a>
/// </p>
///
/// </li>
/// <li>
/// <p>
/// <a>UpdateChapCredentialsInput$TargetARN</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChapCredentialsInput {
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified
    /// VolumeARN.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The secret key that the initiator (for example, the Windows client) must provide to
    /// participate in mutual CHAP with the target.</p>
    ///
    /// <note>
    /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
    /// </note>
    pub secret_to_authenticate_initiator: std::option::Option<std::string::String>,
    /// <p>The iSCSI initiator that connects to the target.</p>
    pub initiator_name: std::option::Option<std::string::String>,
    /// <p>The secret key that the target must provide to participate in mutual CHAP with the
    /// initiator (e.g. Windows client).</p>
    ///
    /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p>
    ///
    /// <note>
    /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
    /// </note>
    pub secret_to_authenticate_target: std::option::Option<std::string::String>,
}
impl UpdateChapCredentialsInput {
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified
    /// VolumeARN.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The secret key that the initiator (for example, the Windows client) must provide to
    /// participate in mutual CHAP with the target.</p>
    ///
    /// <note>
    /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
    /// </note>
    pub fn secret_to_authenticate_initiator(&self) -> std::option::Option<&str> {
        self.secret_to_authenticate_initiator.as_deref()
    }
    /// <p>The iSCSI initiator that connects to the target.</p>
    pub fn initiator_name(&self) -> std::option::Option<&str> {
        self.initiator_name.as_deref()
    }
    /// <p>The secret key that the target must provide to participate in mutual CHAP with the
    /// initiator (e.g. Windows client).</p>
    ///
    /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p>
    ///
    /// <note>
    /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
    /// </note>
    pub fn secret_to_authenticate_target(&self) -> std::option::Option<&str> {
        self.secret_to_authenticate_target.as_deref()
    }
}
impl std::fmt::Debug for UpdateChapCredentialsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChapCredentialsInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field(
            "secret_to_authenticate_initiator",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("initiator_name", &self.initiator_name);
        formatter.field(
            "secret_to_authenticate_target",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBandwidthRateLimitScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no
    /// bandwidth rate limit intervals have been scheduled, the array is empty. </p>
    pub bandwidth_rate_limit_intervals:
        std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
}
impl UpdateBandwidthRateLimitScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no
    /// bandwidth rate limit intervals have been scheduled, the array is empty. </p>
    pub fn bandwidth_rate_limit_intervals(
        &self,
    ) -> std::option::Option<&[crate::model::BandwidthRateLimitInterval]> {
        self.bandwidth_rate_limit_intervals.as_deref()
    }
}
impl std::fmt::Debug for UpdateBandwidthRateLimitScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBandwidthRateLimitScheduleInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field(
            "bandwidth_rate_limit_intervals",
            &self.bandwidth_rate_limit_intervals,
        );
        formatter.finish()
    }
}

/// <p>A JSON object containing one or more of the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBandwidthRateLimitInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The average upload bandwidth rate limit in bits per second.</p>
    pub average_upload_rate_limit_in_bits_per_sec: std::option::Option<i64>,
    /// <p>The average download bandwidth rate limit in bits per second.</p>
    pub average_download_rate_limit_in_bits_per_sec: std::option::Option<i64>,
}
impl UpdateBandwidthRateLimitInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The average upload bandwidth rate limit in bits per second.</p>
    pub fn average_upload_rate_limit_in_bits_per_sec(&self) -> std::option::Option<i64> {
        self.average_upload_rate_limit_in_bits_per_sec
    }
    /// <p>The average download bandwidth rate limit in bits per second.</p>
    pub fn average_download_rate_limit_in_bits_per_sec(&self) -> std::option::Option<i64> {
        self.average_download_rate_limit_in_bits_per_sec
    }
}
impl std::fmt::Debug for UpdateBandwidthRateLimitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBandwidthRateLimitInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field(
            "average_upload_rate_limit_in_bits_per_sec",
            &self.average_upload_rate_limit_in_bits_per_sec,
        );
        formatter.field(
            "average_download_rate_limit_in_bits_per_sec",
            &self.average_download_rate_limit_in_bits_per_sec,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAutomaticTapeCreationPolicyInput {
    /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
    /// The rules determine when and how to automatically create new tapes.</p>
    pub automatic_tape_creation_rules:
        std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateAutomaticTapeCreationPolicyInput {
    /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
    /// The rules determine when and how to automatically create new tapes.</p>
    pub fn automatic_tape_creation_rules(
        &self,
    ) -> std::option::Option<&[crate::model::AutomaticTapeCreationRule]> {
        self.automatic_tape_creation_rules.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAutomaticTapeCreationPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAutomaticTapeCreationPolicyInput");
        formatter.field(
            "automatic_tape_creation_rules",
            &self.automatic_tape_creation_rules,
        );
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway to start.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl StartGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for StartGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartGatewayInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAvailabilityMonitorTestInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl StartAvailabilityMonitorTestInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for StartAvailabilityMonitorTestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAvailabilityMonitorTestInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway to shut
/// down.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShutdownGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ShutdownGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ShutdownGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShutdownGatewayInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>SetSMBGuestPasswordInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSmbGuestPasswordInput {
    /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated
    /// with.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The password that you want to set for your SMB server.</p>
    pub password: std::option::Option<std::string::String>,
}
impl SetSmbGuestPasswordInput {
    /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated
    /// with.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The password that you want to set for your SMB server.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for SetSmbGuestPasswordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSmbGuestPasswordInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p>SetLocalConsolePasswordInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetLocalConsolePasswordInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The password you want to set for your VM local console.</p>
    pub local_console_password: std::option::Option<std::string::String>,
}
impl SetLocalConsolePasswordInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The password you want to set for your VM local console.</p>
    pub fn local_console_password(&self) -> std::option::Option<&str> {
        self.local_console_password.as_deref()
    }
}
impl std::fmt::Debug for SetLocalConsolePasswordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetLocalConsolePasswordInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("local_console_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p>RetrieveTapeRecoveryPointInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveTapeRecoveryPointInput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the
    /// recovery point.</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl RetrieveTapeRecoveryPointInput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the
    /// recovery point.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for RetrieveTapeRecoveryPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveTapeRecoveryPointInput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>RetrieveTapeArchiveInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveTapeArchiveInput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual
    /// tape shelf (VTS).</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to.
    /// Use the <a>ListGateways</a> operation to return a list of gateways for your
    /// account and Amazon Web Services Region.</p>
    ///
    /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape
    /// gateway.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl RetrieveTapeArchiveInput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual
    /// tape shelf (VTS).</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to.
    /// Use the <a>ListGateways</a> operation to return a list of gateways for your
    /// account and Amazon Web Services Region.</p>
    ///
    /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape
    /// gateway.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for RetrieveTapeArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveTapeArchiveInput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetCacheInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ResetCacheInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ResetCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetCacheInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>RemoveTagsFromResourceInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed
    /// of a key-value pair.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsFromResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed
    /// of a key-value pair.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>RefreshCacheInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshCacheInput {
    /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is
    /// [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3
    /// bucket that the file share has access to is refreshed.</p>
    pub folder_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh
    /// includes folders that were in the cache the last time the gateway listed the folder's
    /// contents. If this value set to <code>true</code>, each folder that is listed in
    /// <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in
    /// <code>FolderList</code> are not refreshed. Only objects that are in folders listed
    /// directly under <code>FolderList</code> are found and used for the update. The default is
    /// <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub recursive: std::option::Option<bool>,
}
impl RefreshCacheInput {
    /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
    /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is
    /// [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3
    /// bucket that the file share has access to is refreshed.</p>
    pub fn folder_list(&self) -> std::option::Option<&[std::string::String]> {
        self.folder_list.as_deref()
    }
    /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh
    /// includes folders that were in the cache the last time the gateway listed the folder's
    /// contents. If this value set to <code>true</code>, each folder that is listed in
    /// <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in
    /// <code>FolderList</code> are not refreshed. Only objects that are in folders listed
    /// directly under <code>FolderList</code> are found and used for the update. The default is
    /// <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn recursive(&self) -> std::option::Option<bool> {
        self.recursive
    }
}
impl std::fmt::Debug for RefreshCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshCacheInput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("folder_list", &self.folder_list);
        formatter.field("recursive", &self.recursive);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyWhenUploadedInput {
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
}
impl NotifyWhenUploadedInput {
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
}
impl std::fmt::Debug for NotifyWhenUploadedInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyWhenUploadedInput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.finish()
    }
}

/// <p>A JSON object that contains one or more of the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>ListVolumesInput$Limit</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListVolumesInput$Marker</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVolumesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>A string that indicates the position at which to begin the returned list of volumes.
    /// Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specifies that the list of volumes returned be limited to the specified number of
    /// items.</p>
    pub limit: std::option::Option<i32>,
}
impl ListVolumesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>A string that indicates the position at which to begin the returned list of volumes.
    /// Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specifies that the list of volumes returned be limited to the specified number of
    /// items.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListVolumesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVolumesInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVolumeRecoveryPointsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ListVolumeRecoveryPointsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ListVolumeRecoveryPointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVolumeRecoveryPointsInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>ListVolumeInitiatorsInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVolumeInitiatorsInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes for the gateway.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl ListVolumeInitiatorsInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes for the gateway.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for ListVolumeInitiatorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVolumeInitiatorsInput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}

/// <p>A JSON object that contains one or more of the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>ListTapesInput$Limit</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListTapesInput$Marker</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListTapesInput$TapeARNs</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTapesInput {
    /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't
    /// specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
    pub tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A string that indicates the position at which to begin the returned list of
    /// tapes.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An optional number limit for the tapes in the list returned by this call.</p>
    pub limit: std::option::Option<i32>,
}
impl ListTapesInput {
    /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't
    /// specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
    pub fn tape_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.tape_ar_ns.as_deref()
    }
    /// <p>A string that indicates the position at which to begin the returned list of
    /// tapes.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An optional number limit for the tapes in the list returned by this call.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListTapesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTapesInput");
        formatter.field("tape_ar_ns", &self.tape_ar_ns);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTapePoolsInput {
    /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you
    /// don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
    pub pool_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A string that indicates the position at which to begin the returned list of tape
    /// pools.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
    pub limit: std::option::Option<i32>,
}
impl ListTapePoolsInput {
    /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you
    /// don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
    pub fn pool_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.pool_ar_ns.as_deref()
    }
    /// <p>A string that indicates the position at which to begin the returned list of tape
    /// pools.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListTapePoolsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTapePoolsInput");
        formatter.field("pool_ar_ns", &self.pool_ar_ns);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>ListTagsForResourceInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An opaque string that indicates the position at which to begin returning the list of
    /// tags.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specifies that the list of tags returned be limited to the specified number of
    /// items.</p>
    pub limit: std::option::Option<i32>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin returning the list of
    /// tags.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specifies that the list of tags returned be limited to the specified number of
    /// items.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLocalDisksInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ListLocalDisksInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ListLocalDisksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLocalDisksInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing zero or more of the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>ListGatewaysInput$Limit</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListGatewaysInput$Marker</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewaysInput {
    /// <p>An opaque string that indicates the position at which to begin the returned list of
    /// gateways.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specifies that the list of gateways returned be limited to the specified number of
    /// items.</p>
    pub limit: std::option::Option<i32>,
}
impl ListGatewaysInput {
    /// <p>An opaque string that indicates the position at which to begin the returned list of
    /// gateways.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specifies that the list of gateways returned be limited to the specified number of
    /// items.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListGatewaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewaysInput");
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFileSystemAssociationsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of file system associations to return in the response. If present,
    /// <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
    pub limit: std::option::Option<i32>,
    /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code>
    /// operation. If present, <code>Marker</code> specifies where to continue the list from after
    /// a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListFileSystemAssociationsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The maximum number of file system associations to return in the response. If present,
    /// <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code>
    /// operation. If present, <code>Marker</code> specifies where to continue the list from after
    /// a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListFileSystemAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFileSystemAssociationsInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>ListFileShareInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFileSharesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
    /// this field is not present, all file shares under your account are listed.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of file shares to return in the response. The value must be an
    /// integer with a value greater than zero. Optional.</p>
    pub limit: std::option::Option<i32>,
    /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present,
    /// <code>Marker</code> specifies where to continue the list from after a previous call to
    /// ListFileShares. Optional.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListFileSharesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
    /// this field is not present, all file shares under your account are listed.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The maximum number of file shares to return in the response. The value must be an
    /// integer with a value greater than zero. Optional.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present,
    /// <code>Marker</code> specifies where to continue the list from after a previous call to
    /// ListFileShares. Optional.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListFileSharesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFileSharesInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAutomaticTapeCreationPoliciesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl ListAutomaticTapeCreationPoliciesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for ListAutomaticTapeCreationPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAutomaticTapeCreationPoliciesInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>JoinDomainInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JoinDomainInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The name of the domain that you want the gateway to join.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users,
    /// groups, computers, and other OUs and this parameter specifies the OU that the gateway will
    /// join within the AD domain.</p>
    pub organizational_unit: std::option::Option<std::string::String>,
    /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
    /// to specify the port number include it after the colon (“:”). For example,
    /// <code>mydc.mydomain.com:389</code>.</p>
    pub domain_controllers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must
    /// complete. The default is 20 seconds.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory
    /// domain. The domain user account should be enabled to join computers to the domain. For
    /// example, you can use the domain administrator account or an account with delegated
    /// permissions to join computers to the domain.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Sets the password of the user who has permission to add the gateway to the Active
    /// Directory domain.</p>
    pub password: std::option::Option<std::string::String>,
}
impl JoinDomainInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The name of the domain that you want the gateway to join.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users,
    /// groups, computers, and other OUs and this parameter specifies the OU that the gateway will
    /// join within the AD domain.</p>
    pub fn organizational_unit(&self) -> std::option::Option<&str> {
        self.organizational_unit.as_deref()
    }
    /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
    /// to specify the port number include it after the colon (“:”). For example,
    /// <code>mydc.mydomain.com:389</code>.</p>
    pub fn domain_controllers(&self) -> std::option::Option<&[std::string::String]> {
        self.domain_controllers.as_deref()
    }
    /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must
    /// complete. The default is 20 seconds.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.timeout_in_seconds
    }
    /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory
    /// domain. The domain user account should be enabled to join computers to the domain. For
    /// example, you can use the domain administrator account or an account with delegated
    /// permissions to join computers to the domain.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Sets the password of the user who has permission to add the gateway to the Active
    /// Directory domain.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for JoinDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JoinDomainInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("organizational_unit", &self.organizational_unit);
        formatter.field("domain_controllers", &self.domain_controllers);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("user_name", &self.user_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFileSystemInput {
    /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
    pub file_system_association_arn: std::option::Option<std::string::String>,
    /// <p>If this value is set to true, the operation disassociates an Amazon FSx file
    /// system immediately. It ends all data uploads to the file system, and the file system
    /// association enters the <code>FORCE_DELETING</code> status. If this value is set to false,
    /// the Amazon FSx file system does not disassociate until all data is uploaded.</p>
    pub force_delete: bool,
}
impl DisassociateFileSystemInput {
    /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
    pub fn file_system_association_arn(&self) -> std::option::Option<&str> {
        self.file_system_association_arn.as_deref()
    }
    /// <p>If this value is set to true, the operation disassociates an Amazon FSx file
    /// system immediately. It ends all data uploads to the file system, and the file system
    /// association enters the <code>FORCE_DELETING</code> status. If this value is set to false,
    /// the Amazon FSx file system does not disassociate until all data is uploaded.</p>
    pub fn force_delete(&self) -> bool {
        self.force_delete
    }
}
impl std::fmt::Debug for DisassociateFileSystemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFileSystemInput");
        formatter.field(
            "file_system_association_arn",
            &self.file_system_association_arn,
        );
        formatter.field("force_delete", &self.force_delete);
        formatter.finish()
    }
}

/// <p>DisableGatewayInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DisableGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DisableGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableGatewayInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>AttachVolumeInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachVolumeInput {
    /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume
    /// and detach the volume. The default is <code>false</code>. If this value is set to
    /// <code>false</code>, you must manually disconnect the iSCSI connection from the target
    /// volume.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub force_detach: std::option::Option<bool>,
}
impl DetachVolumeInput {
    /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume
    /// and detach the volume. The default is <code>false</code>. If this value is set to
    /// <code>false</code>, you must manually disconnect the iSCSI connection from the target
    /// volume.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn force_detach(&self) -> std::option::Option<bool> {
        self.force_detach
    }
}
impl std::fmt::Debug for DetachVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachVolumeInput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("force_detach", &self.force_detach);
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkingStorageInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeWorkingStorageInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkingStorageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkingStorageInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>DescribeVTLDevicesInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVtlDevicesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a
    /// VTL device.</p>
    ///
    /// <note>
    /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are
    /// specified, the result will contain all devices on the specified gateway.</p>
    /// </note>
    pub vtl_device_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An opaque string that indicates the position at which to begin describing the VTL
    /// devices.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specifies that the number of VTL devices described be limited to the specified
    /// number.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeVtlDevicesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a
    /// VTL device.</p>
    ///
    /// <note>
    /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are
    /// specified, the result will contain all devices on the specified gateway.</p>
    /// </note>
    pub fn vtl_device_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.vtl_device_ar_ns.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin describing the VTL
    /// devices.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specifies that the number of VTL devices described be limited to the specified
    /// number.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeVtlDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVtlDevicesInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("vtl_device_ar_ns", &self.vtl_device_ar_ns);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUploadBufferInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeUploadBufferInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeUploadBufferInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUploadBufferInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>DescribeTapesInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTapesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
    /// tapes you want to describe. If this parameter is not specified, Tape gateway returns a
    /// description of all virtual tapes associated with the specified gateway.</p>
    pub tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker
    /// indicates which page of results to retrieve.</p>
    ///
    /// <p>If not specified, the first page of results is retrieved.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specifies that the number of virtual tapes described be limited to the specified
    /// number.</p>
    ///
    /// <note>
    /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
    /// </note>
    pub limit: std::option::Option<i32>,
}
impl DescribeTapesInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
    /// tapes you want to describe. If this parameter is not specified, Tape gateway returns a
    /// description of all virtual tapes associated with the specified gateway.</p>
    pub fn tape_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.tape_ar_ns.as_deref()
    }
    /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker
    /// indicates which page of results to retrieve.</p>
    ///
    /// <p>If not specified, the first page of results is retrieved.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specifies that the number of virtual tapes described be limited to the specified
    /// number.</p>
    ///
    /// <note>
    /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
    /// </note>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeTapesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTapesInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("tape_ar_ns", &self.tape_ar_ns);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>DescribeTapeRecoveryPointsInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTapeRecoveryPointsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>An opaque string that indicates the position at which to begin describing the virtual
    /// tape recovery points.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specifies that the number of virtual tape recovery points that are described be limited
    /// to the specified number.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeTapeRecoveryPointsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin describing the virtual
    /// tape recovery points.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specifies that the number of virtual tape recovery points that are described be limited
    /// to the specified number.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeTapeRecoveryPointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTapeRecoveryPointsInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>DescribeTapeArchivesInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTapeArchivesInput {
    /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
    /// tapes you want to describe.</p>
    pub tape_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An opaque string that indicates the position at which to begin describing virtual
    /// tapes.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specifies that the number of virtual tapes described be limited to the specified
    /// number.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeTapeArchivesInput {
    /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
    /// tapes you want to describe.</p>
    pub fn tape_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.tape_ar_ns.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin describing virtual
    /// tapes.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specifies that the number of virtual tapes described be limited to the specified
    /// number.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeTapeArchivesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTapeArchivesInput");
        formatter.field("tape_ar_ns", &self.tape_ar_ns);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>A JSON object containing a list of <a>DescribeStorediSCSIVolumesInput$VolumeARNs</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStorediScsiVolumesInput {
    /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
    /// stored volume. All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
    pub volume_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeStorediScsiVolumesInput {
    /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
    /// stored volume. All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
    pub fn volume_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.volume_ar_ns.as_deref()
    }
}
impl std::fmt::Debug for DescribeStorediScsiVolumesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStorediScsiVolumesInput");
        formatter.field("volume_ar_ns", &self.volume_ar_ns);
        formatter.finish()
    }
}

/// <p>A JSON object containing the <a>DescribeSnapshotScheduleInput$VolumeARN</a>
/// of the volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl DescribeSnapshotScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeSnapshotScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotScheduleInput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSmbSettingsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeSmbSettingsInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeSmbSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSmbSettingsInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>DescribeSMBFileSharesInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSmbFileSharesInput {
    /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
    /// described.</p>
    pub file_share_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeSmbFileSharesInput {
    /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
    /// described.</p>
    pub fn file_share_arn_list(&self) -> std::option::Option<&[std::string::String]> {
        self.file_share_arn_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeSmbFileSharesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSmbFileSharesInput");
        formatter.field("file_share_arn_list", &self.file_share_arn_list);
        formatter.finish()
    }
}

/// <p>DescribeNFSFileSharesInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNfsFileSharesInput {
    /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
    /// described.</p>
    pub file_share_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeNfsFileSharesInput {
    /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
    /// described.</p>
    pub fn file_share_arn_list(&self) -> std::option::Option<&[std::string::String]> {
        self.file_share_arn_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeNfsFileSharesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNfsFileSharesInput");
        formatter.field("file_share_arn_list", &self.file_share_arn_list);
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceStartTimeInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceStartTimeInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceStartTimeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceStartTimeInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing the ID of the gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayInformationInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeGatewayInformationInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeGatewayInformationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayInformationInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemAssociationsInput {
    /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be
    /// described.</p>
    pub file_system_association_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeFileSystemAssociationsInput {
    /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be
    /// described.</p>
    pub fn file_system_association_arn_list(&self) -> std::option::Option<&[std::string::String]> {
        self.file_system_association_arn_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemAssociationsInput");
        formatter.field(
            "file_system_association_arn_list",
            &self.file_system_association_arn_list,
        );
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume
/// target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChapCredentialsInput {
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
    /// specified VolumeARN.</p>
    pub target_arn: std::option::Option<std::string::String>,
}
impl DescribeChapCredentialsInput {
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
    /// specified VolumeARN.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeChapCredentialsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChapCredentialsInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCachediScsiVolumesInput {
    /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
    /// cached volume. All of the specified cached volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
    pub volume_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeCachediScsiVolumesInput {
    /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
    /// cached volume. All of the specified cached volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
    pub fn volume_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.volume_ar_ns.as_deref()
    }
}
impl std::fmt::Debug for DescribeCachediScsiVolumesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCachediScsiVolumesInput");
        formatter.field("volume_ar_ns", &self.volume_ar_ns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeCacheInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBandwidthRateLimitScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeBandwidthRateLimitScheduleInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeBandwidthRateLimitScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBandwidthRateLimitScheduleInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBandwidthRateLimitInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeBandwidthRateLimitInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeBandwidthRateLimitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBandwidthRateLimitInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAvailabilityMonitorTestInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DescribeAvailabilityMonitorTestInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAvailabilityMonitorTestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAvailabilityMonitorTestInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing the <a>DeleteVolumeInput$VolumeARN</a> to
/// delete.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVolumeInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl DeleteVolumeInput {
    /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
    /// operation to return a list of gateway volumes.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVolumeInput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTapePoolInput {
    /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
    pub pool_arn: std::option::Option<std::string::String>,
}
impl DeleteTapePoolInput {
    /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteTapePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTapePoolInput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.finish()
    }
}

/// <p>DeleteTapeArchiveInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTapeArchiveInput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
    /// (VTS).</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
    /// tape retention lock. Only archived tapes with tape retention lock set to
    /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
    /// <code>compliance</code> can't be deleted.</p>
    pub bypass_governance_retention: bool,
}
impl DeleteTapeArchiveInput {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
    /// (VTS).</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
    /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
    /// tape retention lock. Only archived tapes with tape retention lock set to
    /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
    /// <code>compliance</code> can't be deleted.</p>
    pub fn bypass_governance_retention(&self) -> bool {
        self.bypass_governance_retention
    }
}
impl std::fmt::Debug for DeleteTapeArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTapeArchiveInput");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field(
            "bypass_governance_retention",
            &self.bypass_governance_retention,
        );
        formatter.finish()
    }
}

/// <p>DeleteTapeInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTapeInput {
    /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
    /// associated with. Use the <a>ListGateways</a> operation to return a list of
    /// gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
    /// tape retention lock. Only archived tapes with tape retention lock set to
    /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
    /// <code>compliance</code> can't be deleted.</p>
    pub bypass_governance_retention: bool,
}
impl DeleteTapeInput {
    /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
    /// associated with. Use the <a>ListGateways</a> operation to return a list of
    /// gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
    pub fn tape_arn(&self) -> std::option::Option<&str> {
        self.tape_arn.as_deref()
    }
    /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
    /// tape retention lock. Only archived tapes with tape retention lock set to
    /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
    /// <code>compliance</code> can't be deleted.</p>
    pub fn bypass_governance_retention(&self) -> bool {
        self.bypass_governance_retention
    }
}
impl std::fmt::Debug for DeleteTapeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTapeInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field(
            "bypass_governance_retention",
            &self.bypass_governance_retention,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotScheduleInput {
    /// <p>The volume which snapshot schedule to delete.</p>
    pub volume_arn: std::option::Option<std::string::String>,
}
impl DeleteSnapshotScheduleInput {
    /// <p>The volume which snapshot schedule to delete.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSnapshotScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotScheduleInput");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.finish()
    }
}

/// <p>A JSON object containing the ID of the gateway to delete.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DeleteGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>DeleteFileShareInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileShareInput {
    /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>If this value is set to <code>true</code>, the operation deletes a file share
    /// immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is
    /// not deleted until all data is uploaded to Amazon Web Services. This process aborts the data
    /// upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub force_delete: bool,
}
impl DeleteFileShareInput {
    /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
    pub fn file_share_arn(&self) -> std::option::Option<&str> {
        self.file_share_arn.as_deref()
    }
    /// <p>If this value is set to <code>true</code>, the operation deletes a file share
    /// immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is
    /// not deleted until all data is uploaded to Amazon Web Services. This process aborts the data
    /// upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn force_delete(&self) -> bool {
        self.force_delete
    }
}
impl std::fmt::Debug for DeleteFileShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileShareInput");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("force_delete", &self.force_delete);
        formatter.finish()
    }
}

/// <p>A JSON object containing one or more of the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>DeleteChapCredentialsInput$InitiatorName</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>DeleteChapCredentialsInput$TargetARN</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChapCredentialsInput {
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
    /// specified VolumeARN.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The iSCSI initiator that connects to the target.</p>
    pub initiator_name: std::option::Option<std::string::String>,
}
impl DeleteChapCredentialsInput {
    /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
    /// specified VolumeARN.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The iSCSI initiator that connects to the target.</p>
    pub fn initiator_name(&self) -> std::option::Option<&str> {
        self.initiator_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteChapCredentialsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChapCredentialsInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("initiator_name", &self.initiator_name);
        formatter.finish()
    }
}

/// <p>A JSON object containing the following fields:</p>
///
/// <ul>
/// <li>
/// <p>
/// <a>DeleteBandwidthRateLimitInput$BandwidthType</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBandwidthRateLimitInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to
    /// delete.</p>
    ///
    /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code>
    /// </p>
    pub bandwidth_type: std::option::Option<std::string::String>,
}
impl DeleteBandwidthRateLimitInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to
    /// delete.</p>
    ///
    /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code>
    /// </p>
    pub fn bandwidth_type(&self) -> std::option::Option<&str> {
        self.bandwidth_type.as_deref()
    }
}
impl std::fmt::Debug for DeleteBandwidthRateLimitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBandwidthRateLimitInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("bandwidth_type", &self.bandwidth_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAutomaticTapeCreationPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DeleteAutomaticTapeCreationPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAutomaticTapeCreationPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAutomaticTapeCreationPolicyInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

/// <p>CreateTapeWithBarcodeInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTapeWithBarcodeInput {
    /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
    /// virtual tape with. Use the <a>ListGateways</a> operation to return a list of
    /// gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the virtual tape that you want to create.</p>
    ///
    /// <note>
    /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
    /// </note>
    pub tape_size_in_bytes: std::option::Option<i64>,
    /// <p>The barcode that you want to assign to the tape.</p>
    ///
    /// <note>
    /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been
    /// deleted.</p>
    /// </note>
    pub tape_barcode: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub kms_encrypted: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
    /// pool is archived in the S3 storage class that is associated with the pool. When you use
    /// your backup application to eject the tape, the tape is archived directly into the storage
    /// class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
    /// write-once-read-many (WORM) tape.</p>
    pub worm: bool,
    /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
    /// tag is a key-value pair.</p>
    ///
    /// <note>
    /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
    /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
    /// of a tag's key is 128 characters, and the maximum length for a tag's value is
    /// 256.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateTapeWithBarcodeInput {
    /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
    /// virtual tape with. Use the <a>ListGateways</a> operation to return a list of
    /// gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The size, in bytes, of the virtual tape that you want to create.</p>
    ///
    /// <note>
    /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
    /// </note>
    pub fn tape_size_in_bytes(&self) -> std::option::Option<i64> {
        self.tape_size_in_bytes
    }
    /// <p>The barcode that you want to assign to the tape.</p>
    ///
    /// <note>
    /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been
    /// deleted.</p>
    /// </note>
    pub fn tape_barcode(&self) -> std::option::Option<&str> {
        self.tape_barcode.as_deref()
    }
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn kms_encrypted(&self) -> std::option::Option<bool> {
        self.kms_encrypted
    }
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub fn kms_key(&self) -> std::option::Option<&str> {
        self.kms_key.as_deref()
    }
    /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
    /// pool is archived in the S3 storage class that is associated with the pool. When you use
    /// your backup application to eject the tape, the tape is archived directly into the storage
    /// class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
    /// write-once-read-many (WORM) tape.</p>
    pub fn worm(&self) -> bool {
        self.worm
    }
    /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
    /// tag is a key-value pair.</p>
    ///
    /// <note>
    /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
    /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
    /// of a tag's key is 128 characters, and the maximum length for a tag's value is
    /// 256.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateTapeWithBarcodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTapeWithBarcodeInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("tape_size_in_bytes", &self.tape_size_in_bytes);
        formatter.field("tape_barcode", &self.tape_barcode);
        formatter.field("kms_encrypted", &self.kms_encrypted);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("worm", &self.worm);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>CreateTapesInput</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTapesInput {
    /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
    /// virtual tapes with. Use the <a>ListGateways</a> operation to return a list of
    /// gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the virtual tapes that you want to create.</p>
    ///
    /// <note>
    /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
    /// </note>
    pub tape_size_in_bytes: std::option::Option<i64>,
    /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
    /// same <code>ClientToken</code> you specified in the initial request.</p>
    ///
    /// <note>
    /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple
    /// times.</p>
    /// </note>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The number of virtual tapes that you want to create.</p>
    pub num_tapes_to_create: std::option::Option<i32>,
    /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This
    /// prefix makes the barcode unique.</p>
    ///
    /// <note>
    /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
    /// from A to Z.</p>
    /// </note>
    pub tape_barcode_prefix: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub kms_encrypted: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
    /// pool is archived in the S3 storage class that is associated with the pool. When you use
    /// your backup application to eject the tape, the tape is archived directly into the storage
    /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
    /// write-once-read-many (WORM) tape.</p>
    pub worm: bool,
    /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
    /// pair.</p>
    ///
    /// <note>
    /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
    /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
    /// of a tag's key is 128 characters, and the maximum length for a tag's value is
    /// 256.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateTapesInput {
    /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
    /// virtual tapes with. Use the <a>ListGateways</a> operation to return a list of
    /// gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The size, in bytes, of the virtual tapes that you want to create.</p>
    ///
    /// <note>
    /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
    /// </note>
    pub fn tape_size_in_bytes(&self) -> std::option::Option<i64> {
        self.tape_size_in_bytes
    }
    /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
    /// same <code>ClientToken</code> you specified in the initial request.</p>
    ///
    /// <note>
    /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple
    /// times.</p>
    /// </note>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The number of virtual tapes that you want to create.</p>
    pub fn num_tapes_to_create(&self) -> std::option::Option<i32> {
        self.num_tapes_to_create
    }
    /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This
    /// prefix makes the barcode unique.</p>
    ///
    /// <note>
    /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
    /// from A to Z.</p>
    /// </note>
    pub fn tape_barcode_prefix(&self) -> std::option::Option<&str> {
        self.tape_barcode_prefix.as_deref()
    }
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn kms_encrypted(&self) -> std::option::Option<bool> {
        self.kms_encrypted
    }
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub fn kms_key(&self) -> std::option::Option<&str> {
        self.kms_key.as_deref()
    }
    /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
    /// pool is archived in the S3 storage class that is associated with the pool. When you use
    /// your backup application to eject the tape, the tape is archived directly into the storage
    /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
    /// write-once-read-many (WORM) tape.</p>
    pub fn worm(&self) -> bool {
        self.worm
    }
    /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
    /// pair.</p>
    ///
    /// <note>
    /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
    /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
    /// of a tag's key is 128 characters, and the maximum length for a tag's value is
    /// 256.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateTapesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTapesInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("tape_size_in_bytes", &self.tape_size_in_bytes);
        formatter.field("client_token", &self.client_token);
        formatter.field("num_tapes_to_create", &self.num_tapes_to_create);
        formatter.field("tape_barcode_prefix", &self.tape_barcode_prefix);
        formatter.field("kms_encrypted", &self.kms_encrypted);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("worm", &self.worm);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation miss