// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_activate_gateway_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ActivateGatewayOutput, crate::error::ActivateGatewayError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ActivateGatewayError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ActivateGatewayError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ActivateGatewayError {
            meta: generic,
            kind: crate::error::ActivateGatewayErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ActivateGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ActivateGatewayError {
            meta: generic,
            kind: crate::error::ActivateGatewayErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ActivateGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ActivateGatewayError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_activate_gateway_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ActivateGatewayOutput, crate::error::ActivateGatewayError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::activate_gateway_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_activate_gateway(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ActivateGatewayError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_cache_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddCacheOutput, crate::error::AddCacheError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddCacheError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddCacheError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::AddCacheError {
            meta: generic,
            kind: crate::error::AddCacheErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AddCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::AddCacheError {
            meta: generic,
            kind: crate::error::AddCacheErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddCacheError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_cache_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddCacheOutput, crate::error::AddCacheError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_cache_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_cache(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddCacheError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsToResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsToResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsToResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_to_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_tags_to_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddTagsToResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_upload_buffer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddUploadBufferOutput, crate::error::AddUploadBufferError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddUploadBufferError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddUploadBufferError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::AddUploadBufferError {
            meta: generic,
            kind: crate::error::AddUploadBufferErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AddUploadBufferError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::AddUploadBufferError {
            meta: generic,
            kind: crate::error::AddUploadBufferErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddUploadBufferError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddUploadBufferError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_upload_buffer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddUploadBufferOutput, crate::error::AddUploadBufferError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_upload_buffer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_upload_buffer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddUploadBufferError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_working_storage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddWorkingStorageOutput, crate::error::AddWorkingStorageError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddWorkingStorageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddWorkingStorageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::AddWorkingStorageError {
            meta: generic,
            kind: crate::error::AddWorkingStorageErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AddWorkingStorageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::AddWorkingStorageError {
            meta: generic,
            kind: crate::error::AddWorkingStorageErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddWorkingStorageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddWorkingStorageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_working_storage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddWorkingStorageOutput, crate::error::AddWorkingStorageError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_working_storage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_working_storage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddWorkingStorageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_assign_tape_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssignTapePoolOutput, crate::error::AssignTapePoolError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssignTapePoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssignTapePoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::AssignTapePoolError {
            meta: generic,
            kind: crate::error::AssignTapePoolErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AssignTapePoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::AssignTapePoolError {
            meta: generic,
            kind: crate::error::AssignTapePoolErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssignTapePoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssignTapePoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_assign_tape_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssignTapePoolOutput, crate::error::AssignTapePoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::assign_tape_pool_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_assign_tape_pool(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssignTapePoolError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateFileSystemOutput,
    crate::error::AssociateFileSystemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateFileSystemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::AssociateFileSystemError {
            meta: generic,
            kind: crate::error::AssociateFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::AssociateFileSystemError {
            meta: generic,
            kind: crate::error::AssociateFileSystemErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateFileSystemOutput,
    crate::error::AssociateFileSystemError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_file_system_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_file_system(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateFileSystemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachVolumeOutput, crate::error::AttachVolumeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachVolumeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::AttachVolumeError {
            meta: generic,
            kind: crate::error::AttachVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AttachVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::AttachVolumeError {
            meta: generic,
            kind: crate::error::AttachVolumeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachVolumeOutput, crate::error::AttachVolumeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_attach_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AttachVolumeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_archival_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelArchivalOutput, crate::error::CancelArchivalError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelArchivalError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelArchivalError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CancelArchivalError {
            meta: generic,
            kind: crate::error::CancelArchivalErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CancelArchivalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CancelArchivalError {
            meta: generic,
            kind: crate::error::CancelArchivalErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelArchivalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelArchivalError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_archival_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelArchivalOutput, crate::error::CancelArchivalError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_archival_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_archival(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelArchivalError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_retrieval_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelRetrievalOutput, crate::error::CancelRetrievalError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelRetrievalError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelRetrievalError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CancelRetrievalError {
            meta: generic,
            kind: crate::error::CancelRetrievalErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CancelRetrievalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CancelRetrievalError {
            meta: generic,
            kind: crate::error::CancelRetrievalErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelRetrievalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelRetrievalError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_retrieval_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelRetrievalOutput, crate::error::CancelRetrievalError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_retrieval_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_retrieval(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelRetrievalError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cachedi_scsi_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCachediScsiVolumeOutput,
    crate::error::CreateCachediSCSIVolumeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCachediSCSIVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCachediSCSIVolumeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateCachediSCSIVolumeError {
            meta: generic,
            kind: crate::error::CreateCachediSCSIVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCachediSCSIVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateCachediSCSIVolumeError {
            meta: generic,
            kind: crate::error::CreateCachediSCSIVolumeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCachediSCSIVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCachediSCSIVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cachedi_scsi_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCachediScsiVolumeOutput,
    crate::error::CreateCachediSCSIVolumeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cachedi_scsi_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_cachedi_scsi_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCachediSCSIVolumeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_nfs_file_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNfsFileShareOutput,
    crate::error::CreateNFSFileShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateNFSFileShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateNFSFileShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateNFSFileShareError {
            meta: generic,
            kind: crate::error::CreateNFSFileShareErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNFSFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateNFSFileShareError {
            meta: generic,
            kind: crate::error::CreateNFSFileShareErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNFSFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateNFSFileShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_nfs_file_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNfsFileShareOutput,
    crate::error::CreateNFSFileShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_nfs_file_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_nfs_file_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateNFSFileShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_smb_file_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSmbFileShareOutput,
    crate::error::CreateSMBFileShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSMBFileShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSMBFileShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateSMBFileShareError {
            meta: generic,
            kind: crate::error::CreateSMBFileShareErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSMBFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateSMBFileShareError {
            meta: generic,
            kind: crate::error::CreateSMBFileShareErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSMBFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSMBFileShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_smb_file_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSmbFileShareOutput,
    crate::error::CreateSMBFileShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_smb_file_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_smb_file_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSMBFileShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableError" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::ServiceUnavailableError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_unavailable_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_from_volume_recovery_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSnapshotFromVolumeRecoveryPointOutput,
    crate::error::CreateSnapshotFromVolumeRecoveryPointError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSnapshotFromVolumeRecoveryPointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::CreateSnapshotFromVolumeRecoveryPointError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateSnapshotFromVolumeRecoveryPointError { meta: generic, kind: crate::error::CreateSnapshotFromVolumeRecoveryPointErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotFromVolumeRecoveryPointError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::CreateSnapshotFromVolumeRecoveryPointError { meta: generic, kind: crate::error::CreateSnapshotFromVolumeRecoveryPointErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotFromVolumeRecoveryPointError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceUnavailableError" => crate::error::CreateSnapshotFromVolumeRecoveryPointError { meta: generic, kind: crate::error::CreateSnapshotFromVolumeRecoveryPointErrorKind::ServiceUnavailableError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_unavailable_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotFromVolumeRecoveryPointError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateSnapshotFromVolumeRecoveryPointError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_from_volume_recovery_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSnapshotFromVolumeRecoveryPointOutput,
    crate::error::CreateSnapshotFromVolumeRecoveryPointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_snapshot_from_volume_recovery_point_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_snapshot_from_volume_recovery_point(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotFromVolumeRecoveryPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_storedi_scsi_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStorediScsiVolumeOutput,
    crate::error::CreateStorediSCSIVolumeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStorediSCSIVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateStorediSCSIVolumeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateStorediSCSIVolumeError {
            meta: generic,
            kind: crate::error::CreateStorediSCSIVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorediSCSIVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateStorediSCSIVolumeError {
            meta: generic,
            kind: crate::error::CreateStorediSCSIVolumeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorediSCSIVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStorediSCSIVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_storedi_scsi_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStorediScsiVolumeOutput,
    crate::error::CreateStorediSCSIVolumeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_storedi_scsi_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_storedi_scsi_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStorediSCSIVolumeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tape_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTapePoolOutput, crate::error::CreateTapePoolError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTapePoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTapePoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateTapePoolError {
            meta: generic,
            kind: crate::error::CreateTapePoolErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTapePoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateTapePoolError {
            meta: generic,
            kind: crate::error::CreateTapePoolErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTapePoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTapePoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tape_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTapePoolOutput, crate::error::CreateTapePoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tape_pool_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_tape_pool(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTapePoolError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tapes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTapesOutput, crate::error::CreateTapesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTapesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTapesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateTapesError {
            meta: generic,
            kind: crate::error::CreateTapesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTapesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateTapesError {
            meta: generic,
            kind: crate::error::CreateTapesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTapesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTapesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tapes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTapesOutput, crate::error::CreateTapesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tapes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_tapes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTapesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tape_with_barcode_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateTapeWithBarcodeOutput,
    crate::error::CreateTapeWithBarcodeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTapeWithBarcodeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTapeWithBarcodeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateTapeWithBarcodeError {
            meta: generic,
            kind: crate::error::CreateTapeWithBarcodeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTapeWithBarcodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::CreateTapeWithBarcodeError {
            meta: generic,
            kind: crate::error::CreateTapeWithBarcodeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTapeWithBarcodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTapeWithBarcodeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tape_with_barcode_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateTapeWithBarcodeOutput,
    crate::error::CreateTapeWithBarcodeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tape_with_barcode_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_tape_with_barcode(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTapeWithBarcodeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_automatic_tape_creation_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAutomaticTapeCreationPolicyOutput,
    crate::error::DeleteAutomaticTapeCreationPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAutomaticTapeCreationPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAutomaticTapeCreationPolicyError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteAutomaticTapeCreationPolicyError { meta: generic, kind: crate::error::DeleteAutomaticTapeCreationPolicyErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutomaticTapeCreationPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::DeleteAutomaticTapeCreationPolicyError { meta: generic, kind: crate::error::DeleteAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutomaticTapeCreationPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteAutomaticTapeCreationPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_automatic_tape_creation_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAutomaticTapeCreationPolicyOutput,
    crate::error::DeleteAutomaticTapeCreationPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_automatic_tape_creation_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_automatic_tape_creation_policy(response.body().as_ref(), output).map_err(crate::error::DeleteAutomaticTapeCreationPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bandwidth_rate_limit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBandwidthRateLimitOutput,
    crate::error::DeleteBandwidthRateLimitError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBandwidthRateLimitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteBandwidthRateLimitError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteBandwidthRateLimitError {
            meta: generic,
            kind: crate::error::DeleteBandwidthRateLimitErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBandwidthRateLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteBandwidthRateLimitError {
            meta: generic,
            kind: crate::error::DeleteBandwidthRateLimitErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBandwidthRateLimitError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteBandwidthRateLimitError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bandwidth_rate_limit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBandwidthRateLimitOutput,
    crate::error::DeleteBandwidthRateLimitError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bandwidth_rate_limit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_bandwidth_rate_limit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBandwidthRateLimitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_chap_credentials_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChapCredentialsOutput,
    crate::error::DeleteChapCredentialsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChapCredentialsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteChapCredentialsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteChapCredentialsError {
            meta: generic,
            kind: crate::error::DeleteChapCredentialsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChapCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteChapCredentialsError {
            meta: generic,
            kind: crate::error::DeleteChapCredentialsErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChapCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChapCredentialsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_chap_credentials_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChapCredentialsOutput,
    crate::error::DeleteChapCredentialsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_chap_credentials_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_chap_credentials(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteChapCredentialsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFileShareOutput, crate::error::DeleteFileShareError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFileShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFileShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteFileShareError {
            meta: generic,
            kind: crate::error::DeleteFileShareErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteFileShareError {
            meta: generic,
            kind: crate::error::DeleteFileShareErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFileShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFileShareOutput, crate::error::DeleteFileShareError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_file_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_file_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteFileShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_gateway_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGatewayOutput, crate::error::DeleteGatewayError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGatewayError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteGatewayError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteGatewayError {
            meta: generic,
            kind: crate::error::DeleteGatewayErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteGatewayError {
            meta: generic,
            kind: crate::error::DeleteGatewayErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteGatewayError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_gateway_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGatewayOutput, crate::error::DeleteGatewayError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_gateway_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_gateway(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteGatewayError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSnapshotScheduleOutput,
    crate::error::DeleteSnapshotScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSnapshotScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSnapshotScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteSnapshotScheduleError {
            meta: generic,
            kind: crate::error::DeleteSnapshotScheduleErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteSnapshotScheduleError {
            meta: generic,
            kind: crate::error::DeleteSnapshotScheduleErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSnapshotScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSnapshotScheduleOutput,
    crate::error::DeleteSnapshotScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_snapshot_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_snapshot_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSnapshotScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tape_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTapeOutput, crate::error::DeleteTapeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTapeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTapeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteTapeError {
            meta: generic,
            kind: crate::error::DeleteTapeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTapeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteTapeError {
            meta: generic,
            kind: crate::error::DeleteTapeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTapeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTapeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tape_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTapeOutput, crate::error::DeleteTapeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tape_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_tape(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTapeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tape_archive_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTapeArchiveOutput, crate::error::DeleteTapeArchiveError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTapeArchiveError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTapeArchiveError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteTapeArchiveError {
            meta: generic,
            kind: crate::error::DeleteTapeArchiveErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTapeArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteTapeArchiveError {
            meta: generic,
            kind: crate::error::DeleteTapeArchiveErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTapeArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTapeArchiveError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tape_archive_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTapeArchiveOutput, crate::error::DeleteTapeArchiveError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tape_archive_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_tape_archive(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTapeArchiveError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tape_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTapePoolOutput, crate::error::DeleteTapePoolError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTapePoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTapePoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteTapePoolError {
            meta: generic,
            kind: crate::error::DeleteTapePoolErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTapePoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteTapePoolError {
            meta: generic,
            kind: crate::error::DeleteTapePoolErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTapePoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTapePoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tape_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTapePoolOutput, crate::error::DeleteTapePoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tape_pool_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_tape_pool(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTapePoolError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVolumeOutput, crate::error::DeleteVolumeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteVolumeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteVolumeError {
            meta: generic,
            kind: crate::error::DeleteVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DeleteVolumeError {
            meta: generic,
            kind: crate::error::DeleteVolumeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVolumeOutput, crate::error::DeleteVolumeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteVolumeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_availability_monitor_test_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAvailabilityMonitorTestOutput,
    crate::error::DescribeAvailabilityMonitorTestError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAvailabilityMonitorTestError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAvailabilityMonitorTestError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeAvailabilityMonitorTestError { meta: generic, kind: crate::error::DescribeAvailabilityMonitorTestErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAvailabilityMonitorTestError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::DescribeAvailabilityMonitorTestError { meta: generic, kind: crate::error::DescribeAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAvailabilityMonitorTestError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeAvailabilityMonitorTestError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_availability_monitor_test_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAvailabilityMonitorTestOutput,
    crate::error::DescribeAvailabilityMonitorTestError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_availability_monitor_test_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_availability_monitor_test(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeAvailabilityMonitorTestError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_bandwidth_rate_limit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBandwidthRateLimitOutput,
    crate::error::DescribeBandwidthRateLimitError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBandwidthRateLimitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeBandwidthRateLimitError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeBandwidthRateLimitError {
            meta: generic,
            kind: crate::error::DescribeBandwidthRateLimitErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBandwidthRateLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeBandwidthRateLimitError {
            meta: generic,
            kind: crate::error::DescribeBandwidthRateLimitErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBandwidthRateLimitError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeBandwidthRateLimitError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_bandwidth_rate_limit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBandwidthRateLimitOutput,
    crate::error::DescribeBandwidthRateLimitError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_bandwidth_rate_limit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_bandwidth_rate_limit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBandwidthRateLimitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_bandwidth_rate_limit_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBandwidthRateLimitScheduleOutput,
    crate::error::DescribeBandwidthRateLimitScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBandwidthRateLimitScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeBandwidthRateLimitScheduleError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeBandwidthRateLimitScheduleError { meta: generic, kind: crate::error::DescribeBandwidthRateLimitScheduleErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBandwidthRateLimitScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::DescribeBandwidthRateLimitScheduleError { meta: generic, kind: crate::error::DescribeBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBandwidthRateLimitScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeBandwidthRateLimitScheduleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_bandwidth_rate_limit_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBandwidthRateLimitScheduleOutput,
    crate::error::DescribeBandwidthRateLimitScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_bandwidth_rate_limit_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_bandwidth_rate_limit_schedule(response.body().as_ref(), output).map_err(crate::error::DescribeBandwidthRateLimitScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeCacheOutput, crate::error::DescribeCacheError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCacheError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeCacheError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeCacheError {
            meta: generic,
            kind: crate::error::DescribeCacheErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeCacheError {
            meta: generic,
            kind: crate::error::DescribeCacheErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCacheError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeCacheOutput, crate::error::DescribeCacheError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cache_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_cache(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCacheError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cachedi_scsi_volumes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCachediScsiVolumesOutput,
    crate::error::DescribeCachediSCSIVolumesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCachediSCSIVolumesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCachediSCSIVolumesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeCachediSCSIVolumesError {
            meta: generic,
            kind: crate::error::DescribeCachediSCSIVolumesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCachediSCSIVolumesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeCachediSCSIVolumesError {
            meta: generic,
            kind: crate::error::DescribeCachediSCSIVolumesErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCachediSCSIVolumesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeCachediSCSIVolumesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cachedi_scsi_volumes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCachediScsiVolumesOutput,
    crate::error::DescribeCachediSCSIVolumesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cachedi_scsi_volumes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_cachedi_scsi_volumes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCachediSCSIVolumesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_chap_credentials_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChapCredentialsOutput,
    crate::error::DescribeChapCredentialsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChapCredentialsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeChapCredentialsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeChapCredentialsError {
            meta: generic,
            kind: crate::error::DescribeChapCredentialsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChapCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeChapCredentialsError {
            meta: generic,
            kind: crate::error::DescribeChapCredentialsErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChapCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChapCredentialsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_chap_credentials_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChapCredentialsOutput,
    crate::error::DescribeChapCredentialsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_chap_credentials_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_chap_credentials(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChapCredentialsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_system_associations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemAssociationsOutput,
    crate::error::DescribeFileSystemAssociationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFileSystemAssociationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeFileSystemAssociationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeFileSystemAssociationsError { meta: generic, kind: crate::error::DescribeFileSystemAssociationsErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemAssociationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::DescribeFileSystemAssociationsError { meta: generic, kind: crate::error::DescribeFileSystemAssociationsErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemAssociationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeFileSystemAssociationsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_system_associations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemAssociationsOutput,
    crate::error::DescribeFileSystemAssociationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_file_system_associations_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_file_system_associations(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeFileSystemAssociationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_gateway_information_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGatewayInformationOutput,
    crate::error::DescribeGatewayInformationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeGatewayInformationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeGatewayInformationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeGatewayInformationError {
            meta: generic,
            kind: crate::error::DescribeGatewayInformationErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGatewayInformationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeGatewayInformationError {
            meta: generic,
            kind: crate::error::DescribeGatewayInformationErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGatewayInformationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeGatewayInformationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_gateway_information_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGatewayInformationOutput,
    crate::error::DescribeGatewayInformationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_gateway_information_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_gateway_information(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeGatewayInformationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_maintenance_start_time_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMaintenanceStartTimeOutput,
    crate::error::DescribeMaintenanceStartTimeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeMaintenanceStartTimeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeMaintenanceStartTimeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeMaintenanceStartTimeError {
            meta: generic,
            kind: crate::error::DescribeMaintenanceStartTimeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMaintenanceStartTimeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeMaintenanceStartTimeError {
            meta: generic,
            kind:
                crate::error::DescribeMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_gateway_request_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMaintenanceStartTimeError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeMaintenanceStartTimeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_maintenance_start_time_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMaintenanceStartTimeOutput,
    crate::error::DescribeMaintenanceStartTimeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_maintenance_start_time_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_maintenance_start_time(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeMaintenanceStartTimeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_nfs_file_shares_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNfsFileSharesOutput,
    crate::error::DescribeNFSFileSharesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeNFSFileSharesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeNFSFileSharesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeNFSFileSharesError {
            meta: generic,
            kind: crate::error::DescribeNFSFileSharesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNFSFileSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeNFSFileSharesError {
            meta: generic,
            kind: crate::error::DescribeNFSFileSharesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNFSFileSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeNFSFileSharesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_nfs_file_shares_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNfsFileSharesOutput,
    crate::error::DescribeNFSFileSharesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_nfs_file_shares_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_nfs_file_shares(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeNFSFileSharesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_smb_file_shares_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSmbFileSharesOutput,
    crate::error::DescribeSMBFileSharesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSMBFileSharesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSMBFileSharesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeSMBFileSharesError {
            meta: generic,
            kind: crate::error::DescribeSMBFileSharesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSMBFileSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeSMBFileSharesError {
            meta: generic,
            kind: crate::error::DescribeSMBFileSharesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSMBFileSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSMBFileSharesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_smb_file_shares_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSmbFileSharesOutput,
    crate::error::DescribeSMBFileSharesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_smb_file_shares_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_smb_file_shares(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSMBFileSharesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_smb_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSmbSettingsOutput,
    crate::error::DescribeSMBSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSMBSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSMBSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeSMBSettingsError {
            meta: generic,
            kind: crate::error::DescribeSMBSettingsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSMBSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeSMBSettingsError {
            meta: generic,
            kind: crate::error::DescribeSMBSettingsErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSMBSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSMBSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_smb_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSmbSettingsOutput,
    crate::error::DescribeSMBSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_smb_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_smb_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSMBSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshot_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSnapshotScheduleOutput,
    crate::error::DescribeSnapshotScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSnapshotScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeSnapshotScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeSnapshotScheduleError {
            meta: generic,
            kind: crate::error::DescribeSnapshotScheduleErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeSnapshotScheduleError {
            meta: generic,
            kind: crate::error::DescribeSnapshotScheduleErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotScheduleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeSnapshotScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshot_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSnapshotScheduleOutput,
    crate::error::DescribeSnapshotScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_snapshot_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_snapshot_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSnapshotScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_storedi_scsi_volumes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStorediScsiVolumesOutput,
    crate::error::DescribeStorediSCSIVolumesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStorediSCSIVolumesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeStorediSCSIVolumesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeStorediSCSIVolumesError {
            meta: generic,
            kind: crate::error::DescribeStorediSCSIVolumesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStorediSCSIVolumesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeStorediSCSIVolumesError {
            meta: generic,
            kind: crate::error::DescribeStorediSCSIVolumesErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStorediSCSIVolumesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeStorediSCSIVolumesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_storedi_scsi_volumes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStorediScsiVolumesOutput,
    crate::error::DescribeStorediSCSIVolumesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_storedi_scsi_volumes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_storedi_scsi_volumes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStorediSCSIVolumesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tape_archives_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTapeArchivesOutput,
    crate::error::DescribeTapeArchivesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTapeArchivesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTapeArchivesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeTapeArchivesError {
            meta: generic,
            kind: crate::error::DescribeTapeArchivesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTapeArchivesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeTapeArchivesError {
            meta: generic,
            kind: crate::error::DescribeTapeArchivesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTapeArchivesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTapeArchivesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tape_archives_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTapeArchivesOutput,
    crate::error::DescribeTapeArchivesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tape_archives_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tape_archives(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTapeArchivesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tape_recovery_points_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTapeRecoveryPointsOutput,
    crate::error::DescribeTapeRecoveryPointsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTapeRecoveryPointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTapeRecoveryPointsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeTapeRecoveryPointsError {
            meta: generic,
            kind: crate::error::DescribeTapeRecoveryPointsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTapeRecoveryPointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeTapeRecoveryPointsError {
            meta: generic,
            kind: crate::error::DescribeTapeRecoveryPointsErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTapeRecoveryPointsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeTapeRecoveryPointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tape_recovery_points_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTapeRecoveryPointsOutput,
    crate::error::DescribeTapeRecoveryPointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tape_recovery_points_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tape_recovery_points(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTapeRecoveryPointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tapes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTapesOutput, crate::error::DescribeTapesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTapesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTapesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeTapesError {
            meta: generic,
            kind: crate::error::DescribeTapesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTapesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeTapesError {
            meta: generic,
            kind: crate::error::DescribeTapesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTapesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTapesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tapes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTapesOutput, crate::error::DescribeTapesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tapes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tapes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTapesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_upload_buffer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUploadBufferOutput,
    crate::error::DescribeUploadBufferError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUploadBufferError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUploadBufferError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeUploadBufferError {
            meta: generic,
            kind: crate::error::DescribeUploadBufferErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUploadBufferError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeUploadBufferError {
            meta: generic,
            kind: crate::error::DescribeUploadBufferErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUploadBufferError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUploadBufferError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_upload_buffer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUploadBufferOutput,
    crate::error::DescribeUploadBufferError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_upload_buffer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_upload_buffer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUploadBufferError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_vtl_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeVtlDevicesOutput,
    crate::error::DescribeVTLDevicesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeVTLDevicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeVTLDevicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeVTLDevicesError {
            meta: generic,
            kind: crate::error::DescribeVTLDevicesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVTLDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeVTLDevicesError {
            meta: generic,
            kind: crate::error::DescribeVTLDevicesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVTLDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeVTLDevicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_vtl_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeVtlDevicesOutput,
    crate::error::DescribeVTLDevicesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_vtl_devices_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_vtl_devices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeVTLDevicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_working_storage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkingStorageOutput,
    crate::error::DescribeWorkingStorageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkingStorageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeWorkingStorageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeWorkingStorageError {
            meta: generic,
            kind: crate::error::DescribeWorkingStorageErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkingStorageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DescribeWorkingStorageError {
            meta: generic,
            kind: crate::error::DescribeWorkingStorageErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkingStorageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeWorkingStorageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_working_storage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkingStorageOutput,
    crate::error::DescribeWorkingStorageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_working_storage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_working_storage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkingStorageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachVolumeOutput, crate::error::DetachVolumeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachVolumeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DetachVolumeError {
            meta: generic,
            kind: crate::error::DetachVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DetachVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DetachVolumeError {
            meta: generic,
            kind: crate::error::DetachVolumeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachVolumeOutput, crate::error::DetachVolumeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detach_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetachVolumeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_gateway_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableGatewayOutput, crate::error::DisableGatewayError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableGatewayError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableGatewayError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DisableGatewayError {
            meta: generic,
            kind: crate::error::DisableGatewayErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DisableGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DisableGatewayError {
            meta: generic,
            kind: crate::error::DisableGatewayErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableGatewayError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_gateway_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableGatewayOutput, crate::error::DisableGatewayError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_gateway_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disable_gateway(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisableGatewayError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateFileSystemOutput,
    crate::error::DisassociateFileSystemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateFileSystemError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DisassociateFileSystemError {
            meta: generic,
            kind: crate::error::DisassociateFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::DisassociateFileSystemError {
            meta: generic,
            kind: crate::error::DisassociateFileSystemErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateFileSystemOutput,
    crate::error::DisassociateFileSystemError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_file_system_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disassociate_file_system(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisassociateFileSystemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_join_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::JoinDomainOutput, crate::error::JoinDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::JoinDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::JoinDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::JoinDomainError {
            meta: generic,
            kind: crate::error::JoinDomainErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::JoinDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::JoinDomainError {
            meta: generic,
            kind: crate::error::JoinDomainErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::JoinDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::JoinDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_join_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::JoinDomainOutput, crate::error::JoinDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::join_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_join_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::JoinDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_automatic_tape_creation_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAutomaticTapeCreationPoliciesOutput,
    crate::error::ListAutomaticTapeCreationPoliciesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAutomaticTapeCreationPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAutomaticTapeCreationPoliciesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListAutomaticTapeCreationPoliciesError { meta: generic, kind: crate::error::ListAutomaticTapeCreationPoliciesErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListAutomaticTapeCreationPoliciesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::ListAutomaticTapeCreationPoliciesError { meta: generic, kind: crate::error::ListAutomaticTapeCreationPoliciesErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAutomaticTapeCreationPoliciesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListAutomaticTapeCreationPoliciesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_automatic_tape_creation_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAutomaticTapeCreationPoliciesOutput,
    crate::error::ListAutomaticTapeCreationPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_automatic_tape_creation_policies_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_automatic_tape_creation_policies(response.body().as_ref(), output).map_err(crate::error::ListAutomaticTapeCreationPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_file_shares_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFileSharesOutput, crate::error::ListFileSharesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFileSharesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListFileSharesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListFileSharesError {
            meta: generic,
            kind: crate::error::ListFileSharesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListFileSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListFileSharesError {
            meta: generic,
            kind: crate::error::ListFileSharesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFileSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListFileSharesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_file_shares_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFileSharesOutput, crate::error::ListFileSharesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_file_shares_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_file_shares(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListFileSharesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_file_system_associations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFileSystemAssociationsOutput,
    crate::error::ListFileSystemAssociationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFileSystemAssociationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListFileSystemAssociationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListFileSystemAssociationsError {
            meta: generic,
            kind: crate::error::ListFileSystemAssociationsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListFileSystemAssociationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListFileSystemAssociationsError {
            meta: generic,
            kind: crate::error::ListFileSystemAssociationsErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFileSystemAssociationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListFileSystemAssociationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_file_system_associations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFileSystemAssociationsOutput,
    crate::error::ListFileSystemAssociationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_file_system_associations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_file_system_associations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListFileSystemAssociationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_gateways_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGatewaysOutput, crate::error::ListGatewaysError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGatewaysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGatewaysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListGatewaysError {
            meta: generic,
            kind: crate::error::ListGatewaysErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListGatewaysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListGatewaysError {
            meta: generic,
            kind: crate::error::ListGatewaysErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGatewaysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGatewaysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_gateways_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGatewaysOutput, crate::error::ListGatewaysError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_gateways_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_gateways(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGatewaysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_local_disks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLocalDisksOutput, crate::error::ListLocalDisksError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLocalDisksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLocalDisksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListLocalDisksError {
            meta: generic,
            kind: crate::error::ListLocalDisksErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListLocalDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListLocalDisksError {
            meta: generic,
            kind: crate::error::ListLocalDisksErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLocalDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLocalDisksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_local_disks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLocalDisksOutput, crate::error::ListLocalDisksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_local_disks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_local_disks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLocalDisksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tape_pools_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTapePoolsOutput, crate::error::ListTapePoolsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTapePoolsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTapePoolsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListTapePoolsError {
            meta: generic,
            kind: crate::error::ListTapePoolsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTapePoolsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListTapePoolsError {
            meta: generic,
            kind: crate::error::ListTapePoolsErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTapePoolsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTapePoolsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tape_pools_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTapePoolsOutput, crate::error::ListTapePoolsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tape_pools_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tape_pools(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTapePoolsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tapes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTapesOutput, crate::error::ListTapesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTapesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTapesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListTapesError {
            meta: generic,
            kind: crate::error::ListTapesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTapesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListTapesError {
            meta: generic,
            kind: crate::error::ListTapesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTapesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTapesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tapes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTapesOutput, crate::error::ListTapesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tapes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tapes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTapesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_volume_initiators_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVolumeInitiatorsOutput,
    crate::error::ListVolumeInitiatorsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVolumeInitiatorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListVolumeInitiatorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListVolumeInitiatorsError {
            meta: generic,
            kind: crate::error::ListVolumeInitiatorsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListVolumeInitiatorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListVolumeInitiatorsError {
            meta: generic,
            kind: crate::error::ListVolumeInitiatorsErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVolumeInitiatorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListVolumeInitiatorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_volume_initiators_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVolumeInitiatorsOutput,
    crate::error::ListVolumeInitiatorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_volume_initiators_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_volume_initiators(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVolumeInitiatorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_volume_recovery_points_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVolumeRecoveryPointsOutput,
    crate::error::ListVolumeRecoveryPointsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVolumeRecoveryPointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListVolumeRecoveryPointsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListVolumeRecoveryPointsError {
            meta: generic,
            kind: crate::error::ListVolumeRecoveryPointsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListVolumeRecoveryPointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListVolumeRecoveryPointsError {
            meta: generic,
            kind: crate::error::ListVolumeRecoveryPointsErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVolumeRecoveryPointsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListVolumeRecoveryPointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_volume_recovery_points_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVolumeRecoveryPointsOutput,
    crate::error::ListVolumeRecoveryPointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_volume_recovery_points_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_volume_recovery_points(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVolumeRecoveryPointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_volumes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListVolumesOutput, crate::error::ListVolumesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVolumesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListVolumesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListVolumesError {
            meta: generic,
            kind: crate::error::ListVolumesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListVolumesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ListVolumesError {
            meta: generic,
            kind: crate::error::ListVolumesErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVolumesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListVolumesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_volumes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListVolumesOutput, crate::error::ListVolumesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_volumes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_volumes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVolumesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_notify_when_uploaded_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::NotifyWhenUploadedOutput,
    crate::error::NotifyWhenUploadedError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::NotifyWhenUploadedError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::NotifyWhenUploadedError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::NotifyWhenUploadedError {
            meta: generic,
            kind: crate::error::NotifyWhenUploadedErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::NotifyWhenUploadedError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::NotifyWhenUploadedError {
            meta: generic,
            kind: crate::error::NotifyWhenUploadedErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::NotifyWhenUploadedError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::NotifyWhenUploadedError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_notify_when_uploaded_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::NotifyWhenUploadedOutput,
    crate::error::NotifyWhenUploadedError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::notify_when_uploaded_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_notify_when_uploaded(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::NotifyWhenUploadedError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_refresh_cache_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RefreshCacheOutput, crate::error::RefreshCacheError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RefreshCacheError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RefreshCacheError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::RefreshCacheError {
            meta: generic,
            kind: crate::error::RefreshCacheErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::RefreshCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::RefreshCacheError {
            meta: generic,
            kind: crate::error::RefreshCacheErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RefreshCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RefreshCacheError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_refresh_cache_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RefreshCacheOutput, crate::error::RefreshCacheError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::refresh_cache_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_refresh_cache(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RefreshCacheError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveTagsFromResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsFromResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_from_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_remove_tags_from_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_cache_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResetCacheOutput, crate::error::ResetCacheError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetCacheError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResetCacheError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ResetCacheError {
            meta: generic,
            kind: crate::error::ResetCacheErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ResetCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ResetCacheError {
            meta: generic,
            kind: crate::error::ResetCacheErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResetCacheError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_cache_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResetCacheOutput, crate::error::ResetCacheError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_cache_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reset_cache(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResetCacheError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retrieve_tape_archive_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetrieveTapeArchiveOutput,
    crate::error::RetrieveTapeArchiveError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RetrieveTapeArchiveError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RetrieveTapeArchiveError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::RetrieveTapeArchiveError {
            meta: generic,
            kind: crate::error::RetrieveTapeArchiveErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::RetrieveTapeArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::RetrieveTapeArchiveError {
            meta: generic,
            kind: crate::error::RetrieveTapeArchiveErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetrieveTapeArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RetrieveTapeArchiveError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retrieve_tape_archive_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetrieveTapeArchiveOutput,
    crate::error::RetrieveTapeArchiveError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::retrieve_tape_archive_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_retrieve_tape_archive(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RetrieveTapeArchiveError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retrieve_tape_recovery_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetrieveTapeRecoveryPointOutput,
    crate::error::RetrieveTapeRecoveryPointError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RetrieveTapeRecoveryPointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RetrieveTapeRecoveryPointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::RetrieveTapeRecoveryPointError {
            meta: generic,
            kind: crate::error::RetrieveTapeRecoveryPointErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::RetrieveTapeRecoveryPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::RetrieveTapeRecoveryPointError {
            meta: generic,
            kind: crate::error::RetrieveTapeRecoveryPointErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetrieveTapeRecoveryPointError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::RetrieveTapeRecoveryPointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retrieve_tape_recovery_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetrieveTapeRecoveryPointOutput,
    crate::error::RetrieveTapeRecoveryPointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::retrieve_tape_recovery_point_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_retrieve_tape_recovery_point(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RetrieveTapeRecoveryPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_local_console_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLocalConsolePasswordOutput,
    crate::error::SetLocalConsolePasswordError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetLocalConsolePasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetLocalConsolePasswordError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::SetLocalConsolePasswordError {
            meta: generic,
            kind: crate::error::SetLocalConsolePasswordErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::SetLocalConsolePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::SetLocalConsolePasswordError {
            meta: generic,
            kind: crate::error::SetLocalConsolePasswordErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetLocalConsolePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetLocalConsolePasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_local_console_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLocalConsolePasswordOutput,
    crate::error::SetLocalConsolePasswordError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_local_console_password_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_local_console_password(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetLocalConsolePasswordError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_smb_guest_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetSmbGuestPasswordOutput,
    crate::error::SetSMBGuestPasswordError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetSMBGuestPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetSMBGuestPasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::SetSMBGuestPasswordError {
            meta: generic,
            kind: crate::error::SetSMBGuestPasswordErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::SetSMBGuestPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::SetSMBGuestPasswordError {
            meta: generic,
            kind: crate::error::SetSMBGuestPasswordErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetSMBGuestPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetSMBGuestPasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_smb_guest_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetSmbGuestPasswordOutput,
    crate::error::SetSMBGuestPasswordError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_smb_guest_password_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_smb_guest_password(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetSMBGuestPasswordError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_shutdown_gateway_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ShutdownGatewayOutput, crate::error::ShutdownGatewayError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ShutdownGatewayError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ShutdownGatewayError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ShutdownGatewayError {
            meta: generic,
            kind: crate::error::ShutdownGatewayErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ShutdownGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::ShutdownGatewayError {
            meta: generic,
            kind: crate::error::ShutdownGatewayErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShutdownGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ShutdownGatewayError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_shutdown_gateway_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ShutdownGatewayOutput, crate::error::ShutdownGatewayError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::shutdown_gateway_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_shutdown_gateway(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ShutdownGatewayError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_availability_monitor_test_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartAvailabilityMonitorTestOutput,
    crate::error::StartAvailabilityMonitorTestError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartAvailabilityMonitorTestError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartAvailabilityMonitorTestError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::StartAvailabilityMonitorTestError {
            meta: generic,
            kind: crate::error::StartAvailabilityMonitorTestErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::StartAvailabilityMonitorTestError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::StartAvailabilityMonitorTestError {
            meta: generic,
            kind:
                crate::error::StartAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_gateway_request_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAvailabilityMonitorTestError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::StartAvailabilityMonitorTestError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_availability_monitor_test_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartAvailabilityMonitorTestOutput,
    crate::error::StartAvailabilityMonitorTestError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_availability_monitor_test_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_start_availability_monitor_test(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StartAvailabilityMonitorTestError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_gateway_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartGatewayOutput, crate::error::StartGatewayError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartGatewayError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartGatewayError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::StartGatewayError {
            meta: generic,
            kind: crate::error::StartGatewayErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::StartGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::StartGatewayError {
            meta: generic,
            kind: crate::error::StartGatewayErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartGatewayError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_gateway_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartGatewayOutput, crate::error::StartGatewayError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_gateway_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_gateway(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartGatewayError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_automatic_tape_creation_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAutomaticTapeCreationPolicyOutput,
    crate::error::UpdateAutomaticTapeCreationPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAutomaticTapeCreationPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAutomaticTapeCreationPolicyError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateAutomaticTapeCreationPolicyError { meta: generic, kind: crate::error::UpdateAutomaticTapeCreationPolicyErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAutomaticTapeCreationPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::UpdateAutomaticTapeCreationPolicyError { meta: generic, kind: crate::error::UpdateAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAutomaticTapeCreationPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateAutomaticTapeCreationPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_automatic_tape_creation_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAutomaticTapeCreationPolicyOutput,
    crate::error::UpdateAutomaticTapeCreationPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_automatic_tape_creation_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_automatic_tape_creation_policy(response.body().as_ref(), output).map_err(crate::error::UpdateAutomaticTapeCreationPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_bandwidth_rate_limit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBandwidthRateLimitOutput,
    crate::error::UpdateBandwidthRateLimitError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBandwidthRateLimitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateBandwidthRateLimitError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateBandwidthRateLimitError {
            meta: generic,
            kind: crate::error::UpdateBandwidthRateLimitErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBandwidthRateLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateBandwidthRateLimitError {
            meta: generic,
            kind: crate::error::UpdateBandwidthRateLimitErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBandwidthRateLimitError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateBandwidthRateLimitError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_bandwidth_rate_limit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBandwidthRateLimitOutput,
    crate::error::UpdateBandwidthRateLimitError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_bandwidth_rate_limit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_bandwidth_rate_limit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateBandwidthRateLimitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_bandwidth_rate_limit_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBandwidthRateLimitScheduleOutput,
    crate::error::UpdateBandwidthRateLimitScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBandwidthRateLimitScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateBandwidthRateLimitScheduleError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateBandwidthRateLimitScheduleError { meta: generic, kind: crate::error::UpdateBandwidthRateLimitScheduleErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBandwidthRateLimitScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGatewayRequestException" => crate::error::UpdateBandwidthRateLimitScheduleError { meta: generic, kind: crate::error::UpdateBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBandwidthRateLimitScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateBandwidthRateLimitScheduleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_bandwidth_rate_limit_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBandwidthRateLimitScheduleOutput,
    crate::error::UpdateBandwidthRateLimitScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_bandwidth_rate_limit_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_bandwidth_rate_limit_schedule(response.body().as_ref(), output).map_err(crate::error::UpdateBandwidthRateLimitScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_chap_credentials_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateChapCredentialsOutput,
    crate::error::UpdateChapCredentialsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateChapCredentialsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateChapCredentialsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateChapCredentialsError {
            meta: generic,
            kind: crate::error::UpdateChapCredentialsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChapCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateChapCredentialsError {
            meta: generic,
            kind: crate::error::UpdateChapCredentialsErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChapCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateChapCredentialsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_chap_credentials_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateChapCredentialsOutput,
    crate::error::UpdateChapCredentialsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_chap_credentials_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_chap_credentials(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateChapCredentialsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_file_system_association_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFileSystemAssociationOutput,
    crate::error::UpdateFileSystemAssociationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFileSystemAssociationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateFileSystemAssociationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateFileSystemAssociationError {
            meta: generic,
            kind: crate::error::UpdateFileSystemAssociationErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemAssociationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateFileSystemAssociationError {
            meta: generic,
            kind:
                crate::error::UpdateFileSystemAssociationErrorKind::InvalidGatewayRequestException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_gateway_request_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemAssociationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::UpdateFileSystemAssociationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_file_system_association_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFileSystemAssociationOutput,
    crate::error::UpdateFileSystemAssociationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_file_system_association_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_file_system_association(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateFileSystemAssociationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_information_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGatewayInformationOutput,
    crate::error::UpdateGatewayInformationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGatewayInformationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateGatewayInformationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateGatewayInformationError {
            meta: generic,
            kind: crate::error::UpdateGatewayInformationErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewayInformationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateGatewayInformationError {
            meta: generic,
            kind: crate::error::UpdateGatewayInformationErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewayInformationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateGatewayInformationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_information_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGatewayInformationOutput,
    crate::error::UpdateGatewayInformationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_gateway_information_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_gateway_information(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateGatewayInformationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_software_now_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGatewaySoftwareNowOutput,
    crate::error::UpdateGatewaySoftwareNowError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGatewaySoftwareNowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateGatewaySoftwareNowError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateGatewaySoftwareNowError {
            meta: generic,
            kind: crate::error::UpdateGatewaySoftwareNowErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewaySoftwareNowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateGatewaySoftwareNowError {
            meta: generic,
            kind: crate::error::UpdateGatewaySoftwareNowErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewaySoftwareNowError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateGatewaySoftwareNowError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_software_now_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGatewaySoftwareNowOutput,
    crate::error::UpdateGatewaySoftwareNowError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_gateway_software_now_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_gateway_software_now(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateGatewaySoftwareNowError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_maintenance_start_time_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateMaintenanceStartTimeOutput,
    crate::error::UpdateMaintenanceStartTimeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateMaintenanceStartTimeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateMaintenanceStartTimeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateMaintenanceStartTimeError {
            meta: generic,
            kind: crate::error::UpdateMaintenanceStartTimeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateMaintenanceStartTimeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateMaintenanceStartTimeError {
            meta: generic,
            kind: crate::error::UpdateMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateMaintenanceStartTimeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateMaintenanceStartTimeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_maintenance_start_time_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateMaintenanceStartTimeOutput,
    crate::error::UpdateMaintenanceStartTimeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_maintenance_start_time_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_maintenance_start_time(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateMaintenanceStartTimeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_nfs_file_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNfsFileShareOutput,
    crate::error::UpdateNFSFileShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNFSFileShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateNFSFileShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateNFSFileShareError {
            meta: generic,
            kind: crate::error::UpdateNFSFileShareErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNFSFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateNFSFileShareError {
            meta: generic,
            kind: crate::error::UpdateNFSFileShareErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNFSFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateNFSFileShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_nfs_file_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNfsFileShareOutput,
    crate::error::UpdateNFSFileShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_nfs_file_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_nfs_file_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateNFSFileShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_file_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbFileShareOutput,
    crate::error::UpdateSMBFileShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSMBFileShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateSMBFileShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateSMBFileShareError {
            meta: generic,
            kind: crate::error::UpdateSMBFileShareErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateSMBFileShareError {
            meta: generic,
            kind: crate::error::UpdateSMBFileShareErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBFileShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSMBFileShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_file_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbFileShareOutput,
    crate::error::UpdateSMBFileShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_smb_file_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_smb_file_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSMBFileShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_file_share_visibility_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbFileShareVisibilityOutput,
    crate::error::UpdateSMBFileShareVisibilityError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSMBFileShareVisibilityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateSMBFileShareVisibilityError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateSMBFileShareVisibilityError {
            meta: generic,
            kind: crate::error::UpdateSMBFileShareVisibilityErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBFileShareVisibilityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateSMBFileShareVisibilityError {
            meta: generic,
            kind:
                crate::error::UpdateSMBFileShareVisibilityErrorKind::InvalidGatewayRequestException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_gateway_request_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBFileShareVisibilityError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::UpdateSMBFileShareVisibilityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_file_share_visibility_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbFileShareVisibilityOutput,
    crate::error::UpdateSMBFileShareVisibilityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_smb_file_share_visibility_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_update_smb_file_share_visibility(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::UpdateSMBFileShareVisibilityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_local_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbLocalGroupsOutput,
    crate::error::UpdateSMBLocalGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSMBLocalGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateSMBLocalGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateSMBLocalGroupsError {
            meta: generic,
            kind: crate::error::UpdateSMBLocalGroupsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBLocalGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateSMBLocalGroupsError {
            meta: generic,
            kind: crate::error::UpdateSMBLocalGroupsErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBLocalGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSMBLocalGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_local_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbLocalGroupsOutput,
    crate::error::UpdateSMBLocalGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_smb_local_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_smb_local_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSMBLocalGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_security_strategy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbSecurityStrategyOutput,
    crate::error::UpdateSMBSecurityStrategyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSMBSecurityStrategyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateSMBSecurityStrategyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateSMBSecurityStrategyError {
            meta: generic,
            kind: crate::error::UpdateSMBSecurityStrategyErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBSecurityStrategyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateSMBSecurityStrategyError {
            meta: generic,
            kind: crate::error::UpdateSMBSecurityStrategyErrorKind::InvalidGatewayRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_gateway_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSMBSecurityStrategyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateSMBSecurityStrategyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_smb_security_strategy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSmbSecurityStrategyOutput,
    crate::error::UpdateSMBSecurityStrategyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_smb_security_strategy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_smb_security_strategy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSMBSecurityStrategyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_snapshot_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSnapshotScheduleOutput,
    crate::error::UpdateSnapshotScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSnapshotScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateSnapshotScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateSnapshotScheduleError {
            meta: generic,
            kind: crate::error::UpdateSnapshotScheduleErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSnapshotScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateSnapshotScheduleError {
            meta: generic,
            kind: crate::error::UpdateSnapshotScheduleErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSnapshotScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSnapshotScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_snapshot_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSnapshotScheduleOutput,
    crate::error::UpdateSnapshotScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_snapshot_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_snapshot_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSnapshotScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_vtl_device_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateVtlDeviceTypeOutput,
    crate::error::UpdateVTLDeviceTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateVTLDeviceTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateVTLDeviceTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateVTLDeviceTypeError {
            meta: generic,
            kind: crate::error::UpdateVTLDeviceTypeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVTLDeviceTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGatewayRequestException" => crate::error::UpdateVTLDeviceTypeError {
            meta: generic,
            kind: crate::error::UpdateVTLDeviceTypeErrorKind::InvalidGatewayRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_gateway_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_gateway_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVTLDeviceTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateVTLDeviceTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_vtl_device_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateVtlDeviceTypeOutput,
    crate::error::UpdateVTLDeviceTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_vtl_device_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_vtl_device_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateVTLDeviceTypeError::unhandled)?;
        output.build()
    })
}
