// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// <p>An internal server error has occurred because the service is unavailable. For more
    /// information, see the error and message fields.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::InternalServerError(inner) => inner.fmt(f),
            Error::InvalidGatewayRequestException(inner) => inner.fmt(f),
            Error::ServiceUnavailableError(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ActivateGatewayError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ActivateGatewayError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ActivateGatewayErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ActivateGatewayErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ActivateGatewayErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddCacheError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddCacheError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddCacheErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AddCacheErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::AddCacheErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AddTagsToResourceErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddUploadBufferError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddUploadBufferError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddUploadBufferErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AddUploadBufferErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::AddUploadBufferErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddWorkingStorageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddWorkingStorageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddWorkingStorageErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AddWorkingStorageErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::AddWorkingStorageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssignTapePoolError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AssignTapePoolError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssignTapePoolErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AssignTapePoolErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::AssignTapePoolErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateFileSystemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AssociateFileSystemErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::AssociateFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AttachVolumeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AttachVolumeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AttachVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AttachVolumeErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::AttachVolumeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelArchivalError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CancelArchivalError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelArchivalErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CancelArchivalErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::CancelArchivalErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelRetrievalError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CancelRetrievalError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelRetrievalErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CancelRetrievalErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::CancelRetrievalErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCachediSCSIVolumeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCachediSCSIVolumeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCachediSCSIVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateCachediSCSIVolumeErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::CreateCachediSCSIVolumeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateNFSFileShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateNFSFileShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateNFSFileShareErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateNFSFileShareErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::CreateNFSFileShareErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSMBFileShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateSMBFileShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateSMBFileShareErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateSMBFileShareErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::CreateSMBFileShareErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateSnapshotErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateSnapshotErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::CreateSnapshotErrorKind::ServiceUnavailableError(inner) => {
                    Error::ServiceUnavailableError(inner)
                }
                crate::error::CreateSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateSnapshotFromVolumeRecoveryPointError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateSnapshotFromVolumeRecoveryPointError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateSnapshotFromVolumeRecoveryPointErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::CreateSnapshotFromVolumeRecoveryPointErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::CreateSnapshotFromVolumeRecoveryPointErrorKind::ServiceUnavailableError(inner) => Error::ServiceUnavailableError(inner),
                crate::error::CreateSnapshotFromVolumeRecoveryPointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateStorediSCSIVolumeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateStorediSCSIVolumeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateStorediSCSIVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateStorediSCSIVolumeErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::CreateStorediSCSIVolumeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTapePoolError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTapePoolError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTapePoolErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateTapePoolErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::CreateTapePoolErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTapesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTapesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTapesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateTapesErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::CreateTapesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTapeWithBarcodeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateTapeWithBarcodeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTapeWithBarcodeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateTapeWithBarcodeErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::CreateTapeWithBarcodeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteAutomaticTapeCreationPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteAutomaticTapeCreationPolicyError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAutomaticTapeCreationPolicyErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeleteAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DeleteAutomaticTapeCreationPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteBandwidthRateLimitError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteBandwidthRateLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteBandwidthRateLimitErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteBandwidthRateLimitErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DeleteBandwidthRateLimitErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChapCredentialsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteChapCredentialsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChapCredentialsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteChapCredentialsErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DeleteChapCredentialsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFileShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteFileShareError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFileShareErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteFileShareErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DeleteFileShareErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGatewayError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteGatewayError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteGatewayErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteGatewayErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DeleteGatewayErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSnapshotScheduleErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteSnapshotScheduleErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DeleteSnapshotScheduleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTapeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTapeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTapeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteTapeErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DeleteTapeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTapeArchiveError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteTapeArchiveError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTapeArchiveErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteTapeArchiveErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DeleteTapeArchiveErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTapePoolError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTapePoolError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTapePoolErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteTapePoolErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DeleteTapePoolErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteVolumeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteVolumeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteVolumeErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DeleteVolumeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeAvailabilityMonitorTestError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAvailabilityMonitorTestError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAvailabilityMonitorTestErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeAvailabilityMonitorTestErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeBandwidthRateLimitError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeBandwidthRateLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeBandwidthRateLimitErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeBandwidthRateLimitErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeBandwidthRateLimitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeBandwidthRateLimitScheduleError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeBandwidthRateLimitScheduleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeBandwidthRateLimitScheduleErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeBandwidthRateLimitScheduleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCacheError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeCacheError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCacheErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeCacheErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DescribeCacheErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCachediSCSIVolumesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCachediSCSIVolumesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCachediSCSIVolumesErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeCachediSCSIVolumesErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeCachediSCSIVolumesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeChapCredentialsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeChapCredentialsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeChapCredentialsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeChapCredentialsErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeChapCredentialsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemAssociationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeFileSystemAssociationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeFileSystemAssociationsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeFileSystemAssociationsErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeFileSystemAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeGatewayInformationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeGatewayInformationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeGatewayInformationErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeGatewayInformationErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeGatewayInformationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceStartTimeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceStartTimeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeMaintenanceStartTimeErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeMaintenanceStartTimeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeNFSFileSharesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeNFSFileSharesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeNFSFileSharesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeNFSFileSharesErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeNFSFileSharesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSMBFileSharesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSMBFileSharesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSMBFileSharesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeSMBFileSharesErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeSMBFileSharesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSMBSettingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSMBSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSMBSettingsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeSMBSettingsErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeSMBSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSnapshotScheduleErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeSnapshotScheduleErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeSnapshotScheduleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStorediSCSIVolumesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStorediSCSIVolumesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeStorediSCSIVolumesErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeStorediSCSIVolumesErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeStorediSCSIVolumesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTapeArchivesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTapeArchivesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTapeArchivesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeTapeArchivesErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeTapeArchivesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTapeRecoveryPointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTapeRecoveryPointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeTapeRecoveryPointsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeTapeRecoveryPointsErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeTapeRecoveryPointsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTapesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTapesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTapesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeTapesErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DescribeTapesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUploadBufferError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeUploadBufferError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeUploadBufferErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeUploadBufferErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeUploadBufferErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeVTLDevicesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeVTLDevicesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeVTLDevicesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeVTLDevicesErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeVTLDevicesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkingStorageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkingStorageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeWorkingStorageErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeWorkingStorageErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DescribeWorkingStorageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetachVolumeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetachVolumeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetachVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DetachVolumeErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DetachVolumeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableGatewayError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DisableGatewayError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableGatewayErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DisableGatewayErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::DisableGatewayErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateFileSystemError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DisassociateFileSystemErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::DisassociateFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::JoinDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::JoinDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::JoinDomainErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::JoinDomainErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::JoinDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListAutomaticTapeCreationPoliciesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListAutomaticTapeCreationPoliciesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListAutomaticTapeCreationPoliciesErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::ListAutomaticTapeCreationPoliciesErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::ListAutomaticTapeCreationPoliciesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFileSharesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListFileSharesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFileSharesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListFileSharesErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ListFileSharesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFileSystemAssociationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListFileSystemAssociationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListFileSystemAssociationsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::ListFileSystemAssociationsErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::ListFileSystemAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGatewaysError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListGatewaysError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListGatewaysErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListGatewaysErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ListGatewaysErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListLocalDisksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListLocalDisksError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListLocalDisksErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListLocalDisksErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ListLocalDisksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTapePoolsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTapePoolsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTapePoolsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListTapePoolsErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ListTapePoolsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTapesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTapesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTapesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListTapesErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ListTapesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListVolumeInitiatorsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListVolumeInitiatorsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListVolumeInitiatorsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListVolumeInitiatorsErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::ListVolumeInitiatorsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListVolumeRecoveryPointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListVolumeRecoveryPointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListVolumeRecoveryPointsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListVolumeRecoveryPointsErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::ListVolumeRecoveryPointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListVolumesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListVolumesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListVolumesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListVolumesErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ListVolumesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::NotifyWhenUploadedError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::NotifyWhenUploadedError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::NotifyWhenUploadedErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::NotifyWhenUploadedErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::NotifyWhenUploadedErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RefreshCacheError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RefreshCacheError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RefreshCacheErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::RefreshCacheErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::RefreshCacheErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetCacheError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ResetCacheError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResetCacheErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ResetCacheErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ResetCacheErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RetrieveTapeArchiveError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RetrieveTapeArchiveError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RetrieveTapeArchiveErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::RetrieveTapeArchiveErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::RetrieveTapeArchiveErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RetrieveTapeRecoveryPointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RetrieveTapeRecoveryPointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RetrieveTapeRecoveryPointErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::RetrieveTapeRecoveryPointErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::RetrieveTapeRecoveryPointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetLocalConsolePasswordError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetLocalConsolePasswordError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetLocalConsolePasswordErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::SetLocalConsolePasswordErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::SetLocalConsolePasswordErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetSMBGuestPasswordError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetSMBGuestPasswordError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetSMBGuestPasswordErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::SetSMBGuestPasswordErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::SetSMBGuestPasswordErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ShutdownGatewayError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ShutdownGatewayError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ShutdownGatewayErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ShutdownGatewayErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::ShutdownGatewayErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartAvailabilityMonitorTestError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartAvailabilityMonitorTestError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartAvailabilityMonitorTestErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::StartAvailabilityMonitorTestErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartGatewayError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartGatewayError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartGatewayErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::StartGatewayErrorKind::InvalidGatewayRequestException(inner) => {
                    Error::InvalidGatewayRequestException(inner)
                }
                crate::error::StartGatewayErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateAutomaticTapeCreationPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateAutomaticTapeCreationPolicyError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateAutomaticTapeCreationPolicyErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateAutomaticTapeCreationPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateBandwidthRateLimitError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateBandwidthRateLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateBandwidthRateLimitErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateBandwidthRateLimitErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateBandwidthRateLimitErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateBandwidthRateLimitScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateBandwidthRateLimitScheduleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateBandwidthRateLimitScheduleErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateBandwidthRateLimitScheduleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateChapCredentialsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateChapCredentialsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateChapCredentialsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateChapCredentialsErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateChapCredentialsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemAssociationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemAssociationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateFileSystemAssociationErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateFileSystemAssociationErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateFileSystemAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateGatewayInformationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateGatewayInformationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateGatewayInformationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateGatewayInformationErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateGatewayInformationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateGatewaySoftwareNowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateGatewaySoftwareNowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateGatewaySoftwareNowErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateGatewaySoftwareNowErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateGatewaySoftwareNowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceStartTimeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceStartTimeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateMaintenanceStartTimeErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateMaintenanceStartTimeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateNFSFileShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateNFSFileShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateNFSFileShareErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateNFSFileShareErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateNFSFileShareErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateSMBFileShareErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateSMBFileShareErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateSMBFileShareErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareVisibilityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareVisibilityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateSMBFileShareVisibilityErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateSMBFileShareVisibilityErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateSMBFileShareVisibilityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateSMBLocalGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateSMBLocalGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateSMBLocalGroupsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateSMBLocalGroupsErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateSMBLocalGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateSMBSecurityStrategyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateSMBSecurityStrategyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateSMBSecurityStrategyErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateSMBSecurityStrategyErrorKind::InvalidGatewayRequestException(inner) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateSMBSecurityStrategyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateSnapshotScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateSnapshotScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateSnapshotScheduleErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateSnapshotScheduleErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateSnapshotScheduleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateVTLDeviceTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateVTLDeviceTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateVTLDeviceTypeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateVTLDeviceTypeErrorKind::InvalidGatewayRequestException(
                    inner,
                ) => Error::InvalidGatewayRequestException(inner),
                crate::error::UpdateVTLDeviceTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
