// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides additional information about an error that was returned by the service. See the
/// <code>errorCode</code> and <code>errorDetails</code> members for more information about
/// the error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageGatewayError {
    /// <p>Additional information about the error.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>Human-readable text that provides detail about the error that occurred.</p>
    pub error_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for StorageGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageGatewayError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_details", &self.error_details);
        formatter.finish()
    }
}
/// See [`StorageGatewayError`](crate::model::StorageGatewayError)
pub mod storage_gateway_error {
    /// A builder for [`StorageGatewayError`](crate::model::StorageGatewayError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Additional information about the error.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Additional information about the error.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// Adds a key-value pair to `error_details`.
        ///
        /// To override the contents of this collection use [`set_error_details`](Self::set_error_details).
        ///
        /// <p>Human-readable text that provides detail about the error that occurred.</p>
        pub fn error_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.error_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.error_details = Some(hash_map);
            self
        }
        /// <p>Human-readable text that provides detail about the error that occurred.</p>
        pub fn set_error_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageGatewayError`](crate::model::StorageGatewayError)
        pub fn build(self) -> crate::model::StorageGatewayError {
            crate::model::StorageGatewayError {
                error_code: self.error_code,
                error_details: self.error_details,
            }
        }
    }
}
impl StorageGatewayError {
    /// Creates a new builder-style object to manufacture [`StorageGatewayError`](crate::model::StorageGatewayError)
    pub fn builder() -> crate::model::storage_gateway_error::Builder {
        crate::model::storage_gateway_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    ActivationKeyExpired,
    #[allow(missing_docs)] // documentation missing in model
    ActivationKeyInvalid,
    #[allow(missing_docs)] // documentation missing in model
    ActivationKeyNotFound,
    #[allow(missing_docs)] // documentation missing in model
    AuthenticationFailure,
    #[allow(missing_docs)] // documentation missing in model
    BandwidthThrottleScheduleNotFound,
    #[allow(missing_docs)] // documentation missing in model
    Blocked,
    #[allow(missing_docs)] // documentation missing in model
    CannotExportSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    ChapCredentialNotFound,
    #[allow(missing_docs)] // documentation missing in model
    DiskAlreadyAllocated,
    #[allow(missing_docs)] // documentation missing in model
    DiskDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    DiskSizeGreaterThanVolumeMaxSize,
    #[allow(missing_docs)] // documentation missing in model
    DiskSizeLessThanVolumeSize,
    #[allow(missing_docs)] // documentation missing in model
    DiskSizeNotGigAligned,
    #[allow(missing_docs)] // documentation missing in model
    DuplicateCertificateInfo,
    #[allow(missing_docs)] // documentation missing in model
    DuplicateSchedule,
    #[allow(missing_docs)] // documentation missing in model
    EndpointNotFound,
    #[allow(missing_docs)] // documentation missing in model
    GatewayInternalError,
    #[allow(missing_docs)] // documentation missing in model
    GatewayNotConnected,
    #[allow(missing_docs)] // documentation missing in model
    GatewayNotFound,
    #[allow(missing_docs)] // documentation missing in model
    GatewayProxyNetworkConnectionBusy,
    #[allow(missing_docs)] // documentation missing in model
    IamNotSupported,
    #[allow(missing_docs)] // documentation missing in model
    InitiatorInvalid,
    #[allow(missing_docs)] // documentation missing in model
    InitiatorNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    InvalidGateway,
    #[allow(missing_docs)] // documentation missing in model
    InvalidParameters,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSchedule,
    #[allow(missing_docs)] // documentation missing in model
    JoinDomainInProgress,
    #[allow(missing_docs)] // documentation missing in model
    LocalStorageLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    LunAlreadyAllocated,
    #[allow(missing_docs)] // documentation missing in model
    LunInvalid,
    #[allow(missing_docs)] // documentation missing in model
    MaximumContentLengthExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MaximumTapeCartridgeCountExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MaximumVolumeCountExceeded,
    #[allow(missing_docs)] // documentation missing in model
    NetworkConfigurationChanged,
    #[allow(missing_docs)] // documentation missing in model
    NoDisksAvailable,
    #[allow(missing_docs)] // documentation missing in model
    NotImplemented,
    #[allow(missing_docs)] // documentation missing in model
    NotSupported,
    #[allow(missing_docs)] // documentation missing in model
    OperationAborted,
    #[allow(missing_docs)] // documentation missing in model
    OutdatedGateway,
    #[allow(missing_docs)] // documentation missing in model
    ParametersNotImplemented,
    #[allow(missing_docs)] // documentation missing in model
    RegionInvalid,
    #[allow(missing_docs)] // documentation missing in model
    RequestTimeout,
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotDeleted,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotIdInvalid,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotInProgress,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotNotFound,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotScheduleNotFound,
    #[allow(missing_docs)] // documentation missing in model
    StagingAreaFull,
    #[allow(missing_docs)] // documentation missing in model
    StorageFailure,
    #[allow(missing_docs)] // documentation missing in model
    TapeCartridgeNotFound,
    #[allow(missing_docs)] // documentation missing in model
    TargetAlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    TargetInvalid,
    #[allow(missing_docs)] // documentation missing in model
    TargetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedOperation,
    #[allow(missing_docs)] // documentation missing in model
    VolumeAlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    VolumeIdInvalid,
    #[allow(missing_docs)] // documentation missing in model
    VolumeInUse,
    #[allow(missing_docs)] // documentation missing in model
    VolumeNotFound,
    #[allow(missing_docs)] // documentation missing in model
    VolumeNotReady,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ActivationKeyExpired" => ErrorCode::ActivationKeyExpired,
            "ActivationKeyInvalid" => ErrorCode::ActivationKeyInvalid,
            "ActivationKeyNotFound" => ErrorCode::ActivationKeyNotFound,
            "AuthenticationFailure" => ErrorCode::AuthenticationFailure,
            "BandwidthThrottleScheduleNotFound" => ErrorCode::BandwidthThrottleScheduleNotFound,
            "Blocked" => ErrorCode::Blocked,
            "CannotExportSnapshot" => ErrorCode::CannotExportSnapshot,
            "ChapCredentialNotFound" => ErrorCode::ChapCredentialNotFound,
            "DiskAlreadyAllocated" => ErrorCode::DiskAlreadyAllocated,
            "DiskDoesNotExist" => ErrorCode::DiskDoesNotExist,
            "DiskSizeGreaterThanVolumeMaxSize" => ErrorCode::DiskSizeGreaterThanVolumeMaxSize,
            "DiskSizeLessThanVolumeSize" => ErrorCode::DiskSizeLessThanVolumeSize,
            "DiskSizeNotGigAligned" => ErrorCode::DiskSizeNotGigAligned,
            "DuplicateCertificateInfo" => ErrorCode::DuplicateCertificateInfo,
            "DuplicateSchedule" => ErrorCode::DuplicateSchedule,
            "EndpointNotFound" => ErrorCode::EndpointNotFound,
            "GatewayInternalError" => ErrorCode::GatewayInternalError,
            "GatewayNotConnected" => ErrorCode::GatewayNotConnected,
            "GatewayNotFound" => ErrorCode::GatewayNotFound,
            "GatewayProxyNetworkConnectionBusy" => ErrorCode::GatewayProxyNetworkConnectionBusy,
            "IAMNotSupported" => ErrorCode::IamNotSupported,
            "InitiatorInvalid" => ErrorCode::InitiatorInvalid,
            "InitiatorNotFound" => ErrorCode::InitiatorNotFound,
            "InternalError" => ErrorCode::InternalError,
            "InvalidEndpoint" => ErrorCode::InvalidEndpoint,
            "InvalidGateway" => ErrorCode::InvalidGateway,
            "InvalidParameters" => ErrorCode::InvalidParameters,
            "InvalidSchedule" => ErrorCode::InvalidSchedule,
            "JoinDomainInProgress" => ErrorCode::JoinDomainInProgress,
            "LocalStorageLimitExceeded" => ErrorCode::LocalStorageLimitExceeded,
            "LunAlreadyAllocated " => ErrorCode::LunAlreadyAllocated,
            "LunInvalid" => ErrorCode::LunInvalid,
            "MaximumContentLengthExceeded" => ErrorCode::MaximumContentLengthExceeded,
            "MaximumTapeCartridgeCountExceeded" => ErrorCode::MaximumTapeCartridgeCountExceeded,
            "MaximumVolumeCountExceeded" => ErrorCode::MaximumVolumeCountExceeded,
            "NetworkConfigurationChanged" => ErrorCode::NetworkConfigurationChanged,
            "NoDisksAvailable" => ErrorCode::NoDisksAvailable,
            "NotImplemented" => ErrorCode::NotImplemented,
            "NotSupported" => ErrorCode::NotSupported,
            "OperationAborted" => ErrorCode::OperationAborted,
            "OutdatedGateway" => ErrorCode::OutdatedGateway,
            "ParametersNotImplemented" => ErrorCode::ParametersNotImplemented,
            "RegionInvalid" => ErrorCode::RegionInvalid,
            "RequestTimeout" => ErrorCode::RequestTimeout,
            "ServiceUnavailable" => ErrorCode::ServiceUnavailable,
            "SnapshotDeleted" => ErrorCode::SnapshotDeleted,
            "SnapshotIdInvalid" => ErrorCode::SnapshotIdInvalid,
            "SnapshotInProgress" => ErrorCode::SnapshotInProgress,
            "SnapshotNotFound" => ErrorCode::SnapshotNotFound,
            "SnapshotScheduleNotFound" => ErrorCode::SnapshotScheduleNotFound,
            "StagingAreaFull" => ErrorCode::StagingAreaFull,
            "StorageFailure" => ErrorCode::StorageFailure,
            "TapeCartridgeNotFound" => ErrorCode::TapeCartridgeNotFound,
            "TargetAlreadyExists" => ErrorCode::TargetAlreadyExists,
            "TargetInvalid" => ErrorCode::TargetInvalid,
            "TargetNotFound" => ErrorCode::TargetNotFound,
            "UnauthorizedOperation" => ErrorCode::UnauthorizedOperation,
            "VolumeAlreadyExists" => ErrorCode::VolumeAlreadyExists,
            "VolumeIdInvalid" => ErrorCode::VolumeIdInvalid,
            "VolumeInUse" => ErrorCode::VolumeInUse,
            "VolumeNotFound" => ErrorCode::VolumeNotFound,
            "VolumeNotReady" => ErrorCode::VolumeNotReady,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::ActivationKeyExpired => "ActivationKeyExpired",
            ErrorCode::ActivationKeyInvalid => "ActivationKeyInvalid",
            ErrorCode::ActivationKeyNotFound => "ActivationKeyNotFound",
            ErrorCode::AuthenticationFailure => "AuthenticationFailure",
            ErrorCode::BandwidthThrottleScheduleNotFound => "BandwidthThrottleScheduleNotFound",
            ErrorCode::Blocked => "Blocked",
            ErrorCode::CannotExportSnapshot => "CannotExportSnapshot",
            ErrorCode::ChapCredentialNotFound => "ChapCredentialNotFound",
            ErrorCode::DiskAlreadyAllocated => "DiskAlreadyAllocated",
            ErrorCode::DiskDoesNotExist => "DiskDoesNotExist",
            ErrorCode::DiskSizeGreaterThanVolumeMaxSize => "DiskSizeGreaterThanVolumeMaxSize",
            ErrorCode::DiskSizeLessThanVolumeSize => "DiskSizeLessThanVolumeSize",
            ErrorCode::DiskSizeNotGigAligned => "DiskSizeNotGigAligned",
            ErrorCode::DuplicateCertificateInfo => "DuplicateCertificateInfo",
            ErrorCode::DuplicateSchedule => "DuplicateSchedule",
            ErrorCode::EndpointNotFound => "EndpointNotFound",
            ErrorCode::GatewayInternalError => "GatewayInternalError",
            ErrorCode::GatewayNotConnected => "GatewayNotConnected",
            ErrorCode::GatewayNotFound => "GatewayNotFound",
            ErrorCode::GatewayProxyNetworkConnectionBusy => "GatewayProxyNetworkConnectionBusy",
            ErrorCode::IamNotSupported => "IAMNotSupported",
            ErrorCode::InitiatorInvalid => "InitiatorInvalid",
            ErrorCode::InitiatorNotFound => "InitiatorNotFound",
            ErrorCode::InternalError => "InternalError",
            ErrorCode::InvalidEndpoint => "InvalidEndpoint",
            ErrorCode::InvalidGateway => "InvalidGateway",
            ErrorCode::InvalidParameters => "InvalidParameters",
            ErrorCode::InvalidSchedule => "InvalidSchedule",
            ErrorCode::JoinDomainInProgress => "JoinDomainInProgress",
            ErrorCode::LocalStorageLimitExceeded => "LocalStorageLimitExceeded",
            ErrorCode::LunAlreadyAllocated => "LunAlreadyAllocated ",
            ErrorCode::LunInvalid => "LunInvalid",
            ErrorCode::MaximumContentLengthExceeded => "MaximumContentLengthExceeded",
            ErrorCode::MaximumTapeCartridgeCountExceeded => "MaximumTapeCartridgeCountExceeded",
            ErrorCode::MaximumVolumeCountExceeded => "MaximumVolumeCountExceeded",
            ErrorCode::NetworkConfigurationChanged => "NetworkConfigurationChanged",
            ErrorCode::NoDisksAvailable => "NoDisksAvailable",
            ErrorCode::NotImplemented => "NotImplemented",
            ErrorCode::NotSupported => "NotSupported",
            ErrorCode::OperationAborted => "OperationAborted",
            ErrorCode::OutdatedGateway => "OutdatedGateway",
            ErrorCode::ParametersNotImplemented => "ParametersNotImplemented",
            ErrorCode::RegionInvalid => "RegionInvalid",
            ErrorCode::RequestTimeout => "RequestTimeout",
            ErrorCode::ServiceUnavailable => "ServiceUnavailable",
            ErrorCode::SnapshotDeleted => "SnapshotDeleted",
            ErrorCode::SnapshotIdInvalid => "SnapshotIdInvalid",
            ErrorCode::SnapshotInProgress => "SnapshotInProgress",
            ErrorCode::SnapshotNotFound => "SnapshotNotFound",
            ErrorCode::SnapshotScheduleNotFound => "SnapshotScheduleNotFound",
            ErrorCode::StagingAreaFull => "StagingAreaFull",
            ErrorCode::StorageFailure => "StorageFailure",
            ErrorCode::TapeCartridgeNotFound => "TapeCartridgeNotFound",
            ErrorCode::TargetAlreadyExists => "TargetAlreadyExists",
            ErrorCode::TargetInvalid => "TargetInvalid",
            ErrorCode::TargetNotFound => "TargetNotFound",
            ErrorCode::UnauthorizedOperation => "UnauthorizedOperation",
            ErrorCode::VolumeAlreadyExists => "VolumeAlreadyExists",
            ErrorCode::VolumeIdInvalid => "VolumeIdInvalid",
            ErrorCode::VolumeInUse => "VolumeInUse",
            ErrorCode::VolumeNotFound => "VolumeNotFound",
            ErrorCode::VolumeNotReady => "VolumeNotReady",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ActivationKeyExpired",
            "ActivationKeyInvalid",
            "ActivationKeyNotFound",
            "AuthenticationFailure",
            "BandwidthThrottleScheduleNotFound",
            "Blocked",
            "CannotExportSnapshot",
            "ChapCredentialNotFound",
            "DiskAlreadyAllocated",
            "DiskDoesNotExist",
            "DiskSizeGreaterThanVolumeMaxSize",
            "DiskSizeLessThanVolumeSize",
            "DiskSizeNotGigAligned",
            "DuplicateCertificateInfo",
            "DuplicateSchedule",
            "EndpointNotFound",
            "GatewayInternalError",
            "GatewayNotConnected",
            "GatewayNotFound",
            "GatewayProxyNetworkConnectionBusy",
            "IAMNotSupported",
            "InitiatorInvalid",
            "InitiatorNotFound",
            "InternalError",
            "InvalidEndpoint",
            "InvalidGateway",
            "InvalidParameters",
            "InvalidSchedule",
            "JoinDomainInProgress",
            "LocalStorageLimitExceeded",
            "LunAlreadyAllocated ",
            "LunInvalid",
            "MaximumContentLengthExceeded",
            "MaximumTapeCartridgeCountExceeded",
            "MaximumVolumeCountExceeded",
            "NetworkConfigurationChanged",
            "NoDisksAvailable",
            "NotImplemented",
            "NotSupported",
            "OperationAborted",
            "OutdatedGateway",
            "ParametersNotImplemented",
            "RegionInvalid",
            "RequestTimeout",
            "ServiceUnavailable",
            "SnapshotDeleted",
            "SnapshotIdInvalid",
            "SnapshotInProgress",
            "SnapshotNotFound",
            "SnapshotScheduleNotFound",
            "StagingAreaFull",
            "StorageFailure",
            "TapeCartridgeNotFound",
            "TargetAlreadyExists",
            "TargetInvalid",
            "TargetNotFound",
            "UnauthorizedOperation",
            "VolumeAlreadyExists",
            "VolumeIdInvalid",
            "VolumeInUse",
            "VolumeNotFound",
            "VolumeNotReady",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key-value pair that helps you manage, filter, and search for your resource. Allowed
/// characters: letters, white space, and numbers, representable in UTF-8, and the following
/// characters: + - = . _ : /.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Tag key. The key can't start with aws:.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Value of the tag key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Tag key. The key can't start with aws:.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Tag key. The key can't start with aws:.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Value of the tag key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Value of the tag key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmbSecurityStrategy {
    #[allow(missing_docs)] // documentation missing in model
    ClientSpecified,
    #[allow(missing_docs)] // documentation missing in model
    MandatoryEncryption,
    #[allow(missing_docs)] // documentation missing in model
    MandatorySigning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmbSecurityStrategy {
    fn from(s: &str) -> Self {
        match s {
            "ClientSpecified" => SmbSecurityStrategy::ClientSpecified,
            "MandatoryEncryption" => SmbSecurityStrategy::MandatoryEncryption,
            "MandatorySigning" => SmbSecurityStrategy::MandatorySigning,
            other => SmbSecurityStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmbSecurityStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmbSecurityStrategy::from(s))
    }
}
impl SmbSecurityStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmbSecurityStrategy::ClientSpecified => "ClientSpecified",
            SmbSecurityStrategy::MandatoryEncryption => "MandatoryEncryption",
            SmbSecurityStrategy::MandatorySigning => "MandatorySigning",
            SmbSecurityStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ClientSpecified", "MandatoryEncryption", "MandatorySigning"]
    }
}
impl AsRef<str> for SmbSecurityStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of Active Directory users and groups that have special permissions for SMB file
/// shares on the gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmbLocalGroups {
    /// <p>A list of Active Directory users and groups that have local Gateway Admin permissions.
    /// Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
    /// <code>DOMAIN\group1</code>, and <code>group1</code>.</p>
    /// <p>Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to
    /// force-close files that are open and locked.</p>
    pub gateway_admins: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SmbLocalGroups {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmbLocalGroups");
        formatter.field("gateway_admins", &self.gateway_admins);
        formatter.finish()
    }
}
/// See [`SmbLocalGroups`](crate::model::SmbLocalGroups)
pub mod smb_local_groups {
    /// A builder for [`SmbLocalGroups`](crate::model::SmbLocalGroups)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_admins: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `gateway_admins`.
        ///
        /// To override the contents of this collection use [`set_gateway_admins`](Self::set_gateway_admins).
        ///
        /// <p>A list of Active Directory users and groups that have local Gateway Admin permissions.
        /// Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
        /// <code>DOMAIN\group1</code>, and <code>group1</code>.</p>
        /// <p>Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to
        /// force-close files that are open and locked.</p>
        pub fn gateway_admins(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.gateway_admins.unwrap_or_default();
            v.push(input.into());
            self.gateway_admins = Some(v);
            self
        }
        /// <p>A list of Active Directory users and groups that have local Gateway Admin permissions.
        /// Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
        /// <code>DOMAIN\group1</code>, and <code>group1</code>.</p>
        /// <p>Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to
        /// force-close files that are open and locked.</p>
        pub fn set_gateway_admins(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.gateway_admins = input;
            self
        }
        /// Consumes the builder and constructs a [`SmbLocalGroups`](crate::model::SmbLocalGroups)
        pub fn build(self) -> crate::model::SmbLocalGroups {
            crate::model::SmbLocalGroups {
                gateway_admins: self.gateway_admins,
            }
        }
    }
}
impl SmbLocalGroups {
    /// Creates a new builder-style object to manufacture [`SmbLocalGroups`](crate::model::SmbLocalGroups)
    pub fn builder() -> crate::model::smb_local_groups::Builder {
        crate::model::smb_local_groups::Builder::default()
    }
}

/// <p>The refresh cache information for the file share or FSx file systems.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheAttributes {
    /// <p>Refreshes a file share's cache by using Time To Live (TTL). TTL is the length of
    /// time since the last refresh after which access to the directory would cause the file
    /// gateway to first refresh that directory's contents from the Amazon S3 bucket
    /// or Amazon FSx file system. The TTL duration is in seconds.</p>
    ///
    /// <p>Valid Values:0, 300 to 2,592,000 seconds (5 minutes to 30 days)</p>
    pub cache_stale_timeout_in_seconds: std::option::Option<i32>,
}
impl std::fmt::Debug for CacheAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheAttributes");
        formatter.field(
            "cache_stale_timeout_in_seconds",
            &self.cache_stale_timeout_in_seconds,
        );
        formatter.finish()
    }
}
/// See [`CacheAttributes`](crate::model::CacheAttributes)
pub mod cache_attributes {
    /// A builder for [`CacheAttributes`](crate::model::CacheAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_stale_timeout_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Refreshes a file share's cache by using Time To Live (TTL). TTL is the length of
        /// time since the last refresh after which access to the directory would cause the file
        /// gateway to first refresh that directory's contents from the Amazon S3 bucket
        /// or Amazon FSx file system. The TTL duration is in seconds.</p>
        ///
        /// <p>Valid Values:0, 300 to 2,592,000 seconds (5 minutes to 30 days)</p>
        pub fn cache_stale_timeout_in_seconds(mut self, input: i32) -> Self {
            self.cache_stale_timeout_in_seconds = Some(input);
            self
        }
        /// <p>Refreshes a file share's cache by using Time To Live (TTL). TTL is the length of
        /// time since the last refresh after which access to the directory would cause the file
        /// gateway to first refresh that directory's contents from the Amazon S3 bucket
        /// or Amazon FSx file system. The TTL duration is in seconds.</p>
        ///
        /// <p>Valid Values:0, 300 to 2,592,000 seconds (5 minutes to 30 days)</p>
        pub fn set_cache_stale_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.cache_stale_timeout_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheAttributes`](crate::model::CacheAttributes)
        pub fn build(self) -> crate::model::CacheAttributes {
            crate::model::CacheAttributes {
                cache_stale_timeout_in_seconds: self.cache_stale_timeout_in_seconds,
            }
        }
    }
}
impl CacheAttributes {
    /// Creates a new builder-style object to manufacture [`CacheAttributes`](crate::model::CacheAttributes)
    pub fn builder() -> crate::model::cache_attributes::Builder {
        crate::model::cache_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CaseSensitivity {
    #[allow(missing_docs)] // documentation missing in model
    CaseSensitive,
    #[allow(missing_docs)] // documentation missing in model
    ClientSpecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CaseSensitivity {
    fn from(s: &str) -> Self {
        match s {
            "CaseSensitive" => CaseSensitivity::CaseSensitive,
            "ClientSpecified" => CaseSensitivity::ClientSpecified,
            other => CaseSensitivity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CaseSensitivity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CaseSensitivity::from(s))
    }
}
impl CaseSensitivity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CaseSensitivity::CaseSensitive => "CaseSensitive",
            CaseSensitivity::ClientSpecified => "ClientSpecified",
            CaseSensitivity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CaseSensitive", "ClientSpecified"]
    }
}
impl AsRef<str> for CaseSensitivity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
/// that an S3 File Gateway puts objects into. The default value is
/// <code>private</code>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectAcl {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    AwsExecRead,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerFullControl,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerRead,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectAcl {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => ObjectAcl::AuthenticatedRead,
            "aws-exec-read" => ObjectAcl::AwsExecRead,
            "bucket-owner-full-control" => ObjectAcl::BucketOwnerFullControl,
            "bucket-owner-read" => ObjectAcl::BucketOwnerRead,
            "private" => ObjectAcl::Private,
            "public-read" => ObjectAcl::PublicRead,
            "public-read-write" => ObjectAcl::PublicReadWrite,
            other => ObjectAcl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectAcl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectAcl::from(s))
    }
}
impl ObjectAcl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectAcl::AuthenticatedRead => "authenticated-read",
            ObjectAcl::AwsExecRead => "aws-exec-read",
            ObjectAcl::BucketOwnerFullControl => "bucket-owner-full-control",
            ObjectAcl::BucketOwnerRead => "bucket-owner-read",
            ObjectAcl::Private => "private",
            ObjectAcl::PublicRead => "public-read",
            ObjectAcl::PublicReadWrite => "public-read-write",
            ObjectAcl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "aws-exec-read",
            "bucket-owner-full-control",
            "bucket-owner-read",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for ObjectAcl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes Network File System (NFS) file share default values. Files and folders stored
/// as Amazon S3 objects in S3 buckets don't, by default, have Unix file
/// permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3
/// objects that represent files and folders are assigned these default Unix permissions. This
/// operation is only supported for S3 File Gateways.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NfsFileShareDefaults {
    /// <p>The Unix file mode in the form "nnnn". For example, <code>0666</code> represents the
    /// default file mode inside the file share. The default value is <code>0666</code>.</p>
    pub file_mode: std::option::Option<std::string::String>,
    /// <p>The Unix directory mode in the form "nnnn". For example, <code>0666</code> represents
    /// the default access mode for all directories inside the file share. The default value is
    /// <code>0777</code>.</p>
    pub directory_mode: std::option::Option<std::string::String>,
    /// <p>The default group ID for the file share (unless the files have another group ID
    /// specified). The default value is <code>nfsnobody</code>.</p>
    pub group_id: std::option::Option<i64>,
    /// <p>The default owner ID for files in the file share (unless the files have another owner ID
    /// specified). The default value is <code>nfsnobody</code>.</p>
    pub owner_id: std::option::Option<i64>,
}
impl std::fmt::Debug for NfsFileShareDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NfsFileShareDefaults");
        formatter.field("file_mode", &self.file_mode);
        formatter.field("directory_mode", &self.directory_mode);
        formatter.field("group_id", &self.group_id);
        formatter.field("owner_id", &self.owner_id);
        formatter.finish()
    }
}
/// See [`NfsFileShareDefaults`](crate::model::NfsFileShareDefaults)
pub mod nfs_file_share_defaults {
    /// A builder for [`NfsFileShareDefaults`](crate::model::NfsFileShareDefaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_mode: std::option::Option<std::string::String>,
        pub(crate) directory_mode: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<i64>,
        pub(crate) owner_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Unix file mode in the form "nnnn". For example, <code>0666</code> represents the
        /// default file mode inside the file share. The default value is <code>0666</code>.</p>
        pub fn file_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_mode = Some(input.into());
            self
        }
        /// <p>The Unix file mode in the form "nnnn". For example, <code>0666</code> represents the
        /// default file mode inside the file share. The default value is <code>0666</code>.</p>
        pub fn set_file_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_mode = input;
            self
        }
        /// <p>The Unix directory mode in the form "nnnn". For example, <code>0666</code> represents
        /// the default access mode for all directories inside the file share. The default value is
        /// <code>0777</code>.</p>
        pub fn directory_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_mode = Some(input.into());
            self
        }
        /// <p>The Unix directory mode in the form "nnnn". For example, <code>0666</code> represents
        /// the default access mode for all directories inside the file share. The default value is
        /// <code>0777</code>.</p>
        pub fn set_directory_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_mode = input;
            self
        }
        /// <p>The default group ID for the file share (unless the files have another group ID
        /// specified). The default value is <code>nfsnobody</code>.</p>
        pub fn group_id(mut self, input: i64) -> Self {
            self.group_id = Some(input);
            self
        }
        /// <p>The default group ID for the file share (unless the files have another group ID
        /// specified). The default value is <code>nfsnobody</code>.</p>
        pub fn set_group_id(mut self, input: std::option::Option<i64>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The default owner ID for files in the file share (unless the files have another owner ID
        /// specified). The default value is <code>nfsnobody</code>.</p>
        pub fn owner_id(mut self, input: i64) -> Self {
            self.owner_id = Some(input);
            self
        }
        /// <p>The default owner ID for files in the file share (unless the files have another owner ID
        /// specified). The default value is <code>nfsnobody</code>.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<i64>) -> Self {
            self.owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NfsFileShareDefaults`](crate::model::NfsFileShareDefaults)
        pub fn build(self) -> crate::model::NfsFileShareDefaults {
            crate::model::NfsFileShareDefaults {
                file_mode: self.file_mode,
                directory_mode: self.directory_mode,
                group_id: self.group_id,
                owner_id: self.owner_id,
            }
        }
    }
}
impl NfsFileShareDefaults {
    /// Creates a new builder-style object to manufacture [`NfsFileShareDefaults`](crate::model::NfsFileShareDefaults)
    pub fn builder() -> crate::model::nfs_file_share_defaults::Builder {
        crate::model::nfs_file_share_defaults::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GatewayCapacity {
    #[allow(missing_docs)] // documentation missing in model
    Large,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Small,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GatewayCapacity {
    fn from(s: &str) -> Self {
        match s {
            "Large" => GatewayCapacity::Large,
            "Medium" => GatewayCapacity::Medium,
            "Small" => GatewayCapacity::Small,
            other => GatewayCapacity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GatewayCapacity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GatewayCapacity::from(s))
    }
}
impl GatewayCapacity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GatewayCapacity::Large => "Large",
            GatewayCapacity::Medium => "Medium",
            GatewayCapacity::Small => "Small",
            GatewayCapacity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Large", "Medium", "Small"]
    }
}
impl AsRef<str> for GatewayCapacity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Describes a bandwidth rate limit interval for a gateway. A bandwidth rate limit
/// schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit
/// interval defines a period of time on one or more days of the week, during which bandwidth
/// rate limits are specified for uploading, downloading, or both. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BandwidthRateLimitInterval {
    /// <p> The hour of the day to start the bandwidth rate limit interval. </p>
    pub start_hour_of_day: std::option::Option<i32>,
    /// <p> The minute of the hour to start the bandwidth rate limit interval. The interval begins
    /// at the start of that minute. To begin an interval exactly at the start of the hour, use the
    /// value <code>0</code>. </p>
    pub start_minute_of_hour: std::option::Option<i32>,
    /// <p> The hour of the day to end the bandwidth rate limit interval. </p>
    pub end_hour_of_day: std::option::Option<i32>,
    /// <p> The minute of the hour to end the bandwidth rate limit interval. </p>
    ///
    /// <important>
    /// <p> The bandwidth rate limit interval ends at the end of the minute. To end an interval
    /// at the end of an hour, use the value <code>59</code>. </p>
    /// </important>
    pub end_minute_of_hour: std::option::Option<i32>,
    /// <p> The days of the week component of the bandwidth rate limit interval, represented as
    /// ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday. </p>
    pub days_of_week: std::option::Option<std::vec::Vec<i32>>,
    /// <p> The average upload rate limit component of the bandwidth rate limit interval, in bits
    /// per second. This field does not appear in the response if the upload rate limit is not set.
    /// </p>
    pub average_upload_rate_limit_in_bits_per_sec: std::option::Option<i64>,
    /// <p> The average download rate limit component of the bandwidth rate limit interval, in bits
    /// per second. This field does not appear in the response if the download rate limit is not
    /// set. </p>
    pub average_download_rate_limit_in_bits_per_sec: std::option::Option<i64>,
}
impl std::fmt::Debug for BandwidthRateLimitInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BandwidthRateLimitInterval");
        formatter.field("start_hour_of_day", &self.start_hour_of_day);
        formatter.field("start_minute_of_hour", &self.start_minute_of_hour);
        formatter.field("end_hour_of_day", &self.end_hour_of_day);
        formatter.field("end_minute_of_hour", &self.end_minute_of_hour);
        formatter.field("days_of_week", &self.days_of_week);
        formatter.field(
            "average_upload_rate_limit_in_bits_per_sec",
            &self.average_upload_rate_limit_in_bits_per_sec,
        );
        formatter.field(
            "average_download_rate_limit_in_bits_per_sec",
            &self.average_download_rate_limit_in_bits_per_sec,
        );
        formatter.finish()
    }
}
/// See [`BandwidthRateLimitInterval`](crate::model::BandwidthRateLimitInterval)
pub mod bandwidth_rate_limit_interval {
    /// A builder for [`BandwidthRateLimitInterval`](crate::model::BandwidthRateLimitInterval)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_hour_of_day: std::option::Option<i32>,
        pub(crate) start_minute_of_hour: std::option::Option<i32>,
        pub(crate) end_hour_of_day: std::option::Option<i32>,
        pub(crate) end_minute_of_hour: std::option::Option<i32>,
        pub(crate) days_of_week: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) average_upload_rate_limit_in_bits_per_sec: std::option::Option<i64>,
        pub(crate) average_download_rate_limit_in_bits_per_sec: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> The hour of the day to start the bandwidth rate limit interval. </p>
        pub fn start_hour_of_day(mut self, input: i32) -> Self {
            self.start_hour_of_day = Some(input);
            self
        }
        /// <p> The hour of the day to start the bandwidth rate limit interval. </p>
        pub fn set_start_hour_of_day(mut self, input: std::option::Option<i32>) -> Self {
            self.start_hour_of_day = input;
            self
        }
        /// <p> The minute of the hour to start the bandwidth rate limit interval. The interval begins
        /// at the start of that minute. To begin an interval exactly at the start of the hour, use the
        /// value <code>0</code>. </p>
        pub fn start_minute_of_hour(mut self, input: i32) -> Self {
            self.start_minute_of_hour = Some(input);
            self
        }
        /// <p> The minute of the hour to start the bandwidth rate limit interval. The interval begins
        /// at the start of that minute. To begin an interval exactly at the start of the hour, use the
        /// value <code>0</code>. </p>
        pub fn set_start_minute_of_hour(mut self, input: std::option::Option<i32>) -> Self {
            self.start_minute_of_hour = input;
            self
        }
        /// <p> The hour of the day to end the bandwidth rate limit interval. </p>
        pub fn end_hour_of_day(mut self, input: i32) -> Self {
            self.end_hour_of_day = Some(input);
            self
        }
        /// <p> The hour of the day to end the bandwidth rate limit interval. </p>
        pub fn set_end_hour_of_day(mut self, input: std::option::Option<i32>) -> Self {
            self.end_hour_of_day = input;
            self
        }
        /// <p> The minute of the hour to end the bandwidth rate limit interval. </p>
        ///
        /// <important>
        /// <p> The bandwidth rate limit interval ends at the end of the minute. To end an interval
        /// at the end of an hour, use the value <code>59</code>. </p>
        /// </important>
        pub fn end_minute_of_hour(mut self, input: i32) -> Self {
            self.end_minute_of_hour = Some(input);
            self
        }
        /// <p> The minute of the hour to end the bandwidth rate limit interval. </p>
        ///
        /// <important>
        /// <p> The bandwidth rate limit interval ends at the end of the minute. To end an interval
        /// at the end of an hour, use the value <code>59</code>. </p>
        /// </important>
        pub fn set_end_minute_of_hour(mut self, input: std::option::Option<i32>) -> Self {
            self.end_minute_of_hour = input;
            self
        }
        /// Appends an item to `days_of_week`.
        ///
        /// To override the contents of this collection use [`set_days_of_week`](Self::set_days_of_week).
        ///
        /// <p> The days of the week component of the bandwidth rate limit interval, represented as
        /// ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday. </p>
        pub fn days_of_week(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.days_of_week.unwrap_or_default();
            v.push(input.into());
            self.days_of_week = Some(v);
            self
        }
        /// <p> The days of the week component of the bandwidth rate limit interval, represented as
        /// ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday. </p>
        pub fn set_days_of_week(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.days_of_week = input;
            self
        }
        /// <p> The average upload rate limit component of the bandwidth rate limit interval, in bits
        /// per second. This field does not appear in the response if the upload rate limit is not set.
        /// </p>
        pub fn average_upload_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.average_upload_rate_limit_in_bits_per_sec = Some(input);
            self
        }
        /// <p> The average upload rate limit component of the bandwidth rate limit interval, in bits
        /// per second. This field does not appear in the response if the upload rate limit is not set.
        /// </p>
        pub fn set_average_upload_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.average_upload_rate_limit_in_bits_per_sec = input;
            self
        }
        /// <p> The average download rate limit component of the bandwidth rate limit interval, in bits
        /// per second. This field does not appear in the response if the download rate limit is not
        /// set. </p>
        pub fn average_download_rate_limit_in_bits_per_sec(mut self, input: i64) -> Self {
            self.average_download_rate_limit_in_bits_per_sec = Some(input);
            self
        }
        /// <p> The average download rate limit component of the bandwidth rate limit interval, in bits
        /// per second. This field does not appear in the response if the download rate limit is not
        /// set. </p>
        pub fn set_average_download_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.average_download_rate_limit_in_bits_per_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`BandwidthRateLimitInterval`](crate::model::BandwidthRateLimitInterval)
        pub fn build(self) -> crate::model::BandwidthRateLimitInterval {
            crate::model::BandwidthRateLimitInterval {
                start_hour_of_day: self.start_hour_of_day,
                start_minute_of_hour: self.start_minute_of_hour,
                end_hour_of_day: self.end_hour_of_day,
                end_minute_of_hour: self.end_minute_of_hour,
                days_of_week: self.days_of_week,
                average_upload_rate_limit_in_bits_per_sec: self
                    .average_upload_rate_limit_in_bits_per_sec,
                average_download_rate_limit_in_bits_per_sec: self
                    .average_download_rate_limit_in_bits_per_sec,
            }
        }
    }
}
impl BandwidthRateLimitInterval {
    /// Creates a new builder-style object to manufacture [`BandwidthRateLimitInterval`](crate::model::BandwidthRateLimitInterval)
    pub fn builder() -> crate::model::bandwidth_rate_limit_interval::Builder {
        crate::model::bandwidth_rate_limit_interval::Builder::default()
    }
}

/// <p>An automatic tape creation policy consists of automatic tape creation rules where each
/// rule defines when and how to create new tapes. For more information about automatic tape
/// creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomaticTapeCreationRule {
    /// <p>A prefix that you append to the barcode of the virtual tape that you are creating. This
    /// prefix makes the barcode unique.</p>
    ///
    /// <note>
    /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
    /// from A to Z.</p>
    /// </note>
    pub tape_barcode_prefix: std::option::Option<std::string::String>,
    /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
    /// pool is archived in the Amazon S3 storage class that is associated with the pool.
    /// When you use your backup application to eject the tape, the tape is archived directly into
    /// the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the
    /// pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the virtual tape capacity.</p>
    pub tape_size_in_bytes: std::option::Option<i64>,
    /// <p>The minimum number of available virtual tapes that the gateway maintains at all times.
    /// If the number of tapes on the gateway goes below this value, the gateway creates as many
    /// new tapes as are needed to have <code>MinimumNumTapes</code> on the gateway. For more
    /// information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically</a>.</p>
    pub minimum_num_tapes: std::option::Option<i32>,
    /// <p>Set to <code>true</code> to indicate that tapes are to be archived as
    /// write-once-read-many (WORM). Set to <code>false</code> when WORM is not enabled for
    /// tapes.</p>
    pub worm: bool,
}
impl std::fmt::Debug for AutomaticTapeCreationRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomaticTapeCreationRule");
        formatter.field("tape_barcode_prefix", &self.tape_barcode_prefix);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("tape_size_in_bytes", &self.tape_size_in_bytes);
        formatter.field("minimum_num_tapes", &self.minimum_num_tapes);
        formatter.field("worm", &self.worm);
        formatter.finish()
    }
}
/// See [`AutomaticTapeCreationRule`](crate::model::AutomaticTapeCreationRule)
pub mod automatic_tape_creation_rule {
    /// A builder for [`AutomaticTapeCreationRule`](crate::model::AutomaticTapeCreationRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_barcode_prefix: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) tape_size_in_bytes: std::option::Option<i64>,
        pub(crate) minimum_num_tapes: std::option::Option<i32>,
        pub(crate) worm: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A prefix that you append to the barcode of the virtual tape that you are creating. This
        /// prefix makes the barcode unique.</p>
        ///
        /// <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
        /// from A to Z.</p>
        /// </note>
        pub fn tape_barcode_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_barcode_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that you append to the barcode of the virtual tape that you are creating. This
        /// prefix makes the barcode unique.</p>
        ///
        /// <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
        /// from A to Z.</p>
        /// </note>
        pub fn set_tape_barcode_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tape_barcode_prefix = input;
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the Amazon S3 storage class that is associated with the pool.
        /// When you use your backup application to eject the tape, the tape is archived directly into
        /// the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the
        /// pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the Amazon S3 storage class that is associated with the pool.
        /// When you use your backup application to eject the tape, the tape is archived directly into
        /// the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the
        /// pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The size, in bytes, of the virtual tape capacity.</p>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.tape_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tape capacity.</p>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_size_in_bytes = input;
            self
        }
        /// <p>The minimum number of available virtual tapes that the gateway maintains at all times.
        /// If the number of tapes on the gateway goes below this value, the gateway creates as many
        /// new tapes as are needed to have <code>MinimumNumTapes</code> on the gateway. For more
        /// information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically</a>.</p>
        pub fn minimum_num_tapes(mut self, input: i32) -> Self {
            self.minimum_num_tapes = Some(input);
            self
        }
        /// <p>The minimum number of available virtual tapes that the gateway maintains at all times.
        /// If the number of tapes on the gateway goes below this value, the gateway creates as many
        /// new tapes as are needed to have <code>MinimumNumTapes</code> on the gateway. For more
        /// information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically</a>.</p>
        pub fn set_minimum_num_tapes(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_num_tapes = input;
            self
        }
        /// <p>Set to <code>true</code> to indicate that tapes are to be archived as
        /// write-once-read-many (WORM). Set to <code>false</code> when WORM is not enabled for
        /// tapes.</p>
        pub fn worm(mut self, input: bool) -> Self {
            self.worm = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to indicate that tapes are to be archived as
        /// write-once-read-many (WORM). Set to <code>false</code> when WORM is not enabled for
        /// tapes.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.worm = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomaticTapeCreationRule`](crate::model::AutomaticTapeCreationRule)
        pub fn build(self) -> crate::model::AutomaticTapeCreationRule {
            crate::model::AutomaticTapeCreationRule {
                tape_barcode_prefix: self.tape_barcode_prefix,
                pool_id: self.pool_id,
                tape_size_in_bytes: self.tape_size_in_bytes,
                minimum_num_tapes: self.minimum_num_tapes,
                worm: self.worm.unwrap_or_default(),
            }
        }
    }
}
impl AutomaticTapeCreationRule {
    /// Creates a new builder-style object to manufacture [`AutomaticTapeCreationRule`](crate::model::AutomaticTapeCreationRule)
    pub fn builder() -> crate::model::automatic_tape_creation_rule::Builder {
        crate::model::automatic_tape_creation_rule::Builder::default()
    }
}

/// <p>Describes a storage volume object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeInfo {
    /// <p>The Amazon Resource Name (ARN) for the storage volume. For example, the following is a
    /// valid ARN:</p>
    ///
    /// <p>
    /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code>
    /// </p>
    ///
    /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier assigned to the volume. This ID becomes part of the volume Amazon
    /// Resource Name (ARN), which you use as input for other operations.</p>
    ///
    /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part
    /// of the gateway Amazon Resource Name (ARN), which you use as input for other
    /// operations.</p>
    ///
    /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>One of the VolumeType enumeration values describing the type of the volume.</p>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>The size of the volume in bytes.</p>
    ///
    /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
    pub volume_size_in_bytes: i64,
    /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
    pub volume_attachment_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VolumeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeInfo");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("volume_id", &self.volume_id);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("volume_size_in_bytes", &self.volume_size_in_bytes);
        formatter.field("volume_attachment_status", &self.volume_attachment_status);
        formatter.finish()
    }
}
/// See [`VolumeInfo`](crate::model::VolumeInfo)
pub mod volume_info {
    /// A builder for [`VolumeInfo`](crate::model::VolumeInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) volume_size_in_bytes: std::option::Option<i64>,
        pub(crate) volume_attachment_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the storage volume. For example, the following is a
        /// valid ARN:</p>
        ///
        /// <p>
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code>
        /// </p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the storage volume. For example, the following is a
        /// valid ARN:</p>
        ///
        /// <p>
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code>
        /// </p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The unique identifier assigned to the volume. This ID becomes part of the volume Amazon
        /// Resource Name (ARN), which you use as input for other operations.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the volume. This ID becomes part of the volume Amazon
        /// Resource Name (ARN), which you use as input for other operations.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part
        /// of the gateway Amazon Resource Name (ARN), which you use as input for other
        /// operations.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part
        /// of the gateway Amazon Resource Name (ARN), which you use as input for other
        /// operations.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>One of the VolumeType enumeration values describing the type of the volume.</p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>One of the VolumeType enumeration values describing the type of the volume.</p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>The size of the volume in bytes.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn volume_size_in_bytes(mut self, input: i64) -> Self {
            self.volume_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_size_in_bytes = input;
            self
        }
        /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
        pub fn volume_attachment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_attachment_status = Some(input.into());
            self
        }
        /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
        pub fn set_volume_attachment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_attachment_status = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeInfo`](crate::model::VolumeInfo)
        pub fn build(self) -> crate::model::VolumeInfo {
            crate::model::VolumeInfo {
                volume_arn: self.volume_arn,
                volume_id: self.volume_id,
                gateway_arn: self.gateway_arn,
                gateway_id: self.gateway_id,
                volume_type: self.volume_type,
                volume_size_in_bytes: self.volume_size_in_bytes.unwrap_or_default(),
                volume_attachment_status: self.volume_attachment_status,
            }
        }
    }
}
impl VolumeInfo {
    /// Creates a new builder-style object to manufacture [`VolumeInfo`](crate::model::VolumeInfo)
    pub fn builder() -> crate::model::volume_info::Builder {
        crate::model::volume_info::Builder::default()
    }
}

/// <p>Describes a storage volume recovery point object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeRecoveryPointInfo {
    /// <p>The Amazon Resource Name (ARN) of the volume target.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The size of the volume in bytes.</p>
    pub volume_size_in_bytes: i64,
    /// <p>The size of the data stored on the volume in bytes.</p>
    ///
    /// <note>
    /// <p>This value is not available for volumes created prior to May 13, 2015, until you
    /// store data on the volume.</p>
    /// </note>
    pub volume_usage_in_bytes: i64,
    /// <p>The time the recovery point was taken.</p>
    pub volume_recovery_point_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VolumeRecoveryPointInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeRecoveryPointInfo");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("volume_size_in_bytes", &self.volume_size_in_bytes);
        formatter.field("volume_usage_in_bytes", &self.volume_usage_in_bytes);
        formatter.field(
            "volume_recovery_point_time",
            &self.volume_recovery_point_time,
        );
        formatter.finish()
    }
}
/// See [`VolumeRecoveryPointInfo`](crate::model::VolumeRecoveryPointInfo)
pub mod volume_recovery_point_info {
    /// A builder for [`VolumeRecoveryPointInfo`](crate::model::VolumeRecoveryPointInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) volume_size_in_bytes: std::option::Option<i64>,
        pub(crate) volume_usage_in_bytes: std::option::Option<i64>,
        pub(crate) volume_recovery_point_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume target.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn volume_size_in_bytes(mut self, input: i64) -> Self {
            self.volume_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_size_in_bytes = input;
            self
        }
        /// <p>The size of the data stored on the volume in bytes.</p>
        ///
        /// <note>
        /// <p>This value is not available for volumes created prior to May 13, 2015, until you
        /// store data on the volume.</p>
        /// </note>
        pub fn volume_usage_in_bytes(mut self, input: i64) -> Self {
            self.volume_usage_in_bytes = Some(input);
            self
        }
        /// <p>The size of the data stored on the volume in bytes.</p>
        ///
        /// <note>
        /// <p>This value is not available for volumes created prior to May 13, 2015, until you
        /// store data on the volume.</p>
        /// </note>
        pub fn set_volume_usage_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_usage_in_bytes = input;
            self
        }
        /// <p>The time the recovery point was taken.</p>
        pub fn volume_recovery_point_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_recovery_point_time = Some(input.into());
            self
        }
        /// <p>The time the recovery point was taken.</p>
        pub fn set_volume_recovery_point_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_recovery_point_time = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeRecoveryPointInfo`](crate::model::VolumeRecoveryPointInfo)
        pub fn build(self) -> crate::model::VolumeRecoveryPointInfo {
            crate::model::VolumeRecoveryPointInfo {
                volume_arn: self.volume_arn,
                volume_size_in_bytes: self.volume_size_in_bytes.unwrap_or_default(),
                volume_usage_in_bytes: self.volume_usage_in_bytes.unwrap_or_default(),
                volume_recovery_point_time: self.volume_recovery_point_time,
            }
        }
    }
}
impl VolumeRecoveryPointInfo {
    /// Creates a new builder-style object to manufacture [`VolumeRecoveryPointInfo`](crate::model::VolumeRecoveryPointInfo)
    pub fn builder() -> crate::model::volume_recovery_point_info::Builder {
        crate::model::volume_recovery_point_info::Builder::default()
    }
}

/// <p>Describes a virtual tape.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TapeInfo {
    /// <p>The Amazon Resource Name (ARN) of a virtual tape.</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>The barcode that identifies a specific virtual tape.</p>
    pub tape_barcode: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of a virtual tape.</p>
    pub tape_size_in_bytes: std::option::Option<i64>,
    /// <p>The status of the tape.</p>
    pub tape_status: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
    /// pool is archived in the S3 storage class that is associated with the pool. When you use
    /// your backup application to eject the tape, the tape is archived directly into the storage
    /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The date that the tape became subject to tape retention lock.</p>
    pub retention_start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the tape entered the custom tape pool with tape retention lock
    /// enabled.</p>
    pub pool_entry_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for TapeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TapeInfo");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field("tape_barcode", &self.tape_barcode);
        formatter.field("tape_size_in_bytes", &self.tape_size_in_bytes);
        formatter.field("tape_status", &self.tape_status);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("retention_start_date", &self.retention_start_date);
        formatter.field("pool_entry_date", &self.pool_entry_date);
        formatter.finish()
    }
}
/// See [`TapeInfo`](crate::model::TapeInfo)
pub mod tape_info {
    /// A builder for [`TapeInfo`](crate::model::TapeInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) tape_barcode: std::option::Option<std::string::String>,
        pub(crate) tape_size_in_bytes: std::option::Option<i64>,
        pub(crate) tape_status: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) retention_start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pool_entry_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a virtual tape.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a virtual tape.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>The barcode that identifies a specific virtual tape.</p>
        pub fn tape_barcode(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_barcode = Some(input.into());
            self
        }
        /// <p>The barcode that identifies a specific virtual tape.</p>
        pub fn set_tape_barcode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_barcode = input;
            self
        }
        /// <p>The size, in bytes, of a virtual tape.</p>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.tape_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of a virtual tape.</p>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_size_in_bytes = input;
            self
        }
        /// <p>The status of the tape.</p>
        pub fn tape_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_status = Some(input.into());
            self
        }
        /// <p>The status of the tape.</p>
        pub fn set_tape_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The date that the tape became subject to tape retention lock.</p>
        pub fn retention_start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.retention_start_date = Some(input);
            self
        }
        /// <p>The date that the tape became subject to tape retention lock.</p>
        pub fn set_retention_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.retention_start_date = input;
            self
        }
        /// <p>The date that the tape entered the custom tape pool with tape retention lock
        /// enabled.</p>
        pub fn pool_entry_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pool_entry_date = Some(input);
            self
        }
        /// <p>The date that the tape entered the custom tape pool with tape retention lock
        /// enabled.</p>
        pub fn set_pool_entry_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pool_entry_date = input;
            self
        }
        /// Consumes the builder and constructs a [`TapeInfo`](crate::model::TapeInfo)
        pub fn build(self) -> crate::model::TapeInfo {
            crate::model::TapeInfo {
                tape_arn: self.tape_arn,
                tape_barcode: self.tape_barcode,
                tape_size_in_bytes: self.tape_size_in_bytes,
                tape_status: self.tape_status,
                gateway_arn: self.gateway_arn,
                pool_id: self.pool_id,
                retention_start_date: self.retention_start_date,
                pool_entry_date: self.pool_entry_date,
            }
        }
    }
}
impl TapeInfo {
    /// Creates a new builder-style object to manufacture [`TapeInfo`](crate::model::TapeInfo)
    pub fn builder() -> crate::model::tape_info::Builder {
        crate::model::tape_info::Builder::default()
    }
}

/// <p>Describes a custom tape pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PoolInfo {
    /// <p>The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to return a list of custom tape pools for your
    /// account and Amazon Web Services Region.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters,
    /// except '/' and '\'.</p>
    pub pool_name: std::option::Option<std::string::String>,
    /// <p>The storage class that is associated with the custom pool. When you use your backup
    /// application to eject the tape, the tape is archived directly into the storage class (S3
    /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    pub storage_class: std::option::Option<crate::model::TapeStorageClass>,
    /// <p>Tape retention lock type, which can be configured in two modes. When configured in
    /// governance mode, Amazon Web Services accounts with specific IAM permissions are authorized
    /// to remove the tape retention lock from archived virtual tapes. When configured in
    /// compliance mode, the tape retention lock cannot be removed by any user, including the root
    /// Amazon Web Services account.</p>
    pub retention_lock_type: std::option::Option<crate::model::RetentionLockType>,
    /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to
    /// 100 years (36,500 days).</p>
    pub retention_lock_time_in_days: std::option::Option<i32>,
    /// <p>Status of the custom tape pool. Pool can be <code>ACTIVE</code> or
    /// <code>DELETED</code>.</p>
    pub pool_status: std::option::Option<crate::model::PoolStatus>,
}
impl std::fmt::Debug for PoolInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PoolInfo");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_name", &self.pool_name);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("retention_lock_type", &self.retention_lock_type);
        formatter.field(
            "retention_lock_time_in_days",
            &self.retention_lock_time_in_days,
        );
        formatter.field("pool_status", &self.pool_status);
        formatter.finish()
    }
}
/// See [`PoolInfo`](crate::model::PoolInfo)
pub mod pool_info {
    /// A builder for [`PoolInfo`](crate::model::PoolInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_name: std::option::Option<std::string::String>,
        pub(crate) storage_class: std::option::Option<crate::model::TapeStorageClass>,
        pub(crate) retention_lock_type: std::option::Option<crate::model::RetentionLockType>,
        pub(crate) retention_lock_time_in_days: std::option::Option<i32>,
        pub(crate) pool_status: std::option::Option<crate::model::PoolStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to return a list of custom tape pools for your
        /// account and Amazon Web Services Region.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to return a list of custom tape pools for your
        /// account and Amazon Web Services Region.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters,
        /// except '/' and '\'.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_name = Some(input.into());
            self
        }
        /// <p>The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters,
        /// except '/' and '\'.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_name = input;
            self
        }
        /// <p>The storage class that is associated with the custom pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn storage_class(mut self, input: crate::model::TapeStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The storage class that is associated with the custom pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TapeStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>Tape retention lock type, which can be configured in two modes. When configured in
        /// governance mode, Amazon Web Services accounts with specific IAM permissions are authorized
        /// to remove the tape retention lock from archived virtual tapes. When configured in
        /// compliance mode, the tape retention lock cannot be removed by any user, including the root
        /// Amazon Web Services account.</p>
        pub fn retention_lock_type(mut self, input: crate::model::RetentionLockType) -> Self {
            self.retention_lock_type = Some(input);
            self
        }
        /// <p>Tape retention lock type, which can be configured in two modes. When configured in
        /// governance mode, Amazon Web Services accounts with specific IAM permissions are authorized
        /// to remove the tape retention lock from archived virtual tapes. When configured in
        /// compliance mode, the tape retention lock cannot be removed by any user, including the root
        /// Amazon Web Services account.</p>
        pub fn set_retention_lock_type(
            mut self,
            input: std::option::Option<crate::model::RetentionLockType>,
        ) -> Self {
            self.retention_lock_type = input;
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to
        /// 100 years (36,500 days).</p>
        pub fn retention_lock_time_in_days(mut self, input: i32) -> Self {
            self.retention_lock_time_in_days = Some(input);
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to
        /// 100 years (36,500 days).</p>
        pub fn set_retention_lock_time_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_lock_time_in_days = input;
            self
        }
        /// <p>Status of the custom tape pool. Pool can be <code>ACTIVE</code> or
        /// <code>DELETED</code>.</p>
        pub fn pool_status(mut self, input: crate::model::PoolStatus) -> Self {
            self.pool_status = Some(input);
            self
        }
        /// <p>Status of the custom tape pool. Pool can be <code>ACTIVE</code> or
        /// <code>DELETED</code>.</p>
        pub fn set_pool_status(
            mut self,
            input: std::option::Option<crate::model::PoolStatus>,
        ) -> Self {
            self.pool_status = input;
            self
        }
        /// Consumes the builder and constructs a [`PoolInfo`](crate::model::PoolInfo)
        pub fn build(self) -> crate::model::PoolInfo {
            crate::model::PoolInfo {
                pool_arn: self.pool_arn,
                pool_name: self.pool_name,
                storage_class: self.storage_class,
                retention_lock_type: self.retention_lock_type,
                retention_lock_time_in_days: self.retention_lock_time_in_days,
                pool_status: self.pool_status,
            }
        }
    }
}
impl PoolInfo {
    /// Creates a new builder-style object to manufacture [`PoolInfo`](crate::model::PoolInfo)
    pub fn builder() -> crate::model::pool_info::Builder {
        crate::model::pool_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PoolStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PoolStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => PoolStatus::Active,
            "DELETED" => PoolStatus::Deleted,
            other => PoolStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PoolStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PoolStatus::from(s))
    }
}
impl PoolStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PoolStatus::Active => "ACTIVE",
            PoolStatus::Deleted => "DELETED",
            PoolStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED"]
    }
}
impl AsRef<str> for PoolStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RetentionLockType {
    #[allow(missing_docs)] // documentation missing in model
    Compliance,
    #[allow(missing_docs)] // documentation missing in model
    Governance,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RetentionLockType {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANCE" => RetentionLockType::Compliance,
            "GOVERNANCE" => RetentionLockType::Governance,
            "NONE" => RetentionLockType::None,
            other => RetentionLockType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RetentionLockType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RetentionLockType::from(s))
    }
}
impl RetentionLockType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RetentionLockType::Compliance => "COMPLIANCE",
            RetentionLockType::Governance => "GOVERNANCE",
            RetentionLockType::None => "NONE",
            RetentionLockType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANCE", "GOVERNANCE", "NONE"]
    }
}
impl AsRef<str> for RetentionLockType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TapeStorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TapeStorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => TapeStorageClass::DeepArchive,
            "GLACIER" => TapeStorageClass::Glacier,
            other => TapeStorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TapeStorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TapeStorageClass::from(s))
    }
}
impl TapeStorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TapeStorageClass::DeepArchive => "DEEP_ARCHIVE",
            TapeStorageClass::Glacier => "GLACIER",
            TapeStorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEEP_ARCHIVE", "GLACIER"]
    }
}
impl AsRef<str> for TapeStorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a gateway's local disk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Disk {
    /// <p>The unique device ID or other distinguishing data that identifies a local disk.</p>
    pub disk_id: std::option::Option<std::string::String>,
    /// <p>The path of a local disk in the gateway virtual machine (VM).</p>
    pub disk_path: std::option::Option<std::string::String>,
    /// <p>The device node of a local disk as assigned by the virtualization environment.</p>
    pub disk_node: std::option::Option<std::string::String>,
    /// <p>A value that represents the status of a local disk.</p>
    pub disk_status: std::option::Option<std::string::String>,
    /// <p>The local disk size in bytes.</p>
    pub disk_size_in_bytes: i64,
    /// <p>One of the <code>DiskAllocationType</code> enumeration values that identifies how a
    /// local disk is used.</p>
    ///
    /// <p>Valid Values: <code>UPLOAD_BUFFER</code> | <code>CACHE_STORAGE</code>
    /// </p>
    pub disk_allocation_type: std::option::Option<std::string::String>,
    /// <p>The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in
    /// the response if the local disk is not defined as an iSCSI target. The format of this field
    /// is <i>targetIqn::LUNNumber::region-volumeId</i>.</p>
    pub disk_allocation_resource: std::option::Option<std::string::String>,
    /// <p>A list of values that represents attributes of a local disk.</p>
    pub disk_attribute_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Disk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Disk");
        formatter.field("disk_id", &self.disk_id);
        formatter.field("disk_path", &self.disk_path);
        formatter.field("disk_node", &self.disk_node);
        formatter.field("disk_status", &self.disk_status);
        formatter.field("disk_size_in_bytes", &self.disk_size_in_bytes);
        formatter.field("disk_allocation_type", &self.disk_allocation_type);
        formatter.field("disk_allocation_resource", &self.disk_allocation_resource);
        formatter.field("disk_attribute_list", &self.disk_attribute_list);
        formatter.finish()
    }
}
/// See [`Disk`](crate::model::Disk)
pub mod disk {
    /// A builder for [`Disk`](crate::model::Disk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_id: std::option::Option<std::string::String>,
        pub(crate) disk_path: std::option::Option<std::string::String>,
        pub(crate) disk_node: std::option::Option<std::string::String>,
        pub(crate) disk_status: std::option::Option<std::string::String>,
        pub(crate) disk_size_in_bytes: std::option::Option<i64>,
        pub(crate) disk_allocation_type: std::option::Option<std::string::String>,
        pub(crate) disk_allocation_resource: std::option::Option<std::string::String>,
        pub(crate) disk_attribute_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique device ID or other distinguishing data that identifies a local disk.</p>
        pub fn disk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_id = Some(input.into());
            self
        }
        /// <p>The unique device ID or other distinguishing data that identifies a local disk.</p>
        pub fn set_disk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_id = input;
            self
        }
        /// <p>The path of a local disk in the gateway virtual machine (VM).</p>
        pub fn disk_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_path = Some(input.into());
            self
        }
        /// <p>The path of a local disk in the gateway virtual machine (VM).</p>
        pub fn set_disk_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_path = input;
            self
        }
        /// <p>The device node of a local disk as assigned by the virtualization environment.</p>
        pub fn disk_node(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_node = Some(input.into());
            self
        }
        /// <p>The device node of a local disk as assigned by the virtualization environment.</p>
        pub fn set_disk_node(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_node = input;
            self
        }
        /// <p>A value that represents the status of a local disk.</p>
        pub fn disk_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_status = Some(input.into());
            self
        }
        /// <p>A value that represents the status of a local disk.</p>
        pub fn set_disk_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_status = input;
            self
        }
        /// <p>The local disk size in bytes.</p>
        pub fn disk_size_in_bytes(mut self, input: i64) -> Self {
            self.disk_size_in_bytes = Some(input);
            self
        }
        /// <p>The local disk size in bytes.</p>
        pub fn set_disk_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.disk_size_in_bytes = input;
            self
        }
        /// <p>One of the <code>DiskAllocationType</code> enumeration values that identifies how a
        /// local disk is used.</p>
        ///
        /// <p>Valid Values: <code>UPLOAD_BUFFER</code> | <code>CACHE_STORAGE</code>
        /// </p>
        pub fn disk_allocation_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_allocation_type = Some(input.into());
            self
        }
        /// <p>One of the <code>DiskAllocationType</code> enumeration values that identifies how a
        /// local disk is used.</p>
        ///
        /// <p>Valid Values: <code>UPLOAD_BUFFER</code> | <code>CACHE_STORAGE</code>
        /// </p>
        pub fn set_disk_allocation_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_allocation_type = input;
            self
        }
        /// <p>The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in
        /// the response if the local disk is not defined as an iSCSI target. The format of this field
        /// is <i>targetIqn::LUNNumber::region-volumeId</i>.</p>
        pub fn disk_allocation_resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_allocation_resource = Some(input.into());
            self
        }
        /// <p>The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in
        /// the response if the local disk is not defined as an iSCSI target. The format of this field
        /// is <i>targetIqn::LUNNumber::region-volumeId</i>.</p>
        pub fn set_disk_allocation_resource(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_allocation_resource = input;
            self
        }
        /// Appends an item to `disk_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_disk_attribute_list`](Self::set_disk_attribute_list).
        ///
        /// <p>A list of values that represents attributes of a local disk.</p>
        pub fn disk_attribute_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disk_attribute_list.unwrap_or_default();
            v.push(input.into());
            self.disk_attribute_list = Some(v);
            self
        }
        /// <p>A list of values that represents attributes of a local disk.</p>
        pub fn set_disk_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disk_attribute_list = input;
            self
        }
        /// Consumes the builder and constructs a [`Disk`](crate::model::Disk)
        pub fn build(self) -> crate::model::Disk {
            crate::model::Disk {
                disk_id: self.disk_id,
                disk_path: self.disk_path,
                disk_node: self.disk_node,
                disk_status: self.disk_status,
                disk_size_in_bytes: self.disk_size_in_bytes.unwrap_or_default(),
                disk_allocation_type: self.disk_allocation_type,
                disk_allocation_resource: self.disk_allocation_resource,
                disk_attribute_list: self.disk_attribute_list,
            }
        }
    }
}
impl Disk {
    /// Creates a new builder-style object to manufacture [`Disk`](crate::model::Disk)
    pub fn builder() -> crate::model::disk::Builder {
        crate::model::disk::Builder::default()
    }
}

/// <p>Describes a gateway object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayInfo {
    /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part
    /// of the gateway Amazon Resource Name (ARN), which you use as input for other
    /// operations.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The type of the gateway.</p>
    pub gateway_type: std::option::Option<std::string::String>,
    /// <p>The state of the gateway.</p>
    ///
    /// <p>Valid Values: <code>DISABLED</code> | <code>ACTIVE</code>
    /// </p>
    pub gateway_operational_state: std::option::Option<std::string::String>,
    /// <p>The name of the gateway.</p>
    pub gateway_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
    pub ec2_instance_region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GatewayInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayInfo");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("gateway_type", &self.gateway_type);
        formatter.field("gateway_operational_state", &self.gateway_operational_state);
        formatter.field("gateway_name", &self.gateway_name);
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("ec2_instance_region", &self.ec2_instance_region);
        formatter.finish()
    }
}
/// See [`GatewayInfo`](crate::model::GatewayInfo)
pub mod gateway_info {
    /// A builder for [`GatewayInfo`](crate::model::GatewayInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_type: std::option::Option<std::string::String>,
        pub(crate) gateway_operational_state: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part
        /// of the gateway Amazon Resource Name (ARN), which you use as input for other
        /// operations.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to your gateway during activation. This ID becomes part
        /// of the gateway Amazon Resource Name (ARN), which you use as input for other
        /// operations.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The type of the gateway.</p>
        pub fn gateway_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_type = Some(input.into());
            self
        }
        /// <p>The type of the gateway.</p>
        pub fn set_gateway_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_type = input;
            self
        }
        /// <p>The state of the gateway.</p>
        ///
        /// <p>Valid Values: <code>DISABLED</code> | <code>ACTIVE</code>
        /// </p>
        pub fn gateway_operational_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_operational_state = Some(input.into());
            self
        }
        /// <p>The state of the gateway.</p>
        ///
        /// <p>Valid Values: <code>DISABLED</code> | <code>ACTIVE</code>
        /// </p>
        pub fn set_gateway_operational_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_operational_state = input;
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
        pub fn ec2_instance_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the Amazon EC2 instance is located.</p>
        pub fn set_ec2_instance_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_region = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayInfo`](crate::model::GatewayInfo)
        pub fn build(self) -> crate::model::GatewayInfo {
            crate::model::GatewayInfo {
                gateway_id: self.gateway_id,
                gateway_arn: self.gateway_arn,
                gateway_type: self.gateway_type,
                gateway_operational_state: self.gateway_operational_state,
                gateway_name: self.gateway_name,
                ec2_instance_id: self.ec2_instance_id,
                ec2_instance_region: self.ec2_instance_region,
            }
        }
    }
}
impl GatewayInfo {
    /// Creates a new builder-style object to manufacture [`GatewayInfo`](crate::model::GatewayInfo)
    pub fn builder() -> crate::model::gateway_info::Builder {
        crate::model::gateway_info::Builder::default()
    }
}

/// <p>Gets the summary returned by <code>ListFileSystemAssociation</code>, which is a summary
/// of a created file system association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemAssociationSummary {
    /// <p>The ID of the file system association.</p>
    pub file_system_association_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the file system association.</p>
    pub file_system_association_arn: std::option::Option<std::string::String>,
    /// <p>The status of the file share. Valid Values: <code>AVAILABLE</code> |
    /// <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> |
    /// <code>UPDATING</code> | <code>ERROR</code>
    /// </p>
    pub file_system_association_status: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FileSystemAssociationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemAssociationSummary");
        formatter.field(
            "file_system_association_id",
            &self.file_system_association_id,
        );
        formatter.field(
            "file_system_association_arn",
            &self.file_system_association_arn,
        );
        formatter.field(
            "file_system_association_status",
            &self.file_system_association_status,
        );
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`FileSystemAssociationSummary`](crate::model::FileSystemAssociationSummary)
pub mod file_system_association_summary {
    /// A builder for [`FileSystemAssociationSummary`](crate::model::FileSystemAssociationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_id: std::option::Option<std::string::String>,
        pub(crate) file_system_association_arn: std::option::Option<std::string::String>,
        pub(crate) file_system_association_status: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the file system association.</p>
        pub fn file_system_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_association_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system association.</p>
        pub fn set_file_system_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = input;
            self
        }
        /// <p>The status of the file share. Valid Values: <code>AVAILABLE</code> |
        /// <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> |
        /// <code>UPDATING</code> | <code>ERROR</code>
        /// </p>
        pub fn file_system_association_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_status = Some(input.into());
            self
        }
        /// <p>The status of the file share. Valid Values: <code>AVAILABLE</code> |
        /// <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> |
        /// <code>UPDATING</code> | <code>ERROR</code>
        /// </p>
        pub fn set_file_system_association_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemAssociationSummary`](crate::model::FileSystemAssociationSummary)
        pub fn build(self) -> crate::model::FileSystemAssociationSummary {
            crate::model::FileSystemAssociationSummary {
                file_system_association_id: self.file_system_association_id,
                file_system_association_arn: self.file_system_association_arn,
                file_system_association_status: self.file_system_association_status,
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl FileSystemAssociationSummary {
    /// Creates a new builder-style object to manufacture [`FileSystemAssociationSummary`](crate::model::FileSystemAssociationSummary)
    pub fn builder() -> crate::model::file_system_association_summary::Builder {
        crate::model::file_system_association_summary::Builder::default()
    }
}

/// <p>Describes a file share. Only supported S3 File Gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileShareInfo {
    /// <p>The type of the file share.</p>
    pub file_share_type: std::option::Option<crate::model::FileShareType>,
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the file share.</p>
    pub file_share_id: std::option::Option<std::string::String>,
    /// <p>The status of the file share.</p>
    ///
    /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
    /// <code>DELETING</code>
    /// </p>
    pub file_share_status: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FileShareInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileShareInfo");
        formatter.field("file_share_type", &self.file_share_type);
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("file_share_id", &self.file_share_id);
        formatter.field("file_share_status", &self.file_share_status);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`FileShareInfo`](crate::model::FileShareInfo)
pub mod file_share_info {
    /// A builder for [`FileShareInfo`](crate::model::FileShareInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_type: std::option::Option<crate::model::FileShareType>,
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) file_share_id: std::option::Option<std::string::String>,
        pub(crate) file_share_status: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the file share.</p>
        pub fn file_share_type(mut self, input: crate::model::FileShareType) -> Self {
            self.file_share_type = Some(input);
            self
        }
        /// <p>The type of the file share.</p>
        pub fn set_file_share_type(
            mut self,
            input: std::option::Option<crate::model::FileShareType>,
        ) -> Self {
            self.file_share_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>The ID of the file share.</p>
        pub fn file_share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_id = Some(input.into());
            self
        }
        /// <p>The ID of the file share.</p>
        pub fn set_file_share_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_id = input;
            self
        }
        /// <p>The status of the file share.</p>
        ///
        /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
        /// <code>DELETING</code>
        /// </p>
        pub fn file_share_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_status = Some(input.into());
            self
        }
        /// <p>The status of the file share.</p>
        ///
        /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
        /// <code>DELETING</code>
        /// </p>
        pub fn set_file_share_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`FileShareInfo`](crate::model::FileShareInfo)
        pub fn build(self) -> crate::model::FileShareInfo {
            crate::model::FileShareInfo {
                file_share_type: self.file_share_type,
                file_share_arn: self.file_share_arn,
                file_share_id: self.file_share_id,
                file_share_status: self.file_share_status,
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl FileShareInfo {
    /// Creates a new builder-style object to manufacture [`FileShareInfo`](crate::model::FileShareInfo)
    pub fn builder() -> crate::model::file_share_info::Builder {
        crate::model::file_share_info::Builder::default()
    }
}

/// <p>The type of the file share.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileShareType {
    #[allow(missing_docs)] // documentation missing in model
    Nfs,
    #[allow(missing_docs)] // documentation missing in model
    Smb,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileShareType {
    fn from(s: &str) -> Self {
        match s {
            "NFS" => FileShareType::Nfs,
            "SMB" => FileShareType::Smb,
            other => FileShareType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileShareType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileShareType::from(s))
    }
}
impl FileShareType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileShareType::Nfs => "NFS",
            FileShareType::Smb => "SMB",
            FileShareType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NFS", "SMB"]
    }
}
impl AsRef<str> for FileShareType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the gateway's automatic tape creation policies, including the
/// automatic tape creation rules and the gateway that is using the policies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomaticTapeCreationPolicyInfo {
    /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
    /// This returns the rules that determine when and how to automatically create new
    /// tapes.</p>
    pub automatic_tape_creation_rules:
        std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomaticTapeCreationPolicyInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomaticTapeCreationPolicyInfo");
        formatter.field(
            "automatic_tape_creation_rules",
            &self.automatic_tape_creation_rules,
        );
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`AutomaticTapeCreationPolicyInfo`](crate::model::AutomaticTapeCreationPolicyInfo)
pub mod automatic_tape_creation_policy_info {
    /// A builder for [`AutomaticTapeCreationPolicyInfo`](crate::model::AutomaticTapeCreationPolicyInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatic_tape_creation_rules:
            std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `automatic_tape_creation_rules`.
        ///
        /// To override the contents of this collection use [`set_automatic_tape_creation_rules`](Self::set_automatic_tape_creation_rules).
        ///
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
        /// This returns the rules that determine when and how to automatically create new
        /// tapes.</p>
        pub fn automatic_tape_creation_rules(
            mut self,
            input: impl Into<crate::model::AutomaticTapeCreationRule>,
        ) -> Self {
            let mut v = self.automatic_tape_creation_rules.unwrap_or_default();
            v.push(input.into());
            self.automatic_tape_creation_rules = Some(v);
            self
        }
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
        /// This returns the rules that determine when and how to automatically create new
        /// tapes.</p>
        pub fn set_automatic_tape_creation_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
        ) -> Self {
            self.automatic_tape_creation_rules = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomaticTapeCreationPolicyInfo`](crate::model::AutomaticTapeCreationPolicyInfo)
        pub fn build(self) -> crate::model::AutomaticTapeCreationPolicyInfo {
            crate::model::AutomaticTapeCreationPolicyInfo {
                automatic_tape_creation_rules: self.automatic_tape_creation_rules,
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl AutomaticTapeCreationPolicyInfo {
    /// Creates a new builder-style object to manufacture [`AutomaticTapeCreationPolicyInfo`](crate::model::AutomaticTapeCreationPolicyInfo)
    pub fn builder() -> crate::model::automatic_tape_creation_policy_info::Builder {
        crate::model::automatic_tape_creation_policy_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActiveDirectoryStatus {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    Detached,
    #[allow(missing_docs)] // documentation missing in model
    Joined,
    #[allow(missing_docs)] // documentation missing in model
    Joining,
    #[allow(missing_docs)] // documentation missing in model
    NetworkError,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    #[allow(missing_docs)] // documentation missing in model
    UnknownError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActiveDirectoryStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => ActiveDirectoryStatus::AccessDenied,
            "DETACHED" => ActiveDirectoryStatus::Detached,
            "JOINED" => ActiveDirectoryStatus::Joined,
            "JOINING" => ActiveDirectoryStatus::Joining,
            "NETWORK_ERROR" => ActiveDirectoryStatus::NetworkError,
            "TIMEOUT" => ActiveDirectoryStatus::Timeout,
            "UNKNOWN_ERROR" => ActiveDirectoryStatus::UnknownError,
            other => ActiveDirectoryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActiveDirectoryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActiveDirectoryStatus::from(s))
    }
}
impl ActiveDirectoryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActiveDirectoryStatus::AccessDenied => "ACCESS_DENIED",
            ActiveDirectoryStatus::Detached => "DETACHED",
            ActiveDirectoryStatus::Joined => "JOINED",
            ActiveDirectoryStatus::Joining => "JOINING",
            ActiveDirectoryStatus::NetworkError => "NETWORK_ERROR",
            ActiveDirectoryStatus::Timeout => "TIMEOUT",
            ActiveDirectoryStatus::UnknownError => "UNKNOWN_ERROR",
            ActiveDirectoryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "DETACHED",
            "JOINED",
            "JOINING",
            "NETWORK_ERROR",
            "TIMEOUT",
            "UNKNOWN_ERROR",
        ]
    }
}
impl AsRef<str> for ActiveDirectoryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a device object associated with a tape gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VtlDevice {
    /// <p>Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media
    /// changer).</p>
    pub vtl_device_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the type of device that the VTL device emulates.</p>
    pub vtl_device_type: std::option::Option<std::string::String>,
    /// <p>Specifies the vendor of the device that the VTL device object emulates.</p>
    pub vtl_device_vendor: std::option::Option<std::string::String>,
    /// <p>Specifies the model number of device that the VTL device emulates.</p>
    pub vtl_device_product_identifier: std::option::Option<std::string::String>,
    /// <p>A list of iSCSI information about a VTL device.</p>
    pub devicei_scsi_attributes: std::option::Option<crate::model::DeviceiScsiAttributes>,
}
impl std::fmt::Debug for VtlDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VtlDevice");
        formatter.field("vtl_device_arn", &self.vtl_device_arn);
        formatter.field("vtl_device_type", &self.vtl_device_type);
        formatter.field("vtl_device_vendor", &self.vtl_device_vendor);
        formatter.field(
            "vtl_device_product_identifier",
            &self.vtl_device_product_identifier,
        );
        formatter.field("devicei_scsi_attributes", &self.devicei_scsi_attributes);
        formatter.finish()
    }
}
/// See [`VtlDevice`](crate::model::VtlDevice)
pub mod vtl_device {
    /// A builder for [`VtlDevice`](crate::model::VtlDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vtl_device_arn: std::option::Option<std::string::String>,
        pub(crate) vtl_device_type: std::option::Option<std::string::String>,
        pub(crate) vtl_device_vendor: std::option::Option<std::string::String>,
        pub(crate) vtl_device_product_identifier: std::option::Option<std::string::String>,
        pub(crate) devicei_scsi_attributes:
            std::option::Option<crate::model::DeviceiScsiAttributes>,
    }
    impl Builder {
        /// <p>Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media
        /// changer).</p>
        pub fn vtl_device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vtl_device_arn = Some(input.into());
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media
        /// changer).</p>
        pub fn set_vtl_device_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vtl_device_arn = input;
            self
        }
        /// <p>Specifies the type of device that the VTL device emulates.</p>
        pub fn vtl_device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.vtl_device_type = Some(input.into());
            self
        }
        /// <p>Specifies the type of device that the VTL device emulates.</p>
        pub fn set_vtl_device_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vtl_device_type = input;
            self
        }
        /// <p>Specifies the vendor of the device that the VTL device object emulates.</p>
        pub fn vtl_device_vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.vtl_device_vendor = Some(input.into());
            self
        }
        /// <p>Specifies the vendor of the device that the VTL device object emulates.</p>
        pub fn set_vtl_device_vendor(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vtl_device_vendor = input;
            self
        }
        /// <p>Specifies the model number of device that the VTL device emulates.</p>
        pub fn vtl_device_product_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.vtl_device_product_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the model number of device that the VTL device emulates.</p>
        pub fn set_vtl_device_product_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vtl_device_product_identifier = input;
            self
        }
        /// <p>A list of iSCSI information about a VTL device.</p>
        pub fn devicei_scsi_attributes(
            mut self,
            input: crate::model::DeviceiScsiAttributes,
        ) -> Self {
            self.devicei_scsi_attributes = Some(input);
            self
        }
        /// <p>A list of iSCSI information about a VTL device.</p>
        pub fn set_devicei_scsi_attributes(
            mut self,
            input: std::option::Option<crate::model::DeviceiScsiAttributes>,
        ) -> Self {
            self.devicei_scsi_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`VtlDevice`](crate::model::VtlDevice)
        pub fn build(self) -> crate::model::VtlDevice {
            crate::model::VtlDevice {
                vtl_device_arn: self.vtl_device_arn,
                vtl_device_type: self.vtl_device_type,
                vtl_device_vendor: self.vtl_device_vendor,
                vtl_device_product_identifier: self.vtl_device_product_identifier,
                devicei_scsi_attributes: self.devicei_scsi_attributes,
            }
        }
    }
}
impl VtlDevice {
    /// Creates a new builder-style object to manufacture [`VtlDevice`](crate::model::VtlDevice)
    pub fn builder() -> crate::model::vtl_device::Builder {
        crate::model::vtl_device::Builder::default()
    }
}

/// <p>Lists iSCSI information about a VTL device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceiScsiAttributes {
    /// <p>Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified
    /// name(iqn) of a tape drive or media changer target.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The network interface identifier of the VTL device.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The port used to communicate with iSCSI VTL device targets.</p>
    pub network_interface_port: i32,
    /// <p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>
    pub chap_enabled: bool,
}
impl std::fmt::Debug for DeviceiScsiAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceiScsiAttributes");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("network_interface_port", &self.network_interface_port);
        formatter.field("chap_enabled", &self.chap_enabled);
        formatter.finish()
    }
}
/// See [`DeviceiScsiAttributes`](crate::model::DeviceiScsiAttributes)
pub mod devicei_scsi_attributes {
    /// A builder for [`DeviceiScsiAttributes`](crate::model::DeviceiScsiAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_port: std::option::Option<i32>,
        pub(crate) chap_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified
        /// name(iqn) of a tape drive or media changer target.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified
        /// name(iqn) of a tape drive or media changer target.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The network interface identifier of the VTL device.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The network interface identifier of the VTL device.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The port used to communicate with iSCSI VTL device targets.</p>
        pub fn network_interface_port(mut self, input: i32) -> Self {
            self.network_interface_port = Some(input);
            self
        }
        /// <p>The port used to communicate with iSCSI VTL device targets.</p>
        pub fn set_network_interface_port(mut self, input: std::option::Option<i32>) -> Self {
            self.network_interface_port = input;
            self
        }
        /// <p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>
        pub fn chap_enabled(mut self, input: bool) -> Self {
            self.chap_enabled = Some(input);
            self
        }
        /// <p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>
        pub fn set_chap_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.chap_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceiScsiAttributes`](crate::model::DeviceiScsiAttributes)
        pub fn build(self) -> crate::model::DeviceiScsiAttributes {
            crate::model::DeviceiScsiAttributes {
                target_arn: self.target_arn,
                network_interface_id: self.network_interface_id,
                network_interface_port: self.network_interface_port.unwrap_or_default(),
                chap_enabled: self.chap_enabled.unwrap_or_default(),
            }
        }
    }
}
impl DeviceiScsiAttributes {
    /// Creates a new builder-style object to manufacture [`DeviceiScsiAttributes`](crate::model::DeviceiScsiAttributes)
    pub fn builder() -> crate::model::devicei_scsi_attributes::Builder {
        crate::model::devicei_scsi_attributes::Builder::default()
    }
}

/// <p>Describes a virtual tape object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tape {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape.</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>The barcode that identifies a specific virtual tape.</p>
    pub tape_barcode: std::option::Option<std::string::String>,
    /// <p>The date the virtual tape was created.</p>
    pub tape_created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The size, in bytes, of the virtual tape capacity.</p>
    pub tape_size_in_bytes: std::option::Option<i64>,
    /// <p>The current state of the virtual tape.</p>
    pub tape_status: std::option::Option<std::string::String>,
    /// <p>The virtual tape library (VTL) device that the virtual tape is associated with.</p>
    pub vtl_device: std::option::Option<std::string::String>,
    /// <p>For archiving virtual tapes, indicates how much data remains to be uploaded before
    /// archiving is complete.</p>
    ///
    /// <p>Range: 0 (not started) to 100 (complete).</p>
    pub progress: std::option::Option<f64>,
    /// <p>The size, in bytes, of data stored on the virtual tape.</p>
    ///
    /// <note>
    /// <p>This value is not available for tapes created prior to May 13, 2015.</p>
    /// </note>
    pub tape_used_in_bytes: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The ID of the pool that contains tapes that will be archived. The tapes in this pool are
    /// archived in the S3 storage class that is associated with the pool. When you use your backup
    /// application to eject the tape, the tape is archived directly into the storage class (S3
    /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>If the tape is archived as write-once-read-many (WORM), this value is
    /// <code>true</code>.</p>
    pub worm: bool,
    /// <p>The date that the tape is first archived with tape retention lock enabled.</p>
    pub retention_start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the tape enters a custom tape pool.</p>
    pub pool_entry_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Tape {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tape");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field("tape_barcode", &self.tape_barcode);
        formatter.field("tape_created_date", &self.tape_created_date);
        formatter.field("tape_size_in_bytes", &self.tape_size_in_bytes);
        formatter.field("tape_status", &self.tape_status);
        formatter.field("vtl_device", &self.vtl_device);
        formatter.field("progress", &self.progress);
        formatter.field("tape_used_in_bytes", &self.tape_used_in_bytes);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("worm", &self.worm);
        formatter.field("retention_start_date", &self.retention_start_date);
        formatter.field("pool_entry_date", &self.pool_entry_date);
        formatter.finish()
    }
}
/// See [`Tape`](crate::model::Tape)
pub mod tape {
    /// A builder for [`Tape`](crate::model::Tape)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) tape_barcode: std::option::Option<std::string::String>,
        pub(crate) tape_created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tape_size_in_bytes: std::option::Option<i64>,
        pub(crate) tape_status: std::option::Option<std::string::String>,
        pub(crate) vtl_device: std::option::Option<std::string::String>,
        pub(crate) progress: std::option::Option<f64>,
        pub(crate) tape_used_in_bytes: std::option::Option<i64>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) worm: std::option::Option<bool>,
        pub(crate) retention_start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pool_entry_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>The barcode that identifies a specific virtual tape.</p>
        pub fn tape_barcode(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_barcode = Some(input.into());
            self
        }
        /// <p>The barcode that identifies a specific virtual tape.</p>
        pub fn set_tape_barcode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_barcode = input;
            self
        }
        /// <p>The date the virtual tape was created.</p>
        pub fn tape_created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.tape_created_date = Some(input);
            self
        }
        /// <p>The date the virtual tape was created.</p>
        pub fn set_tape_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.tape_created_date = input;
            self
        }
        /// <p>The size, in bytes, of the virtual tape capacity.</p>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.tape_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tape capacity.</p>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_size_in_bytes = input;
            self
        }
        /// <p>The current state of the virtual tape.</p>
        pub fn tape_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_status = Some(input.into());
            self
        }
        /// <p>The current state of the virtual tape.</p>
        pub fn set_tape_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_status = input;
            self
        }
        /// <p>The virtual tape library (VTL) device that the virtual tape is associated with.</p>
        pub fn vtl_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.vtl_device = Some(input.into());
            self
        }
        /// <p>The virtual tape library (VTL) device that the virtual tape is associated with.</p>
        pub fn set_vtl_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vtl_device = input;
            self
        }
        /// <p>For archiving virtual tapes, indicates how much data remains to be uploaded before
        /// archiving is complete.</p>
        ///
        /// <p>Range: 0 (not started) to 100 (complete).</p>
        pub fn progress(mut self, input: f64) -> Self {
            self.progress = Some(input);
            self
        }
        /// <p>For archiving virtual tapes, indicates how much data remains to be uploaded before
        /// archiving is complete.</p>
        ///
        /// <p>Range: 0 (not started) to 100 (complete).</p>
        pub fn set_progress(mut self, input: std::option::Option<f64>) -> Self {
            self.progress = input;
            self
        }
        /// <p>The size, in bytes, of data stored on the virtual tape.</p>
        ///
        /// <note>
        /// <p>This value is not available for tapes created prior to May 13, 2015.</p>
        /// </note>
        pub fn tape_used_in_bytes(mut self, input: i64) -> Self {
            self.tape_used_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of data stored on the virtual tape.</p>
        ///
        /// <note>
        /// <p>This value is not available for tapes created prior to May 13, 2015.</p>
        /// </note>
        pub fn set_tape_used_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_used_in_bytes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The ID of the pool that contains tapes that will be archived. The tapes in this pool are
        /// archived in the S3 storage class that is associated with the pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the pool that contains tapes that will be archived. The tapes in this pool are
        /// archived in the S3 storage class that is associated with the pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>If the tape is archived as write-once-read-many (WORM), this value is
        /// <code>true</code>.</p>
        pub fn worm(mut self, input: bool) -> Self {
            self.worm = Some(input);
            self
        }
        /// <p>If the tape is archived as write-once-read-many (WORM), this value is
        /// <code>true</code>.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.worm = input;
            self
        }
        /// <p>The date that the tape is first archived with tape retention lock enabled.</p>
        pub fn retention_start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.retention_start_date = Some(input);
            self
        }
        /// <p>The date that the tape is first archived with tape retention lock enabled.</p>
        pub fn set_retention_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.retention_start_date = input;
            self
        }
        /// <p>The date that the tape enters a custom tape pool.</p>
        pub fn pool_entry_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pool_entry_date = Some(input);
            self
        }
        /// <p>The date that the tape enters a custom tape pool.</p>
        pub fn set_pool_entry_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pool_entry_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Tape`](crate::model::Tape)
        pub fn build(self) -> crate::model::Tape {
            crate::model::Tape {
                tape_arn: self.tape_arn,
                tape_barcode: self.tape_barcode,
                tape_created_date: self.tape_created_date,
                tape_size_in_bytes: self.tape_size_in_bytes,
                tape_status: self.tape_status,
                vtl_device: self.vtl_device,
                progress: self.progress,
                tape_used_in_bytes: self.tape_used_in_bytes,
                kms_key: self.kms_key,
                pool_id: self.pool_id,
                worm: self.worm.unwrap_or_default(),
                retention_start_date: self.retention_start_date,
                pool_entry_date: self.pool_entry_date,
            }
        }
    }
}
impl Tape {
    /// Creates a new builder-style object to manufacture [`Tape`](crate::model::Tape)
    pub fn builder() -> crate::model::tape::Builder {
        crate::model::tape::Builder::default()
    }
}

/// <p>Describes a recovery point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TapeRecoveryPointInfo {
    /// <p>The Amazon Resource Name (ARN) of the virtual tape.</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>The time when the point-in-time view of the virtual tape was replicated for later
    /// recovery.</p>
    ///
    /// <p>The default timestamp format of the tape recovery point time is in the ISO8601 extended
    /// YYYY-MM-DD'T'HH:MM:SS'Z' format.</p>
    pub tape_recovery_point_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The size, in bytes, of the virtual tapes to recover.</p>
    pub tape_size_in_bytes: std::option::Option<i64>,
    /// <p>The status of the virtual tapes.</p>
    pub tape_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TapeRecoveryPointInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TapeRecoveryPointInfo");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field("tape_recovery_point_time", &self.tape_recovery_point_time);
        formatter.field("tape_size_in_bytes", &self.tape_size_in_bytes);
        formatter.field("tape_status", &self.tape_status);
        formatter.finish()
    }
}
/// See [`TapeRecoveryPointInfo`](crate::model::TapeRecoveryPointInfo)
pub mod tape_recovery_point_info {
    /// A builder for [`TapeRecoveryPointInfo`](crate::model::TapeRecoveryPointInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) tape_recovery_point_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tape_size_in_bytes: std::option::Option<i64>,
        pub(crate) tape_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the virtual tape.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>The time when the point-in-time view of the virtual tape was replicated for later
        /// recovery.</p>
        ///
        /// <p>The default timestamp format of the tape recovery point time is in the ISO8601 extended
        /// YYYY-MM-DD'T'HH:MM:SS'Z' format.</p>
        pub fn tape_recovery_point_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.tape_recovery_point_time = Some(input);
            self
        }
        /// <p>The time when the point-in-time view of the virtual tape was replicated for later
        /// recovery.</p>
        ///
        /// <p>The default timestamp format of the tape recovery point time is in the ISO8601 extended
        /// YYYY-MM-DD'T'HH:MM:SS'Z' format.</p>
        pub fn set_tape_recovery_point_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.tape_recovery_point_time = input;
            self
        }
        /// <p>The size, in bytes, of the virtual tapes to recover.</p>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.tape_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tapes to recover.</p>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_size_in_bytes = input;
            self
        }
        /// <p>The status of the virtual tapes.</p>
        pub fn tape_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_status = Some(input.into());
            self
        }
        /// <p>The status of the virtual tapes.</p>
        pub fn set_tape_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_status = input;
            self
        }
        /// Consumes the builder and constructs a [`TapeRecoveryPointInfo`](crate::model::TapeRecoveryPointInfo)
        pub fn build(self) -> crate::model::TapeRecoveryPointInfo {
            crate::model::TapeRecoveryPointInfo {
                tape_arn: self.tape_arn,
                tape_recovery_point_time: self.tape_recovery_point_time,
                tape_size_in_bytes: self.tape_size_in_bytes,
                tape_status: self.tape_status,
            }
        }
    }
}
impl TapeRecoveryPointInfo {
    /// Creates a new builder-style object to manufacture [`TapeRecoveryPointInfo`](crate::model::TapeRecoveryPointInfo)
    pub fn builder() -> crate::model::tape_recovery_point_info::Builder {
        crate::model::tape_recovery_point_info::Builder::default()
    }
}

/// <p>Represents a virtual tape that is archived in the virtual tape shelf (VTS).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TapeArchive {
    /// <p>The Amazon Resource Name (ARN) of an archived virtual tape.</p>
    pub tape_arn: std::option::Option<std::string::String>,
    /// <p>The barcode that identifies the archived virtual tape.</p>
    pub tape_barcode: std::option::Option<std::string::String>,
    /// <p>The date the virtual tape was created.</p>
    pub tape_created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The size, in bytes, of the archived virtual tape.</p>
    pub tape_size_in_bytes: std::option::Option<i64>,
    /// <p>The time that the archiving of the virtual tape was completed.</p>
    ///
    /// <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
    /// format.</p>
    pub completion_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being
    /// retrieved to.</p>
    ///
    /// <p>The virtual tape is retrieved from the virtual tape shelf (VTS).</p>
    pub retrieved_to: std::option::Option<std::string::String>,
    /// <p>The current state of the archived virtual tape.</p>
    pub tape_status: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of data stored on the virtual tape.</p>
    ///
    /// <note>
    /// <p>This value is not available for tapes created prior to May 13, 2015.</p>
    /// </note>
    pub tape_used_in_bytes: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The ID of the pool that was used to archive the tape. The tapes in this pool are
    /// archived in the S3 storage class that is associated with the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> if the archived tape is stored as write-once-read-many
    /// (WORM).</p>
    pub worm: bool,
    /// <p>If the archived tape is subject to tape retention lock, the date that the archived tape
    /// started being retained.</p>
    pub retention_start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the tape entered the custom tape pool.</p>
    ///
    /// <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
    /// format.</p>
    pub pool_entry_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for TapeArchive {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TapeArchive");
        formatter.field("tape_arn", &self.tape_arn);
        formatter.field("tape_barcode", &self.tape_barcode);
        formatter.field("tape_created_date", &self.tape_created_date);
        formatter.field("tape_size_in_bytes", &self.tape_size_in_bytes);
        formatter.field("completion_time", &self.completion_time);
        formatter.field("retrieved_to", &self.retrieved_to);
        formatter.field("tape_status", &self.tape_status);
        formatter.field("tape_used_in_bytes", &self.tape_used_in_bytes);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("worm", &self.worm);
        formatter.field("retention_start_date", &self.retention_start_date);
        formatter.field("pool_entry_date", &self.pool_entry_date);
        formatter.finish()
    }
}
/// See [`TapeArchive`](crate::model::TapeArchive)
pub mod tape_archive {
    /// A builder for [`TapeArchive`](crate::model::TapeArchive)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tape_arn: std::option::Option<std::string::String>,
        pub(crate) tape_barcode: std::option::Option<std::string::String>,
        pub(crate) tape_created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tape_size_in_bytes: std::option::Option<i64>,
        pub(crate) completion_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) retrieved_to: std::option::Option<std::string::String>,
        pub(crate) tape_status: std::option::Option<std::string::String>,
        pub(crate) tape_used_in_bytes: std::option::Option<i64>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) worm: std::option::Option<bool>,
        pub(crate) retention_start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pool_entry_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an archived virtual tape.</p>
        pub fn tape_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an archived virtual tape.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_arn = input;
            self
        }
        /// <p>The barcode that identifies the archived virtual tape.</p>
        pub fn tape_barcode(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_barcode = Some(input.into());
            self
        }
        /// <p>The barcode that identifies the archived virtual tape.</p>
        pub fn set_tape_barcode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_barcode = input;
            self
        }
        /// <p>The date the virtual tape was created.</p>
        pub fn tape_created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.tape_created_date = Some(input);
            self
        }
        /// <p>The date the virtual tape was created.</p>
        pub fn set_tape_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.tape_created_date = input;
            self
        }
        /// <p>The size, in bytes, of the archived virtual tape.</p>
        pub fn tape_size_in_bytes(mut self, input: i64) -> Self {
            self.tape_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the archived virtual tape.</p>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_size_in_bytes = input;
            self
        }
        /// <p>The time that the archiving of the virtual tape was completed.</p>
        ///
        /// <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
        /// format.</p>
        pub fn completion_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p>The time that the archiving of the virtual tape was completed.</p>
        ///
        /// <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
        /// format.</p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being
        /// retrieved to.</p>
        ///
        /// <p>The virtual tape is retrieved from the virtual tape shelf (VTS).</p>
        pub fn retrieved_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieved_to = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being
        /// retrieved to.</p>
        ///
        /// <p>The virtual tape is retrieved from the virtual tape shelf (VTS).</p>
        pub fn set_retrieved_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.retrieved_to = input;
            self
        }
        /// <p>The current state of the archived virtual tape.</p>
        pub fn tape_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.tape_status = Some(input.into());
            self
        }
        /// <p>The current state of the archived virtual tape.</p>
        pub fn set_tape_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tape_status = input;
            self
        }
        /// <p>The size, in bytes, of data stored on the virtual tape.</p>
        ///
        /// <note>
        /// <p>This value is not available for tapes created prior to May 13, 2015.</p>
        /// </note>
        pub fn tape_used_in_bytes(mut self, input: i64) -> Self {
            self.tape_used_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of data stored on the virtual tape.</p>
        ///
        /// <note>
        /// <p>This value is not available for tapes created prior to May 13, 2015.</p>
        /// </note>
        pub fn set_tape_used_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.tape_used_in_bytes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The ID of the pool that was used to archive the tape. The tapes in this pool are
        /// archived in the S3 storage class that is associated with the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the pool that was used to archive the tape. The tapes in this pool are
        /// archived in the S3 storage class that is associated with the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>Set to <code>true</code> if the archived tape is stored as write-once-read-many
        /// (WORM).</p>
        pub fn worm(mut self, input: bool) -> Self {
            self.worm = Some(input);
            self
        }
        /// <p>Set to <code>true</code> if the archived tape is stored as write-once-read-many
        /// (WORM).</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.worm = input;
            self
        }
        /// <p>If the archived tape is subject to tape retention lock, the date that the archived tape
        /// started being retained.</p>
        pub fn retention_start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.retention_start_date = Some(input);
            self
        }
        /// <p>If the archived tape is subject to tape retention lock, the date that the archived tape
        /// started being retained.</p>
        pub fn set_retention_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.retention_start_date = input;
            self
        }
        /// <p>The time that the tape entered the custom tape pool.</p>
        ///
        /// <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
        /// format.</p>
        pub fn pool_entry_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pool_entry_date = Some(input);
            self
        }
        /// <p>The time that the tape entered the custom tape pool.</p>
        ///
        /// <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
        /// format.</p>
        pub fn set_pool_entry_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pool_entry_date = input;
            self
        }
        /// Consumes the builder and constructs a [`TapeArchive`](crate::model::TapeArchive)
        pub fn build(self) -> crate::model::TapeArchive {
            crate::model::TapeArchive {
                tape_arn: self.tape_arn,
                tape_barcode: self.tape_barcode,
                tape_created_date: self.tape_created_date,
                tape_size_in_bytes: self.tape_size_in_bytes,
                completion_time: self.completion_time,
                retrieved_to: self.retrieved_to,
                tape_status: self.tape_status,
                tape_used_in_bytes: self.tape_used_in_bytes,
                kms_key: self.kms_key,
                pool_id: self.pool_id,
                worm: self.worm.unwrap_or_default(),
                retention_start_date: self.retention_start_date,
                pool_entry_date: self.pool_entry_date,
            }
        }
    }
}
impl TapeArchive {
    /// Creates a new builder-style object to manufacture [`TapeArchive`](crate::model::TapeArchive)
    pub fn builder() -> crate::model::tape_archive::Builder {
        crate::model::tape_archive::Builder::default()
    }
}

/// <p>Describes an iSCSI stored volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorediScsiVolume {
    /// <p>The Amazon Resource Name (ARN) of the storage volume.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>One of the VolumeType enumeration values describing the type of the volume.</p>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
    pub volume_status: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether a storage volume is attached to, detached from, or is in
    /// the process of detaching from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
    /// your volumes to a different gateway</a>.</p>
    pub volume_attachment_status: std::option::Option<std::string::String>,
    /// <p>The size of the volume in bytes.</p>
    pub volume_size_in_bytes: i64,
    /// <p>Represents the percentage complete if the volume is restoring or bootstrapping that
    /// represents the percent of data transferred. This field does not appear in the response if
    /// the stored volume is not restoring or bootstrapping.</p>
    pub volume_progress: std::option::Option<f64>,
    /// <p>The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.</p>
    pub volume_disk_id: std::option::Option<std::string::String>,
    /// <p>If the stored volume was created from a snapshot, this field contains the snapshot ID
    /// used, e.g. snap-78e22663. Otherwise, this field is not included.</p>
    pub source_snapshot_id: std::option::Option<std::string::String>,
    /// <p>Indicates if when the stored volume was created, existing data on the underlying local
    /// disk was preserved.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub preserved_existing_data: bool,
    /// <p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
    /// attributes for one stored volume.</p>
    pub volumei_scsi_attributes: std::option::Option<crate::model::VolumeiScsiAttributes>,
    /// <p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
    /// timestamp.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The size of the data stored on the volume in bytes. This value is calculated based on
    /// the number of blocks that are touched, instead of the actual amount of data written. This
    /// value can be useful for sequential write patterns but less accurate for random write
    /// patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the
    /// volume, which is the value that is used to calculate your bill.</p>
    ///
    /// <note>
    /// <p>This value is not available for volumes created prior to May 13, 2015, until you
    /// store data on the volume.</p>
    /// </note>
    pub volume_used_in_bytes: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
    /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
    /// <i>myvolume</i> results in the target ARN of
    /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
    /// The target name must be unique across all volumes on a gateway.</p>
    ///
    /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
    /// used for this volume as the new target name.</p>
    pub target_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StorediScsiVolume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorediScsiVolume");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("volume_id", &self.volume_id);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("volume_status", &self.volume_status);
        formatter.field("volume_attachment_status", &self.volume_attachment_status);
        formatter.field("volume_size_in_bytes", &self.volume_size_in_bytes);
        formatter.field("volume_progress", &self.volume_progress);
        formatter.field("volume_disk_id", &self.volume_disk_id);
        formatter.field("source_snapshot_id", &self.source_snapshot_id);
        formatter.field("preserved_existing_data", &self.preserved_existing_data);
        formatter.field("volumei_scsi_attributes", &self.volumei_scsi_attributes);
        formatter.field("created_date", &self.created_date);
        formatter.field("volume_used_in_bytes", &self.volume_used_in_bytes);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("target_name", &self.target_name);
        formatter.finish()
    }
}
/// See [`StorediScsiVolume`](crate::model::StorediScsiVolume)
pub mod storedi_scsi_volume {
    /// A builder for [`StorediScsiVolume`](crate::model::StorediScsiVolume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) volume_status: std::option::Option<std::string::String>,
        pub(crate) volume_attachment_status: std::option::Option<std::string::String>,
        pub(crate) volume_size_in_bytes: std::option::Option<i64>,
        pub(crate) volume_progress: std::option::Option<f64>,
        pub(crate) volume_disk_id: std::option::Option<std::string::String>,
        pub(crate) source_snapshot_id: std::option::Option<std::string::String>,
        pub(crate) preserved_existing_data: std::option::Option<bool>,
        pub(crate) volumei_scsi_attributes:
            std::option::Option<crate::model::VolumeiScsiAttributes>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) volume_used_in_bytes: std::option::Option<i64>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) target_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the storage volume.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage volume.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>One of the VolumeType enumeration values describing the type of the volume.</p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>One of the VolumeType enumeration values describing the type of the volume.</p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
        pub fn volume_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_status = Some(input.into());
            self
        }
        /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
        pub fn set_volume_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_status = input;
            self
        }
        /// <p>A value that indicates whether a storage volume is attached to, detached from, or is in
        /// the process of detaching from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
        /// your volumes to a different gateway</a>.</p>
        pub fn volume_attachment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_attachment_status = Some(input.into());
            self
        }
        /// <p>A value that indicates whether a storage volume is attached to, detached from, or is in
        /// the process of detaching from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
        /// your volumes to a different gateway</a>.</p>
        pub fn set_volume_attachment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_attachment_status = input;
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn volume_size_in_bytes(mut self, input: i64) -> Self {
            self.volume_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_size_in_bytes = input;
            self
        }
        /// <p>Represents the percentage complete if the volume is restoring or bootstrapping that
        /// represents the percent of data transferred. This field does not appear in the response if
        /// the stored volume is not restoring or bootstrapping.</p>
        pub fn volume_progress(mut self, input: f64) -> Self {
            self.volume_progress = Some(input);
            self
        }
        /// <p>Represents the percentage complete if the volume is restoring or bootstrapping that
        /// represents the percent of data transferred. This field does not appear in the response if
        /// the stored volume is not restoring or bootstrapping.</p>
        pub fn set_volume_progress(mut self, input: std::option::Option<f64>) -> Self {
            self.volume_progress = input;
            self
        }
        /// <p>The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.</p>
        pub fn volume_disk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_disk_id = Some(input.into());
            self
        }
        /// <p>The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.</p>
        pub fn set_volume_disk_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_disk_id = input;
            self
        }
        /// <p>If the stored volume was created from a snapshot, this field contains the snapshot ID
        /// used, e.g. snap-78e22663. Otherwise, this field is not included.</p>
        pub fn source_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_id = Some(input.into());
            self
        }
        /// <p>If the stored volume was created from a snapshot, this field contains the snapshot ID
        /// used, e.g. snap-78e22663. Otherwise, this field is not included.</p>
        pub fn set_source_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_id = input;
            self
        }
        /// <p>Indicates if when the stored volume was created, existing data on the underlying local
        /// disk was preserved.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn preserved_existing_data(mut self, input: bool) -> Self {
            self.preserved_existing_data = Some(input);
            self
        }
        /// <p>Indicates if when the stored volume was created, existing data on the underlying local
        /// disk was preserved.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_preserved_existing_data(mut self, input: std::option::Option<bool>) -> Self {
            self.preserved_existing_data = input;
            self
        }
        /// <p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
        /// attributes for one stored volume.</p>
        pub fn volumei_scsi_attributes(
            mut self,
            input: crate::model::VolumeiScsiAttributes,
        ) -> Self {
            self.volumei_scsi_attributes = Some(input);
            self
        }
        /// <p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
        /// attributes for one stored volume.</p>
        pub fn set_volumei_scsi_attributes(
            mut self,
            input: std::option::Option<crate::model::VolumeiScsiAttributes>,
        ) -> Self {
            self.volumei_scsi_attributes = input;
            self
        }
        /// <p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
        /// timestamp.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
        /// timestamp.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The size of the data stored on the volume in bytes. This value is calculated based on
        /// the number of blocks that are touched, instead of the actual amount of data written. This
        /// value can be useful for sequential write patterns but less accurate for random write
        /// patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the
        /// volume, which is the value that is used to calculate your bill.</p>
        ///
        /// <note>
        /// <p>This value is not available for volumes created prior to May 13, 2015, until you
        /// store data on the volume.</p>
        /// </note>
        pub fn volume_used_in_bytes(mut self, input: i64) -> Self {
            self.volume_used_in_bytes = Some(input);
            self
        }
        /// <p>The size of the data stored on the volume in bytes. This value is calculated based on
        /// the number of blocks that are touched, instead of the actual amount of data written. This
        /// value can be useful for sequential write patterns but less accurate for random write
        /// patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the
        /// volume, which is the value that is used to calculate your bill.</p>
        ///
        /// <note>
        /// <p>This value is not available for volumes created prior to May 13, 2015, until you
        /// store data on the volume.</p>
        /// </note>
        pub fn set_volume_used_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_used_in_bytes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_name = Some(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StorediScsiVolume`](crate::model::StorediScsiVolume)
        pub fn build(self) -> crate::model::StorediScsiVolume {
            crate::model::StorediScsiVolume {
                volume_arn: self.volume_arn,
                volume_id: self.volume_id,
                volume_type: self.volume_type,
                volume_status: self.volume_status,
                volume_attachment_status: self.volume_attachment_status,
                volume_size_in_bytes: self.volume_size_in_bytes.unwrap_or_default(),
                volume_progress: self.volume_progress,
                volume_disk_id: self.volume_disk_id,
                source_snapshot_id: self.source_snapshot_id,
                preserved_existing_data: self.preserved_existing_data.unwrap_or_default(),
                volumei_scsi_attributes: self.volumei_scsi_attributes,
                created_date: self.created_date,
                volume_used_in_bytes: self.volume_used_in_bytes,
                kms_key: self.kms_key,
                target_name: self.target_name,
            }
        }
    }
}
impl StorediScsiVolume {
    /// Creates a new builder-style object to manufacture [`StorediScsiVolume`](crate::model::StorediScsiVolume)
    pub fn builder() -> crate::model::storedi_scsi_volume::Builder {
        crate::model::storedi_scsi_volume::Builder::default()
    }
}

/// <p>Lists iSCSI information about a volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeiScsiAttributes {
    /// <p>The Amazon Resource Name (ARN) of the volume target.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The network interface identifier.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The port used to communicate with iSCSI targets.</p>
    pub network_interface_port: i32,
    /// <p>The logical disk number.</p>
    pub lun_number: std::option::Option<i32>,
    /// <p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>
    pub chap_enabled: bool,
}
impl std::fmt::Debug for VolumeiScsiAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeiScsiAttributes");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("network_interface_port", &self.network_interface_port);
        formatter.field("lun_number", &self.lun_number);
        formatter.field("chap_enabled", &self.chap_enabled);
        formatter.finish()
    }
}
/// See [`VolumeiScsiAttributes`](crate::model::VolumeiScsiAttributes)
pub mod volumei_scsi_attributes {
    /// A builder for [`VolumeiScsiAttributes`](crate::model::VolumeiScsiAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_port: std::option::Option<i32>,
        pub(crate) lun_number: std::option::Option<i32>,
        pub(crate) chap_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume target.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume target.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The network interface identifier.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The network interface identifier.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The port used to communicate with iSCSI targets.</p>
        pub fn network_interface_port(mut self, input: i32) -> Self {
            self.network_interface_port = Some(input);
            self
        }
        /// <p>The port used to communicate with iSCSI targets.</p>
        pub fn set_network_interface_port(mut self, input: std::option::Option<i32>) -> Self {
            self.network_interface_port = input;
            self
        }
        /// <p>The logical disk number.</p>
        pub fn lun_number(mut self, input: i32) -> Self {
            self.lun_number = Some(input);
            self
        }
        /// <p>The logical disk number.</p>
        pub fn set_lun_number(mut self, input: std::option::Option<i32>) -> Self {
            self.lun_number = input;
            self
        }
        /// <p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>
        pub fn chap_enabled(mut self, input: bool) -> Self {
            self.chap_enabled = Some(input);
            self
        }
        /// <p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>
        pub fn set_chap_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.chap_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeiScsiAttributes`](crate::model::VolumeiScsiAttributes)
        pub fn build(self) -> crate::model::VolumeiScsiAttributes {
            crate::model::VolumeiScsiAttributes {
                target_arn: self.target_arn,
                network_interface_id: self.network_interface_id,
                network_interface_port: self.network_interface_port.unwrap_or_default(),
                lun_number: self.lun_number,
                chap_enabled: self.chap_enabled.unwrap_or_default(),
            }
        }
    }
}
impl VolumeiScsiAttributes {
    /// Creates a new builder-style object to manufacture [`VolumeiScsiAttributes`](crate::model::VolumeiScsiAttributes)
    pub fn builder() -> crate::model::volumei_scsi_attributes::Builder {
        crate::model::volumei_scsi_attributes::Builder::default()
    }
}

/// <p>The Windows file permissions and ownership information assigned, by default, to native
/// S3 objects when S3 File Gateway discovers them in S3 buckets. This operation is only
/// supported for S3 File Gateways.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmbFileShareInfo {
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the file share.</p>
    pub file_share_id: std::option::Option<std::string::String>,
    /// <p>The status of the file share.</p>
    ///
    /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
    /// <code>DELETING</code>
    /// </p>
    pub file_share_status: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub kms_encrypted: bool,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The file share path used by the SMB client to identify the mount point.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
    /// storage.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
    /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
    /// slash (/).</p>
    /// <note>
    /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
    /// as shown in the following examples.</p>
    ///
    /// <p>Bucket ARN:</p>
    /// <p>
    /// <code>arn:aws:s3:::my-bucket/prefix/</code>
    /// </p>
    ///
    /// <p>Access point ARN:</p>
    /// <p>
    /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
    /// </p>
    ///
    /// <p>If you specify an access point, the bucket policy must be configured to delegate
    /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///
    /// <p>Access point alias:</p>
    /// <p>
    /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
    /// </p>
    /// </note>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
    /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
    ///
    /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
    /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
    /// </p>
    pub default_storage_class: std::option::Option<std::string::String>,
    /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
    /// that an S3 File Gateway puts objects into. The default value is
    /// <code>private</code>.</p>
    pub object_acl: std::option::Option<crate::model::ObjectAcl>,
    /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
    /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub read_only: std::option::Option<bool>,
    /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
    /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
    /// to <code>false</code>. The default value is <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub guess_mime_type_enabled: std::option::Option<bool>,
    /// <p>A value that sets who pays the cost of the request and the cost associated with data
    /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
    /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
    /// the cost of storing data.</p>
    ///
    /// <note>
    /// <p>
    /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
    /// share, so make sure that the configuration on the file share is the same as the S3
    /// bucket configuration.</p>
    /// </note>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub requester_pays: std::option::Option<bool>,
    /// <p>If this value is set to <code>true</code>, it indicates that access control list (ACL)
    /// is enabled on the SMB file share. If it is set to <code>false</code>, it indicates that
    /// file and directory permissions are mapped to the POSIX permission.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
    /// control access to an SMB file share</a> in the <i>Storage Gateway User
    /// Guide</i>.</p>
    pub smbacl_enabled: std::option::Option<bool>,
    /// <p>Indicates whether <code>AccessBasedEnumeration</code> is enabled.</p>
    pub access_based_enumeration: std::option::Option<bool>,
    /// <p>A list of users or groups in the Active Directory that have administrator rights to the
    /// file share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub admin_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of users or groups in the Active Directory that are allowed to access the file
    /// share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub valid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of users or groups in the Active Directory that are not allowed to access the
    /// file share. A group must be prefixed with the @ character. Acceptable formats include:
    /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
    /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
    /// <code>ActiveDirectory</code>.</p>
    pub invalid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    pub audit_destination_arn: std::option::Option<std::string::String>,
    /// <p>The authentication method of the file share. The default is
    /// <code>ActiveDirectory</code>.</p>
    ///
    /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code>
    /// </p>
    pub authentication: std::option::Option<std::string::String>,
    /// <p>The case of an object name in an Amazon S3 bucket. For
    /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
    /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
    /// value is <code>ClientSpecified</code>.</p>
    pub case_sensitivity: std::option::Option<crate::model::CaseSensitivity>,
    /// <p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
    /// name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
    /// view all tags using the <code>ListTagsForResource</code> API operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the file share. Optional.</p>
    ///
    /// <note>
    /// <p>
    /// <code>FileShareName</code> must be set if an S3 prefix name is set in
    /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
    /// </note>
    pub file_share_name: std::option::Option<std::string::String>,
    /// <p>Refresh cache information for the file share.</p>
    pub cache_attributes: std::option::Option<crate::model::CacheAttributes>,
    /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
    /// the number of seconds to wait after the last point in time a client wrote to a file before
    /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
    /// writes to files, it's best to set this parameter for as long as possible to avoid
    /// generating multiple notifications for the same file in a small time period.</p>
    ///
    /// <note>
    /// <p>
    /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
    /// uploading to Amazon S3, only the timing of the notification.</p>
    /// </note>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> on with
    /// <code>SettlingTimeInSeconds</code> set to 60.</p>
    ///
    /// <p>
    /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
    /// </p>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
    ///
    /// <p>
    /// <code>{}</code>
    /// </p>
    pub notification_policy: std::option::Option<std::string::String>,
    /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to
    /// Amazon S3.</p>
    /// <note>
    /// <p>This parameter is required for SMB file shares that connect to Amazon S3
    /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
    /// VPC access point.</p>
    /// </note>
    pub vpc_endpoint_dns_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p>
    /// <note>
    /// <p>This parameter is required for SMB file shares that connect to Amazon S3
    /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
    /// VPC access point.</p>
    /// </note>
    pub bucket_region: std::option::Option<std::string::String>,
    /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
    /// <note>
    /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
    /// workloads that involve access to files with the same name in different case.</p>
    /// </note>
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub oplocks_enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for SmbFileShareInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmbFileShareInfo");
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("file_share_id", &self.file_share_id);
        formatter.field("file_share_status", &self.file_share_status);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("kms_encrypted", &self.kms_encrypted);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("path", &self.path);
        formatter.field("role", &self.role);
        formatter.field("location_arn", &self.location_arn);
        formatter.field("default_storage_class", &self.default_storage_class);
        formatter.field("object_acl", &self.object_acl);
        formatter.field("read_only", &self.read_only);
        formatter.field("guess_mime_type_enabled", &self.guess_mime_type_enabled);
        formatter.field("requester_pays", &self.requester_pays);
        formatter.field("smbacl_enabled", &self.smbacl_enabled);
        formatter.field("access_based_enumeration", &self.access_based_enumeration);
        formatter.field("admin_user_list", &self.admin_user_list);
        formatter.field("valid_user_list", &self.valid_user_list);
        formatter.field("invalid_user_list", &self.invalid_user_list);
        formatter.field("audit_destination_arn", &self.audit_destination_arn);
        formatter.field("authentication", &self.authentication);
        formatter.field("case_sensitivity", &self.case_sensitivity);
        formatter.field("tags", &self.tags);
        formatter.field("file_share_name", &self.file_share_name);
        formatter.field("cache_attributes", &self.cache_attributes);
        formatter.field("notification_policy", &self.notification_policy);
        formatter.field("vpc_endpoint_dns_name", &self.vpc_endpoint_dns_name);
        formatter.field("bucket_region", &self.bucket_region);
        formatter.field("oplocks_enabled", &self.oplocks_enabled);
        formatter.finish()
    }
}
/// See [`SmbFileShareInfo`](crate::model::SmbFileShareInfo)
pub mod smb_file_share_info {
    /// A builder for [`SmbFileShareInfo`](crate::model::SmbFileShareInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) file_share_id: std::option::Option<std::string::String>,
        pub(crate) file_share_status: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) default_storage_class: std::option::Option<std::string::String>,
        pub(crate) object_acl: std::option::Option<crate::model::ObjectAcl>,
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) guess_mime_type_enabled: std::option::Option<bool>,
        pub(crate) requester_pays: std::option::Option<bool>,
        pub(crate) smbacl_enabled: std::option::Option<bool>,
        pub(crate) access_based_enumeration: std::option::Option<bool>,
        pub(crate) admin_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) valid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) invalid_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
        pub(crate) authentication: std::option::Option<std::string::String>,
        pub(crate) case_sensitivity: std::option::Option<crate::model::CaseSensitivity>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_share_name: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) notification_policy: std::option::Option<std::string::String>,
        pub(crate) vpc_endpoint_dns_name: std::option::Option<std::string::String>,
        pub(crate) bucket_region: std::option::Option<std::string::String>,
        pub(crate) oplocks_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>The ID of the file share.</p>
        pub fn file_share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_id = Some(input.into());
            self
        }
        /// <p>The ID of the file share.</p>
        pub fn set_file_share_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_id = input;
            self
        }
        /// <p>The status of the file share.</p>
        ///
        /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
        /// <code>DELETING</code>
        /// </p>
        pub fn file_share_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_status = Some(input.into());
            self
        }
        /// <p>The status of the file share.</p>
        ///
        /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
        /// <code>DELETING</code>
        /// </p>
        pub fn set_file_share_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The file share path used by the SMB client to identify the mount point.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The file share path used by the SMB client to identify the mount point.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
        /// storage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
        /// storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_storage_class = Some(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_storage_class = input;
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that an S3 File Gateway puts objects into. The default value is
        /// <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.object_acl = Some(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that an S3 File Gateway puts objects into. The default value is
        /// <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.object_acl = input;
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.guess_mime_type_enabled = Some(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.guess_mime_type_enabled = input;
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.requester_pays = Some(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays = input;
            self
        }
        /// <p>If this value is set to <code>true</code>, it indicates that access control list (ACL)
        /// is enabled on the SMB file share. If it is set to <code>false</code>, it indicates that
        /// file and directory permissions are mapped to the POSIX permission.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        pub fn smbacl_enabled(mut self, input: bool) -> Self {
            self.smbacl_enabled = Some(input);
            self
        }
        /// <p>If this value is set to <code>true</code>, it indicates that access control list (ACL)
        /// is enabled on the SMB file share. If it is set to <code>false</code>, it indicates that
        /// file and directory permissions are mapped to the POSIX permission.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        pub fn set_smbacl_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.smbacl_enabled = input;
            self
        }
        /// <p>Indicates whether <code>AccessBasedEnumeration</code> is enabled.</p>
        pub fn access_based_enumeration(mut self, input: bool) -> Self {
            self.access_based_enumeration = Some(input);
            self
        }
        /// <p>Indicates whether <code>AccessBasedEnumeration</code> is enabled.</p>
        pub fn set_access_based_enumeration(mut self, input: std::option::Option<bool>) -> Self {
            self.access_based_enumeration = input;
            self
        }
        /// Appends an item to `admin_user_list`.
        ///
        /// To override the contents of this collection use [`set_admin_user_list`](Self::set_admin_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn admin_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.admin_user_list.unwrap_or_default();
            v.push(input.into());
            self.admin_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_admin_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.admin_user_list = input;
            self
        }
        /// Appends an item to `valid_user_list`.
        ///
        /// To override the contents of this collection use [`set_valid_user_list`](Self::set_valid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn valid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.valid_user_list.unwrap_or_default();
            v.push(input.into());
            self.valid_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_valid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.valid_user_list = input;
            self
        }
        /// Appends an item to `invalid_user_list`.
        ///
        /// To override the contents of this collection use [`set_invalid_user_list`](Self::set_invalid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn invalid_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.invalid_user_list.unwrap_or_default();
            v.push(input.into());
            self.invalid_user_list = Some(v);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_invalid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.invalid_user_list = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// <p>The authentication method of the file share. The default is
        /// <code>ActiveDirectory</code>.</p>
        ///
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code>
        /// </p>
        pub fn authentication(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication = Some(input.into());
            self
        }
        /// <p>The authentication method of the file share. The default is
        /// <code>ActiveDirectory</code>.</p>
        ///
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code>
        /// </p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn case_sensitivity(mut self, input: crate::model::CaseSensitivity) -> Self {
            self.case_sensitivity = Some(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn set_case_sensitivity(
            mut self,
            input: std::option::Option<crate::model::CaseSensitivity>,
        ) -> Self {
            self.case_sensitivity = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
        /// name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
        /// view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
        /// name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
        /// view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_name = Some(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_name = input;
            self
        }
        /// <p>Refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>Refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_policy = Some(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_policy = input;
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_dns_name = Some(input.into());
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_dns_name = input;
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_region = Some(input.into());
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_region = input;
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn oplocks_enabled(mut self, input: bool) -> Self {
            self.oplocks_enabled = Some(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_oplocks_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.oplocks_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`SmbFileShareInfo`](crate::model::SmbFileShareInfo)
        pub fn build(self) -> crate::model::SmbFileShareInfo {
            crate::model::SmbFileShareInfo {
                file_share_arn: self.file_share_arn,
                file_share_id: self.file_share_id,
                file_share_status: self.file_share_status,
                gateway_arn: self.gateway_arn,
                kms_encrypted: self.kms_encrypted.unwrap_or_default(),
                kms_key: self.kms_key,
                path: self.path,
                role: self.role,
                location_arn: self.location_arn,
                default_storage_class: self.default_storage_class,
                object_acl: self.object_acl,
                read_only: self.read_only,
                guess_mime_type_enabled: self.guess_mime_type_enabled,
                requester_pays: self.requester_pays,
                smbacl_enabled: self.smbacl_enabled,
                access_based_enumeration: self.access_based_enumeration,
                admin_user_list: self.admin_user_list,
                valid_user_list: self.valid_user_list,
                invalid_user_list: self.invalid_user_list,
                audit_destination_arn: self.audit_destination_arn,
                authentication: self.authentication,
                case_sensitivity: self.case_sensitivity,
                tags: self.tags,
                file_share_name: self.file_share_name,
                cache_attributes: self.cache_attributes,
                notification_policy: self.notification_policy,
                vpc_endpoint_dns_name: self.vpc_endpoint_dns_name,
                bucket_region: self.bucket_region,
                oplocks_enabled: self.oplocks_enabled,
            }
        }
    }
}
impl SmbFileShareInfo {
    /// Creates a new builder-style object to manufacture [`SmbFileShareInfo`](crate::model::SmbFileShareInfo)
    pub fn builder() -> crate::model::smb_file_share_info::Builder {
        crate::model::smb_file_share_info::Builder::default()
    }
}

/// <p>The Unix file permissions and ownership information assigned, by default, to native S3
/// objects when an S3 File Gateway discovers them in S3 buckets. This operation is only
/// supported in S3 File Gateways.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NfsFileShareInfo {
    /// <p>Describes Network File System (NFS) file share default values. Files and folders stored
    /// as Amazon S3 objects in S3 buckets don't, by default, have Unix file
    /// permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3
    /// objects that represent files and folders are assigned these default Unix permissions. This
    /// operation is only supported for S3 File Gateways.</p>
    pub nfs_file_share_defaults: std::option::Option<crate::model::NfsFileShareDefaults>,
    /// <p>The Amazon Resource Name (ARN) of the file share.</p>
    pub file_share_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the file share.</p>
    pub file_share_id: std::option::Option<std::string::String>,
    /// <p>The status of the file share.</p>
    ///
    /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
    /// <code>DELETING</code>
    /// </p>
    pub file_share_status: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
    /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
    /// Optional.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub kms_encrypted: bool,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The file share path used by the NFS client to identify the mount point.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
    /// storage.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
    /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
    /// slash (/).</p>
    /// <note>
    /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
    /// as shown in the following examples.</p>
    ///
    /// <p>Bucket ARN:</p>
    /// <p>
    /// <code>arn:aws:s3:::my-bucket/prefix/</code>
    /// </p>
    ///
    /// <p>Access point ARN:</p>
    /// <p>
    /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
    /// </p>
    ///
    /// <p>If you specify an access point, the bucket policy must be configured to delegate
    /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///
    /// <p>Access point alias:</p>
    /// <p>
    /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
    /// </p>
    /// </note>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
    /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
    ///
    /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
    /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
    /// </p>
    pub default_storage_class: std::option::Option<std::string::String>,
    /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
    /// that an S3 File Gateway puts objects into. The default value is
    /// <code>private</code>.</p>
    pub object_acl: std::option::Option<crate::model::ObjectAcl>,
    /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
    /// contain either valid IP addresses or valid CIDR blocks.</p>
    pub client_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user mapped to anonymous user. Valid options are the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
    /// </li>
    /// </ul>
    pub squash: std::option::Option<std::string::String>,
    /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
    /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub read_only: std::option::Option<bool>,
    /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
    /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
    /// to <code>false</code>. The default value is <code>true</code>.</p>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub guess_mime_type_enabled: std::option::Option<bool>,
    /// <p>A value that sets who pays the cost of the request and the cost associated with data
    /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
    /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
    /// the cost of storing data.</p>
    ///
    /// <note>
    /// <p>
    /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
    /// share, so make sure that the configuration on the file share is the same as the S3
    /// bucket configuration.</p>
    /// </note>
    ///
    /// <p>Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub requester_pays: std::option::Option<bool>,
    /// <p>A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key
    /// name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
    /// view all tags using the <code>ListTagsForResource</code> API operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the file share. Optional.</p>
    ///
    /// <note>
    /// <p>
    /// <code>FileShareName</code> must be set if an S3 prefix name is set in
    /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
    /// </note>
    pub file_share_name: std::option::Option<std::string::String>,
    /// <p>Refresh cache information for the file share.</p>
    pub cache_attributes: std::option::Option<crate::model::CacheAttributes>,
    /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
    /// the number of seconds to wait after the last point in time a client wrote to a file before
    /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
    /// writes to files, it's best to set this parameter for as long as possible to avoid
    /// generating multiple notifications for the same file in a small time period.</p>
    ///
    /// <note>
    /// <p>
    /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
    /// uploading to Amazon S3, only the timing of the notification.</p>
    /// </note>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> on with
    /// <code>SettlingTimeInSeconds</code> set to 60.</p>
    ///
    /// <p>
    /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
    /// </p>
    ///
    /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
    ///
    /// <p>
    /// <code>{}</code>
    /// </p>
    pub notification_policy: std::option::Option<std::string::String>,
    /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to
    /// Amazon S3.</p>
    /// <note>
    /// <p>This parameter is required for NFS file shares that connect to Amazon S3
    /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
    /// VPC access point.</p>
    /// </note>
    pub vpc_endpoint_dns_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p>
    /// <note>
    /// <p>This parameter is required for NFS file shares that connect to Amazon S3
    /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
    /// VPC access point.</p>
    /// </note>
    pub bucket_region: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
    pub audit_destination_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NfsFileShareInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NfsFileShareInfo");
        formatter.field("nfs_file_share_defaults", &self.nfs_file_share_defaults);
        formatter.field("file_share_arn", &self.file_share_arn);
        formatter.field("file_share_id", &self.file_share_id);
        formatter.field("file_share_status", &self.file_share_status);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("kms_encrypted", &self.kms_encrypted);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("path", &self.path);
        formatter.field("role", &self.role);
        formatter.field("location_arn", &self.location_arn);
        formatter.field("default_storage_class", &self.default_storage_class);
        formatter.field("object_acl", &self.object_acl);
        formatter.field("client_list", &self.client_list);
        formatter.field("squash", &self.squash);
        formatter.field("read_only", &self.read_only);
        formatter.field("guess_mime_type_enabled", &self.guess_mime_type_enabled);
        formatter.field("requester_pays", &self.requester_pays);
        formatter.field("tags", &self.tags);
        formatter.field("file_share_name", &self.file_share_name);
        formatter.field("cache_attributes", &self.cache_attributes);
        formatter.field("notification_policy", &self.notification_policy);
        formatter.field("vpc_endpoint_dns_name", &self.vpc_endpoint_dns_name);
        formatter.field("bucket_region", &self.bucket_region);
        formatter.field("audit_destination_arn", &self.audit_destination_arn);
        formatter.finish()
    }
}
/// See [`NfsFileShareInfo`](crate::model::NfsFileShareInfo)
pub mod nfs_file_share_info {
    /// A builder for [`NfsFileShareInfo`](crate::model::NfsFileShareInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nfs_file_share_defaults: std::option::Option<crate::model::NfsFileShareDefaults>,
        pub(crate) file_share_arn: std::option::Option<std::string::String>,
        pub(crate) file_share_id: std::option::Option<std::string::String>,
        pub(crate) file_share_status: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) kms_encrypted: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) default_storage_class: std::option::Option<std::string::String>,
        pub(crate) object_acl: std::option::Option<crate::model::ObjectAcl>,
        pub(crate) client_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) squash: std::option::Option<std::string::String>,
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) guess_mime_type_enabled: std::option::Option<bool>,
        pub(crate) requester_pays: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_share_name: std::option::Option<std::string::String>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) notification_policy: std::option::Option<std::string::String>,
        pub(crate) vpc_endpoint_dns_name: std::option::Option<std::string::String>,
        pub(crate) bucket_region: std::option::Option<std::string::String>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes Network File System (NFS) file share default values. Files and folders stored
        /// as Amazon S3 objects in S3 buckets don't, by default, have Unix file
        /// permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3
        /// objects that represent files and folders are assigned these default Unix permissions. This
        /// operation is only supported for S3 File Gateways.</p>
        pub fn nfs_file_share_defaults(
            mut self,
            input: crate::model::NfsFileShareDefaults,
        ) -> Self {
            self.nfs_file_share_defaults = Some(input);
            self
        }
        /// <p>Describes Network File System (NFS) file share default values. Files and folders stored
        /// as Amazon S3 objects in S3 buckets don't, by default, have Unix file
        /// permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3
        /// objects that represent files and folders are assigned these default Unix permissions. This
        /// operation is only supported for S3 File Gateways.</p>
        pub fn set_nfs_file_share_defaults(
            mut self,
            input: std::option::Option<crate::model::NfsFileShareDefaults>,
        ) -> Self {
            self.nfs_file_share_defaults = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_arn = input;
            self
        }
        /// <p>The ID of the file share.</p>
        pub fn file_share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_id = Some(input.into());
            self
        }
        /// <p>The ID of the file share.</p>
        pub fn set_file_share_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_id = input;
            self
        }
        /// <p>The status of the file share.</p>
        ///
        /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
        /// <code>DELETING</code>
        /// </p>
        pub fn file_share_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_status = Some(input.into());
            self
        }
        /// <p>The status of the file share.</p>
        ///
        /// <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> |
        /// <code>DELETING</code>
        /// </p>
        pub fn set_file_share_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, input: bool) -> Self {
            self.kms_encrypted = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.kms_encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The file share path used by the NFS client to identify the mount point.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The file share path used by the NFS client to identify the mount point.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
        /// storage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
        /// storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_storage_class = Some(input.into());
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_storage_class = input;
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that an S3 File Gateway puts objects into. The default value is
        /// <code>private</code>.</p>
        pub fn object_acl(mut self, input: crate::model::ObjectAcl) -> Self {
            self.object_acl = Some(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that an S3 File Gateway puts objects into. The default value is
        /// <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.object_acl = input;
            self
        }
        /// Appends an item to `client_list`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn client_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.client_list.unwrap_or_default();
            v.push(input.into());
            self.client_list = Some(v);
            self
        }
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.client_list = input;
            self
        }
        /// <p>The user mapped to anonymous user. Valid options are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn squash(mut self, input: impl Into<std::string::String>) -> Self {
            self.squash = Some(input.into());
            self
        }
        /// <p>The user mapped to anonymous user. Valid options are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn set_squash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.squash = input;
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, input: bool) -> Self {
            self.guess_mime_type_enabled = Some(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.guess_mime_type_enabled = input;
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.requester_pays = Some(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key
        /// name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
        /// view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key
        /// name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
        /// view all tags using the <code>ListTagsForResource</code> API operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_share_name = Some(input.into());
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_share_name = input;
            self
        }
        /// <p>Refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>Refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_policy = Some(input.into());
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_policy = input;
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_dns_name = Some(input.into());
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_dns_name = input;
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_region = Some(input.into());
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_region = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NfsFileShareInfo`](crate::model::NfsFileShareInfo)
        pub fn build(self) -> crate::model::NfsFileShareInfo {
            crate::model::NfsFileShareInfo {
                nfs_file_share_defaults: self.nfs_file_share_defaults,
                file_share_arn: self.file_share_arn,
                file_share_id: self.file_share_id,
                file_share_status: self.file_share_status,
                gateway_arn: self.gateway_arn,
                kms_encrypted: self.kms_encrypted.unwrap_or_default(),
                kms_key: self.kms_key,
                path: self.path,
                role: self.role,
                location_arn: self.location_arn,
                default_storage_class: self.default_storage_class,
                object_acl: self.object_acl,
                client_list: self.client_list,
                squash: self.squash,
                read_only: self.read_only,
                guess_mime_type_enabled: self.guess_mime_type_enabled,
                requester_pays: self.requester_pays,
                tags: self.tags,
                file_share_name: self.file_share_name,
                cache_attributes: self.cache_attributes,
                notification_policy: self.notification_policy,
                vpc_endpoint_dns_name: self.vpc_endpoint_dns_name,
                bucket_region: self.bucket_region,
                audit_destination_arn: self.audit_destination_arn,
            }
        }
    }
}
impl NfsFileShareInfo {
    /// Creates a new builder-style object to manufacture [`NfsFileShareInfo`](crate::model::NfsFileShareInfo)
    pub fn builder() -> crate::model::nfs_file_share_info::Builder {
        crate::model::nfs_file_share_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HostEnvironment {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    HyperV,
    #[allow(missing_docs)] // documentation missing in model
    Kvm,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    Vmware,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HostEnvironment {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => HostEnvironment::Ec2,
            "HYPER-V" => HostEnvironment::HyperV,
            "KVM" => HostEnvironment::Kvm,
            "OTHER" => HostEnvironment::Other,
            "VMWARE" => HostEnvironment::Vmware,
            other => HostEnvironment::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HostEnvironment {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HostEnvironment::from(s))
    }
}
impl HostEnvironment {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HostEnvironment::Ec2 => "EC2",
            HostEnvironment::HyperV => "HYPER-V",
            HostEnvironment::Kvm => "KVM",
            HostEnvironment::Other => "OTHER",
            HostEnvironment::Vmware => "VMWARE",
            HostEnvironment::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "HYPER-V", "KVM", "OTHER", "VMWARE"]
    }
}
impl AsRef<str> for HostEnvironment {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a gateway's network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>The Internet Protocol version 4 (IPv4) address of the interface.</p>
    pub ipv4_address: std::option::Option<std::string::String>,
    /// <p>The Media Access Control (MAC) address of the interface.</p>
    ///
    /// <note>
    /// <p>This is currently unsupported and will not be returned in output.</p>
    /// </note>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not
    /// supported</i>.</p>
    pub ipv6_address: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("ipv4_address", &self.ipv4_address);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("ipv6_address", &self.ipv6_address);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv4_address: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) ipv6_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Internet Protocol version 4 (IPv4) address of the interface.</p>
        pub fn ipv4_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv4_address = Some(input.into());
            self
        }
        /// <p>The Internet Protocol version 4 (IPv4) address of the interface.</p>
        pub fn set_ipv4_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv4_address = input;
            self
        }
        /// <p>The Media Access Control (MAC) address of the interface.</p>
        ///
        /// <note>
        /// <p>This is currently unsupported and will not be returned in output.</p>
        /// </note>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The Media Access Control (MAC) address of the interface.</p>
        ///
        /// <note>
        /// <p>This is currently unsupported and will not be returned in output.</p>
        /// </note>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// <p>The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not
        /// supported</i>.</p>
        pub fn ipv6_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_address = Some(input.into());
            self
        }
        /// <p>The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not
        /// supported</i>.</p>
        pub fn set_ipv6_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_address = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                ipv4_address: self.ipv4_address,
                mac_address: self.mac_address,
                ipv6_address: self.ipv6_address,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>Describes the object returned by <code>DescribeFileSystemAssociations</code> that
/// describes a created file system association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemAssociationInfo {
    /// <p>The Amazon Resource Name (ARN) of the file system association.</p>
    pub file_system_association_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the backend Amazon FSx file system used for storing file data. For
    /// information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the
    /// <i>Amazon FSx API Reference</i>.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The status of the file system association. Valid Values: <code>AVAILABLE</code> |
    /// <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> |
    /// <code>UPDATING</code> | <code>ERROR</code>
    /// </p>
    pub file_system_association_status: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
    pub audit_destination_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
    /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
    /// name. Each tag is a key-value pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The refresh cache information for the file share or FSx file systems.</p>
    pub cache_attributes: std::option::Option<crate::model::CacheAttributes>,
    /// <p>Specifies network configuration information for the gateway associated with the Amazon FSx file system.</p>
    /// <note>
    /// <p>If multiple file systems are associated with this gateway, this parameter's
    /// <code>IpAddresses</code> field is required.</p>
    /// </note>
    pub endpoint_network_configuration:
        std::option::Option<crate::model::EndpointNetworkConfiguration>,
    /// <p>An array containing the FileSystemAssociationStatusDetail data type, which provides
    /// detailed information on file system association status.</p>
    pub file_system_association_status_details:
        std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationStatusDetail>>,
}
impl std::fmt::Debug for FileSystemAssociationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemAssociationInfo");
        formatter.field(
            "file_system_association_arn",
            &self.file_system_association_arn,
        );
        formatter.field("location_arn", &self.location_arn);
        formatter.field(
            "file_system_association_status",
            &self.file_system_association_status,
        );
        formatter.field("audit_destination_arn", &self.audit_destination_arn);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("tags", &self.tags);
        formatter.field("cache_attributes", &self.cache_attributes);
        formatter.field(
            "endpoint_network_configuration",
            &self.endpoint_network_configuration,
        );
        formatter.field(
            "file_system_association_status_details",
            &self.file_system_association_status_details,
        );
        formatter.finish()
    }
}
/// See [`FileSystemAssociationInfo`](crate::model::FileSystemAssociationInfo)
pub mod file_system_association_info {
    /// A builder for [`FileSystemAssociationInfo`](crate::model::FileSystemAssociationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_association_arn: std::option::Option<std::string::String>,
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) file_system_association_status: std::option::Option<std::string::String>,
        pub(crate) audit_destination_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) cache_attributes: std::option::Option<crate::model::CacheAttributes>,
        pub(crate) endpoint_network_configuration:
            std::option::Option<crate::model::EndpointNetworkConfiguration>,
        pub(crate) file_system_association_status_details:
            std::option::Option<std::vec::Vec<crate::model::FileSystemAssociationStatusDetail>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the file system association.</p>
        pub fn file_system_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_arn = input;
            self
        }
        /// <p>The ARN of the backend Amazon FSx file system used for storing file data. For
        /// information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the
        /// <i>Amazon FSx API Reference</i>.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the backend Amazon FSx file system used for storing file data. For
        /// information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the
        /// <i>Amazon FSx API Reference</i>.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The status of the file system association. Valid Values: <code>AVAILABLE</code> |
        /// <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> |
        /// <code>UPDATING</code> | <code>ERROR</code>
        /// </p>
        pub fn file_system_association_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_association_status = Some(input.into());
            self
        }
        /// <p>The status of the file system association. Valid Values: <code>AVAILABLE</code> |
        /// <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> |
        /// <code>UPDATING</code> | <code>ERROR</code>
        /// </p>
        pub fn set_file_system_association_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_association_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn audit_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_destination_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
        /// name. Each tag is a key-value pair.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
        /// name. Each tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn cache_attributes(mut self, input: crate::model::CacheAttributes) -> Self {
            self.cache_attributes = Some(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.cache_attributes = input;
            self
        }
        /// <p>Specifies network configuration information for the gateway associated with the Amazon FSx file system.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's
        /// <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn endpoint_network_configuration(
            mut self,
            input: crate::model::EndpointNetworkConfiguration,
        ) -> Self {
            self.endpoint_network_configuration = Some(input);
            self
        }
        /// <p>Specifies network configuration information for the gateway associated with the Amazon FSx file system.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's
        /// <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn set_endpoint_network_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointNetworkConfiguration>,
        ) -> Self {
            self.endpoint_network_configuration = input;
            self
        }
        /// Appends an item to `file_system_association_status_details`.
        ///
        /// To override the contents of this collection use [`set_file_system_association_status_details`](Self::set_file_system_association_status_details).
        ///
        /// <p>An array containing the FileSystemAssociationStatusDetail data type, which provides
        /// detailed information on file system association status.</p>
        pub fn file_system_association_status_details(
            mut self,
            input: impl Into<crate::model::FileSystemAssociationStatusDetail>,
        ) -> Self {
            let mut v = self
                .file_system_association_status_details
                .unwrap_or_default();
            v.push(input.into());
            self.file_system_association_status_details = Some(v);
            self
        }
        /// <p>An array containing the FileSystemAssociationStatusDetail data type, which provides
        /// detailed information on file system association status.</p>
        pub fn set_file_system_association_status_details(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::FileSystemAssociationStatusDetail>,
            >,
        ) -> Self {
            self.file_system_association_status_details = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemAssociationInfo`](crate::model::FileSystemAssociationInfo)
        pub fn build(self) -> crate::model::FileSystemAssociationInfo {
            crate::model::FileSystemAssociationInfo {
                file_system_association_arn: self.file_system_association_arn,
                location_arn: self.location_arn,
                file_system_association_status: self.file_system_association_status,
                audit_destination_arn: self.audit_destination_arn,
                gateway_arn: self.gateway_arn,
                tags: self.tags,
                cache_attributes: self.cache_attributes,
                endpoint_network_configuration: self.endpoint_network_configuration,
                file_system_association_status_details: self.file_system_association_status_details,
            }
        }
    }
}
impl FileSystemAssociationInfo {
    /// Creates a new builder-style object to manufacture [`FileSystemAssociationInfo`](crate::model::FileSystemAssociationInfo)
    pub fn builder() -> crate::model::file_system_association_info::Builder {
        crate::model::file_system_association_info::Builder::default()
    }
}

/// <p>Detailed information on file system association status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemAssociationStatusDetail {
    /// <p>The error code for a given file system association status.</p>
    pub error_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FileSystemAssociationStatusDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemAssociationStatusDetail");
        formatter.field("error_code", &self.error_code);
        formatter.finish()
    }
}
/// See [`FileSystemAssociationStatusDetail`](crate::model::FileSystemAssociationStatusDetail)
pub mod file_system_association_status_detail {
    /// A builder for [`FileSystemAssociationStatusDetail`](crate::model::FileSystemAssociationStatusDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code for a given file system association status.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code for a given file system association status.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemAssociationStatusDetail`](crate::model::FileSystemAssociationStatusDetail)
        pub fn build(self) -> crate::model::FileSystemAssociationStatusDetail {
            crate::model::FileSystemAssociationStatusDetail {
                error_code: self.error_code,
            }
        }
    }
}
impl FileSystemAssociationStatusDetail {
    /// Creates a new builder-style object to manufacture [`FileSystemAssociationStatusDetail`](crate::model::FileSystemAssociationStatusDetail)
    pub fn builder() -> crate::model::file_system_association_status_detail::Builder {
        crate::model::file_system_association_status_detail::Builder::default()
    }
}

/// <p>Specifies network configuration information for the gateway associated with the Amazon FSx file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointNetworkConfiguration {
    /// <p>A list of gateway IP addresses on which the associated Amazon FSx file system is
    /// available.</p>
    /// <note>
    /// <p>If multiple file systems are associated with this gateway, this field is
    /// required.</p>
    /// </note>
    pub ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for EndpointNetworkConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointNetworkConfiguration");
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.finish()
    }
}
/// See [`EndpointNetworkConfiguration`](crate::model::EndpointNetworkConfiguration)
pub mod endpoint_network_configuration {
    /// A builder for [`EndpointNetworkConfiguration`](crate::model::EndpointNetworkConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>A list of gateway IP addresses on which the associated Amazon FSx file system is
        /// available.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this field is
        /// required.</p>
        /// </note>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>A list of gateway IP addresses on which the associated Amazon FSx file system is
        /// available.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this field is
        /// required.</p>
        /// </note>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointNetworkConfiguration`](crate::model::EndpointNetworkConfiguration)
        pub fn build(self) -> crate::model::EndpointNetworkConfiguration {
            crate::model::EndpointNetworkConfiguration {
                ip_addresses: self.ip_addresses,
            }
        }
    }
}
impl EndpointNetworkConfiguration {
    /// Creates a new builder-style object to manufacture [`EndpointNetworkConfiguration`](crate::model::EndpointNetworkConfiguration)
    pub fn builder() -> crate::model::endpoint_network_configuration::Builder {
        crate::model::endpoint_network_configuration::Builder::default()
    }
}

/// <p>Describes Challenge-Handshake Authentication Protocol (CHAP) information that supports
/// authentication between your gateway and iSCSI initiators.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChapInfo {
    /// <p>The Amazon Resource Name (ARN) of the volume.</p>
    ///
    /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The secret key that the initiator (for example, the Windows client) must provide to
    /// participate in mutual CHAP with the target.</p>
    pub secret_to_authenticate_initiator: std::option::Option<std::string::String>,
    /// <p>The iSCSI initiator that connects to the target.</p>
    pub initiator_name: std::option::Option<std::string::String>,
    /// <p>The secret key that the target must provide to participate in mutual CHAP with the
    /// initiator (e.g., Windows client).</p>
    pub secret_to_authenticate_target: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChapInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChapInfo");
        formatter.field("target_arn", &self.target_arn);
        formatter.field(
            "secret_to_authenticate_initiator",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("initiator_name", &self.initiator_name);
        formatter.field(
            "secret_to_authenticate_target",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.finish()
    }
}
/// See [`ChapInfo`](crate::model::ChapInfo)
pub mod chap_info {
    /// A builder for [`ChapInfo`](crate::model::ChapInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) secret_to_authenticate_initiator: std::option::Option<std::string::String>,
        pub(crate) initiator_name: std::option::Option<std::string::String>,
        pub(crate) secret_to_authenticate_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the volume.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume.</p>
        ///
        /// <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to
        /// participate in mutual CHAP with the target.</p>
        pub fn secret_to_authenticate_initiator(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_initiator = Some(input.into());
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to
        /// participate in mutual CHAP with the target.</p>
        pub fn set_secret_to_authenticate_initiator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_initiator = input;
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.initiator_name = Some(input.into());
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initiator_name = input;
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the
        /// initiator (e.g., Windows client).</p>
        pub fn secret_to_authenticate_target(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_target = Some(input.into());
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the
        /// initiator (e.g., Windows client).</p>
        pub fn set_secret_to_authenticate_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_to_authenticate_target = input;
            self
        }
        /// Consumes the builder and constructs a [`ChapInfo`](crate::model::ChapInfo)
        pub fn build(self) -> crate::model::ChapInfo {
            crate::model::ChapInfo {
                target_arn: self.target_arn,
                secret_to_authenticate_initiator: self.secret_to_authenticate_initiator,
                initiator_name: self.initiator_name,
                secret_to_authenticate_target: self.secret_to_authenticate_target,
            }
        }
    }
}
impl ChapInfo {
    /// Creates a new builder-style object to manufacture [`ChapInfo`](crate::model::ChapInfo)
    pub fn builder() -> crate::model::chap_info::Builder {
        crate::model::chap_info::Builder::default()
    }
}

/// <p>Describes an iSCSI cached volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachediScsiVolume {
    /// <p>The Amazon Resource Name (ARN) of the storage volume.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>One of the VolumeType enumeration values that describes the type of the volume.</p>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
    pub volume_status: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether a storage volume is attached to or detached from a
    /// gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
    /// your volumes to a different gateway</a>.</p>
    pub volume_attachment_status: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the volume capacity.</p>
    pub volume_size_in_bytes: i64,
    /// <p>Represents the percentage complete if the volume is restoring or bootstrapping that
    /// represents the percent of data transferred. This field does not appear in the response if
    /// the cached volume is not restoring or bootstrapping.</p>
    pub volume_progress: std::option::Option<f64>,
    /// <p>If the cached volume was created from a snapshot, this field contains the snapshot ID
    /// used, e.g., snap-78e22663. Otherwise, this field is not included.</p>
    pub source_snapshot_id: std::option::Option<std::string::String>,
    /// <p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
    /// attributes for one stored volume.</p>
    pub volumei_scsi_attributes: std::option::Option<crate::model::VolumeiScsiAttributes>,
    /// <p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
    /// timestamp.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The size of the data stored on the volume in bytes. This value is calculated based on
    /// the number of blocks that are touched, instead of the actual amount of data written. This
    /// value can be useful for sequential write patterns but less accurate for random write
    /// patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the
    /// volume, which is the value that is used to calculate your bill.</p>
    ///
    /// <note>
    /// <p>This value is not available for volumes created prior to May 13, 2015, until you
    /// store data on the volume.</p>
    /// </note>
    pub volume_used_in_bytes: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
    /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
    /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
    /// <i>myvolume</i> results in the target ARN of
    /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
    /// The target name must be unique across all volumes on a gateway.</p>
    ///
    /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
    /// used for this volume as the new target name.</p>
    pub target_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CachediScsiVolume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachediScsiVolume");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("volume_id", &self.volume_id);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("volume_status", &self.volume_status);
        formatter.field("volume_attachment_status", &self.volume_attachment_status);
        formatter.field("volume_size_in_bytes", &self.volume_size_in_bytes);
        formatter.field("volume_progress", &self.volume_progress);
        formatter.field("source_snapshot_id", &self.source_snapshot_id);
        formatter.field("volumei_scsi_attributes", &self.volumei_scsi_attributes);
        formatter.field("created_date", &self.created_date);
        formatter.field("volume_used_in_bytes", &self.volume_used_in_bytes);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("target_name", &self.target_name);
        formatter.finish()
    }
}
/// See [`CachediScsiVolume`](crate::model::CachediScsiVolume)
pub mod cachedi_scsi_volume {
    /// A builder for [`CachediScsiVolume`](crate::model::CachediScsiVolume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) volume_status: std::option::Option<std::string::String>,
        pub(crate) volume_attachment_status: std::option::Option<std::string::String>,
        pub(crate) volume_size_in_bytes: std::option::Option<i64>,
        pub(crate) volume_progress: std::option::Option<f64>,
        pub(crate) source_snapshot_id: std::option::Option<std::string::String>,
        pub(crate) volumei_scsi_attributes:
            std::option::Option<crate::model::VolumeiScsiAttributes>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) volume_used_in_bytes: std::option::Option<i64>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) target_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the storage volume.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage volume.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>One of the VolumeType enumeration values that describes the type of the volume.</p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>One of the VolumeType enumeration values that describes the type of the volume.</p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
        pub fn volume_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_status = Some(input.into());
            self
        }
        /// <p>One of the VolumeStatus values that indicates the state of the storage volume.</p>
        pub fn set_volume_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_status = input;
            self
        }
        /// <p>A value that indicates whether a storage volume is attached to or detached from a
        /// gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
        /// your volumes to a different gateway</a>.</p>
        pub fn volume_attachment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_attachment_status = Some(input.into());
            self
        }
        /// <p>A value that indicates whether a storage volume is attached to or detached from a
        /// gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
        /// your volumes to a different gateway</a>.</p>
        pub fn set_volume_attachment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_attachment_status = input;
            self
        }
        /// <p>The size, in bytes, of the volume capacity.</p>
        pub fn volume_size_in_bytes(mut self, input: i64) -> Self {
            self.volume_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the volume capacity.</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_size_in_bytes = input;
            self
        }
        /// <p>Represents the percentage complete if the volume is restoring or bootstrapping that
        /// represents the percent of data transferred. This field does not appear in the response if
        /// the cached volume is not restoring or bootstrapping.</p>
        pub fn volume_progress(mut self, input: f64) -> Self {
            self.volume_progress = Some(input);
            self
        }
        /// <p>Represents the percentage complete if the volume is restoring or bootstrapping that
        /// represents the percent of data transferred. This field does not appear in the response if
        /// the cached volume is not restoring or bootstrapping.</p>
        pub fn set_volume_progress(mut self, input: std::option::Option<f64>) -> Self {
            self.volume_progress = input;
            self
        }
        /// <p>If the cached volume was created from a snapshot, this field contains the snapshot ID
        /// used, e.g., snap-78e22663. Otherwise, this field is not included.</p>
        pub fn source_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_id = Some(input.into());
            self
        }
        /// <p>If the cached volume was created from a snapshot, this field contains the snapshot ID
        /// used, e.g., snap-78e22663. Otherwise, this field is not included.</p>
        pub fn set_source_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_id = input;
            self
        }
        /// <p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
        /// attributes for one stored volume.</p>
        pub fn volumei_scsi_attributes(
            mut self,
            input: crate::model::VolumeiScsiAttributes,
        ) -> Self {
            self.volumei_scsi_attributes = Some(input);
            self
        }
        /// <p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
        /// attributes for one stored volume.</p>
        pub fn set_volumei_scsi_attributes(
            mut self,
            input: std::option::Option<crate::model::VolumeiScsiAttributes>,
        ) -> Self {
            self.volumei_scsi_attributes = input;
            self
        }
        /// <p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
        /// timestamp.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
        /// timestamp.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The size of the data stored on the volume in bytes. This value is calculated based on
        /// the number of blocks that are touched, instead of the actual amount of data written. This
        /// value can be useful for sequential write patterns but less accurate for random write
        /// patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the
        /// volume, which is the value that is used to calculate your bill.</p>
        ///
        /// <note>
        /// <p>This value is not available for volumes created prior to May 13, 2015, until you
        /// store data on the volume.</p>
        /// </note>
        pub fn volume_used_in_bytes(mut self, input: i64) -> Self {
            self.volume_used_in_bytes = Some(input);
            self
        }
        /// <p>The size of the data stored on the volume in bytes. This value is calculated based on
        /// the number of blocks that are touched, instead of the actual amount of data written. This
        /// value can be useful for sequential write patterns but less accurate for random write
        /// patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the
        /// volume, which is the value that is used to calculate your bill.</p>
        ///
        /// <note>
        /// <p>This value is not available for volumes created prior to May 13, 2015, until you
        /// store data on the volume.</p>
        /// </note>
        pub fn set_volume_used_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_used_in_bytes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_name = Some(input.into());
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CachediScsiVolume`](crate::model::CachediScsiVolume)
        pub fn build(self) -> crate::model::CachediScsiVolume {
            crate::model::CachediScsiVolume {
                volume_arn: self.volume_arn,
                volume_id: self.volume_id,
                volume_type: self.volume_type,
                volume_status: self.volume_status,
                volume_attachment_status: self.volume_attachment_status,
                volume_size_in_bytes: self.volume_size_in_bytes.unwrap_or_default(),
                volume_progress: self.volume_progress,
                source_snapshot_id: self.source_snapshot_id,
                volumei_scsi_attributes: self.volumei_scsi_attributes,
                created_date: self.created_date,
                volume_used_in_bytes: self.volume_used_in_bytes,
                kms_key: self.kms_key,
                target_name: self.target_name,
            }
        }
    }
}
impl CachediScsiVolume {
    /// Creates a new builder-style object to manufacture [`CachediScsiVolume`](crate::model::CachediScsiVolume)
    pub fn builder() -> crate::model::cachedi_scsi_volume::Builder {
        crate::model::cachedi_scsi_volume::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AvailabilityMonitorTestStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AvailabilityMonitorTestStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => AvailabilityMonitorTestStatus::Complete,
            "FAILED" => AvailabilityMonitorTestStatus::Failed,
            "PENDING" => AvailabilityMonitorTestStatus::Pending,
            other => AvailabilityMonitorTestStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AvailabilityMonitorTestStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AvailabilityMonitorTestStatus::from(s))
    }
}
impl AvailabilityMonitorTestStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AvailabilityMonitorTestStatus::Complete => "COMPLETE",
            AvailabilityMonitorTestStatus::Failed => "FAILED",
            AvailabilityMonitorTestStatus::Pending => "PENDING",
            AvailabilityMonitorTestStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for AvailabilityMonitorTestStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
