// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ActivateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ActivateGatewayError {
    /// Kind of error that occurred.
    pub kind: ActivateGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ActivateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ActivateGatewayErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ActivateGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ActivateGatewayErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ActivateGatewayErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ActivateGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ActivateGatewayError {
    fn code(&self) -> Option<&str> {
        ActivateGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ActivateGatewayError {
    /// Creates a new `ActivateGatewayError`.
    pub fn new(kind: ActivateGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ActivateGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ActivateGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ActivateGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ActivateGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ActivateGatewayErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ActivateGatewayErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ActivateGatewayErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateGatewayErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ActivateGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ActivateGatewayErrorKind::InternalServerError(_inner) => Some(_inner),
            ActivateGatewayErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ActivateGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddCacheError {
    /// Kind of error that occurred.
    pub kind: AddCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddCacheErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddCacheErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddCacheErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            AddCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddCacheError {
    fn code(&self) -> Option<&str> {
        AddCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddCacheError {
    /// Creates a new `AddCacheError`.
    pub fn new(kind: AddCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddCacheErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AddCacheErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `AddCacheErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCacheErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for AddCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddCacheErrorKind::InternalServerError(_inner) => Some(_inner),
            AddCacheErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            AddCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToResourceErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToResourceError {
    /// Creates a new `AddTagsToResourceError`.
    pub fn new(kind: AddTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddTagsToResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `AddTagsToResourceErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for AddTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddUploadBuffer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddUploadBufferError {
    /// Kind of error that occurred.
    pub kind: AddUploadBufferErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddUploadBuffer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddUploadBufferErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddUploadBufferError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddUploadBufferErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddUploadBufferErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            AddUploadBufferErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddUploadBufferError {
    fn code(&self) -> Option<&str> {
        AddUploadBufferError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddUploadBufferError {
    /// Creates a new `AddUploadBufferError`.
    pub fn new(kind: AddUploadBufferErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddUploadBufferError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddUploadBufferErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddUploadBufferError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddUploadBufferErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddUploadBufferErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AddUploadBufferErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `AddUploadBufferErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddUploadBufferErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for AddUploadBufferError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddUploadBufferErrorKind::InternalServerError(_inner) => Some(_inner),
            AddUploadBufferErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            AddUploadBufferErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddWorkingStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddWorkingStorageError {
    /// Kind of error that occurred.
    pub kind: AddWorkingStorageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddWorkingStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddWorkingStorageErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddWorkingStorageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddWorkingStorageErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddWorkingStorageErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            AddWorkingStorageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddWorkingStorageError {
    fn code(&self) -> Option<&str> {
        AddWorkingStorageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddWorkingStorageError {
    /// Creates a new `AddWorkingStorageError`.
    pub fn new(kind: AddWorkingStorageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddWorkingStorageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddWorkingStorageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddWorkingStorageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddWorkingStorageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddWorkingStorageErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AddWorkingStorageErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `AddWorkingStorageErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddWorkingStorageErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for AddWorkingStorageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddWorkingStorageErrorKind::InternalServerError(_inner) => Some(_inner),
            AddWorkingStorageErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            AddWorkingStorageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssignTapePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssignTapePoolError {
    /// Kind of error that occurred.
    pub kind: AssignTapePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssignTapePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssignTapePoolErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssignTapePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssignTapePoolErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssignTapePoolErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            AssignTapePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssignTapePoolError {
    fn code(&self) -> Option<&str> {
        AssignTapePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssignTapePoolError {
    /// Creates a new `AssignTapePoolError`.
    pub fn new(kind: AssignTapePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssignTapePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssignTapePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssignTapePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssignTapePoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssignTapePoolErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AssignTapePoolErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `AssignTapePoolErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssignTapePoolErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for AssignTapePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssignTapePoolErrorKind::InternalServerError(_inner) => Some(_inner),
            AssignTapePoolErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            AssignTapePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateFileSystemError {
    /// Kind of error that occurred.
    pub kind: AssociateFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateFileSystemErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssociateFileSystemErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            AssociateFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateFileSystemError {
    fn code(&self) -> Option<&str> {
        AssociateFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateFileSystemError {
    /// Creates a new `AssociateFileSystemError`.
    pub fn new(kind: AssociateFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFileSystemErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `AssociateFileSystemErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFileSystemErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for AssociateFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            AssociateFileSystemErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            AssociateFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachVolumeError {
    /// Kind of error that occurred.
    pub kind: AttachVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachVolumeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AttachVolumeErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            AttachVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachVolumeError {
    fn code(&self) -> Option<&str> {
        AttachVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachVolumeError {
    /// Creates a new `AttachVolumeError`.
    pub fn new(kind: AttachVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachVolumeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AttachVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AttachVolumeErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `AttachVolumeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachVolumeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for AttachVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            AttachVolumeErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            AttachVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelArchival` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelArchivalError {
    /// Kind of error that occurred.
    pub kind: CancelArchivalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelArchival` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelArchivalErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelArchivalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelArchivalErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CancelArchivalErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CancelArchivalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelArchivalError {
    fn code(&self) -> Option<&str> {
        CancelArchivalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelArchivalError {
    /// Creates a new `CancelArchivalError`.
    pub fn new(kind: CancelArchivalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelArchivalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelArchivalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelArchivalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelArchivalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CancelArchivalErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CancelArchivalErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CancelArchivalErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelArchivalErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CancelArchivalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelArchivalErrorKind::InternalServerError(_inner) => Some(_inner),
            CancelArchivalErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CancelArchivalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelRetrieval` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelRetrievalError {
    /// Kind of error that occurred.
    pub kind: CancelRetrievalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelRetrieval` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelRetrievalErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelRetrievalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelRetrievalErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CancelRetrievalErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CancelRetrievalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelRetrievalError {
    fn code(&self) -> Option<&str> {
        CancelRetrievalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelRetrievalError {
    /// Creates a new `CancelRetrievalError`.
    pub fn new(kind: CancelRetrievalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelRetrievalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelRetrievalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelRetrievalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelRetrievalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CancelRetrievalErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CancelRetrievalErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CancelRetrievalErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelRetrievalErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CancelRetrievalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelRetrievalErrorKind::InternalServerError(_inner) => Some(_inner),
            CancelRetrievalErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CancelRetrievalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCachediSCSIVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCachediSCSIVolumeError {
    /// Kind of error that occurred.
    pub kind: CreateCachediSCSIVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCachediSCSIVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCachediSCSIVolumeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCachediSCSIVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCachediSCSIVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateCachediSCSIVolumeErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateCachediSCSIVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCachediSCSIVolumeError {
    fn code(&self) -> Option<&str> {
        CreateCachediSCSIVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCachediSCSIVolumeError {
    /// Creates a new `CreateCachediSCSIVolumeError`.
    pub fn new(kind: CreateCachediSCSIVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCachediSCSIVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCachediSCSIVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCachediSCSIVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCachediSCSIVolumeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateCachediSCSIVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachediSCSIVolumeErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `CreateCachediSCSIVolumeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachediSCSIVolumeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CreateCachediSCSIVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCachediSCSIVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateCachediSCSIVolumeErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            CreateCachediSCSIVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNFSFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNFSFileShareError {
    /// Kind of error that occurred.
    pub kind: CreateNFSFileShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNFSFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNFSFileShareErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNFSFileShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNFSFileShareErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateNFSFileShareErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CreateNFSFileShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNFSFileShareError {
    fn code(&self) -> Option<&str> {
        CreateNFSFileShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNFSFileShareError {
    /// Creates a new `CreateNFSFileShareError`.
    pub fn new(kind: CreateNFSFileShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNFSFileShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNFSFileShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNFSFileShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNFSFileShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateNFSFileShareErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateNFSFileShareErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `CreateNFSFileShareErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNFSFileShareErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CreateNFSFileShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNFSFileShareErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateNFSFileShareErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CreateNFSFileShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSMBFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSMBFileShareError {
    /// Kind of error that occurred.
    pub kind: CreateSMBFileShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSMBFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSMBFileShareErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSMBFileShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSMBFileShareErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateSMBFileShareErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CreateSMBFileShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSMBFileShareError {
    fn code(&self) -> Option<&str> {
        CreateSMBFileShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSMBFileShareError {
    /// Creates a new `CreateSMBFileShareError`.
    pub fn new(kind: CreateSMBFileShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSMBFileShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSMBFileShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSMBFileShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSMBFileShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSMBFileShareErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMBFileShareErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `CreateSMBFileShareErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMBFileShareErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CreateSMBFileShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSMBFileShareErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateSMBFileShareErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CreateSMBFileShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// <p>An internal server error has occurred because the service is unavailable. For more
    /// information, see the error and message fields.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ServiceUnavailableError(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotError {
    /// Creates a new `CreateSnapshotError`.
    pub fn new(kind: CreateSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::InvalidGatewayRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::ServiceUnavailableError(_)
        )
    }
}
impl std::error::Error for CreateSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateSnapshotErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ServiceUnavailableError(_inner) => Some(_inner),
            CreateSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshotFromVolumeRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotFromVolumeRecoveryPointError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotFromVolumeRecoveryPointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshotFromVolumeRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotFromVolumeRecoveryPointErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// <p>An internal server error has occurred because the service is unavailable. For more
    /// information, see the error and message fields.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotFromVolumeRecoveryPointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotFromVolumeRecoveryPointErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotFromVolumeRecoveryPointErrorKind::InvalidGatewayRequestException(
                _inner,
            ) => _inner.fmt(f),
            CreateSnapshotFromVolumeRecoveryPointErrorKind::ServiceUnavailableError(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotFromVolumeRecoveryPointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotFromVolumeRecoveryPointError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotFromVolumeRecoveryPointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotFromVolumeRecoveryPointError {
    /// Creates a new `CreateSnapshotFromVolumeRecoveryPointError`.
    pub fn new(
        kind: CreateSnapshotFromVolumeRecoveryPointErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotFromVolumeRecoveryPointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotFromVolumeRecoveryPointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotFromVolumeRecoveryPointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotFromVolumeRecoveryPointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSnapshotFromVolumeRecoveryPointErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotFromVolumeRecoveryPointErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotFromVolumeRecoveryPointErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotFromVolumeRecoveryPointErrorKind::InvalidGatewayRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotFromVolumeRecoveryPointErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotFromVolumeRecoveryPointErrorKind::ServiceUnavailableError(_)
        )
    }
}
impl std::error::Error for CreateSnapshotFromVolumeRecoveryPointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotFromVolumeRecoveryPointErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            CreateSnapshotFromVolumeRecoveryPointErrorKind::InvalidGatewayRequestException(
                _inner,
            ) => Some(_inner),
            CreateSnapshotFromVolumeRecoveryPointErrorKind::ServiceUnavailableError(_inner) => {
                Some(_inner)
            }
            CreateSnapshotFromVolumeRecoveryPointErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateStorediSCSIVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStorediSCSIVolumeError {
    /// Kind of error that occurred.
    pub kind: CreateStorediSCSIVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStorediSCSIVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStorediSCSIVolumeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStorediSCSIVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStorediSCSIVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateStorediSCSIVolumeErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateStorediSCSIVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStorediSCSIVolumeError {
    fn code(&self) -> Option<&str> {
        CreateStorediSCSIVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStorediSCSIVolumeError {
    /// Creates a new `CreateStorediSCSIVolumeError`.
    pub fn new(kind: CreateStorediSCSIVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStorediSCSIVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStorediSCSIVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStorediSCSIVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStorediSCSIVolumeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStorediSCSIVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorediSCSIVolumeErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `CreateStorediSCSIVolumeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorediSCSIVolumeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CreateStorediSCSIVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStorediSCSIVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateStorediSCSIVolumeErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            CreateStorediSCSIVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTapePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTapePoolError {
    /// Kind of error that occurred.
    pub kind: CreateTapePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTapePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTapePoolErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTapePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTapePoolErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateTapePoolErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CreateTapePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTapePoolError {
    fn code(&self) -> Option<&str> {
        CreateTapePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTapePoolError {
    /// Creates a new `CreateTapePoolError`.
    pub fn new(kind: CreateTapePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTapePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTapePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTapePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTapePoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTapePoolErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateTapePoolErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CreateTapePoolErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTapePoolErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CreateTapePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTapePoolErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateTapePoolErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CreateTapePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTapes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTapesError {
    /// Kind of error that occurred.
    pub kind: CreateTapesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTapes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTapesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTapesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTapesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateTapesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CreateTapesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTapesError {
    fn code(&self) -> Option<&str> {
        CreateTapesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTapesError {
    /// Creates a new `CreateTapesError`.
    pub fn new(kind: CreateTapesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTapesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTapesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTapesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTapesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTapesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateTapesErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CreateTapesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTapesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CreateTapesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTapesErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateTapesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CreateTapesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTapeWithBarcode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTapeWithBarcodeError {
    /// Kind of error that occurred.
    pub kind: CreateTapeWithBarcodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTapeWithBarcode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTapeWithBarcodeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTapeWithBarcodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTapeWithBarcodeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateTapeWithBarcodeErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            CreateTapeWithBarcodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTapeWithBarcodeError {
    fn code(&self) -> Option<&str> {
        CreateTapeWithBarcodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTapeWithBarcodeError {
    /// Creates a new `CreateTapeWithBarcodeError`.
    pub fn new(kind: CreateTapeWithBarcodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTapeWithBarcodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTapeWithBarcodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTapeWithBarcodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTapeWithBarcodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTapeWithBarcodeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateTapeWithBarcodeErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `CreateTapeWithBarcodeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTapeWithBarcodeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for CreateTapeWithBarcodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTapeWithBarcodeErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateTapeWithBarcodeErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            CreateTapeWithBarcodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAutomaticTapeCreationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAutomaticTapeCreationPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteAutomaticTapeCreationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAutomaticTapeCreationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAutomaticTapeCreationPolicyErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAutomaticTapeCreationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAutomaticTapeCreationPolicyErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DeleteAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAutomaticTapeCreationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAutomaticTapeCreationPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteAutomaticTapeCreationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAutomaticTapeCreationPolicyError {
    /// Creates a new `DeleteAutomaticTapeCreationPolicyError`.
    pub fn new(
        kind: DeleteAutomaticTapeCreationPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAutomaticTapeCreationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAutomaticTapeCreationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAutomaticTapeCreationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAutomaticTapeCreationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAutomaticTapeCreationPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutomaticTapeCreationPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteAutomaticTapeCreationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAutomaticTapeCreationPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DeleteAutomaticTapeCreationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBandwidthRateLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBandwidthRateLimitError {
    /// Kind of error that occurred.
    pub kind: DeleteBandwidthRateLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBandwidthRateLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBandwidthRateLimitErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBandwidthRateLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBandwidthRateLimitErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBandwidthRateLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBandwidthRateLimitError {
    fn code(&self) -> Option<&str> {
        DeleteBandwidthRateLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBandwidthRateLimitError {
    /// Creates a new `DeleteBandwidthRateLimitError`.
    pub fn new(kind: DeleteBandwidthRateLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBandwidthRateLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBandwidthRateLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBandwidthRateLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBandwidthRateLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteBandwidthRateLimitErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBandwidthRateLimitErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteBandwidthRateLimitErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteBandwidthRateLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBandwidthRateLimitErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DeleteBandwidthRateLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChapCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChapCredentialsError {
    /// Kind of error that occurred.
    pub kind: DeleteChapCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChapCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChapCredentialsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChapCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChapCredentialsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteChapCredentialsErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DeleteChapCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChapCredentialsError {
    fn code(&self) -> Option<&str> {
        DeleteChapCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChapCredentialsError {
    /// Creates a new `DeleteChapCredentialsError`.
    pub fn new(kind: DeleteChapCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChapCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChapCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChapCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChapCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChapCredentialsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChapCredentialsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteChapCredentialsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChapCredentialsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteChapCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChapCredentialsErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteChapCredentialsErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteChapCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFileShareError {
    /// Kind of error that occurred.
    pub kind: DeleteFileShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFileShareErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFileShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFileShareErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteFileShareErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DeleteFileShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFileShareError {
    fn code(&self) -> Option<&str> {
        DeleteFileShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFileShareError {
    /// Creates a new `DeleteFileShareError`.
    pub fn new(kind: DeleteFileShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFileShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFileShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFileShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFileShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteFileShareErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteFileShareErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DeleteFileShareErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileShareErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteFileShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFileShareErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteFileShareErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteFileShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGatewayError {
    /// Kind of error that occurred.
    pub kind: DeleteGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGatewayErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGatewayErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteGatewayErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DeleteGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGatewayError {
    fn code(&self) -> Option<&str> {
        DeleteGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGatewayError {
    /// Creates a new `DeleteGatewayError`.
    pub fn new(kind: DeleteGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteGatewayErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteGatewayErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DeleteGatewayErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGatewayErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteGatewayErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSnapshotScheduleError {
    /// Kind of error that occurred.
    pub kind: DeleteSnapshotScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSnapshotScheduleErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSnapshotScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSnapshotScheduleErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteSnapshotScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSnapshotScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSnapshotScheduleError {
    fn code(&self) -> Option<&str> {
        DeleteSnapshotScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSnapshotScheduleError {
    /// Creates a new `DeleteSnapshotScheduleError`.
    pub fn new(kind: DeleteSnapshotScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSnapshotScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSnapshotScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSnapshotScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSnapshotScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSnapshotScheduleErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotScheduleErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteSnapshotScheduleErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotScheduleErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteSnapshotScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSnapshotScheduleErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteSnapshotScheduleErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteSnapshotScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTape` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTapeError {
    /// Kind of error that occurred.
    pub kind: DeleteTapeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTape` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTapeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTapeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTapeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteTapeErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DeleteTapeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTapeError {
    fn code(&self) -> Option<&str> {
        DeleteTapeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTapeError {
    /// Creates a new `DeleteTapeError`.
    pub fn new(kind: DeleteTapeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTapeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTapeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTapeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTapeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTapeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteTapeErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DeleteTapeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTapeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteTapeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTapeErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteTapeErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteTapeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTapeArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTapeArchiveError {
    /// Kind of error that occurred.
    pub kind: DeleteTapeArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTapeArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTapeArchiveErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTapeArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTapeArchiveErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteTapeArchiveErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DeleteTapeArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTapeArchiveError {
    fn code(&self) -> Option<&str> {
        DeleteTapeArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTapeArchiveError {
    /// Creates a new `DeleteTapeArchiveError`.
    pub fn new(kind: DeleteTapeArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTapeArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTapeArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTapeArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTapeArchiveErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTapeArchiveErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTapeArchiveErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteTapeArchiveErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTapeArchiveErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteTapeArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTapeArchiveErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteTapeArchiveErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteTapeArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTapePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTapePoolError {
    /// Kind of error that occurred.
    pub kind: DeleteTapePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTapePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTapePoolErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTapePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTapePoolErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteTapePoolErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DeleteTapePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTapePoolError {
    fn code(&self) -> Option<&str> {
        DeleteTapePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTapePoolError {
    /// Creates a new `DeleteTapePoolError`.
    pub fn new(kind: DeleteTapePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTapePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTapePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTapePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTapePoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTapePoolErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteTapePoolErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DeleteTapePoolErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTapePoolErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteTapePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTapePoolErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteTapePoolErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteTapePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVolumeError {
    /// Kind of error that occurred.
    pub kind: DeleteVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVolumeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteVolumeErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DeleteVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVolumeError {
    fn code(&self) -> Option<&str> {
        DeleteVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVolumeError {
    /// Creates a new `DeleteVolumeError`.
    pub fn new(kind: DeleteVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVolumeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteVolumeErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DeleteVolumeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVolumeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DeleteVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteVolumeErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DeleteVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAvailabilityMonitorTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAvailabilityMonitorTestError {
    /// Kind of error that occurred.
    pub kind: DescribeAvailabilityMonitorTestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAvailabilityMonitorTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAvailabilityMonitorTestErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAvailabilityMonitorTestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAvailabilityMonitorTestErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAvailabilityMonitorTestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAvailabilityMonitorTestError {
    fn code(&self) -> Option<&str> {
        DescribeAvailabilityMonitorTestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAvailabilityMonitorTestError {
    /// Creates a new `DescribeAvailabilityMonitorTestError`.
    pub fn new(
        kind: DescribeAvailabilityMonitorTestErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAvailabilityMonitorTestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAvailabilityMonitorTestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAvailabilityMonitorTestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAvailabilityMonitorTestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAvailabilityMonitorTestErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityMonitorTestErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeAvailabilityMonitorTestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAvailabilityMonitorTestErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeAvailabilityMonitorTestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBandwidthRateLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBandwidthRateLimitError {
    /// Kind of error that occurred.
    pub kind: DescribeBandwidthRateLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBandwidthRateLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBandwidthRateLimitErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBandwidthRateLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBandwidthRateLimitErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBandwidthRateLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBandwidthRateLimitError {
    fn code(&self) -> Option<&str> {
        DescribeBandwidthRateLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBandwidthRateLimitError {
    /// Creates a new `DescribeBandwidthRateLimitError`.
    pub fn new(kind: DescribeBandwidthRateLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBandwidthRateLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBandwidthRateLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBandwidthRateLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBandwidthRateLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeBandwidthRateLimitErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBandwidthRateLimitErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeBandwidthRateLimitErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeBandwidthRateLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBandwidthRateLimitErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeBandwidthRateLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBandwidthRateLimitSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBandwidthRateLimitScheduleError {
    /// Kind of error that occurred.
    pub kind: DescribeBandwidthRateLimitScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBandwidthRateLimitSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBandwidthRateLimitScheduleErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBandwidthRateLimitScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBandwidthRateLimitScheduleErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBandwidthRateLimitScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBandwidthRateLimitScheduleError {
    fn code(&self) -> Option<&str> {
        DescribeBandwidthRateLimitScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBandwidthRateLimitScheduleError {
    /// Creates a new `DescribeBandwidthRateLimitScheduleError`.
    pub fn new(
        kind: DescribeBandwidthRateLimitScheduleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBandwidthRateLimitScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBandwidthRateLimitScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBandwidthRateLimitScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBandwidthRateLimitScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeBandwidthRateLimitScheduleErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBandwidthRateLimitScheduleErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeBandwidthRateLimitScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBandwidthRateLimitScheduleErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeBandwidthRateLimitScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCacheError {
    /// Kind of error that occurred.
    pub kind: DescribeCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCacheErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCacheErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeCacheErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCacheError {
    fn code(&self) -> Option<&str> {
        DescribeCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCacheError {
    /// Creates a new `DescribeCacheError`.
    pub fn new(kind: DescribeCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCacheErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeCacheErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DescribeCacheErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCacheErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCacheErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeCacheErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCachediSCSIVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCachediSCSIVolumesError {
    /// Kind of error that occurred.
    pub kind: DescribeCachediSCSIVolumesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCachediSCSIVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCachediSCSIVolumesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCachediSCSIVolumesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCachediSCSIVolumesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeCachediSCSIVolumesErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCachediSCSIVolumesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCachediSCSIVolumesError {
    fn code(&self) -> Option<&str> {
        DescribeCachediSCSIVolumesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCachediSCSIVolumesError {
    /// Creates a new `DescribeCachediSCSIVolumesError`.
    pub fn new(kind: DescribeCachediSCSIVolumesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCachediSCSIVolumesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCachediSCSIVolumesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCachediSCSIVolumesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCachediSCSIVolumesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCachediSCSIVolumesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCachediSCSIVolumesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeCachediSCSIVolumesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCachediSCSIVolumesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeCachediSCSIVolumesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCachediSCSIVolumesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeCachediSCSIVolumesErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeCachediSCSIVolumesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChapCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChapCredentialsError {
    /// Kind of error that occurred.
    pub kind: DescribeChapCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChapCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChapCredentialsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChapCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChapCredentialsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeChapCredentialsErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChapCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChapCredentialsError {
    fn code(&self) -> Option<&str> {
        DescribeChapCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChapCredentialsError {
    /// Creates a new `DescribeChapCredentialsError`.
    pub fn new(kind: DescribeChapCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChapCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChapCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChapCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChapCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChapCredentialsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChapCredentialsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeChapCredentialsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChapCredentialsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeChapCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChapCredentialsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeChapCredentialsErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeChapCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFileSystemAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFileSystemAssociationsError {
    /// Kind of error that occurred.
    pub kind: DescribeFileSystemAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFileSystemAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFileSystemAssociationsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFileSystemAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFileSystemAssociationsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeFileSystemAssociationsErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFileSystemAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFileSystemAssociationsError {
    fn code(&self) -> Option<&str> {
        DescribeFileSystemAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFileSystemAssociationsError {
    /// Creates a new `DescribeFileSystemAssociationsError`.
    pub fn new(
        kind: DescribeFileSystemAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFileSystemAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFileSystemAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFileSystemAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFileSystemAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeFileSystemAssociationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemAssociationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeFileSystemAssociationsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemAssociationsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeFileSystemAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFileSystemAssociationsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeFileSystemAssociationsErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeFileSystemAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGatewayInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGatewayInformationError {
    /// Kind of error that occurred.
    pub kind: DescribeGatewayInformationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGatewayInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGatewayInformationErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGatewayInformationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGatewayInformationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeGatewayInformationErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGatewayInformationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGatewayInformationError {
    fn code(&self) -> Option<&str> {
        DescribeGatewayInformationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGatewayInformationError {
    /// Creates a new `DescribeGatewayInformationError`.
    pub fn new(kind: DescribeGatewayInformationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGatewayInformationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGatewayInformationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGatewayInformationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGatewayInformationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeGatewayInformationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayInformationErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeGatewayInformationErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayInformationErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeGatewayInformationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGatewayInformationErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeGatewayInformationErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeGatewayInformationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMaintenanceStartTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceStartTimeError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceStartTimeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceStartTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceStartTimeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceStartTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceStartTimeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceStartTimeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceStartTimeError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceStartTimeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceStartTimeError {
    /// Creates a new `DescribeMaintenanceStartTimeError`.
    pub fn new(kind: DescribeMaintenanceStartTimeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceStartTimeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceStartTimeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceStartTimeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceStartTimeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeMaintenanceStartTimeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceStartTimeErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeMaintenanceStartTimeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceStartTimeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceStartTimeErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeMaintenanceStartTimeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNFSFileShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNFSFileSharesError {
    /// Kind of error that occurred.
    pub kind: DescribeNFSFileSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNFSFileShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNFSFileSharesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNFSFileSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNFSFileSharesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeNFSFileSharesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeNFSFileSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNFSFileSharesError {
    fn code(&self) -> Option<&str> {
        DescribeNFSFileSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNFSFileSharesError {
    /// Creates a new `DescribeNFSFileSharesError`.
    pub fn new(kind: DescribeNFSFileSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNFSFileSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNFSFileSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNFSFileSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNFSFileSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeNFSFileSharesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNFSFileSharesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeNFSFileSharesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNFSFileSharesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeNFSFileSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNFSFileSharesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeNFSFileSharesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeNFSFileSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSMBFileShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSMBFileSharesError {
    /// Kind of error that occurred.
    pub kind: DescribeSMBFileSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSMBFileShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSMBFileSharesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSMBFileSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSMBFileSharesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeSMBFileSharesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeSMBFileSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSMBFileSharesError {
    fn code(&self) -> Option<&str> {
        DescribeSMBFileSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSMBFileSharesError {
    /// Creates a new `DescribeSMBFileSharesError`.
    pub fn new(kind: DescribeSMBFileSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSMBFileSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSMBFileSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSMBFileSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSMBFileSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSMBFileSharesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSMBFileSharesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeSMBFileSharesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSMBFileSharesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeSMBFileSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSMBFileSharesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeSMBFileSharesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeSMBFileSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSMBSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSMBSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeSMBSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSMBSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSMBSettingsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSMBSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSMBSettingsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeSMBSettingsErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeSMBSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSMBSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeSMBSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSMBSettingsError {
    /// Creates a new `DescribeSMBSettingsError`.
    pub fn new(kind: DescribeSMBSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSMBSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSMBSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSMBSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSMBSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSMBSettingsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSMBSettingsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeSMBSettingsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSMBSettingsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeSMBSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSMBSettingsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeSMBSettingsErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeSMBSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSnapshotScheduleError {
    /// Kind of error that occurred.
    pub kind: DescribeSnapshotScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSnapshotScheduleErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSnapshotScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSnapshotScheduleErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeSnapshotScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSnapshotScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSnapshotScheduleError {
    fn code(&self) -> Option<&str> {
        DescribeSnapshotScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSnapshotScheduleError {
    /// Creates a new `DescribeSnapshotScheduleError`.
    pub fn new(kind: DescribeSnapshotScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSnapshotScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSnapshotScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSnapshotScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSnapshotScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSnapshotScheduleErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotScheduleErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeSnapshotScheduleErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotScheduleErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeSnapshotScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSnapshotScheduleErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeSnapshotScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeSnapshotScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStorediSCSIVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStorediSCSIVolumesError {
    /// Kind of error that occurred.
    pub kind: DescribeStorediSCSIVolumesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStorediSCSIVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStorediSCSIVolumesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStorediSCSIVolumesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStorediSCSIVolumesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeStorediSCSIVolumesErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeStorediSCSIVolumesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStorediSCSIVolumesError {
    fn code(&self) -> Option<&str> {
        DescribeStorediSCSIVolumesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStorediSCSIVolumesError {
    /// Creates a new `DescribeStorediSCSIVolumesError`.
    pub fn new(kind: DescribeStorediSCSIVolumesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStorediSCSIVolumesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStorediSCSIVolumesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStorediSCSIVolumesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStorediSCSIVolumesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeStorediSCSIVolumesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorediSCSIVolumesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeStorediSCSIVolumesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorediSCSIVolumesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeStorediSCSIVolumesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStorediSCSIVolumesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeStorediSCSIVolumesErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeStorediSCSIVolumesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTapeArchives` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTapeArchivesError {
    /// Kind of error that occurred.
    pub kind: DescribeTapeArchivesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTapeArchives` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTapeArchivesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTapeArchivesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTapeArchivesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTapeArchivesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeTapeArchivesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTapeArchivesError {
    fn code(&self) -> Option<&str> {
        DescribeTapeArchivesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTapeArchivesError {
    /// Creates a new `DescribeTapeArchivesError`.
    pub fn new(kind: DescribeTapeArchivesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTapeArchivesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTapeArchivesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTapeArchivesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTapeArchivesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTapeArchivesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTapeArchivesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeTapeArchivesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTapeArchivesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeTapeArchivesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTapeArchivesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTapeArchivesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeTapeArchivesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTapeRecoveryPoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTapeRecoveryPointsError {
    /// Kind of error that occurred.
    pub kind: DescribeTapeRecoveryPointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTapeRecoveryPoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTapeRecoveryPointsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTapeRecoveryPointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTapeRecoveryPointsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTapeRecoveryPointsErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTapeRecoveryPointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTapeRecoveryPointsError {
    fn code(&self) -> Option<&str> {
        DescribeTapeRecoveryPointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTapeRecoveryPointsError {
    /// Creates a new `DescribeTapeRecoveryPointsError`.
    pub fn new(kind: DescribeTapeRecoveryPointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTapeRecoveryPointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTapeRecoveryPointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTapeRecoveryPointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTapeRecoveryPointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTapeRecoveryPointsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTapeRecoveryPointsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeTapeRecoveryPointsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTapeRecoveryPointsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeTapeRecoveryPointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTapeRecoveryPointsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTapeRecoveryPointsErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            DescribeTapeRecoveryPointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTapes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTapesError {
    /// Kind of error that occurred.
    pub kind: DescribeTapesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTapes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTapesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTapesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTapesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTapesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeTapesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTapesError {
    fn code(&self) -> Option<&str> {
        DescribeTapesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTapesError {
    /// Creates a new `DescribeTapesError`.
    pub fn new(kind: DescribeTapesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTapesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTapesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTapesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTapesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTapesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeTapesErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DescribeTapesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTapesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeTapesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTapesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTapesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeTapesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUploadBuffer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUploadBufferError {
    /// Kind of error that occurred.
    pub kind: DescribeUploadBufferErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUploadBuffer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUploadBufferErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUploadBufferError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUploadBufferErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeUploadBufferErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeUploadBufferErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUploadBufferError {
    fn code(&self) -> Option<&str> {
        DescribeUploadBufferError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUploadBufferError {
    /// Creates a new `DescribeUploadBufferError`.
    pub fn new(kind: DescribeUploadBufferErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUploadBufferError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUploadBufferErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUploadBufferError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUploadBufferErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeUploadBufferErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUploadBufferErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeUploadBufferErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUploadBufferErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeUploadBufferError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUploadBufferErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeUploadBufferErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeUploadBufferErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVTLDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVTLDevicesError {
    /// Kind of error that occurred.
    pub kind: DescribeVTLDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVTLDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVTLDevicesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVTLDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVTLDevicesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeVTLDevicesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DescribeVTLDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVTLDevicesError {
    fn code(&self) -> Option<&str> {
        DescribeVTLDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVTLDevicesError {
    /// Creates a new `DescribeVTLDevicesError`.
    pub fn new(kind: DescribeVTLDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVTLDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVTLDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVTLDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVTLDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeVTLDevicesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVTLDevicesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeVTLDevicesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVTLDevicesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeVTLDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVTLDevicesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeVTLDevicesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeVTLDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkingStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkingStorageError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkingStorageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkingStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkingStorageErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkingStorageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkingStorageErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeWorkingStorageErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkingStorageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkingStorageError {
    fn code(&self) -> Option<&str> {
        DescribeWorkingStorageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkingStorageError {
    /// Creates a new `DescribeWorkingStorageError`.
    pub fn new(kind: DescribeWorkingStorageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkingStorageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkingStorageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkingStorageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkingStorageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeWorkingStorageErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkingStorageErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeWorkingStorageErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkingStorageErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DescribeWorkingStorageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkingStorageErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeWorkingStorageErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DescribeWorkingStorageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachVolumeError {
    /// Kind of error that occurred.
    pub kind: DetachVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachVolumeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DetachVolumeErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DetachVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachVolumeError {
    fn code(&self) -> Option<&str> {
        DetachVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachVolumeError {
    /// Creates a new `DetachVolumeError`.
    pub fn new(kind: DetachVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachVolumeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DetachVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DetachVolumeErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DetachVolumeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachVolumeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DetachVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            DetachVolumeErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DetachVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableGatewayError {
    /// Kind of error that occurred.
    pub kind: DisableGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableGatewayErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableGatewayErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DisableGatewayErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            DisableGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableGatewayError {
    fn code(&self) -> Option<&str> {
        DisableGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableGatewayError {
    /// Creates a new `DisableGatewayError`.
    pub fn new(kind: DisableGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisableGatewayErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DisableGatewayErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DisableGatewayErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableGatewayErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DisableGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableGatewayErrorKind::InternalServerError(_inner) => Some(_inner),
            DisableGatewayErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DisableGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateFileSystemError {
    /// Kind of error that occurred.
    pub kind: DisassociateFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateFileSystemErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DisassociateFileSystemErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateFileSystemError {
    fn code(&self) -> Option<&str> {
        DisassociateFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateFileSystemError {
    /// Creates a new `DisassociateFileSystemError`.
    pub fn new(kind: DisassociateFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFileSystemErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DisassociateFileSystemErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFileSystemErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for DisassociateFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            DisassociateFileSystemErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            DisassociateFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `JoinDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct JoinDomainError {
    /// Kind of error that occurred.
    pub kind: JoinDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `JoinDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum JoinDomainErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for JoinDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            JoinDomainErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            JoinDomainErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            JoinDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for JoinDomainError {
    fn code(&self) -> Option<&str> {
        JoinDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl JoinDomainError {
    /// Creates a new `JoinDomainError`.
    pub fn new(kind: JoinDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `JoinDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: JoinDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `JoinDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: JoinDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `JoinDomainErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, JoinDomainErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `JoinDomainErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            JoinDomainErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for JoinDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            JoinDomainErrorKind::InternalServerError(_inner) => Some(_inner),
            JoinDomainErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            JoinDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAutomaticTapeCreationPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAutomaticTapeCreationPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListAutomaticTapeCreationPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAutomaticTapeCreationPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAutomaticTapeCreationPoliciesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAutomaticTapeCreationPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAutomaticTapeCreationPoliciesErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            ListAutomaticTapeCreationPoliciesErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListAutomaticTapeCreationPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAutomaticTapeCreationPoliciesError {
    fn code(&self) -> Option<&str> {
        ListAutomaticTapeCreationPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAutomaticTapeCreationPoliciesError {
    /// Creates a new `ListAutomaticTapeCreationPoliciesError`.
    pub fn new(
        kind: ListAutomaticTapeCreationPoliciesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAutomaticTapeCreationPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAutomaticTapeCreationPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAutomaticTapeCreationPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAutomaticTapeCreationPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAutomaticTapeCreationPoliciesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListAutomaticTapeCreationPoliciesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `ListAutomaticTapeCreationPoliciesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAutomaticTapeCreationPoliciesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListAutomaticTapeCreationPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAutomaticTapeCreationPoliciesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListAutomaticTapeCreationPoliciesErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            ListAutomaticTapeCreationPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFileShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFileSharesError {
    /// Kind of error that occurred.
    pub kind: ListFileSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFileShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFileSharesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFileSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFileSharesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListFileSharesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListFileSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFileSharesError {
    fn code(&self) -> Option<&str> {
        ListFileSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFileSharesError {
    /// Creates a new `ListFileSharesError`.
    pub fn new(kind: ListFileSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFileSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFileSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFileSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFileSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListFileSharesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListFileSharesErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListFileSharesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFileSharesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListFileSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFileSharesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListFileSharesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListFileSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFileSystemAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFileSystemAssociationsError {
    /// Kind of error that occurred.
    pub kind: ListFileSystemAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFileSystemAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFileSystemAssociationsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFileSystemAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFileSystemAssociationsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListFileSystemAssociationsErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListFileSystemAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFileSystemAssociationsError {
    fn code(&self) -> Option<&str> {
        ListFileSystemAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFileSystemAssociationsError {
    /// Creates a new `ListFileSystemAssociationsError`.
    pub fn new(kind: ListFileSystemAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFileSystemAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFileSystemAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFileSystemAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFileSystemAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListFileSystemAssociationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListFileSystemAssociationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `ListFileSystemAssociationsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFileSystemAssociationsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListFileSystemAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFileSystemAssociationsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListFileSystemAssociationsErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            ListFileSystemAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGatewaysError {
    /// Kind of error that occurred.
    pub kind: ListGatewaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGatewaysErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGatewaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGatewaysErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListGatewaysErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListGatewaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGatewaysError {
    fn code(&self) -> Option<&str> {
        ListGatewaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGatewaysError {
    /// Creates a new `ListGatewaysError`.
    pub fn new(kind: ListGatewaysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGatewaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGatewaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGatewaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGatewaysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListGatewaysErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListGatewaysErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListGatewaysErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewaysErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListGatewaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGatewaysErrorKind::InternalServerError(_inner) => Some(_inner),
            ListGatewaysErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListGatewaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLocalDisks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLocalDisksError {
    /// Kind of error that occurred.
    pub kind: ListLocalDisksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLocalDisks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLocalDisksErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLocalDisksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLocalDisksErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListLocalDisksErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListLocalDisksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLocalDisksError {
    fn code(&self) -> Option<&str> {
        ListLocalDisksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLocalDisksError {
    /// Creates a new `ListLocalDisksError`.
    pub fn new(kind: ListLocalDisksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLocalDisksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLocalDisksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLocalDisksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLocalDisksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLocalDisksErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListLocalDisksErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListLocalDisksErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLocalDisksErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListLocalDisksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLocalDisksErrorKind::InternalServerError(_inner) => Some(_inner),
            ListLocalDisksErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListLocalDisksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTapePools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTapePoolsError {
    /// Kind of error that occurred.
    pub kind: ListTapePoolsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTapePools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTapePoolsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTapePoolsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTapePoolsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTapePoolsErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListTapePoolsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTapePoolsError {
    fn code(&self) -> Option<&str> {
        ListTapePoolsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTapePoolsError {
    /// Creates a new `ListTapePoolsError`.
    pub fn new(kind: ListTapePoolsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTapePoolsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTapePoolsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTapePoolsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTapePoolsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTapePoolsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListTapePoolsErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListTapePoolsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTapePoolsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListTapePoolsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTapePoolsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTapePoolsErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListTapePoolsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTapes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTapesError {
    /// Kind of error that occurred.
    pub kind: ListTapesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTapes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTapesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTapesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTapesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTapesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListTapesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTapesError {
    fn code(&self) -> Option<&str> {
        ListTapesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTapesError {
    /// Creates a new `ListTapesError`.
    pub fn new(kind: ListTapesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTapesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTapesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTapesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTapesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTapesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListTapesErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListTapesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTapesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListTapesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTapesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTapesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListTapesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVolumeInitiators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVolumeInitiatorsError {
    /// Kind of error that occurred.
    pub kind: ListVolumeInitiatorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVolumeInitiators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVolumeInitiatorsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVolumeInitiatorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVolumeInitiatorsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListVolumeInitiatorsErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListVolumeInitiatorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVolumeInitiatorsError {
    fn code(&self) -> Option<&str> {
        ListVolumeInitiatorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVolumeInitiatorsError {
    /// Creates a new `ListVolumeInitiatorsError`.
    pub fn new(kind: ListVolumeInitiatorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVolumeInitiatorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVolumeInitiatorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVolumeInitiatorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVolumeInitiatorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListVolumeInitiatorsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListVolumeInitiatorsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `ListVolumeInitiatorsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVolumeInitiatorsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListVolumeInitiatorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVolumeInitiatorsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListVolumeInitiatorsErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListVolumeInitiatorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVolumeRecoveryPoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVolumeRecoveryPointsError {
    /// Kind of error that occurred.
    pub kind: ListVolumeRecoveryPointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVolumeRecoveryPoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVolumeRecoveryPointsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVolumeRecoveryPointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVolumeRecoveryPointsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListVolumeRecoveryPointsErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListVolumeRecoveryPointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVolumeRecoveryPointsError {
    fn code(&self) -> Option<&str> {
        ListVolumeRecoveryPointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVolumeRecoveryPointsError {
    /// Creates a new `ListVolumeRecoveryPointsError`.
    pub fn new(kind: ListVolumeRecoveryPointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVolumeRecoveryPointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVolumeRecoveryPointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVolumeRecoveryPointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVolumeRecoveryPointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListVolumeRecoveryPointsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListVolumeRecoveryPointsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `ListVolumeRecoveryPointsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVolumeRecoveryPointsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListVolumeRecoveryPointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVolumeRecoveryPointsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListVolumeRecoveryPointsErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            ListVolumeRecoveryPointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVolumesError {
    /// Kind of error that occurred.
    pub kind: ListVolumesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVolumesErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVolumesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVolumesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListVolumesErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ListVolumesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVolumesError {
    fn code(&self) -> Option<&str> {
        ListVolumesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVolumesError {
    /// Creates a new `ListVolumesError`.
    pub fn new(kind: ListVolumesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVolumesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVolumesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVolumesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVolumesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListVolumesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListVolumesErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListVolumesErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVolumesErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ListVolumesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVolumesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListVolumesErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ListVolumesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `NotifyWhenUploaded` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct NotifyWhenUploadedError {
    /// Kind of error that occurred.
    pub kind: NotifyWhenUploadedErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `NotifyWhenUploaded` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum NotifyWhenUploadedErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for NotifyWhenUploadedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            NotifyWhenUploadedErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            NotifyWhenUploadedErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            NotifyWhenUploadedErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for NotifyWhenUploadedError {
    fn code(&self) -> Option<&str> {
        NotifyWhenUploadedError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl NotifyWhenUploadedError {
    /// Creates a new `NotifyWhenUploadedError`.
    pub fn new(kind: NotifyWhenUploadedErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `NotifyWhenUploadedError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: NotifyWhenUploadedErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `NotifyWhenUploadedError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: NotifyWhenUploadedErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `NotifyWhenUploadedErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            NotifyWhenUploadedErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `NotifyWhenUploadedErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyWhenUploadedErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for NotifyWhenUploadedError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            NotifyWhenUploadedErrorKind::InternalServerError(_inner) => Some(_inner),
            NotifyWhenUploadedErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            NotifyWhenUploadedErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RefreshCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RefreshCacheError {
    /// Kind of error that occurred.
    pub kind: RefreshCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RefreshCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RefreshCacheErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RefreshCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RefreshCacheErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RefreshCacheErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            RefreshCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RefreshCacheError {
    fn code(&self) -> Option<&str> {
        RefreshCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RefreshCacheError {
    /// Creates a new `RefreshCacheError`.
    pub fn new(kind: RefreshCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RefreshCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RefreshCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RefreshCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RefreshCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RefreshCacheErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, RefreshCacheErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `RefreshCacheErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RefreshCacheErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for RefreshCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RefreshCacheErrorKind::InternalServerError(_inner) => Some(_inner),
            RefreshCacheErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            RefreshCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromResourceErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromResourceError {
    /// Creates a new `RemoveTagsFromResourceError`.
    pub fn new(kind: RemoveTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RemoveTagsFromResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `RemoveTagsFromResourceErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetCacheError {
    /// Kind of error that occurred.
    pub kind: ResetCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetCacheErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetCacheErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ResetCacheErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ResetCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetCacheError {
    fn code(&self) -> Option<&str> {
        ResetCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetCacheError {
    /// Creates a new `ResetCacheError`.
    pub fn new(kind: ResetCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ResetCacheErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ResetCacheErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ResetCacheErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetCacheErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ResetCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetCacheErrorKind::InternalServerError(_inner) => Some(_inner),
            ResetCacheErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ResetCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetrieveTapeArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetrieveTapeArchiveError {
    /// Kind of error that occurred.
    pub kind: RetrieveTapeArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetrieveTapeArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetrieveTapeArchiveErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetrieveTapeArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetrieveTapeArchiveErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RetrieveTapeArchiveErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            RetrieveTapeArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetrieveTapeArchiveError {
    fn code(&self) -> Option<&str> {
        RetrieveTapeArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetrieveTapeArchiveError {
    /// Creates a new `RetrieveTapeArchiveError`.
    pub fn new(kind: RetrieveTapeArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetrieveTapeArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetrieveTapeArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetrieveTapeArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetrieveTapeArchiveErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RetrieveTapeArchiveErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RetrieveTapeArchiveErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `RetrieveTapeArchiveErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetrieveTapeArchiveErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for RetrieveTapeArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetrieveTapeArchiveErrorKind::InternalServerError(_inner) => Some(_inner),
            RetrieveTapeArchiveErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            RetrieveTapeArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetrieveTapeRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetrieveTapeRecoveryPointError {
    /// Kind of error that occurred.
    pub kind: RetrieveTapeRecoveryPointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetrieveTapeRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetrieveTapeRecoveryPointErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetrieveTapeRecoveryPointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetrieveTapeRecoveryPointErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RetrieveTapeRecoveryPointErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            RetrieveTapeRecoveryPointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetrieveTapeRecoveryPointError {
    fn code(&self) -> Option<&str> {
        RetrieveTapeRecoveryPointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetrieveTapeRecoveryPointError {
    /// Creates a new `RetrieveTapeRecoveryPointError`.
    pub fn new(kind: RetrieveTapeRecoveryPointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetrieveTapeRecoveryPointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetrieveTapeRecoveryPointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetrieveTapeRecoveryPointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetrieveTapeRecoveryPointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RetrieveTapeRecoveryPointErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RetrieveTapeRecoveryPointErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `RetrieveTapeRecoveryPointErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetrieveTapeRecoveryPointErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for RetrieveTapeRecoveryPointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetrieveTapeRecoveryPointErrorKind::InternalServerError(_inner) => Some(_inner),
            RetrieveTapeRecoveryPointErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            RetrieveTapeRecoveryPointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetLocalConsolePassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetLocalConsolePasswordError {
    /// Kind of error that occurred.
    pub kind: SetLocalConsolePasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetLocalConsolePassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetLocalConsolePasswordErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetLocalConsolePasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetLocalConsolePasswordErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            SetLocalConsolePasswordErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            SetLocalConsolePasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetLocalConsolePasswordError {
    fn code(&self) -> Option<&str> {
        SetLocalConsolePasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetLocalConsolePasswordError {
    /// Creates a new `SetLocalConsolePasswordError`.
    pub fn new(kind: SetLocalConsolePasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetLocalConsolePasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetLocalConsolePasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetLocalConsolePasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetLocalConsolePasswordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetLocalConsolePasswordErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            SetLocalConsolePasswordErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `SetLocalConsolePasswordErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLocalConsolePasswordErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for SetLocalConsolePasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetLocalConsolePasswordErrorKind::InternalServerError(_inner) => Some(_inner),
            SetLocalConsolePasswordErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            SetLocalConsolePasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetSMBGuestPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetSMBGuestPasswordError {
    /// Kind of error that occurred.
    pub kind: SetSMBGuestPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetSMBGuestPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetSMBGuestPasswordErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetSMBGuestPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetSMBGuestPasswordErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            SetSMBGuestPasswordErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            SetSMBGuestPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetSMBGuestPasswordError {
    fn code(&self) -> Option<&str> {
        SetSMBGuestPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetSMBGuestPasswordError {
    /// Creates a new `SetSMBGuestPasswordError`.
    pub fn new(kind: SetSMBGuestPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetSMBGuestPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetSMBGuestPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetSMBGuestPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetSMBGuestPasswordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetSMBGuestPasswordErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            SetSMBGuestPasswordErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `SetSMBGuestPasswordErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSMBGuestPasswordErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for SetSMBGuestPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetSMBGuestPasswordErrorKind::InternalServerError(_inner) => Some(_inner),
            SetSMBGuestPasswordErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            SetSMBGuestPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ShutdownGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ShutdownGatewayError {
    /// Kind of error that occurred.
    pub kind: ShutdownGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ShutdownGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ShutdownGatewayErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ShutdownGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ShutdownGatewayErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ShutdownGatewayErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            ShutdownGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ShutdownGatewayError {
    fn code(&self) -> Option<&str> {
        ShutdownGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ShutdownGatewayError {
    /// Creates a new `ShutdownGatewayError`.
    pub fn new(kind: ShutdownGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ShutdownGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ShutdownGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ShutdownGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ShutdownGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ShutdownGatewayErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ShutdownGatewayErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ShutdownGatewayErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShutdownGatewayErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for ShutdownGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ShutdownGatewayErrorKind::InternalServerError(_inner) => Some(_inner),
            ShutdownGatewayErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            ShutdownGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAvailabilityMonitorTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAvailabilityMonitorTestError {
    /// Kind of error that occurred.
    pub kind: StartAvailabilityMonitorTestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAvailabilityMonitorTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAvailabilityMonitorTestErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAvailabilityMonitorTestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAvailabilityMonitorTestErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            StartAvailabilityMonitorTestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAvailabilityMonitorTestError {
    fn code(&self) -> Option<&str> {
        StartAvailabilityMonitorTestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAvailabilityMonitorTestError {
    /// Creates a new `StartAvailabilityMonitorTestError`.
    pub fn new(kind: StartAvailabilityMonitorTestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAvailabilityMonitorTestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAvailabilityMonitorTestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAvailabilityMonitorTestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAvailabilityMonitorTestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartAvailabilityMonitorTestErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StartAvailabilityMonitorTestErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `StartAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for StartAvailabilityMonitorTestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAvailabilityMonitorTestErrorKind::InternalServerError(_inner) => Some(_inner),
            StartAvailabilityMonitorTestErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            StartAvailabilityMonitorTestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartGatewayError {
    /// Kind of error that occurred.
    pub kind: StartGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartGatewayErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartGatewayErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartGatewayErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            StartGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartGatewayError {
    fn code(&self) -> Option<&str> {
        StartGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartGatewayError {
    /// Creates a new `StartGatewayError`.
    pub fn new(kind: StartGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartGatewayErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, StartGatewayErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `StartGatewayErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGatewayErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for StartGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartGatewayErrorKind::InternalServerError(_inner) => Some(_inner),
            StartGatewayErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            StartGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAutomaticTapeCreationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAutomaticTapeCreationPolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateAutomaticTapeCreationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAutomaticTapeCreationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAutomaticTapeCreationPolicyErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAutomaticTapeCreationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAutomaticTapeCreationPolicyErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            UpdateAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAutomaticTapeCreationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAutomaticTapeCreationPolicyError {
    fn code(&self) -> Option<&str> {
        UpdateAutomaticTapeCreationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAutomaticTapeCreationPolicyError {
    /// Creates a new `UpdateAutomaticTapeCreationPolicyError`.
    pub fn new(
        kind: UpdateAutomaticTapeCreationPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAutomaticTapeCreationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAutomaticTapeCreationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAutomaticTapeCreationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAutomaticTapeCreationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAutomaticTapeCreationPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAutomaticTapeCreationPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateAutomaticTapeCreationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAutomaticTapeCreationPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateAutomaticTapeCreationPolicyErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateAutomaticTapeCreationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBandwidthRateLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBandwidthRateLimitError {
    /// Kind of error that occurred.
    pub kind: UpdateBandwidthRateLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBandwidthRateLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBandwidthRateLimitErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBandwidthRateLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBandwidthRateLimitErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateBandwidthRateLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBandwidthRateLimitError {
    fn code(&self) -> Option<&str> {
        UpdateBandwidthRateLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBandwidthRateLimitError {
    /// Creates a new `UpdateBandwidthRateLimitError`.
    pub fn new(kind: UpdateBandwidthRateLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBandwidthRateLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBandwidthRateLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBandwidthRateLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBandwidthRateLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateBandwidthRateLimitErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBandwidthRateLimitErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateBandwidthRateLimitErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateBandwidthRateLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBandwidthRateLimitErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateBandwidthRateLimitErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateBandwidthRateLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBandwidthRateLimitSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBandwidthRateLimitScheduleError {
    /// Kind of error that occurred.
    pub kind: UpdateBandwidthRateLimitScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBandwidthRateLimitSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBandwidthRateLimitScheduleErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBandwidthRateLimitScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBandwidthRateLimitScheduleErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateBandwidthRateLimitScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBandwidthRateLimitScheduleError {
    fn code(&self) -> Option<&str> {
        UpdateBandwidthRateLimitScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBandwidthRateLimitScheduleError {
    /// Creates a new `UpdateBandwidthRateLimitScheduleError`.
    pub fn new(
        kind: UpdateBandwidthRateLimitScheduleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBandwidthRateLimitScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBandwidthRateLimitScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBandwidthRateLimitScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBandwidthRateLimitScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateBandwidthRateLimitScheduleErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBandwidthRateLimitScheduleErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateBandwidthRateLimitScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBandwidthRateLimitScheduleErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateBandwidthRateLimitScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateBandwidthRateLimitScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChapCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChapCredentialsError {
    /// Kind of error that occurred.
    pub kind: UpdateChapCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChapCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChapCredentialsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChapCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChapCredentialsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateChapCredentialsErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            UpdateChapCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChapCredentialsError {
    fn code(&self) -> Option<&str> {
        UpdateChapCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChapCredentialsError {
    /// Creates a new `UpdateChapCredentialsError`.
    pub fn new(kind: UpdateChapCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChapCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChapCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChapCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChapCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateChapCredentialsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChapCredentialsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateChapCredentialsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChapCredentialsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateChapCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChapCredentialsErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateChapCredentialsErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            UpdateChapCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFileSystemAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFileSystemAssociationError {
    /// Kind of error that occurred.
    pub kind: UpdateFileSystemAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFileSystemAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFileSystemAssociationErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFileSystemAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFileSystemAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateFileSystemAssociationErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFileSystemAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFileSystemAssociationError {
    fn code(&self) -> Option<&str> {
        UpdateFileSystemAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFileSystemAssociationError {
    /// Creates a new `UpdateFileSystemAssociationError`.
    pub fn new(kind: UpdateFileSystemAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFileSystemAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFileSystemAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFileSystemAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFileSystemAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateFileSystemAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateFileSystemAssociationErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemAssociationErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateFileSystemAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFileSystemAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateFileSystemAssociationErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateFileSystemAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGatewayInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewayInformationError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewayInformationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGatewayInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewayInformationErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewayInformationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewayInformationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateGatewayInformationErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGatewayInformationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewayInformationError {
    fn code(&self) -> Option<&str> {
        UpdateGatewayInformationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGatewayInformationError {
    /// Creates a new `UpdateGatewayInformationError`.
    pub fn new(kind: UpdateGatewayInformationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewayInformationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewayInformationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewayInformationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewayInformationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGatewayInformationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayInformationErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayInformationErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayInformationErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateGatewayInformationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewayInformationErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateGatewayInformationErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateGatewayInformationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGatewaySoftwareNow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewaySoftwareNowError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewaySoftwareNowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGatewaySoftwareNow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewaySoftwareNowErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewaySoftwareNowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewaySoftwareNowErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateGatewaySoftwareNowErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGatewaySoftwareNowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewaySoftwareNowError {
    fn code(&self) -> Option<&str> {
        UpdateGatewaySoftwareNowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGatewaySoftwareNowError {
    /// Creates a new `UpdateGatewaySoftwareNowError`.
    pub fn new(kind: UpdateGatewaySoftwareNowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewaySoftwareNowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewaySoftwareNowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewaySoftwareNowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewaySoftwareNowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGatewaySoftwareNowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewaySoftwareNowErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewaySoftwareNowErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewaySoftwareNowErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateGatewaySoftwareNowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewaySoftwareNowErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateGatewaySoftwareNowErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateGatewaySoftwareNowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMaintenanceStartTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMaintenanceStartTimeError {
    /// Kind of error that occurred.
    pub kind: UpdateMaintenanceStartTimeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMaintenanceStartTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMaintenanceStartTimeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMaintenanceStartTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMaintenanceStartTimeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateMaintenanceStartTimeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMaintenanceStartTimeError {
    fn code(&self) -> Option<&str> {
        UpdateMaintenanceStartTimeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMaintenanceStartTimeError {
    /// Creates a new `UpdateMaintenanceStartTimeError`.
    pub fn new(kind: UpdateMaintenanceStartTimeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMaintenanceStartTimeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMaintenanceStartTimeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMaintenanceStartTimeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMaintenanceStartTimeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateMaintenanceStartTimeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceStartTimeErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateMaintenanceStartTimeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateMaintenanceStartTimeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMaintenanceStartTimeErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateMaintenanceStartTimeErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateMaintenanceStartTimeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNFSFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNFSFileShareError {
    /// Kind of error that occurred.
    pub kind: UpdateNFSFileShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNFSFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNFSFileShareErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNFSFileShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNFSFileShareErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateNFSFileShareErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            UpdateNFSFileShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNFSFileShareError {
    fn code(&self) -> Option<&str> {
        UpdateNFSFileShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNFSFileShareError {
    /// Creates a new `UpdateNFSFileShareError`.
    pub fn new(kind: UpdateNFSFileShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNFSFileShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNFSFileShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNFSFileShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNFSFileShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateNFSFileShareErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNFSFileShareErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateNFSFileShareErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNFSFileShareErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateNFSFileShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNFSFileShareErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateNFSFileShareErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            UpdateNFSFileShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSMBFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSMBFileShareError {
    /// Kind of error that occurred.
    pub kind: UpdateSMBFileShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSMBFileShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSMBFileShareErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSMBFileShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSMBFileShareErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateSMBFileShareErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            UpdateSMBFileShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSMBFileShareError {
    fn code(&self) -> Option<&str> {
        UpdateSMBFileShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSMBFileShareError {
    /// Creates a new `UpdateSMBFileShareError`.
    pub fn new(kind: UpdateSMBFileShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSMBFileShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSMBFileShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSMBFileShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSMBFileShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSMBFileShareErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBFileShareErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateSMBFileShareErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBFileShareErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateSMBFileShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSMBFileShareErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateSMBFileShareErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            UpdateSMBFileShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSMBFileShareVisibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSMBFileShareVisibilityError {
    /// Kind of error that occurred.
    pub kind: UpdateSMBFileShareVisibilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSMBFileShareVisibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSMBFileShareVisibilityErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSMBFileShareVisibilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSMBFileShareVisibilityErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateSMBFileShareVisibilityErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSMBFileShareVisibilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSMBFileShareVisibilityError {
    fn code(&self) -> Option<&str> {
        UpdateSMBFileShareVisibilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSMBFileShareVisibilityError {
    /// Creates a new `UpdateSMBFileShareVisibilityError`.
    pub fn new(kind: UpdateSMBFileShareVisibilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSMBFileShareVisibilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSMBFileShareVisibilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSMBFileShareVisibilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSMBFileShareVisibilityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSMBFileShareVisibilityErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBFileShareVisibilityErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateSMBFileShareVisibilityErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBFileShareVisibilityErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateSMBFileShareVisibilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSMBFileShareVisibilityErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateSMBFileShareVisibilityErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateSMBFileShareVisibilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSMBLocalGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSMBLocalGroupsError {
    /// Kind of error that occurred.
    pub kind: UpdateSMBLocalGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSMBLocalGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSMBLocalGroupsErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSMBLocalGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSMBLocalGroupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateSMBLocalGroupsErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            UpdateSMBLocalGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSMBLocalGroupsError {
    fn code(&self) -> Option<&str> {
        UpdateSMBLocalGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSMBLocalGroupsError {
    /// Creates a new `UpdateSMBLocalGroupsError`.
    pub fn new(kind: UpdateSMBLocalGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSMBLocalGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSMBLocalGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSMBLocalGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSMBLocalGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSMBLocalGroupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBLocalGroupsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateSMBLocalGroupsErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBLocalGroupsErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateSMBLocalGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSMBLocalGroupsErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateSMBLocalGroupsErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            UpdateSMBLocalGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSMBSecurityStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSMBSecurityStrategyError {
    /// Kind of error that occurred.
    pub kind: UpdateSMBSecurityStrategyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSMBSecurityStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSMBSecurityStrategyErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSMBSecurityStrategyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSMBSecurityStrategyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateSMBSecurityStrategyErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSMBSecurityStrategyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSMBSecurityStrategyError {
    fn code(&self) -> Option<&str> {
        UpdateSMBSecurityStrategyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSMBSecurityStrategyError {
    /// Creates a new `UpdateSMBSecurityStrategyError`.
    pub fn new(kind: UpdateSMBSecurityStrategyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSMBSecurityStrategyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSMBSecurityStrategyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSMBSecurityStrategyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSMBSecurityStrategyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSMBSecurityStrategyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBSecurityStrategyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateSMBSecurityStrategyErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSMBSecurityStrategyErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateSMBSecurityStrategyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSMBSecurityStrategyErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateSMBSecurityStrategyErrorKind::InvalidGatewayRequestException(_inner) => {
                Some(_inner)
            }
            UpdateSMBSecurityStrategyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSnapshotScheduleError {
    /// Kind of error that occurred.
    pub kind: UpdateSnapshotScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSnapshotScheduleErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSnapshotScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSnapshotScheduleErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateSnapshotScheduleErrorKind::InvalidGatewayRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSnapshotScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSnapshotScheduleError {
    fn code(&self) -> Option<&str> {
        UpdateSnapshotScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSnapshotScheduleError {
    /// Creates a new `UpdateSnapshotScheduleError`.
    pub fn new(kind: UpdateSnapshotScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSnapshotScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSnapshotScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSnapshotScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSnapshotScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSnapshotScheduleErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSnapshotScheduleErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateSnapshotScheduleErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSnapshotScheduleErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateSnapshotScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSnapshotScheduleErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateSnapshotScheduleErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            UpdateSnapshotScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVTLDeviceType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVTLDeviceTypeError {
    /// Kind of error that occurred.
    pub kind: UpdateVTLDeviceTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVTLDeviceType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVTLDeviceTypeErrorKind {
    /// <p>An internal server error has occurred during the request. For more information, see the
    /// error and message fields.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An exception occurred because an invalid gateway request was issued to the service. For
    /// more information, see the error and message fields.</p>
    InvalidGatewayRequestException(crate::error::InvalidGatewayRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVTLDeviceTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVTLDeviceTypeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateVTLDeviceTypeErrorKind::InvalidGatewayRequestException(_inner) => _inner.fmt(f),
            UpdateVTLDeviceTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVTLDeviceTypeError {
    fn code(&self) -> Option<&str> {
        UpdateVTLDeviceTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVTLDeviceTypeError {
    /// Creates a new `UpdateVTLDeviceTypeError`.
    pub fn new(kind: UpdateVTLDeviceTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVTLDeviceTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVTLDeviceTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVTLDeviceTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVTLDeviceTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateVTLDeviceTypeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVTLDeviceTypeErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateVTLDeviceTypeErrorKind::InvalidGatewayRequestException`.
    pub fn is_invalid_gateway_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVTLDeviceTypeErrorKind::InvalidGatewayRequestException(_)
        )
    }
}
impl std::error::Error for UpdateVTLDeviceTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVTLDeviceTypeErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateVTLDeviceTypeErrorKind::InvalidGatewayRequestException(_inner) => Some(_inner),
            UpdateVTLDeviceTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An exception occurred because an invalid gateway request was issued to the service. For
/// more information, see the error and message fields.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidGatewayRequestException {
    /// <p>A human-readable message describing the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>A <a>StorageGatewayError</a> that provides more detail about the cause of the
    /// error.</p>
    pub error: std::option::Option<crate::model::StorageGatewayError>,
}
impl std::fmt::Debug for InvalidGatewayRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidGatewayRequestException");
        formatter.field("message", &self.message);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
impl InvalidGatewayRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidGatewayRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidGatewayRequestException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidGatewayRequestException {}
/// See [`InvalidGatewayRequestException`](crate::error::InvalidGatewayRequestException)
pub mod invalid_gateway_request_exception {
    /// A builder for [`InvalidGatewayRequestException`](crate::error::InvalidGatewayRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::StorageGatewayError>,
    }
    impl Builder {
        /// <p>A human-readable message describing the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable message describing the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A <a>StorageGatewayError</a> that provides more detail about the cause of the
        /// error.</p>
        pub fn error(mut self, input: crate::model::StorageGatewayError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>A <a>StorageGatewayError</a> that provides more detail about the cause of the
        /// error.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::StorageGatewayError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidGatewayRequestException`](crate::error::InvalidGatewayRequestException)
        pub fn build(self) -> crate::error::InvalidGatewayRequestException {
            crate::error::InvalidGatewayRequestException {
                message: self.message,
                error: self.error,
            }
        }
    }
}
impl InvalidGatewayRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidGatewayRequestException`](crate::error::InvalidGatewayRequestException)
    pub fn builder() -> crate::error::invalid_gateway_request_exception::Builder {
        crate::error::invalid_gateway_request_exception::Builder::default()
    }
}

/// <p>An internal server error has occurred during the request. For more information, see the
/// error and message fields.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    /// <p>A human-readable message describing the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>A <a>StorageGatewayError</a> that provides more information about the cause
    /// of the error.</p>
    pub error: std::option::Option<crate::model::StorageGatewayError>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::StorageGatewayError>,
    }
    impl Builder {
        /// <p>A human-readable message describing the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable message describing the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A <a>StorageGatewayError</a> that provides more information about the cause
        /// of the error.</p>
        pub fn error(mut self, input: crate::model::StorageGatewayError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>A <a>StorageGatewayError</a> that provides more information about the cause
        /// of the error.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::StorageGatewayError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
                error: self.error,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>An internal server error has occurred because the service is unavailable. For more
/// information, see the error and message fields.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableError {
    /// <p>A human-readable message describing the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>A <a>StorageGatewayError</a> that provides more information about the cause
    /// of the error.</p>
    pub error: std::option::Option<crate::model::StorageGatewayError>,
}
impl std::fmt::Debug for ServiceUnavailableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableError");
        formatter.field("message", &self.message);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
impl ServiceUnavailableError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableError")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableError {}
/// See [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
pub mod service_unavailable_error {
    /// A builder for [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::StorageGatewayError>,
    }
    impl Builder {
        /// <p>A human-readable message describing the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable message describing the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A <a>StorageGatewayError</a> that provides more information about the cause
        /// of the error.</p>
        pub fn error(mut self, input: crate::model::StorageGatewayError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>A <a>StorageGatewayError</a> that provides more information about the cause
        /// of the error.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::StorageGatewayError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
        pub fn build(self) -> crate::error::ServiceUnavailableError {
            crate::error::ServiceUnavailableError {
                message: self.message,
                error: self.error,
            }
        }
    }
}
impl ServiceUnavailableError {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
    pub fn builder() -> crate::error::service_unavailable_error::Builder {
        crate::error::service_unavailable_error::Builder::default()
    }
}
