// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `StorageGateway_20130630`.
///
/// This client allows ergonomic access to a `StorageGateway_20130630`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ActivateGateway` operation.
    ///
    /// See [`ActivateGateway`](crate::client::fluent_builders::ActivateGateway) for more information about the
    /// operation and its arguments.
    pub fn activate_gateway(&self) -> fluent_builders::ActivateGateway<C, M, R> {
        fluent_builders::ActivateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddCache` operation.
    ///
    /// See [`AddCache`](crate::client::fluent_builders::AddCache) for more information about the
    /// operation and its arguments.
    pub fn add_cache(&self) -> fluent_builders::AddCache<C, M, R> {
        fluent_builders::AddCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddUploadBuffer` operation.
    ///
    /// See [`AddUploadBuffer`](crate::client::fluent_builders::AddUploadBuffer) for more information about the
    /// operation and its arguments.
    pub fn add_upload_buffer(&self) -> fluent_builders::AddUploadBuffer<C, M, R> {
        fluent_builders::AddUploadBuffer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddWorkingStorage` operation.
    ///
    /// See [`AddWorkingStorage`](crate::client::fluent_builders::AddWorkingStorage) for more information about the
    /// operation and its arguments.
    pub fn add_working_storage(&self) -> fluent_builders::AddWorkingStorage<C, M, R> {
        fluent_builders::AddWorkingStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssignTapePool` operation.
    ///
    /// See [`AssignTapePool`](crate::client::fluent_builders::AssignTapePool) for more information about the
    /// operation and its arguments.
    pub fn assign_tape_pool(&self) -> fluent_builders::AssignTapePool<C, M, R> {
        fluent_builders::AssignTapePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateFileSystem` operation.
    ///
    /// See [`AssociateFileSystem`](crate::client::fluent_builders::AssociateFileSystem) for more information about the
    /// operation and its arguments.
    pub fn associate_file_system(&self) -> fluent_builders::AssociateFileSystem<C, M, R> {
        fluent_builders::AssociateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachVolume` operation.
    ///
    /// See [`AttachVolume`](crate::client::fluent_builders::AttachVolume) for more information about the
    /// operation and its arguments.
    pub fn attach_volume(&self) -> fluent_builders::AttachVolume<C, M, R> {
        fluent_builders::AttachVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelArchival` operation.
    ///
    /// See [`CancelArchival`](crate::client::fluent_builders::CancelArchival) for more information about the
    /// operation and its arguments.
    pub fn cancel_archival(&self) -> fluent_builders::CancelArchival<C, M, R> {
        fluent_builders::CancelArchival::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelRetrieval` operation.
    ///
    /// See [`CancelRetrieval`](crate::client::fluent_builders::CancelRetrieval) for more information about the
    /// operation and its arguments.
    pub fn cancel_retrieval(&self) -> fluent_builders::CancelRetrieval<C, M, R> {
        fluent_builders::CancelRetrieval::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCachediSCSIVolume` operation.
    ///
    /// See [`CreateCachediSCSIVolume`](crate::client::fluent_builders::CreateCachediSCSIVolume) for more information about the
    /// operation and its arguments.
    pub fn create_cachedi_scsi_volume(&self) -> fluent_builders::CreateCachediSCSIVolume<C, M, R> {
        fluent_builders::CreateCachediSCSIVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNFSFileShare` operation.
    ///
    /// See [`CreateNFSFileShare`](crate::client::fluent_builders::CreateNFSFileShare) for more information about the
    /// operation and its arguments.
    pub fn create_nfs_file_share(&self) -> fluent_builders::CreateNFSFileShare<C, M, R> {
        fluent_builders::CreateNFSFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSMBFileShare` operation.
    ///
    /// See [`CreateSMBFileShare`](crate::client::fluent_builders::CreateSMBFileShare) for more information about the
    /// operation and its arguments.
    pub fn create_smb_file_share(&self) -> fluent_builders::CreateSMBFileShare<C, M, R> {
        fluent_builders::CreateSMBFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshot` operation.
    ///
    /// See [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot<C, M, R> {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshotFromVolumeRecoveryPoint` operation.
    ///
    /// See [`CreateSnapshotFromVolumeRecoveryPoint`](crate::client::fluent_builders::CreateSnapshotFromVolumeRecoveryPoint) for more information about the
    /// operation and its arguments.
    pub fn create_snapshot_from_volume_recovery_point(
        &self,
    ) -> fluent_builders::CreateSnapshotFromVolumeRecoveryPoint<C, M, R> {
        fluent_builders::CreateSnapshotFromVolumeRecoveryPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStorediSCSIVolume` operation.
    ///
    /// See [`CreateStorediSCSIVolume`](crate::client::fluent_builders::CreateStorediSCSIVolume) for more information about the
    /// operation and its arguments.
    pub fn create_storedi_scsi_volume(&self) -> fluent_builders::CreateStorediSCSIVolume<C, M, R> {
        fluent_builders::CreateStorediSCSIVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTapePool` operation.
    ///
    /// See [`CreateTapePool`](crate::client::fluent_builders::CreateTapePool) for more information about the
    /// operation and its arguments.
    pub fn create_tape_pool(&self) -> fluent_builders::CreateTapePool<C, M, R> {
        fluent_builders::CreateTapePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTapes` operation.
    ///
    /// See [`CreateTapes`](crate::client::fluent_builders::CreateTapes) for more information about the
    /// operation and its arguments.
    pub fn create_tapes(&self) -> fluent_builders::CreateTapes<C, M, R> {
        fluent_builders::CreateTapes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTapeWithBarcode` operation.
    ///
    /// See [`CreateTapeWithBarcode`](crate::client::fluent_builders::CreateTapeWithBarcode) for more information about the
    /// operation and its arguments.
    pub fn create_tape_with_barcode(&self) -> fluent_builders::CreateTapeWithBarcode<C, M, R> {
        fluent_builders::CreateTapeWithBarcode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAutomaticTapeCreationPolicy` operation.
    ///
    /// See [`DeleteAutomaticTapeCreationPolicy`](crate::client::fluent_builders::DeleteAutomaticTapeCreationPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_automatic_tape_creation_policy(
        &self,
    ) -> fluent_builders::DeleteAutomaticTapeCreationPolicy<C, M, R> {
        fluent_builders::DeleteAutomaticTapeCreationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBandwidthRateLimit` operation.
    ///
    /// See [`DeleteBandwidthRateLimit`](crate::client::fluent_builders::DeleteBandwidthRateLimit) for more information about the
    /// operation and its arguments.
    pub fn delete_bandwidth_rate_limit(
        &self,
    ) -> fluent_builders::DeleteBandwidthRateLimit<C, M, R> {
        fluent_builders::DeleteBandwidthRateLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChapCredentials` operation.
    ///
    /// See [`DeleteChapCredentials`](crate::client::fluent_builders::DeleteChapCredentials) for more information about the
    /// operation and its arguments.
    pub fn delete_chap_credentials(&self) -> fluent_builders::DeleteChapCredentials<C, M, R> {
        fluent_builders::DeleteChapCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFileShare` operation.
    ///
    /// See [`DeleteFileShare`](crate::client::fluent_builders::DeleteFileShare) for more information about the
    /// operation and its arguments.
    pub fn delete_file_share(&self) -> fluent_builders::DeleteFileShare<C, M, R> {
        fluent_builders::DeleteFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGateway` operation.
    ///
    /// See [`DeleteGateway`](crate::client::fluent_builders::DeleteGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_gateway(&self) -> fluent_builders::DeleteGateway<C, M, R> {
        fluent_builders::DeleteGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSnapshotSchedule` operation.
    ///
    /// See [`DeleteSnapshotSchedule`](crate::client::fluent_builders::DeleteSnapshotSchedule) for more information about the
    /// operation and its arguments.
    pub fn delete_snapshot_schedule(&self) -> fluent_builders::DeleteSnapshotSchedule<C, M, R> {
        fluent_builders::DeleteSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTape` operation.
    ///
    /// See [`DeleteTape`](crate::client::fluent_builders::DeleteTape) for more information about the
    /// operation and its arguments.
    pub fn delete_tape(&self) -> fluent_builders::DeleteTape<C, M, R> {
        fluent_builders::DeleteTape::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTapeArchive` operation.
    ///
    /// See [`DeleteTapeArchive`](crate::client::fluent_builders::DeleteTapeArchive) for more information about the
    /// operation and its arguments.
    pub fn delete_tape_archive(&self) -> fluent_builders::DeleteTapeArchive<C, M, R> {
        fluent_builders::DeleteTapeArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTapePool` operation.
    ///
    /// See [`DeleteTapePool`](crate::client::fluent_builders::DeleteTapePool) for more information about the
    /// operation and its arguments.
    pub fn delete_tape_pool(&self) -> fluent_builders::DeleteTapePool<C, M, R> {
        fluent_builders::DeleteTapePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVolume` operation.
    ///
    /// See [`DeleteVolume`](crate::client::fluent_builders::DeleteVolume) for more information about the
    /// operation and its arguments.
    pub fn delete_volume(&self) -> fluent_builders::DeleteVolume<C, M, R> {
        fluent_builders::DeleteVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAvailabilityMonitorTest` operation.
    ///
    /// See [`DescribeAvailabilityMonitorTest`](crate::client::fluent_builders::DescribeAvailabilityMonitorTest) for more information about the
    /// operation and its arguments.
    pub fn describe_availability_monitor_test(
        &self,
    ) -> fluent_builders::DescribeAvailabilityMonitorTest<C, M, R> {
        fluent_builders::DescribeAvailabilityMonitorTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBandwidthRateLimit` operation.
    ///
    /// See [`DescribeBandwidthRateLimit`](crate::client::fluent_builders::DescribeBandwidthRateLimit) for more information about the
    /// operation and its arguments.
    pub fn describe_bandwidth_rate_limit(
        &self,
    ) -> fluent_builders::DescribeBandwidthRateLimit<C, M, R> {
        fluent_builders::DescribeBandwidthRateLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBandwidthRateLimitSchedule` operation.
    ///
    /// See [`DescribeBandwidthRateLimitSchedule`](crate::client::fluent_builders::DescribeBandwidthRateLimitSchedule) for more information about the
    /// operation and its arguments.
    pub fn describe_bandwidth_rate_limit_schedule(
        &self,
    ) -> fluent_builders::DescribeBandwidthRateLimitSchedule<C, M, R> {
        fluent_builders::DescribeBandwidthRateLimitSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCache` operation.
    ///
    /// See [`DescribeCache`](crate::client::fluent_builders::DescribeCache) for more information about the
    /// operation and its arguments.
    pub fn describe_cache(&self) -> fluent_builders::DescribeCache<C, M, R> {
        fluent_builders::DescribeCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCachediSCSIVolumes` operation.
    ///
    /// See [`DescribeCachediSCSIVolumes`](crate::client::fluent_builders::DescribeCachediSCSIVolumes) for more information about the
    /// operation and its arguments.
    pub fn describe_cachedi_scsi_volumes(
        &self,
    ) -> fluent_builders::DescribeCachediSCSIVolumes<C, M, R> {
        fluent_builders::DescribeCachediSCSIVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChapCredentials` operation.
    ///
    /// See [`DescribeChapCredentials`](crate::client::fluent_builders::DescribeChapCredentials) for more information about the
    /// operation and its arguments.
    pub fn describe_chap_credentials(&self) -> fluent_builders::DescribeChapCredentials<C, M, R> {
        fluent_builders::DescribeChapCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFileSystemAssociations` operation.
    ///
    /// See [`DescribeFileSystemAssociations`](crate::client::fluent_builders::DescribeFileSystemAssociations) for more information about the
    /// operation and its arguments.
    pub fn describe_file_system_associations(
        &self,
    ) -> fluent_builders::DescribeFileSystemAssociations<C, M, R> {
        fluent_builders::DescribeFileSystemAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGatewayInformation` operation.
    ///
    /// See [`DescribeGatewayInformation`](crate::client::fluent_builders::DescribeGatewayInformation) for more information about the
    /// operation and its arguments.
    pub fn describe_gateway_information(
        &self,
    ) -> fluent_builders::DescribeGatewayInformation<C, M, R> {
        fluent_builders::DescribeGatewayInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceStartTime` operation.
    ///
    /// See [`DescribeMaintenanceStartTime`](crate::client::fluent_builders::DescribeMaintenanceStartTime) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_start_time(
        &self,
    ) -> fluent_builders::DescribeMaintenanceStartTime<C, M, R> {
        fluent_builders::DescribeMaintenanceStartTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNFSFileShares` operation.
    ///
    /// See [`DescribeNFSFileShares`](crate::client::fluent_builders::DescribeNFSFileShares) for more information about the
    /// operation and its arguments.
    pub fn describe_nfs_file_shares(&self) -> fluent_builders::DescribeNFSFileShares<C, M, R> {
        fluent_builders::DescribeNFSFileShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSMBFileShares` operation.
    ///
    /// See [`DescribeSMBFileShares`](crate::client::fluent_builders::DescribeSMBFileShares) for more information about the
    /// operation and its arguments.
    pub fn describe_smb_file_shares(&self) -> fluent_builders::DescribeSMBFileShares<C, M, R> {
        fluent_builders::DescribeSMBFileShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSMBSettings` operation.
    ///
    /// See [`DescribeSMBSettings`](crate::client::fluent_builders::DescribeSMBSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_smb_settings(&self) -> fluent_builders::DescribeSMBSettings<C, M, R> {
        fluent_builders::DescribeSMBSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshotSchedule` operation.
    ///
    /// See [`DescribeSnapshotSchedule`](crate::client::fluent_builders::DescribeSnapshotSchedule) for more information about the
    /// operation and its arguments.
    pub fn describe_snapshot_schedule(&self) -> fluent_builders::DescribeSnapshotSchedule<C, M, R> {
        fluent_builders::DescribeSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStorediSCSIVolumes` operation.
    ///
    /// See [`DescribeStorediSCSIVolumes`](crate::client::fluent_builders::DescribeStorediSCSIVolumes) for more information about the
    /// operation and its arguments.
    pub fn describe_storedi_scsi_volumes(
        &self,
    ) -> fluent_builders::DescribeStorediSCSIVolumes<C, M, R> {
        fluent_builders::DescribeStorediSCSIVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTapeArchives` operation.
    ///
    /// See [`DescribeTapeArchives`](crate::client::fluent_builders::DescribeTapeArchives) for more information about the
    /// operation and its arguments.
    pub fn describe_tape_archives(&self) -> fluent_builders::DescribeTapeArchives<C, M, R> {
        fluent_builders::DescribeTapeArchives::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTapeRecoveryPoints` operation.
    ///
    /// See [`DescribeTapeRecoveryPoints`](crate::client::fluent_builders::DescribeTapeRecoveryPoints) for more information about the
    /// operation and its arguments.
    pub fn describe_tape_recovery_points(
        &self,
    ) -> fluent_builders::DescribeTapeRecoveryPoints<C, M, R> {
        fluent_builders::DescribeTapeRecoveryPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTapes` operation.
    ///
    /// See [`DescribeTapes`](crate::client::fluent_builders::DescribeTapes) for more information about the
    /// operation and its arguments.
    pub fn describe_tapes(&self) -> fluent_builders::DescribeTapes<C, M, R> {
        fluent_builders::DescribeTapes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUploadBuffer` operation.
    ///
    /// See [`DescribeUploadBuffer`](crate::client::fluent_builders::DescribeUploadBuffer) for more information about the
    /// operation and its arguments.
    pub fn describe_upload_buffer(&self) -> fluent_builders::DescribeUploadBuffer<C, M, R> {
        fluent_builders::DescribeUploadBuffer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVTLDevices` operation.
    ///
    /// See [`DescribeVTLDevices`](crate::client::fluent_builders::DescribeVTLDevices) for more information about the
    /// operation and its arguments.
    pub fn describe_vtl_devices(&self) -> fluent_builders::DescribeVTLDevices<C, M, R> {
        fluent_builders::DescribeVTLDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkingStorage` operation.
    ///
    /// See [`DescribeWorkingStorage`](crate::client::fluent_builders::DescribeWorkingStorage) for more information about the
    /// operation and its arguments.
    pub fn describe_working_storage(&self) -> fluent_builders::DescribeWorkingStorage<C, M, R> {
        fluent_builders::DescribeWorkingStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachVolume` operation.
    ///
    /// See [`DetachVolume`](crate::client::fluent_builders::DetachVolume) for more information about the
    /// operation and its arguments.
    pub fn detach_volume(&self) -> fluent_builders::DetachVolume<C, M, R> {
        fluent_builders::DetachVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableGateway` operation.
    ///
    /// See [`DisableGateway`](crate::client::fluent_builders::DisableGateway) for more information about the
    /// operation and its arguments.
    pub fn disable_gateway(&self) -> fluent_builders::DisableGateway<C, M, R> {
        fluent_builders::DisableGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateFileSystem` operation.
    ///
    /// See [`DisassociateFileSystem`](crate::client::fluent_builders::DisassociateFileSystem) for more information about the
    /// operation and its arguments.
    pub fn disassociate_file_system(&self) -> fluent_builders::DisassociateFileSystem<C, M, R> {
        fluent_builders::DisassociateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `JoinDomain` operation.
    ///
    /// See [`JoinDomain`](crate::client::fluent_builders::JoinDomain) for more information about the
    /// operation and its arguments.
    pub fn join_domain(&self) -> fluent_builders::JoinDomain<C, M, R> {
        fluent_builders::JoinDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAutomaticTapeCreationPolicies` operation.
    ///
    /// See [`ListAutomaticTapeCreationPolicies`](crate::client::fluent_builders::ListAutomaticTapeCreationPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_automatic_tape_creation_policies(
        &self,
    ) -> fluent_builders::ListAutomaticTapeCreationPolicies<C, M, R> {
        fluent_builders::ListAutomaticTapeCreationPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFileShares` operation.
    ///
    /// See [`ListFileShares`](crate::client::fluent_builders::ListFileShares) for more information about the
    /// operation and its arguments.
    pub fn list_file_shares(&self) -> fluent_builders::ListFileShares<C, M, R> {
        fluent_builders::ListFileShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFileSystemAssociations` operation.
    ///
    /// See [`ListFileSystemAssociations`](crate::client::fluent_builders::ListFileSystemAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_file_system_associations(
        &self,
    ) -> fluent_builders::ListFileSystemAssociations<C, M, R> {
        fluent_builders::ListFileSystemAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGateways` operation.
    ///
    /// See [`ListGateways`](crate::client::fluent_builders::ListGateways) for more information about the
    /// operation and its arguments.
    pub fn list_gateways(&self) -> fluent_builders::ListGateways<C, M, R> {
        fluent_builders::ListGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLocalDisks` operation.
    ///
    /// See [`ListLocalDisks`](crate::client::fluent_builders::ListLocalDisks) for more information about the
    /// operation and its arguments.
    pub fn list_local_disks(&self) -> fluent_builders::ListLocalDisks<C, M, R> {
        fluent_builders::ListLocalDisks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTapePools` operation.
    ///
    /// See [`ListTapePools`](crate::client::fluent_builders::ListTapePools) for more information about the
    /// operation and its arguments.
    pub fn list_tape_pools(&self) -> fluent_builders::ListTapePools<C, M, R> {
        fluent_builders::ListTapePools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTapes` operation.
    ///
    /// See [`ListTapes`](crate::client::fluent_builders::ListTapes) for more information about the
    /// operation and its arguments.
    pub fn list_tapes(&self) -> fluent_builders::ListTapes<C, M, R> {
        fluent_builders::ListTapes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVolumeInitiators` operation.
    ///
    /// See [`ListVolumeInitiators`](crate::client::fluent_builders::ListVolumeInitiators) for more information about the
    /// operation and its arguments.
    pub fn list_volume_initiators(&self) -> fluent_builders::ListVolumeInitiators<C, M, R> {
        fluent_builders::ListVolumeInitiators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVolumeRecoveryPoints` operation.
    ///
    /// See [`ListVolumeRecoveryPoints`](crate::client::fluent_builders::ListVolumeRecoveryPoints) for more information about the
    /// operation and its arguments.
    pub fn list_volume_recovery_points(
        &self,
    ) -> fluent_builders::ListVolumeRecoveryPoints<C, M, R> {
        fluent_builders::ListVolumeRecoveryPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVolumes` operation.
    ///
    /// See [`ListVolumes`](crate::client::fluent_builders::ListVolumes) for more information about the
    /// operation and its arguments.
    pub fn list_volumes(&self) -> fluent_builders::ListVolumes<C, M, R> {
        fluent_builders::ListVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `NotifyWhenUploaded` operation.
    ///
    /// See [`NotifyWhenUploaded`](crate::client::fluent_builders::NotifyWhenUploaded) for more information about the
    /// operation and its arguments.
    pub fn notify_when_uploaded(&self) -> fluent_builders::NotifyWhenUploaded<C, M, R> {
        fluent_builders::NotifyWhenUploaded::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RefreshCache` operation.
    ///
    /// See [`RefreshCache`](crate::client::fluent_builders::RefreshCache) for more information about the
    /// operation and its arguments.
    pub fn refresh_cache(&self) -> fluent_builders::RefreshCache<C, M, R> {
        fluent_builders::RefreshCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetCache` operation.
    ///
    /// See [`ResetCache`](crate::client::fluent_builders::ResetCache) for more information about the
    /// operation and its arguments.
    pub fn reset_cache(&self) -> fluent_builders::ResetCache<C, M, R> {
        fluent_builders::ResetCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetrieveTapeArchive` operation.
    ///
    /// See [`RetrieveTapeArchive`](crate::client::fluent_builders::RetrieveTapeArchive) for more information about the
    /// operation and its arguments.
    pub fn retrieve_tape_archive(&self) -> fluent_builders::RetrieveTapeArchive<C, M, R> {
        fluent_builders::RetrieveTapeArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetrieveTapeRecoveryPoint` operation.
    ///
    /// See [`RetrieveTapeRecoveryPoint`](crate::client::fluent_builders::RetrieveTapeRecoveryPoint) for more information about the
    /// operation and its arguments.
    pub fn retrieve_tape_recovery_point(
        &self,
    ) -> fluent_builders::RetrieveTapeRecoveryPoint<C, M, R> {
        fluent_builders::RetrieveTapeRecoveryPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetLocalConsolePassword` operation.
    ///
    /// See [`SetLocalConsolePassword`](crate::client::fluent_builders::SetLocalConsolePassword) for more information about the
    /// operation and its arguments.
    pub fn set_local_console_password(&self) -> fluent_builders::SetLocalConsolePassword<C, M, R> {
        fluent_builders::SetLocalConsolePassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetSMBGuestPassword` operation.
    ///
    /// See [`SetSMBGuestPassword`](crate::client::fluent_builders::SetSMBGuestPassword) for more information about the
    /// operation and its arguments.
    pub fn set_smb_guest_password(&self) -> fluent_builders::SetSMBGuestPassword<C, M, R> {
        fluent_builders::SetSMBGuestPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ShutdownGateway` operation.
    ///
    /// See [`ShutdownGateway`](crate::client::fluent_builders::ShutdownGateway) for more information about the
    /// operation and its arguments.
    pub fn shutdown_gateway(&self) -> fluent_builders::ShutdownGateway<C, M, R> {
        fluent_builders::ShutdownGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAvailabilityMonitorTest` operation.
    ///
    /// See [`StartAvailabilityMonitorTest`](crate::client::fluent_builders::StartAvailabilityMonitorTest) for more information about the
    /// operation and its arguments.
    pub fn start_availability_monitor_test(
        &self,
    ) -> fluent_builders::StartAvailabilityMonitorTest<C, M, R> {
        fluent_builders::StartAvailabilityMonitorTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartGateway` operation.
    ///
    /// See [`StartGateway`](crate::client::fluent_builders::StartGateway) for more information about the
    /// operation and its arguments.
    pub fn start_gateway(&self) -> fluent_builders::StartGateway<C, M, R> {
        fluent_builders::StartGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAutomaticTapeCreationPolicy` operation.
    ///
    /// See [`UpdateAutomaticTapeCreationPolicy`](crate::client::fluent_builders::UpdateAutomaticTapeCreationPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_automatic_tape_creation_policy(
        &self,
    ) -> fluent_builders::UpdateAutomaticTapeCreationPolicy<C, M, R> {
        fluent_builders::UpdateAutomaticTapeCreationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBandwidthRateLimit` operation.
    ///
    /// See [`UpdateBandwidthRateLimit`](crate::client::fluent_builders::UpdateBandwidthRateLimit) for more information about the
    /// operation and its arguments.
    pub fn update_bandwidth_rate_limit(
        &self,
    ) -> fluent_builders::UpdateBandwidthRateLimit<C, M, R> {
        fluent_builders::UpdateBandwidthRateLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBandwidthRateLimitSchedule` operation.
    ///
    /// See [`UpdateBandwidthRateLimitSchedule`](crate::client::fluent_builders::UpdateBandwidthRateLimitSchedule) for more information about the
    /// operation and its arguments.
    pub fn update_bandwidth_rate_limit_schedule(
        &self,
    ) -> fluent_builders::UpdateBandwidthRateLimitSchedule<C, M, R> {
        fluent_builders::UpdateBandwidthRateLimitSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChapCredentials` operation.
    ///
    /// See [`UpdateChapCredentials`](crate::client::fluent_builders::UpdateChapCredentials) for more information about the
    /// operation and its arguments.
    pub fn update_chap_credentials(&self) -> fluent_builders::UpdateChapCredentials<C, M, R> {
        fluent_builders::UpdateChapCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFileSystemAssociation` operation.
    ///
    /// See [`UpdateFileSystemAssociation`](crate::client::fluent_builders::UpdateFileSystemAssociation) for more information about the
    /// operation and its arguments.
    pub fn update_file_system_association(
        &self,
    ) -> fluent_builders::UpdateFileSystemAssociation<C, M, R> {
        fluent_builders::UpdateFileSystemAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGatewayInformation` operation.
    ///
    /// See [`UpdateGatewayInformation`](crate::client::fluent_builders::UpdateGatewayInformation) for more information about the
    /// operation and its arguments.
    pub fn update_gateway_information(&self) -> fluent_builders::UpdateGatewayInformation<C, M, R> {
        fluent_builders::UpdateGatewayInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGatewaySoftwareNow` operation.
    ///
    /// See [`UpdateGatewaySoftwareNow`](crate::client::fluent_builders::UpdateGatewaySoftwareNow) for more information about the
    /// operation and its arguments.
    pub fn update_gateway_software_now(
        &self,
    ) -> fluent_builders::UpdateGatewaySoftwareNow<C, M, R> {
        fluent_builders::UpdateGatewaySoftwareNow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMaintenanceStartTime` operation.
    ///
    /// See [`UpdateMaintenanceStartTime`](crate::client::fluent_builders::UpdateMaintenanceStartTime) for more information about the
    /// operation and its arguments.
    pub fn update_maintenance_start_time(
        &self,
    ) -> fluent_builders::UpdateMaintenanceStartTime<C, M, R> {
        fluent_builders::UpdateMaintenanceStartTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNFSFileShare` operation.
    ///
    /// See [`UpdateNFSFileShare`](crate::client::fluent_builders::UpdateNFSFileShare) for more information about the
    /// operation and its arguments.
    pub fn update_nfs_file_share(&self) -> fluent_builders::UpdateNFSFileShare<C, M, R> {
        fluent_builders::UpdateNFSFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSMBFileShare` operation.
    ///
    /// See [`UpdateSMBFileShare`](crate::client::fluent_builders::UpdateSMBFileShare) for more information about the
    /// operation and its arguments.
    pub fn update_smb_file_share(&self) -> fluent_builders::UpdateSMBFileShare<C, M, R> {
        fluent_builders::UpdateSMBFileShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSMBFileShareVisibility` operation.
    ///
    /// See [`UpdateSMBFileShareVisibility`](crate::client::fluent_builders::UpdateSMBFileShareVisibility) for more information about the
    /// operation and its arguments.
    pub fn update_smb_file_share_visibility(
        &self,
    ) -> fluent_builders::UpdateSMBFileShareVisibility<C, M, R> {
        fluent_builders::UpdateSMBFileShareVisibility::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSMBLocalGroups` operation.
    ///
    /// See [`UpdateSMBLocalGroups`](crate::client::fluent_builders::UpdateSMBLocalGroups) for more information about the
    /// operation and its arguments.
    pub fn update_smb_local_groups(&self) -> fluent_builders::UpdateSMBLocalGroups<C, M, R> {
        fluent_builders::UpdateSMBLocalGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSMBSecurityStrategy` operation.
    ///
    /// See [`UpdateSMBSecurityStrategy`](crate::client::fluent_builders::UpdateSMBSecurityStrategy) for more information about the
    /// operation and its arguments.
    pub fn update_smb_security_strategy(
        &self,
    ) -> fluent_builders::UpdateSMBSecurityStrategy<C, M, R> {
        fluent_builders::UpdateSMBSecurityStrategy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSnapshotSchedule` operation.
    ///
    /// See [`UpdateSnapshotSchedule`](crate::client::fluent_builders::UpdateSnapshotSchedule) for more information about the
    /// operation and its arguments.
    pub fn update_snapshot_schedule(&self) -> fluent_builders::UpdateSnapshotSchedule<C, M, R> {
        fluent_builders::UpdateSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVTLDeviceType` operation.
    ///
    /// See [`UpdateVTLDeviceType`](crate::client::fluent_builders::UpdateVTLDeviceType) for more information about the
    /// operation and its arguments.
    pub fn update_vtl_device_type(&self) -> fluent_builders::UpdateVTLDeviceType<C, M, R> {
        fluent_builders::UpdateVTLDeviceType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateGateway`.
    ///
    /// <p>Activates the gateway you previously deployed on your host. In the activation process,
    /// you specify information such as the Amazon Web Services Region that you want to use for
    /// storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot
    /// schedule window, an activation key, and a name for your gateway. The activation process
    /// also associates your gateway with your account. For more information, see <a>UpdateGatewayInformation</a>.</p>
    /// <note>
    /// <p>You must turn on the gateway VM before you can activate your gateway.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ActivateGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_gateway_input::Builder,
    }
    impl<C, M, R> ActivateGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateGatewayInputOperationOutputAlias,
                crate::output::ActivateGatewayOutput,
                crate::error::ActivateGatewayError,
                crate::input::ActivateGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET
        /// request with redirects enabled to the gateway IP address (port 80). The redirect URL
        /// returned in the response provides you the activation key for your gateway in the query
        /// string parameter <code>activationKey</code>. It may also include other activation-related
        /// parameters, however, these are merely defaults -- the arguments you pass to the
        /// <code>ActivateGateway</code> API call determine the actual configuration of your
        /// gateway.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
        /// key</a> in the <i>Storage Gateway User Guide</i>.</p>
        pub fn activation_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_key(inp);
            self
        }
        /// <p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET
        /// request with redirects enabled to the gateway IP address (port 80). The redirect URL
        /// returned in the response provides you the activation key for your gateway in the query
        /// string parameter <code>activationKey</code>. It may also include other activation-related
        /// parameters, however, these are merely defaults -- the arguments you pass to the
        /// <code>ActivateGateway</code> API call determine the actual configuration of your
        /// gateway.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
        /// key</a> in the <i>Storage Gateway User Guide</i>.</p>
        pub fn set_activation_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_key(input);
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(inp);
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
        /// <p>A value that indicates the time zone you want to set for the gateway. The time zone is
        /// of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4
        /// hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is
        /// used, for example, for scheduling snapshots and your gateway's maintenance
        /// schedule.</p>
        pub fn gateway_timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_timezone(inp);
            self
        }
        /// <p>A value that indicates the time zone you want to set for the gateway. The time zone is
        /// of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4
        /// hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is
        /// used, for example, for scheduling snapshots and your gateway's maintenance
        /// schedule.</p>
        pub fn set_gateway_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_timezone(input);
            self
        }
        /// <p>A value that indicates the Amazon Web Services Region where you want to store your data.
        /// The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region
        /// as the Amazon Web Services Region in your <code>Host</code> header in the request. For more
        /// information about available Amazon Web Services Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.</p>
        ///
        /// <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.
        ///
        /// </p>
        pub fn gateway_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_region(inp);
            self
        }
        /// <p>A value that indicates the Amazon Web Services Region where you want to store your data.
        /// The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region
        /// as the Amazon Web Services Region in your <code>Host</code> header in the request. For more
        /// information about available Amazon Web Services Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.</p>
        ///
        /// <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
        /// Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services
        /// General Reference</i>.
        ///
        /// </p>
        pub fn set_gateway_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_region(input);
            self
        }
        /// <p>A value that defines the type of gateway to activate. The type specified is critical to
        /// all later functions of the gateway and cannot be changed after activation. The default
        /// value is <code>CACHED</code>.</p>
        ///
        /// <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> |
        /// <code>FILE_S3</code> | <code>FILE_FSX_SMB|</code>
        /// </p>
        pub fn gateway_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_type(inp);
            self
        }
        /// <p>A value that defines the type of gateway to activate. The type specified is critical to
        /// all later functions of the gateway and cannot be changed after activation. The default
        /// value is <code>CACHED</code>.</p>
        ///
        /// <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> |
        /// <code>FILE_S3</code> | <code>FILE_FSX_SMB|</code>
        /// </p>
        pub fn set_gateway_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_type(input);
            self
        }
        /// <p>The value that indicates the type of tape drive to use for tape gateway. This field is
        /// optional.</p>
        ///
        /// <p>Valid Values: <code>IBM-ULT3580-TD5</code>
        /// </p>
        pub fn tape_drive_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_drive_type(inp);
            self
        }
        /// <p>The value that indicates the type of tape drive to use for tape gateway. This field is
        /// optional.</p>
        ///
        /// <p>Valid Values: <code>IBM-ULT3580-TD5</code>
        /// </p>
        pub fn set_tape_drive_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tape_drive_type(input);
            self
        }
        /// <p>The value that indicates the type of medium changer to use for tape gateway. This field
        /// is optional.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn medium_changer_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.medium_changer_type(inp);
            self
        }
        /// <p>The value that indicates the type of medium changer to use for tape gateway. This field
        /// is optional.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn set_medium_changer_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_medium_changer_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that can be
        /// represented in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that can be
        /// represented in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddCache`.
    ///
    /// <p>Configures one or more gateway local disks as cache for a gateway. This operation is
    /// only supported in the cached volume, tape, and file gateway type (see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">How Storage Gateway works (architecture)</a>.</p>
    ///
    /// <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to
    /// add cache, and one or more disk IDs that you want to configure as cache.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_cache_input::Builder,
    }
    impl<C, M, R> AddCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::AddCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddCacheInputOperationOutputAlias,
                crate::output::AddCacheOutput,
                crate::error::AddCacheError,
                crate::input::AddCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `DiskIds`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn disk_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_ids(inp);
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_disk_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds one or more tags to the specified resource. You use tags to add metadata to
    /// resources, which you can use to categorize these resources. For example, you can categorize
    /// resources by purpose, owner, environment, or team. Each tag consists of a key and a value,
    /// which you define. You can add tags to the following Storage Gateway resources:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Storage gateways of all types</p>
    /// </li>
    /// <li>
    /// <p>Storage volumes</p>
    /// </li>
    /// <li>
    /// <p>Virtual tapes</p>
    /// </li>
    /// <li>
    /// <p>NFS and SMB file shares</p>
    /// </li>
    /// <li>
    /// <p>File System associations</p>
    /// </li>
    /// </ul>
    ///
    /// <p>You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes
    /// that are recovered to a new gateway maintain their tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag you want to add to the resource. The value
        /// can be an empty string.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag you want to add to the resource. The value
        /// can be an empty string.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddUploadBuffer`.
    ///
    /// <p>Configures one or more gateway local disks as upload buffer for a specified gateway.
    /// This operation is supported for the stored volume, cached volume, and tape gateway
    /// types.</p>
    ///
    /// <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to
    /// add upload buffer, and one or more disk IDs that you want to configure as upload
    /// buffer.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddUploadBuffer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_upload_buffer_input::Builder,
    }
    impl<C, M, R> AddUploadBuffer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddUploadBuffer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddUploadBufferOutput,
            aws_smithy_http::result::SdkError<crate::error::AddUploadBufferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddUploadBufferInputOperationOutputAlias,
                crate::output::AddUploadBufferOutput,
                crate::error::AddUploadBufferError,
                crate::input::AddUploadBufferInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `DiskIds`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn disk_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_ids(inp);
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_disk_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddWorkingStorage`.
    ///
    /// <p>Configures one or more gateway local disks as working storage for a gateway. This
    /// operation is only supported in the stored volume gateway type. This operation is deprecated
    /// in cached volume API version 20120630. Use <a>AddUploadBuffer</a>
    /// instead.</p>
    ///
    /// <note>
    /// <p>Working storage is also referred to as upload buffer. You can also use the <a>AddUploadBuffer</a> operation to add upload buffer to a stored volume
    /// gateway.</p>
    /// </note>
    ///
    /// <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to
    /// add working storage, and one or more disk IDs that you want to configure as working
    /// storage.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddWorkingStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_working_storage_input::Builder,
    }
    impl<C, M, R> AddWorkingStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddWorkingStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddWorkingStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::AddWorkingStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddWorkingStorageInputOperationOutputAlias,
                crate::output::AddWorkingStorageOutput,
                crate::error::AddWorkingStorageError,
                crate::input::AddWorkingStorageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `DiskIds`.
        ///
        /// To override the contents of this collection use [`set_disk_ids`](Self::set_disk_ids).
        ///
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn disk_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_ids(inp);
            self
        }
        /// <p>An array of strings that identify disks that are to be configured as working storage.
        /// Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
        /// from the <a>ListLocalDisks</a> API.</p>
        pub fn set_disk_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_disk_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssignTapePool`.
    ///
    /// <p>Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in
    /// the S3 storage class that is associated with the pool. When you use your backup application
    /// to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or
    /// S3 Glacier Deep Archive) that corresponds to the pool.</p>
    ///
    /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AssignTapePool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::assign_tape_pool_input::Builder,
    }
    impl<C, M, R> AssignTapePool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssignTapePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssignTapePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::AssignTapePoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssignTapePoolInputOperationOutputAlias,
                crate::output::AssignTapePoolOutput,
                crate::error::AssignTapePoolError,
                crate::input::AssignTapePoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the
        /// tape pool.</p>
        pub fn tape_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(inp);
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the
        /// tape pool.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(inp);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>Set permissions to bypass governance retention. If the lock type of the archived tape is
        /// <code>Governance</code>, the tape's archived age is not older than
        /// <code>RetentionLockInDays</code>, and the user does not already have
        /// <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass
        /// the retention lock. This parameter is set to true by default for calls from the
        /// console.</p>
        ///
        /// <p>Valid values: <code>TRUE</code> | <code>FALSE</code>
        /// </p>
        pub fn bypass_governance_retention(mut self, inp: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(inp);
            self
        }
        /// <p>Set permissions to bypass governance retention. If the lock type of the archived tape is
        /// <code>Governance</code>, the tape's archived age is not older than
        /// <code>RetentionLockInDays</code>, and the user does not already have
        /// <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass
        /// the retention lock. This parameter is set to true by default for calls from the
        /// console.</p>
        ///
        /// <p>Valid values: <code>TRUE</code> | <code>FALSE</code>
        /// </p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateFileSystem`.
    ///
    /// <p>Associate an Amazon FSx file system with the FSx File Gateway. After the
    /// association process is complete, the file shares on the Amazon FSx file system are
    /// available for access through the gateway. This operation only supports the FSx File Gateway
    /// type.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateFileSystem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_file_system_input::Builder,
    }
    impl<C, M, R> AssociateFileSystem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFileSystemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateFileSystemInputOperationOutputAlias,
                crate::output::AssociateFileSystemOutput,
                crate::error::AssociateFileSystemError,
                crate::input::AssociateFileSystemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A unique string value that you supply that is used by the FSx File Gateway to ensure
        /// idempotent file system association creation.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique string value that you supply that is used by the FSx File Gateway to ensure
        /// idempotent file system association creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with
        /// the FSx File Gateway.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with
        /// the FSx File Gateway.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the file system association. Each tag is
        /// a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the file system association. Each tag is
        /// a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn audit_destination_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn cache_attributes(mut self, inp: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(inp);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>Specifies the network configuration information for the gateway associated with the
        /// Amazon FSx file system.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's
        /// <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn endpoint_network_configuration(
            mut self,
            inp: crate::model::EndpointNetworkConfiguration,
        ) -> Self {
            self.inner = self.inner.endpoint_network_configuration(inp);
            self
        }
        /// <p>Specifies the network configuration information for the gateway associated with the
        /// Amazon FSx file system.</p>
        /// <note>
        /// <p>If multiple file systems are associated with this gateway, this parameter's
        /// <code>IpAddresses</code> field is required.</p>
        /// </note>
        pub fn set_endpoint_network_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointNetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_network_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachVolume`.
    ///
    /// <p>Connects a volume to an iSCSI connection and then attaches the volume to the specified
    /// gateway. Detaching and attaching a volume enables you to recover your data from one gateway
    /// to a different gateway without creating a snapshot. It also makes it easier to move your
    /// volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachVolume<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_volume_input::Builder,
    }
    impl<C, M, R> AttachVolume<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachVolumeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachVolumeInputOperationOutputAlias,
                crate::output::AttachVolumeOutput,
                crate::error::AttachVolumeError,
                crate::input::AttachVolumeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume
        /// to.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume
        /// to.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(inp);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(inp);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>The unique device ID or other distinguishing data that identifies the local disk used to
        /// create the volume. This value is only required when you are attaching a stored
        /// volume.</p>
        pub fn disk_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_id(inp);
            self
        }
        /// <p>The unique device ID or other distinguishing data that identifies the local disk used to
        /// create the volume. This value is only required when you are attaching a stored
        /// volume.</p>
        pub fn set_disk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelArchival`.
    ///
    /// <p>Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving
    /// process is initiated. This operation is only supported in the tape gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelArchival<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_archival_input::Builder,
    }
    impl<C, M, R> CancelArchival<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelArchival`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelArchivalOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelArchivalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelArchivalInputOperationOutputAlias,
                crate::output::CancelArchivalOutput,
                crate::error::CancelArchivalError,
                crate::input::CancelArchivalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
        /// for.</p>
        pub fn tape_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
        /// for.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelRetrieval`.
    ///
    /// <p>Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after
    /// the retrieval process is initiated. The virtual tape is returned to the VTS. This operation
    /// is only supported in the tape gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelRetrieval<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_retrieval_input::Builder,
    }
    impl<C, M, R> CancelRetrieval<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelRetrieval`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelRetrievalOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelRetrievalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelRetrievalInputOperationOutputAlias,
                crate::output::CancelRetrievalOutput,
                crate::error::CancelRetrievalError,
                crate::input::CancelRetrievalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
        /// for.</p>
        pub fn tape_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
        /// for.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCachediSCSIVolume`.
    ///
    /// <p>Creates a cached volume on a specified cached volume gateway. This operation is only
    /// supported in the cached volume gateway type.</p>
    ///
    /// <note>
    /// <p>Cache storage must be allocated to the gateway before you can create a cached volume.
    /// Use the <a>AddCache</a> operation to add cache storage to a gateway.</p>
    /// </note>
    ///
    /// <p>In the request, you must specify the gateway, size of the volume in bytes, the iSCSI
    /// target name, an IP address on which to expose the target, and a unique client token. In
    /// response, the gateway creates the volume and returns information about it. This information
    /// includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that
    /// initiators can use to connect to the volume target.</p>
    ///
    /// <p>Optionally, you can provide the ARN for an existing volume as the
    /// <code>SourceVolumeARN</code> for this cached volume, which creates an exact copy of the
    /// existing volume’s latest recovery point. The <code>VolumeSizeInBytes</code> value must be
    /// equal to or larger than the size of the copied volume, in bytes.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCachediSCSIVolume<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cachedi_scsi_volume_input::Builder,
    }
    impl<C, M, R> CreateCachediSCSIVolume<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCachediSCSIVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCachediScsiVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCachediSCSIVolumeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCachediScsiVolumeInputOperationOutputAlias,
                crate::output::CreateCachediScsiVolumeOutput,
                crate::error::CreateCachediSCSIVolumeError,
                crate::input::CreateCachediScsiVolumeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn volume_size_in_bytes(mut self, inp: i64) -> Self {
            self.inner = self.inner.volume_size_in_bytes(inp);
            self
        }
        /// <p>The size of the volume in bytes.</p>
        pub fn set_volume_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_volume_size_in_bytes(input);
            self
        }
        /// <p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn snapshot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(inp);
            self
        }
        /// <p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(inp);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
        /// <p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact
        /// copy of the specified existing volume's latest recovery point. The
        /// <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than
        /// the size of the existing volume, in bytes.</p>
        pub fn source_volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_volume_arn(inp);
            self
        }
        /// <p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact
        /// copy of the specified existing volume's latest recovery point. The
        /// <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than
        /// the size of the existing volume, in bytes.</p>
        pub fn set_source_volume_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_volume_arn(input);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(inp);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that you can
        /// represent in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers that you can
        /// represent in UTF-8 format, and the following special characters: + - = . _ : / @. The
        /// maximum length of a tag's key is 128 characters, and the maximum length for a
        /// tag's value is 256 characters.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNFSFileShare`.
    ///
    /// <p>Creates a Network File System (NFS) file share on an existing S3 File Gateway. In
    /// Storage Gateway, a file share is a file system mount point backed by Amazon S3
    /// cloud storage. Storage Gateway exposes file shares using an NFS interface. This operation
    /// is only supported for S3 File Gateways.</p>
    ///
    /// <important>
    /// <p>S3 File gateway requires Security Token Service (Amazon Web Services STS) to be
    /// activated to enable you to create a file share. Make sure Amazon Web Services STS is
    /// activated in the Amazon Web Services Region you are creating your S3 File Gateway in. If
    /// Amazon Web Services STS is not activated in the Amazon Web Services Region, activate
    /// it. For information about how to activate Amazon Web Services STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
    /// deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the
    /// <i>Identity and Access Management User Guide</i>.</p>
    ///
    /// <p>S3 File Gateways do not support creating hard or symbolic links on a file
    /// share.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateNFSFileShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_nfs_file_share_input::Builder,
    }
    impl<C, M, R> CreateNFSFileShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNFSFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNfsFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNFSFileShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNfsFileShareInputOperationOutputAlias,
                crate::output::CreateNfsFileShareOutput,
                crate::error::CreateNFSFileShareError,
                crate::input::CreateNfsFileShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>File share default values. Optional.</p>
        pub fn nfs_file_share_defaults(mut self, inp: crate::model::NfsFileShareDefaults) -> Self {
            self.inner = self.inner.nfs_file_share_defaults(inp);
            self
        }
        /// <p>File share default values. Optional.</p>
        pub fn set_nfs_file_share_defaults(
            mut self,
            input: std::option::Option<crate::model::NfsFileShareDefaults>,
        ) -> Self {
            self.inner = self.inner.set_nfs_file_share_defaults(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file
        /// share.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file
        /// share.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(inp);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, inp: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(inp);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// Appends an item to `ClientList`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn client_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_list(inp);
            self
        }
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_client_list(input);
            self
        }
        /// <p>A value that maps a user to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn squash(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.squash(inp);
            self
        }
        /// <p>A value that maps a user to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn set_squash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_squash(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.read_only(inp);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(inp);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, inp: bool) -> Self {
            self.inner = self.inner.requester_pays(inp);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(inp);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, inp: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(inp);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(inp);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_dns_name(inp);
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_dns_name(input);
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_region(inp);
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for NFS file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bucket_region(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSMBFileShare`.
    ///
    /// <p>Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In
    /// Storage Gateway, a file share is a file system mount point backed by Amazon S3
    /// cloud storage. Storage Gateway exposes file shares using an SMB interface. This operation
    /// is only supported for S3 File Gateways.</p>
    ///
    /// <important>
    /// <p>S3 File Gateways require Security Token Service (Amazon Web Services STS) to be
    /// activated to enable you to create a file share. Make sure that Amazon Web Services STS
    /// is activated in the Amazon Web Services Region you are creating your S3 File Gateway in.
    /// If Amazon Web Services STS is not activated in this Amazon Web Services Region, activate
    /// it. For information about how to activate Amazon Web Services STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
    /// deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the
    /// <i>Identity and Access Management User Guide</i>.</p>
    ///
    /// <p>File gateways don't support creating hard or symbolic links on a file
    /// share.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateSMBFileShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_smb_file_share_input::Builder,
    }
    impl<C, M, R> CreateSMBFileShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSMBFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSmbFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSMBFileShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSmbFileShareInputOperationOutputAlias,
                crate::output::CreateSmbFileShareOutput,
                crate::error::CreateSMBFileShareError,
                crate::input::CreateSmbFileShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique string value that you supply that is used by S3 File Gateway to ensure
        /// idempotent file share creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ARN of the S3 File Gateway on which you want to create a file share.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The ARN of the S3 File Gateway on which you want to create a file share.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it
        /// accesses the underlying storage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>A custom ARN for the backend storage used for storing data for file shares. It includes
        /// a resource ARN with an optional prefix concatenation. The prefix must end with a forward
        /// slash (/).</p>
        /// <note>
        /// <p>You can specify LocationARN as a bucket ARN, access point ARN or access point alias,
        /// as shown in the following examples.</p>
        ///
        /// <p>Bucket ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:::my-bucket/prefix/</code>
        /// </p>
        ///
        /// <p>Access point ARN:</p>
        /// <p>
        /// <code>arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/</code>
        /// </p>
        ///
        /// <p>If you specify an access point, the bucket policy must be configured to delegate
        /// access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        ///
        /// <p>Access point alias:</p>
        /// <p>
        /// <code>test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias</code>
        /// </p>
        /// </note>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(inp);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, inp: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(inp);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.read_only(inp);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(inp);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, inp: bool) -> Self {
            self.inner = self.inner.requester_pays(inp);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn smbacl_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.smbacl_enabled(inp);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_smbacl_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_smbacl_enabled(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn access_based_enumeration(mut self, inp: bool) -> Self {
            self.inner = self.inner.access_based_enumeration(inp);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn set_access_based_enumeration(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_access_based_enumeration(input);
            self
        }
        /// Appends an item to `AdminUserList`.
        ///
        /// To override the contents of this collection use [`set_admin_user_list`](Self::set_admin_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that will be granted administrator
        /// privileges on the file share. These users can do all file operations as the super-user.
        /// Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
        /// <code>@group1</code>, and <code>@DOMAIN\group1</code>.</p>
        ///
        /// <important>
        /// <p>Use this option very carefully, because any user in this list can do anything they
        /// like on the file share, regardless of file permissions.</p>
        /// </important>
        pub fn admin_user_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_user_list(inp);
            self
        }
        /// <p>A list of users or groups in the Active Directory that will be granted administrator
        /// privileges on the file share. These users can do all file operations as the super-user.
        /// Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
        /// <code>@group1</code>, and <code>@DOMAIN\group1</code>.</p>
        ///
        /// <important>
        /// <p>Use this option very carefully, because any user in this list can do anything they
        /// like on the file share, regardless of file permissions.</p>
        /// </important>
        pub fn set_admin_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_admin_user_list(input);
            self
        }
        /// Appends an item to `ValidUserList`.
        ///
        /// To override the contents of this collection use [`set_valid_user_list`](Self::set_valid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// <a href=""></a> share. A group must be prefixed with the @ character. Acceptable formats
        /// include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn valid_user_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.valid_user_list(inp);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// <a href=""></a> share. A group must be prefixed with the @ character. Acceptable formats
        /// include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_valid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_valid_user_list(input);
            self
        }
        /// Appends an item to `InvalidUserList`.
        ///
        /// To override the contents of this collection use [`set_invalid_user_list`](Self::set_invalid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn invalid_user_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invalid_user_list(inp);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_invalid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_invalid_user_list(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The authentication method that users use to access the file share. The default is
        /// <code>ActiveDirectory</code>.</p>
        ///
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code>
        /// </p>
        pub fn authentication(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication(inp);
            self
        }
        /// <p>The authentication method that users use to access the file share. The default is
        /// <code>ActiveDirectory</code>.</p>
        ///
        /// <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code>
        /// </p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn case_sensitivity(mut self, inp: crate::model::CaseSensitivity) -> Self {
            self.inner = self.inner.case_sensitivity(inp);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn set_case_sensitivity(
            mut self,
            input: std::option::Option<crate::model::CaseSensitivity>,
        ) -> Self {
            self.inner = self.inner.set_case_sensitivity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a
        /// key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(inp);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, inp: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(inp);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(inp);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn vpc_endpoint_dns_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_dns_name(inp);
            self
        }
        /// <p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to
        /// Amazon S3.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_vpc_endpoint_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_dns_name(input);
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn bucket_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_region(inp);
            self
        }
        /// <p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p>
        /// <note>
        /// <p>This parameter is required for SMB file shares that connect to Amazon S3
        /// through a VPC endpoint, a VPC access point, or an access point alias that points to a
        /// VPC access point.</p>
        /// </note>
        pub fn set_bucket_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bucket_region(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn oplocks_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.oplocks_enabled(inp);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_oplocks_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_oplocks_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Initiates a snapshot of a volume.</p>
    ///
    /// <p>Storage Gateway provides the ability to back up point-in-time snapshots of your
    /// data to Amazon Simple Storage (Amazon S3) for durable off-site recovery, and also
    /// import the data to an Amazon Elastic Block Store (EBS) volume in Amazon Elastic Compute
    /// Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc basis.
    /// This API enables you to take an ad hoc snapshot. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot">Editing a
    /// snapshot schedule</a>.</p>
    ///
    /// <p>In the <code>CreateSnapshot</code> request, you identify the volume by providing its
    /// Amazon Resource Name (ARN). You must also provide description for the snapshot. When
    /// Storage Gateway takes the snapshot of specified volume, the snapshot and
    /// description appears in the Storage Gateway console. In response, Storage Gateway
    /// returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or
    /// later use it when you want to create a volume from a snapshot. This operation is only
    /// supported in stored and cached volume gateway type.</p>
    ///
    /// <note>
    /// <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a>
    /// or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in the <i>Amazon Elastic Compute Cloud API
    /// Reference</i>.</p>
    /// </note>
    ///
    /// <important>
    /// <p>Volume and snapshot IDs are changing to a longer length ID format. For more
    /// information, see the important note on the <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome</a> page.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl<C, M, R> CreateSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotInputOperationOutputAlias,
                crate::output::CreateSnapshotOutput,
                crate::error::CreateSnapshotError,
                crate::input::CreateSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn snapshot_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_description(inp);
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn set_snapshot_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshotFromVolumeRecoveryPoint`.
    ///
    /// <p>Initiates a snapshot of a gateway from a volume recovery point. This operation is only
    /// supported in the cached volume gateway type.</p>
    ///
    /// <p>A volume recovery point is a point in time at which all data of the volume is consistent
    /// and from which you can create a snapshot. To get a list of volume recovery point for cached
    /// volume gateway, use <a>ListVolumeRecoveryPoints</a>.</p>
    ///
    /// <p>In the <code>CreateSnapshotFromVolumeRecoveryPoint</code> request, you identify the
    /// volume by providing its Amazon Resource Name (ARN). You must also provide a description for
    /// the snapshot. When the gateway takes a snapshot of the specified volume, the snapshot and
    /// its description appear in the Storage Gateway console.
    /// In response, the gateway returns
    /// you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use
    /// it when you want to create a volume from a snapshot.</p>
    ///
    /// <note>
    /// <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a>
    /// or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in the <i>Amazon Elastic Compute Cloud API
    /// Reference</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateSnapshotFromVolumeRecoveryPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_from_volume_recovery_point_input::Builder,
    }
    impl<C, M, R> CreateSnapshotFromVolumeRecoveryPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshotFromVolumeRecoveryPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotFromVolumeRecoveryPointOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateSnapshotFromVolumeRecoveryPointError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotFromVolumeRecoveryPointInputOperationOutputAlias,
                crate::output::CreateSnapshotFromVolumeRecoveryPointOutput,
                crate::error::CreateSnapshotFromVolumeRecoveryPointError,
                crate::input::CreateSnapshotFromVolumeRecoveryPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn snapshot_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_description(inp);
            self
        }
        /// <p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic
        /// Block Store snapshots panel in the <b>Description</b> field, and
        /// in the Storage Gateway snapshot <b>Details</b> pane,
        /// <b>Description</b> field.</p>
        pub fn set_snapshot_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStorediSCSIVolume`.
    ///
    /// <p>Creates a volume on a specified gateway. This operation is only supported in the stored
    /// volume gateway type.</p>
    ///
    /// <p>The size of the volume to create is inferred from the disk size. You can choose to
    /// preserve existing data on the disk, create volume from an existing snapshot, or create an
    /// empty volume. If you choose to create an empty gateway volume, then any existing data on
    /// the disk is erased.</p>
    ///
    /// <p>In the request, you must specify the gateway and the disk information on which you are
    /// creating the volume. In response, the gateway creates the volume and returns volume
    /// information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target
    /// ARN that initiators can use to connect to the volume target.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStorediSCSIVolume<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_storedi_scsi_volume_input::Builder,
    }
    impl<C, M, R> CreateStorediSCSIVolume<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStorediSCSIVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStorediScsiVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStorediSCSIVolumeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStorediScsiVolumeInputOperationOutputAlias,
                crate::output::CreateStorediScsiVolumeOutput,
                crate::error::CreateStorediSCSIVolumeError,
                crate::input::CreateStorediScsiVolumeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The unique identifier for the gateway local disk that is configured as a stored volume.
        /// Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to
        /// list disk IDs for a gateway.</p>
        pub fn disk_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_id(inp);
            self
        }
        /// <p>The unique identifier for the gateway local disk that is configured as a stored volume.
        /// Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to
        /// list disk IDs for a gateway.</p>
        pub fn set_disk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_id(input);
            self
        }
        /// <p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn snapshot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(inp);
            self
        }
        /// <p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored
        /// volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
        /// otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
        /// Reference</i>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise,
        /// set to <code>false</code> to create an empty volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn preserve_existing_data(mut self, inp: bool) -> Self {
            self.inner = self.inner.preserve_existing_data(inp);
            self
        }
        /// <p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise,
        /// set to <code>false</code> to create an empty volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_preserve_existing_data(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_preserve_existing_data(input);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn target_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(inp);
            self
        }
        /// <p>The name of the iSCSI target used by an initiator to connect to a volume and used as a
        /// suffix for the target ARN. For example, specifying <code>TargetName</code> as
        /// <i>myvolume</i> results in the target ARN of
        /// <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>.
        /// The target name must be unique across all volumes on a gateway.</p>
        ///
        /// <p>If you don't specify a value, Storage Gateway uses the value that was previously
        /// used for this volume as the new target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn network_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(inp);
            self
        }
        /// <p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4
        /// addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of
        /// the network interfaces available on a gateway.</p>
        ///
        /// <p>Valid Values: A valid IP address.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTapePool`.
    ///
    /// <p>Creates a new custom tape pool. You can use custom tape pool to enable tape retention
    /// lock on tapes that are archived in the custom pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTapePool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tape_pool_input::Builder,
    }
    impl<C, M, R> CreateTapePool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTapePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTapePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTapePoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTapePoolInputOperationOutputAlias,
                crate::output::CreateTapePoolOutput,
                crate::error::CreateTapePoolError,
                crate::input::CreateTapePoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new custom tape pool.</p>
        pub fn pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(inp);
            self
        }
        /// <p>The name of the new custom tape pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// <p>The storage class that is associated with the new custom pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn storage_class(mut self, inp: crate::model::TapeStorageClass) -> Self {
            self.inner = self.inner.storage_class(inp);
            self
        }
        /// <p>The storage class that is associated with the new custom pool. When you use your backup
        /// application to eject the tape, the tape is archived directly into the storage class (S3
        /// Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TapeStorageClass>,
        ) -> Self {
            self.inner = self.inner.set_storage_class(input);
            self
        }
        /// <p>Tape retention lock can be configured in two modes. When configured in governance mode,
        /// Amazon Web Services accounts with specific IAM permissions are authorized to remove the
        /// tape retention lock from archived virtual tapes. When configured in compliance mode, the
        /// tape retention lock cannot be removed by any user, including the root Amazon Web Services account.</p>
        pub fn retention_lock_type(mut self, inp: crate::model::RetentionLockType) -> Self {
            self.inner = self.inner.retention_lock_type(inp);
            self
        }
        /// <p>Tape retention lock can be configured in two modes. When configured in governance mode,
        /// Amazon Web Services accounts with specific IAM permissions are authorized to remove the
        /// tape retention lock from archived virtual tapes. When configured in compliance mode, the
        /// tape retention lock cannot be removed by any user, including the root Amazon Web Services account.</p>
        pub fn set_retention_lock_type(
            mut self,
            input: std::option::Option<crate::model::RetentionLockType>,
        ) -> Self {
            self.inner = self.inner.set_retention_lock_type(input);
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to
        /// 100 years (36,500 days).</p>
        pub fn retention_lock_time_in_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.retention_lock_time_in_days(inp);
            self
        }
        /// <p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to
        /// 100 years (36,500 days).</p>
        pub fn set_retention_lock_time_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_lock_time_in_days(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTapes`.
    ///
    /// <p>Creates one or more virtual tapes. You write data to the virtual tapes and then archive
    /// the tapes. This operation is only supported in the tape gateway type.</p>
    ///
    /// <note>
    /// <p>Cache storage must be allocated to the gateway before you can create virtual tapes.
    /// Use the <a>AddCache</a> operation to add cache storage to a gateway.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateTapes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tapes_input::Builder,
    }
    impl<C, M, R> CreateTapes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTapes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTapesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTapesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTapesInputOperationOutputAlias,
                crate::output::CreateTapesOutput,
                crate::error::CreateTapesError,
                crate::input::CreateTapesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tapes with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tapes with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tapes that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn tape_size_in_bytes(mut self, inp: i64) -> Self {
            self.inner = self.inner.tape_size_in_bytes(inp);
            self
        }
        /// <p>The size, in bytes, of the virtual tapes that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_tape_size_in_bytes(input);
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        ///
        /// <note>
        /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple
        /// times.</p>
        /// </note>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique identifier that you use to retry a request. If you retry a request, use the
        /// same <code>ClientToken</code> you specified in the initial request.</p>
        ///
        /// <note>
        /// <p>Using the same <code>ClientToken</code> prevents creating the tape multiple
        /// times.</p>
        /// </note>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The number of virtual tapes that you want to create.</p>
        pub fn num_tapes_to_create(mut self, inp: i32) -> Self {
            self.inner = self.inner.num_tapes_to_create(inp);
            self
        }
        /// <p>The number of virtual tapes that you want to create.</p>
        pub fn set_num_tapes_to_create(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_tapes_to_create(input);
            self
        }
        /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This
        /// prefix makes the barcode unique.</p>
        ///
        /// <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
        /// from A to Z.</p>
        /// </note>
        pub fn tape_barcode_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_barcode_prefix(inp);
            self
        }
        /// <p>A prefix that you append to the barcode of the virtual tape you are creating. This
        /// prefix makes the barcode unique.</p>
        ///
        /// <note>
        /// <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters
        /// from A to Z.</p>
        /// </note>
        pub fn set_tape_barcode_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tape_barcode_prefix(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(inp);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn worm(mut self, inp: bool) -> Self {
            self.inner = self.inner.worm(inp);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_worm(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTapeWithBarcode`.
    ///
    /// <p>Creates a virtual tape by using your own barcode. You write data to the virtual tape and
    /// then archive the tape. A barcode is unique and cannot be reused if it has already been used
    /// on a tape. This applies to barcodes used on deleted tapes. This operation is only supported
    /// in the tape gateway type.</p>
    ///
    /// <note>
    /// <p>Cache storage must be allocated to the gateway before you can create a virtual tape.
    /// Use the <a>AddCache</a> operation to add cache storage to a gateway.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateTapeWithBarcode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tape_with_barcode_input::Builder,
    }
    impl<C, M, R> CreateTapeWithBarcode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTapeWithBarcode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTapeWithBarcodeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTapeWithBarcodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTapeWithBarcodeInputOperationOutputAlias,
                crate::output::CreateTapeWithBarcodeOutput,
                crate::error::CreateTapeWithBarcodeError,
                crate::input::CreateTapeWithBarcodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tape with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the
        /// virtual tape with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The size, in bytes, of the virtual tape that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn tape_size_in_bytes(mut self, inp: i64) -> Self {
            self.inner = self.inner.tape_size_in_bytes(inp);
            self
        }
        /// <p>The size, in bytes, of the virtual tape that you want to create.</p>
        ///
        /// <note>
        /// <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p>
        /// </note>
        pub fn set_tape_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_tape_size_in_bytes(input);
            self
        }
        /// <p>The barcode that you want to assign to the tape.</p>
        ///
        /// <note>
        /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been
        /// deleted.</p>
        /// </note>
        pub fn tape_barcode(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_barcode(inp);
            self
        }
        /// <p>The barcode that you want to assign to the tape.</p>
        ///
        /// <note>
        /// <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been
        /// deleted.</p>
        /// </note>
        pub fn set_tape_barcode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_barcode(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(inp);
            self
        }
        /// <p>The ID of the pool that you want to add your tape to for archiving. The tape in this
        /// pool is archived in the S3 storage class that is associated with the pool. When you use
        /// your backup application to eject the tape, the tape is archived directly into the storage
        /// class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p>
        ///
        /// <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
        /// </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn worm(mut self, inp: bool) -> Self {
            self.inner = self.inner.worm(inp);
            self
        }
        /// <p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a
        /// write-once-read-many (WORM) tape.</p>
        pub fn set_worm(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_worm(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
        /// tag is a key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
        /// tag is a key-value pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAutomaticTapeCreationPolicy`.
    ///
    /// <p>Deletes the automatic tape creation policy of a gateway. If you delete this policy, new
    /// virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway
    /// in your request to remove the policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAutomaticTapeCreationPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_automatic_tape_creation_policy_input::Builder,
    }
    impl<C, M, R> DeleteAutomaticTapeCreationPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAutomaticTapeCreationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAutomaticTapeCreationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAutomaticTapeCreationPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAutomaticTapeCreationPolicyInputOperationOutputAlias,
                crate::output::DeleteAutomaticTapeCreationPolicyOutput,
                crate::error::DeleteAutomaticTapeCreationPolicyError,
                crate::input::DeleteAutomaticTapeCreationPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBandwidthRateLimit`.
    ///
    /// <p>Deletes the bandwidth rate limits of a gateway. You can delete either the upload and
    /// download bandwidth rate limit, or you can delete both. If you delete only one of the
    /// limits, the other limit remains unchanged. To specify which gateway to work with, use the
    /// Amazon Resource Name (ARN) of the gateway in your request. This operation is supported for
    /// the stored volume, cached volume and tape gateway types.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBandwidthRateLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bandwidth_rate_limit_input::Builder,
    }
    impl<C, M, R> DeleteBandwidthRateLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBandwidthRateLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBandwidthRateLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBandwidthRateLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBandwidthRateLimitInputOperationOutputAlias,
                crate::output::DeleteBandwidthRateLimitOutput,
                crate::error::DeleteBandwidthRateLimitError,
                crate::input::DeleteBandwidthRateLimitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to
        /// delete.</p>
        ///
        /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code>
        /// </p>
        pub fn bandwidth_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth_type(inp);
            self
        }
        /// <p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to
        /// delete.</p>
        ///
        /// <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code>
        /// </p>
        pub fn set_bandwidth_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChapCredentials`.
    ///
    /// <p>Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified
    /// iSCSI target and initiator pair. This operation is supported in volume and tape gateway
    /// types.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChapCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_chap_credentials_input::Builder,
    }
    impl<C, M, R> DeleteChapCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChapCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChapCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChapCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChapCredentialsInputOperationOutputAlias,
                crate::output::DeleteChapCredentialsOutput,
                crate::error::DeleteChapCredentialsError,
                crate::input::DeleteChapCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initiator_name(inp);
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initiator_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFileShare`.
    ///
    /// <p>Deletes a file share from an S3 File Gateway. This operation is only supported for S3
    /// File Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFileShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_file_share_input::Builder,
    }
    impl<C, M, R> DeleteFileShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFileShareInputOperationOutputAlias,
                crate::output::DeleteFileShareOutput,
                crate::error::DeleteFileShareError,
                crate::input::DeleteFileShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
        pub fn file_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// <p>If this value is set to <code>true</code>, the operation deletes a file share
        /// immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is
        /// not deleted until all data is uploaded to Amazon Web Services. This process aborts the data
        /// upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn force_delete(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete(inp);
            self
        }
        /// <p>If this value is set to <code>true</code>, the operation deletes a file share
        /// immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is
        /// not deleted until all data is uploaded to Amazon Web Services. This process aborts the data
        /// upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGateway`.
    ///
    /// <p>Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name
    /// (ARN) of the gateway in your request. The operation deletes the gateway; however, it does
    /// not delete the gateway virtual machine (VM) from your host computer.</p>
    ///
    /// <p>After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway
    /// volumes are not deleted upon deleting the gateway, however, pending snapshots will not
    /// complete. After you delete a gateway, your next step is to remove it from your
    /// environment.</p>
    ///
    /// <important>
    /// <p>You no longer pay software charges after the gateway is deleted; however, your
    /// existing Amazon EBS snapshots persist and you will continue to be billed for these
    /// snapshots. You can choose to remove all remaining Amazon EBS snapshots by canceling your
    /// Amazon EC2 subscription.  If you prefer not to cancel your Amazon EC2 subscription, you
    /// can delete your snapshots using the Amazon EC2 console. For more information, see the
    /// <a href="http://aws.amazon.com/storagegateway">Storage Gateway detail
    /// page</a>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gateway_input::Builder,
    }
    impl<C, M, R> DeleteGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGatewayInputOperationOutputAlias,
                crate::output::DeleteGatewayOutput,
                crate::error::DeleteGatewayError,
                crate::input::DeleteGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshotSchedule`.
    ///
    /// <p>Deletes a snapshot of a volume.</p>
    ///
    /// <p>You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API
    /// action enables you to delete a snapshot schedule for a volume. For more information, see
    /// <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html">Backing up your
    /// volumes</a>. In the <code>DeleteSnapshotSchedule</code> request, you identify the
    /// volume by providing its Amazon Resource Name (ARN). This operation is only supported in
    /// stored and cached volume gateway types.</p>
    ///
    /// <note>
    ///
    /// <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
    /// go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a>
    /// in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSnapshotSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_snapshot_schedule_input::Builder,
    }
    impl<C, M, R> DeleteSnapshotSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSnapshotScheduleInputOperationOutputAlias,
                crate::output::DeleteSnapshotScheduleOutput,
                crate::error::DeleteSnapshotScheduleError,
                crate::input::DeleteSnapshotScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The volume which snapshot schedule to delete.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The volume which snapshot schedule to delete.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTape`.
    ///
    /// <p>Deletes the specified virtual tape. This operation is only supported in the tape gateway
    /// type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTape<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tape_input::Builder,
    }
    impl<C, M, R> DeleteTape<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTape`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTapeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTapeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTapeInputOperationOutputAlias,
                crate::output::DeleteTapeOutput,
                crate::error::DeleteTapeError,
                crate::input::DeleteTapeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
        /// associated with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
        /// associated with. Use the <a>ListGateways</a> operation to return a list of
        /// gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
        pub fn tape_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn bypass_governance_retention(mut self, inp: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(inp);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTapeArchive`.
    ///
    /// <p>Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is
    /// only supported in the tape gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTapeArchive<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tape_archive_input::Builder,
    }
    impl<C, M, R> DeleteTapeArchive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTapeArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTapeArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTapeArchiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTapeArchiveInputOperationOutputAlias,
                crate::output::DeleteTapeArchiveOutput,
                crate::error::DeleteTapeArchiveError,
                crate::input::DeleteTapeArchiveInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
        /// (VTS).</p>
        pub fn tape_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
        /// (VTS).</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn bypass_governance_retention(mut self, inp: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(inp);
            self
        }
        /// <p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with
        /// tape retention lock. Only archived tapes with tape retention lock set to
        /// <code>governance</code> can be deleted. Archived tapes with tape retention lock set to
        /// <code>compliance</code> can't be deleted.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTapePool`.
    ///
    /// <p>Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes
    /// in the pool and if there are no automatic tape creation policies that reference the custom
    /// tape pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTapePool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tape_pool_input::Builder,
    }
    impl<C, M, R> DeleteTapePool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTapePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTapePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTapePoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTapePoolInputOperationOutputAlias,
                crate::output::DeleteTapePoolOutput,
                crate::error::DeleteTapePoolError,
                crate::input::DeleteTapePoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
        pub fn pool_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVolume`.
    ///
    /// <p>Deletes the specified storage volume that you previously created using the <a>CreateCachediSCSIVolume</a> or <a>CreateStorediSCSIVolume</a> API.
    /// This operation is only supported in the cached volume and stored volume types. For stored
    /// volume gateways, the local disk that was configured as the storage volume is not deleted.
    /// You can reuse the local disk to create another storage volume.</p>
    ///
    /// <p>Before you delete a volume, make sure there are no iSCSI connections to the volume you
    /// are deleting. You should also make sure there is no snapshot in progress. You can use the
    /// Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are
    /// deleting and check the snapshot status. For more information, go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API
    /// Reference</i>.</p>
    ///
    /// <p>In the request, you must provide the Amazon Resource Name (ARN) of the storage volume
    /// you want to delete.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVolume<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_volume_input::Builder,
    }
    impl<C, M, R> DeleteVolume<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVolumeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVolumeInputOperationOutputAlias,
                crate::output::DeleteVolumeOutput,
                crate::error::DeleteVolumeError,
                crate::input::DeleteVolumeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAvailabilityMonitorTest`.
    ///
    /// <p>Returns information about the most recent high availability monitoring test that was
    /// performed on the host in a cluster. If a test isn't performed, the status and start
    /// time in the response would be null.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAvailabilityMonitorTest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_availability_monitor_test_input::Builder,
    }
    impl<C, M, R> DescribeAvailabilityMonitorTest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAvailabilityMonitorTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAvailabilityMonitorTestOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAvailabilityMonitorTestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAvailabilityMonitorTestInputOperationOutputAlias,
                crate::output::DescribeAvailabilityMonitorTestOutput,
                crate::error::DescribeAvailabilityMonitorTestError,
                crate::input::DescribeAvailabilityMonitorTestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBandwidthRateLimit`.
    ///
    /// <p>Returns the bandwidth rate limits of a gateway. By default, these limits are not set,
    /// which means no bandwidth rate limiting is in effect. This operation is supported for the
    /// stored volume, cached volume, and tape gateway types.</p>
    ///
    /// <p>This operation only returns a value for a bandwidth rate limit only if the limit is set.
    /// If no limits are set for the gateway, then this operation returns only the gateway ARN in
    /// the response body. To specify which gateway to describe, use the Amazon Resource Name (ARN)
    /// of the gateway in your request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBandwidthRateLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_bandwidth_rate_limit_input::Builder,
    }
    impl<C, M, R> DescribeBandwidthRateLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBandwidthRateLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBandwidthRateLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBandwidthRateLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBandwidthRateLimitInputOperationOutputAlias,
                crate::output::DescribeBandwidthRateLimitOutput,
                crate::error::DescribeBandwidthRateLimitError,
                crate::input::DescribeBandwidthRateLimitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBandwidthRateLimitSchedule`.
    ///
    /// <p> Returns information about the bandwidth rate limit schedule of a gateway. By default,
    /// gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting
    /// is in effect. This operation is supported only in the volume and tape gateway types. </p>
    ///
    /// <p>This operation returns information about a gateway's bandwidth rate limit schedule. A
    /// bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A
    /// bandwidth rate limit interval defines a period of time on one or more days of the week,
    /// during which bandwidth rate limits are specified for uploading, downloading, or both. </p>
    ///
    /// <p> A bandwidth rate limit interval consists of one or more days of the week, a start hour
    /// and minute, an ending hour and minute, and bandwidth rate limits for uploading and
    /// downloading </p>
    ///
    /// <p> If no bandwidth rate limit schedule intervals are set for the gateway, this operation
    /// returns an empty response. To specify which gateway to describe, use the Amazon Resource
    /// Name (ARN) of the gateway in your request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBandwidthRateLimitSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_bandwidth_rate_limit_schedule_input::Builder,
    }
    impl<C, M, R> DescribeBandwidthRateLimitSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBandwidthRateLimitSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBandwidthRateLimitScheduleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeBandwidthRateLimitScheduleError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBandwidthRateLimitScheduleInputOperationOutputAlias,
                crate::output::DescribeBandwidthRateLimitScheduleOutput,
                crate::error::DescribeBandwidthRateLimitScheduleError,
                crate::input::DescribeBandwidthRateLimitScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCache`.
    ///
    /// <p>Returns information about the cache of a gateway. This operation is only supported in
    /// the cached volume, tape, and file gateway types.</p>
    ///
    /// <p>The response includes disk IDs that are configured as cache, and it includes the amount
    /// of cache allocated and used.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cache_input::Builder,
    }
    impl<C, M, R> DescribeCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCacheInputOperationOutputAlias,
                crate::output::DescribeCacheOutput,
                crate::error::DescribeCacheError,
                crate::input::DescribeCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCachediSCSIVolumes`.
    ///
    /// <p>Returns a description of the gateway volumes specified in the request. This operation is
    /// only supported in the cached volume gateway types.</p>
    ///
    /// <p>The list of gateway volumes in the request must be from one gateway. In the response,
    /// Storage Gateway returns volume information sorted by volume Amazon Resource Name
    /// (ARN).</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCachediSCSIVolumes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cachedi_scsi_volumes_input::Builder,
    }
    impl<C, M, R> DescribeCachediSCSIVolumes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCachediSCSIVolumes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCachediScsiVolumesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCachediSCSIVolumesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCachediScsiVolumesInputOperationOutputAlias,
                crate::output::DescribeCachediScsiVolumesOutput,
                crate::error::DescribeCachediSCSIVolumesError,
                crate::input::DescribeCachediScsiVolumesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `VolumeARNs`.
        ///
        /// To override the contents of this collection use [`set_volume_ar_ns`](Self::set_volume_ar_ns).
        ///
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// cached volume. All of the specified cached volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn volume_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_ar_ns(inp);
            self
        }
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// cached volume. All of the specified cached volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn set_volume_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_volume_ar_ns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChapCredentials`.
    ///
    /// <p>Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials
    /// information for a specified iSCSI target, one for each target-initiator pair. This
    /// operation is supported in the volume and tape gateway types.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChapCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_chap_credentials_input::Builder,
    }
    impl<C, M, R> DescribeChapCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChapCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChapCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChapCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChapCredentialsInputOperationOutputAlias,
                crate::output::DescribeChapCredentialsOutput,
                crate::error::DescribeChapCredentialsError,
                crate::input::DescribeChapCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for
        /// specified VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystemAssociations`.
    ///
    /// <p>Gets the file system association information. This operation is only supported for FSx
    /// File Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFileSystemAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_file_system_associations_input::Builder,
    }
    impl<C, M, R> DescribeFileSystemAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFileSystemAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFileSystemAssociationsInputOperationOutputAlias,
                crate::output::DescribeFileSystemAssociationsOutput,
                crate::error::DescribeFileSystemAssociationsError,
                crate::input::DescribeFileSystemAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FileSystemAssociationARNList`.
        ///
        /// To override the contents of this collection use [`set_file_system_association_arn_list`](Self::set_file_system_association_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be
        /// described.</p>
        pub fn file_system_association_arn_list(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.file_system_association_arn_list(inp);
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file system association to be
        /// described.</p>
        pub fn set_file_system_association_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_association_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGatewayInformation`.
    ///
    /// <p>Returns metadata about a gateway such as its name, network interfaces, configured time
    /// zone, and the state (whether the gateway is running or not). To specify which gateway to
    /// describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGatewayInformation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_gateway_information_input::Builder,
    }
    impl<C, M, R> DescribeGatewayInformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGatewayInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGatewayInformationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGatewayInformationInputOperationOutputAlias,
                crate::output::DescribeGatewayInformationOutput,
                crate::error::DescribeGatewayInformationError,
                crate::input::DescribeGatewayInformationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceStartTime`.
    ///
    /// <p>Returns your gateway's weekly maintenance start time including the day and time of
    /// the week. Note that values are in terms of the gateway's time zone.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceStartTime<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_start_time_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceStartTime<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceStartTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceStartTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceStartTimeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceStartTimeInputOperationOutputAlias,
                crate::output::DescribeMaintenanceStartTimeOutput,
                crate::error::DescribeMaintenanceStartTimeError,
                crate::input::DescribeMaintenanceStartTimeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNFSFileShares`.
    ///
    /// <p>Gets a description for one or more Network File System (NFS) file shares from an S3 File
    /// Gateway. This operation is only supported for S3 File Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeNFSFileShares<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_nfs_file_shares_input::Builder,
    }
    impl<C, M, R> DescribeNFSFileShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNFSFileShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNfsFileSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNFSFileSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNfsFileSharesInputOperationOutputAlias,
                crate::output::DescribeNfsFileSharesOutput,
                crate::error::DescribeNFSFileSharesError,
                crate::input::DescribeNfsFileSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FileShareARNList`.
        ///
        /// To override the contents of this collection use [`set_file_share_arn_list`](Self::set_file_share_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn file_share_arn_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn_list(inp);
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn set_file_share_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSMBFileShares`.
    ///
    /// <p>Gets a description for one or more Server Message Block (SMB) file shares from a S3 File
    /// Gateway. This operation is only supported for S3 File Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSMBFileShares<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_smb_file_shares_input::Builder,
    }
    impl<C, M, R> DescribeSMBFileShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSMBFileShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSmbFileSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSMBFileSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSmbFileSharesInputOperationOutputAlias,
                crate::output::DescribeSmbFileSharesOutput,
                crate::error::DescribeSMBFileSharesError,
                crate::input::DescribeSmbFileSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FileShareARNList`.
        ///
        /// To override the contents of this collection use [`set_file_share_arn_list`](Self::set_file_share_arn_list).
        ///
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn file_share_arn_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn_list(inp);
            self
        }
        /// <p>An array containing the Amazon Resource Name (ARN) of each file share to be
        /// described.</p>
        pub fn set_file_share_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSMBSettings`.
    ///
    /// <p>Gets a description of a Server Message Block (SMB) file share settings from a file
    /// gateway. This operation is only supported for file gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSMBSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_smb_settings_input::Builder,
    }
    impl<C, M, R> DescribeSMBSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSMBSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSmbSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSMBSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSmbSettingsInputOperationOutputAlias,
                crate::output::DescribeSmbSettingsOutput,
                crate::error::DescribeSMBSettingsError,
                crate::input::DescribeSmbSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshotSchedule`.
    ///
    /// <p>Describes the snapshot schedule for the specified gateway volume. The snapshot schedule
    /// information includes intervals at which snapshots are automatically initiated on the
    /// volume. This operation is only supported in the cached volume and stored volume
    /// types.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSnapshotSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_snapshot_schedule_input::Builder,
    }
    impl<C, M, R> DescribeSnapshotSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSnapshotScheduleInputOperationOutputAlias,
                crate::output::DescribeSnapshotScheduleOutput,
                crate::error::DescribeSnapshotScheduleError,
                crate::input::DescribeSnapshotScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStorediSCSIVolumes`.
    ///
    /// <p>Returns the description of the gateway volumes specified in the request. The list of
    /// gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only
    /// supported in stored volume gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStorediSCSIVolumes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_storedi_scsi_volumes_input::Builder,
    }
    impl<C, M, R> DescribeStorediSCSIVolumes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStorediSCSIVolumes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStorediScsiVolumesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStorediSCSIVolumesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStorediScsiVolumesInputOperationOutputAlias,
                crate::output::DescribeStorediScsiVolumesOutput,
                crate::error::DescribeStorediSCSIVolumesError,
                crate::input::DescribeStorediScsiVolumesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `VolumeARNs`.
        ///
        /// To override the contents of this collection use [`set_volume_ar_ns`](Self::set_volume_ar_ns).
        ///
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// stored volume. All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn volume_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_ar_ns(inp);
            self
        }
        /// <p>An array of strings where each string represents the Amazon Resource Name (ARN) of a
        /// stored volume. All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>
        pub fn set_volume_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_volume_ar_ns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTapeArchives`.
    ///
    /// <p>Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This
    /// operation is only supported in the tape gateway type.</p>
    ///
    /// <p>If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a
    /// description of all virtual tapes found in the VTS associated with your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTapeArchives<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tape_archives_input::Builder,
    }
    impl<C, M, R> DescribeTapeArchives<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTapeArchives`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTapeArchivesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTapeArchivesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTapeArchivesInputOperationOutputAlias,
                crate::output::DescribeTapeArchivesOutput,
                crate::error::DescribeTapeArchivesError,
                crate::input::DescribeTapeArchivesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TapeARNs`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe.</p>
        pub fn tape_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_ar_ns(inp);
            self
        }
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tape_ar_ns(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing virtual
        /// tapes.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing virtual
        /// tapes.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTapeRecoveryPoints`.
    ///
    /// <p>Returns a list of virtual tape recovery points that are available for the specified tape
    /// gateway.</p>
    ///
    /// <p>A recovery point is a point-in-time view of a virtual tape at which all the data on the
    /// virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery
    /// points can be recovered to a new gateway. This operation is only supported in the tape
    /// gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTapeRecoveryPoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tape_recovery_points_input::Builder,
    }
    impl<C, M, R> DescribeTapeRecoveryPoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTapeRecoveryPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTapeRecoveryPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTapeRecoveryPointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTapeRecoveryPointsInputOperationOutputAlias,
                crate::output::DescribeTapeRecoveryPointsOutput,
                crate::error::DescribeTapeRecoveryPointsError,
                crate::input::DescribeTapeRecoveryPointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the virtual
        /// tape recovery points.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the virtual
        /// tape recovery points.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of virtual tape recovery points that are described be limited
        /// to the specified number.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies that the number of virtual tape recovery points that are described be limited
        /// to the specified number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTapes`.
    ///
    /// <p>Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a
    /// <code>TapeARN</code> is not specified, returns a description of all virtual tapes
    /// associated with the specified gateway. This operation is only supported in the tape gateway
    /// type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTapes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tapes_input::Builder,
    }
    impl<C, M, R> DescribeTapes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTapes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTapesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTapesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTapesInputOperationOutputAlias,
                crate::output::DescribeTapesOutput,
                crate::error::DescribeTapesError,
                crate::input::DescribeTapesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `TapeARNs`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe. If this parameter is not specified, Tape gateway returns a
        /// description of all virtual tapes associated with the specified gateway.</p>
        pub fn tape_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_ar_ns(inp);
            self
        }
        /// <p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
        /// tapes you want to describe. If this parameter is not specified, Tape gateway returns a
        /// description of all virtual tapes associated with the specified gateway.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tape_ar_ns(input);
            self
        }
        /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker
        /// indicates which page of results to retrieve.</p>
        ///
        /// <p>If not specified, the first page of results is retrieved.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker
        /// indicates which page of results to retrieve.</p>
        ///
        /// <p>If not specified, the first page of results is retrieved.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        ///
        /// <note>
        /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
        /// </note>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies that the number of virtual tapes described be limited to the specified
        /// number.</p>
        ///
        /// <note>
        /// <p>Amazon Web Services may impose its own limit, if this field is not set.</p>
        /// </note>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUploadBuffer`.
    ///
    /// <p>Returns information about the upload buffer of a gateway. This operation is supported
    /// for the stored volume, cached volume, and tape gateway types.</p>
    ///
    /// <p>The response includes disk IDs that are configured as upload buffer space, and it
    /// includes the amount of upload buffer space allocated and used.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUploadBuffer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_upload_buffer_input::Builder,
    }
    impl<C, M, R> DescribeUploadBuffer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUploadBuffer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUploadBufferOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUploadBufferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUploadBufferInputOperationOutputAlias,
                crate::output::DescribeUploadBufferOutput,
                crate::error::DescribeUploadBufferError,
                crate::input::DescribeUploadBufferInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVTLDevices`.
    ///
    /// <p>Returns a description of virtual tape library (VTL) devices for the specified tape
    /// gateway. In the response, Storage Gateway returns VTL device information.</p>
    ///
    /// <p>This operation is only supported in the tape gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVTLDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_vtl_devices_input::Builder,
    }
    impl<C, M, R> DescribeVTLDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVTLDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVtlDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVTLDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVtlDevicesInputOperationOutputAlias,
                crate::output::DescribeVtlDevicesOutput,
                crate::error::DescribeVTLDevicesError,
                crate::input::DescribeVtlDevicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `VTLDeviceARNs`.
        ///
        /// To override the contents of this collection use [`set_vtl_device_ar_ns`](Self::set_vtl_device_ar_ns).
        ///
        /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a
        /// VTL device.</p>
        ///
        /// <note>
        /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are
        /// specified, the result will contain all devices on the specified gateway.</p>
        /// </note>
        pub fn vtl_device_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vtl_device_ar_ns(inp);
            self
        }
        /// <p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a
        /// VTL device.</p>
        ///
        /// <note>
        /// <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are
        /// specified, the result will contain all devices on the specified gateway.</p>
        /// </note>
        pub fn set_vtl_device_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vtl_device_ar_ns(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the VTL
        /// devices.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin describing the VTL
        /// devices.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the number of VTL devices described be limited to the specified
        /// number.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies that the number of VTL devices described be limited to the specified
        /// number.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkingStorage`.
    ///
    /// <p>Returns information about the working storage of a gateway. This operation is only
    /// supported in the stored volumes gateway type. This operation is deprecated in cached
    /// volumes API version (20120630). Use DescribeUploadBuffer instead.</p>
    ///
    /// <note>
    /// <p>Working storage is also referred to as upload buffer. You can also use the
    /// DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.</p>
    /// </note>
    ///
    /// <p>The response includes disk IDs that are configured as working storage, and it includes
    /// the amount of working storage allocated and used.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeWorkingStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_working_storage_input::Builder,
    }
    impl<C, M, R> DescribeWorkingStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkingStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkingStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkingStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkingStorageInputOperationOutputAlias,
                crate::output::DescribeWorkingStorageOutput,
                crate::error::DescribeWorkingStorageError,
                crate::input::DescribeWorkingStorageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachVolume`.
    ///
    /// <p>Disconnects a volume from an iSCSI connection and then detaches the volume from the
    /// specified gateway. Detaching and attaching a volume enables you to recover your data from
    /// one gateway to a different gateway without creating a snapshot. It also makes it easier to
    /// move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2
    /// instance. This operation is only supported in the volume gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachVolume<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_volume_input::Builder,
    }
    impl<C, M, R> DetachVolume<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachVolumeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachVolumeInputOperationOutputAlias,
                crate::output::DetachVolumeOutput,
                crate::error::DetachVolumeError,
                crate::input::DetachVolumeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume
        /// and detach the volume. The default is <code>false</code>. If this value is set to
        /// <code>false</code>, you must manually disconnect the iSCSI connection from the target
        /// volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn force_detach(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_detach(inp);
            self
        }
        /// <p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume
        /// and detach the volume. The default is <code>false</code>. If this value is set to
        /// <code>false</code>, you must manually disconnect the iSCSI connection from the target
        /// volume.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_force_detach(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_detach(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableGateway`.
    ///
    /// <p>Disables a tape gateway when the gateway is no longer functioning. For example, if your
    /// gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.</p>
    ///
    /// <p>Use this operation for a tape gateway that is not reachable or not functioning. This
    /// operation is only supported in the tape gateway type.</p>
    ///
    /// <important>
    /// <p>After a gateway is disabled, it cannot be enabled.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DisableGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_gateway_input::Builder,
    }
    impl<C, M, R> DisableGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableGatewayInputOperationOutputAlias,
                crate::output::DisableGatewayOutput,
                crate::error::DisableGatewayError,
                crate::input::DisableGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFileSystem`.
    ///
    /// <p>Disassociates an Amazon FSx file system from the specified gateway. After the
    /// disassociation process finishes, the gateway can no longer access the Amazon FSx
    /// file system. This operation is only supported in the FSx File Gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateFileSystem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_file_system_input::Builder,
    }
    impl<C, M, R> DisassociateFileSystem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFileSystemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFileSystemInputOperationOutputAlias,
                crate::output::DisassociateFileSystemOutput,
                crate::error::DisassociateFileSystemError,
                crate::input::DisassociateFileSystemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
        pub fn file_system_association_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_association_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_association_arn(input);
            self
        }
        /// <p>If this value is set to true, the operation disassociates an Amazon FSx file
        /// system immediately. It ends all data uploads to the file system, and the file system
        /// association enters the <code>FORCE_DELETING</code> status. If this value is set to false,
        /// the Amazon FSx file system does not disassociate until all data is uploaded.</p>
        pub fn force_delete(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete(inp);
            self
        }
        /// <p>If this value is set to true, the operation disassociates an Amazon FSx file
        /// system immediately. It ends all data uploads to the file system, and the file system
        /// association enters the <code>FORCE_DELETING</code> status. If this value is set to false,
        /// the Amazon FSx file system does not disassociate until all data is uploaded.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `JoinDomain`.
    ///
    /// <p>Adds a file gateway to an Active Directory domain. This operation is only supported for
    /// file gateways that support the SMB file protocol.</p>
    #[derive(std::fmt::Debug)]
    pub struct JoinDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::join_domain_input::Builder,
    }
    impl<C, M, R> JoinDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `JoinDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::JoinDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::JoinDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::JoinDomainInputOperationOutputAlias,
                crate::output::JoinDomainOutput,
                crate::error::JoinDomainError,
                crate::input::JoinDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The name of the domain that you want the gateway to join.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want the gateway to join.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users,
        /// groups, computers, and other OUs and this parameter specifies the OU that the gateway will
        /// join within the AD domain.</p>
        pub fn organizational_unit(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit(inp);
            self
        }
        /// <p>The organizational unit (OU) is a container in an Active Directory that can hold users,
        /// groups, computers, and other OUs and this parameter specifies the OU that the gateway will
        /// join within the AD domain.</p>
        pub fn set_organizational_unit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit(input);
            self
        }
        /// Appends an item to `DomainControllers`.
        ///
        /// To override the contents of this collection use [`set_domain_controllers`](Self::set_domain_controllers).
        ///
        /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
        /// to specify the port number include it after the colon (“:”). For example,
        /// <code>mydc.mydomain.com:389</code>.</p>
        pub fn domain_controllers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_controllers(inp);
            self
        }
        /// <p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
        /// to specify the port number include it after the colon (“:”). For example,
        /// <code>mydc.mydomain.com:389</code>.</p>
        pub fn set_domain_controllers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_controllers(input);
            self
        }
        /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must
        /// complete. The default is 20 seconds.</p>
        pub fn timeout_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout_in_seconds(inp);
            self
        }
        /// <p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must
        /// complete. The default is 20 seconds.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_seconds(input);
            self
        }
        /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory
        /// domain. The domain user account should be enabled to join computers to the domain. For
        /// example, you can use the domain administrator account or an account with delegated
        /// permissions to join computers to the domain.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>Sets the user name of user who has permission to add the gateway to the Active Directory
        /// domain. The domain user account should be enabled to join computers to the domain. For
        /// example, you can use the domain administrator account or an account with delegated
        /// permissions to join computers to the domain.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Sets the password of the user who has permission to add the gateway to the Active
        /// Directory domain.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>Sets the password of the user who has permission to add the gateway to the Active
        /// Directory domain.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAutomaticTapeCreationPolicies`.
    ///
    /// <p>Lists the automatic tape creation policies for a gateway. If there are no automatic tape
    /// creation policies for the gateway, it returns an empty list.</p>
    ///
    /// <p>This operation is only supported for tape gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAutomaticTapeCreationPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_automatic_tape_creation_policies_input::Builder,
    }
    impl<C, M, R> ListAutomaticTapeCreationPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAutomaticTapeCreationPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAutomaticTapeCreationPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAutomaticTapeCreationPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAutomaticTapeCreationPoliciesInputOperationOutputAlias,
                crate::output::ListAutomaticTapeCreationPoliciesOutput,
                crate::error::ListAutomaticTapeCreationPoliciesError,
                crate::input::ListAutomaticTapeCreationPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFileShares`.
    ///
    /// <p>Gets a list of the file shares for a specific S3 File Gateway, or the list of file
    /// shares that belong to the calling user account. This operation is only supported for S3
    /// File Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFileShares<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_file_shares_input::Builder,
    }
    impl<C, M, R> ListFileShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFileShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFileSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFileSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFileSharesInputOperationOutputAlias,
                crate::output::ListFileSharesOutput,
                crate::error::ListFileSharesError,
                crate::input::ListFileSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
        /// this field is not present, all file shares under your account are listed.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
        /// this field is not present, all file shares under your account are listed.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The maximum number of file shares to return in the response. The value must be an
        /// integer with a value greater than zero. Optional.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of file shares to return in the response. The value must be an
        /// integer with a value greater than zero. Optional.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present,
        /// <code>Marker</code> specifies where to continue the list from after a previous call to
        /// ListFileShares. Optional.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Opaque pagination token returned from a previous ListFileShares operation. If present,
        /// <code>Marker</code> specifies where to continue the list from after a previous call to
        /// ListFileShares. Optional.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFileSystemAssociations`.
    ///
    /// <p>Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a
    /// summary of a file system association. This operation is only supported for FSx File
    /// Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFileSystemAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_file_system_associations_input::Builder,
    }
    impl<C, M, R> ListFileSystemAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFileSystemAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFileSystemAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFileSystemAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFileSystemAssociationsInputOperationOutputAlias,
                crate::output::ListFileSystemAssociationsOutput,
                crate::error::ListFileSystemAssociationsError,
                crate::input::ListFileSystemAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The maximum number of file system associations to return in the response. If present,
        /// <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of file system associations to return in the response. If present,
        /// <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code>
        /// operation. If present, <code>Marker</code> specifies where to continue the list from after
        /// a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code>
        /// operation. If present, <code>Marker</code> specifies where to continue the list from after
        /// a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGateways`.
    ///
    /// <p>Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region
    /// specified in the request. The returned list is ordered by gateway Amazon Resource Name
    /// (ARN).</p>
    ///
    /// <p>By default, the operation returns a maximum of 100 gateways. This operation supports
    /// pagination that allows you to optionally reduce the number of gateways returned in a
    /// response.</p>
    ///
    /// <p>If you have more gateways than are returned in a response (that is, the response returns
    /// only a truncated list of your gateways), the response contains a marker that you can
    /// specify in your next request to fetch the next page of gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_gateways_input::Builder,
    }
    impl<C, M, R> ListGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGatewaysInputOperationOutputAlias,
                crate::output::ListGatewaysOutput,
                crate::error::ListGatewaysError,
                crate::input::ListGatewaysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An opaque string that indicates the position at which to begin the returned list of
        /// gateways.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the returned list of
        /// gateways.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the list of gateways returned be limited to the specified number of
        /// items.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies that the list of gateways returned be limited to the specified number of
        /// items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLocalDisks`.
    ///
    /// <p>Returns a list of the gateway's local disks. To specify which gateway to describe,
    /// you use the Amazon Resource Name (ARN) of the gateway in the body of the request.</p>
    ///
    /// <p>The request returns a list of all disks, specifying which are configured as working
    /// storage, cache storage, or stored volume or not configured at all. The response includes a
    /// <code>DiskStatus</code> field. This field can have a value of present (the disk is
    /// available to use), missing (the disk is no longer connected to the gateway), or mismatch
    /// (the disk node is occupied by a disk that has incorrect metadata or the disk content is
    /// corrupted).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLocalDisks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_local_disks_input::Builder,
    }
    impl<C, M, R> ListLocalDisks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLocalDisks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLocalDisksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLocalDisksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLocalDisksInputOperationOutputAlias,
                crate::output::ListLocalDisksOutput,
                crate::error::ListLocalDisksError,
                crate::input::ListLocalDisksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that have been added to the specified resource. This operation is
    /// supported in storage gateways of all types.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the list of
        /// tags.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the list of
        /// tags.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the list of tags returned be limited to the specified number of
        /// items.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies that the list of tags returned be limited to the specified number of
        /// items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTapePools`.
    ///
    /// <p>Lists custom tape pools. You specify custom tape pools to list by specifying one or more
    /// custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN,
    /// the operation lists all custom tape pools.</p>
    ///
    /// <p>This operation supports pagination. You can optionally specify the <code>Limit</code>
    /// parameter in the body to limit the number of tape pools in the response. If the number of
    /// tape pools returned in the response is truncated, the response includes a
    /// <code>Marker</code> element that you can use in your subsequent request to retrieve the
    /// next set of tape pools.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTapePools<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tape_pools_input::Builder,
    }
    impl<C, M, R> ListTapePools<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTapePools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTapePoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTapePoolsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTapePoolsInputOperationOutputAlias,
                crate::output::ListTapePoolsOutput,
                crate::error::ListTapePoolsError,
                crate::input::ListTapePoolsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `PoolARNs`.
        ///
        /// To override the contents of this collection use [`set_pool_ar_ns`](Self::set_pool_ar_ns).
        ///
        /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you
        /// don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
        pub fn pool_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_ar_ns(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you
        /// don't specify a custom tape pool ARN, the response lists all custom tape pools. </p>
        pub fn set_pool_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pool_ar_ns(input);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape
        /// pools.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of tape
        /// pools.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>An optional number limit for the tape pools in the list returned by this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTapes`.
    ///
    /// <p>Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf
    /// (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names
    /// (ARNs). If you don't specify a tape ARN, the operation lists all virtual tapes in both
    /// your VTL and VTS.</p>
    ///
    /// <p>This operation supports pagination. By default, the operation returns a maximum of up to
    /// 100 tapes. You can optionally specify the <code>Limit</code> parameter in the body to limit
    /// the number of tapes in the response. If the number of tapes returned in the response is
    /// truncated, the response includes a <code>Marker</code> element that you can use in your
    /// subsequent request to retrieve the next set of tapes. This operation is only supported in
    /// the tape gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTapes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tapes_input::Builder,
    }
    impl<C, M, R> ListTapes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTapes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTapesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTapesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTapesInputOperationOutputAlias,
                crate::output::ListTapesOutput,
                crate::error::ListTapesError,
                crate::input::ListTapesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TapeARNs`.
        ///
        /// To override the contents of this collection use [`set_tape_ar_ns`](Self::set_tape_ar_ns).
        ///
        /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't
        /// specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
        pub fn tape_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_ar_ns(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't
        /// specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>
        pub fn set_tape_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tape_ar_ns(input);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of
        /// tapes.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of
        /// tapes.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>An optional number limit for the tapes in the list returned by this call.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>An optional number limit for the tapes in the list returned by this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVolumeInitiators`.
    ///
    /// <p>Lists iSCSI initiators that are connected to a volume. You can use this operation to
    /// determine whether a volume is being used or not. This operation is only supported in the
    /// cached volume and stored volume gateway types.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVolumeInitiators<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_volume_initiators_input::Builder,
    }
    impl<C, M, R> ListVolumeInitiators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVolumeInitiators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVolumeInitiatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVolumeInitiatorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVolumeInitiatorsInputOperationOutputAlias,
                crate::output::ListVolumeInitiatorsOutput,
                crate::error::ListVolumeInitiatorsError,
                crate::input::ListVolumeInitiatorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes for the gateway.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes for the gateway.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVolumeRecoveryPoints`.
    ///
    /// <p>Lists the recovery points for a specified gateway. This operation is only supported in
    /// the cached volume gateway type.</p>
    ///
    /// <p>Each cache volume has one recovery point. A volume recovery point is a point in time at
    /// which all data of the volume is consistent and from which you can create a snapshot or
    /// clone a new cached volume from a source volume. To create a snapshot from a volume recovery
    /// point use the <a>CreateSnapshotFromVolumeRecoveryPoint</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVolumeRecoveryPoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_volume_recovery_points_input::Builder,
    }
    impl<C, M, R> ListVolumeRecoveryPoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVolumeRecoveryPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVolumeRecoveryPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVolumeRecoveryPointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVolumeRecoveryPointsInputOperationOutputAlias,
                crate::output::ListVolumeRecoveryPointsOutput,
                crate::error::ListVolumeRecoveryPointsError,
                crate::input::ListVolumeRecoveryPointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVolumes`.
    ///
    /// <p>Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The
    /// response includes only the volume ARNs. If you want additional volume information, use the
    /// <a>DescribeStorediSCSIVolumes</a> or the <a>DescribeCachediSCSIVolumes</a> API.</p>
    ///
    /// <p>The operation supports pagination. By default, the operation returns a maximum of up to
    /// 100 volumes. You can optionally specify the <code>Limit</code> field in the body to limit
    /// the number of volumes in the response. If the number of volumes returned in the response is
    /// truncated, the response includes a Marker field. You can use this Marker value in your
    /// subsequent request to retrieve the next set of volumes. This operation is only supported in
    /// the cached volume and stored volume gateway types.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVolumes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_volumes_input::Builder,
    }
    impl<C, M, R> ListVolumes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVolumes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVolumesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVolumesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVolumesInputOperationOutputAlias,
                crate::output::ListVolumesOutput,
                crate::error::ListVolumesError,
                crate::input::ListVolumesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of volumes.
        /// Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A string that indicates the position at which to begin the returned list of volumes.
        /// Obtain the marker from the response of a previous List iSCSI Volumes request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies that the list of volumes returned be limited to the specified number of
        /// items.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies that the list of volumes returned be limited to the specified number of
        /// items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyWhenUploaded`.
    ///
    /// <p>Sends you notification through CloudWatch Events when all files written to your file
    /// share have been uploaded to Amazon S3.</p>
    ///
    /// <p>Storage Gateway can send a notification through Amazon CloudWatch Events when all
    /// files written to your file share up to that point in time have been uploaded to Amazon S3. These files include files written to the file share up to the time that you
    /// make a request for notification. When the upload is done, Storage Gateway sends you
    /// notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to
    /// send the notification through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File Gateways.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification">Getting file upload notification</a> in the <i>Storage Gateway User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct NotifyWhenUploaded<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::notify_when_uploaded_input::Builder,
    }
    impl<C, M, R> NotifyWhenUploaded<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `NotifyWhenUploaded`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyWhenUploadedOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyWhenUploadedError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::NotifyWhenUploadedInputOperationOutputAlias,
                crate::output::NotifyWhenUploadedOutput,
                crate::error::NotifyWhenUploadedError,
                crate::input::NotifyWhenUploadedInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn file_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshCache`.
    ///
    /// <p>Refreshes the cached inventory of objects for the specified file share. This operation
    /// finds objects in the Amazon S3 bucket that were added, removed, or replaced since
    /// the gateway last listed the bucket's contents and cached the results. This operation
    /// does not import files into the S3 File Gateway cache storage. It only updates the cached
    /// inventory to reflect changes in the inventory of the objects in the S3 bucket. This
    /// operation is only supported in the S3 File Gateway types.</p>
    /// <p>You can subscribe to be notified through an Amazon CloudWatch event when your
    /// <code>RefreshCache</code> operation completes. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway
    /// User Guide</i>. This operation is Only supported for S3 File Gateways.</p>
    ///
    /// <p>When this API is called, it only initiates the refresh operation. When the API call
    /// completes and returns a success code, it doesn't necessarily mean that the file
    /// refresh has completed. You should use the refresh-complete notification to determine that
    /// the operation has completed before you check for new files on the gateway file share. You
    /// can subscribe to be notified through a CloudWatch event when your <code>RefreshCache</code>
    /// operation completes.</p>
    ///
    /// <p>Throttle limit: This API is asynchronous, so the gateway will accept no more than two
    /// refreshes at any time. We recommend using the refresh-complete CloudWatch event
    /// notification before issuing additional requests. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway
    /// User Guide</i>.</p>
    ///
    /// <p>If you invoke the RefreshCache API when two requests are already being processed, any
    /// new request will cause an <code>InvalidGatewayRequestException</code> error because too
    /// many requests were sent to the server.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway
    /// User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RefreshCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::refresh_cache_input::Builder,
    }
    impl<C, M, R> RefreshCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RefreshCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RefreshCacheInputOperationOutputAlias,
                crate::output::RefreshCacheOutput,
                crate::error::RefreshCacheError,
                crate::input::RefreshCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
        pub fn file_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// Appends an item to `FolderList`.
        ///
        /// To override the contents of this collection use [`set_folder_list`](Self::set_folder_list).
        ///
        /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is
        /// [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3
        /// bucket that the file share has access to is refreshed.</p>
        pub fn folder_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_list(inp);
            self
        }
        /// <p>A comma-separated list of the paths of folders to refresh in the cache. The default is
        /// [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3
        /// bucket that the file share has access to is refreshed.</p>
        pub fn set_folder_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_folder_list(input);
            self
        }
        /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh
        /// includes folders that were in the cache the last time the gateway listed the folder's
        /// contents. If this value set to <code>true</code>, each folder that is listed in
        /// <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in
        /// <code>FolderList</code> are not refreshed. Only objects that are in folders listed
        /// directly under <code>FolderList</code> are found and used for the update. The default is
        /// <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn recursive(mut self, inp: bool) -> Self {
            self.inner = self.inner.recursive(inp);
            self
        }
        /// <p>A value that specifies whether to recursively refresh folders in the cache. The refresh
        /// includes folders that were in the cache the last time the gateway listed the folder's
        /// contents. If this value set to <code>true</code>, each folder that is listed in
        /// <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in
        /// <code>FolderList</code> are not refreshed. Only objects that are in folders listed
        /// directly under <code>FolderList</code> are found and used for the update. The default is
        /// <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes one or more tags from the specified resource. This operation is supported in
    /// storage gateways of all types.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed
        /// of a key-value pair.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the tags you want to remove from the specified resource. A tag is composed
        /// of a key-value pair.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetCache`.
    ///
    /// <p>Resets all cache disks that have encountered an error and makes the disks available for
    /// reconfiguration as cache storage. If your cache disk encounters an error, the gateway
    /// prevents read and write operations on virtual tapes in the gateway. For example, an error
    /// can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the
    /// gateway loses its cache storage. At this point, you can reconfigure the disks as cache
    /// disks. This operation is only supported in the cached volume and tape types.</p>
    ///
    /// <important>
    /// <p>If the cache disk you are resetting contains data that has not been uploaded to
    /// Amazon S3 yet, that data can be lost. After you reset cache disks, there will
    /// be no configured cache disks left in the gateway, so you must configure at least one new
    /// cache disk for your gateway to function properly.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct ResetCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_cache_input::Builder,
    }
    impl<C, M, R> ResetCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetCacheInputOperationOutputAlias,
                crate::output::ResetCacheOutput,
                crate::error::ResetCacheError,
                crate::input::ResetCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveTapeArchive`.
    ///
    /// <p>Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway.
    /// Virtual tapes archived in the VTS are not associated with any gateway. However after a tape
    /// is retrieved, it is associated with a gateway, even though it is also listed in the VTS,
    /// that is, archive. This operation is only supported in the tape gateway type.</p>
    ///
    /// <p>Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to
    /// another gateway. You must archive the tape again before you can retrieve it to another
    /// gateway. This operation is only supported in the tape gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct RetrieveTapeArchive<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retrieve_tape_archive_input::Builder,
    }
    impl<C, M, R> RetrieveTapeArchive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetrieveTapeArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveTapeArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveTapeArchiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetrieveTapeArchiveInputOperationOutputAlias,
                crate::output::RetrieveTapeArchiveOutput,
                crate::error::RetrieveTapeArchiveError,
                crate::input::RetrieveTapeArchiveInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual
        /// tape shelf (VTS).</p>
        pub fn tape_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual
        /// tape shelf (VTS).</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to.
        /// Use the <a>ListGateways</a> operation to return a list of gateways for your
        /// account and Amazon Web Services Region.</p>
        ///
        /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape
        /// gateway.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to.
        /// Use the <a>ListGateways</a> operation to return a list of gateways for your
        /// account and Amazon Web Services Region.</p>
        ///
        /// <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape
        /// gateway.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveTapeRecoveryPoint`.
    ///
    /// <p>Retrieves the recovery point for the specified virtual tape. This operation is only
    /// supported in the tape gateway type.</p>
    ///
    /// <p>A recovery point is a point in time view of a virtual tape at which all the data on the
    /// tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be
    /// recovered to a new gateway.</p>
    ///
    /// <note>
    /// <p>The virtual tape can be retrieved to only one gateway. The retrieved tape is
    /// read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge
    /// for retrieving recovery points.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RetrieveTapeRecoveryPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retrieve_tape_recovery_point_input::Builder,
    }
    impl<C, M, R> RetrieveTapeRecoveryPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetrieveTapeRecoveryPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveTapeRecoveryPointOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveTapeRecoveryPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetrieveTapeRecoveryPointInputOperationOutputAlias,
                crate::output::RetrieveTapeRecoveryPointOutput,
                crate::error::RetrieveTapeRecoveryPointError,
                crate::input::RetrieveTapeRecoveryPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the
        /// recovery point.</p>
        pub fn tape_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tape_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the
        /// recovery point.</p>
        pub fn set_tape_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tape_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetLocalConsolePassword`.
    ///
    /// <p>Sets the password for your VM local console. When you log in to the local console for
    /// the first time, you log in to the VM with the default credentials. We recommend that you
    /// set a new password. You don't need to know the default password to set a new
    /// password.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetLocalConsolePassword<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_local_console_password_input::Builder,
    }
    impl<C, M, R> SetLocalConsolePassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetLocalConsolePassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetLocalConsolePasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::SetLocalConsolePasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetLocalConsolePasswordInputOperationOutputAlias,
                crate::output::SetLocalConsolePasswordOutput,
                crate::error::SetLocalConsolePasswordError,
                crate::input::SetLocalConsolePasswordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The password you want to set for your VM local console.</p>
        pub fn local_console_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.local_console_password(inp);
            self
        }
        /// <p>The password you want to set for your VM local console.</p>
        pub fn set_local_console_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_local_console_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetSMBGuestPassword`.
    ///
    /// <p>Sets the password for the guest user <code>smbguest</code>. The <code>smbguest</code>
    /// user is the user when the authentication method for the file share is set to
    /// <code>GuestAccess</code>. This operation only supported for S3 File Gateways</p>
    #[derive(std::fmt::Debug)]
    pub struct SetSMBGuestPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_smb_guest_password_input::Builder,
    }
    impl<C, M, R> SetSMBGuestPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetSMBGuestPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetSmbGuestPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::SetSMBGuestPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetSmbGuestPasswordInputOperationOutputAlias,
                crate::output::SetSmbGuestPasswordOutput,
                crate::error::SetSMBGuestPasswordError,
                crate::input::SetSmbGuestPasswordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated
        /// with.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated
        /// with.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The password that you want to set for your SMB server.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password that you want to set for your SMB server.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ShutdownGateway`.
    ///
    /// <p>Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource
    /// Name (ARN) of the gateway in the body of your request.</p>
    ///
    /// <p>The operation shuts down the gateway service component running in the gateway's
    /// virtual machine (VM) and not the host VM.</p>
    ///
    /// <note>
    /// <p>If you want to shut down the VM, it is recommended that you first shut down the
    /// gateway component in the VM to avoid unpredictable conditions.</p>
    /// </note>
    ///
    /// <p>After the gateway is shutdown, you cannot call any other API except <a>StartGateway</a>, <a>DescribeGatewayInformation</a>, and <a>ListGateways</a>. For more information, see <a>ActivateGateway</a>.
    /// Your applications cannot read from or write to the gateway's storage volumes, and
    /// there are no snapshots taken.</p>
    ///
    /// <note>
    /// <p>When you make a shutdown request, you will get a <code>200 OK</code> success response
    /// immediately. However, it might take some time for the gateway to shut down. You can call
    /// the <a>DescribeGatewayInformation</a> API to check the status. For more
    /// information, see <a>ActivateGateway</a>.</p>
    /// </note>
    ///
    /// <p>If do not intend to use the gateway again, you must delete the gateway (using <a>DeleteGateway</a>) to no longer pay software charges associated with the
    /// gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct ShutdownGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::shutdown_gateway_input::Builder,
    }
    impl<C, M, R> ShutdownGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ShutdownGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ShutdownGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::ShutdownGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ShutdownGatewayInputOperationOutputAlias,
                crate::output::ShutdownGatewayOutput,
                crate::error::ShutdownGatewayError,
                crate::input::ShutdownGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAvailabilityMonitorTest`.
    ///
    /// <p>Start a test that verifies that the specified gateway is configured for High
    /// Availability monitoring in your host environment. This request only initiates the test and
    /// that a successful response only indicates that the test was started. It doesn't
    /// indicate that the test passed. For the status of the test, invoke the
    /// <code>DescribeAvailabilityMonitorTest</code> API.</p>
    /// <note>
    /// <p>Starting this test will cause your gateway to go offline for a brief period.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct StartAvailabilityMonitorTest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_availability_monitor_test_input::Builder,
    }
    impl<C, M, R> StartAvailabilityMonitorTest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAvailabilityMonitorTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAvailabilityMonitorTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAvailabilityMonitorTestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAvailabilityMonitorTestInputOperationOutputAlias,
                crate::output::StartAvailabilityMonitorTestOutput,
                crate::error::StartAvailabilityMonitorTestError,
                crate::input::StartAvailabilityMonitorTestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartGateway`.
    ///
    /// <p>Starts a gateway that you previously shut down (see <a>ShutdownGateway</a>).
    /// After the gateway starts, you can then make other API calls, your applications can read
    /// from or write to the gateway's storage volumes and you will be able to take snapshot
    /// backups.</p>
    ///
    /// <note>
    /// <p>When you make a request, you will get a 200 OK success response immediately. However,
    /// it might take some time for the gateway to be ready. You should call <a>DescribeGatewayInformation</a> and check the status before making any
    /// additional API calls. For more information, see <a>ActivateGateway</a>.</p>
    /// </note>
    ///
    /// <p>To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in
    /// your request.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_gateway_input::Builder,
    }
    impl<C, M, R> StartGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::StartGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartGatewayInputOperationOutputAlias,
                crate::output::StartGatewayOutput,
                crate::error::StartGatewayError,
                crate::input::StartGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAutomaticTapeCreationPolicy`.
    ///
    /// <p>Updates the automatic tape creation policy of a gateway. Use this to update the policy
    /// with a new set of automatic tape creation rules. This is only supported for tape
    /// gateways.</p>
    ///
    /// <p>By default, there is no automatic tape creation policy.</p>
    ///
    /// <note>
    /// <p>A gateway can have only one automatic tape creation policy.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAutomaticTapeCreationPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_automatic_tape_creation_policy_input::Builder,
    }
    impl<C, M, R> UpdateAutomaticTapeCreationPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAutomaticTapeCreationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAutomaticTapeCreationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAutomaticTapeCreationPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAutomaticTapeCreationPolicyInputOperationOutputAlias,
                crate::output::UpdateAutomaticTapeCreationPolicyOutput,
                crate::error::UpdateAutomaticTapeCreationPolicyError,
                crate::input::UpdateAutomaticTapeCreationPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AutomaticTapeCreationRules`.
        ///
        /// To override the contents of this collection use [`set_automatic_tape_creation_rules`](Self::set_automatic_tape_creation_rules).
        ///
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
        /// The rules determine when and how to automatically create new tapes.</p>
        pub fn automatic_tape_creation_rules(
            mut self,
            inp: impl Into<crate::model::AutomaticTapeCreationRule>,
        ) -> Self {
            self.inner = self.inner.automatic_tape_creation_rules(inp);
            self
        }
        /// <p>An automatic tape creation policy consists of a list of automatic tape creation rules.
        /// The rules determine when and how to automatically create new tapes.</p>
        pub fn set_automatic_tape_creation_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomaticTapeCreationRule>>,
        ) -> Self {
            self.inner = self.inner.set_automatic_tape_creation_rules(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBandwidthRateLimit`.
    ///
    /// <p>Updates the bandwidth rate limits of a gateway. You can update both the upload and
    /// download bandwidth rate limit or specify only one of the two. If you don't set a
    /// bandwidth rate limit, the existing rate limit remains. This operation is supported for the
    /// stored volume, cached volume, and tape gateway types.</p>
    ///
    /// <p>By default, a gateway's bandwidth rate limits are not set. If you don't set
    /// any limit, the gateway does not have any limitations on its bandwidth usage and could
    /// potentially use the maximum available bandwidth.</p>
    ///
    /// <p>To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in
    /// your request.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBandwidthRateLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bandwidth_rate_limit_input::Builder,
    }
    impl<C, M, R> UpdateBandwidthRateLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBandwidthRateLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBandwidthRateLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBandwidthRateLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBandwidthRateLimitInputOperationOutputAlias,
                crate::output::UpdateBandwidthRateLimitOutput,
                crate::error::UpdateBandwidthRateLimitError,
                crate::input::UpdateBandwidthRateLimitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second.</p>
        pub fn average_upload_rate_limit_in_bits_per_sec(mut self, inp: i64) -> Self {
            self.inner = self.inner.average_upload_rate_limit_in_bits_per_sec(inp);
            self
        }
        /// <p>The average upload bandwidth rate limit in bits per second.</p>
        pub fn set_average_upload_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self
                .inner
                .set_average_upload_rate_limit_in_bits_per_sec(input);
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second.</p>
        pub fn average_download_rate_limit_in_bits_per_sec(mut self, inp: i64) -> Self {
            self.inner = self.inner.average_download_rate_limit_in_bits_per_sec(inp);
            self
        }
        /// <p>The average download bandwidth rate limit in bits per second.</p>
        pub fn set_average_download_rate_limit_in_bits_per_sec(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self
                .inner
                .set_average_download_rate_limit_in_bits_per_sec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBandwidthRateLimitSchedule`.
    ///
    /// <p> Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways
    /// do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in
    /// effect. Use this to initiate or update a gateway's bandwidth rate limit schedule. This
    /// operation is supported in the volume and tape gateway types. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBandwidthRateLimitSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bandwidth_rate_limit_schedule_input::Builder,
    }
    impl<C, M, R> UpdateBandwidthRateLimitSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBandwidthRateLimitSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBandwidthRateLimitScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBandwidthRateLimitScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBandwidthRateLimitScheduleInputOperationOutputAlias,
                crate::output::UpdateBandwidthRateLimitScheduleOutput,
                crate::error::UpdateBandwidthRateLimitScheduleError,
                crate::input::UpdateBandwidthRateLimitScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// Appends an item to `BandwidthRateLimitIntervals`.
        ///
        /// To override the contents of this collection use [`set_bandwidth_rate_limit_intervals`](Self::set_bandwidth_rate_limit_intervals).
        ///
        /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no
        /// bandwidth rate limit intervals have been scheduled, the array is empty. </p>
        pub fn bandwidth_rate_limit_intervals(
            mut self,
            inp: impl Into<crate::model::BandwidthRateLimitInterval>,
        ) -> Self {
            self.inner = self.inner.bandwidth_rate_limit_intervals(inp);
            self
        }
        /// <p> An array containing bandwidth rate limit schedule intervals for a gateway. When no
        /// bandwidth rate limit intervals have been scheduled, the array is empty. </p>
        pub fn set_bandwidth_rate_limit_intervals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BandwidthRateLimitInterval>>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth_rate_limit_intervals(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChapCredentials`.
    ///
    /// <p>Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a
    /// specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for
    /// added security, you might use it. This operation is supported in the volume and tape
    /// gateway types.</p>
    ///
    /// <important>
    /// <p>When you update CHAP credentials, all existing connections on the target are closed
    /// and initiators must reconnect with the new credentials.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChapCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_chap_credentials_input::Builder,
    }
    impl<C, M, R> UpdateChapCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChapCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChapCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChapCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChapCredentialsInputOperationOutputAlias,
                crate::output::UpdateChapCredentialsOutput,
                crate::error::UpdateChapCredentialsError,
                crate::input::UpdateChapCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified
        /// VolumeARN.</p>
        pub fn target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified
        /// VolumeARN.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to
        /// participate in mutual CHAP with the target.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn secret_to_authenticate_initiator(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.secret_to_authenticate_initiator(inp);
            self
        }
        /// <p>The secret key that the initiator (for example, the Windows client) must provide to
        /// participate in mutual CHAP with the target.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn set_secret_to_authenticate_initiator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_to_authenticate_initiator(input);
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn initiator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initiator_name(inp);
            self
        }
        /// <p>The iSCSI initiator that connects to the target.</p>
        pub fn set_initiator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initiator_name(input);
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the
        /// initiator (e.g. Windows client).</p>
        ///
        /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn secret_to_authenticate_target(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.secret_to_authenticate_target(inp);
            self
        }
        /// <p>The secret key that the target must provide to participate in mutual CHAP with the
        /// initiator (e.g. Windows client).</p>
        ///
        /// <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p>
        ///
        /// <note>
        /// <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p>
        /// </note>
        pub fn set_secret_to_authenticate_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_to_authenticate_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFileSystemAssociation`.
    ///
    /// <p>Updates a file system association. This operation is only supported in the FSx File
    /// Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFileSystemAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_file_system_association_input::Builder,
    }
    impl<C, M, R> UpdateFileSystemAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFileSystemAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFileSystemAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFileSystemAssociationInputOperationOutputAlias,
                crate::output::UpdateFileSystemAssociationOutput,
                crate::error::UpdateFileSystemAssociationError,
                crate::input::UpdateFileSystemAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association that you want to
        /// update.</p>
        pub fn file_system_association_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_association_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file system association that you want to
        /// update.</p>
        pub fn set_file_system_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_association_arn(input);
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The user name of the user credential that has permission to access the root share D$ of
        /// the Amazon FSx file system. The user account must belong to the Amazon FSx
        /// delegated admin user group.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of the user credential.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn audit_destination_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn cache_attributes(mut self, inp: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(inp);
            self
        }
        /// <p>The refresh cache information for the file share or FSx file systems.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayInformation`.
    ///
    /// <p>Updates a gateway's metadata, which includes the gateway's name and time zone.
    /// To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in
    /// your request.</p>
    ///
    /// <note>
    /// <p>For gateways activated after September 2, 2015, the gateway's ARN contains the
    /// gateway ID rather than the gateway name. However, changing the name of the gateway has
    /// no effect on the gateway's ARN.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGatewayInformation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_information_input::Builder,
    }
    impl<C, M, R> UpdateGatewayInformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGatewayInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayInformationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayInformationInputOperationOutputAlias,
                crate::output::UpdateGatewayInformationOutput,
                crate::error::UpdateGatewayInformationError,
                crate::input::UpdateGatewayInformationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(inp);
            self
        }
        /// <p>The name you configured for your gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn gateway_timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_timezone(inp);
            self
        }
        /// <p>A value that indicates the time zone of the gateway.</p>
        pub fn set_gateway_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_timezone(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
        /// to monitor and log events in the gateway.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
        /// Logs?</a>
        /// </p>
        pub fn cloud_watch_log_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_log_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
        /// to monitor and log events in the gateway.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
        /// Logs?</a>
        /// </p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_log_group_arn(input);
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn gateway_capacity(mut self, inp: crate::model::GatewayCapacity) -> Self {
            self.inner = self.inner.gateway_capacity(inp);
            self
        }
        /// <p>Specifies the size of the gateway's metadata cache.</p>
        pub fn set_gateway_capacity(
            mut self,
            input: std::option::Option<crate::model::GatewayCapacity>,
        ) -> Self {
            self.inner = self.inner.set_gateway_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewaySoftwareNow`.
    ///
    /// <p>Updates the gateway virtual machine (VM) software. The request immediately triggers the
    /// software update.</p>
    ///
    /// <note>
    /// <p>When you make this request, you get a <code>200 OK</code> success response
    /// immediately. However, it might take some time for the update to complete. You can call
    /// <a>DescribeGatewayInformation</a> to verify the gateway is in the
    /// <code>STATE_RUNNING</code> state.</p>
    /// </note>
    ///
    /// <important>
    /// <p>A software update forces a system restart of your gateway. You can minimize the
    /// chance of any disruption to your applications by increasing your iSCSI Initiators'
    /// timeouts. For more information about increasing iSCSI Initiator timeouts for Windows and
    /// Linux, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings">Customizing your Windows iSCSI settings</a> and <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings">Customizing your Linux iSCSI settings</a>, respectively.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGatewaySoftwareNow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_software_now_input::Builder,
    }
    impl<C, M, R> UpdateGatewaySoftwareNow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGatewaySoftwareNow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewaySoftwareNowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewaySoftwareNowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewaySoftwareNowInputOperationOutputAlias,
                crate::output::UpdateGatewaySoftwareNowOutput,
                crate::error::UpdateGatewaySoftwareNowError,
                crate::input::UpdateGatewaySoftwareNowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMaintenanceStartTime`.
    ///
    /// <p>Updates a gateway's weekly maintenance start time information, including day and
    /// time of the week. The maintenance time is the time in your gateway's time zone.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMaintenanceStartTime<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_maintenance_start_time_input::Builder,
    }
    impl<C, M, R> UpdateMaintenanceStartTime<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMaintenanceStartTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMaintenanceStartTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceStartTimeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMaintenanceStartTimeInputOperationOutputAlias,
                crate::output::UpdateMaintenanceStartTimeOutput,
                crate::error::UpdateMaintenanceStartTimeError,
                crate::input::UpdateMaintenanceStartTimeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>,
        /// where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time
        /// zone of the gateway.</p>
        pub fn hour_of_day(mut self, inp: i32) -> Self {
            self.inner = self.inner.hour_of_day(inp);
            self
        }
        /// <p>The hour component of the maintenance start time represented as <i>hh</i>,
        /// where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time
        /// zone of the gateway.</p>
        pub fn set_hour_of_day(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_hour_of_day(input);
            self
        }
        /// <p>The minute component of the maintenance start time represented as
        /// <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The
        /// minute of the hour is in the time zone of the gateway.</p>
        pub fn minute_of_hour(mut self, inp: i32) -> Self {
            self.inner = self.inner.minute_of_hour(inp);
            self
        }
        /// <p>The minute component of the maintenance start time represented as
        /// <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The
        /// minute of the hour is in the time zone of the gateway.</p>
        pub fn set_minute_of_hour(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minute_of_hour(input);
            self
        }
        /// <p>The day of the week component of the maintenance start time week represented as an
        /// ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
        pub fn day_of_week(mut self, inp: i32) -> Self {
            self.inner = self.inner.day_of_week(inp);
            self
        }
        /// <p>The day of the week component of the maintenance start time week represented as an
        /// ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>
        pub fn set_day_of_week(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_day_of_week(input);
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal
        /// number from 1 to 28, where 1 represents the first day of the month and 28 represents the
        /// last day of the month.</p>
        pub fn day_of_month(mut self, inp: i32) -> Self {
            self.inner = self.inner.day_of_month(inp);
            self
        }
        /// <p>The day of the month component of the maintenance start time represented as an ordinal
        /// number from 1 to 28, where 1 represents the first day of the month and 28 represents the
        /// last day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_day_of_month(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNFSFileShare`.
    ///
    /// <p>Updates a Network File System (NFS) file share. This operation is only supported in S3
    /// File Gateways.</p>
    ///
    /// <note>
    /// <p>To leave a file share field unchanged, set the corresponding input field to
    /// null.</p>
    /// </note>
    ///
    /// <p>Updates the following file share settings:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Default storage class for your S3 bucket</p>
    /// </li>
    /// <li>
    /// <p>Metadata defaults for your S3 bucket</p>
    /// </li>
    /// <li>
    /// <p>Allowed NFS clients for your file share</p>
    /// </li>
    /// <li>
    /// <p>Squash settings</p>
    /// </li>
    /// <li>
    /// <p>Write status of your file share</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNFSFileShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_nfs_file_share_input::Builder,
    }
    impl<C, M, R> UpdateNFSFileShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNFSFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNfsFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNFSFileShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNfsFileShareInputOperationOutputAlias,
                crate::output::UpdateNfsFileShareOutput,
                crate::error::UpdateNFSFileShareError,
                crate::input::UpdateNfsFileShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
        pub fn file_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the file share to be updated.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The default values for the file share. Optional.</p>
        pub fn nfs_file_share_defaults(mut self, inp: crate::model::NfsFileShareDefaults) -> Self {
            self.inner = self.inner.nfs_file_share_defaults(inp);
            self
        }
        /// <p>The default values for the file share. Optional.</p>
        pub fn set_nfs_file_share_defaults(
            mut self,
            input: std::option::Option<crate::model::NfsFileShareDefaults>,
        ) -> Self {
            self.inner = self.inner.set_nfs_file_share_defaults(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(inp);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, inp: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(inp);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// Appends an item to `ClientList`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn client_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_list(inp);
            self
        }
        /// <p>The list of clients that are allowed to access the S3 File Gateway. The list must
        /// contain either valid IP addresses or valid CIDR blocks.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_client_list(input);
            self
        }
        /// <p>The user mapped to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn squash(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.squash(inp);
            self
        }
        /// <p>The user mapped to anonymous user.</p>
        ///
        /// <p>Valid values are the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RootSquash</code>: Only root is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoSquash</code>: No one is mapped to anonymous user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AllSquash</code>: Everyone is mapped to anonymous user.</p>
        /// </li>
        /// </ul>
        pub fn set_squash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_squash(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.read_only(inp);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set the write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(inp);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, inp: bool) -> Self {
            self.inner = self.inner.requester_pays(inp);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(inp);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, inp: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(inp);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(inp);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBFileShare`.
    ///
    /// <p>Updates a Server Message Block (SMB) file share. This operation is only supported for S3
    /// File Gateways.</p>
    ///
    /// <note>
    /// <p>To leave a file share field unchanged, set the corresponding input field to
    /// null.</p>
    /// </note>
    ///
    /// <important>
    /// <p>File gateways require Security Token Service (Amazon Web Services STS) to be
    /// activated to enable you to create a file share. Make sure that Amazon Web Services STS
    /// is activated in the Amazon Web Services Region you are creating your file gateway in. If
    /// Amazon Web Services STS is not activated in this Amazon Web Services Region, activate
    /// it. For information about how to activate Amazon Web Services STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
    /// deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the
    /// <i>Identity and Access Management User Guide</i>.</p>
    ///
    /// <p>File gateways don't support creating hard or symbolic links on a file
    /// share.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSMBFileShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_smb_file_share_input::Builder,
    }
    impl<C, M, R> UpdateSMBFileShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSMBFileShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbFileShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmbFileShareInputOperationOutputAlias,
                crate::output::UpdateSmbFileShareOutput,
                crate::error::UpdateSMBFileShareError,
                crate::input::UpdateSmbFileShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
        pub fn file_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>
        pub fn set_file_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_arn(input);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn kms_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.kms_encrypted(inp);
            self
        }
        /// <p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own
        /// KMS key, or <code>false</code> to use a key managed by Amazon S3.
        /// Optional.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_kms_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_kms_encrypted(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This
        /// value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn default_storage_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_storage_class(inp);
            self
        }
        /// <p>The default storage class for objects put into an Amazon S3 bucket by the S3
        /// File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
        ///
        /// <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
        /// <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
        /// </p>
        pub fn set_default_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_storage_class(input);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn object_acl(mut self, inp: crate::model::ObjectAcl) -> Self {
            self.inner = self.inner.object_acl(inp);
            self
        }
        /// <p>A value that sets the access control list (ACL) permission for objects in the S3 bucket
        /// that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>
        pub fn set_object_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectAcl>,
        ) -> Self {
            self.inner = self.inner.set_object_acl(input);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn read_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.read_only(inp);
            self
        }
        /// <p>A value that sets the write status of a file share. Set this value to <code>true</code>
        /// to set write status to read-only, otherwise set to <code>false</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_read_only(input);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn guess_mime_type_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.guess_mime_type_enabled(inp);
            self
        }
        /// <p>A value that enables guessing of the MIME type for uploaded objects based on file
        /// extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set
        /// to <code>false</code>. The default value is <code>true</code>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_guess_mime_type_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_guess_mime_type_enabled(input);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn requester_pays(mut self, inp: bool) -> Self {
            self.inner = self.inner.requester_pays(inp);
            self
        }
        /// <p>A value that sets who pays the cost of the request and the cost associated with data
        /// download from the S3 bucket. If this value is set to <code>true</code>, the requester pays
        /// the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
        /// the cost of storing data.</p>
        ///
        /// <note>
        /// <p>
        /// <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file
        /// share, so make sure that the configuration on the file share is the same as the S3
        /// bucket configuration.</p>
        /// </note>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_requester_pays(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn smbacl_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.smbacl_enabled(inp);
            self
        }
        /// <p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file
        /// share. Set it to <code>false</code> to map file and directory permissions to the POSIX
        /// permissions.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
        /// control access to an SMB file share</a> in the <i>Storage Gateway User
        /// Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_smbacl_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_smbacl_enabled(input);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn access_based_enumeration(mut self, inp: bool) -> Self {
            self.inner = self.inner.access_based_enumeration(inp);
            self
        }
        /// <p>The files and folders on this share will only be visible to users with read
        /// access.</p>
        pub fn set_access_based_enumeration(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_access_based_enumeration(input);
            self
        }
        /// Appends an item to `AdminUserList`.
        ///
        /// To override the contents of this collection use [`set_admin_user_list`](Self::set_admin_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn admin_user_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_user_list(inp);
            self
        }
        /// <p>A list of users or groups in the Active Directory that have administrator rights to the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_admin_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_admin_user_list(input);
            self
        }
        /// Appends an item to `ValidUserList`.
        ///
        /// To override the contents of this collection use [`set_valid_user_list`](Self::set_valid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn valid_user_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.valid_user_list(inp);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are allowed to access the file
        /// share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_valid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_valid_user_list(input);
            self
        }
        /// Appends an item to `InvalidUserList`.
        ///
        /// To override the contents of this collection use [`set_invalid_user_list`](Self::set_invalid_user_list).
        ///
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn invalid_user_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invalid_user_list(inp);
            self
        }
        /// <p>A list of users or groups in the Active Directory that are not allowed to access the
        /// file share. A group must be prefixed with the @ character. Acceptable formats include:
        /// <code>DOMAIN\User1</code>, <code>user1</code>, <code>@group1</code>, and
        /// <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
        /// <code>ActiveDirectory</code>.</p>
        pub fn set_invalid_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_invalid_user_list(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn audit_destination_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_destination_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>
        pub fn set_audit_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_destination_arn(input);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn case_sensitivity(mut self, inp: crate::model::CaseSensitivity) -> Self {
            self.inner = self.inner.case_sensitivity(inp);
            self
        }
        /// <p>The case of an object name in an Amazon S3 bucket. For
        /// <code>ClientSpecified</code>, the client determines the case sensitivity. For
        /// <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default
        /// value is <code>ClientSpecified</code>.</p>
        pub fn set_case_sensitivity(
            mut self,
            input: std::option::Option<crate::model::CaseSensitivity>,
        ) -> Self {
            self.inner = self.inner.set_case_sensitivity(input);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn file_share_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_share_name(inp);
            self
        }
        /// <p>The name of the file share. Optional.</p>
        ///
        /// <note>
        /// <p>
        /// <code>FileShareName</code> must be set if an S3 prefix name is set in
        /// <code>LocationARN</code>, or if an access point or access point alias is used.</p>
        /// </note>
        pub fn set_file_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_share_name(input);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn cache_attributes(mut self, inp: crate::model::CacheAttributes) -> Self {
            self.inner = self.inner.cache_attributes(inp);
            self
        }
        /// <p>Specifies refresh cache information for the file share.</p>
        pub fn set_cache_attributes(
            mut self,
            input: std::option::Option<crate::model::CacheAttributes>,
        ) -> Self {
            self.inner = self.inner.set_cache_attributes(input);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn notification_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_policy(inp);
            self
        }
        /// <p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls
        /// the number of seconds to wait after the last point in time a client wrote to a file before
        /// generating an <code>ObjectUploaded</code> notification. Because clients can make many small
        /// writes to files, it's best to set this parameter for as long as possible to avoid
        /// generating multiple notifications for the same file in a small time period.</p>
        ///
        /// <note>
        /// <p>
        /// <code>SettlingTimeInSeconds</code> has no effect on the timing of the object
        /// uploading to Amazon S3, only the timing of the notification.</p>
        /// </note>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> on with
        /// <code>SettlingTimeInSeconds</code> set to 60.</p>
        ///
        /// <p>
        /// <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
        /// </p>
        ///
        /// <p>The following example sets <code>NotificationPolicy</code> off.</p>
        ///
        /// <p>
        /// <code>{}</code>
        /// </p>
        pub fn set_notification_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_policy(input);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn oplocks_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.oplocks_enabled(inp);
            self
        }
        /// <p>Specifies whether opportunistic locking is enabled for the SMB file share.</p>
        /// <note>
        /// <p>Enabling opportunistic locking on case-sensitive shares is not recommended for
        /// workloads that involve access to files with the same name in different case.</p>
        /// </note>
        /// <p>Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_oplocks_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_oplocks_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBFileShareVisibility`.
    ///
    /// <p>Controls whether the shares on an S3 File Gateway are visible in a net view or browse
    /// list. The operation is only supported for S3 File Gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSMBFileShareVisibility<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_smb_file_share_visibility_input::Builder,
    }
    impl<C, M, R> UpdateSMBFileShareVisibility<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSMBFileShareVisibility`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbFileShareVisibilityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBFileShareVisibilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmbFileShareVisibilityInputOperationOutputAlias,
                crate::output::UpdateSmbFileShareVisibilityOutput,
                crate::error::UpdateSMBFileShareVisibilityError,
                crate::input::UpdateSmbFileShareVisibilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The shares on this gateway appear when listing shares.</p>
        pub fn file_shares_visible(mut self, inp: bool) -> Self {
            self.inner = self.inner.file_shares_visible(inp);
            self
        }
        /// <p>The shares on this gateway appear when listing shares.</p>
        pub fn set_file_shares_visible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_file_shares_visible(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBLocalGroups`.
    ///
    /// <p>Updates the list of Active Directory users and groups that have special permissions for
    /// SMB file shares on the gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSMBLocalGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_smb_local_groups_input::Builder,
    }
    impl<C, M, R> UpdateSMBLocalGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSMBLocalGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbLocalGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBLocalGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmbLocalGroupsInputOperationOutputAlias,
                crate::output::UpdateSmbLocalGroupsOutput,
                crate::error::UpdateSMBLocalGroupsError,
                crate::input::UpdateSmbLocalGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>A list of Active Directory users and groups that you want to grant special permissions
        /// for SMB file shares on the gateway.</p>
        pub fn smb_local_groups(mut self, inp: crate::model::SmbLocalGroups) -> Self {
            self.inner = self.inner.smb_local_groups(inp);
            self
        }
        /// <p>A list of Active Directory users and groups that you want to grant special permissions
        /// for SMB file shares on the gateway.</p>
        pub fn set_smb_local_groups(
            mut self,
            input: std::option::Option<crate::model::SmbLocalGroups>,
        ) -> Self {
            self.inner = self.inner.set_smb_local_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSMBSecurityStrategy`.
    ///
    /// <p>Updates the SMB security strategy on a file gateway. This action is only supported in
    /// file gateways.</p>
    ///
    /// <note>
    /// <p>This API is called Security level in the User Guide.</p>
    ///
    /// <p>A higher security level can affect performance of the gateway.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSMBSecurityStrategy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_smb_security_strategy_input::Builder,
    }
    impl<C, M, R> UpdateSMBSecurityStrategy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSMBSecurityStrategy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmbSecurityStrategyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSMBSecurityStrategyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmbSecurityStrategyInputOperationOutputAlias,
                crate::output::UpdateSmbSecurityStrategyOutput,
                crate::error::UpdateSMBSecurityStrategyError,
                crate::input::UpdateSmbSecurityStrategyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a>
        /// operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>Specifies the type of security strategy.</p>
        ///
        /// <p>ClientSpecified: if you use this option, requests are established based on what is
        /// negotiated by the client. This option is recommended when you want to maximize
        /// compatibility across different clients in your environment. Supported only in S3 File
        /// Gateway.</p>
        ///
        /// <p>MandatorySigning: if you use this option, file gateway only allows connections from
        /// SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on
        /// Microsoft Windows Vista, Windows Server 2008 or newer.</p>
        ///
        /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from
        /// SMBv3 clients that have encryption enabled. This option is highly recommended for
        /// environments that handle sensitive data. This option works with SMB clients on Microsoft
        /// Windows 8, Windows Server 2012 or newer.</p>
        pub fn smb_security_strategy(mut self, inp: crate::model::SmbSecurityStrategy) -> Self {
            self.inner = self.inner.smb_security_strategy(inp);
            self
        }
        /// <p>Specifies the type of security strategy.</p>
        ///
        /// <p>ClientSpecified: if you use this option, requests are established based on what is
        /// negotiated by the client. This option is recommended when you want to maximize
        /// compatibility across different clients in your environment. Supported only in S3 File
        /// Gateway.</p>
        ///
        /// <p>MandatorySigning: if you use this option, file gateway only allows connections from
        /// SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on
        /// Microsoft Windows Vista, Windows Server 2008 or newer.</p>
        ///
        /// <p>MandatoryEncryption: if you use this option, file gateway only allows connections from
        /// SMBv3 clients that have encryption enabled. This option is highly recommended for
        /// environments that handle sensitive data. This option works with SMB clients on Microsoft
        /// Windows 8, Windows Server 2012 or newer.</p>
        pub fn set_smb_security_strategy(
            mut self,
            input: std::option::Option<crate::model::SmbSecurityStrategy>,
        ) -> Self {
            self.inner = self.inner.set_smb_security_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSnapshotSchedule`.
    ///
    /// <p>Updates a snapshot schedule configured for a gateway volume. This operation is only
    /// supported in the cached volume and stored volume gateway types.</p>
    ///
    /// <p>The default snapshot schedule for volume is once every 24 hours, starting at the
    /// creation time of the volume. You can use this API to change the snapshot schedule
    /// configured for the volume.</p>
    ///
    /// <p>In the request you must identify the gateway volume whose snapshot schedule you want to
    /// update, and the schedule information, including when you want the snapshot to begin on a
    /// day and the frequency (in hours) of snapshots.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSnapshotSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_snapshot_schedule_input::Builder,
    }
    impl<C, M, R> UpdateSnapshotSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSnapshotScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSnapshotScheduleInputOperationOutputAlias,
                crate::output::UpdateSnapshotScheduleOutput,
                crate::error::UpdateSnapshotScheduleError,
                crate::input::UpdateSnapshotScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn volume_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a>
        /// operation to return a list of gateway volumes.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_arn(input);
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as
        /// <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour
        /// of the day is in the time zone of the gateway.</p>
        pub fn start_at(mut self, inp: i32) -> Self {
            self.inner = self.inner.start_at(inp);
            self
        }
        /// <p>The hour of the day at which the snapshot schedule begins represented as
        /// <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour
        /// of the day is in the time zone of the gateway.</p>
        pub fn set_start_at(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_start_at(input);
            self
        }
        /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
        pub fn recurrence_in_hours(mut self, inp: i32) -> Self {
            self.inner = self.inner.recurrence_in_hours(inp);
            self
        }
        /// <p>Frequency of snapshots. Specify the number of hours between snapshots.</p>
        pub fn set_recurrence_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_recurrence_in_hours(input);
            self
        }
        /// <p>Optional description of the snapshot that overwrites the existing description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Optional description of the snapshot that overwrites the existing description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
        /// pair.</p>
        ///
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
        /// of a tag's key is 128 characters, and the maximum length for a tag's value is
        /// 256.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVTLDeviceType`.
    ///
    /// <p>Updates the type of medium changer in a tape gateway. When you activate a tape gateway,
    /// you select a medium changer type for the tape gateway. This operation enables you to select
    /// a different type of medium changer after a tape gateway is activated. This operation is
    /// only supported in the tape gateway type.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVTLDeviceType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_vtl_device_type_input::Builder,
    }
    impl<C, M, R> UpdateVTLDeviceType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVTLDeviceType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVtlDeviceTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVTLDeviceTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVtlDeviceTypeInputOperationOutputAlias,
                crate::output::UpdateVtlDeviceTypeOutput,
                crate::error::UpdateVTLDeviceTypeError,
                crate::input::UpdateVtlDeviceTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
        pub fn vtl_device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vtl_device_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>
        pub fn set_vtl_device_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vtl_device_arn(input);
            self
        }
        /// <p>The type of medium changer you want to select.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn device_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_type(inp);
            self
        }
        /// <p>The type of medium changer you want to select.</p>
        ///
        /// <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> |
        /// <code>IBM-03584L32-0402</code>
        /// </p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_type(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
