// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTokenOutput, crate::error::CreateTokenError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AuthorizationPendingException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::AuthorizationPendingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_pending_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_pending_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredTokenException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::ExpiredTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClientException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::InvalidClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::InvalidGrantException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_grant_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidScopeException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::InvalidScopeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_scope_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_scope_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SlowDownException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::SlowDownException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::slow_down_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_slow_down_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedGrantTypeException" => crate::error::CreateTokenError {
            meta: generic,
            kind: crate::error::CreateTokenErrorKind::UnsupportedGrantTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_grant_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_grant_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTokenOutput, crate::error::CreateTokenError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_token_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_token(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTokenError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_client_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterClientOutput, crate::error::RegisterClientError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterClientError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterClientError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::RegisterClientError {
            meta: generic,
            kind: crate::error::RegisterClientErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClientMetadataException" => crate::error::RegisterClientError {
            meta: generic,
            kind: crate::error::RegisterClientErrorKind::InvalidClientMetadataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_client_metadata_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_client_metadata_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::RegisterClientError {
            meta: generic,
            kind: crate::error::RegisterClientErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidScopeException" => crate::error::RegisterClientError {
            meta: generic,
            kind: crate::error::RegisterClientErrorKind::InvalidScopeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_scope_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_scope_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterClientError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_client_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterClientOutput, crate::error::RegisterClientError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_client_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_client(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterClientError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_device_authorization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDeviceAuthorizationOutput,
    crate::error::StartDeviceAuthorizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDeviceAuthorizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartDeviceAuthorizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartDeviceAuthorizationError {
            meta: generic,
            kind: crate::error::StartDeviceAuthorizationErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDeviceAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClientException" => crate::error::StartDeviceAuthorizationError {
            meta: generic,
            kind: crate::error::StartDeviceAuthorizationErrorKind::InvalidClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDeviceAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartDeviceAuthorizationError {
            meta: generic,
            kind: crate::error::StartDeviceAuthorizationErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDeviceAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SlowDownException" => crate::error::StartDeviceAuthorizationError {
            meta: generic,
            kind: crate::error::StartDeviceAuthorizationErrorKind::SlowDownException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::slow_down_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_slow_down_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDeviceAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::StartDeviceAuthorizationError {
            meta: generic,
            kind: crate::error::StartDeviceAuthorizationErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDeviceAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartDeviceAuthorizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_device_authorization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDeviceAuthorizationOutput,
    crate::error::StartDeviceAuthorizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_device_authorization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_device_authorization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartDeviceAuthorizationError::unhandled)?;
        output.build()
    })
}
