// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTokenError {
    /// Kind of error that occurred.
    pub kind: CreateTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTokenErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates that a request to authorize a client with an access user session token is pending.</p>
    AuthorizationPendingException(crate::error::AuthorizationPendingException),
    /// <p>Indicates that the token issued by the service is expired and is no longer valid.</p>
    ExpiredTokenException(crate::error::ExpiredTokenException),
    /// <p>Indicates that an error from the service occurred while trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that the <code>clientId</code> or <code>clientSecret</code> in the request is
    /// invalid. For example, this can occur when a client sends an incorrect <code>clientId</code> or
    /// an expired <code>clientSecret</code>.</p>
    InvalidClientException(crate::error::InvalidClientException),
    /// <p>Indicates that a request contains an invalid grant. This can occur if a client makes a <a>CreateToken</a> request with an invalid grant type.</p>
    InvalidGrantException(crate::error::InvalidGrantException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a required
    /// parameter might be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that the scope provided in the request is invalid.</p>
    InvalidScopeException(crate::error::InvalidScopeException),
    /// <p>Indicates that the client is making the request too frequently and is more than the service can handle. </p>
    SlowDownException(crate::error::SlowDownException),
    /// <p>Indicates that the client is not currently authorized to make the request. This can happen
    /// when a <code>clientId</code> is not issued for a public client.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// <p>Indicates that the grant type in the request is not supported by the service.</p>
    UnsupportedGrantTypeException(crate::error::UnsupportedGrantTypeException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTokenErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::AuthorizationPendingException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::ExpiredTokenException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::InvalidClientException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::InvalidGrantException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::InvalidScopeException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::SlowDownException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::UnsupportedGrantTypeException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTokenError {
    fn code(&self) -> Option<&str> {
        CreateTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTokenError {
    /// Creates a new `CreateTokenError`.
    pub fn new(kind: CreateTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::AuthorizationPendingException`.
    pub fn is_authorization_pending_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTokenErrorKind::AuthorizationPendingException(_)
        )
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::ExpiredTokenException`.
    pub fn is_expired_token_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::ExpiredTokenException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::InvalidClientException`.
    pub fn is_invalid_client_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::InvalidClientException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::InvalidGrantException`.
    pub fn is_invalid_grant_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::InvalidGrantException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::InvalidScopeException`.
    pub fn is_invalid_scope_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::InvalidScopeException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::SlowDownException`.
    pub fn is_slow_down_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::SlowDownException(_))
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTokenErrorKind::UnauthorizedClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateTokenErrorKind::UnsupportedGrantTypeException`.
    pub fn is_unsupported_grant_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTokenErrorKind::UnsupportedGrantTypeException(_)
        )
    }
}
impl std::error::Error for CreateTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTokenErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTokenErrorKind::AuthorizationPendingException(_inner) => Some(_inner),
            CreateTokenErrorKind::ExpiredTokenException(_inner) => Some(_inner),
            CreateTokenErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateTokenErrorKind::InvalidClientException(_inner) => Some(_inner),
            CreateTokenErrorKind::InvalidGrantException(_inner) => Some(_inner),
            CreateTokenErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateTokenErrorKind::InvalidScopeException(_inner) => Some(_inner),
            CreateTokenErrorKind::SlowDownException(_inner) => Some(_inner),
            CreateTokenErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateTokenErrorKind::UnsupportedGrantTypeException(_inner) => Some(_inner),
            CreateTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterClientError {
    /// Kind of error that occurred.
    pub kind: RegisterClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterClientErrorKind {
    /// <p>Indicates that an error from the service occurred while trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that the client information sent in the request during registration is invalid.</p>
    InvalidClientMetadataException(crate::error::InvalidClientMetadataException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a required
    /// parameter might be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that the scope provided in the request is invalid.</p>
    InvalidScopeException(crate::error::InvalidScopeException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterClientErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RegisterClientErrorKind::InvalidClientMetadataException(_inner) => _inner.fmt(f),
            RegisterClientErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RegisterClientErrorKind::InvalidScopeException(_inner) => _inner.fmt(f),
            RegisterClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterClientError {
    fn code(&self) -> Option<&str> {
        RegisterClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterClientError {
    /// Creates a new `RegisterClientError`.
    pub fn new(kind: RegisterClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterClientErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RegisterClientErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClientErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `RegisterClientErrorKind::InvalidClientMetadataException`.
    pub fn is_invalid_client_metadata_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClientErrorKind::InvalidClientMetadataException(_)
        )
    }
    /// Returns true if the error kind is `RegisterClientErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClientErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `RegisterClientErrorKind::InvalidScopeException`.
    pub fn is_invalid_scope_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClientErrorKind::InvalidScopeException(_)
        )
    }
}
impl std::error::Error for RegisterClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterClientErrorKind::InternalServerException(_inner) => Some(_inner),
            RegisterClientErrorKind::InvalidClientMetadataException(_inner) => Some(_inner),
            RegisterClientErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RegisterClientErrorKind::InvalidScopeException(_inner) => Some(_inner),
            RegisterClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDeviceAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDeviceAuthorizationError {
    /// Kind of error that occurred.
    pub kind: StartDeviceAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDeviceAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDeviceAuthorizationErrorKind {
    /// <p>Indicates that an error from the service occurred while trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that the <code>clientId</code> or <code>clientSecret</code> in the request is
    /// invalid. For example, this can occur when a client sends an incorrect <code>clientId</code> or
    /// an expired <code>clientSecret</code>.</p>
    InvalidClientException(crate::error::InvalidClientException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a required
    /// parameter might be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that the client is making the request too frequently and is more than the service can handle. </p>
    SlowDownException(crate::error::SlowDownException),
    /// <p>Indicates that the client is not currently authorized to make the request. This can happen
    /// when a <code>clientId</code> is not issued for a public client.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDeviceAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDeviceAuthorizationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartDeviceAuthorizationErrorKind::InvalidClientException(_inner) => _inner.fmt(f),
            StartDeviceAuthorizationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartDeviceAuthorizationErrorKind::SlowDownException(_inner) => _inner.fmt(f),
            StartDeviceAuthorizationErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            StartDeviceAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDeviceAuthorizationError {
    fn code(&self) -> Option<&str> {
        StartDeviceAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDeviceAuthorizationError {
    /// Creates a new `StartDeviceAuthorizationError`.
    pub fn new(kind: StartDeviceAuthorizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDeviceAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDeviceAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDeviceAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDeviceAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartDeviceAuthorizationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeviceAuthorizationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `StartDeviceAuthorizationErrorKind::InvalidClientException`.
    pub fn is_invalid_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeviceAuthorizationErrorKind::InvalidClientException(_)
        )
    }
    /// Returns true if the error kind is `StartDeviceAuthorizationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeviceAuthorizationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `StartDeviceAuthorizationErrorKind::SlowDownException`.
    pub fn is_slow_down_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeviceAuthorizationErrorKind::SlowDownException(_)
        )
    }
    /// Returns true if the error kind is `StartDeviceAuthorizationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeviceAuthorizationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for StartDeviceAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDeviceAuthorizationErrorKind::InternalServerException(_inner) => Some(_inner),
            StartDeviceAuthorizationErrorKind::InvalidClientException(_inner) => Some(_inner),
            StartDeviceAuthorizationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartDeviceAuthorizationErrorKind::SlowDownException(_inner) => Some(_inner),
            StartDeviceAuthorizationErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            StartDeviceAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Indicates that the client is not currently authorized to make the request. This can happen
/// when a <code>clientId</code> is not issued for a public client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedClientException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedClientException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedClientException {}
/// See [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
pub mod unauthorized_client_exception {
    /// A builder for [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
        pub fn build(self) -> crate::error::UnauthorizedClientException {
            crate::error::UnauthorizedClientException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl UnauthorizedClientException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
    pub fn builder() -> crate::error::unauthorized_client_exception::Builder {
        crate::error::unauthorized_client_exception::Builder::default()
    }
}

/// <p>Indicates that the client is making the request too frequently and is more than the service can handle. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlowDownException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SlowDownException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlowDownException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SlowDownException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SlowDownException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SlowDownException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for SlowDownException {}
/// See [`SlowDownException`](crate::error::SlowDownException)
pub mod slow_down_exception {
    /// A builder for [`SlowDownException`](crate::error::SlowDownException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SlowDownException`](crate::error::SlowDownException)
        pub fn build(self) -> crate::error::SlowDownException {
            crate::error::SlowDownException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl SlowDownException {
    /// Creates a new builder-style object to manufacture [`SlowDownException`](crate::error::SlowDownException)
    pub fn builder() -> crate::error::slow_down_exception::Builder {
        crate::error::slow_down_exception::Builder::default()
    }
}

/// <p>Indicates that something is wrong with the input to the request. For example, a required
/// parameter might be missing or out of range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>Indicates that the <code>clientId</code> or <code>clientSecret</code> in the request is
/// invalid. For example, this can occur when a client sends an incorrect <code>clientId</code> or
/// an expired <code>clientSecret</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClientException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClientException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClientException {}
/// See [`InvalidClientException`](crate::error::InvalidClientException)
pub mod invalid_client_exception {
    /// A builder for [`InvalidClientException`](crate::error::InvalidClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClientException`](crate::error::InvalidClientException)
        pub fn build(self) -> crate::error::InvalidClientException {
            crate::error::InvalidClientException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl InvalidClientException {
    /// Creates a new builder-style object to manufacture [`InvalidClientException`](crate::error::InvalidClientException)
    pub fn builder() -> crate::error::invalid_client_exception::Builder {
        crate::error::invalid_client_exception::Builder::default()
    }
}

/// <p>Indicates that an error from the service occurred while trying to process a request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Indicates that the scope provided in the request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidScopeException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidScopeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidScopeException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidScopeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidScopeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidScopeException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidScopeException {}
/// See [`InvalidScopeException`](crate::error::InvalidScopeException)
pub mod invalid_scope_exception {
    /// A builder for [`InvalidScopeException`](crate::error::InvalidScopeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidScopeException`](crate::error::InvalidScopeException)
        pub fn build(self) -> crate::error::InvalidScopeException {
            crate::error::InvalidScopeException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl InvalidScopeException {
    /// Creates a new builder-style object to manufacture [`InvalidScopeException`](crate::error::InvalidScopeException)
    pub fn builder() -> crate::error::invalid_scope_exception::Builder {
        crate::error::invalid_scope_exception::Builder::default()
    }
}

/// <p>Indicates that the client information sent in the request during registration is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClientMetadataException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClientMetadataException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClientMetadataException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClientMetadataException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClientMetadataException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClientMetadataException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClientMetadataException {}
/// See [`InvalidClientMetadataException`](crate::error::InvalidClientMetadataException)
pub mod invalid_client_metadata_exception {
    /// A builder for [`InvalidClientMetadataException`](crate::error::InvalidClientMetadataException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClientMetadataException`](crate::error::InvalidClientMetadataException)
        pub fn build(self) -> crate::error::InvalidClientMetadataException {
            crate::error::InvalidClientMetadataException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl InvalidClientMetadataException {
    /// Creates a new builder-style object to manufacture [`InvalidClientMetadataException`](crate::error::InvalidClientMetadataException)
    pub fn builder() -> crate::error::invalid_client_metadata_exception::Builder {
        crate::error::invalid_client_metadata_exception::Builder::default()
    }
}

/// <p>Indicates that the grant type in the request is not supported by the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedGrantTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedGrantTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedGrantTypeException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedGrantTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedGrantTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedGrantTypeException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedGrantTypeException {}
/// See [`UnsupportedGrantTypeException`](crate::error::UnsupportedGrantTypeException)
pub mod unsupported_grant_type_exception {
    /// A builder for [`UnsupportedGrantTypeException`](crate::error::UnsupportedGrantTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedGrantTypeException`](crate::error::UnsupportedGrantTypeException)
        pub fn build(self) -> crate::error::UnsupportedGrantTypeException {
            crate::error::UnsupportedGrantTypeException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl UnsupportedGrantTypeException {
    /// Creates a new builder-style object to manufacture [`UnsupportedGrantTypeException`](crate::error::UnsupportedGrantTypeException)
    pub fn builder() -> crate::error::unsupported_grant_type_exception::Builder {
        crate::error::unsupported_grant_type_exception::Builder::default()
    }
}

/// <p>Indicates that a request contains an invalid grant. This can occur if a client makes a <a>CreateToken</a> request with an invalid grant type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidGrantException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidGrantException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidGrantException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidGrantException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidGrantException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidGrantException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidGrantException {}
/// See [`InvalidGrantException`](crate::error::InvalidGrantException)
pub mod invalid_grant_exception {
    /// A builder for [`InvalidGrantException`](crate::error::InvalidGrantException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidGrantException`](crate::error::InvalidGrantException)
        pub fn build(self) -> crate::error::InvalidGrantException {
            crate::error::InvalidGrantException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl InvalidGrantException {
    /// Creates a new builder-style object to manufacture [`InvalidGrantException`](crate::error::InvalidGrantException)
    pub fn builder() -> crate::error::invalid_grant_exception::Builder {
        crate::error::invalid_grant_exception::Builder::default()
    }
}

/// <p>Indicates that the token issued by the service is expired and is no longer valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiredTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExpiredTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiredTokenException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExpiredTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExpiredTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExpiredTokenException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExpiredTokenException {}
/// See [`ExpiredTokenException`](crate::error::ExpiredTokenException)
pub mod expired_token_exception {
    /// A builder for [`ExpiredTokenException`](crate::error::ExpiredTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiredTokenException`](crate::error::ExpiredTokenException)
        pub fn build(self) -> crate::error::ExpiredTokenException {
            crate::error::ExpiredTokenException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl ExpiredTokenException {
    /// Creates a new builder-style object to manufacture [`ExpiredTokenException`](crate::error::ExpiredTokenException)
    pub fn builder() -> crate::error::expired_token_exception::Builder {
        crate::error::expired_token_exception::Builder::default()
    }
}

/// <p>Indicates that a request to authorize a client with an access user session token is pending.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationPendingException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationPendingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationPendingException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationPendingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationPendingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthorizationPendingException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthorizationPendingException {}
/// See [`AuthorizationPendingException`](crate::error::AuthorizationPendingException)
pub mod authorization_pending_exception {
    /// A builder for [`AuthorizationPendingException`](crate::error::AuthorizationPendingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationPendingException`](crate::error::AuthorizationPendingException)
        pub fn build(self) -> crate::error::AuthorizationPendingException {
            crate::error::AuthorizationPendingException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl AuthorizationPendingException {
    /// Creates a new builder-style object to manufacture [`AuthorizationPendingException`](crate::error::AuthorizationPendingException)
    pub fn builder() -> crate::error::authorization_pending_exception::Builder {
        crate::error::authorization_pending_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub error: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_description: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("error", &self.error);
        formatter.field("error_description", &self.error_description);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) error_description: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                error: self.error,
                error_description: self.error_description,
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
