// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AttachManagedPolicyToPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_managed_policy_to_permission_set`](crate::client::Client::attach_managed_policy_to_permission_set).
///
/// See [`crate::client::fluent_builders::AttachManagedPolicyToPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachManagedPolicyToPermissionSet {
    _private: (),
}
impl AttachManagedPolicyToPermissionSet {
    /// Creates a new builder-style object to manufacture [`AttachManagedPolicyToPermissionSetInput`](crate::input::AttachManagedPolicyToPermissionSetInput)
    pub fn builder() -> crate::input::attach_managed_policy_to_permission_set_input::Builder {
        crate::input::attach_managed_policy_to_permission_set_input::Builder::default()
    }
    /// Creates a new `AttachManagedPolicyToPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachManagedPolicyToPermissionSet {
    type Output = std::result::Result<
        crate::output::AttachManagedPolicyToPermissionSetOutput,
        crate::error::AttachManagedPolicyToPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_managed_policy_to_permission_set_error(response)
        } else {
            crate::operation_deser::parse_attach_managed_policy_to_permission_set_response(response)
        }
    }
}

/// Operation shape for `CreateAccountAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_account_assignment`](crate::client::Client::create_account_assignment).
///
/// See [`crate::client::fluent_builders::CreateAccountAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccountAssignment {
    _private: (),
}
impl CreateAccountAssignment {
    /// Creates a new builder-style object to manufacture [`CreateAccountAssignmentInput`](crate::input::CreateAccountAssignmentInput)
    pub fn builder() -> crate::input::create_account_assignment_input::Builder {
        crate::input::create_account_assignment_input::Builder::default()
    }
    /// Creates a new `CreateAccountAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccountAssignment {
    type Output = std::result::Result<
        crate::output::CreateAccountAssignmentOutput,
        crate::error::CreateAccountAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_account_assignment_error(response)
        } else {
            crate::operation_deser::parse_create_account_assignment_response(response)
        }
    }
}

/// Operation shape for `CreateInstanceAccessControlAttributeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instance_access_control_attribute_configuration`](crate::client::Client::create_instance_access_control_attribute_configuration).
///
/// See [`crate::client::fluent_builders::CreateInstanceAccessControlAttributeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstanceAccessControlAttributeConfiguration {
    _private: (),
}
impl CreateInstanceAccessControlAttributeConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateInstanceAccessControlAttributeConfigurationInput`](crate::input::CreateInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::create_instance_access_control_attribute_configuration_input::Builder {
        crate::input::create_instance_access_control_attribute_configuration_input::Builder::default(
        )
    }
    /// Creates a new `CreateInstanceAccessControlAttributeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for CreateInstanceAccessControlAttributeConfiguration
{
    type Output = std::result::Result<
        crate::output::CreateInstanceAccessControlAttributeConfigurationOutput,
        crate::error::CreateInstanceAccessControlAttributeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instance_access_control_attribute_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_instance_access_control_attribute_configuration_response(response)
        }
    }
}

/// Operation shape for `CreatePermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_permission_set`](crate::client::Client::create_permission_set).
///
/// See [`crate::client::fluent_builders::CreatePermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePermissionSet {
    _private: (),
}
impl CreatePermissionSet {
    /// Creates a new builder-style object to manufacture [`CreatePermissionSetInput`](crate::input::CreatePermissionSetInput)
    pub fn builder() -> crate::input::create_permission_set_input::Builder {
        crate::input::create_permission_set_input::Builder::default()
    }
    /// Creates a new `CreatePermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePermissionSet {
    type Output = std::result::Result<
        crate::output::CreatePermissionSetOutput,
        crate::error::CreatePermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_permission_set_error(response)
        } else {
            crate::operation_deser::parse_create_permission_set_response(response)
        }
    }
}

/// Operation shape for `DeleteAccountAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_account_assignment`](crate::client::Client::delete_account_assignment).
///
/// See [`crate::client::fluent_builders::DeleteAccountAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccountAssignment {
    _private: (),
}
impl DeleteAccountAssignment {
    /// Creates a new builder-style object to manufacture [`DeleteAccountAssignmentInput`](crate::input::DeleteAccountAssignmentInput)
    pub fn builder() -> crate::input::delete_account_assignment_input::Builder {
        crate::input::delete_account_assignment_input::Builder::default()
    }
    /// Creates a new `DeleteAccountAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccountAssignment {
    type Output = std::result::Result<
        crate::output::DeleteAccountAssignmentOutput,
        crate::error::DeleteAccountAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_account_assignment_error(response)
        } else {
            crate::operation_deser::parse_delete_account_assignment_response(response)
        }
    }
}

/// Operation shape for `DeleteInlinePolicyFromPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_inline_policy_from_permission_set`](crate::client::Client::delete_inline_policy_from_permission_set).
///
/// See [`crate::client::fluent_builders::DeleteInlinePolicyFromPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInlinePolicyFromPermissionSet {
    _private: (),
}
impl DeleteInlinePolicyFromPermissionSet {
    /// Creates a new builder-style object to manufacture [`DeleteInlinePolicyFromPermissionSetInput`](crate::input::DeleteInlinePolicyFromPermissionSetInput)
    pub fn builder() -> crate::input::delete_inline_policy_from_permission_set_input::Builder {
        crate::input::delete_inline_policy_from_permission_set_input::Builder::default()
    }
    /// Creates a new `DeleteInlinePolicyFromPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInlinePolicyFromPermissionSet {
    type Output = std::result::Result<
        crate::output::DeleteInlinePolicyFromPermissionSetOutput,
        crate::error::DeleteInlinePolicyFromPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_inline_policy_from_permission_set_error(response)
        } else {
            crate::operation_deser::parse_delete_inline_policy_from_permission_set_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteInstanceAccessControlAttributeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_instance_access_control_attribute_configuration`](crate::client::Client::delete_instance_access_control_attribute_configuration).
///
/// See [`crate::client::fluent_builders::DeleteInstanceAccessControlAttributeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstanceAccessControlAttributeConfiguration {
    _private: (),
}
impl DeleteInstanceAccessControlAttributeConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceAccessControlAttributeConfigurationInput`](crate::input::DeleteInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::delete_instance_access_control_attribute_configuration_input::Builder {
        crate::input::delete_instance_access_control_attribute_configuration_input::Builder::default(
        )
    }
    /// Creates a new `DeleteInstanceAccessControlAttributeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DeleteInstanceAccessControlAttributeConfiguration
{
    type Output = std::result::Result<
        crate::output::DeleteInstanceAccessControlAttributeConfigurationOutput,
        crate::error::DeleteInstanceAccessControlAttributeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_instance_access_control_attribute_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_instance_access_control_attribute_configuration_response(response)
        }
    }
}

/// Operation shape for `DeletePermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_permission_set`](crate::client::Client::delete_permission_set).
///
/// See [`crate::client::fluent_builders::DeletePermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePermissionSet {
    _private: (),
}
impl DeletePermissionSet {
    /// Creates a new builder-style object to manufacture [`DeletePermissionSetInput`](crate::input::DeletePermissionSetInput)
    pub fn builder() -> crate::input::delete_permission_set_input::Builder {
        crate::input::delete_permission_set_input::Builder::default()
    }
    /// Creates a new `DeletePermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePermissionSet {
    type Output = std::result::Result<
        crate::output::DeletePermissionSetOutput,
        crate::error::DeletePermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_permission_set_error(response)
        } else {
            crate::operation_deser::parse_delete_permission_set_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountAssignmentCreationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_assignment_creation_status`](crate::client::Client::describe_account_assignment_creation_status).
///
/// See [`crate::client::fluent_builders::DescribeAccountAssignmentCreationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAssignmentCreationStatus {
    _private: (),
}
impl DescribeAccountAssignmentCreationStatus {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAssignmentCreationStatusInput`](crate::input::DescribeAccountAssignmentCreationStatusInput)
    pub fn builder() -> crate::input::describe_account_assignment_creation_status_input::Builder {
        crate::input::describe_account_assignment_creation_status_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAssignmentCreationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAssignmentCreationStatus {
    type Output = std::result::Result<
        crate::output::DescribeAccountAssignmentCreationStatusOutput,
        crate::error::DescribeAccountAssignmentCreationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_assignment_creation_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_account_assignment_creation_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeAccountAssignmentDeletionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_assignment_deletion_status`](crate::client::Client::describe_account_assignment_deletion_status).
///
/// See [`crate::client::fluent_builders::DescribeAccountAssignmentDeletionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAssignmentDeletionStatus {
    _private: (),
}
impl DescribeAccountAssignmentDeletionStatus {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAssignmentDeletionStatusInput`](crate::input::DescribeAccountAssignmentDeletionStatusInput)
    pub fn builder() -> crate::input::describe_account_assignment_deletion_status_input::Builder {
        crate::input::describe_account_assignment_deletion_status_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAssignmentDeletionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAssignmentDeletionStatus {
    type Output = std::result::Result<
        crate::output::DescribeAccountAssignmentDeletionStatusOutput,
        crate::error::DescribeAccountAssignmentDeletionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_assignment_deletion_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_account_assignment_deletion_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeInstanceAccessControlAttributeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_access_control_attribute_configuration`](crate::client::Client::describe_instance_access_control_attribute_configuration).
///
/// See [`crate::client::fluent_builders::DescribeInstanceAccessControlAttributeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceAccessControlAttributeConfiguration {
    _private: (),
}
impl DescribeInstanceAccessControlAttributeConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAccessControlAttributeConfigurationInput`](crate::input::DescribeInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::describe_instance_access_control_attribute_configuration_input::Builder {
        crate::input::describe_instance_access_control_attribute_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceAccessControlAttributeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeInstanceAccessControlAttributeConfiguration
{
    type Output = std::result::Result<
        crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput,
        crate::error::DescribeInstanceAccessControlAttributeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_access_control_attribute_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_access_control_attribute_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribePermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_permission_set`](crate::client::Client::describe_permission_set).
///
/// See [`crate::client::fluent_builders::DescribePermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePermissionSet {
    _private: (),
}
impl DescribePermissionSet {
    /// Creates a new builder-style object to manufacture [`DescribePermissionSetInput`](crate::input::DescribePermissionSetInput)
    pub fn builder() -> crate::input::describe_permission_set_input::Builder {
        crate::input::describe_permission_set_input::Builder::default()
    }
    /// Creates a new `DescribePermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePermissionSet {
    type Output = std::result::Result<
        crate::output::DescribePermissionSetOutput,
        crate::error::DescribePermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_permission_set_error(response)
        } else {
            crate::operation_deser::parse_describe_permission_set_response(response)
        }
    }
}

/// Operation shape for `DescribePermissionSetProvisioningStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_permission_set_provisioning_status`](crate::client::Client::describe_permission_set_provisioning_status).
///
/// See [`crate::client::fluent_builders::DescribePermissionSetProvisioningStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePermissionSetProvisioningStatus {
    _private: (),
}
impl DescribePermissionSetProvisioningStatus {
    /// Creates a new builder-style object to manufacture [`DescribePermissionSetProvisioningStatusInput`](crate::input::DescribePermissionSetProvisioningStatusInput)
    pub fn builder() -> crate::input::describe_permission_set_provisioning_status_input::Builder {
        crate::input::describe_permission_set_provisioning_status_input::Builder::default()
    }
    /// Creates a new `DescribePermissionSetProvisioningStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePermissionSetProvisioningStatus {
    type Output = std::result::Result<
        crate::output::DescribePermissionSetProvisioningStatusOutput,
        crate::error::DescribePermissionSetProvisioningStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_permission_set_provisioning_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_permission_set_provisioning_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `DetachManagedPolicyFromPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_managed_policy_from_permission_set`](crate::client::Client::detach_managed_policy_from_permission_set).
///
/// See [`crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachManagedPolicyFromPermissionSet {
    _private: (),
}
impl DetachManagedPolicyFromPermissionSet {
    /// Creates a new builder-style object to manufacture [`DetachManagedPolicyFromPermissionSetInput`](crate::input::DetachManagedPolicyFromPermissionSetInput)
    pub fn builder() -> crate::input::detach_managed_policy_from_permission_set_input::Builder {
        crate::input::detach_managed_policy_from_permission_set_input::Builder::default()
    }
    /// Creates a new `DetachManagedPolicyFromPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachManagedPolicyFromPermissionSet {
    type Output = std::result::Result<
        crate::output::DetachManagedPolicyFromPermissionSetOutput,
        crate::error::DetachManagedPolicyFromPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_managed_policy_from_permission_set_error(response)
        } else {
            crate::operation_deser::parse_detach_managed_policy_from_permission_set_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetInlinePolicyForPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_inline_policy_for_permission_set`](crate::client::Client::get_inline_policy_for_permission_set).
///
/// See [`crate::client::fluent_builders::GetInlinePolicyForPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInlinePolicyForPermissionSet {
    _private: (),
}
impl GetInlinePolicyForPermissionSet {
    /// Creates a new builder-style object to manufacture [`GetInlinePolicyForPermissionSetInput`](crate::input::GetInlinePolicyForPermissionSetInput)
    pub fn builder() -> crate::input::get_inline_policy_for_permission_set_input::Builder {
        crate::input::get_inline_policy_for_permission_set_input::Builder::default()
    }
    /// Creates a new `GetInlinePolicyForPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInlinePolicyForPermissionSet {
    type Output = std::result::Result<
        crate::output::GetInlinePolicyForPermissionSetOutput,
        crate::error::GetInlinePolicyForPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_inline_policy_for_permission_set_error(response)
        } else {
            crate::operation_deser::parse_get_inline_policy_for_permission_set_response(response)
        }
    }
}

/// Operation shape for `ListAccountAssignmentCreationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_account_assignment_creation_status`](crate::client::Client::list_account_assignment_creation_status).
///
/// See [`crate::client::fluent_builders::ListAccountAssignmentCreationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountAssignmentCreationStatus {
    _private: (),
}
impl ListAccountAssignmentCreationStatus {
    /// Creates a new builder-style object to manufacture [`ListAccountAssignmentCreationStatusInput`](crate::input::ListAccountAssignmentCreationStatusInput)
    pub fn builder() -> crate::input::list_account_assignment_creation_status_input::Builder {
        crate::input::list_account_assignment_creation_status_input::Builder::default()
    }
    /// Creates a new `ListAccountAssignmentCreationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountAssignmentCreationStatus {
    type Output = std::result::Result<
        crate::output::ListAccountAssignmentCreationStatusOutput,
        crate::error::ListAccountAssignmentCreationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_account_assignment_creation_status_error(response)
        } else {
            crate::operation_deser::parse_list_account_assignment_creation_status_response(response)
        }
    }
}

/// Operation shape for `ListAccountAssignmentDeletionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_account_assignment_deletion_status`](crate::client::Client::list_account_assignment_deletion_status).
///
/// See [`crate::client::fluent_builders::ListAccountAssignmentDeletionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountAssignmentDeletionStatus {
    _private: (),
}
impl ListAccountAssignmentDeletionStatus {
    /// Creates a new builder-style object to manufacture [`ListAccountAssignmentDeletionStatusInput`](crate::input::ListAccountAssignmentDeletionStatusInput)
    pub fn builder() -> crate::input::list_account_assignment_deletion_status_input::Builder {
        crate::input::list_account_assignment_deletion_status_input::Builder::default()
    }
    /// Creates a new `ListAccountAssignmentDeletionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountAssignmentDeletionStatus {
    type Output = std::result::Result<
        crate::output::ListAccountAssignmentDeletionStatusOutput,
        crate::error::ListAccountAssignmentDeletionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_account_assignment_deletion_status_error(response)
        } else {
            crate::operation_deser::parse_list_account_assignment_deletion_status_response(response)
        }
    }
}

/// Operation shape for `ListAccountAssignments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_account_assignments`](crate::client::Client::list_account_assignments).
///
/// See [`crate::client::fluent_builders::ListAccountAssignments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountAssignments {
    _private: (),
}
impl ListAccountAssignments {
    /// Creates a new builder-style object to manufacture [`ListAccountAssignmentsInput`](crate::input::ListAccountAssignmentsInput)
    pub fn builder() -> crate::input::list_account_assignments_input::Builder {
        crate::input::list_account_assignments_input::Builder::default()
    }
    /// Creates a new `ListAccountAssignments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountAssignments {
    type Output = std::result::Result<
        crate::output::ListAccountAssignmentsOutput,
        crate::error::ListAccountAssignmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_account_assignments_error(response)
        } else {
            crate::operation_deser::parse_list_account_assignments_response(response)
        }
    }
}

/// Operation shape for `ListAccountsForProvisionedPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_accounts_for_provisioned_permission_set`](crate::client::Client::list_accounts_for_provisioned_permission_set).
///
/// See [`crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountsForProvisionedPermissionSet {
    _private: (),
}
impl ListAccountsForProvisionedPermissionSet {
    /// Creates a new builder-style object to manufacture [`ListAccountsForProvisionedPermissionSetInput`](crate::input::ListAccountsForProvisionedPermissionSetInput)
    pub fn builder() -> crate::input::list_accounts_for_provisioned_permission_set_input::Builder {
        crate::input::list_accounts_for_provisioned_permission_set_input::Builder::default()
    }
    /// Creates a new `ListAccountsForProvisionedPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountsForProvisionedPermissionSet {
    type Output = std::result::Result<
        crate::output::ListAccountsForProvisionedPermissionSetOutput,
        crate::error::ListAccountsForProvisionedPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_accounts_for_provisioned_permission_set_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_accounts_for_provisioned_permission_set_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instances`](crate::client::Client::list_instances).
///
/// See [`crate::client::fluent_builders::ListInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstances {
    _private: (),
}
impl ListInstances {
    /// Creates a new builder-style object to manufacture [`ListInstancesInput`](crate::input::ListInstancesInput)
    pub fn builder() -> crate::input::list_instances_input::Builder {
        crate::input::list_instances_input::Builder::default()
    }
    /// Creates a new `ListInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstances {
    type Output =
        std::result::Result<crate::output::ListInstancesOutput, crate::error::ListInstancesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instances_error(response)
        } else {
            crate::operation_deser::parse_list_instances_response(response)
        }
    }
}

/// Operation shape for `ListManagedPoliciesInPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_managed_policies_in_permission_set`](crate::client::Client::list_managed_policies_in_permission_set).
///
/// See [`crate::client::fluent_builders::ListManagedPoliciesInPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListManagedPoliciesInPermissionSet {
    _private: (),
}
impl ListManagedPoliciesInPermissionSet {
    /// Creates a new builder-style object to manufacture [`ListManagedPoliciesInPermissionSetInput`](crate::input::ListManagedPoliciesInPermissionSetInput)
    pub fn builder() -> crate::input::list_managed_policies_in_permission_set_input::Builder {
        crate::input::list_managed_policies_in_permission_set_input::Builder::default()
    }
    /// Creates a new `ListManagedPoliciesInPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListManagedPoliciesInPermissionSet {
    type Output = std::result::Result<
        crate::output::ListManagedPoliciesInPermissionSetOutput,
        crate::error::ListManagedPoliciesInPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_managed_policies_in_permission_set_error(response)
        } else {
            crate::operation_deser::parse_list_managed_policies_in_permission_set_response(response)
        }
    }
}

/// Operation shape for `ListPermissionSetProvisioningStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_permission_set_provisioning_status`](crate::client::Client::list_permission_set_provisioning_status).
///
/// See [`crate::client::fluent_builders::ListPermissionSetProvisioningStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPermissionSetProvisioningStatus {
    _private: (),
}
impl ListPermissionSetProvisioningStatus {
    /// Creates a new builder-style object to manufacture [`ListPermissionSetProvisioningStatusInput`](crate::input::ListPermissionSetProvisioningStatusInput)
    pub fn builder() -> crate::input::list_permission_set_provisioning_status_input::Builder {
        crate::input::list_permission_set_provisioning_status_input::Builder::default()
    }
    /// Creates a new `ListPermissionSetProvisioningStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPermissionSetProvisioningStatus {
    type Output = std::result::Result<
        crate::output::ListPermissionSetProvisioningStatusOutput,
        crate::error::ListPermissionSetProvisioningStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_permission_set_provisioning_status_error(response)
        } else {
            crate::operation_deser::parse_list_permission_set_provisioning_status_response(response)
        }
    }
}

/// Operation shape for `ListPermissionSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_permission_sets`](crate::client::Client::list_permission_sets).
///
/// See [`crate::client::fluent_builders::ListPermissionSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPermissionSets {
    _private: (),
}
impl ListPermissionSets {
    /// Creates a new builder-style object to manufacture [`ListPermissionSetsInput`](crate::input::ListPermissionSetsInput)
    pub fn builder() -> crate::input::list_permission_sets_input::Builder {
        crate::input::list_permission_sets_input::Builder::default()
    }
    /// Creates a new `ListPermissionSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPermissionSets {
    type Output = std::result::Result<
        crate::output::ListPermissionSetsOutput,
        crate::error::ListPermissionSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_permission_sets_error(response)
        } else {
            crate::operation_deser::parse_list_permission_sets_response(response)
        }
    }
}

/// Operation shape for `ListPermissionSetsProvisionedToAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_permission_sets_provisioned_to_account`](crate::client::Client::list_permission_sets_provisioned_to_account).
///
/// See [`crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPermissionSetsProvisionedToAccount {
    _private: (),
}
impl ListPermissionSetsProvisionedToAccount {
    /// Creates a new builder-style object to manufacture [`ListPermissionSetsProvisionedToAccountInput`](crate::input::ListPermissionSetsProvisionedToAccountInput)
    pub fn builder() -> crate::input::list_permission_sets_provisioned_to_account_input::Builder {
        crate::input::list_permission_sets_provisioned_to_account_input::Builder::default()
    }
    /// Creates a new `ListPermissionSetsProvisionedToAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPermissionSetsProvisionedToAccount {
    type Output = std::result::Result<
        crate::output::ListPermissionSetsProvisionedToAccountOutput,
        crate::error::ListPermissionSetsProvisionedToAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_permission_sets_provisioned_to_account_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_permission_sets_provisioned_to_account_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ProvisionPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provision_permission_set`](crate::client::Client::provision_permission_set).
///
/// See [`crate::client::fluent_builders::ProvisionPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvisionPermissionSet {
    _private: (),
}
impl ProvisionPermissionSet {
    /// Creates a new builder-style object to manufacture [`ProvisionPermissionSetInput`](crate::input::ProvisionPermissionSetInput)
    pub fn builder() -> crate::input::provision_permission_set_input::Builder {
        crate::input::provision_permission_set_input::Builder::default()
    }
    /// Creates a new `ProvisionPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvisionPermissionSet {
    type Output = std::result::Result<
        crate::output::ProvisionPermissionSetOutput,
        crate::error::ProvisionPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provision_permission_set_error(response)
        } else {
            crate::operation_deser::parse_provision_permission_set_response(response)
        }
    }
}

/// Operation shape for `PutInlinePolicyToPermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_inline_policy_to_permission_set`](crate::client::Client::put_inline_policy_to_permission_set).
///
/// See [`crate::client::fluent_builders::PutInlinePolicyToPermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutInlinePolicyToPermissionSet {
    _private: (),
}
impl PutInlinePolicyToPermissionSet {
    /// Creates a new builder-style object to manufacture [`PutInlinePolicyToPermissionSetInput`](crate::input::PutInlinePolicyToPermissionSetInput)
    pub fn builder() -> crate::input::put_inline_policy_to_permission_set_input::Builder {
        crate::input::put_inline_policy_to_permission_set_input::Builder::default()
    }
    /// Creates a new `PutInlinePolicyToPermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutInlinePolicyToPermissionSet {
    type Output = std::result::Result<
        crate::output::PutInlinePolicyToPermissionSetOutput,
        crate::error::PutInlinePolicyToPermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_inline_policy_to_permission_set_error(response)
        } else {
            crate::operation_deser::parse_put_inline_policy_to_permission_set_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateInstanceAccessControlAttributeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_instance_access_control_attribute_configuration`](crate::client::Client::update_instance_access_control_attribute_configuration).
///
/// See [`crate::client::fluent_builders::UpdateInstanceAccessControlAttributeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInstanceAccessControlAttributeConfiguration {
    _private: (),
}
impl UpdateInstanceAccessControlAttributeConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateInstanceAccessControlAttributeConfigurationInput`](crate::input::UpdateInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::update_instance_access_control_attribute_configuration_input::Builder {
        crate::input::update_instance_access_control_attribute_configuration_input::Builder::default(
        )
    }
    /// Creates a new `UpdateInstanceAccessControlAttributeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for UpdateInstanceAccessControlAttributeConfiguration
{
    type Output = std::result::Result<
        crate::output::UpdateInstanceAccessControlAttributeConfigurationOutput,
        crate::error::UpdateInstanceAccessControlAttributeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_instance_access_control_attribute_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_instance_access_control_attribute_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdatePermissionSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_permission_set`](crate::client::Client::update_permission_set).
///
/// See [`crate::client::fluent_builders::UpdatePermissionSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePermissionSet {
    _private: (),
}
impl UpdatePermissionSet {
    /// Creates a new builder-style object to manufacture [`UpdatePermissionSetInput`](crate::input::UpdatePermissionSetInput)
    pub fn builder() -> crate::input::update_permission_set_input::Builder {
        crate::input::update_permission_set_input::Builder::default()
    }
    /// Creates a new `UpdatePermissionSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePermissionSet {
    type Output = std::result::Result<
        crate::output::UpdatePermissionSetOutput,
        crate::error::UpdatePermissionSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_permission_set_error(response)
        } else {
            crate::operation_deser::parse_update_permission_set_response(response)
        }
    }
}
