// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Single Sign-On Admin
///
/// Client for invoking operations on AWS Single Sign-On Admin. Each operation on AWS Single Sign-On Admin is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ssoadmin::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ssoadmin::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ssoadmin::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AttachManagedPolicyToPermissionSet` operation.
    ///
    /// See [`AttachManagedPolicyToPermissionSet`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn attach_managed_policy_to_permission_set(
        &self,
    ) -> fluent_builders::AttachManagedPolicyToPermissionSet<C, M, R> {
        fluent_builders::AttachManagedPolicyToPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccountAssignment` operation.
    ///
    /// See [`CreateAccountAssignment`](crate::client::fluent_builders::CreateAccountAssignment) for more information about the
    /// operation and its arguments.
    pub fn create_account_assignment(&self) -> fluent_builders::CreateAccountAssignment<C, M, R> {
        fluent_builders::CreateAccountAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstanceAccessControlAttributeConfiguration` operation.
    ///
    /// See [`CreateInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::CreateInstanceAccessControlAttributeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::CreateInstanceAccessControlAttributeConfiguration<C, M, R> {
        fluent_builders::CreateInstanceAccessControlAttributeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePermissionSet` operation.
    ///
    /// See [`CreatePermissionSet`](crate::client::fluent_builders::CreatePermissionSet) for more information about the
    /// operation and its arguments.
    pub fn create_permission_set(&self) -> fluent_builders::CreatePermissionSet<C, M, R> {
        fluent_builders::CreatePermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccountAssignment` operation.
    ///
    /// See [`DeleteAccountAssignment`](crate::client::fluent_builders::DeleteAccountAssignment) for more information about the
    /// operation and its arguments.
    pub fn delete_account_assignment(&self) -> fluent_builders::DeleteAccountAssignment<C, M, R> {
        fluent_builders::DeleteAccountAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInlinePolicyFromPermissionSet` operation.
    ///
    /// See [`DeleteInlinePolicyFromPermissionSet`](crate::client::fluent_builders::DeleteInlinePolicyFromPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn delete_inline_policy_from_permission_set(
        &self,
    ) -> fluent_builders::DeleteInlinePolicyFromPermissionSet<C, M, R> {
        fluent_builders::DeleteInlinePolicyFromPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstanceAccessControlAttributeConfiguration` operation.
    ///
    /// See [`DeleteInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::DeleteInstanceAccessControlAttributeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::DeleteInstanceAccessControlAttributeConfiguration<C, M, R> {
        fluent_builders::DeleteInstanceAccessControlAttributeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePermissionSet` operation.
    ///
    /// See [`DeletePermissionSet`](crate::client::fluent_builders::DeletePermissionSet) for more information about the
    /// operation and its arguments.
    pub fn delete_permission_set(&self) -> fluent_builders::DeletePermissionSet<C, M, R> {
        fluent_builders::DeletePermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAssignmentCreationStatus` operation.
    ///
    /// See [`DescribeAccountAssignmentCreationStatus`](crate::client::fluent_builders::DescribeAccountAssignmentCreationStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_account_assignment_creation_status(
        &self,
    ) -> fluent_builders::DescribeAccountAssignmentCreationStatus<C, M, R> {
        fluent_builders::DescribeAccountAssignmentCreationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAssignmentDeletionStatus` operation.
    ///
    /// See [`DescribeAccountAssignmentDeletionStatus`](crate::client::fluent_builders::DescribeAccountAssignmentDeletionStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_account_assignment_deletion_status(
        &self,
    ) -> fluent_builders::DescribeAccountAssignmentDeletionStatus<C, M, R> {
        fluent_builders::DescribeAccountAssignmentDeletionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceAccessControlAttributeConfiguration` operation.
    ///
    /// See [`DescribeInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::DescribeInstanceAccessControlAttributeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::DescribeInstanceAccessControlAttributeConfiguration<C, M, R> {
        fluent_builders::DescribeInstanceAccessControlAttributeConfiguration::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the `DescribePermissionSet` operation.
    ///
    /// See [`DescribePermissionSet`](crate::client::fluent_builders::DescribePermissionSet) for more information about the
    /// operation and its arguments.
    pub fn describe_permission_set(&self) -> fluent_builders::DescribePermissionSet<C, M, R> {
        fluent_builders::DescribePermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePermissionSetProvisioningStatus` operation.
    ///
    /// See [`DescribePermissionSetProvisioningStatus`](crate::client::fluent_builders::DescribePermissionSetProvisioningStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_permission_set_provisioning_status(
        &self,
    ) -> fluent_builders::DescribePermissionSetProvisioningStatus<C, M, R> {
        fluent_builders::DescribePermissionSetProvisioningStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachManagedPolicyFromPermissionSet` operation.
    ///
    /// See [`DetachManagedPolicyFromPermissionSet`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn detach_managed_policy_from_permission_set(
        &self,
    ) -> fluent_builders::DetachManagedPolicyFromPermissionSet<C, M, R> {
        fluent_builders::DetachManagedPolicyFromPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInlinePolicyForPermissionSet` operation.
    ///
    /// See [`GetInlinePolicyForPermissionSet`](crate::client::fluent_builders::GetInlinePolicyForPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn get_inline_policy_for_permission_set(
        &self,
    ) -> fluent_builders::GetInlinePolicyForPermissionSet<C, M, R> {
        fluent_builders::GetInlinePolicyForPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountAssignmentCreationStatus` operation.
    ///
    /// See [`ListAccountAssignmentCreationStatus`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus) for more information about the
    /// operation and its arguments.
    pub fn list_account_assignment_creation_status(
        &self,
    ) -> fluent_builders::ListAccountAssignmentCreationStatus<C, M, R> {
        fluent_builders::ListAccountAssignmentCreationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountAssignmentDeletionStatus` operation.
    ///
    /// See [`ListAccountAssignmentDeletionStatus`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus) for more information about the
    /// operation and its arguments.
    pub fn list_account_assignment_deletion_status(
        &self,
    ) -> fluent_builders::ListAccountAssignmentDeletionStatus<C, M, R> {
        fluent_builders::ListAccountAssignmentDeletionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountAssignments` operation.
    ///
    /// See [`ListAccountAssignments`](crate::client::fluent_builders::ListAccountAssignments) for more information about the
    /// operation and its arguments.
    pub fn list_account_assignments(&self) -> fluent_builders::ListAccountAssignments<C, M, R> {
        fluent_builders::ListAccountAssignments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountsForProvisionedPermissionSet` operation.
    ///
    /// See [`ListAccountsForProvisionedPermissionSet`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn list_accounts_for_provisioned_permission_set(
        &self,
    ) -> fluent_builders::ListAccountsForProvisionedPermissionSet<C, M, R> {
        fluent_builders::ListAccountsForProvisionedPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstances` operation.
    ///
    /// See [`ListInstances`](crate::client::fluent_builders::ListInstances) for more information about the
    /// operation and its arguments.
    pub fn list_instances(&self) -> fluent_builders::ListInstances<C, M, R> {
        fluent_builders::ListInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListManagedPoliciesInPermissionSet` operation.
    ///
    /// See [`ListManagedPoliciesInPermissionSet`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn list_managed_policies_in_permission_set(
        &self,
    ) -> fluent_builders::ListManagedPoliciesInPermissionSet<C, M, R> {
        fluent_builders::ListManagedPoliciesInPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPermissionSetProvisioningStatus` operation.
    ///
    /// See [`ListPermissionSetProvisioningStatus`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus) for more information about the
    /// operation and its arguments.
    pub fn list_permission_set_provisioning_status(
        &self,
    ) -> fluent_builders::ListPermissionSetProvisioningStatus<C, M, R> {
        fluent_builders::ListPermissionSetProvisioningStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPermissionSets` operation.
    ///
    /// See [`ListPermissionSets`](crate::client::fluent_builders::ListPermissionSets) for more information about the
    /// operation and its arguments.
    pub fn list_permission_sets(&self) -> fluent_builders::ListPermissionSets<C, M, R> {
        fluent_builders::ListPermissionSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPermissionSetsProvisionedToAccount` operation.
    ///
    /// See [`ListPermissionSetsProvisionedToAccount`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount) for more information about the
    /// operation and its arguments.
    pub fn list_permission_sets_provisioned_to_account(
        &self,
    ) -> fluent_builders::ListPermissionSetsProvisionedToAccount<C, M, R> {
        fluent_builders::ListPermissionSetsProvisionedToAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ProvisionPermissionSet` operation.
    ///
    /// See [`ProvisionPermissionSet`](crate::client::fluent_builders::ProvisionPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn provision_permission_set(&self) -> fluent_builders::ProvisionPermissionSet<C, M, R> {
        fluent_builders::ProvisionPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutInlinePolicyToPermissionSet` operation.
    ///
    /// See [`PutInlinePolicyToPermissionSet`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet) for more information about the
    /// operation and its arguments.
    pub fn put_inline_policy_to_permission_set(
        &self,
    ) -> fluent_builders::PutInlinePolicyToPermissionSet<C, M, R> {
        fluent_builders::PutInlinePolicyToPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInstanceAccessControlAttributeConfiguration` operation.
    ///
    /// See [`UpdateInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::UpdateInstanceAccessControlAttributeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::UpdateInstanceAccessControlAttributeConfiguration<C, M, R> {
        fluent_builders::UpdateInstanceAccessControlAttributeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePermissionSet` operation.
    ///
    /// See [`UpdatePermissionSet`](crate::client::fluent_builders::UpdatePermissionSet) for more information about the
    /// operation and its arguments.
    pub fn update_permission_set(&self) -> fluent_builders::UpdatePermissionSet<C, M, R> {
        fluent_builders::UpdatePermissionSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AttachManagedPolicyToPermissionSet`.
    ///
    /// <p>Attaches an IAM managed policy ARN to a permission set.</p>
    /// <note>
    /// <p>If the permission set is already referenced by one or more account assignments, you will
    /// need to call <code>
    /// <a>ProvisionPermissionSet</a>
    /// </code> after this operation.
    /// Calling <code>ProvisionPermissionSet</code> applies the corresponding IAM policy updates to
    /// all assigned accounts.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AttachManagedPolicyToPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_managed_policy_to_permission_set_input::Builder,
    }
    impl<C, M, R> AttachManagedPolicyToPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachManagedPolicyToPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachManagedPolicyToPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AttachManagedPolicyToPermissionSetError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachManagedPolicyToPermissionSetInputOperationOutputAlias,
                crate::output::AttachManagedPolicyToPermissionSetOutput,
                crate::error::AttachManagedPolicyToPermissionSetError,
                crate::input::AttachManagedPolicyToPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> that the managed policy should be attached
        /// to.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> that the managed policy should be attached
        /// to.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn managed_policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_policy_arn(inp);
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn set_managed_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccountAssignment`.
    ///
    /// <p>Assigns access to a principal for a specified Amazon Web Services account using a specified permission
    /// set.</p>
    /// <note>
    /// <p>The term <i>principal</i> here refers to a user or group that is defined
    /// in Amazon Web Services SSO.</p>
    /// </note>
    /// <note>
    /// <p>As part of a successful <code>CreateAccountAssignment</code> call, the specified
    /// permission set will automatically be provisioned to the account in the form of an IAM
    /// policy. That policy is attached to the SSO-created IAM role. If the permission set is
    /// subsequently updated, the corresponding IAM policies attached to roles in your accounts will
    /// not be updated automatically. In this case, you must call <code>
    /// <a>ProvisionPermissionSet</a>
    /// </code> to make these updates.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccountAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_account_assignment_input::Builder,
    }
    impl<C, M, R> CreateAccountAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccountAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccountAssignmentInputOperationOutputAlias,
                crate::output::CreateAccountAssignmentOutput,
                crate::error::CreateAccountAssignmentError,
                crate::input::CreateAccountAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn target_type(mut self, inp: crate::model::TargetType) -> Self {
            self.inner = self.inner.target_type(inp);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>The ARN of the permission set that the admin wants to grant the principal access
        /// to.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set that the admin wants to grant the principal access
        /// to.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn principal_type(mut self, inp: crate::model::PrincipalType) -> Self {
            self.inner = self.inner.principal_type(inp);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.inner = self.inner.set_principal_type(input);
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO
    /// instance. You can also specify new attributes to add to your ABAC configuration during the
    /// enabling process. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInstanceAccessControlAttributeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_access_control_attribute_configuration_input::Builder,
    }
    impl<C, M, R> CreateInstanceAccessControlAttributeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::CreateInstanceAccessControlAttributeConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::CreateInstanceAccessControlAttributeConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::CreateInstanceAccessControlAttributeConfigurationInputOperationOutputAlias,
                                    crate::output::CreateInstanceAccessControlAttributeConfigurationOutput,
                                    crate::error::CreateInstanceAccessControlAttributeConfigurationError,
                                    crate::input::CreateInstanceAccessControlAttributeConfigurationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration.
        /// When using an external identity provider as an identity source, you can pass attributes
        /// through the SAML assertion. Doing so provides an alternative to configuring attributes from
        /// the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services
        /// SSO will replace the attribute value with the value from the Amazon Web Services SSO identity
        /// store.</p>
        pub fn instance_access_control_attribute_configuration(
            mut self,
            inp: crate::model::InstanceAccessControlAttributeConfiguration,
        ) -> Self {
            self.inner = self
                .inner
                .instance_access_control_attribute_configuration(inp);
            self
        }
        /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration.
        /// When using an external identity provider as an identity source, you can pass attributes
        /// through the SAML assertion. Doing so provides an alternative to configuring attributes from
        /// the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services
        /// SSO will replace the attribute value with the value from the Amazon Web Services SSO identity
        /// store.</p>
        pub fn set_instance_access_control_attribute_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_instance_access_control_attribute_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePermissionSet`.
    ///
    /// <p>Creates a permission set within a specified SSO instance.</p>
    /// <note>
    /// <p>To grant users and groups access to Amazon Web Services account resources, use <code>
    /// <a>CreateAccountAssignment</a>
    /// </code>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreatePermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_permission_set_input::Builder,
    }
    impl<C, M, R> CreatePermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePermissionSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePermissionSetInputOperationOutputAlias,
                crate::output::CreatePermissionSetOutput,
                crate::error::CreatePermissionSetError,
                crate::input::CreatePermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <a>PermissionSet</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <a>PermissionSet</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the <a>PermissionSet</a>.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the <a>PermissionSet</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The length of time that the application user sessions are valid in the ISO-8601
        /// standard.</p>
        pub fn session_duration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_duration(inp);
            self
        }
        /// <p>The length of time that the application user sessions are valid in the ISO-8601
        /// standard.</p>
        pub fn set_session_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_duration(input);
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication
        /// process.</p>
        pub fn relay_state(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relay_state(inp);
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication
        /// process.</p>
        pub fn set_relay_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_relay_state(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new <a>PermissionSet</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the new <a>PermissionSet</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountAssignment`.
    ///
    /// <p>Deletes a principal's access from a specified Amazon Web Services account using a specified permission
    /// set.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccountAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_assignment_input::Builder,
    }
    impl<C, M, R> DeleteAccountAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccountAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountAssignmentInputOperationOutputAlias,
                crate::output::DeleteAccountAssignmentOutput,
                crate::error::DeleteAccountAssignmentError,
                crate::input::DeleteAccountAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn target_type(mut self, inp: crate::model::TargetType) -> Self {
            self.inner = self.inner.target_type(inp);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn principal_type(mut self, inp: crate::model::PrincipalType) -> Self {
            self.inner = self.inner.principal_type(inp);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.inner = self.inner.set_principal_type(input);
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInlinePolicyFromPermissionSet`.
    ///
    /// <p>Deletes the inline policy from a specified permission set.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInlinePolicyFromPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_inline_policy_from_permission_set_input::Builder,
    }
    impl<C, M, R> DeleteInlinePolicyFromPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInlinePolicyFromPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInlinePolicyFromPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteInlinePolicyFromPermissionSetError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInlinePolicyFromPermissionSetInputOperationOutputAlias,
                crate::output::DeleteInlinePolicyFromPermissionSetOutput,
                crate::error::DeleteInlinePolicyFromPermissionSetError,
                crate::input::DeleteInlinePolicyFromPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO
    /// instance and deletes all of the attribute mappings that have been configured. Once deleted,
    /// any attributes that are received from an identity source and any custom attributes you have
    /// previously configured will not be passed. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInstanceAccessControlAttributeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_instance_access_control_attribute_configuration_input::Builder,
    }
    impl<C, M, R> DeleteInstanceAccessControlAttributeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DeleteInstanceAccessControlAttributeConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::DeleteInstanceAccessControlAttributeConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DeleteInstanceAccessControlAttributeConfigurationInputOperationOutputAlias,
                                    crate::output::DeleteInstanceAccessControlAttributeConfigurationOutput,
                                    crate::error::DeleteInstanceAccessControlAttributeConfigurationError,
                                    crate::input::DeleteInstanceAccessControlAttributeConfigurationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePermissionSet`.
    ///
    /// <p>Deletes the specified permission set.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_permission_set_input::Builder,
    }
    impl<C, M, R> DeletePermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePermissionSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePermissionSetInputOperationOutputAlias,
                crate::output::DeletePermissionSetOutput,
                crate::error::DeletePermissionSetError,
                crate::input::DeletePermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set that should be deleted.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set that should be deleted.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAssignmentCreationStatus`.
    ///
    /// <p>Describes the status of the assignment creation request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountAssignmentCreationStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_assignment_creation_status_input::Builder,
    }
    impl<C, M, R> DescribeAccountAssignmentCreationStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAssignmentCreationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAssignmentCreationStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAccountAssignmentCreationStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAssignmentCreationStatusInputOperationOutputAlias,
                crate::output::DescribeAccountAssignmentCreationStatusOutput,
                crate::error::DescribeAccountAssignmentCreationStatusError,
                crate::input::DescribeAccountAssignmentCreationStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn account_assignment_creation_request_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.account_assignment_creation_request_id(inp);
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn set_account_assignment_creation_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_assignment_creation_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAssignmentDeletionStatus`.
    ///
    /// <p>Describes the status of the assignment deletion request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountAssignmentDeletionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_assignment_deletion_status_input::Builder,
    }
    impl<C, M, R> DescribeAccountAssignmentDeletionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAssignmentDeletionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAssignmentDeletionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAccountAssignmentDeletionStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAssignmentDeletionStatusInputOperationOutputAlias,
                crate::output::DescribeAccountAssignmentDeletionStatusOutput,
                crate::error::DescribeAccountAssignmentDeletionStatusError,
                crate::input::DescribeAccountAssignmentDeletionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn account_assignment_deletion_request_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.account_assignment_deletion_request_id(inp);
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn set_account_assignment_deletion_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_assignment_deletion_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Returns the list of Amazon Web Services SSO identity store attributes that have been configured to
    /// work with attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This
    /// will not return attributes configured and sent by an external identity provider.
    /// For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstanceAccessControlAttributeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner:
            crate::input::describe_instance_access_control_attribute_configuration_input::Builder,
    }
    impl<C, M, R> DescribeInstanceAccessControlAttributeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::DescribeInstanceAccessControlAttributeConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DescribeInstanceAccessControlAttributeConfigurationInputOperationOutputAlias,
                                    crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput,
                                    crate::error::DescribeInstanceAccessControlAttributeConfigurationError,
                                    crate::input::DescribeInstanceAccessControlAttributeConfigurationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePermissionSet`.
    ///
    /// <p>Gets the details of the permission set.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_permission_set_input::Builder,
    }
    impl<C, M, R> DescribePermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePermissionSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePermissionSetInputOperationOutputAlias,
                crate::output::DescribePermissionSetOutput,
                crate::error::DescribePermissionSetError,
                crate::input::DescribePermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePermissionSetProvisioningStatus`.
    ///
    /// <p>Describes the status for the given permission set provisioning request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePermissionSetProvisioningStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_permission_set_provisioning_status_input::Builder,
    }
    impl<C, M, R> DescribePermissionSetProvisioningStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePermissionSetProvisioningStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePermissionSetProvisioningStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribePermissionSetProvisioningStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePermissionSetProvisioningStatusInputOperationOutputAlias,
                crate::output::DescribePermissionSetProvisioningStatusOutput,
                crate::error::DescribePermissionSetProvisioningStatusError,
                crate::input::DescribePermissionSetProvisioningStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier that is provided by the <a>ProvisionPermissionSet</a> call to
        /// retrieve the current status of the provisioning workflow.</p>
        pub fn provision_permission_set_request_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.provision_permission_set_request_id(inp);
            self
        }
        /// <p>The identifier that is provided by the <a>ProvisionPermissionSet</a> call to
        /// retrieve the current status of the provisioning workflow.</p>
        pub fn set_provision_permission_set_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provision_permission_set_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachManagedPolicyFromPermissionSet`.
    ///
    /// <p>Detaches the attached IAM managed policy ARN from the specified permission set.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachManagedPolicyFromPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_managed_policy_from_permission_set_input::Builder,
    }
    impl<C, M, R> DetachManagedPolicyFromPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachManagedPolicyFromPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachManagedPolicyFromPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DetachManagedPolicyFromPermissionSetError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachManagedPolicyFromPermissionSetInputOperationOutputAlias,
                crate::output::DetachManagedPolicyFromPermissionSetOutput,
                crate::error::DetachManagedPolicyFromPermissionSetError,
                crate::input::DetachManagedPolicyFromPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> from which the policy should be
        /// detached.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> from which the policy should be
        /// detached.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn managed_policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_policy_arn(inp);
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn set_managed_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInlinePolicyForPermissionSet`.
    ///
    /// <p>Obtains the inline policy assigned to the permission set.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInlinePolicyForPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_inline_policy_for_permission_set_input::Builder,
    }
    impl<C, M, R> GetInlinePolicyForPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInlinePolicyForPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInlinePolicyForPermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInlinePolicyForPermissionSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInlinePolicyForPermissionSetInputOperationOutputAlias,
                crate::output::GetInlinePolicyForPermissionSetOutput,
                crate::error::GetInlinePolicyForPermissionSetError,
                crate::input::GetInlinePolicyForPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAssignmentCreationStatus`.
    ///
    /// <p>Lists the status of the Amazon Web Services account assignment creation requests for a specified SSO
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccountAssignmentCreationStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_account_assignment_creation_status_input::Builder,
    }
    impl<C, M, R> ListAccountAssignmentCreationStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountAssignmentCreationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAssignmentCreationStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAccountAssignmentCreationStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountAssignmentCreationStatusInputOperationOutputAlias,
                crate::output::ListAccountAssignmentCreationStatusOutput,
                crate::error::ListAccountAssignmentCreationStatusError,
                crate::input::ListAccountAssignmentCreationStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, inp: crate::model::OperationStatusFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAssignmentDeletionStatus`.
    ///
    /// <p>Lists the status of the Amazon Web Services account assignment deletion requests for a specified SSO
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccountAssignmentDeletionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_account_assignment_deletion_status_input::Builder,
    }
    impl<C, M, R> ListAccountAssignmentDeletionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountAssignmentDeletionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAssignmentDeletionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAccountAssignmentDeletionStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountAssignmentDeletionStatusInputOperationOutputAlias,
                crate::output::ListAccountAssignmentDeletionStatusOutput,
                crate::error::ListAccountAssignmentDeletionStatusError,
                crate::input::ListAccountAssignmentDeletionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, inp: crate::model::OperationStatusFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAssignments`.
    ///
    /// <p>Lists the assignee of the specified Amazon Web Services account with the specified permission
    /// set.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccountAssignments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_account_assignments_input::Builder,
    }
    impl<C, M, R> ListAccountAssignments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountAssignments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAssignmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountAssignmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountAssignmentsInputOperationOutputAlias,
                crate::output::ListAccountAssignmentsOutput,
                crate::error::ListAccountAssignmentsError,
                crate::input::ListAccountAssignmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ARN of the permission set from which to list assignments.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set from which to list assignments.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountsForProvisionedPermissionSet`.
    ///
    /// <p>Lists all the Amazon Web Services accounts where the specified permission set is provisioned.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccountsForProvisionedPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_accounts_for_provisioned_permission_set_input::Builder,
    }
    impl<C, M, R> ListAccountsForProvisionedPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountsForProvisionedPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsForProvisionedPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAccountsForProvisionedPermissionSetError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountsForProvisionedPermissionSetInputOperationOutputAlias,
                crate::output::ListAccountsForProvisionedPermissionSetOutput,
                crate::error::ListAccountsForProvisionedPermissionSetError,
                crate::input::ListAccountsForProvisionedPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> from which the associated Amazon Web Services accounts
        /// will be listed.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> from which the associated Amazon Web Services accounts
        /// will be listed.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
        pub fn provisioning_status(mut self, inp: crate::model::ProvisioningStatus) -> Self {
            self.inner = self.inner.provisioning_status(inp);
            self
        }
        /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::ProvisioningStatus>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_status(input);
            self
        }
        /// <p>The maximum number of results to display for the <a>PermissionSet</a>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the <a>PermissionSet</a>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstances`.
    ///
    /// <p>Lists the SSO instances that the caller has access to.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instances_input::Builder,
    }
    impl<C, M, R> ListInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstancesInputOperationOutputAlias,
                crate::output::ListInstancesOutput,
                crate::error::ListInstancesError,
                crate::input::ListInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to display for the instance.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the instance.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedPoliciesInPermissionSet`.
    ///
    /// <p>Lists the IAM managed policy that is attached to a specified permission set.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListManagedPoliciesInPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_managed_policies_in_permission_set_input::Builder,
    }
    impl<C, M, R> ListManagedPoliciesInPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListManagedPoliciesInPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedPoliciesInPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListManagedPoliciesInPermissionSetError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListManagedPoliciesInPermissionSetInputOperationOutputAlias,
                crate::output::ListManagedPoliciesInPermissionSetOutput,
                crate::error::ListManagedPoliciesInPermissionSetError,
                crate::input::ListManagedPoliciesInPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> whose managed policies will be
        /// listed.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the <a>PermissionSet</a> whose managed policies will be
        /// listed.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the <a>PermissionSet</a>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the <a>PermissionSet</a>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissionSetProvisioningStatus`.
    ///
    /// <p>Lists the status of the permission set provisioning requests for a specified SSO
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPermissionSetProvisioningStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_permission_set_provisioning_status_input::Builder,
    }
    impl<C, M, R> ListPermissionSetProvisioningStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPermissionSetProvisioningStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionSetProvisioningStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListPermissionSetProvisioningStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPermissionSetProvisioningStatusInputOperationOutputAlias,
                crate::output::ListPermissionSetProvisioningStatusOutput,
                crate::error::ListPermissionSetProvisioningStatusError,
                crate::input::ListPermissionSetProvisioningStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, inp: crate::model::OperationStatusFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissionSets`.
    ///
    /// <p>Lists the <a>PermissionSet</a>s in an SSO instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPermissionSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_permission_sets_input::Builder,
    }
    impl<C, M, R> ListPermissionSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPermissionSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPermissionSetsInputOperationOutputAlias,
                crate::output::ListPermissionSetsOutput,
                crate::error::ListPermissionSetsError,
                crate::input::ListPermissionSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissionSetsProvisionedToAccount`.
    ///
    /// <p>Lists all the permission sets that are provisioned to a specified Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPermissionSetsProvisionedToAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_permission_sets_provisioned_to_account_input::Builder,
    }
    impl<C, M, R> ListPermissionSetsProvisionedToAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPermissionSetsProvisionedToAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionSetsProvisionedToAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListPermissionSetsProvisionedToAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPermissionSetsProvisionedToAccountInputOperationOutputAlias,
                crate::output::ListPermissionSetsProvisionedToAccountOutput,
                crate::error::ListPermissionSetsProvisionedToAccountError,
                crate::input::ListPermissionSetsProvisionedToAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The status object for the permission set provisioning operation.</p>
        pub fn provisioning_status(mut self, inp: crate::model::ProvisioningStatus) -> Self {
            self.inner = self.inner.provisioning_status(inp);
            self
        }
        /// <p>The status object for the permission set provisioning operation.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::ProvisioningStatus>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_status(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that are attached to a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvisionPermissionSet`.
    ///
    /// <p>The process by which a specified permission set is provisioned to the specified
    /// target.</p>
    #[derive(std::fmt::Debug)]
    pub struct ProvisionPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::provision_permission_set_input::Builder,
    }
    impl<C, M, R> ProvisionPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ProvisionPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvisionPermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvisionPermissionSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ProvisionPermissionSetInputOperationOutputAlias,
                crate::output::ProvisionPermissionSetOutput,
                crate::error::ProvisionPermissionSetError,
                crate::input::ProvisionPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn target_type(mut self, inp: crate::model::ProvisionTargetType) -> Self {
            self.inner = self.inner.target_type(inp);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionTargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInlinePolicyToPermissionSet`.
    ///
    /// <p>Attaches an IAM inline policy to a permission set.</p>
    /// <note>
    /// <p>If the permission set is already referenced by one or more account assignments, you will
    /// need to call <code>
    /// <a>ProvisionPermissionSet</a>
    /// </code> after this action to
    /// apply the corresponding IAM policy updates to all assigned accounts.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutInlinePolicyToPermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_inline_policy_to_permission_set_input::Builder,
    }
    impl<C, M, R> PutInlinePolicyToPermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutInlinePolicyToPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInlinePolicyToPermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInlinePolicyToPermissionSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutInlinePolicyToPermissionSetInputOperationOutputAlias,
                crate::output::PutInlinePolicyToPermissionSetOutput,
                crate::error::PutInlinePolicyToPermissionSetError,
                crate::input::PutInlinePolicyToPermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The IAM inline policy to attach to a <a>PermissionSet</a>.</p>
        pub fn inline_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.inline_policy(inp);
            self
        }
        /// <p>The IAM inline policy to attach to a <a>PermissionSet</a>.</p>
        pub fn set_inline_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_inline_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a set of tags with a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of key-value pairs that are used to manage the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A set of key-value pairs that are used to manage the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Disassociates a set of tags from a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of tags that are attached to the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of tags that are attached to the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO
    /// instance for attributes-based access control (ABAC). When using an external identity provider
    /// as an identity source, you can pass attributes through the SAML assertion as an alternative to
    /// configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of
    /// these attributes, Amazon Web Services SSO replaces the attribute value with the value from the Amazon Web Services SSO
    /// identity store. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateInstanceAccessControlAttributeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_instance_access_control_attribute_configuration_input::Builder,
    }
    impl<C, M, R> UpdateInstanceAccessControlAttributeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::UpdateInstanceAccessControlAttributeConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::UpdateInstanceAccessControlAttributeConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::UpdateInstanceAccessControlAttributeConfigurationInputOperationOutputAlias,
                                    crate::output::UpdateInstanceAccessControlAttributeConfigurationOutput,
                                    crate::error::UpdateInstanceAccessControlAttributeConfigurationError,
                                    crate::input::UpdateInstanceAccessControlAttributeConfigurationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>Updates the attributes for your ABAC configuration.</p>
        pub fn instance_access_control_attribute_configuration(
            mut self,
            inp: crate::model::InstanceAccessControlAttributeConfiguration,
        ) -> Self {
            self.inner = self
                .inner
                .instance_access_control_attribute_configuration(inp);
            self
        }
        /// <p>Updates the attributes for your ABAC configuration.</p>
        pub fn set_instance_access_control_attribute_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_instance_access_control_attribute_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePermissionSet`.
    ///
    /// <p>Updates an existing permission set.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePermissionSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_permission_set_input::Builder,
    }
    impl<C, M, R> UpdatePermissionSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePermissionSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePermissionSetInputOperationOutputAlias,
                crate::output::UpdatePermissionSetOutput,
                crate::error::UpdatePermissionSetError,
                crate::input::UpdatePermissionSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(inp);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The description of the <a>PermissionSet</a>.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the <a>PermissionSet</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601
        /// standard.</p>
        pub fn session_duration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_duration(inp);
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601
        /// standard.</p>
        pub fn set_session_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_duration(input);
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication
        /// process.</p>
        pub fn relay_state(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relay_state(inp);
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication
        /// process.</p>
        pub fn set_relay_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_relay_state(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
