// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AttachManagedPolicyToPermissionSetInput`](crate::input::AttachManagedPolicyToPermissionSetInput)
pub mod attach_managed_policy_to_permission_set_input {
    /// A builder for [`AttachManagedPolicyToPermissionSetInput`](crate::input::AttachManagedPolicyToPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) managed_policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> that the managed policy should be attached to.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> that the managed policy should be attached to.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn managed_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_policy_arn = Some(input.into());
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn set_managed_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachManagedPolicyToPermissionSetInput`](crate::input::AttachManagedPolicyToPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachManagedPolicyToPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachManagedPolicyToPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
                managed_policy_arn: self.managed_policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachManagedPolicyToPermissionSetInputOperationOutputAlias =
    crate::operation::AttachManagedPolicyToPermissionSet;
#[doc(hidden)]
pub type AttachManagedPolicyToPermissionSetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AttachManagedPolicyToPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`AttachManagedPolicyToPermissionSet`](crate::operation::AttachManagedPolicyToPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachManagedPolicyToPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachManagedPolicyToPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachManagedPolicyToPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.AttachManagedPolicyToPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_managed_policy_to_permission_set(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachManagedPolicyToPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachManagedPolicyToPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachManagedPolicyToPermissionSetInput`](crate::input::AttachManagedPolicyToPermissionSetInput)
    pub fn builder() -> crate::input::attach_managed_policy_to_permission_set_input::Builder {
        crate::input::attach_managed_policy_to_permission_set_input::Builder::default()
    }
}

/// See [`CreateAccountAssignmentInput`](crate::input::CreateAccountAssignmentInput)
pub mod create_account_assignment_input {
    /// A builder for [`CreateAccountAssignmentInput`](crate::input::CreateAccountAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<crate::model::TargetType>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The ARN of the permission set that the admin wants to grant the principal access to.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set that the admin wants to grant the principal access to.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountAssignmentInput`](crate::input::CreateAccountAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccountAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccountAssignmentInput {
                instance_arn: self.instance_arn,
                target_id: self.target_id,
                target_type: self.target_type,
                permission_set_arn: self.permission_set_arn,
                principal_type: self.principal_type,
                principal_id: self.principal_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccountAssignmentInputOperationOutputAlias =
    crate::operation::CreateAccountAssignment;
#[doc(hidden)]
pub type CreateAccountAssignmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAccountAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccountAssignment`](crate::operation::CreateAccountAssignment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccountAssignment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAccountAssignmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAccountAssignmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.CreateAccountAssignment",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_account_assignment(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccountAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccountAssignment",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAccountAssignmentInput`](crate::input::CreateAccountAssignmentInput)
    pub fn builder() -> crate::input::create_account_assignment_input::Builder {
        crate::input::create_account_assignment_input::Builder::default()
    }
}

/// See [`CreateInstanceAccessControlAttributeConfigurationInput`](crate::input::CreateInstanceAccessControlAttributeConfigurationInput)
pub mod create_instance_access_control_attribute_configuration_input {
    /// A builder for [`CreateInstanceAccessControlAttributeConfigurationInput`](crate::input::CreateInstanceAccessControlAttributeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) instance_access_control_attribute_configuration:
            std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>
        pub fn instance_access_control_attribute_configuration(
            mut self,
            input: crate::model::InstanceAccessControlAttributeConfiguration,
        ) -> Self {
            self.instance_access_control_attribute_configuration = Some(input);
            self
        }
        /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>
        pub fn set_instance_access_control_attribute_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
        ) -> Self {
            self.instance_access_control_attribute_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceAccessControlAttributeConfigurationInput`](crate::input::CreateInstanceAccessControlAttributeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceAccessControlAttributeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::CreateInstanceAccessControlAttributeConfigurationInput {
                    instance_arn: self.instance_arn,
                    instance_access_control_attribute_configuration: self
                        .instance_access_control_attribute_configuration,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceAccessControlAttributeConfigurationInputOperationOutputAlias =
    crate::operation::CreateInstanceAccessControlAttributeConfiguration;
#[doc(hidden)]
pub type CreateInstanceAccessControlAttributeConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstanceAccessControlAttributeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstanceAccessControlAttributeConfiguration`](crate::operation::CreateInstanceAccessControlAttributeConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstanceAccessControlAttributeConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInstanceAccessControlAttributeConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInstanceAccessControlAttributeConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.CreateInstanceAccessControlAttributeConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_instance_access_control_attribute_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstanceAccessControlAttributeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstanceAccessControlAttributeConfiguration",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceAccessControlAttributeConfigurationInput`](crate::input::CreateInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::create_instance_access_control_attribute_configuration_input::Builder {
        crate::input::create_instance_access_control_attribute_configuration_input::Builder::default(
        )
    }
}

/// See [`CreatePermissionSetInput`](crate::input::CreatePermissionSetInput)
pub mod create_permission_set_input {
    /// A builder for [`CreatePermissionSetInput`](crate::input::CreatePermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) session_duration: std::option::Option<std::string::String>,
        pub(crate) relay_state: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the <code>PermissionSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>PermissionSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>
        pub fn session_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_duration = Some(input.into());
            self
        }
        /// <p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>
        pub fn set_session_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_duration = input;
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn relay_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.relay_state = Some(input.into());
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn set_relay_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.relay_state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new <code>PermissionSet</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the new <code>PermissionSet</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePermissionSetInput`](crate::input::CreatePermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePermissionSetInput {
                name: self.name,
                description: self.description,
                instance_arn: self.instance_arn,
                session_duration: self.session_duration,
                relay_state: self.relay_state,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePermissionSetInputOperationOutputAlias = crate::operation::CreatePermissionSet;
#[doc(hidden)]
pub type CreatePermissionSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`CreatePermissionSet`](crate::operation::CreatePermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.CreatePermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_permission_set(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePermissionSetInput`](crate::input::CreatePermissionSetInput)
    pub fn builder() -> crate::input::create_permission_set_input::Builder {
        crate::input::create_permission_set_input::Builder::default()
    }
}

/// See [`DeleteAccountAssignmentInput`](crate::input::DeleteAccountAssignmentInput)
pub mod delete_account_assignment_input {
    /// A builder for [`DeleteAccountAssignmentInput`](crate::input::DeleteAccountAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<crate::model::TargetType>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountAssignmentInput`](crate::input::DeleteAccountAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccountAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccountAssignmentInput {
                instance_arn: self.instance_arn,
                target_id: self.target_id,
                target_type: self.target_type,
                permission_set_arn: self.permission_set_arn,
                principal_type: self.principal_type,
                principal_id: self.principal_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccountAssignmentInputOperationOutputAlias =
    crate::operation::DeleteAccountAssignment;
#[doc(hidden)]
pub type DeleteAccountAssignmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccountAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccountAssignment`](crate::operation::DeleteAccountAssignment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccountAssignment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAccountAssignmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAccountAssignmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DeleteAccountAssignment",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_account_assignment(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccountAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccountAssignment",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccountAssignmentInput`](crate::input::DeleteAccountAssignmentInput)
    pub fn builder() -> crate::input::delete_account_assignment_input::Builder {
        crate::input::delete_account_assignment_input::Builder::default()
    }
}

/// See [`DeleteInlinePolicyFromPermissionSetInput`](crate::input::DeleteInlinePolicyFromPermissionSetInput)
pub mod delete_inline_policy_from_permission_set_input {
    /// A builder for [`DeleteInlinePolicyFromPermissionSetInput`](crate::input::DeleteInlinePolicyFromPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInlinePolicyFromPermissionSetInput`](crate::input::DeleteInlinePolicyFromPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInlinePolicyFromPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInlinePolicyFromPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInlinePolicyFromPermissionSetInputOperationOutputAlias =
    crate::operation::DeleteInlinePolicyFromPermissionSet;
#[doc(hidden)]
pub type DeleteInlinePolicyFromPermissionSetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInlinePolicyFromPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInlinePolicyFromPermissionSet`](crate::operation::DeleteInlinePolicyFromPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInlinePolicyFromPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInlinePolicyFromPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInlinePolicyFromPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DeleteInlinePolicyFromPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_inline_policy_from_permission_set(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInlinePolicyFromPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInlinePolicyFromPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInlinePolicyFromPermissionSetInput`](crate::input::DeleteInlinePolicyFromPermissionSetInput)
    pub fn builder() -> crate::input::delete_inline_policy_from_permission_set_input::Builder {
        crate::input::delete_inline_policy_from_permission_set_input::Builder::default()
    }
}

/// See [`DeleteInstanceAccessControlAttributeConfigurationInput`](crate::input::DeleteInstanceAccessControlAttributeConfigurationInput)
pub mod delete_instance_access_control_attribute_configuration_input {
    /// A builder for [`DeleteInstanceAccessControlAttributeConfigurationInput`](crate::input::DeleteInstanceAccessControlAttributeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstanceAccessControlAttributeConfigurationInput`](crate::input::DeleteInstanceAccessControlAttributeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInstanceAccessControlAttributeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteInstanceAccessControlAttributeConfigurationInput {
                    instance_arn: self.instance_arn,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteInstanceAccessControlAttributeConfigurationInputOperationOutputAlias =
    crate::operation::DeleteInstanceAccessControlAttributeConfiguration;
#[doc(hidden)]
pub type DeleteInstanceAccessControlAttributeConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInstanceAccessControlAttributeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInstanceAccessControlAttributeConfiguration`](crate::operation::DeleteInstanceAccessControlAttributeConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInstanceAccessControlAttributeConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInstanceAccessControlAttributeConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInstanceAccessControlAttributeConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DeleteInstanceAccessControlAttributeConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_instance_access_control_attribute_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInstanceAccessControlAttributeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInstanceAccessControlAttributeConfiguration",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInstanceAccessControlAttributeConfigurationInput`](crate::input::DeleteInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::delete_instance_access_control_attribute_configuration_input::Builder {
        crate::input::delete_instance_access_control_attribute_configuration_input::Builder::default(
        )
    }
}

/// See [`DeletePermissionSetInput`](crate::input::DeletePermissionSetInput)
pub mod delete_permission_set_input {
    /// A builder for [`DeletePermissionSetInput`](crate::input::DeletePermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the permission set that should be deleted.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set that should be deleted.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePermissionSetInput`](crate::input::DeletePermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePermissionSetInputOperationOutputAlias = crate::operation::DeletePermissionSet;
#[doc(hidden)]
pub type DeletePermissionSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`DeletePermissionSet`](crate::operation::DeletePermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DeletePermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_permission_set(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePermissionSetInput`](crate::input::DeletePermissionSetInput)
    pub fn builder() -> crate::input::delete_permission_set_input::Builder {
        crate::input::delete_permission_set_input::Builder::default()
    }
}

/// See [`DescribeAccountAssignmentCreationStatusInput`](crate::input::DescribeAccountAssignmentCreationStatusInput)
pub mod describe_account_assignment_creation_status_input {
    /// A builder for [`DescribeAccountAssignmentCreationStatusInput`](crate::input::DescribeAccountAssignmentCreationStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) account_assignment_creation_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn account_assignment_creation_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.account_assignment_creation_request_id = Some(input.into());
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn set_account_assignment_creation_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_assignment_creation_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAssignmentCreationStatusInput`](crate::input::DescribeAccountAssignmentCreationStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAssignmentCreationStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAssignmentCreationStatusInput {
                instance_arn: self.instance_arn,
                account_assignment_creation_request_id: self.account_assignment_creation_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAssignmentCreationStatusInputOperationOutputAlias =
    crate::operation::DescribeAccountAssignmentCreationStatus;
#[doc(hidden)]
pub type DescribeAccountAssignmentCreationStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountAssignmentCreationStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAssignmentCreationStatus`](crate::operation::DescribeAccountAssignmentCreationStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAssignmentCreationStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountAssignmentCreationStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountAssignmentCreationStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DescribeAccountAssignmentCreationStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_assignment_creation_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAssignmentCreationStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAssignmentCreationStatus",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAssignmentCreationStatusInput`](crate::input::DescribeAccountAssignmentCreationStatusInput)
    pub fn builder() -> crate::input::describe_account_assignment_creation_status_input::Builder {
        crate::input::describe_account_assignment_creation_status_input::Builder::default()
    }
}

/// See [`DescribeAccountAssignmentDeletionStatusInput`](crate::input::DescribeAccountAssignmentDeletionStatusInput)
pub mod describe_account_assignment_deletion_status_input {
    /// A builder for [`DescribeAccountAssignmentDeletionStatusInput`](crate::input::DescribeAccountAssignmentDeletionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) account_assignment_deletion_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn account_assignment_deletion_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.account_assignment_deletion_request_id = Some(input.into());
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn set_account_assignment_deletion_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_assignment_deletion_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAssignmentDeletionStatusInput`](crate::input::DescribeAccountAssignmentDeletionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAssignmentDeletionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAssignmentDeletionStatusInput {
                instance_arn: self.instance_arn,
                account_assignment_deletion_request_id: self.account_assignment_deletion_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAssignmentDeletionStatusInputOperationOutputAlias =
    crate::operation::DescribeAccountAssignmentDeletionStatus;
#[doc(hidden)]
pub type DescribeAccountAssignmentDeletionStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountAssignmentDeletionStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAssignmentDeletionStatus`](crate::operation::DescribeAccountAssignmentDeletionStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAssignmentDeletionStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountAssignmentDeletionStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountAssignmentDeletionStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DescribeAccountAssignmentDeletionStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_assignment_deletion_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAssignmentDeletionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAssignmentDeletionStatus",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAssignmentDeletionStatusInput`](crate::input::DescribeAccountAssignmentDeletionStatusInput)
    pub fn builder() -> crate::input::describe_account_assignment_deletion_status_input::Builder {
        crate::input::describe_account_assignment_deletion_status_input::Builder::default()
    }
}

/// See [`DescribeInstanceAccessControlAttributeConfigurationInput`](crate::input::DescribeInstanceAccessControlAttributeConfigurationInput)
pub mod describe_instance_access_control_attribute_configuration_input {
    /// A builder for [`DescribeInstanceAccessControlAttributeConfigurationInput`](crate::input::DescribeInstanceAccessControlAttributeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceAccessControlAttributeConfigurationInput`](crate::input::DescribeInstanceAccessControlAttributeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceAccessControlAttributeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeInstanceAccessControlAttributeConfigurationInput {
                    instance_arn: self.instance_arn,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceAccessControlAttributeConfigurationInputOperationOutputAlias =
    crate::operation::DescribeInstanceAccessControlAttributeConfiguration;
#[doc(hidden)]
pub type DescribeInstanceAccessControlAttributeConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstanceAccessControlAttributeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceAccessControlAttributeConfiguration`](crate::operation::DescribeInstanceAccessControlAttributeConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceAccessControlAttributeConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInstanceAccessControlAttributeConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInstanceAccessControlAttributeConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DescribeInstanceAccessControlAttributeConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_access_control_attribute_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceAccessControlAttributeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceAccessControlAttributeConfiguration",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAccessControlAttributeConfigurationInput`](crate::input::DescribeInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::describe_instance_access_control_attribute_configuration_input::Builder {
        crate::input::describe_instance_access_control_attribute_configuration_input::Builder::default()
    }
}

/// See [`DescribePermissionSetInput`](crate::input::DescribePermissionSetInput)
pub mod describe_permission_set_input {
    /// A builder for [`DescribePermissionSetInput`](crate::input::DescribePermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePermissionSetInput`](crate::input::DescribePermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePermissionSetInputOperationOutputAlias = crate::operation::DescribePermissionSet;
#[doc(hidden)]
pub type DescribePermissionSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribePermissionSet`](crate::operation::DescribePermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DescribePermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_permission_set(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePermissionSetInput`](crate::input::DescribePermissionSetInput)
    pub fn builder() -> crate::input::describe_permission_set_input::Builder {
        crate::input::describe_permission_set_input::Builder::default()
    }
}

/// See [`DescribePermissionSetProvisioningStatusInput`](crate::input::DescribePermissionSetProvisioningStatusInput)
pub mod describe_permission_set_provisioning_status_input {
    /// A builder for [`DescribePermissionSetProvisioningStatusInput`](crate::input::DescribePermissionSetProvisioningStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) provision_permission_set_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The identifier that is provided by the <code>ProvisionPermissionSet</code> call to retrieve the current status of the provisioning workflow.</p>
        pub fn provision_permission_set_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.provision_permission_set_request_id = Some(input.into());
            self
        }
        /// <p>The identifier that is provided by the <code>ProvisionPermissionSet</code> call to retrieve the current status of the provisioning workflow.</p>
        pub fn set_provision_permission_set_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_permission_set_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePermissionSetProvisioningStatusInput`](crate::input::DescribePermissionSetProvisioningStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePermissionSetProvisioningStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePermissionSetProvisioningStatusInput {
                instance_arn: self.instance_arn,
                provision_permission_set_request_id: self.provision_permission_set_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePermissionSetProvisioningStatusInputOperationOutputAlias =
    crate::operation::DescribePermissionSetProvisioningStatus;
#[doc(hidden)]
pub type DescribePermissionSetProvisioningStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribePermissionSetProvisioningStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribePermissionSetProvisioningStatus`](crate::operation::DescribePermissionSetProvisioningStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePermissionSetProvisioningStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePermissionSetProvisioningStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePermissionSetProvisioningStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DescribePermissionSetProvisioningStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_permission_set_provisioning_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePermissionSetProvisioningStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePermissionSetProvisioningStatus",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePermissionSetProvisioningStatusInput`](crate::input::DescribePermissionSetProvisioningStatusInput)
    pub fn builder() -> crate::input::describe_permission_set_provisioning_status_input::Builder {
        crate::input::describe_permission_set_provisioning_status_input::Builder::default()
    }
}

/// See [`DetachManagedPolicyFromPermissionSetInput`](crate::input::DetachManagedPolicyFromPermissionSetInput)
pub mod detach_managed_policy_from_permission_set_input {
    /// A builder for [`DetachManagedPolicyFromPermissionSetInput`](crate::input::DetachManagedPolicyFromPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) managed_policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the policy should be detached.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the policy should be detached.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn managed_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_policy_arn = Some(input.into());
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn set_managed_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachManagedPolicyFromPermissionSetInput`](crate::input::DetachManagedPolicyFromPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachManagedPolicyFromPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachManagedPolicyFromPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
                managed_policy_arn: self.managed_policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachManagedPolicyFromPermissionSetInputOperationOutputAlias =
    crate::operation::DetachManagedPolicyFromPermissionSet;
#[doc(hidden)]
pub type DetachManagedPolicyFromPermissionSetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DetachManagedPolicyFromPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`DetachManagedPolicyFromPermissionSet`](crate::operation::DetachManagedPolicyFromPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachManagedPolicyFromPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachManagedPolicyFromPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachManagedPolicyFromPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.DetachManagedPolicyFromPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_managed_policy_from_permission_set(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachManagedPolicyFromPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachManagedPolicyFromPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachManagedPolicyFromPermissionSetInput`](crate::input::DetachManagedPolicyFromPermissionSetInput)
    pub fn builder() -> crate::input::detach_managed_policy_from_permission_set_input::Builder {
        crate::input::detach_managed_policy_from_permission_set_input::Builder::default()
    }
}

/// See [`GetInlinePolicyForPermissionSetInput`](crate::input::GetInlinePolicyForPermissionSetInput)
pub mod get_inline_policy_for_permission_set_input {
    /// A builder for [`GetInlinePolicyForPermissionSetInput`](crate::input::GetInlinePolicyForPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInlinePolicyForPermissionSetInput`](crate::input::GetInlinePolicyForPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInlinePolicyForPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInlinePolicyForPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInlinePolicyForPermissionSetInputOperationOutputAlias =
    crate::operation::GetInlinePolicyForPermissionSet;
#[doc(hidden)]
pub type GetInlinePolicyForPermissionSetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetInlinePolicyForPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`GetInlinePolicyForPermissionSet`](crate::operation::GetInlinePolicyForPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInlinePolicyForPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInlinePolicyForPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInlinePolicyForPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.GetInlinePolicyForPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_inline_policy_for_permission_set(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInlinePolicyForPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInlinePolicyForPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInlinePolicyForPermissionSetInput`](crate::input::GetInlinePolicyForPermissionSetInput)
    pub fn builder() -> crate::input::get_inline_policy_for_permission_set_input::Builder {
        crate::input::get_inline_policy_for_permission_set_input::Builder::default()
    }
}

/// See [`ListAccountAssignmentCreationStatusInput`](crate::input::ListAccountAssignmentCreationStatusInput)
pub mod list_account_assignment_creation_status_input {
    /// A builder for [`ListAccountAssignmentCreationStatusInput`](crate::input::ListAccountAssignmentCreationStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::OperationStatusFilter>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, input: crate::model::OperationStatusFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAssignmentCreationStatusInput`](crate::input::ListAccountAssignmentCreationStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountAssignmentCreationStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountAssignmentCreationStatusInput {
                instance_arn: self.instance_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountAssignmentCreationStatusInputOperationOutputAlias =
    crate::operation::ListAccountAssignmentCreationStatus;
#[doc(hidden)]
pub type ListAccountAssignmentCreationStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAccountAssignmentCreationStatusInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountAssignmentCreationStatus`](crate::operation::ListAccountAssignmentCreationStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountAssignmentCreationStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAccountAssignmentCreationStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAccountAssignmentCreationStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListAccountAssignmentCreationStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_account_assignment_creation_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountAssignmentCreationStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountAssignmentCreationStatus",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAccountAssignmentCreationStatusInput`](crate::input::ListAccountAssignmentCreationStatusInput)
    pub fn builder() -> crate::input::list_account_assignment_creation_status_input::Builder {
        crate::input::list_account_assignment_creation_status_input::Builder::default()
    }
}

/// See [`ListAccountAssignmentDeletionStatusInput`](crate::input::ListAccountAssignmentDeletionStatusInput)
pub mod list_account_assignment_deletion_status_input {
    /// A builder for [`ListAccountAssignmentDeletionStatusInput`](crate::input::ListAccountAssignmentDeletionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::OperationStatusFilter>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, input: crate::model::OperationStatusFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAssignmentDeletionStatusInput`](crate::input::ListAccountAssignmentDeletionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountAssignmentDeletionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountAssignmentDeletionStatusInput {
                instance_arn: self.instance_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountAssignmentDeletionStatusInputOperationOutputAlias =
    crate::operation::ListAccountAssignmentDeletionStatus;
#[doc(hidden)]
pub type ListAccountAssignmentDeletionStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAccountAssignmentDeletionStatusInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountAssignmentDeletionStatus`](crate::operation::ListAccountAssignmentDeletionStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountAssignmentDeletionStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAccountAssignmentDeletionStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAccountAssignmentDeletionStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListAccountAssignmentDeletionStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_account_assignment_deletion_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountAssignmentDeletionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountAssignmentDeletionStatus",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAccountAssignmentDeletionStatusInput`](crate::input::ListAccountAssignmentDeletionStatusInput)
    pub fn builder() -> crate::input::list_account_assignment_deletion_status_input::Builder {
        crate::input::list_account_assignment_deletion_status_input::Builder::default()
    }
}

/// See [`ListAccountAssignmentsInput`](crate::input::ListAccountAssignmentsInput)
pub mod list_account_assignments_input {
    /// A builder for [`ListAccountAssignmentsInput`](crate::input::ListAccountAssignmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ARN of the permission set from which to list assignments.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set from which to list assignments.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAssignmentsInput`](crate::input::ListAccountAssignmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountAssignmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountAssignmentsInput {
                instance_arn: self.instance_arn,
                account_id: self.account_id,
                permission_set_arn: self.permission_set_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountAssignmentsInputOperationOutputAlias = crate::operation::ListAccountAssignments;
#[doc(hidden)]
pub type ListAccountAssignmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccountAssignmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountAssignments`](crate::operation::ListAccountAssignments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountAssignments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAccountAssignmentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAccountAssignmentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListAccountAssignments",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_account_assignments(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountAssignments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountAssignments",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAccountAssignmentsInput`](crate::input::ListAccountAssignmentsInput)
    pub fn builder() -> crate::input::list_account_assignments_input::Builder {
        crate::input::list_account_assignments_input::Builder::default()
    }
}

/// See [`ListAccountsForProvisionedPermissionSetInput`](crate::input::ListAccountsForProvisionedPermissionSetInput)
pub mod list_accounts_for_provisioned_permission_set_input {
    /// A builder for [`ListAccountsForProvisionedPermissionSetInput`](crate::input::ListAccountsForProvisionedPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) provisioning_status: std::option::Option<crate::model::ProvisioningStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the associated Amazon Web Services accounts will be listed.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the associated Amazon Web Services accounts will be listed.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
        pub fn provisioning_status(mut self, input: crate::model::ProvisioningStatus) -> Self {
            self.provisioning_status = Some(input);
            self
        }
        /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::ProvisioningStatus>,
        ) -> Self {
            self.provisioning_status = input;
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountsForProvisionedPermissionSetInput`](crate::input::ListAccountsForProvisionedPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountsForProvisionedPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountsForProvisionedPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
                provisioning_status: self.provisioning_status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountsForProvisionedPermissionSetInputOperationOutputAlias =
    crate::operation::ListAccountsForProvisionedPermissionSet;
#[doc(hidden)]
pub type ListAccountsForProvisionedPermissionSetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAccountsForProvisionedPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountsForProvisionedPermissionSet`](crate::operation::ListAccountsForProvisionedPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountsForProvisionedPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAccountsForProvisionedPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAccountsForProvisionedPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListAccountsForProvisionedPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_accounts_for_provisioned_permission_set(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountsForProvisionedPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountsForProvisionedPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAccountsForProvisionedPermissionSetInput`](crate::input::ListAccountsForProvisionedPermissionSetInput)
    pub fn builder() -> crate::input::list_accounts_for_provisioned_permission_set_input::Builder {
        crate::input::list_accounts_for_provisioned_permission_set_input::Builder::default()
    }
}

/// See [`ListInstancesInput`](crate::input::ListInstancesInput)
pub mod list_instances_input {
    /// A builder for [`ListInstancesInput`](crate::input::ListInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to display for the instance.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the instance.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstancesInput`](crate::input::ListInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstancesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstancesInputOperationOutputAlias = crate::operation::ListInstances;
#[doc(hidden)]
pub type ListInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListInstances`](crate::operation::ListInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListInstances",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_instances(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstances",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListInstancesInput`](crate::input::ListInstancesInput)
    pub fn builder() -> crate::input::list_instances_input::Builder {
        crate::input::list_instances_input::Builder::default()
    }
}

/// See [`ListManagedPoliciesInPermissionSetInput`](crate::input::ListManagedPoliciesInPermissionSetInput)
pub mod list_managed_policies_in_permission_set_input {
    /// A builder for [`ListManagedPoliciesInPermissionSetInput`](crate::input::ListManagedPoliciesInPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> whose managed policies will be listed.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> whose managed policies will be listed.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListManagedPoliciesInPermissionSetInput`](crate::input::ListManagedPoliciesInPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListManagedPoliciesInPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListManagedPoliciesInPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListManagedPoliciesInPermissionSetInputOperationOutputAlias =
    crate::operation::ListManagedPoliciesInPermissionSet;
#[doc(hidden)]
pub type ListManagedPoliciesInPermissionSetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListManagedPoliciesInPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`ListManagedPoliciesInPermissionSet`](crate::operation::ListManagedPoliciesInPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListManagedPoliciesInPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListManagedPoliciesInPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListManagedPoliciesInPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListManagedPoliciesInPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_managed_policies_in_permission_set(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListManagedPoliciesInPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListManagedPoliciesInPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListManagedPoliciesInPermissionSetInput`](crate::input::ListManagedPoliciesInPermissionSetInput)
    pub fn builder() -> crate::input::list_managed_policies_in_permission_set_input::Builder {
        crate::input::list_managed_policies_in_permission_set_input::Builder::default()
    }
}

/// See [`ListPermissionSetProvisioningStatusInput`](crate::input::ListPermissionSetProvisioningStatusInput)
pub mod list_permission_set_provisioning_status_input {
    /// A builder for [`ListPermissionSetProvisioningStatusInput`](crate::input::ListPermissionSetProvisioningStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::OperationStatusFilter>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, input: crate::model::OperationStatusFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionSetProvisioningStatusInput`](crate::input::ListPermissionSetProvisioningStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionSetProvisioningStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionSetProvisioningStatusInput {
                instance_arn: self.instance_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionSetProvisioningStatusInputOperationOutputAlias =
    crate::operation::ListPermissionSetProvisioningStatus;
#[doc(hidden)]
pub type ListPermissionSetProvisioningStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListPermissionSetProvisioningStatusInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissionSetProvisioningStatus`](crate::operation::ListPermissionSetProvisioningStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissionSetProvisioningStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPermissionSetProvisioningStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPermissionSetProvisioningStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListPermissionSetProvisioningStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_permission_set_provisioning_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissionSetProvisioningStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissionSetProvisioningStatus",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionSetProvisioningStatusInput`](crate::input::ListPermissionSetProvisioningStatusInput)
    pub fn builder() -> crate::input::list_permission_set_provisioning_status_input::Builder {
        crate::input::list_permission_set_provisioning_status_input::Builder::default()
    }
}

/// See [`ListPermissionSetsInput`](crate::input::ListPermissionSetsInput)
pub mod list_permission_sets_input {
    /// A builder for [`ListPermissionSetsInput`](crate::input::ListPermissionSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionSetsInput`](crate::input::ListPermissionSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionSetsInput {
                instance_arn: self.instance_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionSetsInputOperationOutputAlias = crate::operation::ListPermissionSets;
#[doc(hidden)]
pub type ListPermissionSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPermissionSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissionSets`](crate::operation::ListPermissionSets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissionSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPermissionSetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPermissionSetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListPermissionSets",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_permission_sets(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissionSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissionSets",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionSetsInput`](crate::input::ListPermissionSetsInput)
    pub fn builder() -> crate::input::list_permission_sets_input::Builder {
        crate::input::list_permission_sets_input::Builder::default()
    }
}

/// See [`ListPermissionSetsProvisionedToAccountInput`](crate::input::ListPermissionSetsProvisionedToAccountInput)
pub mod list_permission_sets_provisioned_to_account_input {
    /// A builder for [`ListPermissionSetsProvisionedToAccountInput`](crate::input::ListPermissionSetsProvisionedToAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_status: std::option::Option<crate::model::ProvisioningStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The status object for the permission set provisioning operation.</p>
        pub fn provisioning_status(mut self, input: crate::model::ProvisioningStatus) -> Self {
            self.provisioning_status = Some(input);
            self
        }
        /// <p>The status object for the permission set provisioning operation.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::ProvisioningStatus>,
        ) -> Self {
            self.provisioning_status = input;
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionSetsProvisionedToAccountInput`](crate::input::ListPermissionSetsProvisionedToAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionSetsProvisionedToAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionSetsProvisionedToAccountInput {
                instance_arn: self.instance_arn,
                account_id: self.account_id,
                provisioning_status: self.provisioning_status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionSetsProvisionedToAccountInputOperationOutputAlias =
    crate::operation::ListPermissionSetsProvisionedToAccount;
#[doc(hidden)]
pub type ListPermissionSetsProvisionedToAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListPermissionSetsProvisionedToAccountInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissionSetsProvisionedToAccount`](crate::operation::ListPermissionSetsProvisionedToAccount)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissionSetsProvisionedToAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPermissionSetsProvisionedToAccountInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPermissionSetsProvisionedToAccountInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListPermissionSetsProvisionedToAccount",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_permission_sets_provisioned_to_account(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissionSetsProvisionedToAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissionSetsProvisionedToAccount",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionSetsProvisionedToAccountInput`](crate::input::ListPermissionSetsProvisionedToAccountInput)
    pub fn builder() -> crate::input::list_permission_sets_provisioned_to_account_input::Builder {
        crate::input::list_permission_sets_provisioned_to_account_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                instance_arn: self.instance_arn,
                resource_arn: self.resource_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ProvisionPermissionSetInput`](crate::input::ProvisionPermissionSetInput)
pub mod provision_permission_set_input {
    /// A builder for [`ProvisionPermissionSetInput`](crate::input::ProvisionPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<crate::model::ProvisionTargetType>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn target_type(mut self, input: crate::model::ProvisionTargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionTargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionPermissionSetInput`](crate::input::ProvisionPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ProvisionPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ProvisionPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
                target_id: self.target_id,
                target_type: self.target_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ProvisionPermissionSetInputOperationOutputAlias = crate::operation::ProvisionPermissionSet;
#[doc(hidden)]
pub type ProvisionPermissionSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ProvisionPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`ProvisionPermissionSet`](crate::operation::ProvisionPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ProvisionPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ProvisionPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ProvisionPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.ProvisionPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_provision_permission_set(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ProvisionPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ProvisionPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ProvisionPermissionSetInput`](crate::input::ProvisionPermissionSetInput)
    pub fn builder() -> crate::input::provision_permission_set_input::Builder {
        crate::input::provision_permission_set_input::Builder::default()
    }
}

/// See [`PutInlinePolicyToPermissionSetInput`](crate::input::PutInlinePolicyToPermissionSetInput)
pub mod put_inline_policy_to_permission_set_input {
    /// A builder for [`PutInlinePolicyToPermissionSetInput`](crate::input::PutInlinePolicyToPermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) inline_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The IAM inline policy to attach to a <code>PermissionSet</code>.</p>
        pub fn inline_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inline_policy = Some(input.into());
            self
        }
        /// <p>The IAM inline policy to attach to a <code>PermissionSet</code>.</p>
        pub fn set_inline_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inline_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInlinePolicyToPermissionSetInput`](crate::input::PutInlinePolicyToPermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutInlinePolicyToPermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutInlinePolicyToPermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
                inline_policy: self.inline_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutInlinePolicyToPermissionSetInputOperationOutputAlias =
    crate::operation::PutInlinePolicyToPermissionSet;
#[doc(hidden)]
pub type PutInlinePolicyToPermissionSetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutInlinePolicyToPermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`PutInlinePolicyToPermissionSet`](crate::operation::PutInlinePolicyToPermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutInlinePolicyToPermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutInlinePolicyToPermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutInlinePolicyToPermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.PutInlinePolicyToPermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_inline_policy_to_permission_set(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutInlinePolicyToPermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutInlinePolicyToPermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutInlinePolicyToPermissionSetInput`](crate::input::PutInlinePolicyToPermissionSetInput)
    pub fn builder() -> crate::input::put_inline_policy_to_permission_set_input::Builder {
        crate::input::put_inline_policy_to_permission_set_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of key-value pairs that are used to manage the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A set of key-value pairs that are used to manage the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                instance_arn: self.instance_arn,
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of tags that are attached to the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of tags that are attached to the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                instance_arn: self.instance_arn,
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateInstanceAccessControlAttributeConfigurationInput`](crate::input::UpdateInstanceAccessControlAttributeConfigurationInput)
pub mod update_instance_access_control_attribute_configuration_input {
    /// A builder for [`UpdateInstanceAccessControlAttributeConfigurationInput`](crate::input::UpdateInstanceAccessControlAttributeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) instance_access_control_attribute_configuration:
            std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>Updates the attributes for your ABAC configuration.</p>
        pub fn instance_access_control_attribute_configuration(
            mut self,
            input: crate::model::InstanceAccessControlAttributeConfiguration,
        ) -> Self {
            self.instance_access_control_attribute_configuration = Some(input);
            self
        }
        /// <p>Updates the attributes for your ABAC configuration.</p>
        pub fn set_instance_access_control_attribute_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
        ) -> Self {
            self.instance_access_control_attribute_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInstanceAccessControlAttributeConfigurationInput`](crate::input::UpdateInstanceAccessControlAttributeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInstanceAccessControlAttributeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::UpdateInstanceAccessControlAttributeConfigurationInput {
                    instance_arn: self.instance_arn,
                    instance_access_control_attribute_configuration: self
                        .instance_access_control_attribute_configuration,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type UpdateInstanceAccessControlAttributeConfigurationInputOperationOutputAlias =
    crate::operation::UpdateInstanceAccessControlAttributeConfiguration;
#[doc(hidden)]
pub type UpdateInstanceAccessControlAttributeConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInstanceAccessControlAttributeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInstanceAccessControlAttributeConfiguration`](crate::operation::UpdateInstanceAccessControlAttributeConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInstanceAccessControlAttributeConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateInstanceAccessControlAttributeConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateInstanceAccessControlAttributeConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.UpdateInstanceAccessControlAttributeConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_instance_access_control_attribute_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInstanceAccessControlAttributeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInstanceAccessControlAttributeConfiguration",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateInstanceAccessControlAttributeConfigurationInput`](crate::input::UpdateInstanceAccessControlAttributeConfigurationInput)
    pub fn builder(
    ) -> crate::input::update_instance_access_control_attribute_configuration_input::Builder {
        crate::input::update_instance_access_control_attribute_configuration_input::Builder::default(
        )
    }
}

/// See [`UpdatePermissionSetInput`](crate::input::UpdatePermissionSetInput)
pub mod update_permission_set_input {
    /// A builder for [`UpdatePermissionSetInput`](crate::input::UpdatePermissionSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) session_duration: std::option::Option<std::string::String>,
        pub(crate) relay_state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>
        pub fn session_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_duration = Some(input.into());
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>
        pub fn set_session_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_duration = input;
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn relay_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.relay_state = Some(input.into());
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn set_relay_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.relay_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePermissionSetInput`](crate::input::UpdatePermissionSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePermissionSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePermissionSetInput {
                instance_arn: self.instance_arn,
                permission_set_arn: self.permission_set_arn,
                description: self.description,
                session_duration: self.session_duration,
                relay_state: self.relay_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePermissionSetInputOperationOutputAlias = crate::operation::UpdatePermissionSet;
#[doc(hidden)]
pub type UpdatePermissionSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePermissionSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePermissionSet`](crate::operation::UpdatePermissionSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePermissionSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePermissionSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePermissionSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SWBExternalService.UpdatePermissionSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_permission_set(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePermissionSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePermissionSet",
            "ssoadmin",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePermissionSetInput`](crate::input::UpdatePermissionSetInput)
    pub fn builder() -> crate::input::update_permission_set_input::Builder {
        crate::input::update_permission_set_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The description of the <code>PermissionSet</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>
    pub session_duration: std::option::Option<std::string::String>,
    /// <p>Used to redirect users within the application during the federation authentication process.</p>
    pub relay_state: std::option::Option<std::string::String>,
}
impl UpdatePermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the permission set.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The description of the <code>PermissionSet</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>
    pub fn session_duration(&self) -> std::option::Option<&str> {
        self.session_duration.as_deref()
    }
    /// <p>Used to redirect users within the application during the federation authentication process.</p>
    pub fn relay_state(&self) -> std::option::Option<&str> {
        self.relay_state.as_deref()
    }
}
impl std::fmt::Debug for UpdatePermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("description", &self.description);
        formatter.field("session_duration", &self.session_duration);
        formatter.field("relay_state", &self.relay_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>Updates the attributes for your ABAC configuration.</p>
    pub instance_access_control_attribute_configuration:
        std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
}
impl UpdateInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>Updates the attributes for your ABAC configuration.</p>
    pub fn instance_access_control_attribute_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InstanceAccessControlAttributeConfiguration> {
        self.instance_access_control_attribute_configuration
            .as_ref()
    }
}
impl std::fmt::Debug for UpdateInstanceAccessControlAttributeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("UpdateInstanceAccessControlAttributeConfigurationInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field(
            "instance_access_control_attribute_configuration",
            &self.instance_access_control_attribute_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource with the tags to be listed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of tags that are attached to the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the resource with the tags to be listed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of tags that are attached to the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource with the tags to be listed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A set of key-value pairs that are used to manage the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the resource with the tags to be listed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A set of key-value pairs that are used to manage the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInlinePolicyToPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The IAM inline policy to attach to a <code>PermissionSet</code>.</p>
    pub inline_policy: std::option::Option<std::string::String>,
}
impl PutInlinePolicyToPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the permission set.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The IAM inline policy to attach to a <code>PermissionSet</code>.</p>
    pub fn inline_policy(&self) -> std::option::Option<&str> {
        self.inline_policy.as_deref()
    }
}
impl std::fmt::Debug for PutInlinePolicyToPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInlinePolicyToPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("inline_policy", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be created.</p>
    pub target_type: std::option::Option<crate::model::ProvisionTargetType>,
}
impl ProvisionPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the permission set.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>The entity type for which the assignment will be created.</p>
    pub fn target_type(&self) -> std::option::Option<&crate::model::ProvisionTargetType> {
        self.target_type.as_ref()
    }
}
impl std::fmt::Debug for ProvisionPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_type", &self.target_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource with the tags to be listed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the resource with the tags to be listed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionSetsProvisionedToAccountInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The status object for the permission set provisioning operation.</p>
    pub provisioning_status: std::option::Option<crate::model::ProvisioningStatus>,
    /// <p>The maximum number of results to display for the assignment.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPermissionSetsProvisionedToAccountInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The status object for the permission set provisioning operation.</p>
    pub fn provisioning_status(&self) -> std::option::Option<&crate::model::ProvisioningStatus> {
        self.provisioning_status.as_ref()
    }
    /// <p>The maximum number of results to display for the assignment.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPermissionSetsProvisionedToAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionSetsProvisionedToAccountInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("account_id", &self.account_id);
        formatter.field("provisioning_status", &self.provisioning_status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionSetsInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display for the assignment.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPermissionSetsInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to display for the assignment.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPermissionSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionSetsInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionSetProvisioningStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display for the assignment.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters results based on the passed attribute value.</p>
    pub filter: std::option::Option<crate::model::OperationStatusFilter>,
}
impl ListPermissionSetProvisioningStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The maximum number of results to display for the assignment.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters results based on the passed attribute value.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::OperationStatusFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for ListPermissionSetProvisioningStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionSetProvisioningStatusInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListManagedPoliciesInPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the <code>PermissionSet</code> whose managed policies will be listed.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListManagedPoliciesInPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the <code>PermissionSet</code> whose managed policies will be listed.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListManagedPoliciesInPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListManagedPoliciesInPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstancesInput {
    /// <p>The maximum number of results to display for the instance.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInstancesInput {
    /// <p>The maximum number of results to display for the instance.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstancesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountsForProvisionedPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the <code>PermissionSet</code> from which the associated Amazon Web Services accounts will be listed.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
    pub provisioning_status: std::option::Option<crate::model::ProvisioningStatus>,
    /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountsForProvisionedPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the <code>PermissionSet</code> from which the associated Amazon Web Services accounts will be listed.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
    pub fn provisioning_status(&self) -> std::option::Option<&crate::model::ProvisioningStatus> {
        self.provisioning_status.as_ref()
    }
    /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountsForProvisionedPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountsForProvisionedPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("provisioning_status", &self.provisioning_status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountAssignmentsInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set from which to list assignments.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display for the assignment.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountAssignmentsInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ARN of the permission set from which to list assignments.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The maximum number of results to display for the assignment.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountAssignmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountAssignmentsInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("account_id", &self.account_id);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountAssignmentDeletionStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display for the assignment.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters results based on the passed attribute value.</p>
    pub filter: std::option::Option<crate::model::OperationStatusFilter>,
}
impl ListAccountAssignmentDeletionStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The maximum number of results to display for the assignment.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters results based on the passed attribute value.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::OperationStatusFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for ListAccountAssignmentDeletionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountAssignmentDeletionStatusInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountAssignmentCreationStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display for the assignment.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters results based on the passed attribute value.</p>
    pub filter: std::option::Option<crate::model::OperationStatusFilter>,
}
impl ListAccountAssignmentCreationStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The maximum number of results to display for the assignment.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters results based on the passed attribute value.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::OperationStatusFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for ListAccountAssignmentCreationStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountAssignmentCreationStatusInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInlinePolicyForPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
}
impl GetInlinePolicyForPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the permission set.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
}
impl std::fmt::Debug for GetInlinePolicyForPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInlinePolicyForPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachManagedPolicyFromPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the <code>PermissionSet</code> from which the policy should be detached.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
    pub managed_policy_arn: std::option::Option<std::string::String>,
}
impl DetachManagedPolicyFromPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the <code>PermissionSet</code> from which the policy should be detached.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
    pub fn managed_policy_arn(&self) -> std::option::Option<&str> {
        self.managed_policy_arn.as_deref()
    }
}
impl std::fmt::Debug for DetachManagedPolicyFromPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachManagedPolicyFromPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("managed_policy_arn", &self.managed_policy_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePermissionSetProvisioningStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The identifier that is provided by the <code>ProvisionPermissionSet</code> call to retrieve the current status of the provisioning workflow.</p>
    pub provision_permission_set_request_id: std::option::Option<std::string::String>,
}
impl DescribePermissionSetProvisioningStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The identifier that is provided by the <code>ProvisionPermissionSet</code> call to retrieve the current status of the provisioning workflow.</p>
    pub fn provision_permission_set_request_id(&self) -> std::option::Option<&str> {
        self.provision_permission_set_request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePermissionSetProvisioningStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePermissionSetProvisioningStatusInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field(
            "provision_permission_set_request_id",
            &self.provision_permission_set_request_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
}
impl DescribePermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the permission set.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribePermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub instance_arn: std::option::Option<std::string::String>,
}
impl DescribeInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstanceAccessControlAttributeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("DescribeInstanceAccessControlAttributeConfigurationInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAssignmentDeletionStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The identifier that is used to track the request operation progress.</p>
    pub account_assignment_deletion_request_id: std::option::Option<std::string::String>,
}
impl DescribeAccountAssignmentDeletionStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The identifier that is used to track the request operation progress.</p>
    pub fn account_assignment_deletion_request_id(&self) -> std::option::Option<&str> {
        self.account_assignment_deletion_request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountAssignmentDeletionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAssignmentDeletionStatusInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field(
            "account_assignment_deletion_request_id",
            &self.account_assignment_deletion_request_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAssignmentCreationStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The identifier that is used to track the request operation progress.</p>
    pub account_assignment_creation_request_id: std::option::Option<std::string::String>,
}
impl DescribeAccountAssignmentCreationStatusInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The identifier that is used to track the request operation progress.</p>
    pub fn account_assignment_creation_request_id(&self) -> std::option::Option<&str> {
        self.account_assignment_creation_request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountAssignmentCreationStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAssignmentCreationStatusInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field(
            "account_assignment_creation_request_id",
            &self.account_assignment_creation_request_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set that should be deleted.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
}
impl DeletePermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the permission set that should be deleted.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub instance_arn: std::option::Option<std::string::String>,
}
impl DeleteInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteInstanceAccessControlAttributeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("DeleteInstanceAccessControlAttributeConfigurationInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInlinePolicyFromPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set that will be used to remove access.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
}
impl DeleteInlinePolicyFromPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the permission set that will be used to remove access.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteInlinePolicyFromPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInlinePolicyFromPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccountAssignmentInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be deleted.</p>
    pub target_type: std::option::Option<crate::model::TargetType>,
    /// <p>The ARN of the permission set that will be used to remove access.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be deleted.</p>
    pub principal_type: std::option::Option<crate::model::PrincipalType>,
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl DeleteAccountAssignmentInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>The entity type for which the assignment will be deleted.</p>
    pub fn target_type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.target_type.as_ref()
    }
    /// <p>The ARN of the permission set that will be used to remove access.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The entity type for which the assignment will be deleted.</p>
    pub fn principal_type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.principal_type.as_ref()
    }
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccountAssignmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccountAssignmentInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_type", &self.target_type);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("principal_type", &self.principal_type);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePermissionSetInput {
    /// <p>The name of the <code>PermissionSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the <code>PermissionSet</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>
    pub session_duration: std::option::Option<std::string::String>,
    /// <p>Used to redirect users within the application during the federation authentication process.</p>
    pub relay_state: std::option::Option<std::string::String>,
    /// <p>The tags to attach to the new <code>PermissionSet</code>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreatePermissionSetInput {
    /// <p>The name of the <code>PermissionSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the <code>PermissionSet</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>
    pub fn session_duration(&self) -> std::option::Option<&str> {
        self.session_duration.as_deref()
    }
    /// <p>Used to redirect users within the application during the federation authentication process.</p>
    pub fn relay_state(&self) -> std::option::Option<&str> {
        self.relay_state.as_deref()
    }
    /// <p>The tags to attach to the new <code>PermissionSet</code>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreatePermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePermissionSetInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("session_duration", &self.session_duration);
        formatter.field("relay_state", &self.relay_state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>
    pub instance_access_control_attribute_configuration:
        std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
}
impl CreateInstanceAccessControlAttributeConfigurationInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>
    pub fn instance_access_control_attribute_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InstanceAccessControlAttributeConfiguration> {
        self.instance_access_control_attribute_configuration
            .as_ref()
    }
}
impl std::fmt::Debug for CreateInstanceAccessControlAttributeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("CreateInstanceAccessControlAttributeConfigurationInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field(
            "instance_access_control_attribute_configuration",
            &self.instance_access_control_attribute_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccountAssignmentInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be created.</p>
    pub target_type: std::option::Option<crate::model::TargetType>,
    /// <p>The ARN of the permission set that the admin wants to grant the principal access to.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be created.</p>
    pub principal_type: std::option::Option<crate::model::PrincipalType>,
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl CreateAccountAssignmentInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>The entity type for which the assignment will be created.</p>
    pub fn target_type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.target_type.as_ref()
    }
    /// <p>The ARN of the permission set that the admin wants to grant the principal access to.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The entity type for which the assignment will be created.</p>
    pub fn principal_type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.principal_type.as_ref()
    }
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for CreateAccountAssignmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccountAssignmentInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_type", &self.target_type);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("principal_type", &self.principal_type);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachManagedPolicyToPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the <code>PermissionSet</code> that the managed policy should be attached to.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
    pub managed_policy_arn: std::option::Option<std::string::String>,
}
impl AttachManagedPolicyToPermissionSetInput {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The ARN of the <code>PermissionSet</code> that the managed policy should be attached to.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
    pub fn managed_policy_arn(&self) -> std::option::Option<&str> {
        self.managed_policy_arn.as_deref()
    }
}
impl std::fmt::Debug for AttachManagedPolicyToPermissionSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachManagedPolicyToPermissionSetInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("managed_policy_arn", &self.managed_policy_arn);
        formatter.finish()
    }
}
