// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Single Sign-On Admin
///
/// Client for invoking operations on AWS Single Sign-On Admin. Each operation on AWS Single Sign-On Admin is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ssoadmin::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_ssoadmin::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_ssoadmin::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AttachManagedPolicyToPermissionSet`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet::set_permission_set_arn): <p>The ARN of the <code>PermissionSet</code> that the managed policy should be attached to.</p>
    ///   - [`managed_policy_arn(impl Into<String>)`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet::managed_policy_arn) / [`set_managed_policy_arn(Option<String>)`](crate::client::fluent_builders::AttachManagedPolicyToPermissionSet::set_managed_policy_arn): <p>The IAM managed policy ARN to be attached to a permission set.</p>
    /// - On success, responds with [`AttachManagedPolicyToPermissionSetOutput`](crate::output::AttachManagedPolicyToPermissionSetOutput)

    /// - On failure, responds with [`SdkError<AttachManagedPolicyToPermissionSetError>`](crate::error::AttachManagedPolicyToPermissionSetError)
    pub fn attach_managed_policy_to_permission_set(
        &self,
    ) -> fluent_builders::AttachManagedPolicyToPermissionSet {
        fluent_builders::AttachManagedPolicyToPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccountAssignment`](crate::client::fluent_builders::CreateAccountAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAccountAssignment::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateAccountAssignment::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccountAssignment::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::CreateAccountAssignment::set_target_id): <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    ///   - [`target_type(TargetType)`](crate::client::fluent_builders::CreateAccountAssignment::target_type) / [`set_target_type(Option<TargetType>)`](crate::client::fluent_builders::CreateAccountAssignment::set_target_type): <p>The entity type for which the assignment will be created.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAccountAssignment::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::CreateAccountAssignment::set_permission_set_arn): <p>The ARN of the permission set that the admin wants to grant the principal access to.</p>
    ///   - [`principal_type(PrincipalType)`](crate::client::fluent_builders::CreateAccountAssignment::principal_type) / [`set_principal_type(Option<PrincipalType>)`](crate::client::fluent_builders::CreateAccountAssignment::set_principal_type): <p>The entity type for which the assignment will be created.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccountAssignment::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::CreateAccountAssignment::set_principal_id): <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    /// - On success, responds with [`CreateAccountAssignmentOutput`](crate::output::CreateAccountAssignmentOutput) with field(s):
    ///   - [`account_assignment_creation_status(Option<AccountAssignmentOperationStatus>)`](crate::output::CreateAccountAssignmentOutput::account_assignment_creation_status): <p>The status object for the account assignment creation operation.</p>
    /// - On failure, responds with [`SdkError<CreateAccountAssignmentError>`](crate::error::CreateAccountAssignmentError)
    pub fn create_account_assignment(&self) -> fluent_builders::CreateAccountAssignment {
        fluent_builders::CreateAccountAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::CreateInstanceAccessControlAttributeConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateInstanceAccessControlAttributeConfiguration::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateInstanceAccessControlAttributeConfiguration::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed.</p>
    ///   - [`instance_access_control_attribute_configuration(InstanceAccessControlAttributeConfiguration)`](crate::client::fluent_builders::CreateInstanceAccessControlAttributeConfiguration::instance_access_control_attribute_configuration) / [`set_instance_access_control_attribute_configuration(Option<InstanceAccessControlAttributeConfiguration>)`](crate::client::fluent_builders::CreateInstanceAccessControlAttributeConfiguration::set_instance_access_control_attribute_configuration): <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>
    /// - On success, responds with [`CreateInstanceAccessControlAttributeConfigurationOutput`](crate::output::CreateInstanceAccessControlAttributeConfigurationOutput)

    /// - On failure, responds with [`SdkError<CreateInstanceAccessControlAttributeConfigurationError>`](crate::error::CreateInstanceAccessControlAttributeConfigurationError)
    pub fn create_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::CreateInstanceAccessControlAttributeConfiguration {
        fluent_builders::CreateInstanceAccessControlAttributeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePermissionSet`](crate::client::fluent_builders::CreatePermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePermissionSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePermissionSet::set_name): <p>The name of the <code>PermissionSet</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePermissionSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePermissionSet::set_description): <p>The description of the <code>PermissionSet</code>.</p>
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreatePermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::CreatePermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`session_duration(impl Into<String>)`](crate::client::fluent_builders::CreatePermissionSet::session_duration) / [`set_session_duration(Option<String>)`](crate::client::fluent_builders::CreatePermissionSet::set_session_duration): <p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>
    ///   - [`relay_state(impl Into<String>)`](crate::client::fluent_builders::CreatePermissionSet::relay_state) / [`set_relay_state(Option<String>)`](crate::client::fluent_builders::CreatePermissionSet::set_relay_state): <p>Used to redirect users within the application during the federation authentication process.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePermissionSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePermissionSet::set_tags): <p>The tags to attach to the new <code>PermissionSet</code>.</p>
    /// - On success, responds with [`CreatePermissionSetOutput`](crate::output::CreatePermissionSetOutput) with field(s):
    ///   - [`permission_set(Option<PermissionSet>)`](crate::output::CreatePermissionSetOutput::permission_set): <p>Defines the level of access on an Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<CreatePermissionSetError>`](crate::error::CreatePermissionSetError)
    pub fn create_permission_set(&self) -> fluent_builders::CreatePermissionSet {
        fluent_builders::CreatePermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccountAssignment`](crate::client::fluent_builders::DeleteAccountAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::set_target_id): <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    ///   - [`target_type(TargetType)`](crate::client::fluent_builders::DeleteAccountAssignment::target_type) / [`set_target_type(Option<TargetType>)`](crate::client::fluent_builders::DeleteAccountAssignment::set_target_type): <p>The entity type for which the assignment will be deleted.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::set_permission_set_arn): <p>The ARN of the permission set that will be used to remove access.</p>
    ///   - [`principal_type(PrincipalType)`](crate::client::fluent_builders::DeleteAccountAssignment::principal_type) / [`set_principal_type(Option<PrincipalType>)`](crate::client::fluent_builders::DeleteAccountAssignment::set_principal_type): <p>The entity type for which the assignment will be deleted.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::DeleteAccountAssignment::set_principal_id): <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    /// - On success, responds with [`DeleteAccountAssignmentOutput`](crate::output::DeleteAccountAssignmentOutput) with field(s):
    ///   - [`account_assignment_deletion_status(Option<AccountAssignmentOperationStatus>)`](crate::output::DeleteAccountAssignmentOutput::account_assignment_deletion_status): <p>The status object for the account assignment deletion operation.</p>
    /// - On failure, responds with [`SdkError<DeleteAccountAssignmentError>`](crate::error::DeleteAccountAssignmentError)
    pub fn delete_account_assignment(&self) -> fluent_builders::DeleteAccountAssignment {
        fluent_builders::DeleteAccountAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInlinePolicyFromPermissionSet`](crate::client::fluent_builders::DeleteInlinePolicyFromPermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteInlinePolicyFromPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteInlinePolicyFromPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteInlinePolicyFromPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::DeleteInlinePolicyFromPermissionSet::set_permission_set_arn): <p>The ARN of the permission set that will be used to remove access.</p>
    /// - On success, responds with [`DeleteInlinePolicyFromPermissionSetOutput`](crate::output::DeleteInlinePolicyFromPermissionSetOutput)

    /// - On failure, responds with [`SdkError<DeleteInlinePolicyFromPermissionSetError>`](crate::error::DeleteInlinePolicyFromPermissionSetError)
    pub fn delete_inline_policy_from_permission_set(
        &self,
    ) -> fluent_builders::DeleteInlinePolicyFromPermissionSet {
        fluent_builders::DeleteInlinePolicyFromPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::DeleteInstanceAccessControlAttributeConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteInstanceAccessControlAttributeConfiguration::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteInstanceAccessControlAttributeConfiguration::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed.</p>
    /// - On success, responds with [`DeleteInstanceAccessControlAttributeConfigurationOutput`](crate::output::DeleteInstanceAccessControlAttributeConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteInstanceAccessControlAttributeConfigurationError>`](crate::error::DeleteInstanceAccessControlAttributeConfigurationError)
    pub fn delete_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::DeleteInstanceAccessControlAttributeConfiguration {
        fluent_builders::DeleteInstanceAccessControlAttributeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePermissionSet`](crate::client::fluent_builders::DeletePermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DeletePermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::DeletePermissionSet::set_permission_set_arn): <p>The ARN of the permission set that should be deleted.</p>
    /// - On success, responds with [`DeletePermissionSetOutput`](crate::output::DeletePermissionSetOutput)

    /// - On failure, responds with [`SdkError<DeletePermissionSetError>`](crate::error::DeletePermissionSetError)
    pub fn delete_permission_set(&self) -> fluent_builders::DeletePermissionSet {
        fluent_builders::DeletePermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAssignmentCreationStatus`](crate::client::fluent_builders::DescribeAccountAssignmentCreationStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentCreationStatus::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentCreationStatus::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`account_assignment_creation_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentCreationStatus::account_assignment_creation_request_id) / [`set_account_assignment_creation_request_id(Option<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentCreationStatus::set_account_assignment_creation_request_id): <p>The identifier that is used to track the request operation progress.</p>
    /// - On success, responds with [`DescribeAccountAssignmentCreationStatusOutput`](crate::output::DescribeAccountAssignmentCreationStatusOutput) with field(s):
    ///   - [`account_assignment_creation_status(Option<AccountAssignmentOperationStatus>)`](crate::output::DescribeAccountAssignmentCreationStatusOutput::account_assignment_creation_status): <p>The status object for the account assignment creation operation.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAssignmentCreationStatusError>`](crate::error::DescribeAccountAssignmentCreationStatusError)
    pub fn describe_account_assignment_creation_status(
        &self,
    ) -> fluent_builders::DescribeAccountAssignmentCreationStatus {
        fluent_builders::DescribeAccountAssignmentCreationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAssignmentDeletionStatus`](crate::client::fluent_builders::DescribeAccountAssignmentDeletionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentDeletionStatus::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentDeletionStatus::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`account_assignment_deletion_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentDeletionStatus::account_assignment_deletion_request_id) / [`set_account_assignment_deletion_request_id(Option<String>)`](crate::client::fluent_builders::DescribeAccountAssignmentDeletionStatus::set_account_assignment_deletion_request_id): <p>The identifier that is used to track the request operation progress.</p>
    /// - On success, responds with [`DescribeAccountAssignmentDeletionStatusOutput`](crate::output::DescribeAccountAssignmentDeletionStatusOutput) with field(s):
    ///   - [`account_assignment_deletion_status(Option<AccountAssignmentOperationStatus>)`](crate::output::DescribeAccountAssignmentDeletionStatusOutput::account_assignment_deletion_status): <p>The status object for the account assignment deletion operation.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAssignmentDeletionStatusError>`](crate::error::DescribeAccountAssignmentDeletionStatusError)
    pub fn describe_account_assignment_deletion_status(
        &self,
    ) -> fluent_builders::DescribeAccountAssignmentDeletionStatus {
        fluent_builders::DescribeAccountAssignmentDeletionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::DescribeInstanceAccessControlAttributeConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceAccessControlAttributeConfiguration::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeInstanceAccessControlAttributeConfiguration::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed.</p>
    /// - On success, responds with [`DescribeInstanceAccessControlAttributeConfigurationOutput`](crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput) with field(s):
    ///   - [`status(Option<InstanceAccessControlAttributeConfigurationStatus>)`](crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput::status): <p>The status of the attribute configuration process.</p>
    ///   - [`status_reason(Option<String>)`](crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput::status_reason): <p>Provides more details about the current status of the specified attribute.</p>
    ///   - [`instance_access_control_attribute_configuration(Option<InstanceAccessControlAttributeConfiguration>)`](crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput::instance_access_control_attribute_configuration): <p>Gets the list of Amazon Web Services SSO identity store attributes that have been added to your ABAC configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceAccessControlAttributeConfigurationError>`](crate::error::DescribeInstanceAccessControlAttributeConfigurationError)
    pub fn describe_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::DescribeInstanceAccessControlAttributeConfiguration {
        fluent_builders::DescribeInstanceAccessControlAttributeConfiguration::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`DescribePermissionSet`](crate::client::fluent_builders::DescribePermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribePermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribePermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::DescribePermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::DescribePermissionSet::set_permission_set_arn): <p>The ARN of the permission set.</p>
    /// - On success, responds with [`DescribePermissionSetOutput`](crate::output::DescribePermissionSetOutput) with field(s):
    ///   - [`permission_set(Option<PermissionSet>)`](crate::output::DescribePermissionSetOutput::permission_set): <p>Describes the level of access on an Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<DescribePermissionSetError>`](crate::error::DescribePermissionSetError)
    pub fn describe_permission_set(&self) -> fluent_builders::DescribePermissionSet {
        fluent_builders::DescribePermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePermissionSetProvisioningStatus`](crate::client::fluent_builders::DescribePermissionSetProvisioningStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribePermissionSetProvisioningStatus::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribePermissionSetProvisioningStatus::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`provision_permission_set_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribePermissionSetProvisioningStatus::provision_permission_set_request_id) / [`set_provision_permission_set_request_id(Option<String>)`](crate::client::fluent_builders::DescribePermissionSetProvisioningStatus::set_provision_permission_set_request_id): <p>The identifier that is provided by the <code>ProvisionPermissionSet</code> call to retrieve the current status of the provisioning workflow.</p>
    /// - On success, responds with [`DescribePermissionSetProvisioningStatusOutput`](crate::output::DescribePermissionSetProvisioningStatusOutput) with field(s):
    ///   - [`permission_set_provisioning_status(Option<PermissionSetProvisioningStatus>)`](crate::output::DescribePermissionSetProvisioningStatusOutput::permission_set_provisioning_status): <p>The status object for the permission set provisioning operation.</p>
    /// - On failure, responds with [`SdkError<DescribePermissionSetProvisioningStatusError>`](crate::error::DescribePermissionSetProvisioningStatusError)
    pub fn describe_permission_set_provisioning_status(
        &self,
    ) -> fluent_builders::DescribePermissionSetProvisioningStatus {
        fluent_builders::DescribePermissionSetProvisioningStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachManagedPolicyFromPermissionSet`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet::set_permission_set_arn): <p>The ARN of the <code>PermissionSet</code> from which the policy should be detached.</p>
    ///   - [`managed_policy_arn(impl Into<String>)`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet::managed_policy_arn) / [`set_managed_policy_arn(Option<String>)`](crate::client::fluent_builders::DetachManagedPolicyFromPermissionSet::set_managed_policy_arn): <p>The IAM managed policy ARN to be attached to a permission set.</p>
    /// - On success, responds with [`DetachManagedPolicyFromPermissionSetOutput`](crate::output::DetachManagedPolicyFromPermissionSetOutput)

    /// - On failure, responds with [`SdkError<DetachManagedPolicyFromPermissionSetError>`](crate::error::DetachManagedPolicyFromPermissionSetError)
    pub fn detach_managed_policy_from_permission_set(
        &self,
    ) -> fluent_builders::DetachManagedPolicyFromPermissionSet {
        fluent_builders::DetachManagedPolicyFromPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInlinePolicyForPermissionSet`](crate::client::fluent_builders::GetInlinePolicyForPermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::GetInlinePolicyForPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::GetInlinePolicyForPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::GetInlinePolicyForPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::GetInlinePolicyForPermissionSet::set_permission_set_arn): <p>The ARN of the permission set.</p>
    /// - On success, responds with [`GetInlinePolicyForPermissionSetOutput`](crate::output::GetInlinePolicyForPermissionSetOutput) with field(s):
    ///   - [`inline_policy(Option<String>)`](crate::output::GetInlinePolicyForPermissionSetOutput::inline_policy): <p>The IAM inline policy that is attached to the permission set.</p>
    /// - On failure, responds with [`SdkError<GetInlinePolicyForPermissionSetError>`](crate::error::GetInlinePolicyForPermissionSetError)
    pub fn get_inline_policy_for_permission_set(
        &self,
    ) -> fluent_builders::GetInlinePolicyForPermissionSet {
        fluent_builders::GetInlinePolicyForPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountAssignmentCreationStatus`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::set_max_results): <p>The maximum number of results to display for the assignment.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    ///   - [`filter(OperationStatusFilter)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::filter) / [`set_filter(Option<OperationStatusFilter>)`](crate::client::fluent_builders::ListAccountAssignmentCreationStatus::set_filter): <p>Filters results based on the passed attribute value.</p>
    /// - On success, responds with [`ListAccountAssignmentCreationStatusOutput`](crate::output::ListAccountAssignmentCreationStatusOutput) with field(s):
    ///   - [`account_assignments_creation_status(Option<Vec<AccountAssignmentOperationStatusMetadata>>)`](crate::output::ListAccountAssignmentCreationStatusOutput::account_assignments_creation_status): <p>The status object for the account assignment creation operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountAssignmentCreationStatusOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListAccountAssignmentCreationStatusError>`](crate::error::ListAccountAssignmentCreationStatusError)
    pub fn list_account_assignment_creation_status(
        &self,
    ) -> fluent_builders::ListAccountAssignmentCreationStatus {
        fluent_builders::ListAccountAssignmentCreationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountAssignmentDeletionStatus`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::set_max_results): <p>The maximum number of results to display for the assignment.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    ///   - [`filter(OperationStatusFilter)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::filter) / [`set_filter(Option<OperationStatusFilter>)`](crate::client::fluent_builders::ListAccountAssignmentDeletionStatus::set_filter): <p>Filters results based on the passed attribute value.</p>
    /// - On success, responds with [`ListAccountAssignmentDeletionStatusOutput`](crate::output::ListAccountAssignmentDeletionStatusOutput) with field(s):
    ///   - [`account_assignments_deletion_status(Option<Vec<AccountAssignmentOperationStatusMetadata>>)`](crate::output::ListAccountAssignmentDeletionStatusOutput::account_assignments_deletion_status): <p>The status object for the account assignment deletion operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountAssignmentDeletionStatusOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListAccountAssignmentDeletionStatusError>`](crate::error::ListAccountAssignmentDeletionStatusError)
    pub fn list_account_assignment_deletion_status(
        &self,
    ) -> fluent_builders::ListAccountAssignmentDeletionStatus {
        fluent_builders::ListAccountAssignmentDeletionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountAssignments`](crate::client::fluent_builders::ListAccountAssignments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountAssignments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignments::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAccountAssignments::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignments::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListAccountAssignments::set_account_id): <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignments::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::ListAccountAssignments::set_permission_set_arn): <p>The ARN of the permission set from which to list assignments.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountAssignments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccountAssignments::set_max_results): <p>The maximum number of results to display for the assignment.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssignments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountAssignments::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On success, responds with [`ListAccountAssignmentsOutput`](crate::output::ListAccountAssignmentsOutput) with field(s):
    ///   - [`account_assignments(Option<Vec<AccountAssignment>>)`](crate::output::ListAccountAssignmentsOutput::account_assignments): <p>The list of assignments that match the input Amazon Web Services account and permission set.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountAssignmentsOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListAccountAssignmentsError>`](crate::error::ListAccountAssignmentsError)
    pub fn list_account_assignments(&self) -> fluent_builders::ListAccountAssignments {
        fluent_builders::ListAccountAssignments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountsForProvisionedPermissionSet`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::set_permission_set_arn): <p>The ARN of the <code>PermissionSet</code> from which the associated Amazon Web Services accounts will be listed.</p>
    ///   - [`provisioning_status(ProvisioningStatus)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::provisioning_status) / [`set_provisioning_status(Option<ProvisioningStatus>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::set_provisioning_status): <p>The permission set provisioning status for an Amazon Web Services account.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::set_max_results): <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountsForProvisionedPermissionSet::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On success, responds with [`ListAccountsForProvisionedPermissionSetOutput`](crate::output::ListAccountsForProvisionedPermissionSetOutput) with field(s):
    ///   - [`account_ids(Option<Vec<String>>)`](crate::output::ListAccountsForProvisionedPermissionSetOutput::account_ids): <p>The list of Amazon Web Services <code>AccountIds</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountsForProvisionedPermissionSetOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListAccountsForProvisionedPermissionSetError>`](crate::error::ListAccountsForProvisionedPermissionSetError)
    pub fn list_accounts_for_provisioned_permission_set(
        &self,
    ) -> fluent_builders::ListAccountsForProvisionedPermissionSet {
        fluent_builders::ListAccountsForProvisionedPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstances`](crate::client::fluent_builders::ListInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInstances::set_max_results): <p>The maximum number of results to display for the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInstances::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On success, responds with [`ListInstancesOutput`](crate::output::ListInstancesOutput) with field(s):
    ///   - [`instances(Option<Vec<InstanceMetadata>>)`](crate::output::ListInstancesOutput::instances): <p>Lists the SSO instances that the caller has access to.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInstancesOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListInstancesError>`](crate::error::ListInstancesError)
    pub fn list_instances(&self) -> fluent_builders::ListInstances {
        fluent_builders::ListInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListManagedPoliciesInPermissionSet`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::set_permission_set_arn): <p>The ARN of the <code>PermissionSet</code> whose managed policies will be listed.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::set_max_results): <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListManagedPoliciesInPermissionSet::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On success, responds with [`ListManagedPoliciesInPermissionSetOutput`](crate::output::ListManagedPoliciesInPermissionSetOutput) with field(s):
    ///   - [`attached_managed_policies(Option<Vec<AttachedManagedPolicy>>)`](crate::output::ListManagedPoliciesInPermissionSetOutput::attached_managed_policies): <p>The array of the <code>AttachedManagedPolicy</code> data type object.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListManagedPoliciesInPermissionSetOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListManagedPoliciesInPermissionSetError>`](crate::error::ListManagedPoliciesInPermissionSetError)
    pub fn list_managed_policies_in_permission_set(
        &self,
    ) -> fluent_builders::ListManagedPoliciesInPermissionSet {
        fluent_builders::ListManagedPoliciesInPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissionSetProvisioningStatus`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::set_max_results): <p>The maximum number of results to display for the assignment.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    ///   - [`filter(OperationStatusFilter)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::filter) / [`set_filter(Option<OperationStatusFilter>)`](crate::client::fluent_builders::ListPermissionSetProvisioningStatus::set_filter): <p>Filters results based on the passed attribute value.</p>
    /// - On success, responds with [`ListPermissionSetProvisioningStatusOutput`](crate::output::ListPermissionSetProvisioningStatusOutput) with field(s):
    ///   - [`permission_sets_provisioning_status(Option<Vec<PermissionSetProvisioningStatusMetadata>>)`](crate::output::ListPermissionSetProvisioningStatusOutput::permission_sets_provisioning_status): <p>The status object for the permission set provisioning operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionSetProvisioningStatusOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListPermissionSetProvisioningStatusError>`](crate::error::ListPermissionSetProvisioningStatusError)
    pub fn list_permission_set_provisioning_status(
        &self,
    ) -> fluent_builders::ListPermissionSetProvisioningStatus {
        fluent_builders::ListPermissionSetProvisioningStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissionSets`](crate::client::fluent_builders::ListPermissionSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissionSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListPermissionSets::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListPermissionSets::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissionSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissionSets::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissionSets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissionSets::set_max_results): <p>The maximum number of results to display for the assignment.</p>
    /// - On success, responds with [`ListPermissionSetsOutput`](crate::output::ListPermissionSetsOutput) with field(s):
    ///   - [`permission_sets(Option<Vec<String>>)`](crate::output::ListPermissionSetsOutput::permission_sets): <p>Defines the level of access on an Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionSetsOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListPermissionSetsError>`](crate::error::ListPermissionSetsError)
    pub fn list_permission_sets(&self) -> fluent_builders::ListPermissionSets {
        fluent_builders::ListPermissionSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissionSetsProvisionedToAccount`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::set_account_id): <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    ///   - [`provisioning_status(ProvisioningStatus)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::provisioning_status) / [`set_provisioning_status(Option<ProvisioningStatus>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::set_provisioning_status): <p>The status object for the permission set provisioning operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::set_max_results): <p>The maximum number of results to display for the assignment.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissionSetsProvisionedToAccount::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On success, responds with [`ListPermissionSetsProvisionedToAccountOutput`](crate::output::ListPermissionSetsProvisionedToAccountOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionSetsProvisionedToAccountOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    ///   - [`permission_sets(Option<Vec<String>>)`](crate::output::ListPermissionSetsProvisionedToAccountOutput::permission_sets): <p>Defines the level of access that an Amazon Web Services account has.</p>
    /// - On failure, responds with [`SdkError<ListPermissionSetsProvisionedToAccountError>`](crate::error::ListPermissionSetsProvisionedToAccountError)
    pub fn list_permission_sets_provisioned_to_account(
        &self,
    ) -> fluent_builders::ListPermissionSetsProvisionedToAccount {
        fluent_builders::ListPermissionSetsProvisionedToAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource with the tags to be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A set of key-value pairs that are used to manage the resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ProvisionPermissionSet`](crate::client::fluent_builders::ProvisionPermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::ProvisionPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::ProvisionPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::ProvisionPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::ProvisionPermissionSet::set_permission_set_arn): <p>The ARN of the permission set.</p>
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::ProvisionPermissionSet::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::ProvisionPermissionSet::set_target_id): <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    ///   - [`target_type(ProvisionTargetType)`](crate::client::fluent_builders::ProvisionPermissionSet::target_type) / [`set_target_type(Option<ProvisionTargetType>)`](crate::client::fluent_builders::ProvisionPermissionSet::set_target_type): <p>The entity type for which the assignment will be created.</p>
    /// - On success, responds with [`ProvisionPermissionSetOutput`](crate::output::ProvisionPermissionSetOutput) with field(s):
    ///   - [`permission_set_provisioning_status(Option<PermissionSetProvisioningStatus>)`](crate::output::ProvisionPermissionSetOutput::permission_set_provisioning_status): <p>The status object for the permission set provisioning operation.</p>
    /// - On failure, responds with [`SdkError<ProvisionPermissionSetError>`](crate::error::ProvisionPermissionSetError)
    pub fn provision_permission_set(&self) -> fluent_builders::ProvisionPermissionSet {
        fluent_builders::ProvisionPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutInlinePolicyToPermissionSet`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet::set_permission_set_arn): <p>The ARN of the permission set.</p>
    ///   - [`inline_policy(impl Into<String>)`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet::inline_policy) / [`set_inline_policy(Option<String>)`](crate::client::fluent_builders::PutInlinePolicyToPermissionSet::set_inline_policy): <p>The IAM inline policy to attach to a <code>PermissionSet</code>.</p>
    /// - On success, responds with [`PutInlinePolicyToPermissionSetOutput`](crate::output::PutInlinePolicyToPermissionSetOutput)

    /// - On failure, responds with [`SdkError<PutInlinePolicyToPermissionSetError>`](crate::error::PutInlinePolicyToPermissionSetError)
    pub fn put_inline_policy_to_permission_set(
        &self,
    ) -> fluent_builders::PutInlinePolicyToPermissionSet {
        fluent_builders::PutInlinePolicyToPermissionSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource with the tags to be listed.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A set of key-value pairs that are used to manage the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource with the tags to be listed.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of tags that are attached to the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInstanceAccessControlAttributeConfiguration`](crate::client::fluent_builders::UpdateInstanceAccessControlAttributeConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateInstanceAccessControlAttributeConfiguration::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::UpdateInstanceAccessControlAttributeConfiguration::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed.</p>
    ///   - [`instance_access_control_attribute_configuration(InstanceAccessControlAttributeConfiguration)`](crate::client::fluent_builders::UpdateInstanceAccessControlAttributeConfiguration::instance_access_control_attribute_configuration) / [`set_instance_access_control_attribute_configuration(Option<InstanceAccessControlAttributeConfiguration>)`](crate::client::fluent_builders::UpdateInstanceAccessControlAttributeConfiguration::set_instance_access_control_attribute_configuration): <p>Updates the attributes for your ABAC configuration.</p>
    /// - On success, responds with [`UpdateInstanceAccessControlAttributeConfigurationOutput`](crate::output::UpdateInstanceAccessControlAttributeConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateInstanceAccessControlAttributeConfigurationError>`](crate::error::UpdateInstanceAccessControlAttributeConfigurationError)
    pub fn update_instance_access_control_attribute_configuration(
        &self,
    ) -> fluent_builders::UpdateInstanceAccessControlAttributeConfiguration {
        fluent_builders::UpdateInstanceAccessControlAttributeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePermissionSet`](crate::client::fluent_builders::UpdatePermissionSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePermissionSet::instance_arn) / [`set_instance_arn(Option<String>)`](crate::client::fluent_builders::UpdatePermissionSet::set_instance_arn): <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`permission_set_arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePermissionSet::permission_set_arn) / [`set_permission_set_arn(Option<String>)`](crate::client::fluent_builders::UpdatePermissionSet::set_permission_set_arn): <p>The ARN of the permission set.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePermissionSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePermissionSet::set_description): <p>The description of the <code>PermissionSet</code>.</p>
    ///   - [`session_duration(impl Into<String>)`](crate::client::fluent_builders::UpdatePermissionSet::session_duration) / [`set_session_duration(Option<String>)`](crate::client::fluent_builders::UpdatePermissionSet::set_session_duration): <p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>
    ///   - [`relay_state(impl Into<String>)`](crate::client::fluent_builders::UpdatePermissionSet::relay_state) / [`set_relay_state(Option<String>)`](crate::client::fluent_builders::UpdatePermissionSet::set_relay_state): <p>Used to redirect users within the application during the federation authentication process.</p>
    /// - On success, responds with [`UpdatePermissionSetOutput`](crate::output::UpdatePermissionSetOutput)

    /// - On failure, responds with [`SdkError<UpdatePermissionSetError>`](crate::error::UpdatePermissionSetError)
    pub fn update_permission_set(&self) -> fluent_builders::UpdatePermissionSet {
        fluent_builders::UpdatePermissionSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AttachManagedPolicyToPermissionSet`.
    ///
    /// <p>Attaches an IAM managed policy ARN to a permission set.</p> <note>
    /// <p>If the permission set is already referenced by one or more account assignments, you will need to call <code> <code>ProvisionPermissionSet</code> </code> after this operation. Calling <code>ProvisionPermissionSet</code> applies the corresponding IAM policy updates to all assigned accounts.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachManagedPolicyToPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::attach_managed_policy_to_permission_set_input::Builder,
    }
    impl AttachManagedPolicyToPermissionSet {
        /// Creates a new `AttachManagedPolicyToPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachManagedPolicyToPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AttachManagedPolicyToPermissionSetError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> that the managed policy should be attached to.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> that the managed policy should be attached to.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn managed_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_policy_arn(input.into());
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn set_managed_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccountAssignment`.
    ///
    /// <p>Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.</p> <note>
    /// <p>The term <i>principal</i> here refers to a user or group that is defined in Amazon Web Services SSO.</p>
    /// </note> <note>
    /// <p>As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the SSO-created IAM role. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call <code> <code>ProvisionPermissionSet</code> </code> to make these updates.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccountAssignment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_account_assignment_input::Builder,
    }
    impl CreateAccountAssignment {
        /// Creates a new `CreateAccountAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountAssignmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>The ARN of the permission set that the admin wants to grant the principal access to.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set that the admin wants to grant the principal access to.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.inner = self.inner.principal_type(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.inner = self.inner.set_principal_type(input);
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInstanceAccessControlAttributeConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_instance_access_control_attribute_configuration_input::Builder,
    }
    impl CreateInstanceAccessControlAttributeConfiguration {
        /// Creates a new `CreateInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceAccessControlAttributeConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateInstanceAccessControlAttributeConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>
        pub fn instance_access_control_attribute_configuration(
            mut self,
            input: crate::model::InstanceAccessControlAttributeConfiguration,
        ) -> Self {
            self.inner = self
                .inner
                .instance_access_control_attribute_configuration(input);
            self
        }
        /// <p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>
        pub fn set_instance_access_control_attribute_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_instance_access_control_attribute_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePermissionSet`.
    ///
    /// <p>Creates a permission set within a specified SSO instance.</p> <note>
    /// <p>To grant users and groups access to Amazon Web Services account resources, use <code> <code>CreateAccountAssignment</code> </code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_permission_set_input::Builder,
    }
    impl CreatePermissionSet {
        /// Creates a new `CreatePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePermissionSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>PermissionSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>PermissionSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>
        pub fn session_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_duration(input.into());
            self
        }
        /// <p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>
        pub fn set_session_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_duration(input);
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn relay_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relay_state(input.into());
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn set_relay_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_relay_state(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new <code>PermissionSet</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the new <code>PermissionSet</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountAssignment`.
    ///
    /// <p>Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccountAssignment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_account_assignment_input::Builder,
    }
    impl DeleteAccountAssignment {
        /// Creates a new `DeleteAccountAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountAssignmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.inner = self.inner.principal_type(input);
            self
        }
        /// <p>The entity type for which the assignment will be deleted.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.inner = self.inner.set_principal_type(input);
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInlinePolicyFromPermissionSet`.
    ///
    /// <p>Deletes the inline policy from a specified permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInlinePolicyFromPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_inline_policy_from_permission_set_input::Builder,
    }
    impl DeleteInlinePolicyFromPermissionSet {
        /// Creates a new `DeleteInlinePolicyFromPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInlinePolicyFromPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteInlinePolicyFromPermissionSetError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set that will be used to remove access.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInstanceAccessControlAttributeConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_instance_access_control_attribute_configuration_input::Builder,
    }
    impl DeleteInstanceAccessControlAttributeConfiguration {
        /// Creates a new `DeleteInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstanceAccessControlAttributeConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteInstanceAccessControlAttributeConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePermissionSet`.
    ///
    /// <p>Deletes the specified permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_permission_set_input::Builder,
    }
    impl DeletePermissionSet {
        /// Creates a new `DeletePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePermissionSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set that should be deleted.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set that should be deleted.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAssignmentCreationStatus`.
    ///
    /// <p>Describes the status of the assignment creation request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAssignmentCreationStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_assignment_creation_status_input::Builder,
    }
    impl DescribeAccountAssignmentCreationStatus {
        /// Creates a new `DescribeAccountAssignmentCreationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAssignmentCreationStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAccountAssignmentCreationStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn account_assignment_creation_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .account_assignment_creation_request_id(input.into());
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn set_account_assignment_creation_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_assignment_creation_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAssignmentDeletionStatus`.
    ///
    /// <p>Describes the status of the assignment deletion request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAssignmentDeletionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_assignment_deletion_status_input::Builder,
    }
    impl DescribeAccountAssignmentDeletionStatus {
        /// Creates a new `DescribeAccountAssignmentDeletionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAssignmentDeletionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAccountAssignmentDeletionStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn account_assignment_deletion_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .account_assignment_deletion_request_id(input.into());
            self
        }
        /// <p>The identifier that is used to track the request operation progress.</p>
        pub fn set_account_assignment_deletion_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_assignment_deletion_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Returns the list of Amazon Web Services SSO identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstanceAccessControlAttributeConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner:
            crate::input::describe_instance_access_control_attribute_configuration_input::Builder,
    }
    impl DescribeInstanceAccessControlAttributeConfiguration {
        /// Creates a new `DescribeInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceAccessControlAttributeConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInstanceAccessControlAttributeConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePermissionSet`.
    ///
    /// <p>Gets the details of the permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_permission_set_input::Builder,
    }
    impl DescribePermissionSet {
        /// Creates a new `DescribePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePermissionSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePermissionSetProvisioningStatus`.
    ///
    /// <p>Describes the status for the given permission set provisioning request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePermissionSetProvisioningStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_permission_set_provisioning_status_input::Builder,
    }
    impl DescribePermissionSetProvisioningStatus {
        /// Creates a new `DescribePermissionSetProvisioningStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePermissionSetProvisioningStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribePermissionSetProvisioningStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier that is provided by the <code>ProvisionPermissionSet</code> call to retrieve the current status of the provisioning workflow.</p>
        pub fn provision_permission_set_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.provision_permission_set_request_id(input.into());
            self
        }
        /// <p>The identifier that is provided by the <code>ProvisionPermissionSet</code> call to retrieve the current status of the provisioning workflow.</p>
        pub fn set_provision_permission_set_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provision_permission_set_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachManagedPolicyFromPermissionSet`.
    ///
    /// <p>Detaches the attached IAM managed policy ARN from the specified permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachManagedPolicyFromPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detach_managed_policy_from_permission_set_input::Builder,
    }
    impl DetachManagedPolicyFromPermissionSet {
        /// Creates a new `DetachManagedPolicyFromPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachManagedPolicyFromPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DetachManagedPolicyFromPermissionSetError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the policy should be detached.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the policy should be detached.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn managed_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_policy_arn(input.into());
            self
        }
        /// <p>The IAM managed policy ARN to be attached to a permission set.</p>
        pub fn set_managed_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInlinePolicyForPermissionSet`.
    ///
    /// <p>Obtains the inline policy assigned to the permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInlinePolicyForPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_inline_policy_for_permission_set_input::Builder,
    }
    impl GetInlinePolicyForPermissionSet {
        /// Creates a new `GetInlinePolicyForPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInlinePolicyForPermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInlinePolicyForPermissionSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAssignmentCreationStatus`.
    ///
    /// <p>Lists the status of the Amazon Web Services account assignment creation requests for a specified SSO instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountAssignmentCreationStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_account_assignment_creation_status_input::Builder,
    }
    impl ListAccountAssignmentCreationStatus {
        /// Creates a new `ListAccountAssignmentCreationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAssignmentCreationStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAccountAssignmentCreationStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountAssignmentCreationStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAccountAssignmentCreationStatusPaginator {
            crate::paginator::ListAccountAssignmentCreationStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, input: crate::model::OperationStatusFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAssignmentDeletionStatus`.
    ///
    /// <p>Lists the status of the Amazon Web Services account assignment deletion requests for a specified SSO instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountAssignmentDeletionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_account_assignment_deletion_status_input::Builder,
    }
    impl ListAccountAssignmentDeletionStatus {
        /// Creates a new `ListAccountAssignmentDeletionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAssignmentDeletionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAccountAssignmentDeletionStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountAssignmentDeletionStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAccountAssignmentDeletionStatusPaginator {
            crate::paginator::ListAccountAssignmentDeletionStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, input: crate::model::OperationStatusFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAssignments`.
    ///
    /// <p>Lists the assignee of the specified Amazon Web Services account with the specified permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountAssignments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_account_assignments_input::Builder,
    }
    impl ListAccountAssignments {
        /// Creates a new `ListAccountAssignments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAssignmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountAssignmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountAssignmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountAssignmentsPaginator {
            crate::paginator::ListAccountAssignmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ARN of the permission set from which to list assignments.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set from which to list assignments.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountsForProvisionedPermissionSet`.
    ///
    /// <p>Lists all the Amazon Web Services accounts where the specified permission set is provisioned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountsForProvisionedPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_accounts_for_provisioned_permission_set_input::Builder,
    }
    impl ListAccountsForProvisionedPermissionSet {
        /// Creates a new `ListAccountsForProvisionedPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsForProvisionedPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAccountsForProvisionedPermissionSetError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountsForProvisionedPermissionSetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAccountsForProvisionedPermissionSetPaginator {
            crate::paginator::ListAccountsForProvisionedPermissionSetPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the associated Amazon Web Services accounts will be listed.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> from which the associated Amazon Web Services accounts will be listed.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
        pub fn provisioning_status(mut self, input: crate::model::ProvisioningStatus) -> Self {
            self.inner = self.inner.provisioning_status(input);
            self
        }
        /// <p>The permission set provisioning status for an Amazon Web Services account.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::ProvisioningStatus>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_status(input);
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstances`.
    ///
    /// <p>Lists the SSO instances that the caller has access to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_instances_input::Builder,
    }
    impl ListInstances {
        /// Creates a new `ListInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstancesPaginator {
            crate::paginator::ListInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to display for the instance.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the instance.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedPoliciesInPermissionSet`.
    ///
    /// <p>Lists the IAM managed policy that is attached to a specified permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListManagedPoliciesInPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_managed_policies_in_permission_set_input::Builder,
    }
    impl ListManagedPoliciesInPermissionSet {
        /// Creates a new `ListManagedPoliciesInPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedPoliciesInPermissionSetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListManagedPoliciesInPermissionSetError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListManagedPoliciesInPermissionSetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListManagedPoliciesInPermissionSetPaginator {
            crate::paginator::ListManagedPoliciesInPermissionSetPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> whose managed policies will be listed.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>PermissionSet</code> whose managed policies will be listed.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the <code>PermissionSet</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissionSetProvisioningStatus`.
    ///
    /// <p>Lists the status of the permission set provisioning requests for a specified SSO instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissionSetProvisioningStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_permission_set_provisioning_status_input::Builder,
    }
    impl ListPermissionSetProvisioningStatus {
        /// Creates a new `ListPermissionSetProvisioningStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionSetProvisioningStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListPermissionSetProvisioningStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionSetProvisioningStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListPermissionSetProvisioningStatusPaginator {
            crate::paginator::ListPermissionSetProvisioningStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn filter(mut self, input: crate::model::OperationStatusFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters results based on the passed attribute value.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OperationStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissionSets`.
    ///
    /// <p>Lists the <code>PermissionSet</code>s in an SSO instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissionSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_permission_sets_input::Builder,
    }
    impl ListPermissionSets {
        /// Creates a new `ListPermissionSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPermissionSetsPaginator {
            crate::paginator::ListPermissionSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissionSetsProvisionedToAccount`.
    ///
    /// <p>Lists all the permission sets that are provisioned to a specified Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissionSetsProvisionedToAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_permission_sets_provisioned_to_account_input::Builder,
    }
    impl ListPermissionSetsProvisionedToAccount {
        /// Creates a new `ListPermissionSetsProvisionedToAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionSetsProvisionedToAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListPermissionSetsProvisionedToAccountError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionSetsProvisionedToAccountPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListPermissionSetsProvisionedToAccountPaginator {
            crate::paginator::ListPermissionSetsProvisionedToAccountPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The status object for the permission set provisioning operation.</p>
        pub fn provisioning_status(mut self, input: crate::model::ProvisioningStatus) -> Self {
            self.inner = self.inner.provisioning_status(input);
            self
        }
        /// <p>The status object for the permission set provisioning operation.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::ProvisioningStatus>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_status(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display for the assignment.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that are attached to a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvisionPermissionSet`.
    ///
    /// <p>The process by which a specified permission set is provisioned to the specified target.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ProvisionPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::provision_permission_set_input::Builder,
    }
    impl ProvisionPermissionSet {
        /// Creates a new `ProvisionPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvisionPermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvisionPermissionSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn target_type(mut self, input: crate::model::ProvisionTargetType) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionTargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInlinePolicyToPermissionSet`.
    ///
    /// <p>Attaches an IAM inline policy to a permission set.</p> <note>
    /// <p>If the permission set is already referenced by one or more account assignments, you will need to call <code> <code>ProvisionPermissionSet</code> </code> after this action to apply the corresponding IAM policy updates to all assigned accounts.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutInlinePolicyToPermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_inline_policy_to_permission_set_input::Builder,
    }
    impl PutInlinePolicyToPermissionSet {
        /// Creates a new `PutInlinePolicyToPermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInlinePolicyToPermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInlinePolicyToPermissionSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The IAM inline policy to attach to a <code>PermissionSet</code>.</p>
        pub fn inline_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.inline_policy(input.into());
            self
        }
        /// <p>The IAM inline policy to attach to a <code>PermissionSet</code>.</p>
        pub fn set_inline_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_inline_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a set of tags with a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of key-value pairs that are used to manage the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A set of key-value pairs that are used to manage the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Disassociates a set of tags from a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource with the tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of tags that are attached to the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of tags that are attached to the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceAccessControlAttributeConfiguration`.
    ///
    /// <p>Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO replaces the attribute value with the value from the Amazon Web Services SSO identity store. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInstanceAccessControlAttributeConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_instance_access_control_attribute_configuration_input::Builder,
    }
    impl UpdateInstanceAccessControlAttributeConfiguration {
        /// Creates a new `UpdateInstanceAccessControlAttributeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInstanceAccessControlAttributeConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateInstanceAccessControlAttributeConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>Updates the attributes for your ABAC configuration.</p>
        pub fn instance_access_control_attribute_configuration(
            mut self,
            input: crate::model::InstanceAccessControlAttributeConfiguration,
        ) -> Self {
            self.inner = self
                .inner
                .instance_access_control_attribute_configuration(input);
            self
        }
        /// <p>Updates the attributes for your ABAC configuration.</p>
        pub fn set_instance_access_control_attribute_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessControlAttributeConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_instance_access_control_attribute_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePermissionSet`.
    ///
    /// <p>Updates an existing permission set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePermissionSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_permission_set_input::Builder,
    }
    impl UpdatePermissionSet {
        /// Creates a new `UpdatePermissionSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePermissionSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePermissionSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_set_arn(input.into());
            self
        }
        /// <p>The ARN of the permission set.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_set_arn(input);
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the <code>PermissionSet</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>
        pub fn session_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_duration(input.into());
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>
        pub fn set_session_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_duration(input);
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn relay_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relay_state(input.into());
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication process.</p>
        pub fn set_relay_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_relay_state(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
