// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Specifies the attributes to add to your attribute-based access control (ABAC)
/// configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceAccessControlAttributeConfiguration {
    /// <p>Lists the attributes that are configured for ABAC in the specified Amazon Web Services SSO
    /// instance.</p>
    pub access_control_attributes:
        std::option::Option<std::vec::Vec<crate::model::AccessControlAttribute>>,
}
impl InstanceAccessControlAttributeConfiguration {
    /// <p>Lists the attributes that are configured for ABAC in the specified Amazon Web Services SSO
    /// instance.</p>
    pub fn access_control_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::AccessControlAttribute]> {
        self.access_control_attributes.as_deref()
    }
}
impl std::fmt::Debug for InstanceAccessControlAttributeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceAccessControlAttributeConfiguration");
        formatter.field("access_control_attributes", &self.access_control_attributes);
        formatter.finish()
    }
}
/// See [`InstanceAccessControlAttributeConfiguration`](crate::model::InstanceAccessControlAttributeConfiguration)
pub mod instance_access_control_attribute_configuration {
    /// A builder for [`InstanceAccessControlAttributeConfiguration`](crate::model::InstanceAccessControlAttributeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_control_attributes:
            std::option::Option<std::vec::Vec<crate::model::AccessControlAttribute>>,
    }
    impl Builder {
        /// Appends an item to `access_control_attributes`.
        ///
        /// To override the contents of this collection use [`set_access_control_attributes`](Self::set_access_control_attributes).
        ///
        /// <p>Lists the attributes that are configured for ABAC in the specified Amazon Web Services SSO
        /// instance.</p>
        pub fn access_control_attributes(
            mut self,
            input: impl Into<crate::model::AccessControlAttribute>,
        ) -> Self {
            let mut v = self.access_control_attributes.unwrap_or_default();
            v.push(input.into());
            self.access_control_attributes = Some(v);
            self
        }
        /// <p>Lists the attributes that are configured for ABAC in the specified Amazon Web Services SSO
        /// instance.</p>
        pub fn set_access_control_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessControlAttribute>>,
        ) -> Self {
            self.access_control_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceAccessControlAttributeConfiguration`](crate::model::InstanceAccessControlAttributeConfiguration)
        pub fn build(self) -> crate::model::InstanceAccessControlAttributeConfiguration {
            crate::model::InstanceAccessControlAttributeConfiguration {
                access_control_attributes: self.access_control_attributes,
            }
        }
    }
}
impl InstanceAccessControlAttributeConfiguration {
    /// Creates a new builder-style object to manufacture [`InstanceAccessControlAttributeConfiguration`](crate::model::InstanceAccessControlAttributeConfiguration)
    pub fn builder() -> crate::model::instance_access_control_attribute_configuration::Builder {
        crate::model::instance_access_control_attribute_configuration::Builder::default()
    }
}

/// <p>These are Amazon Web Services SSO identity store attributes that you can configure for use in
/// attributes-based access control (ABAC). You can create permissions policies that determine who
/// can access your Amazon Web Services resources based upon the configured attribute values. When you enable
/// ABAC and specify <code>AccessControlAttributes</code>, Amazon Web Services SSO passes the attribute values
/// of the authenticated user into IAM for use in policy evaluation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlAttribute {
    /// <p>The name of the attribute associated with your identities in your identity source. This is
    /// used to map a specified attribute in your identity source with an attribute in Amazon Web Services
    /// SSO.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value used for mapping a specified attribute to an identity source.</p>
    pub value: std::option::Option<crate::model::AccessControlAttributeValue>,
}
impl AccessControlAttribute {
    /// <p>The name of the attribute associated with your identities in your identity source. This is
    /// used to map a specified attribute in your identity source with an attribute in Amazon Web Services
    /// SSO.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value used for mapping a specified attribute to an identity source.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::AccessControlAttributeValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for AccessControlAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlAttribute");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AccessControlAttribute`](crate::model::AccessControlAttribute)
pub mod access_control_attribute {
    /// A builder for [`AccessControlAttribute`](crate::model::AccessControlAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::AccessControlAttributeValue>,
    }
    impl Builder {
        /// <p>The name of the attribute associated with your identities in your identity source. This is
        /// used to map a specified attribute in your identity source with an attribute in Amazon Web Services
        /// SSO.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the attribute associated with your identities in your identity source. This is
        /// used to map a specified attribute in your identity source with an attribute in Amazon Web Services
        /// SSO.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value used for mapping a specified attribute to an identity source.</p>
        pub fn value(mut self, input: crate::model::AccessControlAttributeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value used for mapping a specified attribute to an identity source.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::AccessControlAttributeValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlAttribute`](crate::model::AccessControlAttribute)
        pub fn build(self) -> crate::model::AccessControlAttribute {
            crate::model::AccessControlAttribute {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl AccessControlAttribute {
    /// Creates a new builder-style object to manufacture [`AccessControlAttribute`](crate::model::AccessControlAttribute)
    pub fn builder() -> crate::model::access_control_attribute::Builder {
        crate::model::access_control_attribute::Builder::default()
    }
}

/// <p>The value used for mapping a specified attribute to an identity source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlAttributeValue {
    /// <p>The identity source to use when mapping a specified attribute to Amazon Web Services SSO.</p>
    pub source: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AccessControlAttributeValue {
    /// <p>The identity source to use when mapping a specified attribute to Amazon Web Services SSO.</p>
    pub fn source(&self) -> std::option::Option<&[std::string::String]> {
        self.source.as_deref()
    }
}
impl std::fmt::Debug for AccessControlAttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlAttributeValue");
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`AccessControlAttributeValue`](crate::model::AccessControlAttributeValue)
pub mod access_control_attribute_value {
    /// A builder for [`AccessControlAttributeValue`](crate::model::AccessControlAttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `source`.
        ///
        /// To override the contents of this collection use [`set_source`](Self::set_source).
        ///
        /// <p>The identity source to use when mapping a specified attribute to Amazon Web Services SSO.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source.unwrap_or_default();
            v.push(input.into());
            self.source = Some(v);
            self
        }
        /// <p>The identity source to use when mapping a specified attribute to Amazon Web Services SSO.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlAttributeValue`](crate::model::AccessControlAttributeValue)
        pub fn build(self) -> crate::model::AccessControlAttributeValue {
            crate::model::AccessControlAttributeValue {
                source: self.source,
            }
        }
    }
}
impl AccessControlAttributeValue {
    /// Creates a new builder-style object to manufacture [`AccessControlAttributeValue`](crate::model::AccessControlAttributeValue)
    pub fn builder() -> crate::model::access_control_attribute_value::Builder {
        crate::model::access_control_attribute_value::Builder::default()
    }
}

/// <p>A set of key-value pairs that are used to manage the resource. Tags can only be applied to
/// permission sets and cannot be applied to corresponding roles that Amazon Web Services SSO creates in Amazon Web Services
/// accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key for the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key for the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A structure that is used to provide the status of the provisioning operation for a
/// specified permission set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionSetProvisioningStatus {
    /// <p>The status of the permission set provisioning process.</p>
    pub status: std::option::Option<crate::model::StatusValues>,
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set that is being provisioned. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The message that contains an error or exception in case of an operation failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date that the permission set was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl PermissionSetProvisioningStatus {
    /// <p>The status of the permission set provisioning process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusValues> {
        self.status.as_ref()
    }
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ARN of the permission set that is being provisioned. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The message that contains an error or exception in case of an operation failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date that the permission set was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
}
impl std::fmt::Debug for PermissionSetProvisioningStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionSetProvisioningStatus");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`PermissionSetProvisioningStatus`](crate::model::PermissionSetProvisioningStatus)
pub mod permission_set_provisioning_status {
    /// A builder for [`PermissionSetProvisioningStatus`](crate::model::PermissionSetProvisioningStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::StatusValues>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The status of the permission set provisioning process.</p>
        pub fn status(mut self, input: crate::model::StatusValues) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the permission set provisioning process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusValues>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account from which to list the assignments.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ARN of the permission set that is being provisioned. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set that is being provisioned. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The message that contains an error or exception in case of an operation failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The message that contains an error or exception in case of an operation failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionSetProvisioningStatus`](crate::model::PermissionSetProvisioningStatus)
        pub fn build(self) -> crate::model::PermissionSetProvisioningStatus {
            crate::model::PermissionSetProvisioningStatus {
                status: self.status,
                request_id: self.request_id,
                account_id: self.account_id,
                permission_set_arn: self.permission_set_arn,
                failure_reason: self.failure_reason,
                created_date: self.created_date,
            }
        }
    }
}
impl PermissionSetProvisioningStatus {
    /// Creates a new builder-style object to manufacture [`PermissionSetProvisioningStatus`](crate::model::PermissionSetProvisioningStatus)
    pub fn builder() -> crate::model::permission_set_provisioning_status::Builder {
        crate::model::permission_set_provisioning_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusValues {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusValues {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => StatusValues::Failed,
            "IN_PROGRESS" => StatusValues::InProgress,
            "SUCCEEDED" => StatusValues::Succeeded,
            other => StatusValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusValues::from(s))
    }
}
impl StatusValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusValues::Failed => "FAILED",
            StatusValues::InProgress => "IN_PROGRESS",
            StatusValues::Succeeded => "SUCCEEDED",
            StatusValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for StatusValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisionTargetType {
    #[allow(missing_docs)] // documentation missing in model
    AllProvisionedAccounts,
    #[allow(missing_docs)] // documentation missing in model
    AwsAccount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisionTargetType {
    fn from(s: &str) -> Self {
        match s {
            "ALL_PROVISIONED_ACCOUNTS" => ProvisionTargetType::AllProvisionedAccounts,
            "AWS_ACCOUNT" => ProvisionTargetType::AwsAccount,
            other => ProvisionTargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisionTargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisionTargetType::from(s))
    }
}
impl ProvisionTargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisionTargetType::AllProvisionedAccounts => "ALL_PROVISIONED_ACCOUNTS",
            ProvisionTargetType::AwsAccount => "AWS_ACCOUNT",
            ProvisionTargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_PROVISIONED_ACCOUNTS", "AWS_ACCOUNT"]
    }
}
impl AsRef<str> for ProvisionTargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisioningStatus {
    #[allow(missing_docs)] // documentation missing in model
    LatestPermissionSetNotProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    LatestPermissionSetProvisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisioningStatus {
    fn from(s: &str) -> Self {
        match s {
            "LATEST_PERMISSION_SET_NOT_PROVISIONED" => {
                ProvisioningStatus::LatestPermissionSetNotProvisioned
            }
            "LATEST_PERMISSION_SET_PROVISIONED" => {
                ProvisioningStatus::LatestPermissionSetProvisioned
            }
            other => ProvisioningStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisioningStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisioningStatus::from(s))
    }
}
impl ProvisioningStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisioningStatus::LatestPermissionSetNotProvisioned => {
                "LATEST_PERMISSION_SET_NOT_PROVISIONED"
            }
            ProvisioningStatus::LatestPermissionSetProvisioned => {
                "LATEST_PERMISSION_SET_PROVISIONED"
            }
            ProvisioningStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "LATEST_PERMISSION_SET_NOT_PROVISIONED",
            "LATEST_PERMISSION_SET_PROVISIONED",
        ]
    }
}
impl AsRef<str> for ProvisioningStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the permission set provisioning status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionSetProvisioningStatusMetadata {
    /// <p>The status of the permission set provisioning process.</p>
    pub status: std::option::Option<crate::model::StatusValues>,
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The date that the permission set was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl PermissionSetProvisioningStatusMetadata {
    /// <p>The status of the permission set provisioning process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusValues> {
        self.status.as_ref()
    }
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The date that the permission set was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
}
impl std::fmt::Debug for PermissionSetProvisioningStatusMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionSetProvisioningStatusMetadata");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`PermissionSetProvisioningStatusMetadata`](crate::model::PermissionSetProvisioningStatusMetadata)
pub mod permission_set_provisioning_status_metadata {
    /// A builder for [`PermissionSetProvisioningStatusMetadata`](crate::model::PermissionSetProvisioningStatusMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::StatusValues>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The status of the permission set provisioning process.</p>
        pub fn status(mut self, input: crate::model::StatusValues) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the permission set provisioning process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusValues>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionSetProvisioningStatusMetadata`](crate::model::PermissionSetProvisioningStatusMetadata)
        pub fn build(self) -> crate::model::PermissionSetProvisioningStatusMetadata {
            crate::model::PermissionSetProvisioningStatusMetadata {
                status: self.status,
                request_id: self.request_id,
                created_date: self.created_date,
            }
        }
    }
}
impl PermissionSetProvisioningStatusMetadata {
    /// Creates a new builder-style object to manufacture [`PermissionSetProvisioningStatusMetadata`](crate::model::PermissionSetProvisioningStatusMetadata)
    pub fn builder() -> crate::model::permission_set_provisioning_status_metadata::Builder {
        crate::model::permission_set_provisioning_status_metadata::Builder::default()
    }
}

/// <p>Filters he operation status list based on the passed attribute value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationStatusFilter {
    /// <p>Filters the list operations result based on the status attribute.</p>
    pub status: std::option::Option<crate::model::StatusValues>,
}
impl OperationStatusFilter {
    /// <p>Filters the list operations result based on the status attribute.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusValues> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for OperationStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationStatusFilter");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`OperationStatusFilter`](crate::model::OperationStatusFilter)
pub mod operation_status_filter {
    /// A builder for [`OperationStatusFilter`](crate::model::OperationStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::StatusValues>,
    }
    impl Builder {
        /// <p>Filters the list operations result based on the status attribute.</p>
        pub fn status(mut self, input: crate::model::StatusValues) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Filters the list operations result based on the status attribute.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusValues>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationStatusFilter`](crate::model::OperationStatusFilter)
        pub fn build(self) -> crate::model::OperationStatusFilter {
            crate::model::OperationStatusFilter {
                status: self.status,
            }
        }
    }
}
impl OperationStatusFilter {
    /// Creates a new builder-style object to manufacture [`OperationStatusFilter`](crate::model::OperationStatusFilter)
    pub fn builder() -> crate::model::operation_status_filter::Builder {
        crate::model::operation_status_filter::Builder::default()
    }
}

/// <p>A structure that stores the details of the IAM managed policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachedManagedPolicy {
    /// <p>The name of the IAM managed policy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM managed policy. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl AttachedManagedPolicy {
    /// <p>The name of the IAM managed policy.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the IAM managed policy. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for AttachedManagedPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachedManagedPolicy");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`AttachedManagedPolicy`](crate::model::AttachedManagedPolicy)
pub mod attached_managed_policy {
    /// A builder for [`AttachedManagedPolicy`](crate::model::AttachedManagedPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM managed policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the IAM managed policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the IAM managed policy. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM managed policy. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachedManagedPolicy`](crate::model::AttachedManagedPolicy)
        pub fn build(self) -> crate::model::AttachedManagedPolicy {
            crate::model::AttachedManagedPolicy {
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl AttachedManagedPolicy {
    /// Creates a new builder-style object to manufacture [`AttachedManagedPolicy`](crate::model::AttachedManagedPolicy)
    pub fn builder() -> crate::model::attached_managed_policy::Builder {
        crate::model::attached_managed_policy::Builder::default()
    }
}

/// <p>Provides information about the SSO instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMetadata {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the identity store that is connected to the SSO instance.</p>
    pub identity_store_id: std::option::Option<std::string::String>,
}
impl InstanceMetadata {
    /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The identifier of the identity store that is connected to the SSO instance.</p>
    pub fn identity_store_id(&self) -> std::option::Option<&str> {
        self.identity_store_id.as_deref()
    }
}
impl std::fmt::Debug for InstanceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMetadata");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("identity_store_id", &self.identity_store_id);
        formatter.finish()
    }
}
/// See [`InstanceMetadata`](crate::model::InstanceMetadata)
pub mod instance_metadata {
    /// A builder for [`InstanceMetadata`](crate::model::InstanceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) identity_store_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The identifier of the identity store that is connected to the SSO instance.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_store_id = Some(input.into());
            self
        }
        /// <p>The identifier of the identity store that is connected to the SSO instance.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_store_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMetadata`](crate::model::InstanceMetadata)
        pub fn build(self) -> crate::model::InstanceMetadata {
            crate::model::InstanceMetadata {
                instance_arn: self.instance_arn,
                identity_store_id: self.identity_store_id,
            }
        }
    }
}
impl InstanceMetadata {
    /// Creates a new builder-style object to manufacture [`InstanceMetadata`](crate::model::InstanceMetadata)
    pub fn builder() -> crate::model::instance_metadata::Builder {
        crate::model::instance_metadata::Builder::default()
    }
}

/// <p>The assignment that indicates a principal's limited access to a specified Amazon Web Services account
/// with a specified permission set.</p>
/// <note>
/// <p>The term <i>principal</i> here refers to a user or group that is defined
/// in Amazon Web Services SSO.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAssignment {
    /// <p>The identifier of the Amazon Web Services account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be created.</p>
    pub principal_type: std::option::Option<crate::model::PrincipalType>,
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl AccountAssignment {
    /// <p>The identifier of the Amazon Web Services account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The entity type for which the assignment will be created.</p>
    pub fn principal_type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.principal_type.as_ref()
    }
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for AccountAssignment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAssignment");
        formatter.field("account_id", &self.account_id);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("principal_type", &self.principal_type);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}
/// See [`AccountAssignment`](crate::model::AccountAssignment)
pub mod account_assignment {
    /// A builder for [`AccountAssignment`](crate::model::AccountAssignment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAssignment`](crate::model::AccountAssignment)
        pub fn build(self) -> crate::model::AccountAssignment {
            crate::model::AccountAssignment {
                account_id: self.account_id,
                permission_set_arn: self.permission_set_arn,
                principal_type: self.principal_type,
                principal_id: self.principal_id,
            }
        }
    }
}
impl AccountAssignment {
    /// Creates a new builder-style object to manufacture [`AccountAssignment`](crate::model::AccountAssignment)
    pub fn builder() -> crate::model::account_assignment::Builder {
        crate::model::account_assignment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrincipalType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrincipalType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => PrincipalType::Group,
            "USER" => PrincipalType::User,
            other => PrincipalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrincipalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrincipalType::from(s))
    }
}
impl PrincipalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrincipalType::Group => "GROUP",
            PrincipalType::User => "USER",
            PrincipalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "USER"]
    }
}
impl AsRef<str> for PrincipalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the <a>AccountAssignment</a> creation
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAssignmentOperationStatusMetadata {
    /// <p>The status of the permission set provisioning process.</p>
    pub status: std::option::Option<crate::model::StatusValues>,
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The date that the permission set was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl AccountAssignmentOperationStatusMetadata {
    /// <p>The status of the permission set provisioning process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusValues> {
        self.status.as_ref()
    }
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The date that the permission set was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
}
impl std::fmt::Debug for AccountAssignmentOperationStatusMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAssignmentOperationStatusMetadata");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`AccountAssignmentOperationStatusMetadata`](crate::model::AccountAssignmentOperationStatusMetadata)
pub mod account_assignment_operation_status_metadata {
    /// A builder for [`AccountAssignmentOperationStatusMetadata`](crate::model::AccountAssignmentOperationStatusMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::StatusValues>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The status of the permission set provisioning process.</p>
        pub fn status(mut self, input: crate::model::StatusValues) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the permission set provisioning process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusValues>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAssignmentOperationStatusMetadata`](crate::model::AccountAssignmentOperationStatusMetadata)
        pub fn build(self) -> crate::model::AccountAssignmentOperationStatusMetadata {
            crate::model::AccountAssignmentOperationStatusMetadata {
                status: self.status,
                request_id: self.request_id,
                created_date: self.created_date,
            }
        }
    }
}
impl AccountAssignmentOperationStatusMetadata {
    /// Creates a new builder-style object to manufacture [`AccountAssignmentOperationStatusMetadata`](crate::model::AccountAssignmentOperationStatusMetadata)
    pub fn builder() -> crate::model::account_assignment_operation_status_metadata::Builder {
        crate::model::account_assignment_operation_status_metadata::Builder::default()
    }
}

/// <p>An entity that contains IAM policies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionSet {
    /// <p>The name of the permission set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The description of the <a>PermissionSet</a>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the permission set was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The length of time that the application user sessions are valid for in the ISO-8601
    /// standard.</p>
    pub session_duration: std::option::Option<std::string::String>,
    /// <p>Used to redirect users within the application during the federation authentication
    /// process.</p>
    pub relay_state: std::option::Option<std::string::String>,
}
impl PermissionSet {
    /// <p>The name of the permission set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The description of the <a>PermissionSet</a>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the permission set was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The length of time that the application user sessions are valid for in the ISO-8601
    /// standard.</p>
    pub fn session_duration(&self) -> std::option::Option<&str> {
        self.session_duration.as_deref()
    }
    /// <p>Used to redirect users within the application during the federation authentication
    /// process.</p>
    pub fn relay_state(&self) -> std::option::Option<&str> {
        self.relay_state.as_deref()
    }
}
impl std::fmt::Debug for PermissionSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionSet");
        formatter.field("name", &self.name);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("session_duration", &self.session_duration);
        formatter.field("relay_state", &self.relay_state);
        formatter.finish()
    }
}
/// See [`PermissionSet`](crate::model::PermissionSet)
pub mod permission_set {
    /// A builder for [`PermissionSet`](crate::model::PermissionSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) session_duration: std::option::Option<std::string::String>,
        pub(crate) relay_state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the permission set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the permission set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The description of the <a>PermissionSet</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <a>PermissionSet</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601
        /// standard.</p>
        pub fn session_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_duration = Some(input.into());
            self
        }
        /// <p>The length of time that the application user sessions are valid for in the ISO-8601
        /// standard.</p>
        pub fn set_session_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_duration = input;
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication
        /// process.</p>
        pub fn relay_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.relay_state = Some(input.into());
            self
        }
        /// <p>Used to redirect users within the application during the federation authentication
        /// process.</p>
        pub fn set_relay_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.relay_state = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionSet`](crate::model::PermissionSet)
        pub fn build(self) -> crate::model::PermissionSet {
            crate::model::PermissionSet {
                name: self.name,
                permission_set_arn: self.permission_set_arn,
                description: self.description,
                created_date: self.created_date,
                session_duration: self.session_duration,
                relay_state: self.relay_state,
            }
        }
    }
}
impl PermissionSet {
    /// Creates a new builder-style object to manufacture [`PermissionSet`](crate::model::PermissionSet)
    pub fn builder() -> crate::model::permission_set::Builder {
        crate::model::permission_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceAccessControlAttributeConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreationFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceAccessControlAttributeConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATION_FAILED" => InstanceAccessControlAttributeConfigurationStatus::CreationFailed,
            "CREATION_IN_PROGRESS" => {
                InstanceAccessControlAttributeConfigurationStatus::CreationInProgress
            }
            "ENABLED" => InstanceAccessControlAttributeConfigurationStatus::Enabled,
            other => InstanceAccessControlAttributeConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceAccessControlAttributeConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceAccessControlAttributeConfigurationStatus::from(s))
    }
}
impl InstanceAccessControlAttributeConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceAccessControlAttributeConfigurationStatus::CreationFailed => "CREATION_FAILED",
            InstanceAccessControlAttributeConfigurationStatus::CreationInProgress => {
                "CREATION_IN_PROGRESS"
            }
            InstanceAccessControlAttributeConfigurationStatus::Enabled => "ENABLED",
            InstanceAccessControlAttributeConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATION_FAILED", "CREATION_IN_PROGRESS", "ENABLED"]
    }
}
impl AsRef<str> for InstanceAccessControlAttributeConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of the creation or deletion operation of an assignment that a principal needs
/// to access an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAssignmentOperationStatus {
    /// <p>The status of the permission set provisioning process.</p>
    pub status: std::option::Option<crate::model::StatusValues>,
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The message that contains an error or exception in case of an operation failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be created.</p>
    pub target_type: std::option::Option<crate::model::TargetType>,
    /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub permission_set_arn: std::option::Option<std::string::String>,
    /// <p>The entity type for which the assignment will be created.</p>
    pub principal_type: std::option::Option<crate::model::PrincipalType>,
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The date that the permission set was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl AccountAssignmentOperationStatus {
    /// <p>The status of the permission set provisioning process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusValues> {
        self.status.as_ref()
    }
    /// <p>The identifier for tracking the request operation that is generated by the universally
    /// unique identifier (UUID) workflow.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The message that contains an error or exception in case of an operation failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>The entity type for which the assignment will be created.</p>
    pub fn target_type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.target_type.as_ref()
    }
    /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
    /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn permission_set_arn(&self) -> std::option::Option<&str> {
        self.permission_set_arn.as_deref()
    }
    /// <p>The entity type for which the assignment will be created.</p>
    pub fn principal_type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.principal_type.as_ref()
    }
    /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The date that the permission set was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
}
impl std::fmt::Debug for AccountAssignmentOperationStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAssignmentOperationStatus");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_type", &self.target_type);
        formatter.field("permission_set_arn", &self.permission_set_arn);
        formatter.field("principal_type", &self.principal_type);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`AccountAssignmentOperationStatus`](crate::model::AccountAssignmentOperationStatus)
pub mod account_assignment_operation_status {
    /// A builder for [`AccountAssignmentOperationStatus`](crate::model::AccountAssignmentOperationStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::StatusValues>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<crate::model::TargetType>,
        pub(crate) permission_set_arn: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The status of the permission set provisioning process.</p>
        pub fn status(mut self, input: crate::model::StatusValues) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the permission set provisioning process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusValues>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The identifier for tracking the request operation that is generated by the universally
        /// unique identifier (UUID) workflow.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The message that contains an error or exception in case of an operation failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The message that contains an error or exception in case of an operation failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn permission_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
        /// Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_permission_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_set_arn = input;
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The entity type for which the assignment will be created.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the permission set was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAssignmentOperationStatus`](crate::model::AccountAssignmentOperationStatus)
        pub fn build(self) -> crate::model::AccountAssignmentOperationStatus {
            crate::model::AccountAssignmentOperationStatus {
                status: self.status,
                request_id: self.request_id,
                failure_reason: self.failure_reason,
                target_id: self.target_id,
                target_type: self.target_type,
                permission_set_arn: self.permission_set_arn,
                principal_type: self.principal_type,
                principal_id: self.principal_id,
                created_date: self.created_date,
            }
        }
    }
}
impl AccountAssignmentOperationStatus {
    /// Creates a new builder-style object to manufacture [`AccountAssignmentOperationStatus`](crate::model::AccountAssignmentOperationStatus)
    pub fn builder() -> crate::model::account_assignment_operation_status::Builder {
        crate::model::account_assignment_operation_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetType {
    #[allow(missing_docs)] // documentation missing in model
    AwsAccount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_ACCOUNT" => TargetType::AwsAccount,
            other => TargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetType::from(s))
    }
}
impl TargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetType::AwsAccount => "AWS_ACCOUNT",
            TargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_ACCOUNT"]
    }
}
impl AsRef<str> for TargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
