// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AttachManagedPolicyToPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachManagedPolicyToPermissionSetError {
    /// Kind of error that occurred.
    pub kind: AttachManagedPolicyToPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachManagedPolicyToPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachManagedPolicyToPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the permitted number of resources that can be
    /// created.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachManagedPolicyToPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachManagedPolicyToPermissionSetErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AttachManagedPolicyToPermissionSetErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AttachManagedPolicyToPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachManagedPolicyToPermissionSetError {
    fn code(&self) -> Option<&str> {
        AttachManagedPolicyToPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachManagedPolicyToPermissionSetError {
    /// Creates a new `AttachManagedPolicyToPermissionSetError`.
    pub fn new(
        kind: AttachManagedPolicyToPermissionSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachManagedPolicyToPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachManagedPolicyToPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachManagedPolicyToPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachManagedPolicyToPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachManagedPolicyToPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachManagedPolicyToPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachManagedPolicyToPermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachManagedPolicyToPermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachManagedPolicyToPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachManagedPolicyToPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachManagedPolicyToPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachManagedPolicyToPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachManagedPolicyToPermissionSetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachManagedPolicyToPermissionSetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachManagedPolicyToPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachManagedPolicyToPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachManagedPolicyToPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachManagedPolicyToPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AttachManagedPolicyToPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachManagedPolicyToPermissionSetErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ConflictException(_inner) => Some(_inner),
            AttachManagedPolicyToPermissionSetErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AttachManagedPolicyToPermissionSetErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AttachManagedPolicyToPermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccountAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccountAssignmentError {
    /// Kind of error that occurred.
    pub kind: CreateAccountAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccountAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccountAssignmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the permitted number of resources that can be
    /// created.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccountAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccountAssignmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAccountAssignmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAccountAssignmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateAccountAssignmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAccountAssignmentErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateAccountAssignmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAccountAssignmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateAccountAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccountAssignmentError {
    fn code(&self) -> Option<&str> {
        CreateAccountAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccountAssignmentError {
    /// Creates a new `CreateAccountAssignmentError`.
    pub fn new(kind: CreateAccountAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccountAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccountAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccountAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccountAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccountAssignmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAssignmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAssignmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAssignmentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAssignmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAssignmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAssignmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAssignmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAssignmentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAssignmentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAssignmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAssignmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAssignmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAssignmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateAccountAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccountAssignmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAccountAssignmentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAccountAssignmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateAccountAssignmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAccountAssignmentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateAccountAssignmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAccountAssignmentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateAccountAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInstanceAccessControlAttributeConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateInstanceAccessControlAttributeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInstanceAccessControlAttributeConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInstanceAccessControlAttributeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_inner) =>
            _inner.fmt(f)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            _inner.fmt(f)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            _inner.fmt(f)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for CreateInstanceAccessControlAttributeConfigurationError
{
    fn code(&self) -> Option<&str> {
        CreateInstanceAccessControlAttributeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInstanceAccessControlAttributeConfigurationError {
    /// Creates a new `CreateInstanceAccessControlAttributeConfigurationError`.
    pub fn new(
        kind: CreateInstanceAccessControlAttributeConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInstanceAccessControlAttributeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInstanceAccessControlAttributeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateInstanceAccessControlAttributeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_inner) =>
            Some(_inner)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            Some(_inner)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            Some(_inner)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            CreateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreatePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePermissionSetError {
    /// Kind of error that occurred.
    pub kind: CreatePermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the permitted number of resources that can be
    /// created.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePermissionSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePermissionSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePermissionSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePermissionSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePermissionSetErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreatePermissionSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePermissionSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePermissionSetError {
    fn code(&self) -> Option<&str> {
        CreatePermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePermissionSetError {
    /// Creates a new `CreatePermissionSetError`.
    pub fn new(kind: CreatePermissionSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionSetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionSetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreatePermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePermissionSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePermissionSetErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePermissionSetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePermissionSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePermissionSetErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreatePermissionSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePermissionSetErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccountAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccountAssignmentError {
    /// Kind of error that occurred.
    pub kind: DeleteAccountAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccountAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccountAssignmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccountAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccountAssignmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAccountAssignmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAccountAssignmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAccountAssignmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAccountAssignmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAccountAssignmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAccountAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccountAssignmentError {
    fn code(&self) -> Option<&str> {
        DeleteAccountAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccountAssignmentError {
    /// Creates a new `DeleteAccountAssignmentError`.
    pub fn new(kind: DeleteAccountAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccountAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccountAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccountAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccountAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccountAssignmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAssignmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAssignmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAssignmentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAssignmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAssignmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAssignmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAssignmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAssignmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAssignmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAssignmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAssignmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAccountAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccountAssignmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAccountAssignmentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAccountAssignmentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAccountAssignmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAccountAssignmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAccountAssignmentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAccountAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInlinePolicyFromPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInlinePolicyFromPermissionSetError {
    /// Kind of error that occurred.
    pub kind: DeleteInlinePolicyFromPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInlinePolicyFromPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInlinePolicyFromPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInlinePolicyFromPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInlinePolicyFromPermissionSetErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInlinePolicyFromPermissionSetError {
    fn code(&self) -> Option<&str> {
        DeleteInlinePolicyFromPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInlinePolicyFromPermissionSetError {
    /// Creates a new `DeleteInlinePolicyFromPermissionSetError`.
    pub fn new(
        kind: DeleteInlinePolicyFromPermissionSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInlinePolicyFromPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInlinePolicyFromPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInlinePolicyFromPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInlinePolicyFromPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInlinePolicyFromPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInlinePolicyFromPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInlinePolicyFromPermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInlinePolicyFromPermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInlinePolicyFromPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInlinePolicyFromPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInlinePolicyFromPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInlinePolicyFromPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInlinePolicyFromPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInlinePolicyFromPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInlinePolicyFromPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInlinePolicyFromPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteInlinePolicyFromPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInlinePolicyFromPermissionSetErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteInlinePolicyFromPermissionSetErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeleteInlinePolicyFromPermissionSetErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInstanceAccessControlAttributeConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteInstanceAccessControlAttributeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInstanceAccessControlAttributeConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInstanceAccessControlAttributeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DeleteInstanceAccessControlAttributeConfigurationError
{
    fn code(&self) -> Option<&str> {
        DeleteInstanceAccessControlAttributeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInstanceAccessControlAttributeConfigurationError {
    /// Creates a new `DeleteInstanceAccessControlAttributeConfigurationError`.
    pub fn new(
        kind: DeleteInstanceAccessControlAttributeConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInstanceAccessControlAttributeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInstanceAccessControlAttributeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceAccessControlAttributeConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceAccessControlAttributeConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteInstanceAccessControlAttributeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_inner) =>
            Some(_inner)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            Some(_inner)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            Some(_inner)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            DeleteInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeletePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePermissionSetError {
    /// Kind of error that occurred.
    pub kind: DeletePermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePermissionSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePermissionSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePermissionSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePermissionSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePermissionSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePermissionSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePermissionSetError {
    fn code(&self) -> Option<&str> {
        DeletePermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePermissionSetError {
    /// Creates a new `DeletePermissionSetError`.
    pub fn new(kind: DeletePermissionSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePermissionSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePermissionSetErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePermissionSetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePermissionSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePermissionSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePermissionSetErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountAssignmentCreationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAssignmentCreationStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAssignmentCreationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAssignmentCreationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAssignmentCreationStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAssignmentCreationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAssignmentCreationStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAssignmentCreationStatusError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAssignmentCreationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAssignmentCreationStatusError {
    /// Creates a new `DescribeAccountAssignmentCreationStatusError`.
    pub fn new(
        kind: DescribeAccountAssignmentCreationStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAssignmentCreationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAssignmentCreationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAssignmentCreationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAssignmentCreationStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentCreationStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentCreationStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentCreationStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentCreationStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentCreationStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentCreationStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentCreationStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentCreationStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAccountAssignmentCreationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAssignmentCreationStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentCreationStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAccountAssignmentDeletionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAssignmentDeletionStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAssignmentDeletionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAssignmentDeletionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAssignmentDeletionStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAssignmentDeletionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAssignmentDeletionStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAssignmentDeletionStatusError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAssignmentDeletionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAssignmentDeletionStatusError {
    /// Creates a new `DescribeAccountAssignmentDeletionStatusError`.
    pub fn new(
        kind: DescribeAccountAssignmentDeletionStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAssignmentDeletionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAssignmentDeletionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAssignmentDeletionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAssignmentDeletionStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentDeletionStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentDeletionStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentDeletionStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentDeletionStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentDeletionStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentDeletionStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAssignmentDeletionStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAssignmentDeletionStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAccountAssignmentDeletionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAssignmentDeletionStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAssignmentDeletionStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceAccessControlAttributeConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceAccessControlAttributeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceAccessControlAttributeConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceAccessControlAttributeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeInstanceAccessControlAttributeConfigurationError
{
    fn code(&self) -> Option<&str> {
        DescribeInstanceAccessControlAttributeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceAccessControlAttributeConfigurationError {
    /// Creates a new `DescribeInstanceAccessControlAttributeConfigurationError`.
    pub fn new(
        kind: DescribeInstanceAccessControlAttributeConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceAccessControlAttributeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(
                err.into(),
            ),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceAccessControlAttributeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(
                err.into(),
            ),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAccessControlAttributeConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeInstanceAccessControlAttributeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            Some(_inner)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            Some(_inner)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            DescribeInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePermissionSetError {
    /// Kind of error that occurred.
    pub kind: DescribePermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePermissionSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePermissionSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePermissionSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePermissionSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePermissionSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePermissionSetError {
    fn code(&self) -> Option<&str> {
        DescribePermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePermissionSetError {
    /// Creates a new `DescribePermissionSetError`.
    pub fn new(kind: DescribePermissionSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePermissionSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePermissionSetErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePermissionSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePermissionSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePermissionSetErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePermissionSetProvisioningStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePermissionSetProvisioningStatusError {
    /// Kind of error that occurred.
    pub kind: DescribePermissionSetProvisioningStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePermissionSetProvisioningStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePermissionSetProvisioningStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePermissionSetProvisioningStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePermissionSetProvisioningStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribePermissionSetProvisioningStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribePermissionSetProvisioningStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribePermissionSetProvisioningStatusErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribePermissionSetProvisioningStatusErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribePermissionSetProvisioningStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePermissionSetProvisioningStatusError {
    fn code(&self) -> Option<&str> {
        DescribePermissionSetProvisioningStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePermissionSetProvisioningStatusError {
    /// Creates a new `DescribePermissionSetProvisioningStatusError`.
    pub fn new(
        kind: DescribePermissionSetProvisioningStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePermissionSetProvisioningStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePermissionSetProvisioningStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePermissionSetProvisioningStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePermissionSetProvisioningStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePermissionSetProvisioningStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetProvisioningStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetProvisioningStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetProvisioningStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetProvisioningStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetProvisioningStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetProvisioningStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetProvisioningStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePermissionSetProvisioningStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePermissionSetProvisioningStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePermissionSetProvisioningStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePermissionSetProvisioningStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribePermissionSetProvisioningStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribePermissionSetProvisioningStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribePermissionSetProvisioningStatusErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribePermissionSetProvisioningStatusErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribePermissionSetProvisioningStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DetachManagedPolicyFromPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachManagedPolicyFromPermissionSetError {
    /// Kind of error that occurred.
    pub kind: DetachManagedPolicyFromPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachManagedPolicyFromPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachManagedPolicyFromPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachManagedPolicyFromPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachManagedPolicyFromPermissionSetErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachManagedPolicyFromPermissionSetError {
    fn code(&self) -> Option<&str> {
        DetachManagedPolicyFromPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachManagedPolicyFromPermissionSetError {
    /// Creates a new `DetachManagedPolicyFromPermissionSetError`.
    pub fn new(
        kind: DetachManagedPolicyFromPermissionSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachManagedPolicyFromPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachManagedPolicyFromPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachManagedPolicyFromPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachManagedPolicyFromPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachManagedPolicyFromPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachManagedPolicyFromPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachManagedPolicyFromPermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachManagedPolicyFromPermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachManagedPolicyFromPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachManagedPolicyFromPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachManagedPolicyFromPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachManagedPolicyFromPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachManagedPolicyFromPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachManagedPolicyFromPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachManagedPolicyFromPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachManagedPolicyFromPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DetachManagedPolicyFromPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachManagedPolicyFromPermissionSetErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DetachManagedPolicyFromPermissionSetErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetInlinePolicyForPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInlinePolicyForPermissionSetError {
    /// Kind of error that occurred.
    pub kind: GetInlinePolicyForPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInlinePolicyForPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInlinePolicyForPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInlinePolicyForPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInlinePolicyForPermissionSetErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetInlinePolicyForPermissionSetErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetInlinePolicyForPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetInlinePolicyForPermissionSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetInlinePolicyForPermissionSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetInlinePolicyForPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInlinePolicyForPermissionSetError {
    fn code(&self) -> Option<&str> {
        GetInlinePolicyForPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInlinePolicyForPermissionSetError {
    /// Creates a new `GetInlinePolicyForPermissionSetError`.
    pub fn new(
        kind: GetInlinePolicyForPermissionSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInlinePolicyForPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInlinePolicyForPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInlinePolicyForPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInlinePolicyForPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInlinePolicyForPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInlinePolicyForPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInlinePolicyForPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInlinePolicyForPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInlinePolicyForPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInlinePolicyForPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInlinePolicyForPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInlinePolicyForPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInlinePolicyForPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInlinePolicyForPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetInlinePolicyForPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInlinePolicyForPermissionSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInlinePolicyForPermissionSetErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetInlinePolicyForPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetInlinePolicyForPermissionSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetInlinePolicyForPermissionSetErrorKind::ValidationException(_inner) => Some(_inner),
            GetInlinePolicyForPermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountAssignmentCreationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountAssignmentCreationStatusError {
    /// Kind of error that occurred.
    pub kind: ListAccountAssignmentCreationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountAssignmentCreationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountAssignmentCreationStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountAssignmentCreationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountAssignmentCreationStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentCreationStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentCreationStatusErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentCreationStatusErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentCreationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountAssignmentCreationStatusError {
    fn code(&self) -> Option<&str> {
        ListAccountAssignmentCreationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountAssignmentCreationStatusError {
    /// Creates a new `ListAccountAssignmentCreationStatusError`.
    pub fn new(
        kind: ListAccountAssignmentCreationStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountAssignmentCreationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountAssignmentCreationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountAssignmentCreationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountAssignmentCreationStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentCreationStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentCreationStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentCreationStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentCreationStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentCreationStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentCreationStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentCreationStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentCreationStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAccountAssignmentCreationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountAssignmentCreationStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentCreationStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentCreationStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentCreationStatusErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentCreationStatusErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentCreationStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListAccountAssignmentDeletionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountAssignmentDeletionStatusError {
    /// Kind of error that occurred.
    pub kind: ListAccountAssignmentDeletionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountAssignmentDeletionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountAssignmentDeletionStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountAssignmentDeletionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountAssignmentDeletionStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentDeletionStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentDeletionStatusErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentDeletionStatusErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountAssignmentDeletionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountAssignmentDeletionStatusError {
    fn code(&self) -> Option<&str> {
        ListAccountAssignmentDeletionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountAssignmentDeletionStatusError {
    /// Creates a new `ListAccountAssignmentDeletionStatusError`.
    pub fn new(
        kind: ListAccountAssignmentDeletionStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountAssignmentDeletionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountAssignmentDeletionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountAssignmentDeletionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountAssignmentDeletionStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentDeletionStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentDeletionStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentDeletionStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentDeletionStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentDeletionStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentDeletionStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentDeletionStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentDeletionStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAccountAssignmentDeletionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountAssignmentDeletionStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentDeletionStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentDeletionStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentDeletionStatusErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentDeletionStatusErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListAccountAssignmentDeletionStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListAccountAssignments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountAssignmentsError {
    /// Kind of error that occurred.
    pub kind: ListAccountAssignmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountAssignments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountAssignmentsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountAssignmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountAssignmentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAccountAssignmentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAccountAssignmentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAccountAssignmentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAccountAssignmentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAccountAssignmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountAssignmentsError {
    fn code(&self) -> Option<&str> {
        ListAccountAssignmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountAssignmentsError {
    /// Creates a new `ListAccountAssignmentsError`.
    pub fn new(kind: ListAccountAssignmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountAssignmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountAssignmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountAssignmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountAssignmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssignmentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssignmentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAccountAssignmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountAssignmentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAccountAssignmentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAccountAssignmentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAccountAssignmentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAccountAssignmentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAccountAssignmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountsForProvisionedPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountsForProvisionedPermissionSetError {
    /// Kind of error that occurred.
    pub kind: ListAccountsForProvisionedPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountsForProvisionedPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountsForProvisionedPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountsForProvisionedPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountsForProvisionedPermissionSetErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountsForProvisionedPermissionSetError {
    fn code(&self) -> Option<&str> {
        ListAccountsForProvisionedPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountsForProvisionedPermissionSetError {
    /// Creates a new `ListAccountsForProvisionedPermissionSetError`.
    pub fn new(
        kind: ListAccountsForProvisionedPermissionSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountsForProvisionedPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountsForProvisionedPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountsForProvisionedPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountsForProvisionedPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountsForProvisionedPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForProvisionedPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForProvisionedPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForProvisionedPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForProvisionedPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForProvisionedPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForProvisionedPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForProvisionedPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForProvisionedPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForProvisionedPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAccountsForProvisionedPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountsForProvisionedPermissionSetErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListAccountsForProvisionedPermissionSetErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstancesError {
    /// Kind of error that occurred.
    pub kind: ListInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstancesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstancesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstancesError {
    fn code(&self) -> Option<&str> {
        ListInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstancesError {
    /// Creates a new `ListInstancesError`.
    pub fn new(kind: ListInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListInstancesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstancesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListInstancesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListInstancesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstancesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListInstancesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListInstancesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListInstancesErrorKind::ValidationException(_inner) => Some(_inner),
            ListInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListManagedPoliciesInPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListManagedPoliciesInPermissionSetError {
    /// Kind of error that occurred.
    pub kind: ListManagedPoliciesInPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListManagedPoliciesInPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListManagedPoliciesInPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListManagedPoliciesInPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListManagedPoliciesInPermissionSetErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListManagedPoliciesInPermissionSetErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListManagedPoliciesInPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListManagedPoliciesInPermissionSetErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListManagedPoliciesInPermissionSetErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListManagedPoliciesInPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListManagedPoliciesInPermissionSetError {
    fn code(&self) -> Option<&str> {
        ListManagedPoliciesInPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListManagedPoliciesInPermissionSetError {
    /// Creates a new `ListManagedPoliciesInPermissionSetError`.
    pub fn new(
        kind: ListManagedPoliciesInPermissionSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListManagedPoliciesInPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListManagedPoliciesInPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListManagedPoliciesInPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListManagedPoliciesInPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListManagedPoliciesInPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedPoliciesInPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedPoliciesInPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedPoliciesInPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedPoliciesInPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedPoliciesInPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedPoliciesInPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedPoliciesInPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedPoliciesInPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedPoliciesInPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListManagedPoliciesInPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListManagedPoliciesInPermissionSetErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListManagedPoliciesInPermissionSetErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListManagedPoliciesInPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListManagedPoliciesInPermissionSetErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListManagedPoliciesInPermissionSetErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListManagedPoliciesInPermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPermissionSetProvisioningStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionSetProvisioningStatusError {
    /// Kind of error that occurred.
    pub kind: ListPermissionSetProvisioningStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissionSetProvisioningStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionSetProvisioningStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionSetProvisioningStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionSetProvisioningStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetProvisioningStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetProvisioningStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetProvisioningStatusErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetProvisioningStatusErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetProvisioningStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionSetProvisioningStatusError {
    fn code(&self) -> Option<&str> {
        ListPermissionSetProvisioningStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPermissionSetProvisioningStatusError {
    /// Creates a new `ListPermissionSetProvisioningStatusError`.
    pub fn new(
        kind: ListPermissionSetProvisioningStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionSetProvisioningStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionSetProvisioningStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionSetProvisioningStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionSetProvisioningStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPermissionSetProvisioningStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetProvisioningStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetProvisioningStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetProvisioningStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetProvisioningStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetProvisioningStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetProvisioningStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetProvisioningStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetProvisioningStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetProvisioningStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPermissionSetProvisioningStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionSetProvisioningStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetProvisioningStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetProvisioningStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetProvisioningStatusErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetProvisioningStatusErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetProvisioningStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListPermissionSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionSetsError {
    /// Kind of error that occurred.
    pub kind: ListPermissionSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissionSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionSetsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionSetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPermissionSetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPermissionSetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPermissionSetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPermissionSetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPermissionSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionSetsError {
    fn code(&self) -> Option<&str> {
        ListPermissionSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPermissionSetsError {
    /// Creates a new `ListPermissionSetsError`.
    pub fn new(kind: ListPermissionSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPermissionSetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPermissionSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionSetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPermissionSetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPermissionSetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPermissionSetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPermissionSetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPermissionSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPermissionSetsProvisionedToAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionSetsProvisionedToAccountError {
    /// Kind of error that occurred.
    pub kind: ListPermissionSetsProvisionedToAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissionSetsProvisionedToAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionSetsProvisionedToAccountErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionSetsProvisionedToAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionSetsProvisionedToAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionSetsProvisionedToAccountError {
    fn code(&self) -> Option<&str> {
        ListPermissionSetsProvisionedToAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPermissionSetsProvisionedToAccountError {
    /// Creates a new `ListPermissionSetsProvisionedToAccountError`.
    pub fn new(
        kind: ListPermissionSetsProvisionedToAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionSetsProvisionedToAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionSetsProvisionedToAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionSetsProvisionedToAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionSetsProvisionedToAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPermissionSetsProvisionedToAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsProvisionedToAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsProvisionedToAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsProvisionedToAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsProvisionedToAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsProvisionedToAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsProvisionedToAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsProvisionedToAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionSetsProvisionedToAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionSetsProvisionedToAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPermissionSetsProvisionedToAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionSetsProvisionedToAccountErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListPermissionSetsProvisionedToAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ProvisionPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ProvisionPermissionSetError {
    /// Kind of error that occurred.
    pub kind: ProvisionPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ProvisionPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ProvisionPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ProvisionPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ProvisionPermissionSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ProvisionPermissionSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ProvisionPermissionSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ProvisionPermissionSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ProvisionPermissionSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ProvisionPermissionSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ProvisionPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ProvisionPermissionSetError {
    fn code(&self) -> Option<&str> {
        ProvisionPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ProvisionPermissionSetError {
    /// Creates a new `ProvisionPermissionSetError`.
    pub fn new(kind: ProvisionPermissionSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ProvisionPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ProvisionPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ProvisionPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ProvisionPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ProvisionPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionPermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionPermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ProvisionPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ProvisionPermissionSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ProvisionPermissionSetErrorKind::ConflictException(_inner) => Some(_inner),
            ProvisionPermissionSetErrorKind::InternalServerException(_inner) => Some(_inner),
            ProvisionPermissionSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ProvisionPermissionSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            ProvisionPermissionSetErrorKind::ValidationException(_inner) => Some(_inner),
            ProvisionPermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutInlinePolicyToPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutInlinePolicyToPermissionSetError {
    /// Kind of error that occurred.
    pub kind: PutInlinePolicyToPermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutInlinePolicyToPermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutInlinePolicyToPermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the permitted number of resources that can be
    /// created.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutInlinePolicyToPermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutInlinePolicyToPermissionSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutInlinePolicyToPermissionSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutInlinePolicyToPermissionSetErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            PutInlinePolicyToPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutInlinePolicyToPermissionSetErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutInlinePolicyToPermissionSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutInlinePolicyToPermissionSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutInlinePolicyToPermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutInlinePolicyToPermissionSetError {
    fn code(&self) -> Option<&str> {
        PutInlinePolicyToPermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutInlinePolicyToPermissionSetError {
    /// Creates a new `PutInlinePolicyToPermissionSetError`.
    pub fn new(
        kind: PutInlinePolicyToPermissionSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutInlinePolicyToPermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutInlinePolicyToPermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutInlinePolicyToPermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutInlinePolicyToPermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutInlinePolicyToPermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInlinePolicyToPermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInlinePolicyToPermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInlinePolicyToPermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInlinePolicyToPermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInlinePolicyToPermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInlinePolicyToPermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInlinePolicyToPermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInlinePolicyToPermissionSetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInlinePolicyToPermissionSetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInlinePolicyToPermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInlinePolicyToPermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInlinePolicyToPermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInlinePolicyToPermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutInlinePolicyToPermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutInlinePolicyToPermissionSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutInlinePolicyToPermissionSetErrorKind::ConflictException(_inner) => Some(_inner),
            PutInlinePolicyToPermissionSetErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            PutInlinePolicyToPermissionSetErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutInlinePolicyToPermissionSetErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            PutInlinePolicyToPermissionSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutInlinePolicyToPermissionSetErrorKind::ValidationException(_inner) => Some(_inner),
            PutInlinePolicyToPermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the permitted number of resources that can be
    /// created.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInstanceAccessControlAttributeConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateInstanceAccessControlAttributeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInstanceAccessControlAttributeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInstanceAccessControlAttributeConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInstanceAccessControlAttributeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for UpdateInstanceAccessControlAttributeConfigurationError
{
    fn code(&self) -> Option<&str> {
        UpdateInstanceAccessControlAttributeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInstanceAccessControlAttributeConfigurationError {
    /// Creates a new `UpdateInstanceAccessControlAttributeConfigurationError`.
    pub fn new(
        kind: UpdateInstanceAccessControlAttributeConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInstanceAccessControlAttributeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInstanceAccessControlAttributeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateInstanceAccessControlAttributeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ConflictException(_inner) =>
            Some(_inner)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::InternalServerException(_inner) =>
            Some(_inner)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ThrottlingException(_inner) =>
            Some(_inner)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            UpdateInstanceAccessControlAttributeConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdatePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePermissionSetError {
    /// Kind of error that occurred.
    pub kind: UpdatePermissionSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePermissionSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePermissionSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
    /// when the previous write did not have time to propagate to the host serving the current
    /// request. A retry (with appropriate backoff logic) is the recommended response to this
    /// exception.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure with
    /// an internal server.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that a requested resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the principal has crossed the throttling limits of the API
    /// operations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed because it contains a syntax error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePermissionSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePermissionSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePermissionSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePermissionSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePermissionSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePermissionSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePermissionSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePermissionSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePermissionSetError {
    fn code(&self) -> Option<&str> {
        UpdatePermissionSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePermissionSetError {
    /// Creates a new `UpdatePermissionSetError`.
    pub fn new(kind: UpdatePermissionSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePermissionSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePermissionSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePermissionSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePermissionSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePermissionSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePermissionSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePermissionSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePermissionSetErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePermissionSetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePermissionSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePermissionSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePermissionSetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePermissionSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request failed because it contains a syntax error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Indicates that the principal has crossed the throttling limits of the API
/// operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Indicates that a requested resource is not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception, or failure with
/// an internal server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Occurs when a conflict with a previous successful write is detected. This generally occurs
/// when the previous write did not have time to propagate to the host serving the current
/// request. A retry (with appropriate backoff logic) is the recommended response to this
/// exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Indicates that the principal has crossed the permitted number of resources that can be
/// created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
