// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides information about your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountInfo {
    /// <p>The identifier of the AWS account that is assigned to the user.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The display name of the AWS account that is assigned to the user.</p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p>The email address of the AWS account that is assigned to the user.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl AccountInfo {
    /// <p>The identifier of the AWS account that is assigned to the user.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The display name of the AWS account that is assigned to the user.</p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p>The email address of the AWS account that is assigned to the user.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for AccountInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountInfo");
        formatter.field("account_id", &self.account_id);
        formatter.field("account_name", &self.account_name);
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}
/// See [`AccountInfo`](crate::model::AccountInfo)
pub mod account_info {
    /// A builder for [`AccountInfo`](crate::model::AccountInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the AWS account that is assigned to the user.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the AWS account that is assigned to the user.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The display name of the AWS account that is assigned to the user.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p>The display name of the AWS account that is assigned to the user.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p>The email address of the AWS account that is assigned to the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address of the AWS account that is assigned to the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountInfo`](crate::model::AccountInfo)
        pub fn build(self) -> crate::model::AccountInfo {
            crate::model::AccountInfo {
                account_id: self.account_id,
                account_name: self.account_name,
                email_address: self.email_address,
            }
        }
    }
}
impl AccountInfo {
    /// Creates a new builder-style object to manufacture [`AccountInfo`](crate::model::AccountInfo)
    pub fn builder() -> crate::model::account_info::Builder {
        crate::model::account_info::Builder::default()
    }
}

/// <p>Provides information about the role that is assigned to the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoleInfo {
    /// <p>The friendly name of the role that is assigned to the user.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the AWS account assigned to the user.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl RoleInfo {
    /// <p>The friendly name of the role that is assigned to the user.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The identifier of the AWS account assigned to the user.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for RoleInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoleInfo");
        formatter.field("role_name", &self.role_name);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`RoleInfo`](crate::model::RoleInfo)
pub mod role_info {
    /// A builder for [`RoleInfo`](crate::model::RoleInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The friendly name of the role that is assigned to the user.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the role that is assigned to the user.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The identifier of the AWS account assigned to the user.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the AWS account assigned to the user.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RoleInfo`](crate::model::RoleInfo)
        pub fn build(self) -> crate::model::RoleInfo {
            crate::model::RoleInfo {
                role_name: self.role_name,
                account_id: self.account_id,
            }
        }
    }
}
impl RoleInfo {
    /// Creates a new builder-style object to manufacture [`RoleInfo`](crate::model::RoleInfo)
    pub fn builder() -> crate::model::role_info::Builder {
        crate::model::role_info::Builder::default()
    }
}

/// <p>Provides information about the role credentials that are assigned to the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoleCredentials {
    /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub session_token: std::option::Option<std::string::String>,
    /// <p>The date on which temporary security credentials expire.</p>
    pub expiration: i64,
}
impl RoleCredentials {
    /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn secret_access_key(&self) -> std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn session_token(&self) -> std::option::Option<&str> {
        self.session_token.as_deref()
    }
    /// <p>The date on which temporary security credentials expire.</p>
    pub fn expiration(&self) -> i64 {
        self.expiration
    }
}
impl std::fmt::Debug for RoleCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoleCredentials");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
/// See [`RoleCredentials`](crate::model::RoleCredentials)
pub mod role_credentials {
    /// A builder for [`RoleCredentials`](crate::model::RoleCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) session_token: std::option::Option<std::string::String>,
        pub(crate) expiration: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
        pub fn session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_token = Some(input.into());
            self
        }
        /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
        pub fn set_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_token = input;
            self
        }
        /// <p>The date on which temporary security credentials expire.</p>
        pub fn expiration(mut self, input: i64) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>The date on which temporary security credentials expire.</p>
        pub fn set_expiration(mut self, input: std::option::Option<i64>) -> Self {
            self.expiration = input;
            self
        }
        /// Consumes the builder and constructs a [`RoleCredentials`](crate::model::RoleCredentials)
        pub fn build(self) -> crate::model::RoleCredentials {
            crate::model::RoleCredentials {
                access_key_id: self.access_key_id,
                secret_access_key: self.secret_access_key,
                session_token: self.session_token,
                expiration: self.expiration.unwrap_or_default(),
            }
        }
    }
}
impl RoleCredentials {
    /// Creates a new builder-style object to manufacture [`RoleCredentials`](crate::model::RoleCredentials)
    pub fn builder() -> crate::model::role_credentials::Builder {
        crate::model::role_credentials::Builder::default()
    }
}
