// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateReplicationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_set`](crate::client::Client::create_replication_set).
///
/// See [`crate::client::fluent_builders::CreateReplicationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationSet {
    _private: (),
}
impl CreateReplicationSet {
    /// Creates a new builder-style object to manufacture [`CreateReplicationSetInput`](crate::input::CreateReplicationSetInput)
    pub fn builder() -> crate::input::create_replication_set_input::Builder {
        crate::input::create_replication_set_input::Builder::default()
    }
    /// Creates a new `CreateReplicationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationSet {
    type Output = std::result::Result<
        crate::output::CreateReplicationSetOutput,
        crate::error::CreateReplicationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_replication_set_error(response)
        } else {
            crate::operation_deser::parse_create_replication_set_response(response)
        }
    }
}

/// Operation shape for `CreateResponsePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_response_plan`](crate::client::Client::create_response_plan).
///
/// See [`crate::client::fluent_builders::CreateResponsePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResponsePlan {
    _private: (),
}
impl CreateResponsePlan {
    /// Creates a new builder-style object to manufacture [`CreateResponsePlanInput`](crate::input::CreateResponsePlanInput)
    pub fn builder() -> crate::input::create_response_plan_input::Builder {
        crate::input::create_response_plan_input::Builder::default()
    }
    /// Creates a new `CreateResponsePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResponsePlan {
    type Output = std::result::Result<
        crate::output::CreateResponsePlanOutput,
        crate::error::CreateResponsePlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_response_plan_error(response)
        } else {
            crate::operation_deser::parse_create_response_plan_response(response)
        }
    }
}

/// Operation shape for `CreateTimelineEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_timeline_event`](crate::client::Client::create_timeline_event).
///
/// See [`crate::client::fluent_builders::CreateTimelineEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTimelineEvent {
    _private: (),
}
impl CreateTimelineEvent {
    /// Creates a new builder-style object to manufacture [`CreateTimelineEventInput`](crate::input::CreateTimelineEventInput)
    pub fn builder() -> crate::input::create_timeline_event_input::Builder {
        crate::input::create_timeline_event_input::Builder::default()
    }
    /// Creates a new `CreateTimelineEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTimelineEvent {
    type Output = std::result::Result<
        crate::output::CreateTimelineEventOutput,
        crate::error::CreateTimelineEventError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_timeline_event_error(response)
        } else {
            crate::operation_deser::parse_create_timeline_event_response(response)
        }
    }
}

/// Operation shape for `DeleteIncidentRecord`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_incident_record`](crate::client::Client::delete_incident_record).
///
/// See [`crate::client::fluent_builders::DeleteIncidentRecord`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIncidentRecord {
    _private: (),
}
impl DeleteIncidentRecord {
    /// Creates a new builder-style object to manufacture [`DeleteIncidentRecordInput`](crate::input::DeleteIncidentRecordInput)
    pub fn builder() -> crate::input::delete_incident_record_input::Builder {
        crate::input::delete_incident_record_input::Builder::default()
    }
    /// Creates a new `DeleteIncidentRecord` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIncidentRecord {
    type Output = std::result::Result<
        crate::output::DeleteIncidentRecordOutput,
        crate::error::DeleteIncidentRecordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_incident_record_error(response)
        } else {
            crate::operation_deser::parse_delete_incident_record_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_set`](crate::client::Client::delete_replication_set).
///
/// See [`crate::client::fluent_builders::DeleteReplicationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationSet {
    _private: (),
}
impl DeleteReplicationSet {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationSetInput`](crate::input::DeleteReplicationSetInput)
    pub fn builder() -> crate::input::delete_replication_set_input::Builder {
        crate::input::delete_replication_set_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationSet {
    type Output = std::result::Result<
        crate::output::DeleteReplicationSetOutput,
        crate::error::DeleteReplicationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_replication_set_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_set_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteResponsePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_response_plan`](crate::client::Client::delete_response_plan).
///
/// See [`crate::client::fluent_builders::DeleteResponsePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResponsePlan {
    _private: (),
}
impl DeleteResponsePlan {
    /// Creates a new builder-style object to manufacture [`DeleteResponsePlanInput`](crate::input::DeleteResponsePlanInput)
    pub fn builder() -> crate::input::delete_response_plan_input::Builder {
        crate::input::delete_response_plan_input::Builder::default()
    }
    /// Creates a new `DeleteResponsePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResponsePlan {
    type Output = std::result::Result<
        crate::output::DeleteResponsePlanOutput,
        crate::error::DeleteResponsePlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_response_plan_error(response)
        } else {
            crate::operation_deser::parse_delete_response_plan_response(response)
        }
    }
}

/// Operation shape for `DeleteTimelineEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_timeline_event`](crate::client::Client::delete_timeline_event).
///
/// See [`crate::client::fluent_builders::DeleteTimelineEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTimelineEvent {
    _private: (),
}
impl DeleteTimelineEvent {
    /// Creates a new builder-style object to manufacture [`DeleteTimelineEventInput`](crate::input::DeleteTimelineEventInput)
    pub fn builder() -> crate::input::delete_timeline_event_input::Builder {
        crate::input::delete_timeline_event_input::Builder::default()
    }
    /// Creates a new `DeleteTimelineEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTimelineEvent {
    type Output = std::result::Result<
        crate::output::DeleteTimelineEventOutput,
        crate::error::DeleteTimelineEventError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_timeline_event_error(response)
        } else {
            crate::operation_deser::parse_delete_timeline_event_response(response)
        }
    }
}

/// Operation shape for `GetIncidentRecord`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_incident_record`](crate::client::Client::get_incident_record).
///
/// See [`crate::client::fluent_builders::GetIncidentRecord`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIncidentRecord {
    _private: (),
}
impl GetIncidentRecord {
    /// Creates a new builder-style object to manufacture [`GetIncidentRecordInput`](crate::input::GetIncidentRecordInput)
    pub fn builder() -> crate::input::get_incident_record_input::Builder {
        crate::input::get_incident_record_input::Builder::default()
    }
    /// Creates a new `GetIncidentRecord` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIncidentRecord {
    type Output = std::result::Result<
        crate::output::GetIncidentRecordOutput,
        crate::error::GetIncidentRecordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_incident_record_error(response)
        } else {
            crate::operation_deser::parse_get_incident_record_response(response)
        }
    }
}

/// Operation shape for `GetReplicationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_replication_set`](crate::client::Client::get_replication_set).
///
/// See [`crate::client::fluent_builders::GetReplicationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReplicationSet {
    _private: (),
}
impl GetReplicationSet {
    /// Creates a new builder-style object to manufacture [`GetReplicationSetInput`](crate::input::GetReplicationSetInput)
    pub fn builder() -> crate::input::get_replication_set_input::Builder {
        crate::input::get_replication_set_input::Builder::default()
    }
    /// Creates a new `GetReplicationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReplicationSet {
    type Output = std::result::Result<
        crate::output::GetReplicationSetOutput,
        crate::error::GetReplicationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_replication_set_error(response)
        } else {
            crate::operation_deser::parse_get_replication_set_response(response)
        }
    }
}

/// Operation shape for `GetResourcePolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_policies`](crate::client::Client::get_resource_policies).
///
/// See [`crate::client::fluent_builders::GetResourcePolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourcePolicies {
    _private: (),
}
impl GetResourcePolicies {
    /// Creates a new builder-style object to manufacture [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
    pub fn builder() -> crate::input::get_resource_policies_input::Builder {
        crate::input::get_resource_policies_input::Builder::default()
    }
    /// Creates a new `GetResourcePolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourcePolicies {
    type Output = std::result::Result<
        crate::output::GetResourcePoliciesOutput,
        crate::error::GetResourcePoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_policies_error(response)
        } else {
            crate::operation_deser::parse_get_resource_policies_response(response)
        }
    }
}

/// Operation shape for `GetResponsePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_response_plan`](crate::client::Client::get_response_plan).
///
/// See [`crate::client::fluent_builders::GetResponsePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResponsePlan {
    _private: (),
}
impl GetResponsePlan {
    /// Creates a new builder-style object to manufacture [`GetResponsePlanInput`](crate::input::GetResponsePlanInput)
    pub fn builder() -> crate::input::get_response_plan_input::Builder {
        crate::input::get_response_plan_input::Builder::default()
    }
    /// Creates a new `GetResponsePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResponsePlan {
    type Output = std::result::Result<
        crate::output::GetResponsePlanOutput,
        crate::error::GetResponsePlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_response_plan_error(response)
        } else {
            crate::operation_deser::parse_get_response_plan_response(response)
        }
    }
}

/// Operation shape for `GetTimelineEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_timeline_event`](crate::client::Client::get_timeline_event).
///
/// See [`crate::client::fluent_builders::GetTimelineEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTimelineEvent {
    _private: (),
}
impl GetTimelineEvent {
    /// Creates a new builder-style object to manufacture [`GetTimelineEventInput`](crate::input::GetTimelineEventInput)
    pub fn builder() -> crate::input::get_timeline_event_input::Builder {
        crate::input::get_timeline_event_input::Builder::default()
    }
    /// Creates a new `GetTimelineEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTimelineEvent {
    type Output = std::result::Result<
        crate::output::GetTimelineEventOutput,
        crate::error::GetTimelineEventError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_timeline_event_error(response)
        } else {
            crate::operation_deser::parse_get_timeline_event_response(response)
        }
    }
}

/// Operation shape for `ListIncidentRecords`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_incident_records`](crate::client::Client::list_incident_records).
///
/// See [`crate::client::fluent_builders::ListIncidentRecords`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIncidentRecords {
    _private: (),
}
impl ListIncidentRecords {
    /// Creates a new builder-style object to manufacture [`ListIncidentRecordsInput`](crate::input::ListIncidentRecordsInput)
    pub fn builder() -> crate::input::list_incident_records_input::Builder {
        crate::input::list_incident_records_input::Builder::default()
    }
    /// Creates a new `ListIncidentRecords` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIncidentRecords {
    type Output = std::result::Result<
        crate::output::ListIncidentRecordsOutput,
        crate::error::ListIncidentRecordsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_incident_records_error(response)
        } else {
            crate::operation_deser::parse_list_incident_records_response(response)
        }
    }
}

/// Operation shape for `ListRelatedItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_related_items`](crate::client::Client::list_related_items).
///
/// See [`crate::client::fluent_builders::ListRelatedItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRelatedItems {
    _private: (),
}
impl ListRelatedItems {
    /// Creates a new builder-style object to manufacture [`ListRelatedItemsInput`](crate::input::ListRelatedItemsInput)
    pub fn builder() -> crate::input::list_related_items_input::Builder {
        crate::input::list_related_items_input::Builder::default()
    }
    /// Creates a new `ListRelatedItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRelatedItems {
    type Output = std::result::Result<
        crate::output::ListRelatedItemsOutput,
        crate::error::ListRelatedItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_related_items_error(response)
        } else {
            crate::operation_deser::parse_list_related_items_response(response)
        }
    }
}

/// Operation shape for `ListReplicationSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_replication_sets`](crate::client::Client::list_replication_sets).
///
/// See [`crate::client::fluent_builders::ListReplicationSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReplicationSets {
    _private: (),
}
impl ListReplicationSets {
    /// Creates a new builder-style object to manufacture [`ListReplicationSetsInput`](crate::input::ListReplicationSetsInput)
    pub fn builder() -> crate::input::list_replication_sets_input::Builder {
        crate::input::list_replication_sets_input::Builder::default()
    }
    /// Creates a new `ListReplicationSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReplicationSets {
    type Output = std::result::Result<
        crate::output::ListReplicationSetsOutput,
        crate::error::ListReplicationSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_replication_sets_error(response)
        } else {
            crate::operation_deser::parse_list_replication_sets_response(response)
        }
    }
}

/// Operation shape for `ListResponsePlans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_response_plans`](crate::client::Client::list_response_plans).
///
/// See [`crate::client::fluent_builders::ListResponsePlans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResponsePlans {
    _private: (),
}
impl ListResponsePlans {
    /// Creates a new builder-style object to manufacture [`ListResponsePlansInput`](crate::input::ListResponsePlansInput)
    pub fn builder() -> crate::input::list_response_plans_input::Builder {
        crate::input::list_response_plans_input::Builder::default()
    }
    /// Creates a new `ListResponsePlans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResponsePlans {
    type Output = std::result::Result<
        crate::output::ListResponsePlansOutput,
        crate::error::ListResponsePlansError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_response_plans_error(response)
        } else {
            crate::operation_deser::parse_list_response_plans_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTimelineEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_timeline_events`](crate::client::Client::list_timeline_events).
///
/// See [`crate::client::fluent_builders::ListTimelineEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTimelineEvents {
    _private: (),
}
impl ListTimelineEvents {
    /// Creates a new builder-style object to manufacture [`ListTimelineEventsInput`](crate::input::ListTimelineEventsInput)
    pub fn builder() -> crate::input::list_timeline_events_input::Builder {
        crate::input::list_timeline_events_input::Builder::default()
    }
    /// Creates a new `ListTimelineEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTimelineEvents {
    type Output = std::result::Result<
        crate::output::ListTimelineEventsOutput,
        crate::error::ListTimelineEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_timeline_events_error(response)
        } else {
            crate::operation_deser::parse_list_timeline_events_response(response)
        }
    }
}

/// Operation shape for `PutResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_policy`](crate::client::Client::put_resource_policy).
///
/// See [`crate::client::fluent_builders::PutResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourcePolicy {
    _private: (),
}
impl PutResourcePolicy {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
    /// Creates a new `PutResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourcePolicy {
    type Output = std::result::Result<
        crate::output::PutResourcePolicyOutput,
        crate::error::PutResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resource_policy_response(response)
        }
    }
}

/// Operation shape for `StartIncident`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_incident`](crate::client::Client::start_incident).
///
/// See [`crate::client::fluent_builders::StartIncident`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartIncident {
    _private: (),
}
impl StartIncident {
    /// Creates a new builder-style object to manufacture [`StartIncidentInput`](crate::input::StartIncidentInput)
    pub fn builder() -> crate::input::start_incident_input::Builder {
        crate::input::start_incident_input::Builder::default()
    }
    /// Creates a new `StartIncident` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartIncident {
    type Output =
        std::result::Result<crate::output::StartIncidentOutput, crate::error::StartIncidentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_incident_error(response)
        } else {
            crate::operation_deser::parse_start_incident_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDeletionProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_deletion_protection`](crate::client::Client::update_deletion_protection).
///
/// See [`crate::client::fluent_builders::UpdateDeletionProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeletionProtection {
    _private: (),
}
impl UpdateDeletionProtection {
    /// Creates a new builder-style object to manufacture [`UpdateDeletionProtectionInput`](crate::input::UpdateDeletionProtectionInput)
    pub fn builder() -> crate::input::update_deletion_protection_input::Builder {
        crate::input::update_deletion_protection_input::Builder::default()
    }
    /// Creates a new `UpdateDeletionProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeletionProtection {
    type Output = std::result::Result<
        crate::output::UpdateDeletionProtectionOutput,
        crate::error::UpdateDeletionProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_deletion_protection_error(response)
        } else {
            crate::operation_deser::parse_update_deletion_protection_response(response)
        }
    }
}

/// Operation shape for `UpdateIncidentRecord`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_incident_record`](crate::client::Client::update_incident_record).
///
/// See [`crate::client::fluent_builders::UpdateIncidentRecord`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIncidentRecord {
    _private: (),
}
impl UpdateIncidentRecord {
    /// Creates a new builder-style object to manufacture [`UpdateIncidentRecordInput`](crate::input::UpdateIncidentRecordInput)
    pub fn builder() -> crate::input::update_incident_record_input::Builder {
        crate::input::update_incident_record_input::Builder::default()
    }
    /// Creates a new `UpdateIncidentRecord` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIncidentRecord {
    type Output = std::result::Result<
        crate::output::UpdateIncidentRecordOutput,
        crate::error::UpdateIncidentRecordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_incident_record_error(response)
        } else {
            crate::operation_deser::parse_update_incident_record_response(response)
        }
    }
}

/// Operation shape for `UpdateRelatedItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_related_items`](crate::client::Client::update_related_items).
///
/// See [`crate::client::fluent_builders::UpdateRelatedItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRelatedItems {
    _private: (),
}
impl UpdateRelatedItems {
    /// Creates a new builder-style object to manufacture [`UpdateRelatedItemsInput`](crate::input::UpdateRelatedItemsInput)
    pub fn builder() -> crate::input::update_related_items_input::Builder {
        crate::input::update_related_items_input::Builder::default()
    }
    /// Creates a new `UpdateRelatedItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRelatedItems {
    type Output = std::result::Result<
        crate::output::UpdateRelatedItemsOutput,
        crate::error::UpdateRelatedItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_related_items_error(response)
        } else {
            crate::operation_deser::parse_update_related_items_response(response)
        }
    }
}

/// Operation shape for `UpdateReplicationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_replication_set`](crate::client::Client::update_replication_set).
///
/// See [`crate::client::fluent_builders::UpdateReplicationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReplicationSet {
    _private: (),
}
impl UpdateReplicationSet {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationSetInput`](crate::input::UpdateReplicationSetInput)
    pub fn builder() -> crate::input::update_replication_set_input::Builder {
        crate::input::update_replication_set_input::Builder::default()
    }
    /// Creates a new `UpdateReplicationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReplicationSet {
    type Output = std::result::Result<
        crate::output::UpdateReplicationSetOutput,
        crate::error::UpdateReplicationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_replication_set_error(response)
        } else {
            crate::operation_deser::parse_update_replication_set_response(response)
        }
    }
}

/// Operation shape for `UpdateResponsePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_response_plan`](crate::client::Client::update_response_plan).
///
/// See [`crate::client::fluent_builders::UpdateResponsePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResponsePlan {
    _private: (),
}
impl UpdateResponsePlan {
    /// Creates a new builder-style object to manufacture [`UpdateResponsePlanInput`](crate::input::UpdateResponsePlanInput)
    pub fn builder() -> crate::input::update_response_plan_input::Builder {
        crate::input::update_response_plan_input::Builder::default()
    }
    /// Creates a new `UpdateResponsePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResponsePlan {
    type Output = std::result::Result<
        crate::output::UpdateResponsePlanOutput,
        crate::error::UpdateResponsePlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_response_plan_error(response)
        } else {
            crate::operation_deser::parse_update_response_plan_response(response)
        }
    }
}

/// Operation shape for `UpdateTimelineEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_timeline_event`](crate::client::Client::update_timeline_event).
///
/// See [`crate::client::fluent_builders::UpdateTimelineEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTimelineEvent {
    _private: (),
}
impl UpdateTimelineEvent {
    /// Creates a new builder-style object to manufacture [`UpdateTimelineEventInput`](crate::input::UpdateTimelineEventInput)
    pub fn builder() -> crate::input::update_timeline_event_input::Builder {
        crate::input::update_timeline_event_input::Builder::default()
    }
    /// Creates a new `UpdateTimelineEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTimelineEvent {
    type Output = std::result::Result<
        crate::output::UpdateTimelineEventOutput,
        crate::error::UpdateTimelineEventError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_timeline_event_error(response)
        } else {
            crate::operation_deser::parse_update_timeline_event_response(response)
        }
    }
}
