// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationSetError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationSetErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateReplicationSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateReplicationSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateReplicationSetErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateReplicationSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateReplicationSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateReplicationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationSetError {
    fn code(&self) -> Option<&str> {
        CreateReplicationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationSetError {
    /// Creates a new `CreateReplicationSetError`.
    pub fn new(kind: CreateReplicationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReplicationSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateReplicationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateReplicationSetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateReplicationSetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateReplicationSetErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateReplicationSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateReplicationSetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateReplicationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResponsePlanError {
    /// Kind of error that occurred.
    pub kind: CreateResponsePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResponsePlanErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResponsePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResponsePlanErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateResponsePlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateResponsePlanErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateResponsePlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateResponsePlanErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateResponsePlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateResponsePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResponsePlanError {
    fn code(&self) -> Option<&str> {
        CreateResponsePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResponsePlanError {
    /// Creates a new `CreateResponsePlanError`.
    pub fn new(kind: CreateResponsePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResponsePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResponsePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResponsePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResponsePlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResponsePlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponsePlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponsePlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponsePlanErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponsePlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponsePlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponsePlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponsePlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponsePlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponsePlanErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponsePlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponsePlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateResponsePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResponsePlanErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateResponsePlanErrorKind::ConflictException(_inner) => Some(_inner),
            CreateResponsePlanErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateResponsePlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateResponsePlanErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateResponsePlanErrorKind::ValidationException(_inner) => Some(_inner),
            CreateResponsePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTimelineEventError {
    /// Kind of error that occurred.
    pub kind: CreateTimelineEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTimelineEventErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTimelineEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTimelineEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTimelineEventErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateTimelineEventErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateTimelineEventErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateTimelineEventErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateTimelineEventErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateTimelineEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTimelineEventError {
    fn code(&self) -> Option<&str> {
        CreateTimelineEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTimelineEventError {
    /// Creates a new `CreateTimelineEventError`.
    pub fn new(kind: CreateTimelineEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTimelineEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTimelineEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTimelineEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTimelineEventErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTimelineEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTimelineEventErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTimelineEventErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTimelineEventErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTimelineEventErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTimelineEventErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTimelineEventErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTimelineEventErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTimelineEventErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTimelineEventErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTimelineEventErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTimelineEventErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateTimelineEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTimelineEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTimelineEventErrorKind::ConflictException(_inner) => Some(_inner),
            CreateTimelineEventErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateTimelineEventErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateTimelineEventErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateTimelineEventErrorKind::ValidationException(_inner) => Some(_inner),
            CreateTimelineEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIncidentRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIncidentRecordError {
    /// Kind of error that occurred.
    pub kind: DeleteIncidentRecordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIncidentRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIncidentRecordErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIncidentRecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIncidentRecordErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteIncidentRecordErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteIncidentRecordErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteIncidentRecordErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteIncidentRecordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIncidentRecordError {
    fn code(&self) -> Option<&str> {
        DeleteIncidentRecordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIncidentRecordError {
    /// Creates a new `DeleteIncidentRecordError`.
    pub fn new(kind: DeleteIncidentRecordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIncidentRecordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIncidentRecordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIncidentRecordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIncidentRecordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIncidentRecordErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIncidentRecordErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIncidentRecordErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIncidentRecordErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIncidentRecordErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIncidentRecordErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIncidentRecordErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIncidentRecordErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteIncidentRecordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIncidentRecordErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteIncidentRecordErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteIncidentRecordErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteIncidentRecordErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteIncidentRecordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationSetError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationSetErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteReplicationSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteReplicationSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteReplicationSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteReplicationSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteReplicationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationSetError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationSetError {
    /// Creates a new `DeleteReplicationSetError`.
    pub fn new(kind: DeleteReplicationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteReplicationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteReplicationSetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteReplicationSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteReplicationSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteReplicationSetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteReplicationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResponsePlanError {
    /// Kind of error that occurred.
    pub kind: DeleteResponsePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResponsePlanErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResponsePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResponsePlanErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteResponsePlanErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteResponsePlanErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResponsePlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteResponsePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResponsePlanError {
    fn code(&self) -> Option<&str> {
        DeleteResponsePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResponsePlanError {
    /// Creates a new `DeleteResponsePlanError`.
    pub fn new(kind: DeleteResponsePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResponsePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResponsePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResponsePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResponsePlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResponsePlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponsePlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponsePlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponsePlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponsePlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponsePlanErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponsePlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponsePlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteResponsePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResponsePlanErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteResponsePlanErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResponsePlanErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResponsePlanErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteResponsePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTimelineEventError {
    /// Kind of error that occurred.
    pub kind: DeleteTimelineEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTimelineEventErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTimelineEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTimelineEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteTimelineEventErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteTimelineEventErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteTimelineEventErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteTimelineEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTimelineEventError {
    fn code(&self) -> Option<&str> {
        DeleteTimelineEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTimelineEventError {
    /// Creates a new `DeleteTimelineEventError`.
    pub fn new(kind: DeleteTimelineEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTimelineEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTimelineEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTimelineEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTimelineEventErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTimelineEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTimelineEventErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTimelineEventErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTimelineEventErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTimelineEventErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTimelineEventErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTimelineEventErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTimelineEventErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteTimelineEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTimelineEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteTimelineEventErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteTimelineEventErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteTimelineEventErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteTimelineEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIncidentRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIncidentRecordError {
    /// Kind of error that occurred.
    pub kind: GetIncidentRecordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIncidentRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIncidentRecordErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIncidentRecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIncidentRecordErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetIncidentRecordErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetIncidentRecordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetIncidentRecordErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetIncidentRecordErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetIncidentRecordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIncidentRecordError {
    fn code(&self) -> Option<&str> {
        GetIncidentRecordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIncidentRecordError {
    /// Creates a new `GetIncidentRecordError`.
    pub fn new(kind: GetIncidentRecordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIncidentRecordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIncidentRecordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIncidentRecordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIncidentRecordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIncidentRecordErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIncidentRecordErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIncidentRecordErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIncidentRecordErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIncidentRecordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIncidentRecordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIncidentRecordErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIncidentRecordErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIncidentRecordErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIncidentRecordErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetIncidentRecordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIncidentRecordErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetIncidentRecordErrorKind::InternalServerException(_inner) => Some(_inner),
            GetIncidentRecordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetIncidentRecordErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetIncidentRecordErrorKind::ValidationException(_inner) => Some(_inner),
            GetIncidentRecordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReplicationSetError {
    /// Kind of error that occurred.
    pub kind: GetReplicationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReplicationSetErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReplicationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReplicationSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetReplicationSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetReplicationSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetReplicationSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetReplicationSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetReplicationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReplicationSetError {
    fn code(&self) -> Option<&str> {
        GetReplicationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReplicationSetError {
    /// Creates a new `GetReplicationSetError`.
    pub fn new(kind: GetReplicationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReplicationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReplicationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReplicationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReplicationSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReplicationSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetReplicationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReplicationSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetReplicationSetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetReplicationSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetReplicationSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetReplicationSetErrorKind::ValidationException(_inner) => Some(_inner),
            GetReplicationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePoliciesError {
    /// Kind of error that occurred.
    pub kind: GetResourcePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePoliciesErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePoliciesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePoliciesError {
    fn code(&self) -> Option<&str> {
        GetResourcePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePoliciesError {
    /// Creates a new `GetResourcePoliciesError`.
    pub fn new(kind: GetResourcePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetResourcePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePoliciesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResponsePlanError {
    /// Kind of error that occurred.
    pub kind: GetResponsePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResponsePlanErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResponsePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResponsePlanErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResponsePlanErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetResponsePlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResponsePlanErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResponsePlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResponsePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResponsePlanError {
    fn code(&self) -> Option<&str> {
        GetResponsePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResponsePlanError {
    /// Creates a new `GetResponsePlanError`.
    pub fn new(kind: GetResponsePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResponsePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResponsePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResponsePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResponsePlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResponsePlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResponsePlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResponsePlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResponsePlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResponsePlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResponsePlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResponsePlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetResponsePlanErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetResponsePlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetResponsePlanErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetResponsePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResponsePlanErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResponsePlanErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResponsePlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResponsePlanErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResponsePlanErrorKind::ValidationException(_inner) => Some(_inner),
            GetResponsePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTimelineEventError {
    /// Kind of error that occurred.
    pub kind: GetTimelineEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTimelineEventErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTimelineEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTimelineEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTimelineEventErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetTimelineEventErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetTimelineEventErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetTimelineEventErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetTimelineEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTimelineEventError {
    fn code(&self) -> Option<&str> {
        GetTimelineEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTimelineEventError {
    /// Creates a new `GetTimelineEventError`.
    pub fn new(kind: GetTimelineEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTimelineEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTimelineEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTimelineEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTimelineEventErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTimelineEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTimelineEventErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTimelineEventErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTimelineEventErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTimelineEventErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTimelineEventErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTimelineEventErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTimelineEventErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTimelineEventErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTimelineEventErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetTimelineEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTimelineEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTimelineEventErrorKind::InternalServerException(_inner) => Some(_inner),
            GetTimelineEventErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetTimelineEventErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetTimelineEventErrorKind::ValidationException(_inner) => Some(_inner),
            GetTimelineEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIncidentRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIncidentRecordsError {
    /// Kind of error that occurred.
    pub kind: ListIncidentRecordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIncidentRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIncidentRecordsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIncidentRecordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIncidentRecordsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIncidentRecordsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListIncidentRecordsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIncidentRecordsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListIncidentRecordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIncidentRecordsError {
    fn code(&self) -> Option<&str> {
        ListIncidentRecordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIncidentRecordsError {
    /// Creates a new `ListIncidentRecordsError`.
    pub fn new(kind: ListIncidentRecordsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIncidentRecordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIncidentRecordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIncidentRecordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIncidentRecordsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIncidentRecordsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncidentRecordsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIncidentRecordsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncidentRecordsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIncidentRecordsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncidentRecordsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIncidentRecordsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncidentRecordsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListIncidentRecordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIncidentRecordsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIncidentRecordsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListIncidentRecordsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIncidentRecordsErrorKind::ValidationException(_inner) => Some(_inner),
            ListIncidentRecordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRelatedItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRelatedItemsError {
    /// Kind of error that occurred.
    pub kind: ListRelatedItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRelatedItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRelatedItemsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRelatedItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRelatedItemsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRelatedItemsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRelatedItemsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRelatedItemsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRelatedItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRelatedItemsError {
    fn code(&self) -> Option<&str> {
        ListRelatedItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRelatedItemsError {
    /// Creates a new `ListRelatedItemsError`.
    pub fn new(kind: ListRelatedItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRelatedItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRelatedItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRelatedItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRelatedItemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRelatedItemsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRelatedItemsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRelatedItemsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRelatedItemsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRelatedItemsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRelatedItemsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRelatedItemsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRelatedItemsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRelatedItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRelatedItemsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRelatedItemsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRelatedItemsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRelatedItemsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRelatedItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReplicationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReplicationSetsError {
    /// Kind of error that occurred.
    pub kind: ListReplicationSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReplicationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReplicationSetsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReplicationSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReplicationSetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListReplicationSetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListReplicationSetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListReplicationSetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListReplicationSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReplicationSetsError {
    fn code(&self) -> Option<&str> {
        ListReplicationSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReplicationSetsError {
    /// Creates a new `ListReplicationSetsError`.
    pub fn new(kind: ListReplicationSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReplicationSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReplicationSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReplicationSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReplicationSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReplicationSetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReplicationSetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReplicationSetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReplicationSetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReplicationSetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReplicationSetsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReplicationSetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReplicationSetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListReplicationSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReplicationSetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListReplicationSetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListReplicationSetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListReplicationSetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListReplicationSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResponsePlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResponsePlansError {
    /// Kind of error that occurred.
    pub kind: ListResponsePlansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResponsePlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResponsePlansErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResponsePlansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResponsePlansErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListResponsePlansErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListResponsePlansErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListResponsePlansErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListResponsePlansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResponsePlansError {
    fn code(&self) -> Option<&str> {
        ListResponsePlansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResponsePlansError {
    /// Creates a new `ListResponsePlansError`.
    pub fn new(kind: ListResponsePlansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResponsePlansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResponsePlansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResponsePlansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResponsePlansErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResponsePlansErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResponsePlansErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResponsePlansErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResponsePlansErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResponsePlansErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResponsePlansErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResponsePlansErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResponsePlansErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListResponsePlansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResponsePlansErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListResponsePlansErrorKind::InternalServerException(_inner) => Some(_inner),
            ListResponsePlansErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListResponsePlansErrorKind::ValidationException(_inner) => Some(_inner),
            ListResponsePlansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTimelineEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTimelineEventsError {
    /// Kind of error that occurred.
    pub kind: ListTimelineEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTimelineEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTimelineEventsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTimelineEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTimelineEventsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTimelineEventsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTimelineEventsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTimelineEventsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTimelineEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTimelineEventsError {
    fn code(&self) -> Option<&str> {
        ListTimelineEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTimelineEventsError {
    /// Creates a new `ListTimelineEventsError`.
    pub fn new(kind: ListTimelineEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTimelineEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTimelineEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTimelineEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTimelineEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTimelineEventsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTimelineEventsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTimelineEventsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTimelineEventsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTimelineEventsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTimelineEventsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTimelineEventsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTimelineEventsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTimelineEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTimelineEventsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTimelineEventsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTimelineEventsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTimelineEventsErrorKind::ValidationException(_inner) => Some(_inner),
            ListTimelineEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartIncident` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartIncidentError {
    /// Kind of error that occurred.
    pub kind: StartIncidentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartIncident` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartIncidentErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartIncidentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartIncidentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartIncidentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartIncidentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartIncidentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartIncidentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartIncidentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartIncidentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartIncidentError {
    fn code(&self) -> Option<&str> {
        StartIncidentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartIncidentError {
    /// Creates a new `StartIncidentError`.
    pub fn new(kind: StartIncidentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartIncidentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartIncidentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartIncidentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartIncidentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartIncidentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StartIncidentErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `StartIncidentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartIncidentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartIncidentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartIncidentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartIncidentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartIncidentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartIncidentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartIncidentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartIncidentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartIncidentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartIncidentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartIncidentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartIncidentErrorKind::ConflictException(_inner) => Some(_inner),
            StartIncidentErrorKind::InternalServerException(_inner) => Some(_inner),
            StartIncidentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartIncidentErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartIncidentErrorKind::ValidationException(_inner) => Some(_inner),
            StartIncidentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeletionProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeletionProtectionError {
    /// Kind of error that occurred.
    pub kind: UpdateDeletionProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeletionProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeletionProtectionErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeletionProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeletionProtectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDeletionProtectionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDeletionProtectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDeletionProtectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDeletionProtectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDeletionProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeletionProtectionError {
    fn code(&self) -> Option<&str> {
        UpdateDeletionProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeletionProtectionError {
    /// Creates a new `UpdateDeletionProtectionError`.
    pub fn new(kind: UpdateDeletionProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeletionProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeletionProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeletionProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeletionProtectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDeletionProtectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeletionProtectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeletionProtectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeletionProtectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeletionProtectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeletionProtectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeletionProtectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeletionProtectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeletionProtectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeletionProtectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDeletionProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeletionProtectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDeletionProtectionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDeletionProtectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDeletionProtectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDeletionProtectionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDeletionProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIncidentRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIncidentRecordError {
    /// Kind of error that occurred.
    pub kind: UpdateIncidentRecordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIncidentRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIncidentRecordErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIncidentRecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIncidentRecordErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateIncidentRecordErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateIncidentRecordErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateIncidentRecordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateIncidentRecordErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateIncidentRecordErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateIncidentRecordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIncidentRecordError {
    fn code(&self) -> Option<&str> {
        UpdateIncidentRecordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIncidentRecordError {
    /// Creates a new `UpdateIncidentRecordError`.
    pub fn new(kind: UpdateIncidentRecordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIncidentRecordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIncidentRecordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIncidentRecordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIncidentRecordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIncidentRecordErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIncidentRecordErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIncidentRecordErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIncidentRecordErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIncidentRecordErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIncidentRecordErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIncidentRecordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIncidentRecordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIncidentRecordErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIncidentRecordErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIncidentRecordErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIncidentRecordErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateIncidentRecordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIncidentRecordErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateIncidentRecordErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateIncidentRecordErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateIncidentRecordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateIncidentRecordErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateIncidentRecordErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateIncidentRecordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRelatedItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRelatedItemsError {
    /// Kind of error that occurred.
    pub kind: UpdateRelatedItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRelatedItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRelatedItemsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRelatedItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRelatedItemsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRelatedItemsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRelatedItemsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRelatedItemsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRelatedItemsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRelatedItemsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRelatedItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRelatedItemsError {
    fn code(&self) -> Option<&str> {
        UpdateRelatedItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRelatedItemsError {
    /// Creates a new `UpdateRelatedItemsError`.
    pub fn new(kind: UpdateRelatedItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRelatedItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRelatedItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRelatedItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRelatedItemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRelatedItemsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRelatedItemsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRelatedItemsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRelatedItemsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRelatedItemsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRelatedItemsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRelatedItemsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRelatedItemsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRelatedItemsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRelatedItemsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRelatedItemsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRelatedItemsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRelatedItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRelatedItemsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRelatedItemsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRelatedItemsErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRelatedItemsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRelatedItemsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRelatedItemsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRelatedItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReplicationSetError {
    /// Kind of error that occurred.
    pub kind: UpdateReplicationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReplicationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReplicationSetErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReplicationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReplicationSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateReplicationSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateReplicationSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateReplicationSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateReplicationSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateReplicationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReplicationSetError {
    fn code(&self) -> Option<&str> {
        UpdateReplicationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReplicationSetError {
    /// Creates a new `UpdateReplicationSetError`.
    pub fn new(kind: UpdateReplicationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReplicationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReplicationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReplicationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReplicationSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReplicationSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateReplicationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReplicationSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateReplicationSetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateReplicationSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateReplicationSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateReplicationSetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateReplicationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResponsePlanError {
    /// Kind of error that occurred.
    pub kind: UpdateResponsePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResponsePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResponsePlanErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResponsePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResponsePlanErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateResponsePlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateResponsePlanErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateResponsePlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateResponsePlanErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateResponsePlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateResponsePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResponsePlanError {
    fn code(&self) -> Option<&str> {
        UpdateResponsePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResponsePlanError {
    /// Creates a new `UpdateResponsePlanError`.
    pub fn new(kind: UpdateResponsePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResponsePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResponsePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResponsePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResponsePlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResponsePlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponsePlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponsePlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponsePlanErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponsePlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponsePlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponsePlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponsePlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponsePlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponsePlanErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponsePlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponsePlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateResponsePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResponsePlanErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateResponsePlanErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateResponsePlanErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateResponsePlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateResponsePlanErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateResponsePlanErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateResponsePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTimelineEventError {
    /// Kind of error that occurred.
    pub kind: UpdateTimelineEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTimelineEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTimelineEventErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource which doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTimelineEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTimelineEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateTimelineEventErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateTimelineEventErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateTimelineEventErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTimelineEventErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateTimelineEventErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateTimelineEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTimelineEventError {
    fn code(&self) -> Option<&str> {
        UpdateTimelineEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTimelineEventError {
    /// Creates a new `UpdateTimelineEventError`.
    pub fn new(kind: UpdateTimelineEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTimelineEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTimelineEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTimelineEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTimelineEventErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTimelineEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimelineEventErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimelineEventErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimelineEventErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimelineEventErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimelineEventErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimelineEventErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimelineEventErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimelineEventErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimelineEventErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimelineEventErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimelineEventErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateTimelineEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTimelineEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateTimelineEventErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateTimelineEventErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateTimelineEventErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTimelineEventErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateTimelineEventErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateTimelineEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Originating service code
    pub service_code: std::option::Option<crate::model::ServiceCode>,
    /// Originating quota code
    pub quota_code: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    /// Originating service code
    pub fn service_code(&self) -> std::option::Option<&crate::model::ServiceCode> {
        self.service_code.as_ref()
    }
    /// Originating quota code
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<crate::model::ServiceCode>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Originating service code
        pub fn service_code(mut self, input: crate::model::ServiceCode) -> Self {
            self.service_code = Some(input);
            self
        }
        /// Originating service code
        pub fn set_service_code(
            mut self,
            input: std::option::Option<crate::model::ServiceCode>,
        ) -> Self {
            self.service_code = input;
            self
        }
        /// Originating quota code
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// Originating quota code
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Request references a resource which doesn't exist. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// The identifier for the requested resource
    pub resource_identifier: std::option::Option<std::string::String>,
    /// The resource type
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl ResourceNotFoundException {
    /// The identifier for the requested resource
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// The resource type
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// The identifier for the requested resource
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// The identifier for the requested resource
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// The resource type
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// The resource type
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_identifier: self.resource_identifier,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Updating or deleting a resource causes an inconsistent state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// The identifier of the requested resource
    pub resource_identifier: std::option::Option<std::string::String>,
    /// The resource type
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// If present in the output, the operation can be retried after this time
    pub retry_after: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConflictException {
    /// The identifier of the requested resource
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// The resource type
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// If present in the output, the operation can be retried after this time
    pub fn retry_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.retry_after.as_ref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("retry_after", &self.retry_after);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) retry_after: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// The identifier of the requested resource
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// The identifier of the requested resource
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// The resource type
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// The resource type
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// If present in the output, the operation can be retried after this time
        pub fn retry_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.retry_after = Some(input);
            self
        }
        /// If present in the output, the operation can be retried after this time
        pub fn set_retry_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.retry_after = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_identifier: self.resource_identifier,
                resource_type: self.resource_type,
                retry_after: self.retry_after,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You don't have sufficient access to perform this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Request would cause a service quota to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// The identifier for the requested resource
    pub resource_identifier: std::option::Option<std::string::String>,
    /// The resource type
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// Originating service code
    pub service_code: std::option::Option<crate::model::ServiceCode>,
    /// Originating quota code
    pub quota_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// The identifier for the requested resource
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// The resource type
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// Originating service code
    pub fn service_code(&self) -> std::option::Option<&crate::model::ServiceCode> {
        self.service_code.as_ref()
    }
    /// Originating quota code
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) service_code: std::option::Option<crate::model::ServiceCode>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// The identifier for the requested resource
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// The identifier for the requested resource
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// The resource type
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// The resource type
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Originating service code
        pub fn service_code(mut self, input: crate::model::ServiceCode) -> Self {
            self.service_code = Some(input);
            self
        }
        /// Originating service code
        pub fn set_service_code(
            mut self,
            input: std::option::Option<crate::model::ServiceCode>,
        ) -> Self {
            self.service_code = input;
            self
        }
        /// Originating quota code
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// Originating quota code
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_identifier: self.resource_identifier,
                resource_type: self.resource_type,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
