// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Systems Manager Incident Manager
///
/// Client for invoking operations on AWS Systems Manager Incident Manager. Each operation on AWS Systems Manager Incident Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ssmincidents::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ssmincidents::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ssmincidents::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateReplicationSet` operation.
    ///
    /// See [`CreateReplicationSet`](crate::client::fluent_builders::CreateReplicationSet) for more information about the
    /// operation and its arguments.
    pub fn create_replication_set(&self) -> fluent_builders::CreateReplicationSet<C, M, R> {
        fluent_builders::CreateReplicationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResponsePlan` operation.
    ///
    /// See [`CreateResponsePlan`](crate::client::fluent_builders::CreateResponsePlan) for more information about the
    /// operation and its arguments.
    pub fn create_response_plan(&self) -> fluent_builders::CreateResponsePlan<C, M, R> {
        fluent_builders::CreateResponsePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTimelineEvent` operation.
    ///
    /// See [`CreateTimelineEvent`](crate::client::fluent_builders::CreateTimelineEvent) for more information about the
    /// operation and its arguments.
    pub fn create_timeline_event(&self) -> fluent_builders::CreateTimelineEvent<C, M, R> {
        fluent_builders::CreateTimelineEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIncidentRecord` operation.
    ///
    /// See [`DeleteIncidentRecord`](crate::client::fluent_builders::DeleteIncidentRecord) for more information about the
    /// operation and its arguments.
    pub fn delete_incident_record(&self) -> fluent_builders::DeleteIncidentRecord<C, M, R> {
        fluent_builders::DeleteIncidentRecord::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationSet` operation.
    ///
    /// See [`DeleteReplicationSet`](crate::client::fluent_builders::DeleteReplicationSet) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_set(&self) -> fluent_builders::DeleteReplicationSet<C, M, R> {
        fluent_builders::DeleteReplicationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicy` operation.
    ///
    /// See [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResponsePlan` operation.
    ///
    /// See [`DeleteResponsePlan`](crate::client::fluent_builders::DeleteResponsePlan) for more information about the
    /// operation and its arguments.
    pub fn delete_response_plan(&self) -> fluent_builders::DeleteResponsePlan<C, M, R> {
        fluent_builders::DeleteResponsePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTimelineEvent` operation.
    ///
    /// See [`DeleteTimelineEvent`](crate::client::fluent_builders::DeleteTimelineEvent) for more information about the
    /// operation and its arguments.
    pub fn delete_timeline_event(&self) -> fluent_builders::DeleteTimelineEvent<C, M, R> {
        fluent_builders::DeleteTimelineEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIncidentRecord` operation.
    ///
    /// See [`GetIncidentRecord`](crate::client::fluent_builders::GetIncidentRecord) for more information about the
    /// operation and its arguments.
    pub fn get_incident_record(&self) -> fluent_builders::GetIncidentRecord<C, M, R> {
        fluent_builders::GetIncidentRecord::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReplicationSet` operation.
    ///
    /// See [`GetReplicationSet`](crate::client::fluent_builders::GetReplicationSet) for more information about the
    /// operation and its arguments.
    pub fn get_replication_set(&self) -> fluent_builders::GetReplicationSet<C, M, R> {
        fluent_builders::GetReplicationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourcePolicies` operation.
    ///
    /// See [`GetResourcePolicies`](crate::client::fluent_builders::GetResourcePolicies) for more information about the
    /// operation and its arguments.
    pub fn get_resource_policies(&self) -> fluent_builders::GetResourcePolicies<C, M, R> {
        fluent_builders::GetResourcePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResponsePlan` operation.
    ///
    /// See [`GetResponsePlan`](crate::client::fluent_builders::GetResponsePlan) for more information about the
    /// operation and its arguments.
    pub fn get_response_plan(&self) -> fluent_builders::GetResponsePlan<C, M, R> {
        fluent_builders::GetResponsePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTimelineEvent` operation.
    ///
    /// See [`GetTimelineEvent`](crate::client::fluent_builders::GetTimelineEvent) for more information about the
    /// operation and its arguments.
    pub fn get_timeline_event(&self) -> fluent_builders::GetTimelineEvent<C, M, R> {
        fluent_builders::GetTimelineEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIncidentRecords` operation.
    ///
    /// See [`ListIncidentRecords`](crate::client::fluent_builders::ListIncidentRecords) for more information about the
    /// operation and its arguments.
    pub fn list_incident_records(&self) -> fluent_builders::ListIncidentRecords<C, M, R> {
        fluent_builders::ListIncidentRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRelatedItems` operation.
    ///
    /// See [`ListRelatedItems`](crate::client::fluent_builders::ListRelatedItems) for more information about the
    /// operation and its arguments.
    pub fn list_related_items(&self) -> fluent_builders::ListRelatedItems<C, M, R> {
        fluent_builders::ListRelatedItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReplicationSets` operation.
    ///
    /// See [`ListReplicationSets`](crate::client::fluent_builders::ListReplicationSets) for more information about the
    /// operation and its arguments.
    pub fn list_replication_sets(&self) -> fluent_builders::ListReplicationSets<C, M, R> {
        fluent_builders::ListReplicationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResponsePlans` operation.
    ///
    /// See [`ListResponsePlans`](crate::client::fluent_builders::ListResponsePlans) for more information about the
    /// operation and its arguments.
    pub fn list_response_plans(&self) -> fluent_builders::ListResponsePlans<C, M, R> {
        fluent_builders::ListResponsePlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTimelineEvents` operation.
    ///
    /// See [`ListTimelineEvents`](crate::client::fluent_builders::ListTimelineEvents) for more information about the
    /// operation and its arguments.
    pub fn list_timeline_events(&self) -> fluent_builders::ListTimelineEvents<C, M, R> {
        fluent_builders::ListTimelineEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourcePolicy` operation.
    ///
    /// See [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy<C, M, R> {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartIncident` operation.
    ///
    /// See [`StartIncident`](crate::client::fluent_builders::StartIncident) for more information about the
    /// operation and its arguments.
    pub fn start_incident(&self) -> fluent_builders::StartIncident<C, M, R> {
        fluent_builders::StartIncident::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeletionProtection` operation.
    ///
    /// See [`UpdateDeletionProtection`](crate::client::fluent_builders::UpdateDeletionProtection) for more information about the
    /// operation and its arguments.
    pub fn update_deletion_protection(&self) -> fluent_builders::UpdateDeletionProtection<C, M, R> {
        fluent_builders::UpdateDeletionProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIncidentRecord` operation.
    ///
    /// See [`UpdateIncidentRecord`](crate::client::fluent_builders::UpdateIncidentRecord) for more information about the
    /// operation and its arguments.
    pub fn update_incident_record(&self) -> fluent_builders::UpdateIncidentRecord<C, M, R> {
        fluent_builders::UpdateIncidentRecord::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRelatedItems` operation.
    ///
    /// See [`UpdateRelatedItems`](crate::client::fluent_builders::UpdateRelatedItems) for more information about the
    /// operation and its arguments.
    pub fn update_related_items(&self) -> fluent_builders::UpdateRelatedItems<C, M, R> {
        fluent_builders::UpdateRelatedItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReplicationSet` operation.
    ///
    /// See [`UpdateReplicationSet`](crate::client::fluent_builders::UpdateReplicationSet) for more information about the
    /// operation and its arguments.
    pub fn update_replication_set(&self) -> fluent_builders::UpdateReplicationSet<C, M, R> {
        fluent_builders::UpdateReplicationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResponsePlan` operation.
    ///
    /// See [`UpdateResponsePlan`](crate::client::fluent_builders::UpdateResponsePlan) for more information about the
    /// operation and its arguments.
    pub fn update_response_plan(&self) -> fluent_builders::UpdateResponsePlan<C, M, R> {
        fluent_builders::UpdateResponsePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTimelineEvent` operation.
    ///
    /// See [`UpdateTimelineEvent`](crate::client::fluent_builders::UpdateTimelineEvent) for more information about the
    /// operation and its arguments.
    pub fn update_timeline_event(&self) -> fluent_builders::UpdateTimelineEvent<C, M, R> {
        fluent_builders::UpdateTimelineEvent::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateReplicationSet`.
    ///
    /// <p>A replication set replicates and encrypts your data to the provided Regions with the
    /// provided KMS key. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReplicationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replication_set_input::Builder,
    }
    impl<C, M, R> CreateReplicationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplicationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplicationSetInputOperationOutputAlias,
                crate::output::CreateReplicationSetOutput,
                crate::error::CreateReplicationSetError,
                crate::input::CreateReplicationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The Regions that Incident Manager replicates your data to. You can have up to three Regions
        /// in your replication set.</p>
        pub fn regions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RegionMapInputValue>,
        ) -> Self {
            self.inner = self.inner.regions(k, v);
            self
        }
        /// <p>The Regions that Incident Manager replicates your data to. You can have up to three Regions
        /// in your replication set.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RegionMapInputValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResponsePlan`.
    ///
    /// <p>Creates a response plan that automates the initial response to incidents. A response
    /// plan engages contacts, starts chat channel collaboration, and initiates runbooks at the
    /// beginning of an incident.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResponsePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_response_plan_input::Builder,
    }
    impl<C, M, R> CreateResponsePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResponsePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResponsePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResponsePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResponsePlanInputOperationOutputAlias,
                crate::output::CreateResponsePlanOutput,
                crate::error::CreateResponsePlanError,
                crate::input::CreateResponsePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The short format name of the response plan. Can't include spaces.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The short format name of the response plan. Can't include spaces.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The long format of the response plan name. This field can contain spaces.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The long format of the response plan name. This field can contain spaces.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>Details used to create an incident when using this response plan.</p>
        pub fn incident_template(mut self, inp: crate::model::IncidentTemplate) -> Self {
            self.inner = self.inner.incident_template(inp);
            self
        }
        /// <p>Details used to create an incident when using this response plan.</p>
        pub fn set_incident_template(
            mut self,
            input: std::option::Option<crate::model::IncidentTemplate>,
        ) -> Self {
            self.inner = self.inner.set_incident_template(input);
            self
        }
        /// <p>The Chatbot chat channel used for collaboration during an
        /// incident.</p>
        pub fn chat_channel(mut self, inp: crate::model::ChatChannel) -> Self {
            self.inner = self.inner.chat_channel(inp);
            self
        }
        /// <p>The Chatbot chat channel used for collaboration during an
        /// incident.</p>
        pub fn set_chat_channel(
            mut self,
            input: std::option::Option<crate::model::ChatChannel>,
        ) -> Self {
            self.inner = self.inner.set_chat_channel(input);
            self
        }
        /// <p>The contacts and escalation plans that the response plan engages during an
        /// incident.</p>
        pub fn engagements(mut self, inp: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.engagements(inp);
            self
        }
        /// <p>The contacts and escalation plans that the response plan engages during an
        /// incident.</p>
        pub fn set_engagements(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_engagements(input);
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions that the response plan starts at the beginning of an incident.</p>
        pub fn actions(mut self, inp: impl Into<crate::model::Action>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>The actions that the response plan starts at the beginning of an incident.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTimelineEvent`.
    ///
    /// <p>Creates a custom timeline event on the incident details page of an incident record.
    /// Timeline events are automatically created by Incident Manager, marking key moment during an
    /// incident. You can create custom timeline events to mark important events that are
    /// automatically detected by Incident Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTimelineEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_timeline_event_input::Builder,
    }
    impl<C, M, R> CreateTimelineEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTimelineEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTimelineEventOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTimelineEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTimelineEventInputOperationOutputAlias,
                crate::output::CreateTimelineEventOutput,
                crate::error::CreateTimelineEventError,
                crate::input::CreateTimelineEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token ensuring that the action is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record to which the event will be
        /// added.</p>
        pub fn incident_record_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_record_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record to which the event will be
        /// added.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_record_arn(input);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn event_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.event_time(inp);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_event_time(input);
            self
        }
        /// <p>The type of the event. You can create timeline events of type <code>Custom
        /// Event</code>.</p>
        pub fn event_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type(inp);
            self
        }
        /// <p>The type of the event. You can create timeline events of type <code>Custom
        /// Event</code>.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_type(input);
            self
        }
        /// <p>A short description of the event as a valid JSON string. There is no other schema
        /// imposed.</p>
        pub fn event_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_data(inp);
            self
        }
        /// <p>A short description of the event as a valid JSON string. There is no other schema
        /// imposed.</p>
        pub fn set_event_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIncidentRecord`.
    ///
    /// <p>Delete an incident record from Incident Manager. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIncidentRecord<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_incident_record_input::Builder,
    }
    impl<C, M, R> DeleteIncidentRecord<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIncidentRecord`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIncidentRecordOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIncidentRecordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIncidentRecordInputOperationOutputAlias,
                crate::output::DeleteIncidentRecordOutput,
                crate::error::DeleteIncidentRecordError,
                crate::input::DeleteIncidentRecordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are deleting.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are deleting.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationSet`.
    ///
    /// <p>Deletes all Regions in your replication set. Deleting the replication set deletes all
    /// Incident Manager data.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReplicationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_set_input::Builder,
    }
    impl<C, M, R> DeleteReplicationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationSetInputOperationOutputAlias,
                crate::output::DeleteReplicationSetOutput,
                crate::error::DeleteReplicationSetError,
                crate::input::DeleteReplicationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're deleting.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're deleting.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes the resource policy that Resource Access Manager uses to share your Incident Manager
    /// resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you're deleting the policy from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you're deleting the policy from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The ID of the resource policy you're deleting.</p>
        pub fn policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(inp);
            self
        }
        /// <p>The ID of the resource policy you're deleting.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResponsePlan`.
    ///
    /// <p>Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge events from creating an incident with this
    /// response plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResponsePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_response_plan_input::Builder,
    }
    impl<C, M, R> DeleteResponsePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResponsePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResponsePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResponsePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResponsePlanInputOperationOutputAlias,
                crate::output::DeleteResponsePlanOutput,
                crate::error::DeleteResponsePlanError,
                crate::input::DeleteResponsePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTimelineEvent`.
    ///
    /// <p>Deletes a timeline event from an incident.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTimelineEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_timeline_event_input::Builder,
    }
    impl<C, M, R> DeleteTimelineEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTimelineEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTimelineEventOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTimelineEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTimelineEventInputOperationOutputAlias,
                crate::output::DeleteTimelineEventOutput,
                crate::error::DeleteTimelineEventError,
                crate::input::DeleteTimelineEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn incident_record_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_record_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_record_arn(input);
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using
        /// <code>ListTimelineEvents</code>.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using
        /// <code>ListTimelineEvents</code>.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIncidentRecord`.
    ///
    /// <p>Returns the details for the specified incident record.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIncidentRecord<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_incident_record_input::Builder,
    }
    impl<C, M, R> GetIncidentRecord<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIncidentRecord`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIncidentRecordOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIncidentRecordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIncidentRecordInputOperationOutputAlias,
                crate::output::GetIncidentRecordOutput,
                crate::error::GetIncidentRecordError,
                crate::input::GetIncidentRecordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReplicationSet`.
    ///
    /// <p>Retrieve your Incident Manager replication set.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetReplicationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_replication_set_input::Builder,
    }
    impl<C, M, R> GetReplicationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReplicationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReplicationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReplicationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReplicationSetInputOperationOutputAlias,
                crate::output::GetReplicationSetOutput,
                crate::error::GetReplicationSetError,
                crate::input::GetReplicationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you want to retrieve.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you want to retrieve.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicies`.
    ///
    /// <p>Retrieves the resource policies attached to the specified response plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourcePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policies_input::Builder,
    }
    impl<C, M, R> GetResourcePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePoliciesInputOperationOutputAlias,
                crate::output::GetResourcePoliciesOutput,
                crate::error::GetResourcePoliciesError,
                crate::input::GetResourcePoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan with the attached resource policy. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan with the attached resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of resource policies to display per page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of resource policies to display per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResponsePlan`.
    ///
    /// <p>Retrieves the details of the specified response plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResponsePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_response_plan_input::Builder,
    }
    impl<C, M, R> GetResponsePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResponsePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResponsePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResponsePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResponsePlanInputOperationOutputAlias,
                crate::output::GetResponsePlanOutput,
                crate::error::GetResponsePlanError,
                crate::input::GetResponsePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTimelineEvent`.
    ///
    /// <p>Retrieves a timeline event based on its ID and incident record.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTimelineEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_timeline_event_input::Builder,
    }
    impl<C, M, R> GetTimelineEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTimelineEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTimelineEventOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTimelineEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTimelineEventInputOperationOutputAlias,
                crate::output::GetTimelineEventOutput,
                crate::error::GetTimelineEventError,
                crate::input::GetTimelineEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn incident_record_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_record_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_record_arn(input);
            self
        }
        /// <p>The ID of the event. You can get an event's ID when you create it, or by using
        /// <code>ListTimelineEvents</code>.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The ID of the event. You can get an event's ID when you create it, or by using
        /// <code>ListTimelineEvents</code>.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIncidentRecords`.
    ///
    /// <p>Lists all incident records in your account. Use this command to retrieve the Amazon
    /// Resource Name (ARN) of the incident record you want to update. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListIncidentRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_incident_records_input::Builder,
    }
    impl<C, M, R> ListIncidentRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIncidentRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIncidentRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIncidentRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIncidentRecordsInputOperationOutputAlias,
                crate::output::ListIncidentRecordsOutput,
                crate::error::ListIncidentRecordsError,
                crate::input::ListIncidentRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters the list of incident records through which you are searching. You can filter
        /// on the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>creationTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>impact</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>createdBy</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Note the following when deciding how to use Filters:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify a Filter, the response includes all incident
        /// records.</p>
        /// </li>
        /// <li>
        /// <p>If you specify more than one filter in a single request, the response returns
        /// incident records that match all filters.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a filter with more than one value, the response returns
        /// incident records that match any of the values provided.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters the list of incident records through which you are searching. You can filter
        /// on the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>creationTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>impact</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>createdBy</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Note the following when deciding how to use Filters:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify a Filter, the response includes all incident
        /// records.</p>
        /// </li>
        /// <li>
        /// <p>If you specify more than one filter in a single request, the response returns
        /// incident records that match all filters.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a filter with more than one value, the response returns
        /// incident records that match any of the values provided.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRelatedItems`.
    ///
    /// <p>List all related items for an incident record.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRelatedItems<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_related_items_input::Builder,
    }
    impl<C, M, R> ListRelatedItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRelatedItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRelatedItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRelatedItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRelatedItemsInputOperationOutputAlias,
                crate::output::ListRelatedItemsOutput,
                crate::error::ListRelatedItemsError,
                crate::input::ListRelatedItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record containing the listed related
        /// items.</p>
        pub fn incident_record_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_record_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record containing the listed related
        /// items.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_record_arn(input);
            self
        }
        /// <p>The maximum number of related items per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of related items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReplicationSets`.
    ///
    /// <p>Lists details about the replication set configured in your account. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListReplicationSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_replication_sets_input::Builder,
    }
    impl<C, M, R> ListReplicationSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReplicationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReplicationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReplicationSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReplicationSetsInputOperationOutputAlias,
                crate::output::ListReplicationSetsOutput,
                crate::error::ListReplicationSetsError,
                crate::input::ListReplicationSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results per page. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResponsePlans`.
    ///
    /// <p>Lists all response plans in your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResponsePlans<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_response_plans_input::Builder,
    }
    impl<C, M, R> ListResponsePlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResponsePlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResponsePlansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResponsePlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResponsePlansInputOperationOutputAlias,
                crate::output::ListResponsePlansOutput,
                crate::error::ListResponsePlansError,
                crate::input::ListResponsePlansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of response plans per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of response plans per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that are attached to the specified response plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTimelineEvents`.
    ///
    /// <p>Lists timeline events for the specified incident record.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTimelineEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_timeline_events_input::Builder,
    }
    impl<C, M, R> ListTimelineEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTimelineEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTimelineEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTimelineEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTimelineEventsInputOperationOutputAlias,
                crate::output::ListTimelineEventsOutput,
                crate::error::ListTimelineEventsError,
                crate::input::ListTimelineEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn incident_record_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_record_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_record_arn(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters the timeline events based on the provided conditional values. You can filter
        /// timeline events using the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>eventTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>eventType</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Note the following when deciding how to use Filters:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify a Filter, the response includes all timeline
        /// events.</p>
        /// </li>
        /// <li>
        /// <p>If you specify more than one filter in a single request, the response returns
        /// timeline events that match all filters.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a filter with more than one value, the response returns
        /// timeline events that match any of the values provided.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters the timeline events based on the provided conditional values. You can filter
        /// timeline events using the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>eventTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>eventType</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Note the following when deciding how to use Filters:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify a Filter, the response includes all timeline
        /// events.</p>
        /// </li>
        /// <li>
        /// <p>If you specify more than one filter in a single request, the response returns
        /// timeline events that match all filters.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a filter with more than one value, the response returns
        /// timeline events that match any of the values provided.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Sort by the specified key value pair.</p>
        pub fn sort_by(mut self, inp: crate::model::TimelineEventSort) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Sort by the specified key value pair.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::TimelineEventSort>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>Sorts the order of timeline events by the value specified in the <code>sortBy</code>
        /// field.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>Sorts the order of timeline events by the value specified in the <code>sortBy</code>
        /// field.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Adds a resource policy to the specified response plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl<C, M, R> PutResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourcePolicyInputOperationOutputAlias,
                crate::output::PutResourcePolicyOutput,
                crate::error::PutResourcePolicyError,
                crate::input::PutResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the resource policy
        /// to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the resource policy
        /// to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartIncident`.
    ///
    /// <p>Used to start an incident from CloudWatch alarms, EventBridge events, or
    /// manually. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartIncident<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_incident_input::Builder,
    }
    impl<C, M, R> StartIncident<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartIncident`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartIncidentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartIncidentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartIncidentInputOperationOutputAlias,
                crate::output::StartIncidentOutput,
                crate::error::StartIncidentError,
                crate::input::StartIncidentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat
        /// channels, Amazon SNS topics, runbooks, title, and impact of the incident. </p>
        pub fn response_plan_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_plan_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat
        /// channels, Amazon SNS topics, runbooks, title, and impact of the incident. </p>
        pub fn set_response_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_plan_arn(input);
            self
        }
        /// <p>Provide a title for the incident. Providing a title overwrites the title provided by
        /// the response plan. </p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>Provide a title for the incident. Providing a title overwrites the title provided by
        /// the response plan. </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, this typically relates to full application
        /// failure that impacts many to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> -  Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn impact(mut self, inp: i32) -> Self {
            self.inner = self.inner.impact(inp);
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, this typically relates to full application
        /// failure that impacts many to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> -  Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn set_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_impact(input);
            self
        }
        /// <p>Details of what created the incident record in Incident Manager.</p>
        pub fn trigger_details(mut self, inp: crate::model::TriggerDetails) -> Self {
            self.inner = self.inner.trigger_details(inp);
            self
        }
        /// <p>Details of what created the incident record in Incident Manager.</p>
        pub fn set_trigger_details(
            mut self,
            input: std::option::Option<crate::model::TriggerDetails>,
        ) -> Self {
            self.inner = self.inner.set_trigger_details(input);
            self
        }
        /// Appends an item to `relatedItems`.
        ///
        /// To override the contents of this collection use [`set_related_items`](Self::set_related_items).
        ///
        /// <p>Add related items to the incident for other responders to use. Related items are AWS
        /// resources, external links, or files uploaded to an Amazon S3 bucket. </p>
        pub fn related_items(mut self, inp: impl Into<crate::model::RelatedItem>) -> Self {
            self.inner = self.inner.related_items(inp);
            self
        }
        /// <p>Add related items to the incident for other responders to use. Related items are AWS
        /// resources, external links, or files uploaded to an Amazon S3 bucket. </p>
        pub fn set_related_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedItem>>,
        ) -> Self {
            self.inner = self.inner.set_related_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds a tag to a response plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're removing a tag from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're removing a tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The name of the tag you're removing from the response plan.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The name of the tag you're removing from the response plan.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeletionProtection`.
    ///
    /// <p>Update deletion protection to either allow or deny deletion of the final Region in a
    /// replication set.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDeletionProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_deletion_protection_input::Builder,
    }
    impl<C, M, R> UpdateDeletionProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeletionProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeletionProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeletionProtectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeletionProtectionInputOperationOutputAlias,
                crate::output::UpdateDeletionProtectionOutput,
                crate::error::UpdateDeletionProtectionError,
                crate::input::UpdateDeletionProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Details if deletion protection is enabled or disabled in your account.</p>
        pub fn deletion_protected(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protected(inp);
            self
        }
        /// <p>Details if deletion protection is enabled or disabled in your account.</p>
        pub fn set_deletion_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protected(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIncidentRecord`.
    ///
    /// <p>Update the details of an incident record. You can use this operation to update an
    /// incident record from the defined chat channel. For more information about using actions
    /// in chat channels, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact">Interacting through chat</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIncidentRecord<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_incident_record_input::Builder,
    }
    impl<C, M, R> UpdateIncidentRecord<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIncidentRecord`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIncidentRecordOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIncidentRecordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIncidentRecordInputOperationOutputAlias,
                crate::output::UpdateIncidentRecordOutput,
                crate::error::UpdateIncidentRecordError,
                crate::input::UpdateIncidentRecordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token that ensures that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token that ensures that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are updating.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are updating.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>A brief description of the incident.</p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>A brief description of the incident.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>A longer description of what occurred during the incident.</p>
        pub fn summary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.summary(inp);
            self
        }
        /// <p>A longer description of what occurred during the incident.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_summary(input);
            self
        }
        /// <p>Defines the impact of the incident to customers and applications. Providing an impact
        /// overwrites the impact provided by the response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, full application failure that impacts many
        /// to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> - Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> - Low impact, customer aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn impact(mut self, inp: i32) -> Self {
            self.inner = self.inner.impact(inp);
            self
        }
        /// <p>Defines the impact of the incident to customers and applications. Providing an impact
        /// overwrites the impact provided by the response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, full application failure that impacts many
        /// to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> - Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> - Low impact, customer aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn set_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_impact(input);
            self
        }
        /// <p>The status of the incident. An incident can be <code>Open</code> or
        /// <code>Resolved</code>.</p>
        pub fn status(mut self, inp: crate::model::IncidentRecordStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the incident. An incident can be <code>Open</code> or
        /// <code>Resolved</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IncidentRecordStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The Chatbot chat channel where responders can collaborate.</p>
        pub fn chat_channel(mut self, inp: crate::model::ChatChannel) -> Self {
            self.inner = self.inner.chat_channel(inp);
            self
        }
        /// <p>The Chatbot chat channel where responders can collaborate.</p>
        pub fn set_chat_channel(
            mut self,
            input: std::option::Option<crate::model::ChatChannel>,
        ) -> Self {
            self.inner = self.inner.set_chat_channel(input);
            self
        }
        /// Appends an item to `notificationTargets`.
        ///
        /// To override the contents of this collection use [`set_notification_targets`](Self::set_notification_targets).
        ///
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        /// <p>Using multiple SNS topics creates redundancy in the event that a Region is down during
        /// the incident.</p>
        pub fn notification_targets(
            mut self,
            inp: impl Into<crate::model::NotificationTargetItem>,
        ) -> Self {
            self.inner = self.inner.notification_targets(inp);
            self
        }
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        /// <p>Using multiple SNS topics creates redundancy in the event that a Region is down during
        /// the incident.</p>
        pub fn set_notification_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
        ) -> Self {
            self.inner = self.inner.set_notification_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRelatedItems`.
    ///
    /// <p>Add or remove related items from the related items tab of an incident record.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRelatedItems<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_related_items_input::Builder,
    }
    impl<C, M, R> UpdateRelatedItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRelatedItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRelatedItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRelatedItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRelatedItemsInputOperationOutputAlias,
                crate::output::UpdateRelatedItemsOutput,
                crate::error::UpdateRelatedItemsError,
                crate::input::UpdateRelatedItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record containing the related items you
        /// are updating.</p>
        pub fn incident_record_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_record_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record containing the related items you
        /// are updating.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_record_arn(input);
            self
        }
        /// <p>Details about the item you are adding or deleting.</p>
        pub fn related_items_update(mut self, inp: crate::model::RelatedItemsUpdate) -> Self {
            self.inner = self.inner.related_items_update(inp);
            self
        }
        /// <p>Details about the item you are adding or deleting.</p>
        pub fn set_related_items_update(
            mut self,
            input: std::option::Option<crate::model::RelatedItemsUpdate>,
        ) -> Self {
            self.inner = self.inner.set_related_items_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationSet`.
    ///
    /// <p>Add or delete Regions from your replication set.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateReplicationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_replication_set_input::Builder,
    }
    impl<C, M, R> UpdateReplicationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReplicationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReplicationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReplicationSetInputOperationOutputAlias,
                crate::output::UpdateReplicationSetOutput,
                crate::error::UpdateReplicationSetError,
                crate::input::UpdateReplicationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>An action to add or delete a Region.</p>
        pub fn actions(mut self, inp: impl Into<crate::model::UpdateReplicationSetAction>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>An action to add or delete a Region.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateReplicationSetAction>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResponsePlan`.
    ///
    /// <p>Updates the specified response plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResponsePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_response_plan_input::Builder,
    }
    impl<C, M, R> UpdateResponsePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResponsePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResponsePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResponsePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResponsePlanInputOperationOutputAlias,
                crate::output::UpdateResponsePlanOutput,
                crate::error::UpdateResponsePlanError,
                crate::input::UpdateResponsePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The long format name of the response plan. The display name can't contain
        /// spaces.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The long format name of the response plan. The display name can't contain
        /// spaces.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The short format name of the incident. The title can't contain spaces.</p>
        pub fn incident_template_title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_template_title(inp);
            self
        }
        /// <p>The short format name of the incident. The title can't contain spaces.</p>
        pub fn set_incident_template_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_template_title(input);
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>5</code> - Severe impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> - High impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> - Medium impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - Low impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>1</code> - No impact</p>
        /// </li>
        /// </ul>
        pub fn incident_template_impact(mut self, inp: i32) -> Self {
            self.inner = self.inner.incident_template_impact(inp);
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>5</code> - Severe impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> - High impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> - Medium impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - Low impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>1</code> - No impact</p>
        /// </li>
        /// </ul>
        pub fn set_incident_template_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_incident_template_impact(input);
            self
        }
        /// <p>A brief summary of the incident. This typically contains what has happened, what's
        /// currently happening, and next steps.</p>
        pub fn incident_template_summary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_template_summary(inp);
            self
        }
        /// <p>A brief summary of the incident. This typically contains what has happened, what's
        /// currently happening, and next steps.</p>
        pub fn set_incident_template_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_template_summary(input);
            self
        }
        /// <p>The string Incident Manager uses to prevent duplicate incidents from being created by the
        /// same incident in the same account.</p>
        pub fn incident_template_dedupe_string(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.incident_template_dedupe_string(inp);
            self
        }
        /// <p>The string Incident Manager uses to prevent duplicate incidents from being created by the
        /// same incident in the same account.</p>
        pub fn set_incident_template_dedupe_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_template_dedupe_string(input);
            self
        }
        /// Appends an item to `incidentTemplateNotificationTargets`.
        ///
        /// To override the contents of this collection use [`set_incident_template_notification_targets`](Self::set_incident_template_notification_targets).
        ///
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        pub fn incident_template_notification_targets(
            mut self,
            inp: impl Into<crate::model::NotificationTargetItem>,
        ) -> Self {
            self.inner = self.inner.incident_template_notification_targets(inp);
            self
        }
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        pub fn set_incident_template_notification_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
        ) -> Self {
            self.inner = self.inner.set_incident_template_notification_targets(input);
            self
        }
        /// <p>The Chatbot chat channel used for collaboration during an
        /// incident.</p>
        /// <p>Use the empty structure to remove the chat channel from the response plan.</p>
        pub fn chat_channel(mut self, inp: crate::model::ChatChannel) -> Self {
            self.inner = self.inner.chat_channel(inp);
            self
        }
        /// <p>The Chatbot chat channel used for collaboration during an
        /// incident.</p>
        /// <p>Use the empty structure to remove the chat channel from the response plan.</p>
        pub fn set_chat_channel(
            mut self,
            input: std::option::Option<crate::model::ChatChannel>,
        ) -> Self {
            self.inner = self.inner.set_chat_channel(input);
            self
        }
        /// <p>The contacts and escalation plans that Incident Manager engages at the start of the incident.</p>
        pub fn engagements(mut self, inp: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.engagements(inp);
            self
        }
        /// <p>The contacts and escalation plans that Incident Manager engages at the start of the incident.</p>
        pub fn set_engagements(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_engagements(input);
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions that this response plan takes at the beginning of an incident.</p>
        pub fn actions(mut self, inp: impl Into<crate::model::Action>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>The actions that this response plan takes at the beginning of an incident.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTimelineEvent`.
    ///
    /// <p>Updates a timeline event. You can update events of type <code>Custom
    /// Event</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTimelineEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_timeline_event_input::Builder,
    }
    impl<C, M, R> UpdateTimelineEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTimelineEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTimelineEventOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTimelineEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTimelineEventInputOperationOutputAlias,
                crate::output::UpdateTimelineEventOutput,
                crate::error::UpdateTimelineEventError,
                crate::input::UpdateTimelineEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn incident_record_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_record_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that includes the timeline
        /// event.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_incident_record_arn(input);
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using
        /// <code>ListTimelineEvents</code>.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using
        /// <code>ListTimelineEvents</code>.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn event_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.event_time(inp);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_event_time(input);
            self
        }
        /// <p>The type of the event. You can update events of type <code>Custom Event</code>.</p>
        pub fn event_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type(inp);
            self
        }
        /// <p>The type of the event. You can update events of type <code>Custom Event</code>.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_type(input);
            self
        }
        /// <p>A short description of the event.</p>
        pub fn event_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_data(inp);
            self
        }
        /// <p>A short description of the event.</p>
        pub fn set_event_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_data(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
