// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceCode {
    #[allow(missing_docs)] // documentation missing in model
    SsmIncidents,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceCode {
    fn from(s: &str) -> Self {
        match s {
            "ssm-incidents" => ServiceCode::SsmIncidents,
            other => ServiceCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceCode::from(s))
    }
}
impl ServiceCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceCode::SsmIncidents => "ssm-incidents",
            ServiceCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ssm-incidents"]
    }
}
impl AsRef<str> for ServiceCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    IncidentRecord,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationSet,
    #[allow(missing_docs)] // documentation missing in model
    ResourcePolicy,
    #[allow(missing_docs)] // documentation missing in model
    ResponsePlan,
    #[allow(missing_docs)] // documentation missing in model
    TimelineEvent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "INCIDENT_RECORD" => ResourceType::IncidentRecord,
            "REPLICATION_SET" => ResourceType::ReplicationSet,
            "RESOURCE_POLICY" => ResourceType::ResourcePolicy,
            "RESPONSE_PLAN" => ResourceType::ResponsePlan,
            "TIMELINE_EVENT" => ResourceType::TimelineEvent,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::IncidentRecord => "INCIDENT_RECORD",
            ResourceType::ReplicationSet => "REPLICATION_SET",
            ResourceType::ResourcePolicy => "RESOURCE_POLICY",
            ResourceType::ResponsePlan => "RESPONSE_PLAN",
            ResourceType::TimelineEvent => "TIMELINE_EVENT",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "INCIDENT_RECORD",
            "REPLICATION_SET",
            "RESOURCE_POLICY",
            "RESPONSE_PLAN",
            "TIMELINE_EVENT",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The action that starts at the beginning of an incident. The response plan defines the
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Action {
    /// <p>The Systems Manager automation document to start as the runbook at the beginning of
    /// the incident.</p>
    SsmAutomation(crate::model::SsmAutomation),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Action {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`SsmAutomation`](crate::model::Action::SsmAutomation), extracting the inner [`SsmAutomation`](crate::model::SsmAutomation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ssm_automation(&self) -> std::result::Result<&crate::model::SsmAutomation, &Self> {
        if let Action::SsmAutomation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SsmAutomation`](crate::model::Action::SsmAutomation).
    pub fn is_ssm_automation(&self) -> bool {
        self.as_ssm_automation().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Details about the Systems Manager automation document that will be used as a runbook
/// during an incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmAutomation {
    /// <p>The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The automation document's name.</p>
    pub document_name: std::option::Option<std::string::String>,
    /// <p>The automation document's version to use when running.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The account that the automation document will be run in. This can be in either the management account or an application account.</p>
    pub target_account: std::option::Option<crate::model::SsmTargetAccount>,
    /// <p>The key-value pair parameters to use when running the automation document.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl SsmAutomation {
    /// <p>The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The automation document's name.</p>
    pub fn document_name(&self) -> std::option::Option<&str> {
        self.document_name.as_deref()
    }
    /// <p>The automation document's version to use when running.</p>
    pub fn document_version(&self) -> std::option::Option<&str> {
        self.document_version.as_deref()
    }
    /// <p>The account that the automation document will be run in. This can be in either the management account or an application account.</p>
    pub fn target_account(&self) -> std::option::Option<&crate::model::SsmTargetAccount> {
        self.target_account.as_ref()
    }
    /// <p>The key-value pair parameters to use when running the automation document.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.parameters.as_ref()
    }
}
impl std::fmt::Debug for SsmAutomation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmAutomation");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("document_name", &self.document_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("target_account", &self.target_account);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`SsmAutomation`](crate::model::SsmAutomation)
pub mod ssm_automation {
    /// A builder for [`SsmAutomation`](crate::model::SsmAutomation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) document_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) target_account: std::option::Option<crate::model::SsmTargetAccount>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The automation document's name.</p>
        pub fn document_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_name = Some(input.into());
            self
        }
        /// <p>The automation document's name.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_name = input;
            self
        }
        /// <p>The automation document's version to use when running.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The automation document's version to use when running.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The account that the automation document will be run in. This can be in either the management account or an application account.</p>
        pub fn target_account(mut self, input: crate::model::SsmTargetAccount) -> Self {
            self.target_account = Some(input);
            self
        }
        /// <p>The account that the automation document will be run in. This can be in either the management account or an application account.</p>
        pub fn set_target_account(
            mut self,
            input: std::option::Option<crate::model::SsmTargetAccount>,
        ) -> Self {
            self.target_account = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The key-value pair parameters to use when running the automation document.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The key-value pair parameters to use when running the automation document.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmAutomation`](crate::model::SsmAutomation)
        pub fn build(self) -> crate::model::SsmAutomation {
            crate::model::SsmAutomation {
                role_arn: self.role_arn,
                document_name: self.document_name,
                document_version: self.document_version,
                target_account: self.target_account,
                parameters: self.parameters,
            }
        }
    }
}
impl SsmAutomation {
    /// Creates a new builder-style object to manufacture [`SsmAutomation`](crate::model::SsmAutomation)
    pub fn builder() -> crate::model::ssm_automation::Builder {
        crate::model::ssm_automation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SsmTargetAccount {
    #[allow(missing_docs)] // documentation missing in model
    ImpactedAccount,
    #[allow(missing_docs)] // documentation missing in model
    ResponsePlanOwnerAccount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SsmTargetAccount {
    fn from(s: &str) -> Self {
        match s {
            "IMPACTED_ACCOUNT" => SsmTargetAccount::ImpactedAccount,
            "RESPONSE_PLAN_OWNER_ACCOUNT" => SsmTargetAccount::ResponsePlanOwnerAccount,
            other => SsmTargetAccount::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SsmTargetAccount {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SsmTargetAccount::from(s))
    }
}
impl SsmTargetAccount {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SsmTargetAccount::ImpactedAccount => "IMPACTED_ACCOUNT",
            SsmTargetAccount::ResponsePlanOwnerAccount => "RESPONSE_PLAN_OWNER_ACCOUNT",
            SsmTargetAccount::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IMPACTED_ACCOUNT", "RESPONSE_PLAN_OWNER_ACCOUNT"]
    }
}
impl AsRef<str> for SsmTargetAccount {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Chatbot chat channel used for collaboration during an
/// incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ChatChannel {
    /// <p>The Amazon SNS targets that Chatbot uses to notify the chat channel
    /// of updates to an incident. You can also make updates to the incident through the chat
    /// channel
    /// by
    /// using the Amazon SNS topics. </p>
    ChatbotSns(std::vec::Vec<std::string::String>),
    /// <p>Used to remove the chat channel from an incident record or response plan.</p>
    Empty(crate::model::EmptyChatChannel),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ChatChannel {
    /// Tries to convert the enum instance into [`ChatbotSns`](crate::model::ChatChannel::ChatbotSns), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_chatbot_sns(
        &self,
    ) -> std::result::Result<&std::vec::Vec<std::string::String>, &Self> {
        if let ChatChannel::ChatbotSns(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ChatbotSns`](crate::model::ChatChannel::ChatbotSns).
    pub fn is_chatbot_sns(&self) -> bool {
        self.as_chatbot_sns().is_ok()
    }
    /// Tries to convert the enum instance into [`Empty`](crate::model::ChatChannel::Empty), extracting the inner [`EmptyChatChannel`](crate::model::EmptyChatChannel).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_empty(&self) -> std::result::Result<&crate::model::EmptyChatChannel, &Self> {
        if let ChatChannel::Empty(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Empty`](crate::model::ChatChannel::Empty).
    pub fn is_empty(&self) -> bool {
        self.as_empty().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Used to remove the chat channel from an incident record or response plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmptyChatChannel {}
impl std::fmt::Debug for EmptyChatChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmptyChatChannel");
        formatter.finish()
    }
}
/// See [`EmptyChatChannel`](crate::model::EmptyChatChannel)
pub mod empty_chat_channel {
    /// A builder for [`EmptyChatChannel`](crate::model::EmptyChatChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EmptyChatChannel`](crate::model::EmptyChatChannel)
        pub fn build(self) -> crate::model::EmptyChatChannel {
            crate::model::EmptyChatChannel {}
        }
    }
}
impl EmptyChatChannel {
    /// Creates a new builder-style object to manufacture [`EmptyChatChannel`](crate::model::EmptyChatChannel)
    pub fn builder() -> crate::model::empty_chat_channel::Builder {
        crate::model::empty_chat_channel::Builder::default()
    }
}

/// <p>The SNS targets that are notified when updates are made to an incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum NotificationTargetItem {
    /// <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
    SnsTopicArn(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl NotificationTargetItem {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`SnsTopicArn`](crate::model::NotificationTargetItem::SnsTopicArn), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sns_topic_arn(&self) -> std::result::Result<&std::string::String, &Self> {
        if let NotificationTargetItem::SnsTopicArn(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SnsTopicArn`](crate::model::NotificationTargetItem::SnsTopicArn).
    pub fn is_sns_topic_arn(&self) -> bool {
        self.as_sns_topic_arn().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Details used when updating the replication set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum UpdateReplicationSetAction {
    /// <p>Details about the Amazon Web Services Region that you're adding to the replication
    /// set.</p>
    AddRegionAction(crate::model::AddRegionAction),
    /// <p>Details about the Amazon Web Services Region that you're deleting to the replication
    /// set.</p>
    DeleteRegionAction(crate::model::DeleteRegionAction),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl UpdateReplicationSetAction {
    /// Tries to convert the enum instance into [`AddRegionAction`](crate::model::UpdateReplicationSetAction::AddRegionAction), extracting the inner [`AddRegionAction`](crate::model::AddRegionAction).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_add_region_action(
        &self,
    ) -> std::result::Result<&crate::model::AddRegionAction, &Self> {
        if let UpdateReplicationSetAction::AddRegionAction(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AddRegionAction`](crate::model::UpdateReplicationSetAction::AddRegionAction).
    pub fn is_add_region_action(&self) -> bool {
        self.as_add_region_action().is_ok()
    }
    /// Tries to convert the enum instance into [`DeleteRegionAction`](crate::model::UpdateReplicationSetAction::DeleteRegionAction), extracting the inner [`DeleteRegionAction`](crate::model::DeleteRegionAction).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_delete_region_action(
        &self,
    ) -> std::result::Result<&crate::model::DeleteRegionAction, &Self> {
        if let UpdateReplicationSetAction::DeleteRegionAction(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`DeleteRegionAction`](crate::model::UpdateReplicationSetAction::DeleteRegionAction).
    pub fn is_delete_region_action(&self) -> bool {
        self.as_delete_region_action().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Defines the information about the Amazon Web Services Region you're deleting from your
/// replication set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegionAction {
    /// <p>The name of the Amazon Web Services Region you're deleting from the replication
    /// set.</p>
    pub region_name: std::option::Option<std::string::String>,
}
impl DeleteRegionAction {
    /// <p>The name of the Amazon Web Services Region you're deleting from the replication
    /// set.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRegionAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegionAction");
        formatter.field("region_name", &self.region_name);
        formatter.finish()
    }
}
/// See [`DeleteRegionAction`](crate::model::DeleteRegionAction)
pub mod delete_region_action {
    /// A builder for [`DeleteRegionAction`](crate::model::DeleteRegionAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Web Services Region you're deleting from the replication
        /// set.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services Region you're deleting from the replication
        /// set.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRegionAction`](crate::model::DeleteRegionAction)
        pub fn build(self) -> crate::model::DeleteRegionAction {
            crate::model::DeleteRegionAction {
                region_name: self.region_name,
            }
        }
    }
}
impl DeleteRegionAction {
    /// Creates a new builder-style object to manufacture [`DeleteRegionAction`](crate::model::DeleteRegionAction)
    pub fn builder() -> crate::model::delete_region_action::Builder {
        crate::model::delete_region_action::Builder::default()
    }
}

/// <p>Defines the Amazon Web Services Region and KMS key to add to the
/// replication set. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRegionAction {
    /// <p>The Amazon Web Services Region name to add to the replication set.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The KMS key ID to use to encrypt your replication set.</p>
    pub sse_kms_key_id: std::option::Option<std::string::String>,
}
impl AddRegionAction {
    /// <p>The Amazon Web Services Region name to add to the replication set.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The KMS key ID to use to encrypt your replication set.</p>
    pub fn sse_kms_key_id(&self) -> std::option::Option<&str> {
        self.sse_kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for AddRegionAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRegionAction");
        formatter.field("region_name", &self.region_name);
        formatter.field("sse_kms_key_id", &self.sse_kms_key_id);
        formatter.finish()
    }
}
/// See [`AddRegionAction`](crate::model::AddRegionAction)
pub mod add_region_action {
    /// A builder for [`AddRegionAction`](crate::model::AddRegionAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) sse_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services Region name to add to the replication set.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region name to add to the replication set.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The KMS key ID to use to encrypt your replication set.</p>
        pub fn sse_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key ID to use to encrypt your replication set.</p>
        pub fn set_sse_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddRegionAction`](crate::model::AddRegionAction)
        pub fn build(self) -> crate::model::AddRegionAction {
            crate::model::AddRegionAction {
                region_name: self.region_name,
                sse_kms_key_id: self.sse_kms_key_id,
            }
        }
    }
}
impl AddRegionAction {
    /// Creates a new builder-style object to manufacture [`AddRegionAction`](crate::model::AddRegionAction)
    pub fn builder() -> crate::model::add_region_action::Builder {
        crate::model::add_region_action::Builder::default()
    }
}

/// <p>Details about the related item you're adding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum RelatedItemsUpdate {
    /// <p>Details about the related item you're adding.</p>
    ItemToAdd(crate::model::RelatedItem),
    /// <p>Details about the related item you're deleting.</p>
    ItemToRemove(crate::model::ItemIdentifier),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl RelatedItemsUpdate {
    /// Tries to convert the enum instance into [`ItemToAdd`](crate::model::RelatedItemsUpdate::ItemToAdd), extracting the inner [`RelatedItem`](crate::model::RelatedItem).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_item_to_add(&self) -> std::result::Result<&crate::model::RelatedItem, &Self> {
        if let RelatedItemsUpdate::ItemToAdd(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ItemToAdd`](crate::model::RelatedItemsUpdate::ItemToAdd).
    pub fn is_item_to_add(&self) -> bool {
        self.as_item_to_add().is_ok()
    }
    /// Tries to convert the enum instance into [`ItemToRemove`](crate::model::RelatedItemsUpdate::ItemToRemove), extracting the inner [`ItemIdentifier`](crate::model::ItemIdentifier).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_item_to_remove(&self) -> std::result::Result<&crate::model::ItemIdentifier, &Self> {
        if let RelatedItemsUpdate::ItemToRemove(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ItemToRemove`](crate::model::RelatedItemsUpdate::ItemToRemove).
    pub fn is_item_to_remove(&self) -> bool {
        self.as_item_to_remove().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Details and type of a related item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ItemIdentifier {
    /// <p>Details about the related item.</p>
    pub value: std::option::Option<crate::model::ItemValue>,
    /// <p>The type of related item. Incident Manager supports the following types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ANALYSIS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INCIDENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>METRIC</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PARENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ATTACHMENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER</code>
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ItemType>,
}
impl ItemIdentifier {
    /// <p>Details about the related item.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::ItemValue> {
        self.value.as_ref()
    }
    /// <p>The type of related item. Incident Manager supports the following types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ANALYSIS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INCIDENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>METRIC</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PARENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ATTACHMENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ItemType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ItemIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ItemIdentifier");
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ItemIdentifier`](crate::model::ItemIdentifier)
pub mod item_identifier {
    /// A builder for [`ItemIdentifier`](crate::model::ItemIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::ItemValue>,
        pub(crate) r#type: std::option::Option<crate::model::ItemType>,
    }
    impl Builder {
        /// <p>Details about the related item.</p>
        pub fn value(mut self, input: crate::model::ItemValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Details about the related item.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::ItemValue>) -> Self {
            self.value = input;
            self
        }
        /// <p>The type of related item. Incident Manager supports the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ANALYSIS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCIDENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>METRIC</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PARENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ATTACHMENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ItemType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of related item. Incident Manager supports the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ANALYSIS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCIDENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>METRIC</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PARENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ATTACHMENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ItemType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ItemIdentifier`](crate::model::ItemIdentifier)
        pub fn build(self) -> crate::model::ItemIdentifier {
            crate::model::ItemIdentifier {
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl ItemIdentifier {
    /// Creates a new builder-style object to manufacture [`ItemIdentifier`](crate::model::ItemIdentifier)
    pub fn builder() -> crate::model::item_identifier::Builder {
        crate::model::item_identifier::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ItemType {
    #[allow(missing_docs)] // documentation missing in model
    Analysis,
    #[allow(missing_docs)] // documentation missing in model
    Attachment,
    #[allow(missing_docs)] // documentation missing in model
    Incident,
    #[allow(missing_docs)] // documentation missing in model
    Metric,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    Parent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ItemType {
    fn from(s: &str) -> Self {
        match s {
            "ANALYSIS" => ItemType::Analysis,
            "ATTACHMENT" => ItemType::Attachment,
            "INCIDENT" => ItemType::Incident,
            "METRIC" => ItemType::Metric,
            "OTHER" => ItemType::Other,
            "PARENT" => ItemType::Parent,
            other => ItemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ItemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ItemType::from(s))
    }
}
impl ItemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ItemType::Analysis => "ANALYSIS",
            ItemType::Attachment => "ATTACHMENT",
            ItemType::Incident => "INCIDENT",
            ItemType::Metric => "METRIC",
            ItemType::Other => "OTHER",
            ItemType::Parent => "PARENT",
            ItemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANALYSIS",
            "ATTACHMENT",
            "INCIDENT",
            "METRIC",
            "OTHER",
            "PARENT",
        ]
    }
}
impl AsRef<str> for ItemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a related item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ItemValue {
    /// <p>The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon
    /// resource.</p>
    Arn(std::string::String),
    /// <p>The metric definition, if the related item is a metric in Amazon CloudWatch.</p>
    MetricDefinition(std::string::String),
    /// <p>The URL, if the related item is a non-Amazon Web Services resource.</p>
    Url(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ItemValue {
    /// Tries to convert the enum instance into [`Arn`](crate::model::ItemValue::Arn), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_arn(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ItemValue::Arn(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Arn`](crate::model::ItemValue::Arn).
    pub fn is_arn(&self) -> bool {
        self.as_arn().is_ok()
    }
    /// Tries to convert the enum instance into [`MetricDefinition`](crate::model::ItemValue::MetricDefinition), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_metric_definition(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ItemValue::MetricDefinition(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`MetricDefinition`](crate::model::ItemValue::MetricDefinition).
    pub fn is_metric_definition(&self) -> bool {
        self.as_metric_definition().is_ok()
    }
    /// Tries to convert the enum instance into [`Url`](crate::model::ItemValue::Url), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_url(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ItemValue::Url(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Url`](crate::model::ItemValue::Url).
    pub fn is_url(&self) -> bool {
        self.as_url().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Resources that responders use to triage and mitigate the incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelatedItem {
    /// <p>Details about the related item.</p>
    pub identifier: std::option::Option<crate::model::ItemIdentifier>,
    /// <p>The title of the related item.</p>
    pub title: std::option::Option<std::string::String>,
}
impl RelatedItem {
    /// <p>Details about the related item.</p>
    pub fn identifier(&self) -> std::option::Option<&crate::model::ItemIdentifier> {
        self.identifier.as_ref()
    }
    /// <p>The title of the related item.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
}
impl std::fmt::Debug for RelatedItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelatedItem");
        formatter.field("identifier", &self.identifier);
        formatter.field("title", &self.title);
        formatter.finish()
    }
}
/// See [`RelatedItem`](crate::model::RelatedItem)
pub mod related_item {
    /// A builder for [`RelatedItem`](crate::model::RelatedItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<crate::model::ItemIdentifier>,
        pub(crate) title: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Details about the related item.</p>
        pub fn identifier(mut self, input: crate::model::ItemIdentifier) -> Self {
            self.identifier = Some(input);
            self
        }
        /// <p>Details about the related item.</p>
        pub fn set_identifier(
            mut self,
            input: std::option::Option<crate::model::ItemIdentifier>,
        ) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The title of the related item.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the related item.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// Consumes the builder and constructs a [`RelatedItem`](crate::model::RelatedItem)
        pub fn build(self) -> crate::model::RelatedItem {
            crate::model::RelatedItem {
                identifier: self.identifier,
                title: self.title,
            }
        }
    }
}
impl RelatedItem {
    /// Creates a new builder-style object to manufacture [`RelatedItem`](crate::model::RelatedItem)
    pub fn builder() -> crate::model::related_item::Builder {
        crate::model::related_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IncidentRecordStatus {
    #[allow(missing_docs)] // documentation missing in model
    Open,
    #[allow(missing_docs)] // documentation missing in model
    Resolved,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IncidentRecordStatus {
    fn from(s: &str) -> Self {
        match s {
            "OPEN" => IncidentRecordStatus::Open,
            "RESOLVED" => IncidentRecordStatus::Resolved,
            other => IncidentRecordStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IncidentRecordStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IncidentRecordStatus::from(s))
    }
}
impl IncidentRecordStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IncidentRecordStatus::Open => "OPEN",
            IncidentRecordStatus::Resolved => "RESOLVED",
            IncidentRecordStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPEN", "RESOLVED"]
    }
}
impl AsRef<str> for IncidentRecordStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about what caused the incident to be created in Incident Manager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerDetails {
    /// <p>Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "<code>aws.</code>" Customer-generated events can have any value
    /// here, as long as it doesn't begin with "<code>aws.</code>" We recommend the use of Java
    /// package-name style reverse domain-name strings. </p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source that detected the incident.</p>
    pub trigger_arn: std::option::Option<std::string::String>,
    /// <p>The time that the incident was detected.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is created.</p>
    pub raw_data: std::option::Option<std::string::String>,
}
impl TriggerDetails {
    /// <p>Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "<code>aws.</code>" Customer-generated events can have any value
    /// here, as long as it doesn't begin with "<code>aws.</code>" We recommend the use of Java
    /// package-name style reverse domain-name strings. </p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the source that detected the incident.</p>
    pub fn trigger_arn(&self) -> std::option::Option<&str> {
        self.trigger_arn.as_deref()
    }
    /// <p>The time that the incident was detected.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is created.</p>
    pub fn raw_data(&self) -> std::option::Option<&str> {
        self.raw_data.as_deref()
    }
}
impl std::fmt::Debug for TriggerDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerDetails");
        formatter.field("source", &self.source);
        formatter.field("trigger_arn", &self.trigger_arn);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("raw_data", &self.raw_data);
        formatter.finish()
    }
}
/// See [`TriggerDetails`](crate::model::TriggerDetails)
pub mod trigger_details {
    /// A builder for [`TriggerDetails`](crate::model::TriggerDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) trigger_arn: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) raw_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "<code>aws.</code>" Customer-generated events can have any value
        /// here, as long as it doesn't begin with "<code>aws.</code>" We recommend the use of Java
        /// package-name style reverse domain-name strings. </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "<code>aws.</code>" Customer-generated events can have any value
        /// here, as long as it doesn't begin with "<code>aws.</code>" We recommend the use of Java
        /// package-name style reverse domain-name strings. </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source that detected the incident.</p>
        pub fn trigger_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source that detected the incident.</p>
        pub fn set_trigger_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trigger_arn = input;
            self
        }
        /// <p>The time that the incident was detected.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time that the incident was detected.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is created.</p>
        pub fn raw_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_data = Some(input.into());
            self
        }
        /// <p>Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is created.</p>
        pub fn set_raw_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_data = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerDetails`](crate::model::TriggerDetails)
        pub fn build(self) -> crate::model::TriggerDetails {
            crate::model::TriggerDetails {
                source: self.source,
                trigger_arn: self.trigger_arn,
                timestamp: self.timestamp,
                raw_data: self.raw_data,
            }
        }
    }
}
impl TriggerDetails {
    /// Creates a new builder-style object to manufacture [`TriggerDetails`](crate::model::TriggerDetails)
    pub fn builder() -> crate::model::trigger_details::Builder {
        crate::model::trigger_details::Builder::default()
    }
}

/// <p>Details about a timeline event during an incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSummary {
    /// <p>The Amazon Resource Name (ARN) of the incident that the event happened during.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>The timeline event ID.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The time that the event occurred.</p>
    pub event_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the timeline event was last updated.</p>
    pub event_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of event. The timeline event must be <code>Custom Event</code>.</p>
    pub event_type: std::option::Option<std::string::String>,
}
impl EventSummary {
    /// <p>The Amazon Resource Name (ARN) of the incident that the event happened during.</p>
    pub fn incident_record_arn(&self) -> std::option::Option<&str> {
        self.incident_record_arn.as_deref()
    }
    /// <p>The timeline event ID.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>The time that the event occurred.</p>
    pub fn event_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_time.as_ref()
    }
    /// <p>The time that the timeline event was last updated.</p>
    pub fn event_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_updated_time.as_ref()
    }
    /// <p>The type of event. The timeline event must be <code>Custom Event</code>.</p>
    pub fn event_type(&self) -> std::option::Option<&str> {
        self.event_type.as_deref()
    }
}
impl std::fmt::Debug for EventSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSummary");
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("event_id", &self.event_id);
        formatter.field("event_time", &self.event_time);
        formatter.field("event_updated_time", &self.event_updated_time);
        formatter.field("event_type", &self.event_type);
        formatter.finish()
    }
}
/// See [`EventSummary`](crate::model::EventSummary)
pub mod event_summary {
    /// A builder for [`EventSummary`](crate::model::EventSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident that the event happened during.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that the event happened during.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>The timeline event ID.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The timeline event ID.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>The time that the timeline event was last updated.</p>
        pub fn event_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_updated_time = Some(input);
            self
        }
        /// <p>The time that the timeline event was last updated.</p>
        pub fn set_event_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_updated_time = input;
            self
        }
        /// <p>The type of event. The timeline event must be <code>Custom Event</code>.</p>
        pub fn event_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type = Some(input.into());
            self
        }
        /// <p>The type of event. The timeline event must be <code>Custom Event</code>.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_type = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSummary`](crate::model::EventSummary)
        pub fn build(self) -> crate::model::EventSummary {
            crate::model::EventSummary {
                incident_record_arn: self.incident_record_arn,
                event_id: self.event_id,
                event_time: self.event_time,
                event_updated_time: self.event_updated_time,
                event_type: self.event_type,
            }
        }
    }
}
impl EventSummary {
    /// Creates a new builder-style object to manufacture [`EventSummary`](crate::model::EventSummary)
    pub fn builder() -> crate::model::event_summary::Builder {
        crate::model::event_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimelineEventSort {
    #[allow(missing_docs)] // documentation missing in model
    EventTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimelineEventSort {
    fn from(s: &str) -> Self {
        match s {
            "EVENT_TIME" => TimelineEventSort::EventTime,
            other => TimelineEventSort::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimelineEventSort {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimelineEventSort::from(s))
    }
}
impl TimelineEventSort {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimelineEventSort::EventTime => "EVENT_TIME",
            TimelineEventSort::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EVENT_TIME"]
    }
}
impl AsRef<str> for TimelineEventSort {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filter the selection by using a condition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The key that you're filtering on.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The condition accepts before or after a specified time, equal to a string, or equal to an integer.</p>
    pub condition: std::option::Option<crate::model::Condition>,
}
impl Filter {
    /// <p>The key that you're filtering on.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The condition accepts before or after a specified time, equal to a string, or equal to an integer.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::Condition> {
        self.condition.as_ref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("key", &self.key);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<crate::model::Condition>,
    }
    impl Builder {
        /// <p>The key that you're filtering on.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key that you're filtering on.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The condition accepts before or after a specified time, equal to a string, or equal to an integer.</p>
        pub fn condition(mut self, input: crate::model::Condition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The condition accepts before or after a specified time, equal to a string, or equal to an integer.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::Condition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                key: self.key,
                condition: self.condition,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>A conditional statement with which to compare a value, after a timestamp, before a
/// timestamp, or equal to a string or integer. If multiple conditions are specified, the
/// conditionals become an <code>AND</code>ed statement. If multiple values are specified for a
/// conditional, the values are <code>OR</code>d.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Condition {
    /// <p>After the specified timestamp.</p>
    After(aws_smithy_types::Instant),
    /// <p>Before the specified timestamp</p>
    Before(aws_smithy_types::Instant),
    /// <p>The value is equal to the provided string or integer. </p>
    Equals(crate::model::AttributeValueList),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Condition {
    /// Tries to convert the enum instance into [`After`](crate::model::Condition::After), extracting the inner [`Instant`](aws_smithy_types::Instant).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_after(&self) -> std::result::Result<&aws_smithy_types::Instant, &Self> {
        if let Condition::After(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`After`](crate::model::Condition::After).
    pub fn is_after(&self) -> bool {
        self.as_after().is_ok()
    }
    /// Tries to convert the enum instance into [`Before`](crate::model::Condition::Before), extracting the inner [`Instant`](aws_smithy_types::Instant).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_before(&self) -> std::result::Result<&aws_smithy_types::Instant, &Self> {
        if let Condition::Before(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Before`](crate::model::Condition::Before).
    pub fn is_before(&self) -> bool {
        self.as_before().is_ok()
    }
    /// Tries to convert the enum instance into [`Equals`](crate::model::Condition::Equals), extracting the inner [`AttributeValueList`](crate::model::AttributeValueList).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_equals(&self) -> std::result::Result<&crate::model::AttributeValueList, &Self> {
        if let Condition::Equals(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Equals`](crate::model::Condition::Equals).
    pub fn is_equals(&self) -> bool {
        self.as_equals().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Use the AttributeValueList to filter by string or integer values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AttributeValueList {
    /// <p>The list of integer values that the filter matches.</p>
    IntegerValues(std::vec::Vec<i32>),
    /// <p>The list of string values that the filter matches.</p>
    StringValues(std::vec::Vec<std::string::String>),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AttributeValueList {
    /// Tries to convert the enum instance into [`IntegerValues`](crate::model::AttributeValueList::IntegerValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_integer_values(&self) -> std::result::Result<&std::vec::Vec<i32>, &Self> {
        if let AttributeValueList::IntegerValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`IntegerValues`](crate::model::AttributeValueList::IntegerValues).
    pub fn is_integer_values(&self) -> bool {
        self.as_integer_values().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValues`](crate::model::AttributeValueList::StringValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_values(
        &self,
    ) -> std::result::Result<&std::vec::Vec<std::string::String>, &Self> {
        if let AttributeValueList::StringValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`StringValues`](crate::model::AttributeValueList::StringValues).
    pub fn is_string_values(&self) -> bool {
        self.as_string_values().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Details of the response plan that are used when creating an incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponsePlanSummary {
    /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the response plan. This can't include spaces.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The human readable name of the response plan. This can include spaces.</p>
    pub display_name: std::option::Option<std::string::String>,
}
impl ResponsePlanSummary {
    /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the response plan. This can't include spaces.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The human readable name of the response plan. This can include spaces.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for ResponsePlanSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponsePlanSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`ResponsePlanSummary`](crate::model::ResponsePlanSummary)
pub mod response_plan_summary {
    /// A builder for [`ResponsePlanSummary`](crate::model::ResponsePlanSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the response plan. This can't include spaces.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the response plan. This can't include spaces.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The human readable name of the response plan. This can include spaces.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The human readable name of the response plan. This can include spaces.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponsePlanSummary`](crate::model::ResponsePlanSummary)
        pub fn build(self) -> crate::model::ResponsePlanSummary {
            crate::model::ResponsePlanSummary {
                arn: self.arn,
                name: self.name,
                display_name: self.display_name,
            }
        }
    }
}
impl ResponsePlanSummary {
    /// Creates a new builder-style object to manufacture [`ResponsePlanSummary`](crate::model::ResponsePlanSummary)
    pub fn builder() -> crate::model::response_plan_summary::Builder {
        crate::model::response_plan_summary::Builder::default()
    }
}

/// <p>Details describing an incident record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncidentRecordSummary {
    /// <p>The Amazon Resource Name (ARN) of the incident.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The title of the incident. This value is either provided by the response plan or
    /// overwritten on creation.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The current status of the incident.</p>
    pub status: std::option::Option<crate::model::IncidentRecordStatus>,
    /// <p>Defines the impact to customers and applications.</p>
    pub impact: std::option::Option<i32>,
    /// <p>The time the incident was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the incident was resolved.</p>
    pub resolved_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>What caused Incident Manager to create the incident.</p>
    pub incident_record_source: std::option::Option<crate::model::IncidentRecordSource>,
}
impl IncidentRecordSummary {
    /// <p>The Amazon Resource Name (ARN) of the incident.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The title of the incident. This value is either provided by the response plan or
    /// overwritten on creation.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The current status of the incident.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::IncidentRecordStatus> {
        self.status.as_ref()
    }
    /// <p>Defines the impact to customers and applications.</p>
    pub fn impact(&self) -> std::option::Option<i32> {
        self.impact
    }
    /// <p>The time the incident was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time the incident was resolved.</p>
    pub fn resolved_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.resolved_time.as_ref()
    }
    /// <p>What caused Incident Manager to create the incident.</p>
    pub fn incident_record_source(
        &self,
    ) -> std::option::Option<&crate::model::IncidentRecordSource> {
        self.incident_record_source.as_ref()
    }
}
impl std::fmt::Debug for IncidentRecordSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncidentRecordSummary");
        formatter.field("arn", &self.arn);
        formatter.field("title", &self.title);
        formatter.field("status", &self.status);
        formatter.field("impact", &self.impact);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("resolved_time", &self.resolved_time);
        formatter.field("incident_record_source", &self.incident_record_source);
        formatter.finish()
    }
}
/// See [`IncidentRecordSummary`](crate::model::IncidentRecordSummary)
pub mod incident_record_summary {
    /// A builder for [`IncidentRecordSummary`](crate::model::IncidentRecordSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::IncidentRecordStatus>,
        pub(crate) impact: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) resolved_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) incident_record_source: std::option::Option<crate::model::IncidentRecordSource>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The title of the incident. This value is either provided by the response plan or
        /// overwritten on creation.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the incident. This value is either provided by the response plan or
        /// overwritten on creation.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The current status of the incident.</p>
        pub fn status(mut self, input: crate::model::IncidentRecordStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the incident.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IncidentRecordStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Defines the impact to customers and applications.</p>
        pub fn impact(mut self, input: i32) -> Self {
            self.impact = Some(input);
            self
        }
        /// <p>Defines the impact to customers and applications.</p>
        pub fn set_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.impact = input;
            self
        }
        /// <p>The time the incident was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the incident was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the incident was resolved.</p>
        pub fn resolved_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.resolved_time = Some(input);
            self
        }
        /// <p>The time the incident was resolved.</p>
        pub fn set_resolved_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.resolved_time = input;
            self
        }
        /// <p>What caused Incident Manager to create the incident.</p>
        pub fn incident_record_source(mut self, input: crate::model::IncidentRecordSource) -> Self {
            self.incident_record_source = Some(input);
            self
        }
        /// <p>What caused Incident Manager to create the incident.</p>
        pub fn set_incident_record_source(
            mut self,
            input: std::option::Option<crate::model::IncidentRecordSource>,
        ) -> Self {
            self.incident_record_source = input;
            self
        }
        /// Consumes the builder and constructs a [`IncidentRecordSummary`](crate::model::IncidentRecordSummary)
        pub fn build(self) -> crate::model::IncidentRecordSummary {
            crate::model::IncidentRecordSummary {
                arn: self.arn,
                title: self.title,
                status: self.status,
                impact: self.impact,
                creation_time: self.creation_time,
                resolved_time: self.resolved_time,
                incident_record_source: self.incident_record_source,
            }
        }
    }
}
impl IncidentRecordSummary {
    /// Creates a new builder-style object to manufacture [`IncidentRecordSummary`](crate::model::IncidentRecordSummary)
    pub fn builder() -> crate::model::incident_record_summary::Builder {
        crate::model::incident_record_summary::Builder::default()
    }
}

/// <p>Details about what created the incident record and when it was created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncidentRecordSource {
    /// <p>The principal that started the incident.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The principal the assumed the role specified of the <code>createdBy</code>.</p>
    pub invoked_by: std::option::Option<std::string::String>,
    /// <p>The resource that caused the incident to be created.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The service that started the incident. This can be manually created from Incident Manager,
    /// automatically created using an Amazon CloudWatch alarm, or Amazon EventBridge
    /// event.</p>
    pub source: std::option::Option<std::string::String>,
}
impl IncidentRecordSource {
    /// <p>The principal that started the incident.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The principal the assumed the role specified of the <code>createdBy</code>.</p>
    pub fn invoked_by(&self) -> std::option::Option<&str> {
        self.invoked_by.as_deref()
    }
    /// <p>The resource that caused the incident to be created.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The service that started the incident. This can be manually created from Incident Manager,
    /// automatically created using an Amazon CloudWatch alarm, or Amazon EventBridge
    /// event.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
}
impl std::fmt::Debug for IncidentRecordSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncidentRecordSource");
        formatter.field("created_by", &self.created_by);
        formatter.field("invoked_by", &self.invoked_by);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`IncidentRecordSource`](crate::model::IncidentRecordSource)
pub mod incident_record_source {
    /// A builder for [`IncidentRecordSource`](crate::model::IncidentRecordSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) invoked_by: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The principal that started the incident.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The principal that started the incident.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The principal the assumed the role specified of the <code>createdBy</code>.</p>
        pub fn invoked_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.invoked_by = Some(input.into());
            self
        }
        /// <p>The principal the assumed the role specified of the <code>createdBy</code>.</p>
        pub fn set_invoked_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invoked_by = input;
            self
        }
        /// <p>The resource that caused the incident to be created.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource that caused the incident to be created.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The service that started the incident. This can be manually created from Incident Manager,
        /// automatically created using an Amazon CloudWatch alarm, or Amazon EventBridge
        /// event.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The service that started the incident. This can be manually created from Incident Manager,
        /// automatically created using an Amazon CloudWatch alarm, or Amazon EventBridge
        /// event.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`IncidentRecordSource`](crate::model::IncidentRecordSource)
        pub fn build(self) -> crate::model::IncidentRecordSource {
            crate::model::IncidentRecordSource {
                created_by: self.created_by,
                invoked_by: self.invoked_by,
                resource_arn: self.resource_arn,
                source: self.source,
            }
        }
    }
}
impl IncidentRecordSource {
    /// Creates a new builder-style object to manufacture [`IncidentRecordSource`](crate::model::IncidentRecordSource)
    pub fn builder() -> crate::model::incident_record_source::Builder {
        crate::model::incident_record_source::Builder::default()
    }
}

/// <p>A significant event that happened during the incident. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimelineEvent {
    /// <p>The Amazon Resource Name (ARN) of the incident that the event occurred during.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the timeline event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The time that the event occurred.</p>
    pub event_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the timeline event was last updated.</p>
    pub event_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of event that occurred. Currently Incident Manager supports only the <code>Custom
    /// Event</code> type.</p>
    pub event_type: std::option::Option<std::string::String>,
    /// <p>A short description of the event.</p>
    pub event_data: std::option::Option<std::string::String>,
}
impl TimelineEvent {
    /// <p>The Amazon Resource Name (ARN) of the incident that the event occurred during.</p>
    pub fn incident_record_arn(&self) -> std::option::Option<&str> {
        self.incident_record_arn.as_deref()
    }
    /// <p>The ID of the timeline event.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>The time that the event occurred.</p>
    pub fn event_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_time.as_ref()
    }
    /// <p>The time that the timeline event was last updated.</p>
    pub fn event_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_updated_time.as_ref()
    }
    /// <p>The type of event that occurred. Currently Incident Manager supports only the <code>Custom
    /// Event</code> type.</p>
    pub fn event_type(&self) -> std::option::Option<&str> {
        self.event_type.as_deref()
    }
    /// <p>A short description of the event.</p>
    pub fn event_data(&self) -> std::option::Option<&str> {
        self.event_data.as_deref()
    }
}
impl std::fmt::Debug for TimelineEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimelineEvent");
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("event_id", &self.event_id);
        formatter.field("event_time", &self.event_time);
        formatter.field("event_updated_time", &self.event_updated_time);
        formatter.field("event_type", &self.event_type);
        formatter.field("event_data", &self.event_data);
        formatter.finish()
    }
}
/// See [`TimelineEvent`](crate::model::TimelineEvent)
pub mod timeline_event {
    /// A builder for [`TimelineEvent`](crate::model::TimelineEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_type: std::option::Option<std::string::String>,
        pub(crate) event_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident that the event occurred during.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that the event occurred during.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>The ID of the timeline event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the timeline event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>The time that the timeline event was last updated.</p>
        pub fn event_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_updated_time = Some(input);
            self
        }
        /// <p>The time that the timeline event was last updated.</p>
        pub fn set_event_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_updated_time = input;
            self
        }
        /// <p>The type of event that occurred. Currently Incident Manager supports only the <code>Custom
        /// Event</code> type.</p>
        pub fn event_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type = Some(input.into());
            self
        }
        /// <p>The type of event that occurred. Currently Incident Manager supports only the <code>Custom
        /// Event</code> type.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_type = input;
            self
        }
        /// <p>A short description of the event.</p>
        pub fn event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data = Some(input.into());
            self
        }
        /// <p>A short description of the event.</p>
        pub fn set_event_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_data = input;
            self
        }
        /// Consumes the builder and constructs a [`TimelineEvent`](crate::model::TimelineEvent)
        pub fn build(self) -> crate::model::TimelineEvent {
            crate::model::TimelineEvent {
                incident_record_arn: self.incident_record_arn,
                event_id: self.event_id,
                event_time: self.event_time,
                event_updated_time: self.event_updated_time,
                event_type: self.event_type,
                event_data: self.event_data,
            }
        }
    }
}
impl TimelineEvent {
    /// Creates a new builder-style object to manufacture [`TimelineEvent`](crate::model::TimelineEvent)
    pub fn builder() -> crate::model::timeline_event::Builder {
        crate::model::timeline_event::Builder::default()
    }
}

/// <p>Basic details used in creating a response plan. The response plan is then used to create an incident record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncidentTemplate {
    /// <p>The title of the incident. </p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The impact of the incident on your customers and applications. </p>
    pub impact: std::option::Option<i32>,
    /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
    /// currently happening, and context.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>Used to stop Incident Manager from creating multiple incident records for the same incident. </p>
    pub dedupe_string: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS targets that are notified when updates are made to an
    /// incident.</p>
    pub notification_targets:
        std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
}
impl IncidentTemplate {
    /// <p>The title of the incident. </p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The impact of the incident on your customers and applications. </p>
    pub fn impact(&self) -> std::option::Option<i32> {
        self.impact
    }
    /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
    /// currently happening, and context.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>Used to stop Incident Manager from creating multiple incident records for the same incident. </p>
    pub fn dedupe_string(&self) -> std::option::Option<&str> {
        self.dedupe_string.as_deref()
    }
    /// <p>The Amazon SNS targets that are notified when updates are made to an
    /// incident.</p>
    pub fn notification_targets(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationTargetItem]> {
        self.notification_targets.as_deref()
    }
}
impl std::fmt::Debug for IncidentTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncidentTemplate");
        formatter.field("title", &self.title);
        formatter.field("impact", &self.impact);
        formatter.field("summary", &self.summary);
        formatter.field("dedupe_string", &self.dedupe_string);
        formatter.field("notification_targets", &self.notification_targets);
        formatter.finish()
    }
}
/// See [`IncidentTemplate`](crate::model::IncidentTemplate)
pub mod incident_template {
    /// A builder for [`IncidentTemplate`](crate::model::IncidentTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) impact: std::option::Option<i32>,
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) dedupe_string: std::option::Option<std::string::String>,
        pub(crate) notification_targets:
            std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
    }
    impl Builder {
        /// <p>The title of the incident. </p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the incident. </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The impact of the incident on your customers and applications. </p>
        pub fn impact(mut self, input: i32) -> Self {
            self.impact = Some(input);
            self
        }
        /// <p>The impact of the incident on your customers and applications. </p>
        pub fn set_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.impact = input;
            self
        }
        /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
        /// currently happening, and context.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
        /// currently happening, and context.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>Used to stop Incident Manager from creating multiple incident records for the same incident. </p>
        pub fn dedupe_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.dedupe_string = Some(input.into());
            self
        }
        /// <p>Used to stop Incident Manager from creating multiple incident records for the same incident. </p>
        pub fn set_dedupe_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dedupe_string = input;
            self
        }
        /// Appends an item to `notification_targets`.
        ///
        /// To override the contents of this collection use [`set_notification_targets`](Self::set_notification_targets).
        ///
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        pub fn notification_targets(
            mut self,
            input: impl Into<crate::model::NotificationTargetItem>,
        ) -> Self {
            let mut v = self.notification_targets.unwrap_or_default();
            v.push(input.into());
            self.notification_targets = Some(v);
            self
        }
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        pub fn set_notification_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
        ) -> Self {
            self.notification_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`IncidentTemplate`](crate::model::IncidentTemplate)
        pub fn build(self) -> crate::model::IncidentTemplate {
            crate::model::IncidentTemplate {
                title: self.title,
                impact: self.impact,
                summary: self.summary,
                dedupe_string: self.dedupe_string,
                notification_targets: self.notification_targets,
            }
        }
    }
}
impl IncidentTemplate {
    /// Creates a new builder-style object to manufacture [`IncidentTemplate`](crate::model::IncidentTemplate)
    pub fn builder() -> crate::model::incident_template::Builder {
        crate::model::incident_template::Builder::default()
    }
}

/// <p>The resource policy that allows Incident Manager to perform actions on resources on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePolicy {
    /// <p>The JSON blob that describes the policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
    /// <p>The ID of the resource policy.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region that policy allows resources to be used in.</p>
    pub ram_resource_share_region: std::option::Option<std::string::String>,
}
impl ResourcePolicy {
    /// <p>The JSON blob that describes the policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
    /// <p>The ID of the resource policy.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The Amazon Web Services Region that policy allows resources to be used in.</p>
    pub fn ram_resource_share_region(&self) -> std::option::Option<&str> {
        self.ram_resource_share_region.as_deref()
    }
}
impl std::fmt::Debug for ResourcePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePolicy");
        formatter.field("policy_document", &self.policy_document);
        formatter.field("policy_id", &self.policy_id);
        formatter.field("ram_resource_share_region", &self.ram_resource_share_region);
        formatter.finish()
    }
}
/// See [`ResourcePolicy`](crate::model::ResourcePolicy)
pub mod resource_policy {
    /// A builder for [`ResourcePolicy`](crate::model::ResourcePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) ram_resource_share_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The JSON blob that describes the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON blob that describes the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>The ID of the resource policy.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource policy.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The Amazon Web Services Region that policy allows resources to be used in.</p>
        pub fn ram_resource_share_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.ram_resource_share_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region that policy allows resources to be used in.</p>
        pub fn set_ram_resource_share_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ram_resource_share_region = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePolicy`](crate::model::ResourcePolicy)
        pub fn build(self) -> crate::model::ResourcePolicy {
            crate::model::ResourcePolicy {
                policy_document: self.policy_document,
                policy_id: self.policy_id,
                ram_resource_share_region: self.ram_resource_share_region,
            }
        }
    }
}
impl ResourcePolicy {
    /// Creates a new builder-style object to manufacture [`ResourcePolicy`](crate::model::ResourcePolicy)
    pub fn builder() -> crate::model::resource_policy::Builder {
        crate::model::resource_policy::Builder::default()
    }
}

/// <p>The set of Amazon Web Services Region that your Incident Manager data will be replicated to
/// and the KMS key used to encrypt the data. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationSet {
    /// <p>The Amazon Resource Name (ARN) of the replication set.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The map between each Amazon Web Services Region in your replication set and the KMS key that's used to encrypt the data in that Region.</p>
    pub region_map: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RegionInfo>,
    >,
    /// <p>The status of the replication set. If the replication set is still pending, you can't
    /// use Incident Manager functionality.</p>
    pub status: std::option::Option<crate::model::ReplicationSetStatus>,
    /// <p>Determines if the replication set deletion protection is enabled or not. If deletion
    /// protection is enabled, you can't delete the last Amazon Web Services Region in the
    /// replication set. </p>
    pub deletion_protected: std::option::Option<bool>,
    /// <p>When the replication set was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Details about who created the replication set.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>When the replication set was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Who last modified the replication set.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
}
impl ReplicationSet {
    /// <p>The Amazon Resource Name (ARN) of the replication set.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The map between each Amazon Web Services Region in your replication set and the KMS key that's used to encrypt the data in that Region.</p>
    pub fn region_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RegionInfo>,
    > {
        self.region_map.as_ref()
    }
    /// <p>The status of the replication set. If the replication set is still pending, you can't
    /// use Incident Manager functionality.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReplicationSetStatus> {
        self.status.as_ref()
    }
    /// <p>Determines if the replication set deletion protection is enabled or not. If deletion
    /// protection is enabled, you can't delete the last Amazon Web Services Region in the
    /// replication set. </p>
    pub fn deletion_protected(&self) -> std::option::Option<bool> {
        self.deletion_protected
    }
    /// <p>When the replication set was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>Details about who created the replication set.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>When the replication set was last updated.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
    /// <p>Who last modified the replication set.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
}
impl std::fmt::Debug for ReplicationSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationSet");
        formatter.field("arn", &self.arn);
        formatter.field("region_map", &self.region_map);
        formatter.field("status", &self.status);
        formatter.field("deletion_protected", &self.deletion_protected);
        formatter.field("created_time", &self.created_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.finish()
    }
}
/// See [`ReplicationSet`](crate::model::ReplicationSet)
pub mod replication_set {
    /// A builder for [`ReplicationSet`](crate::model::ReplicationSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) region_map: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RegionInfo>,
        >,
        pub(crate) status: std::option::Option<crate::model::ReplicationSetStatus>,
        pub(crate) deletion_protected: std::option::Option<bool>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication set.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `region_map`.
        ///
        /// To override the contents of this collection use [`set_region_map`](Self::set_region_map).
        ///
        /// <p>The map between each Amazon Web Services Region in your replication set and the KMS key that's used to encrypt the data in that Region.</p>
        pub fn region_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RegionInfo>,
        ) -> Self {
            let mut hash_map = self.region_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.region_map = Some(hash_map);
            self
        }
        /// <p>The map between each Amazon Web Services Region in your replication set and the KMS key that's used to encrypt the data in that Region.</p>
        pub fn set_region_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RegionInfo>,
            >,
        ) -> Self {
            self.region_map = input;
            self
        }
        /// <p>The status of the replication set. If the replication set is still pending, you can't
        /// use Incident Manager functionality.</p>
        pub fn status(mut self, input: crate::model::ReplicationSetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the replication set. If the replication set is still pending, you can't
        /// use Incident Manager functionality.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReplicationSetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Determines if the replication set deletion protection is enabled or not. If deletion
        /// protection is enabled, you can't delete the last Amazon Web Services Region in the
        /// replication set. </p>
        pub fn deletion_protected(mut self, input: bool) -> Self {
            self.deletion_protected = Some(input);
            self
        }
        /// <p>Determines if the replication set deletion protection is enabled or not. If deletion
        /// protection is enabled, you can't delete the last Amazon Web Services Region in the
        /// replication set. </p>
        pub fn set_deletion_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protected = input;
            self
        }
        /// <p>When the replication set was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the replication set was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Details about who created the replication set.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>Details about who created the replication set.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>When the replication set was last updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>When the replication set was last updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Who last modified the replication set.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>Who last modified the replication set.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationSet`](crate::model::ReplicationSet)
        pub fn build(self) -> crate::model::ReplicationSet {
            crate::model::ReplicationSet {
                arn: self.arn,
                region_map: self.region_map,
                status: self.status,
                deletion_protected: self.deletion_protected,
                created_time: self.created_time,
                created_by: self.created_by,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
            }
        }
    }
}
impl ReplicationSet {
    /// Creates a new builder-style object to manufacture [`ReplicationSet`](crate::model::ReplicationSet)
    pub fn builder() -> crate::model::replication_set::Builder {
        crate::model::replication_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationSetStatus {
    /// All operations have completed successfully and the replication set is ready to use
    Active,
    /// Replication set is in the process of being created.
    Creating,
    /// Replication set is in the process of being deleted.
    Deleting,
    /// Replication set is not healthy and we cannot fix it.
    Failed,
    /// Replication set is in the process of being updated.
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationSetStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReplicationSetStatus::Active,
            "CREATING" => ReplicationSetStatus::Creating,
            "DELETING" => ReplicationSetStatus::Deleting,
            "FAILED" => ReplicationSetStatus::Failed,
            "UPDATING" => ReplicationSetStatus::Updating,
            other => ReplicationSetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationSetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationSetStatus::from(s))
    }
}
impl ReplicationSetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationSetStatus::Active => "ACTIVE",
            ReplicationSetStatus::Creating => "CREATING",
            ReplicationSetStatus::Deleting => "DELETING",
            ReplicationSetStatus::Failed => "FAILED",
            ReplicationSetStatus::Updating => "UPDATING",
            ReplicationSetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for ReplicationSetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Amazon Web Services Region in your replication set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionInfo {
    /// <p>The ID of the KMS key used to encrypt the data in this Amazon Web Services Region.</p>
    pub sse_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon Web Services Region in the replication set.</p>
    pub status: std::option::Option<crate::model::RegionStatus>,
    /// <p>Information displayed about the status of the Amazon Web Services Region.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The most recent date and time that Incident Manager updated the Amazon Web Services Region's status.</p>
    pub status_update_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl RegionInfo {
    /// <p>The ID of the KMS key used to encrypt the data in this Amazon Web Services Region.</p>
    pub fn sse_kms_key_id(&self) -> std::option::Option<&str> {
        self.sse_kms_key_id.as_deref()
    }
    /// <p>The status of the Amazon Web Services Region in the replication set.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RegionStatus> {
        self.status.as_ref()
    }
    /// <p>Information displayed about the status of the Amazon Web Services Region.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The most recent date and time that Incident Manager updated the Amazon Web Services Region's status.</p>
    pub fn status_update_date_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.status_update_date_time.as_ref()
    }
}
impl std::fmt::Debug for RegionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionInfo");
        formatter.field("sse_kms_key_id", &self.sse_kms_key_id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("status_update_date_time", &self.status_update_date_time);
        formatter.finish()
    }
}
/// See [`RegionInfo`](crate::model::RegionInfo)
pub mod region_info {
    /// A builder for [`RegionInfo`](crate::model::RegionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sse_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RegionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) status_update_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the KMS key used to encrypt the data in this Amazon Web Services Region.</p>
        pub fn sse_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the data in this Amazon Web Services Region.</p>
        pub fn set_sse_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_kms_key_id = input;
            self
        }
        /// <p>The status of the Amazon Web Services Region in the replication set.</p>
        pub fn status(mut self, input: crate::model::RegionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the Amazon Web Services Region in the replication set.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Information displayed about the status of the Amazon Web Services Region.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Information displayed about the status of the Amazon Web Services Region.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The most recent date and time that Incident Manager updated the Amazon Web Services Region's status.</p>
        pub fn status_update_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.status_update_date_time = Some(input);
            self
        }
        /// <p>The most recent date and time that Incident Manager updated the Amazon Web Services Region's status.</p>
        pub fn set_status_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.status_update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionInfo`](crate::model::RegionInfo)
        pub fn build(self) -> crate::model::RegionInfo {
            crate::model::RegionInfo {
                sse_kms_key_id: self.sse_kms_key_id,
                status: self.status,
                status_message: self.status_message,
                status_update_date_time: self.status_update_date_time,
            }
        }
    }
}
impl RegionInfo {
    /// Creates a new builder-style object to manufacture [`RegionInfo`](crate::model::RegionInfo)
    pub fn builder() -> crate::model::region_info::Builder {
        crate::model::region_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegionStatus {
    /// All operations have completed successfully and the region is ready to use
    Active,
    /// The region is in the process of being created.
    Creating,
    /// The region is in the process of being deleted.
    Deleting,
    /// The region is not healthy and we cannot automatically fix it.
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RegionStatus::Active,
            "CREATING" => RegionStatus::Creating,
            "DELETING" => RegionStatus::Deleting,
            "FAILED" => RegionStatus::Failed,
            other => RegionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegionStatus::from(s))
    }
}
impl RegionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegionStatus::Active => "ACTIVE",
            RegionStatus::Creating => "CREATING",
            RegionStatus::Deleting => "DELETING",
            RegionStatus::Failed => "FAILED",
            RegionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED"]
    }
}
impl AsRef<str> for RegionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The record of the incident that's created when an incident occurs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncidentRecord {
    /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The title of the incident.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
    /// currently happening, and context of the incident.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>The current status of the incident.</p>
    pub status: std::option::Option<crate::model::IncidentRecordStatus>,
    /// <p>The impact of the incident on customers and applications.</p>
    pub impact: std::option::Option<i32>,
    /// <p>The time that Incident Manager created the incident record.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the incident was resolved. This appears as a timeline event.</p>
    pub resolved_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the incident was most recently modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Who modified the incident most recently.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The runbook, or automation document, that's run at the beginning of the incident.</p>
    pub automation_executions:
        std::option::Option<std::vec::Vec<crate::model::AutomationExecution>>,
    /// <p>Details about the action that started the incident.</p>
    pub incident_record_source: std::option::Option<crate::model::IncidentRecordSource>,
    /// <p>The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.</p>
    pub dedupe_string: std::option::Option<std::string::String>,
    /// <p>The chat channel used for collaboration during an incident.</p>
    pub chat_channel: std::option::Option<crate::model::ChatChannel>,
    /// <p>The Amazon SNS targets that are notified when updates are made to an
    /// incident.</p>
    pub notification_targets:
        std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
}
impl IncidentRecord {
    /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The title of the incident.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
    /// currently happening, and context of the incident.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>The current status of the incident.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::IncidentRecordStatus> {
        self.status.as_ref()
    }
    /// <p>The impact of the incident on customers and applications.</p>
    pub fn impact(&self) -> std::option::Option<i32> {
        self.impact
    }
    /// <p>The time that Incident Manager created the incident record.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time at which the incident was resolved. This appears as a timeline event.</p>
    pub fn resolved_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.resolved_time.as_ref()
    }
    /// <p>The time at which the incident was most recently modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
    /// <p>Who modified the incident most recently.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The runbook, or automation document, that's run at the beginning of the incident.</p>
    pub fn automation_executions(
        &self,
    ) -> std::option::Option<&[crate::model::AutomationExecution]> {
        self.automation_executions.as_deref()
    }
    /// <p>Details about the action that started the incident.</p>
    pub fn incident_record_source(
        &self,
    ) -> std::option::Option<&crate::model::IncidentRecordSource> {
        self.incident_record_source.as_ref()
    }
    /// <p>The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.</p>
    pub fn dedupe_string(&self) -> std::option::Option<&str> {
        self.dedupe_string.as_deref()
    }
    /// <p>The chat channel used for collaboration during an incident.</p>
    pub fn chat_channel(&self) -> std::option::Option<&crate::model::ChatChannel> {
        self.chat_channel.as_ref()
    }
    /// <p>The Amazon SNS targets that are notified when updates are made to an
    /// incident.</p>
    pub fn notification_targets(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationTargetItem]> {
        self.notification_targets.as_deref()
    }
}
impl std::fmt::Debug for IncidentRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncidentRecord");
        formatter.field("arn", &self.arn);
        formatter.field("title", &self.title);
        formatter.field("summary", &self.summary);
        formatter.field("status", &self.status);
        formatter.field("impact", &self.impact);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("resolved_time", &self.resolved_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("automation_executions", &self.automation_executions);
        formatter.field("incident_record_source", &self.incident_record_source);
        formatter.field("dedupe_string", &self.dedupe_string);
        formatter.field("chat_channel", &self.chat_channel);
        formatter.field("notification_targets", &self.notification_targets);
        formatter.finish()
    }
}
/// See [`IncidentRecord`](crate::model::IncidentRecord)
pub mod incident_record {
    /// A builder for [`IncidentRecord`](crate::model::IncidentRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::IncidentRecordStatus>,
        pub(crate) impact: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) resolved_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) automation_executions:
            std::option::Option<std::vec::Vec<crate::model::AutomationExecution>>,
        pub(crate) incident_record_source: std::option::Option<crate::model::IncidentRecordSource>,
        pub(crate) dedupe_string: std::option::Option<std::string::String>,
        pub(crate) chat_channel: std::option::Option<crate::model::ChatChannel>,
        pub(crate) notification_targets:
            std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The title of the incident.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the incident.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
        /// currently happening, and context of the incident.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>The summary of the incident. The summary is a brief synopsis of what occurred, what's
        /// currently happening, and context of the incident.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>The current status of the incident.</p>
        pub fn status(mut self, input: crate::model::IncidentRecordStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the incident.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IncidentRecordStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The impact of the incident on customers and applications.</p>
        pub fn impact(mut self, input: i32) -> Self {
            self.impact = Some(input);
            self
        }
        /// <p>The impact of the incident on customers and applications.</p>
        pub fn set_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.impact = input;
            self
        }
        /// <p>The time that Incident Manager created the incident record.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that Incident Manager created the incident record.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time at which the incident was resolved. This appears as a timeline event.</p>
        pub fn resolved_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.resolved_time = Some(input);
            self
        }
        /// <p>The time at which the incident was resolved. This appears as a timeline event.</p>
        pub fn set_resolved_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.resolved_time = input;
            self
        }
        /// <p>The time at which the incident was most recently modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time at which the incident was most recently modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Who modified the incident most recently.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>Who modified the incident most recently.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Appends an item to `automation_executions`.
        ///
        /// To override the contents of this collection use [`set_automation_executions`](Self::set_automation_executions).
        ///
        /// <p>The runbook, or automation document, that's run at the beginning of the incident.</p>
        pub fn automation_executions(
            mut self,
            input: impl Into<crate::model::AutomationExecution>,
        ) -> Self {
            let mut v = self.automation_executions.unwrap_or_default();
            v.push(input.into());
            self.automation_executions = Some(v);
            self
        }
        /// <p>The runbook, or automation document, that's run at the beginning of the incident.</p>
        pub fn set_automation_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomationExecution>>,
        ) -> Self {
            self.automation_executions = input;
            self
        }
        /// <p>Details about the action that started the incident.</p>
        pub fn incident_record_source(mut self, input: crate::model::IncidentRecordSource) -> Self {
            self.incident_record_source = Some(input);
            self
        }
        /// <p>Details about the action that started the incident.</p>
        pub fn set_incident_record_source(
            mut self,
            input: std::option::Option<crate::model::IncidentRecordSource>,
        ) -> Self {
            self.incident_record_source = input;
            self
        }
        /// <p>The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.</p>
        pub fn dedupe_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.dedupe_string = Some(input.into());
            self
        }
        /// <p>The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.</p>
        pub fn set_dedupe_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dedupe_string = input;
            self
        }
        /// <p>The chat channel used for collaboration during an incident.</p>
        pub fn chat_channel(mut self, input: crate::model::ChatChannel) -> Self {
            self.chat_channel = Some(input);
            self
        }
        /// <p>The chat channel used for collaboration during an incident.</p>
        pub fn set_chat_channel(
            mut self,
            input: std::option::Option<crate::model::ChatChannel>,
        ) -> Self {
            self.chat_channel = input;
            self
        }
        /// Appends an item to `notification_targets`.
        ///
        /// To override the contents of this collection use [`set_notification_targets`](Self::set_notification_targets).
        ///
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        pub fn notification_targets(
            mut self,
            input: impl Into<crate::model::NotificationTargetItem>,
        ) -> Self {
            let mut v = self.notification_targets.unwrap_or_default();
            v.push(input.into());
            self.notification_targets = Some(v);
            self
        }
        /// <p>The Amazon SNS targets that are notified when updates are made to an
        /// incident.</p>
        pub fn set_notification_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
        ) -> Self {
            self.notification_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`IncidentRecord`](crate::model::IncidentRecord)
        pub fn build(self) -> crate::model::IncidentRecord {
            crate::model::IncidentRecord {
                arn: self.arn,
                title: self.title,
                summary: self.summary,
                status: self.status,
                impact: self.impact,
                creation_time: self.creation_time,
                resolved_time: self.resolved_time,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
                automation_executions: self.automation_executions,
                incident_record_source: self.incident_record_source,
                dedupe_string: self.dedupe_string,
                chat_channel: self.chat_channel,
                notification_targets: self.notification_targets,
            }
        }
    }
}
impl IncidentRecord {
    /// Creates a new builder-style object to manufacture [`IncidentRecord`](crate::model::IncidentRecord)
    pub fn builder() -> crate::model::incident_record::Builder {
        crate::model::incident_record::Builder::default()
    }
}

/// <p>The Systems Manager automation document process to start as the runbook at the
/// beginning of the incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AutomationExecution {
    /// <p>The Amazon Resource Name (ARN) of the automation process.</p>
    SsmExecutionArn(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AutomationExecution {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`SsmExecutionArn`](crate::model::AutomationExecution::SsmExecutionArn), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ssm_execution_arn(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AutomationExecution::SsmExecutionArn(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SsmExecutionArn`](crate::model::AutomationExecution::SsmExecutionArn).
    pub fn is_ssm_execution_arn(&self) -> bool {
        self.as_ssm_execution_arn().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>The mapping between a Amazon Web Services Region and the key that's used to encrypt the
/// data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionMapInputValue {
    /// <p>The KMS key used to encrypt the data in your replication set.</p>
    pub sse_kms_key_id: std::option::Option<std::string::String>,
}
impl RegionMapInputValue {
    /// <p>The KMS key used to encrypt the data in your replication set.</p>
    pub fn sse_kms_key_id(&self) -> std::option::Option<&str> {
        self.sse_kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for RegionMapInputValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionMapInputValue");
        formatter.field("sse_kms_key_id", &self.sse_kms_key_id);
        formatter.finish()
    }
}
/// See [`RegionMapInputValue`](crate::model::RegionMapInputValue)
pub mod region_map_input_value {
    /// A builder for [`RegionMapInputValue`](crate::model::RegionMapInputValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sse_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The KMS key used to encrypt the data in your replication set.</p>
        pub fn sse_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key used to encrypt the data in your replication set.</p>
        pub fn set_sse_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionMapInputValue`](crate::model::RegionMapInputValue)
        pub fn build(self) -> crate::model::RegionMapInputValue {
            crate::model::RegionMapInputValue {
                sse_kms_key_id: self.sse_kms_key_id,
            }
        }
    }
}
impl RegionMapInputValue {
    /// Creates a new builder-style object to manufacture [`RegionMapInputValue`](crate::model::RegionMapInputValue)
    pub fn builder() -> crate::model::region_map_input_value::Builder {
        crate::model::region_map_input_value::Builder::default()
    }
}
